/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.ir2tree;

import fr.inria.tapenade.ir2tree.DeclStruct;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeDecl;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.Tree;

final class TypeDeclStruct
extends DeclStruct {
    private final TypeDecl typeDecl;

    protected TypeDeclStruct(TypeDecl typeDecl) {
        this.typeDecl = typeDecl;
        this.usedNames = typeDecl.dependsOn();
        this.kind = 1;
        this.symbolDecl = typeDecl;
        this.alphabeticalIdent = typeDecl.symbol;
    }

    protected TypeDecl typeDecl() {
        return this.typeDecl;
    }

    @Override
    protected Tree generateTree(TapList<SymbolDecl> declaredTypes, SymbolTable symbolTable) {
        Tree result = null;
        if (this.typeDecl.isATrueSymbolDecl) {
            Tree genTree;
            TypeSpec declaredTypeValue = this.typeDecl.typeSpec;
            while (declaredTypeValue instanceof WrapperTypeSpec) {
                declaredTypeValue = declaredTypeValue.wrappedType;
            }
            if (declaredTypeValue == null) {
                TapEnv.toolWarning(-1, "(Type declaration regeneration) null type");
                genTree = ILUtils.build(94, "UnknownType");
            } else {
                genTree = ((TypeSpec)declaredTypeValue).generateTree(symbolTable, this.typeDecl.dependsOn, declaredTypes, false, null);
            }
            if (this.isEmptyName(this.typeDecl, genTree)) {
                result = ILUtils.build(187, ILUtils.build(136), genTree);
            } else {
                if (genTree.parent() != null) {
                    genTree = ILUtils.copy(genTree);
                }
                result = ILUtils.build(187, ILUtils.build(94, this.typeDecl.symbol), genTree);
                if (genTree.opCode() == 156 && genTree.down(1).opCode() == 136) {
                    genTree.setChild(ILUtils.build(94, this.typeDecl.symbol), 1);
                }
            }
            if (this.typeDecl.extraInfo() != null) {
                Tree accessDecl = ILUtils.build(1, ILUtils.build(94, (String)this.typeDecl.extraInfo().head), ILUtils.build(70, ILUtils.build(94, this.typeDecl.symbol)));
                result = ILUtils.build(52, accessDecl, result);
            }
            if (TypeSpec.isA(this.typeDecl.typeSpec, 11) && genTree.opCode() == 94 && this.typeDecl.symbol.equals(genTree.stringValue())) {
                result = null;
            }
        }
        return result;
    }

    private boolean isEmptyName(TypeDecl typeDecl, Tree genTree) {
        String operatorName = genTree.opName();
        boolean result = typeDecl.symbol.startsWith(operatorName + "_");
        return result;
    }

    @Override
    public String toString() {
        return "declaration of type " + this.typeDecl.symbol + ':' + this.typeDecl.typeSpec;
    }
}

