/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.prettyprint;

import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public abstract class Printer {
    private final OutputStreamWriter toFile;

    protected Printer(String toFileName) throws IOException {
        File file = new File(toFileName);
        if (file.exists() && !file.renameTo(new File(toFileName + "~"))) {
            TapEnv.toolWarning(-1, "Cannot rename " + toFileName + "~");
        }
        this.toFile = new FileWriter(toFileName);
    }

    protected Printer(OutputStream p) {
        this.toFile = new OutputStreamWriter(p);
    }

    public void initFile(int language) {
    }

    public void closeFile() {
        try {
            this.toFile.flush();
            this.toFile.close();
        }
        catch (IOException e) {
            TapEnv.systemError("(Decompiler) I-O error " + e.getMessage() + " while closing output file " + this.toFile);
        }
    }

    public abstract void space(int var1) throws IOException;

    public abstract void newLine() throws IOException;

    public abstract void printText(String var1, String var2) throws IOException;

    public boolean hasAnchors() {
        return false;
    }

    public void setTargetNameAndZone(String name, String zone) {
    }

    public void resetTargetNameAndZone() {
    }

    public void defineAnchor(String ref) {
    }

    public void startAnchorRef(String ref) {
    }

    public void endAnchorRef() {
    }

    public void messageRef(TapList<String> msgTty, boolean showMsg, int language) throws IOException {
    }

    protected OutputStreamWriter toFile() {
        return this.toFile;
    }
}

