/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.prettyprint;

import fr.inria.tapenade.prettyprint.Printer;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import java.io.IOException;
import java.io.OutputStream;

public final class TextPrinter
extends Printer {
    public TextPrinter(String toFileName) throws IOException {
        super(toFileName);
    }

    public TextPrinter(OutputStream s) {
        super(s);
    }

    @Override
    public void space(int nbSpaces) throws IOException {
        for (int i = nbSpaces; i > 0; --i) {
            this.toFile().write(" ");
        }
    }

    @Override
    public void newLine() throws IOException {
        this.toFile().write(System.lineSeparator());
    }

    @Override
    public void printText(String text, String kind) throws IOException {
        this.toFile().write(text);
    }

    @Override
    public void messageRef(TapList<String> msgTty, boolean showMsg, int language) throws IOException {
        if (showMsg) {
            while (msgTty != null) {
                this.toFile().write(TapEnv.commentStart(language) + " TAPENADE: " + (String)msgTty.head);
                if (msgTty.tail != null) {
                    this.newLine();
                }
                msgTty = msgTty.tail;
            }
        }
    }
}

