/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.Tree;

public final class AlignmentBoundary {
    public int offset;
    public boolean infiniteOffset;
    public TapList<VariableDecl> endVars;
    public Tree accessTree;
    protected WrapperTypeSpec accessType;
    public WrapperTypeSpec type;
    protected TapList zones;
    private TapList<TapTriplet<VariableDecl, SymbolTable, Tree>> startVars;
    private VariableDecl commonVariableDecl;
    private boolean active;

    protected AlignmentBoundary(int offset) {
        this.offset = offset;
    }

    public AlignmentBoundary(int offset, boolean infiniteOffset, WrapperTypeSpec typeSpec) {
        this.offset = offset;
        this.infiniteOffset = infiniteOffset;
        this.type = typeSpec;
    }

    protected static boolean lt(int offset1, boolean infiniteOffset1, int offset2, boolean infiniteOffset2) {
        return !infiniteOffset1 && (infiniteOffset2 || offset1 < offset2);
    }

    protected static boolean le(int offset1, boolean infiniteOffset1, int offset2, boolean infiniteOffset2) {
        if (infiniteOffset1) {
            return infiniteOffset2;
        }
        return infiniteOffset2 || offset1 <= offset2;
    }

    public TapList<TapTriplet<VariableDecl, SymbolTable, Tree>> getStartVars() {
        return this.startVars;
    }

    public void setStartVars(TapList<TapTriplet<VariableDecl, SymbolTable, Tree>> stVars) {
        this.startVars = stVars;
    }

    public TapList<VariableDecl> startVars() {
        TapList result = null;
        TapList<TapTriplet<VariableDecl, SymbolTable, Tree>> stV = this.startVars;
        while (stV != null) {
            result = TapList.addLast(result, ((TapTriplet)stV.head).first);
            stV = stV.tail;
        }
        return result;
    }

    public void setCommonVariableDecl(VariableDecl variableDecl) {
        this.commonVariableDecl = variableDecl;
    }

    public VariableDecl commonVariableDecl() {
        return this.commonVariableDecl;
    }

    public void setActive() {
        this.active = true;
    }

    public boolean active() {
        return this.active;
    }

    public void addStartVar(VariableDecl variableDecl, SymbolTable fromSymbolTable, Tree accessTree) {
        this.startVars = new TapList<TapTriplet<VariableDecl, SymbolTable, Tree>>(new TapTriplet<VariableDecl, SymbolTable, Tree>(variableDecl, fromSymbolTable, accessTree), this.startVars);
    }

    public void addEndVar(VariableDecl variableDecl) {
        this.endVars = new TapList<VariableDecl>(variableDecl, this.endVars);
    }

    public String toString() {
        return "AlignmentBoundary:" + this.offset + " " + this.infiniteOffset + " " + this.startVars + " " + this.endVars + " " + this.type;
    }
}

