/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ClassDecl;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeDecl;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public class ArrayDim {
    private Tree tree;
    protected Integer lower;
    protected Integer upper;
    protected Tree refArrayTree;
    protected int refNDims;
    protected int rankInRef;
    protected int refQuality;

    public Tree tree() {
        return this.tree;
    }

    protected void setTree(Tree tree) {
        this.tree = tree;
    }

    public ArrayDim(Tree valueTree, Integer lower, Integer upper, Tree refArrayTree, int rankInRef, int refNDims, int refQuality) {
        this.refArrayTree = refArrayTree;
        this.rankInRef = rankInRef;
        this.refNDims = refNDims;
        int n = this.refQuality = refArrayTree == null ? 0 : refQuality;
        if (valueTree == null) {
            Tree lowerTree = lower == null ? ILUtils.build(136) : ILUtils.build(101, lower);
            Tree upperTree = upper == null ? ILUtils.build(136) : ILUtils.build(101, upper);
            this.tree = ILUtils.build(58, lowerTree, upperTree);
        } else {
            this.tree = valueTree;
        }
        this.lower = lower;
        this.upper = upper;
    }

    private static boolean equalBound(Tree bLeft, Tree bRight, int comparison) {
        boolean result;
        if (TapEnv.traceTypeCheckAnalysis()) {
            TapEnv.indentOnTrace(TapEnv.traceIndent());
            for (int i = TypeSpec.compare_debug_indent; i > 0; --i) {
                TapEnv.printOnTrace("| ");
            }
            TapEnv.printlnOnTrace("Bound equal " + bLeft + " " + TypeSpec.showComparison(comparison) + " " + bRight);
            ++TypeSpec.compare_debug_indent;
        }
        if (TypeSpec.testTypesLitteral(comparison)) {
            result = !ILUtils.isNullOrNone(bLeft) && !ILUtils.isNullOrNone(bRight) && bLeft.equalsTree(bRight);
        } else {
            if (ILUtils.isNullOrNone(bLeft) || !ILUtils.isNullOrNone(bRight)) {
                // empty if block
            }
            result = true;
        }
        if (TapEnv.traceTypeCheckAnalysis()) {
            TapEnv.indentOnTrace(TapEnv.traceIndent());
            for (int i = --TypeSpec.compare_debug_indent; i > 0; --i) {
                TapEnv.printOnTrace("| ");
            }
            TapEnv.printlnOnTrace("Bound equal " + bLeft + " " + TypeSpec.showComparison(comparison) + " " + bRight + " RETURNS:" + result);
        }
        return result;
    }

    protected static ArrayDim preciseDimension(ArrayDim mainDim, ArrayDim complementDim, SymbolTable symbolTable) {
        if (complementDim == null) {
            return mainDim;
        }
        if (mainDim.lower != null && mainDim.upper != null) {
            return mainDim;
        }
        Integer complementLower = complementDim.lower;
        Integer complementUpper = complementDim.upper;
        if (complementDim.tree != null && complementDim.tree.opCode() != 11) {
            Tree upperComplementDimTree;
            Tree lowerComplementDimTree;
            if (complementDim.tree.opCode() == 58) {
                lowerComplementDimTree = complementDim.tree.down(1);
                upperComplementDimTree = complementDim.tree.down(2);
            } else {
                lowerComplementDimTree = null;
                upperComplementDimTree = complementDim.tree;
            }
            if (complementLower == null) {
                complementLower = lowerComplementDimTree == null || lowerComplementDimTree.opCode() == 136 ? Integer.valueOf(1) : symbolTable.computeIntConstant(lowerComplementDimTree);
            }
            if (complementUpper == null && upperComplementDimTree != null && upperComplementDimTree.opCode() != 136) {
                complementUpper = symbolTable.computeIntConstant(upperComplementDimTree);
            }
            if (complementLower != null && complementUpper != null) {
                return new ArrayDim(complementDim.tree, complementLower, complementUpper, mainDim.refArrayTree, mainDim.rankInRef, mainDim.refNDims, mainDim.refQuality);
            }
        }
        return mainDim;
    }

    protected static ArrayDim testConformingAndChoose(ArrayDim dim1, ArrayDim dim2) {
        int size2;
        int size1 = dim1 == null ? -1 : dim1.size();
        int n = size2 = dim2 == null ? -1 : dim2.size();
        if (size1 != size2 && size1 != -1 && size2 != -1) {
            return null;
        }
        if (dim2 == null || dim2.refQuality == 0 || size1 != -1) {
            return dim1;
        }
        if (dim1 == null || dim1.refQuality == 0 || size2 != -1) {
            return dim2;
        }
        if (dim1.betterThanCallSize()) {
            return dim1;
        }
        if (dim2.betterThanCallSize()) {
            return dim2;
        }
        if (dim1.refQuality > dim2.refQuality) {
            return dim1;
        }
        if (dim1.refQuality == dim2.refQuality) {
            String name1 = ILUtils.baseName(dim1.refArrayTree);
            String name2 = ILUtils.baseName(dim2.refArrayTree);
            if (name1 != null && (name2 == null || name1.compareTo(name2) <= 0)) {
                return dim1;
            }
            return dim2;
        }
        return dim2;
    }

    private boolean betterThanCallSize() {
        Tree sizeTree = this.tree;
        if (sizeTree != null && sizeTree.opCode() == 58) {
            sizeTree = ILUtils.isNullOrNone(sizeTree.down(1)) || ILUtils.isIntCst(sizeTree.down(1), 1) ? sizeTree.down(2) : null;
        }
        return !ILUtils.isNullOrNone(sizeTree);
    }

    protected ArrayDim copy() {
        return new ArrayDim(this.tree.copy(), this.lower, this.upper, this.refArrayTree, this.rankInRef, this.refNDims, this.refQuality);
    }

    protected void erasePrivateInfo(Unit publishedUnit) {
        if (publishedUnit != null) {
            SymbolTable unitPublicSymbolTable;
            TapList<Object> toUsedSymbols = new TapList<Object>(null, null);
            SymbolTable unitPrivateSymbolTable = publishedUnit.privateSymbolTable();
            if (unitPrivateSymbolTable != null) {
                SymbolDecl.addUsedSymbolsInExpr(this.tree, toUsedSymbols, unitPrivateSymbolTable, null, true, true);
            }
            if ((unitPublicSymbolTable = publishedUnit.publicSymbolTable()) != null) {
                SymbolDecl.addUsedSymbolsInExpr(this.tree, toUsedSymbols, unitPublicSymbolTable, null, true, true);
            }
            TapList<Object> inUsedSymbols = toUsedSymbols;
            while (inUsedSymbols.tail != null) {
                if (inUsedSymbols.tail.head == null || inUsedSymbols.tail.head instanceof FunctionDecl || inUsedSymbols.tail.head instanceof TypeDecl || inUsedSymbols.tail.head instanceof ClassDecl) {
                    inUsedSymbols.tail = inUsedSymbols.tail.tail;
                    continue;
                }
                inUsedSymbols = inUsedSymbols.tail;
            }
            if (toUsedSymbols.tail != null) {
                this.tree = ILUtils.build(58, ILUtils.build(136), ILUtils.build(136));
            }
        }
        this.refArrayTree = null;
        this.rankInRef = -1;
        this.refNDims = 0;
        this.refQuality = 0;
    }

    protected boolean isSufficientlyDefined() {
        return this.lower != null && this.upper != null || !ILUtils.isNullOrNone(this.tree) && ArrayDim.isDynamicallyExplicit(this.tree);
    }

    private static boolean isDynamicallyExplicit(Tree dimTree) {
        if (dimTree.opCode() == 58) {
            return !ILUtils.isNullOrNoneOrStar(dimTree.down(2));
        }
        if (dimTree.opCode() == 11) {
            return !ILUtils.isNullOrNoneOrStar(dimTree.down(2));
        }
        return !ILUtils.isNullOrNoneOrStar(dimTree);
    }

    protected boolean isUnknown() {
        return (ILUtils.isNullOrNone(this.tree) || this.tree.opCode() == 58 && ILUtils.isNullOrNone(this.tree.down(1)) && ILUtils.isNullOrNone(this.tree.down(2))) && this.upper == null && (this.lower == null || this.lower == 1);
    }

    protected boolean isNone() {
        boolean result = false;
        if (this.tree != null) {
            Tree upperDimTree = this.tree.opCode() == 58 ? this.tree.down(2) : this.tree;
            result = upperDimTree.opCode() == 136;
        }
        return result;
    }

    public int size() {
        if (this.lower != null && this.upper != null) {
            return this.upper + 1 - this.lower;
        }
        return -1;
    }

    protected ArrayDim weakenForInference() {
        return new ArrayDim(null, null, null, null, -1, 0, 0);
    }

    protected boolean equalLength(ArrayDim otherDim, int comparison) {
        boolean areEqual;
        if (TapEnv.traceTypeCheckAnalysis()) {
            TapEnv.indentOnTrace(TapEnv.traceIndent());
            for (int i = TypeSpec.compare_debug_indent; i > 0; --i) {
                TapEnv.printOnTrace("| ");
            }
            TapEnv.printlnOnTrace("Dimension equalLength " + this + " " + TypeSpec.showComparison(comparison) + " " + otherDim);
            ++TypeSpec.compare_debug_indent;
        }
        boolean bl = areEqual = otherDim != null;
        if (areEqual) {
            areEqual = this.lower != null && this.upper != null && otherDim.lower != null && otherDim.upper != null ? this.upper - this.lower == otherDim.upper - otherDim.lower : (this.refQuality > 0 && this.refQuality == otherDim.refQuality && this.refArrayTree != null && otherDim.refArrayTree != null && this.rankInRef == otherDim.rankInRef && this.refArrayTree.equalsTree(otherDim.refArrayTree) ? true : (this.tree != null && otherDim.tree != null ? ArrayDim.equalBound(this.tree.down(1), otherDim.tree.down(1), comparison) && ArrayDim.equalBound(this.tree.down(2), otherDim.tree.down(2), comparison) : false));
        }
        if (TapEnv.traceTypeCheckAnalysis()) {
            TapEnv.indentOnTrace(TapEnv.traceIndent());
            for (int i = --TypeSpec.compare_debug_indent; i > 0; --i) {
                TapEnv.printOnTrace("| ");
            }
            TapEnv.printlnOnTrace("Dimension equalLength " + this + " " + TypeSpec.showComparison(comparison) + " " + otherDim + " RETURNS:" + areEqual);
        }
        return areEqual;
    }

    public Tree getSize() {
        if (this.tree.down(1).opCode() == 136 || ILUtils.evalsToOne(this.tree.down(1))) {
            return this.tree.down(2).copy();
        }
        return ILUtils.build(177, this.tree.down(2).copy(), ILUtils.buildSmartAddSub(this.tree.down(1).copy(), 1, ILUtils.build(101, -1)));
    }

    protected void setSize(Tree sizeTree) {
        Tree lowerTree = this.tree.down(1).opCode() == 136 ? ILUtils.build(101, 1) : this.tree.down(1).copy();
        this.tree.setChild(ILUtils.buildSmartAddSub(sizeTree, 1, ILUtils.buildSmartAddSub(lowerTree, 1, ILUtils.build(101, -1))), 2);
    }

    protected Tree lowerTree() {
        if (this.lower != null) {
            return ILUtils.build(101, this.lower);
        }
        if (this.tree.opCode() == 58) {
            if (this.tree.down(1).opCode() == 136) {
                return ILUtils.build(101, 1);
            }
            return this.tree.down(1);
        }
        return ILUtils.build(101, 1);
    }

    protected Tree upperTree() {
        if (this.upper != null) {
            return ILUtils.build(101, this.upper);
        }
        if (this.tree.opCode() == 58) {
            return this.tree.down(2);
        }
        return this.tree;
    }

    public boolean fullArrayTriplet(Tree tree) {
        if (tree.opCode() == 11) {
            Tree begin = tree.down(1);
            Tree end = tree.down(2);
            Tree stride = tree.down(3);
            return !(!ILUtils.isNullOrNone(begin) && !begin.equalsTree(this.lowerTree()) || !ILUtils.isNullOrNone(end) && !end.equalsTree(this.upperTree()) || !ILUtils.isNullOrNone(stride) && !ILUtils.evalsToOne(stride));
        }
        return false;
    }

    protected void updateImportedDim(SymbolTable symbolTable) {
        Tree upperDimTree;
        Tree lowerDimTree;
        if (this.tree.opCode() == 58) {
            lowerDimTree = this.tree.down(1);
            upperDimTree = this.tree.down(2);
        } else {
            lowerDimTree = null;
            upperDimTree = this.tree;
        }
        if (this.lower == null && lowerDimTree != null && lowerDimTree.opCode() != 136) {
            this.lower = symbolTable.computeIntConstant(lowerDimTree);
        }
        if (this.upper == null && upperDimTree != null && upperDimTree.opCode() != 136) {
            this.upper = symbolTable.computeIntConstant(upperDimTree);
        }
    }

    protected String showType() {
        int language;
        int n = language = TapEnv.relatedUnit() != null ? TapEnv.relatedUnit().language() : -1;
        if (TapEnv.isFortran(language)) {
            return (this.lower == null || this.lower == 1 ? "" : this.lower + ":") + (this.upper == null ? "*" : this.upper);
        }
        return this.lower != null && this.lower == 0 ? (this.upper == null ? "*" : Integer.toString(this.upper + 1)) : (this.lower == null ? "?" : this.lower) + ":" + (this.upper == null ? "*" : this.upper);
    }

    public void dump() throws IOException {
        TapEnv.print(this.lower + 58 + this.upper + " {" + this.tree + '}');
    }

    public String toString() {
        return (this.lower == null || this.lower == 1 ? "" : this.lower + ":") + (this.upper == null ? "*" : this.upper);
    }
}

