/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.IterDescriptor;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeDecl;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;
import java.util.Objects;

public final class ArrayTypeSpec
extends TypeSpec {
    private WrapperTypeSpec elementType;
    private ArrayDim[] dimensions;

    public void setElementType(WrapperTypeSpec elementType) {
        this.elementType = elementType;
    }

    @Override
    public WrapperTypeSpec elementType() {
        return this.elementType;
    }

    public ArrayDim[] dimensions() {
        return this.dimensions;
    }

    public void setDimensions(ArrayDim[] dimensions) {
        this.dimensions = dimensions;
    }

    public ArrayTypeSpec(WrapperTypeSpec elementType, ArrayDim[] dimensions) {
        super(2);
        this.elementType = elementType;
        this.dimensions = dimensions;
    }

    public static ArrayDim[] createDimensions(TapList<ArrayDim> dimsList) {
        ArrayDim[] dimsArray = new ArrayDim[TapList.length(dimsList)];
        for (int i = 0; i < dimsArray.length; ++i) {
            dimsArray[i] = (ArrayDim)dimsList.head;
            dimsList = dimsList.tail;
        }
        return dimsArray;
    }

    public static int totalArrayLength(TapList<ArrayDim> arrayDims) {
        int totalLength = 1;
        while (totalLength != -1 && arrayDims != null) {
            int dimLength = ((ArrayDim)arrayDims.head).size();
            totalLength = dimLength <= 0 ? -1 : totalLength * dimLength;
            arrayDims = arrayDims.tail;
        }
        return totalLength;
    }

    protected TypeSpec combineArrayWith(TypeSpec newActualTypeSpec) {
        boolean fortranPointer;
        boolean bl = fortranPointer = TapEnv.relatedLanguageIsFortran() && ArrayTypeSpec.isA(newActualTypeSpec, 6);
        if (fortranPointer) {
            TapEnv.toolWarning(-1, "It is clearer to specify dimensions on the type declaration statements");
            newActualTypeSpec = ((PointerTypeSpec)newActualTypeSpec).destinationType.wrappedType;
        }
        TypeSpec sumActualTypeSpec = fortranPointer ? this.combineWith(newActualTypeSpec, null) : (this.elementType == null || this.elementType.wrappedType == null ? newActualTypeSpec : this.elementType.wrappedType.combineWith(newActualTypeSpec, null));
        if (fortranPointer) {
            return new PointerTypeSpec(new WrapperTypeSpec(sumActualTypeSpec), null);
        }
        if (sumActualTypeSpec == null) {
            return null;
        }
        return new ArrayTypeSpec(new WrapperTypeSpec(sumActualTypeSpec), this.dimensions);
    }

    protected ArrayDim linearizeAllDim() {
        boolean infiniteUpper;
        int totalUpper;
        TapList<ArrayDim> allDims = this.getAllDimensions();
        assert (allDims != null);
        ArrayDim curArrayDim = (ArrayDim)allDims.head;
        int totalLower = curArrayDim.lower == null ? 1 : curArrayDim.lower;
        if (curArrayDim.upper == null) {
            totalUpper = 0;
            infiniteUpper = true;
        } else {
            totalUpper = curArrayDim.upper;
            infiniteUpper = false;
        }
        allDims = allDims.tail;
        while (allDims != null) {
            curArrayDim = (ArrayDim)allDims.head;
            int dimWidth = curArrayDim.size() - 1;
            if (infiniteUpper || dimWidth < 0) {
                infiniteUpper = true;
            } else {
                totalUpper = dimWidth * (totalUpper - totalLower + 1) + totalUpper;
            }
            allDims = allDims.tail;
        }
        ArrayDim result = new ArrayDim(null, totalLower, infiniteUpper ? null : Integer.valueOf(totalUpper), null, -1, 0, 0);
        return result;
    }

    public ArrayDim[] checkNoneDimensions(ArrayDim[] origDimensions, boolean localDecl, boolean addMultiDirDim, ArrayDim multiDirDimensionMax, String hintArrayNameInText, String hintArrayNameInIdent, Tree hintTreeSize, Tree nameTree, SymbolTable targetSymbolTable, NewSymbolHolder symbolHolder) {
        ArrayDim[] result;
        boolean different = false;
        boolean multiDirDimMustBeNone = false;
        assert (targetSymbolTable != null);
        Unit targetUnit = targetSymbolTable.unit;
        int nDims = origDimensions.length;
        boolean targetF9x = targetUnit.isFortran9x();
        if (addMultiDirDim) {
            different = true;
            result = new ArrayDim[nDims + 1];
        } else {
            result = new ArrayDim[nDims];
        }
        for (int i = nDims - 1; i >= 0; --i) {
            ArrayDim dimI;
            result[i] = dimI = origDimensions[i];
            if (dimI.isNone()) {
                multiDirDimMustBeNone = true;
                if (localDecl) {
                    different = true;
                    TapList<Tree> dummyExprs = null;
                    for (int j = nDims; j > 0; --j) {
                        dummyExprs = new TapList<Tree>(ILUtils.build(136), dummyExprs);
                    }
                    Tree dummyArrayTree = ILUtils.build(8, null, ILUtils.build(70, dummyExprs));
                    IterDescriptor dimIterDescriptor = dimI.refQuality > 0 && TapEnv.get().noisize && targetUnit.isFortran() ? new IterDescriptor(0, targetSymbolTable, null, dummyArrayTree, ILUtils.toString(dimI.refArrayTree), nameTree, dimI.refArrayTree, dimI.rankInRef, dimI.refNDims) : (dimI.refQuality > 0 && ILUtils.getIdentString(dimI.refArrayTree) != null ? new IterDescriptor(0, targetSymbolTable, null, null, dummyArrayTree, ILUtils.toString(dimI.refArrayTree), ILUtils.getIdentString(dimI.refArrayTree), dimI.refArrayTree, dimI.rankInRef, dimI.refNDims) : (hintArrayNameInIdent != null ? new IterDescriptor(0, targetSymbolTable, null, null, dummyArrayTree, hintArrayNameInText, hintArrayNameInIdent, hintTreeSize, i + 1, nDims) : new IterDescriptor(0, targetSymbolTable, null, dummyArrayTree, hintArrayNameInText, nameTree, hintTreeSize, i + 1, nDims)));
                    dimIterDescriptor.preciseDefaultLengthTree(targetUnit, targetSymbolTable);
                    Tree isizeIdent = dimIterDescriptor.getLengthTree();
                    result[i] = new ArrayDim(ILUtils.build(58, null, isizeIdent), null, null, dimI.refArrayTree, dimI.rankInRef, dimI.refNDims, dimI.refQuality);
                }
            }
            if (origDimensions[i].tree() == null) continue;
            this.checkHiddenSize(origDimensions[i].tree().down(1), targetSymbolTable, symbolHolder);
            this.checkHiddenSize(origDimensions[i].tree().down(2), targetSymbolTable, symbolHolder);
        }
        if (addMultiDirDim) {
            ArrayDim multiDirDim = multiDirDimensionMax;
            if (multiDirDimMustBeNone && targetF9x) {
                multiDirDim = new ArrayDim(null, null, null, null, -1, 0, 0);
            }
            result[nDims] = multiDirDim;
        }
        return different ? result : null;
    }

    public void checkDimensions(Tree arrayAccessTree, SymbolTable symbolTable) {
        WrapperTypeSpec typeSpec = symbolTable.typeOf(arrayAccessTree.down(1));
        ArrayTypeSpec arrayTypeSpec = (ArrayTypeSpec)typeSpec.wrappedType;
        for (int i = 0; i < this.dimensions.length; ++i) {
            if (arrayAccessTree.down(2).down(i + 1).opCode() != 11) continue;
            Tree arrayTriplet = arrayAccessTree.down(2).down(i + 1);
            if (this.dimensions[i].lower == null || !this.dimensions[i].lower.equals(arrayTypeSpec.dimensions[i].lower) || this.dimensions[i].upper != null) continue;
            if (arrayTypeSpec.dimensions[i].upper != null) {
                this.dimensions[i].upper = arrayTypeSpec.dimensions[i].upper;
                this.dimensions[i].setTree(arrayTypeSpec.dimensions[i].tree());
                continue;
            }
            if (arrayTriplet.down(2).opCode() == 136) continue;
            Tree sizeTree = ILUtils.addTree(ILUtils.subTree(arrayTriplet.down(2), arrayTriplet.down(1)), ILUtils.build(101, 1));
            this.dimensions[i].setTree(ILUtils.build(58, ILUtils.build(101, 1), sizeTree));
        }
    }

    private void checkHiddenSize(Tree arrayDimExpr, SymbolTable symbolTable, NewSymbolHolder symbolHolder) {
        TapList<Object> toUsedSymbols = new TapList<Object>(null, null);
        TapList<Object> undeclaredSymbols = new TapList<Object>(null, null);
        SymbolDecl.addUsedSymbolsInExpr(arrayDimExpr, toUsedSymbols, symbolTable, undeclaredSymbols, false, true);
        if (symbolHolder != null && undeclaredSymbols.tail != null) {
            undeclaredSymbols = TapList.deleteString("#NBDirsMax#", undeclaredSymbols);
            undeclaredSymbols = TapList.deleteString("NBDirsMax", undeclaredSymbols);
            undeclaredSymbols = TapList.deleteContainsString("ISIZE", undeclaredSymbols);
            if (undeclaredSymbols.tail != null) {
                TapEnv.fileWarning(15, arrayDimExpr, "(TC56) Declaration of " + symbolHolder.probableName() + " uses hidden variable " + undeclaredSymbols.tail);
            }
        }
        if (symbolHolder != null && toUsedSymbols.tail != null) {
            TapList usedSymbols = toUsedSymbols.tail;
            TapList<SymbolDecl> dependsOn = symbolHolder.dependsOn();
            TapList<Object> dependsOnRec = null;
            while (dependsOn != null) {
                if (dependsOn.head != null) {
                    dependsOnRec = TapList.append(((SymbolDecl)dependsOn.head).dependsOn(), dependsOnRec);
                }
                dependsOn = dependsOn.tail;
            }
            while (dependsOnRec != null && dependsOnRec.head == null) {
                dependsOnRec = dependsOnRec.tail;
            }
            while (usedSymbols != null) {
                if (!((SymbolDecl)usedSymbols.head).isA(3)) {
                    boolean hiddenDeclaration;
                    if (dependsOnRec == null) {
                        VariableDecl seenDecl = symbolTable.getVariableOrConstantDecl(((SymbolDecl)usedSymbols.head).symbol);
                        if (seenDecl == null) {
                            TapList<FunctionDecl> seenDecls = symbolTable.getFunctionDecl(((SymbolDecl)usedSymbols.head).symbol, null, null, false);
                            seenDecl = seenDecls == null ? null : (SymbolDecl)seenDecls.head;
                        }
                        hiddenDeclaration = seenDecl != usedSymbols.head;
                    } else {
                        boolean bl = hiddenDeclaration = !TapList.containsEquals(dependsOnRec, usedSymbols.head);
                    }
                    if (hiddenDeclaration) {
                        TapEnv.fileWarning(15, arrayDimExpr, "(TC56) Declaration of " + symbolHolder.probableName() + " uses hidden variable (" + ((SymbolDecl)usedSymbols.head).symbol + ')');
                    }
                }
                usedSymbols = usedSymbols.tail;
            }
        }
    }

    public void preciseSizeReferences(Tree refArrayTree, int newRefQuality) {
        if (this.dimensions != null && refArrayTree != null) {
            for (int i = this.dimensions.length - 1; i >= 0; --i) {
                if (this.dimensions[i].refQuality >= newRefQuality) continue;
                this.dimensions[i].refArrayTree = refArrayTree;
                this.dimensions[i].rankInRef = i + 1;
                this.dimensions[i].refQuality = newRefQuality;
            }
        }
    }

    @Override
    public TypeSpec wrappedType() {
        return this.elementType;
    }

    @Override
    public void setWrappedType(TypeSpec type) {
        this.elementType = type instanceof WrapperTypeSpec ? (WrapperTypeSpec)type : new WrapperTypeSpec(type);
    }

    @Override
    public TypeSpec nestedLevelType() {
        return this.elementType;
    }

    @Override
    protected String baseTypeName() {
        return this.elementType == null ? null : this.elementType.baseTypeName();
    }

    @Override
    public WrapperTypeSpec baseTypeSpec(boolean stopOnPointer) {
        if (this.elementType == null) {
            return null;
        }
        return this.elementType.baseTypeSpec(stopOnPointer);
    }

    @Override
    public WrapperTypeSpec modifiedBaseTypeSpec() {
        if (this.elementType == null) {
            return null;
        }
        return this.elementType.modifiedBaseTypeSpec();
    }

    @Override
    public boolean containsAPointer() {
        return this.elementType != null && this.elementType.containsAPointer();
    }

    @Override
    public TapList<ArrayDim> getAllDimensions() {
        TapList<ArrayDim> result = this.elementType == null ? null : this.elementType.getAllDimensions();
        for (int i = this.dimensions.length - 1; i >= 0; --i) {
            result = new TapList<ArrayDim>(this.dimensions[i], result);
        }
        return result;
    }

    @Override
    public boolean containsUnknownDimension() {
        boolean result = false;
        if (this.elementType != null) {
            result = this.elementType.containsUnknownDimension();
        }
        for (int i = this.dimensions.length - 1; i >= 0 && !result; --i) {
            result = this.dimensions[i] == null || this.dimensions[i].isUnknown();
        }
        return result;
    }

    @Override
    public void doUpdateAfterImports(SymbolTable symbolTable, TapList<TypeSpec> dejaVu) {
        if (this.elementType != null) {
            this.elementType.updateAfterImports(symbolTable, dejaVu);
        }
        for (int i = this.dimensions.length - 1; i >= 0; --i) {
            this.dimensions[i].updateImportedDim(symbolTable);
        }
    }

    @Override
    protected int computeSize() {
        int size = this.elementType.size();
        for (int i = this.dimensions.length - 1; i >= 0; --i) {
            if (this.dimensions[i] != null) {
                size *= this.dimensions[i].size();
                continue;
            }
            TapEnv.toolWarning(-1, "null dimension in " + this);
        }
        return size;
    }

    @Override
    public boolean isCharacter() {
        return this.elementType != null && this.elementType.isCharacter() && this.dimensions.length == 1 && Objects.equals(this.dimensions[0].lower, this.dimensions[0].upper);
    }

    @Override
    public boolean isString() {
        return this.elementType != null && this.elementType.isCharacter() && this.dimensions.length == 1;
    }

    @Override
    public boolean isTarget() {
        return this.elementType.isTarget();
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public void addUsedSymbolsInType(TapList<SymbolDecl> toDependsOn, SymbolTable symbolTable) {
        for (ArrayDim dimension : this.dimensions) {
            SymbolDecl.addUsedSymbolsInExpr(dimension.tree(), toDependsOn, symbolTable, null, false, true);
        }
    }

    @Override
    public void collectUsedTrees(TapList<Tree> toUsedTrees, TapList<TypeSpec> toDejaVu) {
        if (!TapList.contains(toDejaVu, this)) {
            toDejaVu.placdl(this);
            for (ArrayDim dimension : this.dimensions) {
                toUsedTrees.placdl(dimension.tree());
            }
            if (this.elementType != null && this.elementType.wrappedType != null) {
                this.elementType.wrappedType.collectUsedTrees(toUsedTrees, toDejaVu);
            }
        }
    }

    @Override
    protected boolean testComparesWith(TypeSpec other, int comparison, TypeSpec toThis, TypeSpec toOther, TapList<TapPair<TypeSpec, TypeSpec>> dejaVu) {
        toOther = other != null && other.containsArray() ? this.peelWrapperAndModifiedTo(other, toOther) : this.peelWrapperTo(other, toOther);
        if (toOther != null) {
            other = toOther.wrappedType();
        }
        if (this == other) {
            return true;
        }
        if (other == null) {
            if (ArrayTypeSpec.testHasInference(comparison) && ArrayTypeSpec.testIsEquals(comparison)) {
                if (toOther != null) {
                    toOther.setWrappedType(this);
                }
                return true;
            }
            return false;
        }
        boolean onStrings = this.isString();
        if (!(other instanceof ArrayTypeSpec || onStrings || ArrayTypeSpec.testAllowsVectorial(comparison) && (TapEnv.relatedUnit() == null || TapEnv.relatedUnit().isFortran9x()))) {
            return false;
        }
        TapList<Object> toThisDimensions = new TapList<Object>(null, null);
        TapList<Object> toOtherDimensions = new TapList<Object>(null, null);
        TypeSpec toThisElement = this.peelDimensionsTo(this, toThis, toThisDimensions);
        TypeSpec thisElement = toThisElement.wrappedType();
        toThisDimensions = toThisDimensions.tail;
        TypeSpec toOtherElement = this.peelDimensionsTo(other, toOther, toOtherDimensions);
        TypeSpec otherElement = toOtherElement != null ? toOtherElement.wrappedType() : other;
        toOtherDimensions = toOtherDimensions.tail;
        boolean comparesWell = true;
        if (toThisDimensions == null) {
            if (toOtherDimensions != null) {
                comparesWell = ArrayTypeSpec.testAcceptsUnspecified(comparison);
            }
        } else if (toOtherDimensions == null) {
            comparesWell = !(!ArrayTypeSpec.testAcceptsUnspecified(comparison) && !ArrayTypeSpec.testAllowsVectorial(comparison) || ArrayTypeSpec.testTypesLitteral(comparison) || !onStrings && TapEnv.relatedUnit() != null && !TapEnv.relatedUnit().isFortran9x() && !ArrayTypeSpec.testTypesWithoutSize(comparison));
        } else if (ArrayTypeSpec.testIsReceives(comparison)) {
            if (!onStrings) {
                int totalLength = ArrayTypeSpec.totalArrayLength(toThisDimensions);
                int totalLengthOther = ArrayTypeSpec.totalArrayLength(toOtherDimensions);
                comparesWell = totalLength == -1 || totalLengthOther == -1 || totalLengthOther == totalLength;
            }
        } else {
            boolean bl = comparesWell = TapList.length(toThisDimensions) == TapList.length(toOtherDimensions);
            while (comparesWell && toThisDimensions != null) {
                if (toThisDimensions.head == null) {
                    comparesWell = false;
                } else if (ArrayTypeSpec.testLooksDimensionLength(comparison)) {
                    comparesWell = ((ArrayDim)toThisDimensions.head).equalLength((ArrayDim)toOtherDimensions.head, comparison);
                }
                toThisDimensions = toThisDimensions.tail;
                toOtherDimensions = toOtherDimensions.tail;
            }
        }
        if (comparesWell) {
            if (thisElement == null) {
                if (ArrayTypeSpec.testHasInference(comparison)) {
                    toThisElement.setWrappedType(otherElement == null ? null : otherElement.weakenForInference(comparison));
                } else {
                    comparesWell = ArrayTypeSpec.testAcceptsUnspecified(comparison);
                }
            } else if (otherElement == null) {
                if (ArrayTypeSpec.testHasInference(comparison)) {
                    toOtherElement.setWrappedType(thisElement);
                } else {
                    comparesWell = false;
                }
            } else {
                comparesWell = thisElement.comparesWith(otherElement, comparison, toThisElement, toOtherElement, dejaVu);
            }
        }
        return comparesWell;
    }

    @Override
    protected TypeSpec weakenForInference(int comparison) {
        ArrayDim[] weakenedDimensions = new ArrayDim[this.dimensions.length];
        for (int i = this.dimensions.length - 1; i >= 0; --i) {
            weakenedDimensions[i] = this.dimensions[i] == null ? null : this.dimensions[i].weakenForInference();
        }
        if (this.elementType == null) {
            return new ArrayTypeSpec(null, weakenedDimensions);
        }
        return new ArrayTypeSpec((WrapperTypeSpec)this.elementType.weakenForInference(comparison), weakenedDimensions);
    }

    @Override
    public TypeSpec copy() {
        return new ArrayTypeSpec((WrapperTypeSpec)this.elementType.copy(), this.dimensions);
    }

    @Override
    public TypeSpec copyStopOnComposite(Unit publishedUnit) {
        ArrayDim[] copiedDimensions = null;
        if (this.dimensions != null) {
            copiedDimensions = new ArrayDim[this.dimensions.length];
            for (int i = this.dimensions.length - 1; i >= 0; --i) {
                if (this.dimensions[i] == null) {
                    copiedDimensions[i] = null;
                    continue;
                }
                copiedDimensions[i] = this.dimensions[i].copy();
                if (publishedUnit == null) continue;
                copiedDimensions[i].erasePrivateInfo(publishedUnit);
            }
        }
        return new ArrayTypeSpec((WrapperTypeSpec)this.elementType.copyStopOnComposite(publishedUnit), copiedDimensions);
    }

    @Override
    public int precisionSize() {
        return this.elementType == null ? -1 : this.elementType.precisionSize();
    }

    @Override
    public Tree buildConstantZero() {
        Tree result = this.elementType.wrappedType.buildConstantZero();
        if (TapEnv.relatedLanguageIsC()) {
            for (int i = this.dimensions.length - 1; i >= 0; --i) {
                result = ILUtils.build(9, result);
            }
        }
        return result;
    }

    @Override
    public Tree buildConstantOne() {
        return this.elementType.wrappedType.buildConstantOne();
    }

    @Override
    protected boolean containsMetaType(TapList<TypeSpec> dejaVu) {
        boolean contains;
        boolean bl = contains = this.dimensions == null || this.elementType.containsMetaType(dejaVu);
        if (this.dimensions != null) {
            for (int i = this.dimensions.length - 1; !contains && i >= 0; --i) {
                contains = this.dimensions[i] == null || this.dimensions[i].isUnknown();
            }
        }
        return contains;
    }

    @Override
    protected TypeSpec localize(TapList<TapTriplet<TypeSpec, TypeSpec, Boolean>> toAlreadyCopied, ToBool containsMeta) {
        ArrayTypeSpec copiedResult = (ArrayTypeSpec)this.findAlreadyCopiedType(toAlreadyCopied, containsMeta);
        if (copiedResult == null) {
            ArrayDim[] copiedDimensions = new ArrayDim[this.dimensions.length];
            for (int i = this.dimensions.length - 1; i >= 0; --i) {
                copiedDimensions[i] = this.dimensions[i] == null ? null : this.dimensions[i].copy();
            }
            copiedResult = new ArrayTypeSpec(null, copiedDimensions);
            copiedResult.setOrAddTypeDeclName(this.typeDeclName());
            TapTriplet<ArrayTypeSpec, ArrayTypeSpec, Boolean> alreadyRef = new TapTriplet<ArrayTypeSpec, ArrayTypeSpec, Boolean>(this, copiedResult, Boolean.FALSE);
            toAlreadyCopied.placdl(alreadyRef);
            if (this.elementType != null) {
                copiedResult.elementType = (WrapperTypeSpec)this.elementType.localize(toAlreadyCopied, containsMeta);
            }
            if (containsMeta.get()) {
                alreadyRef.third = Boolean.TRUE;
            } else {
                alreadyRef.first = null;
            }
        }
        return copiedResult;
    }

    @Override
    public TypeSpec preciseDimensions(TypeSpec complementType, TapList<TapPair<TypeSpec, TypeSpec>> dejaVu, SymbolTable symbolTable) {
        if (!ArrayTypeSpec.isA(complementType, 2)) {
            return this;
        }
        ArrayTypeSpec precisedType = (ArrayTypeSpec)TapList.cassq(this, dejaVu);
        if (precisedType == null) {
            precisedType = new ArrayTypeSpec(null, null);
            dejaVu.placdl(new TapPair<ArrayTypeSpec, ArrayTypeSpec>(this, precisedType));
            WrapperTypeSpec precisedElementType = WrapperTypeSpec.preciseDimensions(this.elementType, ((ArrayTypeSpec)complementType).elementType, dejaVu, symbolTable);
            boolean oneDimensionPrecised = false;
            ArrayDim[] complementDimensions = ((ArrayTypeSpec)complementType).dimensions;
            ArrayDim[] precisedDimensions = null;
            if (this.dimensions != null && complementDimensions != null && this.dimensions.length == complementDimensions.length) {
                precisedDimensions = new ArrayDim[this.dimensions.length];
                for (int i = this.dimensions.length - 1; i >= 0; --i) {
                    ArrayDim precisedDimension = ArrayDim.preciseDimension(this.dimensions[i], complementDimensions[i], symbolTable);
                    if (precisedDimension == this.dimensions[i] || precisedDimension == null) {
                        precisedDimensions[i] = this.dimensions[i];
                        continue;
                    }
                    precisedDimensions[i] = precisedDimension;
                    oneDimensionPrecised = true;
                }
            }
            if (!oneDimensionPrecised) {
                precisedDimensions = this.dimensions;
            }
            if (precisedElementType == this.elementType && !oneDimensionPrecised || precisedElementType.wrappedType == null || precisedDimensions == null) {
                precisedType = this;
            } else {
                precisedType.elementType = precisedElementType;
                precisedType.dimensions = precisedDimensions;
            }
        }
        return precisedType;
    }

    @Override
    public boolean containsUndefinedType() {
        return this.elementType == null || this.elementType.wrappedType == null || this.elementType.wrappedType.containsUndefinedType();
    }

    @Override
    protected TypeSpec addOneDimension(ArrayDim dimension) {
        ArrayDim[] newDimensions = new ArrayDim[this.dimensions.length + 1];
        boolean multiDirDimMustBeNone = false;
        for (int i = this.dimensions.length - 1; i >= 0; --i) {
            newDimensions[i] = this.dimensions[i];
            if (!this.dimensions[i].isNone()) continue;
            multiDirDimMustBeNone = true;
        }
        if (TapEnv.relatedLanguageIsFortran9x() && multiDirDimMustBeNone) {
            dimension = new ArrayDim(null, null, null, null, -1, 0, 0);
        }
        newDimensions[this.dimensions.length] = dimension;
        return new ArrayTypeSpec(this.elementType, newDimensions);
    }

    @Override
    public TypeSpec intToReal(TapList<TapPair<TypeSpec, TypeSpec>> dejaVu, SymbolTable symbolTable) {
        ArrayTypeSpec convertedType = (ArrayTypeSpec)TapList.cassq(this, dejaVu);
        if (convertedType == null) {
            convertedType = new ArrayTypeSpec(null, null);
            dejaVu.placdl(new TapPair<ArrayTypeSpec, ArrayTypeSpec>(this, convertedType));
            WrapperTypeSpec convertedElementType = WrapperTypeSpec.intToReal(this.elementType, dejaVu, symbolTable);
            if (convertedElementType == this.elementType || convertedElementType.wrappedType == null) {
                convertedType = this;
            } else {
                convertedType.elementType = convertedElementType;
                convertedType.dimensions = this.dimensions;
            }
        }
        return convertedType;
    }

    @Override
    protected TypeSpec realToComplex(TapList<TapPair<TypeSpec, TypeSpec>> dejaVu, WrapperTypeSpec complexTypeSpec) {
        ArrayTypeSpec convertedType = (ArrayTypeSpec)TapList.cassq(this, dejaVu);
        if (convertedType == null) {
            convertedType = new ArrayTypeSpec(null, null);
            dejaVu.placdl(new TapPair<ArrayTypeSpec, ArrayTypeSpec>(this, convertedType));
            TypeSpec convertedElementType = this.elementType.realToComplex(dejaVu, complexTypeSpec);
            if (convertedElementType == this.elementType || ((WrapperTypeSpec)convertedElementType).wrappedType == null) {
                convertedType = this;
            } else {
                convertedType.elementType = convertedElementType;
                convertedType.dimensions = this.dimensions;
            }
        }
        return convertedType;
    }

    @Override
    public WrapperTypeSpec differentiateTypeSpec(SymbolTable symbolTable, SymbolTable srcSymbolTable, int diffUnitSort, String fSuffix, int maxDiffSorts, boolean localDecl, boolean multiDirMode, ArrayDim multiDirDimensionMax, ArrayDim pointerMultiDirDim, String hintArrayNameInText, String hintArrayNameInIdent, Tree hintArrayNameTree, Tree nameTree) {
        boolean addOneDimension = false;
        if (multiDirMode && !ArrayTypeSpec.isA(this.elementType, 21)) {
            addOneDimension = true;
            multiDirMode = false;
        }
        WrapperTypeSpec differentiatedElementType = this.elementType.checkDiffTypeSpec(symbolTable, srcSymbolTable, diffUnitSort, fSuffix, localDecl, multiDirMode, multiDirDimensionMax, null, hintArrayNameInText + "()", hintArrayNameInIdent, hintArrayNameTree, nameTree);
        ArrayDim currentMultiDirDim = pointerMultiDirDim == null ? multiDirDimensionMax : pointerMultiDirDim;
        ArrayDim[] diffDimensions = this.checkNoneDimensions(this.dimensions, localDecl, addOneDimension, currentMultiDirDim, hintArrayNameInText, hintArrayNameInIdent, hintArrayNameTree, hintArrayNameTree, symbolTable, null);
        if (differentiatedElementType == null && diffDimensions == null) {
            return null;
        }
        WrapperTypeSpec result = new WrapperTypeSpec(new ArrayTypeSpec(differentiatedElementType == null ? this.elementType : differentiatedElementType, diffDimensions == null ? this.dimensions : diffDimensions));
        if (TapEnv.associationByAddress()) {
            this.diffTypeSpec = result;
        }
        return result;
    }

    @Override
    protected void addDiffTypeSpec(SymbolTable symbolTable, SymbolTable srcSymbolTable) {
        this.elementType.addRefDiffTypeSpec(symbolTable, srcSymbolTable);
    }

    @Override
    protected void cumulActiveParts(TapList diffInfos, SymbolTable symbolTable) {
        if (diffInfos != null && this.elementType != null) {
            TypeDecl typeDecl;
            this.elementType.cumulActiveParts(diffInfos, symbolTable);
            if (this.typeDeclName() != null && this.needsADiffType(null) && (typeDecl = symbolTable.getTypeDecl(this.typeDeclName())) != null) {
                typeDecl.setActive(true);
            }
        }
    }

    @Override
    public boolean needsADiffType(TapList<TypeSpec> dejaVu) {
        return this.elementType != null && this.elementType.needsADiffType(dejaVu);
    }

    @Override
    public boolean isDifferentiated(TapList<TypeSpec> dejaVu) {
        return this.elementType != null && this.elementType.isDifferentiated(dejaVu);
    }

    @Override
    protected boolean checkTypeSpecValidity(TapList<TypeSpec> dejaVu) {
        if (this.elementType != null && this.elementType.wrappedType == this) {
            TapEnv.fileWarning(15, null, "(TC41) Illegal recursive type definition " + this.showType());
            return false;
        }
        if (this.elementType != null) {
            return this.elementType.checkTypeSpecValidity(dejaVu);
        }
        TapEnv.fileWarning(15, null, "(TC41) null array element type " + this.showType());
        return false;
    }

    @Override
    public Tree generateTree(SymbolTable symbolTable, TapList<SymbolDecl> dependsOn, TapList<SymbolDecl> shortNames, boolean useShortNames, TapList<TypeSpec> dejaVu) {
        Tree typeTree;
        if (TapList.contains(dejaVu, this)) {
            TapEnv.toolWarning(-1, "(TypeSpec tree regeneration) circular type");
            return ILUtils.build(94, "CircularType");
        }
        if (this.elementType != null) {
            dejaVu = new TapList<TypeSpec>(this, dejaVu);
            typeTree = this.elementType.generateTree(symbolTable, dependsOn, shortNames, true, dejaVu);
        } else {
            TapEnv.toolWarning(-1, "(ArrayTypeSpec regeneration) null wrapped type");
            typeTree = ILUtils.build(94, "UnknownType");
        }
        Tree[] dimensionTrees = new Tree[this.dimensions.length];
        for (int i = this.dimensions.length - 1; i >= 0; --i) {
            dimensionTrees[i] = this.dimensions[i] == null ? null : ILUtils.copy(this.dimensions[i].tree());
        }
        return ILUtils.build(12, typeTree, ILUtils.build(59, dimensionTrees));
    }

    public String showDimensions() {
        boolean fortranStyle = TapEnv.relatedUnit() != null && TapEnv.isFortran(TapEnv.relatedUnit().language());
        StringBuilder dims = new StringBuilder(fortranStyle ? "(" : "[");
        if (fortranStyle) {
            for (int i = this.dimensions.length - 1; i >= 0; --i) {
                dims.append(this.dimensions[i] == null ? "?" : this.dimensions[i].showType());
                if (i <= 0) continue;
                dims.append(',');
            }
        } else {
            for (int i = 0; i < this.dimensions.length; ++i) {
                if (i > 0) {
                    dims.append(',');
                }
                dims.append(this.dimensions[i] == null ? "?" : this.dimensions[i].showType());
            }
        }
        return dims + (fortranStyle ? ")" : "]");
    }

    @Override
    public String showType() {
        return (this.elementType == null ? "?" : this.elementType.showType()) + (this.dimensions == null ? "??" : this.showDimensions());
    }

    @Override
    public void dump() throws IOException {
        TapEnv.print(this.toString());
    }

    @Override
    public String toString() {
        String dimsString;
        if (this.dimensions == null) {
            dimsString = "??";
        } else {
            boolean fortranStyle = TapEnv.relatedUnit() != null && TapEnv.isFortran(TapEnv.relatedUnit().language());
            StringBuilder dims = new StringBuilder(fortranStyle ? "(" : "[");
            if (fortranStyle) {
                for (int i = this.dimensions.length - 1; i >= 0; --i) {
                    dims.append(this.dimensions[i] == null ? "?" : this.dimensions[i]);
                    if (i <= 0) continue;
                    dims.append(',');
                }
            } else {
                for (int i = 0; i < this.dimensions.length; ++i) {
                    if (i > 0) {
                        dims.append(',');
                    }
                    dims.append(this.dimensions[i] == null ? "?" : this.dimensions[i]);
                }
            }
            dimsString = dims + (fortranStyle ? ")" : "]");
        }
        return (this.typeDeclName() == null ? "" : "\"" + this.typeDeclName() + "\":") + "array" + dimsString + " of " + (this.elementType == null ? "?" : this.elementType.toString());
    }
}

