/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.FunctionTypeSpec;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.PrimitiveTypeSpec;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.VoidTypeSpec;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;

public class CStuff {
    private static final String[] ioCall = new String[]{"remove", "rename", "tmpfile", "tmpnam", "fclose", "fflush", "fopen", "freopen", "setbuf", "setvbuf", "fprintf", "sprintf", "vfprintf", "vprintf", "vsprintf", "snprintf", "vsnprintf", "fscanf", "scanf", "sscanf", "vfscanf", "vscanf", "vsscanf", "fgetc", "getc", "getchar", "fputc", "putc", "putchar", "fgets", "gets", "fputs", "puts", "ungetc", "fread", "fwrite", "fseek", "ftell", "rewind", "fgetpos", "fsetpos", "clearerr", "feof", "ferror", "perror", "printf"};

    public static void initCSymbolTable(SymbolTable symbolTable) {
        PrimitiveTypeSpec integerTypeSpec = new PrimitiveTypeSpec("integer");
        integerTypeSpec.setPrimitiveTypeSize(TapEnv.get().integerSize);
        symbolTable.addSystemSymbolDecl(new VariableDecl(ILUtils.build(94, "__FILE__"), new WrapperTypeSpec(new PointerTypeSpec(new WrapperTypeSpec(new PrimitiveTypeSpec("character")), null)), false));
        symbolTable.addSystemSymbolDecl(new VariableDecl(ILUtils.build(94, "__LINE__"), new WrapperTypeSpec(integerTypeSpec), false));
        symbolTable.addSystemSymbolDecl(new VariableDecl(ILUtils.build(94, "__func__"), new WrapperTypeSpec(new PointerTypeSpec(new WrapperTypeSpec(new FunctionTypeSpec(new WrapperTypeSpec(new VoidTypeSpec()))), null)), false));
        symbolTable.addSystemSymbolDecl(new VariableDecl(ILUtils.build(94, "__PRETTY_FUNCTION__"), new WrapperTypeSpec(new PointerTypeSpec(new WrapperTypeSpec(new FunctionTypeSpec(new WrapperTypeSpec(new VoidTypeSpec()))), null)), false));
        symbolTable.addSystemSymbolDecl(new VariableDecl(ILUtils.build(94, "__tzname"), new WrapperTypeSpec(null), false));
        symbolTable.addSystemSymbolDecl(new VariableDecl(ILUtils.build(94, "ourIssmMPIStatusIgnore"), new WrapperTypeSpec(null), false));
        symbolTable.addSystemSymbolDecl(new VariableDecl(ILUtils.build(94, "__timezone"), new WrapperTypeSpec(null), false));
        symbolTable.addSystemSymbolDecl(new VariableDecl(ILUtils.build(94, "__daylight"), new WrapperTypeSpec(null), false));
        symbolTable.addSystemSymbolDecl(new VariableDecl(ILUtils.build(94, "__environ"), new WrapperTypeSpec(null), false));
    }

    public static boolean isAnIoCall(Tree callTree) {
        String functionName;
        boolean isIO = false;
        if (callTree != null && callTree.opCode() == 30 && (functionName = ILUtils.getCalledNameString(callTree)) != null) {
            for (int i = ioCall.length - 1; !isIO && i >= 0; --i) {
                isIO = functionName.equals(ioCall[i]);
            }
        }
        return isIO;
    }

    protected static Tree buildIOCall(Tree callTree) {
        return ILUtils.build(107, ILUtils.copy(ILUtils.getCalledName(callTree)), ILUtils.build(70), ILUtils.copy(ILUtils.getArguments(callTree)));
    }

    protected static boolean isAMalloc(Tree mallocTree) {
        boolean isMalloc = false;
        if (mallocTree != null) {
            if (mallocTree.opCode() == 31) {
                mallocTree = mallocTree.down(2);
            }
            if (mallocTree.opCode() == 30) {
                String functionName = ILUtils.getCalledNameString(mallocTree);
                isMalloc = functionName != null && (functionName.equals("malloc") || functionName.equals("calloc"));
            }
        }
        return isMalloc;
    }

    protected static Tree buildAllocate(Tree mallocTree, int typeSize, SymbolTable symbolTable, Instruction instruction) {
        Tree type = null;
        Tree result = ILUtils.build(4);
        if (mallocTree.opCode() == 31) {
            type = ILUtils.copy(mallocTree.down(1));
            if (type != null) {
                if (type.opCode() == 151 || type.opCode() == 12) {
                    type = type.down(1);
                } else {
                    WrapperTypeSpec typeSpec = TypeSpec.build(type, symbolTable, instruction, new TapList<Object>(null, null), new TapList<Object>(null, null), new TapList<Object>(null, null), new ToBool(false), null);
                    if (typeSpec != null) {
                        if (TypeSpec.isA(typeSpec, 6)) {
                            typeSpec = ((PointerTypeSpec)typeSpec.wrappedType).destinationType;
                        } else if (TypeSpec.isA(typeSpec, 2)) {
                            typeSpec = typeSpec.wrappedType.elementType();
                        }
                    }
                    type = typeSpec == null ? null : typeSpec.generateTree(symbolTable, null, null, true, null);
                }
            }
            mallocTree = mallocTree.down(2);
        }
        String funcName = ILUtils.getCalledNameString(mallocTree);
        Tree allocArgs = ILUtils.getArguments(mallocTree);
        Tree sizeInBytes = null;
        Tree sizeInObjects = null;
        if (funcName.equals("malloc")) {
            TapPair<Object, Object> foundSizes = new TapPair<Object, Object>(null, null);
            sizeInBytes = allocArgs.down(1);
            sizeInObjects = CStuff.extractElementSize(sizeInBytes, foundSizes, type, typeSize);
            if (foundSizes.first != null) {
                Tree sizeOfObject = (Tree)foundSizes.first;
                if (CStuff.isaModifiedFloatFloat(sizeOfObject.down(1))) {
                    sizeOfObject.setChild(sizeOfObject.cutChild(1).cutChild(2), 1);
                }
                if (type == null) {
                    type = ILUtils.copy(sizeOfObject.down(1));
                }
                if (foundSizes.second != null) {
                    sizeInObjects = sizeInObjects != null ? ILUtils.build(131, sizeInObjects, (Tree)foundSizes.second) : (Tree)foundSizes.second;
                }
            } else if (foundSizes.second == null) {
                sizeInObjects = typeSize != 0 ? ILUtils.build(61, sizeInObjects, ILUtils.build(101, typeSize)) : ILUtils.build(101, 1);
            }
        } else if (funcName.equals("calloc")) {
            Tree sizeOfObject;
            sizeInObjects = allocArgs.down(1);
            int nbArgs = allocArgs.length();
            if (nbArgs == 2) {
                sizeOfObject = allocArgs.down(2);
                if (sizeOfObject.opCode() == 171) {
                    if (CStuff.isaModifiedFloatFloat(sizeOfObject.down(1))) {
                        sizeOfObject.setChild(sizeOfObject.cutChild(1).cutChild(2), 1);
                    }
                    if (type == null) {
                        type = ILUtils.copy(sizeOfObject.down(1));
                    }
                }
            } else {
                TapEnv.fileError(mallocTree, "(TC32) Conflicting numbers of arguments for calloc, expected 2, is here " + allocArgs.length());
                return mallocTree;
            }
            sizeInBytes = ILUtils.build(131, ILUtils.copy(sizeInObjects), ILUtils.copy(sizeOfObject));
            result.setAnnotation("sourcetree", allocArgs);
        }
        if (sizeInObjects != null) {
            sizeInObjects = ILUtils.build(70, ILUtils.copy(sizeInObjects));
        }
        result.setChild(ILUtils.copy(sizeInBytes), 1);
        if (sizeInObjects != null) {
            result.setChild(sizeInObjects, 2);
        }
        if (type != null) {
            result.setChild(type, 3);
        }
        return result;
    }

    private static Tree extractElementSize(Tree sizeInBytes, TapPair<Tree, Tree> foundSizes, Tree type, int typeSize) {
        if (sizeInBytes.opCode() == 131) {
            Tree x2 = CStuff.extractElementSize(sizeInBytes.down(2), foundSizes, type, typeSize);
            Tree x1 = CStuff.extractElementSize(sizeInBytes.down(1), foundSizes, type, typeSize);
            return x1 == null ? x2 : (x2 == null ? x1 : ILUtils.build(131, x1, x2));
        }
        if (sizeInBytes.opCode() == 61) {
            Tree x1 = CStuff.extractElementSize(sizeInBytes.down(1), foundSizes, type, typeSize);
            if (x1 == null) {
                x1 = ILUtils.build(101, 1);
            }
            return ILUtils.build(61, x1, ILUtils.copy(sizeInBytes.down(2)));
        }
        if (sizeInBytes.opCode() == 171) {
            if (foundSizes.first == null) {
                foundSizes.first = ILUtils.copy(sizeInBytes);
                return null;
            }
            return ILUtils.copy(sizeInBytes);
        }
        if (sizeInBytes.opCode() == 101) {
            if (foundSizes.first == null && foundSizes.second == null && typeSize != 0 && sizeInBytes.intValue() == typeSize) {
                foundSizes.second = ILUtils.copy(sizeInBytes);
                return null;
            }
            return ILUtils.copy(sizeInBytes);
        }
        return ILUtils.copy(sizeInBytes);
    }

    protected static boolean isAFree(Tree callTree) {
        boolean isFree = false;
        if (callTree != null && callTree.opCode() == 30) {
            String functionName = ILUtils.getCalledNameString(callTree);
            isFree = "free".equals(functionName);
        }
        return isFree;
    }

    protected static boolean isAPow(SymbolTable symbolTable, Tree callTree) {
        String functionName;
        boolean isPow = false;
        if (callTree != null && callTree.opCode() == 30 && (isPow = "pow".equals(functionName = ILUtils.getCalledNameString(callTree)))) {
            TapList<FunctionDecl> powFuncDecls = symbolTable.getFunctionDecl("pow", null, null, false);
            FunctionDecl powFuncDecl = powFuncDecls == null ? null : (FunctionDecl)powFuncDecls.head;
            isPow = powFuncDecl != null && (powFuncDecl.isExternal() || powFuncDecl.isIntrinsic()) && powFuncDecl.unit().inStdCIncludeFile();
        }
        return isPow;
    }

    protected static Tree buildDeallocate(Tree callFreeTree) {
        Tree container = ILUtils.copy(ILUtils.getArguments(callFreeTree).down(1));
        return ILUtils.build(51, container, null);
    }

    protected static Tree buildPow(Tree callPowTree) {
        Tree son1 = ILUtils.copy(ILUtils.getArguments(callPowTree).down(1));
        Tree son2 = ILUtils.copy(ILUtils.getArguments(callPowTree).down(2));
        return ILUtils.build(152, son1, son2);
    }

    protected static boolean isaModifiedFloatFloat(Tree instrOrExpr) {
        boolean result;
        boolean bl = result = instrOrExpr != null && instrOrExpr.opCode() == 127;
        if (result) {
            Tree instrOrExprDown1 = instrOrExpr.down(1);
            int length = instrOrExprDown1.length();
            result = instrOrExpr.down(2).opCode() == 76 && (length == 0 || length == 1 && ILUtils.isIdent(instrOrExprDown1.down(1), "float", false));
        }
        return result;
    }

    private CStuff() {
    }
}

