/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.PublicInfo;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;

public final class CallArrow {
    public Unit origin;
    public Unit destination;
    public PublicInfo[] translator;
    private boolean isCall;
    private boolean isImport;
    private boolean isContain;
    private int times;
    private String srcCallName;

    public boolean isCall() {
        return this.isCall;
    }

    public boolean isImport() {
        return this.isImport;
    }

    public void setImport(boolean anImport) {
        this.isImport = anImport;
    }

    public boolean isContain() {
        return this.isContain;
    }

    public void setContain(boolean contain) {
        this.isContain = contain;
    }

    protected int times() {
        return this.times;
    }

    protected void setTimes(int times) {
        this.times = times;
    }

    public CallArrow(Unit origin, Unit destination) {
        this.origin = origin;
        this.times = 0;
        this.destination = destination;
        if (origin != null) {
            origin.callees = new TapList<CallArrow>(this, origin.callees);
        }
        if (destination != null) {
            destination.callers = new TapList<CallArrow>(this, destination.callers);
        }
        this.translator = null;
    }

    public static PublicInfo computeCallTranslatorElem(ZoneInfo zoneInfo, Unit destination, Unit origin) {
        PublicInfo result = null;
        if (zoneInfo != null) {
            switch (zoneInfo.kind()) {
                case 11: {
                    TapList<Tree> itinerary = null;
                    while (zoneInfo.targetZoneOf != null) {
                        itinerary = new TapList<Tree>(zoneInfo.accessTree, itinerary);
                        zoneInfo = zoneInfo.targetZoneOf;
                    }
                    String commonName = zoneInfo.commonName;
                    int startOffset = zoneInfo.startOffset;
                    int endOffset = zoneInfo.endOffset;
                    boolean infiniteEndOffset = zoneInfo.infiniteEndOffset;
                    ToBool declared = new ToBool(true);
                    TapPair<TapList, Unit> zc = origin.getZonesOfCommonInterval(commonName, startOffset, endOffset, infiniteEndOffset, declared);
                    TapList originZones = (TapList)zc.first;
                    TapIntList zoneRks = null;
                    while (originZones != null) {
                        TapList<?> oneOriginZonesTree = TapList.getSetFieldLocation((TapList)originZones.head, zoneInfo.accessTree, false);
                        zoneRks = ZoneInfo.listAllZones(oneOriginZonesTree, false);
                        TapList<Tree> inItinerary = itinerary;
                        while (inItinerary != null) {
                            TapIntList nextLevelZoneRks = null;
                            while (zoneRks != null) {
                                ZoneInfo zi;
                                if (declared.get()) {
                                    SymbolTable originST = ((Unit)zc.second).publicSymbolTable();
                                    zi = originST.declaredZoneInfo(zoneRks.head, 0);
                                } else {
                                    zi = origin.sideEffectZoneInfo(zoneRks.head, 0);
                                }
                                TapList<TapList<Object>> dummyZT = new TapList<TapList>(null, new TapList<TapList>(zi.targetZonesTree, null));
                                dummyZT = TapList.getSetFieldLocation(dummyZT, (Tree)inItinerary.head, false);
                                nextLevelZoneRks = TapIntList.quickUnion(nextLevelZoneRks, ZoneInfo.listAllZones(dummyZT, false));
                                zoneRks = zoneRks.tail;
                            }
                            zoneRks = nextLevelZoneRks;
                            if (!declared.get()) {
                                TapIntList inZoneRks = zoneRks;
                                while (inZoneRks != null) {
                                    inZoneRks.head = inZoneRks.head + 3 + origin.sideEffectZonesNb(0);
                                    inZoneRks = inZoneRks.tail;
                                }
                            }
                            inItinerary = inItinerary.tail;
                        }
                        originZones = originZones.tail;
                    }
                    if (declared.get()) {
                        SymbolTable originST = ((Unit)zc.second).publicSymbolTable();
                        result = PublicInfo.createDeclaredInfo(zoneRks, originST.getDeclaredKindZones(zoneRks, 1, true), originST.getDeclaredKindZones(zoneRks, 2, true), originST.getDeclaredKindZones(zoneRks, 3, true));
                        break;
                    }
                    result = PublicInfo.createSideEffectInfo(zoneRks, origin.getSideEffectKindZones(zoneRks, 1), origin.getSideEffectKindZones(zoneRks, 2), origin.getSideEffectKindZones(zoneRks, 3));
                    break;
                }
                case 7: {
                    result = PublicInfo.createParameterInfo(zoneInfo.index, zoneInfo, destination, origin);
                    break;
                }
                case 10: {
                    result = PublicInfo.createResultInfo(zoneInfo.index, zoneInfo);
                    break;
                }
                case 12: {
                    ZoneInfo copyFrom = null;
                    TapList<TapPair<ZoneInfo, TapIntList>> destinationExtraSideEffects = destination.extraSideEffectVariables;
                    while (copyFrom == null && destinationExtraSideEffects != null) {
                        TapPair currentPair = (TapPair)destinationExtraSideEffects.head;
                        if (currentPair != null && currentPair.second != null && ((TapIntList)currentPair.second).head == zoneInfo.zoneNb) {
                            copyFrom = (ZoneInfo)currentPair.first;
                        }
                        destinationExtraSideEffects = destinationExtraSideEffects.tail;
                    }
                    if (copyFrom != null && origin != null && origin.publicSymbolTable() != null) {
                        ZoneInfo visibleZoneInfo = origin.publicSymbolTable().declaredZoneInfo(copyFrom.zoneNb, 0);
                        if (visibleZoneInfo != null) {
                            while (visibleZoneInfo.from != null) {
                                visibleZoneInfo = visibleZoneInfo.from;
                            }
                        }
                        if (visibleZoneInfo != copyFrom) {
                            TapIntList seZones = (TapIntList)TapList.cassq(copyFrom, origin.extraSideEffectVariables);
                            result = PublicInfo.createSideEffectInfo(seZones, origin.getSideEffectKindZones(seZones, 1), origin.getSideEffectKindZones(seZones, 2), origin.getSideEffectKindZones(seZones, 3));
                            break;
                        }
                        TapIntList lrz = null;
                        TapIntList liz = null;
                        TapIntList lpz = null;
                        if (visibleZoneInfo.realZoneNb != -1) {
                            lrz = new TapIntList(visibleZoneInfo.realZoneNb, null);
                        }
                        if (visibleZoneInfo.intZoneNb != -1) {
                            liz = new TapIntList(visibleZoneInfo.intZoneNb, null);
                        }
                        if (visibleZoneInfo.ptrZoneNb != -1) {
                            lpz = new TapIntList(visibleZoneInfo.ptrZoneNb, null);
                        }
                        result = PublicInfo.createDeclaredInfo(new TapIntList(visibleZoneInfo.zoneNb, null), lrz, liz, lpz);
                        break;
                    }
                    if (zoneInfo.from != null) break;
                    result = PublicInfo.createIdentityInfo(zoneInfo);
                    break;
                }
                case 13: {
                    ZoneInfo origCopyFrom;
                    ZoneInfo copyFrom = zoneInfo;
                    while (copyFrom.from != null) {
                        copyFrom = copyFrom.from;
                    }
                    TapIntList seZones = null;
                    if (origin != null) {
                        seZones = (TapIntList)TapList.cassq(copyFrom, origin.extraSideEffectVariables);
                    }
                    if (seZones != null) {
                        result = PublicInfo.createSideEffectInfo(seZones, origin.getSideEffectKindZones(seZones, 1), origin.getSideEffectKindZones(seZones, 2), origin.getSideEffectKindZones(seZones, 3));
                        break;
                    }
                    ZoneInfo origZoneInfo = null;
                    if (origin != null && origin.publicSymbolTable() != null && (origZoneInfo = origin.publicSymbolTable().declaredZoneInfo(zoneInfo.index, 0)) == null && origin.privateSymbolTable() != null) {
                        origZoneInfo = origin.privateSymbolTable().declaredZoneInfo(zoneInfo.index, 0);
                    }
                    if ((origCopyFrom = origZoneInfo) != null) {
                        while (origCopyFrom.from != null) {
                            origCopyFrom = origCopyFrom.from;
                        }
                    }
                    if (origCopyFrom != copyFrom) break;
                    result = PublicInfo.createDeclaredInfo(new TapIntList(zoneInfo.index, null), zoneInfo.realZoneNb == -1 ? null : new TapIntList(zoneInfo.realZoneNb, null), zoneInfo.intZoneNb == -1 ? null : new TapIntList(zoneInfo.intZoneNb, null), zoneInfo.ptrZoneNb == -1 ? null : new TapIntList(zoneInfo.ptrZoneNb, null));
                    break;
                }
                default: {
                    if (zoneInfo.from != null) break;
                    result = PublicInfo.createIdentityInfo(zoneInfo);
                }
            }
        }
        return result;
    }

    public Unit origin() {
        return this.origin;
    }

    public Unit destination() {
        return this.destination;
    }

    public PublicInfo[] translator() {
        return this.translator;
    }

    public String srcCallName() {
        return this.srcCallName;
    }

    public void setSrcCallName(String calledName) {
        if (calledName != null && this.destination != null && !calledName.equals(this.destination.name)) {
            if (this.origin().isFortran()) {
                calledName = calledName.toUpperCase();
            }
            this.srcCallName = calledName;
        }
    }

    public void addKind(int newKind) {
        switch (newKind) {
            case 1: {
                this.isCall = true;
                break;
            }
            case 2: {
                this.isImport = true;
                break;
            }
            case 3: {
                this.isContain = true;
                break;
            }
        }
    }

    public void delKind(int k) {
        switch (k) {
            case 1: {
                this.isCall = false;
                break;
            }
            case 2: {
                this.isImport = false;
                break;
            }
            case 3: {
                this.isContain = false;
                break;
            }
        }
    }

    public boolean followsDirections(int callsDir, int importsDir, int containsDir, TapList<Unit> forwardDeclarationUnits) {
        return this.isCall && callsDir == 1 && !TapList.contains(forwardDeclarationUnits, this.destination) && (importsDir != -1 || this.origin.upperLevelUnit() == this.destination.upperLevelUnit()) || this.isImport && importsDir == 1 || this.isContain && containsDir == 1;
    }

    public boolean passesByValue(int parameterRank) {
        return this.destination.passesByValue(parameterRank, this.origin.language());
    }

    public void delete() {
        this.redirectOrigin(null);
        this.redirectDestination(null);
    }

    public void redirectOrigin(Unit unit) {
        if (this.origin != null) {
            this.origin.callees = TapList.delete(this, this.origin.callees);
        }
        this.origin = unit;
        if (this.origin != null) {
            this.origin.callees = TapList.addUnlessPresentEquals(this.origin.callees, this);
        }
    }

    public void redirectDestination(Unit unit) {
        if (this.destination != null) {
            this.destination.callers = TapList.delete(this, this.destination.callers);
        }
        this.destination = unit;
        if (this.destination != null) {
            this.destination.callers = new TapList<CallArrow>(this, this.destination.callers);
        }
    }

    public void computeTranslator() {
        if (this.destination.hasParamElemsInfo()) {
            ZoneInfo zi;
            int nbParams = 0;
            int destShapeLength = this.destination.paramElemsNb();
            this.translator = new PublicInfo[destShapeLength];
            for (int i = 0; i < destShapeLength; ++i) {
                zi = this.destination.paramElemZoneInfo(i);
                this.translator[i] = CallArrow.computeCallTranslatorElem(zi, this.destination, this.origin);
                if (!zi.isParameter() || zi.index <= nbParams) continue;
                nbParams = zi.index;
            }
            if (this.destination.isIntrinsic() || this.destination.isExternal()) {
                int i;
                TapList[] paramCoverage = new TapList[nbParams];
                for (i = nbParams - 1; i >= 0; --i) {
                    paramCoverage[i] = new TapList<Object>(null, null);
                }
                for (i = 0; i < destShapeLength; ++i) {
                    zi = this.destination.paramElemZoneInfo(i);
                    if (!zi.isParameter()) continue;
                    TapList.getSetFieldLocation(paramCoverage[zi.index - 1], zi.accessTree, true);
                }
                for (i = 0; i < destShapeLength; ++i) {
                    zi = this.destination.paramElemZoneInfo(i);
                    if (!zi.isParameter()) continue;
                    TapList<?> toLocation = TapList.getSetFieldLocation(paramCoverage[zi.index - 1], zi.accessTree, false);
                    if (this.translator[i] == null || toLocation.tail != null || toLocation.head != null) continue;
                    this.translator[i].coversFurther = true;
                }
            }
        }
    }

    public String toString() {
        return "CallArrow from " + (this.origin == null ? null : this.origin.name) + " to " + (this.destination == null ? null : this.destination.name);
    }
}

