/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public class ClassTypeSpec
extends TypeSpec {
    public Unit unit;
    public String name;

    public ClassTypeSpec(Unit unit) {
        super(23);
        this.unit = unit;
        this.name = unit.name;
        if (this.name != null && this.name.length() > 6 && this.name.startsWith("class ")) {
            this.name = this.name.substring(6);
        }
    }

    @Override
    protected String baseTypeName() {
        return this.name;
    }

    @Override
    protected boolean testComparesWith(TypeSpec other, int comparison, TypeSpec toThis, TypeSpec toOther, TapList<TapPair<TypeSpec, TypeSpec>> dejaVu) {
        if ((toOther = this.peelWrapperAndModifiedTo(other, toOther)) != null) {
            other = toOther.wrappedType();
        }
        if (this == other) {
            return true;
        }
        if (other == null) {
            if (ClassTypeSpec.testHasInference(comparison)) {
                if (toOther != null) {
                    toOther.setWrappedType(this);
                }
                return true;
            }
            return false;
        }
        if (!(other instanceof ClassTypeSpec)) {
            return false;
        }
        ClassTypeSpec otherClassType = (ClassTypeSpec)other;
        if (ClassTypeSpec.testIsEquals(comparison)) {
            return this.unit != null && otherClassType.unit == this.unit;
        }
        return this.unit == null || otherClassType.unit != null && otherClassType.unit.subClassOf(this.unit);
    }

    @Override
    public TypeSpec copy() {
        return this;
    }

    @Override
    public TypeSpec copyStopOnComposite(Unit publishedUnit) {
        return this;
    }

    @Override
    public Tree generateTree(SymbolTable symbolTable, TapList<SymbolDecl> dependsOn, TapList<SymbolDecl> shortNames, boolean useShortNames, TapList<TypeSpec> dejaVu) {
        return ILUtils.build(94, this.name);
    }

    @Override
    public String showType() {
        return this.name;
    }

    @Override
    public void dump() throws IOException {
        TapEnv.print(this.toString());
    }

    @Override
    public String toString() {
        return (this.typeDeclName() == null ? "" : "\"" + this.typeDeclName() + "\":") + "Class " + this.name;
    }
}

