/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.DiffPattern;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;

public final class DiffRoot {
    private final TapList<String> unitPathName;
    private TapList<DiffPattern> diffPatterns;
    private Unit unit;

    public TapList<String> unitPathName() {
        return this.unitPathName;
    }

    public TapList<DiffPattern> diffPatterns() {
        return this.diffPatterns;
    }

    public Unit unit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public DiffRoot(Unit unit, TapList<String> unitPathName, TapList<DiffPattern> diffPatterns) {
        this.unitPathName = unitPathName;
        this.unit = unit;
        this.diffPatterns = diffPatterns;
    }

    public static TapList<Unit> collectUnits(TapList<DiffRoot> diffRoots) {
        TapList<Object> hdResult;
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        while (diffRoots != null) {
            if (!TapList.contains(hdResult.tail, ((DiffRoot)diffRoots.head).unit)) {
                tlResult = tlResult.placdl(((DiffRoot)diffRoots.head).unit);
            }
            diffRoots = diffRoots.tail;
        }
        return hdResult.tail;
    }

    public static DiffRoot findUnit(TapList<DiffRoot> diffRoots, Unit unit) {
        DiffRoot found = null;
        while (found == null && diffRoots != null) {
            if (((DiffRoot)diffRoots.head).unit == unit) {
                found = (DiffRoot)diffRoots.head;
            }
            diffRoots = diffRoots.tail;
        }
        return found;
    }

    public static String rebuildIdentifier(TapList<String> identifierElements) {
        StringBuilder result = null;
        while (identifierElements != null) {
            if (result == null) {
                result = new StringBuilder((String)identifierElements.head);
            } else {
                result.append('.').append((String)identifierElements.head);
            }
            identifierElements = identifierElements.tail;
        }
        assert (result != null);
        return result.toString();
    }

    public void appendDiffPattern(DiffPattern pattern) {
        boolean foundDuplicate = false;
        TapList<DiffPattern> inDiffPatterns = this.diffPatterns;
        while (!foundDuplicate && inDiffPatterns != null) {
            foundDuplicate = ((DiffPattern)inDiffPatterns.head).equals(pattern);
            inDiffPatterns = inDiffPatterns.tail;
        }
        if (!foundDuplicate) {
            this.diffPatterns = new TapList<DiffPattern>(pattern, this.diffPatterns);
        }
    }

    public String toString() {
        return this.unitPathName + "(" + this.unit + "):" + this.diffPatterns;
    }
}

