/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.MPIcallInfo;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.utils.ToObject;
import fr.inria.tapenade.utils.Tree;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class Directive {
    private static final String AD_DIRECTIVE_HEAD = "$AD ";
    public static final int IILOOP = 13;
    public static final int BINOMIALCKP = 15;
    public static final int CHECKPOINTSTART = 16;
    public static final int CHECKPOINTEND = 17;
    public static final int NOCHECKPOINT = 12;
    public static final int SPECIALIZEACTIVITY = 27;
    public static final int NODIFFSTART = 21;
    public static final int NODIFFEND = 22;
    public static final int FIXEDPOINTLOOP = 23;
    public static final int DEBUGHERE = 18;
    public static final int DEBUGCALL = 19;
    private static final int MESSAGE_PASSING = 20;
    private static final int INDEPENDENT = 1;
    private static final int DEPENDENT = 2;
    private static final int DEADVARIABLE = 3;
    private static final int DEADADJOINTVARIABLE = 4;
    private static final int NOSNAPSHOT = 5;
    private static final int PASSIVEVARIABLE = 7;
    private static final int IN = 9;
    private static final int OUT = 10;
    private static final int PROCEDURE = 11;
    private static final int RESET = 14;
    private static final int LINE = 15;
    public static final int OMP_TGT = 25;
    public static final int OMP_ADJ = 26;
    private static final int OMP = 24;
    private static final Pattern splitPattern = Pattern.compile("( +,? *|, *)");
    private String directiveCommand;
    private int type;
    public Tree[] arguments;
    private String label;
    private Float accuracy;

    public String label() {
        return this.label;
    }

    public Float accuracy() {
        return this.accuracy;
    }

    public Directive(int directiveType) {
        this.type = directiveType;
    }

    protected static boolean containDirectives(TapList<Tree> commentsList) {
        boolean found = false;
        while (commentsList != null && !found) {
            found = Directive.getDirectiveText((Tree)commentsList.head) != null;
            commentsList = commentsList.tail;
        }
        return found;
    }

    protected static boolean containDirectives(Tree commentTree) {
        if (commentTree == null) {
            return false;
        }
        boolean found = false;
        Tree[] comments = commentTree.children();
        for (int i = comments.length - 1; i >= 0 && !found; --i) {
            found = Directive.getDirectiveText(comments[i]) != null;
        }
        return found;
    }

    protected static Directive hasDirective(TapList<Directive> directives, int kind) {
        while (directives != null) {
            Directive directive = (Directive)directives.head;
            if (directive.type == kind) {
                return directive;
            }
            directives = directives.tail;
        }
        return null;
    }

    protected static void analyzeUnitDirectives(Unit unit, Tree unitComments) {
        if (unit.hasSource() && unitComments != null) {
            Tree comment;
            Tree[] comments;
            TapList<Object> directivesToCut = null;
            Instruction headerInstruction = unit.entryBlock().headInstr();
            for (Tree tree : comments = unitComments.children()) {
                comment = tree;
                String directiveText = Directive.getDirectiveText(comment);
                if (directiveText == null) continue;
                while (directiveText.startsWith(" ")) {
                    directiveText = directiveText.substring(1);
                }
                String directiveTextUC = directiveText.toUpperCase();
                Directive node = null;
                if (directiveTextUC.startsWith("INDEPENDENT ")) {
                    node = Directive.buildIndependent(directiveText.substring(12));
                } else if (directiveTextUC.startsWith("IN ")) {
                    node = Directive.buildWithArgs(9, directiveText.substring(3));
                } else if (directiveTextUC.startsWith("OUT ")) {
                    node = Directive.buildWithArgs(10, directiveText.substring(4));
                } else if (directiveTextUC.startsWith("NOSNAPSHOT")) {
                    node = Directive.buildWithArgs(5, directiveText.substring(10));
                } else if (directiveTextUC.startsWith("SPECIALIZEACTIVITY")) {
                    node = Directive.buildAtomic(27);
                } else if (directiveTextUC.startsWith("NOCHECKPOINT")) {
                    node = Directive.buildNoCheckpoint(headerInstruction);
                    unit.maybeNoCheckpointed = true;
                    unit.maybeCheckpointed = false;
                } else if (directiveTextUC.startsWith("RESET ")) {
                    node = Directive.buildSaveRestoreReset(directiveText.substring(6));
                }
                if (node == null) continue;
                directivesToCut = new TapList<Tree>(comment, directivesToCut);
                node.directiveCommand = directiveText;
                unit.directives = new TapList<Directive>(node, unit.directives);
            }
            while (directivesToCut != null) {
                comment = (Tree)directivesToCut.head;
                unitComments.removeChild(comment.rankInParent());
                directivesToCut = directivesToCut.tail;
            }
        }
    }

    protected static void analyzeInstructionDirectives(Instruction instruction, Tree instructionComments) {
        if (instructionComments != null) {
            Tree[] comments;
            TapList<Object> directivesToCut = null;
            for (Tree comment : comments = instructionComments.children()) {
                String directiveText = Directive.getDirectiveText(comment);
                if (directiveText == null) continue;
                while (directiveText.startsWith(" ")) {
                    directiveText = directiveText.substring(1);
                }
                String directiveTextUC = directiveText.toUpperCase();
                Directive node = null;
                if (directiveTextUC.startsWith("II-LOOP") && TapEnv.doActivity()) {
                    node = Directive.buildIILoop(directiveText.substring(7), instruction);
                } else if (directiveTextUC.startsWith("BINOMIAL-CKP ")) {
                    node = Directive.buildBinomialCkp(directiveText.substring(13), instruction);
                } else if (directiveTextUC.startsWith("CHECKPOINT-START")) {
                    node = Directive.buildAtomic(16);
                } else if (directiveTextUC.startsWith("CHECKPOINT-END")) {
                    node = Directive.buildAtomic(17);
                } else if (directiveTextUC.startsWith("SPECIALIZEACTIVITY")) {
                    node = Directive.buildAtomic(27);
                } else if (directiveTextUC.startsWith("NOCHECKPOINT")) {
                    node = Directive.buildNoCheckpoint(instruction);
                    if (ILUtils.isCall(instruction.tree)) {
                        FunctionDecl funcDecl;
                        SymbolTable symbolTable = instruction.block.symbolTable;
                        TapList<FunctionDecl> funcDecls = symbolTable.getFunctionDecl(ILUtils.getCalledNameString(ILUtils.getCall(instruction.tree)), null, null, false);
                        FunctionDecl functionDecl = funcDecl = funcDecls == null ? null : (FunctionDecl)funcDecls.head;
                        if (funcDecl != null) {
                            funcDecl.unit().maybeNoCheckpointed = true;
                        }
                    }
                } else if (directiveTextUC.startsWith("DO-NOT-DIFF")) {
                    node = Directive.buildWithLabel(21, directiveText.substring(11));
                } else if (directiveTextUC.startsWith("END-DO-NOT-DIFF")) {
                    node = Directive.buildWithLabel(22, directiveText.substring(15));
                } else if (directiveTextUC.startsWith("FP-LOOP")) {
                    int percentPosition = directiveText.indexOf("%Accuracy");
                    node = percentPosition < 0 ? Directive.buildWithArgs(23, directiveText.substring(7)) : Directive.buildWithArgs(23, directiveText.substring(7, percentPosition), directiveText.substring(percentPosition + 9));
                } else if (directiveTextUC.startsWith("DEBUG-HERE")) {
                    node = Directive.buildWithArgs(18, directiveText.substring(10));
                } else if (directiveTextUC.startsWith("DEBUG-CALL")) {
                    node = Directive.buildWithArgs(19, directiveText.substring(10));
                } else if (directiveTextUC.startsWith("INDEPENDENT ")) {
                    node = Directive.buildIndependent(directiveText.substring(12), instruction);
                } else if (directiveTextUC.startsWith("MAKE-PROCEDURE ")) {
                    node = Directive.buildMakeProcedure(directiveText.substring(15));
                } else if (directiveTextUC.startsWith("IN ")) {
                    node = Directive.buildWithArgs(9, directiveText.substring(3));
                } else if (directiveTextUC.startsWith("OUT ")) {
                    node = Directive.buildWithArgs(10, directiveText.substring(4));
                } else if (directiveTextUC.startsWith("NOSNAPSHOT")) {
                    node = Directive.buildWithArgs(5, directiveText.substring(10));
                } else if (directiveTextUC.startsWith("DEAD ")) {
                    node = Directive.buildWithLabel(3, directiveText.substring(5));
                } else if (directiveTextUC.startsWith("DEADADJOINT ")) {
                    node = Directive.buildWithLabel(4, directiveText.substring(12));
                } else if (directiveTextUC.startsWith("PASSIVE ")) {
                    node = Directive.buildWithArgs(7, directiveText.substring(8));
                } else if (directiveTextUC.startsWith("CHANNEL ")) {
                    node = Directive.buildMessagePassingChannel(directiveText.substring(8), instruction);
                } else if (directiveTextUC.startsWith("LINE ")) {
                    if (ILUtils.isCall(instruction.tree)) {
                        int lineNumber = Integer.parseInt(directiveText.substring(5));
                        ILUtils.getCall(instruction.tree).down(1).setAnnotation("line", ILUtils.build(101, lineNumber));
                    }
                    node = null;
                } else if (directiveTextUC.startsWith("OMP ") || directiveTextUC.startsWith("OMP_")) {
                    String subText = directiveText.substring(4);
                    while (subText.startsWith(" ")) {
                        subText = subText.substring(1);
                    }
                    String subTextUC = subText.toUpperCase();
                    node = subTextUC.startsWith("TGT ") ? Directive.buildWithOMPScopings(25, subText.substring(4)) : (subTextUC.startsWith("TANGENT ") ? Directive.buildWithOMPScopings(25, subText.substring(8)) : (subTextUC.startsWith("ADJ ") ? Directive.buildWithOMPScopings(26, subText.substring(4)) : (subTextUC.startsWith("ADJOINT ") ? Directive.buildWithOMPScopings(26, subText.substring(8)) : Directive.buildWithArgs(24, subText))));
                }
                if (node == null) continue;
                if (!directiveTextUC.startsWith("CHANNEL ")) {
                    directivesToCut = new TapList<Tree>(comment, directivesToCut);
                }
                node.directiveCommand = directiveText;
                instruction.directives = new TapList<Directive>(node, instruction.directives);
            }
            while (directivesToCut != null) {
                Tree comment = (Tree)directivesToCut.head;
                instructionComments.removeChild(comment.rankInParent());
                directivesToCut = directivesToCut.tail;
            }
        }
    }

    protected static boolean isDirective(String directiveText) {
        if (directiveText == null) {
            return false;
        }
        while (directiveText.startsWith(" ")) {
            directiveText = directiveText.substring(1);
        }
        if (!(directiveText = directiveText.toUpperCase()).startsWith(AD_DIRECTIVE_HEAD)) {
            return false;
        }
        directiveText = directiveText.substring(AD_DIRECTIVE_HEAD.length());
        while (directiveText.startsWith(" ")) {
            directiveText = directiveText.substring(1);
        }
        return directiveText.startsWith("II-LOOP");
    }

    protected static String getDirectiveText(Tree comment) {
        if (!comment.isStringAtom()) {
            return null;
        }
        String text = comment.stringValue();
        while (text.startsWith(" ")) {
            text = text.substring(1);
        }
        if (!text.toUpperCase().startsWith(AD_DIRECTIVE_HEAD)) {
            return null;
        }
        text = text.substring(AD_DIRECTIVE_HEAD.length());
        while (text.startsWith(" ")) {
            text = text.substring(1);
        }
        return text;
    }

    private static Directive buildAtomic(int dirName) {
        return new Directive(dirName);
    }

    private static Directive buildWithLabel(int dirName, String args) {
        Directive newDir = new Directive(dirName);
        while (args.startsWith(" ")) {
            args = args.substring(1);
        }
        newDir.label = args;
        return newDir;
    }

    private static Directive buildWithArgs(int dirName, String args) {
        Directive newDir = new Directive(dirName);
        Directive.parseArguments(newDir, args);
        return newDir;
    }

    private static Directive buildWithOMPScopings(int dirName, String args) {
        Directive newDir = new Directive(dirName);
        while (args.startsWith(" ")) {
            args = args.substring(1);
        }
        newDir.arguments = new Tree[]{ILUtils.build(94, args)};
        return newDir;
    }

    private static Directive buildWithArgs(int dirName, String args, String accur) {
        Directive newDir = new Directive(dirName);
        Directive.parseArguments(newDir, args);
        if (!accur.isEmpty()) {
            Directive.parseAccuracy(newDir, accur);
        }
        return newDir;
    }

    private static Directive buildIILoop(String args, Instruction instruction) {
        Block block = instruction.block;
        if (block.isALoop() && block.headInstr() == instruction) {
            Directive newDir = new Directive(13);
            while (args != null && args.startsWith(" ")) {
                args = args.substring(1);
            }
            newDir.label = args;
            return newDir;
        }
        TapEnv.fileWarning(20, instruction.tree, "(XX00) Misplaced AD II-LOOP directive, ignored");
        return null;
    }

    private static Directive buildBinomialCkp(String args, Instruction instruction) {
        Block block = instruction.block;
        if (block.isALoop() && block.headInstr() == instruction) {
            Directive newDir = new Directive(15);
            Directive.parseArguments(newDir, args);
            return newDir;
        }
        TapEnv.fileWarning(20, instruction.tree, "(XX00) Misplaced AD BINOMIAL-CKP directive, ignored");
        return null;
    }

    private static Directive buildNoCheckpoint(Instruction inst) {
        if (TapEnv.get().staticTape) {
            TapEnv.commandWarning(-1, "staticTape option deactivated on units with nocheckpoint option");
            TapEnv.get().staticTape = false;
        }
        Directive newDir = new Directive(12);
        Block block = inst.block;
        if (!block.isALoop() || block.headInstr() == inst) {
            // empty if block
        }
        return newDir;
    }

    private static Directive buildIndependent(String args, Instruction instruction) {
        Block block = instruction.block;
        if (block != null && block.isALoop() && block.headInstr() == instruction) {
            TapEnv.fileWarning(20, instruction.tree, "(XX00) AD directive INDEPENDENT not yet implemented on loops, ignored");
            return null;
        }
        return Directive.buildIndependent(args);
    }

    private static Directive buildIndependent(String args) {
        Directive newDir = new Directive(1);
        StringTokenizer namesToken = new StringTokenizer(args, " ");
        while (namesToken.hasMoreElements()) {
            String name = namesToken.nextToken();
        }
        return newDir;
    }

    private static Directive buildMakeProcedure(String args) {
        while (args.startsWith(" ")) {
            args = args.substring(1);
        }
        Directive newDir = new Directive(11);
        newDir.label = args;
        return newDir;
    }

    private static Directive buildMessagePassingChannel(String args, Instruction instruction) {
        Directive newDir = new Directive(20);
        Tree channelStringTree = null;
        if (ILUtils.isCall(instruction.tree)) {
            Tree callTree = ILUtils.getCall(instruction.tree);
            channelStringTree = ILUtils.build(175, args);
            callTree.setAnnotation("channel", channelStringTree);
            Unit unit = instruction.block.unit();
            if (unit != null) {
                callTree.removeAnnotation("MPIcallInfo");
                MPIcallInfo messagePassingInfo = MPIcallInfo.getMessagePassingMPIcallInfo(ILUtils.getCalledNameString(callTree), callTree, unit.language(), instruction.block);
                if (messagePassingInfo != null && messagePassingInfo.isPointToPoint()) {
                    messagePassingInfo.registerMessagePassingChannel(unit.callGraph());
                }
            }
        }
        newDir.arguments = new Tree[]{channelStringTree};
        return newDir;
    }

    private static Directive buildSaveRestoreReset(String args) {
        Directive newDir = new Directive(14);
        splitPattern.split(args);
        return newDir;
    }

    public static void analyzeOMPScopings(Tree scopingsStringTree, boolean caseSensitive, TapList<Tree> toClausesGivenScoping, TapList<String> toForcedAtomicScopingNames, TapList<String> toForcedOtherScopingNames) {
        String scopingsString = scopingsStringTree == null ? null : scopingsStringTree.stringValue();
        ToObject<String> toScopings = new ToObject<String>(scopingsString != null && !caseSensitive ? scopingsString.toLowerCase() : scopingsString);
        Directive.skipCommaWhites(toScopings);
        while (toScopings.obj() != null && !toScopings.obj().isEmpty()) {
            TapList<String> varsNames;
            String varsString;
            int scopingOp;
            String reducOp = null;
            boolean inAtomic = false;
            if (toScopings.obj().startsWith("private")) {
                scopingOp = 153;
                toScopings.setObj(toScopings.obj().substring(7));
                varsString = Directive.getInParentheses(toScopings);
                varsNames = Directive.getVarNamesInCommas(varsString);
            } else if (toScopings.obj().startsWith("firstprivate")) {
                scopingOp = 75;
                toScopings.setObj(toScopings.obj().substring(12));
                varsString = Directive.getInParentheses(toScopings);
                varsNames = Directive.getVarNamesInCommas(varsString);
            } else if (toScopings.obj().startsWith("lastprivate")) {
                scopingOp = 112;
                toScopings.setObj(toScopings.obj().substring(11));
                varsString = Directive.getInParentheses(toScopings);
                varsNames = Directive.getVarNamesInCommas(varsString);
            } else if (toScopings.obj().startsWith("reduction")) {
                scopingOp = 157;
                toScopings.setObj(toScopings.obj().substring(9));
                varsString = Directive.getInParentheses(toScopings);
                ToObject<String> toReducInside = new ToObject<String>(varsString);
                reducOp = Directive.getBeforeColon(toReducInside);
                varsNames = Directive.getVarNamesInCommas(toReducInside.obj());
            } else if (toScopings.obj().startsWith("shared")) {
                scopingOp = 169;
                toScopings.setObj(toScopings.obj().substring(6));
                varsString = Directive.getInParentheses(toScopings);
                varsNames = Directive.getVarNamesInCommas(varsString);
            } else if (toScopings.obj().startsWith("atomic")) {
                scopingOp = 169;
                inAtomic = true;
                toScopings.setObj(toScopings.obj().substring(6));
                varsString = Directive.getInParentheses(toScopings);
                varsNames = Directive.getVarNamesInCommas(varsString);
            } else {
                TapEnv.fileError(null, "Syntax error in $AD OMP clause at:" + toScopings.obj());
                toScopings.setObj(null);
                scopingOp = 136;
                varsNames = null;
            }
            TapList<Object> toIdents = new TapList<Object>(null, null);
            while (varsNames != null) {
                if (inAtomic) {
                    toForcedAtomicScopingNames.newR((String)varsNames.head);
                } else {
                    toForcedOtherScopingNames.newR((String)varsNames.head);
                }
                toIdents.newR(ILUtils.build(94, (String)varsNames.head));
                varsNames = varsNames.tail;
            }
            if (toIdents.tail != null) {
                TapList<Tree> newClauseArgs = new TapList<Tree>(ILUtils.build(95, toIdents.tail), null);
                if (scopingOp == 157) {
                    newClauseArgs = new TapList<Tree>(ILUtils.build(94, reducOp), newClauseArgs);
                }
                toClausesGivenScoping.newR(ILUtils.build(scopingOp, newClauseArgs));
            }
            Directive.skipCommaWhites(toScopings);
        }
    }

    private static void skipCommaWhites(ToObject<String> toScopings) {
        String scopingsString;
        for (scopingsString = toScopings.obj(); scopingsString != null && (scopingsString.startsWith(" ") || scopingsString.startsWith(",")); scopingsString = scopingsString.substring(1)) {
        }
        toScopings.setObj(scopingsString);
    }

    private static String getInParentheses(ToObject<String> toScopings) {
        int closingPosition;
        String scopingsString;
        for (scopingsString = toScopings.obj(); scopingsString != null && scopingsString.startsWith(" "); scopingsString = scopingsString.substring(1)) {
        }
        assert (scopingsString != null);
        if (scopingsString.startsWith("(") && (closingPosition = scopingsString.indexOf(41)) > 0) {
            String contents = scopingsString.substring(1, closingPosition);
            toScopings.setObj(scopingsString.substring(closingPosition + 1));
            return contents;
        }
        toScopings.setObj(scopingsString);
        return null;
    }

    private static String getBeforeColon(ToObject<String> toContents) {
        String contentsString;
        for (contentsString = toContents.obj(); contentsString != null && contentsString.startsWith(" "); contentsString = contentsString.substring(1)) {
        }
        assert (contentsString != null);
        int colonPos = contentsString.indexOf(58);
        String reducOp = contentsString.substring(0, colonPos);
        int wPos = reducOp.indexOf(32);
        if (wPos > 0) {
            reducOp = reducOp.substring(0, wPos);
        }
        toContents.setObj(contentsString.substring(colonPos + 1));
        return reducOp;
    }

    private static TapList<String> getVarNamesInCommas(String identsString) {
        TapList<Object> toResult = new TapList<Object>(null, null);
        StringTokenizer identsTokenizer = new StringTokenizer(identsString, ", ");
        while (identsTokenizer.hasMoreElements()) {
            toResult.newR(identsTokenizer.nextToken());
        }
        return toResult.tail;
    }

    private static void parseArguments(Directive directive, String args) {
        while (args.startsWith(" ")) {
            args = args.substring(1);
        }
        if (args.startsWith("\"")) {
            int lastDoubleQuote = args.lastIndexOf(34);
            args = args.substring(1, lastDoubleQuote);
        }
        StringTokenizer argumentsTokenizer = new StringTokenizer(args, ", ");
        TapList<Tree> expressionsReversed = null;
        while (argumentsTokenizer.hasMoreElements()) {
            Tree expressionTree;
            if (directive.type == 23) {
                TapList<String> referenceComponents = TapList.parseIdentifier(argumentsTokenizer.nextToken());
                expressionTree = ILUtils.build(94, (String)referenceComponents.head);
                referenceComponents = referenceComponents.tail;
                while (referenceComponents != null) {
                    expressionTree = ILUtils.build(73, expressionTree, ILUtils.build(94, (String)referenceComponents.head));
                    referenceComponents = referenceComponents.tail;
                }
            } else {
                expressionTree = ILUtils.build(94, argumentsTokenizer.nextToken());
            }
            expressionsReversed = new TapList<Tree>(expressionTree, expressionsReversed);
        }
        Tree[] arguments = new Tree[TapList.length(expressionsReversed)];
        for (int i = arguments.length - 1; i >= 0; --i) {
            assert (expressionsReversed != null);
            arguments[i] = (Tree)expressionsReversed.head;
            expressionsReversed = expressionsReversed.tail;
        }
        directive.arguments = arguments;
    }

    private static void parseAccuracy(Directive directive, String accur) {
        StringTokenizer accuracyTokenizer = new StringTokenizer(accur, " ");
        directive.accuracy = Float.valueOf(accuracyTokenizer.nextToken());
    }

    public String toString() {
        StringBuilder argsString = new StringBuilder();
        if (this.arguments != null) {
            argsString.append(" args:[");
            for (int i = 0; i < this.arguments.length; ++i) {
                argsString.append(this.arguments[i]);
                if (i + 1 >= this.arguments.length) continue;
                argsString.append("; ");
            }
            argsString.append(']');
        }
        if (this.label != null) {
            argsString.append(" label:").append(this.label);
        }
        return "<Directive " + this.directiveCommand + " type:" + this.type + argsString;
    }
}

