/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.PrimitiveTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class EnumTypeSpec
extends TypeSpec {
    private final String name;
    private final Tree enumTree;

    public EnumTypeSpec(String name, Tree tree) {
        super(12);
        this.name = name;
        this.enumTree = tree;
    }

    @Override
    protected String baseTypeName() {
        return "";
    }

    @Override
    protected boolean testComparesWith(TypeSpec other, int comparison, TypeSpec toThis, TypeSpec toOther, TapList<TapPair<TypeSpec, TypeSpec>> dejaVu) {
        if ((toOther = this.peelWrapperAndModifiedTo(other, toOther)) != null) {
            other = toOther.wrappedType();
        }
        if (this == other) {
            return true;
        }
        if (other == null) {
            if (EnumTypeSpec.testHasInference(comparison)) {
                if (toOther != null) {
                    toOther.setWrappedType(this);
                }
                return true;
            }
            return false;
        }
        if (TapEnv.relatedLanguageIsC() && EnumTypeSpec.isA(other, 7) && ((PrimitiveTypeSpec)other).isInteger()) {
            return true;
        }
        if (!(other instanceof EnumTypeSpec)) {
            return false;
        }
        return this.enumTree.equalsTree(((EnumTypeSpec)other).enumTree);
    }

    @Override
    public TypeSpec copy() {
        return this;
    }

    @Override
    public TypeSpec copyStopOnComposite(Unit publishedUnit) {
        return this;
    }

    @Override
    public Tree generateTree(SymbolTable symbolTable, TapList<SymbolDecl> dependsOn, TapList<SymbolDecl> shortNames, boolean useShortNames, TapList<TypeSpec> dejaVu) {
        return ILUtils.build(66, ILUtils.build(94, this.name), this.enumTree);
    }

    @Override
    public String showType() {
        String shorthandName = this.typeDeclName();
        if (shorthandName == null) {
            return "Enum " + this.name;
        }
        return shorthandName;
    }

    @Override
    public void dump() throws IOException {
        TapEnv.print(this.toString());
    }

    @Override
    public String toString() {
        return (this.typeDeclName() == null ? "" : "\"" + this.typeDeclName() + "\":") + "enum " + this.name + "(" + ILUtils.toString(this.enumTree) + ')';
    }
}

