/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class FieldDecl
extends SymbolDecl {
    private WrapperTypeSpec type;
    private Tree bitfieldTree;
    private Tree initializationTree;

    @Override
    public WrapperTypeSpec type() {
        return this.type;
    }

    protected void setType(WrapperTypeSpec typeSpec) {
        this.type = typeSpec;
    }

    protected Tree bitfieldTree() {
        return this.bitfieldTree;
    }

    protected void setBitfieldTree(Tree bitfieldTree) {
        this.bitfieldTree = bitfieldTree;
    }

    protected FieldDecl(Tree identTree, WrapperTypeSpec typeSpec) {
        super(identTree, 2);
        this.type = typeSpec;
    }

    protected FieldDecl(String name, WrapperTypeSpec typeSpec) {
        super(name, 2);
        this.type = typeSpec;
    }

    protected Tree initializationTree() {
        if (this.initializationTree == null || this.initializationTree.isAtom()) {
            return this.initializationTree;
        }
        return this.initializationTree.down(2);
    }

    protected Tree generateInitializationTree() {
        if (this.initializationTree == null) {
            return null;
        }
        if (this.initializationTree.isAtom()) {
            return ILUtils.build(13, ILUtils.build(94, this.symbol), this.initializationTree);
        }
        return this.initializationTree;
    }

    protected Tree getInitializationTree() {
        return this.initializationTree;
    }

    protected void setInitializationTree(Tree tree) {
        this.initializationTree = tree;
    }

    @Override
    public void collectUsedTrees(TapList<Tree> toUsedTrees, TapList<TypeSpec> toDejaVu) {
        if (this.type != null && this.type.wrappedType != null) {
            this.type.wrappedType.collectUsedTrees(toUsedTrees, toDejaVu);
        }
    }

    @Override
    public void dump(int indent) throws IOException {
        TapEnv.print(this.symbol + ": ");
        if (this.type == null) {
            TapEnv.print("null type");
        } else {
            this.type.dump();
        }
        if (this.getInitializationTree() != null) {
            TapEnv.print("[init " + this.getInitializationTree() + "]");
        }
        if (this.extraInfo() != null) {
            TapEnv.print(" " + this.extraInfo());
        }
        if (this.isActiveSymbolDecl()) {
            TapEnv.print(" Diff-Active");
        }
        TapEnv.print(" field.");
    }

    @Override
    public String toString() {
        String result = "FIELD:" + this.symbol + ':' + this.type;
        if (this.initializationTree != null) {
            result = result + " := " + this.getInitializationTree();
        }
        if (this.bitfieldTree != null) {
            result = result + " : " + ILUtils.toString(this.bitfieldTree);
        }
        return result;
    }
}

