/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.frontend.TreeProtocol;
import fr.inria.tapenade.representation.BasicBlock;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.ClassDecl;
import fr.inria.tapenade.representation.Directive;
import fr.inria.tapenade.representation.EntryBlock;
import fr.inria.tapenade.representation.ExitBlock;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.FGThreads;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.FunctionTypeSpec;
import fr.inria.tapenade.representation.HeaderBlock;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.InitConstructorBlock;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.InstructionMask;
import fr.inria.tapenade.representation.InterfaceDecl;
import fr.inria.tapenade.representation.LabelHeap;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.VoidTypeSpec;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.Operator;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class FlowGraphBuilder {
    private static int fgbDepth = -1;
    private Unit unit;
    private EntryBlock entryBlock;
    private ExitBlock exitBlock;
    private final TapList<Block> allBlocks = new TapList<Object>(null, null);
    private TapList<ControlJumpInfo> nestedControlStack;
    private final LabelHeap labelHeap = new LabelHeap();
    private TreeProtocol inputTreeStream;
    private CallGraph callGraph;
    private SymbolTable curSymbolTable;
    private TapList<Instruction> curParallelControls;
    private TapList<String> labelVars;
    private Instruction curSCInstruction;
    private final TapPair<TapList<Tree>, TapList<Tree>> commentsWaiting2 = new TapPair<Object, Object>(null, null);
    private Tree labelAbovePostComments;
    private TapList<String> formatLabels;
    private InstructionMask whereMask;
    private int language;
    private boolean traceOn;
    private boolean includeContainsOneDeclaration;
    private int willBeDeletedMark;

    public static Unit build(TreeProtocol inputTreeStream, SymbolTable contextSymbolTable, CallGraph callGraph, int language, Unit unit, boolean fromLib) throws IOException {
        FlowGraphBuilder thisBuilder = new FlowGraphBuilder();
        thisBuilder.callGraph = callGraph;
        thisBuilder.traceOn = false;
        thisBuilder.unit = unit;
        thisBuilder.language = language;
        thisBuilder.inputTreeStream = inputTreeStream;
        try {
            thisBuilder.buildUnit(contextSymbolTable, fromLib);
        }
        catch (IOException exception) {
            TapEnv.systemWarning(-1, exception.getMessage() + " in " + unit.name);
            TapEnv.resetInIncludeFile();
            if (unit.isTranslationUnit()) {
                TapList danglingBlocks = thisBuilder.allBlocks.tail;
                if (danglingBlocks == null) {
                    new FGArrow((Block)thisBuilder.entryBlock, -1, 1, (Block)thisBuilder.exitBlock);
                } else {
                    while (danglingBlocks != null) {
                        if (((Block)danglingBlocks.head).flow() == null) {
                            new FGArrow((Block)danglingBlocks.head, 0, 0, (Block)thisBuilder.exitBlock);
                        }
                        danglingBlocks = danglingBlocks.tail;
                    }
                }
                unit.makeFlowGraph(thisBuilder.entryBlock, thisBuilder.allBlocks.tail, thisBuilder.exitBlock, false);
            }
            throw exception;
        }
        return thisBuilder.unit;
    }

    public static SymbolTable findHostingSymbolTable(SymbolTable enclosingSymbolTable, String privacy, Tree modifiers) {
        if (privacy != null && privacy.contains("protected")) {
            enclosingSymbolTable = enclosingSymbolTable.basisSymbolTable();
        } else if (privacy != null && privacy.contains("public")) {
            enclosingSymbolTable = enclosingSymbolTable.basisSymbolTable().basisSymbolTable();
        } else if (enclosingSymbolTable.isTranslationUnitSymbolTable() && ILUtils.contains(modifiers, 94, "private") == null) {
            enclosingSymbolTable = enclosingSymbolTable.basisSymbolTable();
        }
        return enclosingSymbolTable;
    }

    public static void attachComments(Instruction instruction, Tree tree, TapPair<Tree, Tree> postComments2, TapPair<TapList<Tree>, TapList<Tree>> commentsWaiting2) {
        if (instruction == null && tree == null) {
            if (postComments2 != null && postComments2.first != null) {
                commentsWaiting2.first = TapList.append((TapList)commentsWaiting2.first, ((Tree)postComments2.first).childrenList());
                postComments2.first = null;
            }
            if (postComments2 != null && postComments2.second != null) {
                commentsWaiting2.second = TapList.append((TapList)commentsWaiting2.second, ((Tree)postComments2.second).childrenList());
                postComments2.second = null;
            }
        } else {
            if (commentsWaiting2.first != null) {
                Tree preComments = ILUtils.build(36, ILUtils.collectCommentStrings((TapList)commentsWaiting2.first));
                if (instruction != null) {
                    instruction.preComments = preComments;
                } else {
                    tree.setAnnotation("preComments", preComments);
                }
                commentsWaiting2.first = null;
            }
            if (commentsWaiting2.second != null) {
                Tree preCommentsBlock = ILUtils.build(37, ILUtils.collectCommentStrings((TapList)commentsWaiting2.second));
                if (instruction != null) {
                    instruction.preCommentsBlock = preCommentsBlock;
                } else {
                    tree.setAnnotation("preCommentsBlock", preCommentsBlock);
                }
                commentsWaiting2.second = null;
            }
            if (postComments2 != null && postComments2.first != null) {
                Tree postComments = ILUtils.build(36, ILUtils.collectCommentStrings((Tree)postComments2.first));
                if (instruction != null) {
                    instruction.postComments = postComments;
                } else {
                    tree.setAnnotation("postComments", postComments);
                }
                postComments2.first = null;
            }
            if (postComments2 != null && postComments2.second != null) {
                Tree postCommentsBlock = ILUtils.build(37, ILUtils.collectCommentStrings((Tree)postComments2.second));
                if (instruction != null) {
                    instruction.postCommentsBlock = postCommentsBlock;
                } else {
                    tree.setAnnotation("postCommentsBlock", postCommentsBlock);
                }
                postComments2.second = null;
            }
        }
    }

    private void buildUnit(SymbolTable contextSymbolTable, boolean fromLib) throws IOException {
        SymbolTable unitSymbolTable;
        SymbolTable bodySymbolTable = unitSymbolTable = new SymbolTable(contextSymbolTable);
        this.curSymbolTable = unitSymbolTable;
        unitSymbolTable.setLanguage(this.language);
        unitSymbolTable.unit = this.unit;
        unitSymbolTable.setCaseDependent(!TapEnv.isFortran(this.language));
        this.unit.addDerivedSymbolTable(unitSymbolTable);
        this.unit.setPublicSymbolTable(unitSymbolTable);
        this.entryBlock = new EntryBlock(unitSymbolTable);
        this.exitBlock = new ExitBlock(unitSymbolTable);
        TapEnv.pushRelatedUnit(this.unit);
        this.unit.setEntryBlock(this.entryBlock);
        this.unit.setExitBlock(this.exitBlock);
        this.unit.position = this.inputTreeStream.position() + 1;
        boolean keepUnit = true;
        BasicBlock centralBlock = null;
        WrapperTypeSpec returnTypeSpec = new WrapperTypeSpec(new VoidTypeSpec());
        boolean variableArgList = false;
        int unitCode = this.inputTreeStream.seeOperator().code;
        switch (unitCode) {
            case 26: 
            case 52: 
            case 74: {
                this.traceOn = this.traceOn(this.unit.name);
                unitSymbolTable.setIsTranslationUnit();
                unitSymbolTable.setShortName("SymbolTable of Translation Unit (i.e. file) " + this.unit.name);
                this.unit.setTranslationUnitSymbolTable(unitSymbolTable);
                unitSymbolTable.containerFileName = TapEnv.stripLanguageExtension(this.unit.name);
                if (!this.unit.name.startsWith("iso_c_binding")) {
                    this.callGraph.addTranslationUnitSymbolTable(unitSymbolTable);
                }
                TapEnv.setCurrentTranslationUnitSymbolTable(unitSymbolTable);
                break;
            }
            case 129: {
                SymbolTable privST;
                boolean isBlockData;
                this.inputTreeStream.readOperator();
                this.unit.setModule();
                Tree moduleNameTree = this.inputTreeStream.readTree();
                boolean bl = isBlockData = moduleNameTree.opCode() == 136 || moduleNameTree.opCode() == 94 && ILUtils.getIdentString(moduleNameTree).toLowerCase().startsWith("_blockdata_");
                if (TapEnv.traceInputIL()) {
                    for (int jj = 0; jj < fgbDepth; ++jj) {
                        TapEnv.printOnTrace(" ");
                    }
                    TapEnv.printlnOnTrace("--> [" + fgbDepth + "] module " + moduleNameTree);
                }
                if (moduleNameTree.opCode() == 136) {
                    this.unit.name = "";
                    moduleNameTree = ILUtils.build(94, "");
                    unitSymbolTable.setShortName("SymbolTable of block data");
                    TapEnv.printlnOnTrace(10, "@@ [" + this.unit.nestingDepth() + "] Building block data");
                } else {
                    FunctionDecl modDecl;
                    Unit oldUnit = null;
                    TapList<FunctionDecl> modDecls = unitSymbolTable.getFunctionDecl(ILUtils.getIdentString(moduleNameTree), null, null, false);
                    while (modDecls != null && (((FunctionDecl)modDecls.head).unit() == null || !((FunctionDecl)modDecls.head).unit().isUndefined() && !((FunctionDecl)modDecls.head).unit().isModule())) {
                        modDecls = modDecls.tail;
                    }
                    FunctionDecl functionDecl = modDecl = modDecls == null ? null : (FunctionDecl)modDecls.head;
                    if (modDecl != null) {
                        oldUnit = modDecl.unit();
                    }
                    if (oldUnit == null) {
                        oldUnit = this.callGraph.getUnit(ILUtils.getIdentString(moduleNameTree));
                    }
                    if (oldUnit != null && oldUnit.isUndefined()) {
                        this.unit.absorb(oldUnit);
                        this.callGraph.deleteUnit(oldUnit);
                    }
                    this.unit.name = ILUtils.getIdentString(moduleNameTree);
                    unitSymbolTable.setShortName("Public SymbolTable of module " + this.unit.name);
                    TapEnv.printlnOnTrace(10, "@@ [" + this.unit.nestingDepth() + "] Building module: " + this.unit.name + " @" + Integer.toHexString(this.unit.hashCode()) + " provisional rank:" + this.unit.rank());
                }
                this.traceOn = this.traceOn(this.unit.name);
                if (!isBlockData) {
                    TapEnv.warningFortran77WithFortran90Features(this.unit);
                }
                FunctionDecl prevDecl = null;
                SymbolTable hostingSymbolTable = this.callGraph.fortranRootSymbolTable();
                if (!this.unit.name.isEmpty()) {
                    TapList<FunctionDecl> prevDecls = hostingSymbolTable.getFunctionDecl(ILUtils.getIdentString(moduleNameTree), null, null, false);
                    FunctionDecl functionDecl = prevDecl = prevDecls == null ? null : (FunctionDecl)prevDecls.head;
                }
                if (prevDecl != null && prevDecl.unit() != null) {
                    if (prevDecl.unit().isUndefined()) {
                        hostingSymbolTable.removeDecl(prevDecl.symbol, 3, false);
                        prevDecl = null;
                    } else if (!prevDecl.isIntrinsic()) {
                        TapEnv.fileWarning(5, moduleNameTree, "(DD16) Double declaration of " + prevDecl.unit().name + " (ignored new)");
                        keepUnit = false;
                    } else {
                        prevDecl = null;
                    }
                }
                if (prevDecl == null) {
                    FunctionDecl tmpFunctionDecl = new FunctionDecl(moduleNameTree, this.unit, hostingSymbolTable);
                    hostingSymbolTable.addSymbolDecl(tmpFunctionDecl);
                    keepUnit = true;
                }
                if ((privST = this.unit.privateSymbolTable()) == null) {
                    privST = new SymbolTable(this.unit.publicSymbolTable());
                    privST.unit = this.unit;
                    privST.setShortName("Private SymbolTable of module " + this.unit.name);
                    this.unit.addDerivedSymbolTable(privST);
                    this.unit.setPrivateSymbolTable(privST);
                }
                centralBlock = new BasicBlock(privST, null, this.allBlocks);
                this.unit.publicSymbolTable().declarationsBlock = centralBlock;
                privST.declarationsBlock = centralBlock;
                bodySymbolTable = privST;
                break;
            }
            case 35: {
                SymbolTable privST;
                SymbolTable protST;
                Unit existingClassUnit;
                Tree classNameTree;
                this.inputTreeStream.readOperator();
                this.unit.setClass();
                this.unit.modifiers = this.inputTreeStream.readTree();
                Tree peeledClassNameTree = classNameTree = this.inputTreeStream.readTree();
                if (peeledClassNameTree.opCode() == 168) {
                    peeledClassNameTree = peeledClassNameTree.down(2);
                }
                String className = ILUtils.getIdentString(peeledClassNameTree);
                if (TapEnv.traceInputIL()) {
                    for (int jj = 0; jj < fgbDepth; ++jj) {
                        TapEnv.printOnTrace(" ");
                    }
                    TapEnv.printlnOnTrace("--> [" + fgbDepth + "] class " + className);
                }
                this.unit.name = className;
                this.traceOn = this.traceOn(className);
                ClassDecl existingClassDecl = contextSymbolTable.getClassDecl(className);
                Unit unit = existingClassUnit = existingClassDecl == null ? null : existingClassDecl.unit;
                if (existingClassUnit != null) {
                    this.unit.absorbAndDeleteUnit(existingClassUnit);
                    unitSymbolTable.removeDecl(className, 18, false);
                    TapEnv.printlnOnTrace(10, "@@ [" + this.unit.nestingDepth() + "] Continuing class: " + this.unit.name + " @" + Integer.toHexString(existingClassUnit.hashCode()) + "==>@" + Integer.toHexString(this.unit.hashCode()) + " new provisional rank:" + this.unit.rank());
                } else {
                    TapEnv.printlnOnTrace(10, "@@ [" + this.unit.nestingDepth() + "] Building class: " + this.unit.name + " @" + Integer.toHexString(this.unit.hashCode()) + " provisional rank:" + this.unit.rank());
                }
                unitSymbolTable.setShortName("Public SymbolTable of class " + this.unit.name);
                contextSymbolTable.addNewSymbolDecl(new ClassDecl(className, this.unit));
                VariableDecl thisDecl = new VariableDecl(ILUtils.build(94, "this"), new WrapperTypeSpec(new PointerTypeSpec(new WrapperTypeSpec(this.unit.classTypeSpec()), null)));
                unitSymbolTable.addSymbolDecl(thisDecl);
                Tree parentClassesTree = this.inputTreeStream.readTree();
                if (!ILUtils.isNullOrNoneOrEmptyList(parentClassesTree)) {
                    Tree[] parentClasses = parentClassesTree.children();
                    for (int k = parentClasses.length - 1; k >= 0; --k) {
                        Unit parentClass;
                        String parentClassName = ILUtils.getIdentString(parentClasses[k].down(2));
                        if (parentClassName == null) {
                            TapEnv.printlnOnTrace("Failed to lookup class name " + parentClasses[k].down(2));
                            continue;
                        }
                        ClassDecl parentClassDecl = parentClassName == null ? null : unitSymbolTable.getClassDecl(parentClassName);
                        Unit unit2 = parentClass = parentClassDecl == null ? null : parentClassDecl.unit;
                        if (parentClass == null) {
                            parentClass = this.callGraph.createNewUnit(this.unit.upperLevelUnit(), this.language);
                            parentClass.setExternalSymbolTable(this.callGraph.languageRootSymbolTable(this.language));
                            TapEnv.toolWarning(-1, " NOTE: parent class " + parentClass + " created as undefined");
                            parentClass.setUndefined();
                            parentClass.name = parentClassName;
                            ClassDecl globalClassDecl = new ClassDecl(parentClassName, parentClass);
                            this.callGraph.languageRootSymbolTable(this.language).addSymbolDecl(globalClassDecl);
                        }
                        CallGraph.addCallArrow(this.unit, 2, parentClass);
                        Tree[] modifiersImport = parentClasses[k].down(1).children();
                        boolean isVirtual = false;
                        boolean isPublic = false;
                        for (int j = modifiersImport.length - 1; j >= 0; --j) {
                            isPublic = ILUtils.getIdentString(modifiersImport[j]).contains("public");
                            isVirtual = ILUtils.getIdentString(modifiersImport[j]).contains("virtual");
                        }
                        this.unit.addParentClass(parentClass, isVirtual, isPublic);
                        parentClass.addChildrenClass(this.unit);
                    }
                }
                if ((protST = this.unit.protectedSymbolTable()) == null) {
                    protST = new SymbolTable(this.unit.publicSymbolTable());
                    protST.unit = this.unit;
                    protST.setShortName("Protected SymbolTable of class " + this.unit.name);
                    this.unit.addDerivedSymbolTable(protST);
                    this.unit.setProtectedSymbolTable(protST);
                }
                if ((privST = this.unit.privateSymbolTable()) == null) {
                    privST = new SymbolTable(this.unit.protectedSymbolTable());
                    privST.unit = this.unit;
                    privST.setShortName("Private SymbolTable of class " + this.unit.name);
                    this.unit.addDerivedSymbolTable(privST);
                    this.unit.setPrivateSymbolTable(privST);
                }
                Tree classHeaderTree = ILUtils.build(35, this.unit.modifiers, classNameTree, parentClassesTree, null);
                this.entryBlock.addInstrTl(new Instruction(classHeaderTree, null));
                centralBlock = new BasicBlock(privST, null, this.allBlocks);
                this.unit.publicSymbolTable().declarationsBlock = centralBlock;
                protST.declarationsBlock = centralBlock;
                privST.declarationsBlock = centralBlock;
                bodySymbolTable = privST;
                keepUnit = true;
                break;
            }
            case 45: 
            case 55: {
                TypeSpec[] argumentsTypeSpecs;
                int i;
                Tree xxstructorNameTree;
                boolean isConstructor = unitCode == 45;
                this.inputTreeStream.readOperator();
                if (isConstructor) {
                    this.unit.setConstructor();
                } else {
                    this.unit.setDestructor();
                }
                this.unit.modifiers = this.inputTreeStream.readTree();
                Tree xxstructorNameIdentTree = xxstructorNameTree = this.inputTreeStream.readTree();
                Tree scopeTree = null;
                if (xxstructorNameTree.opCode() == 168) {
                    scopeTree = xxstructorNameTree.down(1);
                    xxstructorNameIdentTree = xxstructorNameTree.down(2);
                }
                String xxstructorNameString = ILUtils.getIdentString(xxstructorNameIdentTree);
                String classNameString = isConstructor ? xxstructorNameString : xxstructorNameString.substring(1);
                Unit classUnit = this.unit.upperLevelUnit();
                if (classUnit != null && classUnit.isClass() && ILUtils.stripSpecialization(classUnit.name).equals(classNameString)) {
                    classNameString = classUnit.name;
                    xxstructorNameString = isConstructor ? classNameString : "~" + classNameString;
                    xxstructorNameIdentTree.setValue(xxstructorNameString);
                } else {
                    ClassDecl classDecl = scopeTree == null ? null : contextSymbolTable.getClassDecl(scopeTree);
                    if ((classDecl = classDecl != null ? classDecl.unit.privateSymbolTable().getClassDecl(classNameString) : contextSymbolTable.getClassDecl(classNameString)) == null) {
                        TapEnv.toolWarning(-1, "Parent class of " + (isConstructor ? "constructor " : "destructor ") + xxstructorNameTree + " not found: marked as undefined");
                        this.unit.setUndefined();
                        classUnit = null;
                    } else {
                        classUnit = classDecl.unit;
                        this.callGraph.detachFromUpperUnit(this.unit);
                        this.callGraph.attachToUpperUnit(this.unit, classUnit);
                    }
                }
                if (TapEnv.traceInputIL()) {
                    for (int jj = 0; jj < fgbDepth; ++jj) {
                        TapEnv.printOnTrace(" ");
                    }
                    TapEnv.printlnOnTrace("--> [" + fgbDepth + "] " + (isConstructor ? "constructor " : "destructor ") + xxstructorNameString);
                }
                this.unit.name = xxstructorNameString;
                this.traceOn = this.traceOn(xxstructorNameString);
                TapEnv.printlnOnTrace(10, "@@ [" + this.unit.nestingDepth() + "] Building " + (isConstructor ? "constructor" : "destructor") + " of class: " + classNameString + " @" + Integer.toHexString(this.unit.hashCode()) + " provisional rank:" + this.unit.rank());
                unitSymbolTable.declareFormalParamsLevel();
                unitSymbolTable.setShortName("Formal params SymbolTable of " + (isConstructor ? "constructor" : "destructor") + " of class " + this.unit.name);
                returnTypeSpec = new WrapperTypeSpec(new VoidTypeSpec());
                int position = this.inputTreeStream.position() + 1;
                Tree callTree = ILUtils.buildCall(ILUtils.build(94, xxstructorNameString), ILUtils.build(70));
                ILUtils.setPosition(callTree, position);
                if (isConstructor) {
                    Tree paramsTree = this.inputTreeStream.readTree();
                    Tree[] paramsTrees = paramsTree.children();
                    TapList<Object> paramTypeSpecList = null;
                    int nbArg = 1;
                    for (i = 0; i < paramsTrees.length; ++i) {
                        Tree[] paramIdents;
                        TapList<WrapperTypeSpec> varTypeSpecs = unitSymbolTable.addVarDeclaration(paramsTrees[i], null, true, null);
                        for (Tree paramIdent : paramIdents = paramsTrees[i].down(3).children()) {
                            String varName;
                            VariableDecl varDecl;
                            if (paramIdent.opCode() != 172 && (varDecl = unitSymbolTable.getVariableDecl(varName = paramIdent.opCode() == 94 || paramIdent.opCode() == 121 ? ILUtils.getIdentString(paramIdent) : ILUtils.baseName(paramIdent))) != null) {
                                varDecl.formalArgRank = nbArg;
                            }
                            ILUtils.getArguments(callTree).addChild(ILUtils.copy(paramIdent), nbArg);
                            ++nbArg;
                        }
                        paramTypeSpecList = TapList.append(paramTypeSpecList, varTypeSpecs);
                    }
                    argumentsTypeSpecs = new WrapperTypeSpec[TapList.length(paramTypeSpecList)];
                    i = 0;
                    while (paramTypeSpecList != null) {
                        argumentsTypeSpecs[i] = (WrapperTypeSpec)paramTypeSpecList.head;
                        paramTypeSpecList = paramTypeSpecList.tail;
                        ++i;
                    }
                } else {
                    argumentsTypeSpecs = new WrapperTypeSpec[]{};
                }
                this.unit.setFunctionTypeSpec(new FunctionTypeSpec(returnTypeSpec, (WrapperTypeSpec[])argumentsTypeSpecs, false));
                if (classUnit != null) {
                    TapList<FunctionDecl> sameFuncs = classUnit.privateSymbolTable().getTopFunctionDecl(xxstructorNameString, returnTypeSpec, argumentsTypeSpecs, true);
                    if (sameFuncs == null) {
                        sameFuncs = classUnit.protectedSymbolTable().getTopFunctionDecl(xxstructorNameString, returnTypeSpec, argumentsTypeSpecs, true);
                    }
                    if (sameFuncs == null) {
                        sameFuncs = classUnit.publicSymbolTable().getTopFunctionDecl(xxstructorNameString, returnTypeSpec, argumentsTypeSpecs, true);
                    }
                    if (sameFuncs != null) {
                        TapEnv.fileWarning(15, xxstructorNameTree, "A declaration of " + (isConstructor ? "constructor" : "destructor") + " in class " + classNameString + " already exists.");
                    }
                }
                this.entryBlock.addInstrTl(new Instruction(callTree, this.curSCInstruction));
                SymbolTable hostingSymbolTable = FlowGraphBuilder.findHostingSymbolTable(contextSymbolTable, null, this.unit.modifiers);
                FunctionDecl tmpFunctionDecl = new FunctionDecl(xxstructorNameIdentTree, this.unit, contextSymbolTable, classNameString);
                if (!this.unit.isTopInFile() && !this.unit.upperLevelUnit().privacy.isEmpty()) {
                    tmpFunctionDecl.addExtraInfo(new TapList<String>(this.unit.upperLevelUnit().privacy, null));
                }
                hostingSymbolTable.addSymbolDecl(tmpFunctionDecl);
                bodySymbolTable = new SymbolTable(unitSymbolTable);
                bodySymbolTable.setShortName("Local variables SymbolTable of " + (isConstructor ? "constructor " : "destructor ") + " of class " + this.unit.name);
                bodySymbolTable.unit = this.unit;
                this.unit.addDerivedSymbolTable(bodySymbolTable);
                this.unit.setPrivateSymbolTable(bodySymbolTable);
                break;
            }
            default: {
                Tree annot;
                Tree annotExplicitReturn;
                Tree modifiers;
                int i;
                this.inputTreeStream.readOperator();
                this.unit.modifiers = modifiers = this.inputTreeStream.readTree();
                Tree classNameTree = null;
                String classNameString = null;
                if (unitCode == 87) {
                    ToBool isPointer = new ToBool(false);
                    Tree returnTree = this.inputTreeStream.readTree();
                    returnTypeSpec = TypeSpec.build(returnTree, unitSymbolTable, null, new TapList<Object>(null, null), new TapList<Object>(null, null), new TapList<Object>(null, null), isPointer, null);
                    if (isPointer.get()) {
                        returnTypeSpec = new WrapperTypeSpec(new PointerTypeSpec(returnTypeSpec, null));
                    }
                    classNameTree = this.inputTreeStream.readTree();
                }
                Tree funcNameTree = this.inputTreeStream.readTree();
                String funcNameString = ILUtils.getIdentString(funcNameTree);
                if (funcNameTree.opCode() == 136) {
                    funcNameString = "_main_";
                    funcNameTree = ILUtils.build(94, funcNameString);
                }
                this.unit.name = funcNameString;
                if (TapEnv.traceInputIL()) {
                    for (int jj = 0; jj < fgbDepth; ++jj) {
                        TapEnv.printOnTrace(" ");
                    }
                    TapEnv.printlnOnTrace("--> [" + fgbDepth + "] function " + funcNameString);
                }
                this.traceOn = this.traceOn(this.unit.name);
                TapEnv.printlnOnTrace(10, "@@ [" + this.unit.nestingDepth() + "] Building " + (this.unit.isInterface() ? "interface" : "flow-graph for unit") + ": " + this.unit.name + " @" + Integer.toHexString(this.unit.hashCode()) + " provisional rank:" + this.unit.rank());
                VariableDecl otherReturnVarDecl = null;
                unitSymbolTable.declareFormalParamsLevel();
                unitSymbolTable.setShortName("Formal params SymbolTable of procedure " + this.unit.name);
                Unit standardUnit = this.unit;
                if (returnTypeSpec.wrappedType == null && TapEnv.isCorMore(this.language) && this.unit.name.equals("main")) {
                    returnTypeSpec.wrappedType = new VoidTypeSpec();
                }
                if ((annotExplicitReturn = (Tree)funcNameTree.getAnnotation("explicitReturnVar")) != null && annotExplicitReturn.opCode() == 1) {
                    funcNameTree.removeAnnotation("explicitReturnVar");
                    funcNameTree.setAnnotation("bind", annotExplicitReturn);
                }
                if ((annot = (Tree)funcNameTree.getAnnotation("bind")) != null && annot.opCode() == 1) {
                    this.unit.modifiers = annot;
                    this.unit.setLanguageAndUp(3);
                }
                if (!TypeSpec.isA(returnTypeSpec, 9)) {
                    annotExplicitReturn = (Tree)funcNameTree.getAnnotation("explicitReturnVar");
                    if (annotExplicitReturn != null && annotExplicitReturn.opCode() == 94) {
                        otherReturnVarDecl = new VariableDecl(annotExplicitReturn, returnTypeSpec);
                        unitSymbolTable.addSymbolDecl(otherReturnVarDecl);
                        otherReturnVarDecl.setNoneInstruction();
                    } else if (TapEnv.isCorMore(this.language) && !fromLib) {
                        NewSymbolHolder otherFuncNameSH = new NewSymbolHolder(funcNameString);
                        otherFuncNameSH.setAsVariable(returnTypeSpec, null);
                        otherFuncNameSH.makeNewRef(this.unit.publicSymbolTable());
                        otherFuncNameSH.solvingLevelMustInclude(this.unit.privateSymbolTable());
                        otherFuncNameSH.declarationLevelMustInclude(this.unit.publicSymbolTable());
                        otherReturnVarDecl = otherFuncNameSH.newVariableDecl();
                        otherReturnVarDecl.setNoneInstruction();
                    } else {
                        VariableDecl returnVarDecl = new VariableDecl(funcNameTree, returnTypeSpec);
                        returnVarDecl.setReturnVar();
                        unitSymbolTable.addSymbolDecl(returnVarDecl);
                        returnVarDecl.setNoneInstruction();
                    }
                }
                int position = this.inputTreeStream.position() + 1;
                Tree paramsTree = this.inputTreeStream.readTree();
                Tree[] paramsTrees = paramsTree.children();
                TapList<Object> paramTypeSpecList = null;
                Tree callTree = ILUtils.buildCall(ILUtils.copy(funcNameTree), ILUtils.build(70));
                ILUtils.setPosition(callTree, position);
                int nbArg = 1;
                for (i = 0; i < paramsTrees.length; ++i) {
                    if (paramsTrees[i].opCode() == 198) {
                        TapEnv.toolWarning(-1, "(DD99) Warning: feature of C not supported: variable argument list");
                        variableArgList = true;
                        continue;
                    }
                    if (ILUtils.isNullOrNone(paramsTrees[i]) || paramsTrees[i].opCode() != 194) continue;
                    TapList<WrapperTypeSpec> varTypeSpecs = unitSymbolTable.addVarDeclaration(paramsTrees[i], null, true, null);
                    Tree[] paramIdents = paramsTrees[i].down(3).children();
                    if (paramIdents.length == 0) {
                        paramIdents = new Tree[]{ILUtils.build(94, "_")};
                    }
                    for (Tree paramIdent : paramIdents) {
                        VariableDecl varDecl;
                        String varName;
                        if (paramIdent.opCode() != 172 && (varName = paramIdent.opCode() == 94 || paramIdent.opCode() == 121 ? ILUtils.getIdentString(paramIdent) : ILUtils.baseName(paramIdent)) != null && (varDecl = unitSymbolTable.getVariableDecl(varName)) != null) {
                            varDecl.formalArgRank = nbArg;
                        }
                        ILUtils.getArguments(callTree).addChild(ILUtils.copy(paramIdent), nbArg);
                        ++nbArg;
                    }
                    paramTypeSpecList = TapList.append(paramTypeSpecList, varTypeSpecs);
                }
                this.entryBlock.addInstrTl(new Instruction(callTree, this.curSCInstruction));
                TypeSpec[] argumentsTypes = new WrapperTypeSpec[TapList.length(paramTypeSpecList)];
                i = 0;
                while (paramTypeSpecList != null) {
                    argumentsTypes[i] = (WrapperTypeSpec)paramTypeSpecList.head;
                    paramTypeSpecList = paramTypeSpecList.tail;
                    ++i;
                }
                if (this.language == 5) {
                    if (classNameTree.opCode() == 168) {
                        classNameTree = classNameTree.down(2);
                    }
                    if ((classNameString = ILUtils.getIdentString(classNameTree)) != null) {
                        Unit classUnit;
                        if (classNameTree.opCode() == 94 && this.unit.upperLevelUnit() != null && this.unit.upperLevelUnit().name.equals(classNameString)) {
                            classUnit = this.unit.upperLevelUnit();
                        } else {
                            TapEnv.printlnOnTrace("DANGER: function Unit out of classUnit: " + this.unit.name + " i.e. " + funcNameString);
                            classUnit = null;
                            this.unit.setUpperLevelUnit(classUnit);
                        }
                        if (classUnit != null) {
                            TapList<FunctionDecl> sameFuncs = classUnit.privateSymbolTable().getTopFunctionDecl(funcNameString, returnTypeSpec, argumentsTypes, true);
                            if (sameFuncs == null) {
                                sameFuncs = classUnit.protectedSymbolTable().getTopFunctionDecl(funcNameString, returnTypeSpec, argumentsTypes, true);
                            }
                            if (sameFuncs == null) {
                                sameFuncs = classUnit.publicSymbolTable().getTopFunctionDecl(funcNameString, returnTypeSpec, argumentsTypes, true);
                            }
                            if (sameFuncs != null) {
                                TapEnv.fileWarning(15, funcNameTree, "A declaration of function " + funcNameString + " in class " + classUnit.name + " already exists (ignoring new decl) HERE:" + new FunctionTypeSpec(returnTypeSpec, (WrapperTypeSpec[])argumentsTypes) + " EXISTING:" + sameFuncs.head + " FTYPE:" + ((FunctionDecl)sameFuncs.head).functionTypeSpec());
                            }
                        } else {
                            TapEnv.toolWarning(-1, " NOTE: function " + this.unit + " will be marked as undefined");
                            this.unit.setUndefined();
                        }
                    } else {
                        TapList<FunctionDecl> sameFuncs = this.callGraph.cPlusPlusRootSymbolTable().getTopFunctionDecl(funcNameString, returnTypeSpec, argumentsTypes, true);
                        if (sameFuncs != null) {
                            TapEnv.fileWarning(15, funcNameTree, "A declaration of function " + funcNameString + " already exists (ignoring new decl) HERE:" + new FunctionTypeSpec(returnTypeSpec, (WrapperTypeSpec[])argumentsTypes) + " EXISTING:" + sameFuncs.head + " FTYPE:" + ((FunctionDecl)sameFuncs.head).functionTypeSpec());
                        }
                    }
                }
                boolean isStatic = ILUtils.contains(this.unit.modifiers, 94, "private") != null;
                boolean allowsOverloading = this.language == 5;
                TapList<FunctionDecl> prevDecls = contextSymbolTable.getTopFunctionDecl(funcNameString, returnTypeSpec, argumentsTypes, classNameString, allowsOverloading);
                if (prevDecls == null && this.callGraph.interfaceUnits() != null) {
                    TapList<Unit> interfaceUnits = this.callGraph.interfaceUnits();
                    while (interfaceUnits != null) {
                        if (((Unit)interfaceUnits.head).name.equals(this.unit.name)) {
                            SymbolDecl prevInterfaceDecl = ((Unit)interfaceUnits.head).enclosingUnitOfInterface.publicSymbolTable().getDecl(this.unit.name, 3, true);
                            if (prevInterfaceDecl == null) {
                                prevInterfaceDecl = ((Unit)interfaceUnits.head).enclosingUnitOfInterface.privateSymbolTable().getDecl(this.unit.name, 3, true);
                            }
                            if (prevInterfaceDecl != null) {
                                prevDecls = new TapList<FunctionDecl>((FunctionDecl)prevInterfaceDecl, prevDecls);
                            }
                        }
                        interfaceUnits = interfaceUnits.tail;
                    }
                }
                if (prevDecls == null && this.language == 1 && contextSymbolTable.basisSymbolTable().isFormalParamsLevel()) {
                    prevDecls = contextSymbolTable.basisSymbolTable().getTopFunctionDecl(funcNameString, returnTypeSpec, argumentsTypes, false);
                }
                if (prevDecls == null && !isStatic) {
                    prevDecls = this.callGraph.languageRootSymbolTable(this.language).getTopFunctionDecl(funcNameString, returnTypeSpec, argumentsTypes, false);
                }
                if (prevDecls == null && TapEnv.inputLanguage() == 100) {
                    prevDecls = this.callGraph.languageRootSymbolTable(this.language == 4 ? 1 : 4).getFunctionDecl(funcNameString, returnTypeSpec, argumentsTypes, false);
                }
                this.unit.setFunctionTypeSpec(new FunctionTypeSpec(returnTypeSpec, (WrapperTypeSpec[])argumentsTypes, variableArgList));
                while (prevDecls != null) {
                    FunctionDecl prevDecl = (FunctionDecl)prevDecls.head;
                    if (prevDecl != null && prevDecl.unit() != null) {
                        if (prevDecl.isStandard()) {
                            if (this.unit.isInterface()) {
                                if (prevDecl.functionTypeSpec().returnType.wrappedType != null && this.unit.functionTypeSpec().returnType.wrappedType != null && !prevDecl.functionTypeSpec().returnType.equalsCompilDep(this.unit.functionTypeSpec().returnType)) {
                                    TapEnv.fileWarning(15, funcNameTree, "(TC90) Type mismatch for result of function " + this.unit.name + " declared in interface " + this.unit.functionTypeSpec().returnType.showType() + ",previously given " + prevDecl.functionTypeSpec().returnType.showType() + " (ignored new)");
                                }
                                keepUnit = false;
                                standardUnit = prevDecl.unit();
                            } else if (this.unit.isIntrinsic() || fromLib) {
                                keepUnit = true;
                            } else if (prevDecl.unit().upperLevelUnit() != this.unit.upperLevelUnit() || prevDecl.isInterface() || this.unit.isInterface()) {
                                keepUnit = true;
                                if (TapEnv.sameLanguageFamily(prevDecl.unit().language(), this.language) && prevDecl.unit().upperLevelUnit().isTranslationUnit() && this.unit.upperLevelUnit().isTranslationUnit()) {
                                    TapEnv.fileWarning(15, funcNameTree, "(DD35) Multiple definition of procedure " + this.unit.name);
                                    keepUnit = false;
                                }
                            } else if (!TapEnv.sameLanguageFamily(prevDecl.unit().language(), this.language)) {
                                keepUnit = true;
                            } else {
                                if (!this.unit.isInterface() && this.language != 5) {
                                    TapEnv.toolWarning(-1, "Could not build the flow graph of unit " + this.unit.name);
                                }
                                keepUnit = false;
                            }
                        } else if (prevDecl.isInterface()) {
                            if (prevDecl.unit().enclosingUnitOfInterface == this.unit.upperLevelUnit()) {
                                TapEnv.fileWarning(15, funcNameTree, "(DD21) Procedure " + prevDecl.unit().name + " defined in interface body clashes with internal procedure defined in " + this.unit.upperLevelUnit().name);
                            }
                            if (prevDecl.functionTypeSpec().returnType.wrappedType != null && this.unit.functionTypeSpec().returnType.wrappedType != null && !prevDecl.functionTypeSpec().returnType.equalsCompilDep(this.unit.functionTypeSpec().returnType)) {
                                TapEnv.fileWarning(15, funcNameTree, "(TC91) Type mismatch for result of function " + this.unit.name + " declared " + this.unit.functionTypeSpec().returnType.showType() + ",previously given in interface " + prevDecl.functionTypeSpec().returnType.showType());
                            }
                            this.callGraph.setPreviousFunctionDeclAndNewUnit(prevDecl, this.unit);
                            keepUnit = true;
                        } else if (prevDecl.isExternal()) {
                            if (!(fromLib && prevDecl.unit().isCorMore() && this.unit.isCorMore() || !TapEnv.sameLanguageFamily(prevDecl.unit().language(), this.language))) {
                                boolean protoMatches = this.unit.functionTypeSpec().receives(prevDecl.functionTypeSpec(), null, null);
                                if (!protoMatches && this.unit.isCorMore()) {
                                    FunctionTypeSpec protoType = prevDecl.functionTypeSpec();
                                    boolean bl = protoMatches = protoType != null && (protoType.argumentsTypes == null || protoType.argumentsTypes.length == 0) && this.unit.functionTypeSpec().returnType != null && this.unit.functionTypeSpec().returnType.equalsCompilDep(protoType.returnType);
                                }
                                if (protoMatches) {
                                    Unit oldUnit = prevDecl.unit();
                                    if (oldUnit.getForwardDeclaration() != null) {
                                        this.unit.setForwardDeclaration(oldUnit.getForwardDeclaration());
                                    }
                                    this.callGraph.setPreviousFunctionDeclAndNewUnit(prevDecl, this.unit);
                                } else {
                                    TapEnv.fileWarning(15, funcNameTree, "(TC92) Incompatible declaration of function prototype or interface " + this.unit.name);
                                }
                            }
                            keepUnit = true;
                        }
                    }
                    prevDecls = prevDecls.tail;
                }
                FunctionDecl tmpFunctionDecl = new FunctionDecl(funcNameTree, standardUnit, contextSymbolTable, classNameString);
                SymbolDecl prevSymbolDecl = contextSymbolTable.getSymbolDecl(ILUtils.getIdentString(funcNameTree));
                if (prevSymbolDecl != null) {
                    tmpFunctionDecl.addExtraInfo(prevSymbolDecl.extraInfo());
                }
                if (!this.unit.isTopInFile() && this.unit.upperLevelUnit().fortranStuff() != null && this.unit.upperLevelUnit().fortranStuff().publicPrivateDefault != null) {
                    String defaultPublicPrivate = this.unit.upperLevelUnit().fortranStuff().publicPrivateDefault;
                    tmpFunctionDecl.addExtraInfo(new TapList<String>(defaultPublicPrivate, null));
                } else if (!this.unit.isTopInFile() && !this.unit.upperLevelUnit().privacy.isEmpty()) {
                    tmpFunctionDecl.addExtraInfo(new TapList<String>(this.unit.upperLevelUnit().privacy, null));
                }
                TapTriplet<FunctionDecl, Unit, TapPair<FunctionDecl, SymbolTable>> previous = this.callGraph.getPreviousFunctionDeclAndNewUnit(funcNameString);
                if (previous != null && !((FunctionDecl)previous.first).unit().isInterface()) {
                    this.callGraph.addNewFunctionDecl(tmpFunctionDecl, contextSymbolTable);
                } else {
                    SymbolDecl declAsFormalParam;
                    Unit upperUnit;
                    SymbolTable hostingSymbolTable = FlowGraphBuilder.findHostingSymbolTable(contextSymbolTable, null, modifiers);
                    if ((this.unit.isInterface() || this.unit.isExternal()) && (upperUnit = this.unit.enclosingUnitOfInterface) != null && upperUnit.isStandard() && (declAsFormalParam = upperUnit.publicSymbolTable().getTopSymbolDecl(this.unit.name)) != null) {
                        hostingSymbolTable = upperUnit.publicSymbolTable();
                    }
                    hostingSymbolTable.addSymbolDecl(tmpFunctionDecl);
                }
                if (otherReturnVarDecl != null && tmpFunctionDecl.unit() != null) {
                    tmpFunctionDecl.unit().setOtherReturnVar(otherReturnVarDecl);
                    otherReturnVarDecl.setReturnVar(tmpFunctionDecl);
                }
                if (this.unit.modifiers != null && this.unit.modifiers.opCode() == 1) {
                    String cName = this.unit.name;
                    if (this.unit.modifiers.down(2).length() == 2 && this.unit.modifiers.down(2).down(2).opCode() == 132) {
                        cName = this.unit.modifiers.down(2).down(2).down(2).stringValue();
                    }
                    this.callGraph.addBindFortranCFunction(this.unit.name, cName, tmpFunctionDecl);
                }
                bodySymbolTable = new SymbolTable(unitSymbolTable);
                bodySymbolTable.setShortName("Local variables SymbolTable of procedure " + this.unit.name);
                bodySymbolTable.unit = this.unit;
                this.unit.addDerivedSymbolTable(bodySymbolTable);
                this.unit.setPrivateSymbolTable(bodySymbolTable);
            }
        }
        if (!keepUnit) {
            this.pushUnitWillBeDeleted();
        }
        FGThreads threads = new FGThreads();
        this.curParallelControls = null;
        if (this.unit.isModule() || this.unit.isClass()) {
            int nbParts = this.entryBlock.maxEntryRank();
            threads.add(this.entryBlock, -1, nbParts + 1);
            threads.convergeToBlock(centralBlock, false, this.traceOn);
            threads.empty();
            threads.add(centralBlock, 0, 0);
        } else if (this.unit.isConstructor()) {
            threads.add(this.entryBlock, -1, 1);
            InitConstructorBlock initConstructorBlock = new InitConstructorBlock(unitSymbolTable, this.allBlocks);
            this.unit.setInitConstructorBlock(initConstructorBlock);
            threads.convergeToBlock(initConstructorBlock, false, this.traceOn);
            threads.empty();
            threads.add(initConstructorBlock, 0, 0);
            this.treeStream2FlowGraph(threads, unitSymbolTable);
        } else {
            threads.add(this.entryBlock, -1, 1);
        }
        this.treeStream2FlowGraph(threads, bodySymbolTable);
        if (!keepUnit) {
            this.popUnitWillBeDeleted();
        }
        if (!keepUnit) {
            if (!this.unit.isInterface() && this.language != 5) {
                TapEnv.toolWarning(-1, "Could not build the flow graph of unit " + this.unit.name);
            }
            this.callGraph.deleteUnit(this.unit);
            this.unit = null;
        } else {
            threads.convergeToBlock(this.exitBlock, false, this.traceOn);
            if (this.commentsWaiting2.first != null) {
                this.unit.setLostComments(TapList.append((TapList)this.commentsWaiting2.first, this.unit.lostComments()));
            }
            if (this.commentsWaiting2.second != null) {
                this.unit.setLostComments(TapList.append((TapList)this.commentsWaiting2.second, this.unit.lostComments()));
            }
            this.analyzeAssGoto();
            this.labelHeap.undefinedLabels(this.exitBlock, unitSymbolTable);
            this.unit.makeFlowGraph(this.entryBlock, this.allBlocks.tail, this.exitBlock, false);
            this.callGraph.absorbAndDeleteAfterCreateNewUnit();
            this.unit.exportFunctionTypeSpec();
            this.callGraph.resetPreviousFunctionDeclAndNewUnit();
        }
        if (TapEnv.traceInputIL()) {
            switch (unitCode) {
                case 26: 
                case 52: 
                case 74: {
                    break;
                }
                case 129: {
                    for (int jj = 0; jj < fgbDepth; ++jj) {
                        TapEnv.printOnTrace(" ");
                    }
                    TapEnv.printlnOnTrace("<-- [" + fgbDepth + "] module " + this.unit);
                    break;
                }
                case 35: {
                    for (int jj = 0; jj < fgbDepth; ++jj) {
                        TapEnv.printOnTrace(" ");
                    }
                    TapEnv.printlnOnTrace("<-- [" + fgbDepth + "] class " + this.unit);
                    break;
                }
                case 55: {
                    for (int jj = 0; jj < fgbDepth; ++jj) {
                        TapEnv.printOnTrace(" ");
                    }
                    TapEnv.printlnOnTrace("<-- [" + fgbDepth + "] destructor " + this.unit);
                    break;
                }
                case 45: {
                    for (int jj = 0; jj < fgbDepth; ++jj) {
                        TapEnv.printOnTrace(" ");
                    }
                    TapEnv.printlnOnTrace("<-- [" + fgbDepth + "] constructor " + this.unit);
                    break;
                }
                default: {
                    for (int jj = 0; jj < fgbDepth; ++jj) {
                        TapEnv.printOnTrace(" ");
                    }
                    TapEnv.printlnOnTrace("<-- [" + fgbDepth + "] function " + this.unit);
                }
            }
        }
        TapEnv.popRelatedUnit();
    }

    private boolean traceOn(String unitName) {
        return TapEnv.traceFlowGraphBuild() != null && (((String)TapEnv.traceFlowGraphBuild().head).equals("%all%") || TapList.containsEquals(TapEnv.traceFlowGraphBuild(), unitName));
    }

    private void treeStream2FlowGraph(FGThreads threads, SymbolTable readySymbolTable) throws IOException {
        Instruction newInstr;
        Tree annotationTree;
        String annotationName;
        TapPair<Object, Object> preComments2 = new TapPair<Object, Object>(null, null);
        TapPair<Object, Object> postComments2 = new TapPair<Object, Object>(null, null);
        while (this.inputTreeStream.seeOperator().code == 6) {
            boolean doInclude;
            Tree includeCommand;
            this.inputTreeStream.readOperator();
            annotationName = this.inputTreeStream.readString();
            annotationTree = this.inputTreeStream.readTree();
            if (TapEnv.inStdCIncludeFile() && !annotationName.equals("include") || TapEnv.isCorMore(this.language) && !annotationTree.isAtom() && annotationTree.down(1).stringValue().startsWith("#pragma GCC set_debug_pwd")) continue;
            if (annotationName.equals("preComments")) {
                if (preComments2.first == null) {
                    preComments2.first = annotationTree;
                    continue;
                }
                ILUtils.appendComments((Tree)preComments2.first, annotationTree);
                continue;
            }
            if (annotationName.equals("postComments")) {
                if (postComments2.first == null) {
                    postComments2.first = annotationTree;
                    continue;
                }
                ILUtils.appendComments((Tree)postComments2.first, annotationTree);
                continue;
            }
            if (annotationName.equals("preCommentsBlock")) {
                if (preComments2.second == null) {
                    preComments2.second = annotationTree;
                    continue;
                }
                ILUtils.appendCommentsBlock((Tree)preComments2.second, annotationTree);
                continue;
            }
            if (annotationName.equals("postCommentsBlock")) {
                if (postComments2.second == null) {
                    postComments2.second = annotationTree;
                    continue;
                }
                ILUtils.appendCommentsBlock((Tree)postComments2.second, annotationTree);
                continue;
            }
            if (!annotationName.equals("include")) continue;
            if (this.unit.isC() && ILUtils.stopInclude(annotationTree, "tapenade end #include") && this.unit.fromInclude() != null) {
                this.unit.setFromInclude(null);
            }
            boolean bl = (includeCommand = TapEnv.getIncludeTree(annotationTree)) == null ? TapEnv.get().includeFiles != null && TapEnv.enclosingIncludeIsEmptyOr(annotationTree) : (doInclude = TapEnv.checkAndUpdateTapEnvInclude(includeCommand) && (!TapEnv.get().expandAllIncludeFile || TapEnv.isStdIncludeName(includeCommand.stringValue())));
            if (doInclude && includeCommand != null && TapList.containsEquals(TapEnv.includeFileList(), includeCommand.stringValue()) && !this.unit.isTranslationUnit()) {
                doInclude = false;
                TapEnv.checkAndUpdateTapEnvInclude(null);
            }
            if (!doInclude) continue;
            if (preComments2.first != null) {
                this.commentsWaiting2.first = TapList.append((TapList)this.commentsWaiting2.first, ((Tree)preComments2.first).childrenList());
                preComments2.first = null;
            }
            if (preComments2.second != null) {
                this.commentsWaiting2.second = TapList.append((TapList)this.commentsWaiting2.second, ((Tree)preComments2.second).childrenList());
                preComments2.second = null;
            }
            if (includeCommand != null) {
                String includeName = includeCommand.stringValue();
                if (!TapEnv.isStdIncludeName(includeName)) {
                    TapEnv.addInIncludeFileList(includeName);
                }
                newInstr = this.addInstructionTree(includeCommand, postComments2, this.commentsWaiting2, threads, true);
                assert (newInstr != null);
                if (includeCommand.equalsTree(TapEnv.currentIncludeInstruction().tree)) {
                    TapEnv.currentIncludeInstruction().preComments = newInstr.preComments;
                    TapEnv.currentIncludeInstruction().preCommentsBlock = newInstr.preCommentsBlock;
                    TapEnv.currentIncludeInstruction().postComments = newInstr.postComments;
                    TapEnv.currentIncludeInstruction().postCommentsBlock = newInstr.postCommentsBlock;
                }
                newInstr.setFromIncludeCopy(TapEnv.currentIncludeInstruction(), false);
            } else {
                TapEnv.updateTapEnvInclude(null);
            }
            this.commentsWaiting2.first = null;
            this.commentsWaiting2.second = null;
            preComments2.first = null;
            preComments2.second = null;
            postComments2.first = null;
            postComments2.second = null;
        }
        if (preComments2.first != null) {
            this.commentsWaiting2.first = TapList.append((TapList)this.commentsWaiting2.first, ((Tree)preComments2.first).childrenList());
            preComments2.first = null;
        }
        if (preComments2.second != null) {
            this.commentsWaiting2.second = TapList.append((TapList)this.commentsWaiting2.second, ((Tree)preComments2.second).childrenList());
            preComments2.second = null;
        }
        if (this.labelAbovePostComments != null) {
            postComments2.first = ILUtils.appendComments((Tree)postComments2.first, this.labelAbovePostComments);
            this.labelAbovePostComments = null;
        }
        switch (this.inputTreeStream.seeOperator().code) {
            case 99: {
                Tree includeTree = this.inputTreeStream.readTree();
                TapEnv.setInIncludeFile(includeTree);
                break;
            }
            case 35: 
            case 45: 
            case 55: 
            case 87: 
            case 129: 
            case 154: {
                if (this.unitWillBeDeleted()) {
                    this.inputTreeStream.readTree();
                    break;
                }
                int opCode = this.inputTreeStream.seeOperator().code;
                Unit subUnit = this.callGraph.createNewUnit(this.unit, this.language);
                try {
                    ++fgbDepth;
                    subUnit = FlowGraphBuilder.build(this.inputTreeStream, this.curSymbolTable, this.callGraph, this.language, subUnit, false);
                    --fgbDepth;
                }
                catch (IOException exception) {
                    --fgbDepth;
                    this.callGraph.deleteUnit(subUnit);
                    this.callGraph.deleteUnitFromSymbolTable(subUnit);
                    throw exception;
                }
                if (subUnit == null) break;
                subUnit.preComments = this.commentsWaiting2.first == null ? null : ILUtils.build(36, ILUtils.collectCommentStrings((TapList)this.commentsWaiting2.first));
                this.commentsWaiting2.first = null;
                subUnit.preCommentsBlock = this.commentsWaiting2.second == null ? null : ILUtils.build(37, ILUtils.collectCommentStrings((TapList)this.commentsWaiting2.second));
                this.commentsWaiting2.second = null;
                subUnit.postComments = postComments2.first == null ? null : ILUtils.build(36, ILUtils.collectCommentStrings((Tree)postComments2.first));
                postComments2.first = null;
                subUnit.postCommentsBlock = postComments2.second == null ? null : ILUtils.build(37, ILUtils.collectCommentStrings((Tree)postComments2.second));
                postComments2.second = null;
                subUnit.specificInfoAD = null;
                subUnit.setTranslationUnitSymbolTable(TapEnv.currentTranslationUnitSymbolTable());
                if (opCode == 154 || opCode == 87 && TapEnv.isCorMore(this.language) && subUnit.name.equals("main")) {
                    if (this.callGraph.getMainUnit() != null) {
                        TapEnv.fileWarning(15, null, "(DD10) Double declaration of the main program: " + this.callGraph.getMainUnit().name + " and " + subUnit.name + " (overwritten previous)");
                    }
                    this.callGraph.setMainUnit(subUnit);
                }
                if (subUnit.isModule() || subUnit.isClass()) {
                    TapList<SymbolDecl> protectedSymbolDecls;
                    TapList<SymbolDecl> publicSymbolDecls = subUnit.privateSymbolTable().findPublicSymbolDecls();
                    if (publicSymbolDecls != null) {
                        TapList<SymbolDecl> inSymbolDecls = publicSymbolDecls;
                        while (inSymbolDecls != null) {
                            if (((SymbolDecl)inSymbolDecls.head).isA(3)) {
                                ((FunctionDecl)inSymbolDecls.head).definitionSymbolTable = subUnit.publicSymbolTable();
                            } else if (((SymbolDecl)inSymbolDecls.head).isA(16)) {
                                ((InterfaceDecl)inSymbolDecls.head).definitionSymbolTable = subUnit.publicSymbolTable();
                            }
                            inSymbolDecls = inSymbolDecls.tail;
                        }
                        subUnit.privateSymbolTable().moveSymbolDeclListUpRec(publicSymbolDecls, subUnit.publicSymbolTable());
                    }
                    if ((protectedSymbolDecls = subUnit.privateSymbolTable().findProtectedSymbolDecls()) != null) {
                        TapList<SymbolDecl> inSymbolDecls = protectedSymbolDecls;
                        while (inSymbolDecls != null) {
                            if (((SymbolDecl)inSymbolDecls.head).isA(3)) {
                                ((FunctionDecl)inSymbolDecls.head).definitionSymbolTable = subUnit.protectedSymbolTable();
                            } else if (((SymbolDecl)inSymbolDecls.head).isA(16)) {
                                ((InterfaceDecl)inSymbolDecls.head).definitionSymbolTable = subUnit.protectedSymbolTable();
                            }
                            inSymbolDecls = inSymbolDecls.tail;
                        }
                        subUnit.privateSymbolTable().moveSymbolDeclListUpRec(protectedSymbolDecls, subUnit.protectedSymbolTable());
                    }
                }
                if (TapEnv.inStdCIncludeFile()) break;
                Tree instructionTree = Instruction.createUnitDefinitionStubTree(subUnit);
                if (subUnit.isClass()) {
                    instructionTree.setAnnotation("UnitPart", subUnit.entryBlock().maxEntryRank());
                }
                this.addInstructionTree(instructionTree, postComments2, this.commentsWaiting2, threads, true);
                break;
            }
            case 91: {
                this.inputTreeStream.readOperator();
                int position = this.inputTreeStream.position();
                this.inputTreeStream.readOperator();
                threads.convergeToBlock(this.labelHeap.getSetLabelled(this.inputTreeStream.readString(), this.allBlocks, false, null), false, this.traceOn);
                threads.empty();
                break;
            }
            case 92: {
                Tree instructionTree = this.inputTreeStream.readTree();
                this.newLabelVar(ILUtils.gotoLabelVar(instructionTree));
                this.addInstructionTree(instructionTree, postComments2, this.commentsWaiting2, threads, false);
                threads.empty();
                break;
            }
            case 14: {
                Tree instructionTree = this.inputTreeStream.readTree();
                this.newLabelVar(ILUtils.assignedLabelVar(instructionTree));
                this.addInstructionTree(instructionTree, postComments2, this.commentsWaiting2, threads, false);
                break;
            }
            case 110: {
                TapList<String> labelsList;
                this.inputTreeStream.readOperator();
                int position = this.inputTreeStream.position();
                Tree labelsTree = this.inputTreeStream.readTree();
                if (labelsTree.opCode() == 111) {
                    Tree[] labels;
                    labelsList = null;
                    for (Tree label : labels = labelsTree.children()) {
                        labelsList = new TapList<String>(label.stringValue(), labelsList);
                    }
                } else {
                    labelsList = new TapList<String>(labelsTree.stringValue(), null);
                }
                Block block = null;
                while (labelsList != null) {
                    if (block == null) {
                        block = this.labelHeap.getSetLabelled((String)labelsList.head, this.allBlocks, true, labelsTree);
                    } else {
                        this.labelHeap.fuseLabelled((String)labelsList.head, block, labelsTree);
                    }
                    labelsList = labelsList.tail;
                }
                if (block != null) {
                    block.symbolTable = this.curSymbolTable;
                    threads.convergeToBlock(block, false, this.traceOn);
                    threads.empty();
                    threads.add(block, 0, 0);
                }
                this.labelAbovePostComments = (Tree)postComments2.first;
                postComments2.first = null;
                this.treeStream2FlowGraph(threads, null);
                break;
            }
            case 39: {
                int position = this.inputTreeStream.position() + 1;
                Tree instructionTree = this.inputTreeStream.readTree();
                ILUtils.setPosition(instructionTree, position);
                newInstr = this.addInstructionTree(instructionTree, postComments2, this.commentsWaiting2, threads, false);
                if (newInstr == null) break;
                if (instructionTree.down(1).opCode() == 111) {
                    Tree[] labels = instructionTree.down(1).children();
                    ++position;
                    for (int i = 0; i < labels.length; ++i) {
                        threads.reTypeThread(10, i + 1);
                        threads.convergeToBlock(this.labelHeap.getSetLabelled(labels[i].stringValue(), this.allBlocks, false, instructionTree), false, this.traceOn);
                    }
                } else {
                    TapEnv.fileWarning(15, instructionTree, "(CF02) Computed-GOTO without legal destinations list");
                }
                threads.reTypeThread(10, -1);
                break;
            }
            case 96: {
                FGThreads thenThreads = new FGThreads();
                FGThreads elseThreads = new FGThreads();
                this.inputTreeStream.readOperator();
                int position = this.inputTreeStream.position();
                Tree testExpression = this.inputTreeStream.readTree();
                Tree ifTestInstruction = ILUtils.build(96, testExpression);
                ILUtils.setPosition(ifTestInstruction, position);
                newInstr = this.addInstructionTree(ifTestInstruction, null, this.commentsWaiting2, threads, false);
                Instruction oldSCInstruction = this.curSCInstruction;
                this.curSCInstruction = newInstr;
                boolean notEmpty = threads.isNotEmpty();
                if (notEmpty) {
                    thenThreads.add(threads.block(), 20, 2);
                }
                this.treeStream2FlowGraph(thenThreads, null);
                if (notEmpty) {
                    elseThreads.add(threads.block(), 20, 5);
                }
                this.treeStream2FlowGraph(elseThreads, null);
                threads.empty();
                threads.concat(thenThreads);
                threads.concat(elseThreads);
                this.curSCInstruction = oldSCInstruction;
                break;
            }
            case 200: {
                this.inputTreeStream.readOperator();
                Tree localTest = this.inputTreeStream.readTree();
                Tree instructionTree = ILUtils.build(200, localTest);
                InstructionMask oldWhereMask = this.whereMask;
                this.whereMask = new InstructionMask(localTest, this.whereMask);
                this.addInstructionTree(instructionTree, postComments2, this.commentsWaiting2, threads, false);
                this.treeStream2FlowGraph(threads, null);
                this.whereMask = this.whereMask.createElseMask();
                this.treeStream2FlowGraph(threads, null);
                Tree namedWhere = this.inputTreeStream.readTree();
                if (namedWhere.opCode() != 136) {
                    localTest.setAnnotation("namedWhere", namedWhere);
                }
                this.whereMask = oldWhereMask;
                break;
            }
            case 179: {
                TapList<Object> hdListTreeCase;
                int caseNumber = -1;
                TapList<Object> tlListTreeCase = hdListTreeCase = new TapList<Object>(null, null);
                Tree defaultTreeCase = null;
                Block switchBlock = null;
                this.inputTreeStream.readOperator();
                int position = this.inputTreeStream.position();
                Tree switchTestInstruction = ILUtils.build(179, this.inputTreeStream.readTree());
                ILUtils.setPosition(switchTestInstruction, position);
                newInstr = this.addInstructionTree(switchTestInstruction, postComments2, this.commentsWaiting2, threads, false);
                Instruction oldSCInstruction = this.curSCInstruction;
                this.curSCInstruction = newInstr;
                this.inputTreeStream.readOperator();
                boolean notEmpty = threads.isNotEmpty();
                if (notEmpty) {
                    switchBlock = threads.block();
                }
                threads.empty();
                boolean foundDefault = false;
                ControlJumpInfo switchJumpInfo = new ControlJumpInfo(179, null, null);
                this.nestedControlStack = new TapList<ControlJumpInfo>(switchJumpInfo, this.nestedControlStack);
                while (this.inputTreeStream.seeOperator().code != 64) {
                    while (this.inputTreeStream.seeOperator().code == 6) {
                        this.inputTreeStream.readOperator();
                        annotationName = this.inputTreeStream.readString();
                        annotationTree = this.inputTreeStream.readTree();
                        if (annotationName.equals("preComments")) {
                            if (preComments2.first == null) {
                                preComments2.first = annotationTree;
                                continue;
                            }
                            ILUtils.appendComments((Tree)preComments2.first, annotationTree);
                            continue;
                        }
                        if (annotationName.equals("postComments")) {
                            if (postComments2.first == null) {
                                postComments2.first = annotationTree;
                                continue;
                            }
                            ILUtils.appendComments((Tree)postComments2.first, annotationTree);
                            continue;
                        }
                        if (annotationName.equals("preCommentsBlock")) {
                            if (preComments2.second == null) {
                                preComments2.second = annotationTree;
                                continue;
                            }
                            ILUtils.appendCommentsBlock((Tree)preComments2.second, annotationTree);
                            continue;
                        }
                        if (!annotationName.equals("postCommentsBlock")) continue;
                        if (postComments2.second == null) {
                            postComments2.second = annotationTree;
                            continue;
                        }
                        ILUtils.appendCommentsBlock((Tree)postComments2.second, annotationTree);
                    }
                    if (preComments2.first != null) {
                        this.commentsWaiting2.first = TapList.append((TapList)this.commentsWaiting2.first, ((Tree)preComments2.first).childrenList());
                        preComments2.first = null;
                    }
                    if (preComments2.second != null) {
                        this.commentsWaiting2.second = TapList.append((TapList)this.commentsWaiting2.second, ((Tree)preComments2.second).childrenList());
                        preComments2.second = null;
                    }
                    this.inputTreeStream.readOperator();
                    Tree exprTree = this.inputTreeStream.readTree();
                    boolean caseIsDefault = exprTree.children().length == 0;
                    exprTree = ILUtils.build(180, exprTree, ILUtils.build(26));
                    if (caseIsDefault) {
                        defaultTreeCase = exprTree;
                    } else {
                        tlListTreeCase = tlListTreeCase.placdl(exprTree);
                    }
                    if (notEmpty) {
                        if (caseIsDefault) {
                            foundDefault = true;
                            threads.add(switchBlock, 21, -1);
                        } else {
                            threads.add(switchBlock, 21, ++caseNumber);
                        }
                    }
                    this.treeStream2FlowGraph(threads, null);
                }
                this.inputTreeStream.readOperator();
                if (defaultTreeCase != null) {
                    tlListTreeCase = tlListTreeCase.placdl(defaultTreeCase);
                }
                switchTestInstruction.setChild(ILUtils.build(181, hdListTreeCase.tail), 2);
                threads.concat(switchJumpInfo.threadsToAfter);
                if (!foundDefault) {
                    threads.add(switchBlock, 21, -2);
                }
                this.nestedControlStack = this.nestedControlStack.tail;
                this.curSCInstruction = oldSCInstruction;
                break;
            }
            case 142: 
            case 143: {
                Operator parallelOperator = this.inputTreeStream.readOperator();
                int position = this.inputTreeStream.position();
                Tree dialectNameTree = this.inputTreeStream.readTree();
                Tree clausesTree = this.inputTreeStream.readTree();
                Tree regionHeader = ILUtils.build(parallelOperator.code, dialectNameTree, clausesTree);
                Instruction regionHeaderInstruction = this.addInstructionTree(regionHeader, postComments2, this.commentsWaiting2, threads, false);
                ILUtils.setPosition(regionHeader, position);
                Block regionHeaderBlock = threads.block();
                threads.empty();
                threads.add(regionHeaderBlock, 0, 0);
                Instruction oldSCInstruction = this.curSCInstruction;
                this.curSCInstruction = regionHeaderInstruction;
                this.curParallelControls = new TapList<Instruction>(regionHeaderInstruction, this.curParallelControls);
                this.treeStream2FlowGraph(threads, null);
                this.curParallelControls = this.curParallelControls.tail;
                this.curSCInstruction = oldSCInstruction;
                break;
            }
            case 119: {
                FGThreads bodyThreads = new FGThreads();
                SymbolTable prevSymbolTable = null;
                this.inputTreeStream.readOperator();
                int position = this.inputTreeStream.position();
                Tree loopNameTree = this.inputTreeStream.readTree();
                String loopName = ILUtils.getIdentString(loopNameTree);
                String loopLabel = ILUtils.getIdentString(this.inputTreeStream.readTree());
                if (this.allBlocks.tail == null) {
                    Tree instructionTree = ILUtils.build(136);
                    this.addInstructionTree(instructionTree, postComments2, this.commentsWaiting2, threads, true);
                }
                if (threads.isNotEmpty() && (this.containsIIloop((TapList)this.commentsWaiting2.first) || this.containsIIloop((TapList)this.commentsWaiting2.second))) {
                    threads.convergeToInstr(new Instruction(ILUtils.build(48), this.curSCInstruction), this.allBlocks, this.unit, this.curSymbolTable, this.curParallelControls, this.traceOn);
                }
                HeaderBlock headerBlock = new HeaderBlock(null, this.curParallelControls, this.allBlocks);
                Tree loopExpression = this.inputTreeStream.readTree();
                Tree loopInstruction = ILUtils.build(119, loopNameTree, null, loopExpression, null);
                ILUtils.setPosition(loopInstruction, position);
                newInstr = new Instruction(loopInstruction, this.curSCInstruction);
                FlowGraphBuilder.attachComments(newInstr, loopInstruction, null, this.commentsWaiting2);
                headerBlock.addInstrTl(newInstr);
                if (loopExpression.opCode() == 77 && loopExpression.down(1).opCode() == 194) {
                    headerBlock.declaresItsIterator = true;
                    prevSymbolTable = this.curSymbolTable;
                    this.curSymbolTable = new SymbolTable(this.curSymbolTable);
                    this.curSymbolTable.setShortName("Local forvar SymbolTable on top of " + prevSymbolTable.shortName());
                    this.curSymbolTable.unit = this.unit;
                    this.unit.addDerivedSymbolTable(this.curSymbolTable);
                    newInstr = new Instruction(loopExpression.down(1));
                    this.curSymbolTable.addVarDeclaration(loopExpression.down(1), newInstr, true, null);
                    this.curSymbolTable.declarationsBlock = headerBlock;
                }
                headerBlock.symbolTable = this.curSymbolTable;
                threads.convergeToBlock(headerBlock, false, this.traceOn);
                Instruction oldSCInstruction = this.curSCInstruction;
                this.curSCInstruction = newInstr;
                ControlJumpInfo loopJumpInfo = new ControlJumpInfo(119, loopLabel, loopName);
                this.nestedControlStack = new TapList<ControlJumpInfo>(loopJumpInfo, this.nestedControlStack);
                bodyThreads.add(headerBlock, 30, 1);
                this.treeStream2FlowGraph(bodyThreads, null);
                bodyThreads.convergeToBlock(headerBlock, true, this.traceOn);
                loopJumpInfo.threadsToCycle.convergeToBlock(headerBlock, true, this.traceOn);
                threads.empty();
                threads.concat(loopJumpInfo.threadsToAfter);
                if (loopExpression.opCode() != 136) {
                    threads.add(headerBlock, 30, 0);
                }
                this.nestedControlStack = this.nestedControlStack.tail;
                this.curSCInstruction = oldSCInstruction;
                if (prevSymbolTable == null) break;
                this.curSymbolTable = prevSymbolTable;
                break;
            }
            case 69: {
                this.inputTreeStream.readOperator();
                this.declareLoopBreak(this.inputTreeStream.readTree(), threads);
                threads.empty();
                break;
            }
            case 49: {
                this.inputTreeStream.readOperator();
                this.declareLoopCycle(this.inputTreeStream.readTree(), threads);
                threads.empty();
                break;
            }
            case 29: {
                this.inputTreeStream.readOperator();
                this.declareControlBreak(threads);
                threads.empty();
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 13: 
            case 18: 
            case 22: 
            case 24: 
            case 31: 
            case 46: 
            case 60: 
            case 62: 
            case 70: 
            case 73: 
            case 94: 
            case 97: 
            case 101: 
            case 115: 
            case 123: 
            case 125: 
            case 147: 
            case 148: 
            case 155: 
            case 165: 
            case 168: 
            case 175: 
            case 178: 
            case 185: 
            case 189: {
                Tree instructionTree = this.inputTreeStream.readTree();
                this.addInstructionTree(instructionTree, postComments2, this.commentsWaiting2, threads, false);
                break;
            }
            case 30: {
                Tree instructionTree = this.inputTreeStream.readTree();
                newInstr = this.addInstructionTree(instructionTree, postComments2, this.commentsWaiting2, threads, false);
                if (newInstr == null) break;
                this.checkAlternativeReturn(threads, ILUtils.getArguments(instructionTree).children());
                break;
            }
            case 107: {
                Tree instructionTree = this.inputTreeStream.readTree();
                this.addInstructionTree(instructionTree, postComments2, this.commentsWaiting2, threads, false);
                this.checkNameEq(threads, instructionTree.down(2).children());
                break;
            }
            case 82: {
                int position = this.inputTreeStream.position() + 1;
                Tree instructionTree = this.inputTreeStream.readTree();
                FlowGraphBuilder.attachComments(null, instructionTree, postComments2, this.commentsWaiting2);
                String formatLabel = instructionTree.down(1).stringValue();
                this.labelHeap.checkFormatLabel(formatLabel, instructionTree);
                if (!TapList.containsEquals(this.formatLabels, formatLabel)) {
                    this.formatLabels = new TapList<String>(formatLabel, this.formatLabels);
                }
                this.unit.addFormatTree(instructionTree);
                break;
            }
            case 48: {
                Tree instructionTree = this.inputTreeStream.readTree();
                if (!Directive.containDirectives((TapList)this.commentsWaiting2.first) && !Directive.containDirectives((TapList)this.commentsWaiting2.second)) break;
                this.addInstructionTree(instructionTree, postComments2, this.commentsWaiting2, threads, false);
                break;
            }
            case 163: {
                Tree instructionTree = this.inputTreeStream.readTree();
                newInstr = this.addInstructionTree(instructionTree, postComments2, this.commentsWaiting2, threads, false);
                if (newInstr == null) break;
                threads.convergeToBlock(this.exitBlock, false, this.traceOn);
                threads.empty();
                break;
            }
            case 174: {
                Tree instructionTree = this.inputTreeStream.readTree();
                newInstr = this.addInstructionTree(instructionTree, postComments2, this.commentsWaiting2, threads, false);
                if (newInstr == null) break;
                threads.empty();
                break;
            }
            case 26: 
            case 52: 
            case 74: {
                SymbolTable prevSymbolTable = this.curSymbolTable;
                this.inputTreeStream.readOperator();
                if (readySymbolTable != null) {
                    this.curSymbolTable = readySymbolTable;
                } else {
                    this.curSymbolTable = new SymbolTable(this.curSymbolTable);
                    this.curSymbolTable.setShortName("Local variables SymbolTable on top of " + prevSymbolTable.shortName());
                    this.curSymbolTable.unit = this.unit;
                    this.unit.addDerivedSymbolTable(this.curSymbolTable);
                    if (prevSymbolTable == this.unit.publicSymbolTable()) {
                        this.unit.setPrivateSymbolTable(this.curSymbolTable);
                    }
                }
                while (this.inputTreeStream.seeOperator().code != 64) {
                    this.treeStream2FlowGraph(threads, null);
                }
                this.inputTreeStream.readOperator();
                this.curSymbolTable = prevSymbolTable;
                break;
            }
            case 134: {
                int jj;
                SymbolTable prevSymbolTable = this.curSymbolTable;
                this.inputTreeStream.readOperator();
                int position = this.inputTreeStream.position();
                Tree nameSpaceTree = this.inputTreeStream.readTree();
                Tree nameSpaceInstruction = ILUtils.build(134, nameSpaceTree);
                ILUtils.setPosition(nameSpaceInstruction, position);
                this.addInstructionTree(nameSpaceInstruction, null, this.commentsWaiting2, threads, true);
                if (TapEnv.traceInputIL()) {
                    ++fgbDepth;
                    for (jj = 0; jj < fgbDepth; ++jj) {
                        TapEnv.printOnTrace(" ");
                    }
                    TapEnv.printlnOnTrace("--> [" + fgbDepth + "] nameSpace " + nameSpaceTree);
                }
                this.curSymbolTable = this.curSymbolTable.getSetNameSpaceDecl((Tree)nameSpaceTree).symbolTable;
                this.treeStream2FlowGraph(threads, this.curSymbolTable);
                this.curSymbolTable = prevSymbolTable;
                if (!TapEnv.traceInputIL()) break;
                for (jj = 0; jj < fgbDepth; ++jj) {
                    TapEnv.printOnTrace(" ");
                }
                TapEnv.printlnOnTrace("<-- [" + fgbDepth + "] nameSpace " + nameSpaceTree);
                --fgbDepth;
                break;
            }
            case 44: 
            case 66: 
            case 72: 
            case 156: 
            case 187: 
            case 190: 
            case 194: 
            case 197: {
                Tree instructionTree = this.inputTreeStream.readTree();
                newInstr = this.addInstructionTree(instructionTree, postComments2, this.commentsWaiting2, threads, true);
                if (newInstr.isInStdCInclude()) {
                    TapEnv.switchOnCombineDeclMessages(false);
                }
                SymbolTable hostSymbolTable = this.curSymbolTable;
                if (hostSymbolTable.unit == null && TapEnv.currentTranslationUnitSymbolTable() != null && newInstr.isInStdCInclude()) {
                    hostSymbolTable = this.callGraph.languageRootSymbolTable(this.language);
                }
                ToBool addInstruction = new ToBool(true);
                switch (instructionTree.opCode()) {
                    case 194: {
                        hostSymbolTable.addVarDeclaration(instructionTree, newInstr, true, addInstruction);
                        break;
                    }
                    case 197: {
                        hostSymbolTable.addVarDimDeclaration(instructionTree, newInstr);
                        break;
                    }
                    case 187: {
                        hostSymbolTable.addTypeDeclaration(instructionTree.down(1), instructionTree.down(2), newInstr, null);
                        break;
                    }
                    case 44: {
                        hostSymbolTable.addConstDeclaration(instructionTree, newInstr);
                        break;
                    }
                    case 72: {
                        hostSymbolTable.addExternalOrForwardDeclaration(instructionTree, newInstr, false);
                        break;
                    }
                    case 66: 
                    case 156: 
                    case 190: {
                        hostSymbolTable.addTypeDeclaration(null, instructionTree, newInstr, null);
                        break;
                    }
                }
                if (!addInstruction.get() || TapEnv.inStdCIncludeFile()) {
                    threads.block().removeInstr(newInstr);
                }
                TapEnv.switchOnCombineDeclMessages(true);
                break;
            }
            case 98: {
                Tree implicitTree = this.inputTreeStream.readTree();
                this.curSymbolTable.basisSymbolTable().addImplicit(implicitTree, this.curSymbolTable);
                this.curSymbolTable.addImplicit(implicitTree, this.curSymbolTable);
                if (!TapEnv.inIncludeFile()) break;
                TapEnv.fileWarning(15, implicitTree, "(DD24) " + ILUtils.toString(TapEnv.currentIncludeInstruction().tree) + " contains an implicit declaration");
                TapEnv.currentIncludeInstruction().tree = null;
                break;
            }
            case 38: 
            case 68: {
                this.unit.fortranStuff().activateArrayAccessOrCall(false);
                Tree instructionTree = this.inputTreeStream.readTree();
                this.unit.fortranStuff().activateArrayAccessOrCall(true);
                newInstr = this.addInstructionTree(instructionTree, postComments2, this.commentsWaiting2, threads, true);
                this.unit.fortranStuff().addCommonEquiv(instructionTree, this.curSymbolTable, newInstr);
                if (instructionTree.opCode() != 38) break;
                String commonName = "//";
                if (instructionTree.down(1).opCode() != 136) {
                    commonName = instructionTree.down(1).stringValue();
                }
                this.unit.declaredMemoryMap.commonInstructions = new TapList<TapPair<String, Instruction>>(new TapPair<String, Instruction>(commonName, newInstr), this.unit.declaredMemoryMap.commonInstructions);
                break;
            }
            case 50: {
                Tree instructionTree = this.inputTreeStream.readTree();
                newInstr = this.addInstructionTree(instructionTree, postComments2, this.commentsWaiting2, threads, true);
                this.curSymbolTable.addData(newInstr);
                break;
            }
            case 166: {
                Tree instructionTree = this.inputTreeStream.readTree();
                newInstr = this.addInstructionTree(instructionTree, postComments2, this.commentsWaiting2, threads, true);
                this.curSymbolTable.addSave(newInstr);
                break;
            }
            case 133: {
                Tree instructionTree = this.inputTreeStream.readTree();
                newInstr = this.addInstructionTree(instructionTree, postComments2, this.commentsWaiting2, threads, true);
                this.curSymbolTable.addNameList(newInstr);
                break;
            }
            case 106: {
                Tree instructionTree = this.inputTreeStream.readTree();
                newInstr = this.addInstructionTree(instructionTree, postComments2, this.commentsWaiting2, threads, true);
                this.curSymbolTable.addIntrinsicDeclaration(instructionTree, newInstr);
                break;
            }
            case 192: {
                Tree instructionTree = this.inputTreeStream.readTree();
                newInstr = this.addInstructionTree(instructionTree, postComments2, this.commentsWaiting2, threads, true);
                this.unit.addUseDecl(instructionTree, this.curSymbolTable);
                break;
            }
            case 104: {
                this.inputTreeStream.pushTreeReader();
                TapList<Unit> units = this.unit.addInterfaceDecl(this.inputTreeStream, this.callGraph, this.curSymbolTable);
                if (units != null) {
                    this.callGraph.setInterfaceUnits(TapList.append(this.callGraph.interfaceUnits(), units));
                }
                Tree instructionTree = this.inputTreeStream.popTreeReader();
                newInstr = this.addInstructionTree(instructionTree, postComments2, this.commentsWaiting2, threads, true);
                newInstr.setInterfaceUnits(units);
                break;
            }
            case 86: {
                Tree instructionTree = this.inputTreeStream.readTree();
                newInstr = this.addInstructionTree(instructionTree, postComments2, this.commentsWaiting2, threads, true);
                break;
            }
            case 1: {
                Tree instructionTree = this.inputTreeStream.readTree();
                newInstr = this.addInstructionTree(instructionTree, postComments2, this.commentsWaiting2, threads, true);
                TapList<String> modifiers = null;
                Tree[] modifIdents = instructionTree.down(1).isList() ? instructionTree.down(1).children() : new Tree[]{instructionTree.down(1)};
                for (int i = modifIdents.length - 1; i >= 0; --i) {
                    String modifierStr = ILUtils.getIdentString(modifIdents[i]);
                    if (modifierStr == null) continue;
                    modifiers = new TapList<String>(modifierStr, modifiers);
                }
                if (instructionTree.down(2).opCode() == 187) {
                    this.curSymbolTable.addTypeDeclaration(instructionTree.down(2).down(1), instructionTree.down(2).down(2), newInstr, modifiers);
                } else if (instructionTree.down(2).opCode() == 194) {
                    this.curSymbolTable.addVarDeclaration(instructionTree.down(2), newInstr, true, null);
                }
                if (instructionTree.down(1).opCode() == 1) {
                    this.unit.fortranStuff().addBindCDecl(this.curSymbolTable, instructionTree);
                }
                if (instructionTree.down(2).children().length == 0) {
                    if (this.unit.fortranStuff() != null) {
                        this.unit.fortranStuff().addPublicPrivateDecl(instructionTree.down(1).stringValue().toUpperCase(), instructionTree);
                    }
                    this.unit.privacy = instructionTree.down(1).stringValue().toLowerCase();
                } else {
                    boolean delayedDeclaration = TapList.containsEquals(modifiers, "private") || TapList.containsEquals(modifiers, "public");
                    this.curSymbolTable.declareAllSymbolsIn(instructionTree.down(2), instructionTree.down(2), this.curSymbolTable.getCommonNames(), instructionTree.down(1), 0, delayedDeclaration, false, newInstr);
                }
                if (instructionTree.down(1).opCode() != 94 || !instructionTree.down(1).stringValue().equals("allocatable")) break;
                this.curSymbolTable.addAllocatableDeclaration(instructionTree, newInstr);
                break;
            }
            case 136: {
                this.inputTreeStream.readOperator();
                break;
            }
            case 4: 
            case 51: 
            case 138: 
            case 149: {
                Tree instructionTree = this.inputTreeStream.readTree();
                this.addInstructionTree(instructionTree, postComments2, this.commentsWaiting2, threads, false);
                TapEnv.warningFortran77WithFortran90Features(this.unit);
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(FlowGraphBuilder.treeStream2FlowGraph) Unexpected operator: " + this.inputTreeStream.seeOperator().name);
                Tree instructionTree = this.inputTreeStream.readTree();
                this.addInstructionTree(instructionTree, postComments2, this.commentsWaiting2, threads, false);
            }
        }
        if (postComments2.first != null) {
            this.commentsWaiting2.first = TapList.append((TapList)this.commentsWaiting2.first, ((Tree)postComments2.first).childrenList());
            postComments2.first = null;
        }
        if (postComments2.second != null) {
            this.commentsWaiting2.second = TapList.append((TapList)this.commentsWaiting2.second, ((Tree)postComments2.second).childrenList());
            postComments2.second = null;
        }
    }

    private Instruction addInstructionTree(Tree instructionTree, TapPair<Tree, Tree> postComments2, TapPair<TapList<Tree>, TapList<Tree>> commentsWaiting2, FGThreads threads, boolean isDeclaration) {
        Instruction newInstr = null;
        if (instructionTree.opCode() != 173) {
            newInstr = new Instruction(instructionTree, this.curSCInstruction);
            FlowGraphBuilder.attachComments(newInstr, instructionTree, postComments2, commentsWaiting2);
            if (this.whereMask != null) {
                newInstr.setWhereMask(this.whereMask);
            }
            if (threads.isNotEmpty()) {
                threads.convergeToInstr(newInstr, this.allBlocks, this.unit, this.curSymbolTable, this.curParallelControls, this.traceOn);
            } else if (!isDeclaration) {
                this.unit.addDeadTree(instructionTree);
            } else {
                this.unit.addNonFlowInstruction(newInstr);
            }
        }
        if (!isDeclaration && (this.unit.isModule() || this.unit.isClass())) {
            TapEnv.fileWarning(15, instructionTree, "(DD32) A purely declarative unit should not contain an instruction");
        }
        if (TapEnv.inIncludeFile()) {
            assert (newInstr != null);
            newInstr.setFromIncludeCopy(TapEnv.currentIncludeInstruction(), false);
            if (isDeclaration) {
                this.includeContainsOneDeclaration = true;
            }
            if (this.includeContainsOneDeclaration && !isDeclaration && !newInstr.isInStdInclude()) {
                if (TapEnv.currentIncludeInstruction().tree != null) {
                    TapEnv.fileWarning(15, instructionTree, "(DD34) Inlined include file: " + TapEnv.currentIncludeInstruction().tree.stringValue());
                    TapEnv.currentIncludeInstruction().tree.setValue("");
                }
                TapEnv.resetInIncludeFile();
            }
        } else {
            this.includeContainsOneDeclaration = false;
        }
        return newInstr;
    }

    private boolean containsIIloop(TapList<Tree> comments) {
        boolean found = false;
        while (!found && comments != null) {
            found = Directive.isDirective(((Tree)comments.head).stringValue());
            comments = comments.tail;
        }
        return found;
    }

    private void declareControlBreak(FGThreads threads) {
        if (this.nestedControlStack != null) {
            ((ControlJumpInfo)this.nestedControlStack.head).threadsToAfter.concat(threads);
        }
    }

    private void declareLoopBreak(Tree labelOrName, FGThreads threads) {
        ControlJumpInfo loopJumpInfo = this.findLoopJumpInfo(ILUtils.getIdentString(labelOrName));
        if (loopJumpInfo != null) {
            loopJumpInfo.threadsToAfter.concat(threads);
        }
    }

    private void declareLoopCycle(Tree labelOrName, FGThreads threads) {
        ControlJumpInfo loopJumpInfo = this.findLoopJumpInfo(ILUtils.getIdentString(labelOrName));
        if (loopJumpInfo != null) {
            loopJumpInfo.threadsToCycle.concat(threads);
        }
    }

    private ControlJumpInfo findLoopJumpInfo(String labelOrName) {
        TapList<ControlJumpInfo> stack = this.nestedControlStack;
        ControlJumpInfo found = null;
        while (found == null && stack != null) {
            if (((ControlJumpInfo)stack.head).destinationOper == 119 && (labelOrName == null || labelOrName.equals(((ControlJumpInfo)stack.head).label) || labelOrName.equals(((ControlJumpInfo)stack.head).name))) {
                found = (ControlJumpInfo)stack.head;
            }
            stack = stack.tail;
        }
        if (found == null && this.nestedControlStack != null) {
            found = (ControlJumpInfo)this.nestedControlStack.head;
        }
        return found;
    }

    private void newLabelVar(String labelVar) {
        if (!TapList.containsEquals(this.labelVars, labelVar)) {
            this.labelVars = new TapList<String>(labelVar, this.labelVars);
        }
    }

    private void analyzeAssGoto() {
        TapList inAllBlocks = this.allBlocks.tail;
        if (this.labelVars != null) {
            int pos;
            Block block;
            int numberLabelVars = TapList.length(this.labelVars);
            this.entryBlock.setLabelVariablesEffect(null);
            this.entryBlock.setFinalGotoRank(-1);
            while (inAllBlocks != null) {
                block = (Block)inAllBlocks.head;
                inAllBlocks = inAllBlocks.tail;
                block.setAssGotoInfoDone(null);
                Block[] effectAssGoto = null;
                int finalGotoRank = -1;
                TapList<Instruction> instructions = block.instructions;
                while (instructions != null) {
                    Tree instrTree = ((Instruction)instructions.head).tree;
                    switch (instrTree.opCode()) {
                        case 14: {
                            if (TapList.containsEquals(this.formatLabels, ILUtils.assignedLabel(instrTree))) break;
                            Block targetBlock = this.labelHeap.getLabelled(ILUtils.assignedLabel(instrTree));
                            if (targetBlock == null) {
                                TapEnv.fileWarning(15, instrTree, "(TC50) Label " + ILUtils.assignedLabel(instrTree) + " is not defined");
                                break;
                            }
                            if (effectAssGoto == null) {
                                effectAssGoto = this.mkNewAssGotoInfo();
                            }
                            pos = this.labelVars.rankString(ILUtils.assignedLabelVar(instrTree));
                            effectAssGoto[pos] = targetBlock;
                            break;
                        }
                        case 13: {
                            if (this.labelVars.rankString(ILUtils.assignedName(instrTree)) == -1) break;
                            TapEnv.fileWarning(15, instrTree, "(TC51) Label variable " + ILUtils.assignedName(instrTree) + " must be written by an ASSIGN-TO construct");
                            break;
                        }
                        case 92: {
                            pos = this.labelVars.rankString(ILUtils.gotoLabelVar(instrTree));
                            if (pos == -1) {
                                TapEnv.fileWarning(15, instrTree, "(TC52) Variable " + ILUtils.gotoLabelVar(instrTree) + " used in assigned-GOTO is not a label variable");
                            }
                            finalGotoRank = pos;
                            break;
                        }
                    }
                    instructions = instructions.tail;
                }
                block.setLabelVariablesEffect(effectAssGoto);
                block.setFinalGotoRank(finalGotoRank);
            }
            this.exitBlock.setLabelVariablesEffect(null);
            this.exitBlock.setFinalGotoRank(-1);
            this.propagate(this.entryBlock, this.mkNewAssGotoInfo());
            inAllBlocks = this.allBlocks.tail;
            while (inAllBlocks != null) {
                block = (Block)inAllBlocks.head;
                inAllBlocks = inAllBlocks.tail;
                block.setAssGotoInfoDone(null);
                block.setLabelVariablesEffect(null);
                pos = block.getFinalGotoRank();
                if (pos == -1) continue;
                if (block.flow() == null) {
                    TapEnv.fileWarning(15, block.lastInstr().tree, "(CF03) This assigned-GOTO to " + TapList.nth(this.labelVars, pos) + " goes nowhere");
                } else if (block.flow().tail == null) {
                    TapEnv.fileWarning(15, block.lastInstr().tree, "(CF04) This assigned-GOTO to " + TapList.nth(this.labelVars, pos) + " only goes to label " + ((FGArrow)block.flow().head).destination.origLabel());
                    block.removeInstr(block.lastInstr());
                    ((FGArrow)block.flow().head).test = 0;
                    ((FGArrow)block.flow().head).cases = null;
                } else {
                    this.cleanupLabelList(block.flow(), block.lastInstr());
                }
                block.setFinalGotoRank(-1);
            }
        }
    }

    private void cleanupLabelList(TapList<FGArrow> flow, Instruction assGoto) {
        if (!ILUtils.isNullOrNoneOrEmptyList(assGoto.tree.down(2))) {
            TapIntList usedLabels = null;
            while (flow != null) {
                usedLabels = TapIntList.append(usedLabels, ((FGArrow)flow.head).cases);
                flow = flow.tail;
            }
            Tree[] labels = assGoto.tree.down(2).children();
            TapList<Tree> keptLabels = null;
            for (int i = labels.length - 1; i >= 0; --i) {
                String labelString = labels[i].stringValue();
                int labelInt = Integer.parseInt(labelString);
                if (!TapIntList.contains(usedLabels, labelInt)) continue;
                keptLabels = new TapList<Tree>(labels[i], keptLabels);
            }
            assGoto.tree.setChild(ILUtils.build(111, keptLabels), 2);
        }
    }

    private Block[] mkNewAssGotoInfo() {
        int numberLabelVars = TapList.length(this.labelVars);
        Block[] info = new Block[numberLabelVars];
        for (int i = numberLabelVars - 1; i >= 0; --i) {
            info[i] = null;
        }
        return info;
    }

    private Block[] newCombineAssGotoInfo(Block[] assGotoInfo, Block[] combineAssGotoInfo) {
        int numberLabelVars = TapList.length(this.labelVars);
        Block[] info = new Block[numberLabelVars];
        for (int i = numberLabelVars - 1; i >= 0; --i) {
            info[i] = combineAssGotoInfo[i] != null ? combineAssGotoInfo[i] : assGotoInfo[i];
        }
        return info;
    }

    private boolean eqAssGotoInfo(Block[] info1, Block[] info2) {
        if (info1 == info2) {
            return true;
        }
        int i = TapList.length(this.labelVars);
        boolean isEqual = true;
        while (--i >= 0 && isEqual) {
            isEqual = info1[i] == info2[i];
        }
        return isEqual;
    }

    private void propagate(Block block, Block[] assGotoInfo) {
        Block[] blockEffect = block.getLabelVariablesEffect();
        TapList<Object> assGotoInfoDone = block.getAssGotoInfoDone();
        int finalGotoRank = block.getFinalGotoRank();
        while (assGotoInfoDone != null && !this.eqAssGotoInfo(assGotoInfo, (Block[])assGotoInfoDone.head)) {
            assGotoInfoDone = assGotoInfoDone.tail;
        }
        if (assGotoInfoDone == null) {
            Block nextBlock;
            block.setAssGotoInfoDone(new TapList<Block[]>(assGotoInfo, block.getAssGotoInfoDone()));
            Block[] newAssGotoInfo = blockEffect == null ? assGotoInfo : this.newCombineAssGotoInfo(assGotoInfo, blockEffect);
            if (finalGotoRank != -1) {
                nextBlock = newAssGotoInfo[finalGotoRank];
                if (nextBlock == null) {
                    TapEnv.fileWarning(15, block.lastInstr().tree, "(CF05) This assigned-GOTO to " + TapList.nth(this.labelVars, finalGotoRank) + " is possibly undefined");
                } else if (block.getFGArrowTo(nextBlock) == null) {
                    new FGArrow(block, 11, Integer.parseInt(nextBlock.origLabel()), nextBlock, false);
                }
            }
            TapList<FGArrow> arrows = block.flow();
            while (arrows != null) {
                nextBlock = ((FGArrow)arrows.head).destination;
                if (finalGotoRank == -1 || nextBlock == newAssGotoInfo[finalGotoRank]) {
                    this.propagate(nextBlock, newAssGotoInfo);
                }
                arrows = arrows.tail;
            }
        }
    }

    private void checkAlternativeReturn(FGThreads threads, Tree[] trees) {
        int arrowCase = 0;
        for (Tree tree : trees) {
            Tree expression = tree;
            if (expression.opCode() != 109) continue;
            String label = expression.stringValue();
            threads.reTypeThread(15, ++arrowCase);
            threads.convergeToBlock(this.labelHeap.getSetLabelled(label, this.allBlocks, false, expression), false, this.traceOn);
        }
        if (arrowCase > 0) {
            threads.reTypeThread(15, -1);
        }
    }

    private void checkNameEq(FGThreads threads, Tree[] trees) {
        String label = null;
        int arrowCase = -1;
        boolean foundOneLabel = false;
        for (Tree tree : trees) {
            String nameEq1;
            Tree expression = tree;
            if (expression.opCode() == 132 && ((nameEq1 = expression.down(1).stringValue()).equals("err") || nameEq1.equals("end") || nameEq1.equals("eor"))) {
                label = expression.down(2).stringValue();
                arrowCase = nameEq1.equals("err") ? 13 : (nameEq1.equals("end") ? 14 : 15);
                foundOneLabel = true;
            }
            if (label != null) {
                threads.reTypeThread(12, arrowCase);
                threads.convergeToBlock(this.labelHeap.getSetLabelled(label, this.allBlocks, false, expression), false, this.traceOn);
            }
            label = null;
        }
        if (foundOneLabel) {
            threads.reTypeThread(12, -1);
        }
    }

    private void pushUnitWillBeDeleted() {
        ++this.willBeDeletedMark;
    }

    private void popUnitWillBeDeleted() {
        --this.willBeDeletedMark;
    }

    private boolean unitWillBeDeleted() {
        return this.willBeDeletedMark > 0;
    }

    private static class ControlJumpInfo {
        private final int destinationOper;
        private final String name;
        private final String label;
        private final FGThreads threadsToCycle;
        private final FGThreads threadsToAfter;

        private ControlJumpInfo(int operator, String label, String name) {
            this.destinationOper = operator;
            this.label = label;
            this.name = name;
            this.threadsToCycle = new FGThreads();
            this.threadsToAfter = new FGThreads();
        }
    }
}

