/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.BasicBlock;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.EntryBlock;
import fr.inria.tapenade.representation.ExitBlock;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.HeaderBlock;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.LoopBlock;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.Tree;

public final class FlowGraphNormalizer {
    private static final int CLEAR = 0;
    private static final int VISITING = 1;
    private static final int VISITED = 2;
    private final EntryBlock entryBlock;
    private final ExitBlock exitBlock;
    private TapList<Block> allBlocks;
    private TapList<Block> visitingStack;
    private LoopMemoCell loopMemos;

    protected FlowGraphNormalizer(EntryBlock entryBlock, TapList<Block> allBlocks, ExitBlock exitBlock) {
        this.entryBlock = entryBlock;
        this.exitBlock = exitBlock;
        this.allBlocks = allBlocks;
    }

    protected void makeSurePrivateDeclarationsBlock(Unit unit) {
        Block block0;
        TapList<FGArrow> flow = this.entryBlock.flow();
        FGArrow arrow = flow == null ? null : (FGArrow)flow.head;
        Block block = block0 = arrow == null ? null : arrow.destination;
        if (!(block0 == null || unit.isTranslationUnit() || TapList.length(block0.backFlow()) == 1 && block0.symbolTable == unit.privateSymbolTable())) {
            BasicBlock newB0 = new BasicBlock(unit.privateSymbolTable(), null, null);
            arrow.insertBlockAtDest(newB0, 0, 0);
            this.allBlocks = new TapList<Block>(newB0, this.allBlocks);
        }
    }

    protected void condenseFG(boolean finalGraph) {
        boolean foundCondensation = true;
        TapList<Block> topAllBlocks = new TapList<Block>(null, this.allBlocks);
        while (foundCondensation) {
            foundCondensation = false;
            TapList<Block> inAllBlocks = topAllBlocks;
            while (inAllBlocks != null && inAllBlocks.tail != null) {
                Block curBlock = (Block)inAllBlocks.tail.head;
                if (curBlock.instructions != null || curBlock.flow() != null || curBlock.backFlow() != null) {
                    if (this.condensedArrows(curBlock)) {
                        foundCondensation = true;
                    }
                    if (this.condensedBlock(curBlock)) {
                        foundCondensation = true;
                    } else if (this.skippedEmptyBlock(curBlock, finalGraph)) {
                        inAllBlocks.tail = inAllBlocks.tail.tail;
                        foundCondensation = true;
                    } else if (this.deleteEmptyIfs(curBlock)) {
                        foundCondensation = true;
                    } else if (this.deleteEmptyParallelRegion(curBlock)) {
                        foundCondensation = true;
                    } else if (this.deleteEmptyLoops(curBlock)) {
                        foundCondensation = true;
                        if (curBlock instanceof HeaderBlock) {
                            BasicBlock newBasicBlock = new BasicBlock(curBlock.symbolTable, curBlock.parallelControls, null);
                            newBasicBlock.replaceInFlowGraph(curBlock);
                            newBasicBlock.newDeclarationsBlock(curBlock);
                            inAllBlocks.tail.head = newBasicBlock;
                        }
                    }
                }
                inAllBlocks = inAllBlocks.tail;
            }
        }
        this.allBlocks = topAllBlocks.tail;
    }

    private boolean deleteEmptyIfs(Block block) {
        TapList<Instruction> toInstructions;
        TapList<Instruction> inInstructions = toInstructions = new TapList<Instruction>(null, block.instructions);
        boolean deletedIf = false;
        while (inInstructions.tail != null) {
            Instruction instruction = (Instruction)inInstructions.tail.head;
            Tree tree = instruction.tree;
            if (tree != null && tree.opCode() == 96 && ILUtils.isNullOrNoneOrEmptyList(tree.down(2)) && ILUtils.isNullOrNoneOrEmptyList(tree.down(3)) && (inInstructions.tail.tail != null || block.flow() != null && block.flow().tail == null && ((FGArrow)block.flow().head).test == 0)) {
                Tree exprIF = tree.down(1);
                if (ILUtils.instrHasSideEffect(exprIF)) {
                    inInstructions = inInstructions.tail;
                    continue;
                }
                block.unit().addDeadTree(instruction.tree);
                if (instruction.preComments != null) {
                    block.unit().addLostComment(instruction.preComments);
                }
                if (instruction.postComments != null) {
                    block.unit().addLostComment(instruction.postComments);
                }
                inInstructions.tail = inInstructions.tail.tail;
                deletedIf = true;
                continue;
            }
            inInstructions = inInstructions.tail;
        }
        block.instructions = toInstructions.tail;
        return deletedIf;
    }

    private boolean deleteEmptyParallelRegion(Block block) {
        if (block.isParallelController()) {
            Instruction instruction = (Instruction)block.instructions.head;
            if (block.flow() != null && (((FGArrow)block.flow().head).destination.parallelControls == null || ((FGArrow)block.flow().head).destination.parallelControls.head != instruction)) {
                block.unit().addDeadTree(instruction.tree);
                if (instruction.preComments != null) {
                    block.unit().addLostComment(instruction.preComments);
                }
                if (instruction.postComments != null) {
                    block.unit().addLostComment(instruction.postComments);
                }
                block.instructions = null;
                return true;
            }
        }
        return false;
    }

    private boolean deleteEmptyLoops(Block block) {
        TapList<Instruction> toInstructions;
        boolean deletedLoop = false;
        TapList<Instruction> inInstructions = toInstructions = new TapList<Instruction>(null, block.instructions);
        while (inInstructions.tail != null) {
            Tree tree = ((Instruction)inInstructions.tail.head).tree;
            deletedLoop = false;
            if (tree != null && tree.opCode() == 119 && (tree.down(3).opCode() == 63 || tree.down(3).opCode() == 184) && !ILUtils.isNotNoneNorEmpty(tree.down(4)) && (inInstructions.tail.tail != null || block.flow() != null && block.flow().tail != null && block.flow().tail.tail == null && (((FGArrow)block.flow().head).destination == block && ((FGArrow)block.flow().head).cases.head == 1 || ((FGArrow)block.flow().tail.head).destination == block && ((FGArrow)block.flow().tail.head).cases.head == 1))) {
                Tree accountTimes;
                Tree duplicableLastIndex;
                if (tree.down(3).opCode() == 63 && (duplicableLastIndex = ILUtils.hasDuplicableLastIndex(tree.down(3), true)) != null) {
                    boolean onLastInstr;
                    block.unit().addDeadTree(((Instruction)inInstructions.tail.head).tree);
                    boolean bl = onLastInstr = inInstructions.tail.tail == null;
                    if (block instanceof HeaderBlock && ((HeaderBlock)block).loopIndexUnusedAfterLoop) {
                        inInstructions.tail = inInstructions.tail.tail;
                    } else {
                        ((Instruction)inInstructions.tail.head).tree = ILUtils.build(13, ILUtils.copy(tree.down(3).down(1)), duplicableLastIndex);
                    }
                    if (onLastInstr) {
                        if (((FGArrow)block.flow().head).destination == block && ((FGArrow)block.flow().head).cases.head == 1) {
                            ((FGArrow)block.flow().tail.head).cases = null;
                            ((FGArrow)block.flow().tail.head).test = 0;
                            ((FGArrow)block.flow().head).delete();
                        } else if (((FGArrow)block.flow().tail.head).destination == block && ((FGArrow)block.flow().tail.head).cases.head == 1) {
                            ((FGArrow)block.flow().head).cases = null;
                            ((FGArrow)block.flow().head).test = 0;
                            ((FGArrow)block.flow().tail.head).delete();
                        }
                    }
                    deletedLoop = true;
                }
                if (tree.down(3).opCode() == 184 && !ILUtils.instrHasSideEffect(accountTimes = tree.down(3).down(1))) {
                    block.unit().addDeadTree(((Instruction)inInstructions.tail.head).tree);
                    if (((Instruction)inInstructions.tail.head).preComments != null) {
                        block.unit().addLostComment(((Instruction)inInstructions.tail.head).preComments);
                    }
                    if (((Instruction)inInstructions.tail.head).postComments != null) {
                        block.unit().addLostComment(((Instruction)inInstructions.tail.head).postComments);
                    }
                    inInstructions.tail = inInstructions.tail.tail;
                    if (inInstructions.tail == null) {
                        if (((FGArrow)block.flow().head).destination == block && ((FGArrow)block.flow().head).cases.head == 1) {
                            ((FGArrow)block.flow().tail.head).cases = null;
                            ((FGArrow)block.flow().tail.head).test = 0;
                            ((FGArrow)block.flow().head).delete();
                        } else if (((FGArrow)block.flow().tail.head).destination == block && ((FGArrow)block.flow().tail.head).cases.head == 1) {
                            ((FGArrow)block.flow().head).cases = null;
                            ((FGArrow)block.flow().head).test = 0;
                            ((FGArrow)block.flow().tail.head).delete();
                        }
                    }
                    deletedLoop = true;
                }
                if (deletedLoop) continue;
                inInstructions = inInstructions.tail;
                continue;
            }
            inInstructions = inInstructions.tail;
        }
        block.instructions = toInstructions.tail;
        return deletedLoop;
    }

    private boolean condensedArrows(Block block) {
        TapList<FGArrow> flowArrows1 = block.flow();
        while (flowArrows1 != null) {
            FGArrow arrow1 = (FGArrow)flowArrows1.head;
            TapList flowArrows2 = flowArrows1.tail;
            while (flowArrows2 != null) {
                FGArrow arrow2 = (FGArrow)flowArrows2.head;
                if (arrow1.destination == arrow2.destination && arrow1.destination != null && arrow1.inACycle == arrow2.inACycle && arrow1.test != 15 && arrow2.test != 15 && arrow1.test != 10 && arrow2.test != 10 && arrow1.test != 12 && arrow2.test != 12 && this.consecutiveIfSwitchCases(arrow1, arrow2, block)) {
                    boolean merge = true;
                    if (arrow1.test == 21 && arrow2.test == 21) {
                        boolean bl = merge = !TapIntList.contains(arrow1.cases, -2) && !TapIntList.contains(arrow2.cases, -2);
                    }
                    if (merge) {
                        arrow1.delete();
                        arrow2.mergeCases(arrow1);
                        return true;
                    }
                }
                flowArrows2 = flowArrows2.tail;
            }
            flowArrows1 = flowArrows1.tail;
        }
        return false;
    }

    private boolean condensedBlock(Block block) {
        Block nextBlock;
        if (!(block.flow() == null || block.flow().tail != null || ((FGArrow)block.flow().head).cases != null || block instanceof EntryBlock || block instanceof HeaderBlock || block.isALoop() || this.blockDelimitatesFuturePart(block) || (nextBlock = ((FGArrow)block.flow().head).destination) == null || nextBlock.backFlow().tail != null || nextBlock.symbolTable != block.symbolTable || nextBlock.parallelControls != block.parallelControls || nextBlock instanceof ExitBlock || nextBlock instanceof HeaderBlock || nextBlock.isALoop() || this.blockDelimitatesFuturePart(nextBlock))) {
            block.mergeWithSuccessor(nextBlock);
            return true;
        }
        return false;
    }

    private boolean blockDelimitatesFuturePart(Block block) {
        Instruction headInstr = block.headInstr();
        if (headInstr == null) {
            return false;
        }
        return ILUtils.isParallelController(headInstr.tree) || this.commentDelimitatesFuturePart(headInstr.preComments) || this.commentDelimitatesFuturePart(headInstr.preCommentsBlock);
    }

    private boolean commentDelimitatesFuturePart(Tree comments) {
        boolean found = false;
        if (comments != null) {
            Tree[] commentsArray = comments.children();
            for (int i = commentsArray.length - 1; i >= 0 && !found; --i) {
                String commentText = commentsArray[i].stringValue();
                commentText = commentText.toUpperCase();
                while (commentText.startsWith(" ")) {
                    commentText = commentText.substring(1);
                }
                if (!commentText.startsWith("$AD ")) continue;
                commentText = commentText.substring(3);
                while (commentText.startsWith(" ")) {
                    commentText = commentText.substring(1);
                }
                if (!commentText.startsWith("CHECKPOINT-START") && !commentText.startsWith("CHECKPOINT-END") && !commentText.startsWith("DO-NOT-DIFF") && !commentText.startsWith("END-DO-NOT-DIFF") && !commentText.startsWith("FP-LOOP")) continue;
                found = true;
            }
        }
        return found;
    }

    private boolean skippedEmptyBlock(Block block, boolean finalGraph) {
        if (block.instructions == null && !(block instanceof ExitBlock) && block.flow() != null && block.flow().tail == null && ((FGArrow)block.flow().head).destination != block && !this.isAssGotoDestination(block) && (finalGraph || this.isNotLoopCyclePoint(block))) {
            block.skipEmpty();
            return true;
        }
        return false;
    }

    private boolean isAssGotoDestination(Block block) {
        if (block.origLabel() == null) {
            return false;
        }
        TapList<FGArrow> backFlow = block.backFlow();
        boolean origAssGoto = false;
        while (backFlow != null && !origAssGoto) {
            Instruction lastInstr = ((FGArrow)backFlow.head).origin == null ? null : ((FGArrow)backFlow.head).origin.lastInstr();
            origAssGoto = lastInstr != null && lastInstr.tree != null && lastInstr.tree.opCode() == 92;
            backFlow = backFlow.tail;
        }
        return origAssGoto;
    }

    private boolean isNotLoopCyclePoint(Block block) {
        if (((FGArrow)block.flow().head).destination.isALoop()) {
            return block.backFlow() != null && block.backFlow().tail == null && ((FGArrow)block.flow().head).destination == ((FGArrow)block.backFlow().head).origin;
        }
        return true;
    }

    private boolean consecutiveIfSwitchCases(FGArrow arrow1, FGArrow arrow2, Block block) {
        boolean consecutive = true;
        if (arrow1.test == 21 && arrow2.test == 21 && arrow1.cases != null && arrow2.cases != null) {
            Tree switchTree;
            if (arrow1.cases.head < 0 || arrow2.cases.head >= 0 && arrow1.cases.head > arrow2.cases.head) {
                FGArrow tmp = arrow2;
                arrow2 = arrow1;
                arrow1 = tmp;
            }
            if ((switchTree = block.lastInstr().tree).opCode() == 179) {
                int min2;
                int nbCases = switchTree.down(2).length();
                if (ILUtils.isNullOrEmptyList(switchTree.down(2).down(nbCases).down(1))) {
                    --nbCases;
                }
                int max1 = TapIntList.maxElem(arrow1.cases);
                TapIntList cases2 = arrow2.cases;
                if (cases2.head < 0) {
                    cases2 = new TapIntList(nbCases, cases2.tail);
                }
                if (max1 < (min2 = TapIntList.minElem(cases2)) - 1) {
                    consecutive = false;
                }
            }
        }
        return consecutive;
    }

    protected void sortFlowArrows() {
        TapList<Block> inAllBlocks = this.allBlocks;
        while (inAllBlocks != null) {
            Block curBlock = (Block)inAllBlocks.head;
            TapList<FGArrow> flow = curBlock.flow();
            Block defaultDest = this.sensitiveDefaultDest(flow);
            if (defaultDest != null) {
                curBlock.setFlow(this.putSensitiveDestLast(flow, defaultDest));
            }
            inAllBlocks = inAllBlocks.tail;
        }
    }

    private Block sensitiveDefaultDest(TapList<FGArrow> flowArrows) {
        Block result = null;
        while (result == null && flowArrows != null) {
            FGArrow arrow = (FGArrow)flowArrows.head;
            if (arrow.containsCase(-1) && (arrow.test == 10 || arrow.test == 12 || arrow.test == 15)) {
                result = arrow.destination;
            }
            flowArrows = flowArrows.tail;
        }
        return result;
    }

    private TapList<FGArrow> putSensitiveDestLast(TapList<FGArrow> flowArrows, Block sensitiveDest) {
        TapList<Object> hdSecndHalf;
        TapList<Object> hdFirstHalf;
        TapList<Object> tlFirstHalf = hdFirstHalf = new TapList<Object>(null, null);
        TapList<Object> tlSecndHalf = hdSecndHalf = new TapList<Object>(null, null);
        while (flowArrows != null) {
            FGArrow arrow = (FGArrow)flowArrows.head;
            if (arrow.destination == sensitiveDest) {
                tlSecndHalf = tlSecndHalf.placdl(arrow);
            } else {
                tlFirstHalf = tlFirstHalf.placdl(arrow);
            }
            flowArrows = flowArrows.tail;
        }
        return TapList.append(hdFirstHalf.tail, hdSecndHalf.tail);
    }

    protected TapList<Block> findOptimalLoops() {
        boolean foundOptimal = false;
        while (!foundOptimal) {
            this.dfstInit();
            foundOptimal = this.dfst(this.entryBlock);
        }
        TapList<Block> topBlocks = this.loopMemos.loopMemo(null).inside;
        this.redefineLoops(topBlocks);
        return topBlocks;
    }

    protected TapList<Block> getDeadBlocks() {
        TapList<Block> inAllBlocks = this.allBlocks;
        TapList<Block> deadBlocks = null;
        while (inAllBlocks != null) {
            Block block = (Block)inAllBlocks.head;
            if (block.visit != 2) {
                deadBlocks = new TapList<Block>(block, deadBlocks);
            }
            block.visit = 0;
            inAllBlocks = inAllBlocks.tail;
        }
        return deadBlocks;
    }

    private void redefineLoops(TapList<Block> blocks) {
        while (blocks != null) {
            Block curBlock = (Block)blocks.head;
            LoopMemoCell blockMemo = this.loopMemos.loopMemo(curBlock);
            if (blockMemo == null) {
                if (!(curBlock instanceof BasicBlock)) {
                    BasicBlock basicBlock = new BasicBlock(curBlock.symbolTable, curBlock.parallelControls, null);
                    basicBlock.replaceInFlowGraph(curBlock);
                    basicBlock.newDeclarationsBlock(curBlock);
                    blocks.head = basicBlock;
                }
            } else {
                HeaderBlock headerBlock = new HeaderBlock(curBlock.symbolTable, curBlock.parallelControls, null);
                LoopBlock loopBlock = new LoopBlock(new TapList<Block>(headerBlock, blockMemo.inside));
                headerBlock.replaceInFlowGraph(curBlock);
                headerBlock.newDeclarationsBlock(curBlock);
                if (curBlock instanceof HeaderBlock) {
                    headerBlock.setOrigCycleLabel(((HeaderBlock)curBlock).origCycleLabel());
                }
                blocks.head = loopBlock;
                this.redefineLoops(blockMemo.inside);
            }
            blocks = blocks.tail;
        }
    }

    private void dfstInit() {
        TapList<Block> inAllBlocks = this.allBlocks;
        this.entryBlock.visit = 2;
        this.exitBlock.visit = 2;
        while (inAllBlocks != null) {
            ((Block)inAllBlocks.head).visit = 0;
            ((Block)inAllBlocks.head).setEnclosingBlock(null);
            inAllBlocks = inAllBlocks.tail;
        }
        this.visitingStack = new TapList<EntryBlock>(this.entryBlock, null);
        this.loopMemos = new LoopMemoCell(null, null, null);
    }

    private boolean dfst(Block prevBlock) {
        TapList<FGArrow> flowArrows = prevBlock.flow();
        flowArrows = this.reorderFlowForDfst(flowArrows);
        boolean foundOptimal = true;
        while (flowArrows != null && foundOptimal) {
            Block curBlock = ((FGArrow)flowArrows.head).destination;
            if (curBlock.visit == 1) {
                if (this.loopMemos.loopMemo(curBlock) == null) {
                    this.loopMemos = new LoopMemoCell(curBlock, null, this.loopMemos);
                }
                this.declareVisitingInLoopUntil(curBlock);
            } else if (curBlock.visit == 2) {
                Block loopBlock = curBlock;
                while (foundOptimal && (loopBlock = loopBlock.enclosingBlock()) != null && loopBlock.visit != 1) {
                    foundOptimal = this.checkAlternateEntry(loopBlock, curBlock);
                }
                if (foundOptimal && loopBlock != null) {
                    this.declareVisitingInLoopUntil(loopBlock);
                }
            } else {
                curBlock.visit = 1;
                this.visitingStack = new TapList<Block>(curBlock, this.visitingStack);
                foundOptimal = this.dfst(curBlock);
                if (foundOptimal) {
                    this.visitingStack = this.visitingStack.tail;
                    curBlock.visit = 2;
                    LoopMemoCell inLoopMemos = this.loopMemos.loopMemo(curBlock.enclosingBlock());
                    inLoopMemos.inside = new TapList<Block>(curBlock, inLoopMemos.inside);
                    inLoopMemos = this.loopMemos.loopMemo(curBlock);
                    if (inLoopMemos != null) {
                        inLoopMemos.visitStack = this.visitingStack;
                    }
                }
            }
            flowArrows = flowArrows.tail;
        }
        return foundOptimal;
    }

    private TapList<FGArrow> reorderFlowForDfst(TapList<FGArrow> flowArrows) {
        TapList<Object> hdResult;
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        FGArrow putLast = null;
        while (flowArrows != null) {
            FGArrow arrow = (FGArrow)flowArrows.head;
            if (arrow.test == 30 && arrow.containsCase(0) || arrow.test == 20 && arrow.containsCase(2)) {
                putLast = arrow;
            } else {
                tlResult = tlResult.placdl(arrow);
            }
            flowArrows = flowArrows.tail;
        }
        if (putLast != null) {
            tlResult.placdl(putLast);
        }
        return hdResult.tail;
    }

    private boolean checkAlternateEntry(Block oldLoopHeader, Block newLoopHeader) {
        Instruction oldHead = null;
        Instruction newHead = null;
        if (oldLoopHeader.instructions != null) {
            oldHead = oldLoopHeader.headInstr();
        }
        if (newLoopHeader.instructions != null) {
            newHead = newLoopHeader.headInstr();
        }
        if (!(oldHead != null && oldHead.isALoop() || newHead == null || !newHead.isALoop() || oldHead != null && !newHead.syntaxControls(oldHead))) {
            TapList<Block> oldStack = this.loopMemos.loopMemo((Block)oldLoopHeader).visitStack;
            oldStack = new TapList<Block>(oldLoopHeader, oldStack);
            TapList<Block> newStack = new TapList<Block>(newLoopHeader, this.visitingStack);
            while (!TapList.contains(newStack, oldStack.tail.head)) {
                oldStack = oldStack.tail;
            }
            while (newStack.tail.head != oldStack.tail.head) {
                newStack = newStack.tail;
            }
            ((Block)newStack.tail.head).exchangeFlowArrowsTo((Block)oldStack.head, (Block)newStack.head);
            return false;
        }
        return true;
    }

    private void declareVisitingInLoopUntil(Block limitLoopBlock) {
        TapList<Block> inVisitingList = this.visitingStack;
        while (inVisitingList.head != limitLoopBlock) {
            ((Block)inVisitingList.head).setEnclosingBlockProtected(limitLoopBlock);
            inVisitingList = inVisitingList.tail;
        }
    }

    private static class LoopMemoCell {
        private final Block loop;
        private final LoopMemoCell next;
        protected TapList<Block> visitStack;
        protected TapList<Block> inside;

        LoopMemoCell(Block loop, TapList<Block> visitStack, LoopMemoCell next) {
            this.loop = loop;
            this.visitStack = visitStack;
            this.next = next;
            this.inside = null;
        }

        LoopMemoCell loopMemo(Block loopHeader) {
            LoopMemoCell curCell = this;
            while (curCell != null && curCell.loop != loopHeader) {
                curCell = curCell.next;
            }
            return curCell;
        }

        public String toString() {
            LoopMemoCell curCell = this;
            StringBuilder result = new StringBuilder();
            while (curCell != null) {
                result.append(';').append(curCell.loop);
                curCell = curCell.next;
            }
            return result.toString();
        }
    }
}

