/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.InFunction;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.MemoryMap;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeDecl;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.Tree;

public class FortranStuff {
    private final Unit unit;
    protected TapList<Tree> statementFunctions;
    protected String publicPrivateDefault;
    protected TapList<TapPair<String, Instruction>> implicitDeclarations;
    private boolean checkArrayAccessOrCall = true;
    private TapList<TapPair<Tree, SymbolTable>> commonEquivList;
    private boolean saveAll;
    private TapList<TapPair<SymbolTable, Tree>> bindCDeclarationList;

    protected FortranStuff(Unit unit) {
        this.unit = unit;
    }

    public static void initFortranSymbolTable(SymbolTable symbolTable) {
        symbolTable.setImplicitLetters('a', 'h', symbolTable.getTypeDecl((String)"float").typeSpec);
        symbolTable.setImplicitLetters('i', 'n', symbolTable.getTypeDecl((String)"integer").typeSpec);
        symbolTable.setImplicitLetters('o', 'z', symbolTable.getTypeDecl((String)"float").typeSpec);
    }

    protected void activateArrayAccessOrCall(boolean val) {
        this.checkArrayAccessOrCall = val;
    }

    protected void addCommonEquiv(Tree commonEquiv, SymbolTable symbolTable, Instruction instr) {
        this.commonEquivList = new TapList<TapPair<Tree, SymbolTable>>(new TapPair<Tree, SymbolTable>(commonEquiv, symbolTable), this.commonEquivList);
        this.declareCommonEquivsRec(commonEquiv, symbolTable, instr);
    }

    private void declareCommonEquivsRec(Tree declTree, SymbolTable symbolTable, Instruction instr) {
        switch (declTree.opCode()) {
            case 166: {
                Tree[] subDecls;
                for (Tree subDecl : subDecls = declTree.children()) {
                    this.declareCommonEquivsRec(subDecl, symbolTable, instr);
                }
                break;
            }
            case 50: {
                Tree[] subDecls;
                for (Tree subDecl : subDecls = declTree.down(1).children()) {
                    Tree subDecli = ILUtils.baseTree(subDecl);
                    assert (subDecli != null);
                    this.declareCommonEquivsRec(subDecli, symbolTable, instr);
                }
                break;
            }
            case 38: {
                Tree[] subDecls;
                for (Tree subDecl : subDecls = declTree.down(2).children()) {
                    this.declareCommonEquivsRec(subDecl, symbolTable, instr);
                }
                break;
            }
            case 59: 
            case 68: 
            case 70: {
                Tree[] subDecls = declTree.children();
                for (int i = subDecls.length - 1; i >= 0; --i) {
                    this.declareCommonEquivsRec(subDecls[i], symbolTable, instr);
                }
                break;
            }
            case 2: 
            case 58: 
            case 61: 
            case 131: 
            case 177: {
                this.declareCommonEquivsRec(declTree.down(1), symbolTable, instr);
                this.declareCommonEquivsRec(declTree.down(2), symbolTable, instr);
                break;
            }
            case 8: 
            case 10: 
            case 178: {
                this.declareCommonEquivsRec(declTree.down(2), symbolTable, instr);
            }
            case 94: {
                String name = ILUtils.baseName(declTree);
                assert (name != null);
                VariableDecl variableDecl = symbolTable.getVariableOrConstantDecl(name);
                boolean isCommonName = false;
                if (variableDecl == null) {
                    boolean bl = isCommonName = this.isCommonName(name) || instr != null && instr.tree != null && instr.tree.opCode() == 166 && name.startsWith("/") && name.endsWith("/");
                }
                if (isCommonName) break;
                if (variableDecl != this.unit.publicSymbolTable().getTopVariableOrConstantDecl(name)) {
                    symbolTable.moveSymbolDeclListUpRec(new TapList<SymbolDecl>(variableDecl, null), this.unit.publicSymbolTable());
                }
                SymbolDecl newVariableDecl = SymbolDecl.build(new WrapperTypeSpec(null), null, false, declTree, 1, symbolTable, instr, null);
                assert (newVariableDecl != null);
                symbolTable.moveSymbolDeclListUpRec(newVariableDecl.dependsOn(), this.unit.publicSymbolTable());
                if (newVariableDecl.isA(1)) {
                    ((VariableDecl)newVariableDecl).isVariableName = true;
                }
                this.unit.publicSymbolTable().addSymbolDecl(newVariableDecl);
                VariableDecl publicVariableDecl = this.unit.publicSymbolTable().getTopVariableDecl(newVariableDecl.symbol);
                if (publicVariableDecl == null || instr == null || instr.tree == null || instr.tree.opCode() != 38) break;
                publicVariableDecl.setCommonInstr(true);
                if (!ILUtils.containsArrayDeclarator(publicVariableDecl, instr.tree)) break;
                publicVariableDecl.setCommonWithArrayDeclaratorInstr(true);
                break;
            }
            case 101: {
                break;
            }
            case 122: {
                this.declareCommonEquivsRec(declTree.down(1), symbolTable, instr);
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(declare COMMON or EQUIVALENCE) Unexpected operator: " + declTree.opName());
            }
        }
    }

    private void declareCommonEquivsSaveRec(VariableDecl variableDecl, SymbolTable symbolTable) {
        if (variableDecl != this.unit.publicSymbolTable().getTopVariableDecl(variableDecl.symbol)) {
            symbolTable.moveSymbolDeclListUpRec(new TapList<SymbolDecl>(variableDecl, null), this.unit.publicSymbolTable());
        }
        SymbolDecl newVariableDecl = SymbolDecl.build(new WrapperTypeSpec(null), null, false, ILUtils.build(94, variableDecl.symbol), 1, symbolTable, null, null);
        symbolTable.moveSymbolDeclListUpRec(variableDecl.dependsOn(), this.unit.publicSymbolTable());
        assert (newVariableDecl != null);
        if (newVariableDecl.isA(1)) {
            ((VariableDecl)newVariableDecl).isVariableName = true;
        }
        this.unit.publicSymbolTable().addSymbolDecl(newVariableDecl);
    }

    protected void commonEquivsIntoMemoryMap() {
        Tree commonEquiv;
        TapList<TapPair<Tree, SymbolTable>> localCommonEquivList = this.commonEquivList;
        while (localCommonEquivList != null) {
            commonEquiv = (Tree)((TapPair)localCommonEquivList.head).first;
            switch (commonEquiv.opCode()) {
                case 38: {
                    this.placeCommonIntoMemoryMap(commonEquiv);
                    break;
                }
                case 68: {
                    this.placeEquivalenceIntoMemoryMap(commonEquiv);
                    break;
                }
            }
            localCommonEquivList = localCommonEquivList.tail;
        }
        localCommonEquivList = this.commonEquivList;
        while (localCommonEquivList != null) {
            commonEquiv = (Tree)((TapPair)localCommonEquivList.head).first;
            if (!(commonEquiv.opCode() != 166 && commonEquiv.opCode() != 50 || this.unit.isModule())) {
                this.placeSaveIntoMemoryMap(ILUtils.copy(commonEquiv));
            }
            localCommonEquivList = localCommonEquivList.tail;
        }
    }

    protected TapList<String> getCommonNames() {
        TapList<String> commonNames = null;
        TapList<TapPair<Tree, SymbolTable>> localCommonEquivList = this.commonEquivList;
        while (localCommonEquivList != null) {
            Tree commonNameTree;
            Tree commonEquiv = (Tree)((TapPair)localCommonEquivList.head).first;
            if (commonEquiv.opCode() == 38 && (commonNameTree = commonEquiv.down(1)).opCode() == 94) {
                String commonName = commonNameTree.stringValue();
                commonNames = new TapList<String>(commonName, commonNames);
            }
            localCommonEquivList = localCommonEquivList.tail;
        }
        return commonNames;
    }

    private boolean isCommonName(String name) {
        return TapList.containsEquals(this.getCommonNames(), name);
    }

    private Tree[] getSavedVars(Tree saveOrDataTree) {
        Tree[] results = null;
        if (saveOrDataTree.opCode() == 166) {
            results = saveOrDataTree.children();
        } else if (saveOrDataTree.opCode() == 50) {
            results = saveOrDataTree.down(1).children();
            for (int i = 0; i < results.length; ++i) {
                results[i] = ILUtils.baseTree(results[i]);
            }
        }
        return results;
    }

    private void placeSaveIntoMemoryMap(Tree saveTree) {
        Tree[] savedVars = this.getSavedVars(saveTree);
        String saveCommonName = TapEnv.get().saveCommonName + this.unit.name + "/";
        assert (savedVars != null);
        for (int i = savedVars.length - 1; i >= 0; --i) {
            String savedName = savedVars[i].stringValue();
            VariableDecl variableDecl = this.unit.publicSymbolTable().getVariableDecl(savedName);
            boolean isCommonName = false;
            if (variableDecl == null) {
                isCommonName = this.isCommonName(savedName);
            }
            if (isCommonName) continue;
            int varSize = variableDecl == null || variableDecl.type() == null ? -1 : variableDecl.type().size();
            if (varSize < 0) {
                TapEnv.fileWarning(15, saveTree, "Cannot compute the size of saved variable " + savedName);
                varSize = 9;
            }
            if (variableDecl == null) continue;
            this.unit.declaredMemoryMap.placeSave(saveCommonName, variableDecl, varSize, this.unit.publicSymbolTable());
        }
    }

    private void placeCommonIntoMemoryMap(Tree commonDecl) {
        Tree commonNameTree = commonDecl.down(1);
        String commonName = commonNameTree.opCode() == 136 ? "" : commonNameTree.stringValue();
        this.unit.declaredMemoryMap.getSetCommon(commonName);
        Tree[] varDecls = commonDecl.down(2).children();
        WrapperTypeSpec baseTypeSpec = null;
        for (Tree varDecl : varDecls) {
            int varSize;
            String varName = ILUtils.baseName(varDecl);
            VariableDecl variableDecl = this.unit.publicSymbolTable().getVariableDecl(varName);
            if (variableDecl == null || variableDecl.type() == null) {
                varSize = -1;
            } else {
                varSize = variableDecl.type().size();
                baseTypeSpec = baseTypeSpec == null ? variableDecl.type().baseTypeSpec(true) : this.unit.publicSymbolTable().getTypeDecl((String)"float").typeSpec.conformingTypeSpec(baseTypeSpec, variableDecl.type().baseTypeSpec(true), null);
            }
            if (varSize < 0) {
                TapEnv.toolWarning(-1, "Cannot compute the size of variable " + varName + " in COMMON " + commonName);
                continue;
            }
            this.unit.declaredMemoryMap.appendCommon(commonName, variableDecl, varSize, this.unit.publicSymbolTable());
        }
        if (commonNameTree.opCode() != 136) {
            this.addBindCDecl(this.unit.publicSymbolTable(), commonNameTree);
        }
    }

    private void placeEquivalenceIntoMemoryMap(Tree equivalenceDecl) {
        Tree[] oneEquivalenceDecls = equivalenceDecl.children();
        for (int i = oneEquivalenceDecls.length - 1; i >= 0; --i) {
            Tree[] sons = oneEquivalenceDecls[i].children();
            Tree lastSon = sons[sons.length - 1];
            VariableDecl variableDecl0 = this.unit.privateSymbolTable().getVariableDecl(ILUtils.baseName(lastSon));
            int offset0 = this.unit.privateSymbolTable().refOffset(lastSon);
            for (int j = sons.length - 2; j >= 0; --j) {
                VariableDecl variableDecl1 = this.unit.privateSymbolTable().getVariableDecl(ILUtils.baseName(sons[j]));
                this.unit.publicSymbolTable().getVariableDecl(ILUtils.baseName(sons[j]));
                int offset1 = this.unit.publicSymbolTable().refOffset(sons[j]);
                boolean success = this.unit.declaredMemoryMap.setEquivalence(variableDecl0, offset0, variableDecl1, offset1, this.unit.publicSymbolTable(), this.unit.publicSymbolTable());
                if (success) continue;
                TapEnv.fileWarning(5, sons[j], "(TC26) Incorrect equivalence");
            }
        }
    }

    protected void computeSave(SymbolTable symbolTable, Instruction saveInstr) {
        Tree saveTree = saveInstr.tree;
        this.commonEquivList = new TapList<TapPair<Tree, SymbolTable>>(new TapPair<Tree, SymbolTable>(saveTree, symbolTable), this.commonEquivList);
        this.declareCommonEquivsRec(saveTree, symbolTable, saveInstr);
    }

    protected void setSaveAll() {
        this.saveAll = true;
    }

    protected boolean getSaveAll() {
        return this.saveAll;
    }

    protected void computeSaveVarDecls(SymbolTable symbolTable, TapList<SymbolDecl> varDecls) {
        while (varDecls != null) {
            FunctionDecl funDecl;
            TapList<FunctionDecl> funDecls = symbolTable.getTopFunctionDecl(((SymbolDecl)varDecls.head).symbol, null, null, false);
            FunctionDecl functionDecl = funDecl = funDecls == null ? null : (FunctionDecl)funDecls.head;
            if (funDecl == null) {
                this.computeSaveVarDecl(symbolTable, (VariableDecl)varDecls.head);
            }
            varDecls = varDecls.tail;
        }
    }

    protected void computeSaveVarDecl(SymbolTable symbolTable, VariableDecl varDecl) {
        this.commonEquivList = new TapList<TapPair<Tree, SymbolTable>>(new TapPair<Tree, SymbolTable>(ILUtils.build(166, ILUtils.build(94, varDecl.symbol)), symbolTable), this.commonEquivList);
        this.declareCommonEquivsSaveRec(varDecl, symbolTable);
    }

    protected Tree checkArrayAccessOrCall(SymbolTable symbolTable, Tree tree) {
        Tree result = tree;
        if (this.checkArrayAccessOrCall) {
            SymbolDecl symbolDecl;
            Tree arrayTree;
            boolean hasNoPointerAccess;
            boolean hasNoTriplet = !ILUtils.oneIsArrayTriplet(tree.down(2));
            boolean bl = hasNoPointerAccess = tree.down(1).opCode() != 148;
            if (hasNoTriplet && hasNoPointerAccess && (arrayTree = tree.down(1)).isAtom() && (!((symbolDecl = symbolTable.getSymbolDecl(arrayTree.stringValue())) instanceof VariableDecl) || !((VariableDecl)symbolDecl).isVariableName && !WrapperTypeSpec.hasAnArrayDimension(symbolDecl.type()))) {
                TypeDecl typeDecl = symbolTable.getTypeDecl(arrayTree.stringValue());
                result = typeDecl != null && TypeSpec.isA(typeDecl.typeSpec, 21) ? ILUtils.build(46, ILUtils.copy(tree.down(1)), ILUtils.copy(tree.down(1)), ILUtils.reverseArrayComponentOrder(tree.down(2))) : ILUtils.buildCall(ILUtils.copy(tree.down(1)), ILUtils.reverseArrayComponentOrder(tree.down(2)));
            }
        }
        return result;
    }

    protected boolean checkStatementFunctionDecl(SymbolTable symbolTable, Tree tree) {
        VariableDecl variableDecl;
        if (tree.down(1).opCode() == 8 && tree.down(1).down(1).isAtom() && ((variableDecl = symbolTable.getVariableDecl(tree.down(1).down(1).stringValue())) == null || variableDecl.type() != null && variableDecl.type().wrappedType != null && !TypeSpec.isA(variableDecl.type().peelPointer(), 2)) && this.allFormalArgs(tree.down(1).down(2).children())) {
            Tree indices = ILUtils.reverseArrayComponentOrder(tree.down(1).down(2));
            Tree newStmtFunc = ILUtils.build(173, ILUtils.buildCall(ILUtils.copy(tree.down(1).down(1)), indices), ILUtils.copy(tree.down(2)));
            this.statementFunctions = new TapList<Tree>(newStmtFunc, this.statementFunctions);
            return true;
        }
        return false;
    }

    private boolean allFormalArgs(Tree[] args) {
        boolean result = true;
        for (Tree arg : args) {
            result = arg.opCode() == 94 && result;
        }
        return result;
    }

    protected Tree checkStatementFunctionCall(Tree tree) {
        Tree defTree = null;
        String funName = null;
        if (ILUtils.getCalledName(tree).isAtom()) {
            funName = ILUtils.getCalledName(tree).stringValue();
            defTree = this.getStatementFunctionDecl(funName);
        }
        Tree result = null;
        if (defTree != null) {
            Tree[] vars = ILUtils.getArguments(tree).children();
            Tree[] params = ILUtils.getArguments(defTree.down(1)).children();
            result = ILUtils.copy(defTree);
            assert (result != null);
            result = result.down(2);
            if (vars.length != params.length) {
                TapEnv.fileWarning(15, tree, "(TC32) Conflicting numbers of arguments for statement function " + funName + ", expected " + params.length + ", is here " + vars.length);
            }
            for (int i = 0; i < Math.min(vars.length, params.length); ++i) {
                InFunction.replaceAllIdent(result, params[i], vars[i]);
            }
            result = ILUtils.copy(result);
            ILUtils.setOrigTree(result, tree);
        }
        return result;
    }

    private Tree getStatementFunctionDecl(String functionName) {
        TapList<Tree> inStatementFunctions = this.statementFunctions;
        Tree found = null;
        while (found == null && inStatementFunctions != null) {
            if (ILUtils.getCalledName(((Tree)inStatementFunctions.head).down(1)).stringValue().equals(functionName)) {
                found = (Tree)inStatementFunctions.head;
            }
            inStatementFunctions = inStatementFunctions.tail;
        }
        return found;
    }

    protected void addPublicPrivateDecl(String publicPrivateDecl, Tree instructionTree) {
        if (this.publicPrivateDefault == null) {
            this.publicPrivateDefault = publicPrivateDecl;
        } else {
            TapEnv.fileWarning(5, instructionTree, "(DD18) Incorrect " + publicPrivateDecl + " declaration");
        }
    }

    protected void addBindCDecl(SymbolTable symbolTable, Tree instructionTree) {
        this.bindCDeclarationList = new TapList<TapPair<SymbolTable, Tree>>(new TapPair<SymbolTable, Tree>(symbolTable, instructionTree), this.bindCDeclarationList);
    }

    private String getCNameFromCommon(String commonName) {
        String cName = null;
        TapList<TapPair<SymbolTable, Tree>> bindCList = this.bindCDeclarationList;
        String cNameTmp = commonName.substring(1, commonName.length() - 1);
        if (bindCList == null) {
            cName = this.unit.callGraph().getOtherLanguageName(cNameTmp, 1, 4);
        } else {
            while (bindCList != null && cName == null) {
                Tree bindTree = (Tree)((TapPair)bindCList.head).second;
                int nbVar = 1;
                if (bindTree.opCode() == 194) {
                    nbVar = bindTree.down(3).length();
                }
                for (int i = 1; i <= nbVar; ++i) {
                    String fortranName;
                    if (bindTree.opCode() == 194) {
                        fortranName = ILUtils.baseName(bindTree.down(3).down(i));
                    } else if (bindTree.opCode() == 94) {
                        fortranName = ILUtils.baseName(bindTree);
                        cName = this.unit.callGraph().getOtherLanguageName(cNameTmp, 1, 4);
                    } else {
                        fortranName = ILUtils.baseName(bindTree.down(2).down(i));
                    }
                    assert (fortranName != null);
                    if (cName != null || !fortranName.equals(commonName)) continue;
                    cName = ILUtils.getBindCValue((Tree)((TapPair)bindCList.head).second, i);
                }
                bindCList = bindCList.tail;
            }
        }
        return cName;
    }

    protected void declareBindCInMemoryMap() {
        TapList<TapPair<SymbolTable, Tree>> bindCList = this.bindCDeclarationList;
        VariableDecl cVarDecl = null;
        if (bindCList != null && this.unit.callGraph().declaredMemoryMap == null) {
            this.unit.callGraph().declaredMemoryMap = new MemoryMap();
        }
        MemoryMap globalCMemoryMap = this.unit.callGraph().declaredMemoryMap;
        while (bindCList != null) {
            Tree bindTree = (Tree)((TapPair)bindCList.head).second;
            int nbVar = 1;
            if (bindTree.opCode() == 194) {
                nbVar = bindTree.down(3).length();
            }
            for (int i = 1; i <= nbVar; ++i) {
                String fortranName;
                if (bindTree.opCode() == 194) {
                    fortranName = ILUtils.baseName(bindTree.down(3).down(i));
                    this.unit.setLanguageAndUp(3);
                    this.unit.translationUnitSymbolTable().setLanguage(3);
                } else if (bindTree.opCode() == 94) {
                    fortranName = bindTree.stringValue();
                } else {
                    fortranName = ILUtils.baseName(bindTree.down(2).down(i));
                    this.unit.setLanguageAndUp(3);
                    this.unit.translationUnitSymbolTable().setLanguage(3);
                }
                assert (fortranName != null);
                VariableDecl fortranVarDecl = ((SymbolTable)((TapPair)bindCList.head).first).getVariableDecl(fortranName);
                String cName = ILUtils.getBindCValue((Tree)((TapPair)bindCList.head).second, i);
                if (cName == null) {
                    cName = this.getCNameFromCommon(fortranName);
                }
                if (this.unit.callGraph().cRootSymbolTable() != null) {
                    cVarDecl = this.unit.callGraph().cRootSymbolTable().getVariableDecl(cName);
                }
                if (cVarDecl != null) {
                    if (fortranVarDecl != null) {
                        fortranVarDecl.renamedFromSymbolDecl = cVarDecl;
                        cVarDecl.renamedFromSymbolDecl = fortranVarDecl;
                        globalCMemoryMap.setEquivalence(fortranVarDecl, 0, cVarDecl, 0, this.unit.publicSymbolTable(), this.unit.callGraph().cRootSymbolTable());
                        this.unit.declaredMemoryMap.setEquivalence(fortranVarDecl, 0, cVarDecl, 0, this.unit.callGraph().cRootSymbolTable(), this.unit.callGraph().cRootSymbolTable());
                        continue;
                    }
                    this.unit.declaredMemoryMap.bindVariableAndCommon(fortranName, cVarDecl, this.unit);
                    if (bindTree.opCode() != 94) continue;
                    assert (fortranName != null);
                    String commonName = fortranName.substring(1, fortranName.length() - 1);
                    cVarDecl.renamedFromSymbolDecl = cVarDecl.copy(null, null);
                    cVarDecl.renamedFromSymbolDecl.symbol = commonName;
                    cVarDecl.renamedFromSymbolDecl.kind = 11;
                    continue;
                }
                TypeDecl fortranTypeDecl = ((SymbolTable)((TapPair)bindCList.head).first).getTypeDecl(fortranName);
                TapList<SymbolTable> tuSymbolTables = this.unit.callGraph().getTranslationUnitSymbolTables();
                TapList<TypeDecl> cTypeDecls = null;
                while (tuSymbolTables != null) {
                    if (((SymbolTable)tuSymbolTables.head).unit.isC()) {
                        TypeDecl cTypeDecl = ((SymbolTable)tuSymbolTables.head).getTypeDecl(cName);
                        if (cTypeDecl == null) {
                            cTypeDecl = ((SymbolTable)tuSymbolTables.head).getTypeDecl("struct " + cName);
                        }
                        if (cTypeDecl != null) {
                            this.unit.callGraph().addBindFortranCType(fortranTypeDecl, cTypeDecl);
                            cTypeDecls = new TapList<TypeDecl>(cTypeDecl, cTypeDecls);
                        }
                    }
                    tuSymbolTables = tuSymbolTables.tail;
                }
                if (cTypeDecls != null || bindTree.opCode() == 94) continue;
                this.unit.callGraph().addBindFortranCType(fortranTypeDecl, null);
                if (bindTree.down(2).opCode() == 187) continue;
                TapEnv.fileWarning(5, (Tree)((TapPair)bindCList.head).second, "(TC26) bind(C) " + fortranName + " with " + cName + " ignored");
            }
            bindCList = bindCList.tail;
        }
    }
}

