/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.FunctionTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class FunctionDecl
extends SymbolDecl {
    public int formalArgRank = -1;
    private TapList zones;
    public SymbolTable definitionSymbolTable;
    public Tree declarator;
    public FunctionDecl[] initFunctionDecls;
    private TapList<Unit> toUnit = new TapList<Object>(null, null);

    public FunctionDecl() {
    }

    public FunctionDecl(Tree identTree, Unit unit) {
        super(identTree, 3);
        this.toUnit.head = unit;
    }

    public FunctionDecl(Tree identTree, Unit unit, SymbolTable symbolTable) {
        super(identTree, 3);
        this.toUnit.head = unit;
        this.definitionSymbolTable = symbolTable;
    }

    public FunctionDecl(Tree identTree, Unit unit, SymbolTable symbolTable, String className) {
        super(identTree, 3);
        this.className = className;
        this.toUnit.head = unit;
        this.definitionSymbolTable = symbolTable;
    }

    public Unit unit() {
        return (Unit)this.toUnit.head;
    }

    public void setUnit(Unit unit) {
        this.toUnit.head = unit;
    }

    public void shareUnitFrom(FunctionDecl otherFunctionDecl) {
        this.toUnit = otherFunctionDecl.toUnit;
    }

    public void deleteUnitIfDifferent(Unit otherUnit, CallGraph callGraph) {
        if (this.toUnit.head != null && this.toUnit.head != otherUnit && !((Unit)this.toUnit.head).isInterface()) {
            callGraph.deleteUnit((Unit)this.toUnit.head);
            this.toUnit.head = null;
        }
    }

    @Override
    public boolean isTarget(WrapperTypeSpec modelTypeSpec) {
        if (this.type() == null) {
            return false;
        }
        if (modelTypeSpec == null || modelTypeSpec.wrappedType == null) {
            return true;
        }
        return modelTypeSpec.canMatchPointerTo(this.type());
    }

    @Override
    public TapList zones() {
        return this.zones;
    }

    public void setZones(TapList value) {
        this.zones = value;
    }

    public FunctionTypeSpec functionTypeSpec() {
        return this.toUnit.head == null ? null : ((Unit)this.toUnit.head).functionTypeSpec();
    }

    @Override
    public WrapperTypeSpec type() {
        return this.toUnit.head == null ? null : new WrapperTypeSpec(((Unit)this.toUnit.head).functionTypeSpec());
    }

    public boolean isStandard() {
        return this.toUnit.head != null && ((Unit)this.toUnit.head).isStandard();
    }

    @Override
    public boolean isExternal() {
        return this.toUnit.head != null && ((Unit)this.toUnit.head).isExternal();
    }

    public boolean isIntrinsic() {
        return this.toUnit.head != null && ((Unit)this.toUnit.head).isIntrinsic();
    }

    public boolean isVarFunction() {
        return this.toUnit.head != null && ((Unit)this.toUnit.head).isVarFunction();
    }

    public boolean isInterface() {
        return this.toUnit.head != null && ((Unit)this.toUnit.head).isInterface();
    }

    public boolean isRenamed() {
        return this.toUnit.head != null && ((Unit)this.toUnit.head).isRenamed();
    }

    public boolean isElemental() {
        return this.toUnit.head != null && ((Unit)this.toUnit.head).isElemental();
    }

    public boolean isIntrinsicNotElemental() {
        return this.toUnit.head != null && ((Unit)this.toUnit.head).isIntrinsicNotElemental();
    }

    public boolean isModule() {
        return this.toUnit.head != null && ((Unit)this.toUnit.head).isModule();
    }

    public boolean declarationMatchesCall(TypeSpec callResultType, TypeSpec[] callArgTypes) {
        if (this.toUnit.head != null && ((Unit)this.toUnit.head).functionTypeSpec() != null) {
            FunctionTypeSpec funcTypeSpec = ((Unit)this.toUnit.head).functionTypeSpec();
            funcTypeSpec = (FunctionTypeSpec)funcTypeSpec.localize(new TapList<Object>(null, null), new ToBool(false));
            return funcTypeSpec.matchesCall(callResultType, callArgTypes);
        }
        return false;
    }

    public boolean sameTypes(WrapperTypeSpec otherReturnType, WrapperTypeSpec[] otherArgumentsTypes) {
        if (this.toUnit.head != null && ((Unit)this.toUnit.head).functionTypeSpec() != null) {
            return ((Unit)this.toUnit.head).functionTypeSpec().sameTypes(otherReturnType, otherArgumentsTypes);
        }
        return false;
    }

    public WrapperTypeSpec[] argumentsTypesSpec() {
        if (this.toUnit.head != null && ((Unit)this.toUnit.head).functionTypeSpec() != null) {
            return ((Unit)this.toUnit.head).functionTypeSpec().argumentsTypes;
        }
        return null;
    }

    public WrapperTypeSpec returnTypeSpec() {
        if (this.toUnit.head != null && ((Unit)this.toUnit.head).functionTypeSpec() != null) {
            return ((Unit)this.toUnit.head).functionTypeSpec().returnType;
        }
        return null;
    }

    @Override
    public void dump(int indent) throws IOException {
        TapEnv.print(this.symbol + ": ");
        if (this.renamedFromSymbolDecl != null) {
            TapEnv.print("(=>" + this.renamedFromSymbolDecl.symbol + ") ");
        }
        if (this.toUnit.head == null) {
            TapEnv.print(" unspecified type function");
        } else if (((Unit)this.toUnit.head).isModule()) {
            TapEnv.print(" module " + this.toUnit.head);
        } else {
            if (((Unit)this.toUnit.head).functionTypeSpec() == null) {
                TapEnv.print("unknown type");
            } else {
                ((Unit)this.toUnit.head).functionTypeSpec().dump();
            }
            if (this.isIntrinsic()) {
                TapEnv.print(" intrinsic");
            } else if (this.isInterface()) {
                TapEnv.print(" interface");
            } else if (this.isVarFunction()) {
                TapEnv.print(" varfunction");
            } else if (this.isExternal()) {
                TapEnv.print(" external");
            }
            TapEnv.print(" function " + this.toUnit.head);
        }
        if (this.extraInfo() != null) {
            TapEnv.print(" " + this.extraInfo());
        }
        TapEnv.print(" depends on: " + this.dependsOn());
        TapEnv.print(" isActive(): " + this.isActiveSymbolDecl());
    }
}

