/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.FunctionTypeSpec;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.TopDownTreeWalk;
import fr.inria.tapenade.utils.Tree;

final class InFunction {
    protected final Unit inlinedUnit;
    protected final Unit copiedUnit;
    private final Tree callingTree;
    protected Instruction callingInstruction;
    protected int rank = -1;
    private Tree resultTree;
    private FunctionTypeSpec functionTypeSpec;

    protected InFunction(Unit inF, Tree call, Block callingBlock, Tree result) {
        this.inlinedUnit = inF;
        this.insertMetaVar();
        this.callingTree = call;
        if (result != null) {
            this.resultTree = ILUtils.copy(result);
        }
        this.copiedUnit = Unit.copyUnitForInline(this.inlinedUnit);
        TapList<Block> copiedBlocks = this.copiedUnit.allBlocks;
        while (copiedBlocks != null) {
            ((Block)copiedBlocks.head).parallelControls = callingBlock.parallelControls;
            copiedBlocks = copiedBlocks.tail;
        }
        this.functionTypeSpec = (FunctionTypeSpec)call.getAnnotation("functionTypeSpec");
        if (this.functionTypeSpec == null) {
            this.functionTypeSpec = (FunctionTypeSpec)this.inlinedUnit.functionTypeSpec().localize(new TapList<Object>(null, null), new ToBool(false));
            call.setAnnotation("functionTypeSpec", this.functionTypeSpec);
        }
    }

    private static void replaceVariable(Tree treeOld, Tree treeNew, TapList<Block> blocks) {
        while (blocks != null) {
            Block currentBlock = (Block)blocks.head;
            TapList<Instruction> instructions = currentBlock.instructions;
            while (instructions != null) {
                Instruction instruction = (Instruction)instructions.head;
                if (treeNew.isAtom()) {
                    if (instruction.whereMask() != null) {
                        InFunction.replaceAllIdent(instruction.whereMask().getControlTree(), treeOld, treeNew);
                    }
                    InFunction.replaceAllIdent(instruction.tree, treeOld, treeNew);
                } else {
                    if (instruction.whereMask() != null) {
                        InFunction.replaceAll(instruction.whereMask().getControlTree(), treeOld, treeNew);
                    }
                    InFunction.replaceAll(instruction.tree, treeOld, treeNew);
                }
                instructions = instructions.tail;
            }
            blocks = blocks.tail;
        }
    }

    private static void replaceAll(Tree tree, Tree oldTree, Tree newTree) {
        TapList<Tree> trees = InFunction.getAll(tree, oldTree);
        while (trees != null) {
            Tree currentTree = (Tree)trees.head;
            currentTree.parent().setChild(ILUtils.copy(newTree), currentTree.rankInParent());
            trees = trees.tail;
        }
    }

    private static TapList<Tree> getAll(Tree tree, Tree oldTree) {
        TapList<Tree> result = null;
        TopDownTreeWalk i = new TopDownTreeWalk(tree);
        while (!i.atEnd()) {
            Tree currentTree = i.get();
            if (currentTree.equalsTree(oldTree)) {
                result = new TapList<Tree>(currentTree, result);
            }
            i.advance();
        }
        return result;
    }

    public static void replaceAllIdent(Tree tree, Tree oldTree, Tree newTree) {
        if (newTree.isStringAtom() && newTree.opCode() == oldTree.opCode()) {
            String newTreeValue = newTree.stringValue();
            TopDownTreeWalk i = new TopDownTreeWalk(tree);
            while (!i.atEnd()) {
                Tree currentTree = i.get();
                if (currentTree.equalsTree(oldTree)) {
                    currentTree.setValue(newTreeValue);
                }
                i.advance();
            }
        } else {
            InFunction.replaceAll(tree, oldTree, newTree);
        }
    }

    private static String createNewVarName(String name, SymbolTable symbolTable) {
        int i = 1;
        while (symbolTable.getVariableDecl(name + i) != null) {
            ++i;
        }
        return name + i;
    }

    protected TapList<Block> allBlocks() {
        return this.copiedUnit.allBlocks;
    }

    private void insertMetaVar() {
        Tree callTree = this.inlinedUnit.entryBlock().headTree();
        assert (callTree != null);
        Tree unitName = ILUtils.getCalledName(callTree);
        Tree[] args = ILUtils.getArguments(callTree).children();
        InFunction.replaceVariable(unitName, ILUtils.build(121, unitName.stringValue()), new TapList<Block>(this.inlinedUnit.entryBlock(), this.inlinedUnit.allBlocks));
        for (Tree arg : args) {
            InFunction.replaceVariable(arg, ILUtils.build(121, arg.stringValue()), new TapList<Block>(this.inlinedUnit.entryBlock(), this.inlinedUnit.allBlocks));
        }
    }

    protected Tree replaceAllVariables(SymbolTable symbolTable, SymbolTable privateSymbolTable) {
        Tree[] newTrees = ILUtils.getArguments(this.callingTree).children();
        assert (this.inlinedUnit.entryBlock().headTree() != null);
        Tree[] oldTrees = ILUtils.getArguments(this.inlinedUnit.entryBlock().headTree()).children();
        Tree functionName = ILUtils.getCalledName(this.inlinedUnit.entryBlock().headTree());
        for (int i = 0; i < oldTrees.length; ++i) {
            if (!ILUtils.instrHasSideEffect(newTrees[i]) && this.cost(newTrees[i]) < 100) {
                InFunction.replaceVariable(oldTrees[i], newTrees[i], this.allBlocks());
                continue;
            }
            this.insertLocalVariable(oldTrees[i], newTrees[i], symbolTable, privateSymbolTable, i);
        }
        Tree newFunctionName = null;
        Tree functionNameIdent = ILUtils.build(121, functionName.stringValue());
        if (this.resultTree != null) {
            this.replaceLeftVariableInAssign(functionNameIdent, this.resultTree, null, symbolTable);
        } else {
            NewSymbolHolder symbolHolder = this.declareNewVarName(functionName.stringValue(), symbolTable);
            newFunctionName = symbolHolder.makeNewRef(privateSymbolTable);
            this.replaceLeftVariableInAssign(functionNameIdent, newFunctionName, symbolHolder, symbolTable);
        }
        return newFunctionName;
    }

    private void replaceLeftVariableInAssign(Tree treeOld, Tree treeNew, NewSymbolHolder symbolHolder, SymbolTable symbolTable) {
        VariableDecl newVarDecl = null;
        TapList<Block> blocks = this.allBlocks();
        if (symbolHolder != null) {
            newVarDecl = symbolHolder.newVariableDecl();
        }
        while (blocks != null) {
            Block currentBlock = (Block)blocks.head;
            TapList<Instruction> instructions = currentBlock.instructions;
            while (instructions != null) {
                Instruction instruction = (Instruction)instructions.head;
                if (instruction.tree.opCode() == 13) {
                    Tree tree1 = instruction.tree.down(1);
                    if (tree1.equalsTree(treeOld)) {
                        instruction.tree.setChild(ILUtils.copy(treeNew), 1);
                    } else if (tree1.opCode() == 148 && tree1.down(1).equalsTree(treeOld)) {
                        tree1.setChild(ILUtils.copy(treeNew), 1);
                    }
                    WrapperTypeSpec curTypeSpec = symbolTable.typeOf(instruction.tree.down(2));
                    if (newVarDecl != null && newVarDecl.type() != curTypeSpec && curTypeSpec != null) {
                        TapList<ArrayDim> dims;
                        newVarDecl.type().receives(curTypeSpec, null, null);
                        if (TypeSpec.isA(newVarDecl.type(), 2) && (dims = newVarDecl.type().getAllDimensions()) == null && TypeSpec.isA(curTypeSpec, 2)) {
                            ((ArrayTypeSpec)newVarDecl.type().wrappedType).setDimensions(((ArrayTypeSpec)curTypeSpec.wrappedType).dimensions());
                        }
                    }
                }
                instructions = instructions.tail;
            }
            blocks = blocks.tail;
        }
    }

    private void insertLocalVariable(Tree formalArg, Tree actualArg, SymbolTable symbolTable, SymbolTable privateSymbolTable, int rank) {
        Block firstBlock = (Block)this.allBlocks().head;
        TapList<Instruction> instructions = firstBlock.instructions;
        Tree leftTree = ILUtils.copy(formalArg);
        assert (leftTree != null);
        String newVarName = InFunction.createNewVarName(leftTree.stringValue(), symbolTable);
        leftTree.setValue(newVarName);
        Tree tree = ILUtils.build(13, leftTree, ILUtils.copy(actualArg));
        WrapperTypeSpec newVarType = this.functionTypeSpec.argumentsTypes != null ? this.functionTypeSpec.argumentsTypes[rank] : new WrapperTypeSpec(null);
        VariableDecl varDecl = new VariableDecl(leftTree, newVarType);
        privateSymbolTable.addSymbolDecl(varDecl);
        Tree varDeclaration = varDecl.buildVarDeclaration(privateSymbolTable);
        InFunction.replaceVariable(formalArg, leftTree, this.allBlocks());
        TapList<Instruction> lastinstruction = null;
        while (instructions != null) {
            lastinstruction = instructions;
            instructions = instructions.tail;
        }
        assert (lastinstruction != null);
        Instruction newInstr = new Instruction(varDeclaration, ((Instruction)lastinstruction.head).syntaxController, ((Instruction)lastinstruction.head).block);
        privateSymbolTable.declarationsBlock.addInstrHdAfterDecls(newInstr);
        newInstr = new Instruction(tree, ((Instruction)lastinstruction.head).syntaxController, ((Instruction)lastinstruction.head).block);
        TapList newTail = new TapList(lastinstruction.head, lastinstruction.tail);
        lastinstruction.head = newInstr;
        lastinstruction.tail = newTail;
        InFunction.replaceVariable(leftTree, ILUtils.build(94, leftTree.stringValue()), this.allBlocks());
    }

    private NewSymbolHolder declareNewVarName(String name, SymbolTable symbolTable) {
        FunctionDecl oldFunctionDecl;
        WrapperTypeSpec typeSpec = null;
        TapList<FunctionDecl> oldFunctionDecls = symbolTable.getFunctionDecl(name, null, null, false);
        FunctionDecl functionDecl = oldFunctionDecl = oldFunctionDecls == null ? null : (FunctionDecl)oldFunctionDecls.head;
        if (oldFunctionDecl != null) {
            typeSpec = this.functionTypeSpec.returnType;
            if (typeSpec.wrappedType == null && oldFunctionDecl.unit() != null && oldFunctionDecl.functionTypeSpec() != null) {
                typeSpec = oldFunctionDecl.functionTypeSpec().returnType;
            }
        }
        NewSymbolHolder symbolHolder = new NewSymbolHolder(name);
        Tree newTree = symbolHolder.makeNewRef(symbolTable);
        assert (typeSpec != null);
        typeSpec = typeSpec.checkNoneDimensionsOfNewSH(name, name, newTree, symbolTable, symbolHolder);
        symbolHolder.setAsVariable(typeSpec, null);
        symbolHolder.declarationLevelMustInclude(symbolTable);
        return symbolHolder;
    }

    private int cost(Tree tree) {
        int result;
        switch (tree.opCode()) {
            case 101: 
            case 155: {
                result = 2;
                break;
            }
            case 8: {
                result = 2 + this.cost(tree.down(2).children());
                break;
            }
            case 2: {
                result = 5 + this.cost(tree.down(1)) + this.cost(tree.down(2));
                break;
            }
            case 131: {
                result = 20 + this.cost(tree.down(1)) + this.cost(tree.down(2));
                break;
            }
            case 61: {
                result = 30 + this.cost(tree.down(1)) + this.cost(tree.down(2));
                break;
            }
            case 30: {
                result = 100 + this.cost(ILUtils.getArguments(tree).children());
                break;
            }
            default: {
                result = 10;
            }
        }
        return result;
    }

    private int cost(Tree[] tree) {
        int result = 0;
        for (Tree value : tree) {
            result += this.cost(value);
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("InFunction ");
        result.append(this.inlinedUnit);
        result.append(" rank ");
        result.append(this.rank);
        result.append(System.lineSeparator());
        if (this.callingInstruction != null) {
            result.append(this.callingInstruction).append(System.lineSeparator());
        }
        if (this.callingTree != null) {
            result.append(this.callingTree).append(System.lineSeparator());
        }
        TapList<Block> allBlocks = this.copiedUnit.allBlocks;
        while (allBlocks != null) {
            result.append("    Block ").append(allBlocks.head).append(" instructions:").append(((Block)allBlocks.head).instructions).append(System.lineSeparator());
            allBlocks = allBlocks.tail;
        }
        return result.toString();
    }
}

