/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.BasicBlock;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.EntryBlock;
import fr.inria.tapenade.representation.ExitBlock;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.FunctionTypeSpec;
import fr.inria.tapenade.representation.HeaderBlock;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.InFunction;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.TopDownTreeWalk;
import fr.inria.tapenade.utils.Tree;

public final class InlinedFunctions {
    private transient TapList<Unit> inlinedUnits = null;
    private transient TapList<InFunction> foundFunctions;
    private boolean reRunSplit;
    private Tree valueOfInline;

    public TapList<Unit> getInlinedUnits() {
        return this.inlinedUnits;
    }

    public void setInlinedUnits(TapList<Unit> units) {
        this.inlinedUnits = units;
    }

    public void findInlinedFunctions(Unit unit) {
        this.findInlinedFunctionsRun(unit);
        while (this.reRunSplit) {
            this.findInlinedFunctionsRun(unit);
        }
    }

    private void findInlinedFunctionsRun(Unit unit) {
        this.foundFunctions = null;
        this.reRunSplit = false;
        TapList<Block> blocks = unit.allBlocks();
        while (blocks != null) {
            Block currentBlock = (Block)blocks.head;
            this.foundFunctions = this.findInlinedFunctions(currentBlock);
            if (this.foundFunctions != null && currentBlock.isALoop() && ((Instruction)currentBlock.instructions.head).tree.down((int)3).operator().code == 201) {
                this.extractInlineFromTest(currentBlock);
                this.reRunSplit = true;
                this.foundFunctions = null;
            }
            if (this.foundFunctions != null) {
                this.splitBlock(currentBlock, unit.symbolTablesBottomUp(), currentBlock.symbolTable, unit);
            }
            blocks = blocks.tail;
        }
        unit.coherence();
    }

    private TapList<InFunction> findInlinedFunctions(Block block) {
        int rank = 0;
        TapList<InFunction> foundRank = null;
        TapList<Instruction> instructions = block.instructions;
        SymbolTable symbolTable = block.symbolTable;
        while (instructions != null) {
            Instruction instruction = (Instruction)instructions.head;
            InFunction found = null;
            if (!instruction.isADeclaration(true)) {
                found = this.findInlinedFunctions(instruction, block, symbolTable);
            }
            if (found != null) {
                found.callingInstruction = instruction;
                found.rank = rank;
                foundRank = TapList.append(foundRank, new TapList<InFunction>(found, null));
            }
            instructions = instructions.tail;
            ++rank;
        }
        return foundRank;
    }

    private void extractInlineFromTest(Block block) {
        Tree whileTree = ((Instruction)block.instructions.head).tree.down(3);
        Tree testTree = ILUtils.copy(whileTree.down(1));
        String trueString = "true";
        if (block.unit().isFortran()) {
            trueString = ".true.";
        } else if (block.unit().isC()) {
            trueString = "1";
        }
        whileTree.setChild(ILUtils.build(94, trueString), 1);
        BasicBlock newTestBlock = new BasicBlock(block.symbolTable, block.parallelControls, null);
        Tree ifTree = ILUtils.build(96);
        ifTree.setChild(testTree, 1);
        newTestBlock.instructions = new TapList<Instruction>(new Instruction(ifTree, null), null);
        newTestBlock.setOrigLabel(block.origLabel());
        FGArrow nextArrow = block.getFGArrowTestCase(30, 1);
        newTestBlock.setEnclosingLoop(block.enclosingLoop());
        nextArrow.insertBlockAtDest(newTestBlock, 20, 2);
        FGArrow exitArrow = block.getFGArrowTestCase(30, 0);
        Block exitLoopBlock = exitArrow.destination;
        new FGArrow((Block)newTestBlock, 20, 5, exitLoopBlock);
        block.enclosingLoop().inside.tail = new TapList<BasicBlock>(newTestBlock, block.enclosingLoop().inside.tail);
    }

    private void splitBlock(Block block, TapList<SymbolTable> sortedSymbolTables, SymbolTable localST, Unit unit) {
        Block newLastBlock;
        int i;
        TapList<Block> resultBlocks = null;
        TapIntList instructionRank = null;
        TapList<InFunction> inFunc = this.foundFunctions;
        int oldrank = -1;
        while (inFunc != null) {
            int r = ((InFunction)inFunc.head).rank;
            if (r != oldrank) {
                instructionRank = TapIntList.append(instructionRank, new TapIntList(r, null));
                oldrank = r;
            } else {
                this.reRunSplit = true;
            }
            inFunc = inFunc.tail;
        }
        TapList<Instruction>[] listInstructions = TapList.split(block.instructions, instructionRank);
        Block[] newBlocks = new Block[listInstructions.length];
        for (i = 0; i < listInstructions.length; ++i) {
            if (listInstructions[i] == null) continue;
            BasicBlock newBlock1 = new BasicBlock(block.symbolTable, block.parallelControls, null);
            block.copyIntoWithoutArrows(newBlock1, new TapList<Object>(null, null));
            newBlock1.setOrigLabel(null);
            newBlock1.rank = block.rank + i + 100;
            newBlock1.instructions = listInstructions[i];
            newBlocks[i] = newBlock1;
        }
        for (i = 0; i < listInstructions.length; ++i) {
            if (0 >= i) continue;
            Block prev = newBlocks[i - 1] != null ? newBlocks[i - 1] : (1 < i ? newBlocks[i - 2] : null);
            Block next = newBlocks[i] != null ? newBlocks[i] : null;
            if (prev == null || next == null) continue;
            new FGArrow(prev, 0, 0, next, false);
        }
        TapList<Block>[] newinBlocks = this.inlineBlocks(newBlocks, sortedSymbolTables, localST);
        i = 0;
        while (2 * i + 1 < newBlocks.length) {
            if (newBlocks[2 * i] != null) {
                resultBlocks = TapList.append(resultBlocks, new TapList<Block>(newBlocks[2 * i], null));
            }
            resultBlocks = TapList.append(resultBlocks, newinBlocks[i]);
            ++i;
        }
        if (newBlocks.length - newBlocks.length / 2 * 2 == 1 && newBlocks[newBlocks.length - 1] != null) {
            resultBlocks = TapList.append(resultBlocks, new TapList<Block>(newBlocks[newBlocks.length - 1], null));
        }
        Block newFirstBlock = null;
        Block newHeaderBlock = null;
        TapList<Block> newBlocksAfterHeader = null;
        Block curBlock = null;
        if (block instanceof HeaderBlock) {
            if (block.isALoop()) {
                TapList<Object> toList;
                TapList<Object> tlList = toList = new TapList<Object>(null, null);
                while (resultBlocks != null) {
                    curBlock = (Block)resultBlocks.head;
                    if (resultBlocks.tail == null) {
                        newHeaderBlock = new HeaderBlock(curBlock.symbolTable, curBlock.parallelControls, null);
                        newHeaderBlock.replaceInFlowGraph(curBlock);
                        curBlock = newHeaderBlock;
                    } else {
                        tlList = tlList.placdl(curBlock);
                    }
                    if (newFirstBlock == null) {
                        newFirstBlock = curBlock;
                    }
                    resultBlocks = resultBlocks.tail;
                }
                tlList.placdl(block.enclosingLoop());
                newLastBlock = curBlock;
                unit.updateNestsOfBlocks(block.enclosingLoop(), toList.tail);
            } else {
                assert (resultBlocks != null);
                curBlock = (Block)resultBlocks.head;
                newFirstBlock = new HeaderBlock(curBlock.symbolTable, curBlock.parallelControls, null);
                newFirstBlock.replaceInFlowGraph(curBlock);
                newHeaderBlock = newFirstBlock;
                newHeaderBlock.setOrigLabel(block.origLabel());
                newBlocksAfterHeader = resultBlocks.tail;
                newLastBlock = newBlocksAfterHeader != null ? TapList.last(newBlocksAfterHeader) : newHeaderBlock;
            }
            newBlocksAfterHeader = new TapList<Block>(newHeaderBlock, newBlocksAfterHeader);
        } else {
            assert (resultBlocks != null);
            newFirstBlock = (Block)resultBlocks.head;
            newFirstBlock.setOrigLabel(block.origLabel());
            newBlocksAfterHeader = resultBlocks;
            newLastBlock = TapList.last(resultBlocks);
        }
        TapList<FGArrow> flow = block.backFlow();
        while (flow != null) {
            FGArrow arrow = (FGArrow)flow.head;
            if (!arrow.inACycle) {
                arrow.redirectDestination(newFirstBlock);
            } else {
                arrow.redirectDestination(newHeaderBlock);
            }
            flow = flow.tail;
        }
        flow = block.flow();
        while (flow != null) {
            ((FGArrow)flow.head).redirectOrigin(newLastBlock);
            flow = flow.tail;
        }
        unit.updateNestsOfBlocks(block, newBlocksAfterHeader);
    }

    private InFunction findInlinedFunctions(Instruction instruction, Block callingBlock, SymbolTable symbolTable) {
        InFunction found = null;
        Tree resultTree = null;
        TopDownTreeWalk downTreeWalk = new TopDownTreeWalk(instruction.tree);
        while (!downTreeWalk.atEnd()) {
            Tree currentTree = downTreeWalk.get();
            if (currentTree.opCode() == 30 && currentTree.parent() != null) {
                String functionName = ILUtils.getCallFunctionNameString(currentTree);
                WrapperTypeSpec actualReturnType = symbolTable.typeOf(currentTree.parent().opCode() == 13 ? currentTree.parent().down(1) : currentTree);
                Tree[] actualArgs = ILUtils.getArguments(currentTree).children();
                int nbActualArgs = actualArgs.length;
                WrapperTypeSpec[] actualArgsTypes = new WrapperTypeSpec[nbActualArgs];
                for (int i = 0; i < nbActualArgs; ++i) {
                    actualArgsTypes[i] = actualArgs[i].opCode() == 136 ? new WrapperTypeSpec(null) : symbolTable.typeOf(actualArgs[i]);
                }
                Unit inlinedUnit = this.findInlinedUnit(functionName, actualArgsTypes, actualReturnType, currentTree);
                if (inlinedUnit != null) {
                    if (currentTree.parent().opCode() == 13) {
                        resultTree = currentTree.parent().down(1);
                    }
                    InFunction inF = new InFunction(inlinedUnit, currentTree, callingBlock, resultTree);
                    if (found == null) {
                        found = inF;
                    } else {
                        this.reRunSplit = true;
                    }
                }
            }
            downTreeWalk.advance();
        }
        return found;
    }

    private TapList<Block>[] inlineBlocks(Block[] blocks, TapList<SymbolTable> sortedSymbolTables, SymbolTable localST) {
        TapList[] newinBlocks = new TapList[blocks.length / 2 + 1];
        int i = 0;
        while (2 * i + 1 < blocks.length) {
            Tree instruction;
            if (blocks[2 * i + 1].instructions != null && blocks[2 * i + 1].instructions.head != null && (instruction = ((Instruction)blocks[2 * i + 1].instructions.head).tree) != null) {
                newinBlocks[i] = this.inlineBlock(instruction, blocks, (InFunction)this.foundFunctions.head, 2 * i + 1, sortedSymbolTables, localST);
            }
            this.foundFunctions = this.foundFunctions.tail;
            ++i;
        }
        return newinBlocks;
    }

    private Unit findInlinedUnit(String name, WrapperTypeSpec[] actualArgsTypes, WrapperTypeSpec actualReturnType, Tree tree) {
        Unit found = null;
        boolean foundName = false;
        TapList<Unit> inList = this.inlinedUnits;
        while (found == null && inList != null) {
            Unit inlineableUnit = (Unit)inList.head;
            if (inlineableUnit.name.equals(name)) {
                foundName = true;
                FunctionTypeSpec funcTypeSpec = (FunctionTypeSpec)inlineableUnit.functionTypeSpec().localize(new TapList<Object>(null, null), new ToBool(false));
                if (funcTypeSpec.matchesCall(actualReturnType, actualArgsTypes) && actualReturnType.receivesVectorNeglectSizes(funcTypeSpec.returnType)) {
                    found = inlineableUnit;
                }
            }
            inList = inList.tail;
        }
        if (found == null && foundName) {
            TapEnv.fileWarning(15, tree, "Inline, bad number of arguments or types in call of " + name + " in " + ILUtils.toString(tree));
        }
        return found;
    }

    private TapList<Block> inlineBlock(Tree instruction, Block[] blocks, InFunction foundinFunction, int rank, TapList<SymbolTable> sortedSymbolTables, SymbolTable localST) {
        Block currentBlock = blocks[rank];
        this.valueOfInline = foundinFunction.replaceAllVariables(localST, localST);
        TapList<Block> inAllBlocks = foundinFunction.allBlocks();
        inAllBlocks = TapList.append(inAllBlocks, new TapList<Block>(currentBlock, null));
        this.changeFlow(blocks[rank], inAllBlocks, foundinFunction);
        this.updateSymbolTableAndLastBlock(instruction, foundinFunction, currentBlock, inAllBlocks, sortedSymbolTables);
        Instruction firstInstruction = ((Block)inAllBlocks.head).headInstr();
        Object message = instruction.getAnnotation("message");
        if (message != null) {
            firstInstruction.tree.setAnnotation("message", message);
        }
        return inAllBlocks;
    }

    private void changeFlow(Block block, TapList<Block> blocks, InFunction ffunction) {
        while (blocks != null) {
            Block currentblock = (Block)blocks.head;
            if (!(currentblock instanceof HeaderBlock)) {
                this.entryArrows(block, currentblock, ffunction);
                this.exitArrows(block, currentblock, ffunction);
            }
            blocks = blocks.tail;
        }
    }

    private void updateSymbolTableAndLastBlock(Tree instTree, InFunction foundinFunction, Block block, TapList<Block> blocks, TapList<SymbolTable> sortedSymbolTables) {
        TapList<TapPair<SymbolTable, SymbolTable>> associationsST = new TapList<TapPair<SymbolTable, SymbolTable>>(new TapPair<SymbolTable, SymbolTable>(foundinFunction.copiedUnit.publicSymbolTable(), block.symbolTable), null);
        while (blocks != null && blocks.tail != null) {
            Block currentBlock = (Block)blocks.head;
            SymbolTable newSymbolTable = currentBlock.symbolTable.smartCopy(associationsST, null, null, null);
            currentBlock.symbolTable.cleanCopySymbolDecls();
            System.arraycopy(newSymbolTable.basisSymbolTable().implicits, 0, newSymbolTable.implicits, 0, 26);
            if (newSymbolTable.isUseless()) {
                newSymbolTable = newSymbolTable.basisSymbolTable();
            }
            currentBlock.symbolTable = newSymbolTable;
            if (!TapList.contains(sortedSymbolTables, newSymbolTable)) {
                TapList newTail = new TapList(sortedSymbolTables.head, sortedSymbolTables.tail);
                sortedSymbolTables.head = newSymbolTable;
                sortedSymbolTables.tail = newTail;
            }
            blocks = blocks.tail;
        }
        Tree assignLeftTree = null;
        boolean done = false;
        String infunctionName = foundinFunction.inlinedUnit.name;
        TopDownTreeWalk downTreeWalk = new TopDownTreeWalk(instTree);
        while (!downTreeWalk.atEnd()) {
            Tree currentTree = downTreeWalk.get();
            if (!done && currentTree.opCode() == 30 && currentTree.parent() != null && infunctionName.equals(ILUtils.getCalledNameString(currentTree))) {
                if (currentTree.parent().opCode() != 13) {
                    currentTree.parent().setChild(ILUtils.copy(this.valueOfInline), currentTree.rankInParent());
                } else {
                    assignLeftTree = currentTree.parent().down(1);
                    block.instructions = block.instructions.tail;
                }
                if (assignLeftTree != null) {
                    currentTree.parent().setChild(ILUtils.copy(assignLeftTree), currentTree.rankInParent());
                }
                done = true;
            }
            downTreeWalk.advance();
        }
    }

    private void entryArrows(Block block, Block curblock, InFunction ffunction) {
        EntryBlock entryBlock = ffunction.copiedUnit.entryBlock();
        TapList<FGArrow> backFlow = curblock.backFlow();
        FGArrow entryArrow = null;
        while (backFlow != null) {
            FGArrow arrow = (FGArrow)backFlow.head;
            if (arrow.origin == entryBlock) {
                entryArrow = arrow;
                arrow.delete();
            }
            backFlow = backFlow.tail;
        }
        if (entryArrow != null) {
            backFlow = block.backFlow();
            while (backFlow != null) {
                ((FGArrow)backFlow.head).redirectDestination(curblock);
                backFlow = backFlow.tail;
            }
        }
    }

    private void exitArrows(Block block, Block curblock, InFunction ffunction) {
        ExitBlock exitBlock = ffunction.copiedUnit.exitBlock();
        TapList<FGArrow> flow = curblock.flow();
        while (flow != null) {
            FGArrow arrow = (FGArrow)flow.head;
            if (arrow.destination == exitBlock) {
                arrow.redirectDestination(block);
            }
            flow = flow.tail;
        }
    }

    public String toString() {
        return "InlinedFunctions " + this.inlinedUnits + System.lineSeparator();
    }
}

