/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.Directive;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.InstructionMask;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class Instruction {
    public Tree tree;
    public Tree preComments;
    public Tree postComments;
    public Tree preCommentsBlock;
    public Tree postCommentsBlock;
    public Block block;
    public TapList<Directive> directives;
    public Instruction syntaxController;
    public boolean isPhantom;
    public TapList<TapPair<TapIntList, BoolVector>> pointerDestsChanges;
    public boolean isDifferentiated;
    private InstructionMask whereMask;
    private boolean isMaskDefinition;
    private Instruction fromInclude;
    private TapList<Unit> interfaceUnits;

    public Instruction() {
    }

    public Instruction(Tree tree) {
        this.tree = tree;
    }

    public Instruction(Tree tree, Instruction syntaxController) {
        this.tree = tree;
        this.syntaxController = syntaxController;
    }

    public Instruction(Tree tree, Instruction syntaxController, Block block) {
        this.tree = tree;
        this.syntaxController = syntaxController;
        this.block = block;
    }

    public static Instruction createUnitDefinitionStub(Unit definedUnit, Block containerBlock) {
        return new Instruction(Instruction.createUnitDefinitionStubTree(definedUnit), null, containerBlock);
    }

    public static Tree createUnitDefinitionStubTree(Unit definedUnit) {
        int stubOp;
        int n = definedUnit.isClass() ? 35 : (stubOp = definedUnit.isModule() ? 129 : 87);
        int nameRank = definedUnit.isClass() ? 2 : (definedUnit.isModule() ? 1 : 4);
        Tree defTree = ILUtils.build(stubOp);
        defTree.setAnnotation("Unit", definedUnit);
        defTree.setChild(ILUtils.build(94, definedUnit.name), nameRank);
        return defTree;
    }

    public static Instruction fromIncludeCopy(Instruction fromIncludeInstr, boolean copy) {
        Instruction result;
        if (fromIncludeInstr == null) {
            result = null;
        } else {
            Instruction copiedOneFromInclude = result = new Instruction(copy ? ILUtils.copy(fromIncludeInstr.tree) : fromIncludeInstr.tree);
            Instruction fromIncl = fromIncludeInstr.fromInclude;
            while (fromIncl != null) {
                copiedOneFromInclude.fromInclude = new Instruction(copy ? ILUtils.copy(fromIncl.tree) : fromIncl.tree);
                fromIncl = fromIncl.fromInclude;
                copiedOneFromInclude = copiedOneFromInclude.fromInclude;
            }
        }
        return result;
    }

    private static Instruction smartCopyInstruction(Instruction origInstruction, TapList<TapPair<Instruction, Instruction>> instructionCopies) {
        Instruction resultInstruction;
        TapPair place = TapList.assq(origInstruction, instructionCopies);
        Tree origTree = origInstruction.tree;
        if (place == null || place.second == null) {
            resultInstruction = new Instruction(ILUtils.copy(origTree));
            instructionCopies.placdl(new TapPair<Instruction, Instruction>(origInstruction, resultInstruction));
        } else {
            resultInstruction = (Instruction)place.second;
        }
        resultInstruction.fromInclude = origInstruction.fromInclude;
        return resultInstruction;
    }

    private static Tree addComment(Tree oldComment, String content) {
        Tree newComment = ILUtils.build(175, content);
        if (oldComment != null) {
            oldComment.addChild(newComment, 1);
            return oldComment;
        }
        return ILUtils.build(36, newComment);
    }

    public static Instruction differentiateChainedIncludes(Instruction includeInstr, String suffix, boolean wait) {
        String originalIncludeString = includeInstr.tree.stringValue();
        TapTriplet<String, String, Tree> diffIncludeInfo = TapEnv.getSetDiffIncludeInfo(originalIncludeString);
        if (diffIncludeInfo.second == null) {
            if (wait) {
                if (diffIncludeInfo.third == null) {
                    diffIncludeInfo.third = ILUtils.copy(includeInstr.tree);
                }
            } else {
                String diffIncludeFileName = TapEnv.differentiateIncludeName(originalIncludeString, suffix);
                diffIncludeInfo.second = diffIncludeFileName;
                if (diffIncludeInfo.third == null) {
                    diffIncludeInfo.third = ILUtils.copy(includeInstr.tree);
                }
                ((Tree)diffIncludeInfo.third).setValue(diffIncludeFileName);
            }
        }
        Instruction diffIncludeInstr = new Instruction((Tree)diffIncludeInfo.third);
        if (includeInstr.fromInclude != null && !ILUtils.isNullOrEmptyAtom(includeInstr.fromInclude.tree)) {
            diffIncludeInstr.fromInclude = Instruction.differentiateChainedIncludes(includeInstr.fromInclude, suffix, wait);
        }
        return diffIncludeInstr;
    }

    public static TapList<Unit> usedUnits(Tree tree, TapList<Unit> collected, SymbolTable symbolTable) {
        if (tree == null) {
            return collected;
        }
        switch (tree.opCode()) {
            case 13: 
            case 44: {
                collected = Instruction.usedUnits(tree.down(2), collected, symbolTable);
                break;
            }
            case 194: {
                collected = Instruction.usedUnits(tree.down(3), collected, symbolTable);
                break;
            }
            case 9: 
            case 53: {
                Tree[] decls = tree.children();
                for (int i = decls.length - 1; i >= 0; --i) {
                    collected = Instruction.usedUnits(decls[i], collected, symbolTable);
                }
                break;
            }
            case 30: {
                collected = Instruction.usedUnits(ILUtils.getCalledName(tree), collected, symbolTable);
                break;
            }
            case 94: {
                Unit found;
                String funcName = ILUtils.getIdentString(tree);
                FunctionDecl funcDecl = funcName == null ? null : symbolTable.getFunctionNotInterfaceDecl(funcName);
                Unit unit = found = funcDecl == null ? null : funcDecl.unit();
                if (found == null) break;
                collected = new TapList<Unit>(found, collected);
                break;
            }
            case 3: 
            case 122: {
                collected = Instruction.usedUnits(tree.down(1), collected, symbolTable);
                break;
            }
            case 2: 
            case 21: 
            case 61: 
            case 114: 
            case 131: 
            case 164: 
            case 177: {
                collected = Instruction.usedUnits(tree.down(1), collected, symbolTable);
                collected = Instruction.usedUnits(tree.down(2), collected, symbolTable);
                break;
            }
            case 4: 
            case 10: 
            case 27: 
            case 31: 
            case 88: 
            case 99: 
            case 101: 
            case 116: 
            case 136: 
            case 150: 
            case 155: 
            case 175: 
            case 187: 
            case 197: {
                break;
            }
            case 35: 
            case 45: 
            case 55: 
            case 87: 
            case 129: 
            case 134: 
            case 154: {
                break;
            }
            case 46: 
            case 56: 
            case 66: 
            case 156: 
            case 168: 
            case 190: 
            case 193: {
                break;
            }
            default: {
                TapEnv.toolError("(usedUnits) unexpected operator " + tree.opName());
            }
        }
        return collected;
    }

    public InstructionMask whereMask() {
        return this.whereMask;
    }

    public boolean isMaskDefinition() {
        return this.isMaskDefinition;
    }

    protected void declareIsMaskDefinition() {
        this.isMaskDefinition = true;
    }

    public Instruction fromInclude() {
        return this.fromInclude;
    }

    private Instruction fromIncludeRoot() {
        Instruction result = this.fromInclude;
        while (result.fromInclude != null) {
            result = result.fromInclude;
        }
        return result;
    }

    public String fromIncludeRootName() {
        if (this.fromInclude == null) {
            return null;
        }
        Instruction result = this.fromIncludeRoot();
        if (result.tree != null && result.tree.opCode() == 99) {
            return result.tree.stringValue();
        }
        return null;
    }

    public void setFromInclude(Instruction incl) {
        this.fromInclude = incl;
    }

    public void updateUnitDefinitionStub(Unit definedUnit) {
        int nameRank = definedUnit.isClass() ? 2 : (definedUnit.isModule() ? 1 : 4);
        this.tree.setAnnotation("Unit", definedUnit);
        this.tree.setChild(ILUtils.build(94, definedUnit.name), nameRank);
    }

    public Unit isUnitDefinitionStub() {
        return this.tree == null ? null : (Unit)this.tree.getAnnotation("Unit");
    }

    public boolean syntaxControls(Instruction controlled) {
        while (controlled != null && controlled != this) {
            controlled = controlled.syntaxController;
        }
        return controlled != null;
    }

    public boolean isALoop() {
        return this.tree != null && this.tree.opCode() == 119;
    }

    public int getPosition() {
        return this.tree == null ? -1 : ILUtils.position(this.tree);
    }

    public void setPosition(Instruction refInstr) {
        int refPos;
        int n = refPos = refInstr == null ? -1 : refInstr.getPosition();
        if (this.tree != null) {
            ILUtils.setPosition(this.tree, refPos);
        }
    }

    public Instruction copy(TapList<TapPair<Instruction, Instruction>> whereMaskCopies) {
        Instruction copyInstr = new Instruction(this.tree.copy());
        copyInstr.preComments = this.preComments;
        copyInstr.postComments = this.postComments;
        copyInstr.preCommentsBlock = this.preCommentsBlock;
        copyInstr.postCommentsBlock = this.postCommentsBlock;
        copyInstr.directives = this.directives;
        copyInstr.whereMask = null;
        if (this.whereMask != null) {
            Instruction localTest = this.whereMask.controlInstruction;
            Instruction result = Instruction.smartCopyInstruction(localTest, whereMaskCopies);
            copyInstr.whereMask = this.whereMask.copy();
            copyInstr.whereMask.controlInstruction = result;
        }
        copyInstr.isMaskDefinition = this.isMaskDefinition;
        copyInstr.fromInclude = Instruction.fromIncludeCopy(this.fromInclude, true);
        copyInstr.isPhantom = this.isPhantom;
        copyInstr.interfaceUnits = this.interfaceUnits;
        return copyInstr;
    }

    public Tree copyTreePlusComments() {
        Tree copyTree;
        if (this.tree == null) {
            return null;
        }
        Tree postCommentsLocation = copyTree = ILUtils.copy(this.tree);
        if (copyTree.opCode() == 119 && copyTree.down(3) != null) {
            postCommentsLocation = copyTree.down(3);
        }
        if (this.preComments != null) {
            copyTree.setAnnotation("preComments", ILUtils.copy(this.preComments));
        }
        if (this.preCommentsBlock != null) {
            copyTree.setAnnotation("preCommentsBlock", ILUtils.copy(this.preCommentsBlock));
        }
        if (this.postComments != null) {
            postCommentsLocation.setAnnotation("postComments", ILUtils.copy(this.postComments));
        }
        if (this.postCommentsBlock != null) {
            postCommentsLocation.setAnnotation("postCommentsBlock", ILUtils.copy(this.postCommentsBlock));
        }
        return copyTree;
    }

    public Directive hasDirective(int kind) {
        return Directive.hasDirective(this.directives, kind);
    }

    public boolean isAWhereControl() {
        return this.tree.opCode() == 200 && this.tree.down(2).opCode() == 136 && this.tree.down(3).opCode() == 136 && this.tree.getAnnotation("notemptywhere") == null;
    }

    public InstructionMask getWhereMask() {
        if (this.tree == null) {
            return null;
        }
        if (this.whereMask != null && this.isAWhereControl()) {
            return this.whereMask.enclosingMask;
        }
        return this.whereMask;
    }

    public void setWhereMask(InstructionMask whereMask) {
        this.whereMask = whereMask;
    }

    public int whereMaskDepth() {
        return this.whereMask == null ? 0 : this.whereMask.depth();
    }

    public String containsPreComment(String searched) {
        if (this.preComments == null) {
            return null;
        }
        Tree[] preCommentStringTrees = this.preComments.children();
        String found = null;
        for (int i = preCommentStringTrees.length - 1; i >= 0 && found == null; --i) {
            if (preCommentStringTrees[i].opCode() != 175 || !preCommentStringTrees[i].stringValue().toLowerCase().contains(searched)) continue;
            found = preCommentStringTrees[i].stringValue();
        }
        return found;
    }

    public void addPreComments(String newComment) {
        this.preComments = Instruction.addComment(this.preComments, newComment);
    }

    public void appendPreComments(TapList<Tree> newComments) {
        if (newComments != null) {
            this.preComments = ILUtils.appendComments(this.preComments, newComments, 36);
        }
    }

    public void appendPostComments(TapList<Tree> newComments) {
        if (newComments != null) {
            this.postComments = ILUtils.appendComments(this.postComments, newComments, 36);
        }
    }

    public boolean isAProcedure() {
        return this.tree.opCode() == 87 || this.tree.opCode() == 154;
    }

    public boolean isADeclaration(boolean data) {
        return ILUtils.isADeclaration(this.tree, data);
    }

    public boolean isADeclaration(boolean data, SymbolTable symbolTable) {
        if (symbolTable != null && symbolTable.unit != null && !symbolTable.unit.isFortran()) {
            return false;
        }
        return ILUtils.isADeclaration(this.tree, data);
    }

    public TapList<SymbolDecl> declaredSymbolDecls(SymbolTable publicSymbolTable, SymbolTable privateSymbolTable) {
        TapList<SymbolDecl> result = null;
        switch (this.tree.opCode()) {
            case 194: {
                result = this.getSymbolDeclsFrom(this.tree.down(3), publicSymbolTable, privateSymbolTable);
                break;
            }
            case 44: {
                result = this.getSymbolDeclsFrom(this.tree.down(2), publicSymbolTable, privateSymbolTable);
                break;
            }
            case 197: {
                result = this.getSymbolDeclsFrom(this.tree, publicSymbolTable, privateSymbolTable);
                break;
            }
            case 187: {
                if (this.tree.down(1).opCode() != 94) break;
                SymbolDecl symbDecl = null;
                if (privateSymbolTable != null) {
                    symbDecl = privateSymbolTable.getTopSymbolDecl(ILUtils.baseName(this.tree.down(1)));
                }
                if (symbDecl == null) {
                    symbDecl = publicSymbolTable.getTopSymbolDecl(ILUtils.baseName(this.tree.down(1)));
                }
                if (symbDecl == null) break;
                result = new TapList<SymbolDecl>(symbDecl, null);
                break;
            }
            case 1: {
                if (this.tree.down(2).opCode() != 70) break;
                result = this.getSymbolDeclsFrom(this.tree.down(2), publicSymbolTable, privateSymbolTable);
                break;
            }
            case 72: 
            case 106: 
            case 166: {
                result = this.getSymbolDeclsFrom(this.tree, publicSymbolTable, privateSymbolTable);
                break;
            }
            case 38: {
                result = this.getSymbolDeclsFrom(this.tree.down(2), publicSymbolTable, privateSymbolTable);
                break;
            }
        }
        return result;
    }

    private TapList<SymbolDecl> getSymbolDeclsFrom(Tree declarators, SymbolTable publicSymbolTable, SymbolTable privateSymbolTable) {
        TapList<SymbolDecl> result = null;
        SymbolDecl symbDecl = null;
        for (int i = declarators.length(); i > 0; --i) {
            if (privateSymbolTable != null) {
                symbDecl = privateSymbolTable.getTopSymbolDecl(ILUtils.baseName(declarators.down(i)));
            }
            if (symbDecl == null && publicSymbolTable != null) {
                symbDecl = publicSymbolTable.getTopSymbolDecl(ILUtils.baseName(declarators.down(i)));
            }
            if (symbDecl == null) continue;
            result = new TapList<SymbolDecl>(symbDecl, result);
        }
        return result;
    }

    public void setFromIncludeCopy(Instruction origInclude, boolean copy) {
        Instruction copiedInclude = Instruction.fromIncludeCopy(origInclude, copy);
        this.setFromInclude(copiedInclude);
    }

    public boolean isInStdCInclude() {
        return (TapEnv.relatedLanguageIsC() || TapEnv.relatedLanguage() == 100) && this.isInStdInclude();
    }

    public boolean isInStdInclude() {
        boolean inStd = false;
        Instruction include = this.fromInclude;
        if (include != null && this.tree.opCode() == 99 && this.tree.stringValue().equals(include.tree.stringValue())) {
            include = include.fromInclude();
        }
        while (include != null && !inStd) {
            inStd = include.tree != null && TapEnv.isStdIncludeName(include.tree.stringValue());
            include = include.fromInclude;
        }
        return inStd;
    }

    public void setIncludeOfDiffInstructions(Instruction primalInstruction, TapList<Instruction> diffInstructionS, String suffix) {
        if (!TapEnv.get().expandDiffIncludeFile && this.tree != null && this.tree.stringValue() != null && !this.tree.stringValue().isEmpty()) {
            Instruction diffInclude = this;
            if (!TapEnv.alreadyDiffInclude(this.tree.stringValue())) {
                diffInclude = Instruction.differentiateChainedIncludes(this, suffix, diffInstructionS == null);
            }
            while (diffInstructionS != null) {
                ((Instruction)diffInstructionS.head).fromInclude = diffInclude;
                diffInstructionS = diffInstructionS.tail;
            }
            if (primalInstruction != null) {
                primalInstruction.fromInclude = diffInclude;
                if (primalInstruction.tree != null && primalInstruction.tree.opCode() == 99 && primalInstruction.tree.stringValue().equals(this.tree.stringValue())) {
                    primalInstruction.tree = diffInclude.tree;
                }
            }
        }
    }

    public void forceDiffInclude(String suffix) {
        String originalIncludeString = this.tree.stringValue();
        TapTriplet<String, String, Tree> diffIncludeInfo = TapEnv.getSetDiffIncludeInfo(originalIncludeString);
        if (diffIncludeInfo.second == null) {
            diffIncludeInfo.second = TapEnv.differentiateIncludeName(originalIncludeString, suffix);
        }
    }

    public boolean checkAccessModifiers(VariableDecl varDecl, boolean isLocalDeclared, VariableDecl origVarDecl, Block inDiffBlock, SymbolTable diffSymbolTable, boolean onPrimalDecl) {
        boolean declRemoved = false;
        Tree instructionTree = this.tree;
        if (instructionTree != null) {
            if (instructionTree.down(3).length() == 1) {
                Instruction instr;
                if (!onPrimalDecl && origVarDecl.hasOtherInstruction()) {
                    instructionTree.setChild(varDecl.type().generateTree(diffSymbolTable, null, null, true, null), 2);
                }
                if (varDecl.extraInfo() != null) {
                    TapList<String> extraInfo = varDecl.extraInfo();
                    TapList<Tree> newModifiers = null;
                    while (extraInfo != null) {
                        String modifier = (String)extraInfo.head;
                        if (!(modifier.equals("save") && origVarDecl.hasInstructionWithRootOperator(166, null) || ILUtils.contains(instructionTree, 128, modifier) != null || onPrimalDecl && (!modifier.equals("out") || origVarDecl.hasOtherInstruction()))) {
                            newModifiers = new TapList<Tree>(ILUtils.build(94, modifier), newModifiers);
                        }
                        extraInfo = extraInfo.tail;
                    }
                    if (newModifiers != null) {
                        instructionTree.setChild(ILUtils.build(127, ILUtils.build(128, TapList.reverse(newModifiers)), instructionTree.cutChild(2)), 2);
                    }
                }
                if (instructionTree.down(2).opCode() == 127 && this.containsModifiers("out") && !TapList.containsEquals(varDecl.extraInfo(), "out")) {
                    ILUtils.peelModifier(instructionTree, "out");
                } else if (instructionTree.down(2).opCode() == 127 && this.containsModifiers("in") && !TapList.containsEquals(varDecl.extraInfo(), "in")) {
                    ILUtils.peelModifier(instructionTree, "in");
                } else if (instructionTree.down(2).opCode() == 127 && this.containsModifiers("inout") && !TapList.containsEquals(varDecl.extraInfo(), "inout")) {
                    ILUtils.peelModifier(instructionTree, "inout");
                } else if (instructionTree.down(2).opCode() == 127 && this.containsModifiers("constant") && !TapList.containsEquals(varDecl.extraInfo(), "constant")) {
                    ILUtils.peelModifier(instructionTree, "constant");
                } else if (instructionTree.down(2).opCode() == 127 && this.containsModifiers("const") && !varDecl.isCconst()) {
                    ILUtils.peelModifier(instructionTree, "const");
                }
                if (!TapList.containsEquals(origVarDecl.extraInfo(), "out") && origVarDecl.hasInstructionWithRootOperator(1, "out") && (instr = inDiffBlock.getOperatorDeclarationInstruction(varDecl, 1, diffSymbolTable)) != null) {
                    instr.tree = ILUtils.build(136);
                }
            } else {
                if (instructionTree.down(2).opCode() != 127 && varDecl.extraInfo() != null) {
                    String modifier = (String)varDecl.extraInfo().head;
                    if (TapEnv.relatedUnit() == inDiffBlock.unit() && !varDecl.hasInstructionWithRootOperator(1, modifier)) {
                        this.removeDeclFromInstruction(varDecl, instructionTree);
                        declRemoved = true;
                    }
                } else if (instructionTree.down(2).opCode() == 127 && this.containsModifiers("out") && !TapList.containsEquals(varDecl.extraInfo(), "out")) {
                    ILUtils.peelModifier(instructionTree, "out");
                }
                if (instructionTree.down(2).opCode() == 127 && this.containsModifiers("optional") && !TapList.containsEquals(varDecl.extraInfo(), "optional")) {
                    this.removeDeclFromInstruction(varDecl, instructionTree);
                    declRemoved = true;
                    instructionTree = null;
                } else if (instructionTree.down(2).opCode() == 127 && this.containsModifiers("constant") && !TapList.containsEquals(varDecl.extraInfo(), "constant")) {
                    this.removeDeclFromInstruction(varDecl, instructionTree);
                    declRemoved = true;
                    instructionTree = null;
                } else if (instructionTree.down(2).opCode() == 127 && this.containsModifiers("const") && !varDecl.isCconst()) {
                    this.removeDeclFromInstruction(varDecl, instructionTree);
                    declRemoved = true;
                    instructionTree = null;
                }
            }
            if (isLocalDeclared && instructionTree != null) {
                if (instructionTree.down(3).length() == 1) {
                    if (instructionTree.down(2).opCode() == 127) {
                        Tree modifiers = instructionTree.down(2).down(1);
                        if (modifiers.length() == 1 && modifiers.down(1).opCode() == 94 && (modifiers.down(1).stringValue().equals("in") || modifiers.down(1).stringValue().equals("out") || modifiers.down(1).stringValue().equals("inout") || modifiers.down(1).stringValue().equals("constant") || modifiers.down(1).stringValue().equals("const") || modifiers.down(1).stringValue().equals("optional"))) {
                            instructionTree.setChild(ILUtils.copy(instructionTree.down(2).down(2)), 2);
                        } else {
                            this.removeDeclFromInstruction(varDecl, instructionTree);
                            declRemoved = true;
                        }
                    }
                } else if (instructionTree.down(2).opCode() == 127) {
                    this.removeDeclFromInstruction(varDecl, instructionTree);
                    declRemoved = true;
                }
            }
        }
        return declRemoved;
    }

    public boolean containsModifiers(String value) {
        boolean result = false;
        if (this.tree.opCode() == 194 && this.tree.down(2).opCode() == 127) {
            result = this.containsModifiersRec(value, this.tree.down(2));
        }
        return result;
    }

    private boolean containsModifiersRec(String value, Tree subTree) {
        Tree modifiers = subTree.down(1);
        boolean found = false;
        int nb = modifiers.length();
        for (int i = 1; !found && i <= nb; ++i) {
            found = modifiers.down(i).opCode() == 94 && modifiers.down(i).stringValue().equals(value);
        }
        boolean result = found;
        if (!result && subTree.down(2).opCode() == 127) {
            result = this.containsModifiersRec(value, subTree.down(2));
        }
        return result;
    }

    public TapList<Unit> declaresUnits(SymbolTable symbolTable) {
        TapList<Unit> found = null;
        if (this.tree != null) {
            if (this.tree.opCode() == 87) {
                FunctionDecl funcDecl;
                String funcName = ILUtils.getIdentString(this.tree.down(4));
                FunctionDecl functionDecl = funcDecl = funcName == null ? null : symbolTable.getFunctionNotInterfaceDecl(funcName);
                if (funcDecl != null) {
                    found = new TapList<Unit>(funcDecl.unit(), null);
                }
            } else if (this.tree.opCode() == 194) {
                Tree[] declarators = this.tree.down(3).children();
                for (int i = declarators.length - 1; i >= 0; --i) {
                    FunctionDecl funcDecl;
                    if (declarators[i].opCode() != 88) continue;
                    String funcName = ILUtils.getIdentString(declarators[i].down(1));
                    FunctionDecl functionDecl = funcDecl = funcName == null ? null : symbolTable.getFunctionNotInterfaceDecl(funcName);
                    if (funcDecl == null) continue;
                    found = new TapList<Unit>(funcDecl.unit(), found);
                }
            }
        }
        return found;
    }

    private void removeDeclFromInstruction(VariableDecl varDecl, Tree instructionTree) {
        int rankDecl = 0;
        for (int i = 1; i <= instructionTree.down(3).length() && rankDecl == 0; ++i) {
            Tree curDecl = ILUtils.baseTree(instructionTree.down(3).down(i));
            assert (curDecl != null);
            if (curDecl.opCode() != 94 || !curDecl.stringValue().equals(varDecl.symbol)) continue;
            rankDecl = i;
        }
        if (rankDecl > 0) {
            instructionTree.down(3).removeChild(rankDecl);
        }
        varDecl.setNullInstruction();
    }

    public Tree replaceTree(Tree oldTree, Tree newTree) {
        if (newTree == null || newTree == oldTree) {
            return oldTree;
        }
        if (this.tree == oldTree) {
            this.tree = newTree;
        } else {
            oldTree.parent().setChild(newTree, oldTree.rankInParent());
        }
        return newTree;
    }

    public void setInterfaceUnits(TapList<Unit> units) {
        this.interfaceUnits = units;
        while (units != null) {
            ((Unit)units.head).setInterfaceDeclaration(this);
            units = units.tail;
        }
    }

    public void dump() throws IOException {
        InstructionMask mask = this.getWhereMask();
        if (mask != null) {
            TapEnv.print("whereMask:");
            mask.dump();
        }
        TapEnv.print(" ");
        if (this.isPhantom) {
            TapEnv.print("phantom: ");
        }
        if (this.tree != null) {
            if (this.tree.getAnnotation("Unit") != null) {
                TapEnv.print("<Definition of " + this.tree.getAnnotation("Unit") + ">");
            } else {
                TapEnv.print(ILUtils.toString(this.tree));
            }
            int lineNumber = ILUtils.getLineNumber(this.tree);
            if (lineNumber != 0) {
                TapEnv.print(" +line:" + lineNumber);
            }
        } else {
            TapEnv.print("null tree");
        }
        if (this.preComments != null) {
            TapEnv.print(" +Instruction preComments ");
            ILUtils.dump(this.preComments, 0);
        }
        if (this.postComments != null) {
            TapEnv.print(" +Instruction postComments ");
            ILUtils.dump(this.postComments, 0);
        }
        if (this.preCommentsBlock != null) {
            TapEnv.print(" +Instruction preCommentsBlock ");
            ILUtils.dump(this.preCommentsBlock, 0);
        }
        if (this.postCommentsBlock != null) {
            TapEnv.print(" +Instruction postCommentsBlock ");
            ILUtils.dump(this.postCommentsBlock, 0);
        }
        if (this.fromInclude != null) {
            TapEnv.print(" from ");
            this.fromInclude.dump();
        }
        if (this.directives != null) {
            TapEnv.print(" directives ");
            TapEnv.print(this.directives.toString());
        }
    }

    public String toString() {
        String result = "Instr:";
        if (this.isPhantom) {
            result = "(phantom)" + result;
        }
        if (this.whereMask != null) {
            result = result + this.whereMask;
        }
        result = this.tree == null ? result + "null_tree" : (this.tree.getAnnotation("Unit") != null ? result + "<Definition of " + this.tree.getAnnotation("Unit") + ">" : result + this.tree);
        if (this.fromInclude != null) {
            result = result + " {from " + this.fromInclude + " @" + Integer.toHexString(this.fromInclude.hashCode()) + ":@" + (this.fromInclude.tree == null ? "null" : Integer.toHexString(this.fromInclude.tree.hashCode())) + '}';
        }
        return result;
    }
}

