/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class InstructionMask {
    public Instruction controlInstruction = new Instruction();
    public boolean isTrueBranch = true;
    public InstructionMask enclosingMask;

    public InstructionMask(Tree localControl, InstructionMask enclosingMask) {
        this.controlInstruction.tree = localControl;
        this.enclosingMask = enclosingMask;
    }

    public static boolean equalMasks(InstructionMask mask1, InstructionMask mask2) {
        if (mask1 == null || mask1.isEmpty()) {
            return mask2 == null || mask2.isEmpty();
        }
        return mask2 != null && !mask2.isEmpty() && mask1.controlInstruction.tree == mask2.controlInstruction.tree && mask1.isTrueBranch == mask2.isTrueBranch;
    }

    public Tree getControlTree() {
        return this.controlInstruction.tree;
    }

    public void setControlTree(Tree tree) {
        this.controlInstruction.tree = tree;
    }

    public InstructionMask createElseMask() {
        InstructionMask elseMask = this.copy();
        elseMask.isTrueBranch = false;
        return elseMask;
    }

    public int depth() {
        return this.enclosingMask == null ? 1 : this.enclosingMask.depth();
    }

    public boolean isEmpty() {
        return this.controlInstruction == null || ILUtils.isNullOrNone(this.controlInstruction.tree);
    }

    protected InstructionMask copy() {
        InstructionMask result = new InstructionMask(null, this.enclosingMask);
        result.controlInstruction = this.controlInstruction;
        result.isTrueBranch = this.isTrueBranch;
        return result;
    }

    public Tree rebuildTree() {
        Tree tree1;
        Tree result = ILUtils.copy(this.controlInstruction.tree);
        if (!this.isTrueBranch) {
            result = ILUtils.build(137, result);
        }
        Tree tree = tree1 = this.enclosingMask == null ? null : this.enclosingMask.rebuildTree();
        if (tree1 != null) {
            result = ILUtils.build(5, tree1, result);
        }
        return result;
    }

    public void dump() throws IOException {
        TapEnv.print(this.toString());
    }

    public String toString() {
        return (this.enclosingMask == null ? "" : this.enclosingMask.toString()) + "<" + (this.isTrueBranch ? "" : "not ") + ILUtils.toString(this.getControlTree()) + ">";
    }
}

