/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.Tree;

public final class IterDescriptor {
    public boolean isArray;
    public boolean isImplicitCompleteDimension = true;
    public boolean allSubArrayAccesses;
    public NewSymbolHolder indexHolder;
    public Tree indexTree;
    public Tree defaultUse;
    private Tree initTree;
    private Tree lengthTree;
    private boolean justAnIndex;
    private int depth;
    private Tree hintRefTree;
    private String hintArrayNameInText = "";
    private Tree hintArrayNameInIdentTree;
    private Tree hintArrayTreeForCallSize;
    private String hintArrayNameInIdent = "";
    private int hintDim;

    public IterDescriptor(int depth, SymbolTable symbolTable, SymbolTable fwdSymbolTable, Tree initIndex, Tree hintRefTree, String hintArrayNameInText, String hintArrayNameInIdent, Tree hintTreeSize, int hintDim, int hintNDims) {
        this.setDepth(depth, symbolTable, fwdSymbolTable);
        this.initTree = initIndex;
        this.hintRefTree = hintRefTree;
        this.hintArrayNameInText = hintArrayNameInText;
        this.hintArrayNameInIdent = hintArrayNameInIdent;
        this.hintArrayTreeForCallSize = hintTreeSize;
        if (symbolTable.unit != null && symbolTable.unit.isFortran()) {
            hintDim = hintNDims + 1 - hintDim;
        }
        this.hintDim = hintDim;
    }

    public IterDescriptor(int depth, SymbolTable symbolTable, Tree initIndex, Tree hintRefTree, String hintArrayNameInText, Tree hintArrayNameInIdentTree, Tree hintTreeSize, int hintDim, int hintNDims) {
        this.setDepth(depth, symbolTable, null);
        this.initTree = initIndex;
        this.hintRefTree = hintRefTree;
        this.hintArrayNameInText = hintArrayNameInText;
        this.hintArrayTreeForCallSize = hintTreeSize;
        this.hintArrayNameInIdentTree = hintArrayNameInIdentTree;
        if ((hintRefTree.opCode() == 8 || hintRefTree.opCode() == 10) && symbolTable.unit != null && symbolTable.unit.isFortran()) {
            hintDim = hintNDims + 1 - hintDim;
        }
        this.hintDim = hintDim;
    }

    public IterDescriptor(Tree doTree) {
        this.indexTree = ILUtils.copy(doTree.down(1));
        this.defaultUse = doTree;
    }

    public IterDescriptor(NewSymbolHolder dirIndexSymbolHolder) {
        this.indexHolder = dirIndexSymbolHolder;
    }

    public void setJustAnIndex(boolean value) {
        this.justAnIndex = value;
    }

    public boolean justAnIndex() {
        return this.justAnIndex;
    }

    public void setHintArrayTreeForCallSize(Tree tree) {
        this.hintArrayTreeForCallSize = tree;
    }

    private void setDepth(int d, SymbolTable symbolTable, SymbolTable fwdSymbolTable) {
        SymbolTable localSymbolTable;
        TapList<Object> inNestedIntIndexSymbolHolders = new TapList<Object>(null, null);
        this.depth = d;
        for (localSymbolTable = symbolTable; localSymbolTable != null && localSymbolTable.nestedIntIndexSymbolHolders == null; localSymbolTable = localSymbolTable.basisSymbolTable()) {
        }
        if (localSymbolTable == null) {
            localSymbolTable = symbolTable;
        }
        assert (localSymbolTable != null);
        if (localSymbolTable.nestedIntIndexSymbolHolders != null) {
            inNestedIntIndexSymbolHolders = localSymbolTable.nestedIntIndexSymbolHolders;
        }
        while (d > 1) {
            if (inNestedIntIndexSymbolHolders.tail == null) {
                inNestedIntIndexSymbolHolders.tail = new TapList<Object>(null, null);
            }
            --d;
            inNestedIntIndexSymbolHolders = inNestedIntIndexSymbolHolders.tail;
        }
        if (inNestedIntIndexSymbolHolders.head == null) {
            this.indexHolder = new NewSymbolHolder("ii" + this.depth);
            if (symbolTable != fwdSymbolTable) {
                this.indexHolder.setOtherDefSymbolTable(fwdSymbolTable);
            }
            this.indexHolder.setAsVariable(symbolTable.getTypeDecl((String)"integer").typeSpec, null);
            inNestedIntIndexSymbolHolders.head = this.indexHolder;
        } else {
            this.indexHolder = (NewSymbolHolder)inNestedIntIndexSymbolHolders.head;
        }
        this.indexHolder.declarationLevelMustInclude(symbolTable);
    }

    public Tree getInitTree() {
        return ILUtils.copy(this.initTree);
    }

    public void setInitTree(Tree initTree) {
        this.initTree = initTree;
    }

    public Tree getLengthTree() {
        return ILUtils.copy(this.lengthTree);
    }

    public void setLengthTree(Tree lengthTree) {
        this.lengthTree = lengthTree;
    }

    public void preciseLengthTree(Tree lengthTree) {
        if (lengthTree != null && (this.lengthTree == null || lengthTree.opCode() == 101)) {
            this.lengthTree = lengthTree;
        }
    }

    public void preciseDefaultLengthTree(Unit targetUnit, SymbolTable symbolTable) {
        if (ILUtils.isNullOrNoneOrStar(this.lengthTree)) {
            if (TapEnv.get().noisize && targetUnit.isFortran() && this.hintArrayTreeForCallSize != null && ILUtils.isAVarRef(this.hintArrayTreeForCallSize, symbolTable)) {
                this.lengthTree = ILUtils.buildCall(ILUtils.build(94, "size"), ILUtils.build(70, ILUtils.copy(this.hintArrayTreeForCallSize), ILUtils.build(101, this.hintDim)));
            } else {
                if (this.hintArrayNameInText.startsWith("#") && this.hintArrayNameInText.endsWith("#")) {
                    this.hintArrayNameInText = this.hintArrayNameInText.substring(1, this.hintArrayNameInText.length() - 1);
                }
                if (this.hintArrayNameInIdent.isEmpty()) {
                    this.hintArrayNameInIdent = ILUtils.toString(this.hintArrayTreeForCallSize);
                    if (this.hintArrayNameInIdent.startsWith("#") && this.hintArrayNameInIdent.endsWith("#")) {
                        this.hintArrayNameInIdent = this.hintArrayNameInIdent.substring(1, this.hintArrayNameInIdent.length() - 1);
                    }
                }
                TapEnv.fileWarning(15, this.hintRefTree, "(AD12) User help requested: unknown dimension " + this.hintDim + " of array " + this.hintArrayNameInText);
                String sizeName = "ISIZE" + this.hintDim + "OF" + this.hintArrayNameInIdent;
                String sizeHint = "the size of dimension " + this.hintDim + " of array " + this.hintArrayNameInText;
                if (this.hintArrayNameInIdentTree != null) {
                    this.lengthTree = this.hintArrayNameInIdentTree;
                    this.lengthTree = ILUtils.build(43, ILUtils.build(94, "ISIZE" + this.hintDim + "OF"), this.lengthTree);
                } else {
                    this.lengthTree = ILUtils.build(94, sizeName);
                }
                if (TapList.rassqString(sizeName, targetUnit.userHelp.tail) == null) {
                    targetUnit.userHelp.placdl(new TapPair<String, String>(sizeHint, sizeName));
                }
            }
            if (this.initTree != null && targetUnit.isFortran()) {
                this.lengthTree = ILUtils.buildSmartAddSub(ILUtils.buildSmartAddSub(this.lengthTree, -1, ILUtils.copy(this.initTree)), 1, ILUtils.build(101, 1));
            }
        }
    }

    public Tree buildIndexTree(SymbolTable usageSymboltable, Unit targetUnit) {
        if (this.justAnIndex) {
            return this.indexHolder.makeNewRef(usageSymboltable);
        }
        if (this.isArray && targetUnit.hasArrayNotation()) {
            if (this.isImplicitCompleteDimension) {
                return ILUtils.build(11);
            }
            this.preciseDefaultLengthTree(targetUnit, usageSymboltable);
            Tree lastTree = ILUtils.buildSmartAddSub(ILUtils.buildSmartAddSub(ILUtils.copy(this.initTree), 1, ILUtils.copy(this.lengthTree)), -1, ILUtils.build(101, 1));
            return ILUtils.build(11, ILUtils.copy(this.initTree), lastTree, ILUtils.build(136));
        }
        if (this.isArray && this.allSubArrayAccesses) {
            return ILUtils.copy(this.initTree);
        }
        return this.indexHolder.makeNewRef(usageSymboltable);
    }

    public Tree buildDoHeaderTree(SymbolTable usageSymboltable, Unit targetUnit, boolean directOrder) {
        if (this.defaultUse != null) {
            return ILUtils.copy(this.defaultUse);
        }
        this.preciseDefaultLengthTree(targetUnit, usageSymboltable);
        Tree lastTree = ILUtils.buildSmartAddSub(ILUtils.buildSmartAddSub(ILUtils.copy(this.initTree), 1, ILUtils.copy(this.lengthTree)), -1, ILUtils.build(101, 1));
        if (lastTree == null) {
            lastTree = ILUtils.build(101, 0);
        }
        if (directOrder) {
            return ILUtils.build(63, this.indexHolder.makeNewRef(usageSymboltable), ILUtils.copy(this.initTree), lastTree);
        }
        return ILUtils.build(63, this.indexHolder.makeNewRef(usageSymboltable), lastTree, ILUtils.copy(this.initTree), ILUtils.build(101, -1));
    }

    public String toString() {
        return "IterDescriptor " + this.indexHolder + (this.isArray ? " ArrayNotation " : " IndexNotation ") + this.initTree + " +>> " + this.lengthTree + " hintSize " + ILUtils.toString(this.hintArrayTreeForCallSize);
    }
}

