/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.HeaderBlock;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class LoopBlock
extends Block {
    public TapList<Block> inside;
    private TapList<LoopBlock> enclosingLoopBLocks;
    public TapList<Block> entryBlocks;
    public TapList<Block> exitBlocks;
    public TapList<FGArrow> exitArrows;
    public TapList<FGArrow> cycleArrows;
    protected TapList<FGArrow> entryArrows;

    protected TapList<LoopBlock> enclosingLoopBLocks() {
        return this.enclosingLoopBLocks;
    }

    protected void setEnclosingLoopBLocks(TapList<LoopBlock> enclosingLoopBLocks) {
        this.enclosingLoopBLocks = enclosingLoopBLocks;
    }

    public LoopBlock(TapList<Block> inside) {
        super(null, null, null);
        this.inside = inside;
    }

    @Override
    public TapList<FGArrow> backFlow() {
        return this.entryArrows;
    }

    @Override
    public TapList<FGArrow> flow() {
        return this.exitArrows;
    }

    public HeaderBlock header() {
        return (HeaderBlock)this.inside.head;
    }

    public Integer staticIterationLength() {
        TapList instructions = this.header().instructions;
        if (instructions == null || instructions.tail != null) {
            return null;
        }
        Instruction instruction = (Instruction)instructions.head;
        Tree tree = instruction.tree;
        if (tree == null || tree.opCode() != 119) {
            return null;
        }
        if ((tree = tree.down(3)) == null || tree.opCode() != 63) {
            return null;
        }
        SymbolTable symbolTable = this.header().symbolTable;
        Integer fromInt = symbolTable.computeIntConstant(tree.down(2));
        Integer toInt = symbolTable.computeIntConstant(tree.down(3));
        Integer strideInt = ILUtils.isNullOrNone(tree.down(4)) ? Integer.valueOf(1) : symbolTable.computeIntConstant(tree.down(4));
        if (fromInt != null && toInt != null && strideInt != null) {
            int from = fromInt;
            int to = toInt;
            int stride = strideInt;
            if (stride == 1) {
                return to - from + 1;
            }
            if (stride == -1) {
                return from - to + 1;
            }
            return null;
        }
        return null;
    }

    public Tree staticNormalizedIndex() {
        TapList instructions = this.header().instructions;
        if (instructions == null || instructions.tail != null) {
            return null;
        }
        Instruction instruction = (Instruction)instructions.head;
        Tree tree = instruction.tree;
        if (tree == null || tree.opCode() != 119) {
            return null;
        }
        if ((tree = tree.down(3)) == null || tree.opCode() != 63) {
            return null;
        }
        SymbolTable symbolTable = this.header().symbolTable;
        Integer fromInt = symbolTable.computeIntConstant(tree.down(2));
        Integer toInt = symbolTable.computeIntConstant(tree.down(3));
        Integer strideInt = ILUtils.isNullOrNone(tree.down(4)) ? Integer.valueOf(1) : symbolTable.computeIntConstant(tree.down(4));
        if (fromInt != null && toInt != null && strideInt != null) {
            int from = fromInt;
            int to = toInt;
            int stride = strideInt;
            Tree index = ILUtils.copy(tree.down(1));
            if (stride == 1) {
                if (from != 1) {
                    return ILUtils.build(177, index, ILUtils.build(101, from - 1));
                }
                return index;
            }
            if (stride == -1) {
                if (to != 1) {
                    return ILUtils.build(177, index, ILUtils.build(101, to - 1));
                }
                return index;
            }
            return null;
        }
        return null;
    }

    @Override
    public void cite() throws IOException {
        TapEnv.print("LB(" + this.rank + ')');
    }

    @Override
    public String toString() {
        return "L" + super.toString();
    }
}

