/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.AlignmentBoundary;
import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneAllocator;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.Int2ZoneInfo;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class MemoryMap {
    private static final int NUM_BUCKETS = 20;
    private final TapList[] buckets = new TapList[20];
    public TapList maps = new TapList<Object>(null, null);
    public boolean isDifferentiated;
    public TapList<TapPair<String, Instruction>> commonInstructions;

    public MemoryMap() {
        for (int i = 0; i < 20; ++i) {
            this.buckets[i] = null;
        }
    }

    private static boolean isCommonMap(TapList alignmentMap) {
        return alignmentMap.head != null;
    }

    private static int hashKey(String key) {
        int code = key.hashCode() % 20;
        if (code < 0) {
            code += 20;
        }
        return code;
    }

    public static void pourCommonInterval(MemoryMap declaredMemoryMap, MemoryMap sideEffectMemoryMap, String commonName, int startOffset, int endOffset, boolean infiniteEndOffset, WrapperTypeSpec type) {
        if (declaredMemoryMap.getCommonRefToMap(commonName) != null) {
            declaredMemoryMap.addCommonInterval(commonName, startOffset, endOffset, infiniteEndOffset, type);
        } else {
            sideEffectMemoryMap.getSetCommon(commonName);
            sideEffectMemoryMap.addCommonInterval(commonName, startOffset, endOffset, infiniteEndOffset, type);
        }
    }

    public static AlignmentBoundary getAlignmentBoundary(int offset, boolean infiniteOffset, TapList map) {
        AlignmentBoundary result = null;
        while (result == null && map != null) {
            if (AlignmentBoundary.le(((AlignmentBoundary)map.head).offset, ((AlignmentBoundary)map.head).infiniteOffset, offset, infiniteOffset) && (map.tail == null || AlignmentBoundary.lt(offset, infiniteOffset, ((AlignmentBoundary)map.tail.head).offset, ((AlignmentBoundary)map.tail.head).infiniteOffset))) {
                result = (AlignmentBoundary)map.head;
            }
            map = map.tail;
        }
        return result;
    }

    public static int getLastOffset(TapList map) {
        while (map != null && map.tail != null) {
            map = map.tail;
        }
        if (map == null) {
            return -1;
        }
        AlignmentBoundary boundary = (AlignmentBoundary)map.head;
        if (boundary.infiniteOffset) {
            return -1;
        }
        return boundary.offset;
    }

    public static void dumpMap(TapList map) throws IOException {
        TapEnv.print("(");
        if (map.head != null) {
            TapEnv.print((String)map.head);
        }
        TapEnv.print("): ");
        map = map.tail;
        while (map != null) {
            VariableDecl variableDecl;
            AlignmentBoundary boundary = (AlignmentBoundary)map.head;
            if (!boundary.infiniteOffset) {
                TapEnv.print("(" + boundary.offset);
            } else {
                TapEnv.print("(+oo");
            }
            TapList<VariableDecl> evars = boundary.endVars;
            while (evars != null) {
                variableDecl = (VariableDecl)evars.head;
                if (variableDecl == null) {
                    TapEnv.print("-?");
                } else {
                    TapEnv.print("-" + variableDecl.symbol);
                }
                evars = evars.tail;
            }
            TapList<TapTriplet<VariableDecl, SymbolTable, Tree>> svars = boundary.getStartVars();
            while (svars != null) {
                variableDecl = (VariableDecl)((TapTriplet)svars.head).first;
                if (variableDecl == null) {
                    TapEnv.print("+??");
                } else if (variableDecl == boundary.commonVariableDecl()) {
                    TapEnv.print("[+" + variableDecl + "]");
                } else {
                    TapEnv.print("+" + variableDecl);
                    TapEnv.print(" from ST " + ((TapTriplet)svars.head).second);
                    TapEnv.print(" accessTree " + ((TapTriplet)svars.head).third + " ");
                }
                svars = svars.tail;
            }
            if (boundary.type != null) {
                TapEnv.print(" " + boundary.type);
            }
            if (map.tail != null && boundary.zones != null) {
                TapEnv.print(" " + boundary.zones);
            }
            TapEnv.print(") ");
            map = map.tail;
        }
    }

    private RefToAlignmentMap createCommon(String name, TapList alignmentMap) {
        RefToAlignmentMap result = new RefToAlignmentMap(name, 1, alignmentMap, 0);
        result.variableDecl = null;
        return result;
    }

    private RefToAlignmentMap createVariable(VariableDecl variableDecl, TapList alignmentMap, int offset) {
        RefToAlignmentMap result = new RefToAlignmentMap(variableDecl.symbol, 0, alignmentMap, offset);
        result.variableDecl = variableDecl;
        return result;
    }

    protected boolean setEquivalence(VariableDecl variableDecl1, int offset1, VariableDecl variableDecl2, int offset2, SymbolTable fromSymbolTable1, SymbolTable fromSymbolTable2) {
        RefToAlignmentMap ref1 = this.getVariableRefToMap(variableDecl1);
        RefToAlignmentMap ref2 = this.getVariableRefToMap(variableDecl2);
        WrapperTypeSpec type1 = variableDecl1.type();
        WrapperTypeSpec type2 = variableDecl2.type();
        int size1 = type1.size();
        int size2 = type2.size();
        if (ref1 == null) {
            if (ref2 == null) {
                TapList alignmentMap = this.buildNewAlignmentMap(null);
                this.insertVarIntoMap(variableDecl1, size1, type1, alignmentMap, 0, fromSymbolTable1, null);
                this.insertVarIntoMap(variableDecl2, size2, type2, alignmentMap, offset1 - offset2, fromSymbolTable2, null);
            } else {
                this.insertVarIntoMap(variableDecl1, size1, type1, ref2.alignmentMap, ref2.offset + offset2 - offset1, fromSymbolTable1, null);
            }
        } else if (ref2 == null) {
            this.insertVarIntoMap(variableDecl2, size2, type2, ref1.alignmentMap, ref1.offset + offset1 - offset2, fromSymbolTable2, null);
        } else {
            if (ref1.alignmentMap == ref2.alignmentMap || MemoryMap.isCommonMap(ref1.alignmentMap) && MemoryMap.isCommonMap(ref2.alignmentMap)) {
                return false;
            }
            if (MemoryMap.isCommonMap(ref1.alignmentMap)) {
                this.mapAbsorbMap(ref1.alignmentMap, ref2.alignmentMap, ref2.offset + offset2 - (ref1.offset + offset1));
            } else {
                this.mapAbsorbMap(ref2.alignmentMap, ref1.alignmentMap, ref1.offset + offset1 - (ref2.offset + offset2));
            }
        }
        return true;
    }

    protected void placeSave(String saveCommonName, VariableDecl variableDecl, int varSize, SymbolTable fromSymbolTable) {
        RefToAlignmentMap ref = this.getVariableRefToMap(variableDecl);
        if (ref == null) {
            RefToAlignmentMap saveCommonRef = this.getSetCommon(saveCommonName);
            AlignmentBoundary boundary = MemoryMap.getAlignmentBoundary(saveCommonRef.offset, false, ((RefToAlignmentMap)saveCommonRef).alignmentMap.tail);
            this.insertVarIntoMap(variableDecl, varSize, variableDecl.type(), saveCommonRef.alignmentMap, saveCommonRef.offset, fromSymbolTable, null);
            assert (boundary != null);
            boundary.setCommonVariableDecl(variableDecl);
            RefToAlignmentMap refToAlignmentMap = saveCommonRef;
            refToAlignmentMap.offset = refToAlignmentMap.offset + varSize;
        } else if (((RefToAlignmentMap)ref).alignmentMap.head == null) {
            RefToAlignmentMap saveCommonRef = this.getSetCommon(saveCommonName);
            int decalage = ((AlignmentBoundary)((RefToAlignmentMap)ref).alignmentMap.tail.head).offset - saveCommonRef.offset;
            int sizeOfEquiv = this.getSizeOfMap(((RefToAlignmentMap)ref).alignmentMap.tail);
            this.mapAbsorbMap(saveCommonRef.alignmentMap, ref.alignmentMap, decalage);
            RefToAlignmentMap refToAlignmentMap = saveCommonRef;
            refToAlignmentMap.offset = refToAlignmentMap.offset + sizeOfEquiv;
        }
    }

    protected void bindVariableAndCommon(String fortranCommonName, VariableDecl variableDecl, Unit unit) {
        CallGraph callGraph = unit.callGraph();
        MemoryMap globalCMemoryMap = callGraph.declaredMemoryMap;
        RefToAlignmentMap ref = this.getVariableRefToMap(variableDecl);
        int offSet = 0;
        if (ref == null) {
            int varSize;
            RefToAlignmentMap commonRef = this.getSetCommon(fortranCommonName);
            RefToAlignmentMap commonGlobalRef = globalCMemoryMap.getSetCommon(fortranCommonName);
            TapList commonVarDecls = commonRef.getVariables();
            while (commonVarDecls != null) {
                VariableDecl fortranVarDecl = (VariableDecl)commonVarDecls.head;
                varSize = fortranVarDecl.type().size();
                globalCMemoryMap.insertVarIntoMap(fortranVarDecl, varSize, fortranVarDecl.type(), commonGlobalRef.alignmentMap, offSet, unit.publicSymbolTable(), ILUtils.build(94, fortranVarDecl.symbol));
                offSet += varSize;
                commonVarDecls = commonVarDecls.tail;
            }
            varSize = variableDecl.type().size();
            globalCMemoryMap.insertVarIntoMap(variableDecl, varSize, variableDecl.type(), commonGlobalRef.alignmentMap, 0, unit.callGraph().cRootSymbolTable(), ILUtils.build(94, variableDecl.symbol));
            this.insertVarIntoMap(variableDecl, varSize, variableDecl.type(), commonRef.alignmentMap, 0, unit.callGraph().cRootSymbolTable(), ILUtils.build(94, variableDecl.symbol));
        } else {
            TapEnv.fileWarning(15, null, "(TC26) bind(C) " + fortranCommonName + " with " + variableDecl.symbol + " ignored");
        }
    }

    public RefToAlignmentMap getSetCommon(String commonName) {
        RefToAlignmentMap result = this.getCommonRefToMap(commonName);
        if (result == null) {
            TapList newMap = this.buildNewAlignmentMap(commonName);
            newMap.tail = new TapList<AlignmentBoundary>(new AlignmentBoundary(0), newMap.tail);
            result = this.createCommon(commonName, newMap);
            this.insertRefToMap(commonName, result);
        }
        return result;
    }

    protected void appendCommon(String commonName, VariableDecl variableDecl, int size, SymbolTable fromSymbolTable) {
        RefToAlignmentMap commonRef = this.getCommonRefToMap(commonName);
        RefToAlignmentMap varRef = this.getVariableRefToMap(variableDecl);
        assert (commonRef != null);
        if (commonRef.infiniteOffset) {
            TapEnv.fileWarning(15, (Tree)variableDecl.defPositions.head, "(TC27) End of common " + commonName + " reached before variable " + variableDecl.symbol);
            return;
        }
        if (varRef == null) {
            AlignmentBoundary boundary = MemoryMap.getAlignmentBoundary(commonRef.offset, false, ((RefToAlignmentMap)commonRef).alignmentMap.tail);
            this.insertVarIntoMap(variableDecl, size, variableDecl.type(), commonRef.alignmentMap, commonRef.offset, fromSymbolTable, null);
            assert (boundary != null);
            boundary.setCommonVariableDecl(variableDecl);
        } else {
            if (MemoryMap.isCommonMap(varRef.alignmentMap)) {
                TapEnv.fileWarning(15, (Tree)variableDecl.defPositions.head, "(TC28) Variable " + variableDecl.symbol + " cannot be added to common " + commonName + " because it is already in common " + ((RefToAlignmentMap)varRef).alignmentMap.head);
                return;
            }
            AlignmentBoundary boundary = MemoryMap.getAlignmentBoundary(varRef.offset, false, ((RefToAlignmentMap)varRef).alignmentMap.tail);
            assert (boundary != null);
            boundary.setCommonVariableDecl(variableDecl);
            this.mapAbsorbMap(commonRef.alignmentMap, varRef.alignmentMap, varRef.offset - commonRef.offset);
        }
        RefToAlignmentMap refToAlignmentMap = commonRef;
        refToAlignmentMap.offset = refToAlignmentMap.offset + size;
        if (size == 0) {
            commonRef.infiniteOffset = true;
        }
    }

    private TapList buildNewAlignmentMap(String key) {
        TapList<String> newMap = new TapList<String>(key, null);
        this.maps.tail = new TapList<TapList<String>>(newMap, this.maps.tail);
        return newMap;
    }

    private TapList gotoGetSetAlignmentBoundary(TapList alignmentMap, int offset, boolean infiniteOffset) {
        WrapperTypeSpec currentType = null;
        if (alignmentMap.head instanceof AlignmentBoundary) {
            currentType = ((AlignmentBoundary)alignmentMap.head).type;
        }
        while (alignmentMap.tail != null && AlignmentBoundary.lt(((AlignmentBoundary)alignmentMap.tail.head).offset, ((AlignmentBoundary)alignmentMap.tail.head).infiniteOffset, offset, infiniteOffset)) {
            alignmentMap = alignmentMap.tail;
            currentType = ((AlignmentBoundary)alignmentMap.head).type;
        }
        if (alignmentMap.tail == null || AlignmentBoundary.lt(offset, infiniteOffset, ((AlignmentBoundary)alignmentMap.tail.head).offset, ((AlignmentBoundary)alignmentMap.tail.head).infiniteOffset)) {
            AlignmentBoundary newBoundary = new AlignmentBoundary(offset, infiniteOffset, null);
            if (alignmentMap.tail == null) {
                if (alignmentMap.head instanceof AlignmentBoundary) {
                    ((AlignmentBoundary)alignmentMap.head).type = currentType;
                }
            } else {
                newBoundary.type = currentType;
            }
            alignmentMap.placdl(newBoundary);
        }
        return alignmentMap.tail;
    }

    private void insertVarIntoMap(VariableDecl variableDecl, int size, WrapperTypeSpec type, TapList alignmentMap, int offset, SymbolTable fromSymbolTable, Tree accessTree) {
        this.insertRefToMap(variableDecl.symbol, this.createVariable(variableDecl, alignmentMap, offset));
        alignmentMap = this.gotoGetSetAlignmentBoundary(alignmentMap, offset, false);
        ((AlignmentBoundary)alignmentMap.head).addStartVar(variableDecl, fromSymbolTable, accessTree);
        WrapperTypeSpec oldtype = ((AlignmentBoundary)alignmentMap.head).type;
        if (oldtype != null) {
            if (type.size() < oldtype.size() && !oldtype.isProbablyRealOrComplexBase()) {
                ((AlignmentBoundary)alignmentMap.head).type = type;
            }
        } else {
            ((AlignmentBoundary)alignmentMap.head).type = type;
        }
        alignmentMap = this.gotoGetSetAlignmentBoundary(alignmentMap, offset + size, size == 0);
        ((AlignmentBoundary)alignmentMap.head).addEndVar(variableDecl);
    }

    private void mapAbsorbMap(TapList map1, TapList map2, int offset) {
        TapList inMaps = this.maps;
        while (inMaps.tail != null && inMaps.tail.head != map2) {
            inMaps = inMaps.tail;
        }
        if (inMaps.tail != null) {
            inMaps.tail = inMaps.tail.tail;
        }
        map2 = map2.tail;
        TapList inMap1 = map1;
        while (map2 != null) {
            VariableDecl variableDecl;
            AlignmentBoundary boundary = (AlignmentBoundary)map2.head;
            int newOffset = boundary.offset - offset;
            inMap1 = this.gotoGetSetAlignmentBoundary(inMap1, newOffset, false);
            AlignmentBoundary newBoundary = (AlignmentBoundary)inMap1.head;
            if (newBoundary.type == null) {
                newBoundary.type = boundary.type;
            }
            if (boundary.commonVariableDecl() != null) {
                newBoundary.setCommonVariableDecl(boundary.commonVariableDecl());
            }
            TapList<Object> vars = boundary.getStartVars();
            while (vars != null) {
                variableDecl = (VariableDecl)((TapTriplet)vars.head).first;
                newBoundary.addStartVar(variableDecl, (SymbolTable)((TapTriplet)vars.head).second, (Tree)((TapTriplet)vars.head).third);
                this.getVariableRefToMap(variableDecl).reMap(map1, newOffset);
                vars = vars.tail;
            }
            vars = boundary.endVars;
            while (vars != null) {
                variableDecl = (VariableDecl)vars.head;
                newBoundary.addEndVar(variableDecl);
                vars = vars.tail;
            }
            map2 = map2.tail;
        }
    }

    private int getSizeOfMap(TapList alignmentMap) {
        int size = 0;
        if (alignmentMap != null) {
            int begin = ((AlignmentBoundary)alignmentMap.head).offset;
            while (alignmentMap.tail != null) {
                alignmentMap = alignmentMap.tail;
            }
            size = ((AlignmentBoundary)alignmentMap.head).offset - begin;
        }
        return size;
    }

    private void insertRefToMap(String name, RefToAlignmentMap ref) {
        int index = MemoryMap.hashKey(name);
        this.buckets[index] = new TapList<RefToAlignmentMap>(ref, this.buckets[index]);
    }

    private RefToAlignmentMap getVariableRefToMap(VariableDecl variableDecl) {
        TapList bucket = this.buckets[MemoryMap.hashKey(variableDecl.symbol)];
        while (bucket != null && !((RefToAlignmentMap)bucket.head).isVariableName(variableDecl)) {
            bucket = bucket.tail;
        }
        if (bucket != null) {
            return (RefToAlignmentMap)bucket.head;
        }
        return null;
    }

    private RefToAlignmentMap getCommonRefToMap(String name) {
        TapList bucket = this.buckets[MemoryMap.hashKey(name)];
        while (bucket != null && !((RefToAlignmentMap)bucket.head).isCommonName(name)) {
            bucket = bucket.tail;
        }
        if (bucket != null) {
            return (RefToAlignmentMap)bucket.head;
        }
        return null;
    }

    protected void buildAccessInfo() {
        TapList inMaps = this.maps.tail;
        while (inMaps != null) {
            TapList map = (TapList)inMaps.head;
            map = map.tail;
            TapList<VariableDecl> variableDecls = null;
            TapList<TapPair<VariableDecl, Integer>> variableDeclsOffsets = null;
            while (map != null) {
                AlignmentBoundary boundary = (AlignmentBoundary)map.head;
                variableDeclsOffsets = this.updateVarsOffsets(variableDeclsOffsets, boundary.endVars, boundary.offset, boundary.startVars());
                variableDecls = TapList.deleteAll(boundary.endVars, variableDecls);
                if ((variableDecls = TapList.addAll(variableDecls, boundary.startVars())) != null || boundary.type != null) {
                    this.buildAccessInfo(boundary, variableDecls, variableDeclsOffsets, map.tail);
                }
                map = map.tail;
            }
            inMaps = inMaps.tail;
        }
    }

    protected void allocateZones(ZoneAllocator zoneAllocator, Unit declarationUnit) {
        TapList inMaps = this.maps.tail;
        TapList<Object> toCopiedZoneInfos = new TapList<Object>(null, null);
        TapList[] allCopiedZoneInfos = new TapList[4];
        while (inMaps != null) {
            boolean needAdditionalAllocateZones;
            TapList map = (TapList)inMaps.head;
            String commonName = (String)map.head;
            map = map.tail;
            TapList<TapTriplet<VariableDecl, SymbolTable, Tree>> variableDecls = null;
            zoneAllocator.setCommonName(commonName);
            boolean bl = needAdditionalAllocateZones = declarationUnit != null && this.needAdditionalZoneInfo(map, declarationUnit);
            while (map != null) {
                AlignmentBoundary boundary = (AlignmentBoundary)map.head;
                variableDecls = TapList.deleteAllStartVars(boundary.endVars, variableDecls);
                if (!((variableDecls = TapList.addAll(variableDecls, boundary.getStartVars())) == null && boundary.type == null || needAdditionalAllocateZones)) {
                    TapList regionZones;
                    zoneAllocator.setStartOffset(boundary.offset);
                    if (map.tail == null || map.tail.head == null || ((AlignmentBoundary)map.tail.head).infiniteOffset) {
                        zoneAllocator.setInfiniteEndOffset(true);
                    } else {
                        zoneAllocator.setInfiniteEndOffset(false);
                        zoneAllocator.setEndOffset(((AlignmentBoundary)map.tail.head).offset);
                    }
                    boolean isInt = false;
                    boolean isReal = false;
                    boolean isPtr = false;
                    TapList<TapTriplet<VariableDecl, SymbolTable, Tree>> inVariableDecls = variableDecls;
                    TapList<String> cumulExtraInfo = null;
                    while (inVariableDecls != null) {
                        WrapperTypeSpec type = ((VariableDecl)((TapTriplet)inVariableDecls.head).first).type();
                        if (type.isRealOrComplexBase()) {
                            isReal = true;
                        }
                        if (type.isIntegerBase()) {
                            isInt = true;
                        }
                        if (TypeSpec.isA(type, 6)) {
                            isPtr = true;
                        }
                        cumulExtraInfo = TapList.unionString(cumulExtraInfo, ((VariableDecl)((TapTriplet)inVariableDecls.head).first).extraInfo());
                        inVariableDecls = inVariableDecls.tail;
                    }
                    boundary.zones = regionZones = zoneAllocator.allocateZones(boundary.accessTree, null, boundary.accessType, boundary.accessType, -1, cumulExtraInfo, -1, isInt, isReal, isPtr, null, null, declarationUnit == null ? null : declarationUnit.privateSymbolTable(), declarationUnit);
                    inVariableDecls = variableDecls;
                    while (inVariableDecls != null) {
                        ((VariableDecl)((TapTriplet)inVariableDecls.head).first).accumulateZones(regionZones);
                        zoneAllocator.addVarName(regionZones, ((VariableDecl)((TapTriplet)inVariableDecls.head).first).symbol);
                        inVariableDecls = inVariableDecls.tail;
                    }
                    if (variableDecls != null) {
                        zoneAllocator.addVarDecl(regionZones, (SymbolDecl)((TapTriplet)variableDecls.head).first);
                    }
                } else if (declarationUnit != null) {
                    TapList<Int2ZoneInfo>[] copiedZoneInfos = this.copyAdditionalDeclaredZoneInfos(boundary.getStartVars(), toCopiedZoneInfos, commonName);
                    for (int kind = 0; kind < 4; ++kind) {
                        allCopiedZoneInfos[kind] = TapList.append(allCopiedZoneInfos[kind], copiedZoneInfos[kind]);
                    }
                }
                map = map.tail;
            }
            inMaps = inMaps.tail;
        }
        for (int kind = 0; kind < 4; ++kind) {
            if (allCopiedZoneInfos[kind] == null) continue;
            assert (declarationUnit != null);
            declarationUnit.publicSymbolTable().setAdditionalDuplicatedDeclaredZoneInfos(allCopiedZoneInfos[kind], kind);
        }
    }

    private boolean needAdditionalZoneInfo(TapList map, Unit unit) {
        boolean result = false;
        while (!result && map != null) {
            AlignmentBoundary boundary = (AlignmentBoundary)map.head;
            result = this.needAdditionalZoneInfoRec(boundary.getStartVars(), unit);
            map = map.tail;
        }
        return result;
    }

    private boolean needAdditionalZoneInfoRec(TapList<TapTriplet<VariableDecl, SymbolTable, Tree>> variableDecls, Unit unit) {
        boolean result = false;
        while (!result && variableDecls != null) {
            result = ((TapTriplet)variableDecls.head).second != unit.publicSymbolTable();
            variableDecls = variableDecls.tail;
        }
        return result;
    }

    private TapList<Int2ZoneInfo>[] copyAdditionalDeclaredZoneInfos(TapList<TapTriplet<VariableDecl, SymbolTable, Tree>> variableDecls, TapList<Int2ZoneInfo> toCopiedZoneInfos, String commonName) {
        TapList<TapTriplet<VariableDecl, SymbolTable, Tree>> vDecls = variableDecls;
        TapList<Object> additionalZoneInfos = toCopiedZoneInfos.tail;
        TapList<Int2ZoneInfo> additionalIntZoneInfos = null;
        TapList<Int2ZoneInfo> additionalRealZoneInfos = null;
        TapList<Int2ZoneInfo> additionalPtrZoneInfos = null;
        TapList[] result = new TapList[4];
        while (vDecls != null) {
            ZoneInfo zoneInfo;
            VariableDecl vDecl = (VariableDecl)((TapTriplet)vDecls.head).first;
            TapIntList zInfos = ZoneInfo.listAllZones(vDecl.zones(), false);
            if (zInfos == null && additionalZoneInfos != null) {
                zoneInfo = ((Int2ZoneInfo)additionalZoneInfos.head).getZoneInfo();
                zoneInfo.ownerSymbolDecl = vDecl;
                zoneInfo.setVariableNames(new TapList<String>(vDecl.symbol, null));
                zoneInfo.accessTree = ILUtils.build(94, vDecl.symbol);
                zoneInfo.commonName = commonName;
                vDecl.setZones(new TapList<TapIntList>(new TapIntList(((Int2ZoneInfo)additionalZoneInfos.head).getZoneNumber(), null), null));
                additionalZoneInfos = additionalZoneInfos.tail;
            }
            while (zInfos != null) {
                int zNb = zInfos.head;
                zoneInfo = ((SymbolTable)((TapTriplet)vDecls.head).second).basisSymbolTable().localDeclaredZoneInfo(zNb, 0);
                if (zoneInfo != null) {
                    ZoneInfo copyZoneInfo = zoneInfo.copy();
                    additionalZoneInfos = TapList.addLast(additionalZoneInfos, new Int2ZoneInfo(copyZoneInfo.zoneNb, copyZoneInfo));
                    if (zoneInfo.intZoneNb != -1) {
                        additionalIntZoneInfos = TapList.addLast(additionalIntZoneInfos, new Int2ZoneInfo(copyZoneInfo.intZoneNb, copyZoneInfo));
                    }
                    if (zoneInfo.realZoneNb != -1) {
                        additionalRealZoneInfos = TapList.addLast(additionalRealZoneInfos, new Int2ZoneInfo(copyZoneInfo.realZoneNb, copyZoneInfo));
                    }
                    if (zoneInfo.ptrZoneNb != -1) {
                        additionalPtrZoneInfos = TapList.addLast(additionalPtrZoneInfos, new Int2ZoneInfo(copyZoneInfo.ptrZoneNb, copyZoneInfo));
                    }
                }
                zInfos = zInfos.tail;
            }
            if (additionalZoneInfos != null && result[0] == null) {
                result[0] = additionalZoneInfos;
                result[2] = additionalIntZoneInfos;
                result[1] = additionalRealZoneInfos;
                result[3] = additionalPtrZoneInfos;
            }
            vDecls = vDecls.tail;
        }
        toCopiedZoneInfos.tail = additionalZoneInfos;
        return result;
    }

    protected void allocateZonesOfVariables(ZoneAllocator zoneAllocator) {
        TapList<Object> variableDecls = new TapList<Object>(null, null);
        TapList inMaps = this.maps.tail;
        while (inMaps != null) {
            TapList map = (TapList)inMaps.head;
            map = map.tail;
            while (map != null) {
                AlignmentBoundary boundary = (AlignmentBoundary)map.head;
                variableDecls = TapList.addAll(variableDecls, boundary.getStartVars());
                map = map.tail;
            }
            inMaps = inMaps.tail;
        }
        while (variableDecls != null) {
            TapTriplet varDecl = (TapTriplet)variableDecls.head;
            if (varDecl != null && ((SymbolTable)varDecl.second).basisSymbolTable().basisSymbolTable() == null && ((VariableDecl)varDecl.first).zones() == null) {
                VariableDecl variableDecl = (VariableDecl)varDecl.first;
                TapList regionZones = zoneAllocator.allocateZones(ILUtils.build(94, variableDecl.symbol), null, variableDecl.type(), variableDecl.type(), -1, variableDecl.extraInfo(), -1, false, false, false, null, null, ((SymbolTable)varDecl.second).basisSymbolTable(), null);
                variableDecl.accumulateZones(regionZones);
                zoneAllocator.addVarName(regionZones, variableDecl.symbol);
                zoneAllocator.addVarDecl(regionZones, variableDecl);
            }
            variableDecls = variableDecls.tail;
        }
    }

    private TapList<TapPair<VariableDecl, Integer>> updateVarsOffsets(TapList<TapPair<VariableDecl, Integer>> varsOffsets, TapList<VariableDecl> endVars, int offset, TapList<VariableDecl> startVars) {
        VariableDecl variableDecl;
        varsOffsets = new TapList<TapPair<VariableDecl, Integer>>(null, varsOffsets);
        while (endVars != null) {
            variableDecl = (VariableDecl)endVars.head;
            TapList<TapPair<VariableDecl, Integer>> inVarsOffsets = varsOffsets;
            while (inVarsOffsets.tail != null && ((TapPair)inVarsOffsets.tail.head).first != variableDecl) {
                inVarsOffsets = inVarsOffsets.tail;
            }
            if (inVarsOffsets.tail != null) {
                inVarsOffsets.tail = inVarsOffsets.tail.tail;
            }
            endVars = endVars.tail;
        }
        varsOffsets = varsOffsets.tail;
        while (startVars != null) {
            variableDecl = (VariableDecl)startVars.head;
            varsOffsets = new TapList<TapPair<VariableDecl, Integer>>(new TapPair<VariableDecl, Integer>(variableDecl, offset), varsOffsets);
            startVars = startVars.tail;
        }
        return varsOffsets;
    }

    private void buildAccessInfo(AlignmentBoundary boundary, TapList<VariableDecl> variableDecls, TapList<TapPair<VariableDecl, Integer>> variableDeclsOffsets, TapList tailMap) {
        int startOffset = boundary.offset;
        int endOffset = -1;
        boolean infiniteEndOffset = true;
        TapList<VariableDecl> endEndVars = variableDecls;
        if (tailMap != null && tailMap.head != null) {
            endOffset = ((AlignmentBoundary)tailMap.head).offset;
            infiniteEndOffset = ((AlignmentBoundary)tailMap.head).infiniteOffset;
            endEndVars = ((AlignmentBoundary)tailMap.head).endVars;
        }
        int quality = 0;
        while (variableDeclsOffsets != null) {
            VariableDecl variableDecl = (VariableDecl)((TapPair)variableDeclsOffsets.head).first;
            int variableOffset = (Integer)((TapPair)variableDeclsOffsets.head).second;
            if (variableDecl.type() != null && variableDecl.type().wrappedType != null) {
                TypeSpec actualType = variableDecl.type().wrappedType;
                while (TypeSpec.isA(actualType, 5)) {
                    actualType = actualType.elementType().wrappedType;
                }
                if (variableOffset == startOffset) {
                    if (TapList.contains(endEndVars, variableDecl)) {
                        if (!TypeSpec.isA(actualType, 2)) {
                            if (quality < 5) {
                                quality = 5;
                                boundary.accessTree = ILUtils.build(94, variableDecl.symbol);
                                boundary.accessType = variableDecl.type();
                            }
                        } else if (quality < 4) {
                            quality = 4;
                            boundary.accessTree = ILUtils.build(94, variableDecl.symbol);
                            boundary.accessType = variableDecl.type();
                        }
                    } else if (quality < 3) {
                        quality = 3;
                        boundary.accessTree = ILUtils.build(94, variableDecl.symbol);
                        boundary.accessType = TypeSpec.isA(actualType, 2) ? this.buildRestrictedSizeArray((ArrayTypeSpec)actualType, startOffset - variableOffset, infiniteEndOffset ? -1 : endOffset - variableOffset) : variableDecl.type();
                    }
                } else if (TapList.contains(endEndVars, variableDecl)) {
                    if (quality < 2) {
                        quality = 2;
                        boundary.accessTree = ILUtils.build(94, variableDecl.symbol);
                        boundary.accessType = TypeSpec.isA(actualType, 2) ? this.buildRestrictedSizeArray((ArrayTypeSpec)actualType, startOffset - variableOffset, infiniteEndOffset ? -1 : endOffset - variableOffset) : variableDecl.type();
                    }
                } else if (quality < 1) {
                    quality = 1;
                    boundary.accessTree = ILUtils.build(94, variableDecl.symbol);
                    boundary.accessType = TypeSpec.isA(actualType, 2) ? this.buildRestrictedSizeArray((ArrayTypeSpec)actualType, startOffset - variableOffset, infiniteEndOffset ? -1 : endOffset - variableOffset) : variableDecl.type();
                }
            }
            variableDeclsOffsets = variableDeclsOffsets.tail;
        }
        if (boundary.accessTree == null) {
            boundary.accessTree = ILUtils.build(136);
        }
        if (boundary.accessType == null) {
            boundary.accessType = boundary.type;
        }
    }

    private WrapperTypeSpec buildRestrictedSizeArray(ArrayTypeSpec arrayType, int fromOffset, int toOffset) {
        int elemSize = arrayType.elementType().size();
        ArrayDim linearizedDim = arrayType.linearizeAllDim();
        linearizedDim.lower = linearizedDim.lower + fromOffset / elemSize;
        if (toOffset > 0) {
            linearizedDim.upper = linearizedDim.lower + toOffset / elemSize;
        }
        ArrayDim[] newDim = new ArrayDim[]{linearizedDim};
        ArrayTypeSpec newArrayType = new ArrayTypeSpec(arrayType.elementType(), newDim);
        return new WrapperTypeSpec(newArrayType);
    }

    public TapList<AlignmentBoundary> addCommonInterval(String commonName, int startOffset, int endOffset, boolean infiniteEndOffset, WrapperTypeSpec type) {
        TapList<Object> hdBoundariesInInternal;
        RefToAlignmentMap commonRef = this.getCommonRefToMap(commonName);
        assert (commonRef != null);
        TapList inMap = this.gotoGetSetAlignmentBoundary(commonRef.alignmentMap, startOffset, false);
        TapList outMap = this.gotoGetSetAlignmentBoundary(inMap, endOffset, infiniteEndOffset);
        TapList<Object> tlBoundariesInInternal = hdBoundariesInInternal = new TapList<Object>(null, null);
        while (inMap.head != outMap.head) {
            AlignmentBoundary newBoundary = (AlignmentBoundary)inMap.head;
            WrapperTypeSpec oldType = newBoundary.type;
            if (oldType == null || type.size() < oldType.size() && !oldType.isProbablyRealOrComplexBase()) {
                newBoundary.type = type;
            }
            tlBoundariesInInternal = tlBoundariesInInternal.placdl(newBoundary);
            inMap = inMap.tail;
        }
        return hdBoundariesInInternal.tail;
    }

    protected void pourMemoryMap(Unit unitInto) {
        TapList inMaps = this.maps.tail;
        while (inMaps != null) {
            TapList map = (TapList)inMaps.head;
            if (map.head != null) {
                boolean foundAsDeclared;
                RefToAlignmentMap targetRef = null;
                String commonName = (String)map.head;
                map = map.tail;
                for (Unit aboveUnitInto = unitInto; aboveUnitInto != null && targetRef == null; aboveUnitInto = aboveUnitInto.upperLevelUnit()) {
                    targetRef = aboveUnitInto.declaredMemoryMap.getCommonRefToMap(commonName);
                    TapList<Unit> importedModulesOfaboveUnitInto = TapList.append(aboveUnitInto.importedModules(), aboveUnitInto.otherImportedModules);
                    while (importedModulesOfaboveUnitInto != null && targetRef == null) {
                        Unit importedModule = (Unit)importedModulesOfaboveUnitInto.head;
                        targetRef = importedModule.declaredMemoryMap.getCommonRefToMap(commonName);
                        importedModulesOfaboveUnitInto = importedModulesOfaboveUnitInto.tail;
                    }
                }
                if (targetRef != null) {
                    foundAsDeclared = true;
                } else {
                    foundAsDeclared = false;
                    targetRef = unitInto.sideEffectMemoryMap.getSetCommon(commonName);
                }
                TapList inTargetMap = targetRef.alignmentMap;
                int mapSize = MemoryMap.getLastOffset(map);
                int targetMapSize = MemoryMap.getLastOffset(inTargetMap.tail);
                if (foundAsDeclared && mapSize != -1 && targetMapSize != -1 && mapSize != targetMapSize) {
                    TapEnv.fileWarning(15, null, "(TC29) Common " + commonName + " declared with two different sizes:" + mapSize + " vs " + targetMapSize);
                }
                while (map != null) {
                    AlignmentBoundary boundary = (AlignmentBoundary)map.head;
                    inTargetMap = this.gotoGetSetAlignmentBoundary(inTargetMap, boundary.offset, boundary.infiniteOffset);
                    ((AlignmentBoundary)inTargetMap.head).accessTree = boundary.accessTree;
                    ((AlignmentBoundary)inTargetMap.head).accessType = boundary.accessType;
                    ((AlignmentBoundary)inTargetMap.head).type = boundary.type;
                    map = map.tail;
                }
            }
            inMaps = inMaps.tail;
        }
    }

    protected TapList getZonesOfCommonInterval(String commonName, int startOffset, int endOffset, boolean infiniteEndOffset) {
        TapList<Object> result;
        RefToAlignmentMap commonRef = this.getCommonRefToMap(commonName);
        if (commonRef == null) {
            return null;
        }
        TapList inMap = ((RefToAlignmentMap)commonRef).alignmentMap.tail;
        TapList<Object> tlResult = result = new TapList<Object>(null, null);
        TapList curZones = null;
        while (inMap != null) {
            AlignmentBoundary boundary = (AlignmentBoundary)inMap.head;
            if (boundary.zones != null) {
                curZones = boundary.zones;
            }
            if (AlignmentBoundary.lt(boundary.offset, boundary.infiniteOffset, endOffset, infiniteEndOffset) && startOffset <= boundary.offset) {
                tlResult = tlResult.placdl(curZones);
            }
            inMap = inMap.tail;
        }
        return result.tail;
    }

    public TapList<SymbolDecl> getCommon(String commonName) {
        TapList<VariableDecl> result = null;
        RefToAlignmentMap ref = this.getCommonRefToMap(commonName);
        assert (ref != null);
        TapList alMap = ((RefToAlignmentMap)ref).alignmentMap.tail;
        while (alMap != null) {
            TapList<VariableDecl> startVars = ((AlignmentBoundary)alMap.head).startVars();
            if (startVars != null) {
                result = TapList.append(result, startVars);
            }
            alMap = alMap.tail;
        }
        return result;
    }

    public TapList getCommonMap(String commonName) {
        RefToAlignmentMap ref = this.getCommonRefToMap(commonName);
        if (ref == null) {
            return null;
        }
        return ((RefToAlignmentMap)ref).alignmentMap.tail;
    }

    public TapList<String> getAllCommonNames() {
        TapList<String> result = null;
        if (this.maps != null) {
            TapList inMaps = this.maps.tail;
            while (inMaps != null) {
                if (((TapList)inMaps.head).head != null) {
                    result = new TapList<String>((String)((TapList)inMaps.head).head, result);
                }
                inMaps = inMaps.tail;
            }
        }
        return result;
    }

    public void dump(int indent) throws IOException {
        if (this.maps == null) {
            TapEnv.indentPrint(indent, "null memory map");
            TapEnv.println();
        } else {
            TapList inMaps = this.maps.tail;
            if (inMaps == null) {
                TapEnv.indentPrint(indent, "EMPTY MemoryMap");
                TapEnv.println();
            } else {
                while (inMaps != null) {
                    TapEnv.indentPrint(indent, "Map ");
                    MemoryMap.dumpMap((TapList)inMaps.head);
                    TapEnv.println();
                    inMaps = inMaps.tail;
                }
            }
        }
    }

    public String toString() {
        return this.maps.toString();
    }

    private static class RefToAlignmentMap {
        private final String name;
        private final int kind;
        private VariableDecl variableDecl;
        private TapList alignmentMap;
        private int offset;
        private boolean infiniteOffset;

        private RefToAlignmentMap(String name, int kind, TapList alignmentMap, int offset) {
            this.name = name;
            this.kind = kind;
            this.alignmentMap = alignmentMap;
            this.offset = offset;
            while (alignmentMap != null) {
                if (alignmentMap.head instanceof AlignmentBoundary && ((AlignmentBoundary)alignmentMap.head).infiniteOffset) {
                    this.infiniteOffset = true;
                }
                alignmentMap = alignmentMap.tail;
            }
        }

        private void reMap(TapList newMap, int newOffset) {
            this.alignmentMap = newMap;
            this.offset = newOffset;
        }

        private boolean isVariableName(VariableDecl variableDecl) {
            return this.kind == 0 && this.variableDecl == variableDecl;
        }

        private boolean isCommonName(String name) {
            return this.kind == 1 && this.name.equals(name);
        }

        private TapList<VariableDecl> getVariables() {
            TapList<VariableDecl> result = null;
            TapList algnMap = this.alignmentMap.tail;
            while (algnMap != null) {
                if (((AlignmentBoundary)algnMap.head).startVars() != null) {
                    result = TapList.append(result, ((AlignmentBoundary)algnMap.head).startVars());
                }
                algnMap = algnMap.tail;
            }
            return result;
        }

        public String toString() {
            if (this.kind == 0) {
                return "RefToAlignmentMap:" + this.variableDecl.symbol + ' ' + this.alignmentMap + ' ' + this.offset + ' ' + this.infiniteOffset + System.lineSeparator();
            }
            return "RefToAlignmentMap:/" + this.name + "/ " + this.alignmentMap + ' ' + this.offset + ' ' + this.infiniteOffset + System.lineSeparator();
        }
    }
}

