/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.CompositeTypeSpec;
import fr.inria.tapenade.representation.FieldDecl;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.PrimitiveTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VoidTypeSpec;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class MetaTypeSpec
extends TypeSpec {
    public final String name;

    public MetaTypeSpec(String name) {
        super(10);
        this.name = name;
    }

    @Override
    protected String baseTypeName() {
        return "";
    }

    @Override
    protected boolean testComparesWith(TypeSpec other, int comparison, TypeSpec toThis, TypeSpec toOther, TapList<TapPair<TypeSpec, TypeSpec>> dejaVu) {
        if ((toOther = this.peelWrapperTo(other, toOther)) != null) {
            other = toOther.wrappedType();
        }
        if (this == other) {
            return true;
        }
        if (MetaTypeSpec.testIsReceives(comparison) && !MetaTypeSpec.testTypesLitteral(comparison)) {
            return true;
        }
        return this.name != null && other instanceof MetaTypeSpec && this.name.equals(((MetaTypeSpec)other).name);
    }

    @Override
    public MetaTypeSpec copy() {
        return this;
    }

    @Override
    public TypeSpec copyStopOnComposite(Unit publishedUnit) {
        return this;
    }

    @Override
    protected boolean containsMetaType(TapList<TypeSpec> dejaVu) {
        return true;
    }

    protected TypeSpec makeLocalizedTypeSpec() {
        TypeSpec localizedType = this.localize(new TapList<Object>(null, null), new ToBool(false));
        return ((WrapperTypeSpec)localizedType).wrappedType;
    }

    @Override
    protected TypeSpec localize(TapList<TapTriplet<TypeSpec, TypeSpec, Boolean>> toAlreadyCopied, ToBool containsMeta) {
        TypeSpec copiedResult = this.findAlreadyCopiedType(toAlreadyCopied, containsMeta);
        if (copiedResult == null) {
            TypeSpec localizedType = null;
            if (this.name != null) {
                if (this.name.startsWith("void")) {
                    localizedType = new VoidTypeSpec();
                } else if (this.name.startsWith("pointer")) {
                    localizedType = new PointerTypeSpec(new WrapperTypeSpec(null), null);
                } else {
                    String proposed = null;
                    if (this.name.startsWith("integer")) {
                        proposed = "integer";
                    } else if (this.name.startsWith("float") || this.name.startsWith("real")) {
                        proposed = "float";
                    } else if (this.name.startsWith("complex")) {
                        proposed = "complex";
                    }
                    if (proposed != null) {
                        localizedType = new PrimitiveTypeSpec(proposed);
                        localizedType.setUndefinedNumeric(true);
                    }
                }
            }
            copiedResult = new WrapperTypeSpec(localizedType);
            toAlreadyCopied.placdl(new TapTriplet<MetaTypeSpec, TypeSpec, Boolean>(this, copiedResult, Boolean.TRUE));
        }
        containsMeta.set(true);
        return copiedResult;
    }

    @Override
    public boolean containsUndefinedType() {
        return true;
    }

    @Override
    public WrapperTypeSpec differentiateTypeSpec(SymbolTable symbolTable, SymbolTable srcSymbolTable, int diffUnitSort, String fSuffix, int maxDiffSorts, boolean localDecl, boolean multiDirMode, ArrayDim multiDirDimensionMax, ArrayDim pointerMultiDirDim, String hintArrayNameInText, String hintArrayNameInIdent, Tree hintArrayNameTree, Tree nameTree) {
        if (TapEnv.associationByAddress()) {
            FieldDecl[] fields = new FieldDecl[]{new FieldDecl(TapEnv.assocAddressValueSuffix(), new WrapperTypeSpec(this)), new FieldDecl(TapEnv.assocAddressDiffSuffix(), new WrapperTypeSpec(this))};
            this.diffTypeSpec = new WrapperTypeSpec(new CompositeTypeSpec(null, fields, 8, null, null));
            this.createOrGetDiffTypeDeclSymbolHolder(symbolTable, this.diffTypeSpec, fSuffix);
            return this.diffTypeSpec;
        }
        return null;
    }

    @Override
    public Tree generateTree(SymbolTable symbolTable, TapList<SymbolDecl> dependsOn, TapList<SymbolDecl> shortNames, boolean useShortNames, TapList<TypeSpec> dejaVu) {
        Tree result = null;
        if (this.name != null) {
            result = this.name.startsWith("integer") ? ILUtils.build(102) : (this.name.startsWith("float") || this.name.startsWith("real") ? ILUtils.build(76) : (this.name.startsWith("complex") ? ILUtils.build(40) : (this.name.startsWith("boolean") ? ILUtils.build(28) : (this.name.startsWith("character") ? ILUtils.build(34) : ILUtils.build(94, this.name)))));
        }
        return result;
    }

    @Override
    public String showType() {
        return this.name;
    }

    @Override
    public void dump() throws IOException {
        TapEnv.print(this.toString());
    }

    @Override
    public String toString() {
        return (this.typeDeclName() == null ? "" : "\"" + this.typeDeclName() + "\":") + "meta" + ':' + this.name;
    }
}

