/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.CompositeTypeSpec;
import fr.inria.tapenade.representation.FieldDecl;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.PrimitiveTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeDecl;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.ToObject;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class ModifiedTypeSpec
extends TypeSpec {
    private WrapperTypeSpec elementType;
    public Tree sizeModifier;
    protected Tree sizeModifierResolved;
    protected int typeSign;
    private int sizeModifierInteger = -1;
    private boolean undefinedSize;

    @Override
    public WrapperTypeSpec elementType() {
        return this.elementType;
    }

    public ModifiedTypeSpec(WrapperTypeSpec elementType, Tree sizeModifier, SymbolTable symbolTable) {
        super(5);
        this.elementType = elementType;
        this.sizeModifier = sizeModifier;
        this.resolveSizeModifier(symbolTable);
    }

    public ModifiedTypeSpec(WrapperTypeSpec elementType, ModifiedTypeSpec model) {
        super(5);
        this.elementType = elementType;
        this.sizeModifier = model.sizeModifier;
        this.sizeModifierResolved = model.sizeModifierResolved;
        this.sizeModifierInteger = model.sizeModifierInteger;
        this.typeSign = model.typeSign;
    }

    protected static boolean sizeModifierIntegerSmaller(int smallSize, int largeSize) {
        return smallSize > 0 && largeSize > smallSize || smallSize == -1 && largeSize != -1 || smallSize == -2 && largeSize > 8;
    }

    protected static boolean compareModifiersWith(int leftModifierInteger, Tree leftModifierTree, int rightModifierInteger, Tree rightModifierTree, int comparison) {
        if (TapEnv.traceTypeCheckAnalysis()) {
            TapEnv.indentOnTrace(TapEnv.traceIndent());
            for (int i = compare_debug_indent; i > 0; --i) {
                TapEnv.printOnTrace("| ");
            }
            TapEnv.printlnOnTrace(" +Comparing size modifiers " + leftModifierInteger + ':' + leftModifierTree + " vs " + rightModifierInteger + ':' + rightModifierTree);
        }
        if (ModifiedTypeSpec.testTypesWithoutSize(comparison)) {
            return true;
        }
        if (ModifiedTypeSpec.testIsReceives(comparison)) {
            if (leftModifierInteger > 0 && rightModifierInteger > 0) {
                return leftModifierInteger >= rightModifierInteger;
            }
            if (leftModifierInteger <= -2 && (rightModifierInteger == 0 || rightModifierInteger <= -2)) {
                return true;
            }
            if (leftModifierInteger == 0 && rightModifierInteger == 0) {
                return true;
            }
            if (leftModifierInteger == -1 && rightModifierInteger == -1 && leftModifierTree.equalsTree(rightModifierTree)) {
                return true;
            }
            return true;
        }
        if (leftModifierInteger == rightModifierInteger && leftModifierInteger != -1) {
            return true;
        }
        if (leftModifierInteger > 0 && rightModifierInteger > 0 && leftModifierInteger != rightModifierInteger) {
            return false;
        }
        if (!(leftModifierInteger != 0 && leftModifierInteger > -2 || rightModifierInteger != 0 && rightModifierInteger > -2)) {
            return false;
        }
        return leftModifierInteger == -1 && rightModifierInteger == -1 && leftModifierTree.equalsTree(rightModifierTree);
    }

    @Override
    protected void setHasUndefinedSize(boolean val) {
        this.undefinedSize = val;
    }

    @Override
    protected boolean hasUndefinedSize() {
        return this.undefinedSize;
    }

    protected void getModifierFrom(ModifiedTypeSpec model) {
        this.sizeModifier = model.sizeModifier;
        this.sizeModifierResolved = model.sizeModifierResolved;
        this.sizeModifierInteger = model.sizeModifierInteger;
    }

    protected void resolveSizeModifier(SymbolTable symbolTable) {
        if (this.sizeModifier == null) {
            this.sizeModifierResolved = null;
            this.sizeModifierInteger = -1;
        } else {
            Tree sizeModifierPeeled = this.sizeModifier.opCode() == 132 ? this.sizeModifier.down(2) : this.sizeModifier;
            Tree result = null;
            if (sizeModifierPeeled.opCode() == 94) {
                String modString = sizeModifierPeeled.stringValue();
                if ("short".equals(modString)) {
                    result = ILUtils.build(101, -3);
                } else if ("double".equals(modString) || "long".equals(modString)) {
                    result = ILUtils.build(101, -2);
                } else if ("long double".equals(modString) || "long long".equals(modString)) {
                    result = ILUtils.build(101, -4);
                }
            } else if (sizeModifierPeeled.opCode() == 101) {
                result = sizeModifierPeeled;
            }
            if (result == null) {
                result = this.resolveSizeModifierRec(sizeModifierPeeled, symbolTable);
            }
            if (result != null && (this.sizeModifierResolved == null || result.opCode() == 101 && this.sizeModifierResolved.opCode() != 101)) {
                this.sizeModifierResolved = result;
                this.sizeModifierInteger = result.opCode() == 101 ? result.intValue() : -1;
            }
        }
    }

    private Tree resolveSizeModifierRec(Tree sizeExpression, SymbolTable symbolTable) {
        Integer ival = symbolTable.computeIntConstant(sizeExpression);
        if (ival != null) {
            return ILUtils.build(101, ival);
        }
        if (sizeExpression.opCode() == 94) {
            Tree cstInit;
            VariableDecl cstDecl = symbolTable.getConstantDecl(sizeExpression.stringValue());
            Tree tree = cstInit = cstDecl == null ? null : cstDecl.initializationTree();
            if (cstInit != null) {
                return this.resolveSizeModifierRec(cstInit, symbolTable);
            }
            return sizeExpression;
        }
        return sizeExpression;
    }

    public int sizeModifierValue() {
        return this.sizeModifierInteger;
    }

    public boolean hasKindEqual() {
        return this.sizeModifier != null && this.sizeModifier.opCode() == 132 && ILUtils.isIdent(this.sizeModifier.down(1), "kind", false);
    }

    @Override
    protected boolean isUndefinedNumeric() {
        TypeSpec ats = this.elementType.wrappedType;
        return ats != null && ats.isUndefinedNumeric();
    }

    @Override
    protected void setUndefinedNumeric(boolean value) {
        this.elementType.wrappedType.setUndefinedNumeric(value);
    }

    @Override
    public TypeSpec wrappedType() {
        return this.elementType;
    }

    @Override
    public void setWrappedType(TypeSpec type) {
        this.elementType = type instanceof WrapperTypeSpec ? (WrapperTypeSpec)type : new WrapperTypeSpec(type);
    }

    @Override
    protected TypeSpec cloneAsUndefinedNumeric(boolean undefined) {
        return new ModifiedTypeSpec((WrapperTypeSpec)this.elementType.cloneAsUndefinedNumeric(undefined), this);
    }

    @Override
    public TypeSpec nestedLevelType() {
        return this.elementType;
    }

    @Override
    protected TypeSpec peelPointer() {
        return this.elementType == null ? null : this.elementType.peelPointer();
    }

    @Override
    protected String baseTypeName() {
        return this.elementType.baseTypeName();
    }

    @Override
    public WrapperTypeSpec baseTypeSpec(boolean stopOnPointer) {
        return this.elementType.baseTypeSpec(stopOnPointer);
    }

    @Override
    public boolean containsAPointer() {
        return this.elementType != null && this.elementType.containsAPointer();
    }

    @Override
    public boolean containsUnknownDimension() {
        return this.elementType != null && this.elementType.containsUnknownDimension();
    }

    @Override
    public void doUpdateAfterImports(SymbolTable symbolTable, TapList<TypeSpec> dejaVu) {
        if (this.elementType != null) {
            this.elementType.updateAfterImports(symbolTable, dejaVu);
        }
        this.resolveSizeModifier(symbolTable);
    }

    @Override
    protected int computeSize() {
        int size = this.elementType.size();
        int sizeValue = this.sizeModifierInteger;
        if (sizeValue > 0) {
            if (this.baseTypeName().equals("character")) {
                return size * sizeValue;
            }
            return sizeValue;
        }
        if (sizeValue == -2) {
            if (this.baseTypeName().equals("float")) {
                return TapEnv.get().doubleRealSize;
            }
            if (this.baseTypeName().equals("complex")) {
                return TapEnv.get().doubleRealSize * 2;
            }
            return size * 2;
        }
        return size;
    }

    @Override
    public boolean isCharacter() {
        return this.elementType != null && this.elementType.isCharacter();
    }

    @Override
    public boolean isString() {
        return this.elementType != null && this.elementType.isString();
    }

    @Override
    public boolean isTarget() {
        return this.elementType.isTarget();
    }

    @Override
    public boolean isArray() {
        return this.elementType != null && this.elementType.isArray();
    }

    @Override
    public void addUsedSymbolsInType(TapList<SymbolDecl> toDependsOn, SymbolTable symbolTable) {
        if (this.sizeModifier != null) {
            SymbolDecl.addUsedSymbolsInExpr(this.sizeModifier, toDependsOn, symbolTable, null, false, true);
        }
    }

    @Override
    public void collectUsedTrees(TapList<Tree> toUsedTrees, TapList<TypeSpec> toDejaVu) {
        if (!TapList.contains(toDejaVu, this)) {
            toDejaVu.placdl(this);
            if (this.sizeModifier != null) {
                toUsedTrees.placdl(this.sizeModifier);
            }
            if (this.elementType != null && this.elementType.wrappedType != null) {
                this.elementType.wrappedType.collectUsedTrees(toUsedTrees, toDejaVu);
            }
        }
    }

    @Override
    public boolean isPointer() {
        return this.elementType != null && this.elementType.isPointer();
    }

    @Override
    protected boolean testComparesWith(TypeSpec other, int comparison, TypeSpec toThis, TypeSpec toOther, TapList<TapPair<TypeSpec, TypeSpec>> dejaVu) {
        while (other instanceof WrapperTypeSpec) {
            toOther = other;
            other = ((WrapperTypeSpec)other).wrappedType;
        }
        if (this == other) {
            return true;
        }
        if (other == null) {
            if (ModifiedTypeSpec.testHasInference(comparison)) {
                if (toOther != null) {
                    toOther.setWrappedType(this);
                }
                return true;
            }
            return false;
        }
        if (ModifiedTypeSpec.testTypesLitteral(comparison) && !(other instanceof ModifiedTypeSpec)) {
            return false;
        }
        ToObject<Object> toThisSizeModifierResolved = new ToObject<Object>(null);
        TypeSpec toThisUnmodified = this.peelSizeModifiersTo(this, toThis, toThisSizeModifierResolved, null, ModifiedTypeSpec.testTypesLitteral(comparison));
        TypeSpec thisUnmodified = toThisUnmodified.wrappedType();
        Tree thisSizeModifierResolved = toThisSizeModifierResolved.obj();
        ToObject<Object> toOtherSizeModifierResolved = new ToObject<Object>(null);
        ToObject<Object> toOtherModifiedTypeSpec = new ToObject<Object>(null);
        TypeSpec toOtherUnmodified = this.peelSizeModifiersTo(other, toOther, toOtherSizeModifierResolved, toOtherModifiedTypeSpec, ModifiedTypeSpec.testTypesLitteral(comparison));
        TypeSpec otherUnmodified = toOtherUnmodified == null ? other : toOtherUnmodified.wrappedType();
        Tree otherSizeModifierResolved = toOtherSizeModifierResolved.obj();
        boolean comparesWell = true;
        if (comparesWell) {
            if (thisUnmodified == null) {
                if (ModifiedTypeSpec.testHasInference(comparison)) {
                    thisUnmodified = otherUnmodified == null ? null : otherUnmodified.weakenForInference(comparison);
                    toThisUnmodified.setWrappedType(thisUnmodified);
                } else {
                    comparesWell = ModifiedTypeSpec.testAcceptsUnspecified(comparison);
                }
            } else if (otherUnmodified == null) {
                if (ModifiedTypeSpec.testHasInference(comparison)) {
                    if (toOtherUnmodified != null) {
                        toOtherUnmodified.setWrappedType(thisUnmodified);
                    }
                } else {
                    comparesWell = false;
                }
            } else {
                comparesWell = thisUnmodified.comparesWith(otherUnmodified, comparison, toThisUnmodified, toOtherUnmodified, dejaVu);
            }
        }
        if (comparesWell && thisUnmodified != null) {
            int unmodifiedSize;
            int thisSizeModifierInteger = -1;
            int otherSizeModifierInteger = -1;
            boolean testTypesCompilDep = ModifiedTypeSpec.testTypesCompilDep(comparison);
            int n = unmodifiedSize = testTypesCompilDep ? thisUnmodified.size() : 0;
            if (thisSizeModifierResolved == null) {
                thisSizeModifierInteger = testTypesCompilDep ? unmodifiedSize : 0;
            } else if (thisSizeModifierResolved.opCode() == 101) {
                thisSizeModifierInteger = thisSizeModifierResolved.intValue();
                if (testTypesCompilDep && thisSizeModifierInteger <= -2) {
                    int n2 = thisSizeModifierInteger == -2 ? 2 * unmodifiedSize : (thisSizeModifierInteger = thisSizeModifierInteger == -4 ? 4 * unmodifiedSize : unmodifiedSize);
                }
            }
            if (otherSizeModifierResolved == null) {
                otherSizeModifierInteger = testTypesCompilDep ? unmodifiedSize : 0;
            } else if (otherSizeModifierResolved.opCode() == 101) {
                otherSizeModifierInteger = otherSizeModifierResolved.intValue();
                if (testTypesCompilDep && otherSizeModifierInteger <= -2) {
                    int n3 = otherSizeModifierInteger == -2 ? 2 * unmodifiedSize : (otherSizeModifierInteger = otherSizeModifierInteger == -4 ? 4 * unmodifiedSize : unmodifiedSize);
                }
            }
            if (ModifiedTypeSpec.testIsReceivesWithInference(comparison) && this.isUndefinedNumeric()) {
                ModifiedTypeSpec otherModifiedTypeSpec;
                if (ModifiedTypeSpec.sizeModifierIntegerSmaller(thisSizeModifierInteger, otherSizeModifierInteger) && (otherModifiedTypeSpec = (ModifiedTypeSpec)toOtherModifiedTypeSpec.obj()) != null) {
                    this.getModifierFrom(otherModifiedTypeSpec);
                }
            } else {
                comparesWell = ModifiedTypeSpec.compareModifiersWith(thisSizeModifierInteger, thisSizeModifierResolved, otherSizeModifierInteger, otherSizeModifierResolved, comparison);
            }
        }
        return comparesWell;
    }

    @Override
    protected TypeSpec weakenForInference(int comparison) {
        return new ModifiedTypeSpec((WrapperTypeSpec)this.elementType.weakenForInference(comparison), this);
    }

    public boolean hasCbindingModifier() {
        boolean result;
        boolean bl = result = this.sizeModifier.opCode() == 94;
        if (result) {
            String modifier = this.sizeModifier.stringValue();
            result = modifier.startsWith("c_int") || modifier.startsWith("c_short") || modifier.startsWith("c_long") || modifier.startsWith("c_signed") || modifier.startsWith("c_size") || modifier.startsWith("c_float") || modifier.startsWith("c_double") || modifier.startsWith("c_bool") || modifier.startsWith("c_char");
        }
        return result;
    }

    public boolean hasCbindingModifier(String cModifier) {
        boolean result;
        boolean bl = result = this.sizeModifier.opCode() == 94;
        if (result) {
            String modifier = this.sizeModifier.stringValue();
            result = modifier.startsWith(cModifier);
        }
        return result;
    }

    @Override
    public TypeSpec copy() {
        return new ModifiedTypeSpec((WrapperTypeSpec)this.elementType.copy(), this);
    }

    @Override
    public TypeSpec copyStopOnComposite(Unit publishedUnit) {
        TypeSpec copyElement = this.elementType == null ? null : this.elementType.copyStopOnComposite(publishedUnit);
        return copyElement == this.elementType ? this : new ModifiedTypeSpec((WrapperTypeSpec)copyElement, this);
    }

    @Override
    public int precisionSize() {
        return this.sizeModifierInteger;
    }

    @Override
    public Tree buildConstantZero() {
        String baseTypeName = this.baseTypeName();
        if (baseTypeName.equals("integer")) {
            return ILUtils.build(101, 0);
        }
        if (baseTypeName.equals("float")) {
            int sizeModifier;
            SymbolTable symbolTable;
            if (TapEnv.relatedUnit() != null && (symbolTable = TapEnv.relatedUnit().privateSymbolTable()) == null) {
                SymbolTable symbolTable2 = TapEnv.relatedUnit().publicSymbolTable();
            }
            if ((sizeModifier = this.sizeModifierInteger) > 0 && TapEnv.relatedLanguageIsFortran9x() && !this.hasUndefinedSize()) {
                return ILUtils.build(155, "0.0_" + sizeModifier);
            }
            if (sizeModifier == -2 || sizeModifier == 8) {
                if (TapEnv.relatedLanguageIsC()) {
                    return ILUtils.build(155, "0.0");
                }
                return ILUtils.build(155, "0.D0");
            }
            return PrimitiveTypeSpec.buildRealConstantZero();
        }
        if (baseTypeName.equals("complex")) {
            return PrimitiveTypeSpec.buildRealConstantZero();
        }
        return null;
    }

    @Override
    public Tree buildConstantOne() {
        String baseTypeName = this.baseTypeName();
        if (baseTypeName.equals("integer")) {
            return ILUtils.build(101, 1);
        }
        if (baseTypeName.equals("float") || baseTypeName.equals("complex")) {
            int sizeModifier;
            SymbolTable symbolTable;
            if (TapEnv.relatedUnit() != null && (symbolTable = TapEnv.relatedUnit().privateSymbolTable()) == null) {
                SymbolTable symbolTable2 = TapEnv.relatedUnit().publicSymbolTable();
            }
            if ((sizeModifier = this.sizeModifierInteger) > 0 && TapEnv.relatedLanguageIsFortran9x()) {
                return ILUtils.build(155, "1.0_" + sizeModifier);
            }
            if (sizeModifier == -2 || sizeModifier == 8) {
                if (TapEnv.relatedLanguageIsC()) {
                    return ILUtils.build(155, "1.0");
                }
                return ILUtils.build(155, "1.D0");
            }
            return ILUtils.build(155, "1.0");
        }
        return null;
    }

    @Override
    protected boolean containsMetaType(TapList<TypeSpec> dejaVu) {
        return this.elementType.containsMetaType(dejaVu);
    }

    @Override
    protected TypeSpec localize(TapList<TapTriplet<TypeSpec, TypeSpec, Boolean>> toAlreadyCopied, ToBool containsMeta) {
        ModifiedTypeSpec copiedResult = (ModifiedTypeSpec)this.findAlreadyCopiedType(toAlreadyCopied, containsMeta);
        if (copiedResult == null) {
            copiedResult = new ModifiedTypeSpec(null, this);
            copiedResult.undefinedSize = this.undefinedSize;
            copiedResult.setOrAddTypeDeclName(this.typeDeclName());
            TapTriplet<ModifiedTypeSpec, ModifiedTypeSpec, Boolean> alreadyRef = new TapTriplet<ModifiedTypeSpec, ModifiedTypeSpec, Boolean>(this, copiedResult, Boolean.FALSE);
            toAlreadyCopied.placdl(alreadyRef);
            if (this.elementType != null) {
                copiedResult.elementType = (WrapperTypeSpec)this.elementType.localize(toAlreadyCopied, containsMeta);
            }
            if (containsMeta.get()) {
                alreadyRef.third = Boolean.TRUE;
            } else {
                alreadyRef.first = null;
            }
        }
        return copiedResult;
    }

    @Override
    public TypeSpec preciseDimensions(TypeSpec complementType, TapList<TapPair<TypeSpec, TypeSpec>> dejaVu, SymbolTable symbolTable) {
        TypeSpec precisedType = (TypeSpec)TapList.cassq(this, dejaVu);
        if (precisedType == null) {
            if (!ModifiedTypeSpec.isA(complementType, 5)) {
                TypeSpec precisedElementActualType = null;
                assert (this.elementType != null);
                if (this.elementType.wrappedType != null) {
                    precisedElementActualType = this.elementType.wrappedType.preciseDimensions(complementType, dejaVu, symbolTable);
                }
                precisedType = !this.undefinedSize && precisedElementActualType == this.elementType.wrappedType ? this : (this.undefinedSize ? precisedElementActualType : new ModifiedTypeSpec(new WrapperTypeSpec(precisedElementActualType), this));
            } else {
                boolean preciseSize;
                precisedType = new ModifiedTypeSpec(null, this);
                dejaVu.placdl(new TapPair<ModifiedTypeSpec, TypeSpec>(this, precisedType));
                WrapperTypeSpec precisedElementType = WrapperTypeSpec.preciseDimensions(this.elementType, ((ModifiedTypeSpec)complementType).elementType, dejaVu, symbolTable);
                ModifiedTypeSpec complementModifiedType = (ModifiedTypeSpec)complementType;
                Tree complementModValue = complementModifiedType.sizeModifierResolved;
                boolean bl = preciseSize = this.undefinedSize || (this.sizeModifierResolved == null || this.sizeModifierResolved.opCode() != 101) && complementModValue != null && complementModValue.opCode() == 101;
                if (precisedElementType == this.elementType && !preciseSize || precisedElementType.wrappedType == null) {
                    precisedType = this;
                } else {
                    ((ModifiedTypeSpec)precisedType).elementType = precisedElementType;
                    ((ModifiedTypeSpec)precisedType).sizeModifier = complementModifiedType.sizeModifier;
                    ((ModifiedTypeSpec)precisedType).sizeModifierResolved = complementModValue;
                    ((ModifiedTypeSpec)precisedType).sizeModifierInteger = complementModifiedType.sizeModifierInteger;
                }
            }
        }
        return precisedType;
    }

    @Override
    protected TypeSpec addOneDimension(ArrayDim dimension) {
        if (ModifiedTypeSpec.isA(this.elementType, 2)) {
            return new ModifiedTypeSpec(this.elementType.addOneDimension(dimension), this);
        }
        ArrayDim[] dimensions = new ArrayDim[]{dimension};
        return new ArrayTypeSpec(new WrapperTypeSpec(this), dimensions);
    }

    @Override
    public TypeSpec intToReal(TapList<TapPair<TypeSpec, TypeSpec>> dejaVu, SymbolTable symbolTable) {
        TypeSpec convertedType = (TypeSpec)TapList.cassq(this, dejaVu);
        if (convertedType == null) {
            convertedType = new ModifiedTypeSpec(null, this);
            dejaVu.placdl(new TapPair<ModifiedTypeSpec, TypeSpec>(this, convertedType));
            WrapperTypeSpec convertedElementType = WrapperTypeSpec.intToReal(this.elementType, dejaVu, symbolTable);
            if (convertedElementType == this.elementType || convertedElementType.wrappedType == null) {
                convertedType = this;
            } else {
                ((ModifiedTypeSpec)convertedType).elementType = convertedElementType;
            }
        }
        return convertedType;
    }

    @Override
    protected TypeSpec realToComplex(TapList<TapPair<TypeSpec, TypeSpec>> dejaVu, WrapperTypeSpec complexTypeSpec) {
        TypeSpec convertedType = (TypeSpec)TapList.cassq(this, dejaVu);
        if (convertedType == null) {
            convertedType = new ModifiedTypeSpec(null, this);
            dejaVu.placdl(new TapPair<ModifiedTypeSpec, TypeSpec>(this, convertedType));
            TypeSpec convertedElementType = this.elementType.realToComplex(dejaVu, complexTypeSpec);
            if (convertedElementType == this.elementType || ((WrapperTypeSpec)convertedElementType).wrappedType == null) {
                convertedType = this;
            } else {
                ((ModifiedTypeSpec)convertedType).elementType = convertedElementType;
            }
        }
        return convertedType;
    }

    @Override
    public WrapperTypeSpec differentiateTypeSpec(SymbolTable symbolTable, SymbolTable srcSymbolTable, int diffUnitSort, String fSuffix, int maxDiffSorts, boolean localDecl, boolean multiDirMode, ArrayDim multiDirDimensionMax, ArrayDim pointerMultiDirDim, String hintArrayNameInText, String hintArrayNameInIdent, Tree hintArrayNameTree, Tree nameTree) {
        WrapperTypeSpec result;
        boolean addOneDimension = false;
        if (multiDirMode && !ModifiedTypeSpec.isA(this.elementType, 21)) {
            addOneDimension = true;
            multiDirMode = false;
        }
        if (TapEnv.associationByAddress()) {
            FieldDecl[] fields = new FieldDecl[]{new FieldDecl(TapEnv.assocAddressValueSuffix(), new WrapperTypeSpec(this)), new FieldDecl(TapEnv.assocAddressDiffSuffix(), new WrapperTypeSpec(this))};
            Tree modifiers = null;
            if (!TapEnv.relatedLanguageIsC()) {
                modifiers = ILUtils.build(128, ILUtils.build(94, "sequence"));
            }
            this.diffTypeSpec = new WrapperTypeSpec(new CompositeTypeSpec(null, fields, 8, modifiers, null));
            this.createOrGetDiffTypeDeclSymbolHolder(symbolTable, this.diffTypeSpec, fSuffix);
            result = this.diffTypeSpec;
        } else {
            WrapperTypeSpec diffElementType = this.elementType.checkDiffTypeSpec(symbolTable, srcSymbolTable, diffUnitSort, fSuffix, localDecl, multiDirMode, multiDirDimensionMax, null, hintArrayNameInText, hintArrayNameInIdent, hintArrayNameTree, null);
            if (diffElementType == null && !addOneDimension) {
                result = null;
            } else {
                TypeSpec resultActualTypeSpec = new ModifiedTypeSpec(diffElementType == null ? this.elementType : diffElementType, this);
                if (addOneDimension) {
                    resultActualTypeSpec = ((TypeSpec)resultActualTypeSpec).addOneDimension(multiDirDimensionMax);
                }
                result = new WrapperTypeSpec(resultActualTypeSpec);
            }
        }
        return result;
    }

    @Override
    protected void cumulActiveParts(TapList diffInfos, SymbolTable symbolTable) {
        if (diffInfos != null && this.elementType != null) {
            TypeDecl typeDecl;
            this.elementType.cumulActiveParts(diffInfos, symbolTable);
            if (this.typeDeclName() != null && this.needsADiffType(null) && (typeDecl = symbolTable.getTypeDecl(this.typeDeclName())) != null) {
                typeDecl.setActive(true);
            }
        }
    }

    @Override
    public boolean needsADiffType(TapList<TypeSpec> dejaVu) {
        return this.elementType != null && this.elementType.needsADiffType(dejaVu);
    }

    @Override
    public boolean isDifferentiated(TapList<TypeSpec> dejaVu) {
        return this.elementType != null && this.elementType.isDifferentiated(dejaVu);
    }

    @Override
    protected boolean checkTypeSpecValidity(TapList<TypeSpec> dejaVu) {
        if (this.elementType != null && this.elementType.wrappedType == this) {
            TapEnv.fileWarning(15, null, "(TC41) Illegal recursive type definition " + this.showType());
            return false;
        }
        assert (this.elementType != null);
        return this.elementType.checkTypeSpecValidity(dejaVu);
    }

    @Override
    public Tree generateTree(SymbolTable symbolTable, TapList<SymbolDecl> dependsOn, TapList<SymbolDecl> shortNames, boolean useShortNames, TapList<TypeSpec> dejaVu) {
        Tree result;
        if (TapList.contains(dejaVu, this)) {
            TapEnv.toolWarning(-1, "(TypeSpec tree regeneration) circular type");
            result = ILUtils.build(94, "CircularType");
        } else {
            dejaVu = new TapList<TypeSpec>(this, dejaVu);
            result = this.elementType.generateTree(symbolTable, dependsOn, shortNames, true, dejaVu);
            TapList<Tree> modifierExprs = null;
            if (!this.hasUndefinedSize()) {
                if (this.sizeModifier != null) {
                    modifierExprs = new TapList<Tree>(ILUtils.copy(this.sizeModifier), modifierExprs);
                }
                if (this.typeSign == 1) {
                    modifierExprs = new TapList<Tree>(ILUtils.build(94, "signed"), modifierExprs);
                } else if (this.typeSign == 2) {
                    modifierExprs = new TapList<Tree>(ILUtils.build(94, "unsigned"), modifierExprs);
                }
            }
            result = ModifiedTypeSpec.addTypeModifiers(result, modifierExprs);
        }
        return result;
    }

    @Override
    public String showType() {
        String signStr;
        int language;
        int n = language = TapEnv.relatedUnit() != null ? TapEnv.relatedUnit().language() : -1;
        String string = this.typeSign == 0 ? "" : (signStr = this.typeSign == 1 ? "signed " : "unsigned ");
        if (ILUtils.isIntCst(this.sizeModifierResolved, -4)) {
            if (this.elementType.isPrimitiveTypeFloat()) {
                return signStr + "long double";
            }
            return "long long " + this.elementType.showType();
        }
        if (ILUtils.isIntCst(this.sizeModifierResolved, -2)) {
            if (this.elementType.isPrimitiveTypeFloat()) {
                return signStr + (TapEnv.isFortran(language) ? "DOUBLE PRECISION" : "double");
            }
            if (this.elementType.isPrimitiveTypeInteger()) {
                return signStr + "long int";
            }
            return signStr + (TapEnv.isFortran(language) ? "DOUBLE PRECISION " : "long ") + this.elementType.showType();
        }
        if (ILUtils.isIdent(this.sizeModifierResolved, "undefinedSize", true)) {
            return signStr + this.elementType.showType();
        }
        return signStr + this.elementType.showType() + (TapEnv.isFortran(language) ? "*" : "_") + ILUtils.toString(this.sizeModifierResolved);
    }

    @Override
    public void dump() throws IOException {
        TapEnv.print(this.toString());
    }

    @Override
    public String toString() {
        return (this.typeDeclName() == null ? "" : "\"" + this.typeDeclName() + "\":") + "Modified" + '(' + ILUtils.toString(this.sizeModifier) + "->" + ILUtils.toString(this.sizeModifierResolved) + (this.hasUndefinedSize() ? " UndefSize! " : "") + '|' + (this.typeSign == 0 ? "" : (this.typeSign == 1 ? "signed" : "unsigned")) + ") " + (this.elementType == null ? "?" : this.elementType.toString());
    }
}

