/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.CompositeTypeSpec;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.InterfaceDecl;
import fr.inria.tapenade.representation.ModifiedTypeSpec;
import fr.inria.tapenade.representation.NamedTypeSpec;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.PrimitiveTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeDecl;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.Tree;

public final class NewSymbolHolder {
    private static final String unsolvedMark = "#";
    private final boolean isDerived;
    public SymbolDecl derivationFrom;
    private final int diffSymbolSort;
    public String probableName;
    public VariableDecl newVariableDecl;
    public VariableDecl newSolvedVariableDecl;
    public Unit definitionModule;
    public Tree hintRootTree;
    public Tree hintArrayTreeForCallSize;
    public boolean declare = true;
    public int zone = -1;
    private String finalName;
    private TapList<Tree> usageTrees;
    private TapList<SymbolTable> symbolUsageSymbolTables;
    private SymbolTable symbolSolvingRootSymbolTable;
    private TapList<Instruction> usageInstructions;
    private TapList<SymbolTable> newVariableDeclSymbolTables;
    private TapList<SymbolTable> varDeclTreeAlreadyPlacedFor;
    private FunctionDecl newFunctionDecl;
    private TapList<SymbolTable> newFunctionDeclSymbolTables;
    private InterfaceDecl newInterfaceDecl;
    private TapList<SymbolTable> newInterfaceDeclSymbolTables;
    private TypeDecl newTypeDecl;
    private TapList<SymbolTable> newTypeDeclSymbolTables;
    private TapList<SymbolTable> typeDeclTreeAlreadyPlacedFor;
    private SymbolTable varDeclarationRootSymbolTable;
    private SymbolTable otherDefSymbolTable;
    private String derivationSuffix = "";
    private Instruction instruction;
    private boolean usesRefTo;
    private TapList<SymbolDecl> dependsOn;
    private TapList<String> extraInfo;

    public NewSymbolHolder(String probableName, int diffSymbolSort) {
        this.isDerived = true;
        this.probableName = probableName;
        this.diffSymbolSort = diffSymbolSort;
    }

    public NewSymbolHolder(String probableName) {
        this.isDerived = false;
        this.probableName = probableName;
        this.diffSymbolSort = 0;
    }

    public NewSymbolHolder(String probableName, Unit hostUnit, WrapperTypeSpec type, int sizeModifier) {
        this.isDerived = false;
        this.probableName = probableName;
        this.diffSymbolSort = 0;
        if (sizeModifier != -1) {
            type = new WrapperTypeSpec(new ModifiedTypeSpec(type, ILUtils.build(101, sizeModifier), null));
        }
        this.setAsVariable(type, null);
        this.prepareDeclarationInstr(hostUnit);
    }

    public static boolean isANewSymbolRef(Tree refTree) {
        return refTree.getAnnotation("NewSymbolHolder") != null;
    }

    public static NewSymbolHolder getNewSymbolHolder(Tree refTree) {
        return (NewSymbolHolder)refTree.getAnnotation("NewSymbolHolder");
    }

    public static boolean sameNSH(Tree tree1, Tree tree2) {
        NewSymbolHolder nsh2;
        NewSymbolHolder nsh1 = (NewSymbolHolder)tree1.getAnnotation("NewSymbolHolder");
        return nsh1 == (nsh2 = (NewSymbolHolder)tree2.getAnnotation("NewSymbolHolder"));
    }

    private static WrapperTypeSpec checkVariableDimension(WrapperTypeSpec typeSpec, String arrayNameInIdent, String arrayNameInText, Tree treeInCallSize, Unit diffUnit, Unit origUnit, SymbolTable symbolTable) {
        if (typeSpec != null) {
            TypeSpec actualTypeSpec = typeSpec.wrappedType;
            if (actualTypeSpec != null) {
                switch (actualTypeSpec.kind()) {
                    case 5: {
                        ModifiedTypeSpec oldModifiedType = (ModifiedTypeSpec)actualTypeSpec;
                        WrapperTypeSpec newElementType = NewSymbolHolder.checkVariableDimension(oldModifiedType.elementType(), arrayNameInIdent, arrayNameInText, treeInCallSize, diffUnit, origUnit, symbolTable);
                        if (newElementType == oldModifiedType.elementType()) {
                            return typeSpec;
                        }
                        return new WrapperTypeSpec(new ModifiedTypeSpec(newElementType, oldModifiedType));
                    }
                    case 2: {
                        ArrayTypeSpec oldArrayType = (ArrayTypeSpec)actualTypeSpec;
                        ArrayDim[] dimensions = oldArrayType.dimensions();
                        ArrayDim[] newDimensions = new ArrayDim[dimensions.length];
                        boolean oneDimensionChanged = false;
                        for (int i = dimensions.length - 1; i >= 0; --i) {
                            int dimRank = origUnit.isC() ? i + 1 : dimensions.length - i;
                            newDimensions[i] = NewSymbolHolder.checkArrayDimension(dimensions[i], dimRank, arrayNameInIdent, arrayNameInText, treeInCallSize, diffUnit, origUnit, symbolTable);
                            if (newDimensions[i] == dimensions[i]) continue;
                            oneDimensionChanged = true;
                        }
                        WrapperTypeSpec newElementType = NewSymbolHolder.checkVariableDimension(oldArrayType.elementType(), arrayNameInIdent, arrayNameInText, treeInCallSize, diffUnit, origUnit, symbolTable);
                        if (oneDimensionChanged || newElementType != oldArrayType.elementType()) {
                            return new WrapperTypeSpec(new ArrayTypeSpec(newElementType, newDimensions));
                        }
                        return typeSpec;
                    }
                }
                return typeSpec;
            }
            return typeSpec;
        }
        return null;
    }

    private static ArrayDim checkArrayDimension(ArrayDim arrayDim, int dimRank, String arrayNameInIdent, String arrayNameInText, Tree treeInSize, Unit diffUnit, Unit origUnit, SymbolTable symbolTable) {
        if (ILUtils.isNullOrNoneOrStar(arrayDim.tree())) {
            if (TapEnv.get().noisize77 && treeInSize != null && ILUtils.isAVarRef(treeInSize, symbolTable)) {
                Tree lengthTree = ILUtils.buildCall(ILUtils.build(94, "size"), ILUtils.build(70, ILUtils.copy(treeInSize)));
                arrayDim.setSize(lengthTree);
            } else if (!TapEnv.get().noisize77 && arrayDim.upper == null && !NewSymbolHolder.isNBDirsMax(arrayDim.tree())) {
                arrayDim = NewSymbolHolder.createIsizeArrayDim(arrayDim, dimRank, arrayNameInIdent, arrayNameInText, diffUnit, origUnit);
            }
        }
        return arrayDim;
    }

    private static ArrayDim createIsizeArrayDim(ArrayDim arrayDim, int dimRank, String arrayNameInIdent, String arrayNameInText, Unit diffUnit, Unit origUnit) {
        arrayDim = arrayDim.copy();
        String sizeHint = "the value of " + ILUtils.toString(arrayDim.getSize());
        if (TapEnv.relatedUnit() != null) {
            origUnit = TapEnv.relatedUnit();
        }
        String sizeName = "ISIZE" + dimRank + "OF" + arrayNameInIdent + "IN" + origUnit.name;
        TapEnv.fileWarning(15, null, "(AD11) User help requested: constant " + sizeName + " must hold the size of dimension " + dimRank + " of " + arrayNameInText + " (should be " + sizeHint + ')');
        arrayDim.setSize(ILUtils.build(94, sizeName));
        diffUnit.userHelp.placdl(new TapPair<String, String>(sizeHint, sizeName));
        return arrayDim;
    }

    private static boolean isNBDirsMax(Tree dimTree) {
        if (dimTree == null) {
            return false;
        }
        switch (dimTree.opCode()) {
            case 58: {
                return NewSymbolHolder.isNBDirsMax(dimTree.down(2));
            }
            case 2: {
                return NewSymbolHolder.isNBDirsMax(dimTree.down(1)) || NewSymbolHolder.isNBDirsMax(dimTree.down(2));
            }
            case 177: {
                return NewSymbolHolder.isNBDirsMax(dimTree.down(1));
            }
            case 94: {
                String name = ILUtils.getIdentString(dimTree).toLowerCase();
                return name.equals("#nbdirsmax#") || name.equals("nbdirsmax");
            }
        }
        return false;
    }

    public static void copySymbolHolderAnnotation(Tree fromTree, Tree toTree, SymbolTable newUsageSymbolTable) {
        NewSymbolHolder symbolHolder = (NewSymbolHolder)fromTree.getAnnotation("NewSymbolHolder");
        if (symbolHolder != null) {
            symbolHolder.registerNewRef(toTree, newUsageSymbolTable);
            symbolHolder.declarationLevelMustInclude(newUsageSymbolTable);
        }
    }

    public static VariableDecl getAttachedVariableDecl(Tree tree) {
        NewSymbolHolder symbolHolder = (NewSymbolHolder)tree.getAnnotation("NewSymbolHolder");
        if (symbolHolder != null) {
            return symbolHolder.newVariableDecl;
        }
        return null;
    }

    public static TapPair<NewSymbolHolder, Tree> buildCptrTree(Tree expr, SymbolTable usageSymbolTable, boolean isNullPTR, String cptrName, Unit targetUnit, WrapperTypeSpec type, boolean initCptr) {
        NewSymbolHolder newSH;
        NewSymbolHolder symbolHolder = NewSymbolHolder.getNewSymbolHolder(usageSymbolTable, cptrName);
        if (symbolHolder == null) {
            newSH = new NewSymbolHolder(cptrName, targetUnit, new WrapperTypeSpec(new NamedTypeSpec("C_PTR")), -1);
            Tree declCptr = ILUtils.build(194, ILUtils.build(128), ILUtils.build(94, "C_PTR"), ILUtils.build(53, newSH.makeNewRef(usageSymbolTable)));
            newSH.setInstruction(new Instruction(declCptr));
        } else {
            newSH = symbolHolder;
        }
        newSH.declarationLevelMustInclude(usageSymbolTable);
        Tree cptrTree = newSH.makeNewRef(usageSymbolTable);
        Tree assignExpr = null;
        if (initCptr) {
            assignExpr = isNullPTR ? ILUtils.build(13, cptrTree, ILUtils.build(94, "C_NULL_PTR")) : ILUtils.build(13, cptrTree, ILUtils.buildCLoc(expr, "C_LOC"));
        }
        Tree callCFPTR = ILUtils.buildCall(ILUtils.build(94, "c_f_pointer"), ILUtils.build(70, newSH.makeNewRef(usageSymbolTable), ILUtils.copy(expr)));
        boolean needShape = TypeSpec.isA(((PointerTypeSpec)type.wrappedType).destinationType, 2);
        if (needShape) {
            NewSymbolHolder shapeHolder;
            String shape = "UNKNOWN_SHAPE_IN_" + targetUnit.origUnit.name;
            symbolHolder = NewSymbolHolder.getNewSymbolHolder(usageSymbolTable, shape = shape.toUpperCase());
            if (symbolHolder == null) {
                shapeHolder = new NewSymbolHolder(shape, targetUnit, new WrapperTypeSpec(new PrimitiveTypeSpec("integer")), -1);
                Tree declShape = ILUtils.build(194, ILUtils.build(128), ILUtils.build(102), ILUtils.build(53, shapeHolder.makeNewRef(usageSymbolTable)));
                shapeHolder.setInstruction(new Instruction(declShape));
            } else {
                shapeHolder = symbolHolder;
            }
            ILUtils.getArguments(callCFPTR).addChild(ILUtils.build(9, shapeHolder.makeNewRef(usageSymbolTable)), 3);
            shapeHolder.declarationLevelMustInclude(usageSymbolTable);
        }
        Tree result = initCptr ? ILUtils.build(26, assignExpr, callCFPTR) : ILUtils.build(26, callCFPTR);
        targetUnit.usesISO_C_BINDING = true;
        return new TapPair<NewSymbolHolder, Tree>(newSH, result);
    }

    private static NewSymbolHolder getNewSymbolHolder(SymbolTable usageSymbolTable, String cptrName) {
        TapList inSymbolHolders = usageSymbolTable.newSymbolHolders.tail;
        NewSymbolHolder symbolHolder = null;
        while (symbolHolder == null && inSymbolHolders != null) {
            NewSymbolHolder oneSymbolHolder = (NewSymbolHolder)inSymbolHolders.head;
            if (oneSymbolHolder.probableName() != null && oneSymbolHolder.probableName().equals(cptrName)) {
                symbolHolder = oneSymbolHolder;
            }
            inSymbolHolders = inSymbolHolders.tail;
        }
        return symbolHolder;
    }

    public void setUsesRefTo() {
        this.usesRefTo = true;
    }

    public boolean usesRefTo() {
        return this.usesRefTo;
    }

    public boolean hasNewFunctionDecl() {
        return this.newFunctionDecl != null;
    }

    public TypeDecl newTypeDecl() {
        return this.newTypeDecl;
    }

    public void setAsVariable(WrapperTypeSpec typeSpec, TapList<SymbolDecl> dependsOn) {
        if (this.newVariableDecl == null) {
            this.newVariableDecl = new VariableDecl(ILUtils.build(94, unsolvedMark + this.probableName + unsolvedMark), null);
        }
        this.newVariableDecl.setType(typeSpec);
        this.newVariableDecl.dependsOn = dependsOn;
    }

    public void setHintRootTree(Tree hintRootTree) {
        if (hintRootTree != null) {
            this.hintRootTree = hintRootTree;
        }
    }

    public void setHintArrayTreeForCallSize(Tree hintSize) {
        this.hintArrayTreeForCallSize = hintSize;
    }

    public void setDependsOn(TapList<SymbolDecl> dependsOn) {
        this.dependsOn = this.dependsOn == null ? dependsOn : TapList.append(dependsOn, this.dependsOn);
    }

    public TapList<SymbolDecl> dependsOn() {
        return this.dependsOn;
    }

    public void setAsConstantVariable(WrapperTypeSpec typeSpec, TapList<SymbolDecl> dependsOn, Tree value) {
        if (this.newVariableDecl == null) {
            this.newVariableDecl = new VariableDecl(ILUtils.build(94, unsolvedMark + this.probableName + unsolvedMark), null);
        }
        this.newVariableDecl.setType(typeSpec);
        this.newVariableDecl.setConstant();
        this.newVariableDecl.setInitializationTree(value);
        this.newVariableDecl.dependsOn = dependsOn;
    }

    public void setAsType(WrapperTypeSpec typeSpec, TapList<SymbolDecl> dependsOn) {
        Tree nameTree = ILUtils.build(94, unsolvedMark + this.probableName + unsolvedMark);
        this.newTypeDecl = new TypeDecl(nameTree, typeSpec);
        this.newTypeDecl.dependsOn = dependsOn;
    }

    public void setNewTypeDecl(TypeDecl typeDecl) {
        this.newTypeDecl = typeDecl;
    }

    public Tree makeNewRef(SymbolTable symbolTable) {
        Tree result;
        if (this.finalName == null) {
            result = ILUtils.build(94, unsolvedMark + this.probableName + unsolvedMark);
            this.registerNewRef(result, symbolTable);
        } else {
            result = ILUtils.build(94, this.finalName);
        }
        return result;
    }

    private void registerNewRef(Tree newUsage, SymbolTable symbolTable) {
        newUsage.setAnnotation("NewSymbolHolder", this);
        this.usageTrees = new TapList<Tree>(newUsage, this.usageTrees);
        this.solvingLevelMustInclude(symbolTable);
    }

    public void solvingLevelMustInclude(SymbolTable symbolTable) {
        if (this.finalName == null && symbolTable != null && !TapList.contains(this.symbolUsageSymbolTables, symbolTable)) {
            this.symbolUsageSymbolTables = new TapList<SymbolTable>(symbolTable, this.symbolUsageSymbolTables);
            if (this.symbolSolvingRootSymbolTable == null) {
                this.symbolSolvingRootSymbolTable = symbolTable;
                this.symbolSolvingRootSymbolTable.addNewSymbolHolder(this);
            } else if (!symbolTable.nestedIn(this.symbolSolvingRootSymbolTable)) {
                SymbolTable commonRootSymbolTable = this.symbolSolvingRootSymbolTable.getCommonRoot(symbolTable);
                if (commonRootSymbolTable == null) {
                    TapEnv.printlnOnTrace("Tool: (Creating new symbol 1) Internal error: Incoherent SymbolTables " + this + " in " + symbolTable.shortName());
                } else if (commonRootSymbolTable != this.symbolSolvingRootSymbolTable) {
                    this.symbolSolvingRootSymbolTable.delNewSymbolHolder(this);
                    this.symbolSolvingRootSymbolTable = commonRootSymbolTable;
                    this.symbolSolvingRootSymbolTable.addNewSymbolHolder(this);
                }
            }
        }
    }

    public void declarationLevelMustInclude(SymbolTable symbolTable) {
        if (symbolTable != null) {
            if (this.varDeclarationRootSymbolTable == null) {
                this.varDeclarationRootSymbolTable = symbolTable;
            } else if (!symbolTable.nestedIn(this.varDeclarationRootSymbolTable)) {
                SymbolTable commonRootSymbolTable = this.varDeclarationRootSymbolTable.getCommonRoot(symbolTable);
                if (commonRootSymbolTable == null) {
                    TapEnv.toolError("(Creating new symbol 2) Internal error: Incoherent SymbolTables " + this + " in " + symbolTable.shortName());
                } else {
                    this.varDeclarationRootSymbolTable = commonRootSymbolTable;
                }
            }
        }
    }

    public void setOtherDefSymbolTable(SymbolTable symbolTable) {
        this.otherDefSymbolTable = symbolTable;
    }

    private void addVariableDeclSymbolTable(SymbolTable symbolTable) {
        TapList<SymbolTable> toAlreadyHere;
        TapList<SymbolTable> inAlreadyHere = toAlreadyHere = new TapList<SymbolTable>(null, this.newVariableDeclSymbolTables);
        while (inAlreadyHere.tail != null && symbolTable != null) {
            SymbolTable alreadySymbolTable = (SymbolTable)inAlreadyHere.tail.head;
            if (alreadySymbolTable == symbolTable || symbolTable.nestedIn(alreadySymbolTable)) {
                symbolTable = null;
                continue;
            }
            if (alreadySymbolTable.nestedIn(symbolTable)) {
                inAlreadyHere.tail = inAlreadyHere.tail.tail;
                continue;
            }
            inAlreadyHere = inAlreadyHere.tail;
        }
        this.newVariableDeclSymbolTables = symbolTable == null ? toAlreadyHere.tail : new TapList<SymbolTable>(symbolTable, toAlreadyHere.tail);
    }

    public void setVarDeclTreeAlreadyPlacedFor(SymbolTable symbolTable) {
        this.varDeclTreeAlreadyPlacedFor = TapList.addUnlessPresent(this.varDeclTreeAlreadyPlacedFor, symbolTable);
    }

    public void addTypeDeclSymbolTable(SymbolTable symbolTable) {
        this.newTypeDeclSymbolTables = TapList.addUnlessPresent(this.newTypeDeclSymbolTables, symbolTable);
    }

    public void setTypeDeclTreeAlreadyPlacedFor(SymbolTable symbolTable) {
        this.typeDeclTreeAlreadyPlacedFor = TapList.addUnlessPresent(this.typeDeclTreeAlreadyPlacedFor, symbolTable);
    }

    private void addFunctionDeclSymbolTable(SymbolTable symbolTable) {
        this.newFunctionDeclSymbolTables = TapList.addUnlessPresent(this.newFunctionDeclSymbolTables, symbolTable);
    }

    private void addInterfaceDeclSymbolTable(SymbolTable symbolTable) {
        this.newInterfaceDeclSymbolTables = TapList.addUnlessPresent(this.newInterfaceDeclSymbolTables, symbolTable);
    }

    private boolean varDeclTreeAlreadyPlacedFor(SymbolTable symbolTable) {
        SymbolTable companionST = null;
        if (symbolTable.unit != null && symbolTable.unit.isFortran()) {
            if (symbolTable == symbolTable.unit.publicSymbolTable()) {
                companionST = symbolTable.unit.privateSymbolTable();
            } else if (symbolTable == symbolTable.unit.privateSymbolTable()) {
                companionST = symbolTable.unit.publicSymbolTable();
            }
        }
        return TapList.contains(this.varDeclTreeAlreadyPlacedFor, symbolTable) || companionST != null && TapList.contains(this.varDeclTreeAlreadyPlacedFor, companionST);
    }

    public void prepareDeclarationInstr(Unit targetUnit) {
        if (targetUnit != null && targetUnit.privateSymbolTable() != null) {
            Instruction newDecl = new Instruction();
            newDecl.block = targetUnit.privateSymbolTable().declarationsBlock;
            this.setInstruction(newDecl);
        }
    }

    public String probableName() {
        return this.probableName;
    }

    public String finalName() {
        return this.finalName;
    }

    public VariableDecl newVariableDecl() {
        return this.newVariableDecl;
    }

    public FunctionDecl newFunctionDecl() {
        return this.newFunctionDecl;
    }

    public WrapperTypeSpec typeSpec() {
        if (this.newVariableDecl != null && this.newVariableDecl.isA(1)) {
            return this.newVariableDecl.type();
        }
        if (this.newTypeDecl != null) {
            return this.newTypeDecl.typeSpec;
        }
        return null;
    }

    public void declareUsageInstruction(Instruction instruction) {
        this.usageInstructions = new TapList<Instruction>(instruction, this.usageInstructions);
    }

    public void accumulateSymbolDecl(SymbolDecl newSymbolDecl, SymbolTable targetSymbolTable) {
        if (newSymbolDecl != null) {
            newSymbolDecl.symbol = unsolvedMark + this.probableName + unsolvedMark;
            this.solvingLevelMustInclude(targetSymbolTable);
            if (newSymbolDecl.isA(1)) {
                this.newVariableDecl = (VariableDecl)newSymbolDecl;
                this.addVariableDeclSymbolTable(targetSymbolTable);
                this.extraInfo = newSymbolDecl.extraInfo();
            } else if (newSymbolDecl.isA(3)) {
                if (((FunctionDecl)newSymbolDecl).unit() != null && !((FunctionDecl)newSymbolDecl).unit().isInterface() || this.newFunctionDecl == null || this.newFunctionDecl.unit() == null || !this.newFunctionDecl.unit().isStandard()) {
                    this.newFunctionDecl = (FunctionDecl)newSymbolDecl;
                }
                this.addFunctionDeclSymbolTable(targetSymbolTable);
            } else if (newSymbolDecl.isA(16)) {
                this.newInterfaceDecl = (InterfaceDecl)newSymbolDecl;
                this.addInterfaceDeclSymbolTable(targetSymbolTable);
            } else if (newSymbolDecl.isA(4)) {
                this.newTypeDecl = (TypeDecl)newSymbolDecl;
                this.addTypeDeclSymbolTable(targetSymbolTable);
            } else {
                TapEnv.toolError("Not yet implemented: accumulateSymbolDecl() for " + newSymbolDecl + " :" + this.probableName);
            }
        }
    }

    public void accumulateTargetForSymbolDecl(SymbolDecl modelSymbolDecl, SymbolTable targetSymbolTable) {
        this.solvingLevelMustInclude(targetSymbolTable);
        if (modelSymbolDecl.isA(1) || modelSymbolDecl.isA(5)) {
            this.addVariableDeclSymbolTable(targetSymbolTable);
        } else if (modelSymbolDecl.isA(3)) {
            this.addFunctionDeclSymbolTable(targetSymbolTable);
        } else if (modelSymbolDecl.isA(16)) {
            this.addInterfaceDeclSymbolTable(targetSymbolTable);
        } else if (modelSymbolDecl.isA(4)) {
            this.addTypeDeclSymbolTable(targetSymbolTable);
        } else {
            TapEnv.toolError("Not yet implemented: accumulateTargetForSymbolDecl() for " + modelSymbolDecl + " :" + this.probableName);
        }
    }

    public void absorb(NewSymbolHolder absorbedSymbolHolder) {
        if (absorbedSymbolHolder.newVariableDecl != null) {
            if (this.newVariableDecl == null) {
                this.newVariableDecl = absorbedSymbolHolder.newVariableDecl;
                this.newVariableDecl.replaceDiffSymbolHolder(absorbedSymbolHolder, this);
            } else if (absorbedSymbolHolder.newVariableDecl != this.newVariableDecl) {
                TapEnv.toolError("Not yet implemented: absorb " + absorbedSymbolHolder.newVariableDecl + " into " + this.newVariableDecl);
            }
        }
        if (absorbedSymbolHolder.newFunctionDecl != null) {
            if (this.newFunctionDecl == null) {
                this.newFunctionDecl = absorbedSymbolHolder.newFunctionDecl;
                this.newFunctionDecl.replaceDiffSymbolHolder(absorbedSymbolHolder, this);
            } else if (absorbedSymbolHolder.newFunctionDecl != this.newFunctionDecl) {
                TapEnv.toolError("Not yet implemented: absorb " + absorbedSymbolHolder.newFunctionDecl + " into " + this.newFunctionDecl);
            }
        }
        if (absorbedSymbolHolder.newInterfaceDecl != null) {
            if (this.newInterfaceDecl == null) {
                this.newInterfaceDecl = absorbedSymbolHolder.newInterfaceDecl;
                this.newInterfaceDecl.replaceDiffSymbolHolder(absorbedSymbolHolder, this);
            } else if (absorbedSymbolHolder.newInterfaceDecl != this.newInterfaceDecl) {
                TapEnv.toolError("Not yet implemented: absorb " + absorbedSymbolHolder.newInterfaceDecl + " into " + this.newInterfaceDecl);
            }
        }
        if (absorbedSymbolHolder.newTypeDecl != null) {
            if (this.newTypeDecl == null) {
                this.newTypeDecl = absorbedSymbolHolder.newTypeDecl;
                this.newTypeDecl.replaceDiffSymbolHolder(absorbedSymbolHolder, this);
            } else if (absorbedSymbolHolder.newTypeDecl != this.newTypeDecl) {
                TapEnv.toolError("Not yet implemented: absorb " + absorbedSymbolHolder.newTypeDecl + " into " + this.newTypeDecl);
            }
        }
        this.symbolUsageSymbolTables = TapList.union(this.symbolUsageSymbolTables, absorbedSymbolHolder.symbolUsageSymbolTables);
        if (this.symbolSolvingRootSymbolTable == null) {
            this.symbolSolvingRootSymbolTable = absorbedSymbolHolder.symbolSolvingRootSymbolTable;
        }
        this.usageInstructions = TapList.union(this.usageInstructions, absorbedSymbolHolder.usageInstructions);
        this.newVariableDeclSymbolTables = TapList.union(this.newVariableDeclSymbolTables, absorbedSymbolHolder.newVariableDeclSymbolTables);
        this.varDeclTreeAlreadyPlacedFor = TapList.union(this.varDeclTreeAlreadyPlacedFor, absorbedSymbolHolder.varDeclTreeAlreadyPlacedFor);
        this.newFunctionDeclSymbolTables = TapList.union(this.newFunctionDeclSymbolTables, absorbedSymbolHolder.newFunctionDeclSymbolTables);
        this.newInterfaceDeclSymbolTables = TapList.union(this.newInterfaceDeclSymbolTables, absorbedSymbolHolder.newInterfaceDeclSymbolTables);
        this.newTypeDeclSymbolTables = TapList.union(this.newTypeDeclSymbolTables, absorbedSymbolHolder.newTypeDeclSymbolTables);
        this.typeDeclTreeAlreadyPlacedFor = TapList.union(this.typeDeclTreeAlreadyPlacedFor, absorbedSymbolHolder.typeDeclTreeAlreadyPlacedFor);
        if (this.varDeclarationRootSymbolTable == null) {
            this.varDeclarationRootSymbolTable = absorbedSymbolHolder.varDeclarationRootSymbolTable;
        }
        this.dependsOn = TapList.union(this.dependsOn, absorbedSymbolHolder.dependsOn);
        TapList<Tree> oldUsages = absorbedSymbolHolder.usageTrees;
        while (oldUsages != null) {
            ((Tree)oldUsages.head).setAnnotation("NewSymbolHolder", this);
            this.usageTrees = new TapList<Tree>((Tree)oldUsages.head, this.usageTrees);
            oldUsages = oldUsages.tail;
        }
    }

    public void solve(SymbolTable symbolTable, boolean noCopySuffix) {
        Tree usageTree;
        if (this.varDeclarationRootSymbolTable != null) {
            this.addVariableDeclSymbolTable(this.varDeclarationRootSymbolTable);
        }
        int i = -1;
        if (this.derivationFrom != null && this.derivationFrom.symbol != null && this.derivationFrom.isA(1) && this.derivationFrom.getDiffSymbolHolder(this.diffSymbolSort, null) == null) {
            this.probableName = TapEnv.extendStringWithSuffix(this.derivationFrom.symbol, this.derivationSuffix);
        }
        if (!symbolTable.isCaseDependent()) {
            this.probableName = this.probableName.toLowerCase();
        }
        this.finalName = this.probableName;
        if (!this.isASameNameCopy(noCopySuffix)) {
            i = 0;
            TapList<SymbolTable> insideUnitSymbolTables = null;
            if (this.newVariableDecl != null && this.newVariableDecl.isReturnVar && symbolTable.unit != null) {
                insideUnitSymbolTables = symbolTable.unit.symbolTablesBottomUp();
            }
            while (!this.availableSymbol(this.finalName, this.symbolUsageSymbolTables, insideUnitSymbolTables)) {
                if (TapEnv.inputLanguage() != 100) {
                    this.finalName = this.probableName + i++;
                    continue;
                }
                if (this.newFunctionDecl != null && this.newFunctionDecl.unit() != null && this.newFunctionDecl.unit().isCalledFromOtherLanguage() && this.newFunctionDecl.unit().isC()) {
                    String name;
                    if (symbolTable.language() == 4 || symbolTable.language() == 5 || symbolTable.basisSymbolTable() == null) {
                        name = (String)symbolTable.getCallGraph().getMixedLanguageFunctionName((String)this.probableName, (int)this.newFunctionDecl.unit().language(), (int)1).first;
                        name = name + i++;
                        this.finalName = (String)symbolTable.getCallGraph().getMixedLanguageFunctionName((String)name, (int)1, (int)this.newFunctionDecl.unit().language()).first;
                        continue;
                    }
                    name = (String)symbolTable.getCallGraph().getMixedLanguageFunctionName((String)this.probableName, (int)1, (int)this.newFunctionDecl.unit().language()).first;
                    this.finalName = (String)symbolTable.getCallGraph().getMixedLanguageFunctionName((String)name, (int)this.newFunctionDecl.unit().language(), (int)1).first;
                    this.finalName = this.finalName + i++;
                    continue;
                }
                this.finalName = this.probableName + i++;
            }
        }
        this.symbolUsageSymbolTables = null;
        if (TapEnv.inputLanguage() != 100) {
            while (this.usageTrees != null) {
                usageTree = (Tree)this.usageTrees.head;
                usageTree.setValue(this.finalName);
                usageTree.removeAnnotation("NewSymbolHolder");
                this.usageTrees = this.usageTrees.tail;
            }
        } else {
            if (this.newFunctionDecl != null && this.newFunctionDecl.unit() != null && this.newFunctionDecl.unit().isCalledFromOtherLanguage() && this.newFunctionDecl.unit().isC()) {
                this.finalName = this.finalName.toLowerCase();
            }
            while (this.usageTrees != null) {
                usageTree = (Tree)this.usageTrees.head;
                String usageTreeStringValue = usageTree.stringValue();
                if (!usageTreeStringValue.isEmpty()) {
                    if ((usageTreeStringValue = usageTreeStringValue.substring(1, usageTreeStringValue.length() - 1)).equals(this.probableName)) {
                        usageTree.setValue(this.finalName);
                    } else {
                        String finalNameC = usageTreeStringValue;
                        finalNameC = finalNameC.toLowerCase();
                        if (i != 0) {
                            finalNameC = finalNameC + (i - 1);
                        }
                        usageTree.setValue(finalNameC);
                    }
                    usageTree.removeAnnotation("NewSymbolHolder");
                }
                this.usageTrees = this.usageTrees.tail;
            }
        }
        if (this.newVariableDecl != null) {
            this.newVariableDecl.symbol = this.finalName;
            this.newVariableDecl.eraseDiffSymbolHolder(this.diffSymbolSort);
            if (this.extraInfo != null && this.oneNotInModule(this.newVariableDeclSymbolTables)) {
                this.extraInfo = TapList.cleanExtraInfoValue(this.extraInfo, "public");
                this.extraInfo = TapList.cleanExtraInfoValue(this.extraInfo, "private");
            }
            if (TapList.containsOneOfStrings(this.extraInfo, new String[]{"in", "out", "inout", "optional", "value"}, symbolTable.unit != null && !symbolTable.unit.isFortran()) && this.oneDeclarationInLocalVars() != null) {
                this.extraInfo = TapList.cleanExtraInfoValue(this.extraInfo, "in");
                this.extraInfo = TapList.cleanExtraInfoValue(this.extraInfo, "out");
                this.extraInfo = TapList.cleanExtraInfoValue(this.extraInfo, "inout");
                this.extraInfo = TapList.cleanExtraInfoValue(this.extraInfo, "value");
                this.extraInfo = TapList.cleanExtraInfoValue(this.extraInfo, "optional");
            }
            this.newVariableDecl.setExtraInfo(this.extraInfo);
            if (this.derivationFrom != null && this.derivationFrom.isA(1) && this.newVariableDecl.formalArgRank == -1) {
                this.newVariableDecl.formalArgRank = ((VariableDecl)this.derivationFrom).formalArgRank;
            }
            if (this.instruction == null && !this.newVariableDecl.hasMainInstruction()) {
                Tree typeTree;
                if (this.newVariableDecl.type().wrappedType == null) {
                    TapEnv.toolWarning(-1, "(New symbol declaration) null wrapped type for " + this.finalName);
                    typeTree = ILUtils.build(94, "UnknownType");
                } else {
                    typeTree = this.newVariableDecl.type().wrappedType.generateTree(null, null, null, true, null);
                }
                if (this.newVariableDecl.extraInfo() != null) {
                    TapList<String> extra = TapList.reverse(this.newVariableDecl.extraInfo());
                    TapList<Tree> modifiers = null;
                    while (extra != null) {
                        modifiers = new TapList<Tree>(ILUtils.build(94, (String)extra.head), modifiers);
                        extra = extra.tail;
                    }
                    typeTree = ILUtils.build(127, ILUtils.build(128, modifiers), typeTree);
                }
                Tree newTree = ILUtils.build(194, ILUtils.build(128), typeTree, ILUtils.build(53, ILUtils.build(94, this.newVariableDecl.symbol)));
                if (this.newVariableDecl.formalArgRank == -1) {
                    this.instruction = new Instruction(newTree);
                }
                this.newVariableDecl.setInstruction(this.instruction);
            }
            if (this.declare) {
                SymbolTable pbFortranSymbolTable;
                if (this.instruction != null && this.instruction.tree != null && this.newVariableDecl.isA(1) && (pbFortranSymbolTable = this.oneSymbolTableIsF77Local(this.newVariableDeclSymbolTables)) != null) {
                    WrapperTypeSpec oldTypeSpec = this.newVariableDecl.type();
                    String hintNameInIdent = this.finalName;
                    String hintNameInText = this.finalName;
                    if (this.hintRootTree != null) {
                        hintNameInIdent = ILUtils.buildNameInText(this.hintRootTree);
                        hintNameInText = ILUtils.buildNameInText(this.hintRootTree);
                    }
                    this.newVariableDecl.setType(NewSymbolHolder.checkVariableDimension(this.newVariableDecl.type(), hintNameInIdent, hintNameInText, this.hintArrayTreeForCallSize, pbFortranSymbolTable.unit, pbFortranSymbolTable.origUnit(), symbolTable));
                    this.newVariableDecl.setType(this.newVariableDecl.type().checkNoneDimensionsOfNewSH(hintNameInText, hintNameInIdent, this.hintArrayTreeForCallSize, pbFortranSymbolTable, this));
                    if (oldTypeSpec != this.newVariableDecl.type()) {
                        Tree declarators = this.instruction.tree.down(3);
                        int rank = ILUtils.findRankOfDeclarator(declarators, this.newVariableDecl.symbol);
                        if (rank > 0) {
                            declarators.removeChild(rank);
                        }
                        this.newVariableDecl.setNullInstruction();
                        this.instruction = null;
                    }
                }
                if (!this.newVariableDecl.hasInstructionWithRootOperator(194, null) && this.instruction != null) {
                    if (this.instruction.tree == null) {
                        this.instruction.tree = ILUtils.build(194, ILUtils.build(128), this.newVariableDecl.type().wrappedType.generateTree(null, null, null, true, null), ILUtils.build(53, ILUtils.build(94, this.finalName)));
                    }
                    this.newVariableDecl.setInstruction(this.instruction);
                }
                while (this.newVariableDeclSymbolTables != null) {
                    SymbolTable vdSymbolTable = (SymbolTable)this.newVariableDeclSymbolTables.head;
                    this.addSymbolDeclAndInstr(vdSymbolTable, this.newVariableDecl);
                    this.newVariableDeclSymbolTables = this.newVariableDeclSymbolTables.tail;
                }
                if (this.otherDefSymbolTable != null) {
                    VariableDecl copyVariableDecl = (VariableDecl)this.newVariableDecl.copy(null, null);
                    this.addSymbolDeclAndInstr(this.otherDefSymbolTable, copyVariableDecl);
                }
            }
            if (this.derivationFrom != null && this.derivationFrom instanceof VariableDecl && ((VariableDecl)this.derivationFrom).initializationTree() != null) {
                Tree origInitTree = ((VariableDecl)this.derivationFrom).getInitializationTree();
                Tree diffInitVal = this.newVariableDecl.type().wrappedType.buildConstantZero();
                if (!this.derivationFrom.isA(5)) {
                    diffInitVal = ILUtils.build(origInitTree.opCode(), null, diffInitVal);
                }
                this.newVariableDecl.setInitializationTree(diffInitVal);
            }
            this.newSolvedVariableDecl = this.newVariableDecl;
            if (!TapEnv.associationByAddress()) {
                this.newVariableDecl = null;
            }
        }
        if (this.newFunctionDecl != null) {
            Unit unit;
            this.newFunctionDecl.symbol = this.finalName;
            this.newFunctionDecl.eraseDiffSymbolHolder(this.diffSymbolSort);
            this.newFunctionDecl.setExtraInfo(this.extraInfo);
            if (this.derivationFrom.renamedFromSymbolDecl == null && this.newFunctionDecl.isA(3) && (unit = this.newFunctionDecl.unit()) != null) {
                unit.name = this.finalName;
            }
            if (this.instruction != null) {
                this.newFunctionDecl.setInstruction(this.instruction);
            }
            while (this.newFunctionDeclSymbolTables != null) {
                ((SymbolTable)this.newFunctionDeclSymbolTables.head).addSymbolDecl(this.newFunctionDecl);
                this.newFunctionDeclSymbolTables = this.newFunctionDeclSymbolTables.tail;
            }
            this.newFunctionDecl = null;
        }
        if (!(this.newTypeDecl == null || !TypeSpec.isA(this.newTypeDecl.typeSpec, 21) || ((CompositeTypeSpec)this.newTypeDecl.typeSpec.wrappedType).isEmpty() || this.derivationFrom != null && this.newTypeDecl.typeSpec.equalsCompilDep(((TypeDecl)this.derivationFrom).typeSpec))) {
            this.newTypeDecl.symbol = this.finalName;
            if (this.finalName.startsWith("struct ")) {
                this.finalName = this.finalName.substring(7);
            }
            this.newTypeDecl.typeSpec.wrappedType.setOrAddTypeDeclName(this.finalName);
            while (this.newTypeDeclSymbolTables != null) {
                ((SymbolTable)this.newTypeDeclSymbolTables.head).addSymbolDecl(this.newTypeDecl);
                this.newTypeDeclSymbolTables = this.newTypeDeclSymbolTables.tail;
            }
        }
        if (this.newInterfaceDecl != null) {
            if (this.derivationFrom.isA(16)) {
                if (((InterfaceDecl)this.derivationFrom).usefulName) {
                    this.newInterfaceDecl.symbol = this.finalName;
                }
            } else {
                this.newInterfaceDecl.symbol = this.finalName;
            }
            if (!ILUtils.isNullOrNone(this.newInterfaceDecl.nameTree)) {
                this.newInterfaceDecl.nameTree = ILUtils.build(94, this.finalName);
            }
            this.newInterfaceDecl.eraseDiffSymbolHolder(this.diffSymbolSort);
            this.newInterfaceDecl.setExtraInfo(this.extraInfo);
            while (this.newInterfaceDeclSymbolTables != null) {
                if (this.newInterfaceDecl.contents != null || this.newInterfaceDecl.functionDecls != null) {
                    ((SymbolTable)this.newInterfaceDeclSymbolTables.head).addSymbolDecl(this.newInterfaceDecl);
                }
                this.newInterfaceDeclSymbolTables = this.newInterfaceDeclSymbolTables.tail;
            }
            TapList<Unit> interfaceUnits = this.newInterfaceDecl.interfaceUnits();
            if (interfaceUnits != null && interfaceUnits.tail == null) {
                ((Unit)interfaceUnits.head).name = this.finalName;
            }
            if (this.instruction != null) {
                this.newInterfaceDecl.setInstruction(this.instruction);
            }
            this.newInterfaceDecl = null;
        }
    }

    private boolean isASameNameCopy(boolean noCopySuffix) {
        return this.isDerived && this.diffSymbolSort == 0 && noCopySuffix;
    }

    private void addSymbolDeclAndInstr(SymbolTable vdSymbolTable, VariableDecl variableDecl) {
        if (this.instruction != null && this.instruction.tree != null && this.newFunctionDecl == null && !this.varDeclTreeAlreadyPlacedFor(vdSymbolTable)) {
            Block declBlock = null;
            if (vdSymbolTable != vdSymbolTable.getCallGraph().cRootSymbolTable()) {
                declBlock = vdSymbolTable.declarationsBlock;
            }
            if (declBlock != null) {
                Instruction cpInstruction = new Instruction(this.instruction.copyTreePlusComments());
                declBlock.addInstrDeclTlBeforeUse(cpInstruction, new TapList<SymbolDecl>(variableDecl, null), this.usageInstructions, vdSymbolTable, true);
            }
        }
        vdSymbolTable.addSymbolDecl(variableDecl);
    }

    private SymbolTable oneSymbolTableIsF77Local(TapList<SymbolTable> symbolTables) {
        SymbolTable found = null;
        while (found == null && symbolTables != null) {
            SymbolTable symbolTable = (SymbolTable)symbolTables.head;
            if (!symbolTable.isFormalParamsLevel() && symbolTable.origUnit() != null && !TapEnv.isFortran9x(symbolTable.origUnit().language())) {
                found = symbolTable;
            }
            symbolTables = symbolTables.tail;
        }
        return found;
    }

    private boolean oneNotInModule(TapList<SymbolTable> symbolTables) {
        boolean found = false;
        while (!found && symbolTables != null) {
            Unit declUnit;
            SymbolTable symbolTable = (SymbolTable)symbolTables.head;
            Unit unit = declUnit = symbolTable == null ? null : symbolTable.origUnit();
            if (declUnit != null && !declUnit.isModule() && declUnit.isFortran()) {
                found = true;
            }
            symbolTables = symbolTables.tail;
        }
        return found;
    }

    private SymbolTable oneDeclarationInLocalVars() {
        SymbolTable found = null;
        TapList<SymbolTable> symbolTables = this.newVariableDeclSymbolTables;
        while (found == null && symbolTables != null) {
            SymbolTable symbolTable = (SymbolTable)symbolTables.head;
            if (symbolTable.origUnit() != null && !symbolTable.isFormalParamsLevel()) {
                found = symbolTable;
            }
            symbolTables = symbolTables.tail;
        }
        return found;
    }

    private boolean availableSymbol(String symbol, TapList<SymbolTable> usageSymbolTables, TapList<SymbolTable> insideUnitSymbolTables) {
        SymbolDecl symbolDecl;
        boolean available = true;
        while (available && usageSymbolTables != null) {
            symbolDecl = ((SymbolTable)usageSymbolTables.head).getSymbolDecl(symbol);
            if (symbolDecl != null) {
                available = insideUnitSymbolTables != null && symbolDecl.isA(3) && ((FunctionDecl)symbolDecl).unit() != null ? this.newVariableDecl == ((FunctionDecl)symbolDecl).unit().otherReturnVar() : false;
            }
            usageSymbolTables = usageSymbolTables.tail;
        }
        while (available && insideUnitSymbolTables != null) {
            symbolDecl = ((SymbolTable)insideUnitSymbolTables.head).getTopSymbolDecl(symbol);
            if (symbolDecl != null && symbolDecl != this.newVariableDecl) {
                available = false;
            }
            insideUnitSymbolTables = insideUnitSymbolTables.tail;
        }
        if (available && this.definitionModule != null) {
            TapList<CallArrow> users = this.definitionModule.callers();
            while (available && users != null) {
                if (((CallArrow)users.head).origin.externalSymbolTable().getSymbolDecl(symbol) != null) {
                    available = false;
                }
                users = users.tail;
            }
        }
        if (available && (this.symbolUsedInUsersOf(symbol, this.newVariableDeclSymbolTables) || this.symbolUsedInUsersOf(symbol, this.newFunctionDeclSymbolTables) || this.symbolUsedInUsersOf(symbol, this.newInterfaceDeclSymbolTables) || this.symbolUsedInUsersOf(symbol, this.newTypeDeclSymbolTables))) {
            available = false;
        }
        return available;
    }

    private boolean symbolUsedInUsersOf(String symbol, TapList<SymbolTable> symbolTables) {
        boolean used = false;
        while (!used && symbolTables != null) {
            SymbolTable symbolTable = (SymbolTable)symbolTables.head;
            Unit declUnit = symbolTable.origUnit();
            if (declUnit != null && declUnit.isModule() && symbolTable.isFormalParamsLevel()) {
                TapList<CallArrow> users = declUnit.callers();
                while (!used && users != null) {
                    if (((CallArrow)users.head).origin.externalSymbolTable().getSymbolDecl(symbol) != null) {
                        used = true;
                    }
                    users = users.tail;
                }
            }
            symbolTables = symbolTables.tail;
        }
        return used;
    }

    public void isDerivationFrom(SymbolDecl baseDecl, String suffix) {
        if (baseDecl != null) {
            this.derivationFrom = baseDecl;
            this.derivationSuffix = suffix;
        }
    }

    public boolean isUsed() {
        return this.symbolUsageSymbolTables != null;
    }

    public void setExtraInfo(TapList<String> info) {
        this.extraInfo = info;
    }

    public TapList<String> extraInfo() {
        return this.extraInfo;
    }

    public void migrateToCopySymbolTable(SymbolTable copyST) {
        this.varDeclarationRootSymbolTable = null;
        this.symbolUsageSymbolTables = new TapList<SymbolTable>(copyST, null);
        this.symbolSolvingRootSymbolTable = copyST;
        this.symbolSolvingRootSymbolTable.addNewSymbolHolder(this);
    }

    public void setInstruction(Instruction instr) {
        this.instruction = instr;
    }

    public Instruction instruction() {
        return this.instruction;
    }

    public Instruction instruction(SymbolTable symbolTable) {
        Instruction result = null;
        if (symbolTable == null || symbolTable.basisSymbolTable() == null) {
            result = this.instruction;
        } else if (this.instruction != null && this.instruction.block != null && symbolTable.unit == this.instruction.block.unit()) {
            result = this.instruction;
        } else if (this.instruction != null && this.instruction.block == null) {
            result = this.instruction;
        }
        if (result == null && symbolTable != null && this.newVariableDecl != null) {
            result = this.instruction;
        }
        return result;
    }

    public void preparePrivateClause(Block srcOfUsageBlock, SymbolTable srcDeclST, boolean inFwd, boolean diff) {
        Instruction parallelRegionInstr = TapList.last(srcOfUsageBlock.parallelControls);
        if (parallelRegionInstr != null && !srcDeclST.basisSymbolTable().nestedIn(parallelRegionInstr.block.symbolTable)) {
            ILUtils.addVarIntoFuturePrivates(this, parallelRegionInstr.tree, inFwd, diff);
        }
    }

    public void prepareSumReductionClause(Block usageBlock) {
        SymbolTable declarationSymbolTable = usageBlock.symbolTable;
        TapList<Instruction> parallelControls = usageBlock.parallelControls;
        while (parallelControls != null && ((Instruction)parallelControls.head).tree.opCode() != 143) {
            parallelControls = parallelControls.tail;
        }
        if (parallelControls != null && ((Instruction)parallelControls.head).block.symbolTable.nestedIn(declarationSymbolTable)) {
            ILUtils.addVarIntoFutureSumReductions(this, ((Instruction)parallelControls.head).tree);
        }
    }

    public String toString() {
        return "NewSymbolHolder" + (this.finalName == null ? " Probable:" + this.probableName : " Final:" + this.finalName) + "{V:" + this.newVariableDecl + " F:" + this.newFunctionDecl + " T:" + this.newTypeDecl + " I:" + this.newInterfaceDecl + "}";
    }
}

