/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.CompositeTypeSpec;
import fr.inria.tapenade.representation.FieldDecl;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.MetaTypeSpec;
import fr.inria.tapenade.representation.ModifiedTypeSpec;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.ToObject;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class PrimitiveTypeSpec
extends TypeSpec {
    public String name;
    private int primitiveTypeSize = 1;
    private boolean undefinedNumeric;

    protected void setPrimitiveTypeSize(int primitiveTypeSize) {
        this.primitiveTypeSize = primitiveTypeSize;
    }

    public PrimitiveTypeSpec(String name) {
        super(7);
        if ("real".equals(name)) {
            name = "float";
        }
        this.name = name;
    }

    public static Tree buildRealConstantZero() {
        int lang = TapEnv.relatedLanguage();
        if (lang == 4 || TapEnv.get().realSize == 4) {
            return ILUtils.build(155, "0.0");
        }
        if (lang == 1 && TapEnv.get().realSize == 8) {
            return ILUtils.build(155, "0.D0");
        }
        return ILUtils.build(155, "0.0_" + TapEnv.get().realSize);
    }

    @Override
    protected void setUndefinedNumeric(boolean value) {
        this.undefinedNumeric = value;
    }

    @Override
    protected boolean isUndefinedNumeric() {
        return this.undefinedNumeric;
    }

    public boolean isInteger() {
        return !this.isUndefinedNumeric() && (this.name.equals("integer") || (TapEnv.relatedLanguageIsC() || TapEnv.relatedLanguageIsCPLUSPLUS()) && this.name.equals("boolean"));
    }

    public boolean isReal() {
        return !this.isUndefinedNumeric() && this.name.equals("float");
    }

    public boolean isRealOrComplex() {
        return !this.isUndefinedNumeric() && (this.name.equals("float") || this.name.equals("complex"));
    }

    public boolean isProbablyRealOrComplex() {
        return this.name.equals("float") || this.name.equals("complex");
    }

    public boolean isComplex() {
        return !this.isUndefinedNumeric() && this.name.equals("complex");
    }

    public boolean isAugmentedDouble() {
        return !this.isUndefinedNumeric() && this.name.equals("adouble");
    }

    protected TypeSpec addWith(WrapperTypeSpec type, SymbolTable symbolTable) {
        TypeSpec result = this;
        if (type == null || type.wrappedType == null) {
            result = this;
        } else if (PrimitiveTypeSpec.isA(type, 2)) {
            WrapperTypeSpec elemType = type.wrappedType.elementType();
            TypeSpec resultElem = this.addWith(elemType, symbolTable);
            result = new ArrayTypeSpec(new WrapperTypeSpec(resultElem), ((ArrayTypeSpec)type.wrappedType).dimensions());
        } else if (PrimitiveTypeSpec.isA(type, 6)) {
            WrapperTypeSpec elemType = ((PointerTypeSpec)type.wrappedType).destinationType;
            TypeSpec resultElem = this.addWith(elemType, symbolTable);
            result = new PointerTypeSpec(new WrapperTypeSpec(resultElem), ((PointerTypeSpec)type.wrappedType).offsetLength);
        } else if (PrimitiveTypeSpec.isA(type, 5)) {
            ModifiedTypeSpec modifiedType = (ModifiedTypeSpec)type.wrappedType;
            TypeSpec resultElem = this.addWith(modifiedType.elementType(), symbolTable);
            result = new ModifiedTypeSpec(new WrapperTypeSpec(resultElem), modifiedType);
        } else if (PrimitiveTypeSpec.isA(type, 7)) {
            PrimitiveTypeSpec primType = (PrimitiveTypeSpec)type.wrappedType;
            int leftCode = 0;
            if (this.name.equals("complex")) {
                leftCode = 5;
            } else if (this.name.equals("float")) {
                leftCode = this.undefinedNumeric ? 4 : 3;
            } else if (this.name.equals("integer") || TapEnv.relatedLanguageIsC() && this.name.equals("boolean")) {
                leftCode = this.undefinedNumeric ? 2 : 1;
            }
            int rightCode = 0;
            if (primType.name.equals("complex")) {
                rightCode = 5;
            } else if (primType.name.equals("float")) {
                rightCode = this.undefinedNumeric ? 4 : 3;
            } else if (primType.name.equals("integer") || TapEnv.relatedLanguageIsC() && primType.name.equals("boolean")) {
                int n = rightCode = this.undefinedNumeric ? 2 : 1;
            }
            if (leftCode == 3 && rightCode == 2) {
                result = new PrimitiveTypeSpec("float");
                result.primitiveTypeSize = TapEnv.get().realSize;
                result.undefinedNumeric = true;
            } else {
                result = leftCode > 0 && rightCode > leftCode ? primType.copy() : this;
            }
        }
        return result;
    }

    @Override
    protected TypeSpec cloneAsUndefinedNumeric(boolean undefined) {
        PrimitiveTypeSpec result = new PrimitiveTypeSpec(this.name);
        result.undefinedNumeric = undefined;
        return result;
    }

    @Override
    protected String baseTypeName() {
        return this.name;
    }

    @Override
    protected int computeSize() {
        switch (this.name) {
            case "integer": {
                return TapEnv.get().integerSize;
            }
            case "float": {
                return TapEnv.get().realSize;
            }
            case "complex": {
                return 2 * TapEnv.get().realSize;
            }
            case "boolean": {
                return TapEnv.get().integerSize;
            }
            case "character": {
                return TapEnv.get().charSize;
            }
        }
        return TapEnv.get().byteSize;
    }

    @Override
    public boolean isCharacter() {
        return "character".equals(this.name);
    }

    @Override
    protected boolean testComparesWith(TypeSpec other, int comparison, TypeSpec toThis, TypeSpec toOther, TapList<TapPair<TypeSpec, TypeSpec>> dejaVu) {
        if ((toOther = this.peelWrapperTo(other, toOther)) != null) {
            other = toOther.wrappedType();
        }
        if (this == other) {
            return true;
        }
        if (other == null) {
            if (PrimitiveTypeSpec.testHasInference(comparison)) {
                if (toOther != null) {
                    toOther.setWrappedType(this);
                }
                return true;
            }
            return false;
        }
        if ("character".equals(this.name)) {
            if (PrimitiveTypeSpec.testTypesLitteral(comparison)) {
                return other instanceof PrimitiveTypeSpec && "character".equals(((PrimitiveTypeSpec)other).name);
            }
            if (other.isCharacter() || other.isString()) {
                return true;
            }
        }
        Tree otherSizeModifierResolved = null;
        ToObject<Object> toOtherModifiedTypeSpec = new ToObject<Object>(null);
        if (!PrimitiveTypeSpec.testTypesLitteral(comparison)) {
            ToObject<Object> toOtherSizeModifierResolved = new ToObject<Object>(null);
            if ((toOther = this.peelSizeModifiersTo(other, toOther, toOtherSizeModifierResolved, toOtherModifiedTypeSpec, false)) != null) {
                other = toOther.wrappedType();
            }
            otherSizeModifierResolved = toOtherSizeModifierResolved.obj();
            if (other instanceof MetaTypeSpec) {
                other = ((MetaTypeSpec)other).makeLocalizedTypeSpec();
            }
        }
        if (TapEnv.relatedLanguageIsC() && PrimitiveTypeSpec.isA(other, 12) && this.isInteger()) {
            return true;
        }
        if (!(other instanceof PrimitiveTypeSpec)) {
            return false;
        }
        String otherName = ((PrimitiveTypeSpec)other).name;
        String thisName = this.name;
        if (TapEnv.relatedLanguageIsC()) {
            if ("boolean".equals(otherName)) {
                otherName = "integer";
            }
            if ("boolean".equals(thisName)) {
                thisName = "integer";
            }
        }
        boolean comparesWell = true;
        if (PrimitiveTypeSpec.testIsReceivesWithInference(comparison) && this.isUndefinedNumeric()) {
            if ("integer".equals(thisName) && "float".equals(otherName)) {
                this.name = "float";
            }
        } else if (PrimitiveTypeSpec.testIsReceives(comparison)) {
            comparesWell = thisName == null || otherName != null && (thisName.equals(otherName) || this.isRealOrComplex() && otherName.equals("integer"));
        } else {
            boolean bl = comparesWell = thisName != null && thisName.equals(otherName);
        }
        if (comparesWell) {
            int thisSizeModifierInteger;
            boolean testTypesCompilDep = PrimitiveTypeSpec.testTypesCompilDep(comparison);
            int unmodifiedSize = testTypesCompilDep ? this.size() : 0;
            int otherSizeModifierInteger = -1;
            if (otherSizeModifierResolved == null) {
                otherSizeModifierInteger = testTypesCompilDep ? unmodifiedSize : 0;
            } else if (otherSizeModifierResolved.opCode() == 101) {
                otherSizeModifierInteger = otherSizeModifierResolved.intValue();
                if (testTypesCompilDep && otherSizeModifierInteger <= -2) {
                    otherSizeModifierInteger = otherSizeModifierInteger == -2 ? 2 * unmodifiedSize : (otherSizeModifierInteger == -4 ? 4 * unmodifiedSize : unmodifiedSize);
                }
            }
            int n = thisSizeModifierInteger = testTypesCompilDep ? unmodifiedSize : 0;
            if (PrimitiveTypeSpec.testIsReceivesWithInference(comparison) && this.isUndefinedNumeric()) {
                ModifiedTypeSpec otherModifiedTypeSpec;
                if (ModifiedTypeSpec.sizeModifierIntegerSmaller(thisSizeModifierInteger, otherSizeModifierInteger) && (otherModifiedTypeSpec = (ModifiedTypeSpec)toOtherModifiedTypeSpec.obj()) != null && toThis != null) {
                    toThis.setWrappedType(new ModifiedTypeSpec(new WrapperTypeSpec(this), otherModifiedTypeSpec));
                }
            } else {
                comparesWell = ModifiedTypeSpec.compareModifiersWith(thisSizeModifierInteger, null, otherSizeModifierInteger, otherSizeModifierResolved, comparison);
            }
        }
        return comparesWell;
    }

    @Override
    protected TypeSpec weakenForInference(int comparison) {
        PrimitiveTypeSpec result = new PrimitiveTypeSpec(this.name);
        result.undefinedNumeric = true;
        return result;
    }

    @Override
    public TypeSpec copy() {
        PrimitiveTypeSpec result = new PrimitiveTypeSpec(this.name);
        result.primitiveTypeSize = this.primitiveTypeSize;
        result.undefinedNumeric = this.undefinedNumeric;
        return result;
    }

    @Override
    public TypeSpec copyStopOnComposite(Unit publishedUnit) {
        return this;
    }

    @Override
    public int precisionSize() {
        if ("float".equals(this.name)) {
            return TapEnv.get().realSize;
        }
        if ("complex".equals(this.name)) {
            return 2 * TapEnv.get().realSize;
        }
        return -1;
    }

    @Override
    public Tree buildConstantZero() {
        switch (this.name) {
            case "integer": {
                return ILUtils.build(155, "0");
            }
            case "float": {
                return PrimitiveTypeSpec.buildRealConstantZero();
            }
            case "complex": {
                return ILUtils.build(41, PrimitiveTypeSpec.buildRealConstantZero(), PrimitiveTypeSpec.buildRealConstantZero());
            }
        }
        return null;
    }

    @Override
    public Tree buildConstantOne() {
        switch (this.name) {
            case "integer": {
                return ILUtils.build(155, "1");
            }
            case "float": {
                return ILUtils.build(155, "1.0");
            }
            case "complex": {
                return ILUtils.build(155, "1.0");
            }
        }
        return null;
    }

    @Override
    protected TypeSpec localize(TapList<TapTriplet<TypeSpec, TypeSpec, Boolean>> toAlreadyCopied, ToBool containsMeta) {
        PrimitiveTypeSpec copiedResult = new PrimitiveTypeSpec(this.name);
        copiedResult.primitiveTypeSize = this.primitiveTypeSize;
        copiedResult.undefinedNumeric = this.undefinedNumeric;
        copiedResult.setOrAddTypeDeclName(this.typeDeclName());
        return copiedResult;
    }

    @Override
    public TypeSpec intToReal(TapList<TapPair<TypeSpec, TypeSpec>> dejaVu, SymbolTable symbolTable) {
        if (this.name.equals("float") || this.name.equals("complex")) {
            return this;
        }
        return symbolTable.getTypeDecl((String)"float").typeSpec.wrappedType;
    }

    @Override
    protected TypeSpec realToComplex(TapList<TapPair<TypeSpec, TypeSpec>> dejaVu, WrapperTypeSpec complexTypeSpec) {
        return complexTypeSpec.wrappedType;
    }

    @Override
    public WrapperTypeSpec differentiateTypeSpec(SymbolTable symbolTable, SymbolTable srcSymbolTable, int diffUnitSort, String fSuffix, int maxDiffSorts, boolean localDecl, boolean multiDirMode, ArrayDim multiDirDimensionMax, ArrayDim pointerMultiDirDim, String hintArrayNameInText, String hintArrayNameInIdent, Tree hintArrayNameTree, Tree nameTree) {
        if (TapEnv.associationByAddress()) {
            FieldDecl[] fields = new FieldDecl[]{new FieldDecl(TapEnv.assocAddressValueSuffix(), new WrapperTypeSpec(this)), new FieldDecl(TapEnv.assocAddressDiffSuffix(), new WrapperTypeSpec(this))};
            Tree modifiers = null;
            if (!TapEnv.relatedLanguageIsC()) {
                modifiers = ILUtils.build(128, ILUtils.build(94, "sequence"));
            }
            this.diffTypeSpec = new WrapperTypeSpec(new CompositeTypeSpec(null, fields, 8, modifiers, null));
            this.createOrGetDiffTypeDeclSymbolHolder(symbolTable, this.diffTypeSpec, fSuffix);
            return this.diffTypeSpec;
        }
        if (multiDirMode && (this.name.equals("float") || this.name.equals("complex"))) {
            ArrayDim[] dimensions = new ArrayDim[]{multiDirDimensionMax};
            return new WrapperTypeSpec(new ArrayTypeSpec(new WrapperTypeSpec(this), dimensions));
        }
        return null;
    }

    @Override
    public boolean isDifferentiated(TapList<TypeSpec> dejaVu) {
        return "float".equals(this.name) || "complex".equals(this.name);
    }

    @Override
    public Tree generateTree(SymbolTable symbolTable, TapList<SymbolDecl> dependsOn, TapList<SymbolDecl> shortNames, boolean useShortNames, TapList<TypeSpec> dejaVu) {
        Tree result = "integer".equals(this.name) ? ILUtils.build(102) : ("float".equals(this.name) ? ILUtils.build(76) : ("complex".equals(this.name) ? ILUtils.build(40) : ("boolean".equals(this.name) ? ILUtils.build(28) : ("character".equals(this.name) ? ILUtils.build(34) : ILUtils.build(94, this.name)))));
        return result;
    }

    @Override
    public String showType() {
        int language;
        int n = language = TapEnv.relatedUnit() != null ? TapEnv.relatedUnit().language() : -1;
        if ("integer".equals(this.name)) {
            return TapEnv.isFortran(language) ? "INTEGER" : "int";
        }
        if ("float".equals(this.name)) {
            return TapEnv.isFortran(language) ? "REAL" : "float";
        }
        if ("complex".equals(this.name)) {
            return TapEnv.isFortran(language) ? "COMPLEX" : "complex";
        }
        if ("boolean".equals(this.name)) {
            return TapEnv.isFortran(language) ? "LOGICAL" : "_Bool";
        }
        if ("character".equals(this.name)) {
            return TapEnv.isFortran(language) ? "CHARACTER" : "char";
        }
        return this.name;
    }

    @Override
    public void dump() throws IOException {
        TapEnv.print(this.toString());
    }

    @Override
    public String toString() {
        return (this.typeDeclName() == null ? "" : "\"" + this.typeDeclName() + "\":") + this.name.toUpperCase() + (this.undefinedNumeric ? "?" : "");
    }
}

