/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.TapIntList;
import java.io.IOException;

public final class PublicInfo {
    public ZoneInfo zone;
    public boolean coversFurther;
    private final int kind;
    private TapIntList ranks;
    private TapIntList realRanks;
    private TapIntList intRanks;
    private TapIntList ptrRanks;

    private PublicInfo(int kind) {
        this.kind = kind;
        this.ranks = null;
        this.realRanks = null;
        this.intRanks = null;
        this.ptrRanks = null;
    }

    public static PublicInfo createIdentityInfo(ZoneInfo zone) {
        PublicInfo ret = new PublicInfo(15);
        ret.zone = zone;
        return ret;
    }

    public static PublicInfo createResultInfo(int rank, ZoneInfo zone) {
        PublicInfo tmpPublicInfo = new PublicInfo(10);
        tmpPublicInfo.ranks = new TapIntList(rank, null);
        tmpPublicInfo.realRanks = null;
        tmpPublicInfo.zone = zone;
        return tmpPublicInfo;
    }

    public static PublicInfo createParameterInfo(int rank, ZoneInfo zone, Unit destination, Unit origin) {
        PublicInfo tmpPublicInfo = new PublicInfo(7);
        tmpPublicInfo.ranks = new TapIntList(rank, null);
        tmpPublicInfo.realRanks = null;
        tmpPublicInfo.zone = zone;
        if (destination != null && origin != null) {
            if (destination.isFortran() && origin.isFortran()) {
                tmpPublicInfo.zone = zone;
            } else if (destination.language() != origin.language()) {
                if (zone.accessTree == null) {
                    tmpPublicInfo = null;
                } else if (origin.isC() && destination.isFortran() && !zone.passesByValue(destination, 4)) {
                    ZoneInfo zi = zone.copy();
                    zi.accessTree = ILUtils.addPointerAccessAtBase(ILUtils.copy(zone.accessTree));
                    tmpPublicInfo.zone = zi;
                } else if (origin.isFortran() && destination.isC()) {
                    if (TypeSpec.isA(zone.type, 6) && (ILUtils.isNullOrNone(zone.accessTree) || zone.accessTree.opCode() == 94)) {
                        tmpPublicInfo = null;
                    } else {
                        ZoneInfo zi = zone.copy();
                        zi.accessTree = ILUtils.addAddressOfAtBase(ILUtils.copy(zone.accessTree));
                        tmpPublicInfo.zone = zi;
                    }
                }
            }
        }
        return tmpPublicInfo;
    }

    public static PublicInfo createDeclaredInfo(TapIntList ranks, TapIntList realRanks, TapIntList intRanks, TapIntList ptrRanks) {
        PublicInfo tmpPublicInfo = new PublicInfo(8);
        tmpPublicInfo.ranks = ranks;
        tmpPublicInfo.realRanks = realRanks;
        tmpPublicInfo.intRanks = intRanks;
        tmpPublicInfo.ptrRanks = ptrRanks;
        return tmpPublicInfo;
    }

    public static PublicInfo createSideEffectInfo(TapIntList ranks, TapIntList realRanks, TapIntList intRanks, TapIntList ptrRanks) {
        PublicInfo tmpPublicInfo = new PublicInfo(9);
        tmpPublicInfo.ranks = ranks;
        tmpPublicInfo.realRanks = realRanks;
        tmpPublicInfo.intRanks = intRanks;
        tmpPublicInfo.ptrRanks = ptrRanks;
        return tmpPublicInfo;
    }

    public static int getPublicZoneFromDeclaredZone(PublicInfo[] translator, int declaredZone) {
        int k;
        boolean found = false;
        for (k = 0; !found && k < translator.length; ++k) {
            PublicInfo transk = translator[k];
            if (transk.kind != 8 || !TapIntList.contains(translator[k].ranks, declaredZone)) continue;
            found = true;
        }
        return found ? k - 1 : -1;
    }

    public static int getPublicZoneFromSideEffectZone(PublicInfo[] translator, int sideEffectZone) {
        int k;
        boolean found = false;
        for (k = 0; !found && k < translator.length; ++k) {
            PublicInfo transk = translator[k];
            if (transk.kind != 9 || !TapIntList.contains(translator[k].ranks, sideEffectZone)) continue;
            found = true;
        }
        return found ? k - 1 : -1;
    }

    public TapIntList ranks(int whichKind) {
        switch (whichKind) {
            case 1: {
                return this.realRanks;
            }
            case 2: {
                return this.intRanks;
            }
            case 3: {
                return this.ptrRanks;
            }
        }
        return this.ranks;
    }

    public int getParamRank() {
        return this.ranks.head;
    }

    public int kind() {
        return this.kind;
    }

    public void dump() throws IOException {
        switch (this.kind) {
            case 7: {
                TapEnv.print("parameter #");
                break;
            }
            case 8: {
                TapEnv.print("declared: ");
                break;
            }
            case 9: {
                TapEnv.print("side effect: ");
                break;
            }
            case 10: {
                TapEnv.print("function result.");
                break;
            }
            default: {
                TapEnv.print("?");
            }
        }
        if (this.kind != 10) {
            if (this.ranks(0) != null) {
                TapEnv.print(this.ranks(0).toString());
                if (this.zone != null) {
                    TapEnv.print(ILUtils.toString(this.zone.accessTree));
                }
            } else {
                TapEnv.print("<_>");
            }
            if (this.kind != 7) {
                if (this.ranks(1) != null) {
                    TapEnv.print(" [" + this.ranks(1) + ']');
                } else {
                    TapEnv.print(" []");
                }
                if (this.ranks(2) != null) {
                    TapEnv.print(" [" + this.ranks(2) + ']');
                } else {
                    TapEnv.print(" []");
                }
            }
        } else if (this.zone != null) {
            TapEnv.print(ILUtils.toString(this.zone.accessTree));
        }
        if (TapEnv.relatedArrow() != null && this.kind == 7) {
            Unit destinationUnit = TapEnv.relatedArrow().destination();
            Unit curUnit = TapEnv.relatedUnit();
            assert (this.zone != null);
            TapEnv.print(" (byValue " + this.zone.passesByValue(destinationUnit, curUnit.language()) + ')');
        }
    }

    public String toString() {
        String typeStr = "PublicInfo?#";
        switch (this.kind) {
            case 7: {
                typeStr = "parameter#";
                break;
            }
            case 8: {
                typeStr = "declared:";
                break;
            }
            case 9: {
                typeStr = "side effect:";
                break;
            }
            case 10: {
                typeStr = "function result";
                break;
            }
        }
        return typeStr + this.ranks;
    }
}

