/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.analysis.ActivityPattern;
import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.FieldDecl;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.FunctionTypeSpec;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.InheritanceTree;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.InterfaceDecl;
import fr.inria.tapenade.representation.MPIcallInfo;
import fr.inria.tapenade.representation.ModifiedTypeSpec;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.UnitStorage;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public class SymbolDecl {
    public String symbol;
    public Tree nameTree;
    public TapList<Tree> defPositions;
    protected InheritanceTree inheritanceTree;
    private TapList<TapPair<ActivityPattern, NewSymbolHolder>>[] funcDiffSymbolHolders;
    private TapList<NewSymbolHolder> copySymbolHolders;
    private NewSymbolHolder[] varDiffSymbolHolders;
    protected SymbolDecl copySymbolDecl;
    public SymbolDecl renamedFromSymbolDecl;
    public int kind;
    public TapList<SymbolDecl> dependsOn;
    public boolean isATrueSymbolDecl = true;
    protected String className;
    public TapList<String> accessInfo;
    private boolean hasMainInstruction;
    private boolean hasNoneInstruction;
    private boolean hasVarDimInstruction;
    private boolean hasCommonInstruction;
    private boolean hasCommonInstructionWithArrayDeclarator;
    private boolean hasExternalInstruction;
    private boolean hasIntrinsicInstruction;
    private boolean hasSaveInstruction;
    private boolean hasOptionalInstruction;
    private boolean hasPointerInstruction;
    private boolean hasAllocatableInstruction;
    private boolean hasAllocatableInstructionWithArrayDeclarator;
    private TapList<String> hasAccessDeclModifier;
    private boolean hasInterfaceInstruction;
    private Instruction fromInclude;
    private ToBool toIsActive = new ToBool(false);
    private boolean isShared;
    private TapList<String> extraInfo;

    protected SymbolDecl() {
        this.defPositions = new TapList<Object>(null, null);
    }

    protected SymbolDecl(String name, int kind) {
        this.symbol = name;
        this.kind = kind;
        this.defPositions = new TapList<Object>(null, null);
    }

    protected SymbolDecl(Tree identTree, int kind) {
        this.symbol = identTree == null ? null : ILUtils.getIdentString(identTree);
        this.kind = kind;
        this.defPositions = new TapList<Tree>(identTree, null);
        this.nameTree = identTree;
    }

    public static TapList<String> addInfosInList(TapList<String> extraInfo, TapList<String> newInfos, SymbolDecl symbolDecl) {
        if (newInfos != null) {
            if (extraInfo == null) {
                if (TapList.containsEquals(newInfos, "pointer")) {
                    symbolDecl.turnTypeIntoPointer();
                    extraInfo = TapList.deleteString("pointer", newInfos);
                } else {
                    extraInfo = newInfos;
                }
            } else {
                String str = null;
                TapList<String> nInfos = newInfos;
                while (newInfos != null) {
                    str = (String)newInfos.head;
                    if (str != null) {
                        if (str.equals("public") || str.equals("private") || str.equals("PUBLIC") || str.equals("PRIVATE")) {
                            if (!(str.equals("public") && TapList.containsEquals(extraInfo, "private") || str.equals("private") && TapList.containsEquals(extraInfo, "public") || TapList.containsEquals(extraInfo, str))) {
                                if (!str.equals("PUBLIC") && !str.equals("PRIVATE") && (TapList.containsEquals(extraInfo, "public") || TapList.containsEquals(extraInfo, "private"))) {
                                    extraInfo = new TapList<String>(str, extraInfo);
                                } else if (str.equals("public") || str.equals("private")) {
                                    extraInfo = TapList.deleteString("PUBLIC", extraInfo);
                                    extraInfo = TapList.deleteString("PRIVATE", extraInfo);
                                    extraInfo = new TapList<String>(str, extraInfo);
                                }
                            }
                        } else if (str.equals("pointer")) {
                            symbolDecl.turnTypeIntoPointer();
                        } else if (!TapList.containsEquals(extraInfo, str)) {
                            extraInfo = new TapList<String>(str, extraInfo);
                        }
                    }
                    newInfos = newInfos.tail;
                }
                if (str == null) {
                    extraInfo = TapList.append(extraInfo, nInfos);
                }
            }
        }
        return extraInfo;
    }

    protected static SymbolDecl copy(SymbolDecl symbol2copy) {
        return symbol2copy;
    }

    public static SymbolDecl build(WrapperTypeSpec typeSpec, TapList<String> accessInfo, boolean isPointer, Tree declarator, int flag, SymbolTable symbolTable, Instruction instruction, TapList<SymbolDecl> typeUsedSymbols) {
        switch (declarator.opCode()) {
            case 94: 
            case 121: {
                SymbolDecl result;
                switch (flag) {
                    case 3: {
                        Unit functionUnit = symbolTable.language() == 1 ? Unit.makeVarFunction(ILUtils.getIdentString(declarator), symbolTable.unit) : symbolTable.buildExternalUnit(ILUtils.getIdentString(declarator), false);
                        if (TapEnv.inIncludeFile() && TapEnv.isStdCInclude(TapEnv.currentIncludeInstruction())) {
                            functionUnit.setInStdCIncludeFile();
                        }
                        functionUnit.setFunctionTypeSpec((FunctionTypeSpec)typeSpec.wrappedType);
                        result = new FunctionDecl(declarator, functionUnit);
                        break;
                    }
                    case 5: {
                        VariableDecl variableDecl = symbolTable.getVariableDecl(declarator.stringValue());
                        result = variableDecl != null ? variableDecl : new VariableDecl(declarator, typeSpec);
                        ((VariableDecl)result).setConstant();
                        break;
                    }
                    case 2: {
                        if (isPointer) {
                            typeSpec = new WrapperTypeSpec(new PointerTypeSpec(typeSpec, null));
                        }
                        result = new FieldDecl(declarator, typeSpec);
                        break;
                    }
                    default: {
                        if (isPointer) {
                            typeSpec = new WrapperTypeSpec(new PointerTypeSpec(typeSpec, null));
                        }
                        if (TypeSpec.isA(typeSpec, 2)) {
                            ArrayTypeSpec arrayTypeSpec = (ArrayTypeSpec)typeSpec.wrappedType;
                            arrayTypeSpec.preciseSizeReferences(declarator, 8);
                        }
                        result = new VariableDecl(declarator, typeSpec);
                    }
                }
                result.dependsOn = typeUsedSymbols;
                result.accessInfo = accessInfo;
                if (instruction != null && instruction.fromInclude() != null) {
                    result.setFromInclude(instruction.fromInclude());
                }
                return result;
            }
            case 10: {
                Tree[] dimTrees = declarator.down(2).children();
                Integer lower = TapEnv.relatedLanguageIsFortran() ? 1 : 0;
                Integer upper = null;
                ArrayDim[] dimensions = new ArrayDim[dimTrees.length];
                String identNext = ILUtils.getIdentString(declarator.down(1));
                for (int i = 0; i < dimTrees.length; ++i) {
                    Tree upperDimTree;
                    Tree lowerDimTree;
                    Tree dimTree = dimTrees[i];
                    if (dimTree.opCode() == 58) {
                        TapList<SymbolDecl> newSymbolDecls = symbolTable.declareAllSymbolsIn(dimTree, dimTree, null, null, 1, true, true, instruction);
                        typeUsedSymbols = TapList.prependNoDups(newSymbolDecls, typeUsedSymbols);
                        lowerDimTree = dimTree.down(1);
                        upperDimTree = dimTree.down(2);
                    } else {
                        lowerDimTree = null;
                        upperDimTree = dimTree;
                    }
                    TapList<SymbolDecl> toTypeUsedSymbols = new TapList<SymbolDecl>(null, typeUsedSymbols);
                    if (!ILUtils.isNullOrNone(lowerDimTree)) {
                        assert (lowerDimTree != null);
                        lower = symbolTable.computeIntConstant(lowerDimTree);
                        SymbolDecl.addUsedSymbolsInExpr(lowerDimTree, toTypeUsedSymbols, symbolTable, null, false, true);
                    }
                    if (!ILUtils.isNullOrNone(upperDimTree)) {
                        assert (upperDimTree != null);
                        upper = symbolTable.computeIntConstant(upperDimTree);
                        SymbolDecl.addUsedSymbolsInExpr(upperDimTree, toTypeUsedSymbols, symbolTable, null, false, true);
                    }
                    typeUsedSymbols = toTypeUsedSymbols.tail;
                    dimensions[i] = new ArrayDim(dimTree, lower, upper, identNext == null ? null : declarator.down(1), i + 1, dimTrees.length, 1);
                }
                if (TapEnv.relatedUnit() != null && TapEnv.relatedUnit().isFortran() && TypeSpec.isA(typeSpec, 2) && !typeSpec.baseTypeName().equals("character")) {
                    ArrayTypeSpec arrayTypeSpec = (ArrayTypeSpec)typeSpec.wrappedType;
                    if (arrayTypeSpec.dimensions() != null) {
                        TapEnv.fileWarning(15, declarator, "(DD22) Ignored array dimensions " + arrayTypeSpec.showDimensions() + " in declaration of " + ILUtils.toString(declarator.down(1)));
                    }
                    typeSpec = arrayTypeSpec.elementType();
                }
                if (TapEnv.relatedLanguageIsC()) {
                    return SymbolDecl.build(new WrapperTypeSpec(new PointerTypeSpec(typeSpec, dimensions.length > 0 ? dimensions[0] : null)), accessInfo, isPointer, declarator.down(1), flag, symbolTable, instruction, typeUsedSymbols);
                }
                return SymbolDecl.build(new WrapperTypeSpec(new ArrayTypeSpec(typeSpec, dimensions)), accessInfo, isPointer, declarator.down(1), flag, symbolTable, instruction, typeUsedSymbols);
            }
            case 8: {
                int dim = declarator.down(2).children().length;
                ArrayDim[] dimensions = new ArrayDim[dim];
                for (int i = 0; i < dim; ++i) {
                    dimensions[i] = new ArrayDim(ILUtils.build(58, ILUtils.build(136), ILUtils.build(136)), 1, null, null, -1, 0, 0);
                }
                return SymbolDecl.build(new WrapperTypeSpec(new ArrayTypeSpec(new WrapperTypeSpec(null), dimensions)), accessInfo, isPointer, declarator.down(1), flag, symbolTable, instruction, typeUsedSymbols);
            }
            case 178: {
                return SymbolDecl.build(new WrapperTypeSpec(null), accessInfo, isPointer, declarator.down(1), flag, symbolTable, instruction, typeUsedSymbols);
            }
            case 170: {
                TypeSpec newSizedType;
                Tree sizeModifier = declarator.down(2);
                if (typeSpec.isCharacter()) {
                    Integer length = null;
                    if (sizeModifier.opCode() == 101) {
                        length = sizeModifier.intValue();
                    }
                    String identNext = ILUtils.getIdentString(declarator.down(1));
                    ArrayDim[] dims = new ArrayDim[]{new ArrayDim(null, 1, length, identNext == null ? null : declarator.down(1), 1, 1, 1)};
                    newSizedType = new ArrayTypeSpec(typeSpec, dims);
                } else {
                    newSizedType = new ModifiedTypeSpec(typeSpec, sizeModifier, symbolTable);
                }
                return SymbolDecl.build(new WrapperTypeSpec(newSizedType), accessInfo, isPointer, declarator.down(1), flag, symbolTable, instruction, typeUsedSymbols);
            }
            case 150: {
                PointerTypeSpec pointerType = new PointerTypeSpec(typeSpec, null);
                pointerType.subAccess = accessInfo;
                return SymbolDecl.build(new WrapperTypeSpec(pointerType), null, isPointer, declarator.down(1), flag, symbolTable, instruction, typeUsedSymbols);
            }
            case 13: 
            case 149: {
                Tree initialTree = declarator.down(2);
                Integer initialValue = null;
                if (initialTree.opCode() != 136 && (typeSpec.isIntegerBase() || ILUtils.seemsInteger(initialTree))) {
                    initialValue = symbolTable.computeIntConstant(initialTree);
                }
                TapList<SymbolDecl> toTypeUsedSymbols = new TapList<SymbolDecl>(null, typeUsedSymbols);
                SymbolDecl.addUsedSymbolsInExpr(initialTree, toTypeUsedSymbols, symbolTable, null, false, true);
                SymbolDecl resultVariableDecl = SymbolDecl.build(typeSpec, accessInfo, isPointer, declarator.down(1), flag, symbolTable, instruction, toTypeUsedSymbols.tail);
                if (resultVariableDecl instanceof VariableDecl) {
                    ((VariableDecl)resultVariableDecl).setInitializationTree(declarator);
                    ((VariableDecl)resultVariableDecl).constantValue = initialValue;
                } else if (resultVariableDecl instanceof FieldDecl) {
                    ((FieldDecl)resultVariableDecl).setInitializationTree(declarator);
                }
                return resultVariableDecl;
            }
            case 25: {
                Tree bitfieldTree = declarator.down(2);
                TapList<SymbolDecl> toTypeUsedSymbols = new TapList<SymbolDecl>(null, typeUsedSymbols);
                SymbolDecl.addUsedSymbolsInExpr(bitfieldTree, toTypeUsedSymbols, symbolTable, null, false, true);
                SymbolDecl resultVariableDecl = SymbolDecl.build(typeSpec, accessInfo, isPointer, declarator.down(1), flag, symbolTable, instruction, toTypeUsedSymbols.tail);
                if (resultVariableDecl instanceof FieldDecl) {
                    ((FieldDecl)resultVariableDecl).setBitfieldTree(bitfieldTree);
                }
                return resultVariableDecl;
            }
            case 88: {
                TapList<SymbolDecl> toTypeUsedSymbols = new TapList<SymbolDecl>(null, typeUsedSymbols);
                ToBool isVariableArgList = new ToBool(false);
                TapList<WrapperTypeSpec> argList = SymbolDecl.buildTypeSpecFromArgs(symbolTable, instruction, toTypeUsedSymbols, declarator.down(2).children(), isVariableArgList);
                WrapperTypeSpec[] argsTypeSpecs = new WrapperTypeSpec[TapList.length(argList)];
                for (int i = TapList.length(argList) - 1; i >= 0; --i) {
                    argsTypeSpecs[i] = (WrapperTypeSpec)argList.head;
                    argList = argList.tail;
                }
                FunctionTypeSpec functionTypeSpec = new FunctionTypeSpec(typeSpec, argsTypeSpecs, isVariableArgList.get());
                boolean isPlainFuncDecl = declarator.down(1).opCode() == 94;
                return SymbolDecl.build(new WrapperTypeSpec(functionTypeSpec), accessInfo, isPointer, declarator.down(1), (symbolTable.unit == null || symbolTable.unit.isC()) && !isPlainFuncDecl ? flag : 3, symbolTable, instruction, toTypeUsedSymbols.tail);
            }
            case 126: {
                Tree[] modifiers = declarator.down(1).children();
                TapList<Object> toInfos = new TapList<Object>(null, null);
                for (int i = modifiers.length - 1; i >= 0; --i) {
                    if (modifiers[i].opCode() == 94) {
                        String modifierName = ILUtils.getIdentString(modifiers[i]);
                        if (modifierName.equals("const") || modifierName.equals("__const") || modifierName.equals("__const__") || modifierName.equals("restrict") || modifierName.equals("__restrict")) {
                            accessInfo = new TapList<String>(modifierName, accessInfo);
                            continue;
                        }
                        toInfos.placdl(modifierName);
                        continue;
                    }
                    TapEnv.toolWarning(-1, " ** Unexpected modifier operator: " + modifiers[i].opName() + " in " + ILUtils.toString(declarator));
                }
                SymbolDecl result = SymbolDecl.build(typeSpec, accessInfo, isPointer, declarator.down(2), flag, symbolTable, instruction, typeUsedSymbols);
                result.addExtraInfo(toInfos.tail);
                return result;
            }
            case 148: {
                return null;
            }
        }
        TapEnv.toolWarning(-1, "(SymbolDecl build) Unexpected declarator operator: " + declarator.opName());
        return null;
    }

    protected static TapList<WrapperTypeSpec> buildTypeSpecFromArgs(SymbolTable symbolTable, Instruction instruction, TapList<SymbolDecl> toTypeUsedSymbols, Tree[] argDecls, ToBool isVariableArgList) {
        TapList<WrapperTypeSpec> argList = null;
        isVariableArgList.set(false);
        Tree[] treeArray = argDecls;
        int n = treeArray.length;
        block4: for (int i = 0; i < n; ++i) {
            Tree decl;
            Tree argDecl = decl = treeArray[i];
            TapList<Object> toAccess = new TapList<Object>(null, null);
            ToBool argIsPointer = new ToBool(false);
            switch (argDecl.opCode()) {
                case 194: {
                    WrapperTypeSpec argTypeSpec = TypeSpec.build(argDecl.down(2), symbolTable, instruction, toTypeUsedSymbols, new TapList<Object>(null, null), toAccess, argIsPointer, null);
                    Tree[] declarators = argDecl.down(3).children();
                    if (declarators.length > 0) {
                        for (Tree declarator : declarators) {
                            VariableDecl argSymbolDecl = (VariableDecl)SymbolDecl.build(argTypeSpec, toAccess.tail, argIsPointer.get(), declarator, 1, symbolTable, instruction, null);
                            argList = new TapList<WrapperTypeSpec>(argSymbolDecl.type(), argList);
                        }
                        continue block4;
                    }
                    argList = new TapList<WrapperTypeSpec>(argTypeSpec, argList);
                    continue block4;
                }
                case 198: {
                    isVariableArgList.set(true);
                    continue block4;
                }
                default: {
                    WrapperTypeSpec argTypeSpec = TypeSpec.build(argDecl, symbolTable, instruction, toTypeUsedSymbols, new TapList<Object>(null, null), new TapList<Object>(null, null), argIsPointer, null);
                    if (argIsPointer.get()) {
                        argTypeSpec = new WrapperTypeSpec(new PointerTypeSpec(argTypeSpec, null));
                    }
                    argList = new TapList<WrapperTypeSpec>(argTypeSpec, argList);
                }
            }
        }
        return argList;
    }

    protected static void addUsedSymbolsInExpr(Tree expression, TapList<SymbolDecl> toUsedSymbols, SymbolTable symbolTable, TapList<String> undeclaredSymbols, boolean top, boolean strict) {
        switch (expression.opCode()) {
            case 94: {
                String symbol = expression.stringValue();
                TapList<SymbolDecl> usedSymbols = null;
                if (symbol == null) break;
                SymbolDecl symbolDecl = symbolTable.getDecl(symbol, 1, 5, top, null);
                if (symbolDecl != null) {
                    usedSymbols = new TapList<SymbolDecl>(symbolDecl, null);
                }
                if (usedSymbols == null) {
                    usedSymbols = symbolTable.getFunctionDecl(symbol, null, null, false);
                }
                if (usedSymbols == null && (symbolDecl = symbolTable.getTypeDecl(symbol)) != null) {
                    usedSymbols = new TapList<SymbolDecl>(symbolDecl, null);
                }
                if (usedSymbols == null && (symbolDecl = symbolTable.getClassDecl(symbol)) != null) {
                    usedSymbols = new TapList<SymbolDecl>(symbolDecl, null);
                }
                if (usedSymbols != null) {
                    while (usedSymbols != null) {
                        symbolDecl = (SymbolDecl)usedSymbols.head;
                        if (!TapList.contains(toUsedSymbols, symbolDecl)) {
                            toUsedSymbols.placdl(symbolDecl);
                        }
                        usedSymbols = usedSymbols.tail;
                    }
                    break;
                }
                if (undeclaredSymbols == null) break;
                undeclaredSymbols.tail = new TapList<String>(expression.stringValue(), undeclaredSymbols.tail);
                break;
            }
            case 168: {
                SymbolDecl.addUsedSymbolsInExpr(expression.down(1), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                SymbolTable scopeST = symbolTable.getPrefixedNamedScope(expression.down(1));
                if (scopeST != symbolTable) break;
                SymbolDecl.addUsedSymbolsInExpr(expression.down(2), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                break;
            }
            case 2: 
            case 5: 
            case 13: 
            case 17: 
            case 21: 
            case 23: 
            case 42: 
            case 58: 
            case 61: 
            case 67: 
            case 89: 
            case 90: 
            case 93: 
            case 113: 
            case 114: 
            case 120: 
            case 127: 
            case 131: 
            case 135: 
            case 141: 
            case 149: 
            case 152: 
            case 164: 
            case 177: 
            case 202: {
                SymbolDecl.addUsedSymbolsInExpr(expression.down(1), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                SymbolDecl.addUsedSymbolsInExpr(expression.down(2), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                break;
            }
            case 119: {
                SymbolDecl.addUsedSymbolsInExpr(expression.down(3), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                break;
            }
            case 51: 
            case 73: 
            case 96: 
            case 122: 
            case 137: 
            case 150: 
            case 151: 
            case 159: 
            case 171: 
            case 179: {
                SymbolDecl.addUsedSymbolsInExpr(expression.down(1), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                break;
            }
            case 19: 
            case 27: 
            case 28: 
            case 34: 
            case 40: 
            case 53: 
            case 76: 
            case 101: 
            case 102: 
            case 104: 
            case 116: 
            case 121: 
            case 136: 
            case 155: 
            case 172: 
            case 175: 
            case 176: 
            case 192: 
            case 199: {
                break;
            }
            case 132: {
                if (!ILUtils.isIdentOf(expression.down(1), new String[]{"len", "kind"}, false)) break;
                SymbolDecl.addUsedSymbolsInExpr(expression.down(2), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                break;
            }
            case 9: 
            case 59: 
            case 63: 
            case 68: 
            case 128: 
            case 195: {
                Tree[] sons = expression.children();
                for (int i = sons.length - 1; i >= 0; --i) {
                    SymbolDecl.addUsedSymbolsInExpr(sons[i], toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                }
                break;
            }
            case 30: {
                SymbolDecl.addUsedSymbolsInExpr(ILUtils.getArguments(expression), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                SymbolDecl.addUsedSymbolsInExpr(ILUtils.getCalledName(expression), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                break;
            }
            case 8: 
            case 12: 
            case 108: 
            case 148: {
                SymbolDecl.addUsedSymbolsInExpr(expression.down(2), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                SymbolDecl.addUsedSymbolsInExpr(expression.down(1), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                break;
            }
            case 46: {
                SymbolDecl.addUsedSymbolsInExpr(expression.down(3), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                SymbolDecl.addUsedSymbolsInExpr(expression.down(1), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                break;
            }
            case 3: 
            case 41: 
            case 66: 
            case 99: 
            case 156: 
            case 174: 
            case 190: 
            case 198: {
                break;
            }
            case 10: 
            case 31: 
            case 129: 
            case 189: {
                SymbolDecl.addUsedSymbolsInExpr(expression.down(2), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                break;
            }
            case 194: {
                Tree[] declarators;
                SymbolDecl.addUsedSymbolsInExpr(expression.down(1), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                SymbolDecl.addUsedSymbolsInExpr(expression.down(2), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                for (Tree declarator : declarators = expression.down(3).children()) {
                    if (declarator.opCode() != 13 && declarator.opCode() != 149) continue;
                    SymbolDecl.addUsedSymbolsInExpr(declarator.down(2), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                }
                break;
            }
            case 187: {
                SymbolDecl.addUsedSymbolsInExpr(expression.down(2), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                break;
            }
            case 44: {
                SymbolDecl.addUsedSymbolsInExpr(expression.down(1), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
            }
            case 1: 
            case 133: {
                Tree[] declarators;
                for (Tree declarator : declarators = expression.down(2).children()) {
                    SymbolDecl.addUsedSymbolsInExpr(declarator, toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                }
                break;
            }
            case 38: {
                Tree[] declarators;
                for (Tree declarator : declarators = expression.down(2).children()) {
                    if (declarator.opCode() == 10) {
                        if (strict) {
                            SymbolDecl.addUsedSymbolsInExpr(declarator.down(1), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                        }
                        SymbolDecl.addUsedSymbolsInExpr(declarator.down(2), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                        continue;
                    }
                    if (!strict) continue;
                    SymbolDecl.addUsedSymbolsInExpr(declarator, toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                }
                break;
            }
            case 72: 
            case 106: 
            case 197: {
                Tree[] declarators;
                for (Tree declarator : declarators = expression.children()) {
                    SymbolDecl.addUsedSymbolsInExpr(declarator, toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                }
                break;
            }
            case 4: 
            case 11: 
            case 97: {
                SymbolDecl.addUsedSymbolsInExpr(expression.down(1), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                SymbolDecl.addUsedSymbolsInExpr(expression.down(2), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                SymbolDecl.addUsedSymbolsInExpr(expression.down(3), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                break;
            }
            case 107: {
                SymbolDecl.addUsedSymbolsInExpr(expression.down(2), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                SymbolDecl.addUsedSymbolsInExpr(expression.down(3), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                break;
            }
            case 50: {
                Tree[] sons = expression.down(1).children();
                for (int i = sons.length - 1; i >= 0; --i) {
                    SymbolDecl.addUsedSymbolsInExpr(sons[i], toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                }
                break;
            }
            case 7: 
            case 52: 
            case 70: 
            case 166: {
                Tree[] sons = expression.children();
                for (int i = sons.length - 1; i >= 0; --i) {
                    SymbolDecl.addUsedSymbolsInExpr(sons[i], toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                }
                break;
            }
            case 87: {
                SymbolDecl.addUsedSymbolsInExpr(expression.down(2), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                SymbolDecl.addUsedSymbolsInExpr(expression.down(3), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                SymbolDecl.addUsedSymbolsInExpr(expression.down(5), toUsedSymbols, symbolTable, undeclaredSymbols, top, strict);
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(Get Used Symbols) Unexpected operator: " + expression.opName());
            }
        }
    }

    public boolean isDifferentiableSymbolDecl(int diffKind, boolean diffConstants) {
        return !(!diffConstants && (this.isA(5) || this.hasModifier("constant") || this.isCconst() && this.isA(1) && ((VariableDecl)this).formalArgRank == -1) || this.type() != null && this.type().wrappedType != null && !TypeSpec.isDifferentiableType(this.type().wrappedType, diffKind));
    }

    public boolean isActiveSymbolDecl() {
        boolean doActivity = TapEnv.doActivity();
        if (doActivity) {
            return this.isActive();
        }
        int diffKind = TapEnv.diffKind();
        return this.isDifferentiableSymbolDecl(diffKind, true);
    }

    protected Instruction fromInclude() {
        return this.fromInclude;
    }

    protected void setFromInclude(Instruction fromInc) {
        this.fromInclude = fromInc;
    }

    public boolean isActive() {
        return this.toIsActive.get();
    }

    public void setActive(boolean act) {
        this.toIsActive.set(act);
    }

    public void setActive() {
        this.toIsActive.set(true);
        if (this instanceof VariableDecl && this.renamedFromSymbolDecl != null && !this.renamedFromSymbolDecl.isActive()) {
            this.renamedFromSymbolDecl.setActive();
        }
    }

    public void shareActivity(SymbolDecl model) {
        this.toIsActive = model.toIsActive;
    }

    public int kind() {
        return this.kind;
    }

    public TapList<SymbolDecl> dependsOn() {
        return this.dependsOn;
    }

    public void setConstantKind() {
        this.kind = 5;
    }

    public boolean isTarget(WrapperTypeSpec modelTypeSpec) {
        return false;
    }

    public boolean isCconst() {
        return TapList.containsEquals(this.accessInfo, "const");
    }

    public boolean isShared() {
        return this.isShared;
    }

    public void setShared() {
        this.isShared = true;
    }

    public TapList<String> extraInfo() {
        return this.extraInfo;
    }

    public void setExtraInfo(TapList<String> info) {
        this.extraInfo = info;
    }

    public void addExtraInfo(TapList<String> info) {
        this.extraInfo = SymbolDecl.addInfosInList(this.extraInfo, info, this);
    }

    public void setSystemPredefined() {
        this.addExtraInfo(new TapList<String>("tapenade_system_predefined", null));
    }

    public boolean isSystemPredefined() {
        return TapList.containsEquals(this.extraInfo, "tapenade_system_predefined");
    }

    public boolean isOptional() {
        return TapList.containsEquals(this.extraInfo, "optional");
    }

    public boolean isExternal() {
        return TapList.containsEquals(this.extraInfo, "external");
    }

    public boolean isExtern() {
        return TapList.containsEquals(this.extraInfo, "extern");
    }

    public boolean isPrivate() {
        return TapList.containsEquals(this.extraInfo, "private");
    }

    public boolean isPublic() {
        return TapList.containsEquals(this.extraInfo, "public");
    }

    public boolean isProtected() {
        return TapList.containsEquals(this.extraInfo, "protected");
    }

    public boolean hasModifier(String modifier) {
        return TapList.containsEquals(this.extraInfo, modifier);
    }

    public void turnTypeIntoPointer() {
    }

    public void collectUsedTrees(TapList<Tree> toUsedTrees, TapList<TypeSpec> toDejaVu) {
    }

    protected SymbolDecl copy(TapList<TapPair<SymbolTable, SymbolTable>> associationsST, UnitStorage<Unit> associationsUnits) {
        SymbolDecl copyDecl;
        if (this.copySymbolDecl != null) {
            return this.copySymbolDecl;
        }
        switch (this.kind) {
            case 1: {
                SymbolDecl copy = new VariableDecl();
                SymbolDecl model = (VariableDecl)this;
                ((VariableDecl)copy).setType(((VariableDecl)model).type());
                ((VariableDecl)copy).setInitializationTree(((VariableDecl)model).getInitializationTree());
                ((VariableDecl)copy).constantValue = ((VariableDecl)model).constantValue;
                ((VariableDecl)copy).formalArgRank = ((VariableDecl)model).formalArgRank;
                ((VariableDecl)copy).adoptZones((VariableDecl)model);
                ((VariableDecl)copy).isReturnVarFromFunction = ((VariableDecl)model).isReturnVarFromFunction;
                ((VariableDecl)copy).isATrueSymbolDecl = ((VariableDecl)model).isATrueSymbolDecl;
                copy.setInstruction(model);
                copy.setNullInstructionIfNone();
                if (this.fromInclude != null) {
                    Instruction copyFromInclude = Instruction.fromIncludeCopy(this.fromInclude, true);
                    copy.setFromInclude(this.fromInclude);
                }
                copyDecl = copy;
                copyDecl.shareActivity(this);
                break;
            }
            case 3: {
                Unit origUnit;
                SymbolDecl copy = new FunctionDecl();
                SymbolDecl model = (FunctionDecl)this;
                Unit copiedUnit = origUnit = ((FunctionDecl)model).unit();
                if (associationsUnits != null && (copiedUnit = associationsUnits.retrieve(origUnit)) == null) {
                    copiedUnit = origUnit;
                }
                ((FunctionDecl)copy).setUnit(copiedUnit);
                ((FunctionDecl)copy).formalArgRank = ((FunctionDecl)model).formalArgRank;
                ((FunctionDecl)copy).setZones(((FunctionDecl)model).zones());
                ((FunctionDecl)copy).isATrueSymbolDecl = ((FunctionDecl)model).isATrueSymbolDecl;
                copy.setInstruction(model);
                copy.setNullInstructionIfNone();
                ((FunctionDecl)copy).definitionSymbolTable = associationsST != null ? (SymbolTable)TapList.cassq(((FunctionDecl)model).definitionSymbolTable, associationsST) : ((FunctionDecl)model).definitionSymbolTable;
                copyDecl = copy;
                copyDecl.shareActivity(this);
                break;
            }
            case 16: {
                TapList<Object> hdInterfaceUnits;
                TapList<Object> hdFunctionDecls;
                Unit copiedUnit;
                Unit origUnit;
                InterfaceDecl model = (InterfaceDecl)this;
                InterfaceDecl copy = new InterfaceDecl();
                copy.nameTree = model.nameTree;
                copy.symbol = model.symbol;
                copy.usefulName = model.usefulName;
                copy.contents = model.contents;
                copy.containerUnit = model.containerUnit;
                TapList<FunctionDecl> inFunctionDecls = model.functionDecls;
                TapList<Object> tlFunctionDecls = hdFunctionDecls = new TapList<Object>(null, null);
                while (inFunctionDecls != null) {
                    copiedUnit = origUnit = ((FunctionDecl)inFunctionDecls.head).unit();
                    if (associationsUnits != null && (copiedUnit = associationsUnits.retrieve(origUnit)) == null) {
                        copiedUnit = origUnit;
                    }
                    tlFunctionDecls = tlFunctionDecls.placdl(new FunctionDecl(ILUtils.build(94, origUnit.name), copiedUnit));
                    inFunctionDecls = inFunctionDecls.tail;
                }
                copy.functionDecls = hdFunctionDecls.tail;
                TapList<Unit> inInterfaceUnits = model.interfaceUnits();
                TapList<Object> tlInterfaceUnits = hdInterfaceUnits = new TapList<Object>(null, null);
                while (inInterfaceUnits != null) {
                    copiedUnit = origUnit = (Unit)inInterfaceUnits.head;
                    if (associationsUnits != null && (copiedUnit = associationsUnits.retrieve(origUnit)) == null) {
                        copiedUnit = origUnit;
                    }
                    if (copiedUnit.rank() != -1) {
                        tlInterfaceUnits = tlInterfaceUnits.placdl(copiedUnit);
                    }
                    inInterfaceUnits = inInterfaceUnits.tail;
                }
                copy.setInterfaceUnits(hdInterfaceUnits.tail);
                copy.functionNames = TapList.append(model.functionNames, null);
                copy.definitionSymbolTable = associationsST != null ? (SymbolTable)TapList.cassq(model.definitionSymbolTable, associationsST) : model.definitionSymbolTable;
                copy.setInstruction(model);
                copy.setNullInstructionIfNone();
                copyDecl = copy;
                copyDecl.shareActivity(this);
                break;
            }
            default: {
                copyDecl = this;
            }
        }
        if (copyDecl != this) {
            copyDecl.symbol = this.symbol;
            copyDecl.kind = this.kind;
            copyDecl.accessInfo = this.accessInfo;
            copyDecl.isShared = this.isShared;
            if (this.extraInfo != null) {
                TapList<Object> copyExtraInfo;
                TapList<String> origExtraInfo = this.extraInfo;
                TapList<Object> tlCopyExtraInfo = copyExtraInfo = new TapList<Object>(null, null);
                while (origExtraInfo != null) {
                    String head = (String)origExtraInfo.head;
                    tlCopyExtraInfo = tlCopyExtraInfo.placdl(head);
                    origExtraInfo = origExtraInfo.tail;
                }
                copyDecl.extraInfo = copyExtraInfo.tail;
            }
            this.copySymbolDecl = copyDecl;
        }
        return copyDecl;
    }

    protected void copyLinksIntoCopy(SymbolDecl copyDecl, TapList<TapPair<SymbolTable, SymbolTable>> associationsST) {
        if (copyDecl != this) {
            if (associationsST != null) {
                TapList<Object> newDependsOn;
                TapList<SymbolDecl> oldDependsOn = this.dependsOn;
                TapList<Object> tlNewDependsOn = newDependsOn = new TapList<Object>(null, null);
                while (oldDependsOn != null) {
                    SymbolDecl newDepend = (SymbolDecl)oldDependsOn.head;
                    if (newDepend != null && newDepend.copySymbolDecl != null) {
                        newDepend = newDepend.copySymbolDecl;
                    }
                    tlNewDependsOn = tlNewDependsOn.placdl(newDepend);
                    oldDependsOn = oldDependsOn.tail;
                }
                copyDecl.dependsOn = newDependsOn.tail;
                if (this.renamedFromSymbolDecl != null) {
                    copyDecl.renamedFromSymbolDecl = this.renamedFromSymbolDecl.copySymbolDecl;
                }
            } else if (this.renamedFromSymbolDecl != null) {
                copyDecl.renamedFromSymbolDecl = this.renamedFromSymbolDecl;
            }
        }
    }

    public TapList zones() {
        return null;
    }

    protected void recomputeDependsOn(SymbolTable symbolTable) {
    }

    public boolean isA(int testKind) {
        return testKind == 0 || testKind == this.kind;
    }

    protected boolean hasPrivateModifier(TapList<SymbolDecl> addSymbolDecls) {
        boolean result = false;
        SymbolDecl addSymbolDecl = TapList.findNamedSymbolDecl(addSymbolDecls, this.symbol);
        if (addSymbolDecl != null) {
            result = addSymbolDecl.isPrivate();
        }
        return result;
    }

    protected boolean hasPublicModifier(TapList<SymbolDecl> addSymbolDecls) {
        boolean result = false;
        SymbolDecl addSymbolDecl = TapList.findNamedSymbolDecl(addSymbolDecls, this.symbol);
        if (addSymbolDecl != null) {
            result = addSymbolDecl.isPublic();
        }
        return result;
    }

    protected boolean hasProtectedModifier(TapList<SymbolDecl> addSymbolDecls) {
        boolean result = false;
        SymbolDecl addSymbolDecl = TapList.findNamedSymbolDecl(addSymbolDecls, this.symbol);
        if (addSymbolDecl != null) {
            result = addSymbolDecl.isProtected();
        }
        return result;
    }

    public void setDiffSymbolHolder(int diffSort, ActivityPattern activityPattern, NewSymbolHolder nSH, int maxDiffSorts) {
        if (this.isA(3) && !((FunctionDecl)this).isModule()) {
            if (this.funcDiffSymbolHolders == null) {
                this.funcDiffSymbolHolders = new TapList[maxDiffSorts - 1];
            }
            if (diffSort == 0) {
                if (this.copySymbolHolders == null) {
                    this.copySymbolHolders = new TapList<NewSymbolHolder>(nSH, null);
                }
            } else {
                TapList newSymbolHolders = this.funcDiffSymbolHolders[diffSort - 1];
                TapPair<ActivityPattern, Object> forThisPattern = TapList.assq(activityPattern, newSymbolHolders);
                if (forThisPattern == null) {
                    forThisPattern = new TapPair<ActivityPattern, Object>(activityPattern, null);
                    this.funcDiffSymbolHolders[diffSort - 1] = new TapList(forThisPattern, newSymbolHolders);
                }
                forThisPattern.second = nSH;
            }
        } else {
            if (this.varDiffSymbolHolders == null) {
                this.varDiffSymbolHolders = new NewSymbolHolder[maxDiffSorts];
            }
            this.varDiffSymbolHolders[diffSort] = nSH;
        }
    }

    public boolean hasDiffSymbolHolders() {
        return this.funcDiffSymbolHolders != null || this.copySymbolHolders != null || this.varDiffSymbolHolders != null;
    }

    public NewSymbolHolder getDiffSymbolHolder(int diffSort, ActivityPattern activityPattern) {
        if (this.isA(3) && !((FunctionDecl)this).isModule()) {
            if (diffSort == 0) {
                return this.copySymbolHolders == null ? null : (NewSymbolHolder)this.copySymbolHolders.head;
            }
            if (this.funcDiffSymbolHolders == null || this.funcDiffSymbolHolders.length < diffSort) {
                return null;
            }
            TapList newSymbolHolders = this.funcDiffSymbolHolders[diffSort - 1];
            if (activityPattern == null) {
                return newSymbolHolders == null ? null : (NewSymbolHolder)((TapPair)newSymbolHolders.head).second;
            }
            return (NewSymbolHolder)TapList.cassq(activityPattern, newSymbolHolders);
        }
        if (this.varDiffSymbolHolders != null) {
            return this.varDiffSymbolHolders[diffSort];
        }
        return null;
    }

    protected void replaceDiffSymbolHolder(NewSymbolHolder oldNSH, NewSymbolHolder newNSH) {
        if (this.isA(3) && !((FunctionDecl)this).isModule()) {
            if (this.funcDiffSymbolHolders != null) {
                for (int i = this.funcDiffSymbolHolders.length - 1; i >= 0; --i) {
                    TapList<TapPair<ActivityPattern, NewSymbolHolder>> newSymbolHolders = this.funcDiffSymbolHolders[i];
                    while (newSymbolHolders != null) {
                        TapPair activityToHolder = (TapPair)newSymbolHolders.head;
                        if (activityToHolder.second == oldNSH) {
                            activityToHolder.second = newNSH;
                        }
                        newSymbolHolders = newSymbolHolders.tail;
                    }
                }
            }
            if (this.copySymbolHolders != null && this.copySymbolHolders.head == oldNSH) {
                this.copySymbolHolders.head = newNSH;
            }
        } else if (this.varDiffSymbolHolders != null) {
            for (int i = this.varDiffSymbolHolders.length - 1; i >= 0; --i) {
                if (this.varDiffSymbolHolders[i] != oldNSH) continue;
                this.varDiffSymbolHolders[i] = newNSH;
            }
        }
    }

    protected void eraseDiffSymbolHolder(int diffSort) {
        if (this.isA(3) && !((FunctionDecl)this).isModule()) {
            if (this.funcDiffSymbolHolders != null && this.funcDiffSymbolHolders.length > diffSort - 1) {
                TapList<TapPair<ActivityPattern, NewSymbolHolder>> newSymbolHolders = this.funcDiffSymbolHolders[diffSort - 1];
                while (newSymbolHolders != null) {
                    TapPair toThisNSH = (TapPair)newSymbolHolders.head;
                    newSymbolHolders = newSymbolHolders.tail;
                }
            }
            if (diffSort == 0 && this.copySymbolHolders != null) {
                this.copySymbolHolders = null;
            }
        } else if (this.varDiffSymbolHolders != null) {
            this.varDiffSymbolHolders[diffSort] = null;
        }
    }

    public void setInstruction(Instruction instr) {
        if (instr != null && instr.tree != null) {
            Tree instrTree = instr.tree;
            if (instrTree.opCode() == 1 && instrTree.down(2).opCode() == 187) {
                instrTree = instrTree.down(2);
            }
            block0 : switch (instrTree.opCode()) {
                case 187: 
                case 194: {
                    this.hasMainInstruction = true;
                    break;
                }
                case 136: {
                    this.hasMainInstruction = true;
                    this.hasNoneInstruction = true;
                    break;
                }
                case 197: {
                    this.hasVarDimInstruction = true;
                    break;
                }
                case 38: {
                    this.hasCommonInstruction = true;
                    this.hasCommonInstructionWithArrayDeclarator = ILUtils.containsArrayDeclarator(this, instrTree) || this.hasCommonInstructionWithArrayDeclarator;
                    break;
                }
                case 72: {
                    this.hasExternalInstruction = true;
                    break;
                }
                case 106: {
                    this.hasIntrinsicInstruction = true;
                    break;
                }
                case 166: {
                    this.hasSaveInstruction = true;
                    break;
                }
                case 104: {
                    this.hasMainInstruction = true;
                    this.hasInterfaceInstruction = true;
                    break;
                }
                case 1: {
                    if (instrTree.down(1).opCode() != 94) break;
                    switch (instrTree.down(1).stringValue()) {
                        case "optional": {
                            this.hasOptionalInstruction = true;
                            break block0;
                        }
                        case "allocatable": 
                        case "target": {
                            this.hasAllocatableInstruction = true;
                            this.hasAllocatableInstructionWithArrayDeclarator = ILUtils.containsArrayDeclarator(this, instrTree) || this.hasAllocatableInstructionWithArrayDeclarator;
                            break block0;
                        }
                        case "pointer": {
                            this.hasPointerInstruction = true;
                            break block0;
                        }
                    }
                    this.hasAccessDeclModifier = new TapList<String>(instrTree.down(1).stringValue(), this.hasAccessDeclModifier);
                    break;
                }
            }
        }
    }

    public void setInstruction(SymbolDecl model) {
        this.hasMainInstruction = model.hasMainInstruction || this.hasMainInstruction;
        this.hasNoneInstruction = model.hasNoneInstruction || this.hasNoneInstruction;
        this.hasVarDimInstruction = model.hasVarDimInstruction || this.hasVarDimInstruction;
        this.hasCommonInstruction = model.hasCommonInstruction || this.hasCommonInstruction;
        this.hasCommonInstructionWithArrayDeclarator = model.hasCommonInstructionWithArrayDeclarator || this.hasCommonInstructionWithArrayDeclarator;
        this.hasExternalInstruction = model.hasExternalInstruction || this.hasExternalInstruction;
        this.hasIntrinsicInstruction = model.hasIntrinsicInstruction || this.hasIntrinsicInstruction;
        this.hasSaveInstruction = model.hasSaveInstruction || this.hasSaveInstruction;
        this.hasOptionalInstruction = model.hasOptionalInstruction || this.hasOptionalInstruction;
        this.hasPointerInstruction = model.hasPointerInstruction || this.hasPointerInstruction;
        this.hasAllocatableInstruction = model.hasAllocatableInstruction || this.hasAllocatableInstruction;
        this.hasAllocatableInstructionWithArrayDeclarator = model.hasAllocatableInstructionWithArrayDeclarator || this.hasAllocatableInstructionWithArrayDeclarator;
        this.hasAccessDeclModifier = model.hasAccessDeclModifier;
        this.hasInterfaceInstruction = model.hasInterfaceInstruction;
    }

    public void setMainDeclInstr(boolean val) {
        this.hasMainInstruction = val;
    }

    public void setExternalInstr(boolean val) {
        this.hasExternalInstruction = val;
    }

    public void setInterfaceInstr(boolean val) {
        this.hasInterfaceInstruction = val;
        this.hasMainInstruction = val;
    }

    public void setCommonInstr(boolean val) {
        this.hasCommonInstruction = val;
    }

    public void setCommonWithArrayDeclaratorInstr(boolean val) {
        this.hasCommonInstructionWithArrayDeclarator = val;
    }

    protected void setNullInstructionIfNone() {
        if (this.hasNoneInstruction) {
            this.hasMainInstruction = false;
            this.hasNoneInstruction = false;
        }
    }

    public void setNullInstruction() {
        this.hasMainInstruction = false;
        this.hasNoneInstruction = false;
        this.hasVarDimInstruction = false;
        this.hasCommonInstruction = false;
        this.hasCommonInstructionWithArrayDeclarator = false;
        this.hasExternalInstruction = false;
        this.hasIntrinsicInstruction = false;
        this.hasSaveInstruction = false;
        this.hasOptionalInstruction = false;
        this.hasPointerInstruction = false;
        this.hasAllocatableInstruction = false;
        this.hasAllocatableInstructionWithArrayDeclarator = false;
        this.hasAccessDeclModifier = null;
        this.hasInterfaceInstruction = false;
    }

    public void setNoneInstruction() {
        this.hasMainInstruction = true;
        this.hasNoneInstruction = true;
    }

    public boolean hasMainInstruction() {
        return this.hasMainInstruction || this.hasNoneInstruction || this.hasInterfaceInstruction;
    }

    public boolean hasOtherInstruction() {
        return this.hasVarDimInstruction || this.hasCommonInstruction || this.hasCommonInstructionWithArrayDeclarator || this.hasExternalInstruction || this.hasIntrinsicInstruction || this.hasSaveInstruction || this.hasOptionalInstruction || this.hasPointerInstruction || this.hasAllocatableInstruction || this.hasAllocatableInstructionWithArrayDeclarator || this.hasAccessDeclModifier != null;
    }

    public boolean hasOtherCombinableDeclarationPart() {
        return this.hasExternalInstruction || this.hasIntrinsicInstruction || this.hasOptionalInstruction || this.hasPointerInstruction || this.hasAllocatableInstruction || this.hasAccessDeclModifier != null;
    }

    public boolean hasInterfaceInstruction() {
        return this.hasInterfaceInstruction;
    }

    public boolean hasInstructionWithRootOperator(int operator, String value) {
        switch (operator) {
            case 187: 
            case 194: {
                return this.hasMainInstruction;
            }
            case 136: {
                return this.hasNoneInstruction;
            }
            case 197: {
                return this.hasVarDimInstruction;
            }
            case 38: {
                return this.hasCommonInstruction;
            }
            case 72: {
                return this.hasExternalInstruction;
            }
            case 106: {
                return this.hasIntrinsicInstruction;
            }
            case 166: {
                return this.hasSaveInstruction;
            }
            case 104: {
                return this.hasInterfaceInstruction;
            }
            case 1: {
                if (value != null) {
                    switch (value) {
                        case "optional": {
                            return this.hasOptionalInstruction;
                        }
                        case "allocatable": 
                        case "target": {
                            return this.hasAllocatableInstruction;
                        }
                        case "pointer": {
                            return this.hasPointerInstruction;
                        }
                    }
                    return TapList.containsEquals(this.hasAccessDeclModifier, value);
                }
                return false;
            }
        }
        return false;
    }

    public boolean hasInstructionWithRootOperatorAndArrayDeclarator(int operator) {
        if (operator == 38) {
            return this.hasCommonInstructionWithArrayDeclarator;
        }
        if (operator == 1) {
            return this.hasAllocatableInstructionWithArrayDeclarator;
        }
        return false;
    }

    public boolean isVarDeclared(TapList<Instruction> instructions) {
        boolean result = false;
        TapList<Instruction> insts = instructions;
        while (!result && insts != null) {
            Instruction inst = (Instruction)insts.head;
            if (inst.tree != null && inst.tree.opCode() == 194) {
                Tree declarators = inst.tree.down(3);
                int i = declarators.length();
                for (int k = 1; !result && k <= i; ++k) {
                    String baseName = ILUtils.baseName(declarators.down(k));
                    if (baseName == null) continue;
                    result = ILUtils.baseName(declarators.down(k)).equals(this.symbol);
                }
            }
            insts = insts.tail;
        }
        return result;
    }

    public boolean isExternalDeclared(TapList<Instruction> instructions) {
        if (MPIcallInfo.isMessagePassingFunction(this.symbol, -1)) {
            return true;
        }
        boolean result = false;
        while (instructions != null && !result) {
            result = this.isExternalDeclared((Instruction)instructions.head);
            instructions = instructions.tail;
        }
        return result;
    }

    public boolean isExternalDeclared(Instruction instruction) {
        if (instruction == null || instruction.tree == null) {
            return this.hasExternalInstruction;
        }
        Tree tree = instruction.tree;
        boolean result = false;
        if (tree.opCode() == 72) {
            result = ILUtils.contains(tree, this.symbol, false);
        } else if (tree.opCode() == 194 && tree.down(2).opCode() == 127) {
            Tree modifiers = tree.down(2).down(1);
            result = !(modifiers.opCode() != 128 || !ILUtils.contains(modifiers, "external", false) && !ILUtils.contains(modifiers, "extern", true) || !ILUtils.contains(tree.down(3), this.symbol, true) && !ILUtils.containsFunctionDeclarator(tree.down(3), this.symbol));
        }
        return result;
    }

    public boolean isIntrinsicDeclared(TapList<Instruction> instructions) {
        boolean result = false;
        while (instructions != null && !result) {
            result = this.isIntrinsicDeclared((Instruction)instructions.head);
            instructions = instructions.tail;
        }
        return result;
    }

    public boolean isIntrinsicDeclared(Instruction instruction) {
        if (instruction == null || instruction.tree == null) {
            return this.hasIntrinsicInstruction;
        }
        Tree tree = instruction.tree;
        boolean result = false;
        if (tree.opCode() == 106) {
            result = ILUtils.contains(tree, this.symbol, true);
        } else if (tree.opCode() == 194 && tree.down(2).opCode() == 127) {
            Tree modifiers = tree.down(2).down(1);
            result = modifiers.opCode() == 128 && ILUtils.contains(modifiers, "intrinsic", false) && ILUtils.contains(tree.down(3), this.symbol, true);
        }
        return result;
    }

    public boolean isContainedFunctionDeclDeclared(Unit inUnit) {
        boolean result;
        boolean bl = result = this.kind == 3;
        if (result) {
            Unit unit = ((FunctionDecl)this).unit();
            result = unit.upperLevelUnit() == inUnit;
        }
        return result;
    }

    public WrapperTypeSpec type() {
        return null;
    }

    public void dump(int indent) throws IOException {
        TapEnv.print(this.toString());
    }

    public String toString() {
        String kindString;
        switch (this.kind) {
            case 0: {
                kindString = "SYMBOL";
                break;
            }
            case 1: {
                kindString = "VARIABLE";
                break;
            }
            case 2: {
                kindString = "FIELD";
                break;
            }
            case 3: {
                Unit unit = ((FunctionDecl)this).unit();
                if (unit != null && unit.isModule()) {
                    kindString = "MODULE[" + unit + "]";
                    break;
                }
                kindString = "FUNCTION[" + unit + "]";
                break;
            }
            case 4: {
                kindString = "TYPE";
                break;
            }
            case 5: {
                kindString = "CONSTANT";
                break;
            }
            case 6: {
                kindString = "FUNCNAME";
                break;
            }
            case 16: {
                kindString = "INTERFACE";
                break;
            }
            case 18: {
                kindString = "CLASS";
                break;
            }
            case 20: {
                kindString = "NAMESPACE";
                break;
            }
            default: {
                kindString = "??SymbolDecl";
            }
        }
        return this.symbol + "-->" + kindString;
    }
}

