/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.analysis.ActivityPattern;
import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.analysis.InOutAnalyzer;
import fr.inria.tapenade.analysis.PointerAnalyzer;
import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.BasicBlock;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.CStuff;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.ClassDecl;
import fr.inria.tapenade.representation.ClassTypeSpec;
import fr.inria.tapenade.representation.CompositeTypeSpec;
import fr.inria.tapenade.representation.FieldDecl;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.FunctionTypeSpec;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.InheritanceTree;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.InterfaceDecl;
import fr.inria.tapenade.representation.LabelTypeSpec;
import fr.inria.tapenade.representation.MPIcallInfo;
import fr.inria.tapenade.representation.ModifiedTypeSpec;
import fr.inria.tapenade.representation.NameSpaceDecl;
import fr.inria.tapenade.representation.NamedTypeSpec;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.PrimitiveTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeDecl;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.UnitStorage;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.VoidTypeSpec;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneAllocator;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolMatrix;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.Int2ZoneInfo;
import fr.inria.tapenade.utils.Operator;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.ToObject;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class SymbolTable {
    private static final int NUM_BUCKETS = 100;
    private int rank = -1;
    private int language = -1;
    public WrapperTypeSpec[] implicits;
    public TapList<Tree> saveList;
    public TapList<Tree> nameListList;
    public Unit unit;
    public String containerFileName;
    public TapList<Unit> privateForwardDeclarations;
    public TapList<Unit> nonPrivForwardDeclarations;
    public Unit usedModule;
    public Unit inheritedClass;
    public TapList<NewSymbolHolder> newSymbolHolders = new TapList<Object>(null, null);
    public TapList<NewSymbolHolder> nestedIntIndexSymbolHolders;
    public TapList<TypeSpec> associationByAddressTypes;
    public Block declarationsBlock;
    public String nameSpaceName;
    protected TapList<Tree> dataList;
    private TapList<SymbolDecl> addSymbolDecls;
    private boolean caseDependent;
    private final TapList<SymbolDecl>[] buckets = new TapList[100];
    private String shortName = "";
    private SymbolTable basisSymbolTable;
    private CallGraph rootCallGraph;
    private boolean isTranslationUnit;
    private int[] freeDeclaredZone = new int[]{0, 0, 0, 0};
    private int[] firstDeclaredZone = new int[]{0, 0, 0, 0};
    private ZoneInfo[][] declaredZoneInfos = new ZoneInfo[][]{null, null, null, null};
    private TapList<Int2ZoneInfo>[] additionalDuplicatedDeclaredZoneInfos = new TapList[4];
    private boolean isFormalParams;
    private Tree assignDestination;
    private CompositeTypeSpec inCompositeTypeSpec;
    private TapList<TapPair<ActivityPattern, BoolVector>> requiredDiffVarsList;

    public int rank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public int language() {
        return this.language;
    }

    public void setLanguage(int language) {
        this.language = language;
    }

    public final int zonesNb(int zoneKind) {
        return this.unit.sideEffectZonesNb(zoneKind) + this.declaredZonesNb(zoneKind);
    }

    public SymbolTable(SymbolTable basisSymbolTable) {
        this.basisSymbolTable = basisSymbolTable;
        if (basisSymbolTable != null) {
            this.language = basisSymbolTable.language;
            this.caseDependent = basisSymbolTable.caseDependent;
            TapEnv.setRelatedLanguage(basisSymbolTable);
        }
        for (int i = 0; i < 100; ++i) {
            this.buckets[i] = new TapList<Object>(null, null);
        }
        this.implicits = new WrapperTypeSpec[26];
        if (basisSymbolTable != null && basisSymbolTable.implicits != null) {
            System.arraycopy(basisSymbolTable.implicits, 0, this.implicits, 0, 26);
        }
    }

    private static int hashKey(String key) {
        int code = key.hashCode() % 100;
        if (code < 0) {
            code += 100;
        }
        return code;
    }

    private static boolean checkScalarBoolean(WrapperTypeSpec type) {
        return type == null || !TypeSpec.isA(type, 2) && type.checkBoolean();
    }

    private static boolean checkScalarArrayBoolean(WrapperTypeSpec type) {
        return type == null || !TypeSpec.isA(type, 2) && type.checkBoolean() || TypeSpec.isA(type, 2) && type.wrappedType.elementType().checkBoolean();
    }

    private static boolean checkScalarNumericInt(WrapperTypeSpec type) {
        return type == null || !TypeSpec.isA(type, 2) && type.checkNumericInt();
    }

    public static Tree offsetRef(Tree refToStart, WrapperTypeSpec type, int offset) {
        if (type == null || type.wrappedType == null) {
            return refToStart;
        }
        TypeSpec actualType = type.wrappedType;
        if (TypeSpec.isA(actualType, 2)) {
            ArrayTypeSpec arrayTypeSpec = (ArrayTypeSpec)actualType;
            ArrayDim[] dimensions = arrayTypeSpec.dimensions();
            int elementSize = arrayTypeSpec.elementType().size();
            int indexInArray = offset / elementSize;
            int[] aboveSizes = new int[dimensions.length];
            aboveSizes[dimensions.length - 1] = 1;
            for (int i = dimensions.length - 2; i >= 0; --i) {
                if (dimensions[i + 1] == null) {
                    return refToStart;
                }
                int dimSize = dimensions[i + 1].size();
                aboveSizes[i] = dimSize <= 0 ? 1 : aboveSizes[i + 1] * dimSize;
            }
            Tree[] indexes = new Tree[dimensions.length];
            for (int i = 0; i < dimensions.length; ++i) {
                int dimLower = dimensions[i].lower == null ? 1 : dimensions[i].lower;
                indexes[i] = ILUtils.build(101, indexInArray / aboveSizes[i] + dimLower);
                indexInArray %= aboveSizes[i];
            }
            Tree newTree = ILUtils.build(8, refToStart, ILUtils.build(70, indexes));
            return SymbolTable.offsetRef(newTree, arrayTypeSpec.elementType(), offset % elementSize);
        }
        if (TypeSpec.isA(actualType, 5)) {
            return SymbolTable.offsetRef(refToStart, actualType.elementType(), offset);
        }
        if (TypeSpec.isA(actualType, 21)) {
            CompositeTypeSpec recordTypeSpec = (CompositeTypeSpec)actualType;
            int i = 0;
            String fieldName = null;
            while (i < recordTypeSpec.fields.length && fieldName == null) {
                if (offset < recordTypeSpec.fields[i].type().size()) {
                    fieldName = recordTypeSpec.fields[i].symbol;
                    continue;
                }
                offset -= recordTypeSpec.fields[i].type().size();
            }
            if (fieldName == null) {
                TapEnv.toolWarning(-1, "(Rebuild offset expression) Offset exceeds record size");
                fieldName = "??";
                i = 0;
            }
            return SymbolTable.offsetRef(ILUtils.build(73, refToStart, ILUtils.build(94, fieldName)), recordTypeSpec.fields[i].type(), offset);
        }
        if (TypeSpec.isA(actualType, 7) || TypeSpec.isA(actualType, 6)) {
            return refToStart;
        }
        TapEnv.toolWarning(-1, "(Rebuild offset expression) Such a type has no offset: " + actualType);
        return refToStart;
    }

    public boolean isCaseDependent() {
        return this.caseDependent;
    }

    public void setCaseDependent(boolean caseDependent) {
        this.caseDependent = caseDependent;
    }

    public Unit origUnit() {
        return this.unit == null ? null : this.unit.origUnit;
    }

    public String shortName() {
        String langName = "UNKNOWN";
        if (this.unit != null) {
            int unitLang = this.unit.language();
            langName = TapEnv.languageName(unitLang);
        }
        return this.shortName + " (" + langName + ')';
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public SymbolTable basisSymbolTable() {
        return this.basisSymbolTable;
    }

    public void setBasisSymbolTable(SymbolTable basis) {
        this.basisSymbolTable = basis;
    }

    public void setRootCallGraph(CallGraph cg) {
        this.rootCallGraph = cg;
    }

    public CallGraph getCallGraph() {
        if (this.unit != null) {
            return this.unit.callGraph();
        }
        SymbolTable rootST = this;
        while (rootST.basisSymbolTable != null) {
            rootST = rootST.basisSymbolTable;
        }
        return rootST.rootCallGraph;
    }

    public void setIsTranslationUnit() {
        this.isTranslationUnit = true;
    }

    public boolean isTranslationUnitSymbolTable() {
        return this.isTranslationUnit;
    }

    public int getFreeDeclaredZone(int kind) {
        return this.freeDeclaredZone[kind];
    }

    public void setFreeDeclaredZone(int freeDZ, int kind) {
        this.freeDeclaredZone[kind] = freeDZ;
    }

    public ZoneInfo[] getDeclaredZoneInfos(int kind) {
        return this.declaredZoneInfos[kind];
    }

    public boolean hasNoDeclaredZoneInfos(int kind) {
        return this.declaredZoneInfos[kind] == null && this.additionalDuplicatedDeclaredZoneInfos[kind] == null;
    }

    public void setDeclaredZoneInfos(ZoneInfo[] zoneInfos, int kind) {
        this.declaredZoneInfos[kind] = zoneInfos;
    }

    public TapList<Int2ZoneInfo>[] getAdditionalDuplicatedDeclaredZoneInfos() {
        return this.additionalDuplicatedDeclaredZoneInfos;
    }

    public void setAdditionalDuplicatedDeclaredZoneInfos(TapList<Int2ZoneInfo> additionalZoneInfos, int kind) {
        this.additionalDuplicatedDeclaredZoneInfos[kind] = additionalZoneInfos;
    }

    public ZoneInfo localDeclaredZoneInfo(int zoneNumber, int whichKind) {
        ZoneInfo result = null;
        if (this.firstDeclaredZone[whichKind] <= zoneNumber && zoneNumber < this.freeDeclaredZone[whichKind]) {
            result = this.declaredZoneInfos[whichKind][zoneNumber - this.firstDeclaredZone[whichKind]];
        } else if (this.additionalDuplicatedDeclaredZoneInfos != null) {
            result = TapList.cassq(zoneNumber, this.additionalDuplicatedDeclaredZoneInfos[whichKind]);
        }
        return result;
    }

    public void addPrimitiveTypes() {
        this.addSystemSymbolDecl(new TypeDecl("void", new WrapperTypeSpec(new VoidTypeSpec())));
        PrimitiveTypeSpec integerTypeSpec = new PrimitiveTypeSpec("integer");
        integerTypeSpec.setPrimitiveTypeSize(TapEnv.get().integerSize);
        this.addSystemSymbolDecl(new TypeDecl("integer", new WrapperTypeSpec(integerTypeSpec)));
        PrimitiveTypeSpec floatTypeSpec = new PrimitiveTypeSpec("float");
        floatTypeSpec.setPrimitiveTypeSize(TapEnv.get().realSize);
        this.addSystemSymbolDecl(new TypeDecl("float", new WrapperTypeSpec(floatTypeSpec)));
        this.addSystemSymbolDecl(new TypeDecl("complex", new WrapperTypeSpec(new PrimitiveTypeSpec("complex"))));
        this.addSystemSymbolDecl(new TypeDecl("boolean", new WrapperTypeSpec(new PrimitiveTypeSpec("boolean"))));
        this.addSystemSymbolDecl(new TypeDecl("character", new WrapperTypeSpec(new PrimitiveTypeSpec("character"))));
    }

    public void addSystemSymbolDecl(SymbolDecl symbolDecl) {
        symbolDecl.setSystemPredefined();
        symbolDecl.setNoneInstruction();
        this.addSymbolDecl(symbolDecl);
    }

    public BoolVector getRequiredDiffVars(ActivityPattern pattern) {
        if (this.requiredDiffVarsList == null) {
            return null;
        }
        TapList<TapPair<ActivityPattern, BoolVector>> itRequiredDiffVar = this.requiredDiffVarsList;
        while (itRequiredDiffVar != null) {
            if (((TapPair)itRequiredDiffVar.head).first == pattern) {
                return (BoolVector)((TapPair)itRequiredDiffVar.head).second;
            }
            itRequiredDiffVar = itRequiredDiffVar.tail;
        }
        return null;
    }

    public void setOrCumulRequiredDiffVars(ActivityPattern pattern, BoolVector diffVars) {
        BoolVector tempDiffVars = this.getRequiredDiffVars(pattern);
        if (tempDiffVars == null) {
            this.requiredDiffVarsList = new TapList<TapPair<ActivityPattern, BoolVector>>(new TapPair<ActivityPattern, BoolVector>(pattern, diffVars), this.requiredDiffVarsList);
        } else {
            tempDiffVars.cumulOr(diffVars);
        }
    }

    public SymbolTable basisNotImportedSymbolTable() {
        SymbolTable upperST = this.basisSymbolTable;
        while (upperST != null && upperST.usedModule != null) {
            upperST = upperST.basisSymbolTable;
        }
        return upperST;
    }

    public int freeDeclaredZone(int whichKind) {
        return this.freeDeclaredZone[whichKind];
    }

    public int declaredZonesNb(int whichKind) {
        return this.freeDeclaredZone[whichKind];
    }

    public int firstDeclaredZone(int whichKind) {
        return this.firstDeclaredZone[whichKind];
    }

    protected void computeFirstDeclaredZone(int[] globalFirstZone, SymbolTable basisNumberingST) {
        if (basisNumberingST == null) {
            this.firstDeclaredZone[0] = globalFirstZone[0];
            this.firstDeclaredZone[1] = globalFirstZone[1];
            this.firstDeclaredZone[2] = globalFirstZone[2];
            this.firstDeclaredZone[3] = globalFirstZone[3];
        } else {
            this.firstDeclaredZone[0] = Math.max(globalFirstZone[0], basisNumberingST.freeDeclaredZone[0]);
            this.firstDeclaredZone[1] = Math.max(globalFirstZone[1], basisNumberingST.freeDeclaredZone[1]);
            this.firstDeclaredZone[2] = Math.max(globalFirstZone[2], basisNumberingST.freeDeclaredZone[2]);
            this.firstDeclaredZone[3] = Math.max(globalFirstZone[3], basisNumberingST.freeDeclaredZone[3]);
        }
        this.freeDeclaredZone[0] = this.firstDeclaredZone[0];
        this.freeDeclaredZone[1] = this.firstDeclaredZone[1];
        this.freeDeclaredZone[2] = this.firstDeclaredZone[2];
        this.freeDeclaredZone[3] = this.firstDeclaredZone[3];
    }

    public ZoneInfo declaredZoneInfo(int zone, int whichKind) {
        SymbolTable symbolTable = this;
        ZoneInfo result = null;
        while (result == null && symbolTable != null) {
            result = symbolTable.localDeclaredZoneInfo(zone, whichKind);
            if (result == null && symbolTable.basisSymbolTable != null && (symbolTable.basisSymbolTable.usedModule != null || zone < symbolTable.basisSymbolTable.freeDeclaredZone[whichKind])) {
                symbolTable = symbolTable.basisSymbolTable;
                continue;
            }
            symbolTable = null;
        }
        return result;
    }

    public void declareFormalParamsLevel() {
        this.isFormalParams = true;
    }

    public boolean isFormalParamsLevel() {
        return this.isFormalParams;
    }

    public void addNewSymbolHolder(NewSymbolHolder newSymbolHolder) {
        if (!TapList.contains(this.newSymbolHolders.tail, newSymbolHolder)) {
            this.newSymbolHolders.placdl(newSymbolHolder);
        }
    }

    public void delNewSymbolHolder(NewSymbolHolder newSymbolHolder) {
        TapList<NewSymbolHolder> inNewSymbolHolders = this.newSymbolHolders;
        while (inNewSymbolHolders.tail != null) {
            if (inNewSymbolHolders.tail.head == newSymbolHolder) {
                inNewSymbolHolders.tail = inNewSymbolHolders.tail.tail;
                continue;
            }
            inNewSymbolHolders = inNewSymbolHolders.tail;
        }
    }

    public void solveNewSymbolHolders(boolean noCopySuffix) {
        TapList orderedNewSymbolHolders = TapList.nreverse(this.newSymbolHolders.tail);
        this.newSymbolHolders.tail = null;
        while (orderedNewSymbolHolders != null) {
            ((NewSymbolHolder)orderedNewSymbolHolders.head).solve(this, noCopySuffix);
            orderedNewSymbolHolders = orderedNewSymbolHolders.tail;
        }
    }

    public NewSymbolHolder reuseNewSymbolHolder(String name, WrapperTypeSpec type, TapList<NewSymbolHolder> excluded) {
        NewSymbolHolder symbolHolder = null;
        TapList inNewSymbolHolders = this.newSymbolHolders.tail;
        while (symbolHolder == null && inNewSymbolHolders != null) {
            NewSymbolHolder oneSymbolHolder = (NewSymbolHolder)inNewSymbolHolders.head;
            if (name.equals(oneSymbolHolder.probableName()) && !TapList.contains(excluded, oneSymbolHolder) && oneSymbolHolder.typeSpec().equalsLiterally(type)) {
                symbolHolder = oneSymbolHolder;
            }
            inNewSymbolHolders = inNewSymbolHolders.tail;
        }
        return symbolHolder;
    }

    protected boolean isUseless() {
        int i;
        boolean useless;
        boolean bl = useless = this.basisSymbolTable != null && this.nameSpaceName == null && this.freeDeclaredZone[0] == this.basisSymbolTable.freeDeclaredZone[0];
        if (useless) {
            for (i = 0; i < 100; ++i) {
                if (this.buckets[i].tail == null) continue;
                useless = false;
            }
        }
        if (useless) {
            for (i = 0; i <= 25; ++i) {
                if (this.implicits[i] == this.basisSymbolTable.implicits[i]) continue;
                useless = false;
            }
        }
        return useless;
    }

    protected void moveSymbolDeclListUpRec(TapList<SymbolDecl> symbolDecls, SymbolTable targetSymbolTable) {
        TapList<SymbolDecl> bucket;
        int i;
        SymbolDecl searchedDecl;
        SymbolTable fromSymbolTable = this;
        TapList<Object> removedDecls = null;
        TapList<SymbolDecl> toSearchedDecls = new TapList<SymbolDecl>(null, symbolDecls);
        TapList<Object> moveAddSymbolDecls = null;
        TapList<SymbolDecl> tmpList = symbolDecls;
        while (tmpList != null) {
            if (tmpList.head != null && (TapList.contains(this.addSymbolDecls, tmpList.head) || ((SymbolDecl)tmpList.head).hasPublicModifier(this.addSymbolDecls) || ((SymbolDecl)tmpList.head).hasModifier("extern"))) {
                moveAddSymbolDecls = new TapList(tmpList.head, moveAddSymbolDecls);
                if (((SymbolDecl)tmpList.head).hasPublicModifier(this.addSymbolDecls)) {
                    SymbolDecl addSymbolDecl = TapList.findNamedSymbolDecl(this.addSymbolDecls, ((SymbolDecl)tmpList.head).symbol);
                    moveAddSymbolDecls = new TapList<SymbolDecl>(addSymbolDecl, moveAddSymbolDecls);
                    this.addSymbolDecls = TapList.delete(addSymbolDecl, this.addSymbolDecls);
                }
            }
            tmpList = tmpList.tail;
        }
        targetSymbolTable.addSymbolDecls = moveAddSymbolDecls;
        while (fromSymbolTable != targetSymbolTable) {
            TapList<SymbolDecl> inSearchedDecls = toSearchedDecls;
            while (inSearchedDecls.tail != null) {
                searchedDecl = (SymbolDecl)inSearchedDecls.tail.head;
                if (searchedDecl != null && !searchedDecl.hasPrivateModifier(this.addSymbolDecls)) {
                    i = SymbolTable.hashKey(searchedDecl.symbol);
                    bucket = fromSymbolTable.buckets[i];
                    while (bucket.tail != null && bucket.tail.head != searchedDecl) {
                        bucket = bucket.tail;
                    }
                    if (bucket.tail != null) {
                        bucket.tail = bucket.tail.tail;
                        removedDecls = new TapList<SymbolDecl>(searchedDecl, removedDecls);
                        inSearchedDecls.tail = inSearchedDecls.tail.tail;
                        TapList<SymbolDecl> dependsOn = searchedDecl.dependsOn();
                        while (dependsOn != null) {
                            inSearchedDecls.tail = new TapList(dependsOn.head, inSearchedDecls.tail);
                            dependsOn = dependsOn.tail;
                        }
                        continue;
                    }
                    inSearchedDecls = inSearchedDecls.tail;
                    continue;
                }
                inSearchedDecls = inSearchedDecls.tail;
            }
            fromSymbolTable = fromSymbolTable.basisSymbolTable;
        }
        while (removedDecls != null) {
            searchedDecl = (SymbolDecl)removedDecls.head;
            searchedDecl.recomputeDependsOn(targetSymbolTable);
            i = SymbolTable.hashKey(searchedDecl.symbol);
            bucket = targetSymbolTable.buckets[i];
            bucket.placdl(searchedDecl);
            removedDecls = removedDecls.tail;
        }
    }

    public SymbolTable getCommonRoot(SymbolTable otherSymbolTable) {
        TapList<SymbolTable> list1 = this.allSymbolTableRoots();
        TapList<SymbolTable> list2 = otherSymbolTable.allSymbolTableRoots();
        if (list1.head != list2.head) {
            return null;
        }
        while (list1.tail != null && list2.tail != null && list1.tail.head == list2.tail.head) {
            list1 = list1.tail;
            list2 = list2.tail;
        }
        return (SymbolTable)list1.head;
    }

    public TapList<SymbolTable> allSymbolTableRoots() {
        SymbolTable current = this;
        TapList<SymbolTable> result = new TapList<SymbolTable>(current, null);
        while ((current = current.basisSymbolTable()) != null) {
            result = new TapList<SymbolTable>(current, result);
        }
        return result;
    }

    public TapList<SymbolTable> allSymbolTableRoots(SymbolTable limit) {
        TapList<SymbolTable> result = null;
        for (SymbolTable current = this; current != limit && current != null; current = current.basisSymbolTable()) {
            result = new TapList<SymbolTable>(current, result);
        }
        return result;
    }

    public boolean nestedIn(SymbolTable symbolTable) {
        boolean nested = false;
        for (SymbolTable nestedST = this; nestedST != null && !nested; nestedST = nestedST.basisSymbolTable()) {
            nested = nestedST == symbolTable;
        }
        return nested;
    }

    protected void importAllClassSymbolTable(SymbolTable parentClassSymbolTable, Unit classUnit, Unit inheritedClassUnit, boolean isVirtualInheritance) {
        SymbolDecl virtualSymbolDecl = null;
        SymbolDecl symbolDecl = null;
        boolean virtualDeclAlreadyPresent = false;
        for (int i = 0; i < 100; ++i) {
            TapList oldBucket = parentClassSymbolTable.buckets[i].tail;
            while (oldBucket != null) {
                SymbolDecl oldSymbolDecl = (SymbolDecl)oldBucket.head;
                InheritanceTree oldInheritanceTree = oldSymbolDecl.inheritanceTree;
                if (oldInheritanceTree != null) {
                    TapList<InheritanceTree> tmpOldVirtualChildren = oldInheritanceTree.virtualChildren;
                    TapList<InheritanceTree> tmpOldChildren = oldInheritanceTree.children;
                    if (tmpOldVirtualChildren != null) {
                        Unit declarationUnit = ((InheritanceTree)tmpOldVirtualChildren.head).declarationUnit;
                        virtualSymbolDecl = this.getTopVirtualSymbolDecl(declarationUnit, oldSymbolDecl);
                        boolean bl = virtualDeclAlreadyPresent = virtualSymbolDecl != null;
                        if (virtualSymbolDecl == null) {
                            virtualSymbolDecl = classUnit.privateSymbolTable().getTopVirtualSymbolDecl(declarationUnit, oldSymbolDecl);
                        }
                        if (virtualSymbolDecl == null) {
                            virtualSymbolDecl = classUnit.protectedSymbolTable().getTopVirtualSymbolDecl(declarationUnit, oldSymbolDecl);
                        }
                        if (virtualSymbolDecl == null) {
                            virtualSymbolDecl = classUnit.publicSymbolTable().getTopVirtualSymbolDecl(declarationUnit, oldSymbolDecl);
                        }
                        if (virtualSymbolDecl == null) {
                            virtualSymbolDecl = SymbolDecl.copy(oldSymbolDecl);
                            virtualSymbolDecl.inheritanceTree = new InheritanceTree();
                        }
                        while (tmpOldVirtualChildren != null) {
                            InheritanceTree tmpOldVirtualChild = (InheritanceTree)tmpOldVirtualChildren.head;
                            InheritanceTree copyOldVirtualChild = InheritanceTree.copy(tmpOldVirtualChild);
                            copyOldVirtualChild.currentUnit = inheritedClassUnit;
                            if (!isVirtualInheritance) {
                                copyOldVirtualChild.declarationUnit = classUnit;
                            }
                            virtualSymbolDecl.inheritanceTree.addChild(copyOldVirtualChild, isVirtualInheritance);
                            tmpOldVirtualChildren = tmpOldVirtualChildren.tail;
                        }
                    }
                    if (tmpOldChildren != null) {
                        symbolDecl = SymbolDecl.copy(oldSymbolDecl);
                        while (tmpOldChildren != null) {
                            InheritanceTree tmpOldChild = (InheritanceTree)tmpOldChildren.head;
                            InheritanceTree copyOldChild = InheritanceTree.copy(tmpOldChild);
                            copyOldChild.currentUnit = inheritedClassUnit;
                            copyOldChild.declarationUnit = classUnit;
                            if (virtualSymbolDecl != null) {
                                virtualSymbolDecl.inheritanceTree.addChild(copyOldChild, isVirtualInheritance);
                            } else {
                                symbolDecl.inheritanceTree.addChild(copyOldChild, isVirtualInheritance);
                            }
                            tmpOldChildren = tmpOldChildren.tail;
                        }
                    }
                    if (!virtualDeclAlreadyPresent && virtualSymbolDecl != null) {
                        this.addSymbolDecl(virtualSymbolDecl);
                    } else if (symbolDecl != null) {
                        this.addSymbolDecl(symbolDecl);
                    }
                } else {
                    symbolDecl = SymbolDecl.copy(oldSymbolDecl);
                    symbolDecl.inheritanceTree = new InheritanceTree();
                    symbolDecl.inheritanceTree.currentUnit = inheritedClassUnit;
                    symbolDecl.inheritanceTree.declarationUnit = isVirtualInheritance ? inheritedClassUnit : classUnit;
                    this.addSymbolDecl(symbolDecl);
                }
                oldBucket = oldBucket.tail;
            }
        }
    }

    protected void importModuleSymbolTable(Unit module, Tree renamedVisibles, boolean printMsg) {
        SymbolTable origSymbolTable = module.publicSymbolTable();
        if ((renamedVisibles.opCode() != 140 || renamedVisibles.length() != 0) && origSymbolTable != null) {
            SymbolDecl nextSymbolDecl;
            TapList<SymbolDecl> toCurBucket;
            int i;
            if (TapEnv.traceTypeCheckAnalysis()) {
                TapEnv.printlnOnTrace("  Importing into unit " + this.unit.name + " symbols used from module " + module.name);
            }
            SymbolTable copyST = origSymbolTable.copy(null, module, null);
            copyST.isFormalParams = false;
            copyST.basisSymbolTable = this.basisSymbolTable;
            Tree[] sons = renamedVisibles.children();
            TapList privates = null;
            TapList<Object> onlyVisibles = null;
            TapList<Object> declarationsToBeRemoved = null;
            TapList<String> visibles = null;
            if (renamedVisibles.opCode() == 140) {
                for (i = 0; i < sons.length; ++i) {
                    Tree onlySon = renamedVisibles.down(i + 1);
                    Tree visibleSon = null;
                    if (onlySon != null) {
                        switch (onlySon.opCode()) {
                            case 16: {
                                visibleSon = onlySon = onlySon.down(2);
                                break;
                            }
                            case 94: {
                                visibleSon = onlySon;
                                break;
                            }
                            case 160: {
                                onlySon = onlySon.down(2);
                                break;
                            }
                            default: {
                                String operatorName = onlySon.opName();
                                InterfaceDecl interfaceDecl = origSymbolTable.getTopInterfaceDecl(operatorName);
                                if (interfaceDecl != null) {
                                    onlySon = ILUtils.build(94, interfaceDecl.symbol);
                                    break;
                                }
                                TapEnv.fileWarning(15, onlySon, "Incorrect only declaration " + ILUtils.toString(onlySon));
                                onlySon = null;
                            }
                        }
                    }
                    if (onlySon != null) {
                        onlyVisibles = new TapList<String>(onlySon.stringValue(), onlyVisibles);
                    }
                    if (visibleSon == null) continue;
                    visibles = new TapList<String>(visibleSon.stringValue(), visibles);
                }
            }
            TapList inOnlyVisibles = onlyVisibles;
            while (inOnlyVisibles != null) {
                String origSymbolName = (String)inOnlyVisibles.head;
                if (printMsg && origSymbolTable.getTopSymbolDecl(origSymbolName) == null && module.getImportedDecl(origSymbolName, 0) == null) {
                    TapEnv.fileWarning(15, null, "(DD17) Symbol " + origSymbolName + " is not defined in module " + module.name);
                }
                inOnlyVisibles = inOnlyVisibles.tail;
            }
            for (i = 0; i < 100; ++i) {
                toCurBucket = copyST.buckets[i];
                while (toCurBucket.tail != null) {
                    nextSymbolDecl = (SymbolDecl)toCurBucket.tail.head;
                    if (nextSymbolDecl.isA(3) && ((FunctionDecl)nextSymbolDecl).isModule() || (TapList.containsString(nextSymbolDecl.extraInfo(), "private", false) || !TapList.containsString(nextSymbolDecl.extraInfo(), "public", false) && module.fortranStuff() != null && module.fortranStuff().publicPrivateDefault != null && module.fortranStuff().publicPrivateDefault.equals("private")) && !nextSymbolDecl.hasPublicModifier(origSymbolTable.addSymbolDecls) || onlyVisibles != null && !TapList.containsEquals(onlyVisibles, nextSymbolDecl.symbol)) {
                        privates = new TapList(new TapPair<String, SymbolDecl>(nextSymbolDecl.symbol, nextSymbolDecl), privates);
                        declarationsToBeRemoved = new TapList<TapList<SymbolDecl>>(toCurBucket, declarationsToBeRemoved);
                    }
                    toCurBucket = toCurBucket.tail;
                }
            }
            while (declarationsToBeRemoved != null) {
                toCurBucket = (TapList<SymbolDecl>)declarationsToBeRemoved.head;
                toCurBucket.tail = toCurBucket.tail.tail;
                declarationsToBeRemoved = declarationsToBeRemoved.tail;
            }
            renamedVisibles = ILUtils.copy(renamedVisibles);
            if (sons != null) {
                int cutRkInTree = 1;
                for (Tree son : sons) {
                    Tree renamed = son;
                    if (renamed != null && renamed.opCode() == 160) {
                        String origName = renamed.down(2).opCode() == 16 ? renamed.down(2).down(2).stringValue() : renamed.down(2).stringValue();
                        SymbolDecl origSymbolDecl = origSymbolTable.getDecl(origName, 0, true);
                        SymbolDecl copiedSymbolDecl = copyST.getDecl(origName, 0, true);
                        if (copiedSymbolDecl == null) {
                            copiedSymbolDecl = (SymbolDecl)TapList.cassqString(origName, privates);
                        }
                        if (copiedSymbolDecl == null) {
                            copiedSymbolDecl = module.getImportedDecl(origName, 0);
                            if (copiedSymbolDecl == null && printMsg) {
                                TapEnv.fileWarning(15, renamed.down(2), "(DD17) Symbol " + origName + " is not defined in module " + module.name);
                            }
                        } else {
                            boolean isNotVisible = !TapList.containsEquals(visibles, origName);
                            Tree renamed1 = renamed.down(1);
                            if (renamed1.opCode() == 16) {
                                renamed1 = renamed1.down(2);
                            }
                            this.renameSymbolInImportedSymbolTable(copyST, renamed1, origName, origSymbolDecl, copiedSymbolDecl, isNotVisible);
                            renamedVisibles.removeChild(cutRkInTree);
                            --cutRkInTree;
                        }
                    }
                    ++cutRkInTree;
                }
            }
            for (int i2 = 0; i2 < 100; ++i2) {
                toCurBucket = copyST.buckets[i2];
                while (toCurBucket.tail != null) {
                    nextSymbolDecl = (SymbolDecl)toCurBucket.tail.head;
                    String inUseString = nextSymbolDecl.symbol;
                    SymbolDecl symbolDecl = this.basisSymbolTable.getSymbolDecl(inUseString);
                    if (symbolDecl != null && (symbolDecl == nextSymbolDecl || nextSymbolDecl.renamedFromSymbolDecl != null && symbolDecl.renamedFromSymbolDecl == nextSymbolDecl.renamedFromSymbolDecl)) {
                        toCurBucket.tail.head = symbolDecl;
                    }
                    toCurBucket = toCurBucket.tail;
                }
            }
            this.basisSymbolTable = copyST;
            copyST.usedModule = module;
        }
    }

    private void renameSymbolInImportedSymbolTable(SymbolTable copyST, Tree renamer, String inUseString, SymbolDecl origSymbol, SymbolDecl inUseSymbol, boolean isNotVisible) {
        SymbolDecl newSymbolDecl;
        switch (inUseSymbol.kind) {
            case 3: {
                newSymbolDecl = new FunctionDecl(renamer, ((FunctionDecl)inUseSymbol).unit());
                break;
            }
            case 4: {
                newSymbolDecl = new TypeDecl(renamer, ((TypeDecl)inUseSymbol).typeSpec, this.unit);
                break;
            }
            case 1: 
            case 5: {
                newSymbolDecl = new VariableDecl(renamer, inUseSymbol.type());
                ((VariableDecl)newSymbolDecl).adoptZones((VariableDecl)inUseSymbol);
                newSymbolDecl.setExtraInfo(inUseSymbol.extraInfo());
                break;
            }
            case 2: {
                newSymbolDecl = new FieldDecl(renamer, inUseSymbol.type());
                break;
            }
            case 16: {
                newSymbolDecl = new InterfaceDecl(renamer);
                newSymbolDecl.nameTree = inUseSymbol.nameTree;
                ((InterfaceDecl)newSymbolDecl).contents = ((InterfaceDecl)inUseSymbol).contents;
                ((InterfaceDecl)newSymbolDecl).functionDecls = ((InterfaceDecl)inUseSymbol).functionDecls;
                ((InterfaceDecl)newSymbolDecl).functionNames = ((InterfaceDecl)inUseSymbol).functionNames;
                ((InterfaceDecl)newSymbolDecl).definitionSymbolTable = ((InterfaceDecl)inUseSymbol).definitionSymbolTable;
                ((InterfaceDecl)newSymbolDecl).containerUnit = ((InterfaceDecl)inUseSymbol).containerUnit;
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(Symbol Table) Renaming of " + inUseSymbol + " is not yet implemented");
                newSymbolDecl = inUseSymbol;
            }
        }
        if (isNotVisible) {
            copyST.removeDecl(inUseString, 0, false);
        }
        copyST.addSymbolDecl(newSymbolDecl);
        newSymbolDecl.renamedFromSymbolDecl = origSymbol;
        newSymbolDecl.shareActivity(origSymbol);
    }

    protected TapList<SymbolDecl> findPublicSymbolDecls() {
        TapList<SymbolDecl> publicSymbolDecls = null;
        boolean caseSensitive = !this.unit.isFortran();
        String defaultAccess = "public";
        if (this.unit.isFortran()) {
            if (this.unit.fortranStuff() != null && this.unit.fortranStuff().publicPrivateDefault != null) {
                defaultAccess = this.unit.fortranStuff().publicPrivateDefault.toLowerCase();
            }
        } else if (this.unit.isCPlusPlus() && this.unit.privacy != null && !this.unit.privacy.isEmpty()) {
            defaultAccess = this.unit.privacy;
        }
        for (int i = 99; i >= 0; --i) {
            TapList curBucket = this.buckets[i].tail;
            while (curBucket != null) {
                SymbolDecl symbolDecl = (SymbolDecl)curBucket.head;
                if (TapList.containsString(symbolDecl.extraInfo(), "public", caseSensitive) || symbolDecl.hasPublicModifier(this.addSymbolDecls) || "public".equals(defaultAccess) && !TapList.containsOneOfStrings(symbolDecl.extraInfo(), new String[]{"private", "protected"}, caseSensitive) && !symbolDecl.hasPrivateModifier(this.addSymbolDecls) && !symbolDecl.hasProtectedModifier(this.addSymbolDecls)) {
                    publicSymbolDecls = new TapList<SymbolDecl>(symbolDecl, publicSymbolDecls);
                }
                curBucket = curBucket.tail;
            }
        }
        return publicSymbolDecls;
    }

    protected TapList<SymbolDecl> findProtectedSymbolDecls() {
        TapList<SymbolDecl> protectedSymbolDecls = null;
        boolean caseSensitive = !this.unit.isFortran();
        String defaultAccess = "public";
        if (this.unit.isFortran()) {
            if (this.unit.fortranStuff() != null && this.unit.fortranStuff().publicPrivateDefault != null) {
                defaultAccess = this.unit.fortranStuff().publicPrivateDefault.toLowerCase();
            }
        } else if (this.unit.isCPlusPlus() && this.unit.privacy != null && !this.unit.privacy.isEmpty()) {
            defaultAccess = this.unit.privacy;
        }
        for (int i = 99; i >= 0; --i) {
            TapList curBucket = this.buckets[i].tail;
            while (curBucket != null) {
                SymbolDecl symbolDecl = (SymbolDecl)curBucket.head;
                if (TapList.containsString(symbolDecl.extraInfo(), "protected", caseSensitive) || symbolDecl.hasProtectedModifier(this.addSymbolDecls) || "protected".equals(defaultAccess) && !TapList.containsOneOfStrings(symbolDecl.extraInfo(), new String[]{"private", "public"}, caseSensitive) && !symbolDecl.hasPrivateModifier(this.addSymbolDecls) && !symbolDecl.hasPublicModifier(this.addSymbolDecls)) {
                    protectedSymbolDecls = new TapList<SymbolDecl>(symbolDecl, protectedSymbolDecls);
                }
                curBucket = curBucket.tail;
            }
        }
        return protectedSymbolDecls;
    }

    public boolean isEmptyTranslationUnitST() {
        return this.allUnitPlaceHolders(this.declarationsBlock.instructions);
    }

    public boolean mustBeCreated() {
        return this.declarationsBlock.instructions != null;
    }

    private boolean allUnitPlaceHolders(TapList<Instruction> instrs) {
        boolean allPlaceHolders = true;
        while (instrs != null && allPlaceHolders) {
            allPlaceHolders = ((Instruction)instrs.head).tree != null && ((Instruction)instrs.head).tree.getAnnotation("Unit") != null;
            instrs = instrs.tail;
        }
        return allPlaceHolders;
    }

    public SymbolDecl getSymbolDecl(String name) {
        return this.getDecl(name, 0, false);
    }

    private TapList<SymbolDecl> getAllSymbolDecls(String name) {
        TapList<SymbolDecl> result = null;
        for (int i = 0; i < 100; ++i) {
            TapList curBucket = this.buckets[i].tail;
            while (curBucket != null) {
                SymbolDecl symbolDecl = (SymbolDecl)curBucket.head;
                if (symbolDecl.symbol.equals(name)) {
                    result = new TapList<SymbolDecl>(symbolDecl, result);
                }
                curBucket = curBucket.tail;
            }
        }
        return result;
    }

    private TapList<TapPair<SymbolDecl, InheritanceTree>> eliminateSymbolDeclsRec(TapList<TapPair<SymbolDecl, InheritanceTree>> possibleSymbolDecls, Tree instrOrExpr) {
        if (possibleSymbolDecls == null || TapList.length(possibleSymbolDecls) == 0) {
            return possibleSymbolDecls;
        }
        TapList<TapPair<SymbolDecl, InheritanceTree>> tmpPossibleSymbolDecls = possibleSymbolDecls;
        TapList<TapPair<SymbolDecl, InheritanceTree>> possibleSymbolDeclsResult = new TapList<TapPair<SymbolDecl, InheritanceTree>>();
        while (tmpPossibleSymbolDecls != null) {
            TapList<InheritanceTree> tmpVirtualChildren;
            TapList<InheritanceTree> tmpChildren;
            SymbolDecl symbol = (SymbolDecl)((TapPair)tmpPossibleSymbolDecls.head).first;
            InheritanceTree tree = (InheritanceTree)((TapPair)tmpPossibleSymbolDecls.head).second;
            String searchedString = ILUtils.getIdentString(instrOrExpr.down(2));
            TapList<InheritanceTree> tapList = tmpChildren = tree == null ? null : tree.children;
            while (tmpChildren != null) {
                if (((InheritanceTree)tmpChildren.head).getName().equals(searchedString)) {
                    possibleSymbolDeclsResult = new TapList<TapPair<SymbolDecl, InheritanceTree>>(new TapPair(symbol, tmpChildren.head), possibleSymbolDeclsResult);
                }
                tmpChildren = tmpChildren.tail;
            }
            TapList<InheritanceTree> tapList2 = tmpVirtualChildren = tree == null ? null : tree.virtualChildren;
            while (tmpVirtualChildren != null) {
                if (((InheritanceTree)tmpVirtualChildren.head).getName().equals(searchedString)) {
                    possibleSymbolDeclsResult = new TapList<TapPair<SymbolDecl, InheritanceTree>>(new TapPair(symbol, tmpVirtualChildren.head), possibleSymbolDeclsResult);
                }
                tmpVirtualChildren = tmpVirtualChildren.tail;
            }
            tmpPossibleSymbolDecls = tmpPossibleSymbolDecls.tail;
        }
        if (instrOrExpr.down(1).opCode() != 168) {
            return possibleSymbolDeclsResult;
        }
        possibleSymbolDecls = this.eliminateSymbolDeclsRec(possibleSymbolDeclsResult, instrOrExpr.down(1));
        return possibleSymbolDecls;
    }

    private SymbolDecl getTopVirtualSymbolDecl(Unit declarationUnit, SymbolDecl oldSymbolDecl) {
        TapList<SymbolDecl> allSymbolDecls;
        if (oldSymbolDecl.isA(3)) {
            FunctionDecl oldFunctionDecl = (FunctionDecl)oldSymbolDecl;
            FunctionTypeSpec functionTypeSpec = oldFunctionDecl.functionTypeSpec();
            allSymbolDecls = this.getTopFunctionDecl(oldFunctionDecl.symbol, functionTypeSpec.returnType, functionTypeSpec.argumentsTypes, true);
        } else {
            allSymbolDecls = this.getAllSymbolDecls(oldSymbolDecl.symbol);
        }
        while (allSymbolDecls != null) {
            TapList<InheritanceTree> virtualChildren = ((SymbolDecl)allSymbolDecls.head).inheritanceTree.virtualChildren;
            if (virtualChildren != null && virtualChildren.head != null && ((InheritanceTree)virtualChildren.head).declarationUnit == declarationUnit) {
                return (SymbolDecl)allSymbolDecls.head;
            }
            allSymbolDecls = allSymbolDecls.tail;
        }
        return null;
    }

    public VariableDecl getVariableDecl(String name) {
        return (VariableDecl)this.getDecl(name, 1, false);
    }

    public VariableDecl getConstantDecl(String name) {
        return (VariableDecl)this.getDecl(name, 5, false);
    }

    public VariableDecl getVariableOrConstantDecl(String name) {
        return (VariableDecl)this.getDecl(name, 1, 5, false, null);
    }

    protected VariableDecl getVariableOrConstantOrFuncNameDecl(String name) {
        return (VariableDecl)this.getDecl(name, 1, 5, 6, false);
    }

    public TapList<FunctionDecl> getFunctionDecl(String name, TypeSpec returnType, TypeSpec[] argumentsTypes, boolean checkArgsTypes) {
        return this.getAllPossibleTypedFunctionDecl(name, returnType, argumentsTypes, this, null, checkArgsTypes, false, false, true, null, false);
    }

    public TapList<FunctionDecl> getFunctionDecl(String name, TypeSpec returnType, TypeSpec[] argumentsTypes, String className, boolean checkArgsTypes) {
        return this.getAllPossibleTypedFunctionDecl(name, returnType, argumentsTypes, this, null, checkArgsTypes, false, false, true, className, true);
    }

    private VariableDecl getFuncVarDecl(String name) {
        VariableDecl varDecl = this.getVariableOrConstantOrFuncNameDecl(name);
        if (varDecl != null && WrapperTypeSpec.isFunctionOrPointerToFunction(varDecl.type())) {
            return varDecl;
        }
        return null;
    }

    protected FunctionDecl getFunctionNotInterfaceDecl(String name) {
        return (FunctionDecl)this.getDecl(name, -3, false);
    }

    protected FunctionDecl getFunctionNotExternalNorInterfaceDecl(String name) {
        return (FunctionDecl)this.getDecl(name, -4, false);
    }

    public FunctionDecl getModuleDecl(String name) {
        return (FunctionDecl)this.getDecl(name, 17, false);
    }

    public SymbolTable getPrefixedNamedScope(Tree prefixTree) {
        SymbolTable searchedSymbolTable;
        if (prefixTree.opCode() == 168) {
            searchedSymbolTable = this.getPrefixedNamedScope(prefixTree.down(1));
            prefixTree = prefixTree.down(2);
        } else {
            searchedSymbolTable = this;
        }
        String prefixName = ILUtils.getIdentString(prefixTree);
        SymbolTable scopeST = searchedSymbolTable.getNamedScope(prefixName);
        if (scopeST == null && this.language == 5) {
            Unit enclosingUnit = searchedSymbolTable.unit;
            TapEnv.fileError(prefixTree, "(TCxx) Adding undeclared namespace " + prefixName + " into " + searchedSymbolTable.shortName());
            scopeST = new SymbolTable(searchedSymbolTable);
            scopeST.setShortName("SymbolTable of nameSpace " + prefixName);
            scopeST.nameSpaceName = prefixName;
            scopeST.unit = enclosingUnit;
            enclosingUnit.addDerivedSymbolTable(scopeST);
            searchedSymbolTable.addNameSpaceDecl(prefixName, scopeST);
        }
        return scopeST;
    }

    public SymbolTable getNamedScope(String prefixName) {
        NameSpaceDecl nameSpaceDecl;
        ClassDecl classDecl = this.getClassDecl(prefixName);
        SymbolTable result = null;
        if (classDecl != null) {
            if (classDecl.unit != null) {
                result = classDecl.unit.privateSymbolTable();
            }
        } else if (this.language == 5 && (nameSpaceDecl = this.getNameSpaceDecl(prefixName)) != null) {
            result = nameSpaceDecl.symbolTable;
        }
        return result;
    }

    public ClassDecl getClassDecl(Tree classNameTree) {
        SymbolTable targetSymbolTable = this;
        if (classNameTree.opCode() == 168) {
            targetSymbolTable = this.getPrefixedNamedScope(classNameTree.down(1));
            classNameTree = classNameTree.down(2);
        }
        return targetSymbolTable == null ? null : targetSymbolTable.getClassDecl(ILUtils.getIdentString(classNameTree));
    }

    public ClassDecl getClassDecl(String name) {
        return (ClassDecl)this.getDecl(name, 18, false);
    }

    public NameSpaceDecl getSetNameSpaceDecl(Tree nameSpaceTree) {
        SymbolTable targetSymbolTable = this;
        if (nameSpaceTree.opCode() == 168) {
            targetSymbolTable = this.getPrefixedNamedScope(nameSpaceTree.down(1));
            nameSpaceTree = nameSpaceTree.down(2);
        }
        String nameSpaceName = ILUtils.getIdentString(nameSpaceTree);
        assert (targetSymbolTable != null);
        NameSpaceDecl result = targetSymbolTable.getNameSpaceDecl(nameSpaceName);
        if (result == null) {
            Unit enclosingUnit = targetSymbolTable.unit;
            SymbolTable nameSpaceST = new SymbolTable(targetSymbolTable);
            nameSpaceST.setShortName("SymbolTable of nameSpace " + nameSpaceName);
            nameSpaceST.nameSpaceName = nameSpaceName;
            nameSpaceST.unit = enclosingUnit;
            enclosingUnit.addDerivedSymbolTable(nameSpaceST);
            result = targetSymbolTable.addNameSpaceDecl(nameSpaceName, nameSpaceST);
        }
        return result;
    }

    public NameSpaceDecl getNameSpaceDecl(String name) {
        return (NameSpaceDecl)this.getDecl(name, 20, false);
    }

    protected Unit getModule(String name) {
        FunctionDecl modDecl = this.getModuleDecl(name);
        return modDecl == null ? null : modDecl.unit();
    }

    protected TapList<InterfaceDecl> getInterfaceDecl(String name) {
        TapList<InterfaceDecl> result = null;
        SymbolTable currentST = this;
        while (currentST.basisSymbolTable != null) {
            SymbolDecl symbolDecl = currentST.getDecl(name, 16, true);
            if (symbolDecl != null) {
                result = new TapList<InterfaceDecl>((InterfaceDecl)symbolDecl, result);
            }
            currentST = currentST.basisSymbolTable;
        }
        return result;
    }

    public TypeDecl getTypeDecl(String name) {
        return (TypeDecl)this.getDecl(name, 4, false);
    }

    public SymbolDecl getTopDecl(String name, int kind) {
        return this.getDecl(name, kind, true);
    }

    public SymbolDecl getTopSymbolDecl(String name) {
        return this.getDecl(name, 0, true);
    }

    public VariableDecl getTopVariableDecl(String name) {
        return (VariableDecl)this.getDecl(name, 1, true);
    }

    public VariableDecl getTopVariableOrConstantDecl(String name) {
        return (VariableDecl)this.getDecl(name, 1, 5, true, null);
    }

    public TapList<FunctionDecl> getTopFunctionDecl(String name, TypeSpec returnType, TypeSpec[] argumentsTypes, boolean checkArgsTypes) {
        return this.getAllPossibleTypedFunctionDecl(name, returnType, argumentsTypes, this, null, checkArgsTypes, true, false, true, null, false);
    }

    public TapList<FunctionDecl> getTopFunctionDecl(String name, TypeSpec returnType, TypeSpec[] argumentsTypes, String className, boolean checkArgsTypes) {
        return this.getAllPossibleTypedFunctionDecl(name, returnType, argumentsTypes, this, null, checkArgsTypes, true, false, true, className, true);
    }

    public FunctionDecl getTopModuleDecl(String name) {
        return (FunctionDecl)this.getDecl(name, 17, true);
    }

    public ClassDecl getTopClassDecl(String name) {
        return (ClassDecl)this.getDecl(name, 18, true);
    }

    public NameSpaceDecl getTopNameSpaceDecl(String name) {
        return (NameSpaceDecl)this.getDecl(name, 20, true);
    }

    public InterfaceDecl getTopInterfaceDecl(String name) {
        return (InterfaceDecl)this.getDecl(name, 16, true);
    }

    protected TypeDecl getTopTypeDecl(String name) {
        return (TypeDecl)this.getDecl(name, 4, true);
    }

    public SymbolDecl getDecl(String name, int kind, boolean top) {
        TapList<SymbolDecl> toBucket = this.getToDecl(name, kind, top, null);
        if (toBucket != null) {
            return (SymbolDecl)toBucket.tail.head;
        }
        return null;
    }

    public void getDecl(String name, int kind, boolean top, TapList<SymbolTable> toST) {
        this.getToDecl(name, kind, top, toST);
    }

    public FunctionDecl getTypedFunctionDecl(String name, WrapperTypeSpec returnType, WrapperTypeSpec[] argumentsTypes, boolean top, Tree callTree) {
        FunctionDecl fDecl;
        if (TapEnv.traceTypeCheckAnalysis()) {
            TapEnv.indentOnTrace(TapEnv.traceIndent());
            TapEnv.printlnOnTrace("Search Typed FunctionDecl of " + name + new FunctionTypeSpec(returnType, argumentsTypes) + " in " + (top ? "TOP of " : "") + this.addressChain());
            TapEnv.setTraceIndent(TapEnv.traceIndent() + 2);
        }
        if ((fDecl = this.getTypedFunctionDeclMoreOrLess(name, returnType, argumentsTypes, top, true, true, callTree)) == null) {
            fDecl = this.getTypedFunctionDeclMoreOrLess(name, returnType, argumentsTypes, top, false, true, callTree);
        }
        if (fDecl == null) {
            fDecl = this.getTypedFunctionDeclMoreOrLess(name, returnType, argumentsTypes, top, false, false, callTree);
        }
        if (TapEnv.traceTypeCheckAnalysis()) {
            TapEnv.setTraceIndent(TapEnv.traceIndent() - 2);
            TapEnv.indentOnTrace(TapEnv.traceIndent());
            TapEnv.printlnOnTrace("Found " + fDecl);
        }
        return fDecl;
    }

    private FunctionDecl getTypedFunctionDeclMoreOrLess(String name, WrapperTypeSpec returnType, WrapperTypeSpec[] argumentsTypes, boolean top, boolean alsoMatchTypes, boolean sameNumberOfArgs, Tree callTree) {
        if (TapEnv.traceTypeCheckAnalysis()) {
            TapEnv.indentOnTrace(TapEnv.traceIndent());
            TapEnv.printlnOnTrace("search watching " + (alsoMatchTypes ? "arguments and result types " : (sameNumberOfArgs ? "only number of arguments " : "only function name ")) + " in " + (top ? "TOP of " : "") + this.addressChain());
            TapEnv.setTraceIndent(TapEnv.traceIndent() + 2);
        }
        String searchedName = name;
        int index = SymbolTable.hashKey(name);
        SymbolTable curSymbolTable = this;
        SymbolDecl resultDecl = null;
        SymbolDecl externalDecl = null;
        int nbArgs = argumentsTypes.length;
        SymbolDecl oneResultDecl = null;
        int bestNbArgs = -1;
        while (resultDecl == null && curSymbolTable != null) {
            TapList<SymbolDecl> toBucket;
            if (!curSymbolTable.caseDependent) {
                searchedName = name.toLowerCase();
                index = SymbolTable.hashKey(searchedName);
            }
            if ((toBucket = curSymbolTable.buckets[index]) != null) {
                while (resultDecl == null && toBucket.tail != null) {
                    SymbolDecl symbolDecl = (SymbolDecl)toBucket.tail.head;
                    if (symbolDecl.symbol.equals(searchedName)) {
                        if (symbolDecl.isA(3)) {
                            boolean matches;
                            if (alsoMatchTypes) {
                                matches = ((FunctionDecl)symbolDecl).declarationMatchesCall(returnType, argumentsTypes);
                            } else {
                                WrapperTypeSpec arg1Type;
                                boolean bl = matches = this.nbArgsOf(((FunctionDecl)symbolDecl).functionTypeSpec()) == nbArgs;
                                if (matches && nbArgs > 0 && TypeSpec.isA(arg1Type = ((FunctionDecl)symbolDecl).functionTypeSpec().argumentsTypes[0], 2) && !TypeSpec.isA(argumentsTypes[0], 2)) {
                                    matches = false;
                                }
                            }
                            if (matches) {
                                resultDecl = symbolDecl;
                                if (symbolDecl.isExternal() && !MPIcallInfo.isMessagePassingFunction(searchedName, this.language)) {
                                    externalDecl = resultDecl;
                                    resultDecl = null;
                                }
                            }
                            if (!sameNumberOfArgs && !matches) {
                                int symbolNbArgs = this.nbArgsOf(((FunctionDecl)symbolDecl).functionTypeSpec());
                                if (oneResultDecl == null || Math.abs(nbArgs - symbolNbArgs) < Math.abs(nbArgs - bestNbArgs)) {
                                    oneResultDecl = symbolDecl;
                                    bestNbArgs = symbolNbArgs;
                                }
                            }
                        } else if (symbolDecl.isA(16) && alsoMatchTypes) {
                            resultDecl = ((InterfaceDecl)symbolDecl).findFunctionDecl(argumentsTypes, returnType, callTree);
                        }
                    }
                    toBucket = toBucket.tail;
                }
            }
            if (resultDecl != null) continue;
            if (top) {
                curSymbolTable = null;
                continue;
            }
            curSymbolTable = curSymbolTable.basisSymbolTable();
        }
        if (resultDecl == null) {
            resultDecl = externalDecl;
        }
        if (resultDecl == null && oneResultDecl != null && !sameNumberOfArgs) {
            resultDecl = oneResultDecl;
        }
        if (TapEnv.traceTypeCheckAnalysis()) {
            TapEnv.setTraceIndent(TapEnv.traceIndent() - 2);
            TapEnv.indentOnTrace(TapEnv.traceIndent());
            TapEnv.printlnOnTrace("found " + resultDecl);
        }
        return (FunctionDecl)resultDecl;
    }

    private int nbArgsOf(FunctionTypeSpec fts) {
        return fts == null || fts.argumentsTypes == null ? -1 : fts.argumentsTypes.length;
    }

    private TapList<FunctionDecl> getAllPossibleTypedFunctionDecl(String name, TypeSpec returnType, TypeSpec[] argumentsTypes, SymbolTable currentSymbolTable, TapList<FunctionDecl> resultFunctionDecls, boolean checkArgsTypes, boolean top, boolean checkArgsNumber, boolean isBottomUpAnalysis, String className, boolean checkClassName) {
        String searchedName = name;
        int index = SymbolTable.hashKey(name);
        if (TapEnv.traceTypeCheckAnalysis()) {
            TapEnv.indentOnTrace(TapEnv.traceIndent());
            TapEnv.printlnOnTrace("getAllPossibleTypedFunctionDecl of " + name + " " + new FunctionTypeSpec((WrapperTypeSpec)returnType, (WrapperTypeSpec[])argumentsTypes) + " in " + currentSymbolTable.addressChain());
            TapEnv.setTraceIndent(TapEnv.traceIndent() + 2);
        }
        while (currentSymbolTable != null) {
            TapList<Unit> childrenClasses;
            TapList<SymbolDecl> toBucket;
            if (!currentSymbolTable.caseDependent) {
                searchedName = name.toLowerCase();
                index = SymbolTable.hashKey(searchedName);
            }
            if ((toBucket = currentSymbolTable.buckets[index]) != null) {
                while (toBucket.tail != null) {
                    SymbolDecl symbolDecl = (SymbolDecl)toBucket.tail.head;
                    if (symbolDecl.symbol.equals(searchedName) && symbolDecl.isA(3)) {
                        boolean matches = true;
                        if (checkClassName) {
                            boolean bl = className == null ? symbolDecl.className == null : (matches = className.equals(symbolDecl.className));
                        }
                        if (matches && checkArgsNumber) {
                            boolean bl = matches = ((FunctionDecl)symbolDecl).functionTypeSpec() != null && ((FunctionDecl)symbolDecl).functionTypeSpec().argumentsTypes.length == argumentsTypes.length;
                        }
                        if (matches && checkArgsTypes) {
                            if (TapEnv.traceTypeCheckAnalysis()) {
                                TapEnv.indentOnTrace(TapEnv.traceIndent());
                                TapEnv.printlnOnTrace("Testing matching function declaration " + symbolDecl + " of type " + ((FunctionDecl)symbolDecl).functionTypeSpec() + " against call " + new FunctionTypeSpec((WrapperTypeSpec)returnType, (WrapperTypeSpec[])argumentsTypes));
                            }
                            matches = ((FunctionDecl)symbolDecl).declarationMatchesCall(returnType, argumentsTypes);
                            if (TapEnv.traceTypeCheckAnalysis()) {
                                TapEnv.indentOnTrace(TapEnv.traceIndent());
                                TapEnv.printlnOnTrace("--> returns " + matches);
                            }
                        }
                        if (matches) {
                            resultFunctionDecls = new TapList<FunctionDecl>((FunctionDecl)symbolDecl, resultFunctionDecls);
                        }
                    }
                    toBucket = toBucket.tail;
                }
            }
            if (top) {
                currentSymbolTable = null;
                continue;
            }
            if (resultFunctionDecls != null && this.unit != null && this.unit.isFortran()) {
                currentSymbolTable = null;
                continue;
            }
            if (isBottomUpAnalysis) {
                currentSymbolTable = currentSymbolTable.basisSymbolTable();
                continue;
            }
            TapList<Unit> tapList = childrenClasses = currentSymbolTable.unit == null ? null : currentSymbolTable.unit.childrenClasses;
            while (childrenClasses != null) {
                resultFunctionDecls = this.getAllPossibleTypedFunctionDecl(name, returnType, argumentsTypes, ((Unit)childrenClasses.head).publicSymbolTable(), resultFunctionDecls, checkArgsTypes, false, checkArgsNumber, false, className, checkClassName);
                resultFunctionDecls = this.getAllPossibleTypedFunctionDecl(name, returnType, argumentsTypes, ((Unit)childrenClasses.head).protectedSymbolTable(), resultFunctionDecls, checkArgsTypes, false, checkArgsNumber, false, className, checkClassName);
                childrenClasses = childrenClasses.tail;
            }
            currentSymbolTable = null;
        }
        if (resultFunctionDecls != null && resultFunctionDecls.tail != null) {
            while (((FunctionDecl)resultFunctionDecls.head).isInterface() && resultFunctionDecls.tail != null) {
                resultFunctionDecls = resultFunctionDecls.tail;
            }
        }
        if (TapEnv.traceTypeCheckAnalysis()) {
            TapEnv.setTraceIndent(TapEnv.traceIndent() - 2);
            TapEnv.indentOnTrace(TapEnv.traceIndent());
            TapEnv.printlnOnTrace("getAllPossibleTypedFunctionDecl returns " + resultFunctionDecls);
        }
        return resultFunctionDecls;
    }

    public SymbolDecl getDecl(String name, int kind1, int kind2, boolean top, TapList<SymbolTable> toST) {
        TapList<SymbolDecl> toBucket = this.getToDecl(name, kind1, kind2, top, toST);
        if (toBucket != null) {
            return (SymbolDecl)toBucket.tail.head;
        }
        return null;
    }

    public SymbolDecl getDecl(String name, int kind1, int kind2, int kind3, boolean top) {
        TapList<SymbolDecl> toBucket = this.getToDecl(name, kind1, kind2, kind3, top, null);
        if (toBucket != null) {
            return (SymbolDecl)toBucket.tail.head;
        }
        return null;
    }

    public void removeDecl(String name, int kind, boolean top) {
        TapList<SymbolDecl> toBucket = this.getToDecl(name, kind, top, null);
        if (toBucket != null) {
            toBucket.tail = toBucket.tail.tail;
        }
    }

    public void removeInterfaceDecl(String name, int kind, boolean top) {
        TapList<SymbolDecl> toBucket = this.getToDecl(name, kind, top, null);
        if (toBucket != null) {
            toBucket.tail = toBucket.tail.tail;
        }
    }

    private TapList<SymbolDecl> getToDecl(String name, int kind, boolean top, TapList<SymbolTable> toST) {
        String searchedName = name;
        int index = SymbolTable.hashKey(name);
        SymbolTable curSymbolTable = this;
        boolean found = false;
        TapList<SymbolDecl> toBucket = null;
        while (!found && curSymbolTable != null) {
            if (!curSymbolTable.caseDependent) {
                searchedName = name.toLowerCase();
                index = SymbolTable.hashKey(searchedName);
            }
            if ((toBucket = curSymbolTable.buckets[index]) != null) {
                while (!found && toBucket.tail != null) {
                    SymbolDecl symbolDecl = (SymbolDecl)toBucket.tail.head;
                    if ((symbolDecl.isA(kind) || kind == 17 && symbolDecl.isA(3) && ((FunctionDecl)symbolDecl).unit() != null && (((FunctionDecl)symbolDecl).unit().isModule() || ((FunctionDecl)symbolDecl).unit().isUndefined()) || kind == -3 && symbolDecl.isA(3) && ((FunctionDecl)symbolDecl).unit() != null && !((FunctionDecl)symbolDecl).unit().isInterface() || kind == -4 && symbolDecl.isA(3) && ((FunctionDecl)symbolDecl).unit() != null && !((FunctionDecl)symbolDecl).unit().isInterface() && !((FunctionDecl)symbolDecl).unit().isExternal()) && symbolDecl.symbol.equals(searchedName)) {
                        found = true;
                        if (toST == null) continue;
                        toST.head = curSymbolTable;
                        continue;
                    }
                    toBucket = toBucket.tail;
                }
            }
            if (found) continue;
            toBucket = null;
            if (top) {
                curSymbolTable = null;
                continue;
            }
            curSymbolTable = curSymbolTable.basisSymbolTable();
        }
        return toBucket;
    }

    private TapList<SymbolDecl> getToDecl(String name, int kind1, int kind2, boolean top, TapList<SymbolTable> toST) {
        String searchedName = name;
        int index = SymbolTable.hashKey(name);
        SymbolTable curSymbolTable = this;
        boolean found = false;
        TapList<SymbolDecl> toBucket = null;
        while (!found && curSymbolTable != null) {
            if (!curSymbolTable.caseDependent) {
                searchedName = name.toLowerCase();
                index = SymbolTable.hashKey(searchedName);
            }
            if ((toBucket = curSymbolTable.buckets[index]) != null) {
                while (!found && toBucket.tail != null) {
                    SymbolDecl symbolDecl = (SymbolDecl)toBucket.tail.head;
                    if ((symbolDecl.isA(kind1) || symbolDecl.isA(kind2)) && symbolDecl.symbol.equals(searchedName)) {
                        found = true;
                        if (toST == null) continue;
                        toST.head = curSymbolTable;
                        continue;
                    }
                    toBucket = toBucket.tail;
                }
            }
            if (found) continue;
            toBucket = null;
            if (top) {
                curSymbolTable = null;
                continue;
            }
            curSymbolTable = curSymbolTable.basisSymbolTable();
        }
        return toBucket;
    }

    private TapList<SymbolDecl> getToDecl(String name, int kind1, int kind2, int kind3, boolean top, TapList<SymbolTable> toST) {
        String searchedName = name;
        int index = SymbolTable.hashKey(name);
        SymbolTable curSymbolTable = this;
        boolean found = false;
        TapList<SymbolDecl> toBucket = null;
        while (!found && curSymbolTable != null) {
            if (!curSymbolTable.caseDependent) {
                searchedName = name.toLowerCase();
                index = SymbolTable.hashKey(searchedName);
            }
            if ((toBucket = curSymbolTable.buckets[index]) != null) {
                while (!found && toBucket.tail != null) {
                    SymbolDecl symbolDecl = (SymbolDecl)toBucket.tail.head;
                    if ((symbolDecl.isA(kind1) || symbolDecl.isA(kind2) || symbolDecl.isA(kind3)) && symbolDecl.symbol.equals(searchedName)) {
                        found = true;
                        if (toST == null) continue;
                        toST.head = curSymbolTable;
                        continue;
                    }
                    toBucket = toBucket.tail;
                }
            }
            if (found) continue;
            toBucket = null;
            if (top) {
                curSymbolTable = null;
                continue;
            }
            curSymbolTable = curSymbolTable.basisSymbolTable();
        }
        return toBucket;
    }

    protected void addNewSymbolDecl(SymbolDecl symbolDecl) {
        this.buckets[SymbolTable.hashKey(symbolDecl.symbol)].placdl(symbolDecl);
    }

    public void addSymbolDecl(SymbolDecl symbolDecl) {
        TapList<SymbolDecl> targetBucket;
        TapList<SymbolDecl> toOldSymbolDecl;
        String symbolName;
        if (!this.caseDependent) {
            symbolDecl.symbol = symbolDecl.symbol.toLowerCase();
        }
        if (this.isFormalParam(symbolName = symbolDecl.symbol, toOldSymbolDecl = this.getToDecl(symbolName, 0, true, null))) {
            this.moveSymbolDeclListUpRec(symbolDecl.dependsOn(), this.basisSymbolTable);
            symbolDecl.recomputeDependsOn(this.basisSymbolTable);
            targetBucket = this.basisSymbolTable.buckets[SymbolTable.hashKey(symbolName)];
            toOldSymbolDecl = this.basisSymbolTable.getToDecl(symbolName, 0, true, null);
            ((SymbolDecl)targetBucket.tail.head).setInstruction(symbolDecl);
            if (this.unit.name.equals(symbolName)) {
                FunctionTypeSpec functionTypeSpec = this.unit.functionTypeSpec();
                WrapperTypeSpec returnType = functionTypeSpec.returnType;
                if (returnType.wrappedType == null) {
                    functionTypeSpec.returnType = symbolDecl.type().combineWith(returnType, this);
                }
            }
        } else {
            targetBucket = this.buckets[SymbolTable.hashKey(symbolName)];
        }
        if (toOldSymbolDecl == null || !this.combinesWith(toOldSymbolDecl, symbolDecl)) {
            targetBucket.placdl(symbolDecl);
        }
    }

    private boolean isFormalParam(String symbolName, TapList<SymbolDecl> toOldSymbolDecl) {
        if (toOldSymbolDecl == null && !this.isFormalParams && this.basisSymbolTable != null && this.basisSymbolTable.isFormalParams) {
            SymbolDecl symbolDeclAbove = this.basisSymbolTable.getTopSymbolDecl(symbolName);
            return symbolDeclAbove != null && (symbolDeclAbove.isA(1) || symbolDeclAbove.isA(5) || symbolDeclAbove.isA(3) || symbolDeclAbove.isA(16));
        }
        return false;
    }

    private boolean combinesWith(TapList<SymbolDecl> toTargetSymbolDecl, SymbolDecl newSymbolDecl) {
        SymbolDecl oldSymbolDecl = (SymbolDecl)toTargetSymbolDecl.tail.head;
        boolean oldIsExtern = oldSymbolDecl.isExtern();
        boolean newIsExtern = newSymbolDecl.isExtern();
        if (oldSymbolDecl.isExtern() && !newSymbolDecl.isExtern()) {
            oldSymbolDecl.setExtraInfo(TapList.cleanExtraInfoValue(oldSymbolDecl.extraInfo(), "extern"));
        } else if (newSymbolDecl.isExtern() && !oldSymbolDecl.isExtern()) {
            newSymbolDecl.setExtraInfo(TapList.cleanExtraInfoValue(newSymbolDecl.extraInfo(), "extern"));
        }
        newSymbolDecl.addExtraInfo(oldSymbolDecl.extraInfo());
        oldSymbolDecl.setExtraInfo(newSymbolDecl.extraInfo());
        String symbol = newSymbolDecl.symbol;
        if (newSymbolDecl.isA(1) && (newSymbolDecl.type() == null || newSymbolDecl.type().wrappedType == null) && (newSymbolDecl.isPrivate() || newSymbolDecl.isPublic())) {
            return true;
        }
        if (oldSymbolDecl.isA(1) || oldSymbolDecl.isA(5)) {
            VariableDecl oldVariableDecl = (VariableDecl)oldSymbolDecl;
            if (newSymbolDecl.isA(1) || newSymbolDecl.isA(5)) {
                VariableDecl newVariableDecl = (VariableDecl)newSymbolDecl;
                WrapperTypeSpec sumTypeSpec = oldVariableDecl.type().combineWith(newVariableDecl.type(), this);
                if (sumTypeSpec == null) {
                    if (this.unit != null && !this.unit.isC() || !TapEnv.inIncludeFile()) {
                        TapEnv.fileWarning(15, (Tree)newSymbolDecl.defPositions.head, "(DD01) Cannot combine successive declarations of variable " + symbol + ": " + oldVariableDecl.type().showType() + " and " + newVariableDecl.type().showType() + " (ignored new)");
                    }
                } else {
                    if (this.unit == null && !oldIsExtern && !newIsExtern || this.unit != null && this.unit.isC() && oldVariableDecl.type() == null) {
                        TapEnv.fileWarning(15, (Tree)newSymbolDecl.defPositions.head, "(DD06) Multiple definition of " + newSymbolDecl.symbol);
                    }
                    oldVariableDecl.setType(sumTypeSpec);
                    oldVariableDecl.dependsOn = TapList.prependNoDups(newSymbolDecl.dependsOn(), oldVariableDecl.dependsOn());
                }
                if (newSymbolDecl.isA(5) && !oldSymbolDecl.isA(5)) {
                    ((VariableDecl)oldSymbolDecl).setConstant();
                }
                if (oldVariableDecl.isReturnVarFromFunction != null) {
                    oldVariableDecl.isReturnVarFromFunction.functionTypeSpec().returnType = oldVariableDecl.isReturnVarFromFunction.functionTypeSpec().returnType.combineWith(newVariableDecl.type(), this);
                }
                newSymbolDecl.setInstruction(oldSymbolDecl);
                return true;
            }
            if (newSymbolDecl.isA(3)) {
                Unit newUnit = ((FunctionDecl)newSymbolDecl).unit();
                WrapperTypeSpec sumTypeSpec = null;
                if (newUnit.functionTypeSpec() != null) {
                    sumTypeSpec = oldVariableDecl.type().combineWith(newUnit.functionTypeSpec().returnType, this);
                }
                if (sumTypeSpec == null) {
                    if (newUnit.functionTypeSpec() != null) {
                        if (!TypeSpec.isA(oldVariableDecl.type(), 3)) {
                            TapEnv.fileWarning(15, (Tree)newSymbolDecl.defPositions.head, "(DD06) Cannot combine successive declarations of function " + symbol + " return type: " + oldVariableDecl.type().showType() + " and " + newUnit.functionTypeSpec().returnType.showType() + " (overwritten previous)");
                        }
                    } else if (!TypeSpec.isA(oldVariableDecl.type(), 3)) {
                        TapEnv.fileWarning(15, (Tree)newSymbolDecl.defPositions.head, "(DD06) Cannot combine successive declarations of " + symbol + " of type: " + oldVariableDecl.type().showType() + " and as a module " + newUnit.name + " (overwritten previous)");
                    }
                } else {
                    newUnit.functionTypeSpec().returnType = sumTypeSpec;
                    newSymbolDecl.dependsOn = TapList.prependNoDups(newSymbolDecl.dependsOn, oldVariableDecl.dependsOn());
                }
                ((FunctionDecl)newSymbolDecl).formalArgRank = ((VariableDecl)oldSymbolDecl).formalArgRank;
                toTargetSymbolDecl.tail.head = newSymbolDecl;
                newSymbolDecl.setInstruction(oldSymbolDecl);
                return true;
            }
            if (newSymbolDecl.isA(16)) {
                TapList<String> extraInfo = oldSymbolDecl.extraInfo();
                newSymbolDecl.addExtraInfo(extraInfo);
                ((InterfaceDecl)newSymbolDecl).formalArgRank = ((VariableDecl)oldSymbolDecl).formalArgRank;
                toTargetSymbolDecl.tail.head = newSymbolDecl;
                newSymbolDecl.setInstruction(oldSymbolDecl);
                return true;
            }
            TapEnv.fileWarning(15, (Tree)newSymbolDecl.defPositions.head, "(TC23) Symbol " + symbol + ", formerly used as a variable, now used for another object");
            return false;
        }
        if (oldSymbolDecl.isA(3)) {
            FunctionDecl oldFunctionDecl = (FunctionDecl)oldSymbolDecl;
            Unit oldUnit = oldFunctionDecl.unit();
            if (oldUnit != null && oldUnit.isUndefined()) {
                return false;
            }
            if (newSymbolDecl.isA(3)) {
                Unit newUnit = ((FunctionDecl)newSymbolDecl).unit();
                if (oldUnit == null) {
                    oldFunctionDecl.shareUnitFrom((FunctionDecl)newSymbolDecl);
                    newSymbolDecl.setInstruction(oldSymbolDecl);
                    return true;
                }
                if (newUnit == null) {
                    ((FunctionDecl)newSymbolDecl).shareUnitFrom(oldFunctionDecl);
                    return true;
                }
                if (oldUnit.functionTypeSpec() == null) {
                    oldUnit.setFunctionTypeSpec(newUnit.functionTypeSpec());
                    newSymbolDecl.setInstruction(oldSymbolDecl);
                    return true;
                }
                if (newUnit.isModule() || newUnit.isUndefined()) {
                    if (oldUnit.isIntrinsic()) {
                        return false;
                    }
                } else if (oldUnit.functionTypeSpec().argumentsTypes == null) {
                    if (newUnit.functionTypeSpec().argumentsTypes != null) {
                        int nbArgs = newUnit.functionTypeSpec().argumentsTypes.length;
                        WrapperTypeSpec[] newArgTypes = new WrapperTypeSpec[nbArgs];
                        for (int i = nbArgs - 1; i >= 0; --i) {
                            newArgTypes[i] = new WrapperTypeSpec(null);
                        }
                        oldUnit.functionTypeSpec().argumentsTypes = newArgTypes;
                    }
                } else if (newUnit.functionTypeSpec().argumentsTypes == null) {
                    int nbArgs = oldUnit.functionTypeSpec().argumentsTypes.length;
                    WrapperTypeSpec[] newArgTypes = new WrapperTypeSpec[nbArgs];
                    for (int i = nbArgs - 1; i >= 0; --i) {
                        newArgTypes[i] = new WrapperTypeSpec(null);
                    }
                    newUnit.functionTypeSpec().argumentsTypes = newArgTypes;
                }
                if (oldUnit.functionTypeSpec().equalsCompilDep(newUnit.functionTypeSpec())) {
                    if (oldUnit.isStandard() && newUnit.isStandard()) {
                        if (oldUnit != newUnit) {
                            TapEnv.fileWarning(15, (Tree)newSymbolDecl.defPositions.head, "(DD04) Double definition of procedure " + symbol + " (ignored new)");
                            ((FunctionDecl)newSymbolDecl).deleteUnitIfDifferent(oldFunctionDecl.unit(), this.getCallGraph());
                        }
                    } else if (oldUnit.isOutside() && newUnit.isStandard()) {
                        oldFunctionDecl.deleteUnitIfDifferent(newUnit, this.getCallGraph());
                        oldFunctionDecl.shareUnitFrom((FunctionDecl)newSymbolDecl);
                    } else {
                        ((FunctionDecl)newSymbolDecl).deleteUnitIfDifferent(oldFunctionDecl.unit(), this.getCallGraph());
                    }
                } else if (oldUnit.isExternal()) {
                    if (MPIcallInfo.isMessagePassingFunction(symbol, oldUnit.language())) {
                        return false;
                    }
                    TapEnv.printlnOnTrace(40, "SETP 3 prevDecl " + oldFunctionDecl + " unit:" + newUnit);
                    this.getCallGraph().setPreviousFunctionDeclAndNewUnit(oldFunctionDecl, newUnit);
                } else {
                    if (oldUnit.isIntrinsic() && (newUnit.isOutsideTBD() || newUnit.isIntrinsic() || newUnit.isStandard())) {
                        if (newUnit.isStandard()) {
                            TapEnv.fileWarning(15, (Tree)newSymbolDecl.defPositions.head, "(DD09) Incorrect use of intrinsic procedure name: " + symbol);
                        }
                        return false;
                    }
                    if (oldUnit.isStandard() && newUnit.isIntrinsic()) {
                        newSymbolDecl.setInstruction(oldSymbolDecl);
                        return false;
                    }
                    if (oldUnit.isVarFunction()) {
                        if (newUnit.isInterface() || newUnit.isExternal()) {
                            newSymbolDecl.setInstruction(oldSymbolDecl);
                            return false;
                        }
                        return false;
                    }
                    if (newUnit.isVarFunction()) {
                        if (oldUnit.isInterface()) {
                            newSymbolDecl.setInstruction(oldSymbolDecl);
                            return true;
                        }
                        return false;
                    }
                    if (!oldUnit.isInterface()) {
                        if (!(newUnit.isInterface() || newUnit.isIntrinsic() || newUnit.isOutsideTBD() || oldUnit.upperLevelUnit() != newUnit.upperLevelUnit())) {
                            if (oldUnit.language() != newUnit.language()) {
                                return false;
                            }
                            if (oldUnit.language() == 5) {
                                return false;
                            }
                            if (TapEnv.get().combineDeclMessagesSwitch) {
                                TapEnv.fileWarning(15, (Tree)newSymbolDecl.defPositions.head, "(DD05) Cannot combine successive declarations of procedure " + symbol + " (ignored new)");
                            }
                        }
                    } else {
                        return false;
                    }
                }
                newSymbolDecl.setInstruction(oldSymbolDecl);
                return true;
            }
            if (newSymbolDecl.isA(16)) {
                return false;
            }
            if (newSymbolDecl.isA(1) && oldUnit.functionTypeSpec() != null && (oldUnit.functionTypeSpec().returnType == null || oldUnit.functionTypeSpec().returnType.receivesNoInferenceNoVector(newSymbolDecl.type())) && oldUnit.functionTypeSpec().returnType.equalsCompilIndep(newSymbolDecl.type())) {
                if (!TypeSpec.isA(newSymbolDecl.type(), 3)) {
                    oldUnit.functionTypeSpec().returnType = newSymbolDecl.type();
                }
                newSymbolDecl.setInstruction(oldSymbolDecl);
                return true;
            }
            if (!oldUnit.isExternal() && newSymbolDecl.isA(1) && !TypeSpec.isA(newSymbolDecl.type(), 3) && !this.isAnAccessDecl(newSymbolDecl)) {
                TapEnv.fileWarning(15, null, "(DD06) Cannot combine successive declarations of function " + oldSymbolDecl.symbol + " return type: " + oldUnit.functionTypeSpec().returnType.showType() + " and " + newSymbolDecl + " (ignored new)");
            }
            newSymbolDecl.setInstruction(oldSymbolDecl);
            return true;
        }
        if (oldSymbolDecl.isA(16)) {
            if (newSymbolDecl.isA(16)) {
                TapEnv.fileWarning(15, (Tree)newSymbolDecl.defPositions.head, "(DD20) Cannot combine successive declarations of interface " + symbol + " (ignored new)");
            } else if (!newSymbolDecl.isA(3)) {
                if (this.isAnAccessDecl(newSymbolDecl)) {
                    return true;
                }
                TapEnv.fileWarning(15, (Tree)newSymbolDecl.defPositions.head, "(DD19) This combination of two declarations for symbol " + symbol + " is not implemented yet");
            }
        } else if (!oldSymbolDecl.isA(4) && !oldSymbolDecl.isA(18) || !newSymbolDecl.isA(3)) {
            if (this.isAnAccessDecl(newSymbolDecl)) {
                return true;
            }
            TapEnv.toolWarning(-1, "(DD19) This combination of two declarations for symbol " + symbol + " is not implemented yet old:" + oldSymbolDecl + " new:" + newSymbolDecl);
        }
        return false;
    }

    private boolean isAnAccessDecl(SymbolDecl newSymbolDecl) {
        return !(newSymbolDecl.type() != null && newSymbolDecl.type().wrappedType != null || !newSymbolDecl.isPrivate() && !newSymbolDecl.isPublic());
    }

    public NameSpaceDecl addNameSpaceDecl(String name, SymbolTable nameSpaceSymbolTable) {
        NameSpaceDecl nameSpaceDecl = new NameSpaceDecl(name, nameSpaceSymbolTable);
        this.addSymbolDecl(nameSpaceDecl);
        return nameSpaceDecl;
    }

    public TapList<WrapperTypeSpec> addVarDeclaration(Tree decl, Instruction instrDecl, boolean isATrueVariable, ToBool addInstruction) {
        SymbolTable sharingSymbolTable;
        SymbolTable hostSymbolTable;
        WrapperTypeSpec lhsTypeSpec;
        Tree typeTree;
        TapList<Object> paramTypeSpecList;
        TapList<Object> paramsTail = paramTypeSpecList = new TapList<Object>(null, null);
        TapList<Object> toTypeUsedSymbols = new TapList<Object>(null, null);
        TapList<Object> toInfos = new TapList<Object>(null, null);
        TapList<Object> toAccess = new TapList<Object>(null, null);
        ToBool isPointer = new ToBool(false);
        int declarationKind = 1;
        boolean declarationIsPrivate = false;
        Tree modifiers = decl.down(1);
        if (!ILUtils.isNullOrNone(modifiers)) {
            Tree[] modifiersList;
            for (Tree tree : modifiersList = modifiers.children()) {
                String modifierString = ILUtils.getIdentString(tree);
                if (modifierString == null) continue;
                toInfos.placdl(modifierString);
            }
        }
        if (toInfos.tail != null && "privateEnumElement".equals(toInfos.tail.head) && decl.down(2).opCode() == 136) {
            declarationIsPrivate = true;
            toInfos.tail = null;
        }
        if ((typeTree = decl.down(2)).opCode() == 53) {
            TapEnv.tapenadeExit(1);
        }
        if (typeTree.opCode() == 136) {
            lhsTypeSpec = null;
        } else {
            TapList<SymbolDecl> newSymbolDecls = null;
            if (typeTree.opCode() == 159 && typeTree.down(1).opCode() == 127) {
                newSymbolDecls = this.declareAllSymbolsIn(typeTree.down(1), typeTree.down(1), null, null, 1, true, false, instrDecl);
            } else if (typeTree.opCode() == 127) {
                newSymbolDecls = this.declareAllSymbolsIn(typeTree, typeTree, null, null, 1, true, false, instrDecl);
            }
            toTypeUsedSymbols = new TapList<Object>(null, newSymbolDecls);
            SymbolDecl.addUsedSymbolsInExpr(typeTree, toTypeUsedSymbols, this, null, false, true);
            lhsTypeSpec = TypeSpec.build(typeTree, this, instrDecl, toTypeUsedSymbols, toInfos, toAccess, isPointer, null);
            if (TypeSpec.isA(lhsTypeSpec, 21)) {
                TypeDecl definedTypeDecl = null;
                String typeSpecName = ILUtils.buildTypeName(typeTree);
                if (typeSpecName != null) {
                    definedTypeDecl = this.getTypeDecl(typeSpecName);
                }
                String typeDeclName = null;
                if (definedTypeDecl == null && (typeDeclName = ILUtils.buildTypeName(typeTree)) != null) {
                    definedTypeDecl = this.getTypeDecl(typeDeclName);
                }
                if (definedTypeDecl == null && typeDeclName != null) {
                    definedTypeDecl = new TypeDecl(typeDeclName, lhsTypeSpec);
                    this.addSymbolDecl(definedTypeDecl);
                    definedTypeDecl.setInstruction(instrDecl);
                }
            }
            declarationKind = this.analyzeModifiers(toInfos.tail);
            if (this.unit != null && toInfos.tail == null) {
                if (this.unit.fortranStuff() != null && this.unit.fortranStuff().publicPrivateDefault != null) {
                    toInfos.tail = new TapList<String>(this.unit.fortranStuff().publicPrivateDefault, null);
                } else if (!this.unit.privacy.isEmpty()) {
                    toInfos.tail = new TapList<String>(this.unit.privacy, null);
                }
            }
        }
        declarationIsPrivate = declarationIsPrivate || (this.unit == null || this.unit.isTranslationUnit()) && (TapList.containsEquals(toAccess.tail, "private") || TapList.containsEquals(toInfos.tail, "private"));
        boolean declarationIsExtern = TapList.containsEquals(toInfos.tail, "extern");
        if (this.unit != null && !this.unit.isTranslationUnit() && !declarationIsExtern) {
            hostSymbolTable = this;
            sharingSymbolTable = null;
        } else if (TapEnv.currentTranslationUnitSymbolTable() != null && declarationIsPrivate) {
            hostSymbolTable = this;
            sharingSymbolTable = null;
        } else if (instrDecl != null && instrDecl.isInStdCInclude()) {
            hostSymbolTable = this.getCallGraph().cRootSymbolTable();
            sharingSymbolTable = null;
        } else if (TapEnv.currentTranslationUnitSymbolTable() != null) {
            hostSymbolTable = this;
            sharingSymbolTable = this.getCallGraph().languageRootSymbolTable(this.language);
        } else {
            hostSymbolTable = this;
            sharingSymbolTable = null;
        }
        Tree[] declarators = decl.down(3).children();
        boolean containsOpNone = false;
        if (declarators.length == 0) {
            paramsTail = paramsTail.placdl(lhsTypeSpec);
        }
        for (int i = 0; i < declarators.length; ++i) {
            VariableDecl variableDecl;
            int symbolDeclKind;
            Tree initTree;
            WrapperTypeSpec copiedLhsTypeSpec = lhsTypeSpec == null || i + 1 == declarators.length ? lhsTypeSpec : (WrapperTypeSpec)lhsTypeSpec.copyStopOnComposite(null);
            Tree declaratorI = declarators[i];
            int opCode = declaratorI.opCode();
            if (opCode == 172) {
                paramsTail = paramsTail.placdl(new WrapperTypeSpec(new LabelTypeSpec()));
                continue;
            }
            if (opCode == 13 || opCode == 149) {
                declaratorI = declarators[i].down(1);
                initTree = declarators[i];
            } else {
                declaratorI = declarators[i];
                initTree = null;
            }
            TapPair<Tree, WrapperTypeSpec> declaratorAndType = new TapPair<Tree, WrapperTypeSpec>(declaratorI, copiedLhsTypeSpec);
            this.peelDeclaratorToIdent(declaratorAndType, instrDecl, new TapList<Object>(null, null));
            String symbolName = ILUtils.baseName((Tree)declaratorAndType.first);
            WrapperTypeSpec symbolTypeSpec = (WrapperTypeSpec)declaratorAndType.second;
            WrapperTypeSpec typeSpec = copiedLhsTypeSpec;
            SymbolDecl symbolDecl = null;
            SymbolDecl functionDecl = null;
            VariableDecl paramDecl = null;
            if (typeSpec != null && (opCode == 94 || opCode == 121)) {
                TapList<FunctionDecl> functionDecls = this.getTopFunctionDecl(symbolName, typeSpec, null, false);
                SymbolDecl symbolDecl2 = functionDecl = functionDecls == null ? null : (FunctionDecl)functionDecls.head;
                if (functionDecl == null) {
                    SymbolTable formalSymbolTable = this;
                    while (formalSymbolTable != null && !formalSymbolTable.isFormalParams) {
                        formalSymbolTable = formalSymbolTable.basisSymbolTable;
                    }
                    if (formalSymbolTable != null) {
                        functionDecls = formalSymbolTable.getTopFunctionDecl(symbolName, typeSpec, null, false);
                        SymbolDecl symbolDecl3 = functionDecl = functionDecls == null ? null : (FunctionDecl)functionDecls.head;
                        if (functionDecl == null) {
                            paramDecl = formalSymbolTable.getTopVariableDecl(symbolName);
                        }
                    }
                }
            }
            if (functionDecl != null) {
                functionDecl.setInstruction(instrDecl);
                if (((FunctionDecl)functionDecl).isExternal() || ((FunctionDecl)functionDecl).isIntrinsic() || ((FunctionDecl)functionDecl).isVarFunction()) {
                    if (isPointer.get()) {
                        typeSpec = new WrapperTypeSpec(new PointerTypeSpec(typeSpec, null));
                    }
                    if (((FunctionDecl)functionDecl).functionTypeSpec() == null) {
                        ((FunctionDecl)functionDecl).unit().setFunctionTypeSpec(new FunctionTypeSpec(typeSpec));
                    } else {
                        ((FunctionDecl)functionDecl).functionTypeSpec().setReturnTypeSpec(typeSpec, declaratorI);
                    }
                }
            }
            if (!(TypeSpec.isA(symbolTypeSpec, 3) && declaratorI.opCode() == 88 || declarationKind != 1 && declarationKind != 5)) {
                symbolDecl = SymbolDecl.build(typeSpec == null ? new WrapperTypeSpec(null) : typeSpec, toAccess.tail, isPointer.get(), declaratorI, declarationKind, this, instrDecl, toTypeUsedSymbols.tail);
            } else {
                Unit globalUnit;
                FunctionDecl globalFunctionDecl;
                SymbolTable curSymbolTable = this;
                TapList<FunctionDecl> globalFunctionDecls = null;
                while (curSymbolTable != null && globalFunctionDecls == null) {
                    globalFunctionDecls = curSymbolTable.getTopFunctionDecl(symbolName, null, null, null, false);
                    if (curSymbolTable.isFormalParams) {
                        paramDecl = curSymbolTable.getTopVariableDecl(symbolName);
                    }
                    if (paramDecl != null || declarationIsPrivate && curSymbolTable.isTranslationUnitSymbolTable()) {
                        curSymbolTable = null;
                        continue;
                    }
                    curSymbolTable = curSymbolTable.basisSymbolTable();
                }
                FunctionDecl functionDecl2 = globalFunctionDecl = globalFunctionDecls == null ? null : (FunctionDecl)globalFunctionDecls.head;
                if (globalFunctionDecl != null) {
                    globalUnit = globalFunctionDecl.unit();
                } else {
                    if (paramDecl != null) {
                        globalUnit = Unit.makeVarFunction(symbolName, this.unit);
                    } else {
                        this.addExternalOrForwardDeclaration(declaratorI, instrDecl, declarationIsPrivate);
                        if (declarationIsPrivate) {
                            globalFunctionDecls = this.getTopFunctionDecl(symbolName, null, null, null, false);
                        } else {
                            globalFunctionDecls = this.getCallGraph().languageRootSymbolTable(TapEnv.relatedLanguage()).getTopFunctionDecl(symbolName, null, null, null, false);
                            if (globalFunctionDecls == null) {
                                globalFunctionDecls = this.getCallGraph().globalRootSymbolTable().getTopFunctionDecl(symbolName, null, null, null, false);
                            }
                        }
                        globalFunctionDecl = (FunctionDecl)globalFunctionDecls.head;
                        globalUnit = globalFunctionDecl.unit();
                    }
                    if (TapEnv.inIncludeFile() && TapEnv.isStdCInclude(TapEnv.currentIncludeInstruction())) {
                        globalUnit.setInStdCIncludeFile();
                    }
                    FunctionTypeSpec functionType = TypeSpec.isA(symbolTypeSpec, 3) ? (FunctionTypeSpec)symbolTypeSpec.wrappedType : new FunctionTypeSpec(symbolTypeSpec);
                    globalUnit.setFunctionTypeSpec(functionType);
                }
                if (this.unit == globalUnit && this.unit.isC()) {
                    symbolDeclKind = 3;
                    TapEnv.fileWarning(15, decl, "(DD08) Procedure header ignored: " + this.unit.name);
                    if (TapEnv.currentIncludeInstruction() != null) {
                        TapEnv.get().expandAllIncludeFile = true;
                    }
                    addInstruction.set(false);
                } else {
                    symbolDecl = new FunctionDecl(ILUtils.baseTree(declaratorI), globalUnit);
                    symbolDecl.addExtraInfo(toAccess.tail);
                }
            }
            if (symbolDecl == null) continue;
            symbolDecl.addExtraInfo(toInfos.tail);
            symbolDeclKind = symbolDecl.kind;
            boolean isExtern = symbolDecl.isExtern();
            if (symbolDecl.hasModifier("value")) {
                this.unit.setLanguageAndUp(3);
            }
            SymbolDecl oldSymbolDecl = hostSymbolTable.getDecl(symbolName, symbolDeclKind, true);
            SymbolDecl newSymbolDecl = hostSymbolTable.getDecl(symbolName, symbolDeclKind, true);
            boolean oldIsExtern = oldSymbolDecl != null && oldSymbolDecl.isExtern();
            symbolDecl.setInstruction(instrDecl);
            hostSymbolTable.addSymbolDecl(symbolDecl);
            if (newSymbolDecl != null && newSymbolDecl != symbolDecl && !isExtern && !oldIsExtern) {
                newSymbolDecl.setInstruction(instrDecl);
            }
            if (this.basisSymbolTable == null && !isExtern && oldSymbolDecl != null && !oldIsExtern && newSymbolDecl != null) {
                decl.down(3).cutChild(i + 1);
                opCode = 136;
                containsOpNone = true;
            }
            paramsTail = paramsTail.placdl((symbolDeclKind == 3 ? ((FunctionDecl)symbolDecl).type() : symbolDecl.type()));
            if (symbolDeclKind == 5 || symbolDeclKind == 1) {
                variableDecl = (VariableDecl)symbolDecl;
                variableDecl.addExtraInfo(symbolDecl.extraInfo());
                boolean bl = variableDecl.isATrueSymbolDecl = isATrueVariable && !TapEnv.inStdCIncludeFile();
                if (initTree != null) {
                    if (this.unit == null || this.unit.isFortran() || this.unit.isCorMore() && variableDecl.isCconst()) {
                        if (variableDecl.initializationTree() != null) {
                            TapEnv.fileWarning(15, decl, "(DD06) Multiple definition of " + variableDecl.symbol + "=" + ILUtils.toString(variableDecl.initializationTree()) + " " + ILUtils.toString(initTree));
                        }
                        variableDecl.setInitializationTree(initTree);
                        if (variableDecl.type().isIntegerBase() || ILUtils.seemsInteger(initTree)) {
                            variableDecl.constantValue = this.computeIntConstant(initTree.down(2));
                        }
                    }
                    if (!WrapperTypeSpec.isFunctionOrPointerToFunction(variableDecl.type())) {
                        TapList<SymbolDecl> newSymbolDecls = this.declareAllSymbolsIn(initTree.down(2), initTree.down(2), null, null, 1, true, false, instrDecl);
                        variableDecl.dependsOn = TapList.prependNoDups(newSymbolDecls, variableDecl.dependsOn);
                    }
                    if (this.unit != null && this.unit.isFortran() && !TapList.containsEquals(variableDecl.extraInfo(), "constant") && variableDecl.kind != 5 && !this.isFormalParam(symbolName, this.getToDecl(symbolName, 0, true, null)) && !this.unit.isModule() && this == this.unit.privateSymbolTable()) {
                        this.unit.fortranStuff().computeSaveVarDecl(this, variableDecl);
                        variableDecl.addExtraInfo(new TapList<String>("save", null));
                    }
                }
                if (TapList.containsEquals(variableDecl.extraInfo(), "save") && !this.unit.isC()) {
                    this.unit.fortranStuff().computeSaveVarDecl(this, variableDecl);
                }
                if (this.unit != null && this.unit.isC() && this.isFormalParam(symbolName, this.getToDecl(symbolName, 0, true, null))) {
                    ILUtils.removeTreeDeclOf(symbolName, instrDecl.tree);
                }
            }
            if (sharingSymbolTable != null) {
                symbolDecl.setShared();
                if (symbolDeclKind == 1 || symbolDeclKind == 5) {
                    variableDecl = (VariableDecl)symbolDecl;
                    VariableDecl sharedDecl = (VariableDecl)sharingSymbolTable.getDecl(symbolName, 1, 5, true, null);
                    if (isExtern && variableDecl.getInitializationTree() != null) {
                        TapEnv.fileWarning(15, decl, "(DD06) " + variableDecl.symbol + " initialized and declared extern");
                    }
                    if (sharedDecl == null) {
                        sharedDecl = new VariableDecl(ILUtils.build(94, symbolName), variableDecl.type());
                        sharedDecl.setInitializationTree(variableDecl.getInitializationTree());
                        sharedDecl.constantValue = variableDecl.constantValue;
                        sharedDecl.adoptZones(variableDecl);
                        sharedDecl.isATrueSymbolDecl = variableDecl.isATrueSymbolDecl;
                        sharingSymbolTable.addSymbolDecl(sharedDecl);
                        if (isExtern) {
                            sharedDecl.addExtraInfo(new TapList<String>("extern", null));
                        }
                    } else {
                        if (variableDecl.isATrueSymbolDecl && !sharedDecl.isExtern() && !variableDecl.isExtern() && !isExtern) {
                            TapEnv.fileWarning(15, (Tree)variableDecl.defPositions.head, "(DD06) Multiple definition of " + variableDecl.symbol);
                        }
                        variableDecl.adoptZones(sharedDecl);
                        if (!isExtern) {
                            sharedDecl.setType(variableDecl.type());
                        }
                        if (sharedDecl.isExtern() && !isExtern) {
                            sharedDecl.setExtraInfo(TapList.cleanExtraInfoValue(sharedDecl.extraInfo(), "extern"));
                        }
                        if (sharedDecl.constantValue != null) {
                            variableDecl.constantValue = sharedDecl.constantValue;
                        }
                    }
                } else if (symbolDeclKind == 3) {
                    FunctionDecl sharedDecl;
                    Unit functionUnit = ((FunctionDecl)symbolDecl).unit();
                    TapList<FunctionDecl> existingDecls = sharingSymbolTable.getTopFunctionDecl(symbolName, null, null, null, false);
                    FunctionDecl functionDecl3 = sharedDecl = existingDecls == null ? null : (FunctionDecl)existingDecls.head;
                    if (sharedDecl == null) {
                        if (functionUnit == null) {
                            functionUnit = this.buildExternalUnit(symbolName, false);
                            ((FunctionDecl)symbolDecl).setUnit(functionUnit);
                        }
                        sharedDecl = new FunctionDecl(ILUtils.build(94, symbolName), functionUnit);
                        sharedDecl.shareUnitFrom((FunctionDecl)symbolDecl);
                        sharedDecl.setZones(symbolDecl.zones());
                        sharedDecl.isATrueSymbolDecl = symbolDecl.isATrueSymbolDecl;
                        sharingSymbolTable.addSymbolDecl(sharedDecl);
                    } else {
                        if (functionUnit != null && functionUnit != sharedDecl.unit()) {
                            Unit mergedUnit = sharedDecl.unit();
                            mergedUnit.absorb(functionUnit);
                            sharedDecl.setUnit(mergedUnit);
                            this.getCallGraph().deleteUnit(functionUnit);
                        }
                        ((FunctionDecl)symbolDecl).shareUnitFrom(sharedDecl);
                    }
                }
            }
            if (!this.isAFunctionDeclarator(declaratorI) || symbolDecl.isA(1) && (TypeSpec.isA(symbolDecl.type(), 6) || TypeSpec.isA(symbolDecl.type(), 2))) continue;
            VariableDecl funVarDecl = this.getVariableDecl(symbolName);
            FunctionDecl varFunDecl = hostSymbolTable.addFunctionDeclarator(decl, typeSpec, declarators[i], this, toTypeUsedSymbols.tail, instrDecl, declarationIsPrivate);
            if (varFunDecl == null) continue;
            if (varFunDecl.isVarFunction() && funVarDecl != null && TypeSpec.isA(funVarDecl.type(), 6)) {
                varFunDecl.unit().setFunctionTypeSpec((FunctionTypeSpec)((PointerTypeSpec)funVarDecl.type().wrappedType).destinationType.wrappedType);
            }
            if (opCode != 13) continue;
            Tree[] initializers = initTree.down(2).opCode() == 9 ? initTree.down(2).children() : new Tree[]{initTree.down(2)};
            varFunDecl.initFunctionDecls = new FunctionDecl[initializers.length];
            for (int j = 0; j < initializers.length; ++j) {
                String initName = ILUtils.baseName(initializers[j]);
                FunctionDecl initFD = null;
                if (initName != null) {
                    TapList<FunctionDecl> initFDs = this.getFunctionDecl(initName, null, null, false);
                    initFD = initFDs == null ? null : (FunctionDecl)initFDs.head;
                }
                varFunDecl.initFunctionDecls[j] = initFD;
                if (initFD != null) continue;
                TapEnv.fileWarning(15, decl, "(TC94) Incorrect initialization of function " + symbolName);
            }
        }
        if (containsOpNone) {
            for (int k = decl.down(3).length(); k > 0; --k) {
                if (decl.down(3).down(k).opCode() != 136) continue;
                decl.down(3).removeChild(k);
            }
            if (addInstruction != null && decl.down(3).length() == 0) {
                addInstruction.set(false);
            }
        }
        return paramTypeSpecList.tail;
    }

    public boolean isAnAllocatablePointer(Tree expression, Instruction refInstruction) {
        TapIntList lz = this.listOfZonesOfValue(expression, null, refInstruction);
        boolean isAllocatable = false;
        while (lz != null && !isAllocatable) {
            ZoneInfo zoneInfo = DataFlowAnalyzer.extendedDeclaredToZoneInfo(lz.head, this, null);
            if (zoneInfo != null) {
                isAllocatable = zoneInfo.isAllocatable;
            }
            lz = lz.tail;
        }
        if (isAllocatable && TapEnv.modeIsAdjoint()) {
            TapEnv.toolWarning(-1, "(SymbolTable) cannot manage allocatable array " + ILUtils.toString(expression) + " not implemented yet");
        }
        return isAllocatable;
    }

    public SymbolDecl getSymbolDecl(Tree tree) {
        SymbolDecl result = null;
        switch (tree.opCode()) {
            case 73: {
                WrapperTypeSpec rootTypeSpec = this.typeOf(tree.down(1));
                int fieldRank = ILUtils.getFieldRank(tree.down(2));
                if (fieldRank != -1) {
                    result = ((CompositeTypeSpec)rootTypeSpec.wrappedType).fields[fieldRank];
                    break;
                }
                TapEnv.toolError("getSymbolDecl " + ILUtils.toString(tree));
                break;
            }
            case 8: {
                break;
            }
            case 148: {
                result = this.getSymbolDecl(tree.down(1));
                break;
            }
            case 94: {
                String baseName = ILUtils.baseName(tree);
                result = this.getVariableDecl(baseName);
                break;
            }
        }
        return result;
    }

    public boolean isAllocatable(Tree assignedVar, String modifier) {
        boolean result = false;
        SymbolDecl symbolDecl = this.getSymbolDecl(assignedVar);
        if (symbolDecl != null) {
            result = symbolDecl.hasModifier(modifier);
        } else {
            NewSymbolHolder newSH = NewSymbolHolder.getNewSymbolHolder(assignedVar);
            if (newSH != null && newSH.newVariableDecl() != null) {
                result = newSH.newVariableDecl().hasModifier(modifier);
            }
        }
        return result;
    }

    public boolean isAllocatableAndTarget(Tree assignedVar) {
        return this.isAllocatable(assignedVar, "allocatable") && this.isAllocatable(assignedVar, "target");
    }

    private boolean isAFunctionDeclarator(Tree declarator) {
        int opCode = declarator.opCode();
        return opCode == 88 || opCode == 150 && this.isAFunctionDeclarator(declarator.down(1)) || opCode == 13 && this.isAFunctionDeclarator(declarator.down(1));
    }

    private int analyzeModifiers(TapList<String> modifiers) {
        if (TapList.containsEquals(modifiers, "external")) {
            return 3;
        }
        if (TapList.containsEquals(modifiers, "constant")) {
            return 5;
        }
        return 1;
    }

    private void peelDeclaratorToIdent(TapPair<Tree, WrapperTypeSpec> declaratorAndType, Instruction instrDecl, TapList<SymbolDecl> toTypeUsedSymbols) {
        Tree declarator = (Tree)declaratorAndType.first;
        WrapperTypeSpec typeSpec = (WrapperTypeSpec)declaratorAndType.second;
        block8: while (declarator != null) {
            switch (declarator.opCode()) {
                case 150: {
                    typeSpec = new WrapperTypeSpec(new PointerTypeSpec(typeSpec, null));
                    declarator = declarator.down(1);
                    continue block8;
                }
                case 88: {
                    WrapperTypeSpec[] argumentsTypes;
                    ToBool isVariableArgList = new ToBool(false);
                    if (ILUtils.isNullOrNoneOrEmptyList(declarator.down(2)) || declarator.down(2).down(1) != null && declarator.down(2).down(1).opCode() == 199) {
                        argumentsTypes = null;
                    } else {
                        TapList<WrapperTypeSpec> argList = SymbolDecl.buildTypeSpecFromArgs(this, instrDecl, toTypeUsedSymbols, declarator.down(2).children(), isVariableArgList);
                        argumentsTypes = new WrapperTypeSpec[TapList.length(argList)];
                        for (int i = TapList.length(argList) - 1; i >= 0; --i) {
                            argumentsTypes[i] = (WrapperTypeSpec)argList.head;
                            argList = argList.tail;
                        }
                    }
                    FunctionTypeSpec newFunctionTypeSpec = new FunctionTypeSpec(typeSpec, argumentsTypes, isVariableArgList.get());
                    typeSpec = new WrapperTypeSpec(newFunctionTypeSpec);
                    declarator = declarator.down(1);
                    continue block8;
                }
                case 10: {
                    Tree[] dimDecls = declarator.down(2).children();
                    ArrayDim[] dims = new ArrayDim[dimDecls.length];
                    String identNext = ILUtils.getIdentString(declarator.down(1));
                    for (int i = dimDecls.length - 1; i >= 0; --i) {
                        dims[i] = new ArrayDim(dimDecls[i], null, null, identNext == null ? null : declarator.down(1), i + 1, dimDecls.length, 1);
                    }
                    typeSpec = new WrapperTypeSpec(new ArrayTypeSpec(typeSpec, dims));
                    declarator = declarator.down(1);
                    continue block8;
                }
                case 126: {
                    TapPair<Object, Object> sizeAndDims = new TapPair<Object, Object>(null, null);
                    TapList<Object> toSymbolDeclInfos = new TapList<Object>(null, null);
                    TapList<Object> toSymbolDeclAccess = new TapList<Object>(null, null);
                    ToBool isPointer = new ToBool(false);
                    int typeSign = TypeSpec.dispatchModifiers(declarator.down(1).children(), declarator.down(2), sizeAndDims, isPointer, toSymbolDeclInfos, toSymbolDeclAccess, toTypeUsedSymbols, declarator, instrDecl, this);
                    if (sizeAndDims.first != null || typeSign != 0) {
                        ModifiedTypeSpec modifiedType = new ModifiedTypeSpec(typeSpec, (Tree)sizeAndDims.first, this);
                        modifiedType.typeSign = typeSign;
                        typeSpec = new WrapperTypeSpec(modifiedType);
                    }
                    if (sizeAndDims.second != null) {
                        typeSpec = new WrapperTypeSpec(new ArrayTypeSpec(typeSpec, (ArrayDim[])sizeAndDims.second));
                    }
                    declarator = declarator.down(2);
                    continue block8;
                }
                case 170: {
                    typeSpec = new WrapperTypeSpec(new ModifiedTypeSpec(typeSpec, declarator.down(2), this));
                    declarator = declarator.down(1);
                    continue block8;
                }
                case 94: 
                case 121: 
                case 136: {
                    declaratorAndType.first = declarator;
                    declaratorAndType.second = typeSpec;
                    declarator = null;
                    continue block8;
                }
            }
            TapEnv.toolWarning(10, "(Analyze function declarator) Unexpected operator:" + declarator.opName());
            declaratorAndType.first = ILUtils.baseTree(declarator);
            declaratorAndType.second = typeSpec;
            declarator = null;
        }
    }

    private FunctionDecl addFunctionDeclarator(Tree decl, WrapperTypeSpec typeSpec, Tree declaratorI, SymbolTable refSymbolTable, TapList<SymbolDecl> typeUsedSymbols, Instruction instrDecl, boolean isPrivate) {
        TapList<FunctionDecl> functionDecls;
        WrapperTypeSpec resultType;
        TypeSpec[] argumentsTypes;
        FunctionDecl functionDecl = null;
        int opCode = declaratorI.opCode();
        Tree declarator = declaratorI;
        if (opCode == 13) {
            declarator = declarator.down(1);
        }
        TapList<SymbolDecl> toTypeUsedSymbols = new TapList<SymbolDecl>(null, typeUsedSymbols);
        TapPair<Tree, WrapperTypeSpec> declaratorAndType = new TapPair<Tree, WrapperTypeSpec>(declarator, typeSpec);
        refSymbolTable.peelDeclaratorToIdent(declaratorAndType, instrDecl, toTypeUsedSymbols);
        declarator = (Tree)declaratorAndType.first;
        typeSpec = (WrapperTypeSpec)declaratorAndType.second;
        if (TypeSpec.isA(typeSpec, 6) && TypeSpec.isA(((PointerTypeSpec)typeSpec.wrappedType).destinationType, 3)) {
            FunctionTypeSpec functionType = (FunctionTypeSpec)((PointerTypeSpec)typeSpec.wrappedType).destinationType.wrappedType;
            argumentsTypes = functionType.argumentsTypes;
            resultType = functionType.returnType;
        } else if (TypeSpec.isA(typeSpec, 3)) {
            argumentsTypes = ((FunctionTypeSpec)typeSpec.wrappedType).argumentsTypes;
            resultType = ((FunctionTypeSpec)typeSpec.wrappedType).returnType;
        } else {
            argumentsTypes = null;
            resultType = typeSpec;
        }
        TapList<FunctionDecl> tmpFunctionDecls = functionDecls = this.getFunctionDecl(declarator.stringValue(), resultType, argumentsTypes, true);
        while (tmpFunctionDecls != null && functionDecl == null) {
            functionDecl = (FunctionDecl)tmpFunctionDecls.head;
            if (functionDecl.className != null && functionDecl.className.equals(this.unit.name) && functionDecl.unit() != null && functionDecl.unit().isUndefined()) {
                Unit functionUnit = functionDecl.unit();
                functionUnit.setUpperLevelUnit(this.unit);
                functionUnit.publicSymbolTable().setBasisSymbolTable(this.unit.privateSymbolTable());
                functionUnit.setKind(3);
            } else {
                functionDecl = null;
            }
            tmpFunctionDecls = tmpFunctionDecls.tail;
        }
        FunctionDecl functionDecl2 = functionDecl = functionDecls == null ? null : (FunctionDecl)functionDecls.head;
        if (functionDecl != null && functionDecl.unit().isFortran() && functionDecl.isIntrinsic()) {
            functionDecl = null;
        }
        if (!(functionDecl != null || this.unit != null && this.unit.isClass())) {
            this.addExternalOrForwardDeclaration(declarator, instrDecl, isPrivate);
            functionDecls = this.getFunctionDecl(ILUtils.baseName(declarator), resultType, argumentsTypes, true);
            if (functionDecls == null) {
                functionDecls = this.getFunctionDecl(ILUtils.baseName(declarator), resultType, null, false);
            }
            functionDecl = (FunctionDecl)functionDecls.head;
            functionDecl.isATrueSymbolDecl = !TapEnv.inStdCIncludeFile();
            functionDecl.setInstruction(instrDecl);
            SymbolTable newPublicSymbolTable = new SymbolTable(this);
            newPublicSymbolTable.unit = functionDecl.unit();
            newPublicSymbolTable.setCaseDependent(!functionDecl.unit().isFortran());
            newPublicSymbolTable.declareFormalParamsLevel();
            functionDecl.unit().addDerivedSymbolTable(newPublicSymbolTable);
            functionDecl.unit().setPublicSymbolTable(newPublicSymbolTable);
            functionDecl.unit().publicSymbolTable().setShortName("Formal params SymbolTable of external " + declarator);
            functionDecl.declarator = decl;
            if (TapEnv.inIncludeFile() && TapEnv.isStdCInclude(TapEnv.currentIncludeInstruction())) {
                functionDecl.unit().setInStdCIncludeFile();
            }
        } else if (!(functionDecl == null || this.unit != null && this.unit.isCPlusPlus())) {
            FunctionTypeSpec newFunctionTypeSpec = new FunctionTypeSpec(resultType, (WrapperTypeSpec[])argumentsTypes);
            boolean forwardDefCorrect = functionDecl.functionTypeSpec().receives(newFunctionTypeSpec, null, null);
            if (!forwardDefCorrect) {
                TapEnv.fileWarning(15, decl, "(DD06) Cannot combine successive declarations of function " + functionDecl.symbol + " " + functionDecl.functionTypeSpec().showType() + " and " + newFunctionTypeSpec.showType() + " (ignored new)");
            }
            if (TapEnv.inIncludeFile() && TapEnv.isStdCInclude(TapEnv.currentIncludeInstruction())) {
                functionDecl.unit().setInStdCIncludeFile();
            }
        }
        if (functionDecl != null && opCode == 13) {
            SymbolDecl.addUsedSymbolsInExpr(declaratorI.down(2), toTypeUsedSymbols, this, null, false, true);
            functionDecl.dependsOn = TapList.prependNoDups(toTypeUsedSymbols.tail, functionDecl.dependsOn);
        }
        return functionDecl;
    }

    public void addVarDimDeclaration(Tree decl, Instruction instrDecl) {
        boolean isPointer = false;
        TapList<SymbolDecl> newSymbolDecls = null;
        Tree[] declarators = decl.children();
        for (int i = 0; i < declarators.length; ++i) {
            if (declarators[i].opCode() == 10) {
                newSymbolDecls = this.declareAllSymbolsIn(declarators[i].down(2), declarators[i].down(2), null, null, 1, true, true, instrDecl);
            } else {
                TapEnv.fileWarning(15, decl, "(DD30) Incorrect dimension statement");
            }
            TapList<Object> toTypeUsedSymbols = new TapList<Object>(null, newSymbolDecls);
            SymbolDecl.addUsedSymbolsInExpr(decl.down(1), toTypeUsedSymbols, this, null, false, true);
            String name = ILUtils.baseName(declarators[i]);
            VariableDecl varDecl = this.getTopVariableDecl(name);
            if (varDecl != null) {
                isPointer = TypeSpec.isA(varDecl.type(), 6);
            }
            SymbolDecl symbolDecl = SymbolDecl.build(new WrapperTypeSpec(null), null, isPointer, declarators[i], 1, this, instrDecl, toTypeUsedSymbols.tail);
            this.addSymbolDecl(symbolDecl);
            SymbolDecl newSymbolDecl = this.getDecl(symbolDecl.symbol, symbolDecl.kind, false);
            if (newSymbolDecl == null) continue;
            newSymbolDecl.setInstruction(instrDecl);
        }
    }

    public void addAllocatableDeclaration(Tree decl, Instruction instrDecl) {
        TapList<SymbolDecl> newSymbolDecls = null;
        Tree[] declarators = decl.down(2).children();
        for (int i = 0; i < declarators.length; ++i) {
            if (declarators[i].opCode() == 10) {
                newSymbolDecls = this.declareAllSymbolsIn(declarators[i].down(2), declarators[i].down(2), null, decl.down(1), 1, true, true, instrDecl);
            } else {
                TapEnv.toolWarning(-1, "It is clearer to specify dimensions on the type declaration statements");
            }
            TapList<Object> toTypeUsedSymbols = new TapList<Object>(null, newSymbolDecls);
            SymbolDecl.addUsedSymbolsInExpr(decl.down(1), toTypeUsedSymbols, this, null, false, true);
            SymbolDecl symbolDecl = SymbolDecl.build(new WrapperTypeSpec(null), null, false, declarators[i], 1, this, instrDecl, toTypeUsedSymbols.tail);
            this.addSymbolDecl(symbolDecl);
            SymbolDecl newSymbolDecl = this.getDecl(symbolDecl.symbol, symbolDecl.kind, false);
            if (newSymbolDecl == null) continue;
            this.wrapPointerType(decl.down(1), newSymbolDecl);
            newSymbolDecl.setInstruction(instrDecl);
        }
    }

    public void addTypeDeclaration(Tree typeNameTree, Tree typeDef, Instruction instrDecl, TapList<String> modifiers) {
        String typeName2;
        String typeName1;
        TapList<Object> toTypeUsedSymbols = new TapList<Object>(null, null);
        TapList<Object> toInfos = new TapList<Object>(null, null);
        ToBool isPointer = new ToBool(false);
        WrapperTypeSpec typeSpec = TypeSpec.build(typeDef, this, instrDecl, toTypeUsedSymbols, toInfos, new TapList<Object>(null, null), isPointer, null);
        if (isPointer.get()) {
            typeSpec = new WrapperTypeSpec(new PointerTypeSpec(typeSpec, null));
        }
        if (toInfos.tail == null && this.unit != null && this.unit.fortranStuff() != null && this.unit.fortranStuff().publicPrivateDefault != null) {
            toInfos.tail = new TapList<String>(this.unit.fortranStuff().publicPrivateDefault, null);
        }
        toInfos = toInfos.tail;
        if (instrDecl.isInStdCInclude()) {
            String compositeName;
            TypeSpec declaredType = typeSpec;
            while (declaredType instanceof WrapperTypeSpec) {
                declaredType = declaredType.wrappedType;
            }
            if (declaredType instanceof CompositeTypeSpec && ("struct _IO_FILE".equals(compositeName = ((CompositeTypeSpec)declaredType).name) || "struct _IO_FILE_plus".equals(compositeName) || "struct _IO_lock_t".equals(compositeName) || "struct _IO_jump_t".equals(compositeName) || "struct _IO_marker".equals(compositeName) || "_IO_FILE".equals(compositeName) || "_IO_FILE_plus".equals(compositeName) || "_IO_lock_t".equals(compositeName) || "_IO_jump_t".equals(compositeName) || "_IO_marker".equals(compositeName))) {
                ((CompositeTypeSpec)declaredType).isAnIOType = true;
            }
        }
        String string = typeName1 = typeNameTree == null ? null : ILUtils.getIdentString(typeNameTree);
        if (typeName1 != null) {
            this.addOneTypeDeclaration(typeName1, typeDef, instrDecl, typeSpec, toTypeUsedSymbols.tail, toInfos, modifiers);
        }
        if ((typeName2 = ILUtils.buildTypeName(typeDef)) == null && typeName1 == null && typeDef.opCode() == 66) {
            typeName2 = "enum null";
        }
        if (typeName2 != null) {
            this.addOneTypeDeclaration(typeName2, typeDef, instrDecl, typeSpec, toTypeUsedSymbols.tail, toInfos, modifiers);
        }
    }

    private void addOneTypeDeclaration(String typeName, Tree typeDef, Instruction instrDecl, WrapperTypeSpec typeSpec, TapList<SymbolDecl> typeUsedSymbols, TapList<String> infos, TapList<String> modifiers) {
        if (!this.caseDependent) {
            typeName = typeName.toLowerCase();
        }
        TapList<SymbolDecl> bucket = this.buckets[SymbolTable.hashKey(typeName)];
        TypeDecl oldDecl = this.getTopTypeDecl(typeName);
        SymbolDecl oldSymbolDecl = this.getTopSymbolDecl(typeName);
        String name1 = null;
        if (oldDecl == null && (name1 = ILUtils.typeName(typeDef)) != null) {
            oldDecl = this.getTopTypeDecl(name1);
            if (oldSymbolDecl == null) {
                oldSymbolDecl = this.getTopSymbolDecl(name1);
            }
        }
        if (oldDecl == null) {
            if (oldSymbolDecl != null) {
                this.removeDecl(typeName, 0, false);
            }
            TypeDecl typeDecl = new TypeDecl(typeName, typeSpec);
            if (infos != null) {
                typeDecl.addExtraInfo(infos);
            }
            if (modifiers != null && (modifiers.head != null || modifiers.tail != null)) {
                typeDecl.addExtraInfo(modifiers);
            }
            typeDecl.dependsOn = TapList.prependNoDups(typeUsedSymbols, typeDecl.dependsOn());
            typeDecl.isATrueSymbolDecl = !TapEnv.inStdCIncludeFile();
            typeDecl.setInstruction(instrDecl);
            if (oldSymbolDecl != null) {
                typeDecl.addExtraInfo(oldSymbolDecl.extraInfo());
            }
            bucket.placdl(typeDecl);
        } else if (TypeSpec.isA(oldDecl.typeSpec.wrappedType, 11)) {
            TapList<TapPair<Unit, String>> oldNames = oldDecl.typeSpec.wrappedType.typeDeclNames();
            oldDecl.typeSpec.wrappedType = typeSpec.wrappedType;
            oldDecl.typeSpec.wrappedType.setTypeDeclNames(oldNames);
            if (oldDecl.getTypeDeclName() == null) {
                oldDecl.setTypeDeclName(typeName);
            }
            oldDecl.dependsOn = TapList.prependNoDups(typeUsedSymbols, oldDecl.dependsOn());
            oldDecl.isATrueSymbolDecl = !TapEnv.inStdCIncludeFile();
            oldDecl.setInstruction(instrDecl);
            if (oldSymbolDecl != null) {
                oldDecl.addExtraInfo(oldSymbolDecl.extraInfo());
            }
            oldDecl.addExtraInfo(modifiers);
            if (name1 != null) {
                oldDecl.symbol = typeName;
            } else if (this.unit == null || this.unit.isC()) {
                TapEnv.fileWarning(45, typeDef, "(TC47) Definition of type " + typeName + " comes a little too late");
            }
        } else if (TypeSpec.isA(typeSpec, 21) && TypeSpec.isA(oldDecl.typeSpec.wrappedType, 21)) {
            if (((CompositeTypeSpec)oldDecl.typeSpec.wrappedType).fields.length == 0) {
                String oldName = oldDecl.typeSpec.wrappedType.typeDeclName();
                TapList<TapPair<Unit, String>> oldNames = oldDecl.typeSpec.wrappedType.typeDeclNames();
                oldDecl.typeSpec.wrappedType = typeSpec.wrappedType;
                oldDecl.typeSpec.wrappedType.setTypeDeclNames(oldNames);
                oldDecl.setTypeDeclName(oldName);
                oldDecl.dependsOn = TapList.prependNoDups(typeUsedSymbols, oldDecl.dependsOn());
                oldDecl.isATrueSymbolDecl = !TapEnv.inStdCIncludeFile();
                oldDecl.setInstruction(instrDecl);
                if (oldSymbolDecl != null) {
                    oldDecl.addExtraInfo(oldSymbolDecl.extraInfo());
                }
                oldDecl.addExtraInfo(modifiers);
            } else if (oldDecl.typeSpec != typeSpec && (this.unit != null && !this.unit.isC() || !TapEnv.inIncludeFile())) {
                TapEnv.fileWarning(15, typeDef, "(DD12) Cannot combine successive declarations of type " + typeName + " (ignored new)");
            }
        } else if (TypeSpec.isA(typeSpec, 12) && TypeSpec.isA(oldDecl.typeSpec.wrappedType, 12)) {
            if (typeName.equals("enum null") && oldDecl.symbol.equals("enum null")) {
                if (oldSymbolDecl != null) {
                    this.removeDecl(typeName, 0, false);
                }
                TypeDecl typeDecl = new TypeDecl(typeName, typeSpec);
                if (infos != null) {
                    typeDecl.addExtraInfo(infos);
                }
                if (modifiers != null && (modifiers.head != null || modifiers.tail != null)) {
                    typeDecl.addExtraInfo(modifiers);
                }
                typeDecl.dependsOn = TapList.prependNoDups(typeUsedSymbols, typeDecl.dependsOn());
                typeDecl.isATrueSymbolDecl = !TapEnv.inStdCIncludeFile();
                typeDecl.setInstruction(instrDecl);
                if (oldSymbolDecl != null) {
                    typeDecl.addExtraInfo(oldSymbolDecl.extraInfo());
                }
                bucket.placdl(typeDecl);
            } else if (oldDecl.typeSpec != typeSpec && (this.unit != null && !this.unit.isC() || !TapEnv.inIncludeFile())) {
                TapEnv.fileWarning(15, typeDef, "(DD12) Cannot combine successive declarations of type " + typeName + " (ignored new)");
            }
        } else if (this.unit != null && !this.unit.isC() || !TapEnv.inIncludeFile()) {
            TapEnv.fileWarning(15, typeDef, "(DD12) Cannot combine successive declarations of type " + typeName + " (ignored new)");
        }
    }

    public void addConstDeclaration(Tree decl, Instruction instrDecl) {
        Tree[] declarators = decl.down(2).children();
        for (int i = 0; i < declarators.length; ++i) {
            Tree initTree;
            Tree declarator;
            TapList<Object> toInfos = new TapList<Object>(null, null);
            ToBool isPointer = new ToBool(false);
            TapList<Object> toTypeUsedSymbols = new TapList<Object>(null, null);
            WrapperTypeSpec typeSpec = TypeSpec.build(decl.down(1), this, instrDecl, toTypeUsedSymbols, toInfos, new TapList<Object>(null, null), isPointer, null);
            if (toInfos.tail == null && this.unit.fortranStuff().publicPrivateDefault != null) {
                toInfos.tail = new TapList<String>(this.unit.fortranStuff().publicPrivateDefault, null);
            }
            if (declarators[i].opCode() == 13) {
                declarator = declarators[i].down(1);
                initTree = declarators[i];
            } else {
                declarator = declarators[i];
                initTree = null;
            }
            String varName = ILUtils.getIdentString(declarator);
            VariableDecl oldVariableDecl = this.getVariableDecl(varName);
            if (oldVariableDecl == null) {
                SymbolDecl symbolDecl = SymbolDecl.build(typeSpec, null, isPointer.get(), declarators[i], 5, this, instrDecl, toTypeUsedSymbols.tail);
                symbolDecl.addExtraInfo(toInfos.tail);
                symbolDecl.isATrueSymbolDecl = !TapEnv.inStdCIncludeFile();
                this.addSymbolDecl(symbolDecl);
                symbolDecl.setInstruction(instrDecl);
                oldVariableDecl = this.getConstantDecl(varName);
            } else {
                if (typeSpec.wrappedType == null) {
                    typeSpec = oldVariableDecl.type();
                } else if (oldVariableDecl.type().wrappedType != null) {
                    TapEnv.fileWarning(15, declarators[i], "(DD03) Cannot combine successive declarations of constant " + ILUtils.toString(declarator) + " type: " + oldVariableDecl.type().wrappedType.showType() + " and " + typeSpec.wrappedType.showType() + " (ignored new)");
                } else {
                    oldVariableDecl.setType(typeSpec);
                }
                oldVariableDecl.setConstantKind();
                oldVariableDecl.setInstruction(instrDecl);
            }
            if (initTree == null) continue;
            assert (oldVariableDecl != null);
            oldVariableDecl.setInitializationTree(initTree);
            if (oldVariableDecl.type().isIntegerBase() || ILUtils.seemsInteger(initTree)) {
                oldVariableDecl.constantValue = this.computeIntConstant(initTree.down(2));
            }
            SymbolDecl.addUsedSymbolsInExpr(initTree.down(2), toTypeUsedSymbols, this, null, false, true);
            oldVariableDecl.dependsOn = TapList.prependNoDups(toTypeUsedSymbols.tail, oldVariableDecl.dependsOn());
        }
    }

    public void addData(Instruction instr) {
        Tree decl = instr.tree;
        if (this.dataList == null) {
            this.dataList = new TapList<Tree>(decl, null);
        } else {
            this.dataList.newR(decl);
        }
        TapList<String> commonNames = this.getCommonNames();
        this.declareAllSymbolsIn(decl, decl, commonNames, null, 1, true, true, instr);
    }

    public void addSave(Instruction instr) {
        Tree decl = instr.tree;
        if (this.saveList == null) {
            this.saveList = new TapList<Tree>(decl, null);
        } else {
            this.saveList.newR(decl);
        }
        if (decl.length() == 0) {
            TapEnv.fileWarning(15, decl, "(DD28) Save statement may save extra variables, please use \"save::varname\" ");
        }
        TapList<String> commonNames = this.getCommonNames();
        this.declareAllSymbolsIn(decl, decl, commonNames, null, 1, true, true, instr);
    }

    public void addNameList(Instruction instr) {
        Tree decl = instr.tree;
        if (this.nameListList == null) {
            this.nameListList = new TapList<Tree>(decl, null);
        } else {
            this.nameListList.newR(decl);
        }
        this.declareAllSymbolsIn(decl, decl, null, null, 1, true, false, instr);
    }

    public TapList<SymbolDecl> declareAllSymbolsIn(Tree decl, Tree topDeclTree, TapList<String> commonNames, Tree modifier, int symbolKind, boolean delayedDeclaration, boolean noFunctionCall, Instruction instr) {
        TapList<SymbolDecl> newAddSymbolDecls = null;
        switch (decl.opCode()) {
            case 9: 
            case 59: 
            case 63: 
            case 70: 
            case 196: {
                Tree[] listOfVar;
                for (Tree tree : listOfVar = decl.children()) {
                    newAddSymbolDecls = TapList.append(newAddSymbolDecls, this.declareAllSymbolsIn(tree, tree, commonNames, modifier, symbolKind, delayedDeclaration, noFunctionCall, instr));
                }
                break;
            }
            case 128: {
                Tree[] listOfVar;
                for (Tree tree : listOfVar = decl.children()) {
                    if (tree.opCode() != 59) continue;
                    newAddSymbolDecls = TapList.append(newAddSymbolDecls, this.declareAllSymbolsIn(tree, tree, commonNames, modifier, symbolKind, delayedDeclaration, false, instr));
                }
                break;
            }
            case 166: {
                Tree[] listOfVar;
                for (Tree tree : listOfVar = decl.children()) {
                    newAddSymbolDecls = TapList.append(newAddSymbolDecls, this.declareAllSymbolsIn(tree, tree, commonNames, modifier, symbolKind, delayedDeclaration, true, instr));
                }
                this.unit.fortranStuff().computeSave(this, instr);
                if (listOfVar.length != 0) break;
                this.unit.fortranStuff().setSaveAll();
                break;
            }
            case 133: {
                Tree[] listOfVar;
                for (Tree tree : listOfVar = decl.down(2).children()) {
                    newAddSymbolDecls = TapList.append(newAddSymbolDecls, this.declareAllSymbolsIn(tree, tree, commonNames, modifier, symbolKind, delayedDeclaration, noFunctionCall, instr));
                }
                break;
            }
            case 8: {
                newAddSymbolDecls = this.declareAllSymbolsIn(decl.down(2), decl.down(2), commonNames, modifier, symbolKind, delayedDeclaration, false, instr);
                break;
            }
            case 50: {
                newAddSymbolDecls = this.declareAllSymbolsIn(decl.down(1), topDeclTree, commonNames, modifier, symbolKind, delayedDeclaration, true, instr);
                this.unit.fortranStuff().computeSave(this, instr);
                break;
            }
            case 108: 
            case 127: {
                newAddSymbolDecls = this.declareAllSymbolsIn(decl.down(1), topDeclTree, commonNames, modifier, symbolKind, delayedDeclaration, true, instr);
                break;
            }
            case 73: {
                newAddSymbolDecls = this.declareAllSymbolsIn(decl.down(1), decl.down(1), commonNames, modifier, symbolKind, delayedDeclaration, false, instr);
                break;
            }
            case 10: {
                newAddSymbolDecls = this.declareAllSymbolsIn(decl.down(1), decl.down(1), commonNames, modifier, symbolKind, delayedDeclaration, true, instr);
                SymbolDecl symbolDecl = SymbolDecl.build(new WrapperTypeSpec(null), null, false, decl, 1, this, instr, newAddSymbolDecls);
                this.addSymbolDecl(symbolDecl);
                newAddSymbolDecls = TapList.append(newAddSymbolDecls, this.declareAllSymbolsIn(decl.down(2), decl.down(2), commonNames, null, symbolKind, delayedDeclaration, false, instr));
                break;
            }
            case 2: 
            case 5: 
            case 13: 
            case 17: 
            case 21: 
            case 23: 
            case 42: 
            case 58: 
            case 61: 
            case 67: 
            case 89: 
            case 90: 
            case 93: 
            case 113: 
            case 114: 
            case 120: 
            case 131: 
            case 135: 
            case 141: 
            case 149: 
            case 152: 
            case 164: 
            case 177: 
            case 202: {
                if (delayedDeclaration && decl.down(1).opCode() == 136 && decl.down(2).opCode() == 136 && this.isOverloadedOperator(decl.operator())) {
                    Tree interfaceTree = ILUtils.build(94, decl.opName());
                    newAddSymbolDecls = this.declareAllSymbolsIn(interfaceTree, interfaceTree, commonNames, modifier, symbolKind, true, false, instr);
                    break;
                }
                newAddSymbolDecls = this.declareAllSymbolsIn(decl.down(1), decl.down(1), commonNames, modifier, symbolKind, delayedDeclaration, false, instr);
                newAddSymbolDecls = TapList.append(newAddSymbolDecls, this.declareAllSymbolsIn(decl.down(2), decl.down(2), commonNames, modifier, symbolKind, delayedDeclaration, false, instr));
                break;
            }
            case 19: 
            case 27: 
            case 30: 
            case 101: 
            case 116: 
            case 121: 
            case 122: 
            case 132: 
            case 136: 
            case 155: 
            case 172: 
            case 175: 
            case 176: {
                break;
            }
            case 94: {
                String name = decl.stringValue();
                if (symbolKind == 1) {
                    VariableDecl variableDecl = this.getVariableOrConstantDecl(name);
                    if (variableDecl == null) {
                        if (TapList.containsEquals(commonNames, name)) break;
                        boolean isCommonName = false;
                        if (instr != null && instr.tree != null && instr.tree.opCode() == 166) {
                            boolean bl = isCommonName = name.startsWith("/") && name.endsWith("/");
                        }
                        if (isCommonName) break;
                        SymbolDecl newSymbolDecl = TapList.findNamedSymbolDecl(this.addSymbolDecls, name);
                        if (newSymbolDecl == null) {
                            WrapperTypeSpec implicitTypeSpec = this.getImplicitTypeSpec(name);
                            newSymbolDecl = SymbolDecl.build(implicitTypeSpec, null, false, topDeclTree, 1, this, instr, null);
                            if (delayedDeclaration) {
                                this.addSymbolDecls = new TapList<SymbolDecl>(newSymbolDecl, this.addSymbolDecls);
                                newAddSymbolDecls = new TapList<SymbolDecl>(newSymbolDecl, null);
                            } else {
                                this.addSymbolDecl(newSymbolDecl);
                            }
                        } else if (delayedDeclaration) {
                            newAddSymbolDecls = new TapList<SymbolDecl>(newSymbolDecl, null);
                        }
                        if (modifier != null && modifier.opCode() == 94) {
                            newSymbolDecl.addExtraInfo(new TapList<String>(modifier.stringValue(), null));
                        }
                        if (instr == null || instr.tree == null || instr.tree.opCode() != 1 && instr.tree.opCode() != 166) break;
                        newSymbolDecl.setInstruction(instr);
                        break;
                    }
                    if (modifier != null && modifier.opCode() == 94) {
                        variableDecl.addExtraInfo(new TapList<String>(modifier.stringValue(), null));
                    }
                    if (instr == null || instr.tree == null || instr.tree.opCode() != 1 && instr.tree.opCode() != 166) break;
                    variableDecl.setInstruction(instr);
                    break;
                }
                if (symbolKind != 0) break;
                SymbolDecl symbolDecl = this.getSymbolDecl(name);
                if (symbolDecl == null && !TapList.containsEquals(commonNames, name)) {
                    SymbolDecl newSymbolDecl = SymbolDecl.build(new WrapperTypeSpec(null), null, false, topDeclTree, 0, this, instr, null);
                    if (delayedDeclaration) {
                        this.addSymbolDecls = new TapList<SymbolDecl>(newSymbolDecl, this.addSymbolDecls);
                        newAddSymbolDecls = new TapList<SymbolDecl>(newSymbolDecl, null);
                    } else {
                        this.addSymbolDecl(newSymbolDecl);
                    }
                    if (modifier != null && modifier.opCode() == 94) {
                        newSymbolDecl.addExtraInfo(new TapList<String>(modifier.stringValue(), null));
                    }
                    if (instr == null || instr.tree == null || instr.tree.opCode() != 1) break;
                    newSymbolDecl.setInstruction(instr);
                    break;
                }
                if (modifier == null || modifier.opCode() != 94) break;
                assert (symbolDecl != null);
                symbolDecl.addExtraInfo(new TapList<String>(modifier.stringValue(), null));
                symbolDecl.setInstruction(instr);
                break;
            }
        }
        return newAddSymbolDecls;
    }

    private boolean isOverloadedOperator(Operator oper) {
        return oper.code == 13 || oper.code == 2 || oper.code == 177 || oper.code == 131 || oper.code == 61 || oper.code == 90 || oper.code == 93 || oper.code == 113 || oper.code == 120 || oper.code == 122;
    }

    public TapIntList systemPredefinedZones() {
        TapIntList result = null;
        ZoneInfo[] zoneInfos = this.declaredZoneInfos[0];
        for (int i = zoneInfos.length - 1; i >= 0; --i) {
            SymbolDecl symbolDecl;
            String varName;
            if (zoneInfos[i] == null || (varName = zoneInfos[i].bestVarName()) == null || (symbolDecl = this.getSymbolDecl(varName)) == null || !symbolDecl.isSystemPredefined()) continue;
            result = new TapIntList(i, result);
        }
        return result;
    }

    public TapIntList constantZones() {
        TapIntList result = null;
        ZoneInfo[] zoneInfos = this.declaredZoneInfos[0];
        for (int i = zoneInfos.length - 1; i >= 0; --i) {
            if (zoneInfos[i] == null || !zoneInfos[i].isConstant()) continue;
            result = new TapIntList(i, result);
        }
        return result;
    }

    private void wrapPointerType(Tree modifier, SymbolDecl newSymbolDecl) {
        if (modifier.stringValue().equals("allocatable")) {
            WrapperTypeSpec typeSpec = newSymbolDecl.type();
            PointerTypeSpec ptrTypeSpec = new PointerTypeSpec(typeSpec, null);
            ((VariableDecl)newSymbolDecl).setType(new WrapperTypeSpec(ptrTypeSpec));
        }
    }

    public TapList<String> getCommonNames() {
        return this.unit.fortranStuff().getCommonNames();
    }

    public void addExternalOrForwardDeclaration(Tree externalTree, Instruction instrDecl, boolean isPrivate) {
        Tree[] functionNames;
        if (externalTree.opCode() == 72) {
            functionNames = externalTree.children();
        } else {
            Tree nameTree = ILUtils.baseTree(externalTree);
            functionNames = new Tree[]{nameTree};
        }
        SymbolTable rootSymbolTable = this;
        SymbolTable publicSymbolTable = null;
        if (!isPrivate) {
            while (rootSymbolTable.basisSymbolTable != this.getCallGraph().globalRootSymbolTable()) {
                if (rootSymbolTable.isFormalParams) {
                    publicSymbolTable = rootSymbolTable;
                }
                rootSymbolTable = rootSymbolTable.basisSymbolTable;
            }
        }
        if (publicSymbolTable == null) {
            publicSymbolTable = rootSymbolTable;
        }
        for (Tree functionName : functionNames) {
            TapList<SymbolDecl> dependsOn;
            SymbolDecl oldVarDecl;
            Unit functionUnit;
            FunctionDecl functionDecl;
            TapList<FunctionDecl> rootFunctionDecls;
            SymbolDecl paramSymbolDecl;
            FunctionDecl localFunctionDecl;
            String name = ILUtils.baseName(functionName);
            TapList<FunctionDecl> localFunctionDecls = this.getTopFunctionDecl(name, null, null, false);
            FunctionDecl functionDecl2 = localFunctionDecl = localFunctionDecls == null ? null : (FunctionDecl)localFunctionDecls.head;
            if (localFunctionDecl != null) {
                paramSymbolDecl = null;
                rootFunctionDecls = rootSymbolTable.getTopFunctionDecl(name, null, null, false);
                FunctionDecl rootFunctionDecl = rootFunctionDecls == null ? null : (FunctionDecl)rootFunctionDecls.head;
                functionDecl = localFunctionDecl;
                if (rootFunctionDecl != null && localFunctionDecl.unit() != rootFunctionDecl.unit()) {
                    TapEnv.toolWarning(-1, "Erroneous analysis of function declarations");
                }
            } else {
                SymbolDecl symbolDecl = paramSymbolDecl = publicSymbolTable.isFormalParams ? publicSymbolTable.getTopSymbolDecl(name) : null;
                if (paramSymbolDecl != null) {
                    rootFunctionDecls = null;
                    functionDecl = null;
                } else {
                    rootFunctionDecls = rootSymbolTable.getTopFunctionDecl(name, null, null, false);
                    FunctionDecl functionDecl3 = functionDecl = rootFunctionDecls == null ? null : (FunctionDecl)rootFunctionDecls.head;
                }
            }
            if (functionDecl != null && functionDecl.isIntrinsic() && functionDecl.unit().isFortran()) {
                functionDecl = null;
            }
            if (functionDecl != null && functionDecl.unit() != null) {
                if (functionDecl.isExternal()) {
                    if (localFunctionDecl == null) {
                        TapList<FunctionDecl> inRootFunctionDecls = rootFunctionDecls;
                        while (inRootFunctionDecls != null) {
                            FunctionDecl rootFunctionDecl = (FunctionDecl)inRootFunctionDecls.head;
                            this.addSymbolDecl(rootFunctionDecl);
                            rootFunctionDecl.setInstruction(instrDecl);
                            inRootFunctionDecls = inRootFunctionDecls.tail;
                        }
                        continue;
                    }
                    if (this == this.getCallGraph().cRootSymbolTable()) continue;
                    TapEnv.fileWarning(15, functionName, "(DD08) Double declaration of external procedure " + name);
                    continue;
                }
                if (functionDecl.isIntrinsic()) {
                    TapEnv.fileWarning(15, functionName, "(DD07) Cannot combine successive declarations of procedure " + name + " kind: INTRINSIC and EXTERNAL (ignored new)");
                    continue;
                }
                if (functionDecl.isStandard() || functionDecl.isInterface()) {
                    this.addSymbolDecl(functionDecl);
                    functionDecl.setInstruction(instrDecl);
                    continue;
                }
                TapEnv.fileWarning(15, functionName, "(DD07) Cannot combine successive declarations of procedure " + name + " kind: USER and EXTERNAL (ignored new)");
                continue;
            }
            if (paramSymbolDecl != null) {
                if (paramSymbolDecl.isA(3)) {
                    functionDecl = (FunctionDecl)paramSymbolDecl;
                    if (functionDecl.isExternal()) {
                        TapEnv.fileWarning(15, functionName, "(DD08) Double declaration of external procedure " + name);
                    } else if (functionDecl.isIntrinsic()) {
                        TapEnv.fileWarning(15, functionName, "(DD07) Cannot combine successive declarations of procedure " + name + " kind: INTRINSIC and EXTERNAL (ignored new)");
                    }
                } else if (paramSymbolDecl.isA(1)) {
                    if (publicSymbolTable.isFormalParams) {
                        Unit varFunctionUnit = Unit.makeVarFunction(name, this.unit);
                        varFunctionUnit.setFunctionTypeSpec(new FunctionTypeSpec(paramSymbolDecl.type()));
                        functionDecl = new FunctionDecl(functionName, varFunctionUnit);
                        publicSymbolTable.addSymbolDecl(functionDecl);
                        TapEnv.relatedUnit().exportOneArgumentType(name, new WrapperTypeSpec(varFunctionUnit.functionTypeSpec()));
                    } else {
                        functionUnit = this.buildExternalUnit(name, isPrivate);
                        functionDecl = new FunctionDecl(functionName, functionUnit);
                        FunctionTypeSpec varFunTypeSpec = TypeSpec.findFunctionTypeSpecUnderTypeSpec(paramSymbolDecl.type());
                        functionUnit.setFunctionTypeSpec(new FunctionTypeSpec(varFunTypeSpec.returnType, varFunTypeSpec.argumentsTypes, varFunTypeSpec.variableArgList));
                        oldVarDecl = this.getDecl(functionDecl.symbol, 1, true);
                        dependsOn = null;
                        if (oldVarDecl != null) {
                            dependsOn = oldVarDecl.dependsOn();
                            publicSymbolTable.removeDecl(functionDecl.symbol, 1, true);
                        }
                        publicSymbolTable.addSymbolDecl(functionDecl);
                        functionDecl.dependsOn = dependsOn;
                    }
                }
                assert (functionDecl != null);
                functionDecl.setInstruction(instrDecl);
                if (!functionDecl.isExternal()) continue;
                functionDecl.unit().setForwardDeclaration(instrDecl);
                continue;
            }
            functionUnit = this.buildExternalUnit(name, isPrivate);
            boolean hasVarDeclInstr = false;
            if (functionUnit.functionTypeSpec() == null) {
                VariableDecl varFunDecl = this.getVariableDecl(functionUnit.name);
                if (varFunDecl != null && varFunDecl.type() != null) {
                    hasVarDeclInstr = varFunDecl.hasInstructionWithRootOperator(194, null);
                    FunctionTypeSpec varFunTypeSpec = TypeSpec.findFunctionTypeSpecUnderTypeSpec(varFunDecl.type());
                    if (varFunTypeSpec != null) {
                        functionUnit.setFunctionTypeSpec(new FunctionTypeSpec(varFunTypeSpec.returnType, varFunTypeSpec.argumentsTypes.length == 0 ? null : varFunTypeSpec.argumentsTypes, varFunTypeSpec.variableArgList));
                    } else {
                        functionUnit.setFunctionTypeSpec(new FunctionTypeSpec(new WrapperTypeSpec(null)));
                        functionUnit.functionTypeSpec().returnType = varFunDecl.type();
                    }
                } else {
                    functionUnit.setFunctionTypeSpec(new FunctionTypeSpec(new WrapperTypeSpec(null)));
                }
            }
            functionDecl = new FunctionDecl(functionName, functionUnit, rootSymbolTable);
            oldVarDecl = this.getDecl(functionDecl.symbol, 1, true);
            dependsOn = null;
            if (oldVarDecl != null) {
                dependsOn = oldVarDecl.dependsOn();
                this.removeDecl(functionDecl.symbol, 1, true);
            }
            this.addSymbolDecl(functionDecl);
            functionDecl.dependsOn = dependsOn;
            if (hasVarDeclInstr) {
                functionDecl.setMainDeclInstr(true);
            }
            functionDecl.setInstruction(instrDecl);
            if (functionUnit.isExternal()) {
                functionUnit.setForwardDeclaration(instrDecl);
            }
            rootSymbolTable.addSymbolDecl(functionDecl);
        }
    }

    public Unit buildExternalUnit(String name, boolean isPrivate) {
        Unit functionUnit;
        if (this.unit != null && !this.unit.isTranslationUnit()) {
            functionUnit = this.unit.callGraph().getAnyNonVarUnit(name, this.unit);
            if (functionUnit == null) {
                functionUnit = Unit.makeExternal(name, this.unit.callGraph(), this.language, isPrivate);
            }
        } else {
            functionUnit = Unit.makeExternal(name, TapEnv.get().origCallGraph(), 4, isPrivate);
        }
        return functionUnit;
    }

    protected InterfaceDecl addInterfaceDecl(Tree interfaceTreeOrig, Unit containerUnit) {
        Tree interfaceTree = interfaceTreeOrig;
        if (interfaceTree != null) {
            if (interfaceTree.opCode() == 16) {
                interfaceTree = ILUtils.build(94, interfaceTree.down(2).stringValue());
            } else if (interfaceTree.opCode() != 94) {
                interfaceTree = ILUtils.build(94, interfaceTree.opName());
            }
        }
        InterfaceDecl interfaceDecl = new InterfaceDecl(interfaceTree, null, this, containerUnit);
        this.addSymbolDecl(interfaceDecl);
        interfaceDecl.nameTree = interfaceTreeOrig;
        return interfaceDecl;
    }

    public void addIntrinsicDeclaration(Tree intrinsicTree, Instruction instrDecl) {
        Tree[] functionNames = intrinsicTree.children();
        SymbolTable rootSymbolTable = this;
        SymbolTable publicSymbolTable = null;
        while (rootSymbolTable.basisSymbolTable != this.getCallGraph().globalRootSymbolTable()) {
            if (rootSymbolTable.isFormalParams) {
                publicSymbolTable = rootSymbolTable;
            }
            rootSymbolTable = rootSymbolTable.basisSymbolTable;
        }
        for (Tree functionName : functionNames) {
            FunctionDecl newFuncDecl;
            FunctionDecl functionDecl;
            FunctionDecl rootFunctionDecl;
            TapList<FunctionDecl> rootFunctionDecls;
            SymbolDecl paramSymbolDecl;
            FunctionDecl localFunctionDecl;
            String name = ILUtils.baseName(functionName);
            TapList<FunctionDecl> localFunctionDecls = this.getTopFunctionDecl(name, null, null, false);
            FunctionDecl functionDecl2 = localFunctionDecl = localFunctionDecls == null ? null : (FunctionDecl)localFunctionDecls.head;
            if (localFunctionDecl != null) {
                paramSymbolDecl = null;
                rootFunctionDecls = rootSymbolTable.getTopFunctionDecl(name, null, null, false);
                rootFunctionDecl = rootFunctionDecls == null ? null : (FunctionDecl)rootFunctionDecls.head;
                functionDecl = localFunctionDecl;
                if (rootFunctionDecl != null && localFunctionDecl.unit() != rootFunctionDecl.unit()) {
                    TapEnv.toolWarning(-1, "Erroneous analysis of function declarations (2)");
                }
            } else {
                SymbolDecl symbolDecl = paramSymbolDecl = publicSymbolTable == null ? null : publicSymbolTable.getTopSymbolDecl(name);
                if (paramSymbolDecl != null) {
                    rootFunctionDecl = null;
                    functionDecl = null;
                } else {
                    rootFunctionDecls = rootSymbolTable.getTopFunctionDecl(name, null, null, false);
                    functionDecl = rootFunctionDecl = rootFunctionDecls == null ? null : (FunctionDecl)rootFunctionDecls.head;
                }
            }
            if (functionDecl != null) {
                if (functionDecl.isIntrinsic()) {
                    if (localFunctionDecl == null) {
                        this.addSymbolDecl(rootFunctionDecl);
                    } else {
                        TapEnv.fileWarning(15, functionName, "(DD08) Double declaration of intrinsic procedure " + name);
                    }
                } else if (functionDecl.isExternal()) {
                    TapEnv.fileWarning(15, functionName, "(DD07) Cannot combine successive declarations of procedure " + name + " kind: EXTERNAL and INTRINSIC (ignored new)");
                } else {
                    TapEnv.fileWarning(15, functionName, "(DD07) Cannot combine successive declarations of procedure " + name + " kind: USER and INTRINSIC (ignored new)");
                }
                functionDecl.setInstruction(instrDecl);
                continue;
            }
            if (paramSymbolDecl != null) {
                if (paramSymbolDecl.isA(3)) {
                    functionDecl = (FunctionDecl)paramSymbolDecl;
                    if (functionDecl.isIntrinsic()) {
                        TapEnv.fileWarning(15, functionName, "(DD08) Double declaration of intrinsic procedure " + name);
                        continue;
                    }
                    if (!functionDecl.isExternal()) continue;
                    TapEnv.fileWarning(15, functionName, "(DD07) Cannot combine successive declarations of procedure " + name + " kind: EXTERNAL and INTRINSIC (ignored new)");
                    continue;
                }
                if (!paramSymbolDecl.isA(1)) continue;
                Unit varFunctionUnit = Unit.makeVarFunction(name, this.unit);
                varFunctionUnit.setFunctionTypeSpec(new FunctionTypeSpec(paramSymbolDecl.type()));
                functionDecl = new FunctionDecl(functionName, varFunctionUnit);
                publicSymbolTable.addSymbolDecl(functionDecl);
                functionDecl.setInstruction(instrDecl);
                continue;
            }
            Unit functionUnit = this.unit.callGraph().getAnyIntrinsicUnit(name);
            if (functionUnit == null) {
                functionUnit = this.unit.callGraph().createNewIntrinsicUnit(name, this.language);
            }
            if (functionUnit.functionTypeSpec() == null) {
                functionUnit.setFunctionTypeSpec(new FunctionTypeSpec(new WrapperTypeSpec(null)));
            }
            functionDecl = new FunctionDecl(functionName, functionUnit);
            this.addSymbolDecl(functionDecl);
            TapList<FunctionDecl> newFuncDecls = this.getTopFunctionDecl(functionDecl.symbol, null, null, false);
            FunctionDecl functionDecl3 = newFuncDecl = newFuncDecls == null ? null : (FunctionDecl)newFuncDecls.head;
            assert (newFuncDecl != null);
            newFuncDecl.setInstruction(instrDecl);
            rootSymbolTable.addSymbolDecl(functionDecl);
            newFuncDecls = rootSymbolTable.getFunctionDecl(functionDecl.symbol, null, null, false);
            FunctionDecl functionDecl4 = newFuncDecl = newFuncDecls == null ? null : (FunctionDecl)newFuncDecls.head;
            assert (newFuncDecl != null);
            newFuncDecl.setInstruction(instrDecl);
        }
    }

    public void addImplicit(Tree decl, SymbolTable refST) {
        Tree[] declarators = decl.children();
        if (declarators.length == 0) {
            this.setImplicitLetters('a', 'z', new WrapperTypeSpec(null));
        } else {
            for (int i = 0; i < declarators.length; ++i) {
                TapList<Object> toInfos = new TapList<Object>(null, null);
                TapList<Object> toAccess = new TapList<Object>(null, null);
                ToBool isPointer = new ToBool(false);
                WrapperTypeSpec typeSpec = TypeSpec.build(declarators[i].down(1), refST, null, new TapList<Object>(null, null), toInfos, toAccess, isPointer, null);
                if (toInfos.tail != null || toAccess.tail != null) {
                    TapEnv.toolWarning(-1, "Cannot handle this implicit declaration " + ILUtils.toString(declarators[i]));
                }
                Tree[] letters = declarators[i].down(2).children();
                for (int j = 0; j < letters.length; ++j) {
                    if (letters[j].opCode() == 116) {
                        this.setImplicitLetters(letters[j].stringValue().charAt(0), letters[j].stringValue().charAt(0), typeSpec);
                        continue;
                    }
                    if (letters[j].opCode() != 117) continue;
                    this.setImplicitLetters(letters[j].down(1).stringValue().charAt(0), letters[j].down(2).stringValue().charAt(0), typeSpec);
                }
            }
        }
    }

    public void setImplicitLetters(char fromChar, char toChar, WrapperTypeSpec defaultType) {
        int from = Character.getNumericValue(fromChar) - Character.getNumericValue('a');
        int to = Character.getNumericValue(toChar) - Character.getNumericValue('a');
        for (int i = from; i <= to; ++i) {
            this.implicits[i] = defaultType;
        }
    }

    private WrapperTypeSpec getImplicitTypeSpec(String name) {
        int index;
        WrapperTypeSpec implicitType = null;
        if (!name.isEmpty() && this.implicits != null && (index = Character.getNumericValue(name.charAt(0)) - Character.getNumericValue('a')) >= 0 && index <= 25 && this.implicits[index] != null && this.implicits[index].wrappedType != null) {
            implicitType = this.implicits[index];
        }
        return implicitType;
    }

    protected void fixImplicits() {
        for (int i = 0; i < 100; ++i) {
            TapList bucket = this.buckets[i].tail;
            while (bucket != null) {
                WrapperTypeSpec baseTypeSpec;
                WrapperTypeSpec typeSpec;
                SymbolDecl symbolDecl = (SymbolDecl)bucket.head;
                if (symbolDecl == null) {
                    typeSpec = null;
                } else if (symbolDecl.isA(1) || symbolDecl.isA(5)) {
                    typeSpec = symbolDecl.type();
                    if (typeSpec == null) {
                        typeSpec = new WrapperTypeSpec(null);
                        ((VariableDecl)symbolDecl).setType(typeSpec);
                    }
                } else if (symbolDecl.isA(2)) {
                    typeSpec = symbolDecl.type();
                    if (typeSpec == null) {
                        typeSpec = new WrapperTypeSpec(null);
                        ((FieldDecl)symbolDecl).setType(typeSpec);
                    }
                } else {
                    typeSpec = null;
                }
                if (typeSpec != null && ((baseTypeSpec = typeSpec.baseTypeSpec(false)) == null || baseTypeSpec.wrappedType == null || TypeSpec.isA(baseTypeSpec.wrappedType, 7) && baseTypeSpec.wrappedType.isUndefinedNumeric())) {
                    WrapperTypeSpec implicitTypeSpec = this.getImplicitTypeSpec(symbolDecl.symbol);
                    if (implicitTypeSpec == null) {
                        if (this.unit == null || this.unit.isC()) {
                            TapEnv.fileWarning(15, (Tree)symbolDecl.defPositions.head, "(TC21) Incomplete declaration of variable " + symbolDecl.symbol);
                        } else {
                            TapEnv.fileWarning(15, (Tree)symbolDecl.defPositions.head, "(TC21) No implicit rule available to complete the declaration of variable " + symbolDecl.symbol);
                        }
                    } else {
                        Tree newDecl;
                        WrapperTypeSpec scalarTypeSpec = typeSpec.scalarTypeSpec(false, this);
                        if (scalarTypeSpec.wrappedType != null && !scalarTypeSpec.receives(implicitTypeSpec, null, null)) {
                            TapEnv.fileWarning(15, (Tree)symbolDecl.defPositions.head, "(TC22) Variable " + symbolDecl.symbol + ", declared implicitly as " + implicitTypeSpec.showType() + ", is used as " + scalarTypeSpec.showType());
                        }
                        scalarTypeSpec.wrappedType = implicitTypeSpec.wrappedType;
                        Tree declarator = ILUtils.build(94, symbolDecl.symbol);
                        if (symbolDecl.isA(1) && ((VariableDecl)symbolDecl).isFunctionName) {
                            declarator.setAnnotation("isFunctionName", Boolean.TRUE);
                        }
                        if (symbolDecl.hasOtherInstruction()) {
                            newDecl = ILUtils.build(194, ILUtils.build(128), scalarTypeSpec.wrappedType.generateTree(this, null, null, true, null), ILUtils.build(53, declarator));
                        } else if (this.language == 1 && TypeSpec.isA(typeSpec, 2)) {
                            Tree fullTypeTree = typeSpec.wrappedType.generateTree(this, null, null, true, null);
                            newDecl = ILUtils.build(194, ILUtils.build(128), fullTypeTree.cutChild(1), ILUtils.build(53, ILUtils.build(10, declarator, fullTypeTree.cutChild(2))));
                        } else {
                            newDecl = ILUtils.build(194, ILUtils.build(128), typeSpec.wrappedType.generateTree(this, null, null, true, null), ILUtils.build(53, declarator));
                        }
                        Instruction newInstr = new Instruction(newDecl);
                        if (symbolDecl.fromInclude() != null && symbolDecl.fromInclude().tree != null) {
                            symbolDecl.fromInclude().setIncludeOfDiffInstructions(newInstr, null, null);
                            symbolDecl.fromInclude().forceDiffInclude(TapEnv.modeIsNoDiff() ? TapEnv.get().preprocessFileSuffix : TapEnv.get().diffFileSuffix);
                        }
                        this.declarationsBlock.addInstrDeclTlBeforeUse(newInstr, new TapList<SymbolDecl>(symbolDecl, null), null, this, true);
                        symbolDecl.setInstruction(newInstr);
                        this.unit.fortranStuff().implicitDeclarations = new TapList<TapPair<String, Instruction>>(new TapPair<String, Instruction>(symbolDecl.symbol, newInstr), this.unit.fortranStuff().implicitDeclarations);
                    }
                }
                bucket = bucket.tail;
            }
        }
    }

    protected void fixImportedDeclarations() {
        for (int i = 0; i < 100; ++i) {
            TapList<SymbolDecl> toBucket = this.buckets[i];
            while (toBucket.tail != null) {
                SymbolDecl symbolDecl = (SymbolDecl)toBucket.tail.head;
                boolean removeThisSymbol = false;
                if (symbolDecl != null) {
                    switch (symbolDecl.kind) {
                        case 4: {
                            TypeDecl importedTypeDecl;
                            WrapperTypeSpec typeSpec = ((TypeDecl)symbolDecl).typeSpec;
                            if (TypeSpec.isA(typeSpec, 11) && (importedTypeDecl = (TypeDecl)this.unit.getImportedDecl(((NamedTypeSpec)typeSpec.wrappedType).name(), 4)) != null) {
                                typeSpec.wrappedType = importedTypeDecl.typeSpec.wrappedType;
                                removeThisSymbol = true;
                            }
                            if (typeSpec == null || removeThisSymbol) break;
                            typeSpec.updateAfterImports(this, null);
                            break;
                        }
                        case 1: {
                            WrapperTypeSpec typeSpec = symbolDecl.type();
                            if (typeSpec != null) {
                                typeSpec.updateAfterImports(this, null);
                            }
                            TapList<SymbolDecl> dependsOn = symbolDecl.dependsOn();
                            TapList<SymbolDecl> fixedDependsOn = null;
                            while (dependsOn != null) {
                                SymbolDecl importedDecl;
                                SymbolDecl dependsOnDecl = (SymbolDecl)dependsOn.head;
                                fixedDependsOn = dependsOnDecl.type() == null ? ((importedDecl = this.getSymbolDecl(dependsOnDecl.symbol)) != null ? new TapList<SymbolDecl>(importedDecl, fixedDependsOn) : new TapList<SymbolDecl>(dependsOnDecl, fixedDependsOn)) : new TapList<SymbolDecl>(dependsOnDecl, fixedDependsOn);
                                dependsOn = dependsOn.tail;
                            }
                            symbolDecl.dependsOn = fixedDependsOn;
                            break;
                        }
                        case 3: {
                            WrapperTypeSpec typeSpec = ((FunctionDecl)symbolDecl).type();
                            if (typeSpec == null) break;
                            typeSpec.updateAfterImports(this, null);
                            break;
                        }
                    }
                }
                if (removeThisSymbol) {
                    toBucket.tail = toBucket.tail.tail;
                    continue;
                }
                toBucket = toBucket.tail;
            }
        }
    }

    private ZoneInfo[] initCopyZoneInfosArray(int modelLength) {
        ZoneInfo[] copyZoneInfos = new ZoneInfo[modelLength];
        for (int i = modelLength - 1; i >= 0; --i) {
            copyZoneInfos[i] = null;
        }
        return copyZoneInfos;
    }

    protected void updateImportedZones() {
        int i;
        ZoneInfo[][] origZoneInfos = this.declaredZoneInfos;
        this.declaredZoneInfos = new ZoneInfo[4][];
        if (origZoneInfos[0] == null) {
            TapEnv.fileError(null, "(TCxx) Fatal error: wrong order of modules/procedures in input files");
            return;
        }
        this.declaredZoneInfos[0] = this.initCopyZoneInfosArray(origZoneInfos[0].length);
        this.declaredZoneInfos[1] = this.initCopyZoneInfosArray(origZoneInfos[1].length);
        this.declaredZoneInfos[2] = this.initCopyZoneInfosArray(origZoneInfos[2].length);
        this.declaredZoneInfos[3] = this.initCopyZoneInfosArray(origZoneInfos[3].length);
        TapList<Object> memoCopies = new TapList<Object>(null, null);
        for (i = 0; i < 100; ++i) {
            TapList curBucket = this.buckets[i].tail;
            while (curBucket != null) {
                SymbolDecl symbolDecl = (SymbolDecl)curBucket.head;
                SymbolDecl origSymbolDecl = symbolDecl.renamedFromSymbolDecl;
                String newName = symbolDecl.symbol;
                TapIntList zones = null;
                switch (symbolDecl.kind()) {
                    case 1: {
                        zones = ZoneInfo.listAllZones(this.includePointedInitialsInTree(symbolDecl.zones(), origZoneInfos[0]), true);
                        break;
                    }
                    case 3: {
                        zones = ZoneInfo.listAllZones(symbolDecl.zones(), true);
                        break;
                    }
                }
                while (zones != null) {
                    int index = zones.head - this.firstDeclaredZone[0];
                    if (index >= 0) {
                        ZoneInfo newZoneInfo;
                        ZoneInfo origZoneInfo = origZoneInfos[0][index];
                        if (origSymbolDecl != null) {
                            String origName = origSymbolDecl.symbol;
                            newZoneInfo = origZoneInfo.copy();
                            memoCopies.placdl(new TapPair<ZoneInfo, ZoneInfo>(origZoneInfo, newZoneInfo));
                            if (origZoneInfo.targetZoneOf != null) {
                                ZoneInfo newTargetOf = (ZoneInfo)TapList.cassq(origZoneInfo.targetZoneOf, memoCopies.tail);
                                if (newTargetOf != null) {
                                    newZoneInfo.targetZoneOf = newTargetOf;
                                } else {
                                    TapEnv.toolWarning(-1, "Wrong order in copy ZoneInfo " + origZoneInfo + ", target of " + origZoneInfo.targetZoneOf);
                                }
                            }
                            newZoneInfo.setVariableNames(new TapList<String>(newName, TapList.deleteString(origName, newZoneInfo.variableNames())));
                            newZoneInfo.accessTree = ILUtils.modifyRootName(newZoneInfo.accessTree, origName, newName);
                        } else {
                            newZoneInfo = origZoneInfo;
                        }
                        this.declaredZoneInfos[0][index] = newZoneInfo;
                        index = origZoneInfo.realZoneNb - this.firstDeclaredZone[1];
                        if (index >= 0) {
                            this.declaredZoneInfos[1][index] = newZoneInfo;
                        }
                        if ((index = origZoneInfo.intZoneNb - this.firstDeclaredZone[2]) >= 0) {
                            this.declaredZoneInfos[2][index] = newZoneInfo;
                        }
                        if ((index = origZoneInfo.ptrZoneNb - this.firstDeclaredZone[3]) >= 0) {
                            this.declaredZoneInfos[3][index] = newZoneInfo;
                        }
                    }
                    zones = zones.tail;
                }
                curBucket = curBucket.tail;
            }
        }
        for (i = origZoneInfos.length - 1; i >= 0; --i) {
            this.copyZoneInfosOfCommon(origZoneInfos[0], this.declaredZoneInfos[0]);
            this.copyZoneInfosOfCommon(origZoneInfos[1], this.declaredZoneInfos[1]);
            this.copyZoneInfosOfCommon(origZoneInfos[2], this.declaredZoneInfos[2]);
            this.copyZoneInfosOfCommon(origZoneInfos[3], this.declaredZoneInfos[3]);
        }
    }

    private void copyZoneInfosOfCommon(ZoneInfo[] modelZones, ZoneInfo[] copyZones) {
        for (int i = modelZones.length - 1; i >= 0; --i) {
            if (copyZones[i] != null || modelZones[i] == null || !modelZones[i].isCommon()) continue;
            copyZones[i] = modelZones[i];
        }
    }

    protected void declareAllSymbolDecls() {
        while (this.addSymbolDecls != null) {
            SymbolDecl symbolDecl = (SymbolDecl)this.addSymbolDecls.head;
            if (symbolDecl != null) {
                SymbolDecl previousDecl = this.getDecl(symbolDecl.symbol, symbolDecl.kind, false);
                if (symbolDecl.kind == 1 && previousDecl == null) {
                    previousDecl = this.getDecl(symbolDecl.symbol, 5, false);
                }
                if (previousDecl == null) {
                    previousDecl = this.getDecl(symbolDecl.symbol, 4, false);
                }
                if (previousDecl == null) {
                    this.addSymbolDecl(symbolDecl);
                }
            }
            this.addSymbolDecls = this.addSymbolDecls.tail;
        }
    }

    private Tree preTypeCheck(Tree instrOrExpr, boolean noFunctionCall, Instruction instruction, ToBool isBeginning) {
        Tree newTree;
        if (this.unit.isFortran()) {
            if (instrOrExpr.opCode() == 8 && !noFunctionCall && this.unit.fortranStuff() != null && (newTree = this.unit.fortranStuff().checkArrayAccessOrCall(this, instrOrExpr)) != instrOrExpr && newTree != null) {
                if (TapEnv.traceTypeCheckAnalysis()) {
                    TapEnv.indentOnTrace(TapEnv.traceIndent());
                    TapEnv.printlnOnTrace("Understand " + instrOrExpr + " as function call " + newTree);
                }
                instrOrExpr = instruction.replaceTree(instrOrExpr, newTree);
            }
            if (instrOrExpr.opCode() == 13 && isBeginning.get() && this.unit.fortranStuff() != null) {
                boolean isStmtFuncDecl = this.unit.fortranStuff().checkStatementFunctionDecl(this, instrOrExpr);
                if (isStmtFuncDecl) {
                    if (TapEnv.traceTypeCheckAnalysis()) {
                        TapEnv.indentOnTrace(TapEnv.traceIndent());
                        TapEnv.printlnOnTrace("Skip Statement-Function def " + instrOrExpr + " -> none()");
                    }
                    instrOrExpr = instruction.replaceTree(instrOrExpr, ILUtils.build(136));
                    if (instruction.preComments != null) {
                        this.unit.addLostComment(instruction.preComments);
                        instruction.preComments = null;
                    }
                    if (instruction.postComments != null) {
                        this.unit.addLostComment(instruction.postComments);
                        instruction.postComments = null;
                    }
                } else if (instruction.tree != null && instruction.tree.opCode() != 194) {
                    isBeginning.set(false);
                }
            }
            if (instrOrExpr.opCode() == 30 && this.unit.fortranStuff() != null && (newTree = this.unit.fortranStuff().checkStatementFunctionCall(instrOrExpr)) != instrOrExpr && newTree != null) {
                if (TapEnv.traceTypeCheckAnalysis()) {
                    TapEnv.indentOnTrace(TapEnv.traceIndent());
                    TapEnv.printlnOnTrace("Expand Statement-Function call " + instrOrExpr + " into " + newTree);
                }
                instrOrExpr = instruction.replaceTree(instrOrExpr, newTree);
                instrOrExpr = this.preTypeCheck(instrOrExpr, false, instruction, isBeginning);
            }
            if (this.unit.isFortran() && instrOrExpr.opCode() == 30 && instrOrExpr.down(2).opCode() == 94 && instrOrExpr.down(2).stringValue().equals("c_loc")) {
                newTree = ILUtils.build(3, ILUtils.copy(instrOrExpr.down(3).down(1)));
                if (TapEnv.traceTypeCheckAnalysis()) {
                    TapEnv.indentOnTrace(TapEnv.traceIndent());
                    TapEnv.printlnOnTrace("Transform Fortran " + instrOrExpr + " into " + newTree);
                }
                newTree.setAnnotation("sourcetree", ILUtils.copy(instrOrExpr));
                instrOrExpr = instruction.replaceTree(instrOrExpr, newTree);
            }
        }
        if (this.unit.isC() || this.unit.isCPlusPlus()) {
            newTree = null;
            if (CStuff.isAnIoCall(instrOrExpr)) {
                newTree = CStuff.buildIOCall(instrOrExpr);
            } else if (CStuff.isAMalloc(instrOrExpr)) {
                Tree assignTree = instruction.tree;
                WrapperTypeSpec resultType = null;
                if (assignTree.opCode() == 13) {
                    resultType = this.typeOf(assignTree.down(1));
                }
                if (TypeSpec.isA(resultType, 6)) {
                    assert (resultType != null);
                    resultType = ((PointerTypeSpec)resultType.wrappedType).destinationType;
                }
                if (TypeSpec.isA(resultType, 2)) {
                    assert (resultType != null);
                    resultType = resultType.wrappedType.elementType();
                }
                int typeSize = 0;
                if (resultType != null) {
                    typeSize = resultType.size();
                }
                if (typeSize < 0) {
                    typeSize = 0;
                }
                newTree = CStuff.buildAllocate(instrOrExpr, typeSize, this, instruction);
            } else if (CStuff.isAFree(instrOrExpr)) {
                newTree = CStuff.buildDeallocate(instrOrExpr);
            }
            if (TapEnv.traceTypeCheckAnalysis() && newTree != null) {
                TapEnv.indentOnTrace(TapEnv.traceIndent());
                TapEnv.printlnOnTrace("Transform C " + instrOrExpr + " into " + newTree);
            }
            instrOrExpr = instruction.replaceTree(instrOrExpr, newTree);
        }
        if (this.unit.isC() || this.unit.isCPlusPlus()) {
            newTree = null;
            if (CStuff.isAPow(this, instrOrExpr)) {
                newTree = CStuff.buildPow(instrOrExpr);
                instrOrExpr = instruction.replaceTree(instrOrExpr, newTree);
            }
            if (CStuff.isaModifiedFloatFloat(instrOrExpr)) {
                instrOrExpr = instruction.replaceTree(instrOrExpr, instrOrExpr.cutChild(2));
            }
            if (TapEnv.traceTypeCheckAnalysis() && newTree != null) {
                TapEnv.indentOnTrace(TapEnv.traceIndent());
                TapEnv.printlnOnTrace("Transform C " + instrOrExpr + " into " + newTree);
            }
        }
        return instrOrExpr;
    }

    protected WrapperTypeSpec typeCheck(Tree instrOrExpr, boolean expectResult, boolean noFunctionCall, boolean onType, Instruction instruction, ToBool isBeginning, Unit currentUnit) {
        if (TapEnv.traceTypeCheckAnalysis()) {
            TapEnv.indentOnTrace(TapEnv.traceIndent());
            TapEnv.printlnOnTrace("TypeCheck of " + instrOrExpr);
            TapEnv.setTraceIndent(TapEnv.traceIndent() + 2);
        }
        WrapperTypeSpec returnedType = null;
        if (this.unit != null) {
            instrOrExpr = this.preTypeCheck(instrOrExpr, noFunctionCall, instruction, isBeginning);
        }
        switch (instrOrExpr.opCode()) {
            case 96: 
            case 191: 
            case 201: {
                WrapperTypeSpec testType = this.typeCheck(instrOrExpr.down(1), true, false, false, instruction, isBeginning, currentUnit);
                if (this.unit == null || this.unit.isC() || SymbolTable.checkScalarBoolean(testType)) break;
                TapEnv.fileWarning(15, instrOrExpr.down(1), "(TC02) Expression is expected to be boolean, and is here " + testType.showType());
                break;
            }
            case 97: {
                WrapperTypeSpec testType = this.typeCheck(instrOrExpr.down(1), true, false, false, instruction, isBeginning, currentUnit);
                if (this.unit != null && !this.unit.isC() && !SymbolTable.checkScalarBoolean(testType)) {
                    TapEnv.fileWarning(15, instrOrExpr.down(1), "(TC02) Expression is expected to be boolean, and is here " + testType.showType());
                }
                WrapperTypeSpec typeSpec2 = this.typeCheck(instrOrExpr.down(2), true, false, false, instruction, isBeginning, currentUnit);
                WrapperTypeSpec typeSpec3 = this.typeCheck(instrOrExpr.down(3), true, false, false, instruction, isBeginning, currentUnit);
                returnedType = typeSpec2;
                break;
            }
            case 200: {
                WrapperTypeSpec testType = this.typeCheck(instrOrExpr.down(1), true, false, false, instruction, isBeginning, currentUnit);
                if (this.unit == null || this.unit.isC() || SymbolTable.checkScalarArrayBoolean(testType)) break;
                TapEnv.fileWarning(15, instrOrExpr.down(1), "(TC02) Expression is expected to be boolean, and is here " + testType.showType());
                break;
            }
            case 142: 
            case 143: {
                break;
            }
            case 119: {
                this.typeCheck(instrOrExpr.down(3), false, false, false, instruction, isBeginning, currentUnit);
                break;
            }
            case 78: {
                Tree[] ranges;
                TapEnv.toolWarning(-1, "(DD99) Warning: feature of Fortran 90/95 not supported: forall");
                for (Tree range : ranges = instrOrExpr.down(1).children()) {
                    this.typeCheck(range, false, false, false, instruction, isBeginning, currentUnit);
                }
                this.typeCheck(instrOrExpr.down(2), false, false, false, instruction, isBeginning, currentUnit);
                break;
            }
            case 63: 
            case 80: {
                WrapperTypeSpec type = this.typeCheck(instrOrExpr.down(1), true, true, false, instruction, isBeginning, currentUnit);
                if (!SymbolTable.checkScalarNumericInt(type)) {
                    TapEnv.fileWarning(15, instrOrExpr.down(1), "(TC06) Loop index is expected to be integer, and is here " + type.showType());
                }
                for (int i = 2; i < 5; ++i) {
                    if (instrOrExpr.down(i).opCode() == 136 || SymbolTable.checkScalarNumericInt(type = this.typeCheck(instrOrExpr.down(i), true, false, false, instruction, isBeginning, currentUnit))) continue;
                    TapEnv.fileWarning(15, instrOrExpr.down(i), "(TC07) Loop bound is expected to be integer, and is here " + type.showType());
                }
                break;
            }
            case 79: {
                this.typeCheck(instrOrExpr.down(1), true, true, false, instruction, isBeginning, currentUnit);
                this.typeCheck(instrOrExpr.down(2), true, true, false, instruction, isBeginning, currentUnit);
                break;
            }
            case 77: {
                WrapperTypeSpec type = this.typeCheck(instrOrExpr.down(1), true, true, false, instruction, isBeginning, currentUnit);
                if (!SymbolTable.checkScalarNumericInt(type) && !TypeSpec.isA(type, 6)) {
                    TapEnv.fileWarning(15, instrOrExpr.down(1), "(TC06) Loop index is expected to be integer, and is here " + type.showType());
                }
                this.typeCheck(instrOrExpr.down(2), true, false, false, instruction, isBeginning, currentUnit);
                type = this.typeCheck(instrOrExpr.down(3), true, false, false, instruction, isBeginning, currentUnit);
                break;
            }
            case 184: {
                WrapperTypeSpec expType = this.typeCheck(instrOrExpr.down(1), true, false, false, instruction, isBeginning, currentUnit);
                expType = this.checkPointerInFortranExpression(expType, instrOrExpr, 1);
                if (SymbolTable.checkScalarNumericInt(expType)) break;
                TapEnv.fileWarning(15, instrOrExpr.down(1), "(TC08) Loop times expression is expected to be integer, and is here " + expType.showType());
                break;
            }
            case 132: {
                returnedType = this.typeCheck(instrOrExpr.down(2), true, false, false, instruction, isBeginning, currentUnit);
                break;
            }
            case 163: {
                this.typeCheck(instrOrExpr.down(2), true, false, false, instruction, isBeginning, currentUnit);
                returnedType = this.typeCheck(instrOrExpr.down(1), true, false, false, instruction, isBeginning, currentUnit);
                break;
            }
            case 1: 
            case 14: 
            case 28: 
            case 29: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 48: 
            case 60: 
            case 68: 
            case 72: 
            case 76: 
            case 82: 
            case 83: 
            case 89: 
            case 92: 
            case 99: 
            case 102: 
            case 106: 
            case 136: 
            case 172: 
            case 173: 
            case 174: 
            case 183: 
            case 199: {
                break;
            }
            case 108: {
                WrapperTypeSpec topTypeSpec = this.typeCheck(instrOrExpr.down(1), true, noFunctionCall, false, instruction, isBeginning, currentUnit);
                this.typeCheck(instrOrExpr.down(2), true, noFunctionCall, false, instruction, isBeginning, currentUnit);
                Tree doTree = instrOrExpr.down(2);
                Tree sizeTree = ILUtils.buildSizeTree(doTree.down(2), doTree.down(3), doTree.down(4));
                ArrayDim[] newDimensions = new ArrayDim[]{new ArrayDim(ILUtils.build(58), 1, this.computeIntConstant(sizeTree), null, -1, 0, 0)};
                returnedType = new WrapperTypeSpec(new ArrayTypeSpec(topTypeSpec, newDimensions));
                break;
            }
            case 149: {
                String lhsBaseName;
                FunctionDecl functionDecl = null;
                InterfaceDecl interfaceDecl = null;
                Tree newTree = ILUtils.build(13, instrOrExpr.cutChild(1), instrOrExpr.cutChild(2));
                if (TapEnv.traceTypeCheckAnalysis()) {
                    TapEnv.indentOnTrace(TapEnv.traceIndent());
                    TapEnv.printlnOnTrace("Transform pointerAssign " + instrOrExpr + " into standard assign " + newTree);
                }
                if ((lhsBaseName = ILUtils.baseName((instrOrExpr = instruction.replaceTree(instrOrExpr, newTree)).down(1))) != null) {
                    SymbolDecl initializationSymbolDecl;
                    if (this.inCompositeTypeSpec != null && this.inCompositeTypeSpec.namedFieldType(lhsBaseName) != null) {
                        initializationSymbolDecl = this.inCompositeTypeSpec.namedFieldDecl(lhsBaseName);
                        if (initializationSymbolDecl != null) {
                            ((FieldDecl)initializationSymbolDecl).setInitializationTree(instrOrExpr);
                        }
                    } else if (instruction.tree.opCode() == 194 && (initializationSymbolDecl = this.getVariableOrConstantDecl(lhsBaseName)) != null) {
                        ((VariableDecl)initializationSymbolDecl).setInitializationTree(instrOrExpr);
                    }
                }
                WrapperTypeSpec lhsType = this.typeCheck(instrOrExpr.down(1), true, true, false, instruction, isBeginning, currentUnit);
                this.assignDestination = instrOrExpr.down(1);
                if (this.assignDestination.opCode() == 10 || this.assignDestination.opCode() == 150 || this.assignDestination.opCode() == 88 || this.assignDestination.opCode() == 126) {
                    this.assignDestination = ILUtils.baseTree(this.assignDestination);
                }
                WrapperTypeSpec rhsType = this.typeCheck(instrOrExpr.down(2), true, false, false, instruction, isBeginning, currentUnit);
                this.assignDestination = null;
                if (lhsType != null && rhsType != null) {
                    boolean pointerAssignOk;
                    if (TypeSpec.isA(lhsType, 6) && TypeSpec.isA(rhsType, 6)) {
                        pointerAssignOk = lhsType.receives(rhsType, null, null);
                    } else {
                        WrapperTypeSpec lhsBaseTypeSpec = lhsType;
                        if (TypeSpec.isA(lhsType, 6)) {
                            lhsBaseTypeSpec = ((PointerTypeSpec)lhsType.wrappedType).destinationType;
                        } else {
                            TapEnv.fileWarning(15, instrOrExpr, "(TC60) " + ILUtils.toString(instrOrExpr.down(1)) + " must be a pointer");
                        }
                        WrapperTypeSpec rhsBaseTypeSpec = rhsType;
                        if (TypeSpec.isA(rhsType, 6)) {
                            rhsBaseTypeSpec = ((PointerTypeSpec)rhsType.wrappedType).destinationType;
                        }
                        pointerAssignOk = lhsBaseTypeSpec.receives(rhsBaseTypeSpec, null, null);
                    }
                    if (!pointerAssignOk) {
                        TapEnv.fileWarning(15, instrOrExpr, "(TC16) Type mismatch in pointer assignment: " + lhsType.showType() + " receives " + rhsType.showType());
                    }
                    if (instrOrExpr.down(2).opCode() == 148) {
                        Tree withoutPointerAccessTree = ILUtils.copy(instrOrExpr.down(2).down(1));
                        instrOrExpr.setChild(withoutPointerAccessTree, instrOrExpr.down(2).rankInParent());
                    } else if (!TypeSpec.isA(rhsType, 6)) {
                        Tree addressTree = ILUtils.build(3, ILUtils.copy(instrOrExpr.down(2)));
                        instrOrExpr.setChild(addressTree, instrOrExpr.down(2).rankInParent());
                    }
                    TapList<InterfaceDecl> interfaceDecls = this.getInterfaceDecl(instrOrExpr.opName());
                    if (interfaceDecls != null) {
                        interfaceDecl = (InterfaceDecl)interfaceDecls.head;
                    }
                    if (interfaceDecl != null) {
                        WrapperTypeSpec[] types = new WrapperTypeSpec[]{lhsType, rhsType};
                        functionDecl = interfaceDecl.findFunctionDecl(types, null, instrOrExpr);
                    }
                    if (functionDecl != null) {
                        Tree newBinaryTree = ILUtils.build(16, instrOrExpr.down(1).copy(), ILUtils.build(94, instrOrExpr.opName()), instrOrExpr.down(2).copy());
                        newTree = ILUtils.buildCall(ILUtils.build(136), ILUtils.build(94, instrOrExpr.opName()), ILUtils.build(70, instrOrExpr.down(1).copy(), instrOrExpr.down(2).copy()));
                        if (TapEnv.traceTypeCheckAnalysis()) {
                            TapEnv.indentOnTrace(TapEnv.traceIndent());
                            TapEnv.printlnOnTrace("Replace " + instrOrExpr + " with explicit call " + newTree);
                        }
                        instrOrExpr = instruction.replaceTree(instrOrExpr, newTree);
                        instrOrExpr.setAnnotation("sourcetree", newBinaryTree);
                        CallArrow callArrow = CallGraph.addCallArrow(this.unit, 1, functionDecl.unit());
                        callArrow.setSrcCallName("pointerAssign");
                        instrOrExpr.setAnnotation("callArrow", callArrow);
                        returnedType = functionDecl.functionTypeSpec().returnType;
                    }
                } else {
                    TapEnv.fileWarning(15, instrOrExpr, "(TC16) Type mismatch in pointer assignment: " + (lhsType == null ? "?" : lhsType.showType()) + " receives " + (rhsType == null ? "?" : rhsType.showType()));
                }
                if (returnedType != null) break;
                returnedType = lhsType != null ? lhsType : rhsType;
                break;
            }
            case 13: {
                WrapperTypeSpec lhsType = this.typeCheck(instrOrExpr.down(1), true, true, false, instruction, isBeginning, currentUnit);
                FunctionDecl functionDecl = null;
                this.assignDestination = instrOrExpr.down(1);
                if (this.assignDestination.opCode() == 10 || this.assignDestination.opCode() == 150 || this.assignDestination.opCode() == 88 || this.assignDestination.opCode() == 126) {
                    this.assignDestination = ILUtils.baseTree(this.assignDestination);
                }
                WrapperTypeSpec rhsType = this.typeCheck(instrOrExpr.down(2), true, false, false, instruction, isBeginning, currentUnit);
                if (!(this.unit == null || this.language != 1 || !TypeSpec.isA(lhsType, 2) || this.unit.isIntrinsic() || this.isCallNotElemental(instrOrExpr.down(2)) || instrOrExpr.down(2).opCode() == 9 || lhsType.isString() || lhsType.isCharacter())) {
                    this.unit.setHasArrayNotation();
                }
                this.assignDestination = null;
                lhsType = this.checkPointerInFortranExpression(lhsType, instrOrExpr, 1);
                rhsType = this.checkPointerInFortranExpression(rhsType, instrOrExpr, 2);
                if (lhsType != null && rhsType != null) {
                    TapList<InterfaceDecl> interfaceDecls = this.getInterfaceDecl(instrOrExpr.opName());
                    WrapperTypeSpec[] types = new WrapperTypeSpec[]{lhsType, rhsType};
                    while (interfaceDecls != null && functionDecl == null) {
                        InterfaceDecl interfaceDecl = (InterfaceDecl)interfaceDecls.head;
                        functionDecl = interfaceDecl.findFunctionDecl(types, null, instrOrExpr);
                        interfaceDecls = interfaceDecls.tail;
                    }
                }
                if (lhsType != null && rhsType != null) {
                    if (functionDecl != null) {
                        Tree newBinaryTree = ILUtils.build(16, instrOrExpr.down(1).copy(), ILUtils.build(94, instrOrExpr.opName()), instrOrExpr.down(2).copy());
                        Tree newTree = ILUtils.buildCall(ILUtils.build(136), ILUtils.build(94, instrOrExpr.opName()), ILUtils.build(70, instrOrExpr.down(1).copy(), instrOrExpr.down(2).copy()));
                        if (TapEnv.traceTypeCheckAnalysis()) {
                            TapEnv.indentOnTrace(TapEnv.traceIndent());
                            TapEnv.printlnOnTrace("Replace " + instrOrExpr + " with explicit call " + newTree);
                        }
                        instrOrExpr = instruction.replaceTree(instrOrExpr, newTree);
                        instrOrExpr.setAnnotation("sourcetree", newBinaryTree);
                        CallArrow callArrow = CallGraph.addCallArrow(this.unit, 1, functionDecl.unit());
                        callArrow.setSrcCallName("assign");
                        instrOrExpr.setAnnotation("callArrow", callArrow);
                        returnedType = functionDecl.functionTypeSpec().returnType;
                        break;
                    }
                    if (!lhsType.receives(rhsType, null, null)) {
                        if (instruction == null || instruction.tree == null || instruction.tree.opCode() == 194 || !TypeSpec.isA(lhsType, 12)) {
                            TapEnv.fileWarning(15, instrOrExpr, "(TC16) Type mismatch in assignment: " + lhsType.showType() + " receives " + rhsType.showType());
                            returnedType = null;
                            break;
                        }
                        returnedType = lhsType;
                        break;
                    }
                } else {
                    TapEnv.fileWarning(15, instrOrExpr, "(TC16) Type mismatch in assignment: " + (lhsType == null ? "?" : lhsType.showType()) + " receives " + (rhsType == null ? "?" : rhsType.showType()));
                }
                if ((TapEnv.relatedLanguageIsC() || TapEnv.relatedLanguageIsCPLUSPLUS()) && WrapperTypeSpec.isFunctionOrPointerToFunction(lhsType)) {
                    String funcVarName = ILUtils.baseName(instrOrExpr.down(1));
                    TapList<FunctionDecl> functionDecls = this.getFunctionDecl(funcVarName, null, null, false);
                    functionDecl = functionDecls == null ? null : (FunctionDecl)functionDecls.head;
                    VariableDecl funcVarDecl = null;
                    if (functionDecl == null) {
                        funcVarDecl = this.getFuncVarDecl(funcVarName);
                    }
                    String rightName = ILUtils.baseName(instrOrExpr.down(2));
                    FunctionDecl initFunDecl = null;
                    if (rightName != null) {
                        TapList<FunctionDecl> initFunDecls = this.getFunctionDecl(rightName, null, null, false);
                        FunctionDecl functionDecl2 = initFunDecl = initFunDecls == null ? null : (FunctionDecl)initFunDecls.head;
                    }
                    if (instrOrExpr.down(2).opCode() == 94 && initFunDecl != null && (functionDecl != null || funcVarDecl != null)) {
                        if (functionDecl != null) {
                            functionDecl.initFunctionDecls = new FunctionDecl[]{initFunDecl};
                        } else if (funcVarDecl != null) {
                            funcVarDecl.initFunctionDecls = new FunctionDecl[]{initFunDecl};
                        }
                    } else {
                        TapEnv.toolWarning(-1, "(DD99) Warning: feature of C/C++ not supported: function assignment " + ILUtils.toString(instrOrExpr));
                    }
                }
                returnedType = lhsType != null ? lhsType : rhsType;
                break;
            }
            case 18: 
            case 22: 
            case 24: 
            case 62: 
            case 115: 
            case 123: 
            case 125: 
            case 147: 
            case 165: 
            case 185: {
                int opRank;
                switch (instrOrExpr.opCode()) {
                    case 147: {
                        opRank = 2;
                        break;
                    }
                    case 123: {
                        opRank = 177;
                        break;
                    }
                    case 185: {
                        opRank = 131;
                        break;
                    }
                    case 62: {
                        opRank = 61;
                        break;
                    }
                    case 125: {
                        opRank = 124;
                        break;
                    }
                    case 18: {
                        opRank = 17;
                        break;
                    }
                    case 22: {
                        opRank = 21;
                        break;
                    }
                    case 24: {
                        opRank = 23;
                        break;
                    }
                    case 115: {
                        opRank = 114;
                        break;
                    }
                    case 165: {
                        opRank = 164;
                        break;
                    }
                    default: {
                        opRank = 2;
                    }
                }
                WrapperTypeSpec lhsType = this.typeCheck(instrOrExpr.down(1), true, true, false, instruction, isBeginning, currentUnit);
                WrapperTypeSpec rhsType = this.typeCheck(instrOrExpr.down(2), true, false, false, instruction, isBeginning, currentUnit);
                if (lhsType != null && rhsType != null && this.canCombineNumeric(lhsType, rhsType, instrOrExpr) == null) {
                    TapEnv.fileWarning(15, instrOrExpr, "(TC16) Type mismatch in op-assignment: " + lhsType.showType() + " receives " + rhsType.showType());
                }
                Tree oldTree = instrOrExpr;
                Tree newTree = ILUtils.build(13, instrOrExpr.down(1).copy(), ILUtils.build(opRank, instrOrExpr.down(1).copy(), instrOrExpr.down(2).copy()));
                if (TapEnv.traceTypeCheckAnalysis()) {
                    TapEnv.indentOnTrace(TapEnv.traceIndent());
                    TapEnv.printlnOnTrace("Expand " + instrOrExpr + " into explicit " + newTree);
                }
                instrOrExpr = instruction.replaceTree(instrOrExpr, newTree);
                instrOrExpr.setAnnotation("sourcetree", oldTree);
                returnedType = lhsType != null ? lhsType : rhsType;
                break;
            }
            case 179: {
                Tree[] switchCasesTree;
                WrapperTypeSpec switchType = this.typeCheck(instrOrExpr.down(1), true, false, false, instruction, isBeginning, currentUnit);
                for (Tree tree : switchCasesTree = instrOrExpr.down(2).children()) {
                    Tree[] expressions = tree.down(1).children();
                    int numberExp = expressions.length;
                    for (int j = 0; j < numberExp; ++j) {
                        WrapperTypeSpec caseType = this.typeCheck(expressions[j], true, noFunctionCall, false, instruction, isBeginning, currentUnit);
                        if (caseType == null || switchType == null || TypeSpec.canCompare(switchType, caseType)) continue;
                        TapEnv.fileWarning(15, instrOrExpr, "(TC17) Type mismatch in case: " + switchType.showType() + " compared to " + caseType.showType());
                    }
                }
                returnedType = switchType;
                break;
            }
            case 30: {
                Instruction implicitInstr;
                TapList<FunctionDecl> functionDeclsToDeclare;
                VariableDecl funcVarDecl;
                int k;
                int k2;
                Instruction newInstr;
                MPIcallInfo messagePassingInfo;
                String functionName = ILUtils.getCallFunctionNameString(instrOrExpr);
                if (functionName == null) {
                    TapEnv.fileError(instrOrExpr, "(TC55) Fatal error, null function name call " + ILUtils.toString(instrOrExpr));
                    break;
                }
                if (functionName.startsWith("operator")) {
                    TapEnv.toolError("Type-checking of operators (" + functionName + ") is not yet implemented");
                    break;
                }
                if (this.unit != null && (messagePassingInfo = MPIcallInfo.getMessagePassingMPIcallInfo(functionName, instrOrExpr, this.language, instruction.block)) != null && messagePassingInfo.isPointToPoint()) {
                    messagePassingInfo.registerMessagePassingChannel(this.unit.callGraph());
                }
                Tree[] actualArgs = ILUtils.getArguments(instrOrExpr).children();
                int nbActualArgs = actualArgs.length;
                TypeSpec[] actualArgsTypes = new WrapperTypeSpec[nbActualArgs];
                WrapperTypeSpec[] nameEqTypes = new WrapperTypeSpec[nbActualArgs];
                int rankOfFirstNameEq = -1;
                for (int i = 0; i < nbActualArgs; ++i) {
                    WrapperTypeSpec actualArgType = this.typeCheck(actualArgs[i], true, false, false, instruction, isBeginning, currentUnit);
                    actualArgType = this.arrayTypeIfElementalCall(instrOrExpr, i, actualArgType);
                    if (actualArgs[i].opCode() == 132) {
                        if (rankOfFirstNameEq == -1) {
                            rankOfFirstNameEq = i;
                        }
                        nameEqTypes[i] = actualArgType;
                        actualArgsTypes[i] = null;
                        continue;
                    }
                    actualArgsTypes[i] = actualArgs[i].opCode() == 136 ? new WrapperTypeSpec(null) : actualArgType;
                }
                if (rankOfFirstNameEq == -1) {
                    rankOfFirstNameEq = nbActualArgs;
                }
                WrapperTypeSpec actualReturnTypeExpected = null;
                if (instrOrExpr.parent() != null && (instrOrExpr.parent().opCode() == 13 || instrOrExpr.parent().opCode() == 149)) {
                    actualReturnTypeExpected = this.typeOf(instrOrExpr.parent().down(1));
                }
                SymbolTable currentSymbolTable = this;
                TapList<FunctionDecl> localFunctionDecls = null;
                InterfaceDecl localInterfaceDecl = null;
                TapList<FunctionDecl> functionDecls = null;
                FunctionDecl functionDecl = null;
                Unit[] functionUnits = null;
                boolean needVarDeclInstruction = true;
                FunctionTypeSpec[] functionTypeSpecs = null;
                Tree objectTree = ILUtils.getObject(instrOrExpr);
                Unit objectClassUnit = null;
                WrapperTypeSpec objectType = this.typeCheck(objectTree, false, false, false, instruction, isBeginning, currentUnit);
                if (TypeSpec.isA(objectType, 23)) {
                    objectClassUnit = ((ClassTypeSpec)objectType.wrappedType).unit;
                }
                if (objectClassUnit != null) {
                    currentSymbolTable = ILUtils.isIdent(objectTree, "this", true) ? objectClassUnit.privateSymbolTable() : objectClassUnit.publicSymbolTable();
                } else {
                    Tree calledName = ILUtils.getCalledName(instrOrExpr);
                    if (calledName.opCode() == 168) {
                        currentSymbolTable = this.getPrefixedNamedScope(calledName.down(1));
                    }
                }
                if (TapEnv.traceTypeCheckAnalysis()) {
                    TapEnv.indentOnTrace(TapEnv.traceIndent());
                    TapEnv.printlnOnTrace("Search for the function declaration(s) that match call " + functionName + new FunctionTypeSpec(actualReturnTypeExpected, (WrapperTypeSpec[])actualArgsTypes) + " on object " + objectTree + ':' + objectClassUnit + " in SymbolTable:" + currentSymbolTable.addressChain());
                    TapEnv.setTraceIndent(TapEnv.traceIndent() + 2);
                }
                if (this.unit != null && this.unit.isCPlusPlus()) {
                    if (currentSymbolTable == null) {
                        TapEnv.fileWarning(15, ILUtils.getCalledName(instrOrExpr), "(TC67) Wrong access to the called function " + functionName);
                        returnedType = actualReturnTypeExpected;
                        break;
                    }
                    SymbolTable tmpSymbolTable = currentSymbolTable;
                    localFunctionDecls = currentSymbolTable.getAllPossibleTypedFunctionDecl(functionName, actualReturnTypeExpected, actualArgsTypes, tmpSymbolTable, null, true, true, false, false, null, false);
                    if (localFunctionDecls == null) {
                        tmpSymbolTable = currentSymbolTable;
                        while (tmpSymbolTable.basisSymbolTable != null && localFunctionDecls == null) {
                            tmpSymbolTable = tmpSymbolTable.basisSymbolTable;
                            localFunctionDecls = currentSymbolTable.getAllPossibleTypedFunctionDecl(functionName, actualReturnTypeExpected, actualArgsTypes, tmpSymbolTable, null, true, true, false, true, null, false);
                        }
                    }
                } else {
                    while (localFunctionDecls == null && localInterfaceDecl == null && currentSymbolTable.basisSymbolTable != null && !currentSymbolTable.isFormalParams) {
                        TapList<InterfaceDecl> interfaceDecls;
                        FunctionDecl localFunctionDecl = currentSymbolTable.getTypedFunctionDecl(functionName, actualReturnTypeExpected, (WrapperTypeSpec[])actualArgsTypes, true, instrOrExpr);
                        if (localFunctionDecl != null && localFunctionDecl.kind() != 16) {
                            localFunctionDecls = new TapList<FunctionDecl>(localFunctionDecl, localFunctionDecls);
                        }
                        if ((localInterfaceDecl = currentSymbolTable.getTopInterfaceDecl(functionName)) == null && (interfaceDecls = this.getInterfaceDecl(functionName)) != null) {
                            localFunctionDecls = null;
                        }
                        currentSymbolTable = currentSymbolTable.basisSymbolTable;
                    }
                }
                FunctionDecl mixedLanguageFunctionDecl = this.mixedLanguageCall(functionName, localFunctionDecls == null ? null : (FunctionDecl)localFunctionDecls.head);
                boolean isMixedLanguageCall = mixedLanguageFunctionDecl != null;
                boolean symbolFoundAsParam = false;
                while (currentSymbolTable.basisSymbolTable != null && functionDecls == null) {
                    SymbolDecl paramSymbolDecl = null;
                    if (currentSymbolTable.isFormalParams && !currentSymbolTable.unit.isModule() && (paramSymbolDecl = currentSymbolTable.getTopSymbolDecl(functionName)) == null) {
                        paramSymbolDecl = currentSymbolTable.getTopInterfaceDecl(functionName);
                    }
                    if (paramSymbolDecl != null) {
                        Unit varFunctionUnit;
                        symbolFoundAsParam = true;
                        if (paramSymbolDecl.isA(3)) {
                            functionDecl = (FunctionDecl)paramSymbolDecl;
                        } else if (paramSymbolDecl.isA(16)) {
                            functionDecl = ((InterfaceDecl)paramSymbolDecl).functionDecl();
                            functionTypeSpecs = functionDecl.unit().isTotallyDeclared ? new FunctionTypeSpec[]{functionDecl.functionTypeSpec()} : new FunctionTypeSpec[]{new FunctionTypeSpec(new WrapperTypeSpec(null))};
                            varFunctionUnit = Unit.makeVarFunction(functionName, this.unit);
                            varFunctionUnit.setFunctionTypeSpec(functionTypeSpecs[0]);
                            functionDecl = new FunctionDecl(ILUtils.getCalledName(instrOrExpr), varFunctionUnit);
                            functionDecl.setInterfaceInstr(true);
                            if (this.unit != null && this.unit.isFortran()) {
                                currentSymbolTable.addSymbolDecl(functionDecl);
                            }
                        } else if (paramSymbolDecl.isA(1) && !paramSymbolDecl.symbol.equals(this.unit.name)) {
                            varFunctionUnit = Unit.makeVarFunction(functionName, this.unit);
                            varFunctionUnit.setFunctionTypeSpec(new FunctionTypeSpec(paramSymbolDecl.type()));
                            functionDecl = new FunctionDecl(ILUtils.getCalledName(instrOrExpr), varFunctionUnit);
                            if (this.unit != null && this.unit.isFortran()) {
                                currentSymbolTable.addSymbolDecl(functionDecl);
                            }
                        }
                        if (functionDecl != null) {
                            functionDecls = new TapList<FunctionDecl>(functionDecl, null);
                        }
                    } else {
                        InterfaceDecl interfaceDecl;
                        if (functionDecls == null && (interfaceDecl = currentSymbolTable.getTopInterfaceDecl(functionName)) != null && (functionDecl = interfaceDecl.findFunctionDecl((WrapperTypeSpec[])actualArgsTypes, null, instrOrExpr)) != null) {
                            functionDecls = new TapList<FunctionDecl>(functionDecl, null);
                        }
                        if (functionDecls == null) {
                            functionDecls = currentSymbolTable.getTopFunctionDecl(functionName, actualReturnTypeExpected, actualArgsTypes, null, true);
                        }
                        if (functionDecls == null) {
                            functionDecls = currentSymbolTable.getTopFunctionDecl(functionName, null, null, null, false);
                        }
                    }
                    currentSymbolTable = currentSymbolTable.basisSymbolTable;
                }
                if (localFunctionDecls == null && functionDecls == null && isMixedLanguageCall && mixedLanguageFunctionDecl.unit().isC()) {
                    functionDecl = mixedLanguageFunctionDecl;
                    functionDecls = new TapList<FunctionDecl>(mixedLanguageFunctionDecl, null);
                    TapEnv.fileWarning(15, ILUtils.getCalledName(instrOrExpr), "(TC33) External C procedure " + functionName + " is not declared");
                }
                if (functionDecls == null && functionTypeSpecs == null) {
                    functionDecl = this.getTypedFunctionDecl(functionName, null, (WrapperTypeSpec[])actualArgsTypes, false, instrOrExpr);
                    if (functionDecl == null) {
                        VariableDecl vDecl = null;
                        if (this.unit != null) {
                            vDecl = (VariableDecl)this.unit.getImportedDecl(functionName, 1);
                        }
                        if (vDecl != null) {
                            Tree arrayTree = ILUtils.build(8, ILUtils.getCalledName(instrOrExpr), ILUtils.getArguments(instrOrExpr));
                            Tree father = instrOrExpr.parent();
                            if (father != null) {
                                father.setChild(arrayTree, instrOrExpr.rankInParent());
                            }
                            returnedType = this.typeCheck(arrayTree, true, true, false, instruction, isBeginning, currentUnit);
                            break;
                        }
                        TapList<InterfaceDecl> interfaceDecls = this.getInterfaceDecl(functionName);
                        if (interfaceDecls == null) {
                            VariableDecl varDecl = this.getVariableDecl(functionName);
                            if (functionUnits == null) {
                                if (varDecl == null || !varDecl.isExternal() && !TypeSpec.isA(varDecl.type(), 6) && !TypeSpec.isA(varDecl.type(), 3)) {
                                    TapEnv.fileWarning(15, ILUtils.getCalledName(instrOrExpr), "(TC33) External procedure " + functionName + " is not declared");
                                }
                                functionUnits = new Unit[]{this.buildExternalUnit(functionName, false)};
                                if (varDecl != null) {
                                    if (TypeSpec.isA(varDecl.type(), 3)) {
                                        functionUnits[0].setFunctionTypeSpec((FunctionTypeSpec)varDecl.type().wrappedType);
                                    } else {
                                        functionUnits[0].setFunctionTypeSpec(new FunctionTypeSpec(varDecl.type()));
                                    }
                                } else {
                                    functionUnits[0].setFunctionTypeSpec(new FunctionTypeSpec(null));
                                }
                            }
                        } else {
                            functionDecl = ((InterfaceDecl)interfaceDecls.head).findOneFunctionDecl((WrapperTypeSpec[])actualArgsTypes, instrOrExpr);
                            if (functionDecl == null) {
                                functionUnits = new Unit[]{this.buildExternalUnit(functionName, false)};
                            }
                            TapEnv.fileWarning(15, ILUtils.getCalledName(instrOrExpr), "(TC34) Found no specific procedure that matches generic interface call: " + ILUtils.toString(instrOrExpr) + "; Took fallback choice: " + (functionDecl == null ? "null" : functionDecl.symbol));
                        }
                    }
                    if (functionDecl == null) {
                        functionDecl = new FunctionDecl(ILUtils.baseTree(ILUtils.getCalledName(instrOrExpr)), (Unit)functionUnits[0]);
                        currentSymbolTable = this.getCallGraph().languageRootSymbolTable(currentSymbolTable.language);
                        if (functionDecl.symbol != null) {
                            currentSymbolTable.addSymbolDecl(functionDecl);
                        } else {
                            TapEnv.toolWarning(-1, "(DD99) Warning: feature of C not supported: non-immediate function name in " + ILUtils.toString(instrOrExpr));
                        }
                        if (!(this.unit == null || this.unit.isCorMore() || this.declarationsBlock == null || functionDecl.hasInstructionWithRootOperator(72, null) || functionDecl.hasInstructionWithRootOperator(106, null) || functionDecl.isExternalDeclared(this.declarationsBlock.instructions) || functionDecl.hasInterfaceInstruction())) {
                            newInstr = new Instruction(ILUtils.build(72, ILUtils.build(94, functionName)));
                            this.unit.privateSymbolTable().declarationsBlock.addInstrDeclTlBeforeUse(newInstr, new TapList<SymbolDecl>(functionDecl, null), null, this, true);
                            functionDecl.setInstruction(newInstr);
                        }
                        if (functionUnits[0].functionTypeSpec() == null) {
                            functionUnits[0].setFunctionTypeSpec(new FunctionTypeSpec(new WrapperTypeSpec(null)));
                        }
                    }
                    functionDecls = new TapList<FunctionDecl>(functionDecl, null);
                }
                if (TapEnv.traceTypeCheckAnalysis()) {
                    TapEnv.setTraceIndent(TapEnv.traceIndent() - 2);
                    TapEnv.indentOnTrace(TapEnv.traceIndent());
                    TapEnv.printlnOnTrace("Found function declaration(s) that match this call:" + functionDecls);
                }
                if (localFunctionDecls == null && functionTypeSpecs == null && this.unit != null && this.unit.isFortran()) {
                    functionDecl = (FunctionDecl)functionDecls.head;
                    if (functionDecl.isVarFunction()) {
                        localFunctionDecls = new TapList<FunctionDecl>(functionDecl, null);
                    } else {
                        localFunctionDecls = new TapList<FunctionDecl>((FunctionDecl)functionDecl.copy(null, null), null);
                        functionDecl.copySymbolDecl = null;
                    }
                    if (this.unit.isModule()) {
                        this.unit.publicSymbolTable().addSymbolDecl((SymbolDecl)localFunctionDecls.head);
                    } else if (((FunctionDecl)localFunctionDecls.head).symbol != null) {
                        if (isMixedLanguageCall) {
                            ((FunctionDecl)localFunctionDecls.head).symbol = functionName;
                            ((FunctionDecl)localFunctionDecls.head).renamedFromSymbolDecl = functionDecl;
                        }
                        this.unit.privateSymbolTable().addSymbolDecl((SymbolDecl)localFunctionDecls.head);
                        if (this.declarationsBlock != null && !this.unit.isCorMore() && (((FunctionDecl)localFunctionDecls.head).isIntrinsic() && !((FunctionDecl)localFunctionDecls.head).isIntrinsicDeclared(this.declarationsBlock.instructions) || ((FunctionDecl)localFunctionDecls.head).isExternal() && !((FunctionDecl)localFunctionDecls.head).isExternalDeclared(this.declarationsBlock.instructions) || ((FunctionDecl)functionDecls.head).isVarFunction() && !((FunctionDecl)localFunctionDecls.head).isIntrinsicDeclared(this.declarationsBlock.instructions) && !((FunctionDecl)localFunctionDecls.head).isExternalDeclared(this.declarationsBlock.instructions) && !((FunctionDecl)localFunctionDecls.head).hasInterfaceInstruction()) && !instruction.isADeclaration(false)) {
                            newInstr = new Instruction(ILUtils.build(((FunctionDecl)localFunctionDecls.head).isIntrinsic() ? 106 : 72, ILUtils.build(94, functionName)));
                            if (((FunctionDecl)localFunctionDecls.head).isIntrinsic()) {
                                newInstr.isPhantom = true;
                            }
                            this.unit.privateSymbolTable().declarationsBlock.addInstrDeclTlBeforeUse(newInstr, null, null, null, true);
                            ((FunctionDecl)localFunctionDecls.head).setInstruction(newInstr);
                        }
                    }
                }
                int nbFunctionDecls = TapList.length(functionDecls);
                if (functionDecls != null) {
                    mixedLanguageFunctionDecl = this.mixedLanguageCall(functionName, (FunctionDecl)functionDecls.head);
                    isMixedLanguageCall = mixedLanguageFunctionDecl != null;
                    TapList<FunctionDecl> tmpFunctionDecls = functionDecls;
                    functionUnits = new Unit[nbFunctionDecls];
                    for (int index = 0; index < nbFunctionDecls; ++index) {
                        functionUnits[index] = ((FunctionDecl)tmpFunctionDecls.head).unit();
                        tmpFunctionDecls = tmpFunctionDecls.tail;
                    }
                }
                FunctionTypeSpec functionTypeSpec = null;
                if (functionTypeSpecs == null) {
                    functionTypeSpecs = new FunctionTypeSpec[nbFunctionDecls];
                    functionTypeSpec = functionUnits[0].functionTypeSpec();
                }
                if (functionTypeSpec == null) {
                    for (k2 = nbFunctionDecls - 1; k2 >= 0; --k2) {
                        functionTypeSpec = new FunctionTypeSpec(new WrapperTypeSpec(null));
                        functionUnits[k2].setFunctionTypeSpec(functionTypeSpec);
                        functionTypeSpecs[k2] = functionTypeSpec;
                    }
                } else {
                    for (k2 = nbFunctionDecls - 1; k2 >= 0; --k2) {
                        functionTypeSpecs[k2] = functionUnits[k2].functionTypeSpec();
                    }
                }
                WrapperTypeSpec localizedFormalReturnType = functionTypeSpec.returnType;
                WrapperTypeSpec[] localizedFormalArgsTypes = null;
                FunctionTypeSpec[] localizedFormalFunctionTypeSpecs = new FunctionTypeSpec[functionTypeSpecs.length];
                if (functionTypeSpec.argumentsTypes == null) {
                    for (k = nbFunctionDecls - 1; k >= 0; --k) {
                        localizedFormalArgsTypes = new WrapperTypeSpec[nbActualArgs];
                        for (int i = 0; i < nbActualArgs; ++i) {
                            localizedFormalArgsTypes[i] = new WrapperTypeSpec(null);
                        }
                        functionTypeSpecs[k].argumentsTypes = localizedFormalArgsTypes;
                        localizedFormalFunctionTypeSpecs[k] = functionTypeSpecs[k];
                        localizedFormalReturnType = functionTypeSpecs[k].returnType;
                    }
                } else {
                    for (k = 0; k < nbFunctionDecls; ++k) {
                        FunctionTypeSpec annotFTS = (FunctionTypeSpec)instrOrExpr.getAnnotation("functionTypeSpec");
                        if (annotFTS == null) {
                            WrapperTypeSpec baseReturnType;
                            TapList<Object> toAlreadySolved = new TapList<Object>(null, null);
                            if (TapEnv.traceTypeCheckAnalysis()) {
                                TapEnv.indentOnTrace(TapEnv.traceIndent());
                                TapEnv.printlnOnTrace("Declared function Type:" + functionTypeSpecs[k]);
                            }
                            if (functionTypeSpecs[k].containsMetaType(null)) {
                                localizedFormalFunctionTypeSpecs[k] = (FunctionTypeSpec)functionTypeSpecs[k].localize(toAlreadySolved, new ToBool(false));
                                if (TapEnv.traceTypeCheckAnalysis()) {
                                    TapEnv.indentOnTrace(TapEnv.traceIndent());
                                    TapEnv.printlnOnTrace("Localized function Type:" + localizedFormalFunctionTypeSpecs[k]);
                                }
                            } else {
                                localizedFormalFunctionTypeSpecs[k] = functionTypeSpecs[k];
                            }
                            localizedFormalFunctionTypeSpecs[k].matchArgumentsTypes((WrapperTypeSpec[])actualArgsTypes, this.unit, functionUnits[k]);
                            FunctionTypeSpec.finishLastMetaTypes(toAlreadySolved, this);
                            if (TapEnv.traceTypeCheckAnalysis()) {
                                TapEnv.indentOnTrace(TapEnv.traceIndent());
                                TapEnv.printlnOnTrace("Matched function Type:" + localizedFormalFunctionTypeSpecs[k]);
                            }
                            localizedFormalReturnType = localizedFormalFunctionTypeSpecs[k].returnType;
                            if (this.unit != null && this.unit.isFortran() && ("sum".equals(functionName) || "spread".equals(functionName))) {
                                if (this.unit.isFortran9x()) {
                                    actualArgsTypes[0] = this.checkPointerInFortranExpression((WrapperTypeSpec)actualArgsTypes[0], ILUtils.getArguments(instrOrExpr), 1);
                                    actualArgs[0] = ILUtils.getArguments(instrOrExpr).down(1);
                                }
                                if ("sum".equals(functionName)) {
                                    localizedFormalReturnType = this.sumResultType((WrapperTypeSpec)actualArgsTypes[0], ILUtils.getOptionalDim(actualArgs, this));
                                } else if ("spread".equals(functionName)) {
                                    Tree newDim = ILUtils.build(58, ILUtils.build(101, 1), ILUtils.copy(actualArgs[2]));
                                    localizedFormalReturnType = this.spreadResultType((WrapperTypeSpec)actualArgsTypes[0], actualArgs[1], newDim);
                                }
                                localizedFormalFunctionTypeSpecs[k].returnType = localizedFormalReturnType;
                            }
                            if (localizedFormalReturnType != null && TypeSpec.isA(baseReturnType = localizedFormalReturnType.baseTypeSpec(false), 7)) {
                                baseReturnType.wrappedType.setUndefinedNumeric(false);
                            }
                            if (localizedFormalFunctionTypeSpecs[k] == functionTypeSpecs[k]) continue;
                            instrOrExpr.setAnnotation("functionTypeSpec", localizedFormalFunctionTypeSpecs[k]);
                            continue;
                        }
                        localizedFormalFunctionTypeSpecs[k] = annotFTS;
                        localizedFormalReturnType = localizedFormalFunctionTypeSpecs[k].returnType;
                    }
                    localizedFormalArgsTypes = new WrapperTypeSpec[localizedFormalFunctionTypeSpecs[0].argumentsTypes.length];
                    System.arraycopy(localizedFormalFunctionTypeSpecs[0].argumentsTypes, 0, localizedFormalArgsTypes, 0, localizedFormalFunctionTypeSpecs[0].argumentsTypes.length);
                }
                WrapperTypeSpec arrayReturnTypeSpec = null;
                boolean elementalCall = false;
                if (localizedFormalArgsTypes != null) {
                    int i;
                    int nbFormalArgs = localizedFormalArgsTypes.length;
                    Tree newCallTree = ILUtils.copy(instrOrExpr);
                    Tree optionalTree = ILUtils.copy(newCallTree);
                    for (int i2 = 0; i2 < localizedFormalArgsTypes.length; ++i2) {
                        ILUtils.getArguments(optionalTree).setChild(ILUtils.build(136), i2 + 1);
                    }
                    boolean needAnnot = false;
                    int optNb = 0;
                    ToBool callUsesNameEq = new ToBool(false);
                    if (!(functionUnits[0] == null || functionUnits[0].isExternal() || rankOfFirstNameEq >= nbActualArgs && nbFormalArgs <= nbActualArgs)) {
                        actualArgsTypes = functionUnits[0].typeCheckNameEqOptionalArguments(this, actualArgs, (WrapperTypeSpec[])actualArgsTypes, nameEqTypes, rankOfFirstNameEq, newCallTree, optionalTree, callUsesNameEq);
                        needAnnot = true;
                    } else {
                        newCallTree = ILUtils.copy(instrOrExpr);
                    }
                    Tree[] sons = ILUtils.getArguments(newCallTree).children();
                    for (i = sons.length; i > 0; --i) {
                        if (sons[i - 1] != null && (sons[i - 1].opCode() != 132 || sons[i - 1].down(2).opCode() != 136)) continue;
                        ILUtils.getArguments(newCallTree).setChild(ILUtils.build(136), i);
                    }
                    if (functionUnits[0] != null && (nbFormalArgs != nbActualArgs || functionUnits[0].isCPlusPlus())) {
                        boolean ok;
                        functionUnits[0].typeCheckOptionalArguments((WrapperTypeSpec[])actualArgsTypes, newCallTree, optionalTree, callUsesNameEq);
                        optNb = functionUnits[0].isCPlusPlus() ? 0 : functionUnits[0].getOptionalParameterDeclsNumber();
                        boolean bl = ok = nbFormalArgs - optNb <= nbActualArgs && nbActualArgs <= nbFormalArgs;
                        if (!functionUnits[0].functionTypeSpec().variableArgList) {
                            if (!ok) {
                                if (functionUnits[0].isC() && functionUnits[0].isExternal() && functionUnits[0].functionTypeSpec().argumentsTypes.length == 0) {
                                    functionUnits[0].functionTypeSpec().argumentsTypes = new WrapperTypeSpec[nbActualArgs];
                                    System.arraycopy(actualArgsTypes, 0, functionUnits[0].functionTypeSpec().argumentsTypes, 0, nbActualArgs);
                                }
                                TapEnv.fileWarning(15, instrOrExpr, "(TC32) Conflicting numbers of arguments for procedure " + functionName + ", expected " + nbFormalArgs + ", is here " + nbActualArgs);
                            } else {
                                needAnnot = true;
                            }
                        }
                        if (nbFormalArgs != nbActualArgs) {
                            int baseReturnType = Math.min(nbFormalArgs, nbActualArgs);
                        }
                    }
                    if (needAnnot) {
                        sons = ILUtils.getArguments(newCallTree).children();
                        for (i = 0; i < sons.length; ++i) {
                            if (sons[i] != null) continue;
                            ILUtils.getArguments(newCallTree).removeChild(i + 1);
                        }
                        while (ILUtils.getArguments(optionalTree).length() > nbFormalArgs) {
                            ILUtils.getArguments(optionalTree).removeChild(nbFormalArgs + 1);
                        }
                        Tree oldTree = instrOrExpr;
                        if (TapEnv.traceTypeCheckAnalysis()) {
                            TapEnv.indentOnTrace(TapEnv.traceIndent());
                            TapEnv.printlnOnTrace("Replace " + instrOrExpr + " with call with explicit arguments " + newCallTree);
                        }
                        instrOrExpr = instruction.replaceTree(instrOrExpr, newCallTree);
                        instrOrExpr.setAnnotation("sourcetree", oldTree);
                        if (optNb != 0) {
                            instrOrExpr.setAnnotation("optionaltree", optionalTree);
                        }
                    }
                    int maxi = Math.min(nbFormalArgs, nbActualArgs);
                    if (functionDecls != null && ((FunctionDecl)functionDecls.head).unit() != null && ((FunctionDecl)functionDecls.head).functionTypeSpec() != null && ((FunctionDecl)functionDecls.head).functionTypeSpec().argumentsTypes != null) {
                        maxi = Math.min(maxi, ((FunctionDecl)functionDecls.head).functionTypeSpec().argumentsTypes.length);
                    }
                    for (int i3 = 0; i3 < maxi; ++i3) {
                        boolean elementalArg;
                        boolean bl = elementalArg = functionDecls != null && ((FunctionDecl)functionDecls.head).unit() != null && !((FunctionDecl)functionDecls.head).isIntrinsicNotElemental() && actualArgsTypes[i3] != null && (((FunctionDecl)functionDecls.head).isElemental() || ((FunctionDecl)functionDecls.head).isIntrinsic()) && TypeSpec.isA(actualArgsTypes[i3], 2) && !((WrapperTypeSpec)actualArgsTypes[i3]).isString() && localizedFormalArgsTypes[i3].receives(((WrapperTypeSpec)actualArgsTypes[i3]).wrappedType.elementType(), null, null);
                        if (elementalArg) {
                            elementalCall = true;
                            Tree kindTree = functionUnits[0].getElementalIntrinsicTypeConverter(actualArgs);
                            if (kindTree != null) {
                                localizedFormalReturnType = new WrapperTypeSpec(new ModifiedTypeSpec(localizedFormalReturnType, kindTree, this));
                            }
                            arrayReturnTypeSpec = !TypeSpec.isA(localizedFormalReturnType, 2) ? new WrapperTypeSpec(new ArrayTypeSpec(localizedFormalReturnType, ((ArrayTypeSpec)((WrapperTypeSpec)actualArgsTypes[i3]).wrappedType).dimensions())) : localizedFormalReturnType;
                        }
                        if (actualArgsTypes[i3] == null || TypeSpec.isA(localizedFormalArgsTypes[i3], 9) || localizedFormalArgsTypes[i3].receives(actualArgsTypes[i3], null, null) || elementalArg) {
                            FunctionDecl argFunctionDecl;
                            String argFunctionName;
                            if (functionUnits == null || !TypeSpec.isA(actualArgsTypes[i3], 3) || (argFunctionName = ILUtils.getIdentString(actualArgs[i3])) == null) continue;
                            TapList<FunctionDecl> argFunctionDecls = this.getFunctionDecl(argFunctionName, null, null, false);
                            FunctionDecl functionDecl3 = argFunctionDecl = argFunctionDecls == null ? null : (FunctionDecl)argFunctionDecls.head;
                            if (argFunctionDecl == null || argFunctionDecl.isInterface()) continue;
                            CallArrow callArrow = CallGraph.addCallArrow(functionUnits[0], 1, argFunctionDecl.unit());
                            callArrow.setSrcCallName("functionName");
                            callArrow = CallGraph.addCallArrow(this.unit, 1, argFunctionDecl.unit());
                            callArrow.setSrcCallName("functionName");
                            continue;
                        }
                        if (this.unit != null && this.unit.isFortran9x() && localizedFormalArgsTypes[i3].wrappedType != null && !TypeSpec.isA(localizedFormalArgsTypes[i3], 6)) {
                            actualArgsTypes[i3] = this.checkPointerInFortranExpression((WrapperTypeSpec)actualArgsTypes[i3], ILUtils.getArguments(instrOrExpr), i3 + 1);
                            actualArgs[i3] = ILUtils.getArguments(instrOrExpr).down(i3 + 1);
                        }
                        if (isMixedLanguageCall) {
                            if (this.unit.callGraph().bindFortranCType() != null) {
                                boolean checkOk = this.unit.callGraph().checkBindFortranCType((WrapperTypeSpec)actualArgsTypes[i3], localizedFormalArgsTypes[i3]);
                                if (checkOk) continue;
                                TapEnv.fileWarning(15, actualArgs[i3], "(TC30) Type mismatch in argument " + (i3 + 1) + " of procedure " + functionName + ", expected " + localizedFormalArgsTypes[i3].showType() + ", is here " + ((WrapperTypeSpec)actualArgsTypes[i3]).showType());
                                continue;
                            }
                            TapEnv.toolWarning(-1, "(DD999) Warning: type-checking of mixed language call not yet implemented: " + ILUtils.toString(instrOrExpr));
                            continue;
                        }
                        if (localizedFormalArgsTypes[i3].receives(actualArgsTypes[i3], null, null)) continue;
                        TapEnv.fileWarning(15, actualArgs[i3], "(TC30) Type mismatch in argument " + (i3 + 1) + " of procedure " + functionName + ", expected " + localizedFormalArgsTypes[i3].showType() + ", is here " + ((WrapperTypeSpec)actualArgsTypes[i3]).showType());
                    }
                }
                if (functionUnits != null && this.unit != null) {
                    TapList<FunctionDecl> tmpFunctionDecls = functionDecls;
                    int index = 0;
                    CallArrow trueFunctionCallArrow = null;
                    while (tmpFunctionDecls != null) {
                        if (index >= functionUnits.length) {
                            TapEnv.toolWarning(10, "Unexpected number of called functions, expected " + functionUnits.length + ", is here at least " + index + 1);
                        } else {
                            CallArrow callArrow = this.setCallArrow(instrOrExpr, functionUnits[index], (FunctionDecl)tmpFunctionDecls.head);
                            instrOrExpr.setAnnotation("callArrow", callArrow);
                            if (trueFunctionCallArrow == null || !callArrow.destination.isInterface()) {
                                trueFunctionCallArrow = callArrow;
                            }
                            ++index;
                        }
                        tmpFunctionDecls = tmpFunctionDecls.tail;
                    }
                    instrOrExpr.setAnnotation("callArrow", trueFunctionCallArrow);
                }
                if (localizedFormalReturnType == null) {
                    for (int k3 = 0; k3 < nbFunctionDecls; ++k3) {
                        functionTypeSpecs[k3].returnType = new WrapperTypeSpec(null);
                    }
                    localizedFormalReturnType = functionTypeSpecs[0].returnType;
                } else if (TypeSpec.isA(localizedFormalReturnType, 10)) {
                    localizedFormalReturnType = new WrapperTypeSpec(null);
                }
                if (this.unit != null && this.unit.isFortran() && (functionDecls == null || !((FunctionDecl)functionDecls.head).isVarFunction()) && (funcVarDecl = this.getVariableDecl(functionName)) != null) {
                    funcVarDecl.isFunctionName = true;
                    funcVarDecl.kind = 6;
                    WrapperTypeSpec funReturnType = funcVarDecl.type();
                    if (TypeSpec.isA(funcVarDecl.type(), 3)) {
                        funReturnType = ((FunctionTypeSpec)funcVarDecl.type().wrappedType).returnType;
                    }
                    if (!funReturnType.receives(localizedFormalReturnType, null, null)) {
                        TapEnv.fileWarning(15, ILUtils.getCalledName(instrOrExpr), "(DD06) Cannot combine successive declarations of function " + functionName + " return type: " + localizedFormalReturnType.showType() + " and " + funcVarDecl.type().showType() + " (overwritten previous)");
                    }
                    if (!TypeSpec.isA(funcVarDecl.type(), 3)) {
                        funcVarDecl.setType(new WrapperTypeSpec(functionTypeSpecs[0]));
                    }
                }
                if (expectResult) {
                    if (localizedFormalReturnType.wrappedType == null) {
                        WrapperTypeSpec implicitType = this.getImplicitTypeSpec(functionName);
                        if (implicitType != null && implicitType.wrappedType != null) {
                            localizedFormalReturnType.wrappedType = implicitType.wrappedType;
                            if (!functionUnits[0].isIntrinsic()) {
                                TapEnv.fileWarning(15, ILUtils.getCalledName(instrOrExpr), "(TC37) Return type of function " + functionName + " set by implicit rule to " + localizedFormalReturnType.wrappedType.showType());
                            }
                        }
                    } else if (TypeSpec.isA(localizedFormalReturnType.wrappedType, 9)) {
                        TapEnv.fileWarning(15, instrOrExpr, "(TC35) Subroutine " + functionName + " used as a function");
                        localizedFormalReturnType = null;
                    } else {
                        needVarDeclInstruction = !((FunctionDecl)functionDecls.head).hasInstructionWithRootOperator(194, null);
                    }
                } else if (localizedFormalReturnType.wrappedType == null || symbolFoundAsParam) {
                    localizedFormalReturnType.wrappedType = new VoidTypeSpec();
                } else if (!TypeSpec.isA(localizedFormalReturnType.wrappedType, 9)) {
                    if (this.unit != null && (this.unit.isFortran() && mixedLanguageFunctionDecl == null || mixedLanguageFunctionDecl != null && mixedLanguageFunctionDecl.unit().isFortran())) {
                        TapEnv.fileWarning(15, instrOrExpr, "(TC36) " + localizedFormalReturnType.showType() + " function " + functionName + " used as a subroutine");
                    }
                    localizedFormalReturnType = null;
                }
                if (elementalCall && expectResult) {
                    functionUnits[0].usedAsElementalResult = true;
                } else if (functionUnits[0] != null) {
                    functionUnits[0].usedAsElementalResult = functionUnits[0].isElemental();
                }
                if (elementalCall) {
                    instrOrExpr.setAnnotation("arrayReturnTypeSpec", arrayReturnTypeSpec);
                    localizedFormalReturnType = arrayReturnTypeSpec;
                }
                Tree kindTree = functionUnits[0].getElementalIntrinsicTypeConverter(actualArgs);
                if (!elementalCall && kindTree != null) {
                    localizedFormalReturnType = new WrapperTypeSpec(new ModifiedTypeSpec(localizedFormalReturnType, kindTree, this));
                    FunctionTypeSpec annotFTypeSpec = (FunctionTypeSpec)instrOrExpr.getAnnotation("functionTypeSpec");
                    if (annotFTypeSpec != null) {
                        annotFTypeSpec.returnType = localizedFormalReturnType;
                    }
                }
                TapList<FunctionDecl> tapList = functionDeclsToDeclare = localFunctionDecls != null && localFunctionDecls.head != null ? localFunctionDecls : functionDecls;
                if (!(!needVarDeclInstruction || !expectResult || this.unit == null || this.unit.isC() || this.unit.isCPlusPlus() || ((FunctionDecl)functionDeclsToDeclare.head).isInterface() || localInterfaceDecl != null || ((FunctionDecl)functionDeclsToDeclare.head).isIntrinsic() || ((FunctionDecl)functionDeclsToDeclare.head).hasInstructionWithRootOperator(194, null) || ((FunctionDecl)functionDeclsToDeclare.head).isContainedFunctionDeclDeclared(this.unit) || ((FunctionDecl)functionDeclsToDeclare.head).isVarDeclared(this.declarationsBlock.instructions) || ((FunctionDecl)functionDeclsToDeclare.head).unit().otherReturnVar() != null && ((FunctionDecl)functionDeclsToDeclare.head).unit().language() == this.language || !((FunctionDecl)functionDeclsToDeclare.head).symbol.equals(functionName) || !this.comesFromRootSymbolTable((SymbolDecl)functionDeclsToDeclare.head) && !((FunctionDecl)functionDeclsToDeclare.head).isVarFunction() || localizedFormalReturnType == null || TypeSpec.isA(localizedFormalReturnType, 9))) {
                    Tree functionNameTree = ILUtils.build(94, functionName);
                    functionNameTree.setAnnotation("isFunctionName", Boolean.TRUE);
                    Tree typeTree = ILUtils.build(136);
                    typeTree.setAnnotation("typeSpec", localizedFormalReturnType);
                    Instruction newInstr2 = new Instruction(ILUtils.build(194, ILUtils.build(128), typeTree, ILUtils.build(53, functionNameTree)));
                    this.declarationsBlock.addInstrDeclTlBeforeUse(newInstr2, null, null, null, true);
                    ((FunctionDecl)functionDeclsToDeclare.head).setInstruction(newInstr2);
                }
                TapList<FunctionDecl> tmpFunctionDeclsToDeclare = functionDeclsToDeclare;
                while (tmpFunctionDeclsToDeclare != null) {
                    ILUtils.checkFunctionName((FunctionDecl)tmpFunctionDeclsToDeclare.head, this);
                    tmpFunctionDeclsToDeclare = tmpFunctionDeclsToDeclare.tail;
                }
                tmpFunctionDeclsToDeclare = functionDeclsToDeclare;
                if (this.basisSymbolTable != null && this.basisSymbolTable.isFormalParams) {
                    while (tmpFunctionDeclsToDeclare != null) {
                        ILUtils.checkFunctionName((FunctionDecl)tmpFunctionDeclsToDeclare.head, this.basisSymbolTable);
                        tmpFunctionDeclsToDeclare = tmpFunctionDeclsToDeclare.tail;
                    }
                }
                if (!(this.unit == null || this.unit.isCorMore() || !((FunctionDecl)functionDeclsToDeclare.head).isExternal() && (TapEnv.inputLanguage() != 100 || !((FunctionDecl)functionDeclsToDeclare.head).unit().isC()) || ((FunctionDecl)functionDeclsToDeclare.head).hasOtherInstruction() || ((FunctionDecl)functionDeclsToDeclare.head).hasInstructionWithRootOperator(72, null) || ((FunctionDecl)functionDeclsToDeclare.head).isExternalDeclared(this.declarationsBlock.instructions) || ((FunctionDecl)functionDeclsToDeclare.head).hasInterfaceInstruction() || this.basisSymbolTable != null && ((FunctionDecl)functionDeclsToDeclare.head).isExternalDeclared(this.basisSymbolTable.declarationsBlock.instructions))) {
                    Instruction newInstr3 = new Instruction(ILUtils.build(72, ILUtils.build(94, functionName)));
                    this.unit.privateSymbolTable().declarationsBlock.addInstrDeclTlBeforeUse(newInstr3, null, null, null, true);
                    ((FunctionDecl)functionDeclsToDeclare.head).setInstruction(newInstr3);
                }
                if (ILUtils.getCalledName(instrOrExpr).opCode() == 148 && TypeSpec.isA(localizedFormalReturnType, 6) && TypeSpec.isA(localizedFormalReturnType = ((PointerTypeSpec)localizedFormalReturnType.wrappedType).destinationType, 3)) {
                    localizedFormalReturnType = ((FunctionTypeSpec)localizedFormalReturnType.wrappedType).returnType;
                }
                if (this.unit != null && this.unit.fortranStuff() != null && functionDecl != null && TypeSpec.isA(localizedFormalReturnType, 9) && functionDecl.hasInstructionWithRootOperator(194, null) && (implicitInstr = (Instruction)TapList.cassqString(functionDecl.symbol, this.unit.fortranStuff().implicitDeclarations)) != null) {
                    implicitInstr.tree = ILUtils.build(136);
                }
                if (TapEnv.traceTypeCheckAnalysis()) {
                    TapList<FunctionDecl> tmpFunctionDecls = functionDecls;
                    int index = 0;
                    while (tmpFunctionDecls != null) {
                        TapEnv.indentOnTrace(TapEnv.traceIndent());
                        TapEnv.printlnOnTrace(instrOrExpr + " calls: " + tmpFunctionDecls.head);
                        TapEnv.indentOnTrace(TapEnv.traceIndent() + 2);
                        TapEnv.printlnOnTrace("which has declared type:" + functionTypeSpecs[index]);
                        TapEnv.indentOnTrace(TapEnv.traceIndent() + 2);
                        TapEnv.printlnOnTrace("...instantiated here as:" + localizedFormalFunctionTypeSpecs[index]);
                        tmpFunctionDecls = tmpFunctionDecls.tail;
                        ++index;
                    }
                }
                returnedType = localizedFormalReturnType;
                break;
            }
            case 46: {
                String className = ILUtils.getClassNameString(instrOrExpr.down(1));
                if (className == null) {
                    TapEnv.fileError(instrOrExpr, "(TC57) null constructor name call " + ILUtils.toString(instrOrExpr));
                    break;
                }
                Tree[] actualArgs = ILUtils.getArguments(instrOrExpr).children();
                int nbActualArgs = actualArgs.length;
                TypeSpec[] actualArgsTypes = new WrapperTypeSpec[nbActualArgs];
                for (int i = 0; i < nbActualArgs; ++i) {
                    actualArgsTypes[i] = actualArgs[i].opCode() == 136 ? new WrapperTypeSpec(null) : this.typeCheck(actualArgs[i], true, false, false, instruction, isBeginning, currentUnit);
                    if (!TapEnv.traceTypeCheckAnalysis()) continue;
                    TapEnv.indentOnTrace(TapEnv.traceIndent());
                    TapEnv.printlnOnTrace("actual arg" + (i + 1) + ": " + actualArgsTypes[i]);
                }
                WrapperTypeSpec[] formalArgsTypes = null;
                ClassDecl classDecl = this.getClassDecl(className);
                if (classDecl != null) {
                    Unit upperClassUnit;
                    String constructorKind = ILUtils.getIdentString(instrOrExpr.down(2));
                    returnedType = new WrapperTypeSpec(classDecl.unit.classTypeSpec());
                    SymbolTable classSymbolTable = currentUnit == null ? classDecl.unit.publicSymbolTable() : ((upperClassUnit = currentUnit.getUpperLevelClassUnit()) != null && upperClassUnit == classDecl.unit ? upperClassUnit.privateSymbolTable() : (upperClassUnit != null && upperClassUnit.subClassOf(classDecl.unit) ? classDecl.unit.protectedSymbolTable() : classDecl.unit.publicSymbolTable()));
                    TapList<FunctionDecl> localConstructorDecls = classSymbolTable.getFunctionDecl(className, new WrapperTypeSpec(new VoidTypeSpec()), actualArgsTypes, className, true);
                    if (localConstructorDecls == null) {
                        if (!(constructorKind == null || nbActualArgs == 0 && constructorKind.equals("default"))) {
                            if (nbActualArgs > 0 && constructorKind.equals("default")) {
                                TapEnv.fileWarning(15, instrOrExpr.down(2), "(TC58) No default constructor defined in class " + className);
                            } else if (nbActualArgs == 1 && constructorKind.equals("copy")) {
                                TapEnv.fileWarning(15, instrOrExpr.down(2), "(TC60) No copy constructor defined in class " + className);
                            } else if (nbActualArgs != 1 && constructorKind.equals("copy")) {
                                TapEnv.fileWarning(15, instrOrExpr, "(TC63) Unexpected number of arguments in copy constructor  " + className);
                            } else if (constructorKind.equals("other")) {
                                TapEnv.fileWarning(15, instrOrExpr, "(TC64) No constructor declared in class " + className);
                            }
                        }
                    } else {
                        if (localConstructorDecls.tail != null) {
                            TapEnv.fileWarning(15, instrOrExpr.down(1), "(TC57) Several constructors found in class " + className);
                        }
                        FunctionDecl constructorDecl = (FunctionDecl)localConstructorDecls.head;
                        CallArrow callArrow = CallGraph.addCallArrow(this.unit, 1, constructorDecl.unit());
                        callArrow.setSrcCallName(className);
                        instrOrExpr.setAnnotation("callArrow", callArrow);
                        FunctionTypeSpec constructorTypeSpec = constructorDecl.functionTypeSpec();
                        if (constructorTypeSpec != null) {
                            formalArgsTypes = constructorTypeSpec.argumentsTypes;
                        }
                    }
                } else {
                    TypeDecl typeDecl = this.getTypeDecl(className);
                    if (typeDecl != null && TypeSpec.isA(typeDecl.typeSpec, 21) && ((CompositeTypeSpec)typeDecl.typeSpec.wrappedType).isRecordType()) {
                        returnedType = typeDecl.typeSpec;
                        CompositeTypeSpec recordType = (CompositeTypeSpec)returnedType.wrappedType;
                        if (recordType.fields != null) {
                            formalArgsTypes = new WrapperTypeSpec[recordType.fields.length];
                            for (int i = recordType.fields.length - 1; i >= 0; --i) {
                                formalArgsTypes[i] = recordType.fields[i] != null ? recordType.fields[i].type() : new WrapperTypeSpec(null);
                            }
                        }
                    } else {
                        TapEnv.fileError(instrOrExpr, "(TC65) Class or Structured type not found: " + className);
                        returnedType = null;
                    }
                }
                if (formalArgsTypes == null) break;
                for (int i = formalArgsTypes.length - 1; i >= 0; --i) {
                    if (formalArgsTypes[i] == null || formalArgsTypes[i].wrappedType == null || i >= actualArgsTypes.length || actualArgsTypes[i] == null || formalArgsTypes[i].wrappedType.receivesNoInferenceNoVector(actualArgsTypes[i])) continue;
                    TapEnv.fileWarning(15, actualArgs[i], "(TC30) Type mismatch in argument " + (i + 1) + " of constructor " + className + ", expected " + formalArgsTypes[i].showType() + ", is here " + ((WrapperTypeSpec)actualArgsTypes[i]).showType());
                }
                break;
            }
            case 107: {
                FunctionDecl ioFunctionDecl;
                String functionName = ILUtils.getCallFunctionNameString(instrOrExpr);
                TapList<FunctionDecl> ioFunctionDecls = this.getFunctionDecl(functionName, null, null, false);
                FunctionDecl functionDecl = ioFunctionDecl = ioFunctionDecls == null ? null : (FunctionDecl)ioFunctionDecls.head;
                if (ioFunctionDecl == null && (this.unit == null || this.unit.isC() || this.unit.isCPlusPlus())) {
                    TapEnv.fileWarning(15, instrOrExpr.down(1), "(TC33) External IO procedure " + functionName + " is not declared");
                    Unit functionUnit = Unit.makeExternal(functionName, this.unit.callGraph(), this.language, false);
                    functionUnit.setFunctionTypeSpec(new FunctionTypeSpec(new WrapperTypeSpec(null)));
                    FunctionDecl functionDecl4 = new FunctionDecl(instrOrExpr.down(1), functionUnit);
                    this.unit.privateSymbolTable().addSymbolDecl(functionDecl4);
                }
                this.typeCheck(instrOrExpr.down(3), true, ILUtils.isIORead(instrOrExpr), false, instruction, isBeginning, currentUnit);
                break;
            }
            case 128: {
                int nbSons = instrOrExpr.length();
                for (int i = 1; i <= nbSons; ++i) {
                    if (instrOrExpr.down(i).opCode() == 94) continue;
                    WrapperTypeSpec modifierType = this.typeCheck(instrOrExpr.down(i), true, false, false, instruction, isBeginning, currentUnit);
                    if (instrOrExpr.down(i).opCode() != 132 || !ILUtils.isIdent(instrOrExpr.down(i).down(1), "kind", false) || ((TypeSpec)modifierType).baseTypeName().equals("integer")) continue;
                    TapEnv.fileWarning(15, instrOrExpr, "(TC16) Type mismatch in named argument: " + ILUtils.toString(instrOrExpr.down(i)) + " expects an integer and is " + ((TypeSpec)modifierType).showType());
                }
                break;
            }
            case 52: 
            case 53: 
            case 59: 
            case 70: 
            case 195: 
            case 197: {
                WrapperTypeSpec lastTypeSpec = null;
                int nbSons = instrOrExpr.length();
                for (int i = 1; i <= nbSons; ++i) {
                    lastTypeSpec = this.typeCheck(instrOrExpr.down(i), true, noFunctionCall, false, instruction, isBeginning, currentUnit);
                }
                returnedType = lastTypeSpec;
                break;
            }
            case 10: {
                this.typeCheck(instrOrExpr.down(2), false, noFunctionCall, false, instruction, isBeginning, currentUnit);
                returnedType = this.typeCheck(instrOrExpr.down(1), false, noFunctionCall, false, instruction, isBeginning, currentUnit);
                break;
            }
            case 88: 
            case 150: {
                returnedType = this.typeCheck(instrOrExpr.down(1), false, noFunctionCall, false, instruction, isBeginning, currentUnit);
                break;
            }
            case 126: {
                returnedType = this.typeCheck(instrOrExpr.down(2), false, noFunctionCall, false, instruction, isBeginning, currentUnit);
                break;
            }
            case 41: {
                WrapperTypeSpec imagType;
                WrapperTypeSpec realType = this.typeCheck(instrOrExpr.down(1), true, false, false, instruction, isBeginning, currentUnit);
                if (realType != null && !realType.checkNumeric()) {
                    TapEnv.fileWarning(15, instrOrExpr.down(1), "(TC09) Real part of complex constructor is expected to be numeric, and is here " + realType.showType());
                }
                if ((imagType = this.typeCheck(instrOrExpr.down(2), true, false, false, instruction, isBeginning, currentUnit)) != null && !imagType.checkNumeric()) {
                    TapEnv.fileWarning(15, instrOrExpr.down(2), "(TC10) Imaginary part of complex constructor is expected to be numeric, and is here " + imagType.showType());
                }
                returnedType = this.getTypeDecl((String)"complex").typeSpec;
                break;
            }
            case 189: {
                WrapperTypeSpec rhsType = this.typeCheck(instrOrExpr.down(2), true, false, false, instruction, isBeginning, currentUnit);
                String unaryCallName = instrOrExpr.down(1).stringValue();
                if ((this.unit == null || this.unit.isC()) && (unaryCallName.equals("++postfix") || unaryCallName.equals("++prefix") || unaryCallName.equals("--postfix") || unaryCallName.equals("--prefix") || unaryCallName.equals("+") || unaryCallName.equals("~"))) {
                    returnedType = rhsType;
                    break;
                }
                Tree oldTree = instrOrExpr;
                FunctionDecl functionDecl = null;
                if (rhsType != null) {
                    WrapperTypeSpec[] types = new WrapperTypeSpec[]{rhsType};
                    Tree newTree = ILUtils.buildCall(instrOrExpr.down(1).copy(), ILUtils.build(70, instrOrExpr.down(2).copy()));
                    if (TapEnv.traceTypeCheckAnalysis()) {
                        TapEnv.indentOnTrace(TapEnv.traceIndent());
                        TapEnv.printlnOnTrace("Understand unary " + instrOrExpr + " as function call " + newTree);
                    }
                    instrOrExpr = instruction.replaceTree(instrOrExpr, newTree);
                    instrOrExpr.setAnnotation("sourcetree", oldTree);
                    TapList<InterfaceDecl> interfaceDecls = this.getInterfaceDecl(unaryCallName);
                    InterfaceDecl interfaceDecl = null;
                    while (interfaceDecls != null && functionDecl == null) {
                        interfaceDecl = (InterfaceDecl)interfaceDecls.head;
                        functionDecl = interfaceDecl.findFunctionDecl(types, null, instrOrExpr);
                        interfaceDecls = interfaceDecls.tail;
                    }
                    if (interfaceDecl != null && functionDecl == null && (functionDecl = interfaceDecl.findOneFunctionDecl(types, instrOrExpr)) != null) {
                        TapEnv.fileWarning(15, instrOrExpr, "(TC34) Found no specific procedure that matches generic interface call: " + ILUtils.toString(instrOrExpr) + "; Took fallback choice: " + functionDecl.symbol);
                    }
                }
                if (functionDecl == null) {
                    TapEnv.fileWarning(15, oldTree, "(TC39) Overloaded operator " + oldTree.down(1).stringValue() + " undefined for type " + rhsType.showType());
                    returnedType = null;
                    break;
                }
                returnedType = this.typeCheck(instrOrExpr, true, false, false, instruction, isBeginning, currentUnit);
                break;
            }
            case 16: {
                int rankLeft = 1;
                int rankOp = 2;
                int rankRight = 3;
                String binaryCallName = null;
                if (this.unit == null || this.unit.isC() || this.unit.isCPlusPlus()) {
                    rankLeft = 2;
                    rankOp = 1;
                    binaryCallName = instrOrExpr.down(1).stringValue();
                }
                WrapperTypeSpec lhsType = this.typeCheck(instrOrExpr.down(rankLeft), true, false, false, instruction, isBeginning, currentUnit);
                WrapperTypeSpec rhsType = this.typeCheck(instrOrExpr.down(rankRight), true, false, false, instruction, isBeginning, currentUnit);
                lhsType = this.checkPointerInFortranExpression(lhsType, instrOrExpr, rankLeft);
                rhsType = this.checkPointerInFortranExpression(rhsType, instrOrExpr, rankRight);
                if ((this.unit == null || this.unit.isC()) && (binaryCallName.equals("&") || binaryCallName.equals("|") || binaryCallName.equals("^"))) {
                    returnedType = lhsType;
                    break;
                }
                FunctionDecl functionDecl = null;
                Tree oldTree = instrOrExpr;
                if (lhsType != null && rhsType != null) {
                    TapList<InterfaceDecl> interfaceDecls = this.getInterfaceDecl(instrOrExpr.down(rankOp).stringValue());
                    WrapperTypeSpec[] types = new WrapperTypeSpec[]{lhsType, rhsType};
                    Tree newTree = ILUtils.buildCall(instrOrExpr.down(rankOp).copy(), ILUtils.build(70, instrOrExpr.down(rankLeft).copy(), instrOrExpr.down(rankRight).copy()));
                    if (TapEnv.traceTypeCheckAnalysis()) {
                        TapEnv.indentOnTrace(TapEnv.traceIndent());
                        TapEnv.printlnOnTrace("Understand binary " + instrOrExpr + " as function call " + newTree);
                    }
                    instrOrExpr = instruction.replaceTree(instrOrExpr, newTree);
                    instrOrExpr.setAnnotation("sourcetree", oldTree);
                    InterfaceDecl interfaceDecl = null;
                    while (interfaceDecls != null && interfaceDecl == null) {
                        interfaceDecl = (InterfaceDecl)interfaceDecls.head;
                        functionDecl = interfaceDecl.findFunctionDecl(types, null, instrOrExpr);
                        interfaceDecls = interfaceDecls.tail;
                    }
                    if (interfaceDecl != null && functionDecl == null && (functionDecl = interfaceDecl.findOneFunctionDecl(types, instrOrExpr)) != null) {
                        TapEnv.fileWarning(15, instrOrExpr, "(TC34) Found no specific procedure that matches generic interface call: " + ILUtils.toString(instrOrExpr) + "; Took fallback choice: " + functionDecl.symbol);
                    }
                }
                if (functionDecl == null) {
                    TapEnv.fileWarning(15, oldTree, "(TC39) Overloaded operator " + oldTree.down(rankOp).stringValue() + " undefined for types  " + lhsType.showType() + " " + rhsType.showType());
                    returnedType = null;
                    break;
                }
                returnedType = this.typeCheck(instrOrExpr, true, false, false, instruction, isBeginning, currentUnit);
                break;
            }
            case 2: 
            case 61: 
            case 131: 
            case 152: 
            case 177: {
                WrapperTypeSpec lhsType = this.typeCheck(instrOrExpr.down(1), true, false, false, instruction, isBeginning, currentUnit);
                WrapperTypeSpec rhsType = this.typeCheck(instrOrExpr.down(2), true, false, false, instruction, isBeginning, currentUnit);
                lhsType = this.checkPointerInFortranExpression(lhsType, instrOrExpr, 1);
                rhsType = this.checkPointerInFortranExpression(rhsType, instrOrExpr, 2);
                if (!(!TapEnv.relatedLanguageIsFortran() || lhsType == null || rhsType == null || lhsType.checkNumeric() && rhsType.checkNumeric())) {
                    WrapperTypeSpec[] types = new WrapperTypeSpec[]{lhsType, rhsType};
                    returnedType = this.getOverloadedWrapperTypeSpec(instrOrExpr, instruction, instrOrExpr.opName(), types);
                    break;
                }
                returnedType = this.canCombineNumeric(lhsType, rhsType, instrOrExpr);
                break;
            }
            case 67: 
            case 135: {
                WrapperTypeSpec lhsType = this.typeCheck(instrOrExpr.down(1), true, false, false, instruction, isBeginning, currentUnit);
                WrapperTypeSpec rhsType = this.typeCheck(instrOrExpr.down(2), true, false, false, instruction, isBeginning, currentUnit);
                if (lhsType != null && rhsType != null) {
                    if (!TypeSpec.canCompare(lhsType, rhsType)) {
                        TapEnv.fileWarning(15, instrOrExpr, "(TC18) Type mismatch in comparison: " + lhsType.showType() + " compared to " + rhsType.showType());
                    }
                    if (lhsType.isRealOrComplexBase() || rhsType.isRealOrComplexBase()) {
                        TapEnv.fileWarning(49, instrOrExpr, "(TC19) Equality test on reals is not reliable");
                    }
                    if (lhsType.isBooleanBase() && rhsType.isBooleanBase()) {
                        instrOrExpr.setAnnotation("boolean", "boolean");
                    }
                }
                returnedType = this.setConformingDimension(this.getTypeDecl((String)"boolean").typeSpec, lhsType, rhsType, instrOrExpr);
                break;
            }
            case 5: 
            case 141: 
            case 202: {
                WrapperTypeSpec lhsType = this.typeCheck(instrOrExpr.down(1), true, false, false, instruction, isBeginning, currentUnit);
                WrapperTypeSpec rhsType = this.typeCheck(instrOrExpr.down(2), true, false, false, instruction, isBeginning, currentUnit);
                if (this.unit != null && !this.unit.isC() && lhsType != null && !lhsType.checkBoolean()) {
                    TapEnv.fileWarning(15, instrOrExpr.down(1), "(TC15) Argument of logical operator is expected to be boolean, and is here " + lhsType.showType());
                }
                if (this.unit != null && !this.unit.isC() && rhsType != null && !rhsType.checkBoolean()) {
                    TapEnv.fileWarning(15, instrOrExpr.down(3), "(TC15) Argument of logical operator is expected to be boolean, and is here " + rhsType.showType());
                }
                returnedType = this.setConformingDimension(this.getTypeDecl((String)"boolean").typeSpec, lhsType, rhsType, instrOrExpr);
                break;
            }
            case 90: 
            case 93: 
            case 113: 
            case 120: {
                WrapperTypeSpec lhsType = this.typeCheck(instrOrExpr.down(1), true, false, false, instruction, isBeginning, currentUnit);
                WrapperTypeSpec rhsType = this.typeCheck(instrOrExpr.down(2), true, false, false, instruction, isBeginning, currentUnit);
                if (TapEnv.relatedLanguageIsFortran() && (lhsType != null && !lhsType.isMetaType() && lhsType.wrappedType != null && !lhsType.isNumericBase() || rhsType != null && !rhsType.isMetaType() && rhsType.wrappedType != null && !rhsType.isNumericBase())) {
                    WrapperTypeSpec[] types = new WrapperTypeSpec[]{lhsType, rhsType};
                    returnedType = this.getOverloadedWrapperTypeSpec(instrOrExpr, instruction, instrOrExpr.opName(), types);
                    break;
                }
                if (lhsType != null && !lhsType.isMetaType() && lhsType.wrappedType != null && !lhsType.isNumericBase()) {
                    TapEnv.fileWarning(15, instrOrExpr.down(1), "(TC01) Expression is expected to be numeric, and is here " + lhsType.showType());
                }
                if (rhsType != null && !rhsType.isMetaType() && rhsType.wrappedType != null && !rhsType.isNumericBase()) {
                    TapEnv.fileWarning(15, instrOrExpr.down(2), "(TC01) Expression is expected to be numeric, and is here " + rhsType.showType());
                }
                returnedType = this.setConformingDimension(this.getTypeDecl((String)"boolean").typeSpec, lhsType, rhsType, instrOrExpr);
                break;
            }
            case 124: {
                WrapperTypeSpec lhsType = this.typeCheck(instrOrExpr.down(1), true, false, false, instruction, isBeginning, currentUnit);
                WrapperTypeSpec rhsType = this.typeCheck(instrOrExpr.down(2), true, false, false, instruction, isBeginning, currentUnit);
                if (lhsType != null && !lhsType.isIntegerBase()) {
                    TapEnv.fileWarning(15, instrOrExpr.down(1), "(TC01) Expression is expected to be integer, and is here " + lhsType.showType());
                }
                if (rhsType != null && !rhsType.isIntegerBase()) {
                    TapEnv.fileWarning(15, instrOrExpr.down(2), "(TC01) Expression is expected to be integer, and is here " + rhsType.showType());
                }
                returnedType = lhsType;
                break;
            }
            case 122: {
                WrapperTypeSpec subType = this.typeCheck(instrOrExpr.down(1), true, false, false, instruction, isBeginning, currentUnit);
                subType = this.checkPointerInFortranExpression(subType, instrOrExpr, 1);
                if (TapEnv.relatedLanguageIsFortran() && WrapperTypeSpec.isA(subType, 21)) {
                    WrapperTypeSpec[] types = new WrapperTypeSpec[]{subType};
                    returnedType = this.getOverloadedWrapperTypeSpec(instrOrExpr, instruction, "sub", types);
                    break;
                }
                if (subType != null && !subType.isMetaType() && subType.wrappedType != null && !subType.isNumericBase()) {
                    TapEnv.fileWarning(15, instrOrExpr.down(1), "(TC01) Expression is expected to be numeric, and is here " + subType.showType());
                }
                returnedType = subType;
                break;
            }
            case 137: {
                WrapperTypeSpec subType = this.typeCheck(instrOrExpr.down(1), true, false, false, instruction, isBeginning, currentUnit);
                if (this.unit != null && !this.unit.isC() && subType != null && !subType.checkBoolean()) {
                    TapEnv.fileWarning(15, instrOrExpr.down(2), "(TC02) Expression is expected to be boolean, and is here " + subType.showType());
                    returnedType = this.setConformingDimension(this.getTypeDecl((String)"boolean").typeSpec, subType, null, instrOrExpr);
                    break;
                }
                returnedType = subType;
                break;
            }
            case 114: 
            case 164: {
                WrapperTypeSpec leftType = this.typeCheck(instrOrExpr.down(1), true, false, false, instruction, isBeginning, currentUnit);
                this.typeCheck(instrOrExpr.down(2), true, false, false, instruction, isBeginning, currentUnit);
                returnedType = leftType;
                break;
            }
            case 168: {
                returnedType = null;
                break;
            }
            case 73: {
                WrapperTypeSpec recordType = this.typeCheck(instrOrExpr.down(1), true, false, false, instruction, isBeginning, currentUnit);
                recordType = this.checkPointerInFortranExpression(recordType, instrOrExpr, 1);
                WrapperTypeSpec fieldType = null;
                if (recordType == null) {
                    fieldType = new WrapperTypeSpec(null);
                } else {
                    TapPair<WrapperTypeSpec, ArrayDim[]> afterPeel = TypeSpec.peelArrayDimsAroundComposite(recordType);
                    recordType = (WrapperTypeSpec)afterPeel.first;
                    if (!recordType.checkRecord()) {
                        TapEnv.fileWarning(15, instrOrExpr.down(1), "(TC03) Expression is expected to be a record, and is here " + recordType.showType());
                        fieldType = new WrapperTypeSpec(null);
                    } else {
                        if (TypeSpec.isA(recordType.wrappedType, 21)) {
                            fieldType = ((CompositeTypeSpec)recordType.wrappedType).checkNamedFieldType(instrOrExpr, this, recordType);
                        } else if (TypeSpec.isA(recordType.wrappedType, 23)) {
                            ClassTypeSpec classType = (ClassTypeSpec)recordType.wrappedType;
                            SymbolTable currentSymbolTable = classType.unit.publicSymbolTable();
                            if (currentUnit != null) {
                                Unit upperClassUnit = currentUnit.getUpperLevelClassUnit();
                                if (upperClassUnit != null && upperClassUnit == classType.unit) {
                                    currentSymbolTable = upperClassUnit.privateSymbolTable();
                                } else if (upperClassUnit != null && upperClassUnit.subClassOf(classType.unit)) {
                                    currentSymbolTable = classType.unit.protectedSymbolTable();
                                }
                            }
                            fieldType = currentSymbolTable.typeCheck(instrOrExpr.down(2), true, false, false, instruction, isBeginning, ((ClassTypeSpec)recordType.wrappedType).unit);
                        }
                        if (fieldType == null) {
                            TapEnv.fileWarning(15, instrOrExpr, "(TC45) No field named " + ILUtils.getIdentString(instrOrExpr.down(2)) + " in " + recordType.showType());
                        }
                    }
                    if (afterPeel.second != null) {
                        fieldType = new WrapperTypeSpec(new ArrayTypeSpec(fieldType, (ArrayDim[])afterPeel.second));
                    }
                }
                returnedType = fieldType;
                break;
            }
            case 8: {
                int i;
                ArrayDim[] newDimensions;
                WrapperTypeSpec elementType;
                Tree indices = instrOrExpr.down(2);
                int realN = indices.length();
                Tree varName = instrOrExpr.down(1);
                WrapperTypeSpec topType = this.typeCheck(varName, true, false, false, instruction, isBeginning, currentUnit);
                TapList<Object> newDimensionsList = null;
                if (topType == null) {
                    elementType = null;
                } else {
                    topType = this.checkPointerInFortranExpression(topType, instrOrExpr, 1);
                    if (ILUtils.oneIsArrayTriplet(instrOrExpr.down(2)) && TypeSpec.isA(topType, 3)) {
                        topType = this.changeFunctionToArrayTypeSpec(instrOrExpr.down(1), topType);
                    }
                    if (!topType.checkArray()) {
                        TapEnv.fileWarning(15, instrOrExpr, "(TC05) Expression " + ILUtils.toString(varName) + " is expected to be an array, and is here " + topType.showType());
                        elementType = TypeSpec.isA(topType, 3) ? ((FunctionTypeSpec)topType.wrappedType).returnType : topType;
                    } else {
                        elementType = topType.wrappedType.elementType();
                        if (((ArrayTypeSpec)topType.wrappedType).dimensions() == null) {
                            newDimensions = new ArrayDim[realN];
                            String identNext = ILUtils.getIdentString(varName);
                            for (i = realN - 1; i >= 0; --i) {
                                newDimensions[i] = new ArrayDim(ILUtils.build(58), 1, null, identNext == null ? null : varName, i + 1, realN, 1);
                            }
                            ((ArrayTypeSpec)topType.wrappedType).setDimensions(newDimensions);
                        } else {
                            int formalN = ((ArrayTypeSpec)topType.wrappedType).dimensions().length;
                            if (formalN != realN) {
                                TapEnv.fileWarning(15, instrOrExpr, "(TC24) Wrong number of dimensions for array " + ILUtils.toString(varName) + ": " + formalN + " expected, and " + realN + " given");
                            }
                        }
                    }
                }
                for (i = 1; i <= realN; ++i) {
                    WrapperTypeSpec indexType;
                    ArrayDim newDim;
                    if (indices.down(i).opCode() == 11) {
                        newDim = new ArrayDim(ILUtils.copy(indices.down(i)), 1, null, null, -1, 0, 0);
                        this.refineTripletDimension(indices.down(i), newDim, true);
                        if (!newDim.isSufficientlyDefined() && TypeSpec.isA(topType, 2) && i <= ((ArrayTypeSpec)topType.wrappedType).dimensions().length) {
                            newDim = ((ArrayTypeSpec)topType.wrappedType).dimensions()[i - 1];
                        }
                    } else {
                        newDim = null;
                    }
                    if ((indexType = this.typeCheck(indices.down(i), true, false, false, instruction, isBeginning, currentUnit)) != null && indexType.wrappedType != null && !indexType.checkNumericInt()) {
                        TapEnv.fileWarning(15, indices.down(i), "(TC12) Array index is expected to be integer, and is here " + indexType.showType());
                    }
                    if (newDim == null || !TypeSpec.isA(indexType, 2)) continue;
                    newDimensionsList = new TapList<ArrayDim>(newDim, newDimensionsList);
                }
                if (newDimensionsList == null) {
                    returnedType = elementType;
                    break;
                }
                newDimensions = new ArrayDim[TapList.length(newDimensionsList)];
                for (i = newDimensions.length - 1; i >= 0; --i) {
                    newDimensions[i] = (ArrayDim)newDimensionsList.head;
                    newDimensionsList = newDimensionsList.tail;
                }
                returnedType = new WrapperTypeSpec(new ArrayTypeSpec(elementType, newDimensions));
                break;
            }
            case 178: {
                WrapperTypeSpec baseType = this.typeCheck(instrOrExpr.down(1), true, false, false, instruction, isBeginning, currentUnit);
                for (int i = 2; i <= 3; ++i) {
                    WrapperTypeSpec indexType;
                    if (instrOrExpr.down(i).opCode() == 136 || SymbolTable.checkScalarNumericInt(indexType = this.typeCheck(instrOrExpr.down(i), true, false, false, instruction, isBeginning, currentUnit))) continue;
                    TapEnv.fileWarning(15, instrOrExpr.down(i), "(TC14) Substring index is expected to be numeric, and is here " + indexType.showType());
                }
                returnedType = baseType;
                break;
            }
            case 11: {
                ArrayDim[] dimensions = new ArrayDim[1];
                for (int i = 1; i <= 3; ++i) {
                    WrapperTypeSpec indexType;
                    if (instrOrExpr.down(i).opCode() == 136 || SymbolTable.checkScalarNumericInt(indexType = this.typeCheck(instrOrExpr.down(i), true, false, false, instruction, isBeginning, currentUnit))) continue;
                    TapEnv.fileWarning(15, instrOrExpr.down(i), "(TC13) Triplet element is expected to be numeric, and is here " + indexType.showType());
                }
                instrOrExpr = ILUtils.build(58, ILUtils.copy(instrOrExpr.down(1)), ILUtils.copy(instrOrExpr.down(2)));
                dimensions[0] = new ArrayDim(ILUtils.copy(instrOrExpr), 1, null, null, -1, 0, 0);
                returnedType = new WrapperTypeSpec(new ArrayTypeSpec(this.getTypeDecl((String)"integer").typeSpec, dimensions));
                break;
            }
            case 9: {
                WrapperTypeSpec resultTypeSpec = null;
                Tree[] elements = instrOrExpr.children();
                int totalLength = 0;
                for (int i = elements.length - 1; i >= 0; --i) {
                    WrapperTypeSpec componentTypeSpec = this.typeCheck(elements[i], true, false, false, instruction, isBeginning, currentUnit);
                    if (TypeSpec.isA(componentTypeSpec, 2) && this.unit != null && !this.unit.isC()) {
                        if (totalLength >= 0) {
                            int elementLength = ArrayTypeSpec.totalArrayLength(componentTypeSpec.wrappedType.getAllDimensions());
                            totalLength = elementLength == -1 ? -1 : totalLength + elementLength;
                        }
                        componentTypeSpec = componentTypeSpec.wrappedType.elementType();
                    } else if (totalLength >= 0) {
                        ++totalLength;
                    }
                    if (resultTypeSpec == null) {
                        resultTypeSpec = componentTypeSpec;
                        continue;
                    }
                    if (resultTypeSpec.equalsCompilIndep(componentTypeSpec)) continue;
                    TapEnv.fileWarning(15, instrOrExpr, "(TC16) Type mismatch in array constructor: " + resultTypeSpec.showType() + " and " + componentTypeSpec.showType());
                }
                if (this.unit == null || this.unit.isC()) {
                    returnedType = new WrapperTypeSpec(new PointerTypeSpec(resultTypeSpec, new ArrayDim(null, 0, totalLength <= 0 ? null : Integer.valueOf(totalLength - 1), null, -1, 0, 0)));
                    break;
                }
                returnedType = new WrapperTypeSpec(new ArrayTypeSpec(resultTypeSpec, new ArrayDim[]{new ArrayDim(null, 1, totalLength <= 0 ? null : Integer.valueOf(totalLength), null, -1, 0, 0)}));
                break;
            }
            case 166: {
                Tree[] sons;
                TapList<String> commonNames = this.unit.fortranStuff().getCommonNames();
                for (Tree son : sons = instrOrExpr.children()) {
                    if (son == null || son.opCode() == 94 && TapList.containsEquals(commonNames, son.stringValue())) continue;
                    this.typeCheck(son, true, true, false, instruction, isBeginning, currentUnit);
                }
                break;
            }
            case 94: 
            case 121: {
                SymbolTable locSymbolTable;
                FunctionDecl funcDecl;
                VariableDecl symbolDecl;
                String varName = ILUtils.getIdentString(instrOrExpr);
                if (this.inCompositeTypeSpec != null && this.inCompositeTypeSpec.namedFieldType(varName) != null) {
                    returnedType = this.inCompositeTypeSpec.namedFieldType(varName);
                    break;
                }
                if (onType) {
                    TypeDecl typeDecl = this.getTypeDecl(varName);
                    if (typeDecl != null && (typeDecl.typeSpec == null || TypeSpec.isA(typeDecl.typeSpec, 11))) {
                        TapEnv.fileWarning(15, instrOrExpr, "(TC62) Undeclared type: " + varName);
                    }
                    if (typeDecl != null) break;
                }
                if ((symbolDecl = this.getVariableOrConstantOrFuncNameDecl(varName)) != null) {
                    returnedType = symbolDecl.type();
                    if (!TapEnv.relatedLanguageIsC() || !symbolDecl.isATrueSymbolDecl) break;
                    VariableDecl tuSymbolDecl = null;
                    SymbolTable localSymbolTable = this;
                    if (this.unit == null) {
                        tuSymbolDecl = this.getTopVariableOrConstantDecl(varName);
                        if (tuSymbolDecl != null || symbolDecl.isExtern()) break;
                        returnedType = null;
                        TapEnv.fileWarning(15, instrOrExpr, "(TC20) Variable " + varName + " is not declared");
                        WrapperTypeSpec typeSpec = new WrapperTypeSpec(null);
                        VariableDecl newVarDecl = new VariableDecl(instrOrExpr, typeSpec);
                        this.addSymbolDecl(newVarDecl);
                        Tree newDecl = ILUtils.build(194, ILUtils.build(128), typeSpec.generateTree(this, null, null, true, null), ILUtils.build(53, ILUtils.build(94, varName)));
                        Instruction instr = new Instruction(newDecl);
                        this.declarationsBlock.addInstrDeclTlBeforeUse(instr, new TapList<SymbolDecl>(newVarDecl, null), null, this, true);
                        newVarDecl.setInstruction(instr);
                        break;
                    }
                    if (this.unit.translationUnitSymbolTable() == null) break;
                    while (tuSymbolDecl == null && localSymbolTable != this.unit.translationUnitSymbolTable().basisSymbolTable()) {
                        tuSymbolDecl = localSymbolTable.getTopVariableOrConstantDecl(varName);
                        localSymbolTable = localSymbolTable.basisSymbolTable;
                    }
                    if (tuSymbolDecl != null || symbolDecl.isExtern()) break;
                    returnedType = null;
                    TapEnv.fileWarning(15, instrOrExpr, "(TC20) Variable " + varName + " is not declared");
                    WrapperTypeSpec typeSpec = new WrapperTypeSpec(null);
                    this.unit.bodySymbolTable().addSymbolDecl(new VariableDecl(instrOrExpr, typeSpec));
                    break;
                }
                Unit enclosingClass = currentUnit;
                if (currentUnit != null && !currentUnit.isClass()) {
                    enclosingClass = currentUnit.getUpperLevelClassUnit();
                }
                if (varName != null && enclosingClass != null && varName.equals("this")) {
                    returnedType = new WrapperTypeSpec(new PointerTypeSpec(new WrapperTypeSpec(enclosingClass.classTypeSpec()), null));
                    TapEnv.fileWarning(15, instrOrExpr, "(TC75) Pointer 'this' not loaded in class " + enclosingClass.name);
                    break;
                }
                TapList<FunctionDecl> funcDecls = this.getTopFunctionDecl(varName, null, null, false);
                if (funcDecls == null) {
                    funcDecls = this.getFunctionDeclInUnit(varName, null, null, false, this.unit);
                }
                if (funcDecls == null && this.unit != null) {
                    TapList<Unit> enclosingUnits = this.unit.enclosingUnits();
                    while (funcDecls == null && enclosingUnits != null) {
                        funcDecls = this.getFunctionDeclInUnit(varName, null, null, false, (Unit)enclosingUnits.head);
                        enclosingUnits = enclosingUnits.tail;
                    }
                }
                if (funcDecls == null && (this.unit == null || this.unit.isC() || this.unit.isCPlusPlus())) {
                    funcDecls = this.getFunctionDecl(varName, null, null, false);
                }
                FunctionDecl functionDecl = funcDecl = funcDecls == null ? null : (FunctionDecl)funcDecls.head;
                if (funcDecl != null) {
                    WrapperTypeSpec typeSpec;
                    returnedType = typeSpec = funcDecl.type();
                    break;
                }
                if (instrOrExpr.parent() != null && ((instrOrExpr.parent().opCode() == 31 || instrOrExpr.parent().opCode() == 171) && instrOrExpr.rankInParent() == 1 || (instrOrExpr.parent().opCode() == 194 || instrOrExpr.parent().opCode() == 127) && instrOrExpr.rankInParent() == 2)) {
                    TypeDecl typeDecl = this.getTypeDecl(varName);
                    if (typeDecl == null || TypeSpec.isA(typeDecl.typeSpec, 11)) {
                        TapEnv.fileWarning(15, instrOrExpr, "(TC62) Undeclared type: " + varName);
                    }
                    returnedType = null;
                    break;
                }
                WrapperTypeSpec typeSpec = this.getImplicitTypeSpec(varName);
                SymbolTable symbolTable = locSymbolTable = this.unit == null ? this : null;
                if (locSymbolTable == null) {
                    locSymbolTable = this.unit.privateSymbolTable();
                }
                if (locSymbolTable == null) {
                    locSymbolTable = this.unit.publicSymbolTable();
                }
                if (typeSpec == null) {
                    TapEnv.fileWarning(15, instrOrExpr, "(TC20) Variable " + varName + " is not declared");
                    typeSpec = new WrapperTypeSpec(null);
                    locSymbolTable.addSymbolDecl(new VariableDecl(instrOrExpr, typeSpec));
                } else {
                    VariableDecl newVarDecl = new VariableDecl(instrOrExpr, typeSpec);
                    locSymbolTable.addSymbolDecl(newVarDecl);
                    Tree newDecl = ILUtils.build(194, ILUtils.build(128), typeSpec.generateTree(this, null, null, true, null), ILUtils.build(53, ILUtils.build(94, newVarDecl.symbol)));
                    Instruction instr = new Instruction(newDecl);
                    this.declarationsBlock.addInstrDeclTlBeforeUse(instr, new TapList<SymbolDecl>(newVarDecl, null), null, locSymbolTable, true);
                    newVarDecl.setInstruction(instr);
                }
                returnedType = typeSpec;
                break;
            }
            case 109: {
                returnedType = new WrapperTypeSpec(new LabelTypeSpec());
                break;
            }
            case 19: 
            case 101: {
                returnedType = this.getTypeDecl((String)"integer").typeSpec;
                break;
            }
            case 155: {
                returnedType = this.realCstTypeSpec(instrOrExpr);
                break;
            }
            case 27: {
                returnedType = this.getTypeDecl((String)"boolean").typeSpec;
                break;
            }
            case 42: {
                this.typeCheck(instrOrExpr.down(1), true, false, false, instruction, isBeginning, currentUnit);
                this.typeCheck(instrOrExpr.down(2), true, false, false, instruction, isBeginning, currentUnit);
                WrapperTypeSpec charType = this.getTypeDecl((String)"character").typeSpec;
                if (this.unit == null || this.unit.isC()) {
                    returnedType = new WrapperTypeSpec(new PointerTypeSpec(charType, new ArrayDim(null, 0, null, null, -1, 0, 0)));
                    break;
                }
                returnedType = new WrapperTypeSpec(new ArrayTypeSpec(charType, new ArrayDim[]{new ArrayDim(null, 1, 0, null, -1, 0, 0)}));
                break;
            }
            case 175: {
                int length = instrOrExpr.isAtom() ? instrOrExpr.stringValue().length() : 0;
                WrapperTypeSpec charType = this.getTypeDecl((String)"character").typeSpec;
                if (length == 1) {
                    returnedType = charType;
                    break;
                }
                if (this.unit == null || this.unit.isC()) {
                    returnedType = new WrapperTypeSpec(new PointerTypeSpec(charType, new ArrayDim(null, 0, null, null, -1, 0, 0)));
                    break;
                }
                returnedType = new WrapperTypeSpec(new ArrayTypeSpec(charType, new ArrayDim[]{new ArrayDim(null, 1, length, null, -1, 0, 0)}));
                break;
            }
            case 116: {
                returnedType = this.getTypeDecl((String)"character").typeSpec;
                break;
            }
            case 50: {
                Tree[] listOfVar = instrOrExpr.down(1).children();
                Tree[] listOfValue = instrOrExpr.down(2).children();
                SymbolTable locSymbolTable = this;
                if (this.unit.isModule() && locSymbolTable.isFormalParamsLevel()) {
                    locSymbolTable = this.unit.privateSymbolTable();
                }
                for (Tree value : listOfVar) {
                    locSymbolTable.typeCheck(value, true, true, false, instruction, isBeginning, currentUnit);
                }
                for (Tree tree : listOfValue) {
                    if (tree.opCode() == 162) {
                        locSymbolTable.typeCheck(tree.down(2), true, false, false, instruction, isBeginning, currentUnit);
                        continue;
                    }
                    locSymbolTable.typeCheck(tree, true, false, false, instruction, isBeginning, currentUnit);
                }
                break;
            }
            case 133: {
                Tree[] listOfVar;
                for (Tree tree : listOfVar = instrOrExpr.down(2).children()) {
                    this.typeCheck(tree, true, noFunctionCall, false, instruction, isBeginning, currentUnit);
                }
                break;
            }
            case 176: {
                Tree[] listOfString = instrOrExpr.children();
                int length = 0;
                for (Tree tree : listOfString) {
                    length = tree.stringValue().length();
                }
                if (length == 1) {
                    returnedType = this.getTypeDecl((String)"character").typeSpec;
                    break;
                }
                ArrayDim[] dims = new ArrayDim[]{this.unit == null || this.unit.isC() ? new ArrayDim(null, 1, null, null, -1, 0, 0) : new ArrayDim(null, 1, length, null, -1, 0, 0)};
                returnedType = new WrapperTypeSpec(new ArrayTypeSpec(this.getTypeDecl((String)"character").typeSpec, dims));
                break;
            }
            case 4: {
                WrapperTypeSpec allocatedType;
                this.typeCheck(instrOrExpr.down(1), expectResult, noFunctionCall, false, instruction, isBeginning, currentUnit);
                this.unit.setAllocDealloc();
                TapList<Object> newDimensionsList = null;
                Tree dimensions = instrOrExpr.down(2);
                if (this.assignDestination == null) break;
                WrapperTypeSpec topType = this.typeCheck(this.assignDestination, true, true, false, instruction, isBeginning, currentUnit);
                this.typeCheck(instrOrExpr.down(5), expectResult, noFunctionCall, false, instruction, isBeginning, currentUnit);
                TapEnv.printlnOnTrace(40, "  ALLOCATION POINT: " + instrOrExpr + " ASSIGNED INTO: " + this.assignDestination + " (in " + instrOrExpr.parent() + ")");
                TapEnv.printlnOnTrace(40, "   OF TYPE (topType):" + topType);
                if (dimensions.opCode() != 136) {
                    int i;
                    ArrayDim[] newDimensions;
                    if (!this.unit.isC() && !this.unit.isCPlusPlus() && TypeSpec.isA(topType, 6)) {
                        topType = ((PointerTypeSpec)topType.wrappedType).destinationType;
                    }
                    int actualN = dimensions.length();
                    int formalN = 0;
                    WrapperTypeSpec elementType = null;
                    if (topType != null) {
                        if (ILUtils.oneIsArrayTriplet(dimensions) && TypeSpec.isA(topType, 3)) {
                            topType = this.changeFunctionToArrayTypeSpec(this.assignDestination, topType);
                        }
                        if (topType.checkArray()) {
                            elementType = topType.wrappedType.elementType();
                            if (((ArrayTypeSpec)topType.wrappedType).dimensions() == null) {
                                newDimensions = new ArrayDim[actualN];
                                String identNext = ILUtils.getIdentString(this.assignDestination);
                                for (int i4 = actualN - 1; i4 >= 0; --i4) {
                                    newDimensions[i4] = new ArrayDim(ILUtils.build(58), 1, null, identNext == null ? null : this.assignDestination, i4 + 1, actualN, 1);
                                }
                                ((ArrayTypeSpec)topType.wrappedType).setDimensions(newDimensions);
                            } else {
                                formalN = ((ArrayTypeSpec)topType.wrappedType).dimensions().length;
                                if (formalN != actualN) {
                                    TapEnv.fileWarning(15, instrOrExpr, "(TC24) Wrong number of dimensions for array " + ILUtils.toString(ILUtils.baseTree(this.assignDestination)) + ": " + formalN + " expected, and " + actualN + " given");
                                }
                            }
                        } else {
                            elementType = topType.checkPointer() ? ((PointerTypeSpec)topType.wrappedType).destinationType : (TypeSpec.isA(topType, 3) ? ((FunctionTypeSpec)topType.wrappedType).returnType : topType);
                        }
                    }
                    for (i = 1; i <= actualN; ++i) {
                        ArrayDim newDim;
                        Tree index = dimensions.down(i);
                        WrapperTypeSpec indexType = this.typeCheck(index, true, false, false, instruction, isBeginning, currentUnit);
                        if (indexType != null && indexType.wrappedType != null && !indexType.checkNumericInt()) {
                            TapEnv.fileWarning(15, index, "(TC12) Array dimension is expected to be integer, and is here " + indexType.showType());
                        }
                        if (index.opCode() == 11) {
                            newDim = new ArrayDim(ILUtils.copy(index), 1, null, null, -1, 0, 0);
                            this.refineTripletDimension(index, newDim, false);
                            if (!newDim.isSufficientlyDefined() && TypeSpec.isA(topType, 2) && i <= formalN) {
                                newDim = ((ArrayTypeSpec)topType.wrappedType).dimensions()[i - 1];
                            }
                        } else {
                            newDim = index.opCode() == 58 ? new ArrayDim(ILUtils.copy(index), 1, null, null, -1, 0, 0) : new ArrayDim(ILUtils.build(58, ILUtils.build(101, 1), ILUtils.copy(index)), 1, null, null, -1, 0, 0);
                        }
                        newDimensionsList = new TapList<ArrayDim>(newDim, newDimensionsList);
                    }
                    newDimensions = new ArrayDim[TapList.length(newDimensionsList)];
                    for (i = newDimensions.length - 1; i >= 0; --i) {
                        newDimensions[i] = (ArrayDim)newDimensionsList.head;
                        newDimensionsList = newDimensionsList.tail;
                    }
                    if (this.unit.isC() || this.unit.isCPlusPlus()) {
                        returnedType = allocatedType = new WrapperTypeSpec(new PointerTypeSpec(elementType, newDimensions[0]));
                    } else {
                        allocatedType = new WrapperTypeSpec(new ArrayTypeSpec(elementType, newDimensions));
                        returnedType = new WrapperTypeSpec(new PointerTypeSpec(allocatedType, null));
                    }
                } else {
                    allocatedType = topType;
                    if (allocatedType.checkPointer()) {
                        allocatedType = ((PointerTypeSpec)allocatedType.wrappedType).destinationType;
                    }
                    returnedType = topType;
                }
                TapEnv.printlnOnTrace(40, "   -> ALLOCATED TYPE: " + allocatedType + " RETURNED TYPE: " + returnedType);
                this.unit.callGraph().addAllocationPoint(instrOrExpr, this.assignDestination, allocatedType, this);
                break;
            }
            case 51: {
                this.unit.setAllocDealloc();
                this.typeCheck(instrOrExpr.down(1), true, true, false, instruction, isBeginning, currentUnit);
                break;
            }
            case 138: {
                int nbSons = instrOrExpr.length();
                for (int i = 1; i <= nbSons; ++i) {
                    WrapperTypeSpec typeSpec = this.typeCheck(instrOrExpr.down(i), true, true, false, instruction, isBeginning, currentUnit);
                    if (TypeSpec.isA(typeSpec, 6)) continue;
                    TapEnv.fileWarning(15, instrOrExpr, "(TC48) Nullify a non-pointer expression " + ILUtils.toString(instrOrExpr));
                }
                break;
            }
            case 148: {
                WrapperTypeSpec indexTypeInAdd;
                if (instrOrExpr.down(1).opCode() == 2 && instrOrExpr.down(2).opCode() == 136 && (indexTypeInAdd = this.typeCheck(instrOrExpr.down(1).down(2), true, false, false, instruction, isBeginning, currentUnit)) != null && indexTypeInAdd.wrappedType != null && indexTypeInAdd.checkNumericInt()) {
                    instrOrExpr.setChild(ILUtils.copy(instrOrExpr.down(1).down(2)), 2);
                    instrOrExpr.setChild(ILUtils.copy(instrOrExpr.down(1).down(1)), 1);
                }
                WrapperTypeSpec pointerTypeSpec = this.typeCheck(instrOrExpr.down(1), true, false, false, instruction, isBeginning, currentUnit);
                WrapperTypeSpec indexType = this.typeCheck(instrOrExpr.down(2), true, false, false, instruction, isBeginning, currentUnit);
                if (indexType != null && indexType.wrappedType != null && !indexType.checkNumericInt()) {
                    TapEnv.fileWarning(15, instrOrExpr.down(2), "(TC12) Array index is expected to be integer, and is here " + indexType.showType());
                }
                if (TypeSpec.isA(pointerTypeSpec, 6)) {
                    returnedType = ((PointerTypeSpec)pointerTypeSpec.wrappedType).destinationType;
                    break;
                }
                if (TypeSpec.isA(pointerTypeSpec, 2)) {
                    TapEnv.fileWarning(15, instrOrExpr, "(TC40) Pointer access to an array expression " + ILUtils.toString(instrOrExpr));
                    returnedType = pointerTypeSpec.wrappedType.elementType();
                    break;
                }
                TapEnv.fileWarning(15, instrOrExpr, "(TC40) Pointer access to a non-pointer expression " + ILUtils.toString(instrOrExpr));
                returnedType = null;
                break;
            }
            case 3: {
                WrapperTypeSpec addressedType = this.typeCheck(instrOrExpr.down(1), true, true, false, instruction, isBeginning, currentUnit);
                returnedType = new WrapperTypeSpec(new PointerTypeSpec(addressedType, null));
                break;
            }
            case 31: {
                this.typeCheck(instrOrExpr.down(1), true, false, false, instruction, isBeginning, currentUnit);
                this.typeCheck(instrOrExpr.down(2), true, false, false, instruction, isBeginning, currentUnit);
                WrapperTypeSpec castTypeCheck = null;
                if (instrOrExpr.down(1).opCode() == 94) {
                    String castTypeName = instrOrExpr.down(1).stringValue();
                    TypeDecl castTypeDecl = this.getTypeDecl(castTypeName);
                    if (castTypeDecl != null) {
                        castTypeCheck = castTypeDecl.typeSpec;
                    }
                } else if (instrOrExpr.down(1).opCode() == 199) {
                    TypeDecl castTypeDecl = this.getTypeDecl("void");
                    if (castTypeDecl != null) {
                        castTypeCheck = castTypeDecl.typeSpec;
                    }
                } else {
                    castTypeCheck = TypeSpec.build(instrOrExpr.down(1), this, instruction, new TapList<Object>(null, null), new TapList<Object>(null, null), new TapList<Object>(null, null), new ToBool(false), null);
                }
                if (castTypeCheck == null) {
                    TapEnv.fileWarning(15, instrOrExpr, "(TC61) Illegal cast expression " + ILUtils.toString(instrOrExpr));
                    castTypeCheck = this.typeCheck(instrOrExpr.down(2), true, false, false, instruction, isBeginning, currentUnit);
                }
                returnedType = castTypeCheck;
                break;
            }
            case 194: {
                Tree[] declarators;
                this.typeCheck(instrOrExpr.down(2), true, true, true, instruction, isBeginning, currentUnit);
                for (Tree tree : declarators = instrOrExpr.down(3).children()) {
                    FunctionDecl funcDecl;
                    Tree declarator = tree;
                    if (declarator.opCode() == 13 || declarator.opCode() == 149 || declarator.opCode() == 10) {
                        this.typeCheck(declarator, false, noFunctionCall, false, instruction, isBeginning, currentUnit);
                        continue;
                    }
                    if (declarator.opCode() != 94) continue;
                    TapList<FunctionDecl> funcDecls = this.getTopFunctionDecl(declarator.stringValue(), null, null, false);
                    FunctionDecl functionDecl = funcDecl = funcDecls == null ? null : (FunctionDecl)funcDecls.head;
                    if (funcDecl == null) continue;
                    declarator.setAnnotation("isFunctionName", Boolean.TRUE);
                }
                break;
            }
            case 187: {
                if (instrOrExpr.down(2).opCode() == 94) break;
                this.typeCheck(instrOrExpr.down(2), true, true, false, instruction, isBeginning, currentUnit);
                break;
            }
            case 171: {
                this.typeCheck(instrOrExpr.down(1), expectResult, noFunctionCall, true, instruction, isBeginning, currentUnit);
                returnedType = this.getTypeDecl((String)"integer").typeSpec;
                break;
            }
            case 151: {
                this.typeCheck(instrOrExpr.down(1), true, true, true, instruction, isBeginning, currentUnit);
                break;
            }
            case 127: {
                this.typeCheck(instrOrExpr.down(1), true, true, false, instruction, isBeginning, currentUnit);
                this.typeCheck(instrOrExpr.down(2), true, false, true, instruction, isBeginning, currentUnit);
                break;
            }
            case 58: {
                this.typeCheck(instrOrExpr.down(1), true, false, false, instruction, isBeginning, currentUnit);
                returnedType = this.typeCheck(instrOrExpr.down(2), true, false, false, instruction, isBeginning, currentUnit);
                break;
            }
            case 156: {
                CompositeTypeSpec inPreviousCompositeTypeSpec = this.inCompositeTypeSpec;
                Object annot = instrOrExpr.getAnnotation("WrapperTypeSpec");
                if (annot != null) {
                    this.inCompositeTypeSpec = (CompositeTypeSpec)((WrapperTypeSpec)annot).wrappedType;
                } else if (instrOrExpr.down(3).opCode() != 136) {
                    TapEnv.toolError("Type checking " + ILUtils.toString(instrOrExpr));
                }
                this.typeCheck(instrOrExpr.down(3), true, true, false, instruction, isBeginning, currentUnit);
                this.inCompositeTypeSpec = inPreviousCompositeTypeSpec;
                break;
            }
            case 35: 
            case 45: 
            case 55: 
            case 87: 
            case 129: 
            case 134: 
            case 154: {
                break;
            }
            case 12: 
            case 66: {
                this.typeCheck(instrOrExpr.down(2), true, true, false, instruction, isBeginning, currentUnit);
                break;
            }
            case 190: {
                CompositeTypeSpec inPreviousCompositeTypeSpec = this.inCompositeTypeSpec;
                this.inCompositeTypeSpec = (CompositeTypeSpec)((WrapperTypeSpec)instrOrExpr.getAnnotation((String)"WrapperTypeSpec")).wrappedType;
                this.typeCheck(instrOrExpr.down(2), true, true, false, instruction, isBeginning, currentUnit);
                this.inCompositeTypeSpec = inPreviousCompositeTypeSpec;
                break;
            }
            case 104: {
                break;
            }
            case 192: {
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(Type checking) Unexpected operator: " + instrOrExpr.opName());
            }
        }
        if (TapEnv.traceTypeCheckAnalysis()) {
            TapEnv.setTraceIndent(TapEnv.traceIndent() - 2);
            TapEnv.indentOnTrace(TapEnv.traceIndent());
            TapEnv.printlnOnTrace("TypeCheck of " + instrOrExpr + " returns " + returnedType);
        }
        return returnedType;
    }

    private WrapperTypeSpec getOverloadedWrapperTypeSpec(Tree instrOrExpr, Instruction instruction, String overloadedName, WrapperTypeSpec[] types) {
        WrapperTypeSpec returnedType;
        TapList<InterfaceDecl> interfaceDecls = this.getInterfaceDecl(overloadedName);
        FunctionDecl functionDecl = null;
        InterfaceDecl interfaceDecl = null;
        while (interfaceDecls != null && functionDecl == null) {
            interfaceDecl = (InterfaceDecl)interfaceDecls.head;
            functionDecl = interfaceDecl.findFunctionDecl(types, null, instrOrExpr);
            interfaceDecls = interfaceDecls.tail;
        }
        if (interfaceDecl != null && functionDecl == null && (functionDecl = interfaceDecl.findOneFunctionDecl(types, instrOrExpr)) != null) {
            TapEnv.fileWarning(15, instrOrExpr, "(TC34) Found no specific procedure that matches generic interface call: " + ILUtils.toString(instrOrExpr) + "; Took fallback choice: " + functionDecl.symbol);
        }
        if (functionDecl != null) {
            Tree newTree;
            Tree newUnaryOrBinaryTree;
            if (types.length == 1) {
                newUnaryOrBinaryTree = ILUtils.build(189, ILUtils.build(94, overloadedName), instrOrExpr.down(1).copy());
                newTree = ILUtils.buildCall(ILUtils.build(94, overloadedName), ILUtils.build(70, instrOrExpr.down(1).copy()));
            } else {
                newUnaryOrBinaryTree = ILUtils.build(16, instrOrExpr.down(1).copy(), ILUtils.build(94, overloadedName), instrOrExpr.down(2).copy());
                newTree = ILUtils.buildCall(ILUtils.build(94, overloadedName), ILUtils.build(70, instrOrExpr.down(1).copy(), instrOrExpr.down(2).copy()));
            }
            if (TapEnv.traceTypeCheckAnalysis()) {
                TapEnv.indentOnTrace(TapEnv.traceIndent());
                TapEnv.printlnOnTrace("Replace " + instrOrExpr + " with explicit call " + newTree);
            }
            newTree.setAnnotation("sourcetree", newUnaryOrBinaryTree);
            CallArrow callArrow = CallGraph.addCallArrow(this.unit, 1, functionDecl.unit());
            callArrow.setSrcCallName(overloadedName);
            newTree.setAnnotation("callArrow", callArrow);
            instruction.replaceTree(instrOrExpr, newTree);
            returnedType = functionDecl.functionTypeSpec().returnType;
        } else {
            String showTypes = types[0].showType();
            if (types.length == 2) {
                showTypes = showTypes + " " + types[1].showType();
            }
            TapEnv.fileWarning(15, instrOrExpr, "(TC39) Overloaded operator " + instrOrExpr.opName() + " undefined for types " + showTypes);
            returnedType = null;
        }
        return returnedType;
    }

    private void removeDuplicateFunctionDecls() {
        SymbolDecl symbolDecl;
        TapList<SymbolDecl> allDecls = this.getAllTopSymbolDecls();
        TapList<Object> allDuplicateFunctionDecls = null;
        while (allDecls != null) {
            symbolDecl = (SymbolDecl)allDecls.head;
            if (symbolDecl.isA(3)) {
                TapList<FunctionDecl> rootFunctionDecls = this.basisSymbolTable.getFunctionDecl(symbolDecl.symbol, ((FunctionDecl)symbolDecl).returnTypeSpec(), ((FunctionDecl)symbolDecl).argumentsTypesSpec(), true);
                while (rootFunctionDecls != null) {
                    if (rootFunctionDecls.head == symbolDecl) {
                        allDuplicateFunctionDecls = new TapList<SymbolDecl>(symbolDecl, allDuplicateFunctionDecls);
                    }
                    rootFunctionDecls = rootFunctionDecls.tail;
                }
            }
            allDecls = allDecls.tail;
        }
        while (allDuplicateFunctionDecls != null) {
            symbolDecl = (SymbolDecl)allDuplicateFunctionDecls.head;
            this.removeDecl(symbolDecl.symbol, 3, true);
            allDuplicateFunctionDecls = allDuplicateFunctionDecls.tail;
        }
    }

    private boolean okWithNoType(Tree declTree, Unit unit) {
        if (unit.isCPlusPlus() && unit.isClass()) {
            Tree declarators = declTree.down(3);
            if (declarators.length() == 1 && declarators.down(1).opCode() == 88) {
                String className;
                Tree funcDeclarator = declarators.down(1);
                String funcName = ILUtils.getIdentString(funcDeclarator.down(1));
                return funcName.equals(className = unit.name) || funcName.equals("~" + className);
            }
            return false;
        }
        return false;
    }

    protected void terminateFunctionDeclarationInstructions(Tree declTree) {
        switch (declTree.opCode()) {
            case 94: {
                SymbolDecl symbolDecl = this.getSymbolDecl(ILUtils.getIdentString(declTree));
                if (symbolDecl == null || !symbolDecl.isA(3) && !symbolDecl.isA(6)) break;
                declTree.setAnnotation("isFunctionName", Boolean.TRUE);
                break;
            }
            case 194: {
                if (!(declTree.down(2) == null || declTree.down(2).opCode() != 136 || this.okWithNoType(declTree, this.unit) || this.unit != null && this.unit.language() == 5)) {
                    Tree returnTypeTree;
                    WrapperTypeSpec returnType = (WrapperTypeSpec)declTree.down(2).getAnnotation("typeSpec");
                    if (returnType != null && returnType.wrappedType != null) {
                        returnTypeTree = returnType.generateTree(this, null, null, true, null);
                    } else {
                        TapEnv.fileWarning(15, declTree, "(TC49) Unknown return type for function " + ILUtils.toString(declTree.down(3)));
                        returnTypeTree = ILUtils.build(94, "UnknownType");
                    }
                    declTree.setChild(returnTypeTree, 2);
                }
                this.terminateFunctionDeclarationInstructions(declTree.down(3));
                break;
            }
            case 53: 
            case 72: 
            case 106: {
                Tree[] sons = declTree.children();
                for (int i = sons.length - 1; i >= 0; --i) {
                    this.terminateFunctionDeclarationInstructions(sons[i]);
                }
                break;
            }
            case 10: 
            case 13: 
            case 25: 
            case 47: 
            case 57: 
            case 126: 
            case 149: 
            case 150: 
            case 170: 
            case 172: 
            case 197: {
                break;
            }
        }
    }

    private CallArrow setCallArrow(Tree instrOrExpr, Unit functionUnit, FunctionDecl functionDecl) {
        FunctionDecl[] initialValues = functionDecl.initFunctionDecls;
        if (initialValues == null && functionDecl.symbol != null) {
            VariableDecl funcVarDecl = this.getFuncVarDecl(functionDecl.symbol);
            initialValues = funcVarDecl == null ? null : funcVarDecl.initFunctionDecls;
        }
        int index = 0;
        if (instrOrExpr.down(1).opCode() == 8) {
            index = instrOrExpr.down(1).down(2).down(1).intValue();
        }
        FunctionDecl initializer = null;
        if (initialValues != null && 0 <= index && index < initialValues.length) {
            initializer = initialValues[index];
        }
        CallArrow mainCallArrow = CallGraph.addCallArrow(this.unit, 1, initializer != null ? initializer.unit() : functionUnit);
        String origCallName = ILUtils.getCallFunctionNameString(instrOrExpr);
        mainCallArrow.setSrcCallName(origCallName);
        return mainCallArrow;
    }

    private WrapperTypeSpec sumResultType(WrapperTypeSpec actualArgType, Tree dim) {
        WrapperTypeSpec returnType = actualArgType.elementType();
        if (dim != null) {
            TapList<ArrayDim> toNewDimensions;
            TapList<ArrayDim> dimensions = actualArgType.getAllDimensions();
            int dimValue = dim.intValue();
            if (dimValue == -1) {
                TapEnv.fileWarning(-1, dim, "(Type Checking of SUM) statically unknown DIM rank: " + ILUtils.toString(dim));
                dimValue = TapList.length(dimensions);
            } else if (dimValue <= 0 || dimValue > TapList.length(dimensions)) {
                TapEnv.fileWarning(-1, dim, "(Type Checking of SUM) DIM rank out of range: " + ILUtils.toString(dim));
                dimValue = TapList.length(dimensions);
            }
            TapList<ArrayDim> inNewDimensions = toNewDimensions = new TapList<ArrayDim>(null, dimensions);
            for (dimValue = TapList.length(dimensions) - dimValue; dimValue > 0; --dimValue) {
                inNewDimensions = inNewDimensions.tail;
            }
            inNewDimensions.tail = inNewDimensions.tail.tail;
            inNewDimensions = toNewDimensions.tail;
            if (inNewDimensions != null) {
                ArrayDim[] dimsArray = new ArrayDim[TapList.length(inNewDimensions)];
                int i = 0;
                while (inNewDimensions != null) {
                    dimsArray[i] = (ArrayDim)inNewDimensions.head;
                    ++i;
                    inNewDimensions = inNewDimensions.tail;
                }
                returnType = new WrapperTypeSpec(new ArrayTypeSpec(returnType, dimsArray));
            }
        }
        return returnType;
    }

    private WrapperTypeSpec spreadResultType(WrapperTypeSpec actualArgType, Tree dim, Tree length) {
        TapList<ArrayDim> toNewDimensions;
        if (dim.opCode() == 132) {
            dim = dim.down(2);
        }
        if (length.opCode() == 132) {
            length = length.down(2);
        }
        WrapperTypeSpec returnType = actualArgType.elementType();
        TapList<ArrayDim> dimensions = actualArgType.getAllDimensions();
        int dimValue = dim.intValue();
        if (dimValue == -1) {
            TapEnv.fileWarning(-1, dim, "(Type Checking of SPREAD) statically unknown DIM rank: " + ILUtils.toString(dim));
            dimValue = TapList.length(dimensions) + 1;
        }
        TapList<ArrayDim> inNewDimensions = toNewDimensions = new TapList<ArrayDim>(null, dimensions);
        for (dimValue = TapList.length(dimensions) + 1 - dimValue; dimValue > 0; --dimValue) {
            inNewDimensions = inNewDimensions.tail;
        }
        inNewDimensions.tail = new TapList<ArrayDim>(new ArrayDim(length, null, null, null, -1, 0, 0), inNewDimensions.tail);
        inNewDimensions = toNewDimensions.tail;
        ArrayDim[] dimsArray = new ArrayDim[TapList.length(inNewDimensions)];
        int i = 0;
        while (inNewDimensions != null) {
            dimsArray[i] = (ArrayDim)inNewDimensions.head;
            ++i;
            inNewDimensions = inNewDimensions.tail;
        }
        returnType = new WrapperTypeSpec(new ArrayTypeSpec(returnType, dimsArray));
        return returnType;
    }

    private FunctionDecl mixedLanguageCall(String functionName, FunctionDecl localFunctionDecl) {
        FunctionDecl calledFunctionDecl = null;
        if (TapEnv.inputLanguage() == 100) {
            if (TapEnv.traceTypeCheckAnalysis()) {
                TapEnv.printlnOnTrace("  Checking Mixed-language call: " + functionName + " " + localFunctionDecl);
            }
            if (this.unit == null || this.unit.isC()) {
                boolean result;
                TapPair<String, FunctionDecl> fortranFuncName = this.getCallGraph().getMixedLanguageFunctionName(functionName, 4, 1);
                FunctionDecl fortranFunctionDecl = (FunctionDecl)fortranFuncName.second;
                String fortranName = (String)fortranFuncName.first;
                if (fortranFunctionDecl == null && fortranName != null) {
                    TapList<FunctionDecl> fortranFunctionDecls = this.getFunctionDecl(fortranName, null, null, false);
                    FunctionDecl functionDecl = fortranFunctionDecl = fortranFunctionDecls == null ? null : (FunctionDecl)fortranFunctionDecls.head;
                    if ((fortranFunctionDecl == null || fortranFunctionDecl.isExternal()) && ((fortranFunctionDecl = this.getFunctionNotExternalNorInterfaceDecl(functionName)) == null || fortranFunctionDecl.isExternal())) {
                        fortranFunctionDecls = this.getCallGraph().fortranRootSymbolTable().getFunctionDecl(fortranName, null, null, false);
                        FunctionDecl functionDecl2 = fortranFunctionDecl = fortranFunctionDecls == null ? null : (FunctionDecl)fortranFunctionDecls.head;
                    }
                }
                if (fortranFunctionDecl != null && localFunctionDecl != null && localFunctionDecl.isExternal() && (this.unit == null || fortranFunctionDecl.unit().language() != this.language)) {
                    this.getCallGraph().deleteUnit(localFunctionDecl.unit());
                    localFunctionDecl.renamedFromSymbolDecl = fortranFunctionDecl;
                    localFunctionDecl.setUnit(fortranFunctionDecl.unit());
                    TapList<FunctionDecl> globalFunctionDecls = this.getCallGraph().cRootSymbolTable().getFunctionDecl(functionName, null, null, false);
                    if (globalFunctionDecls != null) {
                        ((FunctionDecl)globalFunctionDecls.head).renamedFromSymbolDecl = fortranFunctionDecl;
                    }
                    if (TapEnv.traceTypeCheckAnalysis()) {
                        TapEnv.printlnOnTrace("    Mixed-language call:" + this.unit + " calls " + fortranFunctionDecl.unit());
                    }
                    fortranFunctionDecl.unit().setCalledFromOtherLanguage();
                }
                boolean bl = result = fortranFunctionDecl != null && (this.unit == null || fortranFunctionDecl.unit().language() != this.language);
                if (result) {
                    calledFunctionDecl = fortranFunctionDecl;
                }
            } else if (this.unit.isFortran()) {
                boolean result;
                TapList<FunctionDecl> fortranFunctionDecls = this.getFunctionDecl(functionName, null, null, false);
                FunctionDecl fortranFunctionDecl = fortranFunctionDecls == null ? null : (FunctionDecl)fortranFunctionDecls.head;
                FunctionDecl cFunctionDecl = null;
                TapPair<String, FunctionDecl> cFuncName = this.getCallGraph().getMixedLanguageFunctionName(functionName, this.language, 4);
                String cName = (String)cFuncName.first;
                if (cName != null) {
                    TapList<FunctionDecl> cFunctionDecls = this.getCallGraph().cRootSymbolTable().getFunctionDecl(cName, null, null, false);
                    FunctionDecl functionDecl = cFunctionDecl = cFunctionDecls == null ? null : (FunctionDecl)cFunctionDecls.head;
                }
                if (cFunctionDecl != null && localFunctionDecl != null && (localFunctionDecl.isExternal() || localFunctionDecl.isInterface()) && (this.unit != null || cFunctionDecl.unit().language() != this.language)) {
                    localFunctionDecl.renamedFromSymbolDecl = cFunctionDecl;
                    localFunctionDecl.setUnit(cFunctionDecl.unit());
                    if (fortranFunctionDecl != null && fortranFunctionDecl.isInterface() && fortranFunctionDecl.unit() != cFunctionDecl.unit()) {
                        CallGraph.addCallArrow(fortranFunctionDecl.unit(), 1, cFunctionDecl.unit());
                    }
                    if (TapEnv.traceTypeCheckAnalysis()) {
                        TapEnv.printlnOnTrace("    Mixed-language call: " + this.unit + " calls  " + cFunctionDecl.unit());
                    }
                }
                if (cFunctionDecl != null && cFunctionDecl.unit() != null) {
                    cFunctionDecl.unit().setCalledFromOtherLanguage();
                }
                boolean bl = result = cFunctionDecl != null && (this.unit != null || cFunctionDecl.unit().language() != this.language);
                if (result) {
                    calledFunctionDecl = cFunctionDecl;
                }
            }
        }
        return calledFunctionDecl;
    }

    private WrapperTypeSpec changeFunctionToArrayTypeSpec(Tree instrOrExpr, WrapperTypeSpec topType) {
        FunctionDecl funcDecl;
        String name = ILUtils.baseName(instrOrExpr);
        TapList<FunctionDecl> funcDecls = this.getTopFunctionDecl(name, null, null, false);
        FunctionDecl functionDecl = funcDecl = funcDecls == null ? null : (FunctionDecl)funcDecls.head;
        if (funcDecl == null) {
            funcDecls = this.getFunctionDeclInUnit(name, null, null, false, this.unit);
            funcDecl = funcDecls == null ? null : (FunctionDecl)funcDecls.head;
        }
        topType = ((FunctionTypeSpec)topType.wrappedType).returnType;
        if (funcDecl != null) {
            if (funcDecl.hasInstructionWithRootOperator(72, null)) {
                this.declarationsBlock.removeExternalInstr(funcDecl);
            }
            this.removeDecl(name, 3, false);
            this.addSymbolDecl(new VariableDecl(instrOrExpr, topType));
        }
        return topType;
    }

    private WrapperTypeSpec canCombineNumeric(WrapperTypeSpec lhsType, WrapperTypeSpec rhsType, Tree instrOrExpr) {
        if (this.unit != null && this.unit.isCorMore() && lhsType != null && rhsType != null && (((WrapperTypeSpec)lhsType).isPointer() && rhsType.isIntegerBase() || ((WrapperTypeSpec)rhsType).isPointer() && lhsType.isIntegerBase()) && (instrOrExpr.opCode() == 2 || instrOrExpr.opCode() == 177)) {
            return ((WrapperTypeSpec)lhsType).isPointer() ? lhsType : rhsType;
        }
        if (lhsType != null && !((WrapperTypeSpec)lhsType).checkNumeric()) {
            TapEnv.fileWarning(15, instrOrExpr.down(1), "(TC11) Argument of arithmetic operator is expected to be numeric, and is here " + ((WrapperTypeSpec)lhsType).showType());
        }
        if (rhsType != null && !((WrapperTypeSpec)rhsType).checkNumeric()) {
            TapEnv.fileWarning(15, instrOrExpr.down(2), "(TC11) Argument of arithmetic operator is expected to be numeric, and is here " + ((WrapperTypeSpec)rhsType).showType());
        }
        if (lhsType == null || !((WrapperTypeSpec)lhsType).checkNumeric()) {
            if (rhsType == null || !((WrapperTypeSpec)rhsType).checkNumeric()) {
                return null;
            }
            return rhsType;
        }
        if (rhsType == null || !((WrapperTypeSpec)rhsType).checkNumeric()) {
            return lhsType;
        }
        if (((WrapperTypeSpec)lhsType).baseTypeName().equals("complex") || ((WrapperTypeSpec)rhsType).baseTypeName().equals("complex")) {
            if (((WrapperTypeSpec)lhsType).baseTypeName().equals("complex") && ((WrapperTypeSpec)rhsType).baseTypeName().equals("complex") || ((WrapperTypeSpec)lhsType).baseTypeName().equals("float") || ((WrapperTypeSpec)rhsType).baseTypeName().equals("float")) {
                if (((WrapperTypeSpec)lhsType).baseTypeName().equals("float")) {
                    lhsType = ((WrapperTypeSpec)lhsType).realToComplex(new TapList<Object>(null, null), ((WrapperTypeSpec)rhsType).baseTypeSpec(false));
                } else if (((WrapperTypeSpec)rhsType).baseTypeName().equals("float")) {
                    rhsType = ((WrapperTypeSpec)rhsType).realToComplex(new TapList<Object>(null, null), ((WrapperTypeSpec)lhsType).baseTypeSpec(false));
                }
                return this.setConformingDimension(this.setUnionModifier(this.getTypeDecl((String)"complex").typeSpec, (WrapperTypeSpec)lhsType, (WrapperTypeSpec)rhsType, false), (WrapperTypeSpec)lhsType, (WrapperTypeSpec)rhsType, instrOrExpr);
            }
            WrapperTypeSpec modifierTypeSpec = ((WrapperTypeSpec)lhsType).baseTypeName().equals("integer") ? ((WrapperTypeSpec)rhsType).modifiedBaseTypeSpec() : (((WrapperTypeSpec)rhsType).baseTypeName().equals("integer") ? ((WrapperTypeSpec)lhsType).modifiedBaseTypeSpec() : this.getTypeDecl((String)"complex").typeSpec);
            return this.setConformingDimension(modifierTypeSpec, (WrapperTypeSpec)lhsType, (WrapperTypeSpec)rhsType, instrOrExpr);
        }
        if (((WrapperTypeSpec)lhsType).baseTypeName().equals("float") || ((WrapperTypeSpec)rhsType).baseTypeName().equals("float")) {
            if (((WrapperTypeSpec)lhsType).baseTypeName().equals("float") && ((WrapperTypeSpec)rhsType).baseTypeName().equals("float")) {
                return this.setConformingDimension(this.setUnionModifier(this.getTypeDecl((String)"float").typeSpec, (WrapperTypeSpec)lhsType, (WrapperTypeSpec)rhsType, false), (WrapperTypeSpec)lhsType, (WrapperTypeSpec)rhsType, instrOrExpr);
            }
            WrapperTypeSpec modifierTypeSpec = ((WrapperTypeSpec)lhsType).baseTypeName().equals("integer") ? ((WrapperTypeSpec)rhsType).modifiedBaseTypeSpec() : (((WrapperTypeSpec)rhsType).baseTypeName().equals("integer") ? ((WrapperTypeSpec)lhsType).modifiedBaseTypeSpec() : this.getTypeDecl((String)"float").typeSpec);
            return this.setConformingDimension(modifierTypeSpec, (WrapperTypeSpec)lhsType, (WrapperTypeSpec)rhsType, instrOrExpr);
        }
        if (TypeSpec.isA(lhsType, 6)) {
            return lhsType;
        }
        if (TypeSpec.isA(rhsType, 6)) {
            return rhsType;
        }
        if (TypeSpec.isA(lhsType, 12)) {
            return rhsType;
        }
        if (TypeSpec.isA(rhsType, 12)) {
            return lhsType;
        }
        if (((WrapperTypeSpec)lhsType).baseTypeName().equals("integer") || ((WrapperTypeSpec)lhsType).baseTypeName().equals("boolean") || lhsType.isIntegerBase() || ((WrapperTypeSpec)rhsType).baseTypeName().equals("integer") || ((WrapperTypeSpec)rhsType).baseTypeName().equals("boolean") || rhsType.isIntegerBase()) {
            return this.setConformingDimension(this.setUnionModifier(this.getTypeDecl((String)"integer").typeSpec, (WrapperTypeSpec)lhsType, (WrapperTypeSpec)rhsType, false), (WrapperTypeSpec)lhsType, (WrapperTypeSpec)rhsType, instrOrExpr);
        }
        return lhsType;
    }

    public TypeSpec combineNumeric(TypeSpec lhsType, TypeSpec rhsType, Tree instrOrExpr) {
        WrapperTypeSpec lhsModifiedBaseType = lhsType.modifiedBaseTypeSpec();
        WrapperTypeSpec rhsModifiedBaseType = rhsType.modifiedBaseTypeSpec();
        String lhsBaseTypeName = lhsModifiedBaseType.baseTypeName();
        String rhsBaseTypeName = rhsModifiedBaseType.baseTypeName();
        if (this.unit != null && this.unit.isCorMore() && (lhsType.isPointer() && rhsType.isIntegerBase() || rhsType.isPointer() && lhsType.isIntegerBase()) && (instrOrExpr.opCode() == 2 || instrOrExpr.opCode() == 177)) {
            return lhsType.isPointer() ? lhsType : rhsType;
        }
        if (lhsBaseTypeName.equals("complex") || rhsBaseTypeName.equals("complex")) {
            WrapperTypeSpec resultModifiedBaseType;
            if (lhsBaseTypeName.equals("complex") && rhsBaseTypeName.equals("complex") || lhsBaseTypeName.equals("float") || rhsBaseTypeName.equals("float")) {
                if (lhsBaseTypeName.equals("float")) {
                    lhsType = lhsType.realToComplex(new TapList<Object>(null, null), rhsType.baseTypeSpec(false));
                } else if (rhsBaseTypeName.equals("float")) {
                    rhsType = rhsType.realToComplex(new TapList<Object>(null, null), lhsType.baseTypeSpec(false));
                }
                resultModifiedBaseType = this.setUnionModifier(this.getTypeDecl((String)"complex").typeSpec, lhsModifiedBaseType, rhsModifiedBaseType, true);
            } else {
                resultModifiedBaseType = lhsBaseTypeName.equals("integer") ? rhsModifiedBaseType : (rhsBaseTypeName.equals("integer") ? lhsModifiedBaseType : this.getTypeDecl((String)"complex").typeSpec);
            }
            return this.setConformingDimension(resultModifiedBaseType, (WrapperTypeSpec)lhsType, (WrapperTypeSpec)rhsType, instrOrExpr);
        }
        if (lhsBaseTypeName.equals("float") || rhsBaseTypeName.equals("float")) {
            WrapperTypeSpec resultModifiedBaseType = lhsBaseTypeName.equals("float") && rhsBaseTypeName.equals("float") ? this.setUnionModifier(this.getTypeDecl((String)"float").typeSpec, lhsModifiedBaseType, rhsModifiedBaseType, true) : (lhsBaseTypeName.equals("integer") ? rhsModifiedBaseType : (rhsBaseTypeName.equals("integer") ? lhsModifiedBaseType : this.getTypeDecl((String)"float").typeSpec));
            return this.setConformingDimension(resultModifiedBaseType, (WrapperTypeSpec)lhsType, (WrapperTypeSpec)rhsType, instrOrExpr);
        }
        if (TypeSpec.isA(lhsType, 6)) {
            return lhsType;
        }
        if (TypeSpec.isA(rhsType, 6)) {
            return rhsType;
        }
        if (TypeSpec.isA(lhsType, 12)) {
            return rhsType;
        }
        if (TypeSpec.isA(rhsType, 12)) {
            return lhsType;
        }
        if (lhsBaseTypeName.equals("integer") || lhsBaseTypeName.equals("boolean") || rhsBaseTypeName.equals("integer") || rhsBaseTypeName.equals("boolean")) {
            WrapperTypeSpec resultModifiedBaseType = this.setUnionModifier(this.getTypeDecl((String)"integer").typeSpec, lhsModifiedBaseType, rhsModifiedBaseType, true);
            return this.setConformingDimension(resultModifiedBaseType, (WrapperTypeSpec)lhsType, (WrapperTypeSpec)rhsType, instrOrExpr);
        }
        return lhsType;
    }

    private boolean comesFromRootSymbolTable(SymbolDecl symbolDecl) {
        SymbolTable upperST = this;
        SymbolDecl upperSymbolDecl = null;
        upperST = upperST.basisSymbolTable;
        while (upperST != this.getCallGraph().globalRootSymbolTable() && upperST.basisSymbolTable != null && upperSymbolDecl == null) {
            upperSymbolDecl = upperST.getDecl(symbolDecl.symbol, symbolDecl.kind, true);
            if (upperSymbolDecl != null) continue;
            upperST = upperST.basisSymbolTable;
        }
        boolean result = upperST.basisSymbolTable == null || upperST.basisSymbolTable == this.getCallGraph().globalRootSymbolTable();
        return result;
    }

    private WrapperTypeSpec arrayTypeIfElementalCall(Tree upperCallTree, int rank, WrapperTypeSpec typeSpec) {
        Object o;
        WrapperTypeSpec result = typeSpec;
        Tree callTree = ILUtils.getArguments(upperCallTree).down(rank + 1);
        if (callTree.opCode() == 30 && (o = callTree.getAnnotation("arrayReturnTypeSpec")) != null) {
            result = (WrapperTypeSpec)o;
        }
        return result;
    }

    private WrapperTypeSpec realCstTypeSpec(Tree instrOrExpr) {
        WrapperTypeSpec result;
        WrapperTypeSpec elemType = this.getTypeDecl((String)"float").typeSpec;
        String value = instrOrExpr.stringValue();
        int index = value.indexOf(95);
        if (index > 0) {
            Tree modifier;
            String valueString = value.substring(index + 1);
            try {
                Integer.parseInt(value.substring(0, index));
                elemType = this.getTypeDecl((String)"integer").typeSpec;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                int valueInt = Integer.parseInt(valueString);
                modifier = ILUtils.build(101, valueInt);
            }
            catch (NumberFormatException e) {
                valueString = valueString.toLowerCase();
                modifier = ILUtils.build(94, valueString);
            }
            result = new WrapperTypeSpec(new ModifiedTypeSpec(elemType, modifier, this));
        } else if (value.indexOf(100) > 0 || value.indexOf(68) > 0) {
            Tree modifier = ILUtils.build(94, "double");
            result = new WrapperTypeSpec(new ModifiedTypeSpec(elemType, modifier, this));
        } else {
            try {
                Integer.parseInt(value);
                elemType = this.getTypeDecl((String)"integer").typeSpec;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            elemType.wrappedType.setHasUndefinedSize(true);
            result = elemType;
        }
        return result;
    }

    private boolean isCallNotElemental(Tree tree) {
        boolean result;
        boolean bl = result = tree.opCode() == 30;
        if (result) {
            FunctionDecl funcDecl;
            String calledUnitName = ILUtils.baseName(ILUtils.getCalledName(tree));
            TapList<FunctionDecl> funcDecls = this.getFunctionDecl(calledUnitName, null, null, false);
            FunctionDecl functionDecl = funcDecl = funcDecls == null ? null : (FunctionDecl)funcDecls.head;
            if (funcDecl != null) {
                result = !funcDecl.isElemental() || funcDecl.isIntrinsicNotElemental();
            }
        }
        return result;
    }

    private TapList<FunctionDecl> getFunctionDeclInUnit(String varName, WrapperTypeSpec returnType, WrapperTypeSpec[] argumentsTypes, boolean checkArgsTypes, Unit unit) {
        TapList<FunctionDecl> funcDecls = null;
        if (unit != null) {
            SymbolTable inSymTab = unit.privateSymbolTable();
            if (inSymTab != null) {
                funcDecls = inSymTab.getTopFunctionDecl(varName, returnType, argumentsTypes, checkArgsTypes);
            }
            if (funcDecls == null && (inSymTab = unit.protectedSymbolTable()) != null) {
                funcDecls = inSymTab.getTopFunctionDecl(varName, returnType, argumentsTypes, checkArgsTypes);
            }
            if (funcDecls == null && (inSymTab = unit.publicSymbolTable()) != null) {
                funcDecls = inSymTab.getTopFunctionDecl(varName, returnType, argumentsTypes, checkArgsTypes);
                inSymTab = inSymTab.basisSymbolTable;
                while (funcDecls == null && inSymTab != null && inSymTab.usedModule != null) {
                    funcDecls = inSymTab.getTopFunctionDecl(varName, returnType, argumentsTypes, checkArgsTypes);
                    inSymTab = inSymTab.basisSymbolTable;
                }
            }
        }
        return funcDecls;
    }

    private WrapperTypeSpec checkPointerInFortranExpression(WrapperTypeSpec expressionType, Tree expression, int rank) {
        if (this.unit != null && this.unit.isFortran() && TypeSpec.isA(expressionType, 6)) {
            expression.setChild(ILUtils.build(148, expression.cutChild(rank), ILUtils.build(136)), rank);
            expressionType = ((PointerTypeSpec)expressionType.wrappedType).destinationType;
        }
        return expressionType;
    }

    private void refineTripletDimension(Tree tree, ArrayDim dim, boolean resetOffset) {
        dim.lower = ILUtils.isNullOrNone(tree.down(1)) ? Integer.valueOf(1) : this.computeIntConstant(tree.down(1));
        dim.upper = this.computeIntConstant(tree.down(2));
        if (dim.lower == null || dim.upper == null) {
            if (tree.down(2).opCode() != 136) {
                Integer intLength;
                Tree sizeTree = ILUtils.copy(tree.down(2));
                if (!ILUtils.isNullOrNone(tree.down(1))) {
                    sizeTree = ILUtils.addTree(ILUtils.subTree(sizeTree, ILUtils.copy(tree.down(1))), ILUtils.build(101, 1));
                }
                if ((intLength = this.computeIntConstant(sizeTree)) != null) {
                    dim.lower = 1;
                    dim.upper = intLength;
                }
            }
        } else if (resetOffset) {
            dim.upper = dim.upper - dim.lower + 1;
            dim.lower = 1;
        }
    }

    private WrapperTypeSpec setUnionModifier(WrapperTypeSpec resultType, WrapperTypeSpec type1, WrapperTypeSpec type2, boolean precisionUp) {
        int resultMod;
        boolean resultHasUndefinedSize = type1.hasUndefinedSize() && type2.hasUndefinedSize();
        boolean equalTypes = false;
        while (TypeSpec.isA(type1, 2) && TypeSpec.isA(type2, 2)) {
            type1 = type1.wrappedType.elementType();
        }
        while (TypeSpec.isA(type2, 2)) {
            type2 = type2.wrappedType.elementType();
        }
        if (TypeSpec.isA(type1, 5) && type1.hasUndefinedSize() && TypeSpec.isA(type2, 5)) {
            ((ModifiedTypeSpec)type1.wrappedType).getModifierFrom((ModifiedTypeSpec)type2.wrappedType);
            type1.setHasUndefinedSize(type2.hasUndefinedSize());
            equalTypes = true;
        }
        if (TypeSpec.isA(type2, 5) && type2.hasUndefinedSize() && TypeSpec.isA(type1, 5)) {
            ((ModifiedTypeSpec)type2.wrappedType).getModifierFrom((ModifiedTypeSpec)type1.wrappedType);
            type2.setHasUndefinedSize(type1.hasUndefinedSize());
            equalTypes = true;
        }
        int mod1 = -1;
        int mod2 = -1;
        boolean hasKindEqual = false;
        ToObject<Object> toMod = new ToObject<Object>(null);
        TypeSpec.peelSizeModifier(type1, toMod, this);
        if (toMod.obj() != null) {
            mod1 = ((ModifiedTypeSpec)toMod.obj()).sizeModifierValue();
            if (((ModifiedTypeSpec)toMod.obj()).hasKindEqual()) {
                hasKindEqual = true;
            }
        }
        toMod.setObj(null);
        TypeSpec.peelSizeModifier(type2, toMod, this);
        if (toMod.obj() != null) {
            mod2 = ((ModifiedTypeSpec)toMod.obj()).sizeModifierValue();
            if (((ModifiedTypeSpec)toMod.obj()).hasKindEqual()) {
                hasKindEqual = true;
            }
        }
        if ((resultMod = mod1 == -2 && mod2 == -2 ? -2 : (type1.hasUndefinedSize() ? mod2 : (type2.hasUndefinedSize() ? mod1 : (mod1 == -2 ? mod2 : (mod2 == -2 ? mod1 : ((precisionUp ? mod1 > mod2 : mod1 < mod2) ? mod1 : mod2)))))) != -1) {
            Tree modifier;
            if (resultMod == -2) {
                modifier = ILUtils.build(94, "double");
            } else {
                modifier = ILUtils.build(101, resultMod);
                if (hasKindEqual) {
                    modifier = ILUtils.build(132, ILUtils.build(94, "kind"), modifier);
                }
            }
            resultType = new WrapperTypeSpec(new ModifiedTypeSpec(resultType, modifier, this));
        } else if (TypeSpec.isA(type1, 5) && TypeSpec.isA(type2, 5) && equalTypes) {
            resultType = new WrapperTypeSpec(new ModifiedTypeSpec(resultType, (ModifiedTypeSpec)type1.wrappedType));
        } else if (TypeSpec.isA(type1, 5) && TypeSpec.isA(type2, 5) && type1.equalsLiterally(type2)) {
            resultType = type1;
        }
        resultType.setHasUndefinedSize(resultHasUndefinedSize);
        return resultType;
    }

    protected WrapperTypeSpec setConformingDimension(WrapperTypeSpec resultType, WrapperTypeSpec type1, WrapperTypeSpec type2, Tree expression) {
        WrapperTypeSpec conformingTypeSpec = resultType.conformingTypeSpec(type1, type2, this);
        if (conformingTypeSpec != null) {
            return conformingTypeSpec;
        }
        TapEnv.fileWarning(15, expression, "(TC25) Dimensions mismatch in array expression, " + type1.showType() + " combined with " + type2.showType());
        return resultType;
    }

    protected SymbolDecl symbolDeclOf(Tree instrOrExpr) {
        if (instrOrExpr == null) {
            return null;
        }
        switch (instrOrExpr.opCode()) {
            case 94: {
                String symbol = ILUtils.getIdentString(instrOrExpr);
                VariableDecl symbolDecl = this.getVariableDecl(symbol);
                if (symbolDecl == null) {
                    symbolDecl = this.getConstantDecl(symbol);
                }
                if (symbolDecl == null) {
                    TapList<FunctionDecl> functionDecls = this.getFunctionDecl(symbol, null, null, false);
                    symbolDecl = functionDecls == null ? null : (SymbolDecl)functionDecls.head;
                }
                return symbolDecl;
            }
            case 8: {
                return this.symbolDeclOf(instrOrExpr.down(1));
            }
            case 73: {
                WrapperTypeSpec compositeType = this.typeOf(instrOrExpr.down(1));
                FieldDecl symbolDecl = null;
                if (compositeType != null) {
                    TapPair<WrapperTypeSpec, ArrayDim[]> afterPeel = TypeSpec.peelArrayDimsAroundComposite(compositeType);
                    compositeType = (WrapperTypeSpec)afterPeel.first;
                    if (TypeSpec.isA(compositeType, 21)) {
                        symbolDecl = ((CompositeTypeSpec)compositeType.wrappedType).namedFieldDecl(ILUtils.getIdentString(instrOrExpr.down(2)));
                    }
                }
                return symbolDecl;
            }
        }
        return null;
    }

    public WrapperTypeSpec typeOf(Tree instrOrExpr) {
        if (instrOrExpr == null) {
            return null;
        }
        switch (instrOrExpr.opCode()) {
            case 94: {
                WrapperTypeSpec resultType = null;
                VariableDecl variableDecl = this.getVariableDecl(ILUtils.getIdentString(instrOrExpr));
                if (variableDecl == null) {
                    variableDecl = this.getConstantDecl(ILUtils.baseName(instrOrExpr));
                }
                if (variableDecl == null) {
                    NewSymbolHolder newSymbHolder = NewSymbolHolder.getNewSymbolHolder(instrOrExpr);
                    if (newSymbHolder != null) {
                        variableDecl = newSymbHolder.newVariableDecl();
                        if (variableDecl == null) {
                            FunctionDecl funcDecl;
                            TapList<FunctionDecl> funcDecls = this.getFunctionDecl(ILUtils.baseName(instrOrExpr), null, null, false);
                            FunctionDecl functionDecl = funcDecl = funcDecls == null ? null : (FunctionDecl)funcDecls.head;
                            if (funcDecl != null && funcDecl.unit() != null) {
                                resultType = new WrapperTypeSpec(funcDecl.functionTypeSpec());
                            }
                        } else {
                            resultType = variableDecl.type();
                        }
                    } else {
                        FunctionDecl funcDecl;
                        TapList<FunctionDecl> funcDecls = this.getFunctionDecl(ILUtils.baseName(instrOrExpr), null, null, false);
                        FunctionDecl functionDecl = funcDecl = funcDecls == null ? null : (FunctionDecl)funcDecls.head;
                        if (funcDecl != null && funcDecl.unit() != null) {
                            resultType = new WrapperTypeSpec(funcDecl.functionTypeSpec());
                        }
                    }
                } else {
                    resultType = variableDecl.type();
                }
                return resultType;
            }
            case 58: {
                instrOrExpr = ILUtils.build(11, ILUtils.copy(instrOrExpr.down(1)), ILUtils.copy(instrOrExpr.down(2)), ILUtils.build(136));
            }
            case 11: {
                Integer lengthI;
                ArrayDim[] dimensions = new ArrayDim[1];
                Tree lengthITree = null;
                Integer lowerI = ILUtils.isNullOrNone(instrOrExpr.down(1)) ? null : this.computeIntConstant(instrOrExpr.down(1));
                Integer upperI = ILUtils.isNullOrNone(instrOrExpr.down(2)) ? null : this.computeIntConstant(instrOrExpr.down(2));
                Integer strideI = ILUtils.isNullOrNone(instrOrExpr.down(3)) ? Integer.valueOf(1) : this.computeIntConstant(instrOrExpr.down(3));
                if (lowerI != null && upperI != null && strideI != null) {
                    int length;
                    int lower = lowerI;
                    int upper = upperI;
                    int stride = strideI;
                    if (lower > upper) {
                        lower = upper;
                        upper = lowerI;
                    }
                    if (stride < 0) {
                        stride = -stride;
                    }
                    lengthITree = (length = (upper - lower) / stride + 1) == upperI ? ILUtils.copy(instrOrExpr.down(2)) : (length == lowerI ? ILUtils.copy(instrOrExpr.down(1)) : ILUtils.build(101, length));
                    lengthI = length;
                } else {
                    lengthI = null;
                }
                instrOrExpr = lengthI != null ? ILUtils.build(58, ILUtils.build(101, 1), lengthITree) : ILUtils.build(58, ILUtils.build(101, 1), ILUtils.buildSizeTree(instrOrExpr.down(1), instrOrExpr.down(2), instrOrExpr.down(3)));
                dimensions[0] = new ArrayDim(instrOrExpr, 1, lengthI, null, -1, 0, 0);
                return new WrapperTypeSpec(new ArrayTypeSpec(this.getTypeDecl((String)"integer").typeSpec, dimensions));
            }
            case 8: {
                WrapperTypeSpec resultType;
                WrapperTypeSpec arrayType = this.typeOf(instrOrExpr.down(1));
                if (TypeSpec.isA(arrayType, 2)) {
                    ArrayTypeSpec arrayTypeSpec = (ArrayTypeSpec)arrayType.wrappedType;
                    TapList<ArrayDim> remainingDimensions = null;
                    Tree[] indexes = instrOrExpr.down(2).children();
                    int indexlength = arrayTypeSpec.dimensions().length;
                    if (indexlength > indexes.length) {
                        indexlength = indexes.length;
                    }
                    for (int i = indexlength - 1; i >= 0; --i) {
                        WrapperTypeSpec indexType;
                        ArrayDim arrayDimType = arrayTypeSpec.dimensions()[i];
                        Tree index = indexes[i];
                        if (index.opCode() == 58 || index.opCode() == 11 && ILUtils.isNullOrNone(index.down(1)) && ILUtils.isNullOrNone(index.down(2)) && ILUtils.isNullOrNone(index.down(3))) {
                            remainingDimensions = new TapList<ArrayDim>(arrayDimType, remainingDimensions);
                            continue;
                        }
                        if (index.opCode() == 11) {
                            Tree cpIndex = ILUtils.copy(index);
                            if (ILUtils.isNullOrNone(cpIndex.down(1))) {
                                cpIndex.setChild(ILUtils.copy(arrayDimType.lowerTree()), 1);
                            }
                            if (ILUtils.isNullOrNone(cpIndex.down(2))) {
                                cpIndex.setChild(ILUtils.copy(arrayDimType.upperTree()), 2);
                            }
                            indexType = this.typeOf(cpIndex);
                        } else {
                            indexType = this.typeOf(index);
                        }
                        if (!TypeSpec.isA(indexType, 2)) continue;
                        ArrayDim newArrayDimType = ((ArrayTypeSpec)indexType.wrappedType).dimensions()[0];
                        remainingDimensions = new TapList<ArrayDim>(newArrayDimType, remainingDimensions);
                    }
                    if (remainingDimensions != null) {
                        ArrayDim[] newDimensions = new ArrayDim[TapList.length(remainingDimensions)];
                        for (int i = 0; i < newDimensions.length; ++i) {
                            newDimensions[i] = (ArrayDim)remainingDimensions.head;
                            remainingDimensions = remainingDimensions.tail;
                        }
                        resultType = new WrapperTypeSpec(new ArrayTypeSpec(arrayTypeSpec.elementType(), newDimensions));
                    } else {
                        resultType = arrayTypeSpec.elementType();
                    }
                } else {
                    resultType = arrayType;
                }
                return resultType;
            }
            case 73: {
                WrapperTypeSpec compositeType = this.typeOf(instrOrExpr.down(1));
                WrapperTypeSpec fieldType = null;
                if (compositeType != null) {
                    TapPair<WrapperTypeSpec, ArrayDim[]> afterPeel = TypeSpec.peelArrayDimsAroundComposite(compositeType);
                    compositeType = (WrapperTypeSpec)afterPeel.first;
                    if (TypeSpec.isA(compositeType, 21)) {
                        fieldType = ((CompositeTypeSpec)compositeType.wrappedType).namedFieldType(ILUtils.getIdentString(instrOrExpr.down(2)));
                    }
                    if (afterPeel.second != null) {
                        fieldType = new WrapperTypeSpec(new ArrayTypeSpec(fieldType, (ArrayDim[])afterPeel.second));
                    }
                }
                return fieldType;
            }
            case 3: {
                return new WrapperTypeSpec(new PointerTypeSpec(this.typeOf(instrOrExpr.down(1)), null));
            }
            case 10: {
                WrapperTypeSpec typeInside = this.typeOf(instrOrExpr.down(1));
                if ((this.unit == null || this.unit.isC()) && typeInside != null && TypeSpec.isA(typeInside.wrappedType, 6)) {
                    typeInside = ((PointerTypeSpec)typeInside.wrappedType).destinationType;
                    Tree[] dimDecls = instrOrExpr.down(2).children();
                    ArrayDim[] dims = new ArrayDim[dimDecls.length];
                    for (int i = dimDecls.length - 1; i >= 0; --i) {
                        dims[i] = new ArrayDim(dimDecls[i], null, null, null, -1, 0, 0);
                    }
                    typeInside = new WrapperTypeSpec(new ArrayTypeSpec(typeInside, dims));
                }
                return typeInside;
            }
            case 13: 
            case 42: 
            case 88: 
            case 114: 
            case 122: 
            case 150: 
            case 164: {
                return this.typeOf(instrOrExpr.down(1));
            }
            case 126: 
            case 132: 
            case 189: {
                return this.typeOf(instrOrExpr.down(2));
            }
            case 148: {
                WrapperTypeSpec ptrType = this.typeOf(instrOrExpr.down(1));
                ArrayDim[] dims = null;
                if (TypeSpec.isA(ptrType, 2) && TypeSpec.isA(ptrType.wrappedType.elementType(), 6)) {
                    dims = ((ArrayTypeSpec)ptrType.wrappedType).dimensions();
                    ptrType = ptrType.wrappedType.elementType();
                }
                WrapperTypeSpec result = TypeSpec.isA(ptrType, 6) ? ((PointerTypeSpec)ptrType.wrappedType).destinationType : ptrType;
                WrapperTypeSpec indexType = this.typeOf(instrOrExpr.down(2));
                if (TypeSpec.isA(indexType, 2)) {
                    result = new WrapperTypeSpec(new ArrayTypeSpec(result, ((ArrayTypeSpec)indexType.wrappedType).dimensions()));
                } else if (dims != null) {
                    result = new WrapperTypeSpec(new ArrayTypeSpec(result, dims));
                }
                return result;
            }
            case 2: 
            case 61: 
            case 131: 
            case 152: 
            case 177: {
                WrapperTypeSpec type1 = this.typeOf(instrOrExpr.down(1));
                WrapperTypeSpec type2 = this.typeOf(instrOrExpr.down(2));
                WrapperTypeSpec resultType = type1 == null || !type1.checkNumeric() ? type2 : (type2 == null || !type2.checkNumeric() ? type1 : (WrapperTypeSpec)this.combineNumeric(type1, type2, instrOrExpr));
                return resultType;
            }
            case 19: 
            case 101: 
            case 171: {
                return this.getTypeDecl((String)"integer").typeSpec;
            }
            case 155: {
                return this.realCstTypeSpec(instrOrExpr);
            }
            case 175: {
                int length = instrOrExpr.stringValue().length();
                WrapperTypeSpec charType = this.getTypeDecl((String)"character").typeSpec;
                if (length == 1) {
                    return charType;
                }
                if (this.unit == null || this.unit.isC()) {
                    return new WrapperTypeSpec(new PointerTypeSpec(charType, new ArrayDim(null, 0, null, null, -1, 0, 0)));
                }
                return new WrapperTypeSpec(new ArrayTypeSpec(charType, new ArrayDim[]{new ArrayDim(null, 1, length, null, -1, 0, 0)}));
            }
            case 176: {
                Tree[] listOfString = instrOrExpr.children();
                int length = 0;
                for (Tree tree : listOfString) {
                    length = tree.stringValue().length();
                }
                if (length == 1) {
                    return this.getTypeDecl((String)"character").typeSpec;
                }
                ArrayDim[] dims = new ArrayDim[]{this.unit == null || this.unit.isC() ? new ArrayDim(null, 1, null, null, -1, 0, 0) : new ArrayDim(null, 1, length, null, -1, 0, 0)};
                return new WrapperTypeSpec(new ArrayTypeSpec(this.getTypeDecl((String)"character").typeSpec, dims));
            }
            case 83: 
            case 116: {
                return this.getTypeDecl((String)"character").typeSpec;
            }
            case 27: {
                return this.getTypeDecl((String)"boolean").typeSpec;
            }
            case 5: 
            case 17: 
            case 21: 
            case 23: 
            case 67: 
            case 90: 
            case 93: 
            case 113: 
            case 120: 
            case 135: 
            case 141: 
            case 202: {
                return this.getTypeDecl((String)"boolean").typeSpec.conformingTypeSpec(this.typeOf(instrOrExpr.down(1)), this.typeOf(instrOrExpr.down(2)), this);
            }
            case 137: {
                return this.getTypeDecl((String)"boolean").typeSpec.conformingTypeSpec(this.typeOf(instrOrExpr.down(1)), null, this);
            }
            case 30: {
                Unit functionUnit;
                FunctionTypeSpec functionTypeSpec = null;
                WrapperTypeSpec returnType = null;
                String functionName = ILUtils.getCallFunctionNameString(instrOrExpr);
                Tree[] actualArgs = ILUtils.getArguments(instrOrExpr).children();
                if (this.unit != null && this.unit.isFortran9x() && "sum".equals(functionName)) {
                    return this.sumResultType(this.typeOf(actualArgs[0]), ILUtils.getOptionalDim(actualArgs, this));
                }
                if (this.unit != null && this.unit.isFortran9x() && "spread".equals(functionName)) {
                    Tree newDim = ILUtils.build(58, ILUtils.build(101, 1), ILUtils.copy(actualArgs[2]));
                    return this.spreadResultType(this.typeOf(actualArgs[0]), actualArgs[1], newDim);
                }
                Object f = instrOrExpr.getAnnotation("functionTypeSpec");
                if (f != null) {
                    functionTypeSpec = (FunctionTypeSpec)f;
                } else {
                    f = instrOrExpr.getAnnotation("callArrow");
                    if (f != null) {
                        CallArrow callArrow = (CallArrow)f;
                        functionUnit = callArrow.destination;
                        if (this.unit.callGraph() == functionUnit.callGraph()) {
                            functionTypeSpec = functionUnit.functionTypeSpec();
                        }
                    }
                }
                if (functionTypeSpec == null) {
                    functionName = ILUtils.getCallFunctionNameString(instrOrExpr);
                    WrapperTypeSpec[] types = this.typesOf(ILUtils.getArguments(instrOrExpr));
                    FunctionDecl functionDecl = this.getTypedFunctionDecl(functionName, null, types, false, instrOrExpr);
                    functionUnit = null;
                    if (functionDecl != null) {
                        functionUnit = functionDecl.unit();
                    }
                    if (functionUnit != null) {
                        functionTypeSpec = functionUnit.functionTypeSpec();
                        Tree kindTree = functionUnit.getElementalIntrinsicTypeConverter(ILUtils.getArguments(instrOrExpr).children());
                        if (kindTree != null) {
                            returnType = new WrapperTypeSpec(new ModifiedTypeSpec(returnType, kindTree, this));
                        }
                    }
                    if (functionName.equals("sum") && TypeSpec.isA(types[0], 2)) {
                        return types[0].wrappedType.elementType();
                    }
                }
                if (functionTypeSpec != null) {
                    returnType = functionTypeSpec.returnType;
                }
                if (instrOrExpr.getAnnotation("arrayReturnTypeSpec") != null) {
                    returnType = (WrapperTypeSpec)instrOrExpr.getAnnotation("arrayReturnTypeSpec");
                }
                return returnType;
            }
            case 46: {
                TypeDecl typeDecl = this.getTypeDecl(ILUtils.baseTree(instrOrExpr.down(1)).stringValue());
                if (typeDecl != null) {
                    return typeDecl.typeSpec;
                }
                return null;
            }
            case 1: 
            case 12: 
            case 14: 
            case 28: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 48: 
            case 50: 
            case 51: 
            case 63: 
            case 68: 
            case 70: 
            case 72: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 92: 
            case 96: 
            case 99: 
            case 102: 
            case 104: 
            case 106: 
            case 107: 
            case 119: 
            case 121: 
            case 127: 
            case 133: 
            case 136: 
            case 142: 
            case 143: 
            case 163: 
            case 166: 
            case 170: 
            case 172: 
            case 174: 
            case 179: 
            case 184: 
            case 187: 
            case 191: 
            case 192: 
            case 194: 
            case 197: 
            case 199: 
            case 200: 
            case 201: {
                return null;
            }
            case 9: {
                WrapperTypeSpec resultTypeSpec = null;
                Tree[] elements = instrOrExpr.children();
                int totalLength = 0;
                for (int i = elements.length - 1; i >= 0; --i) {
                    WrapperTypeSpec componentTypeSpec = this.typeOf(elements[i]);
                    if (TypeSpec.isA(componentTypeSpec, 2) && this.unit != null && !this.unit.isC()) {
                        if (totalLength >= 0) {
                            int elementLength = ArrayTypeSpec.totalArrayLength(componentTypeSpec.wrappedType.getAllDimensions());
                            totalLength = elementLength == -1 ? -1 : totalLength + elementLength;
                        }
                        componentTypeSpec = componentTypeSpec.wrappedType.elementType();
                    } else if (totalLength >= 0) {
                        ++totalLength;
                    }
                    if (resultTypeSpec != null) continue;
                    resultTypeSpec = componentTypeSpec;
                }
                resultTypeSpec = this.unit == null || this.unit.isC() ? new WrapperTypeSpec(new PointerTypeSpec(resultTypeSpec, new ArrayDim(null, 0, totalLength <= 0 ? null : Integer.valueOf(totalLength - 1), null, -1, 0, 0))) : new WrapperTypeSpec(new ArrayTypeSpec(resultTypeSpec, new ArrayDim[]{new ArrayDim(null, 1, totalLength <= 0 ? null : Integer.valueOf(totalLength), null, -1, 0, 0)}));
                return resultTypeSpec;
            }
            case 41: {
                return this.getTypeDecl((String)"complex").typeSpec;
            }
            case 97: {
                return this.typeOf(instrOrExpr.down(2));
            }
            case 4: {
                return new WrapperTypeSpec(new PointerTypeSpec(new WrapperTypeSpec(null), null));
            }
            case 138: {
                return null;
            }
            case 109: {
                return new WrapperTypeSpec(new LabelTypeSpec());
            }
            case 31: {
                WrapperTypeSpec castTypeCheck = null;
                if (instrOrExpr.down(1).opCode() == 94) {
                    String castTypeName = instrOrExpr.down(1).stringValue();
                    TypeDecl castTypeDecl = this.getTypeDecl(castTypeName);
                    if (castTypeDecl != null) {
                        castTypeCheck = castTypeDecl.typeSpec;
                    }
                } else if (instrOrExpr.down(1).opCode() == 199) {
                    TypeDecl castTypeDecl = this.getTypeDecl("void");
                    if (castTypeDecl != null) {
                        castTypeCheck = castTypeDecl.typeSpec;
                    }
                } else {
                    castTypeCheck = ILUtils.hasATypeOperator(instrOrExpr.down(1)) ? TypeSpec.build(instrOrExpr.down(1), this, new Instruction(instrOrExpr), new TapList<Object>(null, null), new TapList<Object>(null, null), new TapList<Object>(null, null), new ToBool(false), null) : this.typeOf(instrOrExpr.down(2));
                }
                return castTypeCheck;
            }
            case 124: {
                return this.typeOf(instrOrExpr.down(1));
            }
            case 151: {
                return TypeSpec.build(instrOrExpr, this, null, new TapList<Object>(null, null), new TapList<Object>(null, null), new TapList<Object>(null, null), new ToBool(false), null);
            }
            case 108: {
                WrapperTypeSpec topTypeSpec = this.typeOf(instrOrExpr.down(1));
                Tree doTree = instrOrExpr.down(2);
                Tree sizeTree = ILUtils.buildSizeTree(doTree.down(2), doTree.down(3), doTree.down(4));
                ArrayDim[] newDimensions = new ArrayDim[]{new ArrayDim(ILUtils.build(58), 1, this.computeIntConstant(sizeTree), null, -1, 0, 0)};
                return new WrapperTypeSpec(new ArrayTypeSpec(topTypeSpec, newDimensions));
            }
            case 35: 
            case 45: 
            case 55: 
            case 87: {
                return null;
            }
        }
        TapEnv.toolWarning(-1, "(Typing expression) Unexpected operator: " + instrOrExpr.opName() + " in " + (instrOrExpr.parent() == null ? "()" : ILUtils.toString(instrOrExpr.parent())) + " i.e. " + instrOrExpr.parent());
        return null;
    }

    public WrapperTypeSpec[] typesOf(Tree instrOrExpr) {
        switch (instrOrExpr.opCode()) {
            case 70: {
                int length = instrOrExpr.length();
                WrapperTypeSpec[] typeSpec = new WrapperTypeSpec[length];
                for (int i = 1; i <= length; ++i) {
                    typeSpec[i - 1] = this.typeOf(instrOrExpr.down(i));
                }
                return typeSpec;
            }
            case 136: {
                return new WrapperTypeSpec[0];
            }
        }
        TapEnv.toolWarning(-1, "(Typing expressions) Unexpected operator: " + instrOrExpr.opName());
        return null;
    }

    protected int refOffset(Tree ref) {
        TapIntList toOffset = new TapIntList(0, null);
        this.refTypeAndOffsetRec(ref, toOffset);
        return toOffset.head;
    }

    private WrapperTypeSpec refTypeAndOffsetRec(Tree ref, TapIntList toOffset) {
        switch (ref.opCode()) {
            case 94: {
                toOffset.head = 0;
                return this.getVariableDecl(ILUtils.getIdentString(ref)).type();
            }
            case 8: {
                ArrayTypeSpec arrayType = (ArrayTypeSpec)this.refTypeAndOffsetRec((Tree)ref.down((int)1), (TapIntList)toOffset).wrappedType;
                ArrayDim[] dims = arrayType.dimensions();
                int elemRank = 0;
                Tree[] indexTrees = ref.down(2).children();
                for (int i = 0; i < indexTrees.length; ++i) {
                    Integer constValueI;
                    if (i > 0) {
                        if (dims[i] != null) {
                            elemRank *= dims[i].size();
                        } else {
                            TapEnv.toolWarning(-1, "null dimension in " + arrayType);
                        }
                    }
                    if ((constValueI = this.computeIntConstant(indexTrees[i])) == null) {
                        TapEnv.fileWarning(15, indexTrees[i], "(DD14) Undefined constant value " + ILUtils.toString(indexTrees[i]));
                        continue;
                    }
                    elemRank += constValueI - dims[i].lower;
                }
                toOffset.head += elemRank * arrayType.elementType().size();
                return arrayType.elementType();
            }
            case 178: {
                WrapperTypeSpec subType = this.refTypeAndOffsetRec(ref.down(1), toOffset);
                if (ref.down(2).opCode() != 136) {
                    int strOffset = this.computeIntConstant(ref.down(2)) - 1;
                    toOffset.head += strOffset;
                }
                return subType;
            }
            case 73: {
                CompositeTypeSpec recordType = (CompositeTypeSpec)this.refTypeAndOffsetRec((Tree)ref.down((int)1), (TapIntList)toOffset).wrappedType;
                String fieldName = ILUtils.getIdentString(ref.down(2));
                toOffset.head += recordType.namedFieldOffset(fieldName);
                return recordType.namedFieldType(fieldName);
            }
        }
        TapEnv.toolWarning(-1, "(Type and offset of VariableRef) Unexpected operator: " + ref.opName());
        return null;
    }

    public TapIntList listOfZonesOfValue(Tree refExpr, ToBool total, Instruction instruction) {
        return ZoneInfo.listAllZones(this.treeOfZonesOfValue(refExpr, total, instruction, null), true);
    }

    public TapList<?> treeOfZonesOfValue(Tree instrOrExpr, ToBool total, Instruction instruction, BoolMatrix pointerInfo) {
        if (instrOrExpr == null) {
            return null;
        }
        switch (instrOrExpr.opCode()) {
            case 94: {
                if (total != null) {
                    total.set(true);
                }
                if (NewSymbolHolder.isANewSymbolRef(instrOrExpr)) {
                    int tmpZoneNum = NewSymbolHolder.getNewSymbolHolder((Tree)instrOrExpr).zone;
                    return new TapList<TapIntList>(new TapIntList(tmpZoneNum, null), null);
                }
                VariableDecl variableDecl = this.getVariableDecl(ILUtils.getIdentString(instrOrExpr));
                return variableDecl == null ? null : variableDecl.zones();
            }
            case 10: {
                TapList<Object> result = this.treeOfZonesOfValue(instrOrExpr.down(1), total, instruction, pointerInfo);
                WrapperTypeSpec typeInside = this.typeOf(instrOrExpr.down(1));
                if (this.unit != null && this.language == 4 && typeInside != null && TypeSpec.isA(typeInside.wrappedType, 6)) {
                    result = TapList.copyTree(result);
                    DataFlowAnalyzer.includePointedElementsInTree(result, null, null, false, this, instruction, null, false, true);
                    result = new TapList<TapIntList>(ZoneInfo.listAllZones(result, true), null);
                }
                if (total != null) {
                    total.set(true);
                }
                return result;
            }
            case 8: {
                TapList<?> result = this.treeOfZonesOfValue(instrOrExpr.down(1), total, instruction, pointerInfo);
                if (total != null) {
                    WrapperTypeSpec typeSpec = this.typeOf(instrOrExpr.down(1));
                    boolean tot = total.get();
                    if (TypeSpec.isA(typeSpec, 2) && tot) {
                        Tree[] sons;
                        ArrayDim[] dims = ((ArrayTypeSpec)typeSpec.wrappedType).dimensions();
                        tot &= dims.length == (sons = instrOrExpr.down(2).children()).length;
                        for (int i = 0; i < sons.length && tot; tot &= dims[i].fullArrayTriplet(sons[i]), ++i) {
                        }
                    }
                    total.set(tot);
                }
                return result;
            }
            case 73: {
                TapList<?> recordZones = this.treeOfZonesOfValue(instrOrExpr.down(1), total, instruction, pointerInfo);
                int fieldRank = ILUtils.getFieldRank(instrOrExpr.down(2));
                if (fieldRank == -1) {
                    return recordZones;
                }
                if (recordZones != null && TapList.nth(recordZones, fieldRank) instanceof TapList) {
                    return (TapList)TapList.nth(recordZones, fieldRank);
                }
                return recordZones;
            }
            case 4: {
                return (TapList)instrOrExpr.getAnnotation("allocatedZones");
            }
            case 13: 
            case 51: 
            case 108: {
                return this.treeOfZonesOfValue(instrOrExpr.down(1), total, instruction, pointerInfo);
            }
            case 70: {
                TapList result = null;
                Tree[] sons = instrOrExpr.children();
                for (int i = sons.length - 1; i >= 0; --i) {
                    result = new TapList(this.treeOfZonesOfValue(sons[i], total, instruction, pointerInfo), result);
                }
                return result;
            }
            case 3: {
                return new TapList<Object>(null, this.treeOfZonesOfValue(instrOrExpr.down(1), total, instruction, pointerInfo));
            }
            case 148: {
                TapList<?> treeOfZones = this.treeOfZonesOfValue(instrOrExpr.down(1), total, instruction, pointerInfo);
                if (treeOfZones == null) {
                    return null;
                }
                TapIntList pointerZones = ZoneInfo.listAllZones(new TapList(treeOfZones.head, null), true);
                TapList res = treeOfZones.tail != null ? treeOfZones.tail : this.getPointerDestinationZonesTreeHere(pointerZones, instruction, null, pointerInfo, this.typeOf(instrOrExpr), null, true);
                if (total != null) {
                    ZoneInfo initialDest;
                    if (pointerZones != null && (pointerZones.tail != null || !this.isScalarPointerZone(pointerZones.head) || this.isArrayPointerUse(instrOrExpr) || this.isArrayPointer(pointerZones.head))) {
                        total.set(false);
                    }
                    if (!TapList.allSingletonLeaves(res)) {
                        total.set(false);
                    }
                    if (pointerZones != null && (initialDest = DataFlowAnalyzer.extendedDeclaredToZoneInfo(pointerZones.head, this, null)) != null && !this.isSameShape(initialDest.targetZonesTree, res)) {
                        total.set(false);
                    }
                }
                return res;
            }
            case 2: 
            case 177: {
                if (TypeSpec.isA(this.typeOf(instrOrExpr.down(1)), 6)) {
                    return this.treeOfZonesOfValue(instrOrExpr.down(1), total, instruction, pointerInfo);
                }
                if (TypeSpec.isA(this.typeOf(instrOrExpr.down(2)), 6)) {
                    return this.treeOfZonesOfValue(instrOrExpr.down(2), total, instruction, pointerInfo);
                }
                return null;
            }
            case 31: 
            case 132: {
                return this.treeOfZonesOfValue(instrOrExpr.down(2), total, instruction, pointerInfo);
            }
        }
        return null;
    }

    public TapList includePointedElementsInZonesTree(TapList<?> zonesTree, Instruction instruction, BoolMatrix pointerInfo, boolean upstream) {
        return this.ipeiztRec(zonesTree, null, instruction, pointerInfo, upstream);
    }

    private TapList ipeiztRec(TapList<?> zonesTree, TapIntList dejaVuZones, Instruction instruction, BoolMatrix pointerInfo, boolean upstream) {
        if (zonesTree == null) {
            return null;
        }
        if (zonesTree.head instanceof TapList) {
            TapList<Object> hdSubTrees;
            TapList<Object> tlSubTrees = hdSubTrees = new TapList<Object>(null, null);
            while (zonesTree != null) {
                tlSubTrees = tlSubTrees.placdl(this.ipeiztRec((TapList)zonesTree.head, dejaVuZones, instruction, pointerInfo, upstream));
                zonesTree = zonesTree.tail;
            }
            return hdSubTrees.tail;
        }
        TapList result = new TapList(zonesTree.head, null);
        if (zonesTree.tail != null) {
            result.tail = this.ipeiztRec(zonesTree.tail, dejaVuZones, instruction, pointerInfo, upstream);
        } else if (!TapIntList.contains(dejaVuZones, (TapIntList)zonesTree.head)) {
            TapIntList pointerZoneRanks = (TapIntList)zonesTree.head;
            ZoneInfo pzi = null;
            if (pointerZoneRanks != null) {
                pzi = DataFlowAnalyzer.extendedDeclaredToZoneInfo(pointerZoneRanks.head, this, null);
            }
            if (pzi != null && TypeSpec.isA(pzi.type, 6)) {
                WrapperTypeSpec type = ((PointerTypeSpec)pzi.type.wrappedType).destinationType;
                result.tail = this.getPointerDestinationZonesTreeHere((TapIntList)zonesTree.head, instruction, instruction.block, pointerInfo, type, null, upstream);
                result.tail = this.ipeiztRec(result.tail, TapIntList.quickUnion(dejaVuZones, (TapIntList)zonesTree.head), instruction, pointerInfo, upstream);
            }
        }
        return result;
    }

    public TapList zonesOfDestination(TapList<?> treeOfZones, WrapperTypeSpec pointerType, Instruction instruction, BoolMatrix pointerInfo) {
        if (treeOfZones == null) {
            return null;
        }
        if (treeOfZones.tail != null) {
            return treeOfZones.tail;
        }
        TapIntList pointerZones = ZoneInfo.listAllZones(treeOfZones, true);
        WrapperTypeSpec destType = TypeSpec.isA(pointerType, 6) ? ((PointerTypeSpec)pointerType.wrappedType).destinationType : null;
        return this.getPointerDestinationZonesTreeHere(pointerZones, instruction, null, pointerInfo, destType, null, true);
    }

    public TapList getPointerDestinationZonesTreeHere(TapIntList pointerZones, Instruction instruction, Block block, BoolMatrix pointerInfo, WrapperTypeSpec type, Unit calledUnit, boolean upstream) {
        if (instruction != null) {
            block = instruction.block;
        }
        Object destZonesTree = null;
        if (pointerInfo == null && (block == null || block.pointerInfosIn == null)) {
            while (pointerZones != null) {
                ZoneInfo pointerZone;
                if (pointerZones.head != 0 && (pointerZone = DataFlowAnalyzer.extendedDeclaredToZoneInfo(pointerZones.head, this, calledUnit)) != null && pointerZone.targetZonesTree != null) {
                    destZonesTree = destZonesTree == null ? TapList.copyTree(pointerZone.targetZonesTree) : TapList.cumulWithOper(destZonesTree, pointerZone.targetZonesTree, 91);
                }
                pointerZones = pointerZones.tail;
            }
            TapList<SymbolDecl> targetDecls = this.getAllTargetDecls(type);
            while (targetDecls != null) {
                SymbolDecl targetDecl = (SymbolDecl)targetDecls.head;
                if (targetDecl.isA(1)) {
                    destZonesTree = TapList.cumulWithOper(destZonesTree, targetDecl.zones(), 91);
                } else if (targetDecl.isA(3) && targetDecl.zones() != null) {
                    destZonesTree = TapList.cumulWithOper(destZonesTree, targetDecl.zones(), 91);
                }
                targetDecls = targetDecls.tail;
            }
        } else {
            boolean hasIOpointer;
            BoolVector cumulPointedZonesVector = null;
            int[] rowMap = DataFlowAnalyzer.makeMap3(this.unit == null ? 0 : this.unit.sideEffectZonesNb(3), 0, this.declaredZonesNb(3));
            int[] colMap = DataFlowAnalyzer.makeMap3(this.unit == null ? 0 : this.unit.sideEffectZonesNb(0), 2, this.declaredZonesNb(0));
            boolean bl = hasIOpointer = pointerZones != null && pointerZones.head == 0;
            while (pointerZones != null) {
                int pointerRowIndex = DataFlowAnalyzer.extendedDeclaredToVectorIndex(pointerZones.head, 3, rowMap, this, calledUnit);
                if (pointerRowIndex >= 0) {
                    BoolVector pointedZonesVector = this.getPointerDestinationVector(pointerRowIndex, instruction, block, pointerInfo, upstream);
                    if (pointedZonesVector == null) {
                        pointedZonesVector = PointerAnalyzer.buildExplicitIdentityDestsRow(pointerRowIndex, this);
                    }
                    if (cumulPointedZonesVector == null) {
                        cumulPointedZonesVector = pointedZonesVector.copy();
                    } else {
                        cumulPointedZonesVector.cumulOr(pointedZonesVector);
                    }
                }
                pointerZones = pointerZones.tail;
            }
            destZonesTree = cumulPointedZonesVector != null ? this.treeOfPointedZones(cumulPointedZonesVector, colMap, type) : (hasIOpointer ? null : new TapList<TapIntList>(new TapIntList(-2, null), null));
        }
        return destZonesTree;
    }

    public BoolVector getPointerDestinationVector(int pointerRowIndex, Instruction instruction, Block block, BoolMatrix pointerInfo, boolean upstream) {
        BoolVector result = null;
        boolean found = false;
        if (pointerInfo == null && instruction != null) {
            TapList instructionsUp = null;
            TapList<Instruction> allInstructions = block.instructions;
            while (allInstructions != null && allInstructions.head != instruction) {
                instructionsUp = new TapList(allInstructions.head, instructionsUp);
                allInstructions = allInstructions.tail;
            }
            if (!upstream && allInstructions != null) {
                instructionsUp = new TapList(allInstructions.head, instructionsUp);
            }
            while (!found && instructionsUp != null) {
                TapPair cell = TapList.assqOne(pointerRowIndex, ((Instruction)instructionsUp.head).pointerDestsChanges);
                if (cell != null) {
                    result = (BoolVector)cell.second;
                    found = true;
                }
                instructionsUp = instructionsUp.tail;
            }
        }
        if (!found) {
            if (pointerInfo == null) {
                pointerInfo = block.pointerInfosIn;
            }
            if (pointerInfo != null) {
                found = true;
                result = pointerInfo.getRow(pointerRowIndex);
            }
        }
        if (found && result == null) {
            result = PointerAnalyzer.buildExplicitIdentityDestsRow(pointerRowIndex, this);
        }
        return result;
    }

    private boolean isScalarPointerZone(int zone) {
        ZoneInfo zi = this.declaredZoneInfo(zone, 0);
        return zi != null && zi.accessIndexes == null;
    }

    private boolean isArrayPointerUse(Tree pointerUse) {
        return !ILUtils.isNullOrNone(pointerUse.down(2));
    }

    private boolean isArrayPointer(int zone) {
        ZoneInfo zi = this.declaredZoneInfo(zone, 0);
        return zi != null && TypeSpec.isA(zi.type, 6) && ((PointerTypeSpec)zi.type.wrappedType).offsetLength != null;
    }

    private boolean isSameShape(TapList<?> initialDest, TapList<?> currentDest) {
        boolean sameShape = true;
        while (sameShape && initialDest != null && currentDest != null) {
            sameShape = initialDest.head instanceof TapList && currentDest.head instanceof TapList ? this.isSameShape((TapList)initialDest.head, (TapList)currentDest.head) : (initialDest.head instanceof TapIntList && currentDest.head instanceof TapIntList ? this.isSameShape((TapIntList)initialDest.head, (TapIntList)currentDest.head) : false);
            initialDest = initialDest.tail;
            if (initialDest == null != ((currentDest = currentDest.tail) != null)) continue;
            sameShape = false;
        }
        return sameShape;
    }

    private boolean isSameShape(TapIntList initialDest, TapIntList currentDest) {
        if (initialDest.tail != null || currentDest.tail != null) {
            return false;
        }
        ZoneInfo initialDestZone = DataFlowAnalyzer.extendedDeclaredToZoneInfo(initialDest.head, this, null);
        ZoneInfo currentDestZone = DataFlowAnalyzer.extendedDeclaredToZoneInfo(currentDest.head, this, null);
        int initialDestSize = initialDestZone == null ? -1 : initialDestZone.knownSize(this);
        int currentDestSize = currentDestZone == null ? -1 : currentDestZone.knownSize(this);
        return initialDestSize > 0 && currentDestSize == initialDestSize;
    }

    private TapList includePointedInitialsInTree(TapList<?> zonesTree, ZoneInfo[] declaredAllKindArray) {
        return this.includePointedInitialsInTreeRec(zonesTree, new TapIntList(-1, null), declaredAllKindArray);
    }

    private TapList includePointedInitialsInTreeRec(TapList<?> zonesTree, TapIntList dejaVu, ZoneInfo[] declaredAllKindArray) {
        if (zonesTree == null) {
            return null;
        }
        if (zonesTree.head instanceof TapList) {
            TapList<Object> result;
            TapList<Object> tlResult = result = new TapList<Object>(null, null);
            while (zonesTree != null) {
                tlResult = tlResult.placdl(this.includePointedInitialsInTreeRec((TapList)zonesTree.head, dejaVu, declaredAllKindArray));
                zonesTree = zonesTree.tail;
            }
            return result.tail;
        }
        TapIntList zonesList = (TapIntList)zonesTree.head;
        TapIntList zonesListCopy = TapIntList.copy(zonesList);
        TapList<?> cumulTargets = null;
        while (zonesList != null) {
            if (!TapIntList.contains(dejaVu.tail, zonesList.head)) {
                dejaVu.tail = new TapIntList(zonesList.head, dejaVu.tail);
                ZoneInfo zi = this.declaredZoneInfo(zonesList.head, 0);
                if (zi == null && zonesList.head >= this.firstDeclaredZone[0]) {
                    zi = declaredAllKindArray[zonesList.head - this.firstDeclaredZone[0]];
                }
                if (zi != null && zi.targetZonesTree != null) {
                    cumulTargets = TapList.cumulWithOper(cumulTargets, zi.targetZonesTree, 91);
                }
            }
            zonesList = zonesList.tail;
        }
        if (cumulTargets != null) {
            cumulTargets = this.includePointedInitialsInTreeRec(cumulTargets, dejaVu, declaredAllKindArray);
        }
        return new TapList<TapIntList>(zonesListCopy, cumulTargets);
    }

    public TapList subTreeOfPointedZones(BoolVector destsRow, int[] elemMap, WrapperTypeSpec destinationType, Tree pathToSubTree) {
        TapList<Object> pointerDestsTree = new TapList<Object>(null, this.treeOfPointedZones(destsRow, elemMap, destinationType));
        return TapList.getSetFieldLocation(pointerDestsTree, pathToSubTree, false);
    }

    public Tree buildZoneVisibleAccessTree(ZoneInfo zoneInfo) {
        Tree visibleAccessTree = null;
        TapList<String> varNames = zoneInfo.variableNames();
        if (varNames == null) {
            varNames = new TapList<String>(ILUtils.baseName(zoneInfo.accessTree), null);
        }
        while (visibleAccessTree == null && varNames != null) {
            TapList varZones;
            VariableDecl varDecl;
            String varName = (String)varNames.head;
            if (varName != null && (varDecl = this.getTopVariableDecl(varName)) != null && TapIntList.contains(ZoneInfo.listAllZones(varZones = this.includePointedInitialsInTree(varDecl.zones(), this.declaredZoneInfos[0]), true), zoneInfo.zoneNb)) {
                visibleAccessTree = ILUtils.copy(zoneInfo.accessTree);
                TapList<Tree> reversedTreeNodes = ILUtils.reversedExprAccess(visibleAccessTree);
                Tree treeNode = (Tree)reversedTreeNodes.head;
                if (treeNode.opCode() == 94 && !varName.equals(treeNode.stringValue())) {
                    treeNode.setValue(varName);
                }
                reversedTreeNodes = reversedTreeNodes.tail;
                WrapperTypeSpec rootType = varDecl.type();
                while (reversedTreeNodes != null) {
                    treeNode = (Tree)reversedTreeNodes.head;
                    if (treeNode.opCode() == 73 && rootType.wrappedType.kind() == 21) {
                        TapList foundFieldZoneTree = null;
                        int fieldRank = -1;
                        while (varZones != null && foundFieldZoneTree == null) {
                            ++fieldRank;
                            if (TapIntList.contains(ZoneInfo.listAllZones((TapList)varZones.head, true), zoneInfo.zoneNb)) {
                                foundFieldZoneTree = (TapList)varZones.head;
                            }
                            varZones = varZones.tail;
                        }
                        FieldDecl fieldDecl = ((CompositeTypeSpec)rootType.wrappedType).fields[fieldRank];
                        if (treeNode.down(2).opCode() == 94 && !fieldDecl.symbol.equals(treeNode.down(2).stringValue())) {
                            treeNode.down(2).setValue(fieldDecl.symbol);
                        }
                        rootType = fieldDecl.type();
                        varZones = foundFieldZoneTree;
                        reversedTreeNodes = reversedTreeNodes.tail;
                        break;
                    }
                    if (treeNode.opCode() == 148 && rootType.wrappedType.kind() == 6) {
                        assert (varZones != null);
                        if (TapIntList.contains((TapIntList)varZones.head, zoneInfo.zoneNb)) {
                            reversedTreeNodes = null;
                            continue;
                        }
                        rootType = ((PointerTypeSpec)rootType.wrappedType).destinationType;
                        varZones = varZones.tail;
                        reversedTreeNodes = reversedTreeNodes.tail;
                        continue;
                    }
                    if (treeNode.opCode() == 8 && rootType.wrappedType.kind() == 2) {
                        rootType = rootType.wrappedType.elementType();
                        reversedTreeNodes = reversedTreeNodes.tail;
                        continue;
                    }
                    if (rootType.wrappedType.kind() == 5) {
                        rootType = rootType.wrappedType.elementType();
                        reversedTreeNodes = reversedTreeNodes.tail;
                        continue;
                    }
                    TapEnv.fileWarning(15, null, "(Visible access tree) local type " + varDecl.type() + " of " + varName + " incompatible with global " + zoneInfo.accessTree);
                    reversedTreeNodes = null;
                }
            }
            varNames = varNames.tail;
        }
        if (!(visibleAccessTree != null || this.basisSymbolTable == null || TapEnv.isCorMore(this.language) && this.isTranslationUnitSymbolTable())) {
            visibleAccessTree = this.basisSymbolTable.buildZoneVisibleAccessTree(zoneInfo);
        }
        return visibleAccessTree;
    }

    private TapList treeOfPointedZones(BoolVector destsRow, int[] elemMap, WrapperTypeSpec destinationType) {
        TapList<Object> resultTree = new TapList<Object>(null, null);
        TapIntList forgottenZones = null;
        for (int mapClass = elemMap.length - 1; mapClass > 0; --mapClass) {
            for (int zoneIndex = elemMap[mapClass] - 1; zoneIndex >= elemMap[mapClass - 1]; --zoneIndex) {
                Tree subAccessTree;
                if (!destsRow.get(zoneIndex)) continue;
                ZoneInfo zoneInfo = DataFlowAnalyzer.vectorIndexToZoneInfo(zoneIndex, mapClass, 0, elemMap, this);
                int indexAsDeclared = DataFlowAnalyzer.vectorIndexToExtendedDeclared(zoneIndex, mapClass, 0, elemMap, this);
                if (zoneInfo == null) {
                    subAccessTree = null;
                } else if (zoneInfo.targetZoneOf != null) {
                    WrapperTypeSpec pointingTypeSpec = zoneInfo.targetZoneOf.type;
                    pointingTypeSpec = pointingTypeSpec.baseTypeSpec(true);
                    subAccessTree = this.findTypeInTypedTree(destinationType, zoneInfo.accessTree, ((PointerTypeSpec)pointingTypeSpec.wrappedType).destinationType, null, null, true);
                } else {
                    subAccessTree = this.findTypeInTypedTree(destinationType, zoneInfo.accessTree, zoneInfo.rootAccessType, null, null, true);
                }
                if (subAccessTree == null) {
                    forgottenZones = new TapIntList(indexAsDeclared, forgottenZones);
                    continue;
                }
                TapList<?> leaf = TapList.getSetFieldLocation(resultTree, subAccessTree, true);
                TapList.addIntoLeaves(leaf, new TapIntList(indexAsDeclared, null));
            }
        }
        if (forgottenZones != null) {
            TapList.addIntoLeaves(resultTree, forgottenZones);
        }
        return resultTree;
    }

    public TapList<Tree> listOfPointedTrees(BoolVector destsRow, int[] elemMap, WrapperTypeSpec destinationType, ToBool toNull, ToBool toUndef, ToBool toUnknown) {
        TapList<Tree> dTrees = null;
        TapList<Tree> seTrees = null;
        TapPair<Object, Object> accessAndZones = new TapPair<Object, Object>(null, null);
        BoolVector destsRowCopy = destsRow.copy();
        toNull.set(false);
        toUndef.set(false);
        toUnknown.set(false);
        for (int mapClass = elemMap.length - 1; mapClass > 0; --mapClass) {
            for (int zoneIndex = elemMap[mapClass] - 1; zoneIndex >= elemMap[mapClass - 1]; --zoneIndex) {
                if (!destsRowCopy.get(zoneIndex)) continue;
                ZoneInfo zoneInfo = DataFlowAnalyzer.vectorIndexToZoneInfo(zoneIndex, mapClass, 0, elemMap, this);
                if (zoneInfo == null) {
                    if (zoneIndex == elemMap[2] - 1) {
                        toUndef.set(true);
                        continue;
                    }
                    if (zoneIndex == elemMap[2] - 2) {
                        toNull.set(true);
                        continue;
                    }
                    toUnknown.set(true);
                    continue;
                }
                if (zoneInfo.targetZoneOf != null) {
                    this.findTypeInTypedTree(destinationType, zoneInfo.accessTree, ((PointerTypeSpec)zoneInfo.targetZoneOf.type.wrappedType).destinationType, zoneInfo.targetZoneOf.targetZonesTree, accessAndZones, false);
                } else if (zoneInfo.ownerSymbolDecl != null) {
                    this.findTypeInTypedTree(destinationType, zoneInfo.accessTree, zoneInfo.rootAccessType, zoneInfo.ownerSymbolDecl.zones(), accessAndZones, false);
                }
                if (accessAndZones.first == null) {
                    accessAndZones.first = zoneInfo.accessTree;
                    accessAndZones.second = null;
                }
                TapIntList zonesDone = ZoneInfo.listAllZones((TapList)accessAndZones.second, true);
                while (zonesDone != null) {
                    int doneIndex = DataFlowAnalyzer.zoneRkToVectorIndex(zonesDone.head, mapClass, 0, elemMap, null);
                    destsRowCopy.set(doneIndex, false);
                    zonesDone = zonesDone.tail;
                }
                Tree destTree = (Tree)accessAndZones.first;
                if (mapClass == 3) {
                    if (TapList.containsTree(dTrees, destTree)) continue;
                    dTrees = new TapList<Tree>(destTree, dTrees);
                    continue;
                }
                if (TapList.containsTree(seTrees, destTree)) continue;
                seTrees = new TapList<Tree>(destTree, seTrees);
            }
        }
        return TapList.append(dTrees, seTrees);
    }

    private Tree findTypeInTypedTree(WrapperTypeSpec searchedType, Tree accessTree, WrapperTypeSpec givenType, TapList<?> zonesTree, TapPair<Tree, TapList> accessAndZones, boolean peelAllocate) {
        if (accessAndZones != null) {
            accessAndZones.first = null;
            accessAndZones.second = null;
        }
        WrapperTypeSpec searchedTypeElement = null;
        if (TypeSpec.isA(searchedType, 2)) {
            searchedTypeElement = searchedType.wrappedType.elementType();
        }
        TapList<Tree> reversedAccesses = ILUtils.reversedExprAccessFromPointerAccess(accessTree, peelAllocate);
        Tree subAccessTree = null;
        block5: while (reversedAccesses != null && givenType != null && givenType.wrappedType != null) {
            if (subAccessTree == null && (givenType.equalsCompilIndep(searchedType) || searchedTypeElement != null && givenType.equalsCompilIndep(searchedTypeElement))) {
                subAccessTree = ILUtils.build(136);
                if (accessAndZones != null) {
                    accessAndZones.first = reversedAccesses.head;
                    accessAndZones.second = zonesTree;
                }
            }
            switch (givenType.wrappedType.kind()) {
                case 2: {
                    reversedAccesses = reversedAccesses.tail;
                    if (reversedAccesses != null && ((Tree)reversedAccesses.head).opCode() == 8) {
                        givenType = givenType.wrappedType.elementType();
                        if (subAccessTree == null) continue block5;
                        subAccessTree = ILUtils.build(8, subAccessTree, null);
                        continue block5;
                    }
                    givenType = null;
                    continue block5;
                }
                case 21: {
                    reversedAccesses = reversedAccesses.tail;
                    if (reversedAccesses != null && ((Tree)reversedAccesses.head).opCode() == 73) {
                        Tree field = ((Tree)reversedAccesses.head).down(2);
                        givenType = ((CompositeTypeSpec)givenType.wrappedType).getFieldType(field);
                        if (subAccessTree != null) {
                            subAccessTree = ILUtils.build(73, subAccessTree, ILUtils.copy(field));
                            ILUtils.setFieldRank(subAccessTree.down(2), ILUtils.getFieldRank(field));
                        }
                        if (zonesTree == null) continue block5;
                        zonesTree = (TapList)TapList.nth(zonesTree, ILUtils.getFieldRank(field));
                        continue block5;
                    }
                    givenType = null;
                    continue block5;
                }
                case 5: {
                    givenType = givenType.wrappedType.elementType();
                    continue block5;
                }
            }
            givenType = null;
        }
        return subAccessTree;
    }

    public TapList<ZoneInfo> collectAddressTakenZones(Tree tree, Instruction instruction, TapList<ZoneInfo> collected) {
        block3: {
            block4: {
                if (tree == null) break block3;
                if (tree.opCode() != 3) break block4;
                TapIntList addressTakenZones = this.listOfZonesOfValue(tree.down(1), null, instruction);
                while (addressTakenZones != null) {
                    ZoneInfo zi = DataFlowAnalyzer.extendedDeclaredToZoneInfo(addressTakenZones.head, this, null);
                    if (!TapList.contains(collected, zi)) {
                        collected = new TapList<ZoneInfo>(zi, collected);
                    }
                    addressTakenZones = addressTakenZones.tail;
                }
                break block3;
            }
            if (tree.isAtom()) break block3;
            Tree[] subTrees = tree.children();
            for (int i = subTrees.length - 1; i >= 0; --i) {
                collected = this.collectAddressTakenZones(subTrees[i], instruction, collected);
            }
        }
        return collected;
    }

    public BoolVector zonesUsedByExp(Tree instrOrExpr, Instruction instruction) {
        int[] vectorMap = DataFlowAnalyzer.makeMap3(this.unit == null ? 0 : this.unit.sideEffectZonesNb(0), 0, this.declaredZonesNb(0));
        BoolVector usedZones = new BoolVector(DataFlowAnalyzer.mapSize(vectorMap));
        TapList zonesOfExp = this.zUBErec(instrOrExpr, usedZones, vectorMap, instruction);
        DataFlowAnalyzer.setExtendedDeclared(usedZones, vectorMap, 0, ZoneInfo.listAllZones(zonesOfExp, true), true, this);
        return usedZones;
    }

    private TapList zUBErec(Tree instrOrExpr, BoolVector usedZones, int[] vectorMap, Instruction instruction) {
        switch (instrOrExpr.opCode()) {
            case 13: {
                this.zUBErec(instrOrExpr.down(1), usedZones, vectorMap, instruction);
                TapList rhsz = this.zUBErec(instrOrExpr.down(2), usedZones, vectorMap, instruction);
                DataFlowAnalyzer.setExtendedDeclared(usedZones, vectorMap, 0, ZoneInfo.listAllZones(rhsz, true), true, this);
                return rhsz;
            }
            case 163: {
                TapList rz = this.zUBErec(instrOrExpr.down(1), usedZones, vectorMap, instruction);
                DataFlowAnalyzer.setExtendedDeclared(usedZones, vectorMap, 0, ZoneInfo.listAllZones(rz, true), true, this);
                return rz;
            }
            case 94: {
                if (NewSymbolHolder.isANewSymbolRef(instrOrExpr)) {
                    return null;
                }
                VariableDecl variableDecl = this.getVariableDecl(ILUtils.getIdentString(instrOrExpr));
                if (variableDecl == null) {
                    return null;
                }
                return variableDecl.zones();
            }
            case 8: 
            case 108: {
                this.zUBErec(instrOrExpr.down(2), usedZones, vectorMap, instruction);
                return this.zUBErec(instrOrExpr.down(1), usedZones, vectorMap, instruction);
            }
            case 73: {
                TapList rz = this.zUBErec(instrOrExpr.down(1), usedZones, vectorMap, instruction);
                int fieldRank = ILUtils.getFieldRank(instrOrExpr.down(2));
                if (fieldRank != -1 && rz != null && TapList.nth(rz, fieldRank) instanceof TapList) {
                    rz = (TapList)TapList.nth(rz, fieldRank);
                }
                return rz;
            }
            case 3: {
                return new TapList<Object>(null, this.zUBErec(instrOrExpr.down(1), usedZones, vectorMap, instruction));
            }
            case 148: {
                TapList rz = this.zUBErec(instrOrExpr.down(2), usedZones, vectorMap, instruction);
                DataFlowAnalyzer.setExtendedDeclared(usedZones, vectorMap, 0, ZoneInfo.listAllZones(rz, true), true, this);
                rz = this.zUBErec(instrOrExpr.down(1), usedZones, vectorMap, instruction);
                DataFlowAnalyzer.setExtendedDeclared(usedZones, vectorMap, 0, ZoneInfo.listAllZones(rz, true), true, this);
                return this.treeOfZonesOfValue(instrOrExpr, null, instruction, null);
            }
            case 2: 
            case 5: 
            case 17: 
            case 21: 
            case 23: 
            case 41: 
            case 42: 
            case 58: 
            case 61: 
            case 67: 
            case 90: 
            case 93: 
            case 113: 
            case 114: 
            case 120: 
            case 124: 
            case 131: 
            case 135: 
            case 141: 
            case 152: 
            case 164: 
            case 177: 
            case 202: {
                TapList rz = this.zUBErec(instrOrExpr.down(1), usedZones, vectorMap, instruction);
                DataFlowAnalyzer.setExtendedDeclared(usedZones, vectorMap, 0, ZoneInfo.listAllZones(rz, true), true, this);
                rz = this.zUBErec(instrOrExpr.down(2), usedZones, vectorMap, instruction);
                DataFlowAnalyzer.setExtendedDeclared(usedZones, vectorMap, 0, ZoneInfo.listAllZones(rz, true), true, this);
                return null;
            }
            case 97: {
                TapList rz = this.zUBErec(instrOrExpr.down(1), usedZones, vectorMap, instruction);
                DataFlowAnalyzer.setExtendedDeclared(usedZones, vectorMap, 0, ZoneInfo.listAllZones(rz, true), true, this);
                TapList rzTrue = this.zUBErec(instrOrExpr.down(2), usedZones, vectorMap, instruction);
                rz = this.zUBErec(instrOrExpr.down(3), usedZones, vectorMap, instruction);
                return TapList.cumulWithOper(TapList.copyTree(rz), rzTrue, 91);
            }
            case 96: 
            case 122: 
            case 137: 
            case 171: 
            case 180: 
            case 184: 
            case 191: 
            case 200: 
            case 201: {
                TapList rz = this.zUBErec(instrOrExpr.down(1), usedZones, vectorMap, instruction);
                DataFlowAnalyzer.setExtendedDeclared(usedZones, vectorMap, 0, ZoneInfo.listAllZones(rz, true), true, this);
                return null;
            }
            case 31: 
            case 39: 
            case 189: {
                TapList rz = this.zUBErec(instrOrExpr.down(2), usedZones, vectorMap, instruction);
                DataFlowAnalyzer.setExtendedDeclared(usedZones, vectorMap, 0, ZoneInfo.listAllZones(rz, true), true, this);
                return null;
            }
            case 179: {
                TapList rz = this.zUBErec(instrOrExpr.down(1), usedZones, vectorMap, instruction);
                DataFlowAnalyzer.setExtendedDeclared(usedZones, vectorMap, 0, ZoneInfo.listAllZones(rz, true), true, this);
                this.zUBErec(instrOrExpr.down(2), usedZones, vectorMap, instruction);
                return null;
            }
            case 156: 
            case 194: {
                this.zUBErec(instrOrExpr.down(2), usedZones, vectorMap, instruction);
                this.zUBErec(instrOrExpr.down(3), usedZones, vectorMap, instruction);
                return null;
            }
            case 10: 
            case 12: 
            case 44: 
            case 127: 
            case 170: 
            case 187: {
                this.zUBErec(instrOrExpr.down(1), usedZones, vectorMap, instruction);
                this.zUBErec(instrOrExpr.down(2), usedZones, vectorMap, instruction);
                return null;
            }
            case 151: {
                this.zUBErec(instrOrExpr.down(1), usedZones, vectorMap, instruction);
                return null;
            }
            case 52: 
            case 53: 
            case 59: 
            case 181: 
            case 195: 
            case 197: {
                Tree[] subtrees = instrOrExpr.children();
                for (int i = subtrees.length - 1; i >= 0; --i) {
                    this.zUBErec(subtrees[i], usedZones, vectorMap, instruction);
                }
                return null;
            }
            case 4: 
            case 14: 
            case 19: 
            case 27: 
            case 28: 
            case 34: 
            case 38: 
            case 40: 
            case 43: 
            case 48: 
            case 50: 
            case 51: 
            case 68: 
            case 72: 
            case 76: 
            case 88: 
            case 92: 
            case 101: 
            case 102: 
            case 104: 
            case 106: 
            case 109: 
            case 116: 
            case 136: 
            case 138: 
            case 150: 
            case 155: 
            case 166: 
            case 172: 
            case 174: 
            case 175: 
            case 176: 
            case 192: 
            case 199: {
                return null;
            }
            case 132: {
                return this.zUBErec(instrOrExpr.down(2), usedZones, vectorMap, instruction);
            }
            case 119: {
                return this.zUBErec(instrOrExpr.down(3), usedZones, vectorMap, instruction);
            }
            case 46: {
                this.zUBErec(instrOrExpr.down(2), usedZones, vectorMap, instruction);
                return null;
            }
            case 9: 
            case 11: 
            case 26: 
            case 70: 
            case 77: 
            case 128: {
                Tree[] expressions = instrOrExpr.children();
                for (int i = expressions.length - 1; i >= 0; --i) {
                    TapList iz = this.zUBErec(expressions[i], usedZones, vectorMap, instruction);
                    DataFlowAnalyzer.setExtendedDeclared(usedZones, vectorMap, 0, ZoneInfo.listAllZones(iz, true), true, this);
                }
                return null;
            }
            case 63: {
                TapList rz = this.zUBErec(instrOrExpr.down(1), usedZones, vectorMap, instruction);
                DataFlowAnalyzer.setExtendedDeclared(usedZones, vectorMap, 0, ZoneInfo.listAllZones(rz, true), true, this);
                rz = this.zUBErec(instrOrExpr.down(2), usedZones, vectorMap, instruction);
                DataFlowAnalyzer.setExtendedDeclared(usedZones, vectorMap, 0, ZoneInfo.listAllZones(rz, true), true, this);
                rz = this.zUBErec(instrOrExpr.down(3), usedZones, vectorMap, instruction);
                DataFlowAnalyzer.setExtendedDeclared(usedZones, vectorMap, 0, ZoneInfo.listAllZones(rz, true), true, this);
                rz = this.zUBErec(instrOrExpr.down(4), usedZones, vectorMap, instruction);
                DataFlowAnalyzer.setExtendedDeclared(usedZones, vectorMap, 0, ZoneInfo.listAllZones(rz, true), true, this);
                return null;
            }
            case 30: {
                Tree[] arguments = ILUtils.getArguments(instrOrExpr).children();
                TapList[] az = new TapList[arguments.length];
                for (int i = arguments.length - 1; i >= 0; --i) {
                    az[i] = this.zUBErec(arguments[i], usedZones, vectorMap, instruction);
                }
                Unit calledUnit = DataFlowAnalyzer.getCalledUnit(instrOrExpr, this);
                CallArrow callArrow = null;
                if (calledUnit != null && calledUnit.unitInOutR != null) {
                    callArrow = CallGraph.getCallArrow(this.unit, calledUnit);
                }
                if (callArrow != null && callArrow.translator != null) {
                    BoolVector callUsedZones = new BoolVector(DataFlowAnalyzer.mapSize(vectorMap));
                    DataFlowAnalyzer.propagateDataToCaller(calledUnit.unitInOutPossiblyR(), null, arguments, arguments.length, callUsedZones, vectorMap, null, instruction, callArrow, true, true, 0);
                    usedZones.cumulOr(callUsedZones);
                } else {
                    for (int i = az.length - 1; i >= 0; --i) {
                        DataFlowAnalyzer.setExtendedDeclared(usedZones, vectorMap, 0, ZoneInfo.listAllZones(az[i], true), true, this);
                    }
                }
                return null;
            }
            case 107: {
                TapList rz;
                String ioAction = ILUtils.getIdentString(instrOrExpr.down(1));
                boolean writesInVars = ioAction.equals("read") || ioAction.equals("accept") || ioAction.equals("decode");
                Tree[] ioArgs = instrOrExpr.down(3).children();
                for (int i = ioArgs.length - 1; i >= 0; --i) {
                    rz = this.zUBErec(ioArgs[i], usedZones, vectorMap, instruction);
                    if (writesInVars) continue;
                    DataFlowAnalyzer.setExtendedDeclared(usedZones, vectorMap, 0, ZoneInfo.listAllZones(rz, true), true, this);
                }
                Tree[] ioSpecs = instrOrExpr.down(2).children();
                ToBool totally = new ToBool(false);
                ToBool written = new ToBool(false);
                for (int i = ioSpecs.length - 1; i >= 0; --i) {
                    Tree ioSpecTree = InOutAnalyzer.getIOeffectOfIOspec(ioSpecs[i], i, ioAction, written, totally, this);
                    rz = this.zUBErec(ioSpecTree, usedZones, vectorMap, instruction);
                    if (written.get()) continue;
                    DataFlowAnalyzer.setExtendedDeclared(usedZones, vectorMap, 0, ZoneInfo.listAllZones(rz, true), true, this);
                }
                return null;
            }
        }
        TapEnv.toolWarning(-1, "(Zones used by expression) Unexpected operator: " + instrOrExpr.opName());
        return null;
    }

    public TapIntList getDeclaredKindZones(TapIntList zones, int whichKind, boolean withTmps) {
        TapIntList result;
        TapIntList tlResult = result = new TapIntList(-1, null);
        while (zones != null) {
            if (zones.head >= this.declaredZonesNb(0)) {
                if (withTmps) {
                    tlResult = tlResult.placdl(zones.head);
                }
            } else {
                int kindZone;
                ZoneInfo zi = this.declaredZoneInfo(zones.head, 0);
                if (zi != null && (kindZone = zi.zoneNb(whichKind)) >= 0) {
                    tlResult = tlResult.placdl(kindZone);
                }
            }
            zones = zones.tail;
        }
        return result.tail;
    }

    public boolean identIsAFunction(Tree varTree) {
        if (varTree.opCode() == 94) {
            SymbolDecl varDecl = this.getSymbolDecl(ILUtils.getIdentString(varTree));
            return varDecl != null && varDecl.isA(3);
        }
        return false;
    }

    public boolean varIsIntentIn(Tree varTree) {
        if (ILUtils.isAVarRef(varTree, this)) {
            VariableDecl variableDecl = this.getVariableDecl(ILUtils.baseName(varTree));
            return variableDecl != null && variableDecl.hasModifier("in");
        }
        return false;
    }

    public boolean hidesRef(Tree tree1, Tree tree2) {
        return false;
    }

    public TapList<SymbolDecl> getAllTopSymbolDecls() {
        return this.getAllDecls(0, true);
    }

    public TapList<SymbolDecl> getAllTopVariableDecls() {
        return this.getAllDecls(1, true);
    }

    public TapList<SymbolDecl> getAllVariableDecls() {
        return this.getAllDecls(1, false);
    }

    public TapList<SymbolDecl> getAllTypeDecls() {
        return this.getAllDecls(4, false);
    }

    public VariableDecl getVariableDeclOfRank(int rank) {
        TapList<SymbolDecl> allVarDecls = this.getAllTopVariableDecls();
        VariableDecl result = null;
        while (allVarDecls != null && result == null) {
            if (((VariableDecl)allVarDecls.head).formalArgRank == rank) {
                result = (VariableDecl)allVarDecls.head;
            }
            allVarDecls = allVarDecls.tail;
        }
        return result;
    }

    private TapList<SymbolDecl> getAllDecls(int kind, boolean top) {
        TapList<Object> resList;
        SymbolTable curSymbolTable = this;
        TapList<Object> tailRes = resList = new TapList<Object>(null, null);
        while (curSymbolTable != null) {
            for (int i = 0; i < 100; ++i) {
                TapList curBucket = curSymbolTable.buckets[i].tail;
                while (curBucket != null) {
                    if (((SymbolDecl)curBucket.head).isA(kind)) {
                        tailRes = tailRes.placdl(curBucket.head);
                    }
                    curBucket = curBucket.tail;
                }
            }
            if (top) {
                curSymbolTable = null;
                continue;
            }
            curSymbolTable = curSymbolTable.basisSymbolTable();
        }
        return resList.tail;
    }

    public TapList<SymbolDecl> getAllTopFunctionDecls() {
        return this.getAllDecls(3, true);
    }

    public TapList<FunctionDecl> getAllInterfaceDecls() {
        TapList<SymbolDecl> intfs = this.getAllDecls(16, true);
        TapList<SymbolDecl> functions = this.getAllDecls(3, true);
        while (intfs != null) {
            if (intfs.head instanceof FunctionDecl) {
                FunctionDecl funcDecl = (FunctionDecl)intfs.head;
                if (funcDecl.hasInterfaceInstruction()) {
                    functions = new TapList<SymbolDecl>(funcDecl, functions);
                }
            } else {
                InterfaceDecl interfaceDecl = (InterfaceDecl)intfs.head;
                functions = TapList.append(interfaceDecl.functionDecls, functions);
            }
            intfs = intfs.tail;
        }
        return functions;
    }

    private TapList<SymbolDecl> getAllTargetDecls(WrapperTypeSpec typeSpec) {
        TapList<Object> resList;
        TapList<Object> tailRes = resList = new TapList<Object>(null, null);
        for (SymbolTable curSymbolTable = this; curSymbolTable != null; curSymbolTable = curSymbolTable.basisSymbolTable()) {
            for (int i = 0; i < 100; ++i) {
                TapList curBucket = curSymbolTable.buckets[i].tail;
                while (curBucket != null) {
                    SymbolDecl symbolDecl = (SymbolDecl)curBucket.head;
                    if (symbolDecl != null && (!TapEnv.isFortran9x(this.language) || symbolDecl.isTarget(typeSpec))) {
                        tailRes = tailRes.placdl(symbolDecl);
                    }
                    curBucket = curBucket.tail;
                }
            }
        }
        return resList.tail;
    }

    protected void allocateZones(ZoneAllocator zoneAllocator, Unit declarationUnit) {
        zoneAllocator.setCommonName(null);
        zoneAllocator.setStartOffset(-1);
        zoneAllocator.setInfiniteEndOffset(false);
        zoneAllocator.setEndOffset(-1);
        for (int i = 0; i < 100; ++i) {
            TapList curBucket = this.buckets[i].tail;
            while (curBucket != null) {
                TapList regionZones;
                int argRank;
                if (((SymbolDecl)curBucket.head).isA(1)) {
                    VariableDecl variableDecl = (VariableDecl)curBucket.head;
                    int n = argRank = variableDecl.isReturnVar ? 0 : variableDecl.formalArgRank;
                    if (variableDecl.isSystemPredefined()) {
                        variableDecl.setZones(new TapList<TapIntList>(new TapIntList(TapEnv.get().origCallGraph().zoneNbOfAllIOStreams, null), null));
                    } else if (variableDecl.type() != null && !TypeSpec.isA(variableDecl.type(), 4)) {
                        if (variableDecl.zones() == null) {
                            regionZones = zoneAllocator.allocateZones(ILUtils.build(94, variableDecl.symbol), null, variableDecl.type(), variableDecl.type(), -1, variableDecl.extraInfo(), argRank, false, false, false, null, null, this, declarationUnit);
                            variableDecl.accumulateZones(regionZones);
                            zoneAllocator.addVarName(regionZones, variableDecl.symbol);
                            zoneAllocator.addVarDecl(regionZones, variableDecl);
                        } else if (argRank != -1) {
                            zoneAllocator.addArgRank(variableDecl.zones(), argRank);
                        }
                    }
                } else if (((SymbolDecl)curBucket.head).isA(3)) {
                    FunctionDecl functionDecl = (FunctionDecl)curBucket.head;
                    if (functionDecl.isVarFunction()) {
                        argRank = functionDecl.formalArgRank;
                        if (functionDecl.zones() == null) {
                            regionZones = zoneAllocator.allocateZones(ILUtils.build(94, functionDecl.symbol), null, functionDecl.type(), functionDecl.type(), -1, null, argRank, false, false, false, null, null, this, declarationUnit);
                            functionDecl.setZones(regionZones);
                            zoneAllocator.addVarName(regionZones, functionDecl.symbol);
                            zoneAllocator.addVarDecl(regionZones, functionDecl);
                        } else if (argRank != -1) {
                            zoneAllocator.addArgRank(functionDecl.zones(), argRank);
                        }
                    }
                } else if (((SymbolDecl)curBucket.head).isA(16)) {
                    InterfaceDecl interfaceDecl = (InterfaceDecl)curBucket.head;
                    if (this.isFormalParams && this.unit.isStandard()) {
                        argRank = interfaceDecl.formalArgRank;
                        if (interfaceDecl.zones() == null) {
                            FunctionDecl functionDecl = interfaceDecl.functionDecl();
                            regionZones = zoneAllocator.allocateZones(ILUtils.build(94, functionDecl.symbol), null, functionDecl.type(), functionDecl.type(), -1, null, argRank, false, false, false, null, null, this, declarationUnit);
                            interfaceDecl.setZones(regionZones);
                            zoneAllocator.addVarName(regionZones, functionDecl.symbol);
                            zoneAllocator.addVarDecl(regionZones, functionDecl);
                        } else if (argRank != -1) {
                            zoneAllocator.addArgRank(interfaceDecl.zones(), argRank);
                        }
                    }
                }
                curBucket = curBucket.tail;
            }
        }
    }

    protected Object staticValue(Tree tree) {
        Object valueAnnotation = tree.getAnnotation("staticValue");
        if (valueAnnotation == null) {
            valueAnnotation = this.doCompute(tree);
            tree.setAnnotation("staticValue", valueAnnotation);
        }
        return valueAnnotation;
    }

    private Object doCompute(Tree tree) {
        switch (tree.opCode()) {
            case 101: {
                return tree.intValue();
            }
            case 175: {
                return tree.stringValue();
            }
            case 155: {
                return null;
            }
            case 94: {
                String name = ILUtils.getIdentString(tree);
                VariableDecl variableDecl = this.getVariableOrConstantDecl(name);
                if (variableDecl != null && variableDecl.kind == 5 && variableDecl.initializationTree() != null) {
                    return this.doCompute(variableDecl.initializationTree());
                }
                return null;
            }
            case 67: {
                Object valueLeft = this.doCompute(tree.down(1));
                Object valueRight = this.doCompute(tree.down(2));
                if (valueLeft != null && valueRight != null) {
                    return valueLeft.equals(valueRight);
                }
                return null;
            }
        }
        return null;
    }

    public Integer computeIntConstant(Tree tree) {
        switch (tree.opCode()) {
            case 101: {
                return tree.intValue();
            }
            case 3: 
            case 9: 
            case 19: 
            case 27: 
            case 41: 
            case 42: 
            case 43: 
            case 70: 
            case 73: 
            case 97: 
            case 107: 
            case 116: 
            case 136: 
            case 148: 
            case 155: 
            case 171: 
            case 172: 
            case 175: 
            case 176: {
                return null;
            }
            case 94: {
                boolean wasAnInteger;
                String sval = tree.stringValue();
                int ival = -1;
                try {
                    ival = Integer.parseInt(sval);
                    wasAnInteger = true;
                }
                catch (NumberFormatException e) {
                    wasAnInteger = false;
                }
                if (wasAnInteger) {
                    return ival;
                }
                VariableDecl variableDecl = this.getVariableOrConstantDecl(tree.stringValue());
                if (variableDecl != null && variableDecl.constantValue != null) {
                    return variableDecl.constantValue;
                }
                return null;
            }
            case 2: {
                Integer i1 = this.computeIntConstant(tree.down(1));
                Integer i2 = this.computeIntConstant(tree.down(2));
                if (i1 != null && i2 != null) {
                    return i1 + i2;
                }
                return null;
            }
            case 177: {
                Integer i1 = this.computeIntConstant(tree.down(1));
                Integer i2 = this.computeIntConstant(tree.down(2));
                if (i1 != null && i2 != null) {
                    return i1 - i2;
                }
                return null;
            }
            case 131: {
                Integer i1 = this.computeIntConstant(tree.down(1));
                Integer i2 = this.computeIntConstant(tree.down(2));
                if (i1 != null && i2 != null) {
                    return i1 * i2;
                }
                return null;
            }
            case 122: {
                Integer i1 = this.computeIntConstant(tree.down(1));
                if (i1 != null) {
                    return -i1.intValue();
                }
                return null;
            }
            case 61: {
                Integer i1 = this.computeIntConstant(tree.down(1));
                Integer i2 = this.computeIntConstant(tree.down(2));
                if (i1 != null && i2 != null && i2 != 0) {
                    return i1 / i2;
                }
                return null;
            }
            case 152: {
                Integer i1 = this.computeIntConstant(tree.down(1));
                Integer i2 = this.computeIntConstant(tree.down(2));
                if (i1 != null && i2 != null) {
                    return (int)Math.pow(i1.intValue(), i2.intValue());
                }
                return null;
            }
            case 31: 
            case 132: {
                return this.computeIntConstant(tree.down(2));
            }
            case 8: {
                if ((this.unit == null || this.unit.isFortran()) && ILUtils.isIdentOf(tree.down(1), new String[]{"kind", "size"}, false)) {
                    return this.computeIntConstant(ILUtils.buildCall(null, ILUtils.copy(tree.down(1)), ILUtils.copy(tree.down(2))));
                }
                return null;
            }
            case 30: {
                WrapperTypeSpec typeSpec;
                Unit calledUnit = DataFlowAnalyzer.getCalledUnit(tree, this);
                if (calledUnit != null && calledUnit.isIntrinsic() && calledUnit.name.equals("kind") && (typeSpec = this.typeOf(ILUtils.getArguments(tree).down(1))) != null) {
                    return typeSpec.size();
                }
                return null;
            }
        }
        TapEnv.fileWarning(15, tree, "(Compute constant) Unexpected operator: " + tree.opName());
        return null;
    }

    public boolean equalValues(Tree exp1, Tree exp2) {
        if (exp1.equalsTree(exp2)) {
            return true;
        }
        Integer val1 = this.computeIntConstant(exp1);
        Integer val2 = this.computeIntConstant(exp2);
        return val1 != null && val2 != null && val1.intValue() == val2.intValue();
    }

    public final SymbolTable getExistingCopy(TapList<TapPair<SymbolTable, SymbolTable>> associationsST) {
        return (SymbolTable)TapList.cassq(this, associationsST);
    }

    public SymbolTable getExistingOrig(TapList<TapPair<SymbolTable, SymbolTable>> associationsST) {
        TapPair foundPair = TapList.rassq(this, associationsST);
        return foundPair == null ? null : (SymbolTable)foundPair.first;
    }

    public SymbolTable smartCopy(TapList<TapPair<SymbolTable, SymbolTable>> associationsST, Object targetUnitOrCG, CallGraph targetCG, UnitStorage<Unit> associationsUnits) {
        SymbolTable copyST = this.getExistingCopy(associationsST);
        if (copyST == null) {
            SymbolTable copyBasisST = null;
            if (this.basisSymbolTable != null) {
                Object basisTargetUnitOrCG = targetUnitOrCG;
                if (this.basisSymbolTable.unit != this.unit && targetUnitOrCG instanceof Unit && (basisTargetUnitOrCG = ((Unit)targetUnitOrCG).upperLevelUnit()) == null) {
                    basisTargetUnitOrCG = targetCG;
                }
                copyBasisST = this.basisSymbolTable.smartCopy(associationsST, basisTargetUnitOrCG, targetCG, associationsUnits);
            }
            if (associationsST != null && this.usedModule != null) {
                SymbolTable symbolTableOfDiffModule = (SymbolTable)TapList.cassq(this.usedModule.publicSymbolTable(), associationsST);
                if (symbolTableOfDiffModule != null) {
                    targetUnitOrCG = symbolTableOfDiffModule.unit;
                } else {
                    TapEnv.toolWarning(-1, "(Symbol Table smartcopy) Didn't find copy SymbolTable");
                }
            }
            copyST = this.copy(associationsST, targetUnitOrCG, associationsUnits);
            copyST.setBasisSymbolTable(copyBasisST);
        }
        copyST.rootCallGraph = targetCG;
        return copyST;
    }

    private SymbolTable copy(TapList<TapPair<SymbolTable, SymbolTable>> associationsST, Object targetUnitOrCG, UnitStorage<Unit> associationsUnits) {
        TapList<Object> copyBucket;
        TapList oldBucket;
        int i;
        Unit targetUnit;
        SymbolTable copyST = new SymbolTable(null);
        if (associationsST != null) {
            associationsST.placdl(new TapPair<SymbolTable, SymbolTable>(this, copyST));
        }
        copyST.setShortName("Copy of " + this.shortName);
        copyST.language = this.language;
        copyST.implicits = this.implicits;
        copyST.caseDependent = this.caseDependent;
        copyST.isFormalParams = this.isFormalParams;
        copyST.dataList = this.dataList;
        Unit unit = targetUnit = targetUnitOrCG instanceof Unit ? (Unit)targetUnitOrCG : null;
        if (associationsST == null) {
            copyST.inheritedClass = this.inheritedClass;
            copyST.usedModule = this.usedModule;
            copyST.unit = this.unit;
        } else if (this.usedModule == null) {
            copyST.usedModule = null;
            copyST.unit = targetUnit;
        } else {
            copyST.usedModule = targetUnit;
            copyST.unit = targetUnit;
        }
        if (this.isTranslationUnitSymbolTable()) {
            copyST.setIsTranslationUnit();
        }
        if (associationsST == null) {
            copyST.firstDeclaredZone = this.firstDeclaredZone;
            copyST.freeDeclaredZone = this.freeDeclaredZone;
            copyST.additionalDuplicatedDeclaredZoneInfos = this.additionalDuplicatedDeclaredZoneInfos;
        }
        copyST.declaredZoneInfos = this.declaredZoneInfos;
        if (this.declarationsBlock != null) {
            Block copyDeclarationsBlock = null;
            if (targetUnit != null) {
                if (targetUnit.orig2copiedBlocks != null && this.declarationsBlock.rank >= -1) {
                    copyDeclarationsBlock = targetUnit.orig2copiedBlocks.retrieve(this.declarationsBlock);
                }
                if (copyDeclarationsBlock == null && targetUnit.origPublicSTDeclarationBlock == this.declarationsBlock) {
                    copyDeclarationsBlock = targetUnit.copyPublicSTDeclarationBlock;
                }
            }
            if (copyDeclarationsBlock == null) {
                copyDeclarationsBlock = new BasicBlock(copyST, this.declarationsBlock.parallelControls, null);
                copyDeclarationsBlock.rank = -81;
                if (this.isFormalParams || this.basisSymbolTable != null && this.basisSymbolTable.isFormalParams && this.unit.isModule()) {
                    copyDeclarationsBlock.copyInstructions(this.declarationsBlock, new TapList<Object>(null, null));
                }
            }
            copyST.declarationsBlock = copyDeclarationsBlock;
        }
        for (i = 0; i < 100; ++i) {
            oldBucket = this.buckets[i].tail;
            copyBucket = new TapList<Object>(null, null);
            copyST.buckets[i] = copyBucket;
            while (oldBucket != null) {
                SymbolDecl oldSymbolDecl = (SymbolDecl)oldBucket.head;
                SymbolDecl newSymbolDecl = associationsST != null ? oldSymbolDecl.copy(associationsST, associationsUnits) : oldSymbolDecl;
                copyBucket = copyBucket.placdl(newSymbolDecl);
                oldBucket = oldBucket.tail;
            }
        }
        if (associationsST != null) {
            for (i = 0; i < 100; ++i) {
                oldBucket = this.buckets[i].tail;
                copyBucket = copyST.buckets[i].tail;
                while (oldBucket != null) {
                    ((SymbolDecl)oldBucket.head).copyLinksIntoCopy((SymbolDecl)copyBucket.head, associationsST);
                    oldBucket = oldBucket.tail;
                    copyBucket = copyBucket.tail;
                }
            }
        }
        if (this.newSymbolHolders.tail != null) {
            TapList newSHs = this.newSymbolHolders.tail;
            while (newSHs != null) {
                ((NewSymbolHolder)newSHs.head).migrateToCopySymbolTable(copyST);
                newSHs = newSHs.tail;
            }
        }
        return copyST;
    }

    public void cleanCopySymbolDecls() {
        for (int i = 0; i < 100; ++i) {
            TapList bucket = this.buckets[i].tail;
            while (bucket != null) {
                ((SymbolDecl)bucket.head).copySymbolDecl = null;
                bucket = bucket.tail;
            }
        }
    }

    protected WrapperTypeSpec findCompositeTypeSpec(String name) {
        WrapperTypeSpec result = null;
        TapList<SymbolDecl> allVars = this.getAllTopVariableDecls();
        while (allVars != null && result == null) {
            VariableDecl var = (VariableDecl)allVars.head;
            WrapperTypeSpec typeSpec = var.type();
            if (TypeSpec.isA(typeSpec, 21) && ((CompositeTypeSpec)typeSpec.wrappedType).name != null && ((CompositeTypeSpec)typeSpec.wrappedType).name.equals(name)) {
                result = typeSpec;
            }
            allVars = allVars.tail;
        }
        return result;
    }

    public String addressChain() {
        String result = "@" + Integer.toHexString(this.hashCode());
        if (this.basisSymbolTable != null) {
            result = result + "==>" + this.basisSymbolTable.addressChain();
        }
        return result;
    }

    protected void checkTypeSpecValidity() {
        for (int j = this.buckets.length - 1; j >= 0; --j) {
            TapList<SymbolDecl> bucket = this.buckets[j];
            while (bucket != null) {
                SymbolDecl symbolDecl = (SymbolDecl)bucket.head;
                WrapperTypeSpec typeSpec = null;
                if (symbolDecl != null) {
                    switch (symbolDecl.kind) {
                        case 3: {
                            typeSpec = ((FunctionDecl)symbolDecl).type();
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 5: 
                        case 6: {
                            typeSpec = symbolDecl.type();
                            break;
                        }
                        case 4: {
                            typeSpec = ((TypeDecl)symbolDecl).typeSpec;
                            break;
                        }
                        case 16: 
                        case 18: 
                        case 19: 
                        case 20: {
                            break;
                        }
                        default: {
                            TapEnv.toolWarning(-1, "(checkTypeSpecValidity) Not yet implemented " + symbolDecl + " " + symbolDecl.kind);
                        }
                    }
                    if (typeSpec != null) {
                        typeSpec.checkTypeSpecValidity(null);
                    }
                }
                bucket = bucket.tail;
            }
        }
    }

    protected SymbolTable findAssocAddresTypeDeclSymbolTable() {
        int lang = 4;
        if (this.unit != null) {
            lang = this.unit.language();
        }
        return TapEnv.assocAddressDiffTypesUnit(lang).publicSymbolTable();
    }

    public void dump(int indent) throws IOException {
        if (this.unit != null) {
            TapEnv.pushRelatedUnit(this.unit);
        }
        if (this.usedModule != null) {
            TapEnv.indentPrint(indent + 1, " used from " + this.usedModule);
            TapEnv.println();
        }
        TapList<SymbolDecl> symbolDecls = this.getAllTopSymbolDecls();
        while (symbolDecls != null) {
            TapEnv.indentPrint(indent, "- ");
            ((SymbolDecl)symbolDecls.head).dump(0);
            TapEnv.println();
            symbolDecls = symbolDecls.tail;
        }
        if (this.newSymbolHolders.tail != null) {
            TapEnv.indentPrint(indent, "NEW SYMBOLS WAITING FOR SOLVE:" + this.newSymbolHolders.tail);
        }
        if (this.nameListList != null) {
            TapEnv.indentPrint(indent + 4, "-----NameList:------");
            TapEnv.println();
            TapEnv.indentPrint(indent + 4, this.nameListList.toString());
        }
        ZoneInfo[] zoneInfos = this.declaredZoneInfos[0];
        int offset = this.firstDeclaredZone(0);
        if (zoneInfos == null) {
            TapEnv.indentPrint(indent + 6, "no zones at this level.");
            TapEnv.println();
        } else {
            TapEnv.indentPrint(indent + 4, "-----Zones:------ ");
            TapEnv.print("(firstDZ: " + this.firstDeclaredZone[0] + ' ' + this.firstDeclaredZone[1] + ' ' + this.firstDeclaredZone[2] + ' ' + this.firstDeclaredZone[3] + " freeDZ: " + this.freeDeclaredZone[0] + " " + this.freeDeclaredZone[1] + " " + this.freeDeclaredZone[2] + ' ' + this.freeDeclaredZone[3] + ')');
            TapEnv.println();
            for (int i = 0; i < zoneInfos.length; ++i) {
                TapEnv.indentPrint(indent + 6, TapEnv.str3(i + offset) + "> ");
                if (zoneInfos[i] != null) {
                    zoneInfos[i].dump();
                } else {
                    TapEnv.print(" null, meaning hidden");
                }
                TapEnv.println();
            }
        }
        if (this.additionalDuplicatedDeclaredZoneInfos != null && this.additionalDuplicatedDeclaredZoneInfos[0] != null) {
            TapEnv.indentPrint(indent + 4, "-----Additional Zones:------");
            TapEnv.println();
            TapList<Int2ZoneInfo> additionalZoneInfos = this.additionalDuplicatedDeclaredZoneInfos[0];
            while (additionalZoneInfos != null) {
                TapEnv.indentPrint(indent + 6, TapEnv.str3(((Int2ZoneInfo)additionalZoneInfos.head).getZoneNumber()) + "> ");
                ((Int2ZoneInfo)additionalZoneInfos.head).getZoneInfo().dump();
                additionalZoneInfos = additionalZoneInfos.tail;
                TapEnv.println();
            }
        }
        if (this.declarationsBlock != null) {
            TapEnv.indentPrint(indent + 4, "-----DeclBlock:------" + this.declarationsBlock + " (@" + Integer.toHexString(this.declarationsBlock.hashCode()) + ')');
            TapEnv.println();
            TapEnv.indentPrint(indent + 8, this.declarationsBlock.instructions == null ? "empty" : this.declarationsBlock.instructions.toString());
            TapEnv.println();
        } else {
            TapEnv.indentPrint(indent + 8, "null declarationsBlock");
            TapEnv.println();
        }
        TapEnv.indentPrint(indent + 4, "-----Case dependent:------ " + this.caseDependent);
        TapEnv.println();
        SymbolTable basisST = this.basisSymbolTable();
        if (basisST != null) {
            TapEnv.indentPrint(indent, "--------------");
            TapEnv.println();
            if (TapEnv.getSeenSymbolTableShortName(basisST) != null) {
                TapEnv.indentPrint(indent, basisST.shortName());
            } else {
                basisST.dump(indent);
            }
        }
        if (this.unit != null) {
            TapEnv.popRelatedUnit();
        }
    }

    public void dumpDeclaredZones(String stRanks) throws IOException {
        ZoneInfo[] zoneInfos = this.declaredZoneInfos[0];
        TapEnv.indentPrint(2, "Declared zones of " + this.shortName() + ':');
        TapEnv.println();
        if (zoneInfos != null && zoneInfos.length != 0) {
            for (ZoneInfo info : zoneInfos) {
                ZoneInfo zoneInfo = info;
                if (zoneInfo == null) continue;
                TapEnv.indentPrint(6, stRanks + ":a" + zoneInfo.zoneNb);
                if (zoneInfo.realZoneNb != -1) {
                    TapEnv.print("r" + zoneInfo.realZoneNb);
                }
                if (zoneInfo.intZoneNb != -1) {
                    TapEnv.print("i" + zoneInfo.intZoneNb);
                }
                if (zoneInfo.ptrZoneNb != -1) {
                    TapEnv.print("p" + zoneInfo.ptrZoneNb);
                }
                TapEnv.print(" : ");
                zoneInfo.dump();
                TapEnv.println();
            }
        } else {
            TapEnv.indentPrint(6, "empty");
            TapEnv.println();
        }
    }

    public String toString() {
        String result = "SymbolTable[" + this.addressChain() + "]:" + this.shortName();
        return result;
    }
}

