/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.analysis.ADActivityAnalyzer;
import fr.inria.tapenade.analysis.ADTBRAnalyzer;
import fr.inria.tapenade.analysis.DepsAnalyzer;
import fr.inria.tapenade.analysis.DiffLivenessAnalyzer;
import fr.inria.tapenade.analysis.InOutAnalyzer;
import fr.inria.tapenade.analysis.OmpClauseAnalyzer;
import fr.inria.tapenade.analysis.PointerAnalyzer;
import fr.inria.tapenade.analysis.ReqExplicit;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.InlinedFunctions;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.MixedLanguageInfos;
import fr.inria.tapenade.representation.PositionAndMessage;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TapEnvForThread {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final TapList<TapTriplet<String, String, Tree>> differentiatedIncludeNames = new TapList<Object>(null, null);
    public final OutputStream traceOutputStream = System.out;
    protected final int[] languages = new int[3];
    public String parserFileSeparator;
    protected TapList<MixedLanguageInfos> mixedLangInfos;
    protected int traceLevel = 7;
    protected int msgLevel = 10;
    protected int diffMode = 1;
    public int integerSize = 4;
    public int byteSize = 1;
    public int charSize = 1;
    public int pointerSize = 8;
    public int realSize = 4;
    public int doubleRealSize = 8;
    public int doubleDoubleRealSize = 16;
    public boolean mustTangent;
    public boolean mustAdjoint;
    public boolean multiDirDiffMode;
    public String nbdirsmaxString;
    public Tree nbdirsmaxTree;
    protected boolean valid;
    public String saveCommonName = "/tapenade_save_";
    protected boolean doActivity = true;
    protected boolean doUsefulness = true;
    public boolean spareNoDiffArgs = true;
    protected boolean spareDiffReinitializations = true;
    public boolean splitDiffExpressions = true;
    public boolean mergeDiffInstructions = true;
    public boolean dontSaveUnused = true;
    public boolean doTBR = true;
    public boolean doRecompute = true;
    public boolean removeDeadPrimal = true;
    public boolean removeDeadControl = true;
    public boolean mustContext;
    public boolean oldContext;
    public boolean staticTape;
    public boolean stripDiffTypes = true;
    public boolean stripPrimalCode = true;
    public boolean stripPrimalEvenIfImportsActive;
    public boolean stripPrimalModules = true;
    public boolean profile;
    protected boolean associationByAddress;
    protected String assocAddressValueSuffix = "v";
    protected String assocAddressDiffSuffix = "d";
    protected Unit[] assocAddressDiffTypesUnits = new Unit[3];
    protected int dbadMode;
    public boolean debugPassives;
    public boolean fixInterface;
    public boolean numberPushPops;
    public int pushPopNumber;
    public int inputLanguage = -1;
    public int outputLanguage = -1;
    public String stdLibraryDirectory;
    public String optionsString = "";
    public String diffFileSuffix = "";
    public String preprocessFileSuffix = "_p";
    public String multiFuncSuffix = "v";
    public String suffixF90 = ".f90??";
    public boolean dumps;
    public boolean hasParsingError;
    protected int nextCodeTag;
    protected int nextSourceTag;
    public int nextSourceMsgTag;
    public int nextMessageTag;
    public boolean createStub;
    public TapList<String> dumpUnitNames;
    public boolean dumpCallGraph;
    public boolean dumpSymbolTables;
    public boolean dumpFlowGraphs;
    public boolean dumpZones;
    public boolean dumpDataFlow;
    public boolean dumpDiffSymbolTables;
    public boolean dumpDiffFlowGraphs;
    public boolean dumpPointers;
    public boolean dumpInOut;
    public boolean dumpDeps;
    public boolean traceParser;
    public boolean traceInputIL;
    public TapList<String> traceFlowGraphBuild;
    public TapList<String> traceTypeCheck;
    public TapList<String> tracePointer;
    public TapList<String> traceInOut;
    public TapList<String> traceDeps;
    public TapList<String> traceADDeps;
    public TapList<String> traceActivity;
    public TapList<String> traceReqExplicit;
    public TapList<String> traceDiffLiveness;
    public TapList<String> traceTBR;
    protected boolean doMPI;
    protected boolean doOpenMP;
    protected DepsAnalyzer depsAnalyzer;
    protected InOutAnalyzer inOutAnalyzer;
    protected OmpClauseAnalyzer ompClauseAnalyzer;
    protected ADActivityAnalyzer adActivityAnalyzer;
    protected ADTBRAnalyzer adTbrAnalyzer;
    protected DiffLivenessAnalyzer diffLivenessAnalyzer;
    protected PointerAnalyzer pointerAnalyzer;
    protected ReqExplicit reqExplicitAnalyzer;
    public int newSHdisambiguator = -1;
    public boolean noisize;
    public boolean noisize77;
    public TapList<String> traceDifferentiationUnitNames;
    public TapList<String> traceTreeGenUnitNames;
    public TapList<Unit> srcUnitsToTraceInTreeGen;
    public int traceBlockRk = -99;
    protected String traceCallArrowOriginName = null;
    protected String traceCallArrowDestinationName = null;
    private CallGraph origCallGraph;
    public boolean noComment;
    public TapList<TapPair<SymbolTable, String>> seenSymbolTables;
    public OutputStream dumpOutputStream;
    public OutputStream curOutputStream = System.out;
    public TapList<OutputStream> outputStreamStack = new TapList<PrintStream>(System.out, null);
    protected Unit relatedUnit;
    protected TapList<Unit> relatedUnits = new TapList<Object>(null, null);
    protected int relatedLanguage = -1;
    protected TapList<String> includeDirList;
    protected TapList<String> includeFileList;
    protected Path rootDirectoryPath;
    protected String currentDirectory;
    protected String currentParsedFile;
    public String fortran90LineLength = "132";
    public int fortran90OutputLineLength = 72;
    public String cppCommand;
    public String cppOptions;
    public boolean cppBeforeParsing = true;
    public boolean refineADMM = true;
    public boolean expandAllIncludeFile;
    public boolean expandDiffIncludeFile;
    protected Instruction currentIncludeInstruction;
    public TapList<String> includeFiles;
    protected boolean inIncludeFile;
    protected CallArrow relatedArrow;
    public InlinedFunctions inlinedFunctions = new InlinedFunctions();
    public TapList<String> usedLabels;
    protected int resultRK = 1;
    protected int argRK = 1;
    protected int expRK = 1;
    public int nextNewLabel = 100;
    protected int diffKind = 1;
    protected boolean debugActivity;
    protected TapList<PositionAndMessage> danglingMessages = new TapList<Object>(null, null);
    protected SymbolTable currentTranslationUnitSymbolTable;
    protected int traceIndent;
    protected boolean combineDeclMessagesSwitch = true;
    public boolean absLinearForm;
    protected TapList<Unit> tracedTypeCheckUnits;
    protected boolean traceTypeCheckAnalysis;
    private TapList<PositionAndMessage> nextTreeMessages = new TapList<Object>(null, null);

    public CallGraph origCallGraph() {
        return this.origCallGraph;
    }

    public void setOrigCallGraph(CallGraph cg) {
        this.origCallGraph = cg;
    }

    public final void parserError(String message) {
        this.hasParsingError = true;
        this.emitMessage(-1, null, "File: " + message, 0);
    }

    public final synchronized void emitMessage(int position, Tree tree, String message, int inverseSeverity) {
        TapList<PositionAndMessage> toMessages = this.relatedUnit == null ? this.danglingMessages : this.relatedUnit.messages;
        PositionAndMessage pm = new PositionAndMessage(position, message, tree);
        this.setSourceMessageCorrespondence(tree, pm);
        while (toMessages.tail != null && position > ((PositionAndMessage)toMessages.tail.head).position) {
            toMessages = toMessages.tail;
        }
        boolean messageDejaVu = false;
        while (!messageDejaVu && toMessages.tail != null) {
            PositionAndMessage curpm = (PositionAndMessage)toMessages.tail.head;
            messageDejaVu = position == curpm.position && tree == curpm.tree && message.equals(curpm.message);
            toMessages = toMessages.tail;
        }
        if (!messageDejaVu) {
            if (inverseSeverity <= this.msgLevel) {
                TapEnv.printlnOnTrace(message);
            }
            if (this.curOutputStream != System.out) {
                try {
                    this.curOutputStream.write((message + System.lineSeparator()).getBytes(StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    LOGGER.error("OutputStream for messages broken", (Throwable)e);
                }
            }
            toMessages.tail = new TapList<PositionAndMessage>(pm, toMessages.tail);
            TapEnv.addMessageAnnotation(tree, message);
            if (position == -2) {
                this.nextTreeMessages = new TapList<PositionAndMessage>(pm, this.nextTreeMessages);
            } else if (position >= 0) {
                PositionAndMessage pm1;
                while ((pm1 = (PositionAndMessage)this.nextTreeMessages.head) != null) {
                    pm1.position = position;
                    this.setSourceMessageCorrespondence(tree, pm1);
                    TapEnv.addMessageAnnotation(tree, pm1.message);
                    this.nextTreeMessages = this.nextTreeMessages.tail;
                }
            }
        }
    }

    private void setSourceMessageCorrespondence(Tree source, PositionAndMessage message) {
        if (source != null) {
            TapPair<Object, Object> sourceTags = (TapPair<Object, Object>)source.getAnnotation("toMessageTags");
            TapPair<String, String> messageTags = message.tags;
            if (sourceTags == null) {
                sourceTags = new TapPair<Object, Object>(null, null);
                source.setAnnotation("toMessageTags", sourceTags);
            }
            if (messageTags == null) {
                message.tags = messageTags = new TapPair<Object, Object>(null, null);
            }
            if (sourceTags.second == null) {
                if (messageTags.first == null) {
                    messageTags.first = "p" + this.nextMessageTag;
                    ++this.nextMessageTag;
                }
                sourceTags.second = messageTags.first;
            } else {
                messageTags.first = sourceTags.second;
            }
            if (messageTags.second == null) {
                if (sourceTags.first == null) {
                    sourceTags.first = "p" + this.nextSourceMsgTag;
                    ++this.nextSourceMsgTag;
                }
                messageTags.second = sourceTags.first;
            }
        }
    }

    public final synchronized void flushOutputStream() {
        try {
            this.curOutputStream.flush();
        }
        catch (IOException e) {
            LOGGER.error("OutputStream for messages broken", (Throwable)e);
        }
    }
}

