/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.Int2ZoneInfo;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public final class TapList<T>
implements Iterable<T> {
    public T head;
    public TapList<T> tail;

    public TapList() {
    }

    public TapList(T head, TapList<T> tail) {
        this.head = head;
        this.tail = tail;
    }

    public static <T> int length(TapList<T> list) {
        int result = 0;
        while (list != null) {
            ++result;
            list = list.tail;
        }
        return result;
    }

    public static <T> int lengthWithCycle(TapList<T> list) {
        TapList<TapList<T>> dejaVu = null;
        int result = 0;
        while (list != null) {
            if (TapList.contains(dejaVu, list)) {
                list = null;
                continue;
            }
            dejaVu = new TapList<TapList<T>>(list, dejaVu);
            ++result;
            list = list.tail;
        }
        return result;
    }

    public static <T> TapList<T> addUnlessPresent(TapList<T> list, T obj) {
        if (obj == null) {
            return list;
        }
        TapList<T> inList = list;
        boolean found = false;
        while (!found && inList != null) {
            found = inList.head == obj;
            inList = inList.tail;
        }
        return found ? list : new TapList<T>(obj, list);
    }

    protected static <T> TapList<T> addUnlessPresentEquals(TapList<T> list, T obj) {
        if (obj == null) {
            return list;
        }
        TapList<T> inList = list;
        boolean found = false;
        while (!found && inList != null) {
            found = inList.head.equals(obj);
            inList = inList.tail;
        }
        return found ? list : new TapList<T>(obj, list);
    }

    public static <T> boolean contains(TapList<T> list, T obj) {
        boolean found = false;
        while (!found && list != null) {
            found = list.head == obj;
            list = list.tail;
        }
        return found;
    }

    public static <T> boolean containsEquals(TapList<T> list, T obj) {
        boolean found = false;
        while (!found && list != null) {
            found = obj.equals(list.head);
            list = list.tail;
        }
        return found;
    }

    public static boolean containsString(TapList<String> list, String str, boolean caseSensitive) {
        boolean found = false;
        while (!found && list != null) {
            found = caseSensitive ? ((String)list.head).equals(str) : ((String)list.head).equalsIgnoreCase(str);
            list = list.tail;
        }
        return found;
    }

    public static boolean containsOneOfStrings(TapList<String> list, String[] searched, boolean caseSensitive) {
        boolean found = false;
        for (int i = searched.length - 1; i >= 0 && !found; --i) {
            found = TapList.containsString(list, searched[i], caseSensitive);
        }
        return found;
    }

    public static boolean containsTree(TapList<Tree> list, Tree tree) {
        boolean found = false;
        while (!found && list != null) {
            found = ILUtils.eqOrDisjointRef((Tree)list.head, tree, null, null) == 1;
            list = list.tail;
        }
        return found;
    }

    public static boolean containsTreeEquals(TapList<Tree> list, Tree tree) {
        boolean found = false;
        while (!found && list != null) {
            found = tree.equalsTree((Tree)list.head);
            list = list.tail;
        }
        return found;
    }

    public static boolean intersectTreeEquals(TapList<Tree> list1, TapList<Tree> list2) {
        boolean intersects = false;
        while (!intersects && list1 != null) {
            intersects = TapList.containsTreeEquals(list2, (Tree)list1.head);
            list1 = list1.tail;
        }
        return intersects;
    }

    protected static <T, U> boolean containsObjectPair(TapList<TapPair<T, U>> list, T first, U second) {
        boolean found = false;
        while (!found && list != null) {
            TapPair pair = (TapPair)list.head;
            found = pair.first == first && pair.second == second;
            list = list.tail;
        }
        return found;
    }

    public static boolean containsEqualsObjectPair(TapList<TapPair<Unit, String>> list, Unit first, String second) {
        boolean found = false;
        while (!found && list != null) {
            TapPair pair = (TapPair)list.head;
            found = pair.first == first && ((String)pair.second).equals(second);
            list = list.tail;
        }
        return found;
    }

    public static boolean containsStartVars(TapList<VariableDecl> list, TapTriplet<VariableDecl, SymbolTable, Tree> obj) {
        boolean found = false;
        while (!found && list != null) {
            found = list.head == obj.first;
            list = list.tail;
        }
        return found;
    }

    public static boolean containsVariableDecl(TapList<SymbolDecl> list, VariableDecl varDecl) {
        boolean found = false;
        while (!found && list != null) {
            found = list.head != null && ((SymbolDecl)list.head).isA(1) && varDecl.equalsOther((VariableDecl)list.head);
            list = list.tail;
        }
        return found;
    }

    public static boolean containsSameNameSymbolDecl(TapList<SymbolDecl> list, SymbolDecl symbolDecl) {
        boolean found = false;
        while (!found && list != null) {
            found = list.head != null && symbolDecl.symbol.equals(((SymbolDecl)list.head).symbol);
            list = list.tail;
        }
        return found;
    }

    public static WrapperTypeSpec findTypeSpec(TapList<TypeSpec> list, WrapperTypeSpec typeSpec) {
        WrapperTypeSpec found = null;
        while (found == null && list != null) {
            if (list.head != null && typeSpec.equalsLiterally((TypeSpec)list.head)) {
                found = (WrapperTypeSpec)list.head;
            }
            list = list.tail;
        }
        return found;
    }

    public static SymbolDecl findNamedSymbolDecl(TapList<SymbolDecl> list, String name) {
        SymbolDecl found = null;
        while (found == null && list != null) {
            if (list.head != null && name.equals(((SymbolDecl)list.head).symbol)) {
                found = (SymbolDecl)list.head;
            }
            list = list.tail;
        }
        return found;
    }

    public static <T> void replace(TapList<T> list, T from, T to) {
        while (list != null) {
            if (list.head == from) {
                list.head = to;
            }
            list = list.tail;
        }
    }

    public static <T, U> TapPair<T, U> assq(T key, TapList<TapPair<T, U>> list) {
        TapPair found = null;
        while (found == null && list != null) {
            if (list.head != null && ((TapPair)list.head).first == key) {
                found = (TapPair)list.head;
            }
            list = list.tail;
        }
        return found;
    }

    public static <T, U> U cassq(T key, TapList<TapPair<T, U>> list) {
        TapPair<T, U> found = TapList.assq(key, list);
        return found == null ? null : (U)found.second;
    }

    public static <T, U> TapPair<T, U> rassq(U value, TapList<TapPair<T, U>> list) {
        TapPair found = null;
        while (found == null && list != null) {
            if (list.head != null && ((TapPair)list.head).second == value) {
                found = (TapPair)list.head;
            }
            list = list.tail;
        }
        return found;
    }

    public static <T> TapPair<TapIntList, T> assqOne(int key, TapList<TapPair<TapIntList, T>> list) {
        TapPair found = null;
        while (found == null && list != null) {
            if (list.head != null && ((TapIntList)((TapPair)list.head).first).head == key) {
                found = (TapPair)list.head;
            }
            list = list.tail;
        }
        return found;
    }

    public static TapPair<Tree, Tree> assqTree(Tree tree, TapList<TapPair<Tree, Tree>> list) {
        while (list != null && !((Tree)((TapPair)list.head).first).equalsTree(tree)) {
            list = list.tail;
        }
        return list == null ? null : (TapPair)list.head;
    }

    public static <T> TapPair<String, T> assqString(String string, TapList<TapPair<String, T>> list) {
        while (list != null && !((String)((TapPair)list.head).first).equals(string)) {
            list = list.tail;
        }
        return list == null ? null : (TapPair)list.head;
    }

    public static <T> T cassqString(String string, TapList<TapPair<String, T>> list) {
        TapPair<String, T> found = TapList.assqString(string, list);
        return found == null ? null : (T)found.second;
    }

    public static TapPair<String, String> rassqString(String string, TapList<TapPair<String, String>> list) {
        while (list != null && !((String)((TapPair)list.head).second).equals(string)) {
            list = list.tail;
        }
        return list == null ? null : (TapPair)list.head;
    }

    public static <T, U> TapTriplet<String, T, U> assqStringInTriplet(String string, TapList<TapTriplet<String, T, U>> list) {
        while (list != null && !((String)((TapTriplet)list.head).first).equals(string)) {
            list = list.tail;
        }
        return list == null ? null : (TapTriplet)list.head;
    }

    public static Int2ZoneInfo assq(int key, TapList<Int2ZoneInfo> list) {
        Int2ZoneInfo found = null;
        while (found == null && list != null) {
            if (list.head != null && ((Int2ZoneInfo)list.head).getZoneNumber() == key) {
                found = (Int2ZoneInfo)list.head;
            }
            list = list.tail;
        }
        return found;
    }

    public static ZoneInfo cassq(int key, TapList<Int2ZoneInfo> list) {
        Int2ZoneInfo found = TapList.assq(key, list);
        return found == null ? null : found.getZoneInfo();
    }

    public static Object nth(TapList<?> list, int rank) {
        while (list != null && rank != 0) {
            --rank;
            list = list.tail;
        }
        return list == null ? null : list.head;
    }

    public static <T> TapList<T> deleteAll(TapList<T> delList, TapList<T> list) {
        TapList<Object> toResult;
        TapList<Object> inResult = toResult = new TapList<Object>(null, list);
        while (inResult.tail != null) {
            if (TapList.contains(delList, inResult.tail.head)) {
                inResult.tail = inResult.tail.tail;
                continue;
            }
            inResult = inResult.tail;
        }
        return toResult.tail;
    }

    public static <T> TapList<T> deleteNth(TapList<T> list, int n) {
        TapList<Object> hdResult;
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        while (list != null) {
            if (n <= 0) {
                tlResult.tail = list.tail;
                list = null;
                continue;
            }
            tlResult = tlResult.placdl(list.head);
            --n;
            list = list.tail;
        }
        return hdResult.tail;
    }

    public static TapList<TapTriplet<VariableDecl, SymbolTable, Tree>> deleteAllStartVars(TapList<VariableDecl> delList, TapList<TapTriplet<VariableDecl, SymbolTable, Tree>> list) {
        TapList<TapTriplet<VariableDecl, SymbolTable, Tree>> toResult;
        TapList<TapTriplet<VariableDecl, SymbolTable, Tree>> inResult = toResult = new TapList<TapTriplet<VariableDecl, SymbolTable, Tree>>(null, list);
        while (inResult.tail != null) {
            if (TapList.containsStartVars(delList, (TapTriplet)inResult.tail.head)) {
                inResult.tail = inResult.tail.tail;
                continue;
            }
            inResult = inResult.tail;
        }
        return toResult.tail;
    }

    public static <T> TapList<T> delete(T delElem, TapList<T> list) {
        TapList<Object> toResult;
        TapList<Object> inResult = toResult = new TapList<Object>(null, list);
        while (inResult.tail != null) {
            if (inResult.tail.head == delElem) {
                inResult.tail = inResult.tail.tail;
                continue;
            }
            inResult = inResult.tail;
        }
        return toResult.tail;
    }

    public static TapList<String> deleteString(String delElem, TapList<String> list) {
        TapList<String> toResult;
        TapList<String> inResult = toResult = new TapList<String>(null, list);
        while (inResult.tail != null) {
            if (inResult.tail.head != null && ((String)inResult.tail.head).equals(delElem)) {
                inResult.tail = inResult.tail.tail;
                continue;
            }
            inResult = inResult.tail;
        }
        return toResult.tail;
    }

    public static TapList<String> deleteContainsString(String delElem, TapList<String> list) {
        TapList<String> toResult;
        TapList<String> inResult = toResult = new TapList<String>(null, list);
        while (inResult.tail != null) {
            if (inResult.tail.head != null && ((String)inResult.tail.head).startsWith(delElem)) {
                inResult.tail = inResult.tail.tail;
                continue;
            }
            inResult = inResult.tail;
        }
        return toResult.tail;
    }

    public static <T> TapList<T> append(TapList<T> list1, TapList<T> list2) {
        TapList<Object> res;
        if (list1 == null) {
            return list2;
        }
        TapList<Object> inRes = res = new TapList<Object>(null, list2);
        while (list1 != null) {
            inRes = inRes.placdl(list1.head);
            list1 = list1.tail;
        }
        return res.tail;
    }

    public static <T> TapList<T> prependNoDups(TapList<T> newElems, TapList<T> oldList) {
        while (newElems != null) {
            if (!TapList.contains(oldList, newElems.head)) {
                oldList = new TapList<T>(newElems.head, oldList);
            }
            newElems = newElems.tail;
        }
        return oldList;
    }

    public static <T> TapList<T> addAll(TapList<T> list1, TapList<T> list2) {
        TapList<T> result = TapList.append(list2, null);
        while (list1 != null) {
            if (!TapList.contains(result, list1.head)) {
                result = new TapList<T>(list1.head, result);
            }
            list1 = list1.tail;
        }
        return result;
    }

    public static <T> TapList<T> union(TapList<T> list1, TapList<T> list2) {
        TapList<Object> toResult = new TapList<Object>(null, list1);
        while (list2 != null) {
            TapList<Object> inResult = toResult;
            while (inResult != null && inResult.tail != null) {
                if (inResult.tail.head == list2.head) {
                    inResult = null;
                    continue;
                }
                inResult = inResult.tail;
            }
            if (inResult != null) {
                inResult.placdl(list2.head);
            }
            list2 = list2.tail;
        }
        return toResult.tail;
    }

    public static TapList<String> unionString(TapList<String> list1, TapList<String> list2) {
        TapList<String> toResult = new TapList<String>(null, list1);
        while (list2 != null) {
            TapList<String> inResult = toResult;
            while (inResult != null && inResult.tail != null) {
                if (((String)inResult.tail.head).equals(list2.head)) {
                    inResult = null;
                    continue;
                }
                inResult = inResult.tail;
            }
            if (inResult != null) {
                inResult.placdl((String)list2.head);
            }
            list2 = list2.tail;
        }
        return toResult.tail;
    }

    public static <T> T last(TapList<T> list) {
        if (list == null) {
            return null;
        }
        while (list.tail != null) {
            list = list.tail;
        }
        return list.head;
    }

    public static <T> TapList<T> toLast(TapList<T> list) {
        if (list == null) {
            return null;
        }
        while (list.tail != null) {
            list = list.tail;
        }
        return list;
    }

    public static <T> TapList<T> removeLast(TapList<T> list) {
        if (list == null || list.tail == null) {
            return null;
        }
        TapList<T> toTail = list;
        while (toTail.tail.tail != null) {
            toTail = toTail.tail;
        }
        toTail.tail = null;
        return list;
    }

    public static <T> TapList<T> addLast(TapList<T> list, T object) {
        if (list == null) {
            list = new TapList<T>(object, null);
        } else {
            TapList.toLast(list).tail = new TapList<T>(object, null);
        }
        return list;
    }

    public static TapList<Instruction>[] split(TapList<Instruction> list, TapIntList listRank) {
        int len = TapIntList.length(listRank);
        TapList[] resultList = new TapList[2 * len + 1];
        int i = 0;
        int position = 0;
        while (listRank != null && list != null) {
            TapList result1 = null;
            int rank = listRank.head;
            while (list != null && i < rank) {
                result1 = TapList.append(result1, new TapList(list.head, null));
                list = list.tail;
                ++i;
            }
            resultList[position] = result1;
            assert (list != null);
            resultList[position + 1] = new TapList(list.head, null);
            listRank = listRank.tail;
            position += 2;
            list = list.tail;
            ++i;
        }
        resultList[position] = list;
        return resultList;
    }

    public static <T> TapList<T> reverse(TapList<T> list) {
        TapList<T> result = null;
        while (list != null) {
            result = new TapList<T>(list.head, result);
            list = list.tail;
        }
        return result;
    }

    public static <T> TapList<T> nreverse(TapList<T> list) {
        TapList<T> result = null;
        while (list != null) {
            TapList<T> tmp = list.tail;
            list.tail = result;
            result = list;
            list = tmp;
        }
        return result;
    }

    public static <T> TapList<T> unique(TapList<T> list) {
        TapList<Object> result;
        TapList<Object> tail = result = new TapList<Object>(null, null);
        while (list != null) {
            if (!TapList.contains(result, list.head)) {
                tail = tail.placdl(list.head);
            }
            list = list.tail;
        }
        return result.tail;
    }

    public static <T> TapList<T> fromObjectArray(T[] array) {
        TapList<T> list = null;
        if (array != null) {
            for (int i = array.length - 1; i >= 0; --i) {
                list = new TapList<T>(array[i], list);
            }
        }
        return list;
    }

    public static TapList<String> cleanExtraInfoValue(TapList<String> extraInfo, String lcValue) {
        TapList<String> toExtraInfo;
        TapList<String> inExtraInfo = toExtraInfo = new TapList<String>(null, extraInfo);
        while (inExtraInfo.tail != null) {
            String infoString = (String)inExtraInfo.tail.head;
            if (infoString != null && infoString.equalsIgnoreCase(lcValue)) {
                inExtraInfo.tail = inExtraInfo.tail.tail;
                continue;
            }
            inExtraInfo = inExtraInfo.tail;
        }
        return toExtraInfo.tail;
    }

    public static TapList<String> exchangeExtraInfoValue(TapList<String> extraInfo, String lcValue1, String lcValue2) {
        TapList<String> toExtraInfo;
        TapList<String> inExtraInfo = toExtraInfo = new TapList<String>(null, extraInfo);
        String foundValue = null;
        while (inExtraInfo.tail != null) {
            String infoString = (String)inExtraInfo.tail.head;
            if (infoString != null && (infoString.toLowerCase().equals(lcValue1) || infoString.toLowerCase().equals(lcValue2))) {
                inExtraInfo.tail = inExtraInfo.tail.tail;
                foundValue = infoString.toLowerCase();
                continue;
            }
            inExtraInfo = inExtraInfo.tail;
        }
        if (foundValue != null) {
            if (foundValue.equals(lcValue1)) {
                toExtraInfo.tail = new TapList<String>(lcValue2, toExtraInfo.tail);
            } else if (foundValue.equals(lcValue2)) {
                toExtraInfo.tail = new TapList<String>(lcValue1, toExtraInfo.tail);
            }
        }
        return toExtraInfo.tail;
    }

    protected static boolean equalsImportedModules(TapList<Tree> l1, TapList<Tree> l2) {
        boolean result;
        boolean bl = result = TapList.length(l1) == TapList.length(l2);
        if (result) {
            while (l1 != null && l2 != null && result) {
                result = ((Tree)l1.head).equalsTree((Tree)l2.head);
                l1 = l1.tail;
                l2 = l2.tail;
            }
        }
        return result;
    }

    public static TapList<String> parseIdentifier(String ident) {
        TapList<Object> hdParsed;
        StringTokenizer identTokenizer = new StringTokenizer(ident, ".%");
        TapList<Object> tlParsed = hdParsed = new TapList<Object>(null, null);
        while (identTokenizer.hasMoreElements()) {
            String varNameOptStar = identTokenizer.nextToken();
            int derefLevel = 0;
            while (!varNameOptStar.isEmpty() && varNameOptStar.charAt(varNameOptStar.length() - 1) == '*') {
                ++derefLevel;
                varNameOptStar = varNameOptStar.substring(0, varNameOptStar.length() - 1);
            }
            tlParsed = tlParsed.placdl(varNameOptStar);
            while (derefLevel != 0) {
                tlParsed = tlParsed.placdl("*");
                --derefLevel;
            }
        }
        return hdParsed.tail;
    }

    public static TapList<?> copyTree(TapList<?> model) {
        return TapList.copyTreeRec(model, new TapList<Object>(null, null));
    }

    private static TapList<?> copyTreeRec(TapList<?> model, TapList<TapPair<TapList<?>, TapList<?>>> dejaVu) {
        TapList<Object> toResult;
        TapList<Object> inResult = toResult = new TapList<Object>(null, null);
        while (model != null) {
            TapPair foundDejaVu = TapList.assq(model, dejaVu);
            if (foundDejaVu != null) {
                inResult.tail = (TapList)foundDejaVu.second;
                model = null;
                continue;
            }
            inResult.tail = new TapList<Object>(null, null);
            inResult = inResult.tail;
            dejaVu.placdl(new TapPair(model, inResult));
            if (model.head != null) {
                inResult.head = model.head instanceof TapList ? TapList.copyTreeRec((TapList)model.head, dejaVu) : (model.head instanceof TapIntList ? TapIntList.copy((TapIntList)model.head) : (model.head instanceof ToBool ? new ToBool(((ToBool)model.head).get()) : model.head));
            }
            model = model.tail;
        }
        return toResult.tail;
    }

    private static Object copyLeaf(Object leaf) {
        if (leaf instanceof TapIntList) {
            return TapIntList.copy((TapIntList)leaf);
        }
        if (leaf instanceof ToBool) {
            return new ToBool(((ToBool)leaf).get());
        }
        if (leaf instanceof BoolVector) {
            return ((BoolVector)leaf).copy();
        }
        return leaf;
    }

    public static TapList<?> copyTreeNoPointed(TapList<?> model) {
        if (model == null) {
            return null;
        }
        if (model.head instanceof TapList) {
            TapList<Object> hdCopy;
            TapList<Object> tlCopy = hdCopy = new TapList<Object>(null, null);
            while (model != null) {
                tlCopy = tlCopy.placdl(TapList.copyTreeNoPointed((TapList)model.head));
                model = model.tail;
            }
            return hdCopy.tail;
        }
        return new TapList(model.head, null);
    }

    public static TapList<?> getSetFieldLocation(TapList infoTree, Tree accessTree, boolean createIfAbsent) {
        if (accessTree == null) {
            return infoTree;
        }
        switch (accessTree.opCode()) {
            case 3: 
            case 4: 
            case 8: 
            case 70: {
                return TapList.getSetFieldLocation(infoTree, accessTree.down(1), createIfAbsent);
            }
            case 73: {
                infoTree = TapList.getSetFieldLocation(infoTree, accessTree.down(1), createIfAbsent);
                int fieldRank = ILUtils.getFieldRank(accessTree.down(2));
                Object resObj = TapList.nth(infoTree, fieldRank);
                if (resObj instanceof TapList) {
                    return (TapList)resObj;
                }
                if (createIfAbsent && infoTree != null) {
                    Boolean previousBool = null;
                    if (infoTree.head instanceof Boolean) {
                        previousBool = (Boolean)infoTree.head;
                        infoTree.head = new TapList<Boolean>(previousBool, null);
                    } else if (infoTree.head == null) {
                        infoTree.head = new TapList<Object>(null, null);
                    }
                    while (fieldRank > 0) {
                        if (infoTree.tail == null) {
                            infoTree.tail = new TapList<TapList<Boolean>>(new TapList<Boolean>(previousBool, null), null);
                        }
                        infoTree = infoTree.tail;
                        --fieldRank;
                    }
                    if (!(infoTree.head instanceof TapList)) {
                        infoTree.head = new TapList<Object>(null, null);
                    }
                    return (TapList)infoTree.head;
                }
                return infoTree;
            }
            case 148: {
                infoTree = TapList.getSetFieldLocation(infoTree, accessTree.down(1), createIfAbsent);
                if (infoTree == null) {
                    return null;
                }
                if (infoTree.tail == null && createIfAbsent) {
                    infoTree.tail = new TapList<Object>(null, null);
                }
                return infoTree.tail;
            }
            case 94: 
            case 136: {
                return infoTree;
            }
        }
        TapEnv.printlnOnTrace("Tool: (getSetFieldLocation) Unexpected operator: " + accessTree.opName());
        return infoTree;
    }

    public static boolean allSingletonLeaves(TapList<?> tree) {
        return TapList.allSingletonLeavesRec(tree, new TapList<Object>(null, null));
    }

    private static boolean allSingletonLeavesRec(TapList<?> tree, TapList<TapList<?>> dejaVu) {
        boolean result = true;
        while (result && tree != null) {
            if (TapList.contains(dejaVu.tail, tree)) {
                tree = null;
                continue;
            }
            dejaVu.placdl(tree);
            if (tree.head != null) {
                if (tree.head instanceof TapList) {
                    result = TapList.allSingletonLeavesRec((TapList)tree.head, dejaVu);
                } else if (((TapIntList)tree.head).tail != null) {
                    result = false;
                }
            }
            tree = tree.tail;
        }
        return result;
    }

    public static boolean oneNonSingleton(TapList<?> boolsTree) {
        return TapList.oneNonSingletonRec(boolsTree, new TapList<Object>(null, null));
    }

    private static boolean oneNonSingletonRec(TapList<?> boolsTree, TapList<TapList<?>> dejaVu) {
        boolean found = false;
        while (!found && boolsTree != null) {
            if (TapList.contains(dejaVu.tail, boolsTree)) {
                boolsTree = null;
                continue;
            }
            dejaVu.placdl(boolsTree);
            if (boolsTree.head instanceof TapList) {
                found = TapList.oneNonSingletonRec((TapList)boolsTree.head, dejaVu);
            } else if (boolsTree.head == null || boolsTree.head instanceof TapIntList) {
                found = boolsTree.head == null || ((TapIntList)boolsTree.head).tail != null;
            }
            boolsTree = boolsTree.tail;
        }
        return found;
    }

    public static boolean trueForAll(TapList<?> boolsTree) {
        return boolsTree != null && boolsTree.tail == null && boolsTree.head instanceof Boolean && (Boolean)boolsTree.head != false;
    }

    public static boolean oneTrueInHead(TapList<?> boolsTree) {
        return boolsTree != null && TapList.oneTrue(new TapList<Object>(null, new TapList(boolsTree.head, null)));
    }

    public static boolean oneTrue(TapList<?> boolsTree) {
        return TapList.oneTrueRec(boolsTree, new TapList<Object>(null, null));
    }

    private static boolean oneTrueRec(TapList<?> boolsTree, TapList<TapList<?>> dejaVu) {
        boolean found = false;
        while (!found && boolsTree != null) {
            if (TapList.contains(dejaVu.tail, boolsTree)) {
                boolsTree = null;
                continue;
            }
            dejaVu.placdl(boolsTree);
            if (boolsTree.head instanceof TapList) {
                found = TapList.oneTrueRec((TapList)boolsTree.head, dejaVu);
            } else if (boolsTree.head instanceof Boolean) {
                found = (Boolean)boolsTree.head;
            }
            boolsTree = boolsTree.tail;
        }
        return found;
    }

    public static boolean oneFalse(TapList<?> boolsTree) {
        return TapList.oneFalseRec(boolsTree, new TapList<Object>(null, null));
    }

    private static boolean oneFalseRec(TapList<?> boolsTree, TapList<TapList<?>> dejaVu) {
        boolean found = false;
        while (!found && boolsTree != null) {
            if (TapList.contains(dejaVu.tail, boolsTree)) {
                boolsTree = null;
                continue;
            }
            dejaVu.placdl(boolsTree);
            found = boolsTree.head instanceof TapList ? TapList.oneFalseRec((TapList)boolsTree.head, dejaVu) : (boolsTree.head instanceof Boolean ? (Boolean)boolsTree.head == false : true);
            boolsTree = boolsTree.tail;
        }
        return found;
    }

    public static TapList<?> cumulWithOper(TapList<?> target, Object added, int oper) {
        return TapList.cumulWithOperRec(target, added, oper, null, new TapList<Object>(null, null));
    }

    private static TapList<?> cumulWithOperRec(TapList<?> target, Object added, int oper, TapList<TapList> dejaVuTarget, TapList<TapPair<Object, TapList>> dejaVuAdded) {
        TapList<Object> hdTarget;
        if (target != null) {
            if (TapList.contains(dejaVuTarget, target)) {
                return target;
            }
            dejaVuTarget = new TapList<TapList>(target, dejaVuTarget);
        }
        TapList<Object> toTarget = hdTarget = new TapList<Object>(null, target);
        while (added != null) {
            TapPair foundDejaVuAdded = TapList.assq(added, dejaVuAdded.tail);
            if (foundDejaVuAdded != null) {
                toTarget.tail = (TapList)foundDejaVuAdded.second;
                added = null;
                continue;
            }
            if (added instanceof TapList) {
                int i;
                TapList addedL = added;
                if (toTarget.tail == null) {
                    toTarget.tail = new TapList<Object>(null, null);
                } else {
                    dejaVuAdded.placdl(new TapPair(added, toTarget.tail));
                }
                TapList<Object> addedHeadL = null;
                if (addedL.head instanceof TapList && !(toTarget.tail.head instanceof TapList)) {
                    addedHeadL = (TapList<Object>)addedL.head;
                    Object leafToExpand = toTarget.tail.head;
                    TapList<Object> expandedTarget = null;
                    for (i = TapList.length(addedHeadL); i > 0; --i) {
                        expandedTarget = new TapList<Object>(TapList.copyLeaf(leafToExpand), expandedTarget);
                    }
                    toTarget.tail.head = expandedTarget;
                } else if (!(addedL.head instanceof TapList) && toTarget.tail.head instanceof TapList) {
                    addedHeadL = null;
                    for (i = TapList.length((TapList)toTarget.tail.head); i > 0; --i) {
                        addedHeadL = new TapList<Object>(TapList.copyLeaf(addedL.head), addedHeadL);
                    }
                } else if (addedL.head instanceof TapList) {
                    addedHeadL = (TapList)addedL.head;
                }
                toTarget.tail.head = toTarget.tail.head instanceof TapList ? TapList.cumulWithOperRec((TapList)toTarget.tail.head, addedHeadL, oper, dejaVuTarget, dejaVuAdded) : TapList.cumulLeavesWithOper(toTarget.tail.head, addedL.head, oper);
                toTarget = toTarget.tail;
                added = addedL.tail;
                continue;
            }
            if (toTarget.tail == null) {
                added = null;
            } else {
                toTarget.tail.head = toTarget.tail.head instanceof TapList ? TapList.cumulWithOperRec((TapList)toTarget.tail.head, added, oper, dejaVuTarget, dejaVuAdded) : TapList.cumulLeavesWithOper(toTarget.tail.head, added, oper);
            }
            toTarget = toTarget.tail;
        }
        return hdTarget.tail;
    }

    private static Object cumulLeavesWithOper(Object target, Object added, int oper) {
        if (added == null) {
            return target;
        }
        if (added instanceof TapIntList) {
            if (target == null) {
                if (oper != 93) {
                    target = TapIntList.copy((TapIntList)added);
                }
            } else if (oper == 91) {
                target = TapIntList.quickUnion((TapIntList)target, (TapIntList)added);
            } else if (oper == 92) {
                target = TapIntList.intersection((TapIntList)target, (TapIntList)added);
            } else if (oper == 93) {
                target = TapIntList.minus((TapIntList)target, (TapIntList)added);
            }
        } else if (added instanceof ToBool) {
            if (target == null) {
                target = oper == 93 ? new ToBool(!((ToBool)added).get()) : new ToBool(((ToBool)added).get());
            } else if (oper == 91) {
                if (((ToBool)added).get()) {
                    target = new ToBool(true);
                }
            } else if (oper == 92) {
                if (!((ToBool)added).get()) {
                    target = new ToBool(false);
                }
            } else if (oper == 93 && ((ToBool)added).get()) {
                target = new ToBool(false);
            }
        } else if (added instanceof Boolean) {
            if (target == null) {
                target = oper == 93 ? ((Boolean)added != false ? Boolean.FALSE : Boolean.TRUE) : added;
            } else if (oper == 91) {
                if (((Boolean)added).booleanValue()) {
                    target = Boolean.TRUE;
                }
            } else if (oper == 92) {
                if (!((Boolean)added).booleanValue()) {
                    target = Boolean.FALSE;
                }
            } else if (oper == 93 && ((Boolean)added).booleanValue()) {
                target = Boolean.FALSE;
            }
        } else if (added instanceof BoolVector) {
            if (target == null) {
                target = oper == 93 ? ((BoolVector)added).not() : ((BoolVector)added).copy();
            } else if (oper == 91) {
                ((BoolVector)target).cumulOr((BoolVector)added);
            } else if (oper == 92) {
                ((BoolVector)target).cumulAnd((BoolVector)added);
            } else if (oper == 93) {
                ((BoolVector)target).cumulMinus((BoolVector)added);
            }
        } else {
            TapEnv.printlnOnTrace("Tool: (Cumul Info trees) class not implemented:" + added);
        }
        return target;
    }

    public static void replaceIntsWithValueInts(TapList zonesTree, int[] values, int offset) {
        while (zonesTree != null) {
            if (zonesTree.head instanceof TapList) {
                TapList.replaceIntsWithValueInts((TapList)zonesTree.head, values, offset);
            } else {
                TapIntList zonesList = (TapIntList)zonesTree.head;
                while (zonesList != null) {
                    zonesList.head = values[zonesList.head + offset];
                    zonesList = zonesList.tail;
                }
            }
            zonesTree = zonesTree.tail;
        }
    }

    public static void addIntoLeaves(TapList zonesTree, TapIntList newInts) {
        while (zonesTree != null) {
            if (zonesTree.head instanceof TapList) {
                TapList.addIntoLeaves((TapList)zonesTree.head, newInts);
            } else {
                zonesTree.head = TapIntList.quickUnion((TapIntList)zonesTree.head, newInts);
            }
            zonesTree = zonesTree.tail;
        }
    }

    public TapList<T> placdl(T obj) {
        this.tail = new TapList<T>(obj, this.tail);
        return this.tail;
    }

    public int rank(Object obj) {
        int rank = 0;
        TapList<T> inList = this;
        while (inList != null && inList.head != obj) {
            ++rank;
            inList = inList.tail;
        }
        return inList == null ? -1 : rank;
    }

    public int rankString(String str) {
        int rank = 0;
        TapList<T> inList = this;
        while (inList != null && !inList.head.equals(str)) {
            ++rank;
            inList = inList.tail;
        }
        return inList == null ? -1 : rank;
    }

    public void newR(T object) {
        TapList<T> inList = this;
        while (inList.tail != null) {
            inList = inList.tail;
        }
        inList.tail = new TapList<T>(object, null);
    }

    public TapList<TapPair<Unit, Tree>> findExtraInfos(Unit unit) {
        TapList<T> result = null;
        TapList<TapPair<Unit, Tree>> tmpInfo = this.findExtraInfo(unit);
        if (tmpInfo != null) {
            result = new TapList<T>(tmpInfo.head, null);
            while (tmpInfo != null) {
                tmpInfo = tmpInfo.tail;
                if (tmpInfo == null || (tmpInfo = super.findExtraInfo(unit)) == null) continue;
                result = TapList.append(result, new TapList<T>(tmpInfo.head, null));
            }
        }
        return result;
    }

    private TapList<TapPair<Unit, Tree>> findExtraInfo(Unit unit) {
        boolean found;
        TapList<T> tmpInfo = this;
        boolean bl = found = ((TapPair)tmpInfo.head).first == unit;
        while (tmpInfo.tail != null && !found) {
            found = ((TapPair)tmpInfo.tail.head).first == unit;
            tmpInfo = tmpInfo.tail;
        }
        if (!found) {
            tmpInfo = null;
        }
        return tmpInfo;
    }

    @Override
    public Iterator<T> iterator() {
        TapListIterator iter = new TapListIterator();
        iter.current = this;
        return iter;
    }

    public void dump() throws IOException {
        TapEnv.print(this.toStringRec(null, null, new TapList<Object>(null, null)));
    }

    public String toString() {
        int dagSize = this.dagSize(new TapList<Object>(null, null));
        if (dagSize > 150) {
            return "enormousDag:" + dagSize;
        }
        return this.toStringRec(null, null, new TapList<Object>(null, null));
    }

    public String toString(Object info) {
        return this.toStringRec(info, null, new TapList<Object>(null, null));
    }

    private String toStringRec(Object info, TapList<TapList> dejaVuSeeing, TapList<TapList> dejaVuSeen) {
        int cycleRank = dejaVuSeeing == null ? -1 : dejaVuSeeing.rank(this);
        if (cycleRank != -1) {
            return "CYCLE-" + (cycleRank + 1);
        }
        int dagRank = dejaVuSeen.rank(this);
        if (dagRank != -1) {
            return "DAG-" + dagRank;
        }
        TapList<T> listTail = this;
        String result = null;
        cycleRank = -1;
        dagRank = -1;
        while (listTail != null && (cycleRank = dejaVuSeeing == null ? -1 : dejaVuSeeing.rank(listTail)) == -1 && (dagRank = dejaVuSeen.rank(listTail)) == -1) {
            result = result == null ? "(" : result + " ";
            dejaVuSeeing = new TapList<TapList>(listTail, dejaVuSeeing);
            result = listTail.head instanceof TapList ? result + ((TapList)listTail.head).toStringRec(info, dejaVuSeeing, dejaVuSeen) : (listTail.head instanceof Tree ? result + ILUtils.toString((Tree)listTail.head) : (listTail.head instanceof BoolVector ? (info == null ? result + listTail.head : result + ((BoolVector)listTail.head).toString((int[])info)) : result + listTail.head));
            listTail = listTail.tail;
        }
        if (listTail != null) {
            result = cycleRank != -1 ? result + " . CYCLE-" + (cycleRank + 1) : (dagRank != -1 ? result + " . DAG-" + dagRank : result + " . " + listTail);
        }
        result = result + ')';
        dejaVuSeen.newR(this);
        if (this.head instanceof TapList && this.tail != null) {
            dejaVuSeen.newR(this.tail);
        }
        return result;
    }

    public int dagSize(TapList<TapList> dejaVu) {
        TapList<T> listTail = this;
        int result = 0;
        while (listTail != null && !TapList.contains(dejaVu.tail, listTail)) {
            dejaVu.placdl(listTail);
            result = listTail.head instanceof TapList ? (result += ((TapList)listTail.head).dagSize(dejaVu)) : ++result;
            listTail = listTail.tail;
        }
        if (listTail != null) {
            ++result;
        }
        return result;
    }

    public void setAll(boolean value) {
        TapList<T> objTree = this;
        while (objTree != null) {
            if (objTree.head instanceof TapList) {
                ((TapList)objTree.head).setAll(value);
                objTree = objTree.tail;
                continue;
            }
            objTree.head = value;
            objTree = null;
        }
    }

    private static class TapListIterator<T>
    implements Iterator<T> {
        private TapList<T> current;

        private TapListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public T next() {
            if (this.current == null) {
                throw new NoSuchElementException("TapListIterator");
            }
            Object object = this.current.head;
            this.current = this.current.tail;
            return object;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

