/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class TypeDecl
extends SymbolDecl {
    public WrapperTypeSpec typeSpec;

    public TypeDecl(Tree identTree, WrapperTypeSpec typeSpec) {
        super(identTree, 4);
        this.typeSpec = typeSpec;
        this.setTypeDeclName(this.symbol);
    }

    public TypeDecl(String name, WrapperTypeSpec typeSpec) {
        super(name, 4);
        this.typeSpec = typeSpec;
        this.setTypeDeclName(this.symbol);
    }

    public TypeDecl(Tree identTree, WrapperTypeSpec typeSpec, Unit inUnit) {
        super(identTree, 4);
        this.typeSpec = typeSpec;
        this.setTypeDeclName(this.symbol, inUnit);
    }

    public static TypeDecl findTypeDecl(TapList<SymbolDecl> dependsOn) {
        TypeDecl result = null;
        while (dependsOn != null && result == null) {
            SymbolDecl symbolDecl = (SymbolDecl)dependsOn.head;
            if (symbolDecl != null && symbolDecl.kind == 4) {
                result = (TypeDecl)symbolDecl;
            }
            dependsOn = dependsOn.tail;
        }
        return result;
    }

    public void setTypeDeclName(String name, Unit inUnit) {
        if (this.typeSpec.wrappedType != null) {
            this.typeSpec.wrappedType.addInTypeDeclNames(inUnit, name);
        }
    }

    public String getTypeDeclName() {
        if (this.typeSpec.wrappedType != null) {
            return this.typeSpec.wrappedType.typeDeclName();
        }
        return null;
    }

    public void setTypeDeclName(String name) {
        String oldName;
        if (this.typeSpec.wrappedType != null && TypeSpec.ignoreTypeDeclName(oldName = this.typeSpec.wrappedType.typeDeclName())) {
            this.typeSpec.wrappedType.setTypeDeclName(name);
        }
    }

    public TypeDecl activeTypeDecl(SymbolTable diffSymbolTable, WrapperTypeSpec activeTypeSpec, String fSuffix, int maxDiffSorts) {
        TypeDecl diffTypeDecl = null;
        String origTypeName = this.symbol;
        if (TypeSpec.isA(this.typeSpec, 21) || TapEnv.associationByAddress()) {
            if (this.getDiffSymbolHolder(0, null) == null && activeTypeSpec != null) {
                SymbolTable basisSymbolTable = diffSymbolTable;
                if (TapEnv.associationByAddress() && diffSymbolTable != null && this.typeSpec.isScalar()) {
                    basisSymbolTable = diffSymbolTable.findAssocAddresTypeDeclSymbolTable();
                }
                NewSymbolHolder diffSymbolHolder = new NewSymbolHolder(TapEnv.extendStringWithSuffix(origTypeName, fSuffix));
                diffSymbolHolder.setAsType(activeTypeSpec, null);
                diffSymbolHolder.isDerivationFrom(this, fSuffix);
                if (basisSymbolTable != null) {
                    diffSymbolHolder.addTypeDeclSymbolTable(basisSymbolTable);
                    diffSymbolHolder.makeNewRef(basisSymbolTable);
                    diffSymbolHolder.makeNewRef(diffSymbolTable);
                    diffSymbolHolder.solvingLevelMustInclude(basisSymbolTable);
                    if (TapEnv.associationByAddress() && basisSymbolTable.basisSymbolTable() != null) {
                        diffSymbolHolder.declarationLevelMustInclude(TapEnv.assocAddressDiffTypesUnit(basisSymbolTable.unit.language()).publicSymbolTable());
                    }
                }
                diffTypeDecl = diffSymbolHolder.newTypeDecl();
                this.setDiffSymbolHolder(0, null, diffSymbolHolder, maxDiffSorts);
            }
        } else {
            WrapperTypeSpec baseTypeSpec = this.typeSpec.baseTypeSpec(true);
            TapEnv.toolWarning(-1, "(Diff of a Type): Don't know how to differentiate a " + baseTypeSpec);
        }
        return diffTypeDecl;
    }

    @Override
    public void collectUsedTrees(TapList<Tree> toUsedTrees, TapList<TypeSpec> toDejaVu) {
        if (this.typeSpec != null && this.typeSpec.wrappedType != null) {
            this.typeSpec.wrappedType.collectUsedTrees(toUsedTrees, toDejaVu);
        }
    }

    @Override
    public WrapperTypeSpec type() {
        return this.typeSpec;
    }

    @Override
    public void dump(int indent) throws IOException {
        TapEnv.print(this.symbol + ": type name");
        if (this.renamedFromSymbolDecl != null) {
            TapEnv.print("(=>" + this.renamedFromSymbolDecl.symbol + ") ");
        }
        if (this.typeSpec != null) {
            TapEnv.print(" for ");
            this.typeSpec.dump();
        }
        TapEnv.print(" depends on: " + this.dependsOn());
        TapEnv.print(" isActive(): " + this.isActiveSymbolDecl());
    }

    @Override
    public String toString() {
        String typeS = "";
        if (this.typeSpec != null) {
            typeS = this.typeSpec.toString();
        }
        return "TYPE:" + this.symbol + " " + typeS + " isActive()->" + this.isActiveSymbolDecl();
    }
}

