/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.analysis.ADActivityAnalyzer;
import fr.inria.tapenade.analysis.ADTBRAnalyzer;
import fr.inria.tapenade.analysis.ActivityPattern;
import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.analysis.DiffLivenessAnalyzer;
import fr.inria.tapenade.frontend.TreeProtocol;
import fr.inria.tapenade.ir2tree.DeclStruct;
import fr.inria.tapenade.ir2tree.TreeGen;
import fr.inria.tapenade.ir2tree.VariableDeclStruct;
import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.BasicBlock;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.BlockStorage;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.ClassTypeSpec;
import fr.inria.tapenade.representation.Directive;
import fr.inria.tapenade.representation.EntryBlock;
import fr.inria.tapenade.representation.ExitBlock;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.FGConstants;
import fr.inria.tapenade.representation.FieldDecl;
import fr.inria.tapenade.representation.FlowGraphBuilder;
import fr.inria.tapenade.representation.FlowGraphNormalizer;
import fr.inria.tapenade.representation.FortranStuff;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.FunctionTypeSpec;
import fr.inria.tapenade.representation.HeaderBlock;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.InitConstructorBlock;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.InterfaceDecl;
import fr.inria.tapenade.representation.LoopBlock;
import fr.inria.tapenade.representation.MPIcallInfo;
import fr.inria.tapenade.representation.MemoryMap;
import fr.inria.tapenade.representation.MixedLanguageInfos;
import fr.inria.tapenade.representation.ModifiedTypeSpec;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.PositionAndMessage;
import fr.inria.tapenade.representation.PrimitiveTypeSpec;
import fr.inria.tapenade.representation.PublicInfo;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeDecl;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneAllocator;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.toplevel.Tapenade;
import fr.inria.tapenade.utils.BoolMatrix;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.Int2ZoneInfo;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.ToInt;
import fr.inria.tapenade.utils.ToObject;
import fr.inria.tapenade.utils.Tree;
import java.io.File;
import java.io.IOException;

public final class Unit {
    private static final int UNDEFINED = -1;
    private static final int STANDARD = 0;
    private static final int INTRINSIC = 1;
    private static final int EXTERNAL = 2;
    private static final int VARFUNCTION = 3;
    private static final int MODULE = 4;
    private static final int INTERFACE = 5;
    private static final int RENAMED = 6;
    private static final int OUTSIDE_TBD = 7;
    private static final int CLASS = 8;
    private static final int CONSTRUCTOR = 9;
    private static final int DESTRUCTOR = 10;
    private static final int FILE = 11;
    private static final int DEADBLOCK = -2;
    private static final int TOOMANYZONES = 128;
    private final int[] freeSideEffectZone = new int[]{0, 0, 0, 0};
    private final ZoneInfo[][] sideEffectZoneInfos = new ZoneInfo[][]{null, null, null, null};
    public String name = "";
    public TapList<CallArrow> callers;
    public TapList<CallArrow> callees;
    public TapList<Unit> childrenClasses;
    public TapList<Unit> lowerLevelUnits;
    public MemoryMap declaredMemoryMap;
    public MemoryMap sideEffectMemoryMap;
    public TapList<TapPair<ZoneInfo, TapIntList>> extraSideEffectVariables;
    public int position = -1;
    public Unit enclosingUnitOfInterface;
    private FortranStuff fortranStuff;
    public String privacy = "";
    public TapList<PositionAndMessage> messages = new TapList<Object>(null, null);
    public TapList<Unit> otherImportedModules;
    public boolean usesISO_C_BINDING;
    public Tree parametersOrModuleNameTree = ILUtils.build(70);
    private VariableDecl otherReturnVar;
    public Tree modifiers;
    public EntryBlock entryBlock;
    public ExitBlock exitBlock;
    public TapList<Block> allBlocks;
    public int nbBlocks;
    public TapList<FGArrow> allArrows;
    public int nbArrows;
    public TapList<Tree> formats;
    public TapList<Instruction> nonFlowInstructions;
    public Tree preComments;
    public Tree postComments;
    public Tree preCommentsBlock;
    public Tree postCommentsBlock;
    public TapList<TapPair<String, String>> userHelp = new TapList<Object>(null, null);
    public Unit origUnit;
    public BlockStorage<Block> orig2copiedBlocks;
    public Block origPublicSTDeclarationBlock;
    public Block copyPublicSTDeclarationBlock;
    public TapList<ActivityPattern> specificInfoAD;
    public BoolMatrix unitADDependencies;
    public NewSymbolHolder dirNumberMaxSymbolHolder;
    public ArrayDim multiDirDimensionMax;
    public Object diffInfo;
    public TapList<Directive> directives;
    public boolean maybeCheckpointed;
    public boolean maybeNoCheckpointed;
    public TapList<String> activeCalledNames;
    public boolean isCGCycle;
    public boolean analysisIsOutOfDate = true;
    public boolean usedAsElementalResult;
    public boolean isMadeForInline;
    public int arrayDimMin = -1;
    public ZoneInfo[] externalShape;
    public PublicInfo[] translator;
    public TapList[] argsPublicRankTrees;
    public BoolMatrix pointerEffect;
    public BoolVector unitInOutN;
    public BoolVector unitInOutR;
    public BoolVector unitInOutW;
    public BoolVector unitInOutRW;
    public BoolMatrix unitDependencies;
    public NewSymbolHolder tagMessagePassingSymbolHolder;
    public BoolVector zonesUsedInDeclarations;
    protected int sortRk = -1;
    protected CallArrow genericArrow;
    protected boolean isTotallyDeclared = true;
    private CallGraph callGraph;
    private TapList<TapTriplet<Unit, Boolean, Boolean>> parentClasses;
    private Unit upperLevelUnit;
    private SymbolTable privateSymbolTable;
    private SymbolTable publicSymbolTable;
    private SymbolTable protectedSymbolTable;
    private SymbolTable externalSymbolTable;
    private SymbolTable translationUnitSymbolTable;
    private TapList<SymbolTable> symbolTablesBottomUp;
    private int language;
    private int kind = 0;
    private boolean wasDeleted;
    private TapList<Instruction> interfaceDeclarations;
    private Instruction fromInclude;
    private int unitRank;
    private boolean isPredefinedModuleOrTranslationUnit;
    private boolean isCalledFromOtherLanguage;
    private TapList<Tree> importedModulesUseDecl;
    private TapList<Unit> importedModules;
    private TapList<TapPair<Unit, Tree>> importedModulesAndUseInfo;
    private FunctionTypeSpec functionTypeSpec;
    private ClassTypeSpec classTypeSpec;
    private InitConstructorBlock initConstructorBlock;
    private TapList<Block> topBlocks;
    private int nbLoopBlocks;
    private TapList<Tree> deadTrees;
    private TapList<Tree> lostComments;
    private boolean isDiffPackage;
    private Unit otherName;
    private Instruction forwardDeclaration;
    private boolean inStdCIncludeFile;
    private boolean hasArrayNotation;
    private TapList[] argsZoneTrees;
    private int[] elemArgPublicRanks;
    private int[] zoneRkToElemArgRk;
    private BoolMatrix transferMatrix;
    private BoolMatrix transferMatrixReal;
    private boolean containsAllocDealloc;
    private int testZonesNb;
    private TapList<TapPair<ZoneInfo, TapList>> targetZoneInfos;

    public final boolean hasTooManyZones() {
        return false;
    }

    public FortranStuff fortranStuff() {
        return this.fortranStuff;
    }

    public VariableDecl otherReturnVar() {
        return this.otherReturnVar;
    }

    public void setOtherReturnVar(VariableDecl otherReturnVar) {
        this.otherReturnVar = otherReturnVar;
    }

    public boolean wasDeleted() {
        return this.wasDeleted;
    }

    public void setDeleted() {
        this.wasDeleted = true;
    }

    public Unit(CallGraph callGraph, int rank, Unit upperLevelUnit, int language) {
        this.language = language;
        this.setRank(rank);
        this.callGraph = callGraph;
        this.upperLevelUnit = upperLevelUnit;
        if (this.isFortran()) {
            this.fortranStuff = new FortranStuff(this);
        }
        if (callGraph != null) {
            this.declaredMemoryMap = new MemoryMap();
            this.sideEffectMemoryMap = new MemoryMap();
            if (this.fortranStuff != null && upperLevelUnit != null && !upperLevelUnit.isTranslationUnit()) {
                this.fortranStuff.statementFunctions = upperLevelUnit.fortranStuff.statementFunctions;
            }
        }
    }

    public static TapList<Unit> removePhantomPackages(TapList<Unit> diffUnits) {
        TapList<Object> hdResult;
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        while (diffUnits != null) {
            if (diffUnits.head != null && ((Unit)diffUnits.head).isDiffPackage) {
                tlResult = tlResult.placdl(diffUnits.head);
            }
            diffUnits = diffUnits.tail;
        }
        return hdResult.tail;
    }

    private static boolean markDownStreamBlock(boolean[] array, Block block, boolean value) {
        boolean result = false;
        TapList<FGArrow> iter = block.flow();
        while (iter != null) {
            Unit.mark(array, ((FGArrow)iter.head).destination, value);
            result |= ((FGArrow)iter.head).destination.rank <= block.rank;
            iter = iter.tail;
        }
        return result;
    }

    private static boolean markUpStreamBlock(boolean[] array, Block block, boolean value) {
        boolean result = false;
        TapList<FGArrow> iter = block.backFlow();
        while (iter != null) {
            Unit.mark(array, ((FGArrow)iter.head).origin, value);
            result |= ((FGArrow)iter.head).destination.rank >= block.rank;
            iter = iter.tail;
        }
        return result;
    }

    private static boolean marked(boolean[] array, Block block) {
        return array[block.rank + 1];
    }

    private static void mark(boolean[] array, Block block, boolean value) {
        array[block.rank + 1] = value;
    }

    private static TapList<FGArrow> findFlowArrow(Block block, int test) {
        return Unit.findFGArrow(block.flow(), test);
    }

    private static TapList<FGArrow> findFGArrow(TapList<FGArrow> flow, int test) {
        TapList<Object> hd;
        TapList<Object> tl = hd = new TapList<Object>(null, null);
        while (flow != null) {
            if (TapIntList.contains(((FGArrow)flow.head).cases, test)) {
                tl = tl.placdl(flow.head);
            }
            flow = flow.tail;
        }
        return tl;
    }

    private static boolean getBitForBlock(BoolVector bv, Block block) {
        return bv.get(block.rank + 1);
    }

    public static Unit makeExternalOrIntrinsic(String funcName, CallGraph callGraph, int language) {
        Unit unit = callGraph.createNewUnit(null, language);
        unit.setExternalSymbolTable(callGraph.languageRootSymbolTable(language));
        unit.kind = 7;
        unit.name = funcName;
        unit.specificInfoAD = null;
        return unit;
    }

    public static Unit makeExternal(String funcName, CallGraph callGraph, int language, boolean isPrivate) {
        Unit unit = callGraph.createNewUnit(null, language);
        if (isPrivate) {
            unit.setTranslationUnitSymbolTable(TapEnv.currentTranslationUnitSymbolTable());
        } else {
            unit.setExternalSymbolTable(callGraph.languageRootSymbolTable(language));
        }
        unit.kind = 2;
        unit.name = funcName;
        unit.specificInfoAD = null;
        return unit;
    }

    public static Unit makeVarFunction(String funcName, Unit callingUnit) {
        Unit unit = callingUnit.callGraph.createNewUnit(null, callingUnit.language);
        unit.setExternalSymbolTable(callingUnit.externalSymbolTable());
        unit.kind = callingUnit.isFortran() ? 3 : 2;
        unit.name = funcName;
        return unit;
    }

    public static TapList<Unit> allCallersMulti(TapList<Unit> initialUnits) {
        TapList<Object> toDejaVu = new TapList<Object>(null, null);
        TapList<Unit> callersList = null;
        while (initialUnits != null) {
            callersList = Unit.allCallersRec((Unit)initialUnits.head, callersList, toDejaVu);
            initialUnits = initialUnits.tail;
        }
        return callersList;
    }

    private static TapList<Unit> allCallersRec(Unit unit, TapList<Unit> callersList, TapList<Unit> toDejaVu) {
        if (TapList.contains(toDejaVu, unit) || unit.rank() < 0) {
            return callersList;
        }
        TapList<CallArrow> callArrows = unit.callers;
        toDejaVu.tail = new TapList<Unit>(unit, toDejaVu.tail);
        while (callArrows != null) {
            Unit origin = ((CallArrow)callArrows.head).origin;
            callersList = Unit.allCallersRec(origin, callersList, toDejaVu);
            callArrows = callArrows.tail;
        }
        return new TapList<Unit>(unit, callersList);
    }

    public static TapList<Unit> allCalleesMulti(TapList<Unit> initialUnits) {
        TapList<Object> toDejaVu = new TapList<Object>(null, null);
        TapList<Unit> calleesList = null;
        while (initialUnits != null) {
            calleesList = Unit.allCalleesRec((Unit)initialUnits.head, calleesList, toDejaVu);
            initialUnits = initialUnits.tail;
        }
        return calleesList;
    }

    public static TapList<Unit> allCalleesMultiAvoiding(TapList<Unit> initialUnits, TapList<Unit> avoidedUnits) {
        TapList<Unit> toDejaVu = new TapList<Unit>(null, avoidedUnits);
        TapList<Unit> calleesList = null;
        while (initialUnits != null) {
            calleesList = Unit.allCalleesRec((Unit)initialUnits.head, calleesList, toDejaVu);
            initialUnits = initialUnits.tail;
        }
        return calleesList;
    }

    private static TapList<Unit> allCalleesRec(Unit unit, TapList<Unit> calleesList, TapList<Unit> toDejaVu) {
        if (TapList.contains(toDejaVu, unit) || unit.rank() < 0) {
            return calleesList;
        }
        TapList<CallArrow> callArrows = unit.callees;
        toDejaVu.tail = new TapList<Unit>(unit, toDejaVu.tail);
        while (callArrows != null) {
            Unit destination = ((CallArrow)callArrows.head).destination;
            if (((CallArrow)callArrows.head).isCall()) {
                calleesList = Unit.allCalleesRec(destination, calleesList, toDejaVu);
            }
            callArrows = callArrows.tail;
        }
        return new TapList<Unit>(unit, calleesList);
    }

    protected static Unit copyUnitForInline(Unit unit) {
        Unit newUnit = new Unit(null, -1, null, unit.language);
        Unit.copyUnitBody(unit, newUnit, true);
        newUnit.orig2copiedBlocks = null;
        newUnit.origPublicSTDeclarationBlock = null;
        newUnit.copyPublicSTDeclarationBlock = null;
        newUnit.messages = unit.messages;
        newUnit.hasArrayNotation = unit.hasArrayNotation;
        return newUnit;
    }

    private static TapList<FGArrow> copyUnitBody(Unit origUnit, Unit copyUnit, boolean forInline) {
        Block copyBlock;
        Block origBlock;
        TapList<Object> hdNewArrows;
        TapList<Object> hdNewBlocks;
        TapList<Object> tlNewBlocks = hdNewBlocks = new TapList<Object>(null, null);
        TapList<Object> tlNewArrows = hdNewArrows = new TapList<Object>(null, null);
        TapList<Block> origBlocks = origUnit.allBlocks;
        copyUnit.setPublicSymbolTable(origUnit.entryBlock.symbolTable);
        copyUnit.orig2copiedBlocks = new BlockStorage(origUnit);
        TapList<Object> whereMaskCopies = new TapList<Object>(null, null);
        if (origUnit.entryBlock != null) {
            copyUnit.entryBlock = new EntryBlock(origUnit.entryBlock.symbolTable);
            origUnit.entryBlock.copyIntoWithoutArrows(copyUnit.entryBlock, whereMaskCopies);
            copyUnit.orig2copiedBlocks.store(origUnit.entryBlock, copyUnit.entryBlock);
        }
        if (origUnit.exitBlock != null) {
            copyUnit.exitBlock = new ExitBlock(origUnit.exitBlock.symbolTable);
            origUnit.exitBlock.copyIntoWithoutArrows(copyUnit.exitBlock, whereMaskCopies);
            copyUnit.orig2copiedBlocks.store(origUnit.exitBlock, copyUnit.exitBlock);
        }
        while (origBlocks != null) {
            origBlock = (Block)origBlocks.head;
            if (origBlock instanceof HeaderBlock) {
                copyBlock = new HeaderBlock(origBlock.symbolTable, origBlock.parallelControls, null);
                copyBlock.declaresItsIterator = ((HeaderBlock)origBlock).declaresItsIterator;
                copyBlock.setOrigCycleLabel(((HeaderBlock)origBlock).origCycleLabel());
            } else {
                copyBlock = new BasicBlock(origBlock.symbolTable, origBlock.parallelControls, null);
            }
            origBlock.copyIntoWithoutArrows(copyBlock, whereMaskCopies);
            copyUnit.orig2copiedBlocks.store(origBlock, copyBlock);
            copyBlock.rank = copyBlock.rank + (forInline ? 1000 : 0);
            tlNewBlocks = tlNewBlocks.placdl(copyBlock);
            origBlocks = origBlocks.tail;
        }
        copyUnit.allBlocks = hdNewBlocks.tail;
        if (origUnit.publicSymbolTable() != null) {
            Block origPublicSTDB;
            copyUnit.origPublicSTDeclarationBlock = origPublicSTDB = origUnit.publicSymbolTable().declarationsBlock;
            if (origPublicSTDB != null && origPublicSTDB.rank >= -1) {
                copyUnit.copyPublicSTDeclarationBlock = copyUnit.orig2copiedBlocks.retrieve(origPublicSTDB);
            }
        }
        if (origUnit.entryBlock != null) {
            origBlocks = new TapList<Block>(origUnit.entryBlock, origUnit.allBlocks);
        }
        while (origBlocks != null) {
            TapList<FGArrow> flow = ((Block)origBlocks.head).flow();
            copyBlock = copyUnit.orig2copiedBlocks.retrieve((Block)origBlocks.head);
            while (flow != null) {
                FGArrow origArrow = (FGArrow)flow.head;
                Block copyDest = copyUnit.orig2copiedBlocks.retrieve(origArrow.destination);
                if (copyDest != null) {
                    FGArrow copyArrow = new FGArrow(copyBlock, origArrow.test, origArrow.cases, copyDest, origArrow.inACycle);
                    tlNewArrows = tlNewArrows.placdl(copyArrow);
                    copyArrow.rank = origArrow.rank;
                }
                flow = flow.tail;
            }
            origBlocks = origBlocks.tail;
        }
        BlockStorage<TapList<Instruction>> parallelControlsCorrepondence = new BlockStorage<TapList<Instruction>>(origUnit);
        origBlocks = origUnit.allBlocks;
        while (origBlocks != null) {
            origBlock = (Block)origBlocks.head;
            copyBlock = copyUnit.orig2copiedBlocks.retrieve(origBlock);
            copyBlock.parallelControls = Unit.getSetNewParallelControls(origBlock.parallelControls, copyUnit.orig2copiedBlocks, parallelControlsCorrepondence);
            origBlocks = origBlocks.tail;
        }
        return hdNewArrows.tail;
    }

    public static TapList<Instruction> getSetNewParallelControls(TapList<Instruction> oldParallelControls, BlockStorage<Block> blockCorrespondence, BlockStorage<TapList<Instruction>> parallelControlsCorrepondence) {
        if (oldParallelControls == null) {
            return null;
        }
        Block oldControlBlock = ((Instruction)oldParallelControls.head).block;
        TapList<Instruction> newControls = parallelControlsCorrepondence.retrieve(oldControlBlock);
        if (newControls == null) {
            TapList<Instruction> newControlsAround = Unit.getSetNewParallelControls(oldParallelControls.tail, blockCorrespondence, parallelControlsCorrepondence);
            TapList<Instruction> newControlBlockInstrs = blockCorrespondence.retrieve((Block)oldControlBlock).instructions;
            newControls = newControlBlockInstrs != null ? new TapList<Instruction>((Instruction)newControlBlockInstrs.head, newControlsAround) : newControlsAround;
            parallelControlsCorrepondence.store(oldControlBlock, newControls);
        }
        return newControls;
    }

    private static void dumpDeclaredKindZones(SymbolTable symbolTable, int kind, int indent) throws IOException {
        if (symbolTable != null) {
            Unit.dumpDeclaredKindZones(symbolTable.basisSymbolTable(), kind, indent);
            Unit.dumpArrayOfZones(symbolTable.getDeclaredZoneInfos(kind), symbolTable.firstDeclaredZone(kind), indent);
            if (symbolTable.getAdditionalDuplicatedDeclaredZoneInfos() != null) {
                Unit.dumpTapListOfZones(symbolTable.getAdditionalDuplicatedDeclaredZoneInfos()[kind], indent);
            }
        }
    }

    private static void dumpArrayOfZones(ZoneInfo[] zoneInfos, int offset, int indent) throws IOException {
        if (zoneInfos != null) {
            for (int i = 0; i < zoneInfos.length; ++i) {
                TapEnv.indentPrint(indent, TapEnv.str3(i + offset) + "> ");
                if (zoneInfos[i] != null) {
                    zoneInfos[i].dump();
                } else {
                    TapEnv.print(" null, meaning hidden");
                }
                TapEnv.println();
            }
        }
    }

    private static void dumpTapListOfZones(TapList<Int2ZoneInfo> zoneInfos, int indent) throws IOException {
        while (zoneInfos != null) {
            Int2ZoneInfo iZoneInfo = (Int2ZoneInfo)zoneInfos.head;
            TapEnv.indentPrint(indent, TapEnv.str3(iZoneInfo.getZoneNumber()) + "> ");
            iZoneInfo.getZoneInfo().dump();
            TapEnv.println();
            zoneInfos = zoneInfos.tail;
        }
    }

    private static void dumpTranslator(PublicInfo[] translator, int indent) throws IOException {
        if (translator == null) {
            TapEnv.indentPrint(indent, "null translator");
            TapEnv.println();
        } else {
            for (int i = 0; i < translator.length; ++i) {
                TapEnv.indentPrint(indent, TapEnv.str3(i) + "> ");
                TapEnv.dumpObject(translator[i]);
                TapEnv.println();
            }
        }
    }

    private static void dumpBlocksNesting(TapList<Block> blocks) throws IOException {
        TapEnv.print("(");
        while (blocks != null) {
            Block block = (Block)blocks.head;
            if (block instanceof LoopBlock) {
                TapEnv.print("L" + block.rank + ':');
                Unit.dumpBlocksNesting(((LoopBlock)block).inside);
            } else {
                TapEnv.print("B" + block.rank);
            }
            if ((blocks = blocks.tail) == null) continue;
            TapEnv.print(" ");
        }
        TapEnv.print(")");
    }

    public CallGraph callGraph() {
        return this.callGraph;
    }

    public TapList<CallArrow> callers() {
        return this.callers;
    }

    public TapList<CallArrow> callersThatCall() {
        TapList<CallArrow> result = null;
        TapList<CallArrow> inCallerArrows = this.callers;
        while (inCallerArrows != null) {
            CallArrow arrow = (CallArrow)inCallerArrows.head;
            if (arrow.origin != null && arrow.isCall()) {
                result = new TapList<CallArrow>(arrow, result);
            }
            inCallerArrows = inCallerArrows.tail;
        }
        return result;
    }

    public TapList<String> callerUnitNamesThatCall() {
        TapList<String> result = null;
        TapList<CallArrow> inCallerArrows = this.callers;
        while (inCallerArrows != null) {
            String callerName;
            CallArrow arrow = (CallArrow)inCallerArrows.head;
            if (arrow.origin != null && arrow.isCall() && (callerName = arrow.origin.name) != null && !TapList.containsEquals(result, callerName)) {
                result = new TapList<String>(callerName, result);
            }
            inCallerArrows = inCallerArrows.tail;
        }
        return result;
    }

    public TapList<CallArrow> callees() {
        return this.callees;
    }

    public void addParentClass(Unit unit, boolean isVirtualInheritance, boolean isPublicInheritance) {
        this.parentClasses = new TapList<TapTriplet<Unit, Boolean, Boolean>>(new TapTriplet<Unit, Boolean, Boolean>(unit, isVirtualInheritance, isPublicInheritance), this.parentClasses);
    }

    public void addChildrenClass(Unit unit) {
        this.childrenClasses = new TapList<Unit>(unit, this.childrenClasses);
    }

    public void addLowerLevelUnit(Unit unit) {
        this.lowerLevelUnits = new TapList<Unit>(unit, this.lowerLevelUnits);
    }

    public Unit upperLevelUnit() {
        return this.upperLevelUnit;
    }

    public void setUpperLevelUnit(Unit upUnit) {
        this.upperLevelUnit = upUnit;
    }

    public int nestingDepth() {
        int depth = 0;
        Unit curUnit = this.upperLevelUnit;
        while (curUnit != null) {
            ++depth;
            curUnit = curUnit.upperLevelUnit;
        }
        return depth;
    }

    public TapList<Unit> enclosingUnits() {
        if (this.upperLevelUnit == null) {
            return null;
        }
        return new TapList<Unit>(this.upperLevelUnit, this.upperLevelUnit.enclosingUnits());
    }

    private boolean encloses(Unit enclosed) {
        boolean encloses = false;
        while (!encloses && enclosed != null) {
            enclosed = enclosed.upperLevelUnit;
            encloses = enclosed == this;
        }
        return encloses;
    }

    public SymbolTable privateSymbolTable() {
        return this.privateSymbolTable;
    }

    public SymbolTable protectedSymbolTable() {
        return this.protectedSymbolTable;
    }

    public SymbolTable publicSymbolTable() {
        return this.publicSymbolTable;
    }

    public void setPrivateSymbolTable(SymbolTable symbolTable) {
        this.privateSymbolTable = symbolTable;
    }

    public void setPublicSymbolTable(SymbolTable symbolTable) {
        this.publicSymbolTable = symbolTable;
    }

    public void setProtectedSymbolTable(SymbolTable symbolTable) {
        this.protectedSymbolTable = symbolTable;
    }

    public void setExternalSymbolTable(SymbolTable symbolTable) {
        this.externalSymbolTable = symbolTable;
    }

    public SymbolTable externalSymbolTable() {
        SymbolTable resultST = this.externalSymbolTable != null ? this.externalSymbolTable : (this.publicSymbolTable != null ? this.publicSymbolTable.basisSymbolTable() : (this.privateSymbolTable != null && this.privateSymbolTable.basisSymbolTable() != null ? this.privateSymbolTable.basisSymbolTable().basisSymbolTable() : this.callGraph.languageRootSymbolTable(this.language)));
        return resultST;
    }

    public void setTranslationUnitSymbolTable(SymbolTable symbolTable) {
        this.translationUnitSymbolTable = symbolTable;
    }

    public SymbolTable translationUnitSymbolTable() {
        return this.translationUnitSymbolTable;
    }

    public SymbolTable bodySymbolTable() {
        if (this.privateSymbolTable != null) {
            return this.privateSymbolTable;
        }
        if (this.protectedSymbolTable != null && this.isClass()) {
            return this.protectedSymbolTable;
        }
        if (this.publicSymbolTable != null) {
            return this.publicSymbolTable;
        }
        return this.translationUnitSymbolTable;
    }

    public void addDerivedSymbolTable(SymbolTable symbolTable) {
        this.symbolTablesBottomUp = new TapList<SymbolTable>(symbolTable, this.symbolTablesBottomUp);
    }

    private void removeDerivedSymbolTable(SymbolTable symbolTable) {
        TapList<SymbolTable> toList;
        TapList<SymbolTable> inList = toList = new TapList<SymbolTable>(null, this.symbolTablesBottomUp);
        while (inList.tail != null) {
            if (inList.tail.head == symbolTable) {
                inList.tail = inList.tail.tail;
                continue;
            }
            inList = inList.tail;
        }
        this.symbolTablesBottomUp = toList.tail;
    }

    public TapList<SymbolTable> symbolTablesBottomUp() {
        return this.symbolTablesBottomUp;
    }

    public int language() {
        return this.language;
    }

    public void setLanguage(int lang) {
        this.language = lang;
    }

    public void setLanguageAndUp(int lang) {
        this.language = lang;
        if (this.upperLevelUnit != null) {
            this.upperLevelUnit.setLanguageAndUp(lang);
        }
    }

    public boolean isFortran() {
        return this.language == 1 || this.language == 2 || this.language == 3;
    }

    public boolean isFortran9x() {
        return this.language == 2 || this.language == 3;
    }

    public boolean isFortran2003() {
        return this.language == 3;
    }

    public boolean isC() {
        return this.language == 4;
    }

    public boolean isCPlusPlus() {
        return this.language == 5;
    }

    public boolean isCorMore() {
        return this.language == 4 || this.language == 5;
    }

    public boolean sameLanguage(int lang) {
        if (lang == 4) {
            return this.isC();
        }
        if (lang == 5) {
            return this.isCPlusPlus();
        }
        if (lang != 100) {
            return this.isFortran();
        }
        return false;
    }

    public void setKind(Unit otherUnit) {
        this.kind = otherUnit.kind;
    }

    public void setKind(int kind) {
        this.kind = kind;
    }

    public void setUndefined() {
        this.kind = -1;
    }

    public boolean isUndefined() {
        return this.kind == -1;
    }

    public boolean isStandard() {
        return this.kind == 0;
    }

    public void setIntrinsic() {
        this.kind = 1;
    }

    public boolean isIntrinsic() {
        return this.kind == 1;
    }

    public void setExternal() {
        this.kind = 2;
    }

    public boolean isExternal() {
        return this.kind == 2;
    }

    public boolean isProcedure() {
        return this.kind == 0 || this.kind == 1 || this.kind == 9 || this.kind == 10 || this.kind == 2 || this.kind == -1;
    }

    public boolean isProcedureWithCode() {
        return this.kind == 0 || this.kind == 9 || this.kind == 10 || this.kind == 1 && this.hasSource();
    }

    public boolean isPackage() {
        return this.kind == 11 || this.kind == 4 || this.kind == 8;
    }

    public void setVarFunction() {
        this.kind = 3;
    }

    public boolean isVarFunction() {
        return this.kind == 3;
    }

    public void setModule() {
        this.kind = 4;
    }

    public boolean isModule() {
        return this.kind == 4;
    }

    public void setClass() {
        this.kind = 8;
    }

    public boolean isClass() {
        return this.kind == 8;
    }

    public void setConstructor() {
        this.kind = 9;
    }

    public boolean isConstructor() {
        return this.kind == 9;
    }

    public void setDestructor() {
        this.kind = 10;
    }

    public void setInterface() {
        this.kind = 5;
    }

    public void setInterfaceDeclaration(Instruction instr) {
        this.interfaceDeclarations = new TapList<Instruction>(instr, this.interfaceDeclarations);
    }

    public boolean isInterface() {
        return this.kind == 5;
    }

    public boolean isRenamed() {
        return this.kind == 6;
    }

    public boolean isOutsideTBD() {
        return this.kind == 7;
    }

    public boolean isOutside() {
        return this.kind == 7 || this.kind == 2 || this.kind == 1;
    }

    public boolean isTranslationUnit() {
        return this.kind == 11;
    }

    public void setTranslationUnit(String fileName) {
        this.kind = 11;
        this.name = fileName;
    }

    public boolean isTopInFile() {
        return this.upperLevelUnit == null ? !this.isTranslationUnit() : this.upperLevelUnit.isTranslationUnit();
    }

    public Instruction fromInclude() {
        return this.fromInclude;
    }

    public void setFromInclude(Instruction fromInc) {
        this.fromInclude = fromInc;
    }

    public int rank() {
        return this.unitRank;
    }

    public void setRank(int rank) {
        this.unitRank = rank;
    }

    public boolean isPredefinedModuleOrTranslationUnit() {
        return this.isPredefinedModuleOrTranslationUnit;
    }

    public void setPredefinedModuleOrTranslationUnit() {
        this.isPredefinedModuleOrTranslationUnit = true;
        if (this.upperLevelUnit != null) {
            this.upperLevelUnit.setPredefinedModuleOrTranslationUnit();
        }
    }

    public void setCalledFromOtherLanguage() {
        this.isCalledFromOtherLanguage = true;
    }

    public boolean isCalledFromOtherLanguage() {
        return this.isCalledFromOtherLanguage;
    }

    public TapList<Unit> importedModules() {
        return this.importedModules;
    }

    public boolean hasSource() {
        return !this.isInterface() && !this.isVarFunction() && !this.isMadeForInline && this.entryBlock != null;
    }

    public ClassTypeSpec classTypeSpec() {
        return this.classTypeSpec;
    }

    public void setClassTypeSpec(ClassTypeSpec type) {
        this.classTypeSpec = type;
    }

    public FunctionTypeSpec functionTypeSpec() {
        return this.functionTypeSpec;
    }

    public void setFunctionTypeSpec(FunctionTypeSpec functionTypeSpec) {
        this.functionTypeSpec = functionTypeSpec;
    }

    public int formalArgumentsNb() {
        if (this.functionTypeSpec == null || this.functionTypeSpec.argumentsTypes == null) {
            return 0;
        }
        return this.functionTypeSpec.argumentsTypes.length;
    }

    public Tree headTree() {
        Tree result = this.entryBlock != null ? this.entryBlock.headTree() : ILUtils.buildCall(ILUtils.build(94, this.name), this.parametersOrModuleNameTree);
        return result;
    }

    public EntryBlock entryBlock() {
        return this.entryBlock;
    }

    public void setEntryBlock(EntryBlock eb) {
        this.entryBlock = eb;
    }

    public void setInitConstructorBlock(InitConstructorBlock ib) {
        this.initConstructorBlock = ib;
    }

    public ExitBlock exitBlock() {
        return this.exitBlock;
    }

    public void setExitBlock(ExitBlock eb) {
        this.exitBlock = eb;
    }

    public TapList<Block> topBlocks() {
        return this.topBlocks;
    }

    public void addBlock(Block block) {
        this.allBlocks = new TapList<Block>(block, this.allBlocks);
    }

    public TapList<Block> allBlocks() {
        return this.allBlocks;
    }

    public FGArrow getArrow(int rank) {
        return (FGArrow)TapList.nth(this.allArrows, rank);
    }

    public void addDeadTree(Tree tree) {
        this.deadTrees = new TapList<Tree>(tree, this.deadTrees);
    }

    public TapList<Tree> deadTrees() {
        return this.deadTrees;
    }

    public void addFormatTree(Tree formatTree) {
        this.formats = new TapList<Tree>(formatTree, this.formats);
    }

    public void addNonFlowInstruction(Instruction instr) {
        this.nonFlowInstructions = TapList.addLast(this.nonFlowInstructions, instr);
    }

    public TapList<Tree> formats() {
        return this.formats;
    }

    public void addLostComment(Tree tree) {
        this.lostComments = TapList.addLast(this.lostComments, tree);
    }

    public TapList<Tree> lostComments() {
        return this.lostComments;
    }

    public void setLostComments(TapList<Tree> lostComments) {
        this.lostComments = lostComments;
    }

    public void appendPostComments(TapList<Tree> newComments) {
        if (newComments != null) {
            this.postComments = ILUtils.appendComments(this.postComments, newComments, 36);
        }
    }

    public Boolean isDiffPackage() {
        return this.isDiffPackage;
    }

    public void setIsDiffPackage(boolean isDiff) {
        this.isDiffPackage = isDiff;
        if (this.origUnit != null) {
            this.origUnit.isDiffPackage = isDiff;
        }
    }

    public Unit otherName() {
        return this.otherName;
    }

    public void setOtherName(Unit otherUnit) {
        this.otherName = otherUnit;
    }

    public boolean isAContext() {
        TapList<ActivityPattern> activityPatterns = this.specificInfoAD;
        return activityPatterns != null && activityPatterns.head != null && ((ActivityPattern)activityPatterns.head).isContext();
    }

    public Directive hasDirective(int kind) {
        return Directive.hasDirective(this.directives, kind);
    }

    public boolean mustDifferentiateJoint() {
        return this.maybeCheckpointed;
    }

    public boolean mustDifferentiateSplit() {
        return this.maybeNoCheckpointed;
    }

    public boolean hasPredefinedDerivatives() {
        return (this.isIntrinsic() || this.isExternal() || this.isOutsideTBD()) && this.diffInfo != null;
    }

    public Instruction getForwardDeclaration() {
        return this.forwardDeclaration;
    }

    public void setForwardDeclaration(Instruction instr) {
        this.forwardDeclaration = instr;
    }

    public boolean isElemental() {
        boolean elemental = false;
        if (this.isFortran()) {
            boolean bl = elemental = this.isIntrinsic() && !this.isIntrinsicNotElemental();
        }
        if (this.isFortran9x() && !elemental && this.modifiers != null) {
            for (int i = 1; !elemental && i <= this.modifiers.length(); ++i) {
                Tree subTree = this.modifiers.down(i);
                if (subTree.opCode() != 94) continue;
                elemental = subTree.stringValue().equals("elemental");
            }
        }
        return elemental;
    }

    public boolean isIntrinsicNotElemental() {
        boolean result;
        boolean bl = result = this.isFortran() && this.isIntrinsic();
        if (result) {
            result = this.name.equals("all") || this.name.equals("any") || this.name.equals("count") || this.name.equals("maxval") || this.name.equals("minloc") || this.name.equals("minval") || this.name.equals("present") || this.name.equals("product") || this.name.equals("size") || this.name.equals("sum") || this.name.equals("associated") || this.name.equals("lbound") || this.name.equals("ubound") || this.name.equals("reshape") || this.name.equals("dot_product");
        }
        return result;
    }

    public boolean inStdCIncludeFile() {
        return this.inStdCIncludeFile;
    }

    public void setInStdCIncludeFile() {
        this.inStdCIncludeFile = true;
    }

    public boolean passesByValue(int parameterRank, int callerLanguage) {
        boolean result = true;
        if (this.externalShape == null) {
            if (this.isFortran()) {
                if (parameterRank == -1 || parameterRank > this.formalArgumentsNb()) {
                    String parameterPassing = MixedLanguageInfos.getParameterPassing(callerLanguage, this.language, TapEnv.mixedLanguageInfos());
                    result = parameterPassing == null || parameterPassing.toLowerCase().startsWith("byvalue");
                } else {
                    NewSymbolHolder newSH;
                    String param = ILUtils.getArguments(this.headTree()).down(parameterRank).stringValue();
                    VariableDecl paramVarDecl = this.publicSymbolTable.getTopVariableDecl(param);
                    if (paramVarDecl == null && (newSH = NewSymbolHolder.getNewSymbolHolder(ILUtils.getArguments(this.headTree()).down(parameterRank))) != null) {
                        paramVarDecl = newSH.newVariableDecl;
                    }
                    assert (paramVarDecl != null);
                    result = paramVarDecl.passesByValue(this);
                }
            } else {
                String parameterPassing = MixedLanguageInfos.getParameterPassing(callerLanguage, this.language, TapEnv.mixedLanguageInfos());
                result = parameterPassing == null || parameterPassing.toLowerCase().startsWith("byvalue");
            }
        } else if (parameterRank == -1 || parameterRank > this.formalArgumentsNb()) {
            String parameterPassing = MixedLanguageInfos.getParameterPassing(callerLanguage, this.language, TapEnv.mixedLanguageInfos());
            result = parameterPassing == null || parameterPassing.toLowerCase().startsWith("byvalue");
        } else {
            TapIntList zones = ZoneInfo.listAllZones(this.argsPublicRankTrees[parameterRank], true);
            if (zones == null) {
                String parameterPassing = MixedLanguageInfos.getParameterPassing(callerLanguage, this.language, TapEnv.mixedLanguageInfos());
                result = parameterPassing != null && parameterPassing.toLowerCase().startsWith("byvalue");
            } else {
                while (zones != null) {
                    result = result && this.paramElemZoneInfo(zones.head).passesByValue(this, callerLanguage);
                    zones = zones.tail;
                }
            }
        }
        return result;
    }

    public void setHasArrayNotation() {
        this.hasArrayNotation = true;
    }

    public boolean hasArrayNotation() {
        return this.isFortran9x() || this.hasArrayNotation;
    }

    public boolean isAFunction() {
        if (this.functionTypeSpec != null) {
            return this.functionTypeSpec.isAFunction();
        }
        TapEnv.toolWarning(-1, "Undefined functionTypeSpec for procedure " + this);
        return false;
    }

    public int sideEffectZonesNb(int whichKind) {
        return this.freeSideEffectZone[whichKind];
    }

    public ZoneInfo sideEffectZoneInfo(int zone, int whichKind) {
        return this.sideEffectZoneInfos[whichKind][zone];
    }

    public boolean hasParamElemsInfo() {
        return this.externalShape != null;
    }

    public int paramElemsNb() {
        return this.externalShape == null ? 0 : this.externalShape.length;
    }

    public ZoneInfo paramElemZoneInfo(int i) {
        return this.externalShape[i];
    }

    public PublicInfo paramElemPublicInfo(int i) {
        return this.translator[i];
    }

    public BoolMatrix transferMatrix(int whichKind) {
        switch (whichKind) {
            case 1: {
                return this.transferMatrixReal;
            }
        }
        return this.transferMatrix;
    }

    public void setAllocDealloc() {
        this.containsAllocDealloc = true;
    }

    public int testZonesNb() {
        return this.testZonesNb;
    }

    public void computeTestZones() {
        TapList<Block> inBlocks;
        if (!this.hasSource()) {
            return;
        }
        BoolVector tempVector = this.buildBitVectorOnBlocks();
        BlockStorage<BoolVector> fsStorage = this.forcedSuccessorAnalysis();
        BlockStorage<BoolVector> storage = new BlockStorage<BoolVector>(this);
        for (int i = 0; i < this.nbBlocks + 2; ++i) {
            storage.storage[i] = this.buildBitVectorOnBlocks();
        }
        boolean[] fgVector = this.allocateFlowGraphVector();
        block1: while (true) {
            inBlocks = this.allBlocks;
            while (inBlocks != null) {
                Block block = (Block)inBlocks.head;
                if (Unit.marked(fgVector, block)) {
                    Unit.mark(fgVector, block, false);
                    if (this.computeControllersForBlock(block, tempVector, fsStorage, storage) && Unit.markDownStreamBlock(fgVector, block, true)) continue block1;
                }
                inBlocks = inBlocks.tail;
            }
            break;
        }
        this.allocateTestZones(storage);
        inBlocks = this.allBlocks();
        while (inBlocks != null) {
            Block aBlock = (Block)inBlocks.head;
            BoolVector controlVector = storage.retrieve(aBlock);
            if (!controlVector.isFalse(this.nbBlocks + 2)) {
                TapList<Block> inBlocks2 = this.allBlocks();
                while (inBlocks2 != null) {
                    Block controlBlock = (Block)inBlocks2.head;
                    if (Unit.getBitForBlock(controlVector, controlBlock)) {
                        aBlock.controllers = new TapList<Block>(controlBlock, aBlock.controllers);
                        aBlock.controllersZone = new TapIntList(controlBlock.testZone, aBlock.controllersZone);
                    }
                    inBlocks2 = inBlocks2.tail;
                }
            }
            inBlocks = inBlocks.tail;
        }
    }

    private BlockStorage<BoolVector> forcedSuccessorAnalysis() {
        int i;
        Block b;
        BoolVector tempVector;
        if (!this.hasSource()) {
            return null;
        }
        TapList<Block> reverseBlocks = TapList.reverse(this.allBlocks);
        BlockStorage<BoolVector> result = new BlockStorage<BoolVector>(this);
        BlockStorage<BoolVector> storage = new BlockStorage<BoolVector>(this);
        BoolVector bVectorForExitBlock = this.buildBitVectorOnBlocks();
        this.setBitForBlock(bVectorForExitBlock, this.exitBlock, true);
        storage.store(this.exitBlock(), bVectorForExitBlock);
        TapList<Block> inBlocks = this.allBlocks;
        while (inBlocks != null) {
            tempVector = this.buildBitVectorOnBlocks();
            tempVector.setTrue();
            storage.store((Block)inBlocks.head, tempVector);
            inBlocks = inBlocks.tail;
        }
        tempVector = this.buildBitVectorOnBlocks();
        tempVector.setTrue();
        boolean[] fgVector = this.allocateFlowGraphVector();
        block1: while (true) {
            inBlocks = reverseBlocks;
            while (inBlocks != null) {
                b = (Block)inBlocks.head;
                if (Unit.marked(fgVector, b)) {
                    Unit.mark(fgVector, b, false);
                    if (this.fsThroughBlock((Block)inBlocks.head, storage, tempVector, this.exitBlock) && Unit.markUpStreamBlock(fgVector, b, true)) continue block1;
                }
                inBlocks = inBlocks.tail;
            }
            break;
        }
        for (i = 1; i < this.nbBlocks + 2; ++i) {
            result.storage[i] = new BoolVector(this.nbBlocks + 2);
        }
        inBlocks = this.allBlocks;
        while (inBlocks != null) {
            b = (Block)inBlocks.head;
            if (b.isControl()) {
                BoolVector fs = storage.retrieve(b);
                for (i = 1; i < this.nbBlocks + 2; ++i) {
                    if (!fs.get(i) || i - 1 == b.rank) continue;
                    BoolVector resultBv = (BoolVector)result.storage[i];
                    this.setBitForBlock(resultBv, b, true);
                }
            }
            inBlocks = inBlocks.tail;
        }
        return result;
    }

    private boolean fsThroughBlock(Block block, BlockStorage<BoolVector> store, BoolVector temp, Block exitBlock) {
        BoolVector oldValue = store.retrieve(block);
        TapList<FGArrow> flowingArrows = block.flow();
        if (flowingArrows == null) {
            FGArrow dummyArrow = new FGArrow();
            dummyArrow.destination = exitBlock;
            flowingArrows = new TapList<FGArrow>(dummyArrow, null);
        }
        BoolVector newValue = temp;
        newValue.setTrue();
        TapList<FGArrow> inArrows = flowingArrows;
        while (inArrows != null) {
            FGArrow arrow = (FGArrow)inArrows.head;
            BoolVector inputValue = store.retrieve(arrow.destination);
            newValue.cumulAnd(inputValue);
            inArrows = inArrows.tail;
        }
        this.setBitForBlock(newValue, block, true);
        if (!oldValue.equals(newValue, this.nbBlocks + 2)) {
            oldValue.setCopy(newValue);
            return true;
        }
        return false;
    }

    private boolean computeControllersForBlock(Block block, BoolVector newValue, BlockStorage<BoolVector> fsStorage, BlockStorage<BoolVector> storage) {
        BoolVector oldValue = storage.retrieve(block);
        BoolVector forcedSuccessor = fsStorage.retrieve(block);
        newValue.setFalse();
        TapList<FGArrow> inArrows = block.backFlow();
        while (inArrows != null) {
            Block upBlock = ((FGArrow)inArrows.head).origin;
            if (upBlock.isControl()) {
                this.setBitForBlock(newValue, upBlock, true);
            }
            newValue.cumulOr(storage.retrieve(upBlock), this.nbBlocks + 2);
            inArrows = inArrows.tail;
        }
        if (forcedSuccessor != null) {
            newValue.cumulMinus(forcedSuccessor);
        }
        for (LoopBlock container = block.enclosingLoop(); container != null; container = container.enclosingLoop()) {
            HeaderBlock containerHeader = container.header();
            if (containerHeader == null) continue;
            this.setBitForBlock(newValue, containerHeader, true);
        }
        if (!newValue.equals(oldValue, this.nbBlocks + 2)) {
            oldValue.setCopy(newValue);
            return true;
        }
        return false;
    }

    private void allocateTestZones(BlockStorage<BoolVector> storage) {
        TapIntList[] coControlles = new TapIntList[this.nbBlocks];
        int[] nbOfControlledBlocks = new int[this.nbBlocks];
        TapList<Block> blocks = this.allBlocks;
        while (blocks != null) {
            Block block = (Block)blocks.head;
            BoolVector bv = storage.retrieve(block);
            for (int i = 1; i < this.nbBlocks + 1; ++i) {
                if (!bv.get(i)) continue;
                int n = i - 1;
                nbOfControlledBlocks[n] = nbOfControlledBlocks[n] + 1;
                for (int j = i + 1; j < this.nbBlocks + 1; ++j) {
                    if (!bv.get(j)) continue;
                    if (coControlles[i - 1] == null || !TapIntList.contains(coControlles[i - 1], j - 1)) {
                        coControlles[i - 1] = new TapIntList(j - 1, coControlles[i - 1]);
                    }
                    if (coControlles[j - 1] != null && TapIntList.contains(coControlles[j - 1], i - 1)) continue;
                    coControlles[j - 1] = new TapIntList(i - 1, coControlles[j - 1]);
                }
            }
            blocks = blocks.tail;
        }
        TapList<Block> controllingBlocks = null;
        blocks = this.allBlocks;
        while (blocks != null) {
            Block b = (Block)blocks.head;
            if (b.isControl()) {
                if (controllingBlocks == null) {
                    controllingBlocks = new TapList<Block>(b, null);
                } else {
                    TapList<Block> appendTo = controllingBlocks;
                    TapList<Block> last = null;
                    while (nbOfControlledBlocks[((Block)appendTo.head).rank] >= nbOfControlledBlocks[b.rank] && appendTo.tail != null) {
                        last = appendTo;
                        appendTo = appendTo.tail;
                    }
                    if (nbOfControlledBlocks[((Block)appendTo.head).rank] < nbOfControlledBlocks[b.rank]) {
                        if (last != null) {
                            last.tail = new TapList<Block>(b, appendTo);
                        } else {
                            controllingBlocks = new TapList<Block>(b, appendTo);
                        }
                    } else {
                        appendTo.tail = new TapList<Block>(b, appendTo.tail);
                    }
                }
            }
            blocks = blocks.tail;
        }
        blocks = this.allBlocks;
        int maxDepth = 0;
        while (blocks != null) {
            Block b = (Block)blocks.head;
            TapList<Instruction> instructions = b.instructions;
            while (instructions != null) {
                int depth;
                Instruction instruction = (Instruction)instructions.head;
                if (instruction.whereMask() != null && (depth = instruction.whereMask().depth()) > maxDepth) {
                    maxDepth = depth;
                }
                instructions = instructions.tail;
            }
            blocks = blocks.tail;
        }
        int[] testZones = new int[this.nbBlocks + 2];
        this.testZonesNb = -1;
        for (int i = testZones.length - 1; i >= 0; --i) {
            testZones[i] = -1;
        }
        while (controllingBlocks != null) {
            Block b = (Block)controllingBlocks.head;
            TapIntList list = coControlles[b.rank];
            int max = -1;
            while (list != null) {
                int co = list.head;
                if (testZones[co + 1] > max) {
                    max = testZones[co + 1];
                }
                list = list.tail;
            }
            testZones[b.rank + 1] = max + 1;
            if (max + 1 > this.testZonesNb) {
                this.testZonesNb = max + 1;
            }
            controllingBlocks = controllingBlocks.tail;
        }
        this.testZonesNb = this.testZonesNb + 1 + maxDepth;
        blocks = this.allBlocks();
        while (blocks != null) {
            Block b = (Block)blocks.head;
            b.testZone = testZones[b.rank + 1];
            blocks = blocks.tail;
        }
    }

    private boolean[] allocateFlowGraphVector() {
        boolean[] fgVector = new boolean[this.nbBlocks + 2];
        for (int i = fgVector.length - 1; i >= 0; --i) {
            fgVector[i] = true;
        }
        return fgVector;
    }

    protected void computeAllDominatorlikeInfo() {
        this.computePredecessors();
        this.computeSucessors();
        this.computeDominator();
        this.computePostDominator();
        this.computeReachability();
    }

    private void computePredecessors() {
        boolean[] fgVector = this.allocateFlowGraphVector();
        BoolVector tempVector = this.buildBitVectorOnBlocks();
        this.entryBlock.predecessor = this.buildBitVectorOnBlocks();
        this.exitBlock.predecessor = this.buildBitVectorOnBlocks();
        TapList<Block> inBlocks = this.allBlocks;
        while (inBlocks != null) {
            ((Block)inBlocks.head).predecessor = this.buildBitVectorOnBlocks();
            inBlocks = inBlocks.tail;
        }
        block1: while (true) {
            inBlocks = this.allBlocks;
            while (inBlocks != null) {
                if (Unit.marked(fgVector, (Block)inBlocks.head)) {
                    Unit.mark(fgVector, (Block)inBlocks.head, false);
                    tempVector.setFalse();
                    TapList<FGArrow> backFlow = ((Block)inBlocks.head).backFlow();
                    while (backFlow != null) {
                        tempVector.cumulOr(((FGArrow)backFlow.head).origin.predecessor);
                        this.setBitForBlock(tempVector, ((FGArrow)backFlow.head).origin, true);
                        backFlow = backFlow.tail;
                    }
                    if (!this.equalsBoolVector(((Block)inBlocks.head).predecessor, tempVector)) {
                        ((Block)inBlocks.head).predecessor.setCopy(tempVector);
                        if (Unit.markDownStreamBlock(fgVector, (Block)inBlocks.head, true)) continue block1;
                    }
                }
                inBlocks = inBlocks.tail;
            }
            break;
        }
        BoolVector exitBlockPredecessor = this.exitBlock.predecessor;
        TapList<FGArrow> backFlow = this.exitBlock.backFlow();
        while (backFlow != null) {
            exitBlockPredecessor.cumulOr(((FGArrow)backFlow.head).origin.predecessor);
            this.setBitForBlock(exitBlockPredecessor, ((FGArrow)backFlow.head).origin, true);
            backFlow = backFlow.tail;
        }
    }

    private void computeSucessors() {
        boolean[] fgVector = this.allocateFlowGraphVector();
        BoolVector tempVector = this.buildBitVectorOnBlocks();
        this.entryBlock.successor = this.buildBitVectorOnBlocks();
        this.exitBlock.successor = this.buildBitVectorOnBlocks();
        TapList<Block> inBlocks = this.allBlocks;
        while (inBlocks != null) {
            ((Block)inBlocks.head).successor = this.buildBitVectorOnBlocks();
            inBlocks = inBlocks.tail;
        }
        inBlocks = this.allBlocks;
        while (inBlocks != null) {
            if (((Block)inBlocks.head).flow() == null) {
                Unit.markUpStreamBlock(fgVector, (Block)inBlocks.head, true);
            }
            inBlocks = inBlocks.tail;
        }
        block2: while (true) {
            inBlocks = TapList.reverse(this.allBlocks);
            while (inBlocks != null) {
                if (Unit.marked(fgVector, (Block)inBlocks.head)) {
                    Unit.mark(fgVector, (Block)inBlocks.head, false);
                    tempVector.setFalse();
                    TapList<FGArrow> flow = ((Block)inBlocks.head).flow();
                    while (flow != null) {
                        tempVector.cumulOr(((FGArrow)flow.head).destination.successor);
                        this.setBitForBlock(tempVector, ((FGArrow)flow.head).destination, true);
                        flow = flow.tail;
                    }
                    if (!this.equalsBoolVector(((Block)inBlocks.head).successor, tempVector)) {
                        ((Block)inBlocks.head).successor.setCopy(tempVector);
                        if (Unit.markUpStreamBlock(fgVector, (Block)inBlocks.head, true)) continue block2;
                    }
                }
                inBlocks = inBlocks.tail;
            }
            break;
        }
        BoolVector entryBlockSuccessor = this.entryBlock.successor;
        if (this.entryBlock.flow() != null) {
            entryBlockSuccessor.setCopy(((FGArrow)this.entryBlock.flow().head).destination.successor);
            this.setBitForBlock(entryBlockSuccessor, ((FGArrow)this.entryBlock.flow().head).destination, true);
        }
    }

    private void computePostDominator() {
        boolean[] fgVector = this.allocateFlowGraphVector();
        BoolVector tempVector = this.buildBitVectorOnBlocks();
        this.exitBlock.postDominator = this.buildBitVectorOnBlocks();
        this.setBitForBlock(this.exitBlock.postDominator, this.exitBlock, true);
        this.entryBlock.postDominator = this.buildBitVectorOnBlocks();
        this.entryBlock.postDominator.setTrue();
        TapList<Block> inBlocks = this.allBlocks;
        while (inBlocks != null) {
            ((Block)inBlocks.head).postDominator = this.buildBitVectorOnBlocks();
            ((Block)inBlocks.head).postDominator.setTrue();
            inBlocks = inBlocks.tail;
        }
        block1: while (true) {
            inBlocks = TapList.reverse(this.allBlocks);
            while (inBlocks != null) {
                if (Unit.marked(fgVector, (Block)inBlocks.head)) {
                    Unit.mark(fgVector, (Block)inBlocks.head, false);
                    TapList<FGArrow> flow = ((Block)inBlocks.head).flow();
                    BoolVector workVector = ((Block)inBlocks.head).postDominator;
                    tempVector.setCopy(workVector);
                    while (flow != null) {
                        workVector.cumulAnd(((FGArrow)flow.head).destination.postDominator);
                        flow = flow.tail;
                    }
                    this.setBitForBlock(workVector, (Block)inBlocks.head, true);
                    if (!this.equalsBoolVector(workVector, tempVector) && Unit.markUpStreamBlock(fgVector, (Block)inBlocks.head, true)) continue block1;
                }
                inBlocks = inBlocks.tail;
            }
            break;
        }
        BoolVector workVector = this.entryBlock.postDominator;
        if (this.entryBlock.flow() != null) {
            workVector.setCopy(((FGArrow)this.entryBlock.flow().head).destination.postDominator);
            this.setBitForBlock(workVector, ((FGArrow)this.entryBlock.flow().head).destination, true);
        }
        if (this.allBlocks != null) {
            Block[] blocks = this.toObjectArray(this.allBlocks());
            inBlocks = this.allBlocks;
            while (inBlocks != null) {
                tempVector.setCopy(((Block)inBlocks.head).postDominator);
                this.setBitForBlock(tempVector, (Block)inBlocks.head, false);
                for (int i = 1; i < this.nbBlocks + 2; ++i) {
                    Block block = i == this.nbBlocks + 1 ? this.exitBlock : blocks[i - 1];
                    if (!tempVector.get(i) || !this.equalsBoolVector(block.postDominator, tempVector)) continue;
                    ((Block)inBlocks.head).immediatePostDominator = block;
                    break;
                }
                inBlocks = inBlocks.tail;
            }
        }
        if (this.entryBlock.flow() != null) {
            this.entryBlock.immediatePostDominator = ((FGArrow)this.entryBlock.flow().head).destination;
        }
    }

    private void computeDominator() {
        boolean[] fgVector = this.allocateFlowGraphVector();
        BoolVector tempVector = this.buildBitVectorOnBlocks();
        this.entryBlock.dominator = this.buildBitVectorOnBlocks();
        this.setBitForBlock(this.entryBlock.dominator, this.entryBlock, true);
        this.exitBlock.dominator = this.buildBitVectorOnBlocks();
        this.exitBlock.dominator.setTrue();
        TapList<Block> inBlocks = this.allBlocks;
        while (inBlocks != null) {
            ((Block)inBlocks.head).dominator = this.buildBitVectorOnBlocks();
            ((Block)inBlocks.head).dominator.setTrue();
            inBlocks = inBlocks.tail;
        }
        for (int i = fgVector.length - 1; i >= 0; --i) {
            fgVector[i] = true;
        }
        block2: while (true) {
            inBlocks = this.allBlocks;
            while (inBlocks != null) {
                if (Unit.marked(fgVector, (Block)inBlocks.head)) {
                    Unit.mark(fgVector, (Block)inBlocks.head, false);
                    TapList<FGArrow> backFlow = ((Block)inBlocks.head).backFlow();
                    BoolVector workVector = ((Block)inBlocks.head).dominator;
                    tempVector.setCopy(workVector);
                    while (backFlow != null) {
                        workVector.cumulAnd(((FGArrow)backFlow.head).origin.dominator);
                        backFlow = backFlow.tail;
                    }
                    this.setBitForBlock(workVector, (Block)inBlocks.head, true);
                    if (!this.equalsBoolVector(workVector, tempVector) && Unit.markDownStreamBlock(fgVector, (Block)inBlocks.head, true)) continue block2;
                }
                inBlocks = inBlocks.tail;
            }
            break;
        }
        BoolVector workVector = this.exitBlock.dominator;
        TapList<FGArrow> backFlow = this.exitBlock.backFlow();
        while (backFlow != null) {
            workVector.cumulAnd(((FGArrow)backFlow.head).origin.dominator);
            backFlow = backFlow.tail;
        }
        this.setBitForBlock(workVector, this.exitBlock, true);
        if (this.allBlocks() != null) {
            int i;
            Block[] blocks = this.toObjectArray(this.allBlocks());
            inBlocks = this.allBlocks;
            while (inBlocks != null) {
                tempVector.setCopy(((Block)inBlocks.head).dominator);
                if (((Block)inBlocks.head).rank == 0) {
                    ((Block)inBlocks.head).immediateDominator = this.entryBlock;
                } else {
                    this.setBitForBlock(tempVector, (Block)inBlocks.head, false);
                    for (i = 1; i < this.nbBlocks + 1; ++i) {
                        if (!tempVector.get(i) || !this.equalsBoolVector(blocks[i - 1].dominator, tempVector)) continue;
                        ((Block)inBlocks.head).immediateDominator = blocks[i - 1];
                        break;
                    }
                }
                inBlocks = inBlocks.tail;
            }
            tempVector.setCopy(this.exitBlock.dominator);
            this.setBitForBlock(tempVector, this.exitBlock, false);
            for (i = 1; i < this.nbBlocks + 1; ++i) {
                if (!tempVector.get(i) || !this.equalsBoolVector(blocks[i - 1].dominator, tempVector)) continue;
                this.exitBlock.immediateDominator = blocks[i - 1];
                break;
            }
        } else {
            this.exitBlock.immediateDominator = this.entryBlock;
        }
    }

    public void computeDominatorArrows() {
        Block block;
        TapList<Block> inAllBlocks = this.allBlocks;
        int nbOfArrows = this.nbArrows;
        this.entryBlock.setDominatorArrows(new BoolVector(nbOfArrows));
        this.entryBlock.setControlStruct(null);
        while (inAllBlocks != null) {
            block = (Block)inAllBlocks.head;
            BoolVector boolVect = new BoolVector(nbOfArrows);
            boolVect.setTrue();
            block.setDominatorArrows(boolVect);
            block.setControlStruct(null);
            inAllBlocks = inAllBlocks.tail;
        }
        this.exitBlock.setDominatorArrows(new BoolVector(nbOfArrows));
        this.exitBlock.setControlStruct(null);
        boolean runAgain = true;
        while (runAgain) {
            runAgain = false;
            inAllBlocks = this.allBlocks;
            while (inAllBlocks != null) {
                block = (Block)inAllBlocks.head;
                BoolVector domIn = this.accumulateDomIn(block, nbOfArrows);
                if (!block.getDominatorArrows().equals(domIn, nbOfArrows)) {
                    block.setDominatorArrows(domIn);
                    runAgain = true;
                }
                inAllBlocks = inAllBlocks.tail;
            }
        }
    }

    private BoolVector accumulateDomIn(Block block, int nbOfArrows) {
        BoolVector domIn = new BoolVector(nbOfArrows);
        domIn.setTrue();
        TapList<FGArrow> arrows = block.backFlow();
        while (arrows != null) {
            FGArrow fgArrow = (FGArrow)arrows.head;
            Block origin = fgArrow.origin;
            BoolVector domIncoming = origin.getDominatorArrows().copy();
            if (fgArrow.goesInsideControl()) {
                domIncoming.set(fgArrow.rank, true);
            } else {
                this.removeExitedNamespacesAndParallelControls(fgArrow, domIncoming);
            }
            TapList<TapPair<Integer, LoopBlock>> inIter = fgArrow.iter;
            LoopBlock loopBlock = null;
            while (inIter != null && ((Integer)((TapPair)inIter.head).first).equals(FGConstants.POP)) {
                if (((LoopBlock)((TapPair)inIter.head).second).header() != block) {
                    loopBlock = (LoopBlock)((TapPair)inIter.head).second;
                }
                inIter = inIter.tail;
            }
            if (loopBlock != null) {
                domIncoming = this.accumulateDomIn(loopBlock.header(), nbOfArrows);
            }
            this.removeExitedNamespacesAndParallelControls(fgArrow, domIncoming);
            while (inIter != null) {
                FGArrow loopArrow;
                if (((Integer)((TapPair)inIter.head).first).equals(FGConstants.PUSH) && block != (loopBlock = (LoopBlock)((TapPair)inIter.head).second).header() && (loopArrow = loopBlock.header().getFGArrowTestCase(30, 1)) != null) {
                    domIncoming.set(loopArrow.rank, true);
                }
                inIter = inIter.tail;
            }
            if (fgArrow.isAJumpIntoNextCase) {
                domIncoming = null;
            }
            if (domIncoming != null) {
                domIn.cumulAnd(domIncoming);
            }
            arrows = arrows.tail;
        }
        return domIn;
    }

    private void removeExitedNamespacesAndParallelControls(FGArrow arrow, BoolVector domVector) {
        SymbolTable commonRoot = arrow.origin.symbolTable.getCommonRoot(arrow.destination.symbolTable);
        for (int arrowIndex = arrow.rank - 1; arrowIndex >= 0; --arrowIndex) {
            if (!domVector.get(arrowIndex)) continue;
            FGArrow oneArrow = this.getArrow(arrowIndex);
            if ((!oneArrow.origin.isANameSpace() || commonRoot.nestedIn(oneArrow.destination.symbolTable)) && (!oneArrow.origin.isParallelController() || TapList.contains(arrow.destination.parallelControls, oneArrow.origin.lastInstr()))) continue;
            domVector.set(arrowIndex, false);
        }
    }

    private void computeReachability() {
        Block block;
        TapList<Block> inBlocks = this.allBlocks;
        while (inBlocks != null) {
            Object value;
            block = (Block)inBlocks.head;
            if (block.lastInstr() != null && block.lastInstr().tree != null && block.lastInstr().tree.opCode() == 96 && (value = block.symbolTable.staticValue(block.lastInstr().tree.down(1))) instanceof Boolean) {
                Boolean v = (Boolean)value;
                int test = v != false ? 5 : 2;
                TapList<FGArrow> nonReachableArrow = Unit.findFlowArrow(block, test);
                while (nonReachableArrow != null) {
                    ((FGArrow)nonReachableArrow.head).reachable = false;
                    nonReachableArrow = nonReachableArrow.tail;
                }
            }
            inBlocks = inBlocks.tail;
        }
        inBlocks = this.allBlocks;
        while (inBlocks != null) {
            block = (Block)inBlocks.head;
            if (this.allIncomingArrowsNonReachable(block)) {
                this.setForcedSuccessorsAsNonReachable(block);
            }
            inBlocks = inBlocks.tail;
        }
    }

    private boolean allIncomingArrowsNonReachable(Block origin) {
        TapList<FGArrow> backFlow = origin.backFlow();
        while (backFlow != null) {
            if (((FGArrow)backFlow.head).reachable) {
                return false;
            }
            backFlow = backFlow.tail;
        }
        return true;
    }

    private void setForcedSuccessorsAsNonReachable(Block block) {
        block.reachable = false;
        TapList<Block> inBlocks = this.allBlocks;
        while (inBlocks != null) {
            if (Unit.getBitForBlock(((Block)inBlocks.head).dominator, block)) {
                ((Block)inBlocks.head).reachable = false;
            }
            inBlocks = inBlocks.tail;
        }
    }

    private Block[] toObjectArray(TapList<Block> blocks) {
        int s = TapList.length(blocks);
        Block[] array = new Block[s];
        int u = 0;
        while (blocks != null) {
            array[u] = (Block)blocks.head;
            blocks = blocks.tail;
            ++u;
        }
        return array;
    }

    private BoolVector buildBitVectorOnBlocks() {
        return new BoolVector(this.nbBlocks + 2);
    }

    private void setBitForBlock(BoolVector bVector, Block block, boolean value) {
        bVector.set(block.rank + 1, value);
    }

    private boolean equalsBoolVector(BoolVector b1, BoolVector b2) {
        return b1.equals(b2, this.nbBlocks + 2);
    }

    protected TapList<Block> blocksFromBitVector(BoolVector bv) {
        TapList<ExitBlock> result = null;
        if (bv != null) {
            if (Unit.getBitForBlock(bv, this.exitBlock)) {
                result = new TapList<ExitBlock>(this.exitBlock, result);
            }
            TapList<Block> reverseBlocks = TapList.reverse(this.allBlocks);
            while (reverseBlocks != null) {
                if (Unit.getBitForBlock(bv, (Block)reverseBlocks.head)) {
                    result = new TapList<ExitBlock>((ExitBlock)reverseBlocks.head, result);
                }
                reverseBlocks = reverseBlocks.tail;
            }
            if (Unit.getBitForBlock(bv, this.entryBlock)) {
                result = new TapList<ExitBlock>((ExitBlock)((Object)this.entryBlock), result);
            }
        }
        return result;
    }

    public BoolVector unitInOutN() {
        return this.unitInOutN;
    }

    public BoolVector unitInOutR() {
        return this.unitInOutR;
    }

    public BoolVector unitInOutW() {
        return this.unitInOutW;
    }

    public BoolVector unitInOutRW() {
        return this.unitInOutRW;
    }

    public BoolVector unitInOutCertainlyR() {
        return this.unitInOutN.not().minus(this.unitInOutW);
    }

    public BoolVector unitInOutCertainlyW() {
        if (this.unitInOutN == null) {
            return null;
        }
        return this.unitInOutN.not().minus(this.unitInOutR);
    }

    public BoolVector unitInOutPossiblyR() {
        if (this.unitInOutR == null) {
            return this.unitInOutRW;
        }
        return this.unitInOutR.or(this.unitInOutRW);
    }

    public BoolVector unitInOutPossiblyW() {
        if (this.unitInOutW == null) {
            return this.unitInOutRW;
        }
        return this.unitInOutW.or(this.unitInOutRW);
    }

    public BoolVector unitInOutPossiblyRorW() {
        return this.unitInOutR.or(this.unitInOutW).or(this.unitInOutRW);
    }

    public void dumpDataFlow(boolean dumpPointers, boolean dumpInOut, boolean dumpDeps, boolean dumpInside) throws IOException {
        TapEnv.print(" External data-dep info on entry of unit " + this + ':');
        TapEnv.println();
        int[] unitPublicMap = new int[]{0, this.paramElemsNb()};
        String unitPublicMapName = "[x" + this.rank() + ":a]";
        int[] unitPublicPlusNUPMap = new int[]{0, this.paramElemsNb(), this.paramElemsNb() + 2};
        String unitPublicPlusNUPMapName = "[x" + this.rank() + ":a|nup2]";
        TapEnv.print("  === In-Out __ (global): ");
        if (this.unitInOutN != null) {
            TapEnv.dumpBoolVector(this.unitInOutN, unitPublicMap, unitPublicMapName);
        } else {
            TapEnv.print("null");
        }
        TapEnv.println();
        TapEnv.print("  === In-Out R_ (global): ");
        if (this.unitInOutR != null) {
            TapEnv.dumpBoolVector(this.unitInOutR, unitPublicMap, unitPublicMapName);
        } else {
            TapEnv.print("null");
        }
        TapEnv.println();
        TapEnv.print("  === In-Out _W (global): ");
        if (this.unitInOutW != null) {
            TapEnv.dumpBoolVector(this.unitInOutW, unitPublicMap, unitPublicMapName);
        } else {
            TapEnv.print("null");
        }
        TapEnv.println();
        TapEnv.print("  === In-Out RW (global): ");
        if (this.unitInOutRW != null) {
            TapEnv.dumpBoolVector(this.unitInOutRW, unitPublicMap, unitPublicMapName);
        } else {
            TapEnv.print("null");
        }
        TapEnv.println();
        if (dumpDeps) {
            TapEnv.print("  === Plain Dependencies matrix:" + unitPublicMapName + "*" + unitPublicMapName);
            if (this.unitDependencies != null) {
                TapEnv.println();
                TapEnv.dumpObject(this.unitDependencies);
            } else {
                TapEnv.print(" null");
                TapEnv.println();
            }
            ADActivityAnalyzer adActivityAnalyzer = TapEnv.adActivityAnalyzer();
            TapEnv.print("  === Differentiable Dependencies matrix:" + unitPublicMapName + "*" + unitPublicMapName);
            if (adActivityAnalyzer != null && adActivityAnalyzer.getPublicDeps(this) != null) {
                TapEnv.println();
                TapEnv.dumpObject(adActivityAnalyzer.getPublicDeps(this));
            } else {
                TapEnv.print(" null");
                TapEnv.println();
            }
        }
        TapList<ActivityPattern> activitiesList = this.specificInfoAD;
        int activityNumber = 0;
        while (activitiesList != null) {
            BlockStorage<TapList<BoolVector>> usefulnesses;
            BlockStorage<TapList<BoolVector>> activities;
            TapEnv.print("  ### Activity Context number " + ++activityNumber + " ###");
            TapEnv.println();
            ActivityPattern curActivity = (ActivityPattern)activitiesList.head;
            if (curActivity.callActivity() != null) {
                TapTriplet<Unit, BoolVector, BoolVector>[] varFunctionInfos;
                TapEnv.print("  === Activity    /entry: ");
                TapEnv.dumpBoolVector(curActivity.callActivity(), unitPublicMap, unitPublicMapName);
                if (curActivity.callUsefulness() != null) {
                    TapEnv.println();
                    TapEnv.print("  === Usefulness  /entry: ");
                    TapEnv.dumpBoolVector(curActivity.callUsefulness(), unitPublicMap, unitPublicMapName);
                }
                if (!TapEnv.doActivity()) {
                    TapEnv.print(" NO OPTIM activity!");
                }
                TapEnv.println();
                activities = curActivity.activities();
                usefulnesses = curActivity.usefulnesses();
                if (TapEnv.doActivity() && (varFunctionInfos = curActivity.varFunctionADActivities()) != null) {
                    String startline = "  === varFunction actvty: ";
                    for (int i = 0; i < varFunctionInfos.length; ++i) {
                        if (varFunctionInfos[i] == null) continue;
                        TapEnv.print(startline + "Arg" + (i + 1) + ':');
                        startline = " ; ";
                        TapEnv.dumpObject(varFunctionInfos[i].second);
                        TapEnv.print("=>");
                        TapEnv.dumpObject(varFunctionInfos[i].third);
                    }
                    if (startline.equals(" ; ")) {
                        TapEnv.println();
                    }
                }
            } else {
                activities = null;
                usefulnesses = null;
            }
            BlockStorage<TapList<BoolVector>> reqXs = curActivity.reqXs();
            BlockStorage<TapList<BoolVector>> avlXs = curActivity.avlXs();
            BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> livenesses = curActivity.diffLivenesses();
            BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> livenessesCkp = curActivity.diffLivenessesCkp();
            BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> overwrites = curActivity.diffOverwrites();
            BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> overwritesCkp = curActivity.diffOverwritesCkp();
            BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> tbrs = curActivity.tbrs();
            BlockStorage<TapList<TapList<Instruction>>> recomps = curActivity.recomps();
            if (!TapEnv.debugActivity()) {
                TapEnv.print("  === ReqX        /entry: ");
                TapEnv.dumpBoolVector(curActivity.entryReqX(), unitPublicMap, unitPublicMapName);
                TapEnv.println();
                TapEnv.print("  === AvlX        /entry: ");
                TapEnv.dumpBoolVector(curActivity.entryAvlX(), unitPublicMap, unitPublicMapName);
                TapEnv.println();
                TapEnv.print("  === Loc DiffLive/entry: ");
                TapEnv.dumpBoolVector(curActivity.entryDiffLivenessesCkp(), unitPublicMap, unitPublicMapName);
                TapEnv.print(" Ptr:");
                TapEnv.dumpBoolVector(curActivity.entryDiffLivenessesCkpOnDiffPtr(), unitPublicMap, unitPublicMapName);
                TapEnv.println();
                TapEnv.print("  === Loc DiffOwrt/entry: ");
                TapEnv.dumpBoolVector(curActivity.entryDiffOverwritesCkp(), unitPublicMap, unitPublicMapName);
                TapEnv.print(" Ptr:");
                TapEnv.dumpBoolVector(curActivity.entryDiffOverwritesCkpOnDiffPtr(), unitPublicMap, unitPublicMapName);
                TapEnv.println();
                TapEnv.print("  === TBR reqrd on entry: ");
                TapEnv.dumpBoolVector(curActivity.adTBRTopDownContext(), unitPublicMap, unitPublicMapName);
                TapEnv.println();
            }
            if (this.hasSource() && dumpInside) {
                TapList<TapPair<BoolVector, BoolVector>> overwriteList;
                TapList<TapPair<BoolVector, BoolVector>> livenessList;
                TapList<BoolVector> reqXsList;
                int[] unitAllMap = DataFlowAnalyzer.makeMap3(this, 0);
                String unitAllMapName = "[s" + this.rank() + ":a||d" + this.publicSymbolTable().rank() + ":a]";
                int[] unitDiffMap = DataFlowAnalyzer.makeMap3(this, TapEnv.diffKind());
                String unitDiffMapName = "[s" + this.rank() + ":r||d" + this.publicSymbolTable().rank() + ":r]";
                int[] unitDiffPtrMap = DataFlowAnalyzer.makeMap3(this, 3);
                String unitDiffPtrMapName = "[s" + this.rank() + ":p||d" + this.publicSymbolTable().rank() + ":p]";
                TapEnv.print("  -----------------------------------------------------");
                TapEnv.println();
                TapEnv.print("  Control zones:");
                this.dumpControlZones(1);
                TapEnv.print(" Local data-dep info: Entry Block:     " + this.entryBlock.citeFlowShort());
                TapEnv.println();
                if (dumpInOut && !TapEnv.debugActivity()) {
                    TapEnv.print("  === Constant till end : ");
                    TapEnv.dumpBoolVector(this.entryBlock.constantZones, unitAllMap, unitAllMapName);
                    TapEnv.println();
                    TapEnv.print("  === Dead at this point: ");
                    TapEnv.dumpBoolVector(this.entryBlock.unusedZones, unitAllMap, unitAllMapName);
                    TapEnv.println();
                }
                if (activities != null) {
                    TapEnv.print("  === Activity          : ");
                    TapEnv.dumpBoolVector((BoolVector)activities.retrieve((Block)this.entryBlock).head, unitDiffMap, unitDiffMapName);
                    TapEnv.println();
                }
                if (usefulnesses != null) {
                    TapEnv.print("  === Usefulness        : ");
                    TapEnv.dumpBoolVector((BoolVector)usefulnesses.retrieve((Block)this.entryBlock).head, unitDiffMap, unitDiffMapName);
                    TapEnv.println();
                }
                if (reqXs != null && !TapEnv.debugActivity() && (reqXsList = reqXs.retrieve(this.entryBlock)) != null) {
                    TapEnv.print("  === ReqX upon entry   : ");
                    TapEnv.dumpBoolVector((BoolVector)reqXsList.head, unitAllMap, unitAllMapName);
                    TapEnv.println();
                }
                if (avlXs != null && !TapEnv.debugActivity()) {
                    TapEnv.print("  === AvlX upon entry   : ");
                    TapEnv.dumpBoolVector((BoolVector)avlXs.retrieve((Block)this.entryBlock).head, unitAllMap, unitAllMapName);
                    TapEnv.println();
                }
                if (livenesses != null && !TapEnv.debugActivity() && (livenessList = livenesses.retrieve(this.entryBlock)) != null) {
                    TapEnv.print("  === Diff Liveness     : ");
                    TapEnv.dumpBoolVector((BoolVector)((TapPair)livenessList.head).first, unitAllMap, unitAllMapName);
                    TapEnv.print(" Ptr:");
                    TapEnv.dumpBoolVector((BoolVector)((TapPair)livenessList.head).second, unitDiffPtrMap, unitDiffPtrMapName);
                    TapEnv.println();
                }
                if (livenessesCkp != null && !TapEnv.debugActivity() && (livenessList = livenessesCkp.retrieve(this.entryBlock)) != null) {
                    TapEnv.print("  === Diff Liveness Ckp : ");
                    TapEnv.dumpBoolVector((BoolVector)((TapPair)livenessList.head).first, unitAllMap, unitAllMapName);
                    TapEnv.print(" Ptr:");
                    TapEnv.dumpBoolVector((BoolVector)((TapPair)livenessList.head).second, unitDiffPtrMap, unitDiffPtrMapName);
                    TapEnv.println();
                }
                if (overwrites != null && !TapEnv.debugActivity() && (overwriteList = overwrites.retrieve(this.entryBlock)) != null) {
                    TapEnv.print("  === Diff Overwrite    : ");
                    TapEnv.dumpBoolVector((BoolVector)((TapPair)overwriteList.head).first, unitAllMap, unitAllMapName);
                    TapEnv.print(" Ptr:");
                    TapEnv.dumpBoolVector((BoolVector)((TapPair)overwriteList.head).second, unitDiffPtrMap, unitDiffPtrMapName);
                    TapEnv.println();
                }
                if (overwritesCkp != null && !TapEnv.debugActivity() && (overwriteList = overwritesCkp.retrieve(this.entryBlock)) != null) {
                    TapEnv.print("  === Diff Overwrite Ckp: ");
                    TapEnv.dumpBoolVector((BoolVector)((TapPair)overwriteList.head).first, unitAllMap, unitAllMapName);
                    TapEnv.print(" Ptr:");
                    TapEnv.dumpBoolVector((BoolVector)((TapPair)overwriteList.head).second, unitDiffPtrMap, unitDiffPtrMapName);
                    TapEnv.println();
                }
                if (tbrs != null && !TapEnv.debugActivity()) {
                    TapPair entryTBR = (TapPair)tbrs.retrieve((Block)this.entryBlock).head;
                    TapEnv.print("  === TBR upon entry    : " + DataFlowAnalyzer.infoToStringWithDiffPtr((BoolVector)entryTBR.first, unitAllMap, (BoolVector)entryTBR.second, unitDiffPtrMap, this, this.entryBlock.symbolTable));
                    TapEnv.println();
                }
                TapList<Block> blocks = this.allBlocks();
                while (blocks != null) {
                    Block block = (Block)blocks.head;
                    SymbolTable symbolTable = block.symbolTable;
                    int[] blockAllMap = DataFlowAnalyzer.makeMap3(this, block, 0);
                    String blockAllMapName = "[s" + this.rank() + ":a||d" + symbolTable.rank() + ":a]";
                    int[] blockAllCtrlMap = DataFlowAnalyzer.makeMap3(this, block, 0);
                    blockAllCtrlMap[2] = this.testZonesNb;
                    blockAllCtrlMap[3] = blockAllCtrlMap[3] + this.testZonesNb;
                    String blockAllCtrlMapName = "[s" + this.rank() + ":a||d" + symbolTable.rank() + ":a]";
                    int[] blockDiffMap = DataFlowAnalyzer.makeMap3(this, block, TapEnv.diffKind());
                    String blockDiffMapName = "[s" + this.rank() + ":r||d" + symbolTable.rank() + ":r]";
                    int[] blockPointerRowMap = DataFlowAnalyzer.makeMap3(this, block, 3);
                    String blockPointerRowMapName = "[s" + this.rank() + ":p||d" + symbolTable.rank() + ":p]";
                    int[] blockPointerColMap = DataFlowAnalyzer.makeMap3(this.sideEffectZonesNb(0), 2, symbolTable.declaredZonesNb(0));
                    String blockPointerColMapName = "[s" + this.rank() + ":a|NU|d" + symbolTable.rank() + ":a]";
                    int[] blockDiffPtrMap = DataFlowAnalyzer.makeMap3(this.sideEffectZonesNb(3), 0, symbolTable.declaredZonesNb(3));
                    String blockDiffPtrMapName = "[s" + this.rank() + ":p||d" + symbolTable.rank() + ":p]";
                    TapEnv.print(" Local data-dep info: " + block + ":     " + block.citeFlowShort());
                    TapEnv.println();
                    if (block instanceof HeaderBlock && !TapEnv.debugActivity()) {
                        TapEnv.print("  === Localized:" + ((HeaderBlock)block).localizedZones + " UniqueAccess:" + ((HeaderBlock)block).uniqueAccessZones + " TopUniqueAccess:" + ((HeaderBlock)block).topUniqueAccessZones + " LoopComplete:" + ((HeaderBlock)block).loopCompleteZones);
                        TapEnv.println();
                    }
                    TapList<Instruction> instructions = new TapList<Instruction>(null, block.instructions);
                    if (dumpPointers) {
                        TapEnv.print("  === Pointers destinations matrix: ");
                        if (block.pointerInfosIn != null) {
                            TapEnv.print(blockPointerRowMapName + "*" + blockPointerColMapName);
                            TapEnv.println();
                            block.pointerInfosIn.dump(blockPointerRowMap, blockPointerColMap);
                            TapEnv.println();
                        } else {
                            TapEnv.print(" null");
                            TapEnv.println();
                        }
                    }
                    if (dumpInOut && !TapEnv.debugActivity() && block.constantZones != null) {
                        TapEnv.print("  === Constant till end : ");
                        TapEnv.dumpBoolVector(block.constantZones, blockAllMap, blockAllMapName);
                        TapEnv.println();
                    }
                    if (dumpInOut && !TapEnv.debugActivity() && block.unusedZones != null) {
                        TapEnv.print("  === Dead at this point: ");
                        TapEnv.dumpBoolVector(block.unusedZones, blockAllMap, blockAllMapName);
                        TapEnv.println();
                    }
                    TapList<BoolVector> instrsActivities = activities != null ? activities.retrieve(block) : null;
                    TapList<BoolVector> instrsUsefulnesses = usefulnesses != null ? usefulnesses.retrieve(block) : null;
                    TapList<BoolVector> instrsReqXs = reqXs != null ? reqXs.retrieve(block) : null;
                    TapList<BoolVector> instrsAvlXs = avlXs != null ? avlXs.retrieve(block) : null;
                    TapList<TapPair<BoolVector, BoolVector>> instrsLivenesses = livenesses != null ? livenesses.retrieve(block) : null;
                    TapList<TapPair<BoolVector, BoolVector>> instrsLivenessesCkp = livenessesCkp != null ? livenessesCkp.retrieve(block) : null;
                    TapList<TapPair<BoolVector, BoolVector>> instrsOverwrites = overwrites != null ? overwrites.retrieve(block) : null;
                    TapList<TapPair<BoolVector, BoolVector>> instrsOverwritesCkp = overwritesCkp != null ? overwritesCkp.retrieve(block) : null;
                    TapList<TapPair<BoolVector, BoolVector>> instrsTBRs = tbrs != null ? tbrs.retrieve(block) : null;
                    TapList<TapList<Instruction>> instrsRecomps = recomps != null ? recomps.retrieve(block) : null;
                    if (instrsRecomps != null && instrsRecomps.head != null && !TapEnv.debugActivity()) {
                        TapEnv.print("      === Adjoint bwd recomputations: " + instrsRecomps.head);
                        TapEnv.println();
                        instrsRecomps = instrsRecomps.tail;
                    }
                    while (instructions != null) {
                        Instruction instruction = (Instruction)instructions.head;
                        if (instruction != null) {
                            boolean isTBR;
                            TapEnv.print("      " + ILUtils.toString(instruction.tree, curActivity));
                            if (instrsActivities != null && !TapEnv.debugActivity()) {
                                boolean dead2;
                                boolean dead1 = !DiffLivenessAnalyzer.isTreeOrSubtreeRequiredInDiff(curActivity, instruction.tree, true);
                                boolean bl = dead2 = !DiffLivenessAnalyzer.isTreeOrSubtreeRequiredInDiff(curActivity, instruction.tree, false);
                                if (dead1 || dead2) {
                                    TapEnv.print("    DIFF-DEAD" + (dead1 ? ", in adjoint-ckp" : "") + (dead2 ? ", in tangent or adjoint-split" : ""));
                                }
                            }
                            if (instruction.tree != null && instruction.tree.opCode() == 13 && !TapEnv.debugActivity() && (isTBR = ADTBRAnalyzer.isTBR(curActivity, instruction.tree.down(1)))) {
                                TapEnv.print("    TBR!");
                            }
                            TapEnv.println();
                            if (dumpPointers) {
                                TapList<TapPair<TapIntList, BoolVector>> destsChange = instruction.pointerDestsChanges;
                                if (destsChange != null) {
                                    TapEnv.print("      === Pointers destinations update: " + blockPointerRowMapName);
                                }
                                while (destsChange != null) {
                                    TapIntList ptrRks = (TapIntList)((TapPair)destsChange.head).first;
                                    BoolVector ptrRow = (BoolVector)((TapPair)destsChange.head).second;
                                    TapEnv.println();
                                    TapEnv.print("        " + TapEnv.str3(ptrRks.head) + "> ");
                                    TapEnv.dumpBoolVector(ptrRow, blockPointerColMap, blockPointerColMapName);
                                    destsChange = destsChange.tail;
                                }
                                TapEnv.println();
                            }
                        }
                        instructions = instructions.tail;
                        if (instrsActivities != null) {
                            TapEnv.print("      === Activity          : ");
                            TapEnv.dumpBoolVector((BoolVector)instrsActivities.head, blockDiffMap, blockDiffMapName);
                            TapEnv.println();
                            instrsActivities = instrsActivities.tail;
                        }
                        if (instrsUsefulnesses != null) {
                            TapEnv.print("      === Usefulness        : ");
                            TapEnv.dumpBoolVector((BoolVector)instrsUsefulnesses.head, blockDiffMap, blockDiffMapName);
                            TapEnv.println();
                            instrsUsefulnesses = instrsUsefulnesses.tail;
                        }
                        if (instrsReqXs != null && !TapEnv.debugActivity()) {
                            TapEnv.print("      === ReqX              : ");
                            TapEnv.dumpBoolVector((BoolVector)instrsReqXs.head, blockAllMap, blockAllMapName);
                            TapEnv.println();
                            instrsReqXs = instrsReqXs.tail;
                        }
                        if (instrsAvlXs != null && !TapEnv.debugActivity()) {
                            TapEnv.print("      === AvlX              : ");
                            TapEnv.dumpBoolVector((BoolVector)instrsAvlXs.head, blockAllMap, blockAllMapName);
                            TapEnv.println();
                            instrsAvlXs = instrsAvlXs.tail;
                        }
                        if (instrsLivenesses != null && !TapEnv.debugActivity()) {
                            TapEnv.print("      === Diff Liveness     : ");
                            TapEnv.dumpBoolVector((BoolVector)((TapPair)instrsLivenesses.head).first, blockAllCtrlMap, blockAllCtrlMapName);
                            TapEnv.print(" Ptr:");
                            TapEnv.dumpBoolVector((BoolVector)((TapPair)instrsLivenesses.head).second, blockDiffPtrMap, blockDiffPtrMapName);
                            TapEnv.println();
                            instrsLivenesses = instrsLivenesses.tail;
                        }
                        if (instrsLivenessesCkp != null && !TapEnv.debugActivity()) {
                            TapEnv.print("      === Diff Liveness Ckp : ");
                            TapEnv.dumpBoolVector((BoolVector)((TapPair)instrsLivenessesCkp.head).first, blockAllCtrlMap, blockAllCtrlMapName);
                            TapEnv.print(" Ptr:");
                            TapEnv.dumpBoolVector((BoolVector)((TapPair)instrsLivenessesCkp.head).second, blockDiffPtrMap, blockDiffPtrMapName);
                            TapEnv.println();
                            instrsLivenessesCkp = instrsLivenessesCkp.tail;
                        }
                        if (instrsOverwrites != null && !TapEnv.debugActivity()) {
                            TapEnv.print("      === Diff Overwrite    : ");
                            TapEnv.dumpBoolVector((BoolVector)((TapPair)instrsOverwrites.head).first, blockAllMap, blockAllMapName);
                            TapEnv.print(" Ptr:");
                            TapEnv.dumpBoolVector((BoolVector)((TapPair)instrsOverwrites.head).second, blockDiffPtrMap, blockDiffPtrMapName);
                            TapEnv.println();
                            instrsOverwrites = instrsOverwrites.tail;
                        }
                        if (instrsOverwritesCkp != null && !TapEnv.debugActivity()) {
                            TapEnv.print("      === Diff Overwrite Ckp: ");
                            TapEnv.dumpBoolVector((BoolVector)((TapPair)instrsOverwritesCkp.head).first, blockAllMap, blockAllMapName);
                            TapEnv.print(" Ptr:");
                            TapEnv.dumpBoolVector((BoolVector)((TapPair)instrsOverwritesCkp.head).second, blockDiffPtrMap, blockDiffPtrMapName);
                            TapEnv.println();
                            instrsOverwritesCkp = instrsOverwritesCkp.tail;
                        }
                        if (instrsTBRs != null && !TapEnv.debugActivity()) {
                            TapEnv.print("      === TBR               : " + DataFlowAnalyzer.infoToStringWithDiffPtr((BoolVector)((TapPair)instrsTBRs.head).first, blockAllMap, (BoolVector)((TapPair)instrsTBRs.head).second, blockDiffPtrMap, this, symbolTable));
                            TapEnv.println();
                            instrsTBRs = instrsTBRs.tail;
                        }
                        if (instrsRecomps == null || instrsRecomps.head == null || TapEnv.debugActivity()) continue;
                        TapEnv.print("      === Adjoint bwd recomputations: " + instrsRecomps.head);
                        TapEnv.println();
                        instrsRecomps = instrsRecomps.tail;
                    }
                    blocks = blocks.tail;
                }
                TapEnv.print(" Local data-dep info: Exit Block:     " + this.exitBlock.citeFlowShort());
                TapEnv.println();
                if (activities != null) {
                    TapEnv.print("  === Activity          : ");
                    TapEnv.dumpBoolVector((BoolVector)activities.retrieve((Block)this.exitBlock).head, unitDiffMap, unitDiffMapName);
                    TapEnv.println();
                }
                if (usefulnesses != null) {
                    TapEnv.print("  === Usefulness        : ");
                    TapEnv.dumpBoolVector((BoolVector)usefulnesses.retrieve((Block)this.exitBlock).head, unitDiffMap, unitDiffMapName);
                    TapEnv.println();
                }
                if (reqXs != null && !TapEnv.debugActivity() && (reqXsList = reqXs.retrieve(this.exitBlock)) != null) {
                    TapEnv.print("  === ReqX upon exit    : ");
                    TapEnv.dumpBoolVector((BoolVector)reqXsList.head, unitAllMap, unitAllMapName);
                    TapEnv.println();
                }
                if (avlXs != null && !TapEnv.debugActivity()) {
                    TapEnv.print("  === AvlX upon exit    : ");
                    TapEnv.dumpBoolVector((BoolVector)avlXs.retrieve((Block)this.exitBlock).head, unitAllMap, unitAllMapName);
                    TapEnv.println();
                }
                if (livenesses != null && !TapEnv.debugActivity() && (livenessList = livenesses.retrieve(this.exitBlock)) != null) {
                    TapEnv.print("  === Diff Liveness     : ");
                    TapEnv.dumpBoolVector((BoolVector)((TapPair)livenessList.head).first, unitAllMap, unitAllMapName);
                    TapEnv.print(" Ptr:");
                    TapEnv.dumpBoolVector((BoolVector)((TapPair)livenessList.head).second, unitDiffPtrMap, unitDiffPtrMapName);
                    TapEnv.println();
                }
                if (livenessesCkp != null && !TapEnv.debugActivity() && (livenessList = livenessesCkp.retrieve(this.exitBlock)) != null) {
                    TapEnv.print("  === Diff Liveness Ckp : ");
                    TapEnv.dumpBoolVector((BoolVector)((TapPair)livenessList.head).first, unitAllMap, unitAllMapName);
                    TapEnv.print(" Ptr:");
                    TapEnv.dumpBoolVector((BoolVector)((TapPair)livenessList.head).second, unitDiffPtrMap, unitDiffPtrMapName);
                    TapEnv.println();
                }
                if (overwrites != null && !TapEnv.debugActivity() && (overwriteList = overwrites.retrieve(this.exitBlock)) != null) {
                    TapEnv.print("  === Diff Overwrite    : ");
                    TapEnv.dumpBoolVector((BoolVector)((TapPair)overwriteList.head).first, unitAllMap, unitAllMapName);
                    TapEnv.print(" Ptr:");
                    TapEnv.dumpBoolVector((BoolVector)((TapPair)overwriteList.head).second, unitDiffPtrMap, unitDiffPtrMapName);
                    TapEnv.println();
                }
                if (overwritesCkp != null && !TapEnv.debugActivity() && (overwriteList = overwritesCkp.retrieve(this.exitBlock)) != null) {
                    TapEnv.print("  === Diff Overwrite Ckp: ");
                    TapEnv.dumpBoolVector((BoolVector)((TapPair)overwriteList.head).first, unitAllMap, unitAllMapName);
                    TapEnv.print(" Ptr:");
                    TapEnv.dumpBoolVector((BoolVector)((TapPair)overwriteList.head).second, unitDiffPtrMap, unitDiffPtrMapName);
                    TapEnv.println();
                }
                if (tbrs != null && !TapEnv.debugActivity()) {
                    TapPair exitTBR = (TapPair)tbrs.retrieve((Block)this.exitBlock).head;
                    TapEnv.print("  === TBR upon exit     : " + DataFlowAnalyzer.infoToStringWithDiffPtr((BoolVector)exitTBR.first, unitAllMap, (BoolVector)exitTBR.second, unitDiffPtrMap, this, this.exitBlock.symbolTable));
                    TapEnv.println();
                }
            }
            TapEnv.print("  -----------------------------------------------------");
            TapEnv.println();
            TapEnv.print(" External data-dep info on exit from unit " + this + ':');
            TapEnv.println();
            if (dumpPointers) {
                TapEnv.print("  === Pointers destinations public matrix: ");
                if (this.pointerEffect != null) {
                    TapEnv.print(unitPublicMapName + "*" + unitPublicPlusNUPMapName);
                    TapEnv.println();
                    this.pointerEffect.dump(unitPublicMap, unitPublicPlusNUPMap);
                    TapEnv.println();
                } else {
                    TapEnv.print(" null");
                    TapEnv.println();
                }
            }
            TapEnv.print("  === Activity     /exit: ");
            TapEnv.dumpBoolVector(curActivity.exitActivity(), unitPublicMap, unitPublicMapName);
            if (curActivity.exitUsefulness() != null) {
                TapEnv.println();
                TapEnv.print("  === Usefulness   /exit: ");
                TapEnv.dumpBoolVector(curActivity.exitUsefulness(), unitPublicMap, unitPublicMapName);
            }
            if (!TapEnv.doActivity()) {
                TapEnv.print(" NO OPTIM activity!");
            }
            TapEnv.println();
            if (!TapEnv.debugActivity()) {
                TapEnv.print("  === ReqX         /exit: ");
                TapEnv.dumpBoolVector(curActivity.exitReqX(), unitPublicMap, unitPublicMapName);
                TapEnv.println();
                TapEnv.print("  === AvlX         /exit: ");
                TapEnv.dumpBoolVector(curActivity.exitAvlX(), unitPublicMap, unitPublicMapName);
                TapEnv.println();
                TapEnv.print("  === DiffLiveness /exit: ");
                TapEnv.dumpBoolVector(curActivity.exitDiffLivenesses(), unitPublicMap, unitPublicMapName);
                TapEnv.print(" Ptr:");
                TapEnv.dumpBoolVector(curActivity.exitDiffLivenessesOnDiffPtr(), unitPublicMap, unitPublicMapName);
                TapEnv.println();
                TapEnv.print("  === DiffOverwrite/exit: ");
                TapEnv.dumpBoolVector(curActivity.exitDiffOverwrites(), unitPublicMap, unitPublicMapName);
                TapEnv.print(" Ptr:");
                TapEnv.dumpBoolVector(curActivity.exitDiffOverwritesOnDiffPtr(), unitPublicMap, unitPublicMapName);
                TapEnv.println();
                TapEnv.print("  === Local    TBR reqrd: ");
                TapEnv.dumpBoolVector(curActivity.localTBR(), unitPublicMap, unitPublicMapName);
                TapEnv.println();
            }
            TapEnv.print("  ### End of Activity Context number " + activityNumber + " ###");
            TapEnv.println();
            activitiesList = activitiesList.tail;
        }
        TapEnv.println();
    }

    public void turnIntrinsic() {
        if (this.kind != 1) {
            this.callGraph.deleteUnit(this);
            this.setRank(-1);
            this.genericArrow = new CallArrow(null, this);
            this.kind = 1;
            this.callGraph.addIntrinsicUnit(this);
        }
    }

    public void turnExternal() {
        if (this.kind != 2) {
            this.kind = 2;
        }
    }

    private void turnVarFunction(Unit callingUnit) {
        this.setExternalSymbolTable(callingUnit.externalSymbolTable());
        this.kind = 3;
    }

    public void absorbAndDeleteUnit(Unit absorbedUnit) {
        CallArrow callArrow;
        if (this.language == -1) {
            this.language = absorbedUnit.language;
        }
        if (this.position == -1) {
            this.position = absorbedUnit.position;
        }
        if (this.kind == -1) {
            this.kind = absorbedUnit.kind;
        }
        if (this.callGraph == null) {
            this.callGraph = absorbedUnit.callGraph;
        }
        if (this.declaredMemoryMap == null) {
            this.declaredMemoryMap = absorbedUnit.declaredMemoryMap;
        }
        if (this.sideEffectMemoryMap == null) {
            this.sideEffectMemoryMap = absorbedUnit.sideEffectMemoryMap;
        }
        if (this.modifiers == null) {
            this.modifiers = absorbedUnit.modifiers;
        }
        if (this.functionTypeSpec == null) {
            this.functionTypeSpec = absorbedUnit.functionTypeSpec;
        }
        if (this.unitADDependencies == null) {
            this.unitADDependencies = absorbedUnit.unitADDependencies;
        }
        if (this.diffInfo == null) {
            this.diffInfo = absorbedUnit.diffInfo;
        }
        if (absorbedUnit.privateSymbolTable != null) {
            if (this.privateSymbolTable != null && this.privateSymbolTable != absorbedUnit.privateSymbolTable) {
                this.removeDerivedSymbolTable(this.privateSymbolTable);
            }
            this.privateSymbolTable = absorbedUnit.privateSymbolTable;
            this.addDerivedSymbolTable(this.privateSymbolTable);
        }
        if (absorbedUnit.protectedSymbolTable != null) {
            if (this.protectedSymbolTable != null && this.protectedSymbolTable != absorbedUnit.protectedSymbolTable) {
                this.removeDerivedSymbolTable(this.protectedSymbolTable);
            }
            this.protectedSymbolTable = absorbedUnit.protectedSymbolTable;
            this.addDerivedSymbolTable(this.protectedSymbolTable);
        }
        if (absorbedUnit.publicSymbolTable != null) {
            if (this.publicSymbolTable != null && this.publicSymbolTable != absorbedUnit.publicSymbolTable) {
                this.removeDerivedSymbolTable(this.publicSymbolTable);
            }
            this.publicSymbolTable = absorbedUnit.publicSymbolTable;
            this.addDerivedSymbolTable(this.publicSymbolTable);
        }
        this.entryBlock = absorbedUnit.entryBlock;
        this.entryBlock.symbolTable = this.publicSymbolTable;
        this.exitBlock = absorbedUnit.exitBlock;
        this.exitBlock.symbolTable = this.publicSymbolTable;
        if (this.allBlocks == null) {
            this.allBlocks = absorbedUnit.allBlocks;
        }
        if (this.topBlocks == null) {
            this.topBlocks = absorbedUnit.topBlocks;
        }
        if (this.upperLevelUnit != absorbedUnit.upperLevelUnit) {
            TapEnv.toolWarning(-1, "(Unit.absorb) incompatible container units for " + this + " (in " + this.upperLevelUnit + ") absorbing " + absorbedUnit + " (in" + absorbedUnit.upperLevelUnit + ')');
        } else if (this.upperLevelUnit != null) {
            CallGraph.getCallArrow(this.upperLevelUnit, absorbedUnit).delete();
        }
        TapList<Unit> absorbedLowerUnits = absorbedUnit.lowerLevelUnits;
        absorbedUnit.lowerLevelUnits = null;
        TapList<Unit> toCurrentLowerUnits = new TapList<Unit>(null, this.lowerLevelUnits);
        TapList<Unit> toTlCurrentLowerUnits = toCurrentLowerUnits;
        while (toTlCurrentLowerUnits.tail != null) {
            toTlCurrentLowerUnits = toTlCurrentLowerUnits.tail;
        }
        while (absorbedLowerUnits != null) {
            ((Unit)absorbedLowerUnits.head).upperLevelUnit = this;
            toTlCurrentLowerUnits = toTlCurrentLowerUnits.placdl((Unit)absorbedLowerUnits.head);
            absorbedLowerUnits = absorbedLowerUnits.tail;
        }
        this.lowerLevelUnits = toCurrentLowerUnits.tail;
        TapList<CallArrow> callArrows = absorbedUnit.callees;
        while (callArrows != null) {
            callArrow = (CallArrow)callArrows.head;
            callArrow.redirectOrigin(this);
            callArrows = callArrows.tail;
        }
        callArrows = absorbedUnit.callers;
        while (callArrows != null) {
            callArrow = (CallArrow)callArrows.head;
            callArrow.redirectDestination(this);
            callArrows = callArrows.tail;
        }
        if (absorbedUnit.importedModulesUseDecl != null) {
            if (this.importedModulesUseDecl != null) {
                if (!TapList.equalsImportedModules(this.importedModulesUseDecl, absorbedUnit.importedModulesUseDecl)) {
                    String unitMsg = null;
                    if (absorbedUnit.isInterface()) {
                        unitMsg = absorbedUnit.name;
                    } else if (this.isInterface()) {
                        unitMsg = this.name;
                    }
                    if (unitMsg == null) {
                        TapEnv.toolWarning(-1, "(Unit.absorb) Not implemented " + this + " imports modules: " + this.importedModulesUseDecl + " and " + absorbedUnit + " imports modules: " + absorbedUnit.importedModulesUseDecl);
                    } else {
                        TapEnv.fileWarning(15, this.position, "(DD29) interface and procedure " + unitMsg + " use statements differ");
                    }
                }
            } else {
                this.importedModulesUseDecl = absorbedUnit.importedModulesUseDecl;
            }
        }
        absorbedUnit.callGraph.deleteUnit(absorbedUnit);
    }

    protected void absorb(Unit absorbedUnit) {
        CallArrow callArrow;
        TapList<CallArrow> callArrows = absorbedUnit.callees;
        while (callArrows != null) {
            callArrow = (CallArrow)callArrows.head;
            callArrow.redirectOrigin(this);
            callArrows = callArrows.tail;
        }
        callArrows = absorbedUnit.callers;
        while (callArrows != null) {
            callArrow = (CallArrow)callArrows.head;
            callArrow.redirectDestination(this);
            callArrows = callArrows.tail;
        }
        if (absorbedUnit.importedModulesUseDecl != null) {
            if (this.importedModulesUseDecl != null) {
                if (!TapList.equalsImportedModules(this.importedModulesUseDecl, absorbedUnit.importedModulesUseDecl)) {
                    String unitMsg = null;
                    if (absorbedUnit.isInterface()) {
                        unitMsg = absorbedUnit.name;
                    } else if (this.isInterface()) {
                        unitMsg = this.name;
                    }
                    if (unitMsg == null) {
                        TapEnv.toolWarning(-1, "(Unit.absorb) Not implemented " + this + " imports modules: " + this.importedModulesUseDecl + " and " + absorbedUnit + " imports modules: " + absorbedUnit.importedModulesUseDecl);
                    } else {
                        TapEnv.fileWarning(15, this.position, "(DD29) interface and procedure " + unitMsg + " use statements differ");
                    }
                }
            } else {
                this.importedModulesUseDecl = absorbedUnit.importedModulesUseDecl;
            }
        }
    }

    protected void addUseDecl(Tree useDecl, SymbolTable symbolTable) {
        TapEnv.warningFortran77WithFortran90Features(this);
        String moduleName = ILUtils.getIdentString(useDecl.down(1));
        Unit usedModule = symbolTable.getModule(moduleName);
        if (usedModule == null) {
            usedModule = this.callGraph.createNewUnit(null, this.language);
            usedModule.setExternalSymbolTable(this.callGraph.languageRootSymbolTable(this.language));
            usedModule.kind = -1;
            usedModule.name = moduleName;
            FunctionDecl globalModDecl = new FunctionDecl(useDecl.down(1), usedModule);
            this.callGraph.languageRootSymbolTable(this.language).addSymbolDecl(globalModDecl);
        }
        this.importedModulesUseDecl = TapList.append(this.importedModulesUseDecl, new TapList<Tree>(useDecl, null));
        CallGraph.addCallArrow(this, 2, usedModule);
    }

    public Unit getOrigUnitOfInterface(CallGraph callGraph) {
        Unit oUnit;
        Unit origUnitOfInterface = null;
        if (this.kind == 5 && (oUnit = callGraph.getUnit(this.name, this.functionTypeSpec())) != null && oUnit != this && oUnit.kind == 0) {
            origUnitOfInterface = oUnit;
        }
        return origUnitOfInterface;
    }

    public Unit getUnitOfInterface() {
        FunctionDecl standardDecl;
        TapList<FunctionDecl> standardDecls = this.externalSymbolTable().getFunctionDecl(this.name, this.functionTypeSpec().returnType, this.functionTypeSpec().argumentsTypes, true);
        FunctionDecl functionDecl = standardDecl = standardDecls == null ? null : (FunctionDecl)standardDecls.head;
        if (standardDecl == null) {
            standardDecls = this.publicSymbolTable.getTopFunctionDecl(this.name, null, null, false);
            FunctionDecl functionDecl2 = standardDecl = standardDecls == null ? null : (FunctionDecl)standardDecls.head;
            if (standardDecl == null) {
                standardDecls = this.privateSymbolTable.getTopFunctionDecl(this.name, null, null, false);
                standardDecl = standardDecls == null ? null : (FunctionDecl)standardDecls.head;
            }
        }
        return standardDecl == null ? null : standardDecl.unit();
    }

    public Unit getUpperLevelClassUnit() {
        Unit result = this;
        while (result != null && !result.isClass()) {
            result = result.upperLevelUnit;
        }
        return result;
    }

    protected Tree getElementalIntrinsicTypeConverter(Tree[] args) {
        Tree result = null;
        if (this.isFortran()) {
            if (args.length == 2 && (this.name.equals("aint") || this.name.equals("anint") || this.name.equals("ceiling") || this.name.equals("floor") || this.name.equals("int") || this.name.equals("nint") || this.name.equals("real"))) {
                result = args[1];
            } else if (this.name.equals("cmplx")) {
                if (args.length == 3) {
                    result = args[2];
                } else if (args.length == 2 && args[1].opCode() == 132) {
                    result = args[1];
                }
            }
            if (result != null && result.opCode() == 132) {
                result = result.down(2);
            }
        }
        return result;
    }

    public int getPosition() {
        if (this.position == -1) {
            if (this.entryBlock != null) {
                this.position = this.entryBlock.getPosition();
            }
            if (this.position == -1) {
                TapList<Block> blocks = this.allBlocks;
                while (this.position == -1 && blocks != null) {
                    this.position = ((Block)blocks.head).getPosition();
                    blocks = blocks.tail;
                }
            }
            if (this.position == -1 && this.publicSymbolTable != null && this.publicSymbolTable.declarationsBlock != null) {
                this.position = this.publicSymbolTable.declarationsBlock.getPosition();
            }
            if (this.position == -1 && this.privateSymbolTable != null && this.privateSymbolTable.declarationsBlock != null) {
                this.position = this.privateSymbolTable.declarationsBlock.getPosition();
            }
            if (this.position == -1 && this.translationUnitSymbolTable != null && this.translationUnitSymbolTable.declarationsBlock != null) {
                this.position = this.translationUnitSymbolTable.declarationsBlock.getPosition();
            }
        }
        return this.position;
    }

    public TapList<Unit> allCallers() {
        return Unit.allCallersRec(this, null, new TapList<Object>(null, null));
    }

    public TapList<Unit> allCallees() {
        return Unit.allCalleesRec(this, null, new TapList<Object>(null, null));
    }

    public void makeFlowGraph(EntryBlock entryBlock, TapList<Block> givenAllBlocks, ExitBlock exitBlock, boolean finalGraph) {
        this.entryBlock = entryBlock;
        this.exitBlock = exitBlock;
        if (this.isClass() || this.isModule()) {
            this.allBlocks = givenAllBlocks;
            this.topBlocks = givenAllBlocks;
        } else {
            FlowGraphNormalizer flowGraphNormalizer = new FlowGraphNormalizer(entryBlock, givenAllBlocks, exitBlock);
            flowGraphNormalizer.condenseFG(finalGraph);
            if (!this.isConstructor()) {
                flowGraphNormalizer.makeSurePrivateDeclarationsBlock(this);
            }
            flowGraphNormalizer.sortFlowArrows();
            this.topBlocks = flowGraphNormalizer.findOptimalLoops();
            TapList<Block> deadBlocks = flowGraphNormalizer.getDeadBlocks();
            while (deadBlocks != null) {
                this.declareDeadBlock((Block)deadBlocks.head);
                deadBlocks = deadBlocks.tail;
            }
        }
        this.coherence();
        TapList<Block> inAllBlocks = this.allBlocks;
        SymbolTable referenceSymbolTable = this.bodySymbolTable();
        while (inAllBlocks != null) {
            Block curBlock = (Block)inAllBlocks.head;
            SymbolTable curSymbolTable = curBlock.symbolTable;
            if (curSymbolTable != null && curSymbolTable != referenceSymbolTable) {
                boolean hasUselessLevels = false;
                SymbolTable newSymbolTable = curSymbolTable.basisSymbolTable();
                if (newSymbolTable != null) {
                    while (newSymbolTable != referenceSymbolTable && newSymbolTable.isUseless()) {
                        hasUselessLevels = true;
                        this.removeDerivedSymbolTable(newSymbolTable);
                        newSymbolTable = newSymbolTable.basisSymbolTable();
                    }
                    if (hasUselessLevels) {
                        curSymbolTable.setBasisSymbolTable(newSymbolTable);
                    }
                    if (curSymbolTable.isUseless()) {
                        this.removeDerivedSymbolTable(curSymbolTable);
                        curBlock.symbolTable = newSymbolTable;
                    }
                }
            }
            inAllBlocks = inAllBlocks.tail;
        }
        if (this.privateSymbolTable != null && this.privateSymbolTable.declarationsBlock == null && this.allBlocks != null) {
            this.privateSymbolTable.declarationsBlock = (Block)this.allBlocks.head;
        }
        if (this.publicSymbolTable != null && this.publicSymbolTable.declarationsBlock == null) {
            this.publicSymbolTable.declarationsBlock = new BasicBlock(this.publicSymbolTable, null, null);
            this.publicSymbolTable.declarationsBlock.rank = -37;
        }
    }

    public void fixImplicits() {
        TapList<SymbolTable> inSymbolTables = this.symbolTablesBottomUp;
        while (inSymbolTables != null) {
            ((SymbolTable)inSymbolTables.head).fixImplicits();
            inSymbolTables = inSymbolTables.tail;
        }
    }

    public void exportFunctionTypeSpec() {
        if (!this.isPackage()) {
            Tree[] callArgsTrees;
            Tree callTree;
            WrapperTypeSpec[] argumentsTypes = this.functionTypeSpec.argumentsTypes;
            if (this.entryBlock != null) {
                callTree = this.entryBlock.headTree();
                assert (callTree != null);
                callArgsTrees = ILUtils.getArguments(callTree).children();
            } else {
                callTree = this.parametersOrModuleNameTree;
                callArgsTrees = this.parametersOrModuleNameTree.children();
            }
            SymbolTable argsSymbolTable = this.publicSymbolTable();
            for (int i = callArgsTrees.length - 1; i >= 0; --i) {
                String varName;
                SymbolDecl symbolDecl;
                if (callArgsTrees[i].opCode() == 172 || (symbolDecl = argsSymbolTable.getSymbolDecl(varName = callArgsTrees[i].opCode() == 94 || callArgsTrees[i].opCode() == 121 ? ILUtils.getIdentString(callArgsTrees[i]) : ILUtils.baseName(callArgsTrees[i]))) == null || argumentsTypes == null || i >= argumentsTypes.length) continue;
                if (symbolDecl.isA(1)) {
                    WrapperTypeSpec declaredType = symbolDecl.type();
                    if (!TypeSpec.canCompare(declaredType, argumentsTypes[i])) {
                        TapEnv.fileWarning(15, callArgsTrees[i], "(TC31) Type mismatch in argument " + (i + 1) + " of function " + this.name + ", was " + declaredType.showType() + ", is here " + ((TypeSpec)argumentsTypes[i]).showType());
                    }
                    argumentsTypes[i] = declaredType;
                } else if (symbolDecl.isA(3)) {
                    argumentsTypes[i] = new WrapperTypeSpec(((FunctionDecl)symbolDecl).unit().functionTypeSpec());
                }
                argumentsTypes[i] = ((TypeSpec)argumentsTypes[i]).copyStopOnComposite(this);
            }
            if (this.isFortran()) {
                WrapperTypeSpec returnTypeSpec = this.functionTypeSpec().returnType;
                SymbolDecl symbolDecl = argsSymbolTable.getSymbolDecl(this.name);
                if (symbolDecl != null && symbolDecl.isA(1)) {
                    WrapperTypeSpec declaredType = symbolDecl.type();
                    if (!TypeSpec.canCompare(declaredType, returnTypeSpec)) {
                        TapEnv.fileWarning(15, callTree, "(TC31) Type mismatch in result of function " + this.name + ", was " + declaredType.showType() + ", is here " + returnTypeSpec.showType());
                    }
                    this.functionTypeSpec.returnType = declaredType;
                }
            }
            this.functionTypeSpec.returnType = (WrapperTypeSpec)this.functionTypeSpec.returnType.copyStopOnComposite(this);
        }
    }

    protected void exportOneArgumentType(String argName, WrapperTypeSpec typeSpec) {
        if (this.functionTypeSpec != null && !this.isModule()) {
            WrapperTypeSpec[] argumentsTypes = this.functionTypeSpec.argumentsTypes;
            assert (this.entryBlock.headTree() != null);
            Tree[] callArgsTrees = ILUtils.getArguments(this.entryBlock.headTree()).children();
            for (int i = callArgsTrees.length - 1; i >= 0; --i) {
                if (callArgsTrees[i].opCode() != 94 || !ILUtils.getIdentString(callArgsTrees[i]).equals(argName)) continue;
                argumentsTypes[i] = typeSpec;
            }
        }
    }

    public TapList<Tree> generateHeaderParamsList() {
        Tree paramsTree = this.entryBlock != null && this.entryBlock.headTree() != null ? ILUtils.getArguments(this.entryBlock.headTree()) : this.parametersOrModuleNameTree;
        TapList<Tree> paramsTypedTreeList = this.generateParamsList(paramsTree);
        if (this.functionTypeSpec() != null && this.functionTypeSpec().variableArgList) {
            paramsTypedTreeList = TapList.addLast(paramsTypedTreeList, ILUtils.build(198));
        }
        return paramsTypedTreeList;
    }

    public TapList<Tree> generateParamsList(Tree callParamsList) {
        TapList<Tree> paramDecls;
        TapList<Object> topParams;
        Tree[] callParams = callParamsList.children();
        TapList<Object> tailParams = topParams = new TapList<Object>(null, null);
        if (callParams.length != 0) {
            if (this.sameLanguage(TapEnv.relatedLanguage())) {
                if (TapEnv.isCorMore(this.language())) {
                    paramDecls = this.getCTapList(callParams, this.publicSymbolTable, null);
                } else {
                    for (Tree callParam : callParams) {
                        Tree generatedParam = callParam.copy();
                        String paramName = ILUtils.baseName(generatedParam);
                        if (paramName != null && (this.publicSymbolTable.getTopFunctionDecl(paramName, null, null, false) != null || this.publicSymbolTable.getTopInterfaceDecl(paramName) != null)) {
                            generatedParam.setAnnotation("isFunctionName", Boolean.TRUE);
                        }
                        tailParams = tailParams.placdl(generatedParam);
                    }
                    paramDecls = new TapList<Tree>(ILUtils.build(194, ILUtils.build(128), ILUtils.build(136), ILUtils.build(53, topParams.tail)), null);
                }
            } else if (this.isFortran()) {
                for (int i = 0; i < callParams.length; ++i) {
                    Tree generatedParamType;
                    if (!(this.passesByValue(i + 1, TapEnv.languages(0)) || TapEnv.get().multiDirDiffMode && i == callParams.length - 1)) {
                        WrapperTypeSpec baseTypeSpec = this.functionTypeSpec().argumentsTypes[i];
                        if (TypeSpec.isA(baseTypeSpec, 5) && ((ModifiedTypeSpec)baseTypeSpec.wrappedType).hasCbindingModifier()) {
                            if (((ModifiedTypeSpec)baseTypeSpec.wrappedType).hasCbindingModifier("c_double")) {
                                WrapperTypeSpec elementTypeSpec = baseTypeSpec.wrappedType.elementType();
                                baseTypeSpec = new WrapperTypeSpec(new ModifiedTypeSpec(new WrapperTypeSpec(elementTypeSpec), ILUtils.build(94, "double"), null));
                            } else {
                                baseTypeSpec = baseTypeSpec.wrappedType.elementType();
                            }
                        }
                        if (TypeSpec.isA(baseTypeSpec, 7) || TypeSpec.isA(baseTypeSpec, 5)) {
                            generatedParamType = baseTypeSpec.generateTree(this.publicSymbolTable, null, null, true, null);
                            generatedParamType = ILUtils.build(151, generatedParamType);
                        } else if (baseTypeSpec.baseTypeSpec(true).isCharacter()) {
                            generatedParamType = ILUtils.build(151, ILUtils.build(94, "char"));
                        } else if (TypeSpec.isA(baseTypeSpec, 2)) {
                            generatedParamType = baseTypeSpec.generateTree(this.publicSymbolTable, null, null, true, null);
                            ArrayTypeSpec arrayTypeSpec = (ArrayTypeSpec)baseTypeSpec.wrappedType;
                            ArrayDim[] dimensions = arrayTypeSpec.dimensions();
                            if (dimensions.length == 1) {
                                generatedParamType.down(2).down(1).setChild(ILUtils.build(136), 2);
                            } else {
                                int nbUndefinedSize = 0;
                                for (int j = dimensions.length - 1; j >= 0; --j) {
                                    if (dimensions[j].size() != -1 && nbUndefinedSize == 0) continue;
                                    generatedParamType.down(2).down(j + 1).setChild(ILUtils.build(136), 2);
                                    ++nbUndefinedSize;
                                }
                                if (nbUndefinedSize > 1) {
                                    baseTypeSpec = baseTypeSpec.modifiedBaseTypeSpec();
                                    generatedParamType = baseTypeSpec.generateTree(this.publicSymbolTable, null, null, true, null);
                                    generatedParamType = ILUtils.build(151, generatedParamType);
                                }
                            }
                        } else if (TypeSpec.isA(baseTypeSpec, 21)) {
                            String typeDeclName = baseTypeSpec.wrappedType.typeDeclName();
                            TypeDecl typeDecl = TapEnv.relatedUnit().translationUnitSymbolTable.getTypeDecl(typeDeclName);
                            if (typeDecl == null) {
                                typeDecl = TapEnv.relatedUnit().translationUnitSymbolTable.getTypeDecl("struct " + typeDeclName);
                            }
                            if (typeDecl != null) {
                                typeDeclName = typeDecl.symbol;
                                generatedParamType = ILUtils.build(94, typeDeclName);
                                generatedParamType = ILUtils.build(151, generatedParamType);
                            } else {
                                typeDeclName = "UnknownTypeName";
                                TypeDecl otherTypeDecl = this.callGraph.getOtherBindType(baseTypeSpec);
                                if (otherTypeDecl != null) {
                                    generatedParamType = otherTypeDecl.typeSpec.wrappedType.generateTree(this.publicSymbolTable, null, null, true, null);
                                } else {
                                    generatedParamType = ILUtils.build(94, typeDeclName);
                                    generatedParamType = ILUtils.build(151, generatedParamType);
                                }
                            }
                        } else {
                            generatedParamType = baseTypeSpec.generateTree(this.publicSymbolTable, null, null, true, null);
                        }
                    } else {
                        generatedParamType = this.functionTypeSpec.argumentsTypes[i].generateTree(this.publicSymbolTable, null, null, true, null);
                    }
                    Tree generatedParam = ILUtils.build(194, ILUtils.build(128), generatedParamType, ILUtils.build(53));
                    tailParams = tailParams.placdl(generatedParam);
                }
                paramDecls = topParams.tail;
            } else {
                for (Tree callParam : callParams) {
                    Tree generatedParam = callParam.copy();
                    String paramName = ILUtils.baseName(generatedParam);
                    if (paramName != null && (this.publicSymbolTable.getTopFunctionDecl(paramName, null, null, false) != null || this.publicSymbolTable.getTopInterfaceDecl(paramName) != null)) {
                        generatedParam.setAnnotation("isFunctionName", Boolean.TRUE);
                    }
                    tailParams = tailParams.placdl(generatedParam);
                }
                paramDecls = new TapList<Tree>(ILUtils.build(194, ILUtils.build(128), ILUtils.build(136), ILUtils.build(53, topParams.tail)), null);
            }
        } else {
            paramDecls = new TapList<Tree>(ILUtils.build(194, ILUtils.build(128), ILUtils.build(136), ILUtils.build(53, topParams.tail)), null);
        }
        return paramDecls;
    }

    private TapList<Tree> getCTapList(Tree[] callParams, SymbolTable publicSymbolTable, TapList<Tree> paramDecls) {
        TapList<SymbolDecl> externalTypes = publicSymbolTable.getAllTypeDecls();
        for (int i = callParams.length - 1; i >= 0; --i) {
            TapList<DeclStruct> declStructs;
            NewSymbolHolder newSH;
            Tree declTree;
            Tree generatedParam = callParams[i].copy();
            String paramName = ILUtils.baseName(generatedParam);
            if (generatedParam.opCode() == 172) {
                declTree = ILUtils.copy(generatedParam);
                paramDecls = new TapList<Tree>(declTree, paramDecls);
                continue;
            }
            if (this.functionTypeSpec != null && this.functionTypeSpec.argumentsTypes != null && "_".equals(paramName) && this.functionTypeSpec.argumentsTypes[i] != null) {
                declTree = this.functionTypeSpec.argumentsTypes[i].generateTree(publicSymbolTable, null, externalTypes, true, null);
                paramDecls = new TapList<Tree>(declTree, paramDecls);
                continue;
            }
            Tree paramNameTree = null;
            VariableDecl paramDecl = publicSymbolTable.getTopVariableDecl(paramName);
            if (paramDecl == null && (newSH = NewSymbolHolder.getNewSymbolHolder(ILUtils.baseTree(generatedParam))) != null) {
                paramDecl = newSH.newVariableDecl();
                paramNameTree = newSH.makeNewRef(publicSymbolTable);
            }
            if (paramNameTree == null) {
                paramNameTree = ILUtils.build(94, paramName);
            }
            if (paramDecl == null) {
                FunctionDecl functionParamDecl;
                TapList<FunctionDecl> functionsParamDecl = publicSymbolTable.getTopFunctionDecl(paramName, null, null, false);
                FunctionDecl functionDecl = functionParamDecl = functionsParamDecl == null ? null : (FunctionDecl)functionsParamDecl.head;
                if (functionParamDecl != null && functionParamDecl.unit() != null) {
                    paramDecl = new VariableDecl(paramNameTree, new WrapperTypeSpec(new PointerTypeSpec(new WrapperTypeSpec(functionParamDecl.unit().functionTypeSpec()), null)));
                }
            }
            if ((declStructs = TreeGen.addSymbolDeclStructs(paramDecl, null, publicSymbolTable, null, paramNameTree)) == null) continue;
            declTree = ((VariableDeclStruct)declStructs.head).generateTree(externalTypes, this.privateSymbolTable());
            paramDecls = new TapList<Tree>(declTree, paramDecls);
            assert (paramDecl != null);
            paramDecl.setInstruction(new Instruction(declTree));
        }
        return paramDecls;
    }

    public Tree buildReturnTypeTree(Block privateDeclBlock, TapList<SymbolDecl> externalTypes, ToObject<Tree> toNewDeclTree, TapList<Instruction> publicDeclarationsInstructions) {
        Tree returnTypeTree;
        if (this.isAFunction()) {
            boolean returnsArrayTypeInFortran;
            VariableDecl varOrFuncDecl = this.publicSymbolTable().getTopVariableDecl(this.name);
            WrapperTypeSpec localReturnType = this.functionTypeSpec().returnType;
            boolean bl = returnsArrayTypeInFortran = this.isFortran() && TypeSpec.isA(localReturnType, 2) && !localReturnType.isCharacter() && !localReturnType.isString();
            if (varOrFuncDecl == null) {
                TapList<FunctionDecl> funcDecls = this.publicSymbolTable().getTopFunctionDecl(this.name, localReturnType, this.functionTypeSpec().argumentsTypes, true);
                SymbolDecl symbolDecl = varOrFuncDecl = funcDecls == null ? null : (SymbolDecl)funcDecls.head;
            }
            if (!(varOrFuncDecl != null && (varOrFuncDecl.isVarDeclared(privateDeclBlock.instructions) || varOrFuncDecl.isVarDeclared(publicDeclarationsInstructions)) || this.otherReturnVar != null && (this.otherReturnVar.isVarDeclared(privateDeclBlock.instructions) || this.otherReturnVar.isVarDeclared(publicDeclarationsInstructions)) || this.functionTypeSpec() == null)) {
                if (varOrFuncDecl != null) {
                    varOrFuncDecl.setNoneInstruction();
                }
                if (returnsArrayTypeInFortran) {
                    returnTypeTree = null;
                    if (varOrFuncDecl == null) {
                        varOrFuncDecl = new VariableDecl(ILUtils.build(94, this.name), localReturnType);
                    }
                    if (varOrFuncDecl instanceof VariableDecl) {
                        Tree newDecl = varOrFuncDecl.buildVarDeclaration(this.publicSymbolTable());
                        toNewDeclTree.setObj(newDecl);
                    }
                } else {
                    returnTypeTree = localReturnType.generateTree(null, null, externalTypes, true, null);
                }
            } else {
                returnTypeTree = this.isC() ? localReturnType.generateTree(null, null, externalTypes, true, null) : ILUtils.build(136);
            }
        } else {
            returnTypeTree = ILUtils.build(199);
        }
        return returnTypeTree;
    }

    protected void importAllSymbolTables() {
        TapList<Object> otherMods = null;
        if (this.importedModulesUseDecl != null) {
            TapList<TapPair<Unit, Tree>> newImportedModules = null;
            TapList<Tree> useDecls = this.importedModulesUseDecl;
            TapList<TapPair<Unit, Tree>> allImportedModules = null;
            if (this.importedModulesAndUseInfo == null) {
                while (useDecls != null) {
                    Tree useDecl = (Tree)useDecls.head;
                    String moduleName = ILUtils.getIdentString(useDecl.down(1));
                    Unit module = this.externalSymbolTable().getModule(moduleName);
                    if (module != null && !module.isUndefined()) {
                        Tree onlyRenamed = ILUtils.copy(useDecl.down(2));
                        allImportedModules = TapList.append(new TapList<TapPair<Unit, Tree>>(new TapPair<Unit, Tree>(module, onlyRenamed), null), allImportedModules);
                        otherMods = TapList.append(this.buildOtherModsRec(module, onlyRenamed, new TapList<Unit>(module, null), new TapList<Unit>(module, null)), otherMods);
                        newImportedModules = TapList.append(newImportedModules, new TapList<TapPair<Unit, Tree>>(new TapPair<Unit, Tree>(module, ILUtils.copy(useDecl.down(2))), null));
                    } else if (moduleName.equals("mpi") || moduleName.equals("ampi") || moduleName.equals("iso_c_binding")) {
                        module = this.buildPredefinedModule(moduleName);
                        newImportedModules = TapList.append(newImportedModules, new TapList<TapPair<Unit, Tree>>(new TapPair<Unit, Tree>(module, ILUtils.copy(useDecl.down(2))), null));
                    } else {
                        TapEnv.fileWarning(15, useDecl, "(DD15) Module " + moduleName + " is not defined");
                    }
                    useDecls = useDecls.tail;
                }
            }
            TapList deeperImportedModules = otherMods;
            this.importedModulesAndUseInfo = newImportedModules;
            this.importedModules = this.buildImportedModules(this.importedModulesAndUseInfo);
            TapList deeperUseDecls = deeperImportedModules;
            while (deeperUseDecls != null) {
                this.publicSymbolTable().importModuleSymbolTable((Unit)((TapPair)deeperUseDecls.head).first, (Tree)((TapPair)deeperUseDecls.head).second, false);
                deeperUseDecls = deeperUseDecls.tail;
            }
            TapList<TapPair<Unit, Tree>> useDeclsInfo = this.importedModulesAndUseInfo;
            while (useDeclsInfo != null) {
                this.publicSymbolTable().importModuleSymbolTable((Unit)((TapPair)useDeclsInfo.head).first, (Tree)((TapPair)useDeclsInfo.head).second, false);
                useDeclsInfo = useDeclsInfo.tail;
            }
            this.otherImportedModules = this.buildImportedModules(deeperImportedModules);
            this.fixImportedDeclarations();
        }
    }

    protected void importInheritedClassesSymbolTables() {
        if (this.parentClasses != null && this.isClass()) {
            if (TapList.length(this.parentClasses) > 1) {
                TapEnv.fileWarning(9, null, "(TC70) Multiple inheritance is not well managed yet (class " + this.name + ')');
            }
            TapList<TapTriplet<Unit, Boolean, Boolean>> tmpParentClasses = this.parentClasses;
            while (tmpParentClasses != null) {
                SymbolTable targetSymbolTable;
                Unit parentClass = (Unit)((TapTriplet)tmpParentClasses.head).first;
                boolean isVirtualInheritance = (Boolean)((TapTriplet)tmpParentClasses.head).second;
                boolean isPublicInheritance = (Boolean)((TapTriplet)tmpParentClasses.head).third;
                if (parentClass.publicSymbolTable() != null) {
                    targetSymbolTable = isPublicInheritance ? this.publicSymbolTable() : this.privateSymbolTable();
                    targetSymbolTable.importAllClassSymbolTable(parentClass.publicSymbolTable(), this, parentClass, isVirtualInheritance);
                }
                if (parentClass.protectedSymbolTable() != null) {
                    targetSymbolTable = isPublicInheritance ? this.protectedSymbolTable() : this.privateSymbolTable();
                    targetSymbolTable.importAllClassSymbolTable(parentClass.protectedSymbolTable(), this, parentClass, isVirtualInheritance);
                }
                tmpParentClasses = tmpParentClasses.tail;
            }
        }
    }

    private TapList<TapPair<Unit, Tree>> buildOtherModsRec(Unit module, Tree onlyRenamed, TapList<Unit> dejaVu, TapList<Unit> d2) {
        TapList<TapPair<Unit, Tree>> otherMods = null;
        if (!module.isPrivate()) {
            TapList<TapPair<Unit, Tree>> otherModsLevel1 = otherMods = TapList.append(this.buildObjectList(module.importedModulesAndUseInfo, onlyRenamed), null);
            while (otherModsLevel1 != null) {
                Unit importedModule = (Unit)((TapPair)otherModsLevel1.head).first;
                if (TapList.contains(dejaVu, importedModule)) {
                    StringBuilder recurChain = new StringBuilder(importedModule.name);
                    TapList<Unit> inDejaVu = dejaVu;
                    while (inDejaVu != null) {
                        recurChain.insert(0, ((Unit)inDejaVu.head).name + " USEs ");
                        inDejaVu = inDejaVu.tail;
                    }
                    TapEnv.fileWarning(8, null, "(TC42) Module USE recursivity: " + recurChain);
                } else if (!TapList.contains(d2, importedModule)) {
                    d2.placdl(importedModule);
                    TapList<TapPair<Unit, Tree>> otherMods1 = this.buildOtherModsRec(importedModule, onlyRenamed, new TapList<Unit>(importedModule, dejaVu), d2);
                    otherMods = TapList.append(otherMods, otherMods1);
                }
                otherModsLevel1 = otherModsLevel1.tail;
            }
        }
        return otherMods;
    }

    protected boolean isPrivate() {
        boolean result = this.isModule() ? this.fortranStuff != null && this.fortranStuff.publicPrivateDefault != null && this.fortranStuff.publicPrivateDefault.equals("PRIVATE") : this.modifiers != null && this.modifiers.opCode() == 128 && this.modifiers.length() != 0 && this.modifiers.down(1).opCode() == 94 && this.modifiers.down(1).stringValue().equals("private");
        return result;
    }

    private Unit buildPredefinedModule(String moduleName) {
        Unit result = this.callGraph.getUnit(moduleName);
        if (result == null || result.isUndefined()) {
            String[] inputFileNames = new String[1];
            String resourcesDirectory = TapEnv.tapenadeHome + File.separator + "resources" + File.separator;
            inputFileNames[0] = resourcesDirectory + TapEnv.get().stdLibraryDirectory + moduleName + "f.f90";
            try {
                TapEnv.printlnOnTrace(10, "@@ Loading " + moduleName + " information from library " + inputFileNames[0]);
                Tapenade.parseFiles(false, "." + File.separator, inputFileNames, this.callGraph, null, 2, false);
                Unit predefinedUnit = this.callGraph.getUnit(moduleName);
                predefinedUnit.name = moduleName;
                predefinedUnit.isPredefinedModuleOrTranslationUnit = true;
                result = predefinedUnit;
                predefinedUnit.typeCheck();
                TapList<Unit> predefLowerLevelUnits = predefinedUnit.lowerLevelUnits;
                while (predefLowerLevelUnits != null) {
                    ((Unit)predefLowerLevelUnits.head).typeCheck();
                    predefLowerLevelUnits = predefLowerLevelUnits.tail;
                }
            }
            catch (IOException e) {
                TapEnv.toolWarning(-1, "Definition of " + moduleName + " module not found in " + TapEnv.get().stdLibraryDirectory);
            }
        }
        return result;
    }

    private TapList<TapPair<Unit, Tree>> buildObjectList(TapList<TapPair<Unit, Tree>> importedModules, Tree renamedOnly) {
        TapList<TapPair<Unit, Tree>> result = null;
        while (importedModules != null) {
            Unit importedModule = (Unit)((TapPair)importedModules.head).first;
            Tree renamed = (Tree)((TapPair)importedModules.head).second;
            TapPair<Unit, Tree> op = new TapPair<Unit, Tree>(importedModule, ILUtils.mergeUseDeclTrees(renamedOnly, renamed, true));
            result = new TapList<TapPair<Unit, Tree>>(op, result);
            importedModules = importedModules.tail;
        }
        return result;
    }

    private TapList<Unit> buildImportedModules(TapList<TapPair<Unit, Tree>> impModulesAndUse) {
        TapList result = null;
        while (impModulesAndUse != null) {
            result = new TapList(((TapPair)impModulesAndUse.head).first, result);
            impModulesAndUse = impModulesAndUse.tail;
        }
        return result;
    }

    private void fixImportedDeclarations() {
        TapList<SymbolTable> inSymbolTables = this.symbolTablesBottomUp;
        while (inSymbolTables != null) {
            ((SymbolTable)inSymbolTables.head).fixImportedDeclarations();
            inSymbolTables = inSymbolTables.tail;
        }
        TapList<Unit> lowerUnits = this.lowerLevelUnits;
        while (lowerUnits != null) {
            ((Unit)lowerUnits.head).fixImportedDeclarations();
            lowerUnits = lowerUnits.tail;
        }
    }

    protected boolean subClassOf(Unit parentUnit) {
        return parentUnit == this || this.subClassOfRec(parentUnit);
    }

    private boolean subClassOfRec(Unit parentUnit) {
        boolean isSubClass = false;
        TapList<TapTriplet<Unit, Boolean, Boolean>> parents = this.parentClasses;
        while (!isSubClass && parents != null) {
            isSubClass = ((Unit)((TapTriplet)parents.head).first).subClassOf(parentUnit);
            parents = parents.tail;
        }
        return isSubClass;
    }

    public void typeCheck() {
        Instruction curInstr;
        SymbolTable symbolTable;
        TapList<Instruction> inInstructions;
        Block curBlock;
        TapList<Block> inAllBlocks = this.allBlocks;
        ToBool isBeginning = new ToBool(true);
        if (TapEnv.traceTypeCheckAnalysis()) {
            TapEnv.printlnOnTrace("==========  TAPENADE TYPECHECK ON UNIT " + this.name + " : =========");
            TapEnv.printlnOnTrace();
        } else {
            TapEnv.printlnOnTrace(10, "@@ Checking types for unit: " + this.name);
        }
        while (inAllBlocks != null) {
            curBlock = (Block)inAllBlocks.head;
            inInstructions = curBlock.instructions;
            symbolTable = curBlock.symbolTable;
            if ((this.isModule() || this.isClass()) && this.privateSymbolTable() != null) {
                symbolTable = this.privateSymbolTable();
            }
            while (inInstructions != null) {
                curInstr = (Instruction)inInstructions.head;
                Tree instrOrExpr = curInstr.tree;
                if (instrOrExpr != null) {
                    symbolTable.typeCheck(instrOrExpr, false, false, false, curInstr, isBeginning, this);
                }
                inInstructions = inInstructions.tail;
            }
            isBeginning.set(isBeginning.get() && (curBlock.instructions == null || curBlock.lastInstr().isADeclaration(true)));
            inAllBlocks = inAllBlocks.tail;
        }
        if (this.fortranStuff != null && this.fortranStuff.getSaveAll()) {
            this.fortranStuff.computeSaveVarDecls(this.publicSymbolTable(), this.publicSymbolTable().getAllTopVariableDecls());
            this.fortranStuff.computeSaveVarDecls(this.privateSymbolTable(), this.privateSymbolTable().getAllTopVariableDecls());
        }
        if (this.fortranStuff != null) {
            this.fortranStuff.commonEquivsIntoMemoryMap();
            this.fortranStuff.implicitDeclarations = null;
            this.fortranStuff.declareBindCInMemoryMap();
        }
        if (this.publicSymbolTable != null) {
            inAllBlocks = TapList.addUnlessPresent(this.allBlocks, this.publicSymbolTable.declarationsBlock);
        }
        if (this.privateSymbolTable != null) {
            inAllBlocks = TapList.addUnlessPresent(inAllBlocks, this.privateSymbolTable.declarationsBlock);
        }
        while (inAllBlocks != null) {
            curBlock = (Block)inAllBlocks.head;
            symbolTable = curBlock.symbolTable;
            inInstructions = curBlock.instructions;
            while (inInstructions != null) {
                curInstr = (Instruction)inInstructions.head;
                if (curInstr.isADeclaration(true)) {
                    symbolTable.terminateFunctionDeclarationInstructions(curInstr.tree);
                }
                inInstructions = inInstructions.tail;
            }
            inAllBlocks = inAllBlocks.tail;
        }
        if (TapEnv.traceTypeCheckAnalysis()) {
            TapEnv.printlnOnTrace();
        }
    }

    protected void typeCheckInterface() {
        Unit unit;
        if (TapEnv.traceTypeCheckAnalysis()) {
            TapEnv.printlnOnTrace("==========  TAPENADE TYPECHECK ON INTERFACE " + this.name + " : =========");
            TapEnv.printlnOnTrace();
        } else {
            TapEnv.printlnOnTrace(10, "@@ Checking types for interface: " + this.name);
        }
        TapList<Block> inAllBlocks = this.allBlocks;
        while (inAllBlocks != null) {
            Block declBlock = (Block)inAllBlocks.head;
            TapList<Instruction> inInstructions = declBlock.instructions;
            SymbolTable symbolTable = declBlock.symbolTable;
            ToBool isBeginning = new ToBool(true);
            while (inInstructions != null) {
                Instruction curInstr = (Instruction)inInstructions.head;
                symbolTable.typeCheck(curInstr.tree, false, false, false, curInstr, isBeginning, null);
                inInstructions = inInstructions.tail;
            }
            inAllBlocks = inAllBlocks.tail;
        }
        TapList<FunctionDecl> actualFunctionDecls = this.externalSymbolTable().getFunctionDecl(this.name, this.functionTypeSpec().returnType, this.functionTypeSpec().argumentsTypes, true);
        if (actualFunctionDecls == null) {
            actualFunctionDecls = this.externalSymbolTable().getFunctionDecl(this.name, this.functionTypeSpec().returnType, null, true);
        }
        if (actualFunctionDecls == null) {
            actualFunctionDecls = this.publicSymbolTable.getTopFunctionDecl(this.name, null, null, false);
        }
        if (actualFunctionDecls == null) {
            actualFunctionDecls = this.privateSymbolTable.getTopFunctionDecl(this.name, null, null, false);
        }
        FunctionDecl actualFunctionDecl = actualFunctionDecls == null ? null : (FunctionDecl)actualFunctionDecls.head;
        Unit unit2 = unit = actualFunctionDecl == null ? null : actualFunctionDecl.unit();
        if (unit != null && !unit.headTree().equalsTree(this.headTree())) {
            SymbolDecl[] unitParameterDecls;
            SymbolDecl[] interfaceParameterDecls = this.getParameterDecls();
            if (interfaceParameterDecls.length != (unitParameterDecls = unit.getParameterDecls()).length) {
                TapEnv.fileWarning(15, this.headTree(), "Interface and procedure headers differ: " + ILUtils.toString(unit.headTree()) + " and " + ILUtils.toString(this.headTree()));
            } else {
                TapList<Tree> intfDecls;
                int i;
                TapList<Tree> interfaceDecls = this.findInterfaceDeclations();
                for (i = 0; i < interfaceParameterDecls.length; ++i) {
                    if (interfaceParameterDecls[i].symbol.equals(unitParameterDecls[i].symbol)) continue;
                    intfDecls = interfaceDecls;
                    while (intfDecls != null) {
                        ILUtils.replaceAllIdentsNamed((Tree)intfDecls.head, interfaceParameterDecls[i].symbol, "paramXXX" + i);
                        intfDecls = intfDecls.tail;
                    }
                }
                for (i = 0; i < interfaceParameterDecls.length; ++i) {
                    if (interfaceParameterDecls[i].symbol.equals(unitParameterDecls[i].symbol)) continue;
                    intfDecls = interfaceDecls;
                    while (intfDecls != null) {
                        ILUtils.replaceAllIdentsNamed((Tree)intfDecls.head, "paramXXX" + i, unitParameterDecls[i].symbol);
                        intfDecls = intfDecls.tail;
                    }
                }
                ((Instruction)this.entryBlock.instructions.head).tree = ILUtils.copy(unit.headTree());
            }
        }
        if (unit != null && !unit.functionTypeSpec().equalsCompilDep(this.functionTypeSpec())) {
            WrapperTypeSpec returnType = this.functionTypeSpec().returnType;
            WrapperTypeSpec[] argumentsTypes = this.functionTypeSpec().argumentsTypes;
            WrapperTypeSpec otherReturnType = unit.functionTypeSpec().returnType;
            WrapperTypeSpec[] otherArgumentsTypes = unit.functionTypeSpec().argumentsTypes;
            boolean mismatch = false;
            if (unit.sameLanguage(this.language)) {
                boolean bl = mismatch = otherReturnType.wrappedType != null && !otherReturnType.equalsCompilDep(returnType);
                if (!mismatch && otherArgumentsTypes != null && argumentsTypes != null) {
                    mismatch = otherArgumentsTypes.length != argumentsTypes.length;
                    for (int i = 0; !mismatch && i < argumentsTypes.length; ++i) {
                        mismatch = otherArgumentsTypes[i].wrappedType == null || !otherArgumentsTypes[i].equalsCompilDep(argumentsTypes[i]);
                    }
                }
            } else {
                TapEnv.toolWarning(-1, "(DD999) Warning: type-checking of mixed language interface not yet implemented: " + this.name);
            }
            if (mismatch) {
                TapEnv.setRelatedUnit(unit);
                TapEnv.fileWarning(15, null, "(TC93) Type mismatch in interface " + this.name + ", " + this.functionTypeSpec().showType() + ", declared: " + unit.functionTypeSpec().showType());
            }
        }
        if (this.fortranStuff != null) {
            this.fortranStuff.commonEquivsIntoMemoryMap();
        }
    }

    protected WrapperTypeSpec[] typeCheckNameEqOptionalArguments(SymbolTable symbolTable, Tree[] actualArgs, WrapperTypeSpec[] actualTypes, WrapperTypeSpec[] nameEqTypes, int rankOfFirstNameEq, Tree newCallTree, Tree optionalTree, ToBool callUsesNameEq) {
        int i;
        int maxi;
        int nbFormalArgs = this.functionTypeSpec().argumentsTypes.length;
        WrapperTypeSpec[] result = new WrapperTypeSpec[nbFormalArgs];
        SymbolDecl[] parameterDecls = this.getParameterDecls();
        int n = maxi = parameterDecls == null ? 0 : parameterDecls.length;
        if (maxi > nbFormalArgs) {
            maxi = nbFormalArgs;
        }
        for (i = 0; i < maxi; ++i) {
            assert (parameterDecls != null);
            if (parameterDecls[i] == null) continue;
            ILUtils.getArguments(newCallTree).setChild(ILUtils.build(132, ILUtils.build(94, parameterDecls[i].symbol), ILUtils.build(136)), i + 1);
        }
        if (actualArgs != null) {
            for (i = 0; i < actualArgs.length; ++i) {
                if (actualArgs[i].opCode() == 132) {
                    callUsesNameEq.set(true);
                    String argName = ILUtils.getIdentString(actualArgs[i].down(1));
                    ToInt formalArgRank = new ToInt(-1);
                    SymbolDecl parameter = this.findParameter(parameterDecls, argName, formalArgRank);
                    WrapperTypeSpec typeSpec = nameEqTypes[i];
                    if (parameter != null) {
                        result[formalArgRank.get() - 1] = typeSpec;
                        ILUtils.getArguments(newCallTree).setChild(ILUtils.copy(actualArgs[i].down(2)), formalArgRank.get());
                        ILUtils.getArguments(newCallTree).down(formalArgRank.get()).setAnnotation("sourcetree", actualArgs[i]);
                        ILUtils.getArguments(optionalTree).setChild(ILUtils.copy(actualArgs[i]), formalArgRank.get());
                        continue;
                    }
                    if (!this.isIntrinsic()) {
                        TapEnv.fileWarning(15, actualArgs[i], "(TC53) Incorrect keyword argument " + argName + " in call to procedure " + ILUtils.getCalledNameString(newCallTree));
                        ILUtils.getArguments(optionalTree).setChild(ILUtils.copy(actualArgs[i]), i + 1);
                    } else if (TapEnv.relatedUnit().isFortran9x() && this.name.equals("sum") && argName.equals("mask")) {
                        symbolTable.setConformingDimension(symbolTable.getTypeDecl((String)"boolean").typeSpec, actualTypes[0], typeSpec, newCallTree);
                    }
                    ILUtils.getArguments(newCallTree).setChild(ILUtils.copy(actualArgs[i]), i + 1);
                    if (i >= nbFormalArgs) continue;
                    result[i] = typeSpec;
                    continue;
                }
                ILUtils.getArguments(newCallTree).setChild(ILUtils.copy(actualArgs[i]), i + 1);
                if (i < nbFormalArgs) {
                    result[i] = actualTypes[i];
                }
                if (i > rankOfFirstNameEq) {
                    TapEnv.fileWarning(15, actualArgs[i], "(TC54) Missing keyword argument in procedure " + ILUtils.getCalledNameString(newCallTree) + " call");
                }
                ILUtils.getArguments(optionalTree).setChild(ILUtils.copy(actualArgs[i]), i + 1);
            }
        }
        return result;
    }

    private TapList<Tree> findInterfaceDeclations() {
        TapList<Tree> result = null;
        TapList<Instruction> interfaceDecls = this.interfaceDeclarations;
        while (interfaceDecls != null) {
            TapList<Tree> interfaces = ((Instruction)interfaceDecls.head).tree.down(2).childrenList();
            while (interfaces != null) {
                if (((Tree)interfaces.head).opCode() == 103 && ((Tree)interfaces.head).down(1).opCode() == 87 && ((Tree)interfaces.head).down(1).down(4).stringValue().equals(this.name)) {
                    result = new TapList<Tree>(((Tree)interfaces.head).down(1), result);
                }
                interfaces = interfaces.tail;
            }
            interfaceDecls = interfaceDecls.tail;
        }
        return result;
    }

    private SymbolDecl findParameter(SymbolDecl[] parameterDecls, String param, ToInt rank) {
        SymbolDecl result = null;
        if (parameterDecls != null) {
            for (int i = 0; result == null && i < parameterDecls.length; ++i) {
                if (parameterDecls[i] == null || !parameterDecls[i].symbol.equals(param)) continue;
                result = parameterDecls[i];
                rank.set(i + 1);
            }
        }
        return result;
    }

    protected void typeCheckOptionalArguments(WrapperTypeSpec[] actualTypes, Tree newCallTree, Tree optionalTree, ToBool callUsesNameEq) {
        SymbolDecl[] parameterDecls = this.getParameterDecls();
        int nbArgs = ILUtils.getArguments(newCallTree).length();
        int nbParams = this.functionTypeSpec().argumentsTypes.length;
        int neededArgs = nbParams - nbArgs;
        if (parameterDecls != null) {
            for (int i = 0; i < parameterDecls.length; ++i) {
                if (parameterDecls[i] == null || parameterDecls[i].isOptional() && neededArgs != 0) {
                    if (!callUsesNameEq.get()) {
                        ILUtils.getArguments(optionalTree).addChild(ILUtils.build(136), i + 1);
                    }
                    WrapperTypeSpec paramTypeSpec = parameterDecls[i] != null ? parameterDecls[i].type() : new WrapperTypeSpec(null);
                    this.insertTypeSpec(actualTypes, paramTypeSpec, i);
                    --neededArgs;
                    continue;
                }
                if (parameterDecls[i] == null || actualTypes == null || actualTypes.length <= i || actualTypes[i] != null && actualTypes[i].wrappedType != null) continue;
                actualTypes[i] = parameterDecls[i].type();
            }
        }
    }

    private void insertTypeSpec(WrapperTypeSpec[] actualTypes, WrapperTypeSpec typeSpec, int pos) {
        if (pos < actualTypes.length) {
            if (actualTypes.length - 1 - pos >= 0) {
                System.arraycopy(actualTypes, pos, actualTypes, pos + 1, actualTypes.length - 1 - pos);
            }
            actualTypes[pos] = typeSpec;
        }
    }

    protected void preprocess() {
        if (this.hasSource()) {
            TapEnv.get().inlinedFunctions.findInlinedFunctions(this);
            if (this.privateSymbolTable() != null) {
                if (this.allBlocks != null) {
                    this.privateSymbolTable().declarationsBlock = (Block)this.allBlocks.head;
                }
                this.splitInstructions();
                this.privateSymbolTable().declarationsBlock = null;
            }
            this.distributeOMPclauses();
            this.makeFlowGraph(this.entryBlock, this.allBlocks, this.exitBlock, false);
        }
    }

    private void distributeOMPclauses() {
        Tree schedule;
        Tree ompPragma;
        Block block;
        TapList<Block> inAllBlocks = this.allBlocks;
        TapList collectedSchedules = null;
        while (inAllBlocks != null) {
            block = (Block)inAllBlocks.head;
            if (block.isParallelController() && (ompPragma = ((Instruction)block.instructions.head).tree).opCode() == 143 && (schedule = ILUtils.getRemoveSchedule(ompPragma)) != null) {
                collectedSchedules = new TapList(new TapPair(block.instructions.head, schedule), collectedSchedules);
            }
            inAllBlocks = inAllBlocks.tail;
        }
        inAllBlocks = this.allBlocks;
        while (inAllBlocks != null) {
            block = (Block)inAllBlocks.head;
            if (block.isParallelController() && (ompPragma = ((Instruction)block.instructions.head).tree).opCode() == 142) {
                TapList<Instruction> enclosings = block.parallelControls;
                while (enclosings != null) {
                    schedule = (Tree)TapList.cassq(enclosings.head, collectedSchedules);
                    if (schedule != null) {
                        ILUtils.addSchedule(ILUtils.copy(schedule), ompPragma);
                    }
                    enclosings = enclosings.tail;
                }
            }
            inAllBlocks = inAllBlocks.tail;
        }
    }

    private void splitInstructions() {
        TapList<Block> inAllBlocks = this.allBlocks;
        while (inAllBlocks != null) {
            Block block = (Block)inAllBlocks.head;
            boolean isADoLoopHeader = block.isALoop() && block instanceof HeaderBlock;
            block.splitInstructions();
            if (isADoLoopHeader && block.instructions.tail != null) {
                this.splitDoHeaderBlock((HeaderBlock)block);
            }
            inAllBlocks = inAllBlocks.tail;
        }
        TapList<SymbolTable> symbolTables = this.symbolTablesBottomUp();
        while (symbolTables != null) {
            ((SymbolTable)symbolTables.head).solveNewSymbolHolders(false);
            symbolTables = symbolTables.tail;
        }
    }

    private void splitDoHeaderBlock(HeaderBlock block) {
        TapList<FGArrow> toBackFlow;
        TapList<Object> toInstructions1;
        BasicBlock block1 = new BasicBlock(block.symbolTable, block.parallelControls, null);
        block1.setOrigLabel(block.origLabel());
        block.setOrigLabel(null);
        TapList<Object> tlInstructions1 = toInstructions1 = new TapList<Object>(null, null);
        while (block.instructions.tail != null) {
            tlInstructions1 = tlInstructions1.placdl(block.instructions.head);
            block.instructions = block.instructions.tail;
        }
        block1.instructions = toInstructions1.tail;
        TapList<Instruction> toAddInLoop = TapList.reverse(block1.instructions);
        TapList<Instruction> copiedAddInLoop = null;
        FGArrow arrowToBody = block.getFGArrowTestCase(30, 1);
        Block bodyBlock = arrowToBody.destination;
        while (toAddInLoop != null) {
            copiedAddInLoop = new TapList<Instruction>(new Instruction(ILUtils.copy(((Instruction)toAddInLoop.head).tree)), copiedAddInLoop);
            toAddInLoop = toAddInLoop.tail;
        }
        bodyBlock.instructions = TapList.append(bodyBlock.instructions, copiedAddInLoop);
        TapList<FGArrow> inBackFlow = toBackFlow = new TapList<FGArrow>(null, block.backFlow());
        while (inBackFlow.tail != null) {
            FGArrow arrow = (FGArrow)inBackFlow.tail.head;
            if (!arrow.inACycle) {
                arrow.destination = block1;
                block1.setBackFlow(new TapList<FGArrow>(arrow, block1.backFlow()));
                inBackFlow.tail = inBackFlow.tail.tail;
                continue;
            }
            inBackFlow = inBackFlow.tail;
        }
        new FGArrow((Block)block1, 0, 0, (Block)block);
        LoopBlock loopBlock = block.enclosingLoop();
        this.updateNestsOfBlocks(loopBlock, new TapList<Block>(block1, new TapList<LoopBlock>(loopBlock, null)));
    }

    protected void updateNestsOfBlocks(Block block, TapList<Block> blocks) {
        TapList<Block> toLevelAbove = block.enclosingLoop() == null ? new TapList<Block>(null, this.topBlocks()) : new TapList<Block>(null, block.enclosingLoop().inside);
        TapList<Block> inLevelAbove = toLevelAbove;
        while (inLevelAbove != null && inLevelAbove.tail != null) {
            if (inLevelAbove.tail.head == block) {
                inLevelAbove.tail = TapList.append(blocks, inLevelAbove.tail.tail);
                inLevelAbove = null;
                continue;
            }
            inLevelAbove = inLevelAbove.tail;
        }
        if (block.enclosingLoop() == null) {
            this.topBlocks = toLevelAbove.tail;
        } else {
            block.enclosingLoop().inside = toLevelAbove.tail;
        }
    }

    protected void checkMessagePassingCalls(CallGraph callGraph) {
        MPIcallInfo.checkMessagePassingCalls(callGraph);
    }

    public void buildSideEffectMemoryMap() {
        TapList<CallArrow> arrows = this.callees;
        this.targetZoneInfos = null;
        while (arrows != null) {
            Unit destination = ((CallArrow)arrows.head).destination;
            if (!this.isCorMore() || destination.isCorMore()) {
                ZoneInfo zoneInfo;
                if (destination.kind == 4 || destination.isProcedureWithCode()) {
                    while (destination != null) {
                        if (destination.declaredMemoryMap != null) {
                            destination.declaredMemoryMap.pourMemoryMap(this);
                        }
                        if (destination.sideEffectMemoryMap != null) {
                            destination.sideEffectMemoryMap.pourMemoryMap(this);
                        }
                        TapList<Unit> importedModulesOfDestination = TapList.append(destination.importedModules, destination.otherImportedModules);
                        while (importedModulesOfDestination != null) {
                            Unit importedModule = (Unit)importedModulesOfDestination.head;
                            if (importedModule.declaredMemoryMap != null) {
                                importedModule.declaredMemoryMap.pourMemoryMap(this);
                            }
                            if (importedModule.sideEffectMemoryMap != null) {
                                importedModule.sideEffectMemoryMap.pourMemoryMap(this);
                            }
                            importedModulesOfDestination = importedModulesOfDestination.tail;
                        }
                        if (destination.isProcedureWithCode()) {
                            SymbolTable visibleFromCaller;
                            SymbolTable symbolTable = visibleFromCaller = this.encloses(destination) ? this.privateSymbolTable() : this.publicSymbolTable();
                            for (SymbolTable visibleFromCalled = destination.publicSymbolTable().basisSymbolTable(); visibleFromCalled != null && !visibleFromCaller.nestedIn(visibleFromCalled); visibleFromCalled = visibleFromCalled.basisSymbolTable()) {
                                for (int z = visibleFromCalled.declaredZonesNb(0) - 1; z >= visibleFromCalled.firstDeclaredZone(0); --z) {
                                    zoneInfo = visibleFromCalled.declaredZoneInfo(z, 0);
                                    if (zoneInfo == null) continue;
                                    while (zoneInfo.from != null) {
                                        zoneInfo = zoneInfo.from;
                                    }
                                    this.addExtraSideEffectIfHidden(zoneInfo, visibleFromCaller, destination, visibleFromCalled);
                                }
                            }
                            TapList<TapPair<ZoneInfo, TapIntList>> destinationExtraSideEffect = destination.extraSideEffectVariables;
                            while (destinationExtraSideEffect != null) {
                                zoneInfo = (ZoneInfo)((TapPair)destinationExtraSideEffect.head).first;
                                if (zoneInfo.declarationUnit != null) {
                                    this.addExtraSideEffectIfHidden(zoneInfo, visibleFromCaller, zoneInfo.declarationUnit, zoneInfo.declarationUnit.publicSymbolTable());
                                }
                                destinationExtraSideEffect = destinationExtraSideEffect.tail;
                            }
                        }
                        destination = destination.upperLevelUnit;
                    }
                } else if (destination.kind != -1) {
                    destination.setDefaultOrUpdateExternalShape();
                    if (destination.elemArgPublicRanks == null) {
                        destination.computeElemArgInfo(destination.externalShape.length);
                    }
                    for (int i = destination.externalShape.length - 1; i >= 0; --i) {
                        zoneInfo = destination.externalShape[i];
                        if (zoneInfo.kind() != 11) continue;
                        MemoryMap.pourCommonInterval(this.declaredMemoryMap, this.sideEffectMemoryMap, zoneInfo.commonName, zoneInfo.startOffset, zoneInfo.endOffset, zoneInfo.infiniteEndOffset, zoneInfo.type);
                    }
                }
            }
            arrows = arrows.tail;
        }
    }

    private void addExtraSideEffectIfHidden(ZoneInfo zoneInfo, SymbolTable visibleSymbolTable, Unit callee, SymbolTable calleeSymbolTable) {
        ZoneInfo visibleZoneInfo = visibleSymbolTable.declaredZoneInfo(zoneInfo.zoneNb, 0);
        if (visibleZoneInfo != null) {
            while (visibleZoneInfo.from != null) {
                visibleZoneInfo = visibleZoneInfo.from;
            }
        }
        if (visibleZoneInfo != zoneInfo && TapList.assq(zoneInfo, this.extraSideEffectVariables) == null) {
            this.extraSideEffectVariables = new TapList<TapPair<ZoneInfo, TapIntList>>(new TapPair<ZoneInfo, Object>(zoneInfo, null), this.extraSideEffectVariables);
            if (zoneInfo.targetZonesTree != null) {
                TapList tziTree = this.explicitTargetZoneInfos(zoneInfo.targetZonesTree, calleeSymbolTable, callee);
                this.targetZoneInfos = new TapList<TapPair<ZoneInfo, TapList>>(new TapPair<ZoneInfo, TapList>(zoneInfo, tziTree), this.targetZoneInfos);
            }
        }
    }

    private TapList explicitTargetZoneInfos(TapList targetZoneTree, SymbolTable origSymbolTable, Unit origUnit) {
        TapList<Object> hdResult;
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        while (targetZoneTree != null) {
            tlResult = targetZoneTree.head instanceof TapList ? tlResult.placdl(this.explicitTargetZoneInfos((TapList)targetZoneTree.head, origSymbolTable, origUnit)) : (targetZoneTree.head instanceof TapIntList ? tlResult.placdl(this.explicitTargetZoneInfos((TapIntList)targetZoneTree.head, origSymbolTable, origUnit)) : tlResult.placdl(null));
            targetZoneTree = targetZoneTree.tail;
        }
        return hdResult.tail;
    }

    private TapList explicitTargetZoneInfos(TapIntList targetZoneList, SymbolTable origSymbolTable, Unit origUnit) {
        TapList<Object> hdResult;
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        while (targetZoneList != null) {
            ZoneInfo explicitZI = DataFlowAnalyzer.extendedDeclaredToZoneInfo(targetZoneList.head, origSymbolTable, origUnit);
            tlResult = tlResult.placdl(explicitZI);
            targetZoneList = targetZoneList.tail;
        }
        return hdResult.tail;
    }

    protected void allocateSideEffectZones() {
        this.sideEffectMemoryMap.buildAccessInfo();
        ZoneAllocator zoneAllocator = new ZoneAllocator(null);
        this.sideEffectMemoryMap.allocateZones(zoneAllocator, null);
        TapList<TapPair<ZoneInfo, TapIntList>> extraVars = this.extraSideEffectVariables;
        TapList<ZoneInfo> seZoneInfoList = null;
        TapList<TapPair<ZoneInfo, ZoneInfo>> oldZIToSEZI = null;
        while (extraVars != null) {
            TapPair oneSideEffectInfo = (TapPair)extraVars.head;
            ZoneInfo hiddenZoneInfo = (ZoneInfo)oneSideEffectInfo.first;
            zoneAllocator.startOffset = hiddenZoneInfo.startOffset;
            zoneAllocator.endOffset = hiddenZoneInfo.endOffset;
            zoneAllocator.infiniteEndOffset = hiddenZoneInfo.infiniteEndOffset;
            zoneAllocator.commonName = null;
            TapList zones = zoneAllocator.allocateOneZone(hiddenZoneInfo.type, -1, hiddenZoneInfo.accessTree, hiddenZoneInfo.rootAccessType, null, -1, false, false, false, false, hiddenZoneInfo, hiddenZoneInfo.targetZoneOf, hiddenZoneInfo.declarationUnit);
            ZoneInfo seZoneInfo = zoneAllocator.lastAllocated();
            seZoneInfo.ownerSymbolDecl = hiddenZoneInfo.ownerSymbolDecl;
            seZoneInfoList = new TapList<ZoneInfo>(seZoneInfo, seZoneInfoList);
            oldZIToSEZI = new TapList<TapPair<ZoneInfo, ZoneInfo>>(new TapPair<ZoneInfo, ZoneInfo>(hiddenZoneInfo, seZoneInfo), oldZIToSEZI);
            oneSideEffectInfo.second = ZoneInfo.listAllZones(zones, true);
            zoneAllocator.addVarName(zones, hiddenZoneInfo.bestVarName());
            extraVars = extraVars.tail;
        }
        this.sideEffectZoneInfos[0] = zoneAllocator.extractZoneInfos();
        this.freeSideEffectZone[0] = zoneAllocator.nextZone;
        this.sideEffectZoneInfos[2] = zoneAllocator.extractIntZoneInfos();
        this.freeSideEffectZone[2] = zoneAllocator.nextIntZone;
        this.sideEffectZoneInfos[1] = zoneAllocator.extractRealZoneInfos();
        this.freeSideEffectZone[1] = zoneAllocator.nextRealZone;
        this.sideEffectZoneInfos[3] = zoneAllocator.extractPtrZoneInfos();
        this.freeSideEffectZone[3] = zoneAllocator.nextPtrZone;
        int seZonesNb = this.sideEffectZonesNb(0);
        ZoneInfo[] ptrZIArray = this.sideEffectZoneInfos[3];
        for (int i = this.sideEffectZoneInfos[3].length - 1; i >= 0; --i) {
            ZoneInfo ptrZoneInfo = ptrZIArray[i];
            if (TapList.contains(seZoneInfoList, ptrZoneInfo)) continue;
            Unit.updateTargetsAsSideEffect(ptrZoneInfo.targetZonesTree, seZonesNb + 3);
        }
        while (seZoneInfoList != null) {
            this.updateTargetZoneInfos((ZoneInfo)seZoneInfoList.head, oldZIToSEZI, seZonesNb);
            seZoneInfoList = seZoneInfoList.tail;
        }
    }

    private static void updateTargetsAsSideEffect(TapList targets, int offset) {
        while (targets != null) {
            if (targets.head instanceof TapIntList) {
                TapIntList listRks = (TapIntList)targets.head;
                while (listRks != null) {
                    if (listRks.head >= 0) {
                        listRks.head -= offset;
                    }
                    listRks = listRks.tail;
                }
            } else {
                Unit.updateTargetsAsSideEffect((TapList)targets.head, offset);
            }
            targets = targets.tail;
        }
    }

    private void updateTargetZoneInfos(ZoneInfo seZoneInfo, TapList<TapPair<ZoneInfo, ZoneInfo>> oldZIToSEZI, int seZonesNb) {
        seZoneInfo.targetZoneOf = (ZoneInfo)TapList.cassq(seZoneInfo.targetZoneOf, oldZIToSEZI);
        ZoneInfo origZoneInfo = (ZoneInfo)TapList.rassq(seZoneInfo, oldZIToSEZI).first;
        TapList explicitOrigZoneInfosTree = (TapList)TapList.cassq(origZoneInfo, this.targetZoneInfos);
        seZoneInfo.targetZonesTree = this.implicitTargetSEZoneInfos(explicitOrigZoneInfosTree, oldZIToSEZI, seZonesNb);
    }

    private TapList implicitTargetSEZoneInfos(TapList zoneInfosTree, TapList<TapPair<ZoneInfo, ZoneInfo>> oldZIToSEZI, int seZonesNb) {
        TapList<Object> hdResult;
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        while (zoneInfosTree != null) {
            tlResult = zoneInfosTree.head instanceof TapList && ((TapList)zoneInfosTree.head).head instanceof ZoneInfo ? tlResult.placdl(this.implicitTargetSEZoneInfosList((TapList)zoneInfosTree.head, oldZIToSEZI, seZonesNb)) : tlResult.placdl(this.implicitTargetSEZoneInfos((TapList)zoneInfosTree.head, oldZIToSEZI, seZonesNb));
            zoneInfosTree = zoneInfosTree.tail;
        }
        return hdResult.tail;
    }

    private TapIntList implicitTargetSEZoneInfosList(TapList<ZoneInfo> zoneInfosList, TapList<TapPair<ZoneInfo, ZoneInfo>> oldZIToSEZI, int seZonesNb) {
        TapIntList hdResult;
        TapIntList tlResult = hdResult = new TapIntList(-1, null);
        while (zoneInfosList != null) {
            ZoneInfo originalDestZoneInfo = (ZoneInfo)zoneInfosList.head;
            while (originalDestZoneInfo.from != null) {
                originalDestZoneInfo = originalDestZoneInfo.from;
            }
            ZoneInfo seZoneInfo = (ZoneInfo)TapList.cassq(originalDestZoneInfo, oldZIToSEZI);
            if (seZoneInfo == null) {
                TapEnv.toolError("Target of side-effect pointer was not made side-effect:" + zoneInfosList.head + " in Unit:" + this);
            } else {
                int extendedRank = seZoneInfo.zoneNb - seZonesNb - 3;
                tlResult = tlResult.placdl(extendedRank);
            }
            zoneInfosList = zoneInfosList.tail;
        }
        return hdResult.tail;
    }

    protected void allocateDeclaredZones(int[] globalFirstZone, boolean initLowerLevelUnits) {
        SymbolTable symbolTable;
        if (this.publicSymbolTable == null) {
            return;
        }
        for (symbolTable = this.publicSymbolTable.basisSymbolTable(); symbolTable != null && symbolTable.usedModule != null; symbolTable = symbolTable.basisSymbolTable()) {
            symbolTable.updateImportedZones();
        }
        this.declaredMemoryMap.buildAccessInfo();
        SymbolTable basisNumberingST = this.isTopInFile() ? this.callGraph.languageRootSymbolTable(this.language) : this.upperLevelUnit.privateSymbolTable();
        this.publicSymbolTable.computeFirstDeclaredZone(globalFirstZone, basisNumberingST);
        ZoneAllocator zoneAllocator = new ZoneAllocator(this.publicSymbolTable);
        this.declaredMemoryMap.allocateZones(zoneAllocator, this);
        this.publicSymbolTable.allocateZones(zoneAllocator, this);
        zoneAllocator.extractAllZoneInfosInto(this.publicSymbolTable);
        TapList symbolTables = TapList.reverse(this.symbolTablesBottomUp).tail;
        symbolTables = TapList.unique(symbolTables);
        while (symbolTables != null) {
            symbolTable = (SymbolTable)symbolTables.head;
            symbolTable.computeFirstDeclaredZone(globalFirstZone, symbolTable.basisSymbolTable());
            zoneAllocator = new ZoneAllocator(symbolTable);
            symbolTable.allocateZones(zoneAllocator, this);
            zoneAllocator.extractAllZoneInfosInto(symbolTable);
            symbolTables = symbolTables.tail;
        }
        for (int i = 0; i <= 3; ++i) {
            globalFirstZone[i] = this.bodySymbolTable().getFreeDeclaredZone(i);
        }
        TapList<Unit> units = this.lowerLevelUnits;
        if (initLowerLevelUnits) {
            int[] init = new int[4];
            while (units != null) {
                System.arraycopy(globalFirstZone, 0, init, 0, 4);
                ((Unit)units.head).allocateDeclaredZones(init, true);
                units = units.tail;
            }
        }
    }

    protected void computeZoneInterfaces() {
        if (this.isProcedureWithCode() || this.kind == 4 || this.kind == 5) {
            int pz;
            int iz;
            int rz;
            int z;
            int declNb = this.publicSymbolTable.declaredZonesNb(0);
            int globNb = this.publicSymbolTable.firstDeclaredZone(0);
            int nbElemArgs = 0;
            TapList<ZoneInfo> shapeElements = null;
            TapList<Object> translatorElements = null;
            for (z = 0; z < declNb; ++z) {
                ZoneInfo zi = this.publicSymbolTable.declaredZoneInfo(z, 0);
                if (z < globNb && zi != null && zi.variableNames() != null) {
                    FunctionDecl funcDecl1;
                    TapList<FunctionDecl> funcDecls1 = this.publicSymbolTable.getTopFunctionDecl((String)zi.variableNames().head, null, null, false);
                    FunctionDecl functionDecl = funcDecl1 = funcDecls1 == null ? null : (FunctionDecl)funcDecls1.head;
                    if (!(funcDecl1 != null && funcDecl1.isVarFunction() || zi.kind() != 7 && zi.kind() != 10 && zi.kind() != 12)) {
                        zi = zi.copy();
                        zi.setKind(13);
                        zi.index = z;
                    }
                }
                if (zi != null && (this.kind == 1 || this.kind == 2 || this.kind == 5) && zi.comesFromAllocate()) {
                    zi = null;
                }
                if (zi == null) continue;
                shapeElements = new TapList<ZoneInfo>(zi, shapeElements);
                if (zi.kind() == 7 || zi.kind() == 10) {
                    ++nbElemArgs;
                }
                rz = zi.zoneNb(1);
                iz = zi.zoneNb(2);
                pz = zi.zoneNb(3);
                translatorElements = new TapList<PublicInfo>(PublicInfo.createDeclaredInfo(new TapIntList(z, null), rz >= 0 ? new TapIntList(rz, null) : null, iz >= 0 ? new TapIntList(iz, null) : null, pz >= 0 ? new TapIntList(pz, null) : null), translatorElements);
            }
            for (z = 0; z < this.freeSideEffectZone[0]; ++z) {
                shapeElements = new TapList<ZoneInfo>(this.sideEffectZoneInfos[0][z], shapeElements);
                rz = this.sideEffectZoneInfos[0][z].zoneNb(1);
                iz = this.sideEffectZoneInfos[0][z].zoneNb(2);
                pz = this.sideEffectZoneInfos[0][z].zoneNb(3);
                translatorElements = new TapList<PublicInfo>(PublicInfo.createSideEffectInfo(new TapIntList(z, null), rz >= 0 ? new TapIntList(rz, null) : null, iz >= 0 ? new TapIntList(iz, null) : null, pz >= 0 ? new TapIntList(pz, null) : null), translatorElements);
            }
            int shapeLength = TapList.length(shapeElements);
            this.externalShape = new ZoneInfo[shapeLength];
            this.translator = new PublicInfo[shapeLength];
            for (int i = shapeLength - 1; i >= 0; --i) {
                this.externalShape[i] = (ZoneInfo)shapeElements.head;
                shapeElements = shapeElements.tail;
                this.translator[i] = (PublicInfo)translatorElements.head;
                translatorElements = translatorElements.tail;
            }
            this.computeElemArgInfo(nbElemArgs);
            if (this.externalShape.length < 100) {
                this.transferMatrix = this.makeTransferMatrix(0, false);
                this.transferMatrixReal = this.makeTransferMatrix(1, false);
            }
            if (this.entryBlock != null) {
                TapIntList collectedZones = null;
                SymbolTable dataSymbolTable = this.publicSymbolTable();
                if (dataSymbolTable != null) {
                    collectedZones = this.collectZonesOfData(dataSymbolTable.dataList, null, dataSymbolTable);
                    collectedZones = this.collectZonesOfInitializedVariables(dataSymbolTable, collectedZones);
                }
                if ((dataSymbolTable = this.privateSymbolTable()) != null) {
                    collectedZones = this.collectZonesOfData(dataSymbolTable.dataList, collectedZones, dataSymbolTable);
                    collectedZones = this.collectZonesOfInitializedVariables(dataSymbolTable, collectedZones);
                }
                collectedZones = this.collectZonesOfInitializedVarDecl(this.bodySymbolTable(), collectedZones);
                this.entryBlock.setInitializedLocalZones(collectedZones);
            }
        } else if (this.kind == 2 || this.kind == 3) {
            this.setDefaultOrUpdateExternalShape();
            if (this.elemArgPublicRanks == null) {
                this.computeElemArgInfo(this.externalShape.length);
            }
        } else if (this.kind == 1) {
            this.setDefaultOrUpdateExternalShape();
            if (this.elemArgPublicRanks == null) {
                this.computeElemArgInfo(this.externalShape.length);
            }
            if (this.genericArrow.translator() == null) {
                this.genericArrow.computeTranslator();
            }
        }
    }

    private TapIntList collectZonesOfData(TapList<Tree> trees, TapIntList collected, SymbolTable symbolTable) {
        while (trees != null) {
            collected = this.collectZonesOfData((Tree)trees.head, collected, symbolTable);
            trees = trees.tail;
        }
        return collected;
    }

    private TapIntList collectZonesOfData(Tree dataTree, TapIntList collected, SymbolTable symbolTable) {
        switch (dataTree.opCode()) {
            case 50: {
                collected = this.collectZonesOfData(dataTree.down(1), collected, symbolTable);
                break;
            }
            case 70: {
                Tree[] sons = dataTree.children();
                for (int i = sons.length - 1; i >= 0; --i) {
                    collected = this.collectZonesOfData(sons[i], collected, symbolTable);
                }
                break;
            }
            case 8: 
            case 73: {
                collected = this.collectZonesOfData(dataTree.down(1), collected, symbolTable);
                break;
            }
            case 94: {
                String varName = ILUtils.getIdentString(dataTree);
                VariableDecl varDecl = symbolTable.getVariableOrConstantOrFuncNameDecl(varName);
                TapIntList zones = ZoneInfo.listAllZones(varDecl.zones(), true);
                collected = TapIntList.append(collected, zones);
                break;
            }
            case 108: {
                collected = this.collectZonesOfData(ILUtils.baseTree(dataTree), collected, symbolTable);
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(Data zones) Unexpected operator: " + dataTree.opName());
            }
        }
        return collected;
    }

    private TapIntList collectZonesOfInitializedVarDecl(SymbolTable symbolTable, TapIntList collected) {
        for (int zz = symbolTable.firstDeclaredZone(0); zz < symbolTable.freeDeclaredZone(0); ++zz) {
            ZoneInfo zoneInfo = symbolTable.declaredZoneInfo(zz, 0);
            SymbolDecl deepSymbolDecl = symbolTable.symbolDeclOf(zoneInfo.accessTree);
            if ((!(deepSymbolDecl instanceof VariableDecl) || ((VariableDecl)deepSymbolDecl).initializationTree() == null) && (!(deepSymbolDecl instanceof FieldDecl) || ((FieldDecl)deepSymbolDecl).initializationTree() == null)) continue;
            collected = new TapIntList(zz, collected);
        }
        return collected;
    }

    private TapIntList collectZonesOfInitializedVariables(SymbolTable symbolTable, TapIntList collected) {
        TapList<SymbolDecl> listOfVars = symbolTable.getAllTopVariableDecls();
        while (listOfVars != null) {
            VariableDecl variableDecl = (VariableDecl)listOfVars.head;
            if (variableDecl.initializationTree() != null) {
                TapIntList zones = ZoneInfo.listAllZones(variableDecl.zones(), true);
                collected = TapIntList.append(collected, zones);
            }
            listOfVars = listOfVars.tail;
        }
        return collected;
    }

    protected void computeArrowZoneInterfaces() {
        TapList<CallArrow> arrows = this.callees;
        while (arrows != null) {
            CallArrow arrow = (CallArrow)arrows.head;
            if (arrow.destination != null && !arrow.destination.isPackage()) {
                arrow.computeTranslator();
            }
            arrows = arrows.tail;
        }
    }

    private void setDefaultOrUpdateExternalShape() {
        boolean hasReturn;
        WrapperTypeSpec returnType = this.functionTypeSpec().returnType;
        WrapperTypeSpec[] argumentsTypes = this.functionTypeSpec().argumentsTypes;
        boolean bl = hasReturn = returnType == null || returnType.wrappedType == null || !TypeSpec.isA(returnType, 9);
        if (this.externalShape == null) {
            SymbolTable enclosingSymbolTable;
            ZoneAllocator zoneAllocator = new ZoneAllocator(this.externalSymbolTable());
            zoneAllocator.setCommonName(null);
            zoneAllocator.setStartOffset(-1);
            zoneAllocator.setInfiniteEndOffset(false);
            zoneAllocator.setEndOffset(-1);
            if (argumentsTypes != null) {
                for (int i = 0; i < argumentsTypes.length; ++i) {
                    zoneAllocator.allocateZones(null, null, argumentsTypes[i], argumentsTypes[i], -1, null, i + 1, false, false, false, null, null, this.publicSymbolTable(), this);
                }
            }
            if (hasReturn) {
                zoneAllocator.allocateZones(null, null, returnType, returnType, -1, null, 0, false, false, false, null, null, this.publicSymbolTable(), this);
            }
            TapList<ZoneInfo> allZoneInfos = null;
            TapList<SymbolTable> enclosingSymbolTables = null;
            for (enclosingSymbolTable = this.externalSymbolTable(); enclosingSymbolTable != null; enclosingSymbolTable = enclosingSymbolTable.basisSymbolTable()) {
                enclosingSymbolTables = new TapList<SymbolTable>(enclosingSymbolTable, enclosingSymbolTables);
            }
            while (enclosingSymbolTables != null) {
                enclosingSymbolTable = (SymbolTable)enclosingSymbolTables.head;
                ZoneInfo[] enclosingZoneInfos = enclosingSymbolTable.getDeclaredZoneInfos(0);
                if (enclosingZoneInfos != null) {
                    for (ZoneInfo enclosingZoneInfo : enclosingZoneInfos) {
                        if (enclosingZoneInfo == null || enclosingZoneInfo.comesFromAllocate()) continue;
                        allZoneInfos = new TapList<ZoneInfo>(enclosingZoneInfo, allZoneInfos);
                    }
                }
                enclosingSymbolTables = enclosingSymbolTables.tail;
            }
            zoneAllocator.zoneInfos = TapList.append(zoneAllocator.zoneInfos, allZoneInfos);
            this.externalShape = zoneAllocator.extractZoneInfos();
        } else {
            ZoneInfo zoneInfo;
            int n;
            int lastIntZ = -1;
            int lastRealZ = -1;
            int lastPtrZ = -1;
            ZoneInfo[] zoneInfoArray = this.externalShape;
            int n2 = zoneInfoArray.length;
            for (n = 0; n < n2; ++n) {
                ZoneInfo value;
                zoneInfo = value = zoneInfoArray[n];
                if (zoneInfo.intZoneNb > lastIntZ) {
                    lastIntZ = zoneInfo.intZoneNb;
                }
                if (zoneInfo.realZoneNb > lastRealZ) {
                    lastRealZ = zoneInfo.realZoneNb;
                }
                if (zoneInfo.ptrZoneNb <= lastPtrZ) continue;
                lastPtrZ = zoneInfo.ptrZoneNb;
            }
            zoneInfoArray = this.externalShape;
            n2 = zoneInfoArray.length;
            for (n = 0; n < n2; ++n) {
                ZoneInfo info;
                zoneInfo = info = zoneInfoArray[n];
                ToObject<Object> toModifiedType = new ToObject<Object>(null);
                WrapperTypeSpec leafZoneType = TypeSpec.peelSizeModifier(zoneInfo.type, toModifiedType, this.privateSymbolTable());
                if (toModifiedType.obj() != null) {
                    zoneInfo.typeSizeModifier = ((ModifiedTypeSpec)toModifiedType.obj()).sizeModifierValue();
                }
                if (TypeSpec.isA(leafZoneType, 6)) {
                    if (zoneInfo.ptrZoneNb >= 0) continue;
                    zoneInfo.ptrZoneNb = ++lastPtrZ;
                    continue;
                }
                if (!TypeSpec.isA(leafZoneType, 7)) continue;
                String leafZoneTypeName = ((PrimitiveTypeSpec)leafZoneType.wrappedType).name;
                if (leafZoneTypeName.equals("integer")) {
                    if (zoneInfo.intZoneNb >= 0) continue;
                    zoneInfo.intZoneNb = ++lastIntZ;
                    continue;
                }
                if (!leafZoneTypeName.equals("float") && !leafZoneTypeName.equals("complex") || zoneInfo.realZoneNb >= 0) continue;
                zoneInfo.realZoneNb = ++lastRealZ;
            }
        }
    }

    private void computeElemArgInfo(int nbElemArgs) {
        int i;
        ZoneInfo zoneInfo;
        this.elemArgPublicRanks = new int[nbElemArgs];
        int elemArgRank = 0;
        int formalArgumentsNumber = this.formalArgumentsNb();
        int maxZoneInfoNb = -1;
        for (ZoneInfo info : this.externalShape) {
            zoneInfo = info;
            if (zoneInfo != null && zoneInfo.kind() == 7 && zoneInfo.index > formalArgumentsNumber) {
                formalArgumentsNumber = zoneInfo.index;
            }
            if (zoneInfo == null || zoneInfo.zoneNb <= maxZoneInfoNb) continue;
            maxZoneInfoNb = zoneInfo.zoneNb;
        }
        this.argsZoneTrees = new TapList[formalArgumentsNumber + 1];
        for (i = this.argsZoneTrees.length - 1; i >= 0; --i) {
            this.argsZoneTrees[i] = new TapList<Object>(null, null);
        }
        this.zoneRkToElemArgRk = new int[maxZoneInfoNb + 1];
        for (i = 0; i < this.externalShape.length; ++i) {
            zoneInfo = this.externalShape[i];
            if (zoneInfo == null) continue;
            int paramNumber = -1;
            if (zoneInfo.kind() == 7) {
                paramNumber = zoneInfo.index;
            } else if (zoneInfo.kind() == 10) {
                paramNumber = 0;
            }
            if (paramNumber < 0) continue;
            Tree accessTree = zoneInfo.accessTree;
            if (ILUtils.isAccessibleDirectlyFromVariable(accessTree)) {
                TapList tree = this.argsZoneTrees[paramNumber];
                TapList<?> location = TapList.getSetFieldLocation(tree, accessTree, true);
                location.head = new TapIntList(elemArgRank, null);
            }
            this.zoneRkToElemArgRk[zoneInfo.zoneNb] = elemArgRank;
            this.elemArgPublicRanks[elemArgRank] = i;
            ++elemArgRank;
        }
        this.argsPublicRankTrees = new TapList[formalArgumentsNumber + 1];
        for (i = this.argsZoneTrees.length - 1; i >= 0; --i) {
            this.argsPublicRankTrees[i] = TapList.copyTree(this.argsZoneTrees[i]);
            TapList.replaceIntsWithValueInts(this.argsPublicRankTrees[i], this.elemArgPublicRanks, 0);
        }
    }

    protected boolean hasGlobalArgs() {
        boolean globalFound = false;
        if (this.externalShape != null) {
            for (int i = this.externalShape.length - 1; !globalFound && i > 0; --i) {
                ZoneInfo zi = this.externalShape[i];
                if (zi == null || !zi.isCommon() && !zi.isGlobal() || this.unitInOutN != null && !this.unitInOutR.get(i) && !this.unitInOutW.get(i) && !this.unitInOutRW.get(i)) continue;
                globalFound = true;
            }
        }
        return globalFound;
    }

    public BoolMatrix makeTransferMatrix(int whichKind, boolean withNullPtrs) {
        int offsetForDeclared = this.freeSideEffectZone[whichKind];
        if (withNullPtrs) {
            offsetForDeclared += 2;
        }
        BoolMatrix transferMatrixThisKind = new BoolMatrix(this.hasTooManyZones(), this.translator.length + (withNullPtrs ? 2 : 0), offsetForDeclared + this.publicSymbolTable().declaredZonesNb(whichKind));
        transferMatrixThisKind.setExplicitZero();
        for (int i = this.translator.length - 1; i >= 0; --i) {
            PublicInfo publicInfo = this.translator[i];
            int privateZonesOffset = publicInfo.kind() == 8 ? offsetForDeclared : 0;
            TapIntList privateZones = publicInfo.ranks(whichKind);
            while (privateZones != null) {
                if (privateZones.head >= 0) {
                    transferMatrixThisKind.set(i, privateZones.head + privateZonesOffset, true);
                }
                privateZones = privateZones.tail;
            }
        }
        if (withNullPtrs) {
            transferMatrixThisKind.set(this.translator.length, offsetForDeclared - 2, true);
            transferMatrixThisKind.set(this.translator.length + 1, offsetForDeclared - 1, true);
        }
        return transferMatrixThisKind;
    }

    public BoolMatrix transferTransposed(BoolMatrix matrix, int whichKind) {
        int nRows = this.translator.length;
        int nbSECols = this.freeSideEffectZone[whichKind];
        BoolMatrix result = new BoolMatrix(nRows, matrix.nRows);
        result.setExplicitZero();
        for (int i = nRows - 1; i >= 0; --i) {
            PublicInfo publicInfo = this.translator[i];
            TapIntList leftIndices = publicInfo.ranks(whichKind);
            if (publicInfo.kind() == 8 && nbSECols != 0) {
                leftIndices = TapIntList.addOffset(leftIndices, nbSECols);
            }
            BoolVector cumulRow = result.getRow(i);
            for (int j = matrix.nRows - 1; j >= 0; --j) {
                if (matrix.rows[j] == null) {
                    if (!TapIntList.contains(leftIndices, j)) continue;
                    cumulRow.set(j, true);
                    continue;
                }
                if (!matrix.rows[j].intersects(leftIndices)) continue;
                cumulRow.set(j, true);
            }
        }
        return result;
    }

    private void declareDeadBlock(Block deadBlock) {
        deadBlock.rank = -2;
        TapList<FGArrow> arrows = deadBlock.flow();
        while (arrows != null) {
            ((FGArrow)arrows.head).redirectDestination(null);
            arrows = arrows.tail;
        }
        arrows = deadBlock.backFlow();
        while (arrows != null) {
            ((FGArrow)arrows.head).redirectOrigin(null);
            arrows = arrows.tail;
        }
        TapList<Instruction> instructions = deadBlock.instructions;
        while (instructions != null) {
            this.addDeadTree(((Instruction)instructions.head).tree);
            instructions = instructions.tail;
        }
    }

    protected void coherence() {
        this.allBlocks = new TapList<Object>(null, null);
        this.allArrows = new TapList<Object>(null, null);
        this.getAllBlocks(this.topBlocks, this.allBlocks, null, null);
        this.allBlocks = this.allBlocks.tail;
        this.entryBlock.rank = -1;
        this.entryBlock.coherence();
        TapList<Block> inAllBlocks = this.allBlocks;
        int curBlockRank = 0;
        int curLoopRank = 0;
        while (inAllBlocks != null) {
            LoopBlock enclosing;
            Block block = (Block)inAllBlocks.head;
            block.rank = curBlockRank++;
            block.symbolicRk = null;
            block.isFGCycleTail = false;
            block.isFGCycleHead = false;
            block.coherence();
            if (block instanceof HeaderBlock && (enclosing = block.enclosingLoop()) != null) {
                enclosing.rank = curLoopRank++;
            }
            inAllBlocks = inAllBlocks.tail;
        }
        this.exitBlock.rank = curBlockRank;
        this.exitBlock.coherence();
        this.nbBlocks = curBlockRank;
        this.nbLoopBlocks = curLoopRank;
        int curArrowRank = 0;
        inAllBlocks = new TapList<Block>(this.entryBlock, this.allBlocks);
        while (inAllBlocks != null) {
            TapList<FGArrow> arrows = ((Block)inAllBlocks.head).flow();
            while (arrows != null) {
                FGArrow arrow = (FGArrow)arrows.head;
                arrow.coherence();
                arrow.setRank(curArrowRank);
                this.allArrows.newR(arrow);
                ++curArrowRank;
                if (arrow.origin.rank >= arrow.destination.rank) {
                    arrow.origin.isFGCycleTail = true;
                    arrow.destination.isFGCycleHead = true;
                }
                arrows = arrows.tail;
            }
            inAllBlocks = inAllBlocks.tail;
        }
        this.allArrows = this.allArrows.tail;
        this.nbArrows = curArrowRank;
    }

    private TapList<Block> getAllBlocks(TapList<Block> fromBlocks, TapList<Block> toBlocks, LoopBlock enclosing, TapList<LoopBlock> enclosings) {
        while (fromBlocks != null) {
            ((Block)fromBlocks.head).setEnclosingLoop(enclosing);
            if (fromBlocks.head instanceof LoopBlock) {
                LoopBlock loopBlock = (LoopBlock)fromBlocks.head;
                loopBlock.entryBlocks = null;
                loopBlock.exitBlocks = null;
                loopBlock.entryArrows = null;
                loopBlock.exitArrows = null;
                loopBlock.cycleArrows = null;
                loopBlock.setEnclosingLoopBLocks(enclosings);
                toBlocks = this.getAllBlocks(loopBlock.inside, toBlocks, loopBlock, new TapList<LoopBlock>(loopBlock, enclosings));
            } else {
                toBlocks = toBlocks.placdl((Block)fromBlocks.head);
            }
            fromBlocks = fromBlocks.tail;
        }
        return toBlocks;
    }

    protected TapIntList getSideEffectKindZones(TapIntList zones, int whichKind) {
        TapIntList result;
        TapIntList tlResult = result = new TapIntList(-1, null);
        while (zones != null) {
            int kindZone;
            if (zones.head > 0 && (kindZone = this.sideEffectZoneInfos[0][zones.head].zoneNb(whichKind)) >= 0) {
                tlResult = tlResult.placdl(kindZone);
            }
            zones = zones.tail;
        }
        return result.tail;
    }

    protected TapPair<TapList, Unit> getZonesOfCommonInterval(String commonName, int startOffset, int endOffset, boolean infiniteEndOffset, ToBool declared) {
        TapList zonesFound = null;
        Unit searchedUnit = this;
        Unit unitWhereFound = null;
        while (searchedUnit != null && zonesFound == null) {
            zonesFound = searchedUnit.declaredMemoryMap.getZonesOfCommonInterval(commonName, startOffset, endOffset, infiniteEndOffset);
            if (zonesFound != null) {
                unitWhereFound = searchedUnit;
                continue;
            }
            TapList<Unit> importedModulesOfSearched = TapList.append(searchedUnit.importedModules, searchedUnit.otherImportedModules);
            while (importedModulesOfSearched != null && zonesFound == null) {
                Unit importedModule = (Unit)importedModulesOfSearched.head;
                zonesFound = importedModule.declaredMemoryMap.getZonesOfCommonInterval(commonName, startOffset, endOffset, infiniteEndOffset);
                if (zonesFound != null) {
                    unitWhereFound = importedModule;
                }
                importedModulesOfSearched = importedModulesOfSearched.tail;
            }
            searchedUnit = searchedUnit.upperLevelUnit;
        }
        if (zonesFound == null) {
            declared.set(false);
            zonesFound = this.sideEffectMemoryMap.getZonesOfCommonInterval(commonName, startOffset, endOffset, infiniteEndOffset);
            if (zonesFound != null) {
                unitWhereFound = this;
            }
        }
        return new TapPair<Object, Object>(zonesFound, unitWhereFound);
    }

    public TapIntList translateDeclaredToPublicZones(TapIntList declaredZones) {
        TapIntList hdPublicZones;
        TapIntList tlPublicZones = hdPublicZones = new TapIntList(-1, null);
        while (declaredZones != null) {
            int publicZone = PublicInfo.getPublicZoneFromDeclaredZone(this.translator, declaredZones.head);
            if (publicZone != -1) {
                tlPublicZones = tlPublicZones.placdl(publicZone);
            }
            declaredZones = declaredZones.tail;
        }
        return hdPublicZones.tail;
    }

    private TapIntList translateSideEffectToPublicZones(TapIntList sideEffectZones) {
        TapIntList hdPublicZones;
        TapIntList tlPublicZones = hdPublicZones = new TapIntList(-1, null);
        while (sideEffectZones != null) {
            int publicZone = PublicInfo.getPublicZoneFromSideEffectZone(this.translator, sideEffectZones.head);
            if (publicZone != -1) {
                tlPublicZones = tlPublicZones.placdl(publicZone);
            }
            sideEffectZones = sideEffectZones.tail;
        }
        return hdPublicZones.tail;
    }

    public TapIntList translateToCallerZones(TapIntList publicZones, Unit origUnit) {
        ZoneInfo[] unitExternalShape = this.externalShape;
        TapIntList callerZones = null;
        while (publicZones != null) {
            PublicInfo tmpOrigPublicInfo = CallArrow.computeCallTranslatorElem(unitExternalShape[publicZones.head], this, origUnit);
            if (tmpOrigPublicInfo != null) {
                TapIntList newPublicZones = null;
                if (tmpOrigPublicInfo.kind() == 8) {
                    newPublicZones = origUnit.translateDeclaredToPublicZones(tmpOrigPublicInfo.ranks(0));
                } else if (tmpOrigPublicInfo.kind() == 9) {
                    newPublicZones = origUnit.translateSideEffectToPublicZones(tmpOrigPublicInfo.ranks(0));
                }
                while (newPublicZones != null) {
                    callerZones = TapIntList.addIntoSorted(callerZones, newPublicZones.head);
                    newPublicZones = newPublicZones.tail;
                }
            }
            publicZones = publicZones.tail;
        }
        return callerZones;
    }

    public TapIntList actuallyDifferentiableZones(TapIntList zones) {
        TapIntList hdDifferentiableZones;
        ZoneInfo[] unitExternalShape = this.externalShape;
        TapIntList tlDifferentiableZones = hdDifferentiableZones = new TapIntList(-1, null);
        while (zones != null) {
            if (unitExternalShape[zones.head].realZoneNb != -1) {
                tlDifferentiableZones = tlDifferentiableZones.placdl(zones.head);
            }
            zones = zones.tail;
        }
        return hdDifferentiableZones.tail;
    }

    public TapIntList publicRankOfResult() {
        TapIntList result = null;
        for (int i = this.externalShape.length - 1; i >= 0; --i) {
            if (this.externalShape[i] == null || this.externalShape[i].kind() != 10) continue;
            result = new TapIntList(i, result);
        }
        return result;
    }

    protected void computeZonesUsedInDeclarations() {
        this.zonesUsedInDeclarations = new BoolVector(this.sideEffectZonesNb(0) + this.bodySymbolTable().declaredZonesNb(0));
        TapList<Block> bl = this.allBlocks;
        Instruction instr0 = null;
        while (instr0 == null && bl != null) {
            if (((Block)bl.head).instructions != null) {
                instr0 = (Instruction)((Block)bl.head).instructions.head;
            }
            bl = bl.tail;
        }
        this.collectZonesUsedInDeclarations(this.publicSymbolTable().getAllTopSymbolDecls(), instr0);
        this.collectZonesUsedInDeclarations(this.bodySymbolTable().getAllTopSymbolDecls(), instr0);
    }

    private void collectZonesUsedInDeclarations(TapList<SymbolDecl> listOfSymbolDecls, Instruction instr0) {
        TapList<Object> toUsedTrees = new TapList<Object>(null, null);
        TapList<Object> toDejaVu = new TapList<Object>(null, null);
        while (listOfSymbolDecls != null) {
            SymbolDecl symbolDecl = (SymbolDecl)listOfSymbolDecls.head;
            symbolDecl.collectUsedTrees(toUsedTrees, toDejaVu);
            while (toUsedTrees.tail != null) {
                BoolVector zonesUsedByDecl = this.privateSymbolTable.zonesUsedByExp((Tree)toUsedTrees.tail.head, instr0);
                this.zonesUsedInDeclarations.cumulOr(zonesUsedByDecl);
                toUsedTrees.tail = toUsedTrees.tail.tail;
            }
            listOfSymbolDecls = listOfSymbolDecls.tail;
        }
    }

    protected TapList<Unit> addInterfaceDecl(TreeProtocol inputStream, CallGraph callGraph, SymbolTable symbolTable) throws IOException {
        Tree preCommentsAnnot = null;
        Tree postCommentsAnnot = null;
        TapList<Unit> result = null;
        inputStream.readOperator();
        while (inputStream.seeOperator().code == 6) {
            inputStream.readOperator();
            String annotationName = inputStream.readString();
            Tree annotationTree = inputStream.readTree();
            if (annotationName.equals("preComments")) {
                preCommentsAnnot = annotationTree;
                continue;
            }
            if (!annotationName.equals("postComments")) continue;
            postCommentsAnnot = annotationTree;
        }
        Tree currentTree = inputStream.readTree();
        inputStream.readOperator();
        SymbolTable enclosingPrivateSymbolTable = symbolTable.unit != null ? (symbolTable.unit.isModule() ? symbolTable.unit.publicSymbolTable() : symbolTable.unit.privateSymbolTable()) : callGraph.languageRootSymbolTable(this.language);
        InterfaceDecl interfaceDecl = null;
        if (currentTree.opCode() != 136) {
            interfaceDecl = symbolTable.addInterfaceDecl(currentTree, this);
            interfaceDecl.setInterfaceInstr(true);
        }
        block6: while (inputStream.seeOperator().code != 64) {
            switch (inputStream.seeOperator().code) {
                case 103: {
                    FunctionDecl functionDecl;
                    inputStream.readOperator();
                    if (inputStream.seeOperator().code != 87) continue block6;
                    Unit unit = callGraph.createNewUnit(this, this.language);
                    unit.enclosingUnitOfInterface = this;
                    unit.setInterface();
                    SymbolDecl declAsFormalParam = null;
                    FlowGraphBuilder.build(inputStream, symbolTable, callGraph, this.language, unit, false);
                    unit.preComments = preCommentsAnnot;
                    unit.postComments = postCommentsAnnot;
                    unit.exportFunctionTypeSpec();
                    assert (unit.entryBlock.headTree() != null);
                    unit.parametersOrModuleNameTree = ILUtils.getArguments(unit.entryBlock.headTree());
                    if (this.isStandard()) {
                        declAsFormalParam = this.publicSymbolTable().getTopSymbolDecl(unit.name);
                    }
                    if (declAsFormalParam != null && declAsFormalParam.isA(1)) {
                        callGraph.languageRootSymbolTable(this.language).removeDecl(unit.name, 3, true);
                        unit.turnVarFunction(this);
                        Tree unitName = ILUtils.getCalledName(unit.entryBlock.headTree());
                        functionDecl = new FunctionDecl(unitName, unit);
                        functionDecl.setInterfaceInstr(true);
                        SymbolDecl oldVarDecl = enclosingPrivateSymbolTable.basisSymbolTable().getDecl(functionDecl.symbol, 1, true);
                        if (oldVarDecl != null) {
                            TapList<SymbolDecl> dependsOn = oldVarDecl.dependsOn();
                            enclosingPrivateSymbolTable.basisSymbolTable().removeDecl(functionDecl.symbol, 1, true);
                            functionDecl.dependsOn = dependsOn;
                        }
                        enclosingPrivateSymbolTable.basisSymbolTable().addSymbolDecl(functionDecl);
                    } else {
                        TapList<FunctionDecl> functionDecls = symbolTable.getFunctionDecl(unit.name, unit.functionTypeSpec().returnType, unit.functionTypeSpec().argumentsTypes, true);
                        if (functionDecls == null) {
                            functionDecls = symbolTable.getFunctionDecl(unit.name, unit.functionTypeSpec().returnType, null, true);
                        }
                        functionDecl = (FunctionDecl)functionDecls.head;
                    }
                    functionDecl.setInterfaceInstr(true);
                    if (interfaceDecl != null) {
                        interfaceDecl.addInInterfaceDecl(functionDecl, this);
                        interfaceDecl.setInterfaceUnits(TapList.append(interfaceDecl.interfaceUnits(), new TapList<Unit>(unit, null)));
                    }
                    TapList<Tree> importedModulesTree = unit.importedModulesUseDecl;
                    while (importedModulesTree != null) {
                        String usedModuleName;
                        Unit usedModule;
                        if (((Tree)importedModulesTree.head).opCode() == 192 && (usedModule = symbolTable.getModule(usedModuleName = ((Tree)importedModulesTree.head).down(1).stringValue())) != null) {
                            CallGraph.addCallArrow(this, 2, usedModule);
                        }
                        importedModulesTree = importedModulesTree.tail;
                    }
                    result = new TapList<Unit>(unit, result);
                    continue block6;
                }
                case 130: {
                    currentTree = inputStream.readTree();
                    interfaceDecl.addInInterfaceDecl(currentTree);
                    continue block6;
                }
                case 6: {
                    inputStream.readOperator();
                    String annotationName = inputStream.readString();
                    Tree annotationTree = inputStream.readTree();
                    if (annotationName.equals("preComments")) {
                        preCommentsAnnot = annotationTree;
                        continue block6;
                    }
                    if (!annotationName.equals("postComments")) continue block6;
                    postCommentsAnnot = annotationTree;
                    continue block6;
                }
            }
            TapEnv.toolWarning(-1, "(Reading interface declaration) Unexpected tree: " + inputStream.readTree());
        }
        inputStream.readOperator();
        inputStream.readTree();
        return result;
    }

    protected void declareAllSymbolDecls() {
        TapList<SymbolTable> inSymbolTables = TapList.reverse(this.symbolTablesBottomUp);
        while (inSymbolTables != null) {
            ((SymbolTable)inSymbolTables.head).declareAllSymbolDecls();
            inSymbolTables = inSymbolTables.tail;
        }
    }

    public SymbolDecl getImportedDecl(String name, int kind) {
        Unit currentUnit = this;
        SymbolDecl result = null;
        while (result == null && currentUnit != null) {
            for (SymbolTable importedSymbolTable = currentUnit.publicSymbolTable().basisSymbolTable(); result == null && importedSymbolTable != null && importedSymbolTable.usedModule != null; importedSymbolTable = importedSymbolTable.basisSymbolTable()) {
                result = importedSymbolTable.getTopDecl(name, kind);
            }
            currentUnit = currentUnit.upperLevelUnit;
        }
        return result;
    }

    public boolean isUseAssociatedIntrinsic(FunctionDecl intrinsicDecl) {
        boolean result = false;
        TapList<Unit> importedMods = this.importedModules;
        while (!result && importedMods != null) {
            result = ((Unit)importedMods.head).publicSymbolTable().getTopFunctionDecl(intrinsicDecl.symbol, null, null, false) != null;
            importedMods = importedMods.tail;
        }
        importedMods = this.otherImportedModules;
        while (!result && importedMods != null) {
            result = ((Unit)importedMods.head).publicSymbolTable().getTopFunctionDecl(intrinsicDecl.symbol, null, null, false) != null;
            importedMods = importedMods.tail;
        }
        return result;
    }

    private SymbolDecl[] getParameterDecls() {
        SymbolDecl[] result = null;
        if (this.entryBlock != null && this.entryBlock.headTree() != null) {
            Tree[] callArgsTrees = ILUtils.getArguments(this.entryBlock.headTree()).children();
            result = new SymbolDecl[callArgsTrees.length];
            SymbolTable argsSymbolTable = this.publicSymbolTable();
            for (int i = 0; i < callArgsTrees.length; ++i) {
                Tree argTree = callArgsTrees[i];
                if (argTree.opCode() != 172) {
                    TapList<InterfaceDecl> interfaceDecls;
                    result[i] = argsSymbolTable.getVariableDecl(ILUtils.baseName(argTree));
                    if (result[i] == null) {
                        TapList<FunctionDecl> tmp = argsSymbolTable.getFunctionDecl(ILUtils.baseName(argTree), null, null, false);
                        SymbolDecl symbolDecl = result[i] = tmp == null ? null : (SymbolDecl)tmp.head;
                    }
                    if (result[i] != null || (interfaceDecls = argsSymbolTable.getInterfaceDecl(ILUtils.baseName(argTree))) == null) continue;
                    result[i] = (SymbolDecl)interfaceDecls.head;
                    continue;
                }
                result[i] = null;
            }
        }
        return result;
    }

    protected int getOptionalParameterDeclsNumber() {
        int result = 0;
        if (this.entryBlock != null) {
            Tree[] callArgsTrees = ILUtils.getArguments(this.entryBlock.headTree()).children();
            SymbolTable argsSymbolTable = this.publicSymbolTable();
            for (Tree argTree : callArgsTrees) {
                VariableDecl params;
                if (argTree.opCode() == 172 || (params = argsSymbolTable.getVariableDecl(ILUtils.baseName(argTree))) != null && !params.isOptional()) continue;
                ++result;
            }
        }
        return result;
    }

    public Block middleNormalBlock() {
        Block middleBlock = null;
        if (this.allBlocks != null) {
            int ll = TapList.length(this.allBlocks);
            int n1 = ll / 2;
            for (int n2 = n1 + 1; middleBlock == null && n1 >= 0 && n2 < ll; --n1, ++n2) {
                middleBlock = (Block)TapList.nth(this.allBlocks, n1);
                if (middleBlock.isALoop()) {
                    middleBlock = null;
                }
                if (middleBlock != null || !(middleBlock = (Block)TapList.nth(this.allBlocks, n2)).isALoop()) continue;
                middleBlock = null;
            }
        }
        return middleBlock;
    }

    public Unit copyUnitExceptSymbolTables(CallGraph callGraph, Unit upperLevelUnit, Unit otherEnclosingUnitOfInterface) {
        Unit copyUnit = callGraph.createNewUnit(upperLevelUnit, this.language);
        copyUnit.name = this.name;
        copyUnit.kind = this.kind;
        copyUnit.language = this.language;
        copyUnit.position = this.position;
        copyUnit.allArrows = Unit.copyUnitBody(this, copyUnit, false);
        copyUnit.topBlocks = null;
        copyUnit.nbBlocks = this.nbBlocks;
        copyUnit.nbArrows = this.nbArrows;
        copyUnit.nbLoopBlocks = this.nbLoopBlocks;
        copyUnit.functionTypeSpec = this.functionTypeSpec;
        copyUnit.formats = this.formats;
        copyUnit.preComments = this.preComments;
        copyUnit.postComments = this.postComments;
        copyUnit.preCommentsBlock = this.preCommentsBlock;
        copyUnit.postCommentsBlock = this.postCommentsBlock;
        copyUnit.lostComments = this.lostComments;
        copyUnit.modifiers = this.modifiers;
        copyUnit.declaredMemoryMap = this.declaredMemoryMap;
        copyUnit.otherReturnVar = this.otherReturnVar;
        copyUnit.hasArrayNotation = this.hasArrayNotation;
        copyUnit.enclosingUnitOfInterface = otherEnclosingUnitOfInterface;
        copyUnit.containsAllocDealloc = this.containsAllocDealloc;
        if (this.userHelp.tail != null) {
            copyUnit.userHelp = new TapList<Object>(null, this.userHelp.tail);
        }
        return copyUnit;
    }

    public TapList<Unit> collectContainedUnits(TapList<Unit> collector) {
        TapList<Unit> contained = this.lowerLevelUnits;
        while (contained != null) {
            collector = ((Unit)contained.head).collectContainedUnits(new TapList<Unit>((Unit)contained.head, collector));
            contained = contained.tail;
        }
        return collector;
    }

    public TapTriplet<TapList<FGArrow>, TapList<Block>, TapList<FGArrow>> getFrontierOfParallelRegion(Block regionBlock) {
        Instruction parallelControl = regionBlock.lastInstr();
        TapList<Block> parallelRegionBody = null;
        TapList exitArrows = null;
        TapList<Block> inAllBlocks = this.allBlocks;
        while (inAllBlocks != null) {
            Block block = (Block)inAllBlocks.head;
            if (TapList.contains(block.parallelControls, parallelControl)) {
                parallelRegionBody = new TapList<Block>(block, parallelRegionBody);
                TapList<FGArrow> inExitArrows = block.flow();
                while (inExitArrows != null) {
                    if (!TapList.contains(((FGArrow)inExitArrows.head).destination.parallelControls, parallelControl)) {
                        exitArrows = new TapList(inExitArrows.head, exitArrows);
                    }
                    inExitArrows = inExitArrows.tail;
                }
            }
            inAllBlocks = inAllBlocks.tail;
        }
        return new TapTriplet(regionBlock.flow(), TapList.nreverse(parallelRegionBody), exitArrows);
    }

    public void dump(int indent) throws IOException {
        Tree comments;
        TapList<Tree> inLostComments;
        CallArrow arrow;
        TapEnv.indentPrint(indent, "Call Node number " + this.rank() + ": " + this + " contained in " + this.upperLevelUnit());
        TapEnv.println();
        TapEnv.pushRelatedUnit(this);
        if (this.fromInclude != null) {
            TapEnv.indentPrint(indent + 6, "From Include:" + this.fromInclude);
            TapEnv.println();
        }
        TapEnv.indentPrint(indent + 6, "LowerLevelUnits " + this.lowerLevelUnits);
        TapEnv.println();
        TapEnv.indentPrint(indent + 6, "Error messages");
        TapEnv.println();
        TapList msg = this.messages.tail;
        while (msg != null) {
            TapEnv.indentPrint(indent + 8, ((PositionAndMessage)msg.head).toString());
            TapEnv.println();
            msg = msg.tail;
        }
        TapEnv.indentPrint(indent + 6, "SymbolTables:" + this.bodySymbolTable() + " till external:" + this.externalSymbolTable());
        TapEnv.println();
        TapEnv.indentPrint(indent + 6, "tuST:" + this.translationUnitSymbolTable);
        TapEnv.println();
        TapList<CallArrow> callArrows = this.callers();
        TapEnv.indentPrint(indent + 6, "CALL GRAPH PREDECESSORS: ");
        while (callArrows != null) {
            arrow = (CallArrow)callArrows.head;
            if (arrow.origin != null) {
                arrow.origin.cite();
            }
            if (arrow.isCall()) {
                TapEnv.print(" calls");
            }
            if (arrow.isImport()) {
                TapEnv.print(" imports");
            }
            if (arrow.isContain()) {
                TapEnv.print(" contains");
            }
            TapEnv.print(" it, ");
            callArrows = callArrows.tail;
        }
        TapEnv.println();
        callArrows = this.callees();
        TapEnv.indentPrint(indent + 6, "IMPORTS AND CONTAINS:");
        while (callArrows != null) {
            arrow = (CallArrow)callArrows.head;
            if (arrow.isImport() || arrow.isContain()) {
                TapEnv.print(arrow.isImport() ? " imports " : " contains ");
                if (arrow.destination != null) {
                    arrow.destination.cite();
                }
                TapEnv.print(",");
            }
            callArrows = callArrows.tail;
        }
        TapEnv.println();
        callArrows = this.callees();
        while (callArrows != null) {
            arrow = (CallArrow)callArrows.head;
            if (arrow.isCall()) {
                TapEnv.indentPrint(indent + 6, "CALLS: " + arrow.destination + " with CallArrow translator:");
                TapEnv.println();
                TapEnv.setRelatedArrow(arrow);
                Unit.dumpTranslator(arrow.translator(), indent + 12);
                TapEnv.setRelatedArrow(null);
                TapEnv.println();
            }
            callArrows = callArrows.tail;
        }
        TapEnv.indentPrint(indent + 6, "unit type:" + this.functionTypeSpec());
        TapEnv.println();
        TapEnv.indentPrint(indent + 6, "unit external shape: " + (this.externalShape == null ? "null external shape" : "see x" + this.rank()));
        TapEnv.println();
        if (this.argsZoneTrees != null) {
            int i;
            TapEnv.indentPrint(indent + 6, "unit argsZone trees:");
            TapEnv.println();
            for (i = 0; i < this.argsZoneTrees.length; ++i) {
                TapEnv.indentPrint(indent + 8, "arg#" + i + " zones tree:" + this.argsZoneTrees[i]);
                TapEnv.println();
            }
            TapEnv.indentPrint(indent + 6, "elem arg ranks ");
            for (i = 0; i < this.elemArgPublicRanks.length; ++i) {
                TapEnv.print(i + 58 + this.elemArgPublicRanks[i] + " ");
            }
            TapEnv.println();
        }
        TapEnv.indentPrint(indent + 6, "unit zone translator:");
        TapEnv.println();
        Unit.dumpTranslator(this.translator, indent + 8);
        if (!this.isModule()) {
            ZoneInfo[] zoneInfos = this.sideEffectZoneInfos[0];
            TapEnv.indentPrint(indent + 6, "side-effect Zones: " + (zoneInfos == null ? "none" : "see s" + this.rank()));
            TapEnv.println();
        }
        TapEnv.indentPrint(indent + 6, "Side Effect Memory Map of unit:");
        if (this.sideEffectMemoryMap.maps == null) {
            TapEnv.print(" null");
            TapEnv.println();
        } else if (this.sideEffectMemoryMap.maps.tail == null) {
            TapEnv.print(" EMPTY");
            TapEnv.println();
        } else {
            TapEnv.println();
            this.sideEffectMemoryMap.dump(indent + 10);
        }
        TapEnv.indentPrint(indent + 6, "Declared Memory Map of unit:");
        if (this.declaredMemoryMap.maps == null) {
            TapEnv.print(" null");
            TapEnv.println();
        } else if (this.declaredMemoryMap.maps.tail == null) {
            TapEnv.print(" EMPTY");
            TapEnv.println();
        } else {
            TapEnv.println();
            this.declaredMemoryMap.dump(indent + 10);
        }
        TapEnv.indentPrint(indent + 2, "FLOW GRAPH:");
        TapEnv.println();
        if (this.entryBlock == null) {
            TapEnv.indentPrint(indent + 4, "null FlowGraph!");
            TapEnv.println();
        } else {
            TapEnv.indentPrint(indent + 4, "Blocks nesting: ");
            Unit.dumpBlocksNesting(this.topBlocks());
            TapEnv.println();
            this.entryBlock.dump(indent + 4);
            TapEnv.println();
            TapList<Block> inAllBlocks = this.allBlocks;
            while (inAllBlocks != null) {
                ((Block)inAllBlocks.head).dump(indent + 6);
                TapEnv.println();
                inAllBlocks = inAllBlocks.tail;
            }
            this.exitBlock.dump(indent + 4);
            TapEnv.println();
            TapEnv.indentPrint(indent + 4, "Non-flow instructions:");
            TapList<Instruction> inNonFlowInstructions = this.nonFlowInstructions;
            while (inNonFlowInstructions != null) {
                ((Instruction)inNonFlowInstructions.head).dump();
                TapEnv.println();
                inNonFlowInstructions = inNonFlowInstructions.tail;
            }
            TapEnv.println();
            TapEnv.indentPrint(indent + 4, "Dead code:");
            TapEnv.println();
            TapList<Tree> inDeadTrees = this.deadTrees();
            while (inDeadTrees != null) {
                ILUtils.dump((Tree)inDeadTrees.head, indent + 6);
                TapEnv.println();
                inDeadTrees = inDeadTrees.tail;
            }
        }
        TapList<Tree> inFormats = this.formats;
        if (inFormats != null) {
            TapEnv.indentPrint(indent + 4, "Format declarations:");
            TapEnv.println();
            while (inFormats != null) {
                ILUtils.dump((Tree)inFormats.head, indent + 5);
                TapEnv.println();
                inFormats = inFormats.tail;
            }
        }
        if ((inLostComments = this.lostComments) != null) {
            TapEnv.indentPrint(indent + 4, "Lost comments:");
            TapEnv.println();
            while (inLostComments != null) {
                ILUtils.dump((Tree)inLostComments.head, indent + 5);
                TapEnv.println();
                inLostComments = inLostComments.tail;
            }
        }
        if ((comments = this.preComments) != null) {
            TapEnv.indentPrint(indent + 4, "Unit preComments:");
            TapEnv.println();
            ILUtils.dump(comments, indent + 5);
            TapEnv.println();
        }
        if ((comments = this.postComments) != null) {
            TapEnv.indentPrint(indent + 4, "Unit postComments:");
            TapEnv.println();
            ILUtils.dump(comments, indent + 5);
            TapEnv.println();
        }
        TapEnv.popRelatedUnit();
    }

    public void dumpExternalZones() throws IOException {
        TapEnv.indentPrint(2, "External zones of == public zones of == external shape of unit " + this + ':');
        TapEnv.println();
        if (this.externalShape != null && this.externalShape.length != 0) {
            for (int i = 0; i < this.externalShape.length; ++i) {
                ZoneInfo zoneInfo = this.externalShape[i];
                TapEnv.indentPrint(6, "x" + this.rank() + ":a" + i + " : ");
                zoneInfo.dump();
                TapEnv.println();
            }
        } else {
            TapEnv.indentPrint(6, "empty");
            TapEnv.println();
        }
    }

    public void dumpSideEffectZones() throws IOException {
        ZoneInfo[] zoneInfos = this.sideEffectZoneInfos[0];
        TapEnv.indentPrint(2, "Side-Effect zones of unit " + this + ':');
        TapEnv.println();
        if (zoneInfos != null && zoneInfos.length != 0) {
            ZoneInfo[] zoneInfoArray = zoneInfos;
            int n = zoneInfoArray.length;
            for (int i = 0; i < n; ++i) {
                ZoneInfo info;
                ZoneInfo zoneInfo = info = zoneInfoArray[i];
                TapEnv.indentPrint(6, "s" + this.rank() + ":a" + zoneInfo.zoneNb);
                if (zoneInfo.realZoneNb != -1) {
                    TapEnv.print("r" + zoneInfo.realZoneNb);
                }
                if (zoneInfo.intZoneNb != -1) {
                    TapEnv.print("i" + zoneInfo.intZoneNb);
                }
                if (zoneInfo.ptrZoneNb != -1) {
                    TapEnv.print("p" + zoneInfo.ptrZoneNb);
                }
                TapEnv.print(" : ");
                zoneInfo.dump();
                TapEnv.println();
            }
        } else {
            TapEnv.indentPrint(6, "empty");
            TapEnv.println();
        }
    }

    private void dumpSideEffectKindZones(int kind, int indent) throws IOException {
        Unit.dumpArrayOfZones(this.sideEffectZoneInfos[kind], 0, indent);
    }

    private void dumpControlZones(int indent) throws IOException {
        if (this.testZonesNb == 0) {
            TapEnv.print(" none.");
            TapEnv.println();
        } else {
            String[] controllers = new String[this.testZonesNb];
            for (int i = controllers.length - 1; i >= 0; --i) {
                controllers[i] = "";
            }
            TapList<Block> blocks = this.allBlocks();
            while (blocks != null) {
                Block block = (Block)blocks.head;
                if (block.testZone >= 0) {
                    controllers[block.testZone] = controllers[block.testZone] + " or " + block;
                }
                blocks = blocks.tail;
            }
            TapEnv.println();
            for (int i = 0; i < controllers.length; ++i) {
                TapEnv.indentPrint(indent, TapEnv.str3(i) + "> " + controllers[i]);
                TapEnv.println();
            }
        }
    }

    public String getNameFromBindC() {
        String result = null;
        if (this.modifiers != null) {
            Tree accessDecl = this.modifiers;
            if (accessDecl.opCode() == 1 && accessDecl.down(2).length() != 1) {
                result = accessDecl.down(2).down(2).down(2).stringValue();
            }
            if (accessDecl.opCode() == 1) {
                result = accessDecl.down(2).length() != 1 ? accessDecl.down(2).down(2).down(2).stringValue() : this.name;
            }
        }
        return result;
    }

    public void cite() throws IOException {
        String nameFromBindC;
        TapEnv.print(this.name);
        if (this.language == 3 && (nameFromBindC = this.getNameFromBindC()) != null) {
            TapEnv.print("(<=" + this.getNameFromBindC() + ')');
        }
        TapEnv.print("(" + TapEnv.languageName(this.language) + ')');
    }

    public String toString() {
        String kindString;
        switch (this.kind) {
            case 0: {
                kindString = "Unit";
                break;
            }
            case 1: {
                kindString = "IntrinsicUnit";
                break;
            }
            case 2: {
                kindString = "ExternalUnit";
                break;
            }
            case 3: {
                kindString = "VarFunctionUnit";
                break;
            }
            case -1: {
                kindString = "UndefModuleOrClassUnit";
                break;
            }
            case 4: {
                kindString = "ModuleUnit";
                break;
            }
            case 5: {
                kindString = "InterfaceUnit";
                break;
            }
            case 7: {
                kindString = "OutsideUnit_TBD";
                break;
            }
            case 9: {
                kindString = "ConstructorUnit";
                break;
            }
            case 10: {
                kindString = "DestructorUnit";
                break;
            }
            case 8: {
                kindString = "ClassUnit";
                break;
            }
            case 11: {
                kindString = "TranslationUnit";
                break;
            }
            default: {
                kindString = "?Unit" + this.kind + "?";
            }
        }
        String nameFromBindC = "";
        if (this.language == 3) {
            nameFromBindC = this.getNameFromBindC();
            nameFromBindC = nameFromBindC != null ? "(<=" + nameFromBindC + ')' : "";
        }
        return kindString + "<rk " + this.rank() + ':' + this.name + "(" + TapEnv.languageName(this.language) + ')' + nameFromBindC + ">";
    }
}

