/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.Unit;

public final class UnitStorage<T> {
    private Object[] storage;

    public UnitStorage(CallGraph callGraph) {
        this.storage = new Object[callGraph.nbUnits()];
        for (int i = callGraph.nbUnits() - 1; i >= 0; --i) {
            this.storage[i] = null;
        }
    }

    public void store(Unit unit, T value) {
        int rank = unit.rank();
        if (rank >= 0) {
            if (rank >= this.storage.length) {
                this.resizeStorage(rank);
            }
            this.storage[rank] = value;
        }
    }

    public T retrieve(Unit unit) {
        int rank = unit.rank();
        if (rank >= 0) {
            if (rank >= this.storage.length) {
                this.resizeStorage(rank);
            }
            return (T)this.storage[rank];
        }
        return null;
    }

    private void resizeStorage(int rank) {
        Object[] newStorage = new Object[rank + 20 + 1];
        System.arraycopy(this.storage, 0, newStorage, 0, this.storage.length);
        for (int i = this.storage.length; i < rank + 20; ++i) {
            newStorage[i] = null;
        }
        this.storage = newStorage;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = this.storage.length - 1; i >= 0; --i) {
            result.insert(0, (i == 0 ? "" : " ") + i + ':' + this.storage[i]);
        }
        return "[" + result + "]";
    }
}

