/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class VariableDecl
extends SymbolDecl {
    private WrapperTypeSpec type;
    public Integer constantValue;
    public int formalArgRank = -1;
    public int formalArgRankInOrigUnit = -9;
    public boolean isReturnVar;
    public FunctionDecl isReturnVarFromFunction;
    public boolean isFunctionName;
    public boolean isVariableName;
    public FunctionDecl[] initFunctionDecls;
    public TapList activityInfo;
    private TapList toZones = new TapList<Object>(null, null);
    private Tree initializationTree;

    @Override
    public WrapperTypeSpec type() {
        return this.type;
    }

    public void setType(WrapperTypeSpec typeSpec) {
        this.type = typeSpec;
    }

    public VariableDecl(Tree identTree, WrapperTypeSpec typeSpec) {
        super(identTree, 1);
        this.type = typeSpec;
    }

    public VariableDecl(Tree identTree, WrapperTypeSpec typeSpec, boolean isATrueSymbolDecl) {
        super(identTree, 1);
        this.type = typeSpec;
        this.isATrueSymbolDecl = isATrueSymbolDecl;
    }

    public VariableDecl() {
    }

    public void setReturnVar() {
        this.isReturnVar = true;
    }

    public void setReturnVar(FunctionDecl funcDecl) {
        this.isReturnVar = true;
        this.isReturnVarFromFunction = funcDecl;
    }

    public Tree initializationTree() {
        if (this.initializationTree == null || this.initializationTree.isAtom()) {
            return this.initializationTree;
        }
        return this.initializationTree.down(2);
    }

    public Tree getInitializationTree() {
        return this.initializationTree;
    }

    public void setInitializationTree(Tree tree) {
        this.initializationTree = tree;
    }

    public Tree generateInitializationTree() {
        if (WrapperTypeSpec.isPointerOrArrayOfPointer(this.type) || this.initializationTree.opCode() == 13 && this.initializationTree.down(2).opCode() == 30 && this.initializationTree.down(2).down(1).opCode() == 94 && this.initializationTree.down(2).down(1).stringValue().toLowerCase().equals("null")) {
            Tree resultTree = ILUtils.build(149, this.initializationTree.cutChild(1), this.initializationTree.cutChild(2));
            resultTree.copyAnnotations(this.initializationTree);
            this.initializationTree = resultTree;
        }
        if (this.initializationTree.isAtom()) {
            return ILUtils.build(13, ILUtils.build(94, this.symbol), ILUtils.copy(this.initializationTree));
        }
        if (this.initializationTree.opCode() == 13 || this.initializationTree.opCode() == 149) {
            Tree result = ILUtils.copy(this.initializationTree);
            result.setChild(ILUtils.build(94, this.symbol), 1);
            return result;
        }
        return ILUtils.copy(this.initializationTree);
    }

    @Override
    public boolean isTarget(WrapperTypeSpec modelTypeSpec) {
        if (this.type == null || this.type.wrappedType == null || !this.type.wrappedType.isTarget()) {
            return false;
        }
        if (modelTypeSpec == null || modelTypeSpec.wrappedType == null) {
            return true;
        }
        return modelTypeSpec.canMatchPointerTo(this.type);
    }

    @Override
    public TapList zones() {
        return this.toZones.tail;
    }

    public void setZones(TapList value) {
        this.toZones.tail = value;
    }

    public void adoptZones(VariableDecl model) {
        this.toZones = model.toZones;
    }

    public void accumulateZones(TapList intTree) {
        if (intTree != null) {
            this.toZones.tail = TapList.cumulWithOper(this.toZones.tail, intTree, 91);
        }
    }

    @Override
    protected void recomputeDependsOn(SymbolTable symbolTable) {
        TapList<Object> toDependsOn = new TapList<Object>(null, this.dependsOn);
        if (this.initializationTree != null) {
            VariableDecl.addUsedSymbolsInExpr(this.initializationTree(), toDependsOn, symbolTable, null, false, true);
        }
        if (this.type != null && this.type.wrappedType != null) {
            this.type.wrappedType.addUsedSymbolsInType(toDependsOn, symbolTable);
        }
        this.dependsOn = toDependsOn.tail;
    }

    @Override
    public void collectUsedTrees(TapList<Tree> toUsedTrees, TapList<TypeSpec> toDejaVu) {
        if (this.initializationTree != null) {
            toUsedTrees.tail = new TapList<Tree>(this.initializationTree(), toUsedTrees.tail);
        }
        if (this.type != null && this.type.wrappedType != null) {
            this.type.wrappedType.collectUsedTrees(toUsedTrees, toDejaVu);
        }
    }

    public void setConstant() {
        this.kind = 5;
    }

    public boolean equalsOther(VariableDecl varDecl) {
        boolean result = this.symbol.equals(varDecl.symbol);
        if (result) {
            result = this.kind == varDecl.kind && this.type.equalsCompilDep(varDecl.type);
        }
        return result;
    }

    @Override
    public void turnTypeIntoPointer() {
        this.type = new WrapperTypeSpec(new PointerTypeSpec(this.type, null));
    }

    public Tree buildVarDeclaration(SymbolTable symbolTable) {
        this.type = this.type.checkNoneDimensionsOfNewSH(this.symbol, this.symbol, ILUtils.build(94, this.symbol), symbolTable, null);
        return ILUtils.build(194, ILUtils.build(128), this.type.wrappedType.generateTree(null, null, null, true, null), ILUtils.build(53, ILUtils.build(94, this.symbol)));
    }

    public boolean cumulActiveField(Tree tree) {
        boolean modified;
        if (this.activityInfo == null) {
            this.activityInfo = new TapList<Object>(null, null);
        }
        TapList<?> toLeaf = TapList.getSetFieldLocation(this.activityInfo, tree, true);
        if (toLeaf.head instanceof Boolean && ((Boolean)toLeaf.head).booleanValue()) {
            modified = false;
        } else {
            if (toLeaf.head instanceof TapList) {
                ((TapList)toLeaf.head).setAll(true);
            } else {
                toLeaf.head = Boolean.TRUE;
            }
            modified = true;
        }
        return modified;
    }

    public boolean passesByValue(Unit calledUnit) {
        boolean result = false;
        if (calledUnit != null) {
            result = calledUnit.isFortran() ? this.hasModifier("value") : (calledUnit.isCPlusPlus() ? true : true);
        }
        return result;
    }

    @Override
    public void dump(int indent) throws IOException {
        TapEnv.print(this.symbol + ": ");
        if (this.renamedFromSymbolDecl != null) {
            TapEnv.print("(=>" + this.renamedFromSymbolDecl.symbol + ") ");
        }
        if (this.type == null) {
            TapEnv.print("null type");
        } else {
            this.type.dump();
        }
        if (this.getInitializationTree() != null) {
            TapEnv.print("[init " + this.getInitializationTree() + ']');
        }
        if (this.extraInfo() != null) {
            TapEnv.print(" " + this.extraInfo());
        }
        if (this.isActiveSymbolDecl()) {
            TapEnv.print(" Diff-Active");
        }
        if (this.kind() == 5) {
            TapEnv.print(" constant. value: " + this.constantValue);
        } else if (this.kind() == 6) {
            TapEnv.print(" function's return variable.");
        } else {
            TapEnv.print(" variable.");
        }
        TapEnv.print(" zones: " + this.zones());
        TapEnv.print(" depends on: " + this.dependsOn());
        TapEnv.print(" isActive(): " + this.isActiveSymbolDecl());
    }

    @Override
    public String toString() {
        return this.symbol + ':' + this.type + (this.extraInfo() == null ? "" : " X" + this.extraInfo()) + (this.accessInfo == null ? "" : " A" + this.accessInfo) + (this.initializationTree == null ? "" : ":=" + ILUtils.toString(this.getInitializationTree())) + " isActive()->" + this.isActiveSymbolDecl();
    }
}

