/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.CompositeTypeSpec;
import fr.inria.tapenade.representation.FieldDecl;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.ModifiedTypeSpec;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.PrimitiveTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.Tree;

final class ZoneAllocator {
    public int nextZone;
    public TapList<ZoneInfo> zoneInfos;
    public int nextIntZone;
    public TapList<ZoneInfo> intZoneInfos;
    public int nextRealZone;
    public TapList<ZoneInfo> realZoneInfos;
    public int nextPtrZone;
    public TapList<ZoneInfo> ptrZoneInfos;
    public String commonName;
    public int startOffset;
    public int endOffset;
    public boolean infiniteEndOffset;
    public boolean allocateGlobals;

    public ZoneAllocator(SymbolTable symbolTable) {
        if (symbolTable != null) {
            this.nextZone = symbolTable.freeDeclaredZone(0);
            this.nextIntZone = symbolTable.freeDeclaredZone(2);
            this.nextRealZone = symbolTable.freeDeclaredZone(1);
            this.nextPtrZone = symbolTable.freeDeclaredZone(3);
        } else {
            this.nextZone = 0;
            this.nextIntZone = 0;
            this.nextRealZone = 0;
            this.nextPtrZone = 0;
        }
        this.zoneInfos = null;
        this.intZoneInfos = null;
        this.realZoneInfos = null;
        this.ptrZoneInfos = null;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public void setStartOffset(int startOffset) {
        this.startOffset = startOffset;
    }

    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    public void setInfiniteEndOffset(boolean infiniteEndOffset) {
        this.infiniteEndOffset = infiniteEndOffset;
    }

    public void setAllocateGlobals(boolean allocateGlobals) {
        this.allocateGlobals = allocateGlobals;
    }

    public TapList allocateZones(Tree accessTree, TapList<TapPair<Tree, Tree>> accessIndexes, WrapperTypeSpec rootAccessType, WrapperTypeSpec accessType, int accessTypeModifier, TapList<String> declExtraInfo, int accessArgRank, boolean isInt, boolean isReal, boolean isPtr, ZoneInfo targetZoneOf, TapList<TapPair<CompositeTypeSpec, TapList>> dejaVu, SymbolTable symbolTable, Unit declUnit) {
        TapList zones;
        if (accessType == null || accessType.wrappedType == null) {
            zones = this.allocateOneZone(new WrapperTypeSpec(null), accessTypeModifier, accessTree, rootAccessType, accessIndexes, accessArgRank, isInt, isReal, isPtr, false, null, targetZoneOf, declUnit);
        } else if ((declUnit != null && declUnit.isCorMore() || declUnit == null && symbolTable != null && (symbolTable.language() == 4 || symbolTable.language() == 5)) && (accessType.isAnIOTypeSpec(symbolTable) || accessTree != null && ILUtils.isACIOSymbol(accessTree))) {
            zones = new TapList(new TapIntList(TapEnv.get().origCallGraph().zoneNbOfAllIOStreams, null), null);
        } else {
            switch (accessType.wrappedType.kind()) {
                case 2: {
                    ArrayTypeSpec arrayTypeSpec = (ArrayTypeSpec)accessType.wrappedType;
                    ArrayDim[] typeDimensions = arrayTypeSpec.dimensions();
                    TapList newAccessIndexes = null;
                    if (accessTree != null && accessTree.opCode() == 8 && accessTree.down(2).children().length >= typeDimensions.length) {
                        Tree[] indexTrees = accessTree.down(2).children();
                        for (int i = indexTrees.length - 1; i >= 0; --i) {
                            TapList<Tree> arrayTriplets = ILUtils.arrayTripletsInside(indexTrees[i]);
                            if (arrayTriplets == null) continue;
                            newAccessIndexes = new TapList(new TapPair(arrayTriplets.head, null), newAccessIndexes);
                        }
                    } else {
                        TapList<Tree> arrayIndexes = null;
                        for (int i = typeDimensions.length - 1; i >= 0; --i) {
                            Tree indexTree = typeDimensions[i].tree();
                            indexTree = ILUtils.build(11, ILUtils.copy(indexTree.down(1)), ILUtils.copy(indexTree.down(2)), ILUtils.build(136));
                            arrayIndexes = new TapList<Tree>(indexTree, arrayIndexes);
                            newAccessIndexes = new TapList(new TapPair<Tree, Object>(indexTree, null), newAccessIndexes);
                        }
                        boolean inAllocate = accessTree != null && accessTree.opCode() == 4;
                        Tree allocTree = null;
                        if (inAllocate) {
                            allocTree = accessTree;
                            accessTree = accessTree.cutChild(1);
                        } else {
                            accessTree = ILUtils.copy(accessTree);
                        }
                        accessTree = ILUtils.build(8, accessTree, ILUtils.build(70, arrayIndexes));
                        if (inAllocate) {
                            allocTree.setChild(accessTree, 1);
                            accessTree = allocTree;
                        }
                    }
                    zones = this.allocateZones(accessTree, TapList.append(accessIndexes, newAccessIndexes), rootAccessType, arrayTypeSpec.elementType(), accessTypeModifier, declExtraInfo, accessArgRank, isInt, isReal, isPtr, targetZoneOf, dejaVu, symbolTable, declUnit);
                    break;
                }
                case 21: {
                    TapList<ZoneInfo> zoneInfosBefore = this.zoneInfos;
                    CompositeTypeSpec recordTypeSpec = (CompositeTypeSpec)accessType.wrappedType;
                    zones = (TapList)TapList.cassq(recordTypeSpec, dejaVu);
                    if (zones != null) {
                        zones.head = Boolean.TRUE;
                    } else {
                        for (int listLength = recordTypeSpec.fields.length + 1; listLength > 0; --listLength) {
                            zones = new TapList<Object>(null, zones);
                        }
                        dejaVu = new TapList<TapPair<CompositeTypeSpec, TapList>>(new TapPair(recordTypeSpec, zones), dejaVu);
                        assert (zones != null);
                        TapList inZones = zones.tail;
                        for (int i = 0; i < recordTypeSpec.fields.length; ++i) {
                            FieldDecl field = recordTypeSpec.fields[i];
                            if (field != null) {
                                TapList fieldAccessIndexes;
                                Tree fieldAccessTree;
                                if (accessTree != null) {
                                    TapPair<Tree, TapList<TapPair<Tree, Tree>>> copyTreeIndexes = ILUtils.copyWatchingSubtrees(accessTree, accessIndexes);
                                    fieldAccessTree = (Tree)copyTreeIndexes.first;
                                    fieldAccessIndexes = (TapList)copyTreeIndexes.second;
                                } else {
                                    fieldAccessTree = null;
                                    fieldAccessIndexes = accessIndexes;
                                }
                                fieldAccessTree = ILUtils.build(73, fieldAccessTree, ILUtils.build(94, field.symbol));
                                ILUtils.setFieldRank(fieldAccessTree.down(2), i);
                                inZones.head = this.allocateZones(fieldAccessTree, fieldAccessIndexes, rootAccessType, field.type(), accessTypeModifier, field.extraInfo(), accessArgRank, isInt, isReal, isPtr, targetZoneOf, dejaVu, symbolTable, declUnit);
                            }
                            inZones = inZones.tail;
                        }
                        if (zones.head != null) {
                            TapList<ZoneInfo> zoneInfosNow = this.zoneInfos;
                            while (zoneInfosNow != zoneInfosBefore) {
                                ((ZoneInfo)zoneInfosNow.head).setMultiple();
                                zoneInfosNow = zoneInfosNow.tail;
                            }
                        }
                    }
                    zones = zones.tail;
                    break;
                }
                case 5: {
                    ModifiedTypeSpec modifiedTypeSpec = (ModifiedTypeSpec)accessType.wrappedType;
                    if (symbolTable != null) {
                        modifiedTypeSpec.resolveSizeModifier(symbolTable);
                    }
                    int sizeModifier = modifiedTypeSpec.sizeModifierValue();
                    zones = this.allocateZones(ILUtils.copy(accessTree), accessIndexes, rootAccessType, modifiedTypeSpec.elementType(), sizeModifier == -1 ? accessTypeModifier : sizeModifier, declExtraInfo, accessArgRank, isInt, isReal, isPtr, targetZoneOf, dejaVu, symbolTable, declUnit);
                    break;
                }
                case 6: {
                    zones = this.allocateOneZone(accessType, accessTypeModifier, accessTree, rootAccessType, accessIndexes, accessArgRank, isInt, isReal, true, TapList.containsEquals(declExtraInfo, "allocatable"), null, targetZoneOf, declUnit);
                    ZoneInfo pointerZone = (ZoneInfo)this.zoneInfos.head;
                    PointerTypeSpec pointerType = (PointerTypeSpec)accessType.wrappedType;
                    Tree insideAccessTree = ILUtils.build(148, ILUtils.copy(accessTree), pointerType.offsetLength == null ? ILUtils.build(136) : ILUtils.copy(pointerType.offsetLength.tree()));
                    if (pointerType.offsetLength != null) {
                        accessIndexes = TapList.append(accessIndexes, new TapList<TapPair<Tree, Object>>(new TapPair<Tree, Object>(pointerType.offsetLength.tree(), null), null));
                    }
                    pointerZone.targetZonesTree = this.allocateZones(insideAccessTree, accessIndexes, rootAccessType, pointerType.destinationType, -1, null, accessArgRank, false, false, false, pointerZone, dejaVu, symbolTable, declUnit);
                    break;
                }
                case 9: {
                    zones = this.allocateOneZone(accessType, accessTypeModifier, accessTree, rootAccessType, accessIndexes, accessArgRank, isInt, true, isPtr, TapList.containsEquals(declExtraInfo, "allocatable"), null, targetZoneOf, declUnit);
                    break;
                }
                case 7: 
                case 10: {
                    zones = this.allocateOneZone(accessType, accessTypeModifier, accessTree, rootAccessType, accessIndexes, accessArgRank, isInt, isReal, isPtr, TapList.containsEquals(declExtraInfo, "allocatable"), null, targetZoneOf, declUnit);
                    break;
                }
                case 3: {
                    zones = this.allocateOneZone(accessType, accessTypeModifier, accessTree, rootAccessType, accessIndexes, accessArgRank, false, false, false, false, null, targetZoneOf, declUnit);
                    break;
                }
                default: {
                    zones = null;
                }
            }
        }
        return zones;
    }

    public TapList allocateOneZone(WrapperTypeSpec type, int accessTypeModifier, Tree accessTree, WrapperTypeSpec rootAccessType, TapList<TapPair<Tree, Tree>> accessIndexes, int accessArgRank, boolean isInt, boolean isReal, boolean isPtr, boolean isAllocatable, ZoneInfo copyFrom, ZoneInfo targetZoneOf, Unit declUnit) {
        if (TypeSpec.isA(type, 10)) {
            isReal = true;
            isInt = true;
        }
        if (TypeSpec.isA(type, 7)) {
            String typeName = ((PrimitiveTypeSpec)type.wrappedType).name;
            if (typeName.equals("integer")) {
                isInt = true;
            }
            if (typeName.equals("float") || typeName.equals("complex")) {
                isReal = true;
            }
        }
        if (TypeSpec.isA(type, 6)) {
            isPtr = true;
        }
        ZoneInfo zoneInfo = targetZoneOf != null ? new ZoneInfo(-1, -1, false) : new ZoneInfo(this.startOffset, this.endOffset, this.infiniteEndOffset);
        zoneInfo.declarationUnit = declUnit;
        zoneInfo.from = copyFrom;
        if (this.commonName == null) {
            zoneInfo.commonName = null;
        } else {
            zoneInfo.setKind(11);
            zoneInfo.commonName = this.commonName;
        }
        if (this.allocateGlobals) {
            zoneInfo.setKind(13);
            zoneInfo.index = this.nextZone;
        }
        zoneInfo.type = type;
        zoneInfo.typeSizeModifier = accessTypeModifier;
        zoneInfo.isAllocatable = isAllocatable;
        zoneInfo.accessTree = accessTree;
        zoneInfo.rootAccessType = rootAccessType;
        zoneInfo.accessIndexes = accessIndexes;
        if (accessArgRank == 0) {
            zoneInfo.setKind(10);
        } else if (accessArgRank > 0) {
            zoneInfo.setKind(7);
            zoneInfo.index = accessArgRank;
        }
        if (isInt) {
            zoneInfo.intZoneNb = this.nextIntZone++;
            this.intZoneInfos = new TapList<ZoneInfo>(zoneInfo, this.intZoneInfos);
        } else {
            zoneInfo.intZoneNb = -1;
        }
        if (isReal) {
            zoneInfo.realZoneNb = this.nextRealZone++;
            this.realZoneInfos = new TapList<ZoneInfo>(zoneInfo, this.realZoneInfos);
        } else {
            zoneInfo.realZoneNb = -1;
        }
        if (isPtr) {
            zoneInfo.ptrZoneNb = this.nextPtrZone++;
            this.ptrZoneInfos = new TapList<ZoneInfo>(zoneInfo, this.ptrZoneInfos);
        } else {
            zoneInfo.ptrZoneNb = -1;
        }
        zoneInfo.targetZoneOf = targetZoneOf;
        zoneInfo.zoneNb = this.nextZone++;
        this.zoneInfos = new TapList<ZoneInfo>(zoneInfo, this.zoneInfos);
        return new TapList<TapIntList>(new TapIntList(zoneInfo.zoneNb, null), null);
    }

    public ZoneInfo lastAllocated() {
        if (this.zoneInfos == null) {
            return null;
        }
        return (ZoneInfo)this.zoneInfos.head;
    }

    public void addVarName(TapList zonesTree, String varName) {
        TapIntList zones = ZoneInfo.listAllZones(zonesTree, true);
        while (zones != null) {
            ZoneInfo zoneInfo = (ZoneInfo)TapList.nth(this.zoneInfos, this.nextZone - zones.head - 1);
            if (zoneInfo != null && !TapList.containsEquals(zoneInfo.variableNames(), varName)) {
                zoneInfo.addVariableName(varName);
                if (zoneInfo.targetZonesTree != null) {
                    this.addVarName(zoneInfo.targetZonesTree, varName);
                }
            }
            zones = zones.tail;
        }
    }

    public void addVarDecl(TapList zonesTree, SymbolDecl symbolDecl) {
        TapIntList zones = ZoneInfo.listAllZones(zonesTree, true);
        while (zones != null) {
            ZoneInfo zoneInfo = (ZoneInfo)TapList.nth(this.zoneInfos, this.nextZone - zones.head - 1);
            if (zoneInfo != null) {
                zoneInfo.ownerSymbolDecl = symbolDecl;
            }
            zones = zones.tail;
        }
    }

    public void setMultiple(TapList zonesTree) {
        TapIntList zones = ZoneInfo.listAllZones(zonesTree, true);
        while (zones != null) {
            ZoneInfo zoneInfo = (ZoneInfo)TapList.nth(this.zoneInfos, this.nextZone - zones.head - 1);
            zoneInfo.setMultiple();
            zones = zones.tail;
        }
    }

    public void addArgRank(TapList zonesTree, int argRank) {
        TapIntList zones = ZoneInfo.listAllZones(zonesTree, true);
        while (zones != null) {
            ZoneInfo zoneInfo = (ZoneInfo)TapList.nth(this.zoneInfos, this.nextZone - zones.head - 1);
            if (zoneInfo != null) {
                if (argRank == 0) {
                    zoneInfo.setKind(10);
                } else if (argRank > 0) {
                    zoneInfo.setKind(7);
                    zoneInfo.index = argRank;
                }
            }
            zones = zones.tail;
        }
    }

    public void extractAllZoneInfosInto(SymbolTable symbolTable) {
        symbolTable.setDeclaredZoneInfos(this.extractZoneInfos(), 0);
        symbolTable.setFreeDeclaredZone(this.nextZone, 0);
        symbolTable.setDeclaredZoneInfos(this.extractIntZoneInfos(), 2);
        symbolTable.setFreeDeclaredZone(this.nextIntZone, 2);
        symbolTable.setDeclaredZoneInfos(this.extractRealZoneInfos(), 1);
        symbolTable.setFreeDeclaredZone(this.nextRealZone, 1);
        symbolTable.setDeclaredZoneInfos(this.extractPtrZoneInfos(), 3);
        symbolTable.setFreeDeclaredZone(this.nextPtrZone, 3);
    }

    public ZoneInfo[] extractZoneInfos() {
        int nbz = TapList.length(this.zoneInfos);
        ZoneInfo[] result = new ZoneInfo[nbz];
        for (int i = nbz - 1; i >= 0; --i) {
            result[i] = (ZoneInfo)this.zoneInfos.head;
            this.zoneInfos = this.zoneInfos.tail;
        }
        return result;
    }

    public ZoneInfo[] extractIntZoneInfos() {
        int nbz = TapList.length(this.intZoneInfos);
        ZoneInfo[] result = new ZoneInfo[nbz];
        for (int i = nbz - 1; i >= 0; --i) {
            result[i] = (ZoneInfo)this.intZoneInfos.head;
            this.intZoneInfos = this.intZoneInfos.tail;
        }
        return result;
    }

    public ZoneInfo[] extractRealZoneInfos() {
        int nbz = TapList.length(this.realZoneInfos);
        ZoneInfo[] result = new ZoneInfo[nbz];
        for (int i = nbz - 1; i >= 0; --i) {
            result[i] = (ZoneInfo)this.realZoneInfos.head;
            this.realZoneInfos = this.realZoneInfos.tail;
        }
        return result;
    }

    public ZoneInfo[] extractPtrZoneInfos() {
        int nbz = TapList.length(this.ptrZoneInfos);
        ZoneInfo[] result = new ZoneInfo[nbz];
        for (int i = nbz - 1; i >= 0; --i) {
            result[i] = (ZoneInfo)this.ptrZoneInfos.head;
            this.ptrZoneInfos = this.ptrZoneInfos.tail;
        }
        return result;
    }
}

