/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.representation;

import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class ZoneInfo {
    public static final String MESSAGE_PASSING_CHANNEL = "%message_passing_channel_";
    private int kind = 12;
    public int index;
    public int zoneNb = -1;
    public int realZoneNb = -1;
    public int intZoneNb = -1;
    public int ptrZoneNb = -1;
    public TapList targetZonesTree;
    public ZoneInfo targetZoneOf;
    public ZoneInfo from;
    public WrapperTypeSpec type;
    public int typeSizeModifier = -1;
    public boolean isAllocatable;
    public Tree accessTree;
    public WrapperTypeSpec rootAccessType;
    public TapList<TapPair<Tree, Tree>> accessIndexes;
    public int startOffset;
    public int endOffset;
    public boolean infiniteEndOffset;
    public String commonName;
    public boolean multiple;
    public SymbolDecl ownerSymbolDecl;
    public Unit declarationUnit;
    public boolean relocated;
    public boolean relocatedDiff;
    public boolean rebased;
    public boolean rebasedDiff;
    private TapList<String> variableNames;
    private boolean isOnceActive;

    public ZoneInfo(int startOffset, int endOffset, boolean infiniteEndOffset) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.infiniteEndOffset = infiniteEndOffset;
    }

    public static boolean eqOrCopyOfEq(ZoneInfo z1, ZoneInfo z2) {
        if (z1 == null || z2 == null) {
            return false;
        }
        if (z1.from != null) {
            z1 = z1.from;
        }
        if (z2.from != null) {
            z2 = z2.from;
        }
        return z1 == z2;
    }

    protected static String makeMessagePassingChannelName(int channelNum) {
        return MESSAGE_PASSING_CHANNEL + channelNum + "%";
    }

    public static boolean isMessagePassingChannelName(String name) {
        return name != null && name.startsWith(MESSAGE_PASSING_CHANNEL);
    }

    public static TapIntList listAllZones(TapList<?> zonesTree, boolean throughPointers) {
        TapIntList toCollector = new TapIntList(-1, null);
        ZoneInfo.listAllZonesRec(zonesTree, throughPointers, toCollector, new TapList<Object>(null, null));
        return toCollector.tail;
    }

    private static void listAllZonesRec(TapList<?> zonesTree, boolean throughPointers, TapIntList toCollector, TapList<TapList> dejaVu) {
        while (zonesTree != null && !TapList.contains(dejaVu.tail, zonesTree)) {
            dejaVu.placdl(zonesTree);
            if (zonesTree.head instanceof TapList) {
                ZoneInfo.listAllZonesRec((TapList)zonesTree.head, throughPointers, toCollector, dejaVu);
            } else {
                TapIntList newZones = (TapIntList)zonesTree.head;
                while (newZones != null) {
                    toCollector.appendIfAbsent(newZones.head);
                    newZones = newZones.tail;
                }
                if (!throughPointers) {
                    zonesTree = null;
                }
            }
            if (zonesTree == null) continue;
            zonesTree = zonesTree.tail;
        }
    }

    public ZoneInfo copy() {
        ZoneInfo copyZI = new ZoneInfo(this.startOffset, this.endOffset, this.infiniteEndOffset);
        copyZI.kind = this.kind;
        copyZI.index = this.index;
        copyZI.zoneNb = this.zoneNb;
        copyZI.realZoneNb = this.realZoneNb;
        copyZI.intZoneNb = this.intZoneNb;
        copyZI.ptrZoneNb = this.ptrZoneNb;
        copyZI.targetZonesTree = this.targetZonesTree;
        copyZI.from = this.from != null ? this.from : this;
        copyZI.type = this.type;
        copyZI.typeSizeModifier = this.typeSizeModifier;
        copyZI.accessTree = this.accessTree;
        copyZI.rootAccessType = this.rootAccessType;
        copyZI.accessIndexes = this.accessIndexes;
        copyZI.commonName = this.commonName;
        copyZI.variableNames = this.variableNames;
        copyZI.ownerSymbolDecl = this.ownerSymbolDecl;
        copyZI.declarationUnit = this.declarationUnit;
        return copyZI;
    }

    public boolean isCommon() {
        return this.kind == 11;
    }

    public boolean isParameter() {
        return this.kind == 7;
    }

    public boolean isResult() {
        return this.kind == 10;
    }

    public boolean isGlobal() {
        return this.kind == 13;
    }

    public boolean isRemanentLocal() {
        return this.commonName != null && this.commonName.startsWith("/tapenade_save_");
    }

    public int kind() {
        return this.kind;
    }

    public void setKind(int kind) {
        this.kind = kind;
    }

    public int zoneNb(int whichKind) {
        switch (whichKind) {
            case 1: {
                return this.realZoneNb;
            }
            case 2: {
                return this.intZoneNb;
            }
            case 3: {
                return this.ptrZoneNb;
            }
        }
        return this.zoneNb;
    }

    public void setOnceActive() {
        this.isOnceActive = true;
        if (this.targetZoneOf != null) {
            this.targetZoneOf.isOnceActive = true;
        }
    }

    public boolean isConstant() {
        return this.ownerSymbolDecl != null && this.ownerSymbolDecl.isCconst();
    }

    public boolean isOnceActive() {
        return this.isOnceActive;
    }

    public boolean isMessagePassingChannel() {
        if (this.accessTree == null) {
            return false;
        }
        String name = ILUtils.getIdentString(this.accessTree);
        return ZoneInfo.isMessagePassingChannelName(name);
    }

    public void addVariableName(String varName) {
        this.variableNames = new TapList<String>(varName, this.variableNames);
    }

    public void setVariableNames(TapList<String> varNames) {
        this.variableNames = varNames;
    }

    public TapList<String> variableNames() {
        return this.variableNames;
    }

    public String bestVarName() {
        return ILUtils.baseName(this.accessTree);
    }

    public String sideEffectZoneName() {
        if (this.commonName == null) {
            return "(global)" + ILUtils.toString(this.accessTree);
        }
        if (this.commonName.startsWith("/tapenade_save_")) {
            return "(" + ILUtils.toString(this.accessTree) + " SAVEd by " + this.commonName.substring(15, this.commonName.length() - 1) + ')';
        }
        if (this.infiniteEndOffset) {
            return this.commonName + "[" + this.startOffset + ",inf[";
        }
        return this.commonName + "[" + this.startOffset + "," + this.endOffset + "[";
    }

    public boolean containsOffset(int testedOffset) {
        return this.startOffset <= testedOffset && (this.infiniteEndOffset || testedOffset < this.endOffset);
    }

    public String publicName() {
        String accessTreeString = ILUtils.isNullOrNone(this.accessTree) || this.accessTree.opCode() == 8 && ILUtils.isNullOrNone(this.accessTree.down(1)) && (ILUtils.isNullOrNone(this.accessTree.down(2)) || this.allTreesNull(this.accessTree.down(2).children())) ? "" : ":" + ILUtils.toString(this.accessTree);
        switch (this.kind) {
            case 7: {
                return "Arg" + this.index + accessTreeString;
            }
            case 11: {
                return this.sideEffectZoneName() + accessTreeString;
            }
            case 10: {
                return "Result" + accessTreeString;
            }
            case 13: {
                return ILUtils.toString(this.accessTree);
            }
            case 12: {
                return "(hidden global)" + ILUtils.toString(this.accessTree);
            }
        }
        return "??";
    }

    private boolean allTreesNull(Tree[] trees) {
        boolean result = true;
        for (int i = trees.length - 1; result && i >= 0; --i) {
            Tree tree = trees[i];
            result = ILUtils.isNullOrNone(tree) || tree.opCode() == 58 && ILUtils.isNullOrNone(tree.down(1)) && ILUtils.isNullOrNone(tree.down(2)) || tree.opCode() == 11 && ILUtils.isNullOrNone(tree.down(1)) && ILUtils.isNullOrNone(tree.down(2)) && ILUtils.isNullOrNone(tree.down(3));
        }
        return result;
    }

    public String accessTreePrint(int language) {
        return ILUtils.toString(this.accessTree, language, false);
    }

    public void setMultiple() {
        this.multiple = true;
    }

    public boolean comesFromAllocate() {
        return this.accessTree != null && this.comesFromAllocateRec(this.accessTree);
    }

    private boolean comesFromAllocateRec(Tree inAccessTree) {
        switch (inAccessTree.opCode()) {
            case 4: {
                return true;
            }
            case 8: 
            case 73: 
            case 148: {
                return this.comesFromAllocateRec(inAccessTree.down(1));
            }
        }
        return false;
    }

    public boolean isHiddenFrom(SymbolTable symbolTable) {
        ZoneInfo zi = this;
        while (zi.targetZoneOf != null) {
            zi = zi.targetZoneOf;
        }
        boolean hidden = true;
        TapList<String> varNames = zi.variableNames;
        if (varNames == null) {
            varNames = new TapList<String>(ILUtils.baseName(zi.accessTree), null);
        }
        while (hidden && varNames != null) {
            VariableDecl varDecl;
            String varName = (String)varNames.head;
            if (varName != null && (varDecl = symbolTable.getVariableDecl(varName)) != null && TapIntList.contains(ZoneInfo.listAllZones(varDecl.zones(), true), zi.zoneNb)) {
                hidden = false;
            }
            varNames = varNames.tail;
        }
        return hidden;
    }

    public WrapperTypeSpec pointerDestType() {
        if (this.ptrZoneNb == -1) {
            return null;
        }
        return ((PointerTypeSpec)this.type.wrappedType).destinationType;
    }

    public boolean passesByValue(Unit inUnit, int callerLanguage) {
        boolean result = true;
        if (this.isParameter()) {
            int language = inUnit.language();
            switch (language) {
                case 1: 
                case 2: 
                case 3: {
                    if (this.ownerSymbolDecl instanceof VariableDecl) {
                        result = this.ownerSymbolDecl.hasModifier("value");
                        break;
                    }
                    result = false;
                    break;
                }
                case 4: 
                case 5: {
                    result = callerLanguage == 4 || callerLanguage == 5;
                    break;
                }
                default: {
                    TapEnv.printlnOnTrace("Undefined language " + language);
                }
            }
        }
        return result;
    }

    public int knownSize(SymbolTable symbolTable) {
        int size = this.type == null ? -1 : this.type.size();
        Tree accTree = this.accessTree;
        block6: while (size > 0 && accTree != null) {
            switch (accTree.opCode()) {
                case 8: {
                    Tree[] dims = accTree.down(2).children();
                    for (int i = dims.length - 1; size > 0 && i >= 0; --i) {
                        int dimSize = this.knownSize(dims[i], symbolTable);
                        size = dimSize <= 0 ? -1 : size * dimSize;
                    }
                    accTree = accTree.down(1);
                    continue block6;
                }
                case 148: {
                    if (!ILUtils.isNullOrNone(accTree.down(2))) {
                        int dimSize = this.knownSize(accTree.down(2), symbolTable);
                        size = dimSize <= 0 ? -1 : size * dimSize;
                    }
                    accTree = accTree.down(1);
                    continue block6;
                }
                case 73: {
                    accTree = accTree.down(1);
                    continue block6;
                }
                case 94: {
                    accTree = null;
                    continue block6;
                }
            }
            accTree = null;
            size = -1;
        }
        return size;
    }

    private int knownSize(Tree arrayIndex, SymbolTable symbolTable) {
        if (arrayIndex.opCode() == 11) {
            Integer computed;
            int firstIndex = 1;
            if (!ILUtils.isNullOrNone(arrayIndex.down(1)) && (computed = symbolTable.computeIntConstant(arrayIndex.down(1))) != null) {
                firstIndex = computed;
            }
            int lastIndex = -1;
            if (!ILUtils.isNullOrNone(arrayIndex.down(2)) && (computed = symbolTable.computeIntConstant(arrayIndex.down(2))) != null) {
                lastIndex = computed;
            }
            int stride = 1;
            if (!ILUtils.isNullOrNone(arrayIndex.down(3)) && (computed = symbolTable.computeIntConstant(arrayIndex.down(3))) != null) {
                stride = computed;
            }
            if (stride == 1 && firstIndex != -1 && lastIndex != -1) {
                return lastIndex - firstIndex + 1;
            }
            return -1;
        }
        return 1;
    }

    public void dump() throws IOException {
        switch (this.kind) {
            case 11: {
                TapEnv.print("common " + this.commonName + " [" + this.startOffset + "," + this.endOffset + "[ ");
                break;
            }
            case 7: {
                TapEnv.print("parameter #" + this.index + " ");
                break;
            }
            case 12: {
                TapEnv.print("local var ");
                break;
            }
            case 10: {
                TapEnv.print("function result ");
                break;
            }
            case 13: {
                TapEnv.print("global ");
                break;
            }
            default: {
                TapEnv.print("unknown kind ");
            }
        }
        TapEnv.print((this.variableNames() == null ? "()" : this.variableNames().toString()) + " " + ILUtils.toString(this.accessTree) + ':');
        if (this.multiple) {
            TapEnv.print("multi-");
        }
        if (this.type == null) {
            TapEnv.print("unknown type");
        } else {
            this.type.dump();
        }
        TapEnv.print(" (zoneNb:" + this.zoneNb);
        if (this.zoneNb(2) != -1) {
            TapEnv.print("/i" + this.zoneNb(2));
        }
        if (this.zoneNb(3) != -1) {
            TapEnv.print("/p" + this.zoneNb(3));
        }
        if (this.zoneNb(1) != -1) {
            TapEnv.print("/r" + this.zoneNb(1));
        }
        TapEnv.print(")");
        if (this.targetZoneOf != null) {
            TapEnv.print(" " + this.targetZoneOf.zoneNb + "-i>");
        }
        if (this.targetZonesTree != null) {
            TapEnv.print(" -i>" + this.targetZonesTree);
        }
        if (this.isParameter()) {
            TapEnv.print(" passesByValue: " + this.passesByValue(TapEnv.relatedUnit(), TapEnv.relatedUnit().language()));
        }
    }

    public String toString() {
        String result;
        switch (this.kind) {
            case 11: {
                result = "common " + this.commonName + " [" + this.startOffset + "," + this.endOffset + "[ ";
                break;
            }
            case 7: {
                result = "parameter #" + this.index + " ";
                break;
            }
            case 12: {
                result = "local var ";
                break;
            }
            case 10: {
                result = "function result ";
                break;
            }
            case 13: {
                result = "global ";
                break;
            }
            default: {
                result = "unknown kind ";
            }
        }
        return "ZoneInfo " + this.zoneNb + " " + result + (this.variableNames == null ? "()" : this.variableNames.toString()) + " " + ILUtils.toString(this.accessTree) + ':' + this.type;
    }
}

