/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.toplevel;

import fr.inria.tapenade.toplevel.ADServlet;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RetryNewServlet
extends ADServlet {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 354099994054L;

    @Override
    public final void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.doGet(req, res);
    }

    @Override
    public final void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        HttpSession session = req.getSession(false);
        String servletDir = this.getServletDir();
        if (session != null) {
            File dir;
            LOGGER.info("RetryNServlet {}", (Object)session.getId());
            String tmpDirToClean = (String)session.getAttribute("tmpDirToClean");
            if (tmpDirToClean != null && (dir = new File(tmpDirToClean)).exists()) {
                this.cleanSubDirectory("tapenadeGenDir", session, tmpDirToClean);
                this.cleanSubDirectory("tapenadeOutputDir", session, tmpDirToClean);
                String[] files = dir.list();
                for (String fileName : Objects.requireNonNull(files)) {
                    File file = new File(tmpDirToClean + "/" + fileName);
                    if (file.delete()) continue;
                    LOGGER.info("RetryServlet, delete {}/{}", (Object)tmpDirToClean, (Object)fileName);
                }
            }
            session.setAttribute("inputFileNames", null);
            session.setAttribute("includeFileNames", null);
            session.setAttribute("size", (Object)0L);
            session.setAttribute("inputLanguage", null);
        } else {
            LOGGER.info("RetryNServlet");
        }
        String url = res.encodeRedirectURL(servletDir + "index.jsp");
        res.sendRedirect(url);
    }

    private void cleanSubDirectory(String subDirectory, HttpSession session, String tmpDirToClean) {
        String diffgenpath = tmpDirToClean + File.separator + session.getAttribute(subDirectory);
        File dir = new File(diffgenpath);
        if (dir.exists()) {
            String[] files = dir.list();
            for (int i = 0; i < Objects.requireNonNull(files).length; ++i) {
                File f = new File(diffgenpath + "/" + files[i]);
                if (f.delete()) continue;
                LOGGER.info("Clean directory, delete: {}", (Object)files[i]);
            }
        }
    }
}

