/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.toplevel;

import fr.inria.tapenade.analysis.ADActivityAnalyzer;
import fr.inria.tapenade.analysis.ADTBRAnalyzer;
import fr.inria.tapenade.analysis.ActivityPattern;
import fr.inria.tapenade.analysis.DepsAnalyzer;
import fr.inria.tapenade.analysis.DiffLivenessAnalyzer;
import fr.inria.tapenade.analysis.ReqExplicit;
import fr.inria.tapenade.differentiation.CallGraphDifferentiator;
import fr.inria.tapenade.frontend.GeneralLibReader;
import fr.inria.tapenade.frontend.Parser;
import fr.inria.tapenade.frontend.TreeProtocol;
import fr.inria.tapenade.graphicsutils.GraphViewer;
import fr.inria.tapenade.gui.TapenadeFrame;
import fr.inria.tapenade.ir2tree.TreeGen;
import fr.inria.tapenade.prettyprint.CDecompiler;
import fr.inria.tapenade.prettyprint.CallGraphDisplayer;
import fr.inria.tapenade.prettyprint.Decompiler;
import fr.inria.tapenade.prettyprint.DotDecompiler;
import fr.inria.tapenade.prettyprint.FortranDecompiler;
import fr.inria.tapenade.prettyprint.HtmlPrinter;
import fr.inria.tapenade.prettyprint.TextPrinter;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.CStuff;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.DiffPattern;
import fr.inria.tapenade.representation.DiffRoot;
import fr.inria.tapenade.representation.Directive;
import fr.inria.tapenade.representation.FlowGraphBuilder;
import fr.inria.tapenade.representation.FortranStuff;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.MPIcallInfo;
import fr.inria.tapenade.representation.MixedLanguageInfos;
import fr.inria.tapenade.representation.PositionAndMessage;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.utils.Chrono;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Tapenade {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final String TAPENADE_SERVLET_OUTPUT_DIR = "tapenadeoutput";
    protected static final String TAPENADE_GEN_HTML_DIR = "tapenadehtml";
    private static final int IL = 0;
    private static final int VARIABLE = 0;
    private static final int PROCEDURE = 1;
    private static final int MODULE = 2;
    private static final int TYPE = 3;
    private static final int ORIGCOPY = 0;
    private static final int DIFFERENTIATED = 1;
    private static final int TANGENT = 1;
    private static final int ADJOINT = 2;
    private static final int ADJOINT_FWD = 3;
    private static final int ADJOINT_BWD = 4;
    private static final String DEFAULT_COPIED_UNIT_SUFFIX = "_nodiff";
    private static final String DEFAULT_MODULE_UNIT_SUFFIX = "_diff";
    private static final String DEFAULT_ADOLC_FUNC_SUFFIX = "_a";
    private static final String DEFAULT_ADOLC_VAR_SUFFIX = "a";
    private static final String DEFAULT_ASSOC_BY_ADDRESS_FUNC_SUFFIX = "aa";
    private static final int BEGINNING = 0;
    private static final int INIDENT = 1;
    private static final int INCASN = 2;
    private static final int INVARS = 3;
    private static final int ENDING = 10;
    private static final int NOTHING = 0;
    private static final int FUNC = 1;
    private static final int CASN = 2;
    private static final int VARS = 3;
    private static final int ONTK = 4;
    private static final int TOTK = 5;
    private static final int BEFORE_FUNC = 0;
    private static final int AFTER_FUNC = 1;
    private static final int AFTER_FUNC_CASN = 2;
    private static final int AFTER_ONTK = 3;
    private static final int AFTER_TOTK = 4;
    private static final int AFTER_VARS = 5;
    private static final String javaHome = System.getProperty("java.home");
    private static String pathToParsers;
    private static String tapenadeServletRoot;
    private static String parserDirectory;
    private final String directoryHtmlGen = "tapenadehtml" + File.separator;
    private final TapList<String> includeDirList = new TapList<Object>(null, null);
    private final String[][] suffixes = new String[][]{{"", "_nodiff", "", ""}, {"d", "_d", "_diff", "_diff"}, {"b", "_b", "", "_diff"}, {"b", "_fwd", "", "_diff"}, {"b", "_bwd", "", "_diff"}};
    protected String htmlMessageFileName = "msg.html";
    protected String textMessageFileName = "msg.txt";
    private String cssDir = "";
    protected TapList<DiffRoot> diffRoots;
    private CallGraph diffCallGraph;
    private boolean generateLanguage = true;
    private boolean generateHTML;
    private boolean generateAST;
    private int diffKind = 1;
    private String outputDirectory = "." + File.separator;
    private String absDirectoryHtmlGen = this.outputDirectory + this.directoryHtmlGen;
    private String outputHtmlDirectory;
    private TapList<String> toIncludeDirList = this.includeDirList;
    private String inputFileName;
    private String[] inputFileNames;
    private int inputLanguage = -1;
    private boolean parseOpenMP;
    private boolean nolib;
    private String stdGeneralLibraryDirectory;
    private String libraryFileNames = "";
    private boolean fortranLibraryLoaded;
    private OutputStream dumpOutputStream;
    private DiffPattern unfinishedInVars;
    private DiffPattern unfinishedOutVars;
    private TapList<TapList<String>> waitingInVars;
    private TapList<TapList<String>> waitingOutVars;
    private boolean debug;
    private boolean showMessagesInFile;
    private boolean viewCallGraph;
    private String outputFileName;
    private boolean splitOutputFiles;
    private PrintWriter fileILNames;
    private TapList<String> splittedUnitNames;
    private TapList<String> specializedActivityUnitNames;

    private Tapenade() {
        TapEnv.distribVersionInit();
        TapEnv.setParserFileSeparator(File.separator);
        TapEnv.setMixedLanguageInfos(MixedLanguageInfos.defaultMixedLangInfos());
        this.diffRoots = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tapenade(String[] args) {
        Tapenade tapenade = this;
        synchronized (tapenade) {
            this.runTapenade(args);
        }
    }

    protected Tapenade(int fileLang, String aliParser, int diffmode, String webAppRoot, String absoluteDirectory, String clientDirectory, String[] inputfilenames, String libDirectory, String headFunction, String activevariables, String usefulvariables, boolean multiDirDiffMode) {
        TapEnv.distribVersionInit();
        TapEnv.setMixedLanguageInfos(MixedLanguageInfos.defaultMixedLangInfos());
        this.diffRoots = null;
        TapEnv.setMsgLevel(30);
        TapEnv.setTraceLevel(30);
        TapEnv.printlnOnTrace("Tapenade 3.16 (master) -  9 Oct 2020 17:47 - Java " + System.getProperty("java.version"));
        if (diffmode == 1) {
            TapEnv.setModeTangent();
            TapEnv.setRemoveDeadPrimal(false);
            TapEnv.setRemoveDeadControl(false);
        } else if (diffmode == -1) {
            TapEnv.setModeAdjoint();
        } else if (diffmode == 2) {
            TapEnv.setModeOverloading();
        } else {
            TapEnv.setModeNoDiff();
        }
        if (TapEnv.modeIsTangent()) {
            TapEnv.setMustTangent(true);
        }
        if (TapEnv.modeIsAdjoint()) {
            TapEnv.setMustAdjoint(true);
        }
        TapEnv.get().multiDirDiffMode = multiDirDiffMode;
        pathToParsers = aliParser;
        TapEnv.forServlet = true;
        tapenadeServletRoot = webAppRoot;
        TapEnv.setParserFileSeparator(File.separator);
        this.outputDirectory = absoluteDirectory + TAPENADE_SERVLET_OUTPUT_DIR + File.separator;
        this.absDirectoryHtmlGen = absoluteDirectory + this.directoryHtmlGen;
        this.outputHtmlDirectory = clientDirectory + this.directoryHtmlGen;
        this.cssDir = "../../../";
        this.inputLanguage = fileLang;
        TapEnv.setInputLanguage(this.inputLanguage);
        if (inputfilenames == null) {
            this.inputFileName = absoluteDirectory + "default.f";
            this.inputFileNames = new String[1];
            this.inputFileNames[0] = this.inputFileName;
        } else {
            this.inputFileNames = new String[inputfilenames.length];
            for (int i = 0; i < inputfilenames.length; ++i) {
                this.inputFileNames[i] = absoluteDirectory + inputfilenames[i];
            }
            this.inputFileName = absoluteDirectory + inputfilenames[0];
        }
        this.stdGeneralLibraryDirectory = libDirectory;
        TapEnv.get().stdLibraryDirectory = libDirectory;
        this.parseDiffRoots(headFunction);
        this.parseDiffVars(activevariables);
        this.parseDiffOutvars(usefulvariables);
        this.generateHTML = true;
        this.prepareAllSuffixes("_d", "d", "_b", "b", DEFAULT_MODULE_UNIT_SUFFIX, DEFAULT_MODULE_UNIT_SUFFIX, DEFAULT_MODULE_UNIT_SUFFIX, "_c", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tapenade(String[] args, String modeString, boolean multiMode) {
        Tapenade tapenade = this;
        synchronized (tapenade) {
            String[] newArgs = new String[args.length + 3];
            newArgs[0] = modeString;
            System.arraycopy(args, 0, newArgs, 1, args.length);
            newArgs[newArgs.length - 2] = "-o";
            int random = (int)(Math.random() * 50.0 + 1.0);
            newArgs[newArgs.length - 1] = "result" + random;
            TapEnv.printlnOnTrace("RunTapenade " + modeString + " " + multiMode + " output " + newArgs[newArgs.length - 1]);
            this.runTapenade(newArgs);
        }
    }

    public static void main(final String[] args) {
        TapEnv.printlnOnTrace("Tapenade 3.16 (master) -  9 Oct 2020 17:47 - Java " + System.getProperty("java.version") + " " + System.getProperty("os.name"));
        if (!TapEnv.isDistribVersion()) {
            TapEnv.printlnOnTrace("@@ TAPENADE_HOME=" + System.getProperty("tapenade_home"));
        }
        if (args.length > 0) {
            if (!TapEnv.isDistribVersion() && args[0].equals("-thread")) {
                TapEnv.printlnOnTrace("Test // PreProcess, Direct, DirectV, Reverse");
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            new Tapenade(args, "-p", false);
                        }
                    }
                }.start();
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        2 var1_1 = this;
                        synchronized (var1_1) {
                            new Tapenade(args, "-d", false);
                        }
                    }
                }.start();
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        3 var1_1 = this;
                        synchronized (var1_1) {
                            new Tapenade(args, "-d", true);
                        }
                    }
                }.start();
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        4 var1_1 = this;
                        synchronized (var1_1) {
                            new Tapenade(args, "-b", false);
                        }
                    }
                }.start();
            } else {
                new Tapenade(args);
            }
        } else {
            Tapenade.gui();
        }
    }

    protected CallGraph origCallGraph() {
        return TapEnv.get().origCallGraph();
    }

    protected CallGraph diffCallGraph() {
        return this.diffCallGraph;
    }

    private void setDiffCallGraph(CallGraph diffCallGraph) {
        this.diffCallGraph = diffCallGraph;
    }

    private static int getFortranDialect(int type, int result) {
        if (type == 1 && (result == 2 || result == 3)) {
            result = 2;
        } else if (!(result != 1 && result != 2 && result != 3 || type != 2 && type != 3)) {
            result = 2;
        }
        return result;
    }

    public static void parseFiles(boolean addDirectory, String directory, String[] localInputFileNames, CallGraph origCallGraph, TapList<String> includeDirList, int inputLang, boolean parseOpenMP) throws IOException {
        String line;
        TapList<Object> cPlusPlusFileNames;
        String cPreProcSuffix = "_cpp.c";
        int position = 0;
        TapList<Object> cPlusPlusFileNamesTail = cPlusPlusFileNames = new TapList<Object>(null, null);
        for (String name : localInputFileNames) {
            int index = name.lastIndexOf(File.separator);
            TapList<String> includeDirs = includeDirList;
            String currentDirectory = "";
            if (index > 0) {
                currentDirectory = name.substring(0, index + 1);
            }
            TapEnv.setCurrentDirectory(currentDirectory);
            String localInputFileName = addDirectory ? directory + name : name;
            int language = inputLang != -1 ? inputLang : Tapenade.getLanguageOfFile(localInputFileName);
            TapEnv.setRelatedLanguage(language);
            if (language == 1 || language == 2 || language == 3) {
                int length = 8;
                if (parseOpenMP) {
                    ++length;
                }
                if (language != 1) {
                    ++length;
                }
                String[] commands = new String[length += 2 * TapList.length(includeDirs)];
                commands[0] = TapEnv.forServlet ? pathToParsers + parserDirectory + File.separator + "fortranParser" : pathToParsers + "fortranParserRun.sh";
                commands[1] = "-fileseparator";
                commands[2] = TapEnv.parserFileSeparator();
                commands[3] = "-linesize";
                commands[4] = TapEnv.get().fortran90LineLength;
                int k = 5;
                while (includeDirs != null) {
                    commands[k] = "-includedir";
                    commands[k + 1] = (String)includeDirs.head;
                    k += 2;
                    includeDirs = includeDirs.tail;
                }
                commands[k] = "-includetype";
                commands[++k] = TapEnv.forServlet ? "servlet" : "tapenade";
                ++k;
                if (parseOpenMP) {
                    commands[k] = "-openmp";
                    ++k;
                }
                if (language != 1) {
                    commands[k] = "-freeformat";
                    ++k;
                }
                commands[length - 1] = localInputFileName;
                BufferedReader reader = Parser.parse(null, commands, localInputFileName);
                position = Tapenade.readILstream(reader, origCallGraph, position, localInputFileName, language);
            } else if (language == 5) {
                cPlusPlusFileNamesTail = cPlusPlusFileNamesTail.placdl(localInputFileName);
            } else if (language == 4) {
                if (TapEnv.get().cppCommand == null) {
                    TapEnv.get().cppCommand = parserDirectory.equals("mac") && Tapenade.commandFound("/usr/bin/cpp") ? "/usr/bin/cpp" : "/usr/bin/cpp";
                }
                String[] preProcessOptions = null;
                if (TapEnv.get().cppOptions != null) {
                    preProcessOptions = Tapenade.splitTokens(TapEnv.get().cppOptions);
                }
                int length = 6;
                if (TapEnv.get().noComment) {
                    length = 5;
                }
                int totalLength = length + 2 * TapList.length(includeDirs);
                if (preProcessOptions != null) {
                    totalLength += preProcessOptions.length;
                }
                String[] preProcessCommands = new String[totalLength];
                preProcessCommands[0] = TapEnv.get().cppCommand;
                preProcessCommands[1] = "-std=c99";
                preProcessCommands[2] = "-ffreestanding";
                if (!TapEnv.get().noComment) {
                    preProcessCommands[3] = "-C";
                }
                int k = length - 2;
                if (preProcessOptions != null) {
                    System.arraycopy(preProcessOptions, 0, preProcessCommands, k, preProcessOptions.length);
                    k += preProcessOptions.length;
                }
                while (includeDirs != null) {
                    preProcessCommands[k] = "-I";
                    preProcessCommands[k + 1] = (String)includeDirs.head;
                    k += 2;
                    includeDirs = includeDirs.tail;
                }
                preProcessCommands[k] = localInputFileName;
                preProcessCommands[k + 1] = localInputFileName + "_cpp.c";
                if (!Tapenade.commandFound(TapEnv.get().cppCommand)) {
                    TapEnv.commandWarning(-1, TapEnv.get().cppCommand + " not found ");
                    TapEnv.get().cppBeforeParsing = false;
                    preProcessCommands = null;
                }
                String javaCommand = javaHome + File.separator + "bin" + File.separator + "java";
                String jarName = TapEnv.tapenadeHome + File.separator + "build" + File.separator + "libs" + File.separator + "frontc.jar";
                String[] commands = new String[]{javaCommand, "-classpath", jarName, "fr/inria/frontc/C2IL", localInputFileName + "_cpp.c"};
                if (!TapEnv.get().cppBeforeParsing) {
                    commands[4] = localInputFileName;
                }
                if (TapEnv.forServlet) {
                    commands[2] = tapenadeServletRoot + File.separator + "WEB-INF" + File.separator + "lib" + File.separator + "frontc.jar";
                }
                BufferedReader reader = Parser.parse(preProcessCommands, commands, localInputFileName);
                position = Tapenade.readILstream(reader, origCallGraph, position, localInputFileName, 4);
            } else if (language == 0) {
                BufferedReader reader = new BufferedReader(new FileReader(localInputFileName));
                TapEnv.setCurrentParsedFile(localInputFileName);
                TapEnv.printlnOnTrace(7, "@@ Reading from IL file " + localInputFileName);
                reader.mark(299);
                line = reader.readLine();
                int givenInputFileLang = -1;
                while (line != null) {
                    String givenInputFileName;
                    if (line.startsWith("From file ")) {
                        givenInputFileName = line.substring(10);
                        givenInputFileLang = Tapenade.getLanguageOfFile(givenInputFileName);
                        TapEnv.printlnOnTrace(7, "@@  ...actually representing file " + givenInputFileName);
                    } else {
                        reader.reset();
                        givenInputFileName = localInputFileName;
                    }
                    if (givenInputFileLang == -1) {
                        givenInputFileLang = TapEnv.outputLanguage();
                    }
                    position = Tapenade.readILstream(reader, origCallGraph, position, givenInputFileName, givenInputFileLang);
                    reader.mark(299);
                    line = reader.readLine();
                    while (line != null && !line.startsWith("From file ")) {
                        reader.mark(299);
                        line = reader.readLine();
                    }
                }
            } else if (language == 98) {
                TapEnv.commandWarning(-1, localInputFileName + ", include skipped in command line");
            } else if (language == 99) {
                Tapenade.parseFiles(true, directory, Tapenade.extractFiles(directory, localInputFileName), origCallGraph, includeDirs, inputLang, parseOpenMP);
            } else {
                String noParserFileName = TapEnv.forServlet ? TapEnv.stripPath(localInputFileName) : localInputFileName;
                TapEnv.toolWarning(-1, "No parser for " + noParserFileName + ". File skipped");
            }
            if (language != 4 || !TapEnv.get().cppBeforeParsing || TapEnv.get().traceParser || new File(localInputFileName + "_cpp.c").delete()) continue;
            TapEnv.toolWarning(-1, "Cannot remove " + localInputFileName + "_cpp.c");
        }
        if (cPlusPlusFileNames.tail != null) {
            TapEnv.setRelatedLanguage(5);
            TapList<String> allcPlusPlusFileNames = cPlusPlusFileNames.tail;
            cPlusPlusFileNames = cPlusPlusFileNames.tail;
            String firstFileName = (String)cPlusPlusFileNames.head;
            int nbFiles = TapList.length(cPlusPlusFileNames);
            String[] commands = new String[nbFiles + 1];
            commands[0] = pathToParsers + "cppParserRun.sh";
            int i = 1;
            while (cPlusPlusFileNames != null) {
                commands[i] = (String)cPlusPlusFileNames.head;
                ++i;
                cPlusPlusFileNames = cPlusPlusFileNames.tail;
            }
            String[] preProcessCommands = new String[6 + nbFiles];
            preProcessCommands[0] = "clang++";
            preProcessCommands[1] = "-MJ";
            preProcessCommands[2] = "o.json";
            preProcessCommands[3] = "-std=c++11";
            preProcessCommands[4] = "-w";
            preProcessCommands[5] = "-c";
            if (nbFiles >= 0) {
                System.arraycopy(commands, 1, preProcessCommands, 6, nbFiles);
            }
            BufferedReader reader = Parser.parse(preProcessCommands, commands, firstFileName);
            TapEnv.setCurrentParsedFile(firstFileName);
            if (reader != null) {
                line = reader.readLine();
                while (line != null) {
                    if (line.startsWith("From file ")) {
                        String fileName = line.substring(10);
                        position = Tapenade.readILstream(reader, origCallGraph, position, fileName, 5);
                        line = reader.readLine();
                        continue;
                    }
                    throw new IOException("Parsing error");
                }
            }
            if (!TapEnv.get().traceParser) {
                Parser.cleanJsonFiles(allcPlusPlusFileNames);
            }
        }
    }

    private static int readILstream(BufferedReader reader, CallGraph callGraph, int position, String fileName, int language) {
        Unit fileUnit = callGraph.createNewUnit(null, language);
        fileUnit.setTranslationUnit(fileName);
        if (fileName.endsWith("iso_c_bindingf.f90") || fileName.endsWith("mpif.f90")) {
            fileUnit.setPredefinedModuleOrTranslationUnit();
        }
        TreeProtocol inputTreeStream = new TreeProtocol(reader);
        callGraph.setInputStream(inputTreeStream);
        inputTreeStream.setPosition(position);
        if (TapEnv.traceInputIL()) {
            inputTreeStream.pushTreeReader();
            inputTreeStream.setTraceOn(true);
        }
        try {
            FlowGraphBuilder.build(inputTreeStream, callGraph.languageRootSymbolTable(language), callGraph, language, fileUnit, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (TapEnv.traceInputIL()) {
            Tree fullTree = inputTreeStream.popTreeReader();
            TapEnv.printlnOnTrace("Checking IL syntax of input tree:" + (fullTree.checkSyntax(fileName) ? "ok" : "wrong"));
            String unmodifiedInputFile = "unmodifiedInput.c++";
            try {
                TextPrinter textPrinter = new TextPrinter(unmodifiedInputFile);
                textPrinter.initFile(language);
                Decompiler languagePrinter = null;
                if (TapEnv.isFortran(language)) {
                    languagePrinter = new FortranDecompiler(textPrinter, null);
                } else if (TapEnv.isCorMore(language)) {
                    languagePrinter = new CDecompiler(textPrinter, null);
                }
                if (languagePrinter != null) {
                    languagePrinter.decompileTree(fullTree, language, false, false);
                    languagePrinter.newLine(0);
                }
                textPrinter.newLine();
                textPrinter.closeFile();
            }
            catch (IOException e) {
                TapEnv.printlnOnTrace("Could not open file " + unmodifiedInputFile + " for unmodified input file output");
            }
        }
        return inputTreeStream.position() + 1;
    }

    private static boolean commandFound(String command) {
        File commandFile = new File(command);
        return commandFile.exists();
    }

    private static String[] splitTokens(String optionsLine) {
        StringTokenizer token = new StringTokenizer(optionsLine);
        String[] result = new String[token.countTokens()];
        int i = 0;
        while (token.hasMoreElements()) {
            result[i] = token.nextToken();
            ++i;
        }
        return result;
    }

    private static int getLanguageOfFile(String filename) {
        String extension;
        int type = -1;
        switch (extension = TapEnv.getExtension(filename)) {
            case "": {
                type = 0;
                break;
            }
            case "f": 
            case "for": 
            case "fortran": {
                type = 1;
                break;
            }
            case "f90": 
            case "f95": {
                type = 2;
                if (!TapEnv.get().suffixF90.equals(".f90??")) break;
                TapEnv.get().suffixF90 = "." + extension;
                break;
            }
            case "f03": {
                type = 3;
                break;
            }
            case "c": {
                type = 4;
                break;
            }
            case "cpp": 
            case "cxx": 
            case "c++": 
            case "cc": {
                type = 5;
                break;
            }
            case "jar": 
            case "zip": {
                type = 99;
                break;
            }
            case "h": 
            case "inc": 
            case "include": {
                type = 98;
                break;
            }
            default: {
                TapEnv.commandWarning(-1, "Unknown file extension " + extension + " in " + filename);
            }
        }
        return type;
    }

    protected static String[] extractFiles(String directory, String filename) {
        LOGGER.debug("ExtractFiles of filename {} in directory {}", (Object)filename, (Object)directory);
        String[] exFileNames = null;
        try (ZipFile zipFile = new ZipFile(filename);){
            TapList<Object> names = null;
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            while (en.hasMoreElements()) {
                ZipEntry zipEntry = en.nextElement();
                String name = zipEntry.getName();
                if (name.equals("META-INF/") || name.equals("META-INF/MANIFEST.MF")) continue;
                if (!zipEntry.isDirectory()) {
                    names = new TapList<String>(name, names);
                    Tapenade.copyInputStream(zipFile.getInputStream(zipEntry), new BufferedOutputStream(Files.newOutputStream(Paths.get(directory + name, new String[0]), new OpenOption[0])));
                    continue;
                }
                TapEnv.printlnOnTrace("Directory ignored in archive file");
            }
            int nb = TapList.length(names);
            int i = 0;
            exFileNames = new String[nb];
            while (names != null) {
                exFileNames[i] = (String)names.head;
                ++i;
                names = names.tail;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return exFileNames;
    }

    private static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    private static String rmFilenameFortranExtension(String filename) {
        String newfilename = filename;
        if (filename.endsWith(".f") || filename.endsWith(".F") || filename.endsWith(".c")) {
            newfilename = filename.substring(0, filename.length() - 2);
        } else if (filename.endsWith(".f90") || filename.endsWith(".F90") || filename.endsWith(".f95") || filename.endsWith(".F95") || filename.endsWith(".f03") || filename.endsWith(".F03")) {
            newfilename = filename.substring(0, filename.length() - 4);
        }
        return newfilename;
    }

    private static boolean neqIdentifiers(TapList<String> id1, TapList<String> id2) {
        boolean areEqual = true;
        while (areEqual && (id1 != null || id2 != null)) {
            if (id1 == null || id2 == null || !((String)id1.head).equals(id2.head)) {
                areEqual = false;
                continue;
            }
            id1 = id1.tail;
            id2 = id2.tail;
        }
        return !areEqual;
    }

    private static void addIdentInList(TapList<String> ident, TapList<TapList<String>> toList) {
        TapList<TapList<String>> inList = toList;
        while (inList.tail != null && Tapenade.neqIdentifiers(ident, (TapList)inList.tail.head)) {
            inList = inList.tail;
        }
        if (inList.tail == null) {
            inList.tail = new TapList<TapList<String>>(ident, null);
        }
    }

    private static int parseLanguage(String languageName) {
        int result = -1;
        switch (languageName) {
            case "FORTRAN": {
                result = 1;
                break;
            }
            case "FORTRAN90": {
                result = 2;
                break;
            }
            case "FORTRAN2003": {
                result = 3;
                break;
            }
            case "C": {
                result = 4;
                break;
            }
        }
        return result;
    }

    private static void help() {
        TapEnv.printlnOnTrace(" Builds a differentiated program.");
        TapEnv.printlnOnTrace(" Usage: tapenade [options]* filenames");
        TapEnv.printlnOnTrace("  options:");
        TapEnv.printlnOnTrace("   -head, -root <proc>     set the differentiation root procedure(s)");
        TapEnv.printlnOnTrace("                           See FAQ for refined invocation syntax, e.g.");
        TapEnv.printlnOnTrace("                           independent and dependent arguments, multiple heads...");
        TapEnv.printlnOnTrace("   -tangent, -d            differentiate in forward/tangent mode (default)");
        TapEnv.printlnOnTrace("   -reverse, -b            differentiate in reverse/adjoint mode");
        TapEnv.printlnOnTrace("   -vector, -multi         turn on \"vector\" mode (i.e. multi-directional)");
        TapEnv.printlnOnTrace("   -specializeactivity <unit_names or %all%>  Allow for several activity patterns per routine");
        TapEnv.printlnOnTrace("   -preprocess, -p         turn off differentiation. Show pointer destinations");
        TapEnv.printlnOnTrace("   -output, -o <file>      put all generated code into a single <file>");
        TapEnv.printlnOnTrace("   -splitoutputfiles       split generated code, one file per top unit");
        TapEnv.printlnOnTrace("   -outputdirectory, -O <directory>  put all generated files in <directory> (default: .)");
        TapEnv.printlnOnTrace("   -I <includePath>        add a new search path for include files");
        TapEnv.printlnOnTrace("   -tgtvarname <str>       set extension for tangent variables  (default %d)");
        TapEnv.printlnOnTrace("   -tgtfuncname <str>      set extension for tangent procedures (default %_d)");
        TapEnv.printlnOnTrace("   -tgtmodulename <str>    set extension for tangent modules and types (default %_diff)");
        TapEnv.printlnOnTrace("   -adjvarname <str>       set extension for adjoint variables  (default %b)");
        TapEnv.printlnOnTrace("   -adjfuncname <str>      set extension for adjoint procedures (default %_b)");
        TapEnv.printlnOnTrace("   -adjmodulename <str>    set extension for adjoint modules and types (default %_diff)");
        TapEnv.printlnOnTrace("   -modulename <str>       set extension for tangent&adjoint modules and types (default %_diff)");
        TapEnv.printlnOnTrace("   -inputlanguage <lang>   language of  input files (fortran, fortran90,");
        TapEnv.printlnOnTrace("                           fortran95, or C)");
        TapEnv.printlnOnTrace("   -outputlanguage <lang>  language of output files (fortran, fortran90,");
        TapEnv.printlnOnTrace("                           fortran95, or C)");
        TapEnv.printlnOnTrace("   -ext <file>             incorporate external library description <file>");
        TapEnv.printlnOnTrace("   -nolib                  don't load standard libraries descriptions");
        TapEnv.printlnOnTrace("   -i<n>                   count <n> bytes for an integer (default -i4)");
        TapEnv.printlnOnTrace("   -r<n>                   count <n> bytes for a real (default -r4)");
        TapEnv.printlnOnTrace("   -dr<n>                  count <n> bytes for a double real (default -dr8)");
        TapEnv.printlnOnTrace("   -p<n>                   count <n> bytes for a pointer (default -p8)");
        TapEnv.printlnOnTrace("   -fixinterface           don't use activity to filter user-given (in)dependent vars");
        TapEnv.printlnOnTrace("   -noinclude              inline include files");
        TapEnv.printlnOnTrace("   -debugTGT               insert instructions for debugging tangent mode");
        TapEnv.printlnOnTrace("   -debugADJ               insert instructions for debugging adjoint mode");
        TapEnv.printlnOnTrace("   -tracelevel <n>         set the level of detail of trace milestones");
        TapEnv.printlnOnTrace("   -msglevel <n>           set the level of detail of error messages");
        TapEnv.printlnOnTrace("   -msginfile              insert error messages in output files");
        TapEnv.printlnOnTrace("   -dump <file>            write a dump <file>");
        TapEnv.printlnOnTrace("   -html                   display results in a web browser");
        TapEnv.printlnOnTrace("   -nooptim <str>          turn off optimization <str> (in {activity, difftypes,");
        TapEnv.printlnOnTrace("                           diffarguments, stripprimalmodules, spareinit, splitdiff, ");
        TapEnv.printlnOnTrace("                           mergediff, saveonlyused, tbr, snapshot, diffliveness,");
        TapEnv.printlnOnTrace("                           deadcontrol, recomputeintermediates,");
        TapEnv.printlnOnTrace("                           everyoptim}");
        TapEnv.printlnOnTrace("   -version                display Tapenade version information");
        TapEnv.printlnOnTrace(" Report bugs to <tapenade@lists-sop.inria.fr>.");
    }

    private static void hiddenHelp() {
        TapEnv.printlnOnTrace("  Warning: some options implemented only partly");
        TapEnv.printlnOnTrace("   -directValid            tangent mode computing validity interval");
        TapEnv.printlnOnTrace("   -traceParser");
        TapEnv.printlnOnTrace("   -traceInputIL");
        TapEnv.printlnOnTrace("   -traceFlowGraphBuild <unit_names or %all%>");
        TapEnv.printlnOnTrace("   -traceTypeCheck <unit_names or %all%>");
        TapEnv.printlnOnTrace("   -tracePointer <unit_names or %all%>");
        TapEnv.printlnOnTrace("   -traceInOut <unit_names or %all%>");
        TapEnv.printlnOnTrace("   -traceDeps <unit_names or %all%>");
        TapEnv.printlnOnTrace("   -traceADDeps <unit_names or %all%>");
        TapEnv.printlnOnTrace("   -traceActivity <unit_names or %all%>");
        TapEnv.printlnOnTrace("   -traceReqExplicit <unit_names or %all%>");
        TapEnv.printlnOnTrace("   -traceDiffLiveness <unit_names or %all%>");
        TapEnv.printlnOnTrace("   -traceTBR <unit_names or %all%>");
        TapEnv.printlnOnTrace("   -traceDifferentiation <unit_names or %all%>");
        TapEnv.printlnOnTrace("   -traceTreeGen <unit_names or %all%>");
        TapEnv.printlnOnTrace("   -traceBlock <block_rank>");
        TapEnv.printlnOnTrace("   -optim {spareinit, diffliveness, statictape}");
        TapEnv.printlnOnTrace("   -nooptim {activity, usefulness, difftypes, stripprimalcode, stripprimalmodules,");
        TapEnv.printlnOnTrace("             spareinit, diffarguments, splitdiff, mergediff, saveonlyused, tbr, snapshot,");
        TapEnv.printlnOnTrace("             diffliveness, deadcontrol, recomputeintermediates, refineadmm, everyoptim}");
        TapEnv.printlnOnTrace("   -noisize");
        TapEnv.printlnOnTrace("   -noisize77");
        TapEnv.printlnOnTrace("   -profile");
        TapEnv.printlnOnTrace("   -buildsaverestore");
        TapEnv.printlnOnTrace("   -dumpunit <unit_names or %all%>");
        TapEnv.printlnOnTrace("   -dumpCallGraph");
        TapEnv.printlnOnTrace("   -dumpSymbolTables");
        TapEnv.printlnOnTrace("   -dumpFlowGraphs");
        TapEnv.printlnOnTrace("   -dumpZones");
        TapEnv.printlnOnTrace("   -dumpDataFlow");
        TapEnv.printlnOnTrace("     -dumpInOut");
        TapEnv.printlnOnTrace("     -dumpPointers");
        TapEnv.printlnOnTrace("     -dumpDeps");
        TapEnv.printlnOnTrace("   -dumpDiffSymbolTables");
        TapEnv.printlnOnTrace("   -dumpDiffFlowGraphs");
        TapEnv.printlnOnTrace("   -viewCallGraph");
        TapEnv.printlnOnTrace("   -debugActivity");
        TapEnv.printlnOnTrace("   -debugPassives");
        TapEnv.printlnOnTrace("   -differentiateintegers");
        TapEnv.printlnOnTrace("   -copyname <str>       set extension for copies (\"\" for no extension)");
        TapEnv.printlnOnTrace("   -context");
        TapEnv.printlnOnTrace("   -specializeActivity <unit_names or %all%>       Allow for several activity patterns per routine");
        TapEnv.printlnOnTrace("   -oldContext");
        TapEnv.printlnOnTrace("   -distinctNewVars");
        TapEnv.printlnOnTrace("   OBSOLETE: -dptest <unit_names>");
        TapEnv.printlnOnTrace("   OBSOLETE: -traceactivevars <unit_names or %all%>");
    }

    private static void gui() {
        String display = System.getenv("DISPLAY");
        LOGGER.info("DISPLAY={}", (Object)display);
        if (display != null) {
            TapenadeFrame.getInstance();
        } else {
            LOGGER.info("No X11 DISPLAY variable was set,");
            LOGGER.info("but this program performed an operation which requires it.");
        }
    }

    public static CallGraph preProcess(String[] files) {
        Tapenade tapenade = new Tapenade();
        TapEnv.setModeNoDiff();
        tapenade.analyzeParameters(files);
        try {
            tapenade.createCallGraph();
        }
        catch (IOException e) {
            TapEnv.toolError(e.toString());
        }
        return tapenade.origCallGraph();
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    private void runTapenade(String[] args) {
        boolean hasGlobalDeclarations;
        boolean hasError;
        Chrono totalTapenadeTimer;
        block10: {
            totalTapenadeTimer = new Chrono();
            hasError = false;
            TapEnv.distribVersionInit();
            TapEnv.setMixedLanguageInfos(MixedLanguageInfos.defaultMixedLangInfos());
            this.diffRoots = null;
            this.analyzeParameters(args);
            if (!TapEnv.optionsString().isEmpty()) {
                TapEnv.printlnOnTrace("@@ Options: " + TapEnv.optionsString());
            }
            this.checkParserFileSeparator();
            this.textMessageFileName = this.outputFileName;
            if (this.textMessageFileName == null) {
                String name = TapEnv.stripPath(this.inputFileName);
                int index = name.lastIndexOf(46);
                this.textMessageFileName = index > 0 ? name.substring(0, index) : name;
            }
            this.textMessageFileName = TapEnv.extendStringWithSuffix(this.textMessageFileName, TapEnv.get().diffFileSuffix) + ".msg";
            hasGlobalDeclarations = false;
            try {
                hasGlobalDeclarations = this.analyzeFile();
            }
            catch (IOException e) {
                hasError = true;
                TapEnv.systemWarning(-1, e.toString());
                if (TapEnv.get().dumps && this.dumpOutputStream != null) {
                    e.printStackTrace(new PrintStream(this.dumpOutputStream));
                }
                if (!TapEnv.get().dumps && !this.debug) break block10;
                LOGGER.info("Error ", (Throwable)e);
            }
        }
        TapList<Unit> transformedUnits = this.getTransformedSourceUnits(this.diffCallGraph() == null ? null : this.diffCallGraph().backAssociations);
        boolean showMessagesOfAllUnits = TapEnv.modeIsNoDiff() || this.diffCallGraph() == null || transformedUnits == null || this.generateHTML;
        TapList<PositionAndMessage> allMessages = TapEnv.getAllMessages(this.origCallGraph(), this.diffCallGraph(), transformedUnits, showMessagesOfAllUnits);
        if (this.generateHTML) {
            TapEnv.saveAllMessagesAsHTML(allMessages, this.absDirectoryHtmlGen + this.htmlMessageFileName, this.cssDir, "", this.outputFileName, hasGlobalDeclarations, TapEnv.get().preprocessFileSuffix);
        }
        TapEnv.saveAllMessagesAsText(allMessages, this.outputDirectory + this.textMessageFileName);
        TapEnv.printlnOnTrace(7, "@@ Created " + this.outputDirectory + this.textMessageFileName);
        if (this.generateHTML) {
            this.htmlOutput();
        }
        if (hasError || TapEnv.get().hasParsingError) {
            TapEnv.printlnOnTrace(10, "total time " + totalTapenadeTimer.elapsed() + " s");
            TapEnv.tapenadeExit(1);
        } else if (this.debug) {
            TapEnv.printlnOnTrace("job is completed: total time " + totalTapenadeTimer.elapsed() + " s");
        }
    }

    protected TapList<Unit> getTransformedSourceUnits(TapList<TapPair<Unit, TapList<Unit>>> differentiationAssociations) {
        TapList transformedUnits = null;
        while (differentiationAssociations != null) {
            transformedUnits = new TapList(((TapPair)differentiationAssociations.head).first, transformedUnits);
            differentiationAssociations = differentiationAssociations.tail;
        }
        return transformedUnits;
    }

    protected boolean analyzeFile() throws IOException {
        File tapHtmlDir;
        if (this.generateHTML && !(tapHtmlDir = new File(this.absDirectoryHtmlGen)).exists() && !new File(this.absDirectoryHtmlGen).mkdir()) {
            TapEnv.printlnOnTrace("Could not open output directory tapenadehtml, -html option ignored");
            this.generateHTML = false;
        }
        TapEnv.initializeSourceMessageCorrespondence();
        this.createCallGraph();
        if (this.origCallGraph() != null) {
            Chrono regenTimer;
            TapList<Unit> rootUnits;
            TapList<Unit> splittedUnits;
            TapList<Unit> unitsToDump;
            if (TapEnv.get().dumps && TapEnv.get().dumpFlowGraphs && this.dumpOutputStream != null) {
                TapEnv.pushOutputStream(this.dumpOutputStream);
                try {
                    boolean dumpAllUnitsOfCallGraph = TapEnv.get().dumpUnitNames == null || ((String)TapEnv.get().dumpUnitNames.head).equals("%all%");
                    unitsToDump = this.collectUnitsToDump(this.origCallGraph(), dumpAllUnitsOfCallGraph);
                    TapEnv.println();
                    TapEnv.print(" *** *** *** FLOW GRAPHS : *** *** ***" + System.lineSeparator());
                    this.origCallGraph().dumpAllFlowGraphs(unitsToDump, 2);
                }
                catch (IOException e) {
                    TapEnv.printlnOnTrace("OutputStream for dump broken");
                    this.dumpOutputStream = null;
                }
                TapEnv.popOutputStream();
            }
            if (TapEnv.get().dumps && this.dumpOutputStream != null && this.origCallGraph() != null) {
                TapEnv.pushOutputStream(this.dumpOutputStream);
                try {
                    boolean dumpAllUnitsOfCallGraph = TapEnv.get().dumpUnitNames == null || ((String)TapEnv.get().dumpUnitNames.head).equals("%all%");
                    unitsToDump = this.collectUnitsToDump(this.origCallGraph(), dumpAllUnitsOfCallGraph);
                    if (TapEnv.get().dumpSymbolTables) {
                        TapEnv.println();
                        TapEnv.print(" *** *** *** SYMBOL TABLES : *** *** ***" + System.lineSeparator());
                        TapEnv.resetSeenSymbolTables();
                        this.origCallGraph().dumpAllSymbolTables(unitsToDump, 2);
                    }
                    TapEnv.println();
                }
                catch (IOException e) {
                    TapEnv.printlnOnTrace("OutputStream for dump broken");
                    this.dumpOutputStream = null;
                }
                TapEnv.popOutputStream();
            }
            this.findRootUnits();
            if (!TapEnv.get().createStub && TapEnv.inputLanguage() != 5) {
                this.origCallGraph().prepareAnalyses(DiffRoot.collectUnits(this.diffRoots));
            }
            if ((splittedUnits = this.origCallGraph().getUnits(this.splittedUnitNames)) != null && splittedUnits.head == null) {
                TapList<Unit> rootUnits2 = DiffRoot.collectUnits(this.diffRoots);
                TapList<Unit> tapList = splittedUnits = rootUnits2 == null ? this.origCallGraph().sortedComputationalUnits() : Unit.allCalleesMulti(rootUnits2);
            }
            while (splittedUnits != null) {
                Unit unitToSplit = (Unit)splittedUnits.head;
                if (unitToSplit != null && unitToSplit.isStandard()) {
                    unitToSplit.directives = new TapList<Directive>(new Directive(12), unitToSplit.directives);
                    unitToSplit.maybeNoCheckpointed = true;
                }
                splittedUnits = splittedUnits.tail;
            }
            TapList<Unit> specActUnits = this.origCallGraph().getUnits(this.specializedActivityUnitNames);
            if (specActUnits != null && specActUnits.head == null) {
                rootUnits = DiffRoot.collectUnits(this.diffRoots);
                TapList<Unit> tapList = specActUnits = rootUnits == null ? this.origCallGraph().sortedComputationalUnits() : Unit.allCalleesMulti(rootUnits);
            }
            while (specActUnits != null) {
                Unit unitToSpecialize = (Unit)specActUnits.head;
                if (unitToSpecialize != null && unitToSpecialize.isStandard()) {
                    unitToSpecialize.directives = new TapList<Directive>(new Directive(27), unitToSpecialize.directives);
                }
                specActUnits = specActUnits.tail;
            }
            if (TapEnv.get().dumps && this.dumpOutputStream != null && this.origCallGraph() != null) {
                TapEnv.pushOutputStream(this.dumpOutputStream);
                try {
                    TapList<Unit> unitsToDump2 = this.collectUnitsToDump(this.origCallGraph(), true);
                    if (TapEnv.get().dumpCallGraph) {
                        TapEnv.println();
                        TapEnv.print(" *** *** *** CALL GRAPH " + this.origCallGraph().name() + " : *** *** ***" + System.lineSeparator());
                        CallGraph.dumpCompactCallGraph(unitsToDump2);
                    }
                    TapEnv.println();
                }
                catch (IOException e) {
                    TapEnv.printlnOnTrace("OutputStream for dump broken");
                    this.dumpOutputStream = null;
                }
                TapEnv.popOutputStream();
            }
            if (this.viewCallGraph) {
                GraphViewer.open();
                GraphViewer.view(this.origCallGraph());
            }
            if (!TapEnv.modeIsNoDiff()) {
                if (this.diffRoots == null) {
                    TapEnv.fileWarning(-1, null, "File: The code provided does not contain a top procedure");
                } else {
                    TapList<Unit> unitsToDump3;
                    rootUnits = DiffRoot.collectUnits(this.diffRoots);
                    ADActivityAnalyzer.runAnalysis(this.origCallGraph(), this.diffRoots, this.diffKind);
                    ReqExplicit.runAnalysis(this.origCallGraph(), this.diffRoots);
                    if (TapEnv.traceActivity() != null) {
                        TapList<Unit> allUnits = this.origCallGraph().sortedUnits();
                        TapEnv.pushOutputStream(TapEnv.get().traceOutputStream);
                        try {
                            while (allUnits != null) {
                                Unit oneUnit = (Unit)allUnits.head;
                                int[] unitPublicMap = new int[]{0, oneUnit.paramElemsNb()};
                                String unitPublicMapName = "[x" + oneUnit.rank() + ":a]";
                                TapList<ActivityPattern> activityPatterns = oneUnit.specificInfoAD;
                                TapEnv.print("  Resulting ActivityPattern(s) for Unit " + oneUnit + (activityPatterns != null ? ":" : ": none") + System.lineSeparator());
                                while (activityPatterns != null) {
                                    ActivityPattern ap = (ActivityPattern)activityPatterns.head;
                                    TapEnv.print("     " + ap + " called by {");
                                    TapList<ActivityPattern> callers = ap.callingPatterns();
                                    while (callers != null) {
                                        TapEnv.print(" @" + Integer.toHexString(((ActivityPattern)callers.head).hashCode()));
                                        callers = callers.tail;
                                    }
                                    TapEnv.print((ap.diffP() != null ? "} also a diff root: " + ap.diffP() : "}") + System.lineSeparator());
                                    TapEnv.print("       activity:");
                                    if (ap.callActivity() != null && ap.callActivity().isFalse(oneUnit.paramElemsNb())) {
                                        TapEnv.print("empty");
                                    } else {
                                        TapEnv.dumpBoolVector(ap.callActivity(), unitPublicMap, unitPublicMapName);
                                    }
                                    TapEnv.print("=>");
                                    if (ap.exitActivity() != null && ap.exitActivity().isFalse(oneUnit.paramElemsNb())) {
                                        TapEnv.print("empty");
                                    } else {
                                        TapEnv.dumpBoolVector(ap.exitActivity(), unitPublicMap, unitPublicMapName);
                                    }
                                    TapEnv.print((ap.isForcedActive() ? " forcedActive" : "") + (ap.isDontDiff() ? " dontDiff" : "") + System.lineSeparator());
                                    TapEnv.print("       ReqX:    ");
                                    if (ap.entryReqX() != null && ap.entryReqX().isFalse(oneUnit.paramElemsNb())) {
                                        TapEnv.print("empty");
                                    } else {
                                        TapEnv.dumpBoolVector(ap.entryReqX(), unitPublicMap, unitPublicMapName);
                                    }
                                    TapEnv.print("=>");
                                    if (ap.exitReqX() != null && ap.exitReqX().isFalse(oneUnit.paramElemsNb())) {
                                        TapEnv.print("empty");
                                    } else {
                                        TapEnv.dumpBoolVector(ap.exitReqX(), unitPublicMap, unitPublicMapName);
                                    }
                                    TapEnv.println();
                                    TapEnv.print("       AvlX:    ");
                                    if (ap.entryAvlX() != null && ap.entryAvlX().isFalse(oneUnit.paramElemsNb())) {
                                        TapEnv.print("empty");
                                    } else {
                                        TapEnv.dumpBoolVector(ap.entryAvlX(), unitPublicMap, unitPublicMapName);
                                    }
                                    TapEnv.print("=>");
                                    if (ap.exitAvlX() != null && ap.exitAvlX().isFalse(oneUnit.paramElemsNb())) {
                                        TapEnv.print("empty");
                                    } else {
                                        TapEnv.dumpBoolVector(ap.exitAvlX(), unitPublicMap, unitPublicMapName);
                                    }
                                    TapEnv.println();
                                    activityPatterns = activityPatterns.tail;
                                }
                                allUnits = allUnits.tail;
                            }
                        }
                        catch (IOException e) {
                            TapEnv.printlnOnTrace("OutputStream for trace broken");
                        }
                        TapEnv.popOutputStream();
                    }
                    DepsAnalyzer.runAnalysis(this.origCallGraph(), rootUnits);
                    if (TapEnv.removeDeadPrimal()) {
                        DiffLivenessAnalyzer.runAnalysis(this.origCallGraph(), rootUnits);
                    } else {
                        TapEnv.printlnOnTrace("Diff-liveness analysis turned off");
                    }
                    if (TapEnv.mustAdjoint()) {
                        ADTBRAnalyzer.runAnalysis(this.origCallGraph(), rootUnits);
                    }
                    if (TapEnv.get().dumps && this.dumpOutputStream != null && TapEnv.get().dumpZones) {
                        TapEnv.pushOutputStream(this.dumpOutputStream);
                        try {
                            TapEnv.println();
                            TapEnv.print(" *** *** *** ZONES: *** *** ***" + System.lineSeparator());
                            TapEnv.println();
                            boolean dumpAllUnits = TapEnv.get().dumpUnitNames == null || ((String)TapEnv.get().dumpUnitNames.head).equals("%all%");
                            unitsToDump3 = this.collectUnitsToDump(this.origCallGraph(), dumpAllUnits);
                            TapList<Object> toSTChainRks = new TapList<Object>(null, null);
                            while (unitsToDump3 != null) {
                                Unit oneUnit = (Unit)unitsToDump3.head;
                                TapList<SymbolTable> unitSymbolTables = oneUnit.symbolTablesBottomUp();
                                while (unitSymbolTables != null) {
                                    SymbolTable oneSymbolTable = (SymbolTable)unitSymbolTables.head;
                                    this.addIntoSTChainRks(oneSymbolTable, toSTChainRks, null);
                                    unitSymbolTables = unitSymbolTables.tail;
                                }
                                unitsToDump3 = unitsToDump3.tail;
                            }
                            toSTChainRks = TapList.nreverse(toSTChainRks.tail);
                            while (toSTChainRks != null) {
                                TapPair stInfo = (TapPair)toSTChainRks.head;
                                SymbolTable thisSymbolTable = (SymbolTable)stInfo.first;
                                String stRanks = this.stRanksBuildStr(new TapIntList(thisSymbolTable.rank(), (TapIntList)stInfo.second));
                                Unit thisUnit = thisSymbolTable.unit;
                                if (thisUnit != null && thisUnit.publicSymbolTable() == thisSymbolTable) {
                                    thisUnit.dumpExternalZones();
                                    thisUnit.dumpSideEffectZones();
                                }
                                thisSymbolTable.dumpDeclaredZones(stRanks);
                                toSTChainRks = toSTChainRks.tail;
                            }
                            TapEnv.println();
                        }
                        catch (IOException e) {
                            TapEnv.printlnOnTrace("OutputStream for dump broken");
                            this.dumpOutputStream = null;
                        }
                        TapEnv.popOutputStream();
                    }
                    if (TapEnv.get().dumps && this.dumpOutputStream != null && TapEnv.get().dumpDataFlow) {
                        TapEnv.pushOutputStream(this.dumpOutputStream);
                        try {
                            boolean dumpAllUnits = TapEnv.get().dumpUnitNames == null || ((String)TapEnv.get().dumpUnitNames.head).equals("%all%");
                            unitsToDump3 = this.collectUnitsToDump(this.origCallGraph(), dumpAllUnits);
                            TapEnv.println();
                            TapEnv.print(" *** *** *** DATA FLOW INFO: *** *** ***" + System.lineSeparator());
                            TapEnv.println();
                            this.origCallGraph().dumpAllDataFlows(unitsToDump3);
                            TapEnv.println();
                        }
                        catch (IOException e) {
                            TapEnv.printlnOnTrace("OutputStream for dump broken");
                            this.dumpOutputStream = null;
                        }
                        TapEnv.popOutputStream();
                    }
                    this.setDiffCallGraph(CallGraphDifferentiator.run(this.origCallGraph(), rootUnits, this.suffixes));
                    if (this.diffCallGraph() != null) {
                        this.diffCallGraph().numberSymbolTables();
                    }
                    if (TapEnv.get().dumps && this.dumpOutputStream != null && this.diffCallGraph() != null) {
                        TapEnv.pushOutputStream(this.dumpOutputStream);
                        try {
                            String modeName = TapEnv.modeIsOverloading() ? "ADOLC" : (TapEnv.mustTangent() ? (TapEnv.mustAdjoint() ? "TANGENT PLUS ADJOINT" : "TANGENT") : (TapEnv.mustAdjoint() ? "ADJOINT" : "unknown"));
                            TapEnv.println();
                            TapEnv.print("=============== " + modeName + " MODE DIFFERENTIATION ===============" + System.lineSeparator());
                            boolean dumpAllUnitsOfCallGraph = TapEnv.get().dumpUnitNames == null || ((String)TapEnv.get().dumpUnitNames.head).equals("%all%");
                            TapList<Unit> unitsToDump4 = this.collectUnitsToDump(this.diffCallGraph(), dumpAllUnitsOfCallGraph);
                            if (TapEnv.get().dumpDiffSymbolTables) {
                                TapEnv.println();
                                TapEnv.print(" *** *** *** DIFF SYMBOL TABLES : *** *** ***" + System.lineSeparator());
                                TapEnv.resetSeenSymbolTables();
                                this.diffCallGraph().dumpAllSymbolTables(unitsToDump4, 2);
                            }
                            if (TapEnv.get().dumpDiffFlowGraphs) {
                                TapEnv.println();
                                TapEnv.print(" *** *** *** DIFF FLOW GRAPHS : *** *** ***" + System.lineSeparator());
                                this.diffCallGraph().dumpAllFlowGraphs(unitsToDump4, 2);
                            }
                            TapEnv.println();
                        }
                        catch (IOException e) {
                            TapEnv.printlnOnTrace("OutputStream for dump broken");
                            this.dumpOutputStream = null;
                        }
                        TapEnv.popOutputStream();
                    }
                    if (TapEnv.get().profile) {
                        for (Unit unit : this.diffCallGraph().units()) {
                            if (unit.allBlocks() == null) continue;
                            for (Block block : unit.allBlocks()) {
                                if (block.instructions == null) continue;
                                for (Instruction inst : block.instructions) {
                                    if (inst.tree.opCode() != 30 || ILUtils.getCalledNameString(inst.tree).toUpperCase().startsWith("PROFILE")) continue;
                                    inst.addPreComments("$AD LINE " + ILUtils.getLineNumber(inst.tree));
                                }
                            }
                        }
                    }
                }
            }
            if (this.generateAST) {
                this.fileILNames = new PrintWriter(Files.newOutputStream(Paths.get(this.outputDirectory + "generatedIL.unitNames", new String[0]), new OpenOption[0]));
            }
            TapEnv.get().srcUnitsToTraceInTreeGen = this.origCallGraph().getUnits(TapEnv.get().traceTreeGenUnitNames);
            Unit topUnit = this.origCallGraph().sortedUnit(0);
            int targetLanguageCallDirection = 1;
            if (topUnit == null || topUnit.isCorMore() || TapEnv.inputLanguage() == 100) {
                targetLanguageCallDirection = -1;
            }
            ToBool existGlobalDeclarations = new ToBool(false);
            if (TapEnv.modeIsNoDiff() || this.generateHTML || this.showMessagesInFile) {
                regenTimer = new Chrono();
                this.outputCallGraph(this.origCallGraph(), this.outputDirectory, this.absDirectoryHtmlGen, "", existGlobalDeclarations, targetLanguageCallDirection, true, true);
                TapEnv.printlnOnTrace(10, "@@ Source Regeneration total time " + regenTimer.elapsed() + " s");
            }
            if (!TapEnv.modeIsNoDiff() && this.diffCallGraph() != null) {
                regenTimer = new Chrono();
                this.outputCallGraph(this.diffCallGraph(), this.outputDirectory, this.absDirectoryHtmlGen, TapEnv.get().diffFileSuffix, existGlobalDeclarations, targetLanguageCallDirection, false, false);
                TapEnv.printlnOnTrace(10, "@@ Diff Regeneration total time " + regenTimer.elapsed() + " s");
            }
            if (this.generateHTML) {
                new CallGraphDisplayer(this.origCallGraph(), this.absDirectoryHtmlGen + "callgraph.html", existGlobalDeclarations.get(), this.outputFileName, this.outputHtmlDirectory == null ? "" : this.outputHtmlDirectory, TapEnv.get().preprocessFileSuffix, "Original call graph", "origFile").display();
                new CallGraphDisplayer(this.diffCallGraph(), this.absDirectoryHtmlGen + "callgraphdiff.html", existGlobalDeclarations.get(), this.outputFileName, this.outputHtmlDirectory == null ? "" : this.outputHtmlDirectory, TapEnv.get().diffFileSuffix, "Differentiated call graph", "diffFile").display();
            }
            if (this.generateAST) {
                this.fileILNames.flush();
                this.fileILNames.close();
            }
            return existGlobalDeclarations.get();
        }
        return false;
    }

    private void addIntoSTChainRks(SymbolTable symbolTable, TapList<TapPair<SymbolTable, TapIntList>> toSTChainRks, TapIntList ranks) {
        while (toSTChainRks.tail != null && !symbolTable.nestedIn((SymbolTable)((TapPair)toSTChainRks.tail.head).first)) {
            toSTChainRks = toSTChainRks.tail;
        }
        if (toSTChainRks.tail == null || symbolTable != ((TapPair)toSTChainRks.tail.head).first) {
            toSTChainRks = toSTChainRks.placdl(new TapPair<SymbolTable, TapIntList>(symbolTable, ranks));
            ranks = new TapIntList(symbolTable.rank(), ranks);
        } else {
            ((TapPair)toSTChainRks.tail.head).second = TapIntList.quickUnion((TapIntList)((TapPair)toSTChainRks.tail.head).second, ranks);
        }
        if (symbolTable.basisSymbolTable() != null) {
            this.addIntoSTChainRks(symbolTable.basisSymbolTable(), toSTChainRks, ranks);
        }
    }

    private String stRanksBuildStr(TapIntList ranks) {
        StringBuilder result = new StringBuilder();
        while (ranks != null) {
            result.append('d').append(ranks.head);
            ranks = ranks.tail;
        }
        return result.toString();
    }

    private TapList<Unit> collectUnitsToDump(CallGraph callGraph, boolean dumpAllUnits) {
        if (dumpAllUnits) {
            TapList<Object> hdToDump;
            TapList<Unit> allUnitsList = callGraph.sortedUnits();
            if (allUnitsList == null) {
                allUnitsList = callGraph.units();
            }
            TapList<Object> tlToDump = hdToDump = new TapList<Object>(null, null);
            while (allUnitsList != null) {
                Unit unit = (Unit)allUnitsList.head;
                if (!MPIcallInfo.isMessagePassingFunction(unit.name, unit.language()) && !unit.inStdCIncludeFile() && (unit.isTranslationUnit() || unit.isStandard() || unit.isExternal() || unit.isModule() || unit.isInterface() || unit.isClass())) {
                    tlToDump = tlToDump.placdl(unit);
                }
                allUnitsList = allUnitsList.tail;
            }
            return hdToDump.tail;
        }
        TapList<Unit> selectedOrigUnits = this.origCallGraph().getUnits(TapEnv.get().dumpUnitNames);
        if (callGraph == this.origCallGraph()) {
            return selectedOrigUnits;
        }
        TapList diffUnitsToDump = null;
        while (selectedOrigUnits != null) {
            TapList<Unit> thisUnitDiffs = Unit.removePhantomPackages((TapList)TapList.cassq(selectedOrigUnits.head, this.diffCallGraph().backAssociations));
            while (thisUnitDiffs != null) {
                diffUnitsToDump = new TapList(thisUnitDiffs.head, diffUnitsToDump);
                thisUnitDiffs = thisUnitDiffs.tail;
            }
            selectedOrigUnits = selectedOrigUnits.tail;
        }
        return diffUnitsToDump;
    }

    private void createCallGraph() throws IOException {
        Chrono cgBuildTimer = new Chrono();
        TapEnv.get().setOrigCallGraph(new CallGraph("Input CallGraph"));
        TapEnv.setRelatedUnit(null);
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("windows")) {
            osName = "windows";
        } else if (osName.startsWith("mac")) {
            osName = "mac";
        }
        parserDirectory = osName;
        if (osName.equals("linux") || osName.equals("mac") || osName.equals("windows")) {
            int[] languages;
            int lang;
            if (this.inputLanguage != -1) {
                lang = this.inputLanguage;
                languages = new int[2];
                if (lang == 4 || lang == 0 && TapEnv.outputLanguage() == 4) {
                    languages[1] = lang;
                    TapEnv.setLanguages(1, 4);
                } else if (lang == 5 || lang == 0 && TapEnv.outputLanguage() == 5) {
                    languages[1] = lang;
                    TapEnv.setLanguages(1, 5);
                } else {
                    languages[0] = lang;
                    TapEnv.setLanguages(0, lang);
                }
            } else {
                languages = this.getInputLanguageOfFiles(false, this.outputDirectory, this.inputFileNames);
                if (languages[0] == -1) {
                    lang = languages[1];
                    TapEnv.setLanguages(1, lang);
                } else if (languages[1] == -1) {
                    lang = languages[0];
                    TapEnv.setLanguages(0, lang);
                } else {
                    lang = 100;
                    TapEnv.setLanguages(0, languages[0]);
                    TapEnv.setLanguages(1, languages[1]);
                }
            }
            if (lang == 4 || lang == 0 && TapEnv.outputLanguage() == 4) {
                TapEnv.toolWarning(-1, "(DD99) Warning: Some features of C are not yet supported");
            } else if (lang == 5 || lang == 0 && TapEnv.outputLanguage() == 5) {
                TapEnv.toolWarning(-1, "(DD99) Warning: Many features of C++ are not yet supported");
            } else if (lang == 100) {
                TapEnv.toolWarning(-1, "(DD999) Warning: mixed language differentiation not yet fully implemented");
            }
            TapEnv.setInputLanguage(lang);
            this.origCallGraph().createRootSymbolTables();
            FortranStuff.initFortranSymbolTable(this.origCallGraph().fortranRootSymbolTable());
            CStuff.initCSymbolTable(this.origCallGraph().cRootSymbolTable());
            CStuff.initCSymbolTable(this.origCallGraph().cPlusPlusRootSymbolTable());
            if (!TapEnv.get().stripPrimalModules && lang != 4) {
                TapEnv.addOptionsString(" no!StripPrimalModules");
            }
            if (lang == 100) {
                TapEnv.setInputLanguage(languages[0]);
                this.loadGeneralLibraries(languages[0]);
                TapEnv.setInputLanguage(languages[1]);
                this.loadGeneralLibraries(languages[1]);
            } else if (lang == 0) {
                this.loadGeneralLibraries(TapEnv.outputLanguage());
            } else {
                this.loadGeneralLibraries(lang);
            }
            TapEnv.setInputLanguage(lang);
            TapEnv.setIncludeDirList(this.includeDirList);
            Tapenade.parseFiles(false, this.outputDirectory, this.inputFileNames, this.origCallGraph(), this.includeDirList.tail, this.inputLanguage, this.parseOpenMP);
            if (TapEnv.inputLanguage() == 0) {
                TapEnv.setInputLanguage(TapEnv.outputLanguage());
            }
        } else {
            TapEnv.toolError("No parser for " + osName);
        }
        TapEnv.printlnOnTrace(10, "@@ Call Graph building total time " + cgBuildTimer.elapsed() + " s");
        Chrono typeCheckTimer = new Chrono();
        this.origCallGraph().terminateTypesAndZones();
        this.origCallGraph().numberSymbolTables();
        TapEnv.printlnOnTrace(10, "@@ Type Checking total time " + typeCheckTimer.elapsed() + " s");
    }

    private void loadGeneralLibraries(int lang) {
        if (this.stdGeneralLibraryDirectory != null) {
            if (lang == 4) {
                new GeneralLibReader(this.stdGeneralLibraryDirectory, "GeneralLib", this.origCallGraph(), 4);
                new GeneralLibReader(this.stdGeneralLibraryDirectory, "CGeneralLib", this.origCallGraph(), 4);
            } else if (lang == 5) {
                new GeneralLibReader(this.stdGeneralLibraryDirectory, "GeneralLib", this.origCallGraph(), 5);
                new GeneralLibReader(this.stdGeneralLibraryDirectory, "CGeneralLib", this.origCallGraph(), 5);
            } else {
                if (!this.fortranLibraryLoaded) {
                    new GeneralLibReader(this.stdGeneralLibraryDirectory, "GeneralLib", this.origCallGraph(), 1);
                    new GeneralLibReader(this.stdGeneralLibraryDirectory, "F77GeneralLib", this.origCallGraph(), 1);
                    this.fortranLibraryLoaded = true;
                }
                if (lang == 2 || lang == 3) {
                    new GeneralLibReader(this.stdGeneralLibraryDirectory, "F95GeneralLib", this.origCallGraph(), lang);
                }
            }
        }
        StringTokenizer stLib = new StringTokenizer(this.libraryFileNames);
        while (stLib.hasMoreTokens()) {
            String libraryFileName = stLib.nextToken();
            new GeneralLibReader("", libraryFileName, this.origCallGraph(), lang);
        }
    }

    private int[] getInputLanguageOfFiles(boolean addDirectory, String directory, String[] localInputFileNames) {
        int result = -1;
        int[] results = new int[]{-1, -1};
        for (String fileName : localInputFileNames) {
            int type;
            int index = fileName.lastIndexOf(File.separator);
            String currentDirectory = "";
            if (index > 0) {
                currentDirectory = fileName.substring(0, index + 1);
            }
            TapEnv.setCurrentDirectory(currentDirectory);
            String localInputFileName = addDirectory ? directory + fileName : fileName;
            int n = type = this.inputLanguage == -1 ? Tapenade.getLanguageOfFile(localInputFileName) : this.inputLanguage;
            if (type == 99) {
                int[] types = this.getInputLanguageOfFiles(true, directory, Tapenade.extractFiles(directory, localInputFileName));
                results = types;
            }
            if (result == -1) {
                result = type;
                if (type == 4) {
                    results[1] = result;
                    continue;
                }
                results[0] = result;
                continue;
            }
            if (result == type || type == 98) continue;
            if (type != 4 && result != 4) {
                results[0] = result = Tapenade.getFortranDialect(type, result);
                continue;
            }
            if (type == 4) {
                results[1] = result = 4;
                continue;
            }
            results[0] = result = type;
        }
        return results;
    }

    private void checkParserFileSeparator() {
        if (TapEnv.parserFileSeparator() == null) {
            if (File.separator.equals("\\")) {
                String path = System.getenv("PWD");
                if (path != null && path.startsWith("/")) {
                    TapEnv.setParserFileSeparator("/");
                } else {
                    TapEnv.setParserFileSeparator(File.separator);
                }
            } else {
                TapEnv.setParserFileSeparator(File.separator);
            }
        }
    }

    private void findRootUnits() {
        TapList<DiffRoot> inDiffRoots = this.diffRoots = new TapList<DiffRoot>(null, this.diffRoots);
        while (inDiffRoots.tail != null) {
            DiffRoot diffRoot = (DiffRoot)inDiffRoots.tail.head;
            Unit unit = this.origCallGraph().getUnit(diffRoot.unitPathName());
            if (unit == null) {
                TapEnv.commandWarning(10, "unit " + DiffRoot.rebuildIdentifier(diffRoot.unitPathName()) + ": not found");
            } else if (!unit.isStandard() && !unit.isInterface()) {
                TapEnv.commandWarning(-1, "Can't differentiate " + unit.name + ": is not a standard procedure");
                unit = null;
            }
            if (unit != null) {
                diffRoot.setUnit(unit);
                inDiffRoots = inDiffRoots.tail;
                continue;
            }
            inDiffRoots.tail = inDiffRoots.tail.tail;
        }
        if (this.diffRoots.tail == null && this.origCallGraph().nbUnits() > 0) {
            Unit firstUnit = null;
            Unit firstModule = null;
            Unit mainUnit = null;
            for (int i = 0; i < this.origCallGraph().nbUnits() && firstUnit == null; ++i) {
                Unit uniti = this.origCallGraph().sortedUnit(i);
                if (uniti == null) continue;
                if (uniti.isStandard()) {
                    if (uniti == this.origCallGraph().getMainUnit()) {
                        mainUnit = uniti;
                        continue;
                    }
                    firstUnit = uniti;
                    continue;
                }
                if (!uniti.isModule()) continue;
                firstModule = uniti;
            }
            if (firstUnit == null) {
                firstUnit = mainUnit;
            }
            if (!TapEnv.modeIsNoDiff()) {
                if (firstUnit == null) {
                    TapEnv.commandWarning(-1, "No root unit to differentiate");
                } else {
                    String unitStyle = "procedure";
                    if (firstUnit.isFortran()) {
                        unitStyle = "subroutine";
                    }
                    TapEnv.commandWarning(-1, "Took " + unitStyle + " " + firstUnit.name + " as default differentiation root");
                }
            } else if (firstUnit == null) {
                firstUnit = firstModule;
            }
            if (firstUnit != null) {
                DiffRoot defaultRoot = new DiffRoot(firstUnit, null, null);
                DiffPattern defaultPattern = new DiffPattern(null, null, null);
                defaultRoot.appendDiffPattern(defaultPattern);
                if (this.waitingInVars != null) {
                    defaultPattern.setIndepsPathNames(this.waitingInVars.tail);
                    this.waitingInVars = null;
                }
                if (this.waitingOutVars != null) {
                    defaultPattern.setDepsPathNames(this.waitingOutVars.tail);
                    this.waitingOutVars = null;
                }
                this.diffRoots.placdl(defaultRoot);
            }
        }
        this.diffRoots = this.diffRoots.tail;
    }

    private void forceSortedOrderInBlocks(TapList<Instruction> instructions) {
        while (instructions != null) {
            Instruction i1 = (Instruction)instructions.head;
            Unit u1 = i1.isUnitDefinitionStub();
            if (u1 != null) {
                Instruction iLight = i1;
                Unit uLight = u1;
                TapList rest = instructions.tail;
                while (rest != null) {
                    Instruction i2 = (Instruction)rest.head;
                    Unit u2 = i2.isUnitDefinitionStub();
                    if (u2 != null && uLight.rank() > u2.rank()) {
                        iLight = i2;
                        uLight = u2;
                    }
                    rest = rest.tail;
                }
                if (iLight != i1) {
                    Tree tmpTree = i1.tree;
                    i1.tree = iLight.tree;
                    iLight.tree = tmpTree;
                }
            }
            instructions = instructions.tail;
        }
    }

    private void outputCallGraph(CallGraph callGraph, String fileDirectory, String htmlDirectory, String diffFileSuffix, ToBool existsGlobalDeclarationsFile, int callDirection, boolean keepAllUnits, boolean isOrigCallGraph) throws IOException {
        Tree firstFileTree;
        TapList<Unit> fileUnits;
        Tree globalFileTree;
        boolean needsGlobalDecls;
        boolean moreThanOneFile;
        callGraph.sortUnits(keepAllUnits, callDirection, -1, 1);
        if (isOrigCallGraph) {
            TapEnv.get().srcUnitsToTraceInTreeGen = callGraph.getUnits(TapEnv.get().traceTreeGenUnitNames);
        }
        TapList<Unit> topUs = callGraph.topUnits();
        while (topUs != null) {
            if (!((Unit)topUs.head).isCorMore()) {
                TapList<Block> allBs = ((Unit)topUs.head).allBlocks();
                while (allBs != null) {
                    this.forceSortedOrderInBlocks(((Block)allBs.head).instructions);
                    allBs = allBs.tail;
                }
            }
            topUs = topUs.tail;
        }
        callGraph.decideForwardDeclarations();
        TapList<Object> toFutureFiles = new TapList<Object>(null, null);
        TapList<Object> includesNameTree = new TapList<Object>(null, null);
        TapEnv.setRelatedUnit(null);
        int lang = TapEnv.getInputLanguage();
        Unit topUnit = null;
        if (callGraph.topUnits() != null) {
            topUnit = lang == 1 ? (Unit)callGraph.topUnits().head : TapList.last(callGraph.topUnits());
        }
        if (TapEnv.outputLanguage() != -1) {
            lang = TapEnv.outputLanguage();
            if (TapEnv.outputLanguage() == 100 && this.outputFileName != null) {
                if (topUnit != null) {
                    lang = topUnit.language();
                    TapEnv.setOutputLanguage(lang);
                } else {
                    lang = TapEnv.getInputLanguage();
                }
            }
        } else {
            lang = topUnit != null ? topUnit.language() : -1;
        }
        Tree mainServletFileTree = null;
        Tree otherServletFileTree = null;
        int otherServletFileLanguage = -1;
        if (TapEnv.forServlet) {
            mainServletFileTree = ILUtils.build(26);
            TreeGen.addHeader(mainServletFileTree, lang, "Tapenade 3.16 (master) -  9 Oct 2020 17:47");
            otherServletFileTree = ILUtils.build(26);
            if (lang == 4 || lang == 100) {
                otherServletFileLanguage = TapEnv.languages(0);
                lang = TapEnv.languages(1);
            } else {
                otherServletFileLanguage = 4;
            }
        }
        TreeGen.cleanBeforeGenerate(callGraph);
        if (this.outputFileName != null) {
            TapPair[] conflictingLocals = new TapPair[]{new TapPair<Integer, Object>(0, null), new TapPair<Integer, Object>(0, null)};
            this.collectConflictingLocals(this.origCallGraph(), conflictingLocals);
            if ((Integer)conflictingLocals[0].first > 1 && conflictingLocals[0].second != null) {
                TapEnv.commandWarning(-1, "Please remove command-line option -o because Fortran symbols:" + conflictingLocals[0].second + " are local to their translation unit");
            }
            if ((Integer)conflictingLocals[1].first > 1 && conflictingLocals[1].second != null) {
                TapEnv.commandWarning(-1, "Please remove command-line option -o because C symbols:" + conflictingLocals[1].second + " are local to their translation unit");
            }
            if (TapEnv.associationByAddress()) {
                TapEnv.commandWarning(-1, "Please remove command-line option -o with association byaddress");
            }
        }
        String globalDeclsIncludeName = null;
        boolean bl = moreThanOneFile = TapList.length(callGraph.getTranslationUnitSymbolTables()) > 1;
        if (moreThanOneFile && this.outputFileName == null && (needsGlobalDecls = TreeGen.generateGlobalDeclarations(callGraph, includesNameTree, null, globalFileTree = ILUtils.build(26), lang, false))) {
            TreeGen.addHeader(globalFileTree, lang, "Tapenade 3.16 (master) -  9 Oct 2020 17:47");
            existsGlobalDeclarationsFile.set(true);
            int globalLang = lang;
            if (lang == 100) {
                globalLang = 4;
            }
            globalDeclsIncludeName = "GlobalDeclarations";
            if (!isOrigCallGraph) {
                globalDeclsIncludeName = TapEnv.extendStringWithSuffix(globalDeclsIncludeName, diffFileSuffix);
            }
            if (TapEnv.modeIsNoDiff()) {
                globalDeclsIncludeName = TapEnv.extendStringWithSuffix(globalDeclsIncludeName, TapEnv.get().preprocessFileSuffix);
            }
            toFutureFiles.placdl(new FutureFile(globalFileTree, globalLang, fileDirectory + globalDeclsIncludeName, globalLang, null, false));
            if (TapEnv.forServlet) {
                int nbNewSons = globalFileTree.length();
                for (int i = 1; i <= nbNewSons; ++i) {
                    assert (mainServletFileTree != null);
                    mainServletFileTree.addChild(ILUtils.copy(globalFileTree.down(i)), -1);
                }
            }
        }
        TapList<Unit> tapList = fileUnits = this.outputFileName != null ? callGraph.orderedFiles() : callGraph.topUnits();
        while (fileUnits != null) {
            Unit fileUnit = (Unit)fileUnits.head;
            if (fileUnit.isTranslationUnit() && !fileUnit.isPredefinedModuleOrTranslationUnit()) {
                TapEnv.setRelatedUnit(fileUnit);
                if (TapEnv.outputLanguage() != -1 && TapEnv.outputLanguage() != 100) {
                    fileUnit.setLanguage(TapEnv.outputLanguage());
                }
                Tree treeForServlet = TapEnv.forServlet ? (fileUnit.sameLanguage(lang) ? mainServletFileTree : otherServletFileTree) : null;
                SymbolTable tuSymbolTable = fileUnit.publicSymbolTable();
                String futureFileName = this.outputFileName;
                if (futureFileName == null) {
                    futureFileName = TapEnv.stripPath(fileUnit.name);
                    futureFileName = TapEnv.stripLanguageExtension(futureFileName);
                }
                String differentiationSuffix = isOrigCallGraph ? TapEnv.get().preprocessFileSuffix : TapEnv.get().diffFileSuffix;
                futureFileName = TapEnv.extendStringWithSuffix(futureFileName, differentiationSuffix);
                this.prepareFutureFile(futureFileName, fileUnit, tuSymbolTable, globalDeclsIncludeName, includesNameTree, treeForServlet, toFutureFiles, fileDirectory, callGraph, this.splitOutputFiles);
                if (this.splitOutputFiles) {
                    TapList<Unit> subUnits = fileUnit.lowerLevelUnits;
                    while (subUnits != null) {
                        Unit subUnit = (Unit)subUnits.head;
                        futureFileName = subUnit.name;
                        TapEnv.setRelatedUnit(subUnit);
                        this.prepareFutureFile(futureFileName, subUnit, null, globalDeclsIncludeName, includesNameTree, treeForServlet, toFutureFiles, fileDirectory, callGraph, false);
                        subUnits = subUnits.tail;
                    }
                }
            }
            fileUnits = fileUnits.tail;
        }
        TapEnv.setRelatedUnit(null);
        if (toFutureFiles.tail != null && (firstFileTree = ((FutureFile)toFutureFiles.tail.head).tree) != null) {
            ILUtils.adoptOrAppendComments(callGraph.topPreComments, "preComments", firstFileTree);
            ILUtils.adoptOrAppendComments(callGraph.topPostComments, "postComments", firstFileTree);
            ILUtils.adoptOrAppendComments(callGraph.topPreCommentsBlock, "preCommentsBlock", firstFileTree);
            ILUtils.adoptOrAppendComments(callGraph.topPostCommentsBlock, "postCommentsBlock", firstFileTree);
        }
        if (this.outputFileName == null && TapEnv.forServlet) {
            String oFileName = TapEnv.extendStringWithSuffix(Tapenade.rmFilenameFortranExtension(this.inputFileName), TapEnv.get().diffFileSuffix) + "-all";
            String strippedFileName = Tapenade.rmFilenameFortranExtension(TapEnv.stripPath(oFileName));
            if (TapEnv.modeIsNoDiff()) {
                strippedFileName = TapEnv.extendStringWithSuffix(strippedFileName, TapEnv.get().preprocessFileSuffix);
            }
            if (!TapEnv.isDistribVersion()) {
                TapEnv.printlnOnTrace(7, "@@ Creating " + fileDirectory + strippedFileName + TapEnv.outputExtension(lang));
            }
            toFutureFiles.placdl(new FutureFile(mainServletFileTree, lang, fileDirectory + strippedFileName, lang, null, false));
            if (!TapEnv.isDistribVersion()) {
                TapEnv.printlnOnTrace(7, "@@ Creating " + fileDirectory + strippedFileName + TapEnv.outputExtension(otherServletFileLanguage));
            }
            toFutureFiles.placdl(new FutureFile(otherServletFileTree, otherServletFileLanguage, fileDirectory + strippedFileName, lang, null, false));
        }
        includesNameTree = includesNameTree.tail;
        while (includesNameTree != null) {
            TapTriplet include = (TapTriplet)includesNameTree.head;
            String includeName = ((Tree)include.first).stringValue();
            int includeLang = (Integer)include.third;
            if (TapEnv.isDiffIncludeFileName(includeName) && (!isOrigCallGraph || TapEnv.modeIsNoDiff())) {
                if (includeLang == 4 || includeLang == 100) {
                    if (includeName.startsWith("\"")) {
                        includeName = includeName.substring(1);
                    }
                    if (includeName.endsWith("\"")) {
                        includeName = includeName.substring(0, includeName.length() - 1);
                    }
                }
                int index = includeName.indexOf(File.separator);
                String includeDirectory = fileDirectory;
                if (index >= 0) {
                    includeName = TapEnv.stripPath(includeName);
                    includeDirectory = fileDirectory;
                }
                if (!this.generateHTML || !isOrigCallGraph) {
                    TapEnv.printlnOnTrace(7, "@@ Creating " + includeDirectory + includeName);
                }
                toFutureFiles.placdl(new FutureFile((Tree)include.second, includeLang, includeDirectory + includeName, includeLang, null, true));
            }
            includesNameTree = includesNameTree.tail;
        }
        TapList futureFiles = toFutureFiles.tail;
        StringBuilder allCreatedFiles = new StringBuilder();
        while (futureFiles != null) {
            FutureFile futureFile = (FutureFile)futureFiles.head;
            if (futureFile.tree != null && futureFile.tree.length() > 0) {
                TextPrinter textPrinter;
                if (this.generateHTML && !futureFile.isIncludeFile) {
                    String createdFile = htmlDirectory + TapEnv.stripPath(futureFile.fileName) + TapEnv.outputExtension(futureFile.language) + ".html";
                    allCreatedFiles.insert(0, createdFile + " ");
                    try {
                        String completeOppositeHtmlFileName = null;
                        if (futureFile.oppositeHtmlFileName != null) {
                            completeOppositeHtmlFileName = futureFile.oppositeHtmlFileName + TapEnv.outputExtension(futureFile.oppositeHtmlLanguage) + ".html";
                        }
                        HtmlPrinter htmlPrinter = new HtmlPrinter(createdFile, completeOppositeHtmlFileName, isOrigCallGraph ? "diffFile" : "origFile", this.cssDir);
                        htmlPrinter.initFile(futureFile.language);
                        Decompiler languagePrinter = null;
                        if (TapEnv.isFortran(futureFile.language)) {
                            languagePrinter = new FortranDecompiler(htmlPrinter, this.htmlMessageFileName);
                        } else if (TapEnv.isCorMore(futureFile.language)) {
                            languagePrinter = new CDecompiler(htmlPrinter, this.htmlMessageFileName);
                        }
                        if (languagePrinter != null) {
                            languagePrinter.decompileTree(futureFile.tree, futureFile.language, false, this.showMessagesInFile);
                            languagePrinter.newLine(0);
                        }
                        htmlPrinter.closeFile();
                    }
                    catch (FileNotFoundException e) {
                        TapEnv.printlnOnTrace("Could not open output file " + createdFile + " for html output");
                    }
                }
                if (this.generateLanguage && (!isOrigCallGraph || TapEnv.modeIsNoDiff() || this.showMessagesInFile)) {
                    String createdFile = futureFile.fileName;
                    if (!futureFile.isIncludeFile) {
                        createdFile = createdFile + TapEnv.outputExtension(futureFile.language);
                    }
                    allCreatedFiles.insert(0, createdFile + " ");
                    try {
                        textPrinter = new TextPrinter(createdFile);
                        textPrinter.initFile(futureFile.language);
                        Decompiler languagePrinter = null;
                        if (TapEnv.isFortran(futureFile.language)) {
                            languagePrinter = new FortranDecompiler(textPrinter, null);
                        } else if (TapEnv.isCorMore(futureFile.language)) {
                            languagePrinter = new CDecompiler(textPrinter, null);
                        }
                        if (languagePrinter != null) {
                            if (TapEnv.isCorMore(futureFile.language) && futureFile.isIncludeFile) {
                                String includeShortName = TapEnv.stripPath(futureFile.fileName);
                                if (includeShortName.contains(".")) {
                                    includeShortName = includeShortName.substring(0, includeShortName.indexOf(46));
                                }
                                includeShortName = includeShortName + "_loaded";
                                includeShortName = includeShortName.toUpperCase();
                                textPrinter.printText("#ifndef " + includeShortName, "plain");
                                languagePrinter.newLine(0);
                                textPrinter.printText("#define " + includeShortName, "plain");
                                languagePrinter.newLine(0);
                            }
                            languagePrinter.decompileTree(futureFile.tree, futureFile.language, futureFile.isIncludeFile, this.showMessagesInFile);
                            if (TapEnv.isCorMore(futureFile.language) && futureFile.isIncludeFile) {
                                languagePrinter.newLine(0);
                                textPrinter.printText("#endif", "plain");
                            }
                            languagePrinter.newLine(0);
                            if (TapEnv.isFortran(futureFile.language)) {
                                languagePrinter.newLine(0);
                            }
                        }
                        textPrinter.closeFile();
                    }
                    catch (FileNotFoundException e) {
                        TapEnv.printlnOnTrace("Could not open output file " + createdFile + " for file output");
                    }
                }
                if (this.generateAST) {
                    String createdFile = futureFile.fileName + ".il";
                    allCreatedFiles.insert(0, createdFile + " ");
                    try {
                        textPrinter = new TextPrinter(createdFile);
                        textPrinter.initFile(futureFile.language);
                        new DotDecompiler(textPrinter, null).decompileTree(futureFile.tree, futureFile.language, futureFile.isIncludeFile, this.showMessagesInFile);
                        textPrinter.newLine();
                        textPrinter.closeFile();
                    }
                    catch (FileNotFoundException e) {
                        TapEnv.printlnOnTrace("Could not open output file " + createdFile + " for IL output");
                    }
                }
            }
            futureFiles = futureFiles.tail;
        }
        if (allCreatedFiles.length() > 0) {
            TapEnv.printlnOnTrace(7, "@@ Created " + allCreatedFiles);
        }
    }

    private void prepareFutureFile(String fileName, Unit unit, SymbolTable fileSymbolTable, String globalDeclsIncludeName, TapList<TapTriplet<Tree, Tree, Integer>> includesNameTree, Tree treeForServlet, TapList<FutureFile> toFutureFiles, String fileDirectory, CallGraph callGraph, boolean skipSubUnits) {
        int language = unit.language();
        int otherHtmlLanguage = unit.language();
        TapList<Object> fileUserHelpStrings = null;
        boolean addUseDiffSizesHere = false;
        if (TapEnv.isCorMore(language)) {
            addUseDiffSizesHere = true;
            fileUserHelpStrings = new TapList<Object>(null, null);
        }
        if (unit.rank() == -1) {
            TapEnv.toolWarning(10, "Regenerated unit seems external (rank==-1): " + unit);
        }
        Tree fileTree = TreeGen.generate(unit, false, false, skipSubUnits, includesNameTree, fileUserHelpStrings);
        includesNameTree.tail = TreeGen.generateInclude(includesNameTree, "Tapenade 3.16 (master) -  9 Oct 2020 17:47");
        FutureFile futureFile = null;
        TapList inFutureFiles = toFutureFiles.tail;
        while (futureFile == null && inFutureFiles != null) {
            if (((FutureFile)inFutureFiles.head).fileName.equals(fileDirectory + fileName) && ((FutureFile)inFutureFiles.head).language == language) {
                futureFile = (FutureFile)inFutureFiles.head;
            }
            inFutureFiles = inFutureFiles.tail;
        }
        if (futureFile == null) {
            if (!(TapEnv.isDistribVersion() || this.generateHTML && callGraph == TapEnv.get().origCallGraph())) {
                TapEnv.printlnOnTrace(7, "@@ Creating " + fileDirectory + fileName + TapEnv.outputExtension(language));
            }
            TreeGen.addHeader(fileTree, language, "Tapenade 3.16 (master) -  9 Oct 2020 17:47");
            String oppositeHtmlFileName = null;
            if (this.generateHTML) {
                if (callGraph == TapEnv.get().origCallGraph()) {
                    TapList<Unit> diffUnits = null;
                    if (this.diffCallGraph() != null) {
                        diffUnits = Unit.removePhantomPackages((TapList)TapList.cassq(unit, this.diffCallGraph().backAssociations));
                    }
                    if (diffUnits != null) {
                        oppositeHtmlFileName = fileName.substring(0, fileName.length() - TapEnv.get().preprocessFileSuffix.length()) + TapEnv.get().diffFileSuffix;
                        otherHtmlLanguage = ((Unit)diffUnits.head).language();
                    }
                } else {
                    oppositeHtmlFileName = fileName.substring(0, fileName.length() - TapEnv.get().diffFileSuffix.length()) + TapEnv.get().preprocessFileSuffix;
                    if (unit.otherName() != null) {
                        otherHtmlLanguage = unit.otherName().language();
                    }
                }
            }
            if (TapEnv.modeIsNoDiff() && callGraph != TapEnv.get().origCallGraph()) {
                fileName = TapEnv.extendStringWithSuffix(fileName, TapEnv.get().preprocessFileSuffix);
            }
            if (fileSymbolTable != null && fileSymbolTable.mustBeCreated()) {
                if (globalDeclsIncludeName != null) {
                    fileTree.addChild(ILUtils.build(99, "\"" + globalDeclsIncludeName + TapEnv.outputExtension(4) + "\""), 1);
                } else if (TapEnv.isCorMore(language)) {
                    TreeGen.generateGlobalDeclarations(callGraph, includesNameTree, fileUserHelpStrings, fileTree, language, false);
                }
            }
            if (addUseDiffSizesHere) {
                TreeGen.addUseDiffSizesAndUserHelp(fileTree, fileUserHelpStrings.tail, language);
            }
            futureFile = new FutureFile(fileTree, language, fileDirectory + fileName, otherHtmlLanguage, oppositeHtmlFileName, false);
            toFutureFiles.placdl(futureFile);
        } else {
            Tree[] newPieces;
            for (Tree newPiece : newPieces = fileTree.children()) {
                futureFile.tree.addChild(newPiece, -1);
            }
        }
        if (TapEnv.get().dumps && this.dumpOutputStream != null && TapEnv.get().dumpDiffFlowGraphs && fileTree != null) {
            TapEnv.printOnDump("Checking syntax of unit " + unit.name + ':' + (fileTree.checkSyntax(unit.name) ? "ok" : "wrong") + System.lineSeparator());
        }
        if (fileTree != null && treeForServlet != null) {
            treeForServlet.addChild(ILUtils.copy(fileTree), -1);
        }
        if (TapEnv.get().srcUnitsToTraceInTreeGen != null) {
            TapEnv.printlnOnTrace("Contents for future file " + fileDirectory + fileName + TapEnv.outputExtension(language) + ':');
            try {
                TapEnv.indent(2);
                ILUtils.dump(futureFile.tree, 2);
                TapEnv.println();
            }
            catch (IOException e) {
                TapEnv.printlnOnTrace("IO error while dumping generated tree");
            }
        }
    }

    private void collectConflictingLocals(CallGraph callGraph, TapPair<Integer, TapList<String>>[] conflictingLocals) {
        TapList<Unit> topUnits = callGraph.topUnits();
        while (topUnits != null) {
            Unit topUnit = (Unit)topUnits.head;
            if (topUnit.isTranslationUnit()) {
                int langFamily = topUnit.isCorMore() ? 1 : 0;
                conflictingLocals[langFamily].first = (Integer)conflictingLocals[langFamily].first + 1;
                if (langFamily == 1) {
                    SymbolDecl symbol;
                    SymbolTable tust = topUnit.translationUnitSymbolTable();
                    TapList<SymbolDecl> symbols = tust.getAllTopVariableDecls();
                    while (symbols != null) {
                        symbol = (SymbolDecl)symbols.head;
                        if (!symbol.isShared()) {
                            conflictingLocals[1].second = new TapList<String>(symbol.symbol, (TapList)conflictingLocals[langFamily].second);
                        }
                        symbols = symbols.tail;
                    }
                    symbols = tust.getAllTopFunctionDecls();
                    while (symbols != null) {
                        symbol = (SymbolDecl)symbols.head;
                        if (!symbol.isShared()) {
                            conflictingLocals[langFamily].second = new TapList<String>(symbol.symbol, (TapList)conflictingLocals[langFamily].second);
                        }
                        symbols = symbols.tail;
                    }
                }
            }
            topUnits = topUnits.tail;
        }
    }

    private void analyzeParameters(String[] argv) {
        if (TapEnv.tapenadeHome == null) {
            TapEnv.tapenadeHome = System.getProperty("user.dir");
        }
        System.setProperty("file.encoding", "ISO8859_1");
        File libraryPath = new File(TapEnv.tapenadeHome + File.separator + "bin");
        if (!libraryPath.exists()) {
            TapEnv.toolError("Parser not found: " + TapEnv.tapenadeHome + File.separator + "bin");
        }
        pathToParsers = libraryPath.getPath() + File.separator;
        TapList<Object> listFileNames = null;
        String dumpPathFile = null;
        String tgtFuncSuffix = null;
        String tgtVarSuffix = null;
        String adjFuncSuffix = null;
        String adjVarSuffix = null;
        String tgtModuleSuffix = null;
        String adjModuleSuffix = null;
        String moduleSuffix = null;
        String diffFuncSuffix = null;
        String diffVarSuffix = null;
        String copiedUnitSuffix = null;
        String assocByAddressSuffix = null;
        boolean seenExplicitDiffLivenessOption = false;
        for (int i = 0; i < argv.length; ++i) {
            String includeDir;
            String argviLower = argv[i].toLowerCase();
            if (argviLower.equals("-inputlanguage")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                if (argv[i + 1] != null && !argv[i + 1].isEmpty()) {
                    String inputLang;
                    switch (inputLang = argv[i + 1].toLowerCase()) {
                        case "protocol": 
                        case "il": {
                            this.inputLanguage = 0;
                            break;
                        }
                        case "fortran": {
                            this.inputLanguage = 1;
                            break;
                        }
                        case "fortran90": 
                        case "fortran95": {
                            this.inputLanguage = 2;
                            break;
                        }
                        case "fortran2003": 
                        case "fortran03": {
                            this.inputLanguage = 3;
                            break;
                        }
                        case "c": {
                            this.inputLanguage = 4;
                            break;
                        }
                        case "cpp": 
                        case "c++": {
                            this.inputLanguage = 5;
                            break;
                        }
                    }
                    TapEnv.setInputLanguage(this.inputLanguage);
                }
                ++i;
                continue;
            }
            if (argviLower.equals("-outputfiletype")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                switch (argv[i + 1]) {
                    case "protocol": 
                    case "dot": {
                        this.generateAST = true;
                        break;
                    }
                    case "html": {
                        this.generateHTML = true;
                        break;
                    }
                    case "nolanguage": {
                        this.generateLanguage = false;
                        break;
                    }
                }
                ++i;
                continue;
            }
            if (argviLower.equals("-outputlanguage")) {
                String outputLang;
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                if ((outputLang = argv[i + 1]) != null) {
                    block43 : switch (outputLang = outputLang.toLowerCase()) {
                        case "fortran": {
                            TapEnv.setOutputLanguage(1);
                            break;
                        }
                        case "fortran90": 
                        case "fortran95": 
                        case "fortran2003": {
                            if (outputLang.equals("fortran2003")) {
                                TapEnv.setOutputLanguage(3);
                            } else {
                                TapEnv.setOutputLanguage(2);
                            }
                            switch (outputLang) {
                                case "fortran90": {
                                    TapEnv.get().suffixF90 = ".f90";
                                    break block43;
                                }
                                case "fortran95": {
                                    TapEnv.get().suffixF90 = ".f95";
                                    break block43;
                                }
                                case "fortran2003": {
                                    TapEnv.get().suffixF90 = ".f03";
                                    break block43;
                                }
                            }
                            break;
                        }
                        case "c": {
                            TapEnv.setOutputLanguage(4);
                            break;
                        }
                        case "cpp": 
                        case "c++": {
                            TapEnv.setOutputLanguage(5);
                            break;
                        }
                    }
                }
                ++i;
                continue;
            }
            if (argviLower.equals("-openmp")) {
                this.parseOpenMP = true;
                TapEnv.setDoOpenMP(true);
                TapEnv.addOptionsString(" OpenMP");
                continue;
            }
            if (argviLower.equals("-freeformat") || argv[i].equals("-f95")) {
                this.inputLanguage = 2;
                libraryPath = new File(TapEnv.tapenadeHome + File.separator + "bin");
                pathToParsers = libraryPath.getPath() + File.separator;
                continue;
            }
            if (argviLower.equals("-linelength")) {
                TapEnv.get().fortran90LineLength = argv[i + 1];
                TapEnv.get().fortran90OutputLineLength = Integer.parseInt(TapEnv.get().fortran90LineLength);
                ++i;
                continue;
            }
            if (argv[i].equals("-tangent") || argv[i].equals("-forward") || argv[i].equals("-d") || argv[i].equals("-tl")) {
                TapEnv.setMustTangent(true);
                TapEnv.setModeTangent();
                continue;
            }
            if (argviLower.equals("-adolc")) {
                TapEnv.setModeOverloading();
                continue;
            }
            if (argv[i].equals("-backward") || argv[i].equals("-reverse") || argv[i].equals("-b") || argv[i].equals("-cl")) {
                TapEnv.setMustAdjoint(true);
                TapEnv.setModeAdjoint();
                continue;
            }
            if (argviLower.equals("-directvalid")) {
                TapEnv.setModeTangent();
                TapEnv.setValid(true);
                TapEnv.addOptionsString(" directValid");
                continue;
            }
            if (argviLower.equals("-distinctnewvars")) {
                TapEnv.get().newSHdisambiguator = 0;
                TapEnv.addOptionsString(" distinctNewVars");
                continue;
            }
            if (argv[i].equals("-context")) {
                TapEnv.setMustContext(true);
                TapEnv.addOptionsString(" context");
                continue;
            }
            if (argviLower.equals("-oldcontext")) {
                TapEnv.get().oldContext = true;
                TapEnv.addOptionsString(" oldContext");
                continue;
            }
            if (argviLower.equals("-tgtfuncname")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                tgtFuncSuffix = argv[i + 1];
                ++i;
                continue;
            }
            if (argviLower.equals("-tgtvarname")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                tgtVarSuffix = argv[i + 1];
                ++i;
                continue;
            }
            if (argviLower.equals("-tgtmodulename")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                tgtModuleSuffix = argv[i + 1];
                ++i;
                continue;
            }
            if (argviLower.equals("-adjfuncname")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                adjFuncSuffix = argv[i + 1];
                ++i;
                continue;
            }
            if (argviLower.equals("-adjvarname")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                adjVarSuffix = argv[i + 1];
                ++i;
                continue;
            }
            if (argviLower.equals("-adjmodulename")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                adjModuleSuffix = argv[i + 1];
                ++i;
                continue;
            }
            if (argviLower.equals("-modulename")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                moduleSuffix = argv[i + 1];
                ++i;
                continue;
            }
            if (argviLower.equals("-copyname")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                copiedUnitSuffix = argv[i + 1];
                ++i;
                continue;
            }
            if (argviLower.equals("-assocbyaddresssuffix")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                assocByAddressSuffix = argv[i + 1];
                ++i;
                continue;
            }
            if (argviLower.equals("-difffuncname")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                } else {
                    TapEnv.commandWarning(-1, "Command-line option -difffuncname is deprecated: please use -tgtfuncname or -adjfuncname");
                }
                diffFuncSuffix = argv[i + 1];
                ++i;
                continue;
            }
            if (argviLower.equals("-diffvarname")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                } else {
                    TapEnv.commandWarning(-1, "Command-line option -diffvarname is deprecated: please use -tgtvarname or -adjvarname");
                }
                diffVarSuffix = argv[i + 1];
                ++i;
                continue;
            }
            if (argviLower.equals("-preprocess") || argv[i].equals("-p")) {
                TapEnv.setModeNoDiff();
                continue;
            }
            if (argviLower.equals("-createstub")) {
                TapEnv.setModeNoDiff();
                TapEnv.get().createStub = true;
                continue;
            }
            if (argv[i].equals("-O") || argviLower.equals("-outputdirectory")) {
                String directory;
                File directoryFile;
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                if ((directoryFile = new File(directory = argv[i + 1])).exists() && directoryFile.isDirectory()) {
                    this.outputDirectory = directory;
                    if (!this.outputDirectory.endsWith(File.separator)) {
                        this.outputDirectory = this.outputDirectory + File.separator;
                    }
                } else {
                    TapEnv.commandWarning(-1, "Output directory not found: " + directory);
                    TapEnv.tapenadeExit(1);
                }
                ++i;
                continue;
            }
            if (argv[i].equals("-o") || argv[i].equals("-output")) {
                String outputFilePathName;
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                if ((outputFilePathName = argv[++i]) == null || outputFilePathName.isEmpty()) {
                    this.outputFileName = null;
                    continue;
                }
                this.outputFileName = TapEnv.stripPath(outputFilePathName);
                if (this.outputFileName == null || this.outputFileName.equals(outputFilePathName)) continue;
                TapEnv.commandWarning(14, "Parent directory ignored in " + outputFilePathName);
                continue;
            }
            if (!this.generateHTML && argviLower.equals("-splitoutputfiles")) {
                this.splitOutputFiles = true;
                continue;
            }
            if (argv[i].equals("-multi") || argv[i].equals("-vector")) {
                TapEnv.get().multiDirDiffMode = true;
                TapEnv.addOptionsString(" multiDirectional");
                continue;
            }
            if (argviLower.equals("-nbdirsmax")) {
                String nbdirsmaxString;
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                if ((nbdirsmaxString = argv[i + 1]) != null && !nbdirsmaxString.isEmpty()) {
                    TapEnv.get().nbdirsmaxString = nbdirsmaxString;
                }
                ++i;
                continue;
            }
            if (argviLower.equals("-parserfileseparator")) {
                String parserFileSep;
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                if ((parserFileSep = argv[i + 1]) != null && !parserFileSep.isEmpty()) {
                    TapEnv.get().parserFileSeparator = parserFileSep;
                }
                ++i;
                continue;
            }
            if (argv[i].equals("-I") || argv[i].equals("-include")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                if (!(includeDir = argv[i + 1]).endsWith(File.separator)) {
                    includeDir = includeDir + File.separator;
                }
                if (includeDir.startsWith("./")) {
                    includeDir = includeDir.substring(2);
                }
                this.toIncludeDirList = this.toIncludeDirList.placdl(includeDir);
                ++i;
                continue;
            }
            if (argv[i].startsWith("-I")) {
                includeDir = argv[i].substring(2);
                if (!includeDir.endsWith(File.separator)) {
                    includeDir = includeDir + File.separator;
                }
                if (includeDir.startsWith("./")) {
                    includeDir = includeDir.substring(2);
                }
                this.toIncludeDirList = this.toIncludeDirList.placdl(includeDir);
                continue;
            }
            if (argviLower.equals("-noinclude")) {
                TapEnv.get().expandAllIncludeFile = true;
                TapEnv.addOptionsString(" noinclude");
                continue;
            }
            if (argv[i].equals("-cpp")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                TapEnv.get().cppCommand = argv[i + 1];
                ++i;
                continue;
            }
            if (argviLower.equals("-cppoptions")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                TapEnv.get().cppOptions = argv[i + 1];
                ++i;
                continue;
            }
            if (argviLower.equals("-nocomment")) {
                TapEnv.get().noComment = true;
                TapEnv.addOptionsString(" nocomment");
                continue;
            }
            if (argv[i].equals("-root") || argv[i].equals("-head")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                this.parseDiffRoots(argv[i + 1]);
                ++i;
                continue;
            }
            if (argv[i].equals("-vars") || argv[i].equals("-variables")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                if (TapEnv.isDistribVersion()) {
                    TapEnv.commandWarning(-1, "Command-line option " + argv[i] + " is deprecated: please use -head instead");
                }
                this.parseDiffVars(argv[i + 1]);
                ++i;
                continue;
            }
            if (argviLower.equals("-outvars")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                if (TapEnv.isDistribVersion()) {
                    TapEnv.commandWarning(-1, "Command-line option " + argv[i] + " is deprecated: please use -head instead");
                }
                this.parseDiffOutvars(argv[i + 1]);
                ++i;
                continue;
            }
            if (argviLower.equals("-nolib")) {
                this.nolib = true;
                continue;
            }
            if (argv[i].equals("-ext")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                this.libraryFileNames = this.libraryFileNames + ' ' + argv[i + 1];
                ++i;
                continue;
            }
            if (argviLower.equals("-extad")) {
                TapEnv.commandWarning(-1, "Sorry, option -extAD is now obsolete. Please merge your ADLib into the corresponding GeneralLib and use only option -ext");
                TapEnv.tapenadeExit(1);
                continue;
            }
            if (argv[i].equals("-i2")) {
                TapEnv.get().integerSize = 2;
                TapEnv.addOptionsString(" i2");
                continue;
            }
            if (argv[i].equals("-i4")) {
                TapEnv.get().integerSize = 4;
                TapEnv.addOptionsString(" i4");
                continue;
            }
            if (argv[i].equals("-i8")) {
                TapEnv.get().integerSize = 8;
                TapEnv.addOptionsString(" i8");
                continue;
            }
            if (argv[i].equals("-r4")) {
                TapEnv.get().realSize = 4;
                TapEnv.addOptionsString(" r4");
                continue;
            }
            if (argv[i].equals("-r8")) {
                TapEnv.get().realSize = 8;
                TapEnv.addOptionsString(" r8");
                continue;
            }
            if (argv[i].equals("-dr4")) {
                TapEnv.get().doubleRealSize = 4;
                TapEnv.addOptionsString(" dr4");
                continue;
            }
            if (argv[i].equals("-dr8")) {
                TapEnv.get().doubleRealSize = 8;
                TapEnv.addOptionsString(" dr8");
                continue;
            }
            if (argv[i].equals("-dr16")) {
                TapEnv.get().doubleRealSize = 16;
                TapEnv.addOptionsString(" dr16");
                continue;
            }
            if (argv[i].equals("-p4")) {
                TapEnv.get().pointerSize = 4;
                TapEnv.addOptionsString(" p4");
                continue;
            }
            if (argv[i].equals("-p8")) {
                TapEnv.get().pointerSize = 8;
                TapEnv.addOptionsString(" p8");
                continue;
            }
            if (argviLower.equals("-specializeactivity")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                this.specializedActivityUnitNames = this.collectUnitNamesFromString(argv[++i]);
                TapEnv.addOptionsString(" specializeActivity(" + argv[i] + ')');
                continue;
            }
            if (argv[i].equals("-split") || argviLower.equals("-nocheckpoint")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                this.splittedUnitNames = this.collectUnitNamesFromString(argv[++i]);
                TapEnv.addOptionsString(" split(" + argv[i] + ')');
                if (!TapEnv.get().staticTape) continue;
                TapEnv.get().staticTape = false;
                TapEnv.commandWarning(-1, "Command-line option -nocheckpoint deactivates option statictape");
                continue;
            }
            if (argviLower.equals("-numberpushpops")) {
                TapEnv.get().numberPushPops = true;
                TapEnv.addOptionsString(" numberpushpops");
                continue;
            }
            if (argviLower.equals("-fixinterface")) {
                TapEnv.get().fixInterface = true;
                TapEnv.addOptionsString(" fixinterface");
                continue;
            }
            if (argviLower.equals("-differentiateintegers")) {
                this.diffKind = 0;
                TapEnv.setDiffKind(this.diffKind);
                TapEnv.addOptionsString(" diffIntegers");
                continue;
            }
            if (argviLower.equals("-debugactivity")) {
                TapEnv.setDebugActivity(true);
                TapEnv.addOptionsString(" debugActivity");
                continue;
            }
            if (argv[i].equals("-dump") || argviLower.equals("-dumpfile")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                this.debug = true;
                dumpPathFile = argv[++i];
                TapEnv.get().dumps = dumpPathFile != null;
                continue;
            }
            if (argviLower.equals("-dumpunit")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                TapEnv.get().dumpUnitNames = this.collectUnitNamesFromString(argv[++i]);
                continue;
            }
            if (argviLower.equals("-dumpcallgraph")) {
                TapEnv.get().dumpCallGraph = true;
                continue;
            }
            if (argviLower.equals("-dumpsymboltables")) {
                TapEnv.get().dumpSymbolTables = true;
                continue;
            }
            if (argviLower.equals("-dumpflowgraphs")) {
                TapEnv.get().dumpFlowGraphs = true;
                continue;
            }
            if (argviLower.equals("-dumpzones")) {
                TapEnv.get().dumpZones = true;
                continue;
            }
            if (argviLower.equals("-dumpdataflow")) {
                TapEnv.get().dumpDataFlow = true;
                continue;
            }
            if (argviLower.equals("-dumpdiffsymboltables")) {
                TapEnv.get().dumpDiffSymbolTables = true;
                continue;
            }
            if (argviLower.equals("-dumpdiffflowgraphs")) {
                TapEnv.get().dumpDiffFlowGraphs = true;
                continue;
            }
            if (argviLower.equals("-dumpinout")) {
                TapEnv.get().dumpInOut = true;
                continue;
            }
            if (argviLower.equals("-dumppointers")) {
                TapEnv.get().dumpPointers = true;
                continue;
            }
            if (argviLower.equals("-dumpdeps")) {
                TapEnv.get().dumpDeps = true;
                continue;
            }
            if (argv[i].equals("-profile")) {
                TapEnv.get().profile = true;
                TapEnv.addOptionsString(" profile");
                continue;
            }
            if (argviLower.equals("-tracelevel") || argv[i].equals("-debug")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                try {
                    TapEnv.setTraceLevel(Integer.parseInt(argv[i + 1]));
                }
                catch (NumberFormatException e) {
                    TapEnv.commandWarning(-1, "Incorrect trace level value");
                }
                this.debug = true;
                ++i;
                continue;
            }
            if (argviLower.equals("-msglevel")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                try {
                    TapEnv.setMsgLevel(Integer.parseInt(argv[i + 1]));
                }
                catch (NumberFormatException e) {
                    TapEnv.commandWarning(-1, "Incorrect message level value");
                }
                this.debug = true;
                ++i;
                continue;
            }
            if (argviLower.equals("-noisize")) {
                TapEnv.get().noisize = true;
                TapEnv.addOptionsString(" noISIZE");
                continue;
            }
            if (argviLower.equals("-noisize77")) {
                TapEnv.get().noisize77 = true;
                TapEnv.get().noisize = true;
                TapEnv.addOptionsString(" noISIZE77");
                continue;
            }
            if (argviLower.equals("-viewcallgraph")) {
                this.viewCallGraph = true;
                continue;
            }
            if (argv[i].equals("-association") || argv[i].equals("-assoc")) {
                String assoc;
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                if ((assoc = argv[++i]).equalsIgnoreCase("byaddress")) {
                    TapEnv.setAssociationByAddress(true);
                    TapEnv.addOptionsString(" associationByAddress");
                    continue;
                }
                TapEnv.commandWarning(-1, "Unknown associationByAddress option: " + assoc);
                continue;
            }
            if (argviLower.equals("-mixedlanguage")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                this.parseMixedLanguage(argv[i + 1]);
                ++i;
                continue;
            }
            if (argv[i].equals("-optim")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                seenExplicitDiffLivenessOption = this.analyzeOptimOptions(argv[++i], seenExplicitDiffLivenessOption);
                continue;
            }
            if (argviLower.equals("-nooptim")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                seenExplicitDiffLivenessOption = this.analyzeNoOptimOptions(argv[++i], seenExplicitDiffLivenessOption);
                continue;
            }
            if (argviLower.equals("-stripprimalevenifimportsactive")) {
                TapEnv.get().stripPrimalEvenIfImportsActive = true;
                TapEnv.addOptionsString(" stripPrimalEvenIfImportsActive");
                continue;
            }
            if (argviLower.equals("-msginfile")) {
                this.showMessagesInFile = true;
                TapEnv.addOptionsString(" messagesInFile");
                continue;
            }
            if (argviLower.equals("-debugtgt")) {
                TapEnv.get().mergeDiffInstructions = false;
                TapEnv.setDbadMode(1);
                TapEnv.addOptionsString(" debugTangent");
                TapEnv.setSpareDiffReinitializations(false);
                TapEnv.addOptionsString(" no!SpareInits");
                TapEnv.get().fixInterface = true;
                TapEnv.addOptionsString(" fixinterface");
                continue;
            }
            if (argviLower.equals("-debugadj")) {
                TapEnv.get().mergeDiffInstructions = false;
                TapEnv.setDbadMode(-1);
                TapEnv.addOptionsString(" debugAdjoint");
                TapEnv.setSpareDiffReinitializations(false);
                TapEnv.addOptionsString(" no!SpareInits");
                TapEnv.get().fixInterface = true;
                TapEnv.addOptionsString(" fixinterface");
                continue;
            }
            if (argviLower.equals("-debugpassives")) {
                TapEnv.get().debugPassives = true;
                TapEnv.addOptionsString(" debugPassives");
                TapEnv.setDoUsefulness(false);
                TapEnv.addOptionsString(" no!Usefulness");
                continue;
            }
            if (argv[i].equals("-html")) {
                this.generateHTML = true;
                this.splitOutputFiles = false;
                continue;
            }
            if (argv[i].equals("-version") || argv[i].equals("--version")) {
                TapEnv.printlnOnTrace("@@ JAVA_HOME=" + javaHome);
                TapEnv.printlnOnTrace("Tag:      3.16-v0-1-g8a3876252");
                TapEnv.printlnOnTrace("Revision: 8a387625233009c8ab2238d013083fc693fbc2d5");
                if (!TapEnv.optionsString().isEmpty()) {
                    TapEnv.printlnOnTrace(" Options: " + TapEnv.optionsString());
                }
                TapEnv.tapenadeExit(0);
                continue;
            }
            if (argviLower.equals("-versiontapenade")) {
                TapEnv.tapenadeExit(0);
                continue;
            }
            if (argv[i].equals("-java")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                TapEnv.printlnOnTrace("-java " + argv[++i]);
                continue;
            }
            if (argv[i].equals("-h") || argv[i].equals("-help") || argv[i].equals("-?")) {
                Tapenade.help();
                TapEnv.tapenadeExit(0);
                continue;
            }
            if (argv[i].equals("-H") || argv[i].equals("-HELP")) {
                Tapenade.hiddenHelp();
                TapEnv.tapenadeExit(0);
                continue;
            }
            if (argviLower.equals("-traceparser")) {
                TapEnv.get().traceParser = true;
                continue;
            }
            if (argviLower.equals("-traceinputil")) {
                TapEnv.setTraceInputIL(true);
                continue;
            }
            if (argviLower.equals("-traceflowgraphbuild")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                TapEnv.setTraceFlowGraphBuild(this.collectUnitNamesFromString(argv[++i]));
                continue;
            }
            if (argviLower.equals("-tracetypecheck")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                TapEnv.get().traceTypeCheck = this.collectUnitNamesFromString(argv[++i]);
                continue;
            }
            if (argviLower.equals("-tracepointer")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                TapEnv.setTracePointer(this.collectUnitNamesFromString(argv[++i]));
                continue;
            }
            if (argviLower.equals("-traceinout")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                TapEnv.setTraceInOut(this.collectUnitNamesFromString(argv[++i]));
                continue;
            }
            if (argviLower.equals("-tracedeps")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                TapEnv.setTraceDeps(this.collectUnitNamesFromString(argv[++i]));
                continue;
            }
            if (argviLower.equals("-traceaddeps")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                TapEnv.setTraceADDeps(this.collectUnitNamesFromString(argv[++i]));
                continue;
            }
            if (argviLower.equals("-traceactivity")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                TapEnv.setTraceActivity(this.collectUnitNamesFromString(argv[++i]));
                ILUtils.activeMark = "@";
                continue;
            }
            if (argviLower.equals("-tracereqexplicit") || argviLower.equals("-tracereqx")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                TapEnv.setTraceReqExplicit(this.collectUnitNamesFromString(argv[++i]));
                ILUtils.reqXMark = "#";
                continue;
            }
            if (argviLower.equals("-tracediffliveness")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                TapEnv.setTraceDiffLiveness(this.collectUnitNamesFromString(argv[++i]));
                continue;
            }
            if (argviLower.equals("-tracetbr")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                TapEnv.setTraceTBR(this.collectUnitNamesFromString(argv[++i]));
                continue;
            }
            if (argviLower.equals("-tracedifferentiation")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                TapEnv.get().traceDifferentiationUnitNames = this.collectUnitNamesFromString(argv[++i]);
                continue;
            }
            if (argviLower.equals("-tracetreegen")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                TapEnv.get().traceTreeGenUnitNames = this.collectUnitNamesFromString(argv[++i]);
                continue;
            }
            if (argviLower.equals("-traceblock")) {
                if (i >= argv.length - 1) {
                    TapEnv.commandWarning(-1, "Missing command-line argument after: " + argv[i]);
                    TapEnv.tapenadeExit(1);
                }
                TapEnv.get().traceBlockRk = Integer.parseInt(argv[++i]);
                continue;
            }
            String fileName = argv[i];
            if (!new File(fileName).exists()) {
                TapEnv.commandWarning(-1, "File not found: " + fileName);
                continue;
            }
            if (Tapenade.getLanguageOfFile(fileName) == 98) {
                TapEnv.commandWarning(-1, fileName + ", include skipped in command line");
                continue;
            }
            listFileNames = new TapList<String>(fileName, listFileNames);
        }
        if (TapEnv.modeIsTangent()) {
            TapEnv.setMustTangent(true);
        }
        if (TapEnv.modeIsTangent() && !TapEnv.mustAdjoint() && !seenExplicitDiffLivenessOption) {
            TapEnv.setRemoveDeadPrimal(false);
            TapEnv.setRemoveDeadControl(false);
        }
        if (TapEnv.get().dumps) {
            String dumpFileName = TapEnv.stripPath(dumpPathFile);
            if (dumpFileName != null && !dumpFileName.equals(dumpPathFile)) {
                TapEnv.commandWarning(14, "Parent directory ignored in " + dumpPathFile);
            }
            try {
                this.dumpOutputStream = Files.newOutputStream(Paths.get(this.outputDirectory + dumpFileName, new String[0]), new OpenOption[0]);
            }
            catch (IOException e) {
                TapEnv.systemWarning(-1, e.toString());
                this.dumpOutputStream = null;
            }
            TapEnv.get().dumpOutputStream = this.dumpOutputStream;
            if (!(TapEnv.get().dumpCallGraph || TapEnv.get().dumpZones || TapEnv.get().dumpDataFlow || TapEnv.get().dumpSymbolTables || TapEnv.get().dumpDiffSymbolTables || TapEnv.get().dumpFlowGraphs || TapEnv.get().dumpDiffFlowGraphs || TapEnv.get().dumpUnitNames != null)) {
                TapEnv.get().dumpZones = true;
                TapEnv.get().dumpDataFlow = true;
                TapEnv.get().dumpSymbolTables = true;
                TapEnv.get().dumpFlowGraphs = true;
                TapEnv.get().dumpDiffSymbolTables = true;
                TapEnv.get().dumpDiffFlowGraphs = true;
            }
        }
        if (listFileNames == null) {
            TapEnv.commandWarning(-1, "No input files");
            TapEnv.tapenadeExit(1);
        }
        int nbFileNames = TapList.length(listFileNames);
        String[] arrayFileNames = new String[nbFileNames];
        for (int j = nbFileNames - 1; j >= 0; --j) {
            arrayFileNames[j] = (String)listFileNames.head;
            listFileNames = listFileNames.tail;
        }
        this.inputFileNames = arrayFileNames;
        this.inputFileName = this.inputFileNames[0];
        String stdLibraryDirectory = "lib" + File.separator;
        this.stdGeneralLibraryDirectory = this.nolib ? null : stdLibraryDirectory;
        TapEnv.get().stdLibraryDirectory = stdLibraryDirectory;
        if (tgtFuncSuffix == null) {
            tgtFuncSuffix = diffFuncSuffix;
        }
        if (tgtVarSuffix == null) {
            tgtVarSuffix = diffVarSuffix;
        }
        if (adjFuncSuffix == null) {
            adjFuncSuffix = diffFuncSuffix;
        }
        if (adjVarSuffix == null) {
            adjVarSuffix = diffVarSuffix;
        }
        if (tgtModuleSuffix == null) {
            tgtModuleSuffix = moduleSuffix;
        }
        if (adjModuleSuffix == null) {
            adjModuleSuffix = moduleSuffix;
        }
        this.prepareAllSuffixes(tgtFuncSuffix, tgtVarSuffix, adjFuncSuffix, adjVarSuffix, tgtModuleSuffix, adjModuleSuffix, moduleSuffix, copiedUnitSuffix, assocByAddressSuffix);
        this.absDirectoryHtmlGen = this.outputDirectory + this.directoryHtmlGen;
    }

    private boolean analyzeOptimOptions(String str, boolean seenExplicitDiffLivenessOption) {
        StringTokenizer token = new StringTokenizer(str, " ,");
        block12: while (token.hasMoreElements()) {
            String oneoptimLower;
            String oneOptim = token.nextToken();
            switch (oneoptimLower = oneOptim.toLowerCase()) {
                case "diffliveness": {
                    seenExplicitDiffLivenessOption = true;
                    TapEnv.setRemoveDeadPrimal(true);
                    TapEnv.setRemoveDeadControl(true);
                    TapEnv.addOptionsString(" with!SliceDeadControl");
                    TapEnv.addOptionsString(" with!SliceDeadInstrs");
                    continue block12;
                }
                case "stripprimalcode": {
                    TapEnv.get().stripPrimalCode = true;
                    TapEnv.addOptionsString(" with!StripPrimalCode");
                    continue block12;
                }
                case "spareinit": {
                    TapEnv.setSpareDiffReinitializations(true);
                    TapEnv.addOptionsString(" with!SpareInits");
                    continue block12;
                }
                case "statictape": {
                    TapEnv.get().staticTape = true;
                    if (this.splittedUnitNames != null) {
                        TapEnv.commandWarning(-1, "Option statictape deactivated on units with nocheckpoint option");
                    }
                    TapEnv.addOptionsString(" with!StaticTaping");
                    continue block12;
                }
            }
            TapEnv.commandWarning(-1, "Unknown command-line option: -optim " + oneOptim);
        }
        return seenExplicitDiffLivenessOption;
    }

    private boolean analyzeNoOptimOptions(String str, boolean seenExplicitDiffLivenessOption) {
        StringTokenizer token = new StringTokenizer(str, " ,");
        block44: while (token.hasMoreElements()) {
            String onenooptimLower;
            String oneNooptim = token.nextToken();
            switch (onenooptimLower = oneNooptim.toLowerCase()) {
                case "activity": {
                    TapEnv.setDoActivity(false);
                    TapEnv.addOptionsString(" no!Activity");
                    TapEnv.get().stripPrimalModules = false;
                    TapEnv.get().mergeDiffInstructions = false;
                    TapEnv.addOptionsString(" =>no!MergeDiffInstrs");
                    continue block44;
                }
                case "usefulness": {
                    TapEnv.setDoUsefulness(false);
                    TapEnv.addOptionsString(" no!Usefulness");
                    continue block44;
                }
                case "diffarguments": {
                    TapEnv.get().spareNoDiffArgs = false;
                    TapEnv.addOptionsString(" no!SpareDiffArgs");
                    continue block44;
                }
                case "spareinit": {
                    TapEnv.setSpareDiffReinitializations(false);
                    TapEnv.addOptionsString(" no!SpareInits");
                    continue block44;
                }
                case "splitdiff": {
                    TapEnv.get().splitDiffExpressions = false;
                    TapEnv.addOptionsString(" no!SplitDiffExprs");
                    continue block44;
                }
                case "mergediff": {
                    TapEnv.get().mergeDiffInstructions = false;
                    TapEnv.addOptionsString(" no!MergeDiffInstrs");
                    continue block44;
                }
                case "saveonlyused": {
                    TapEnv.get().dontSaveUnused = false;
                    TapEnv.addOptionsString(" no!SaveOnlyUsed");
                    TapEnv.setDoTBR(false);
                    TapEnv.addOptionsString(" no!SaveOnlyTBR");
                    continue block44;
                }
                case "tbr": {
                    TapEnv.setDoTBR(false);
                    TapEnv.addOptionsString(" no!SaveOnlyTBR");
                    continue block44;
                }
                case "snapshot": {
                    TapEnv.addOptionsString(" no!ReducedSnapshots");
                    continue block44;
                }
                case "adjointliveness": 
                case "diffliveness": {
                    seenExplicitDiffLivenessOption = true;
                    TapEnv.setRemoveDeadPrimal(false);
                    TapEnv.setRemoveDeadControl(false);
                    TapEnv.setDoRecompute(false);
                    TapEnv.addOptionsString(" no!SliceDeadControl");
                    TapEnv.addOptionsString(" no!SliceDeadInstrs");
                    TapEnv.addOptionsString(" no!tryRecomputations");
                    continue block44;
                }
                case "deadcontrol": {
                    seenExplicitDiffLivenessOption = true;
                    TapEnv.setRemoveDeadControl(false);
                    TapEnv.addOptionsString(" no!SliceDeadControl");
                    continue block44;
                }
                case "dc": {
                    seenExplicitDiffLivenessOption = true;
                    TapEnv.setRemoveDeadControl(false);
                    TapEnv.addOptionsString(" no!SliceDeadControl");
                    TapEnv.setRemoveDeadPrimal(false);
                    TapEnv.addOptionsString(" no!SliceDeadInstrs");
                    continue block44;
                }
                case "recomputeintermediates": {
                    TapEnv.setDoRecompute(false);
                    TapEnv.addOptionsString(" no!tryRecomputations");
                    continue block44;
                }
                case "difftypes": {
                    TapEnv.get().stripDiffTypes = false;
                    TapEnv.addOptionsString(" no!StripDiffTypes");
                    continue block44;
                }
                case "stripprimalcode": {
                    TapEnv.get().stripPrimalCode = false;
                    TapEnv.addOptionsString(" no!StripPrimalCode");
                    continue block44;
                }
                case "diffmodules": 
                case "stripprimalmodules": {
                    TapEnv.get().stripPrimalModules = false;
                    continue block44;
                }
                case "refineadmm": {
                    TapEnv.get().refineADMM = false;
                    TapEnv.addOptionsString(" no!refineADMM");
                    continue block44;
                }
                case "dataflow": {
                    TapEnv.setDoActivity(false);
                    TapEnv.addOptionsString(" no!Activity");
                    TapEnv.get().stripPrimalModules = false;
                    TapEnv.get().mergeDiffInstructions = false;
                    TapEnv.addOptionsString(" =>no!MergeDiffInstrs");
                    TapEnv.setSpareDiffReinitializations(false);
                    TapEnv.addOptionsString(" no!SpareInits");
                    TapEnv.setRemoveDeadPrimal(false);
                    TapEnv.setRemoveDeadControl(false);
                    TapEnv.setDoRecompute(false);
                    TapEnv.addOptionsString(" no!SliceDeadControl");
                    TapEnv.addOptionsString(" no!SliceDeadInstrs");
                    TapEnv.addOptionsString(" no!tryRecomputations");
                    seenExplicitDiffLivenessOption = true;
                    TapEnv.setRemoveDeadControl(false);
                    TapEnv.addOptionsString(" no!SliceDeadControl");
                    TapEnv.setDoRecompute(false);
                    TapEnv.addOptionsString(" no!tryRecomputations");
                    TapEnv.setDoTBR(false);
                    TapEnv.addOptionsString(" no!SaveOnlyTBR");
                    TapEnv.get().dontSaveUnused = false;
                    TapEnv.addOptionsString(" no!SaveOnlyUsed");
                    TapEnv.setDoTBR(false);
                    TapEnv.addOptionsString(" no!SaveOnlyTBR");
                    TapEnv.addOptionsString(" no!ReducedSnapshots");
                    continue block44;
                }
                case "everyoptim": {
                    TapEnv.setDoActivity(false);
                    TapEnv.addOptionsString(" no!Activity");
                    TapEnv.get().stripPrimalModules = false;
                    TapEnv.get().spareNoDiffArgs = false;
                    TapEnv.addOptionsString(" no!SpareDiffArgs");
                    TapEnv.setSpareDiffReinitializations(false);
                    TapEnv.addOptionsString(" no!SpareInits");
                    TapEnv.get().splitDiffExpressions = false;
                    TapEnv.addOptionsString(" no!SplitDiffExprs");
                    TapEnv.get().mergeDiffInstructions = false;
                    TapEnv.addOptionsString(" no!MergeDiffInstrs");
                    TapEnv.get().dontSaveUnused = false;
                    TapEnv.addOptionsString(" no!SaveOnlyUsed");
                    TapEnv.setDoTBR(false);
                    TapEnv.addOptionsString(" no!SaveOnlyTBR");
                    TapEnv.addOptionsString(" no!ReducedSnapshots");
                    seenExplicitDiffLivenessOption = true;
                    TapEnv.setRemoveDeadControl(false);
                    TapEnv.addOptionsString(" no!SliceDeadControl");
                    TapEnv.setRemoveDeadPrimal(false);
                    TapEnv.addOptionsString(" no!SliceDeadInstrs");
                    TapEnv.setDoRecompute(false);
                    TapEnv.addOptionsString(" no!tryRecomputations");
                    TapEnv.get().stripDiffTypes = false;
                    TapEnv.addOptionsString(" no!StripDiffTypes");
                    continue block44;
                }
            }
            TapEnv.commandWarning(-1, "Unknown command-line option: -nooptim " + oneNooptim);
        }
        return seenExplicitDiffLivenessOption;
    }

    private void prepareAllSuffixes(String tgtFuncSuffix, String tgtVarSuffix, String adjFuncSuffix, String adjVarSuffix, String tgtModuleSuffix, String adjModuleSuffix, String moduleSuffix, String copiedUnitSuffix, String assocByAddressSuffix) {
        if (TapEnv.associationByAddress() && assocByAddressSuffix == null) {
            assocByAddressSuffix = DEFAULT_ASSOC_BY_ADDRESS_FUNC_SUFFIX;
        }
        if (TapEnv.modeIsNoDiff()) {
            tgtVarSuffix = "";
            tgtFuncSuffix = "";
        } else if (TapEnv.modeIsOverloading()) {
            if (tgtVarSuffix == null || tgtVarSuffix.isEmpty()) {
                tgtVarSuffix = DEFAULT_ADOLC_VAR_SUFFIX;
            }
            if (tgtFuncSuffix == null || tgtFuncSuffix.isEmpty()) {
                tgtFuncSuffix = DEFAULT_ADOLC_FUNC_SUFFIX;
            }
        } else {
            if (tgtVarSuffix == null || tgtVarSuffix.isEmpty()) {
                tgtVarSuffix = this.suffixes[1][0];
            }
            if (tgtFuncSuffix == null || tgtFuncSuffix.isEmpty()) {
                tgtFuncSuffix = this.suffixes[1][1];
            }
            if (adjVarSuffix == null || adjVarSuffix.isEmpty()) {
                adjVarSuffix = this.suffixes[2][0];
            }
            if (adjFuncSuffix == null || adjFuncSuffix.isEmpty()) {
                adjFuncSuffix = this.suffixes[2][1];
            }
            if (TapEnv.associationByAddress()) {
                if (!assocByAddressSuffix.isEmpty()) {
                    tgtFuncSuffix = "_" + assocByAddressSuffix + tgtVarSuffix;
                    adjFuncSuffix = "_" + assocByAddressSuffix + adjVarSuffix;
                    copiedUnitSuffix = "_c" + assocByAddressSuffix + (TapEnv.mustTangent() ? "d" : "b");
                }
                tgtVarSuffix = "";
                adjVarSuffix = "";
            }
        }
        if (TapEnv.get().multiDirDiffMode) {
            tgtFuncSuffix = TapEnv.extendStringWithSuffix(tgtFuncSuffix, TapEnv.get().multiFuncSuffix);
            adjFuncSuffix = TapEnv.extendStringWithSuffix(adjFuncSuffix, TapEnv.get().multiFuncSuffix);
        }
        if (copiedUnitSuffix == null) {
            copiedUnitSuffix = DEFAULT_COPIED_UNIT_SUFFIX;
        }
        if (moduleSuffix == null) {
            moduleSuffix = DEFAULT_MODULE_UNIT_SUFFIX;
        }
        this.suffixes[0][1] = copiedUnitSuffix;
        this.suffixes[1][0] = tgtVarSuffix;
        this.suffixes[1][1] = tgtFuncSuffix;
        this.suffixes[1][2] = tgtModuleSuffix == null ? DEFAULT_MODULE_UNIT_SUFFIX : tgtModuleSuffix;
        this.suffixes[1][3] = moduleSuffix;
        this.suffixes[2][0] = adjVarSuffix;
        this.suffixes[2][1] = adjFuncSuffix;
        this.suffixes[2][2] = adjModuleSuffix == null ? DEFAULT_MODULE_UNIT_SUFFIX : adjModuleSuffix;
        this.suffixes[2][3] = moduleSuffix;
        this.suffixes[3][0] = adjVarSuffix;
        this.suffixes[3][2] = adjModuleSuffix == null ? DEFAULT_MODULE_UNIT_SUFFIX : adjModuleSuffix;
        this.suffixes[3][3] = moduleSuffix;
        this.suffixes[4][0] = adjVarSuffix;
        this.suffixes[4][2] = adjModuleSuffix == null ? DEFAULT_MODULE_UNIT_SUFFIX : adjModuleSuffix;
        this.suffixes[4][3] = moduleSuffix;
        if (this.suffixes[0][1].isEmpty()) {
            this.suffixes[0][1] = "";
        }
        String string = TapEnv.mustTangent() ? (TapEnv.mustAdjoint() ? (TapEnv.get().multiDirDiffMode ? TapEnv.extendStringWithSuffix("_db", TapEnv.get().multiFuncSuffix) : "_db") : tgtFuncSuffix) : (TapEnv.mustAdjoint() ? adjFuncSuffix : (TapEnv.get().diffFileSuffix = copiedUnitSuffix.isEmpty() ? DEFAULT_COPIED_UNIT_SUFFIX : copiedUnitSuffix));
        if (!TapEnv.mustTangent() && !TapEnv.mustAdjoint()) {
            TapEnv.get().diffFileSuffix = TapEnv.modeIsOverloading() ? tgtFuncSuffix : TapEnv.get().preprocessFileSuffix;
        }
        String string2 = TapEnv.mustTangent() ? (TapEnv.mustAdjoint() ? moduleSuffix : this.suffixes[1][2]) : (this.suffixes[1][2] = TapEnv.mustAdjoint() ? this.suffixes[2][2] : moduleSuffix);
        if (tgtModuleSuffix != null && !tgtModuleSuffix.equals(this.suffixes[2][2]) || adjModuleSuffix != null && !adjModuleSuffix.equals(this.suffixes[1][2])) {
            this.suffixes[0][1] = "_c" + (TapEnv.mustTangent() ? "d" : "b");
        }
        if (TapEnv.get().multiDirDiffMode && (TapEnv.mustTangent() || TapEnv.mustAdjoint()) && !DEFAULT_COPIED_UNIT_SUFFIX.equals(this.suffixes[1][2]) && !DEFAULT_COPIED_UNIT_SUFFIX.equals(this.suffixes[2][2])) {
            this.suffixes[1][2] = TapEnv.extendStringWithSuffix(this.suffixes[1][2], TapEnv.get().multiFuncSuffix);
            this.suffixes[2][2] = TapEnv.extendStringWithSuffix(this.suffixes[2][2], TapEnv.get().multiFuncSuffix);
        }
        this.suffixes[1][3] = this.suffixes[1][2];
        this.suffixes[2][3] = this.suffixes[2][2];
        this.suffixes[4][3] = this.suffixes[4][2];
    }

    private TapList<String> collectUnitNamesFromString(String str) {
        StringTokenizer tokenizer = new StringTokenizer(str, " ,");
        TapList<String> result = null;
        while (tokenizer.hasMoreElements()) {
            String name = tokenizer.nextToken();
            result = new TapList<String>(name, result);
        }
        return result;
    }

    private void parseDiffRoots(String cmdStr) {
        String diffRootFunc = null;
        String diffRootCasN = null;
        String diffRootIndeps = null;
        String diffRootDeps = null;
        StrIndex strIndex = new StrIndex(cmdStr);
        int state = 0;
        StrIndex toPiece = new StrIndex("");
        int pieceKind = this.getNextDiffRootPiece(strIndex, toPiece);
        while (pieceKind != 0) {
            block0 : switch (state) {
                case 0: {
                    if (pieceKind == 1) {
                        diffRootFunc = toPiece.str;
                        state = 1;
                        break;
                    }
                    TapEnv.commandWarning(-1, "Wrong argument syntax. Ignored: " + toPiece.str);
                    break;
                }
                case 1: {
                    switch (pieceKind) {
                        case 1: {
                            this.flushDiffRoot(diffRootFunc, null, null, null);
                            diffRootFunc = toPiece.str;
                            break block0;
                        }
                        case 2: {
                            diffRootCasN = toPiece.str;
                            state = 2;
                            break block0;
                        }
                        case 3: {
                            diffRootDeps = toPiece.str;
                            state = 5;
                            break block0;
                        }
                        case 4: {
                            state = 3;
                            break block0;
                        }
                        case 5: {
                            state = 4;
                            break block0;
                        }
                    }
                    TapEnv.commandWarning(-1, "Wrong argument syntax. Ignored: " + toPiece.str);
                    break;
                }
                case 2: {
                    switch (pieceKind) {
                        case 1: {
                            this.flushDiffRoot(diffRootFunc, diffRootCasN, null, null);
                            diffRootCasN = null;
                            diffRootFunc = toPiece.str;
                            break block0;
                        }
                        case 3: {
                            diffRootDeps = toPiece.str;
                            state = 5;
                            break block0;
                        }
                        case 4: {
                            state = 3;
                            break block0;
                        }
                        case 5: {
                            state = 4;
                            break block0;
                        }
                    }
                    TapEnv.commandWarning(-1, "Wrong argument syntax. Ignored: " + toPiece.str);
                    break;
                }
                case 3: {
                    switch (pieceKind) {
                        case 1: {
                            this.flushDiffRoot(diffRootFunc, diffRootCasN, null, diffRootDeps);
                            diffRootIndeps = null;
                            diffRootDeps = null;
                            diffRootCasN = null;
                            diffRootFunc = toPiece.str;
                            state = 1;
                            break block0;
                        }
                        case 3: {
                            diffRootIndeps = toPiece.str;
                            this.flushDiffRoot(diffRootFunc, diffRootCasN, diffRootIndeps, diffRootDeps);
                            diffRootFunc = null;
                            diffRootIndeps = null;
                            diffRootDeps = null;
                            diffRootCasN = null;
                            state = 0;
                            break block0;
                        }
                    }
                    TapEnv.commandWarning(-1, "Wrong argument syntax. Ignored: " + toPiece.str);
                    break;
                }
                case 4: {
                    switch (pieceKind) {
                        case 1: {
                            this.flushDiffRoot(diffRootFunc, diffRootCasN, diffRootIndeps, null);
                            diffRootIndeps = null;
                            diffRootDeps = null;
                            diffRootCasN = null;
                            diffRootFunc = toPiece.str;
                            state = 1;
                            break block0;
                        }
                        case 3: {
                            this.flushDiffRoot(diffRootFunc, diffRootCasN, diffRootIndeps, toPiece.str);
                            diffRootFunc = null;
                            diffRootIndeps = null;
                            diffRootDeps = null;
                            diffRootCasN = null;
                            state = 0;
                            break block0;
                        }
                    }
                    TapEnv.commandWarning(-1, "Wrong argument syntax. Ignored: " + toPiece.str);
                    break;
                }
                case 5: {
                    switch (pieceKind) {
                        case 1: {
                            this.flushDiffRoot(diffRootFunc, diffRootCasN, null, diffRootDeps);
                            diffRootIndeps = null;
                            diffRootDeps = null;
                            diffRootCasN = null;
                            diffRootFunc = toPiece.str;
                            state = 1;
                            break block0;
                        }
                        case 3: {
                            diffRootIndeps = diffRootDeps;
                            diffRootDeps = toPiece.str;
                            this.flushDiffRoot(diffRootFunc, diffRootCasN, diffRootIndeps, diffRootDeps);
                            diffRootFunc = null;
                            diffRootIndeps = null;
                            diffRootDeps = null;
                            diffRootCasN = null;
                            state = 0;
                            break block0;
                        }
                        case 4: {
                            state = 3;
                            break block0;
                        }
                        case 5: {
                            diffRootIndeps = diffRootDeps;
                            diffRootDeps = null;
                            state = 4;
                            break block0;
                        }
                    }
                    TapEnv.commandWarning(-1, "Wrong argument syntax. Ignored: " + toPiece.str);
                    break;
                }
                default: {
                    TapEnv.commandWarning(-1, "Wrong argument syntax. Ignored: " + toPiece.str + " " + strIndex.str.substring(strIndex.index));
                    strIndex.str = "";
                    strIndex.index = 0;
                }
            }
            pieceKind = this.getNextDiffRootPiece(strIndex, toPiece);
        }
        if (diffRootFunc != null) {
            this.flushDiffRoot(diffRootFunc, diffRootCasN, diffRootIndeps, diffRootDeps);
        }
    }

    private int getNextDiffRootPiece(StrIndex strIndex, StrIndex toPiece) {
        String str = strIndex.str;
        int found = 0;
        if (str != null) {
            int i;
            int strlen = str.length();
            int ifirst = i = strIndex.index;
            int ilast = -1;
            int inext = i;
            int state = 0;
            while (i < strlen && state != 10) {
                char chari = str.charAt(i);
                switch (state) {
                    case 0: {
                        if (chari != ' ') {
                            if (chari == '\\' || chari == '>') {
                                found = 5;
                                state = 10;
                            } else if (chari == '/') {
                                found = 4;
                                state = 10;
                            } else if (chari == '(') {
                                ifirst = ilast = i + 1;
                                found = 3;
                                state = 3;
                            } else if (chari == '[') {
                                ifirst = ilast = i + 1;
                                found = 2;
                                state = 2;
                            } else {
                                ifirst = i;
                                ilast = i + 1;
                                found = 1;
                                state = 1;
                            }
                        }
                        inext = i + 1;
                        break;
                    }
                    case 3: {
                        if (chari == ')') {
                            ilast = i;
                            state = 10;
                        } else {
                            ilast = i + 1;
                        }
                        inext = i + 1;
                        break;
                    }
                    case 2: {
                        if (chari == ']') {
                            ilast = i;
                            state = 10;
                        } else {
                            ilast = i + 1;
                        }
                        inext = i + 1;
                        break;
                    }
                    case 1: {
                        if (chari == ' ' || chari == '\\' || chari == '>' || chari == '/' || chari == '(' || chari == '[') {
                            ilast = inext = i;
                            state = 10;
                            break;
                        }
                        ilast = inext = i + 1;
                        break;
                    }
                }
                ++i;
            }
            if (found == 1 || found == 3) {
                toPiece.str = str.substring(ifirst, ilast);
            } else if (found == 2) {
                toPiece.str = this.stripWhitesInCasN(str.substring(ifirst, ilast));
            } else {
                toPiece.str = null;
            }
            strIndex.index = inext;
        }
        return found;
    }

    private String stripWhitesInCasN(String str) {
        StringBuilder buffer = new StringBuilder();
        boolean placeSeparator = false;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == ' ') {
                placeSeparator = true;
                continue;
            }
            if (placeSeparator && buffer.length() != 0) {
                buffer.append('_');
            }
            buffer.append(str.charAt(i));
            placeSeparator = false;
        }
        return buffer.toString();
    }

    private void parseDiffVars(String cmdStr) {
        this.flushDiffRoot(null, null, cmdStr, null);
    }

    private void parseDiffOutvars(String cmdStr) {
        this.flushDiffRoot(null, null, null, cmdStr);
    }

    private void flushDiffRoot(String func, String casN, String indeps, String deps) {
        TapList<String> parsedIdent;
        StringTokenizer varsTokenizer;
        TapList<Object> inCumulVars = new TapList<Object>(null, null);
        if (indeps != null) {
            varsTokenizer = new StringTokenizer(indeps, " ,");
            while (varsTokenizer.hasMoreElements()) {
                parsedIdent = TapList.parseIdentifier(varsTokenizer.nextToken());
                Tapenade.addIdentInList(parsedIdent, inCumulVars);
            }
            if (func == null) {
                if (this.unfinishedInVars == null) {
                    this.waitingInVars = inCumulVars;
                } else {
                    this.unfinishedInVars.setIndepsPathNames(inCumulVars.tail);
                    this.unfinishedInVars = null;
                }
            }
        }
        TapList<Object> outCumulVars = new TapList<Object>(null, null);
        if (deps != null) {
            varsTokenizer = new StringTokenizer(deps, " ,");
            while (varsTokenizer.hasMoreElements()) {
                parsedIdent = TapList.parseIdentifier(varsTokenizer.nextToken());
                Tapenade.addIdentInList(parsedIdent, outCumulVars);
            }
            if (func == null) {
                if (this.unfinishedOutVars == null) {
                    this.waitingOutVars = outCumulVars;
                } else {
                    this.unfinishedOutVars.setDepsPathNames(outCumulVars.tail);
                    this.unfinishedOutVars = null;
                }
            }
        }
        if (func != null) {
            DiffRoot thisDiffRoot;
            parsedIdent = TapList.parseIdentifier(func);
            TapList<DiffRoot> inDiffRoots = this.diffRoots;
            while (inDiffRoots != null && Tapenade.neqIdentifiers(((DiffRoot)inDiffRoots.head).unitPathName(), parsedIdent)) {
                inDiffRoots = inDiffRoots.tail;
            }
            if (inDiffRoots == null) {
                this.diffRoots = new TapList<DiffRoot>(new DiffRoot(null, parsedIdent, null), this.diffRoots);
                thisDiffRoot = (DiffRoot)this.diffRoots.head;
            } else {
                thisDiffRoot = (DiffRoot)inDiffRoots.head;
            }
            DiffPattern thisDiffPattern = new DiffPattern(casN, null, null);
            if (indeps == null) {
                if (this.waitingInVars != null) {
                    thisDiffPattern.setIndepsPathNames(this.waitingInVars.tail);
                    this.waitingInVars = null;
                } else {
                    this.unfinishedInVars = thisDiffPattern;
                }
            } else {
                thisDiffPattern.setIndepsPathNames(inCumulVars.tail);
            }
            if (deps == null) {
                if (this.waitingOutVars != null) {
                    thisDiffPattern.setDepsPathNames(this.waitingOutVars.tail);
                    this.waitingOutVars = null;
                } else {
                    this.unfinishedOutVars = thisDiffPattern;
                }
            } else {
                thisDiffPattern.setDepsPathNames(outCumulVars.tail);
            }
            thisDiffRoot.appendDiffPattern(thisDiffPattern);
        }
    }

    private void parseMixedLanguage(String cmdStr) {
        if (cmdStr != null) {
            String[] cmdArray = cmdStr.split("\\s+", -1);
            boolean error = cmdArray.length < 5;
            int origLang = Tapenade.parseLanguage(cmdArray[0]);
            int destLang = Tapenade.parseLanguage(cmdArray[1]);
            if (origLang == -1 || destLang == -1) {
                TapEnv.commandWarning(-1, "Undefined language in: " + cmdStr);
                error = true;
            }
            if (error) {
                TapEnv.commandWarning(-1, "Mixed language info ignored: " + cmdStr);
            } else {
                TapEnv.addMixedLanguageInfos(new MixedLanguageInfos(origLang, destLang, cmdArray[2], cmdArray[3], cmdArray[4]));
            }
        }
    }

    private void htmlOutput() {
        String osName = System.getProperty("os.name").toLowerCase();
        File sourceDirFile = new File(TapEnv.tapenadeHome + File.separator + "build" + File.separator + "libs" + File.separator);
        String sourceDir = sourceDirFile.getPath() + File.separator;
        String tapenadedir = File.separator + TAPENADE_GEN_HTML_DIR + File.separator;
        String outputdir = this.outputDirectory + tapenadedir;
        Tapenade.extractFiles(outputdir, sourceDir + "tapenadehtml.jar");
        String browser = System.getProperty("browser");
        if (browser == null || browser.isEmpty()) {
            browser = osName.startsWith("windows") ? "iexplore" : "firefox";
        }
        String[] cmd = new String[2];
        String path = this.outputDirectory + tapenadedir + "tapenade.html";
        File file = new File(path);
        path = file.getAbsolutePath();
        cmd[0] = browser;
        cmd[1] = path;
        TapEnv.printlnOnTrace("Viewing result: " + cmd[0] + " " + cmd[1]);
        (new Thread(){
            private String[] cmd;

            private void start(String[] c) {
                this.cmd = (String[])c.clone();
                this.start();
            }

            @Override
            public void run() {
                try {
                    Process p = Runtime.getRuntime().exec(this.cmd);
                    InputStream err = p.getErrorStream();
                    this.loadStream(err);
                }
                catch (IOException | IndexOutOfBoundsException | NullPointerException | SecurityException e) {
                    TapEnv.toolError(e.toString());
                }
            }

            private void loadStream(InputStream in) throws IOException {
                int ptr;
                in = new BufferedInputStream(in);
                StringBuilder buffer = new StringBuilder();
                while ((ptr = in.read()) != -1) {
                    buffer.append((char)ptr);
                }
            }
        }).start(cmd);
    }

    protected String cssDir() {
        return this.cssDir;
    }

    private static final class FutureFile {
        private final Tree tree;
        private final int language;
        private final int oppositeHtmlLanguage;
        private final String fileName;
        private final String oppositeHtmlFileName;
        private final boolean isIncludeFile;

        private FutureFile(Tree tr, int lang, String filename, int oppositelanguage, String oppositehtmlfilename, boolean isincludefile) {
            this.tree = tr;
            this.language = lang;
            this.fileName = filename;
            this.oppositeHtmlLanguage = oppositelanguage;
            this.oppositeHtmlFileName = oppositehtmlfilename;
            this.isIncludeFile = isincludefile;
        }

        public String toString() {
            return "<FutureFile " + this.fileName + " lang:" + this.language + " [HTML opposite:" + this.oppositeHtmlFileName + "] tree:" + (this.tree == null ? "empty" : this.tree.length() + "children") + ">";
        }
    }

    private static class StrIndex {
        private String str;
        private int index;

        StrIndex(String strg) {
            this.str = strg;
        }
    }
}

