/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.utils;

import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.utils.ILLangOps;
import fr.inria.tapenade.utils.Operator;
import fr.inria.tapenade.utils.Phylum;
import fr.inria.tapenade.utils.Tree;
import java.io.BufferedWriter;
import java.io.IOException;

class FixedTree
extends Tree {
    private final Tree[] sons;

    protected FixedTree(Operator operator) {
        super(operator);
        this.sons = new Tree[operator.arity];
    }

    @Override
    public void setChild(Tree newChild, int rank) {
        this.connectNewChild(newChild, this.sons, rank - 1);
    }

    @Override
    public Tree cutChild(int rank) {
        Tree child = this.sons[rank - 1];
        if (child != null) {
            child.setParent(null);
            this.sons[rank - 1] = ILLangOps.ops(136).tree();
        }
        return child;
    }

    @Override
    public Tree copy() {
        FixedTree newTree = (FixedTree)this.operator().tree();
        for (int i = this.sons.length - 1; i >= 0; --i) {
            if (this.sons[i] != null) {
                newTree.connectNewChild(this.sons[i].copy(), newTree.sons, i);
                continue;
            }
            newTree.sons[i] = null;
        }
        newTree.copyAnnotations(this);
        return newTree;
    }

    @Override
    protected boolean checkSyntax(Phylum phylum, String path) {
        boolean correct = super.checkSyntax(phylum, path);
        int[] childrenPhyla = this.operator().childrenPhyla;
        path = path + " " + this.operator().name + ":";
        for (int i = 0; i < this.sons.length; ++i) {
            Phylum childPhylum = ILLangOps.phyla(childrenPhyla[i]);
            if (this.sons[i] == null) {
                TapEnv.toolError("Checking Tree: null child at " + path + (i + 1) + " ... " + this.parent());
                correct = false;
                continue;
            }
            if (this.sons[i].checkSyntax(childPhylum, path + (i + 1))) continue;
            correct = false;
        }
        return correct;
    }

    @Override
    public boolean isAtom() {
        return false;
    }

    @Override
    public boolean isStringAtom() {
        return false;
    }

    @Override
    public boolean isIntAtom() {
        return false;
    }

    @Override
    public boolean isList() {
        return false;
    }

    @Override
    public boolean isFixed() {
        return true;
    }

    @Override
    public int length() {
        return this.sons.length;
    }

    @Override
    public Tree[] children() {
        return this.sons;
    }

    @Override
    public TapList<Tree> childrenList() {
        TapList<Tree> list = null;
        for (int index = this.sons.length - 1; index >= 0; --index) {
            list = new TapList<Tree>(this.sons[index], list);
        }
        return list;
    }

    @Override
    public Tree down(int rank) {
        if (rank - 1 < this.sons.length) {
            return this.sons[rank - 1];
        }
        return null;
    }

    @Override
    public int getRank(Tree son) {
        for (int i = this.sons.length - 1; i >= 0; --i) {
            if (this.sons[i] != son) continue;
            return i + 1;
        }
        return -1;
    }

    @Override
    public boolean equalsTree(Tree other) {
        if (other == null || this.operator() != other.operator()) {
            return false;
        }
        for (int i = this.sons.length - 1; i >= 0; --i) {
            if (!(this.sons[i] == null ? ((FixedTree)other).sons[i] != null : !this.sons[i].equalsTree(((FixedTree)other).sons[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void writeToILFile(BufferedWriter fileWriter) throws IOException {
        this.operator().writeToILFile(fileWriter);
        for (Tree son : this.sons) {
            if (son == null) {
                ILLangOps.ops(136).writeToILFile(fileWriter);
                continue;
            }
            son.writeToILFile(fileWriter);
        }
    }

    @Override
    public String toString() {
        StringBuilder childrenStr = new StringBuilder();
        for (int i = this.sons.length - 1; i >= 0; --i) {
            childrenStr.insert(0, this.sons[i]);
            if (i <= 0) continue;
            childrenStr.insert(0, ", ");
        }
        return this.operator() + "(" + childrenStr + ')';
    }
}

