/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.utils;

import fr.inria.tapenade.utils.Operator;
import fr.inria.tapenade.utils.Tree;
import java.io.BufferedWriter;
import java.io.IOException;

class IAtomTree
extends Tree {
    private int value;

    protected IAtomTree(Operator operator) {
        super(operator);
    }

    @Override
    public void setValue(int value) {
        this.value = value;
    }

    @Override
    public Tree copy() {
        IAtomTree newTree = (IAtomTree)this.operator().tree();
        newTree.value = this.value;
        newTree.copyAnnotations(this);
        return newTree;
    }

    @Override
    public boolean isAtom() {
        return true;
    }

    @Override
    public boolean isStringAtom() {
        return false;
    }

    @Override
    public boolean isIntAtom() {
        return true;
    }

    @Override
    public boolean isList() {
        return false;
    }

    @Override
    public boolean isFixed() {
        return false;
    }

    @Override
    public int length() {
        return 0;
    }

    @Override
    public Tree[] children() {
        return null;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public String stringValue() {
        return String.valueOf(this.value);
    }

    @Override
    public boolean equalsTree(Tree other) {
        if (other == null || this.operator() != other.operator()) {
            return false;
        }
        return this.value == ((IAtomTree)other).value;
    }

    @Override
    public void writeToILFile(BufferedWriter fileWriter) throws IOException {
        this.operator().writeToILFile(fileWriter);
        fileWriter.write(this.value + System.lineSeparator());
    }

    @Override
    public String toString() {
        return this.operator() + ":" + this.value;
    }
}

