!        Generated by TAPENADE     (INRIA, Ecuador team)
!  Tapenade 3.16 (master) -  9 Oct 2020 17:47
!
! external library updated to work with Tapenade and wrapped
MODULE MWD_BAYESIAN_TOOLS_DIFF
  IMPLICIT NONE
!integer,parameter::mrk= selected_real_kind(p=8) ! sp in SMASH vs. mrk in DMSL?
! sp in SMASH vs. mrk in DMSL?
  INTEGER, PARAMETER :: mrk=8
!
  INTEGER, PARAMETER :: mik=8
  INTEGER(mik), PARAMETER :: len_longstr=256
! flag for undefined real numbers
  REAL(mrk), PARAMETER :: undefrn=-999999999._mrk
! flag for undefined integer numbers
  INTEGER(mik), PARAMETER :: undefin=-999999999
! missing value threshold -9999._mrk in BaM, 0 in Smash
  REAL(mrk), PARAMETER :: mv=-0._mrk
  REAL(mrk), PARAMETER :: pi=&
&   3.1415926535897932384626433832795028841971693993751_mrk
!$F90W char
! BEN 2DO: try linking wit existing type in BMSL's BayesianEstimation_tools
  TYPE, PUBLIC :: PRIORTYPE
      CHARACTER(len=250) :: dist='FlatPrior'
      REAL(mrk), ALLOCATABLE :: par(:)
  END TYPE PRIORTYPE
! type, public:: PriorListType
!     type(PriorType),allocatable::prior(:)
! end type PriorListType
  PUBLIC :: compute_logpost, compute_loglkh, compute_logprior, &
& compute_logh, mufunk_vect, sigmafunk_vect
  PUBLIC :: compute_logpost_d, compute_loglkh_d, compute_logprior_d, &
& compute_logpost_b, compute_loglkh_b, compute_logprior_b

CONTAINS
  SUBROUTINE PRIORTYPE_INITIALISE(this, n)
    IMPLICIT NONE
    TYPE(PRIORTYPE), INTENT(INOUT) :: this
    INTEGER, INTENT(IN) :: n
    ALLOCATE(this%par(n))
  END SUBROUTINE PRIORTYPE_INITIALISE

!  Differentiation of compute_loglkh in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: loglkh
!   with respect to varying inputs: sigma_gamma mu_gamma sim
! subroutine PriorListType_initialise(this, n)
!     type(PriorListType),intent(inout)::this
!     integer, intent(in) :: n
!     integer :: i
!     allocate(this%prior(n))
!     do i = 1, n
!         call PriorType_initialise(this%prior(i), 0)
!     end do
! end subroutine PriorListType_initialise
  SUBROUTINE COMPUTE_LOGLKH_D(obs, uobs, sim, sim_d, mu_funk, mu_gamma, &
&   mu_gamma_d, sigma_funk, sigma_gamma, sigma_gamma_d, loglkh, loglkh_d&
&   , feas, isnull)
    IMPLICIT NONE
! nT*nS
    REAL(mrk), INTENT(IN) :: obs(:, :), sim(:, :), uobs(:, :)
    REAL(mrk), INTENT(IN) :: sim_d(:, :)
    CHARACTER(len=*), INTENT(IN) :: mu_funk, sigma_funk
! nHyper*nS
    REAL(mrk), INTENT(IN) :: mu_gamma(:, :), sigma_gamma(:, :)
    REAL(mrk), INTENT(IN) :: mu_gamma_d(:, :), sigma_gamma_d(:, :)
    REAL(mrk), INTENT(OUT) :: loglkh
    REAL(mrk), INTENT(OUT) :: loglkh_d
    LOGICAL, INTENT(OUT) :: feas, isnull
! locals
    CHARACTER(len=len_longstr), PARAMETER :: procname='compute_logLkh'
    INTEGER(mik) :: ns, nt, s, t, err
    REAL(mrk) :: v, mu, sigma
    REAL(mrk) :: v_d, mu_d, sigma_d
    CHARACTER(len=len_longstr) :: mess
    INTRINSIC SIZE
    INTRINSIC TRIM
    INTRINSIC LOG
    REAL(mrk) :: temp
! Initialize
    loglkh = 0._mrk
    feas = .true.
    isnull = .false.
! Compute
    nt = SIZE(obs, dim=1)
    ns = SIZE(obs, dim=2)
    loglkh_d = 0.0_8
    DO s=1,ns
      DO t=1,nt
        IF (obs(t, s) .GE. mv .AND. uobs(t, s) .GE. mv) THEN
          CALL MUFUNK_APPLY_D(funk=mu_funk, par=mu_gamma(:, s), par_d=&
&                       mu_gamma_d(:, s), y=sim(t, s), y_d=sim_d(t, s), &
&                       res=mu, res_d=mu_d, err=err, mess=mess)
          IF (err .GT. 0) THEN
            feas = .false.
! return removed for Tapenade
          END IF
          CALL SIGMAFUNK_APPLY_D(funk=sigma_funk, par=sigma_gamma(:, s)&
&                          , par_d=sigma_gamma_d(:, s), y=sim(t, s), y_d&
&                          =sim_d(t, s), res=sigma, res_d=sigma_d, err=&
&                          err, mess=mess)
          IF (err .GT. 0) THEN
            feas = .false.
! return removed for Tapenade
          END IF
          v_d = 2*sigma*sigma_d
          v = sigma**2 + uobs(t, s)**2
          IF (v .LE. 0._mrk) THEN
            feas = .false.
! return removed for Tapenade
!exit
          END IF
          temp = (obs(t, s)-sim(t, s)-mu)*(obs(t, s)-sim(t, s)-mu)/v
          loglkh_d = loglkh_d - 0.5_mrk*(v_d/v+(2*(obs(t, s)-sim(t, s)-&
&           mu)*(-sim_d(t, s)-mu_d)-temp*v_d)/v)
          loglkh = loglkh - 0.5_mrk*(LOG(pi*2._mrk)+LOG(v)+temp)
        END IF
      END DO
    END DO
  END SUBROUTINE COMPUTE_LOGLKH_D

!  Differentiation of compute_loglkh in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: loglkh
!   with respect to varying inputs: sigma_gamma mu_gamma sim
! subroutine PriorListType_initialise(this, n)
!     type(PriorListType),intent(inout)::this
!     integer, intent(in) :: n
!     integer :: i
!     allocate(this%prior(n))
!     do i = 1, n
!         call PriorType_initialise(this%prior(i), 0)
!     end do
! end subroutine PriorListType_initialise
  SUBROUTINE COMPUTE_LOGLKH_B(obs, uobs, sim, sim_b, mu_funk, mu_gamma, &
&   mu_gamma_b, sigma_funk, sigma_gamma, sigma_gamma_b, loglkh, loglkh_b&
&   , feas, isnull)
    IMPLICIT NONE
! nT*nS
    REAL(mrk), INTENT(IN) :: obs(:, :), sim(:, :), uobs(:, :)
    REAL(mrk) :: sim_b(:, :)
    CHARACTER(len=*), INTENT(IN) :: mu_funk, sigma_funk
! nHyper*nS
    REAL(mrk), INTENT(IN) :: mu_gamma(:, :), sigma_gamma(:, :)
    REAL(mrk) :: mu_gamma_b(:, :), sigma_gamma_b(:, :)
    REAL(mrk) :: loglkh
    REAL(mrk) :: loglkh_b
    LOGICAL, INTENT(OUT) :: feas, isnull
! locals
    CHARACTER(len=len_longstr), PARAMETER :: procname='compute_logLkh'
    INTEGER(mik) :: ns, nt, s, t, err
    REAL(mrk) :: v, mu, sigma
    REAL(mrk) :: v_b, mu_b, sigma_b
    CHARACTER(len=len_longstr) :: mess
    INTRINSIC SIZE
    INTRINSIC TRIM
    INTRINSIC LOG
    REAL(mrk) :: temp_b
    REAL(mrk) :: temp
    REAL(mrk) :: temp_b0
    INTEGER :: branch
! Initialize
! Compute
    nt = SIZE(obs, dim=1)
    ns = SIZE(obs, dim=2)
    DO s=1,ns
      DO t=1,nt
        IF (obs(t, s) .GE. mv .AND. uobs(t, s) .GE. mv) THEN
          CALL PUSHREAL8(mu)
          CALL MUFUNK_APPLY(funk=mu_funk, par=mu_gamma(:, s), y=sim(t, s&
&                     ), res=mu, err=err, mess=mess)
          CALL PUSHREAL8(sigma)
          CALL SIGMAFUNK_APPLY(funk=sigma_funk, par=sigma_gamma(:, s), y&
&                        =sim(t, s), res=sigma, err=err, mess=mess)
          CALL PUSHREAL8(v)
          v = sigma**2 + uobs(t, s)**2
          CALL PUSHCONTROL1B(1)
        ELSE
          CALL PUSHCONTROL1B(0)
        END IF
      END DO
    END DO
    sigma_gamma_b = 0.0_8
    mu_gamma_b = 0.0_8
    sim_b = 0.0_8
    DO s=ns,1,-1
      DO t=nt,1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) THEN
          temp_b = -(0.5_mrk*loglkh_b/v)
          temp = obs(t, s) - sim(t, s) - mu
          v_b = -(0.5_mrk*loglkh_b/v) - temp**2*temp_b/v
          temp_b0 = 2*temp*temp_b
          sim_b(t, s) = sim_b(t, s) - temp_b0
          mu_b = -temp_b0
          CALL POPREAL8(v)
          sigma_b = 2*sigma*v_b
          CALL POPREAL8(sigma)
          CALL SIGMAFUNK_APPLY_B(funk=sigma_funk, par=sigma_gamma(:, s)&
&                          , par_b=sigma_gamma_b(:, s), y=sim(t, s), y_b&
&                          =sim_b(t, s), res=sigma, res_b=sigma_b, err=&
&                          err, mess=mess)
          CALL POPREAL8(mu)
          CALL MUFUNK_APPLY_B(funk=mu_funk, par=mu_gamma(:, s), par_b=&
&                       mu_gamma_b(:, s), y=sim(t, s), y_b=sim_b(t, s), &
&                       res=mu, res_b=mu_b, err=err, mess=mess)
        END IF
      END DO
    END DO
  END SUBROUTINE COMPUTE_LOGLKH_B

! subroutine PriorListType_initialise(this, n)
!     type(PriorListType),intent(inout)::this
!     integer, intent(in) :: n
!     integer :: i
!     allocate(this%prior(n))
!     do i = 1, n
!         call PriorType_initialise(this%prior(i), 0)
!     end do
! end subroutine PriorListType_initialise
  SUBROUTINE COMPUTE_LOGLKH(obs, uobs, sim, mu_funk, mu_gamma, &
&   sigma_funk, sigma_gamma, loglkh, feas, isnull)
    IMPLICIT NONE
! nT*nS
    REAL(mrk), INTENT(IN) :: obs(:, :), sim(:, :), uobs(:, :)
    CHARACTER(len=*), INTENT(IN) :: mu_funk, sigma_funk
! nHyper*nS
    REAL(mrk), INTENT(IN) :: mu_gamma(:, :), sigma_gamma(:, :)
    REAL(mrk), INTENT(OUT) :: loglkh
    LOGICAL, INTENT(OUT) :: feas, isnull
! locals
    CHARACTER(len=len_longstr), PARAMETER :: procname='compute_logLkh'
    INTEGER(mik) :: ns, nt, s, t, err
    REAL(mrk) :: v, mu, sigma
    CHARACTER(len=len_longstr) :: mess
    INTRINSIC SIZE
    INTRINSIC TRIM
    INTRINSIC LOG
! Initialize
    loglkh = 0._mrk
    feas = .true.
    isnull = .false.
! Compute
    nt = SIZE(obs, dim=1)
    ns = SIZE(obs, dim=2)
    DO s=1,ns
      DO t=1,nt
        IF (obs(t, s) .GE. mv .AND. uobs(t, s) .GE. mv) THEN
          CALL MUFUNK_APPLY(mu_funk, mu_gamma(:, s), sim(t, s), mu, err&
&                     , mess)
          IF (err .GT. 0) THEN
            mess = TRIM(procname)//': '//TRIM(mess)
            feas = .false.
! return removed for Tapenade
          END IF
          CALL SIGMAFUNK_APPLY(sigma_funk, sigma_gamma(:, s), sim(t, s)&
&                        , sigma, err, mess)
          IF (err .GT. 0) THEN
            mess = TRIM(procname)//': '//TRIM(mess)
            feas = .false.
! return removed for Tapenade
          END IF
          v = sigma**2 + uobs(t, s)**2
          IF (v .LE. 0._mrk) THEN
            feas = .false.
! return removed for Tapenade
!exit
          END IF
          loglkh = loglkh - 0.5_mrk*(LOG(2._mrk*pi)+LOG(v)+(obs(t, s)-&
&           sim(t, s)-mu)**2/v)
        END IF
      END DO
    END DO
  END SUBROUTINE COMPUTE_LOGLKH

!  Differentiation of compute_logprior in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: logprior
!   with respect to varying inputs: sigma_gamma mu_gamma theta
  SUBROUTINE COMPUTE_LOGPRIOR_D(theta, theta_d, theta_prior, mu_gamma, &
&   mu_gamma_d, mu_gamma_prior, sigma_gamma, sigma_gamma_d, &
&   sigma_gamma_prior, logprior, logprior_d, feas, isnull)
    IMPLICIT NONE
    REAL(mrk), INTENT(IN) :: theta(:), mu_gamma(:, :), sigma_gamma(:, :)
    REAL(mrk), INTENT(IN) :: theta_d(:), mu_gamma_d(:, :), sigma_gamma_d&
&   (:, :)
    TYPE(PRIORTYPE), INTENT(IN) :: theta_prior(:), mu_gamma_prior(:, :)&
&   , sigma_gamma_prior(:, :)
    REAL(mrk), INTENT(OUT) :: logprior
    REAL(mrk), INTENT(OUT) :: logprior_d
    LOGICAL, INTENT(OUT) :: feas, isnull
! locals
    REAL(mrk) :: pdf
    REAL(mrk) :: pdf_d
    REAL(mrk) :: dummytheta(SIZE(theta), 1)
    REAL(mrk) :: dummytheta_d(SIZE(theta), 1)
    TYPE(PRIORTYPE) :: dummytheta_prior(SIZE(theta_prior), 1)
    INTRINSIC SIZE
! Initialize
    logprior = 0.0_mrk
! theta
    dummytheta_d = 0.0_8
    dummytheta_d(:, 1) = theta_d
    dummytheta(:, 1) = theta
    dummytheta_prior(:, 1) = theta_prior
    CALL COMPUTE_LOGPRIOR_ENGINE_D(dummytheta, dummytheta_d, &
&                            dummytheta_prior, pdf, pdf_d, feas, isnull)
    IF ((.NOT.feas) .OR. isnull) THEN
      logprior_d = 0.0_8
    ELSE
      logprior_d = pdf_d
      logprior = logprior + pdf
! mu hyperparameters
      CALL COMPUTE_LOGPRIOR_ENGINE_D(mu_gamma, mu_gamma_d, &
&                              mu_gamma_prior, pdf, pdf_d, feas, isnull)
      IF (.NOT.((.NOT.feas) .OR. isnull)) THEN
        logprior_d = logprior_d + pdf_d
        logprior = logprior + pdf
! sigma hyperparameters
        CALL COMPUTE_LOGPRIOR_ENGINE_D(sigma_gamma, sigma_gamma_d, &
&                                sigma_gamma_prior, pdf, pdf_d, feas, &
&                                isnull)
        IF (.NOT.((.NOT.feas) .OR. isnull)) THEN
          logprior_d = logprior_d + pdf_d
          logprior = logprior + pdf
        END IF
      END IF
    END IF
  END SUBROUTINE COMPUTE_LOGPRIOR_D

!  Differentiation of compute_logprior in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: sigma_gamma mu_gamma logprior
!   with respect to varying inputs: sigma_gamma mu_gamma theta
  SUBROUTINE COMPUTE_LOGPRIOR_B(theta, theta_b, theta_prior, mu_gamma, &
&   mu_gamma_b, mu_gamma_prior, sigma_gamma, sigma_gamma_b, &
&   sigma_gamma_prior, logprior, logprior_b, feas, isnull)
    IMPLICIT NONE
    REAL(mrk), INTENT(IN) :: theta(:), mu_gamma(:, :), sigma_gamma(:, :)
    REAL(mrk) :: theta_b(:), mu_gamma_b(:, :), sigma_gamma_b(:, :)
    TYPE(PRIORTYPE), INTENT(IN) :: theta_prior(:), mu_gamma_prior(:, :)&
&   , sigma_gamma_prior(:, :)
    REAL(mrk) :: logprior
    REAL(mrk) :: logprior_b
    LOGICAL, INTENT(OUT) :: feas, isnull
! locals
    REAL(mrk) :: pdf
    REAL(mrk) :: pdf_b
    REAL(mrk) :: dummytheta(SIZE(theta), 1)
    REAL(mrk) :: dummytheta_b(SIZE(theta), 1)
    TYPE(PRIORTYPE) :: dummytheta_prior(SIZE(theta_prior), 1)
    INTRINSIC SIZE
! Initialize
! theta
    dummytheta(:, 1) = theta
    dummytheta_prior(:, 1) = theta_prior
    CALL COMPUTE_LOGPRIOR_ENGINE(dummytheta, dummytheta_prior, pdf, feas&
&                          , isnull)
    IF ((.NOT.feas) .OR. isnull) THEN
      pdf_b = 0.0_8
    ELSE
! mu hyperparameters
      CALL COMPUTE_LOGPRIOR_ENGINE(mu_gamma, mu_gamma_prior, pdf, feas, &
&                            isnull)
      IF ((.NOT.feas) .OR. isnull) THEN
        pdf_b = 0.0_8
      ELSE
! sigma hyperparameters
        CALL COMPUTE_LOGPRIOR_ENGINE(sigma_gamma, sigma_gamma_prior, pdf&
&                              , feas, isnull)
        IF ((.NOT.feas) .OR. isnull) THEN
          pdf_b = 0.0_8
        ELSE
          pdf_b = logprior_b
        END IF
        CALL COMPUTE_LOGPRIOR_ENGINE_B(sigma_gamma, sigma_gamma_b, &
&                                sigma_gamma_prior, pdf, pdf_b, feas, &
&                                isnull)
        pdf_b = logprior_b
      END IF
      CALL COMPUTE_LOGPRIOR_ENGINE_B(mu_gamma, mu_gamma_b, &
&                              mu_gamma_prior, pdf, pdf_b, feas, isnull)
      pdf_b = logprior_b
    END IF
    dummytheta_b = 0.0_8
    CALL COMPUTE_LOGPRIOR_ENGINE_B(dummytheta, dummytheta_b, &
&                            dummytheta_prior, pdf, pdf_b, feas, isnull)
    theta_b = 0.0_8
    theta_b = dummytheta_b(:, 1)
  END SUBROUTINE COMPUTE_LOGPRIOR_B

  SUBROUTINE COMPUTE_LOGPRIOR(theta, theta_prior, mu_gamma, &
&   mu_gamma_prior, sigma_gamma, sigma_gamma_prior, logprior, feas, &
&   isnull)
    IMPLICIT NONE
    REAL(mrk), INTENT(IN) :: theta(:), mu_gamma(:, :), sigma_gamma(:, :)
    TYPE(PRIORTYPE), INTENT(IN) :: theta_prior(:), mu_gamma_prior(:, :)&
&   , sigma_gamma_prior(:, :)
    REAL(mrk), INTENT(OUT) :: logprior
    LOGICAL, INTENT(OUT) :: feas, isnull
! locals
    REAL(mrk) :: pdf
    REAL(mrk) :: dummytheta(SIZE(theta), 1)
    TYPE(PRIORTYPE) :: dummytheta_prior(SIZE(theta_prior), 1)
    INTRINSIC SIZE
! Initialize
    logprior = 0.0_mrk
    feas = .true.
    isnull = .false.
! theta
    dummytheta(:, 1) = theta
    dummytheta_prior(:, 1) = theta_prior
    CALL COMPUTE_LOGPRIOR_ENGINE(dummytheta, dummytheta_prior, pdf, feas&
&                          , isnull)
    IF ((.NOT.feas) .OR. isnull) THEN
      RETURN
    ELSE
      logprior = logprior + pdf
! mu hyperparameters
      CALL COMPUTE_LOGPRIOR_ENGINE(mu_gamma, mu_gamma_prior, pdf, feas, &
&                            isnull)
      IF ((.NOT.feas) .OR. isnull) THEN
        RETURN
      ELSE
        logprior = logprior + pdf
! sigma hyperparameters
        CALL COMPUTE_LOGPRIOR_ENGINE(sigma_gamma, sigma_gamma_prior, pdf&
&                              , feas, isnull)
        IF ((.NOT.feas) .OR. isnull) THEN
          RETURN
        ELSE
          logprior = logprior + pdf
        END IF
      END IF
    END IF
  END SUBROUTINE COMPUTE_LOGPRIOR

  SUBROUTINE COMPUTE_LOGH(logh, feas, isnull)
    IMPLICIT NONE
    REAL(mrk), INTENT(OUT) :: logh
    LOGICAL, INTENT(OUT) :: feas, isnull
! Initialize
    logh = 0._mrk
    feas = .true.
    isnull = .false.
  END SUBROUTINE COMPUTE_LOGH

!  Differentiation of compute_logpost in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: logpost
!   with respect to varying inputs: sigma_gamma mu_gamma theta
!                sim
  SUBROUTINE COMPUTE_LOGPOST_D(obs, uobs, sim, sim_d, theta, theta_d, &
&   theta_prior, mu_funk, mu_gamma, mu_gamma_d, mu_gamma_prior, &
&   sigma_funk, sigma_gamma, sigma_gamma_d, sigma_gamma_prior, logpost, &
&   logpost_d, logprior, loglkh, logh, feas, isnull)
    IMPLICIT NONE
    REAL(mrk), INTENT(IN) :: obs(:, :), sim(:, :), uobs(:, :)
    REAL(mrk), INTENT(IN) :: sim_d(:, :)
    CHARACTER(len=*), INTENT(IN) :: mu_funk, sigma_funk
    REAL(mrk), INTENT(IN) :: theta(:), mu_gamma(:, :), sigma_gamma(:, :)
    REAL(mrk), INTENT(IN) :: theta_d(:), mu_gamma_d(:, :), sigma_gamma_d&
&   (:, :)
    TYPE(PRIORTYPE), INTENT(IN) :: theta_prior(:), mu_gamma_prior(:, :)&
&   , sigma_gamma_prior(:, :)
    REAL(mrk), INTENT(OUT) :: logpost, logprior, loglkh, logh
    REAL(mrk), INTENT(OUT) :: logpost_d
    LOGICAL, INTENT(OUT) :: feas, isnull
    REAL(mrk) :: loglkh_d
    REAL(mrk) :: logprior_d
! Initialize
    logpost = undefrn
! Prior
    CALL COMPUTE_LOGPRIOR_D(theta, theta_d, theta_prior, mu_gamma, &
&                     mu_gamma_d, mu_gamma_prior, sigma_gamma, &
&                     sigma_gamma_d, sigma_gamma_prior, logprior, &
&                     logprior_d, feas, isnull)
    IF ((.NOT.feas) .OR. isnull) THEN
      logpost_d = 0.0_8
    ELSE
! Likelihood
      CALL COMPUTE_LOGLKH_D(obs, uobs, sim, sim_d, mu_funk, mu_gamma, &
&                     mu_gamma_d, sigma_funk, sigma_gamma, sigma_gamma_d&
&                     , loglkh, loglkh_d, feas, isnull)
      IF ((.NOT.feas) .OR. isnull) THEN
        logpost_d = 0.0_8
      ELSE
! Hierarchical term
        CALL COMPUTE_LOGH(logh, feas, isnull)
        IF ((.NOT.feas) .OR. isnull) THEN
          logpost_d = 0.0_8
        ELSE
! Posterior
          logpost_d = loglkh_d + logprior_d
          logpost = loglkh + logprior + logh
        END IF
      END IF
    END IF
  END SUBROUTINE COMPUTE_LOGPOST_D

!  Differentiation of compute_logpost in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: logpost
!   with respect to varying inputs: sigma_gamma mu_gamma theta
!                sim
  SUBROUTINE COMPUTE_LOGPOST_B(obs, uobs, sim, sim_b, theta, theta_b, &
&   theta_prior, mu_funk, mu_gamma, mu_gamma_b, mu_gamma_prior, &
&   sigma_funk, sigma_gamma, sigma_gamma_b, sigma_gamma_prior, logpost, &
&   logpost_b, logprior, loglkh, logh, feas, isnull)
    IMPLICIT NONE
    REAL(mrk), INTENT(IN) :: obs(:, :), sim(:, :), uobs(:, :)
    REAL(mrk) :: sim_b(:, :)
    CHARACTER(len=*), INTENT(IN) :: mu_funk, sigma_funk
    REAL(mrk), INTENT(IN) :: theta(:), mu_gamma(:, :), sigma_gamma(:, :)
    REAL(mrk) :: theta_b(:), mu_gamma_b(:, :), sigma_gamma_b(:, :)
    TYPE(PRIORTYPE), INTENT(IN) :: theta_prior(:), mu_gamma_prior(:, :)&
&   , sigma_gamma_prior(:, :)
    REAL(mrk) :: logpost, logprior, loglkh, logh
    REAL(mrk) :: logpost_b
    LOGICAL, INTENT(OUT) :: feas, isnull
    REAL(mrk) :: loglkh_b
    REAL(mrk) :: logprior_b
! Initialize
! Prior
    CALL COMPUTE_LOGPRIOR(theta, theta_prior, mu_gamma, mu_gamma_prior, &
&                   sigma_gamma, sigma_gamma_prior, logprior, feas, &
&                   isnull)
    IF ((.NOT.feas) .OR. isnull) THEN
      sigma_gamma_b = 0.0_8
      mu_gamma_b = 0.0_8
      logprior_b = 0.0_8
      sim_b = 0.0_8
    ELSE
! Likelihood
      CALL COMPUTE_LOGLKH(obs, uobs, sim, mu_funk, mu_gamma, sigma_funk&
&                   , sigma_gamma, loglkh, feas, isnull)
      IF ((.NOT.feas) .OR. isnull) THEN
        loglkh_b = 0.0_8
        logprior_b = 0.0_8
      ELSE
! Hierarchical term
        CALL COMPUTE_LOGH(logh, feas, isnull)
        IF ((.NOT.feas) .OR. isnull) THEN
          loglkh_b = 0.0_8
          logprior_b = 0.0_8
        ELSE
          loglkh_b = logpost_b
          logprior_b = logpost_b
        END IF
      END IF
      CALL COMPUTE_LOGLKH_B(obs, uobs, sim, sim_b, mu_funk, mu_gamma, &
&                     mu_gamma_b, sigma_funk, sigma_gamma, sigma_gamma_b&
&                     , loglkh, loglkh_b, feas, isnull)
    END IF
    CALL COMPUTE_LOGPRIOR_B(theta, theta_b, theta_prior, mu_gamma, &
&                     mu_gamma_b, mu_gamma_prior, sigma_gamma, &
&                     sigma_gamma_b, sigma_gamma_prior, logprior, &
&                     logprior_b, feas, isnull)
  END SUBROUTINE COMPUTE_LOGPOST_B

  SUBROUTINE COMPUTE_LOGPOST(obs, uobs, sim, theta, theta_prior, mu_funk&
&   , mu_gamma, mu_gamma_prior, sigma_funk, sigma_gamma, &
&   sigma_gamma_prior, logpost, logprior, loglkh, logh, feas, isnull)
    IMPLICIT NONE
    REAL(mrk), INTENT(IN) :: obs(:, :), sim(:, :), uobs(:, :)
    CHARACTER(len=*), INTENT(IN) :: mu_funk, sigma_funk
    REAL(mrk), INTENT(IN) :: theta(:), mu_gamma(:, :), sigma_gamma(:, :)
    TYPE(PRIORTYPE), INTENT(IN) :: theta_prior(:), mu_gamma_prior(:, :)&
&   , sigma_gamma_prior(:, :)
    REAL(mrk), INTENT(OUT) :: logpost, logprior, loglkh, logh
    LOGICAL, INTENT(OUT) :: feas, isnull
! Initialize
    logpost = undefrn
    feas = .true.
    isnull = .false.
! Prior
    CALL COMPUTE_LOGPRIOR(theta, theta_prior, mu_gamma, mu_gamma_prior, &
&                   sigma_gamma, sigma_gamma_prior, logprior, feas, &
&                   isnull)
    IF ((.NOT.feas) .OR. isnull) THEN
      RETURN
    ELSE
! Likelihood
      CALL COMPUTE_LOGLKH(obs, uobs, sim, mu_funk, mu_gamma, sigma_funk&
&                   , sigma_gamma, loglkh, feas, isnull)
      IF ((.NOT.feas) .OR. isnull) THEN
        RETURN
      ELSE
! Hierarchical term
        CALL COMPUTE_LOGH(logh, feas, isnull)
        IF ((.NOT.feas) .OR. isnull) THEN
          RETURN
        ELSE
! Posterior
          logpost = loglkh + logprior + logh
        END IF
      END IF
    END IF
  END SUBROUTINE COMPUTE_LOGPOST

!  Differentiation of compute_logprior_engine in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: logprior
!   with respect to varying inputs: x
  SUBROUTINE COMPUTE_LOGPRIOR_ENGINE_D(x, x_d, x_prior, logprior, &
&   logprior_d, feas, isnull)
    IMPLICIT NONE
    REAL(mrk), INTENT(IN) :: x(:, :)
    REAL(mrk), INTENT(IN) :: x_d(:, :)
    TYPE(PRIORTYPE), INTENT(IN) :: x_prior(:, :)
    REAL(mrk), INTENT(OUT) :: logprior
    REAL(mrk), INTENT(OUT) :: logprior_d
    LOGICAL, INTENT(OUT) :: feas, isnull
! locals
    INTEGER(mik) :: i, j, err
    REAL(mrk) :: pdf
    REAL(mrk) :: pdf_d
    CHARACTER(len=250) :: mess
    INTRINSIC SIZE
! Initialize
    logprior = 0.0_mrk
    feas = .true.
    isnull = .false.
! No prior <=> flat prior
    IF (SIZE(x_prior) .EQ. 0) THEN
      logprior_d = 0.0_8
    ELSE
      logprior_d = 0.0_8
! Add up individual log-priors
      DO j=1,SIZE(x, 2)
        DO i=1,SIZE(x, 1)
          CALL GETPDF_D(x_prior(i, j)%dist, x(i, j), x_d(i, j), x_prior(&
&                 i, j)%par, .true., pdf, pdf_d, feas, isnull, err, mess&
&                )
          IF (err .GT. 0) feas = .false.
! return removed for Tapenade
          logprior_d = logprior_d + pdf_d
          logprior = logprior + pdf
        END DO
      END DO
    END IF
  END SUBROUTINE COMPUTE_LOGPRIOR_ENGINE_D

!  Differentiation of compute_logprior_engine in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: x logprior
!   with respect to varying inputs: x
  SUBROUTINE COMPUTE_LOGPRIOR_ENGINE_B(x, x_b, x_prior, logprior, &
&   logprior_b, feas, isnull)
    IMPLICIT NONE
    REAL(mrk), INTENT(IN) :: x(:, :)
    REAL(mrk) :: x_b(:, :)
    TYPE(PRIORTYPE), INTENT(IN) :: x_prior(:, :)
    REAL(mrk) :: logprior
    REAL(mrk) :: logprior_b
    LOGICAL, INTENT(OUT) :: feas, isnull
! locals
    INTEGER(mik) :: i, j, err
    REAL(mrk) :: pdf
    REAL(mrk) :: pdf_b
    CHARACTER(len=250) :: mess
    INTRINSIC SIZE
    INTEGER*8 :: ad_to
    INTEGER*8 :: ad_to0
! Initialize
! No prior <=> flat prior
    IF (SIZE(x_prior) .NE. 0) THEN
! Add up individual log-priors
      DO j=1,SIZE(x, 2)
        DO i=1,SIZE(x, 1)
          CALL GETPDF(x_prior(i, j)%dist, x(i, j), x_prior(i, j)%par, &
&               .true., pdf, feas, isnull, err, mess)
        END DO
        CALL PUSHINTEGER8(i - 1)
      END DO
      ad_to0 = j - 1
      DO j=ad_to0,1,-1
        CALL POPINTEGER8(ad_to)
        DO i=ad_to,1,-1
          pdf_b = logprior_b
          CALL GETPDF_B(x_prior(i, j)%dist, x(i, j), x_b(i, j), x_prior(&
&                 i, j)%par, .true., pdf, pdf_b, feas, isnull, err, mess&
&                )
        END DO
      END DO
    END IF
  END SUBROUTINE COMPUTE_LOGPRIOR_ENGINE_B

  SUBROUTINE COMPUTE_LOGPRIOR_ENGINE(x, x_prior, logprior, feas, isnull)
    IMPLICIT NONE
    REAL(mrk), INTENT(IN) :: x(:, :)
    TYPE(PRIORTYPE), INTENT(IN) :: x_prior(:, :)
    REAL(mrk), INTENT(OUT) :: logprior
    LOGICAL, INTENT(OUT) :: feas, isnull
! locals
    INTEGER(mik) :: i, j, err
    REAL(mrk) :: pdf
    CHARACTER(len=250) :: mess
    INTRINSIC SIZE
! Initialize
    logprior = 0.0_mrk
    feas = .true.
    isnull = .false.
! No prior <=> flat prior
    IF (SIZE(x_prior) .EQ. 0) THEN
      RETURN
    ELSE
! Add up individual log-priors
      DO j=1,SIZE(x, 2)
        DO i=1,SIZE(x, 1)
          CALL GETPDF(x_prior(i, j)%dist, x(i, j), x_prior(i, j)%par, &
&               .true., pdf, feas, isnull, err, mess)
          IF (err .GT. 0) feas = .false.
! return removed for Tapenade
          logprior = logprior + pdf
        END DO
      END DO
    END IF
  END SUBROUTINE COMPUTE_LOGPRIOR_ENGINE

! BEN 2DO: try replacing what's below with existing subs in BMSL's Distribution_tools
!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  PURE SUBROUTINE GETPARNUMBER(distid, npar, err, mess)
    IMPLICIT NONE
!^**********************************************************************
!^* Purpose: returns the number of parameters of a distribution
!^**********************************************************************
!^* Programmer: Ben Renard, University of Newcastle
!^**********************************************************************
!^* Last modified:30/05/2008
!^**********************************************************************
!^* Comments:
!^**********************************************************************
!^* References:
!^**********************************************************************
!^* 2Do List:
!^**********************************************************************
!^* IN
!^*    1.DistID, the distribution ID
!^* OUT
!^*    1.nPar, the numbr of parameters
!^*    2.err, error code
!^*    3.mess, error message
!^**********************************************************************
    CHARACTER(len=*), INTENT(IN) :: distid
    INTEGER(mik), INTENT(OUT) :: npar
    INTEGER(mik), INTENT(OUT) :: err
    CHARACTER(len=*), INTENT(OUT) :: mess
    err = 0
    mess = ''
    npar = undefin
    SELECT CASE  (distid) 
    CASE ('FlatPrior') 
      npar = 0
    CASE ('Gaussian', 'Uniform', 'LogNormal', 'Exponential') 
      npar = 2
    CASE ('Triangle') 
      npar = 3
    CASE DEFAULT
      err = 1
      mess = 'GetParNumber:Fatal:Unavailable Dist'
    END SELECT
  END SUBROUTINE GETPARNUMBER

!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  PURE SUBROUTINE GETPARNAME(distid, name, err, mess)
    IMPLICIT NONE
!^**********************************************************************
!^* Purpose: returns the names of parameters of a distribution
!^**********************************************************************
!^* Programmer: Ben Renard, University of Newcastle
!^**********************************************************************
!^* Last modified:30/05/2008
!^**********************************************************************
!^* Comments:
!^**********************************************************************
!^* References:
!^**********************************************************************
!^* 2Do List:
!^**********************************************************************
!^* IN
!^*    1.DistID, the distribution ID
!^* OUT
!^*    1.name, parameters names
!^*    2.err, error code
!^*    3.mess, error message
!^**********************************************************************
    CHARACTER(len=*), INTENT(IN) :: distid
    CHARACTER(len=*), INTENT(OUT) :: name(:)
    INTEGER(mik), INTENT(OUT) :: err
    CHARACTER(len=*), INTENT(OUT) :: mess
!locals
    INTEGER(mik) :: npar
    INTRINSIC TRIM
    INTRINSIC SIZE
    err = 0
    mess = ''
    name = ''
! check size
    CALL GETPARNUMBER(distid, npar, err, mess)
    IF (err .GT. 0) THEN
      mess = 'GetParName: '//TRIM(mess)
      RETURN
    ELSE IF (SIZE(name) .NE. npar) THEN
      err = 2
      mess = 'GetParName: dimension mismatch'
      RETURN
    ELSE
      SELECT CASE  (distid) 
      CASE ('FlatPrior') 

      CASE ('Gaussian') 
! no parameter
        name(1) = 'mean'
        name(2) = 'standard_deviation'
      CASE ('LogNormal') 
        name(1) = 'mean_log'
        name(2) = 'standard_deviation_log'
      CASE ('Exponential') 
        name(1) = 'threshold'
        name(2) = 'scale'
      CASE ('Uniform') 
        name(1) = 'lower_bound'
        name(2) = 'higher_bound'
      CASE ('Triangle') 
        name(1) = 'peak'
        name(2) = 'lower_bound'
        name(3) = 'higher_bound'
      CASE DEFAULT
        err = 1
        mess = 'GetParName:Fatal:Unavailable Dist'
      END SELECT
    END IF
  END SUBROUTINE GETPARNAME

!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  PURE SUBROUTINE CHECKPARSIZE(distid, par, ok, err, mess)
    IMPLICIT NONE
!^**********************************************************************
!^* Purpose: check size(par)=ParNumber(dist)
!^**********************************************************************
!^* Programmer: Ben Renard, University of Newcastle
!^**********************************************************************
!^* Last modified:30/05/2008
!^**********************************************************************
!^* Comments:
!^**********************************************************************
!^* References:
!^**********************************************************************
!^* 2Do List:
!^**********************************************************************
!^* IN
!^*    1.DistID, the distribution
!^*    1.par, parameter vector
!^* OUT
!^*    1.ok
!^*    2.err, error code
!^*    3.mess, error message
!^**********************************************************************
    CHARACTER(len=*), INTENT(IN) :: distid
    REAL(mrk), INTENT(IN) :: par(:)
    LOGICAL, INTENT(OUT) :: ok
    INTEGER(mik), INTENT(OUT) :: err
    CHARACTER(len=*), INTENT(OUT) :: mess
!locals
    INTEGER(mik) :: npar
    INTRINSIC TRIM
    INTRINSIC SIZE
    err = 0
    mess = ''
    ok = .false.
    CALL GETPARNUMBER(distid, npar, err, mess)
    IF (err .GT. 0) THEN
      mess = 'CheckParSize: '//TRIM(mess)
      RETURN
    ELSE IF (SIZE(par) .EQ. npar) THEN
      ok = .true.
    END IF
  END SUBROUTINE CHECKPARSIZE

!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  PURE SUBROUTINE GETPARFEAS(distid, par, feas, err, mess)
    IMPLICIT NONE
!^**********************************************************************
!^* Purpose: check parameters feasability
!^**********************************************************************
!^* Programmer: Ben Renard, University of Newcastle
!^**********************************************************************
!^* Last modified:30/05/2008
!^**********************************************************************
!^* Comments:
!^**********************************************************************
!^* References:
!^**********************************************************************
!^* 2Do List:
!^**********************************************************************
!^* IN
!^*    1.DistID, the distribution ID
!^*    2.par, parameter vector
!^* OUT
!^*    1.feas, feasability
!^*    2.err, error code
!^*    3.mess, error message
!^**********************************************************************
    CHARACTER(len=*), INTENT(IN) :: distid
    REAL(mrk), INTENT(IN) :: par(:)
    LOGICAL, INTENT(OUT) :: feas
    INTEGER(mik), INTENT(OUT) :: err
    CHARACTER(len=*), INTENT(OUT) :: mess
! Locals
    LOGICAL :: ok
    err = 0
    mess = ''
    feas = .true.
! check size
    CALL CHECKPARSIZE(distid, par, ok, err, mess)
    IF (.NOT.ok) THEN
      err = 2
      mess = 'GetParFeas: dimension mismatch'
      RETURN
    ELSE
      SELECT CASE  (distid) 
      CASE ('FlatPrior') 

      CASE ('Gaussian', 'LogNormal', 'Exponential') 
! Can't get it wrong!
        IF (par(2) .LE. 0.0_mrk) feas = .false.
      CASE ('Uniform') 
        IF (par(2) .LE. par(1)) feas = .false.
      CASE ('Triangle') 
        IF ((par(3) .LE. par(2) .OR. par(1) .LE. par(2)) .OR. par(1) &
&           .GE. par(3)) feas = .false.
      CASE DEFAULT
        err = 1
        mess = 'GetParFeas:Fatal:Unavailable Dist'
      END SELECT
    END IF
  END SUBROUTINE GETPARFEAS

!  Differentiation of getpdf in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: pdf
!   with respect to varying inputs: x
!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  SUBROUTINE GETPDF_D(distid, x, x_d, par, loga, pdf, pdf_d, feas, &
&   isnull, err, mess)
    IMPLICIT NONE
!^**********************************************************************
!^* Purpose: compute pdf(x|par) for DistID
!^**********************************************************************
!^* Programmer: Ben Renard, University of Newcastle
!^**********************************************************************
!^* Last modified:30/05/2008
!^**********************************************************************
!^* Comments:
!^**********************************************************************
!^* References:
!^**********************************************************************
!^* 2Do List:
!^**********************************************************************
!^* IN
!^*    1.DistID, the distribution
!^*    2.x, value
!^*    3.par, parameters
!^*    4.loga, log-pdf or natural pdf?
!^* OUT
!^*    1.pdf, result
!^*    2.feas, is par feasible?
!^*    3.isnull, pdf==0? (usefull for log-pdf of bounded-support distribution)
!^*    4.err, error code
!^*    5.mess, error message
!^**********************************************************************
    CHARACTER(len=*), INTENT(IN) :: distid
    REAL(mrk), INTENT(IN) :: x, par(:)
    REAL(mrk), INTENT(IN) :: x_d
    LOGICAL, INTENT(IN) :: loga
    REAL(mrk), INTENT(OUT) :: pdf
    REAL(mrk), INTENT(OUT) :: pdf_d
    LOGICAL, INTENT(OUT) :: feas, isnull
    INTEGER(mik), INTENT(OUT) :: err
    CHARACTER(len=*), INTENT(OUT) :: mess
    INTRINSIC TRIM
    INTRINSIC LOG
    INTRINSIC EXP
!Locals
!Init
    pdf = undefrn
    isnull = .false.
!Feasability
    CALL GETPARFEAS(distid, par, feas, err, mess)
    IF (err .GT. 0) THEN
      pdf_d = 0.0_8
    ELSE IF (.NOT.feas) THEN
      pdf_d = 0.0_8
    ELSE
!Compute
      SELECT CASE  (distid) 
      CASE ('FlatPrior') 
        pdf = 0.0_mrk
        pdf_d = 0.0_8
      CASE ('Gaussian') 
        pdf_d = -(0.5_mrk*2*(x-par(1))*x_d/par(2)**2)
        pdf = -(0.5_mrk*LOG(2._mrk*pi)) - LOG(par(2)) - 0.5_mrk*((x-par(&
&         1))/par(2))**2
      CASE ('LogNormal') 
        IF (x .LE. 0.0_mrk) THEN
          isnull = .true.
          pdf_d = 0.0_8
        ELSE
          pdf_d = -((1.0/x+0.5_mrk*2*(LOG(x)-par(1))/(par(2)**2*x))*x_d)
          pdf = -(0.5_mrk*LOG(2._mrk*pi)) - LOG(x*par(2)) - 0.5_mrk*((&
&           LOG(x)-par(1))/par(2))**2
        END IF
      CASE ('Exponential') 
        IF (x .LT. par(1)) THEN
          isnull = .true.
          pdf_d = 0.0_8
        ELSE
          pdf_d = -(x_d/par(2))
          pdf = -(1.0_mrk*LOG(par(2))) - (x-par(1))/par(2)
        END IF
      CASE ('Uniform') 
        IF (x .LT. par(1) .OR. x .GT. par(2)) THEN
          isnull = .true.
          pdf_d = 0.0_8
        ELSE
          pdf = -(1.0_mrk*LOG(par(2)-par(1)))
          pdf_d = 0.0_8
        END IF
      CASE ('Triangle') 
        IF (x .LT. par(2) .OR. x .GT. par(3)) THEN
          isnull = .true.
          pdf_d = 0.0_8
        ELSE IF (x .LE. par(1)) THEN
          pdf_d = x_d/(x-par(2))
          pdf = LOG(2._mrk) + LOG(x - par(2)) - LOG(par(3) - par(2)) - &
&           LOG(par(1) - par(2))
        ELSE
          pdf_d = -(x_d/(par(3)-x))
          pdf = LOG(2._mrk) + LOG(par(3) - x) - LOG(par(3) - par(2)) - &
&           LOG(par(3) - par(1))
        END IF
      CASE DEFAULT
        err = 1
        pdf_d = 0.0_8
      END SELECT
! Exponentiate if loga=.false.
      IF (.NOT.loga) THEN
        IF (isnull) THEN
          pdf = 0.0_mrk
          pdf_d = 0.0_8
        ELSE
          pdf_d = EXP(pdf)*pdf_d
          pdf = EXP(pdf)
        END IF
      END IF
    END IF
  END SUBROUTINE GETPDF_D

!  Differentiation of getpdf in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: x pdf
!   with respect to varying inputs: x
!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  SUBROUTINE GETPDF_B(distid, x, x_b, par, loga, pdf, pdf_b, feas, &
&   isnull, err, mess)
    IMPLICIT NONE
!^**********************************************************************
!^* Purpose: compute pdf(x|par) for DistID
!^**********************************************************************
!^* Programmer: Ben Renard, University of Newcastle
!^**********************************************************************
!^* Last modified:30/05/2008
!^**********************************************************************
!^* Comments:
!^**********************************************************************
!^* References:
!^**********************************************************************
!^* 2Do List:
!^**********************************************************************
!^* IN
!^*    1.DistID, the distribution
!^*    2.x, value
!^*    3.par, parameters
!^*    4.loga, log-pdf or natural pdf?
!^* OUT
!^*    1.pdf, result
!^*    2.feas, is par feasible?
!^*    3.isnull, pdf==0? (usefull for log-pdf of bounded-support distribution)
!^*    4.err, error code
!^*    5.mess, error message
!^**********************************************************************
    CHARACTER(len=*), INTENT(IN) :: distid
    REAL(mrk), INTENT(IN) :: x, par(:)
    REAL(mrk) :: x_b
    LOGICAL, INTENT(IN) :: loga
    REAL(mrk) :: pdf
    REAL(mrk) :: pdf_b
    LOGICAL, INTENT(OUT) :: feas, isnull
    INTEGER(mik), INTENT(OUT) :: err
    CHARACTER(len=*), INTENT(OUT) :: mess
    INTRINSIC TRIM
    INTRINSIC LOG
    INTRINSIC EXP
    INTEGER :: branch
!Locals
!Init
    pdf = undefrn
    isnull = .false.
!Feasability
    CALL GETPARFEAS(distid, par, feas, err, mess)
    IF (err .LE. 0) THEN
      IF (feas) THEN
!Compute
        SELECT CASE  (distid) 
        CASE ('FlatPrior') 
          CALL PUSHCONTROL4B(9)
          pdf = 0.0_mrk
        CASE ('Gaussian') 
          pdf = -(0.5_mrk*LOG(2._mrk*pi)) - LOG(par(2)) - 0.5_mrk*((x-&
&           par(1))/par(2))**2
          CALL PUSHCONTROL4B(0)
        CASE ('LogNormal') 
          IF (x .LE. 0.0_mrk) THEN
            CALL PUSHCONTROL4B(1)
            isnull = .true.
          ELSE
            pdf = -(0.5_mrk*LOG(2._mrk*pi)) - LOG(x*par(2)) - 0.5_mrk*((&
&             LOG(x)-par(1))/par(2))**2
            CALL PUSHCONTROL4B(2)
          END IF
        CASE ('Exponential') 
          IF (x .LT. par(1)) THEN
            CALL PUSHCONTROL4B(3)
            isnull = .true.
          ELSE
            pdf = -(1.0_mrk*LOG(par(2))) - (x-par(1))/par(2)
            CALL PUSHCONTROL4B(4)
          END IF
        CASE ('Uniform') 
          IF (x .LT. par(1) .OR. x .GT. par(2)) THEN
            CALL PUSHCONTROL4B(5)
            isnull = .true.
          ELSE
            CALL PUSHCONTROL4B(5)
            pdf = -(1.0_mrk*LOG(par(2)-par(1)))
          END IF
        CASE ('Triangle') 
          IF (x .LT. par(2) .OR. x .GT. par(3)) THEN
            CALL PUSHCONTROL4B(6)
            isnull = .true.
          ELSE IF (x .LE. par(1)) THEN
            pdf = LOG(2._mrk) + LOG(x - par(2)) - LOG(par(3) - par(2)) -&
&             LOG(par(1) - par(2))
            CALL PUSHCONTROL4B(7)
          ELSE
            pdf = LOG(2._mrk) + LOG(par(3) - x) - LOG(par(3) - par(2)) -&
&             LOG(par(3) - par(1))
            CALL PUSHCONTROL4B(8)
          END IF
        CASE DEFAULT
          CALL PUSHCONTROL4B(9)
        END SELECT
! Exponentiate if loga=.false.
        IF (.NOT.loga) THEN
          IF (isnull) THEN
            pdf_b = 0.0_8
          ELSE
            pdf_b = EXP(pdf)*pdf_b
          END IF
        END IF
        CALL POPCONTROL4B(branch)
        IF (branch .LT. 5) THEN
          IF (branch .LT. 2) THEN
            IF (branch .EQ. 0) x_b = x_b - 2*(x-par(1))*0.5_mrk*pdf_b/&
&               par(2)**2
          ELSE IF (branch .EQ. 2) THEN
            x_b = x_b - (1.0/x+2*(LOG(x)-par(1))*0.5_mrk/(x*par(2)**2))*&
&             pdf_b
          ELSE IF (branch .NE. 3) THEN
            x_b = x_b - pdf_b/par(2)
          END IF
        ELSE IF (branch .GE. 7) THEN
          IF (branch .EQ. 7) THEN
            x_b = x_b + pdf_b/(x-par(2))
          ELSE IF (branch .EQ. 8) THEN
            x_b = x_b - pdf_b/(par(3)-x)
          END IF
        END IF
      END IF
    END IF
  END SUBROUTINE GETPDF_B

!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  PURE SUBROUTINE GETPDF(distid, x, par, loga, pdf, feas, isnull, err, &
&   mess)
    IMPLICIT NONE
!^**********************************************************************
!^* Purpose: compute pdf(x|par) for DistID
!^**********************************************************************
!^* Programmer: Ben Renard, University of Newcastle
!^**********************************************************************
!^* Last modified:30/05/2008
!^**********************************************************************
!^* Comments:
!^**********************************************************************
!^* References:
!^**********************************************************************
!^* 2Do List:
!^**********************************************************************
!^* IN
!^*    1.DistID, the distribution
!^*    2.x, value
!^*    3.par, parameters
!^*    4.loga, log-pdf or natural pdf?
!^* OUT
!^*    1.pdf, result
!^*    2.feas, is par feasible?
!^*    3.isnull, pdf==0? (usefull for log-pdf of bounded-support distribution)
!^*    4.err, error code
!^*    5.mess, error message
!^**********************************************************************
    CHARACTER(len=*), INTENT(IN) :: distid
    REAL(mrk), INTENT(IN) :: x, par(:)
    LOGICAL, INTENT(IN) :: loga
    REAL(mrk), INTENT(OUT) :: pdf
    LOGICAL, INTENT(OUT) :: feas, isnull
    INTEGER(mik), INTENT(OUT) :: err
    CHARACTER(len=*), INTENT(OUT) :: mess
    INTRINSIC TRIM
    INTRINSIC LOG
    INTRINSIC EXP
!Locals
!Init
    pdf = undefrn
    feas = .true.
    isnull = .false.
    err = 0
    mess = ''
!Feasability
    CALL GETPARFEAS(distid, par, feas, err, mess)
    IF (err .GT. 0) THEN
      mess = 'GetPdf: '//TRIM(mess)
      RETURN
    ELSE IF (.NOT.feas) THEN
      RETURN
    ELSE
!Compute
      SELECT CASE  (distid) 
      CASE ('FlatPrior') 
        pdf = 0.0_mrk
      CASE ('Gaussian') 
        pdf = -(0.5_mrk*LOG(2._mrk*pi)) - LOG(par(2)) - 0.5_mrk*((x-par(&
&         1))/par(2))**2
      CASE ('LogNormal') 
        IF (x .LE. 0.0_mrk) THEN
          isnull = .true.
        ELSE
          pdf = -(0.5_mrk*LOG(2._mrk*pi)) - LOG(x*par(2)) - 0.5_mrk*((&
&           LOG(x)-par(1))/par(2))**2
        END IF
      CASE ('Exponential') 
        IF (x .LT. par(1)) THEN
          isnull = .true.
        ELSE
          pdf = -(1.0_mrk*LOG(par(2))) - (x-par(1))/par(2)
        END IF
      CASE ('Uniform') 
        IF (x .LT. par(1) .OR. x .GT. par(2)) THEN
          isnull = .true.
        ELSE
          pdf = -(1.0_mrk*LOG(par(2)-par(1)))
        END IF
      CASE ('Triangle') 
        IF (x .LT. par(2) .OR. x .GT. par(3)) THEN
          isnull = .true.
        ELSE IF (x .LE. par(1)) THEN
          pdf = LOG(2._mrk) + LOG(x - par(2)) - LOG(par(3) - par(2)) - &
&           LOG(par(1) - par(2))
        ELSE
          pdf = LOG(2._mrk) + LOG(par(3) - x) - LOG(par(3) - par(2)) - &
&           LOG(par(3) - par(1))
        END IF
      CASE DEFAULT
        err = 1
        mess = 'GetPdf:Fatal:Unavailable Dist'
      END SELECT
! Exponentiate if loga=.false.
      IF (.NOT.loga) THEN
        IF (isnull) THEN
          pdf = 0.0_mrk
        ELSE
          pdf = EXP(pdf)
        END IF
      END IF
    END IF
  END SUBROUTINE GETPDF

!  Differentiation of sigmafunk_apply in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: res
!   with respect to varying inputs: y par
!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  SUBROUTINE SIGMAFUNK_APPLY_D(funk, par, par_d, y, y_d, res, res_d, err&
&   , mess)
    IMPLICIT NONE
!^**********************************************************************
!^* Purpose: Apply the selected Sigmafunk
!^**********************************************************************
!^* Programmer: Ben Renard, Irstea Lyon
!^**********************************************************************
!^* Created: 29/04/2013, last modified: 05/08/2022, added 'Power'
!^**********************************************************************
!^* Comments:
!^**********************************************************************
!^* References:
!^**********************************************************************
!^* 2Do List:
!^**********************************************************************
!^* IN
!^*    1.funk, which function?? (e.g., 'Constant','Linear')
!^*    2.par, parameters of funk
!^*    3.Y, covariate of funk
!^* OUT
!^*    1.res, result
!^*    2.err, error code; <0:Warning, ==0:OK, >0: Error
!^*    3.mess, error message
!^**********************************************************************
    CHARACTER(len=*), INTENT(IN) :: funk
    REAL(mrk), INTENT(IN) :: par(:), y
    REAL(mrk), INTENT(IN) :: par_d(:), y_d
    REAL(mrk), INTENT(OUT) :: res
    REAL(mrk), INTENT(OUT) :: res_d
    INTEGER(mik), INTENT(OUT) :: err
    CHARACTER(len=*), INTENT(OUT) :: mess
! locals
    CHARACTER(len=250), PARAMETER :: procname='Sigmafunk_Apply'
    INTRINSIC TRIM
    INTRINSIC ABS
    INTRINSIC EXP
    REAL(mrk) :: abs0
    REAL(mrk) :: abs0_d
    REAL(mrk) :: abs1
    REAL(mrk) :: abs1_d
    REAL(mrk) :: abs2
    REAL(mrk) :: abs2_d
    REAL(mrk) :: abs3
    REAL(mrk) :: abs3_d
    REAL(mrk) :: pwr1
    REAL(mrk) :: pwr1_d
    REAL(mrk) :: arg1
    REAL(mrk) :: arg1_d
    REAL(mrk) :: temp
    err = 0
    res = undefrn
    SELECT CASE  (TRIM(funk)) 
    CASE ('Constant') 
      res_d = par_d(1)
      res = par(1)
    CASE ('Linear') 
      IF (y .GE. 0.) THEN
        abs0_d = y_d
        abs0 = y
      ELSE
        abs0_d = -y_d
        abs0 = -y
      END IF
      res_d = par_d(1) + abs0*par_d(2) + par(2)*abs0_d
      res = par(1) + par(2)*abs0
    CASE ('Power') 
      IF (y .GE. 0.) THEN
        abs1_d = y_d
        abs1 = y
      ELSE
        abs1_d = -y_d
        abs1 = -y
      END IF
      temp = abs1**par(3)
      IF (abs1 .LE. 0.0 .AND. (par(3) .EQ. 0.0 .OR. par(3) .NE. INT(par(&
&         3)))) THEN
        pwr1_d = 0.0_8
      ELSE IF (abs1 .LE. 0.0) THEN
        pwr1_d = par(3)*abs1**(par(3)-1)*abs1_d
      ELSE
        pwr1_d = par(3)*abs1**(par(3)-1)*abs1_d + temp*LOG(abs1)*par_d(3&
&         )
      END IF
      pwr1 = temp
      res_d = par_d(1) + pwr1*par_d(2) + par(2)*pwr1_d
      res = par(1) + par(2)*pwr1
    CASE ('Exponential') 
      IF (y .GE. 0.) THEN
        abs2_d = y_d
        abs2 = y
      ELSE
        abs2_d = -y_d
        abs2 = -y
      END IF
      temp = abs2/par(2)
      arg1_d = -((abs2_d-temp*par_d(2))/par(2))
      arg1 = -(temp**1)
      temp = -EXP(arg1) + 1._mrk
      res_d = par_d(1) + temp*(par_d(3)-par_d(1)) - (par(3)-par(1))*EXP(&
&       arg1)*arg1_d
      res = par(1) + (par(3)-par(1))*temp
    CASE ('Gaussian') 
      IF (y .GE. 0.) THEN
        abs3_d = y_d
        abs3 = y
      ELSE
        abs3_d = -y_d
        abs3 = -y
      END IF
      temp = abs3/par(2)
      arg1_d = -(2*temp*(abs3_d-temp*par_d(2))/par(2))
      arg1 = -(temp*temp)
      temp = -EXP(arg1) + 1._mrk
      res_d = par_d(1) + temp*(par_d(3)-par_d(1)) - (par(3)-par(1))*EXP(&
&       arg1)*arg1_d
      res = par(1) + (par(3)-par(1))*temp
    CASE DEFAULT
      err = 1
      res_d = 0.0_8
    END SELECT
  END SUBROUTINE SIGMAFUNK_APPLY_D

!  Differentiation of sigmafunk_apply in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: res y par
!   with respect to varying inputs: y par
!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  SUBROUTINE SIGMAFUNK_APPLY_B(funk, par, par_b, y, y_b, res, res_b, err&
&   , mess)
    IMPLICIT NONE
!^**********************************************************************
!^* Purpose: Apply the selected Sigmafunk
!^**********************************************************************
!^* Programmer: Ben Renard, Irstea Lyon
!^**********************************************************************
!^* Created: 29/04/2013, last modified: 05/08/2022, added 'Power'
!^**********************************************************************
!^* Comments:
!^**********************************************************************
!^* References:
!^**********************************************************************
!^* 2Do List:
!^**********************************************************************
!^* IN
!^*    1.funk, which function?? (e.g., 'Constant','Linear')
!^*    2.par, parameters of funk
!^*    3.Y, covariate of funk
!^* OUT
!^*    1.res, result
!^*    2.err, error code; <0:Warning, ==0:OK, >0: Error
!^*    3.mess, error message
!^**********************************************************************
    CHARACTER(len=*), INTENT(IN) :: funk
    REAL(mrk), INTENT(IN) :: par(:), y
    REAL(mrk) :: par_b(:), y_b
    REAL(mrk) :: res
    REAL(mrk) :: res_b
    INTEGER(mik), INTENT(OUT) :: err
    CHARACTER(len=*), INTENT(OUT) :: mess
! locals
    CHARACTER(len=250), PARAMETER :: procname='Sigmafunk_Apply'
    INTRINSIC TRIM
    INTRINSIC ABS
    INTRINSIC EXP
    REAL(mrk) :: abs0
    REAL(mrk) :: abs0_b
    REAL(mrk) :: abs1
    REAL(mrk) :: abs1_b
    REAL(mrk) :: abs2
    REAL(mrk) :: abs2_b
    REAL(mrk) :: abs3
    REAL(mrk) :: abs3_b
    REAL(mrk) :: pwr1
    REAL(mrk) :: pwr1_b
    REAL(mrk) :: arg1
    REAL(mrk) :: arg1_b
    REAL(mrk) :: temp
    REAL(mrk) :: temp_b
    INTEGER :: branch
    SELECT CASE  (TRIM(funk)) 
    CASE ('Constant') 
      par_b(1) = par_b(1) + res_b
    CASE ('Linear') 
      IF (y .GE. 0.) THEN
        abs0 = y
        CALL PUSHCONTROL1B(0)
      ELSE
        abs0 = -y
        CALL PUSHCONTROL1B(1)
      END IF
      par_b(1) = par_b(1) + res_b
      par_b(2) = par_b(2) + abs0*res_b
      abs0_b = par(2)*res_b
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) THEN
        y_b = y_b + abs0_b
      ELSE
        y_b = y_b - abs0_b
      END IF
    CASE ('Power') 
      IF (y .GE. 0.) THEN
        abs1 = y
        CALL PUSHCONTROL1B(0)
      ELSE
        abs1 = -y
        CALL PUSHCONTROL1B(1)
      END IF
      pwr1 = abs1**par(3)
      pwr1 = abs1**par(3)
      par_b(1) = par_b(1) + res_b
      par_b(2) = par_b(2) + pwr1*res_b
      pwr1_b = par(2)*res_b
      IF (abs1 .LE. 0.0 .AND. (par(3) .EQ. 0.0 .OR. par(3) .NE. INT(par(&
&         3)))) THEN
        abs1_b = 0.0_8
      ELSE
        abs1_b = par(3)*abs1**(par(3)-1)*pwr1_b
      END IF
      IF (.NOT.abs1 .LE. 0.0) par_b(3) = par_b(3) + abs1**par(3)*LOG(&
&         abs1)*pwr1_b
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) THEN
        y_b = y_b + abs1_b
      ELSE
        y_b = y_b - abs1_b
      END IF
    CASE ('Exponential') 
      IF (y .GE. 0.) THEN
        abs2 = y
        CALL PUSHCONTROL1B(0)
      ELSE
        abs2 = -y
        CALL PUSHCONTROL1B(1)
      END IF
      arg1 = -((abs2/par(2))**1)
      arg1 = -((abs2/par(2))**1)
      temp_b = (1._mrk-EXP(arg1))*res_b
      par_b(1) = par_b(1) + res_b - temp_b
      arg1_b = -(EXP(arg1)*(par(3)-par(1))*res_b)
      par_b(3) = par_b(3) + temp_b
      temp = abs2/par(2)
      temp_b = -(arg1_b/par(2))
      abs2_b = temp_b
      par_b(2) = par_b(2) - temp*temp_b
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) THEN
        y_b = y_b + abs2_b
      ELSE
        y_b = y_b - abs2_b
      END IF
    CASE ('Gaussian') 
      IF (y .GE. 0.) THEN
        abs3 = y
        CALL PUSHCONTROL1B(0)
      ELSE
        abs3 = -y
        CALL PUSHCONTROL1B(1)
      END IF
      arg1 = -((abs3/par(2))**2)
      arg1 = -((abs3/par(2))**2)
      temp_b = (1._mrk-EXP(arg1))*res_b
      par_b(1) = par_b(1) + res_b - temp_b
      arg1_b = -(EXP(arg1)*(par(3)-par(1))*res_b)
      par_b(3) = par_b(3) + temp_b
      temp = abs3/par(2)
      temp_b = -(2*temp*arg1_b/par(2))
      abs3_b = temp_b
      par_b(2) = par_b(2) - temp*temp_b
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) THEN
        y_b = y_b + abs3_b
      ELSE
        y_b = y_b - abs3_b
      END IF
    END SELECT
  END SUBROUTINE SIGMAFUNK_APPLY_B

!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  PURE SUBROUTINE SIGMAFUNK_APPLY(funk, par, y, res, err, mess)
    IMPLICIT NONE
!^**********************************************************************
!^* Purpose: Apply the selected Sigmafunk
!^**********************************************************************
!^* Programmer: Ben Renard, Irstea Lyon
!^**********************************************************************
!^* Created: 29/04/2013, last modified: 05/08/2022, added 'Power'
!^**********************************************************************
!^* Comments:
!^**********************************************************************
!^* References:
!^**********************************************************************
!^* 2Do List:
!^**********************************************************************
!^* IN
!^*    1.funk, which function?? (e.g., 'Constant','Linear')
!^*    2.par, parameters of funk
!^*    3.Y, covariate of funk
!^* OUT
!^*    1.res, result
!^*    2.err, error code; <0:Warning, ==0:OK, >0: Error
!^*    3.mess, error message
!^**********************************************************************
    CHARACTER(len=*), INTENT(IN) :: funk
    REAL(mrk), INTENT(IN) :: par(:), y
    REAL(mrk), INTENT(OUT) :: res
    INTEGER(mik), INTENT(OUT) :: err
    CHARACTER(len=*), INTENT(OUT) :: mess
! locals
    CHARACTER(len=250), PARAMETER :: procname='Sigmafunk_Apply'
    INTRINSIC TRIM
    INTRINSIC ABS
    INTRINSIC EXP
    REAL(mrk) :: abs0
    REAL(mrk) :: abs1
    REAL(mrk) :: abs2
    REAL(mrk) :: abs3
    REAL(mrk) :: pwr1
    REAL(mrk) :: arg1
    err = 0
    mess = ''
    res = undefrn
    SELECT CASE  (TRIM(funk)) 
    CASE ('Constant') 
      res = par(1)
    CASE ('Linear') 
      IF (y .GE. 0.) THEN
        abs0 = y
      ELSE
        abs0 = -y
      END IF
      res = par(1) + par(2)*abs0
    CASE ('Power') 
      IF (y .GE. 0.) THEN
        abs1 = y
      ELSE
        abs1 = -y
      END IF
      pwr1 = abs1**par(3)
      res = par(1) + par(2)*pwr1
    CASE ('Exponential') 
      IF (y .GE. 0.) THEN
        abs2 = y
      ELSE
        abs2 = -y
      END IF
      arg1 = -((abs2/par(2))**1)
      res = par(1) + (par(3)-par(1))*(1._mrk-EXP(arg1))
    CASE ('Gaussian') 
      IF (y .GE. 0.) THEN
        abs3 = y
      ELSE
        abs3 = -y
      END IF
      arg1 = -((abs3/par(2))**2)
      res = par(1) + (par(3)-par(1))*(1._mrk-EXP(arg1))
    CASE DEFAULT
      err = 1
      mess = TRIM(procname)//': unknown SigmaFunk'
    END SELECT
  END SUBROUTINE SIGMAFUNK_APPLY

!  Differentiation of mufunk_apply in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: res
!   with respect to varying inputs: y par
!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  SUBROUTINE MUFUNK_APPLY_D(funk, par, par_d, y, y_d, res, res_d, err, &
&   mess)
    IMPLICIT NONE
!^**********************************************************************
!^* Purpose: Apply the selected MuFunk
!^**********************************************************************
!^* Programmer: Ben Renard, Irstea Lyon
!^**********************************************************************
!^* Created: 29/04/2013, last modified: 05/08/2022, added 'Power'
!^**********************************************************************
!^* Comments:
!^**********************************************************************
!^* References:
!^**********************************************************************
!^* 2Do List:
!^**********************************************************************
!^* IN
!^*    1.funk, which function?? (e.g., 'Constant','Linear')
!^*    2.par, parameters of funk
!^*    3.Y, covariate of funk
!^* OUT
!^*    1.res, result
!^*    2.err, error code; <0:Warning, ==0:OK, >0: Error
!^*    3.mess, error message
!^**********************************************************************
    CHARACTER(len=*), INTENT(IN) :: funk
    REAL(mrk), INTENT(IN) :: par(:), y
    REAL(mrk), INTENT(IN) :: par_d(:), y_d
    REAL(mrk), INTENT(OUT) :: res
    REAL(mrk), INTENT(OUT) :: res_d
    INTEGER(mik), INTENT(OUT) :: err
    CHARACTER(len=*), INTENT(OUT) :: mess
! locals
    CHARACTER(len=250), PARAMETER :: procname='MuFunk_Apply'
    INTRINSIC TRIM
    err = 0
    res = undefrn
    SELECT CASE  (TRIM(funk)) 
    CASE ('Zero') 
      res = 0._mrk
      res_d = 0.0_8
    CASE ('Constant') 
      res_d = par_d(1)
      res = par(1)
    CASE ('Linear') 
      res_d = par_d(1) + y*par_d(2) + par(2)*y_d
      res = par(1) + par(2)*y
    CASE DEFAULT
      err = 1
      res_d = 0.0_8
    END SELECT
  END SUBROUTINE MUFUNK_APPLY_D

!  Differentiation of mufunk_apply in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: res y par
!   with respect to varying inputs: y par
!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  SUBROUTINE MUFUNK_APPLY_B(funk, par, par_b, y, y_b, res, res_b, err, &
&   mess)
    IMPLICIT NONE
!^**********************************************************************
!^* Purpose: Apply the selected MuFunk
!^**********************************************************************
!^* Programmer: Ben Renard, Irstea Lyon
!^**********************************************************************
!^* Created: 29/04/2013, last modified: 05/08/2022, added 'Power'
!^**********************************************************************
!^* Comments:
!^**********************************************************************
!^* References:
!^**********************************************************************
!^* 2Do List:
!^**********************************************************************
!^* IN
!^*    1.funk, which function?? (e.g., 'Constant','Linear')
!^*    2.par, parameters of funk
!^*    3.Y, covariate of funk
!^* OUT
!^*    1.res, result
!^*    2.err, error code; <0:Warning, ==0:OK, >0: Error
!^*    3.mess, error message
!^**********************************************************************
    CHARACTER(len=*), INTENT(IN) :: funk
    REAL(mrk), INTENT(IN) :: par(:), y
    REAL(mrk) :: par_b(:), y_b
    REAL(mrk) :: res
    REAL(mrk) :: res_b
    INTEGER(mik), INTENT(OUT) :: err
    CHARACTER(len=*), INTENT(OUT) :: mess
! locals
    CHARACTER(len=250), PARAMETER :: procname='MuFunk_Apply'
    INTRINSIC TRIM
    SELECT CASE  (TRIM(funk)) 
    CASE ('Zero') 

    CASE ('Constant') 
      par_b(1) = par_b(1) + res_b
    CASE ('Linear') 
      par_b(1) = par_b(1) + res_b
      par_b(2) = par_b(2) + y*res_b
      y_b = y_b + par(2)*res_b
    END SELECT
  END SUBROUTINE MUFUNK_APPLY_B

!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  PURE SUBROUTINE MUFUNK_APPLY(funk, par, y, res, err, mess)
    IMPLICIT NONE
!^**********************************************************************
!^* Purpose: Apply the selected MuFunk
!^**********************************************************************
!^* Programmer: Ben Renard, Irstea Lyon
!^**********************************************************************
!^* Created: 29/04/2013, last modified: 05/08/2022, added 'Power'
!^**********************************************************************
!^* Comments:
!^**********************************************************************
!^* References:
!^**********************************************************************
!^* 2Do List:
!^**********************************************************************
!^* IN
!^*    1.funk, which function?? (e.g., 'Constant','Linear')
!^*    2.par, parameters of funk
!^*    3.Y, covariate of funk
!^* OUT
!^*    1.res, result
!^*    2.err, error code; <0:Warning, ==0:OK, >0: Error
!^*    3.mess, error message
!^**********************************************************************
    CHARACTER(len=*), INTENT(IN) :: funk
    REAL(mrk), INTENT(IN) :: par(:), y
    REAL(mrk), INTENT(OUT) :: res
    INTEGER(mik), INTENT(OUT) :: err
    CHARACTER(len=*), INTENT(OUT) :: mess
! locals
    CHARACTER(len=250), PARAMETER :: procname='MuFunk_Apply'
    INTRINSIC TRIM
    err = 0
    mess = ''
    res = undefrn
    SELECT CASE  (TRIM(funk)) 
    CASE ('Zero') 
      res = 0._mrk
    CASE ('Constant') 
      res = par(1)
    CASE ('Linear') 
      res = par(1) + par(2)*y
    CASE DEFAULT
      err = 1
      mess = TRIM(procname)//': unknown MuFunk'
    END SELECT
  END SUBROUTINE MUFUNK_APPLY

  PURE SUBROUTINE SIGMAFUNK_VECT(funk, par, y, res)
    IMPLICIT NONE
!^**********************************************************************
!^* Purpose: Apply the selected Sigmafunk to an array Y(:,:)
!^**********************************************************************
!^* Programmer: Ben Renard & François Colleoni, INRAE Aix
!^**********************************************************************
!^* Created: 29/04/2013, last modified: 20/09/2023
!^**********************************************************************
!^* Comments:
!^**********************************************************************
!^* References:
!^**********************************************************************
!^* 2Do List:
!^**********************************************************************
!^* IN
!^*    1.funk, which function?? (e.g., 'Constant','Linear')
!^*    2.par, parameters of funk
!^*    3.Y, covariate of funk
!^* OUT
!^*    1.res, result
!^*    2.err, error code; <0:Warning, ==0:OK, >0: Error
!^*    3.mess, error message
!^**********************************************************************
    CHARACTER(len=*), INTENT(IN) :: funk
    REAL(mrk), INTENT(IN) :: par(:, :), y(:, :)
    REAL(mrk), INTENT(OUT) :: res(:, :)
! locals
    INTEGER(mik) :: i, j, err
    CHARACTER(len=250) :: mess
    INTRINSIC SIZE
    res = undefrn
    DO j=1,SIZE(y, 2)
      DO i=1,SIZE(y, 1)
        CALL SIGMAFUNK_APPLY(funk, par(:, j), y(i, j), res(i, j), err, &
&                      mess)
      END DO
    END DO
  END SUBROUTINE SIGMAFUNK_VECT

  PURE SUBROUTINE MUFUNK_VECT(funk, par, y, res)
    IMPLICIT NONE
!^**********************************************************************
!^* Purpose: Apply the selected Mufunk to an array Y(:,:)
!^**********************************************************************
!^* Programmer: Ben Renard & François Colleoni, INRAE Aix
!^**********************************************************************
!^* Created: 29/04/2013, last modified: 20/09/2023
!^**********************************************************************
!^* Comments:
!^**********************************************************************
!^* References:
!^**********************************************************************
!^* 2Do List:
!^**********************************************************************
!^* IN
!^*    1.funk, which function?? (e.g., 'Constant','Linear')
!^*    2.par, parameters of funk
!^*    3.Y, covariate of funk
!^* OUT
!^*    1.res, result
!^*    2.err, error code; <0:Warning, ==0:OK, >0: Error
!^*    3.mess, error message
!^**********************************************************************
    CHARACTER(len=*), INTENT(IN) :: funk
    REAL(mrk), INTENT(IN) :: par(:, :), y(:, :)
    REAL(mrk), INTENT(OUT) :: res(:, :)
! locals
    INTEGER(mik) :: i, j, err
    CHARACTER(len=250) :: mess
    INTRINSIC SIZE
    res = undefrn
    DO j=1,SIZE(y, 2)
      DO i=1,SIZE(y, 1)
        CALL MUFUNK_APPLY(funk, par(:, j), y(i, j), res(i, j), err, mess&
&                  )
      END DO
    END DO
  END SUBROUTINE MUFUNK_VECT

END MODULE MWD_BAYESIAN_TOOLS_DIFF

!%      (MWD) Module Wrapped and Differentiated.
!%
!%      Type
!%      ----
!%
!%      - Cost_OptionsDT
!%          Cost options passed by user to define the output cost
!%
!%          ======================== =======================================
!%          `Variables`              Description
!%          ======================== =======================================
!%          ``bayesian``             Enable bayesian cost computation
!%          ``njoc``                 Number of jobs components
!%          ``jobs_cmpt``            Jobs components
!%          ``wjobs_cmpt``           Weight jobs components
!%          ``njrc``                 Number of jreg components
!%          ``wjreg``                Base weight for regularization
!%          ``jreg_cmpt``            Jreg components
!%          ``wjreg_cmpt``           Weight jreg components
!%          ``nog``                  Number of optimized gauges
!%          ``gauge``                Optimized gauges
!%          ``wgauge``               Weight optimized gauges
!%          ``end_warmup``           End Warmup index
!%          ``n_event ``             Number of flood events
!%          ``mask_event  ``         Mask info by segmentation algorithm
!%          ``control_prior``        Array of PriorType (from mwd_bayesian_tools)
!%          ======================== =======================================
!%
!%      Subroutine
!%      ----------
!%
!%      - Cost_OptionsDT_initialise
!%      - Cost_OptionsDT_copy
MODULE MWD_COST_OPTIONS_DIFF
!% only PriorType, PriorType_initialise
  USE MWD_BAYESIAN_TOOLS_DIFF
!% only: sp, lchar
  USE MD_CONSTANT
!% only: SetupDT
  USE MWD_SETUP
!% only: MeshDT
  USE MWD_MESH
  IMPLICIT NONE
!$F90W char-array
!$F90W char-array
!$F90W char-array
!$F90W index
  TYPE COST_OPTIONSDT
      LOGICAL :: bayesian=.false.
      INTEGER :: njoc=-99
      CHARACTER(len=lchar), DIMENSION(:), ALLOCATABLE :: jobs_cmpt
      REAL(sp), DIMENSION(:), ALLOCATABLE :: wjobs_cmpt
      CHARACTER(len=lchar), DIMENSION(:), ALLOCATABLE :: jobs_cmpt_tfm
      INTEGER :: njrc=-99
      REAL(sp) :: wjreg=-99._sp
      CHARACTER(len=lchar), DIMENSION(:), ALLOCATABLE :: jreg_cmpt
      REAL(sp), DIMENSION(:), ALLOCATABLE :: wjreg_cmpt
      INTEGER :: nog=-99
      INTEGER, DIMENSION(:), ALLOCATABLE :: gauge
      REAL(sp), DIMENSION(:), ALLOCATABLE :: wgauge
      INTEGER :: end_warmup=-99
      INTEGER, DIMENSION(:), ALLOCATABLE :: n_event
      INTEGER, DIMENSION(:, :), ALLOCATABLE :: mask_event
      TYPE(PRIORTYPE), DIMENSION(:), ALLOCATABLE :: control_prior
  END TYPE COST_OPTIONSDT
  TYPE COST_OPTIONSDT_DIFF
      REAL(sp), DIMENSION(:), ALLOCATABLE :: wjreg_cmpt
  END TYPE COST_OPTIONSDT_DIFF

CONTAINS
  SUBROUTINE COST_OPTIONSDT_INITIALISE(this, setup, mesh, njoc, njrc)
    IMPLICIT NONE
    TYPE(COST_OPTIONSDT), INTENT(INOUT) :: this
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    INTEGER, INTENT(IN) :: njoc, njrc
    this%njoc = njoc
    this%njrc = njrc
    ALLOCATE(this%jobs_cmpt(this%njoc))
    this%jobs_cmpt = '...'
    ALLOCATE(this%wjobs_cmpt(this%njoc))
    this%wjobs_cmpt = -99._sp
    ALLOCATE(this%jobs_cmpt_tfm(this%njoc))
    this%jobs_cmpt_tfm = '...'
    ALLOCATE(this%jreg_cmpt(this%njrc))
    this%jreg_cmpt = '...'
    ALLOCATE(this%wjreg_cmpt(this%njrc))
    this%wjreg_cmpt = -99._sp
    ALLOCATE(this%gauge(mesh%ng))
    this%gauge = -99
    ALLOCATE(this%wgauge(mesh%ng))
    this%wgauge = -99._sp
    ALLOCATE(this%n_event(mesh%ng))
    this%n_event = -99
    ALLOCATE(this%mask_event(mesh%ng, setup%ntime_step))
    this%mask_event = -99
  END SUBROUTINE COST_OPTIONSDT_INITIALISE

  SUBROUTINE COST_OPTIONSDT_COPY(this, this_copy)
    IMPLICIT NONE
    TYPE(COST_OPTIONSDT), INTENT(IN) :: this
    TYPE(COST_OPTIONSDT), INTENT(OUT) :: this_copy
    this_copy = this
  END SUBROUTINE COST_OPTIONSDT_COPY

  SUBROUTINE COST_OPTIONSDT_ALLOC_CONTROL_PRIOR(this, n, npar)
    IMPLICIT NONE
    TYPE(COST_OPTIONSDT), INTENT(INOUT) :: this
    INTEGER, INTENT(IN) :: n
    INTEGER, DIMENSION(n), INTENT(IN) :: npar
    INTEGER :: i
    ALLOCATE(this%control_prior(n))
    DO i=1,n
      CALL PRIORTYPE_INITIALISE(this%control_prior(i), npar(i))
    END DO
  END SUBROUTINE COST_OPTIONSDT_ALLOC_CONTROL_PRIOR

END MODULE MWD_COST_OPTIONS_DIFF

!%      (MWD) Module Wrapped and Differentiated.
!%
!%      Type
!%      ----
!%
!%      - OptionsDT
!%          Container for all user options (optimize, cost, common)
!%
!%          ======================== =======================================
!%          `Variables`              Description
!%          ======================== =======================================
!%          ``optimize``             Optimize_OptionsDT
!%          ``cost``                 Cost_OptionsDT
!%          ``comm``                 Common_OptionsDT
!%          ======================== =======================================
!%
!%      Subroutine
!%      ----------
!%
!%      - OptionsDT_initialise
!%      - OptionsDT_copy
MODULE MWD_OPTIONS_DIFF
!% only: SetupDT
  USE MWD_SETUP
!% only: MeshDT
  USE MWD_MESH
!% only: Cost_OptionsDT, Cost_OptionsDT_initialise
  USE MWD_COST_OPTIONS_DIFF
!% only: Optimize_OptionsDT, Optimize_OptionsDT_initialise
  USE MWD_OPTIMIZE_OPTIONS
!% only: Common_OptionsDT, Common_OptionsDT_initialise
  USE MWD_COMMON_OPTIONS
  IMPLICIT NONE
  TYPE OPTIONSDT
      TYPE(OPTIMIZE_OPTIONSDT) :: optimize
      TYPE(COST_OPTIONSDT) :: cost
      TYPE(COMMON_OPTIONSDT) :: comm
  END TYPE OPTIONSDT
  TYPE OPTIONSDT_DIFF
      TYPE(COST_OPTIONSDT_DIFF) :: cost
  END TYPE OPTIONSDT_DIFF

CONTAINS
  SUBROUTINE OPTIONSDT_INITIALISE(this, setup, mesh, njoc, njrc)
    IMPLICIT NONE
    TYPE(OPTIONSDT), INTENT(INOUT) :: this
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    INTEGER, INTENT(IN) :: njoc, njrc
    CALL COST_OPTIONSDT_INITIALISE(this%cost, setup, mesh, njoc, njrc)
    CALL OPTIMIZE_OPTIONSDT_INITIALISE(this%optimize, setup)
    CALL COMMON_OPTIONSDT_INITIALISE(this%comm)
  END SUBROUTINE OPTIONSDT_INITIALISE

  SUBROUTINE OPTIONSDT_COPY(this, this_copy)
    IMPLICIT NONE
    TYPE(OPTIONSDT), INTENT(IN) :: this
    TYPE(OPTIONSDT), INTENT(OUT) :: this_copy
    this_copy = this
  END SUBROUTINE OPTIONSDT_COPY

END MODULE MWD_OPTIONS_DIFF

!%      (MWD) Module Wrapped and Differentiated.
!%
!%      Type
!%      ----
!%
!%      - RR_StatesDT
!%        Matrices containting spatialized states of hydrological operators.
!%        (reservoir level ...) The matrices are updated at each time step.
!%
!%          ========================== =====================================
!%          `Variables`                Description
!%          ========================== =====================================
!%          ``keys``                   Rainfall-runoff states keys
!%          ``values``                 Rainfall-runoff states values
!%
!§      Subroutine
!%      ----------
!%
!%      - RR_StatesDT_initialise
!%      - RR_StatesDT_copy
MODULE MWD_RR_STATES_DIFF
!% only: sp, lchar
  USE MD_CONSTANT
!% only: SetupDT
  USE MWD_SETUP
!% only: MeshDT
  USE MWD_MESH
  IMPLICIT NONE
!$F90W char-array
  TYPE RR_STATESDT
      CHARACTER(len=lchar), DIMENSION(:), ALLOCATABLE :: keys
      REAL(sp), DIMENSION(:, :, :), ALLOCATABLE :: values
  END TYPE RR_STATESDT
  TYPE RR_STATESDT_DIFF
      REAL(sp), DIMENSION(:, :, :), ALLOCATABLE :: values
  END TYPE RR_STATESDT_DIFF

CONTAINS
  SUBROUTINE RR_STATESDT_INITIALISE(this, setup, mesh)
    IMPLICIT NONE
    TYPE(RR_STATESDT), INTENT(INOUT) :: this
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    ALLOCATE(this%keys(setup%nrrs))
    this%keys = '...'
    ALLOCATE(this%values(mesh%nrow, mesh%ncol, setup%nrrs))
    this%values = -99._sp
  END SUBROUTINE RR_STATESDT_INITIALISE

  SUBROUTINE RR_STATESDT_COPY(this, this_copy)
    IMPLICIT NONE
    TYPE(RR_STATESDT), INTENT(IN) :: this
    TYPE(RR_STATESDT), INTENT(OUT) :: this_copy
    this_copy = this
  END SUBROUTINE RR_STATESDT_COPY

END MODULE MWD_RR_STATES_DIFF

!%      (MWD) Module Wrapped and Differentiated.
!%
!%      Type
!%      ----
!%
!%      - OutputDT
!%
!%          ======================== =======================================
!%          `Variables`              Description
!%          ======================== =======================================
!%          ``cost``                 Value of cost function
!%          ``response``             ResponseDT
!%          ``rr_final_states``      Rr_StatesDT
!%          ======================== =======================================
!%
!%      Subroutine
!%      ----------
!%
!%      - OutputDT_initialise
!%      - OutputDT_copy
MODULE MWD_OUTPUT_DIFF
!% only: sp
  USE MD_CONSTANT
!% only: SetupDT
  USE MWD_SETUP
!% only: MeshDT
  USE MWD_MESH
!% only: ResponseDT, ResponseDT_initialise
  USE MWD_RESPONSE
!% only: Rr_StatesDT, Rr_StatesDT_initialise
  USE MWD_RR_STATES_DIFF
  IMPLICIT NONE
  TYPE OUTPUTDT
      TYPE(RESPONSEDT) :: response
      TYPE(RR_STATESDT) :: rr_final_states
      REAL(sp) :: cost
  END TYPE OUTPUTDT
  TYPE OUTPUTDT_DIFF
      TYPE(RESPONSEDT) :: response
      REAL(sp) :: cost
  END TYPE OUTPUTDT_DIFF

CONTAINS
  SUBROUTINE OUTPUTDT_INITIALISE(this, setup, mesh)
    IMPLICIT NONE
    TYPE(OUTPUTDT), INTENT(INOUT) :: this
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    CALL RESPONSEDT_INITIALISE(this%response, setup, mesh)
    CALL RR_STATESDT_INITIALISE(this%rr_final_states, setup, mesh)
  END SUBROUTINE OUTPUTDT_INITIALISE

  SUBROUTINE OUTPUTDT_COPY(this, this_copy)
    IMPLICIT NONE
    TYPE(OUTPUTDT), INTENT(IN) :: this
    TYPE(OUTPUTDT), INTENT(OUT) :: this_copy
    this_copy = this
  END SUBROUTINE OUTPUTDT_COPY

END MODULE MWD_OUTPUT_DIFF

!%      (MWD) Module Wrapped and Differentiated.
!%
!%      Type
!%      ----
!%
!%      - ControlDT
!%          Control vector used in optimize and quantities required by the optimizer
!%
!%          ========================== =====================================
!%          `Variables`                Description
!%          ========================== =====================================
!%          ``x``                      Control vector
!%          ``l``                      Control vector lower bound
!%          ``u``                      Control vector upper bound
!%          ``x_raw``                  Control vector raw
!%          ``l_raw``                  Control vector lower bound raw
!%          ``u_raw``                  Control vector upper bound raw
!%          ``nbd``                    Control vector kind of bound
!%
!§      Subroutine
!%      ----------
!%
!%      - ControlDT_initialise
!%      - ControlDT_copy
MODULE MWD_CONTROL_DIFF
!% only: sp
  USE MD_CONSTANT
  IMPLICIT NONE
! Kinds: rr_parameters, rr_initial_states, serr_mu_parameters, serr_sigma_parameters, nn_parameters
!$F90W char-array
  TYPE CONTROLDT
      INTEGER :: n
      INTEGER, DIMENSION(5) :: nbk
      REAL(sp), DIMENSION(:), ALLOCATABLE :: x
      REAL(sp), DIMENSION(:), ALLOCATABLE :: l
      REAL(sp), DIMENSION(:), ALLOCATABLE :: u
      REAL(sp), DIMENSION(:), ALLOCATABLE :: x_raw
      REAL(sp), DIMENSION(:), ALLOCATABLE :: l_raw
      REAL(sp), DIMENSION(:), ALLOCATABLE :: u_raw
      INTEGER, DIMENSION(:), ALLOCATABLE :: nbd
      CHARACTER(len=lchar), DIMENSION(:), ALLOCATABLE :: name
  END TYPE CONTROLDT
  TYPE CONTROLDT_DIFF
      REAL(sp), DIMENSION(:), ALLOCATABLE :: x
      REAL(sp), DIMENSION(:), ALLOCATABLE :: l
      REAL(sp), DIMENSION(:), ALLOCATABLE :: u
      REAL(sp), DIMENSION(:), ALLOCATABLE :: l_raw
      REAL(sp), DIMENSION(:), ALLOCATABLE :: u_raw
      INTEGER, DIMENSION(:), ALLOCATABLE :: nbd
  END TYPE CONTROLDT_DIFF

CONTAINS
  SUBROUTINE CONTROLDT_INITIALISE(this, nbk)
    IMPLICIT NONE
    TYPE(CONTROLDT), INTENT(INOUT) :: this
    INTRINSIC SIZE
    INTEGER, DIMENSION(SIZE(this%nbk)), INTENT(IN) :: nbk
    INTRINSIC SUM
    CALL CONTROLDT_FINALISE(this)
    this%nbk = nbk
    this%n = SUM(this%nbk)
    ALLOCATE(this%x(this%n))
    this%x = -99._sp
    ALLOCATE(this%l(this%n))
    this%l = -99._sp
    ALLOCATE(this%u(this%n))
    this%u = -99._sp
    ALLOCATE(this%x_raw(this%n))
    this%x_raw = 0._sp
    ALLOCATE(this%l_raw(this%n))
    this%l_raw = -99._sp
    ALLOCATE(this%u_raw(this%n))
    this%u_raw = -99._sp
    ALLOCATE(this%nbd(this%n))
    this%nbd = -99
    ALLOCATE(this%name(this%n))
    this%name = '...'
  END SUBROUTINE CONTROLDT_INITIALISE

  SUBROUTINE CONTROLDT_FINALISE(this)
    IMPLICIT NONE
    TYPE(CONTROLDT), INTENT(INOUT) :: this
    INTRINSIC ALLOCATED
    IF (ALLOCATED(this%x)) THEN
      DEALLOCATE(this%x)
      DEALLOCATE(this%l)
      DEALLOCATE(this%u)
      DEALLOCATE(this%x_raw)
      DEALLOCATE(this%l_raw)
      DEALLOCATE(this%u_raw)
      DEALLOCATE(this%nbd)
      DEALLOCATE(this%name)
    END IF
  END SUBROUTINE CONTROLDT_FINALISE

  SUBROUTINE CONTROLDT_COPY(this, this_copy)
    IMPLICIT NONE
    TYPE(CONTROLDT), INTENT(IN) :: this
    TYPE(CONTROLDT), INTENT(OUT) :: this_copy
    this_copy = this
  END SUBROUTINE CONTROLDT_COPY

! To manually deallocate from Python. ControlDT_finalise is used as
! __del__ method for garbage collecting (implemented by f90wrap automatically)
  SUBROUTINE CONTROLDT_DEALLOC(this)
    IMPLICIT NONE
    TYPE(CONTROLDT), INTENT(INOUT) :: this
    CALL CONTROLDT_FINALISE(this)
  END SUBROUTINE CONTROLDT_DEALLOC

END MODULE MWD_CONTROL_DIFF

!%      (MWD) Module Wrapped and Differentiated.
!%
!%      Type
!%      ----
!%
!%      - NN_ParametersDT
!%          Contain weights and biases of the neural network
!%
!%          ======================== ===========================================================
!%          `Variables`              Description
!%          ======================== ===========================================================
!%          ``weight_1``             Transposed weight at the first layer of the neural network
!%          ``bias_1``               Bias at the first layer of the neural network
!%          ``weight_2``             Transposed weight at the second layer of the neural network
!%          ``bias_2``               Bias at the second layer of the neural network
!%          ``weight_3``             Transposed weight at the third layer of the neural network
!%          ``bias_3``               Bias at the third layer of the neural network
!%          ======================== ===========================================================
!%
!%      Subroutine
!%      ----------
!%
!%      - NN_ParametersDT_initialise
!%      - NN_ParametersDT_copy
MODULE MWD_NN_PARAMETERS_DIFF
!% only: sp
  USE MD_CONSTANT
!% only: SetupDT
  USE MWD_SETUP
  IMPLICIT NONE
  TYPE NN_PARAMETERSDT
      REAL(sp), DIMENSION(:, :), ALLOCATABLE :: weight_1
      REAL(sp), DIMENSION(:), ALLOCATABLE :: bias_1
      REAL(sp), DIMENSION(:, :), ALLOCATABLE :: weight_2
      REAL(sp), DIMENSION(:), ALLOCATABLE :: bias_2
      REAL(sp), DIMENSION(:, :), ALLOCATABLE :: weight_3
      REAL(sp), DIMENSION(:), ALLOCATABLE :: bias_3
  END TYPE NN_PARAMETERSDT

CONTAINS
  SUBROUTINE NN_PARAMETERSDT_INITIALISE(this, setup)
    IMPLICIT NONE
    TYPE(NN_PARAMETERSDT), INTENT(INOUT) :: this
    TYPE(SETUPDT), INTENT(IN) :: setup
!% First layer
    ALLOCATE(this%weight_1(setup%neurons(2), setup%neurons(1)))
    this%weight_1 = -99._sp
    ALLOCATE(this%bias_1(setup%neurons(2)))
    this%bias_1 = -99._sp
!% Second layer
    ALLOCATE(this%weight_2(setup%neurons(3), setup%neurons(2)))
    this%weight_2 = -99._sp
    ALLOCATE(this%bias_2(setup%neurons(3)))
    this%bias_2 = -99._sp
!% Third layer
    ALLOCATE(this%weight_3(setup%neurons(4), setup%neurons(3)))
    this%weight_3 = -99._sp
    ALLOCATE(this%bias_3(setup%neurons(4)))
    this%bias_3 = -99._sp
  END SUBROUTINE NN_PARAMETERSDT_INITIALISE

  SUBROUTINE NN_PARAMETERSDT_COPY(this, this_copy)
    IMPLICIT NONE
    TYPE(NN_PARAMETERSDT), INTENT(IN) :: this
    TYPE(NN_PARAMETERSDT), INTENT(OUT) :: this_copy
    this_copy = this
  END SUBROUTINE NN_PARAMETERSDT_COPY

END MODULE MWD_NN_PARAMETERS_DIFF

!%      (MWD) Module Wrapped and Differentiated.
!%
!%      Type
!%      ----
!%
!%
!%      - RR_ParametersDT
!%          Matrices containting spatialized parameters of hydrological operators.
!%          (reservoir max capacity, lag time ...)
!%
!%          ========================== =====================================
!%          `Variables`                Description
!%          ========================== =====================================
!%          ``keys``                   Rainfall-runoff parameters keys
!%          ``values``                 Rainfall-runoff parameters values
!%
!%
!%      Subroutine
!%      ----------
!%
!%      - RR_ParametersDT_initialise
!%      - RR_ParametersDT_copy
MODULE MWD_RR_PARAMETERS_DIFF
!% only: sp, lchar
  USE MD_CONSTANT
!% only: SetupDT
  USE MWD_SETUP
!% only: MeshDT
  USE MWD_MESH
  IMPLICIT NONE
!$F90W char-array
  TYPE RR_PARAMETERSDT
      CHARACTER(len=lchar), DIMENSION(:), ALLOCATABLE :: keys
      REAL(sp), DIMENSION(:, :, :), ALLOCATABLE :: values
  END TYPE RR_PARAMETERSDT
  TYPE RR_PARAMETERSDT_DIFF
      REAL(sp), DIMENSION(:, :, :), ALLOCATABLE :: values
  END TYPE RR_PARAMETERSDT_DIFF

CONTAINS
  SUBROUTINE RR_PARAMETERSDT_INITIALISE(this, setup, mesh)
    IMPLICIT NONE
    TYPE(RR_PARAMETERSDT), INTENT(INOUT) :: this
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    ALLOCATE(this%keys(setup%nrrp))
    this%keys = '...'
    ALLOCATE(this%values(mesh%nrow, mesh%ncol, setup%nrrp))
    this%values = -99._sp
  END SUBROUTINE RR_PARAMETERSDT_INITIALISE

  SUBROUTINE RR_PARAMETERSDT_COPY(this, this_copy)
    IMPLICIT NONE
    TYPE(RR_PARAMETERSDT), INTENT(IN) :: this
    TYPE(RR_PARAMETERSDT), INTENT(OUT) :: this_copy
    this_copy = this
  END SUBROUTINE RR_PARAMETERSDT_COPY

END MODULE MWD_RR_PARAMETERS_DIFF

!%      (MWD) Module Wrapped and Differentiated.
!%
!%      Type
!%      ----
!%
!%      - SErr_Mu_ParametersDT
!%          Vectors containting hyper parameters of the temporalisation function for mu, the mean of structural errors
!%          (mg0, mg1, ...)
!%
!%          ======================== =============================================
!%          `Variables`              Description
!%          ======================== =============================================
!%          ``keys``                 Structural errors mu hyper parameters keys
!%          ``values``               Structural errors mu hyper parameters values
!%          ======================== =============================================
!%
!%      Subroutine
!%      ----------
!%
!%      - SErr_Mu_ParametersDT_initialise
!%      - SErr_Mu_ParametersDT_copy
MODULE MWD_SERR_MU_PARAMETERS_DIFF
!% only: sp, lchar
  USE MD_CONSTANT
!% only: SetupDT
  USE MWD_SETUP
!% only: MeshDT
  USE MWD_MESH
  IMPLICIT NONE
!$F90W char-array
  TYPE SERR_MU_PARAMETERSDT
      CHARACTER(len=lchar), DIMENSION(:), ALLOCATABLE :: keys
      REAL(sp), DIMENSION(:, :), ALLOCATABLE :: values
  END TYPE SERR_MU_PARAMETERSDT
  TYPE SERR_MU_PARAMETERSDT_DIFF
      REAL(sp), DIMENSION(:, :), ALLOCATABLE :: values
  END TYPE SERR_MU_PARAMETERSDT_DIFF

CONTAINS
  SUBROUTINE SERR_MU_PARAMETERSDT_INITIALISE(this, setup, mesh)
    IMPLICIT NONE
    TYPE(SERR_MU_PARAMETERSDT), INTENT(INOUT) :: this
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    ALLOCATE(this%keys(setup%nsep_mu))
    this%keys = '...'
    ALLOCATE(this%values(mesh%ng, setup%nsep_mu))
    this%values = -99._sp
  END SUBROUTINE SERR_MU_PARAMETERSDT_INITIALISE

  SUBROUTINE SERR_MU_PARAMETERSDT_COPY(this, this_copy)
    IMPLICIT NONE
    TYPE(SERR_MU_PARAMETERSDT), INTENT(IN) :: this
    TYPE(SERR_MU_PARAMETERSDT), INTENT(OUT) :: this_copy
    this_copy = this
  END SUBROUTINE SERR_MU_PARAMETERSDT_COPY

END MODULE MWD_SERR_MU_PARAMETERS_DIFF

!%      (MWD) Module Wrapped and Differentiated.
!%
!%      Type
!%      ----
!%
!%      - SErr_Sigma_ParametersDT
!%          Vectors containting hyper parameters of the temporalisation function for sigma, the standard deviation of structural 
!errors
!%          (sg0, sg1, sg2, ...)
!%
!%          ======================== =============================================
!%          `Variables`              Description
!%          ======================== =============================================
!%          ``keys``                 Structural errors sigma hyper parameters keys
!%          ``values``               Structural errors sigma hyper parameters values
!%          ======================== =============================================
!%
!%      Subroutine
!%      ----------
!%
!%      - SErr_Sigma_ParametersDT_initialise
!%      - SErr_Sigma_ParametersDT_copy
MODULE MWD_SERR_SIGMA_PARAMETERS_DIFF
!% only: sp, lchar
  USE MD_CONSTANT
!% only: SetupDT
  USE MWD_SETUP
!% only: MeshDT
  USE MWD_MESH
  IMPLICIT NONE
!$F90W char-array
  TYPE SERR_SIGMA_PARAMETERSDT
      CHARACTER(len=lchar), DIMENSION(:), ALLOCATABLE :: keys
      REAL(sp), DIMENSION(:, :), ALLOCATABLE :: values
  END TYPE SERR_SIGMA_PARAMETERSDT
  TYPE SERR_SIGMA_PARAMETERSDT_DIFF
      REAL(sp), DIMENSION(:, :), ALLOCATABLE :: values
  END TYPE SERR_SIGMA_PARAMETERSDT_DIFF

CONTAINS
  SUBROUTINE SERR_SIGMA_PARAMETERSDT_INITIALISE(this, setup, mesh)
    IMPLICIT NONE
    TYPE(SERR_SIGMA_PARAMETERSDT), INTENT(INOUT) :: this
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    ALLOCATE(this%keys(setup%nsep_sigma))
    this%keys = '...'
    ALLOCATE(this%values(mesh%ng, setup%nsep_sigma))
    this%values = -99._sp
  END SUBROUTINE SERR_SIGMA_PARAMETERSDT_INITIALISE

  SUBROUTINE SERR_SIGMA_PARAMETERSDT_COPY(this, this_copy)
    IMPLICIT NONE
    TYPE(SERR_SIGMA_PARAMETERSDT), INTENT(IN) :: this
    TYPE(SERR_SIGMA_PARAMETERSDT), INTENT(OUT) :: this_copy
    this_copy = this
  END SUBROUTINE SERR_SIGMA_PARAMETERSDT_COPY

END MODULE MWD_SERR_SIGMA_PARAMETERS_DIFF

!%      (MWD) Module Wrapped and Differentiated.
!%
!%      Type
!%      ----
!%
!%      - ParametersDT
!%          Container for all parameters. The goal is to keep the control vector in sync with the spatial matrices
!%          of rainfall-runoff parameters and the hyper parameters for mu/sigma of structural erros
!%
!%          ========================== =====================================
!%          `Variables`                Description
!%          ========================== =====================================
!%          ``control``                ControlDT
!%          ``rr_parameters``          RR_ParametersDT
!%          ``rr_initial_states``      RR_StatesDT
!%          ``serr_mu_parameters``     SErr_Mu_ParametersDT
!%          ``serr_sigma_parameters``  SErr_Sigma_ParametersDT
!%
!§      Subroutine
!%      ----------
!%
!%      - ParametersDT_initialise
!%      - ParametersDT_copy
MODULE MWD_PARAMETERS_DIFF
!% only: sp
  USE MD_CONSTANT
!% only: SetupDT
  USE MWD_SETUP
!% only: MeshDT
  USE MWD_MESH
!% only: ControlDT
  USE MWD_CONTROL_DIFF
!% only: RR_ParametersDT, RR_ParametersDT_initialise
  USE MWD_RR_PARAMETERS_DIFF
!% only: RR_StatesDT, RR_StatesDT_initialise
  USE MWD_RR_STATES_DIFF
!% only: SErr_Mu_ParametersDT, SErr_Mu_ParametersDT_initialise
  USE MWD_SERR_MU_PARAMETERS_DIFF
!% only: SErr_Sigma_ParametersDT, SErr_Sigma_ParametersDT_initialise
  USE MWD_SERR_SIGMA_PARAMETERS_DIFF
!% only: NN_ParametersDT, NN_ParametersDT_initialise
  USE MWD_NN_PARAMETERS_DIFF
  IMPLICIT NONE
  TYPE PARAMETERSDT
      TYPE(CONTROLDT) :: control
      TYPE(RR_PARAMETERSDT) :: rr_parameters
      TYPE(RR_STATESDT) :: rr_initial_states
      TYPE(SERR_MU_PARAMETERSDT) :: serr_mu_parameters
      TYPE(SERR_SIGMA_PARAMETERSDT) :: serr_sigma_parameters
      TYPE(NN_PARAMETERSDT) :: nn_parameters
  END TYPE PARAMETERSDT
  TYPE PARAMETERSDT_DIFF
      TYPE(CONTROLDT_DIFF) :: control
      TYPE(RR_PARAMETERSDT) :: rr_parameters
      TYPE(RR_STATESDT) :: rr_initial_states
      TYPE(SERR_MU_PARAMETERSDT_DIFF) :: serr_mu_parameters
      TYPE(SERR_SIGMA_PARAMETERSDT_DIFF) :: serr_sigma_parameters
      TYPE(NN_PARAMETERSDT) :: nn_parameters
  END TYPE PARAMETERSDT_DIFF

CONTAINS
  SUBROUTINE PARAMETERSDT_INITIALISE(this, setup, mesh)
    IMPLICIT NONE
    TYPE(PARAMETERSDT), INTENT(INOUT) :: this
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    CALL RR_PARAMETERSDT_INITIALISE(this%rr_parameters, setup, mesh)
    CALL RR_STATESDT_INITIALISE(this%rr_initial_states, setup, mesh)
    CALL SERR_MU_PARAMETERSDT_INITIALISE(this%serr_mu_parameters, setup&
&                                  , mesh)
    CALL SERR_SIGMA_PARAMETERSDT_INITIALISE(this%serr_sigma_parameters, &
&                                     setup, mesh)
    CALL NN_PARAMETERSDT_INITIALISE(this%nn_parameters, setup)
  END SUBROUTINE PARAMETERSDT_INITIALISE

  SUBROUTINE PARAMETERSDT_COPY(this, this_copy)
    IMPLICIT NONE
    TYPE(PARAMETERSDT), INTENT(IN) :: this
    TYPE(PARAMETERSDT), INTENT(OUT) :: this_copy
    this_copy = this
  END SUBROUTINE PARAMETERSDT_COPY

END MODULE MWD_PARAMETERS_DIFF

!%      (MWD) Module Wrapped and Differentiated.
!%
!%      Type
!%      ----
!%
!%      - ReturnsDT
!%          Usefull quantities returned by the hydrological model other than response variables themselves.
!%
!%          ======================== =======================================
!%          `Variables`              Description
!%          ======================== =======================================
!%          ``nmts``                 Number of time step to return
!%          ``mask_time_step``       Mask of time step
!%          ``rr_states``            Array of Rr_StatesDT
!%          ``rr_states_flag``       Return flag of rr_states
!%          ``q_domain``             Array of discharge
!%          ``q_domain_flag``        Return flag of q_domain
!%          ``cost``                 Cost value
!%          ``cost_flag``            Return flag of cost
!%          ``jobs``                 Jobs value
!%          ``jobs_flag``            Return flag of jobs
!%          ``jreg``                 Jreg value
!%          ``jreg_flag``            Return flag of jreg
!%          ``log_lkh``              Log_lkh value
!%          ``log_lkh_flag``         Return flag of log_lkh
!%          ``log_prior``            Log_prior value
!%          ``log_prior_flag``       Return flag of log_prior
!%          ``log_h``                Log_h value
!%          ``log_h_flag``           Return flag of log_h
!%          ======================== =======================================
!%
!%      Subroutine
!%      ----------
!%
!%      - ReturnsDT_initialise
!%      - ReturnsDT_copy
MODULE MWD_RETURNS_DIFF
!% only: sp
  USE MD_CONSTANT
!% only: SetupDT
  USE MWD_SETUP
!% only: MeshDT
  USE MWD_MESH
!%only: RR_StatesDT, RR_StatesDT_initialise
  USE MWD_RR_STATES_DIFF
  IMPLICIT NONE
!$F90W index-array
  TYPE RETURNSDT
      INTEGER :: nmts
      LOGICAL, DIMENSION(:), ALLOCATABLE :: mask_time_step
      INTEGER, DIMENSION(:), ALLOCATABLE :: &
&     time_step_to_returns_time_step
      TYPE(RR_STATESDT), DIMENSION(:), ALLOCATABLE :: rr_states
      LOGICAL :: rr_states_flag=.false.
      REAL(sp), DIMENSION(:, :, :), ALLOCATABLE :: q_domain
      LOGICAL :: q_domain_flag=.false.
      REAL(sp) :: cost
      LOGICAL :: cost_flag=.false.
      REAL(sp) :: jobs
      LOGICAL :: jobs_flag=.false.
      REAL(sp) :: jreg
      LOGICAL :: jreg_flag=.false.
      REAL(sp) :: log_lkh
      LOGICAL :: log_lkh_flag=.false.
      REAL(sp) :: log_prior
      LOGICAL :: log_prior_flag=.false.
      REAL(sp) :: log_h
      LOGICAL :: log_h_flag=.false.
      REAL(sp), DIMENSION(:, :, :, :), ALLOCATABLE :: internal_fluxes
      LOGICAL :: internal_fluxes_flag=.false.
  END TYPE RETURNSDT

CONTAINS
  SUBROUTINE RETURNSDT_INITIALISE(this, setup, mesh, nmts, keys)
    IMPLICIT NONE
    TYPE(RETURNSDT), INTENT(INOUT) :: this
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    INTEGER, INTENT(IN) :: nmts
    CHARACTER, DIMENSION(:, :), INTENT(IN) :: keys
    INTEGER :: i, j
    INTRINSIC SIZE
    CHARACTER(len=lchar), DIMENSION(SIZE(keys, 2)) :: wkeys
    wkeys = ''
    DO i=1,SIZE(keys, 2)
      DO j=1,SIZE(keys, 1)
        wkeys(i)(j:j) = keys(j, i)
      END DO
    END DO
    this%nmts = nmts
    ALLOCATE(this%mask_time_step(setup%ntime_step))
    this%mask_time_step = .false.
    ALLOCATE(this%time_step_to_returns_time_step(setup%ntime_step))
    this%time_step_to_returns_time_step = -99
! Variable inside forward run are pre allocated
! Variable inside optimize will be allocated on the fly
    DO i=1,SIZE(wkeys)
      SELECT CASE  (wkeys(i)) 
      CASE ('rr_states') 
        this%rr_states_flag = .true.
        ALLOCATE(this%rr_states(this%nmts))
        DO j=1,this%nmts
          CALL RR_STATESDT_INITIALISE(this%rr_states(j), setup, mesh)
        END DO
      CASE ('q_domain') 
        this%q_domain_flag = .true.
        ALLOCATE(this%q_domain(mesh%nrow, mesh%ncol, this%nmts))
        this%q_domain = -99._sp
      CASE ('cost') 
        this%cost_flag = .true.
      CASE ('jobs') 
        this%jobs_flag = .true.
      CASE ('jreg') 
        this%jreg_flag = .true.
      CASE ('log_lkh') 
        this%log_lkh_flag = .true.
      CASE ('log_prior') 
        this%log_prior_flag = .true.
      CASE ('log_h') 
        this%log_h_flag = .true.
      CASE ('internal_fluxes') 
        this%internal_fluxes_flag = .true.
        ALLOCATE(this%internal_fluxes(mesh%nrow, mesh%ncol, this%nmts, &
&       setup%n_internal_fluxes))
      END SELECT
    END DO
  END SUBROUTINE RETURNSDT_INITIALISE

  SUBROUTINE RETURNSDT_COPY(this, this_copy)
    IMPLICIT NONE
    TYPE(RETURNSDT), INTENT(IN) :: this
    TYPE(RETURNSDT), INTENT(OUT) :: this_copy
    this_copy = this
  END SUBROUTINE RETURNSDT_COPY

END MODULE MWD_RETURNS_DIFF

!%      (MWD) Module Wrapped and Differentiated.
!%
!%      Subroutine
!%      ----------
!%
!%      - kge_components
!%
!%      Function
!%      --------
!%
!%      - nse
!%      - nnse
!%      - kge
!%      - mae
!%      - mape
!%      - se
!%      - mse
!%      - rmse
!%      - lgrm
MODULE MWD_METRICS_DIFF
!% only: sp
  USE MD_CONSTANT
  IMPLICIT NONE

CONTAINS
!  Differentiation of nse in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: res
!   with respect to varying inputs: y
  FUNCTION NSE_D(x, y, y_d, res) RESULT (RES_D)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp), DIMENSION(:), INTENT(IN) :: y_d
    REAL(sp) :: res
    REAL(sp) :: res_d
    REAL(sp) :: sum_x, sum_xx, sum_yy, sum_xy, mean_x, num, den
    REAL(sp) :: sum_yy_d, sum_xy_d, num_d
    INTEGER :: i, n
    INTRINSIC SIZE
!% Metric computation
    n = 0
    sum_x = 0._sp
    sum_xx = 0._sp
    sum_yy = 0._sp
    sum_xy = 0._sp
    sum_yy_d = 0.0_4
    sum_xy_d = 0.0_4
    DO i=1,SIZE(x)
      IF (x(i) .GE. 0._sp) THEN
        n = n + 1
        sum_x = sum_x + x(i)
        sum_xx = sum_xx + x(i)*x(i)
        sum_yy_d = sum_yy_d + 2*y(i)*y_d(i)
        sum_yy = sum_yy + y(i)*y(i)
        sum_xy_d = sum_xy_d + x(i)*y_d(i)
        sum_xy = sum_xy + x(i)*y(i)
      END IF
    END DO
    mean_x = sum_x/n
!% NSE numerator / denominator
    num_d = sum_yy_d - 2*sum_xy_d
    num = sum_xx - 2*sum_xy + sum_yy
    den = sum_xx - n*mean_x*mean_x
!% NSE criterion
    res_d = -(num_d/den)
    res = 1._sp - num/den
  END FUNCTION NSE_D

!  Differentiation of nse in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: res y
!   with respect to varying inputs: y
  SUBROUTINE NSE_B(x, y, y_b, res_b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp), DIMENSION(:) :: y_b
    REAL(sp) :: res
    REAL(sp) :: res_b
    REAL(sp) :: sum_x, sum_xx, sum_yy, sum_xy, mean_x, num, den
    REAL(sp) :: sum_yy_b, sum_xy_b, num_b
    INTEGER :: i, n
    INTRINSIC SIZE
    INTEGER :: ad_to
    INTEGER :: branch
!% Metric computation
    n = 0
    sum_x = 0._sp
    sum_xx = 0._sp
    DO i=1,SIZE(x)
      IF (x(i) .LT. 0._sp) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        n = n + 1
        sum_x = sum_x + x(i)
        sum_xx = sum_xx + x(i)*x(i)
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    CALL PUSHINTEGER4(i - 1)
    mean_x = sum_x/n
!% NSE numerator / denominator
    den = sum_xx - n*mean_x*mean_x
!% NSE criterion
    num_b = -(res_b/den)
    sum_yy_b = num_b
    sum_xy_b = -(2*num_b)
    CALL POPINTEGER4(ad_to)
    DO i=ad_to,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) y_b(i) = y_b(i) + x(i)*sum_xy_b + 2*y(i)*&
&         sum_yy_b
    END DO
  END SUBROUTINE NSE_B

  FUNCTION NSE(x, y) RESULT (RES)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp) :: res
    REAL(sp) :: sum_x, sum_xx, sum_yy, sum_xy, mean_x, num, den
    INTEGER :: i, n
    INTRINSIC SIZE
!% Metric computation
    n = 0
    sum_x = 0._sp
    sum_xx = 0._sp
    sum_yy = 0._sp
    sum_xy = 0._sp
    DO i=1,SIZE(x)
      IF (x(i) .GE. 0._sp) THEN
        n = n + 1
        sum_x = sum_x + x(i)
        sum_xx = sum_xx + x(i)*x(i)
        sum_yy = sum_yy + y(i)*y(i)
        sum_xy = sum_xy + x(i)*y(i)
      END IF
    END DO
    mean_x = sum_x/n
!% NSE numerator / denominator
    num = sum_xx - 2*sum_xy + sum_yy
    den = sum_xx - n*mean_x*mean_x
!% NSE criterion
    res = 1._sp - num/den
  END FUNCTION NSE

!  Differentiation of nnse in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: res
!   with respect to varying inputs: y
  FUNCTION NNSE_D(x, y, y_d, res) RESULT (RES_D)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp), DIMENSION(:), INTENT(IN) :: y_d
    REAL(sp) :: res
    REAL(sp) :: res_d
    REAL(sp) :: result1
    REAL(sp) :: result1_d
    result1_d = NSE_D(x, y, y_d, result1)
    res_d = result1_d/(2._sp-result1)**2
    res = 1._sp/(2._sp-result1)
  END FUNCTION NNSE_D

!  Differentiation of nnse in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: res y
!   with respect to varying inputs: y
  SUBROUTINE NNSE_B(x, y, y_b, res_b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp), DIMENSION(:) :: y_b
    REAL(sp) :: res
    REAL(sp) :: res_b
    REAL(sp) :: result1
    REAL(sp) :: result1_b
    result1 = NSE(x, y)
    result1_b = res_b/(2._sp-result1)**2
    CALL NSE_B(x, y, y_b, result1_b)
  END SUBROUTINE NNSE_B

  FUNCTION NNSE(x, y) RESULT (RES)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp) :: res
    REAL(sp) :: result1
    result1 = NSE(x, y)
    res = 1._sp/(2._sp-result1)
  END FUNCTION NNSE

!  Differentiation of kge_components in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: r a b
!   with respect to varying inputs: y
  SUBROUTINE KGE_COMPONENTS_D(x, y, y_d, r, r_d, a, a_d, b, b_d)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp), DIMENSION(:), INTENT(IN) :: y_d
    REAL(sp), INTENT(INOUT) :: r, a, b
    REAL(sp), INTENT(INOUT) :: r_d, a_d, b_d
    REAL(sp) :: sum_x, sum_y, sum_xx, sum_yy, sum_xy, mean_x, mean_y, &
&   var_x, var_y, cov
    REAL(sp) :: sum_y_d, sum_yy_d, sum_xy_d, mean_y_d, var_y_d, cov_d
    INTEGER :: n, i
    INTRINSIC SIZE
    INTRINSIC SQRT
    REAL(sp) :: result1
    REAL(sp) :: result1_d
    REAL(sp) :: result2
    REAL(sp) :: result2_d
    REAL(sp) :: temp
! Metric computation
    n = 0
    sum_x = 0._sp
    sum_y = 0._sp
    sum_xx = 0._sp
    sum_yy = 0._sp
    sum_xy = 0._sp
    sum_yy_d = 0.0_4
    sum_y_d = 0.0_4
    sum_xy_d = 0.0_4
    DO i=1,SIZE(x)
      IF (x(i) .GE. 0._sp) THEN
        n = n + 1
        sum_x = sum_x + x(i)
        sum_y_d = sum_y_d + y_d(i)
        sum_y = sum_y + y(i)
        sum_xx = sum_xx + x(i)*x(i)
        sum_yy_d = sum_yy_d + 2*y(i)*y_d(i)
        sum_yy = sum_yy + y(i)*y(i)
        sum_xy_d = sum_xy_d + x(i)*y_d(i)
        sum_xy = sum_xy + x(i)*y(i)
      END IF
    END DO
    mean_x = sum_x/n
    mean_y_d = sum_y_d/n
    mean_y = sum_y/n
    var_x = sum_xx/n - mean_x*mean_x
    var_y_d = sum_yy_d/n - 2*mean_y*mean_y_d
    var_y = sum_yy/n - mean_y*mean_y
    cov_d = sum_xy_d/n - mean_x*mean_y_d
    cov = sum_xy/n - mean_x*mean_y
! KGE components (r, alpha, beta)
    result1 = SQRT(var_x)
    temp = SQRT(var_y)
    IF (var_y .EQ. 0.0) THEN
      result2_d = 0.0_4
    ELSE
      result2_d = var_y_d/(2.0*temp)
    END IF
    result2 = temp
    temp = cov/(result1*result2)
    r_d = (cov_d-temp*result1*result2_d)/(result1*result2)
    r = temp
    temp = SQRT(var_y)
    IF (var_y .EQ. 0.0) THEN
      result1_d = 0.0_4
    ELSE
      result1_d = var_y_d/(2.0*temp)
    END IF
    result1 = temp
    result2 = SQRT(var_x)
    a_d = result1_d/result2
    a = result1/result2
    b_d = mean_y_d/mean_x
    b = mean_y/mean_x
  END SUBROUTINE KGE_COMPONENTS_D

!  Differentiation of kge_components in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: r y a b
!   with respect to varying inputs: y
  SUBROUTINE KGE_COMPONENTS_B(x, y, y_b, r, r_b, a, a_b, b, b_b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp), DIMENSION(:) :: y_b
    REAL(sp), INTENT(INOUT) :: r, a, b
    REAL(sp), INTENT(INOUT) :: r_b, a_b, b_b
    REAL(sp) :: sum_x, sum_y, sum_xx, sum_yy, sum_xy, mean_x, mean_y, &
&   var_x, var_y, cov
    REAL(sp) :: sum_y_b, sum_yy_b, sum_xy_b, mean_y_b, var_y_b, cov_b
    INTEGER :: n, i
    INTRINSIC SIZE
    INTRINSIC SQRT
    REAL(sp) :: result1
    REAL(sp) :: result1_b
    REAL(sp) :: result2
    REAL(sp) :: result2_b
    REAL(sp) :: temp_b
    INTEGER :: ad_to
    INTEGER :: branch
! Metric computation
    n = 0
    sum_x = 0._sp
    sum_y = 0._sp
    sum_xx = 0._sp
    sum_yy = 0._sp
    sum_xy = 0._sp
    DO i=1,SIZE(x)
      IF (x(i) .LT. 0._sp) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        n = n + 1
        sum_x = sum_x + x(i)
        sum_y = sum_y + y(i)
        sum_xx = sum_xx + x(i)*x(i)
        sum_yy = sum_yy + y(i)*y(i)
        sum_xy = sum_xy + x(i)*y(i)
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    CALL PUSHINTEGER4(i - 1)
    mean_x = sum_x/n
    mean_y = sum_y/n
    var_x = sum_xx/n - mean_x*mean_x
    var_y = sum_yy/n - mean_y*mean_y
    cov = sum_xy/n - mean_x*mean_y
! KGE components (r, alpha, beta)
    result1 = SQRT(var_x)
    result2 = SQRT(var_y)
    CALL PUSHREAL4(result2)
    result2 = SQRT(var_x)
    result1_b = a_b/result2
    CALL POPREAL4(result2)
    IF (var_y .EQ. 0.0) THEN
      var_y_b = 0.0_4
    ELSE
      var_y_b = result1_b/(2.0*SQRT(var_y))
    END IF
    temp_b = r_b/(result1*result2)
    cov_b = temp_b
    result2_b = -(cov*temp_b/result2)
    IF (.NOT.var_y .EQ. 0.0) var_y_b = var_y_b + result2_b/(2.0*SQRT(&
&       var_y))
    mean_y_b = b_b/mean_x - mean_x*cov_b - 2*mean_y*var_y_b
    sum_xy_b = cov_b/n
    sum_yy_b = var_y_b/n
    sum_y_b = mean_y_b/n
    CALL POPINTEGER4(ad_to)
    DO i=ad_to,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) y_b(i) = y_b(i) + x(i)*sum_xy_b + 2*y(i)*&
&         sum_yy_b + sum_y_b
    END DO
  END SUBROUTINE KGE_COMPONENTS_B

  SUBROUTINE KGE_COMPONENTS(x, y, r, a, b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp), INTENT(INOUT) :: r, a, b
    REAL(sp) :: sum_x, sum_y, sum_xx, sum_yy, sum_xy, mean_x, mean_y, &
&   var_x, var_y, cov
    INTEGER :: n, i
    INTRINSIC SIZE
    INTRINSIC SQRT
    REAL(sp) :: result1
    REAL(sp) :: result2
! Metric computation
    n = 0
    sum_x = 0._sp
    sum_y = 0._sp
    sum_xx = 0._sp
    sum_yy = 0._sp
    sum_xy = 0._sp
    DO i=1,SIZE(x)
      IF (x(i) .GE. 0._sp) THEN
        n = n + 1
        sum_x = sum_x + x(i)
        sum_y = sum_y + y(i)
        sum_xx = sum_xx + x(i)*x(i)
        sum_yy = sum_yy + y(i)*y(i)
        sum_xy = sum_xy + x(i)*y(i)
      END IF
    END DO
    mean_x = sum_x/n
    mean_y = sum_y/n
    var_x = sum_xx/n - mean_x*mean_x
    var_y = sum_yy/n - mean_y*mean_y
    cov = sum_xy/n - mean_x*mean_y
! KGE components (r, alpha, beta)
    result1 = SQRT(var_x)
    result2 = SQRT(var_y)
    r = cov/result1/result2
    result1 = SQRT(var_y)
    result2 = SQRT(var_x)
    a = result1/result2
    b = mean_y/mean_x
  END SUBROUTINE KGE_COMPONENTS

!  Differentiation of kge in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: res
!   with respect to varying inputs: y
  FUNCTION KGE_D(x, y, y_d, res) RESULT (RES_D)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp), DIMENSION(:), INTENT(IN) :: y_d
    REAL(sp) :: res
    REAL(sp) :: res_d
    REAL(sp) :: r, a, b
    REAL(sp) :: r_d, a_d, b_d
    INTRINSIC SQRT
    REAL(sp) :: arg1
    REAL(sp) :: arg1_d
    REAL(sp) :: result1
    REAL(sp) :: result1_d
    REAL(sp) :: temp
    CALL KGE_COMPONENTS_D(x, y, y_d, r, r_d, a, a_d, b, b_d)
! KGE criterion
    arg1_d = 2*(r-1._sp)*r_d + 2*(b-1._sp)*b_d + 2*(a-1._sp)*a_d
    arg1 = (r-1._sp)*(r-1._sp) + (b-1._sp)*(b-1._sp) + (a-1._sp)*(a-&
&     1._sp)
    temp = SQRT(arg1)
    IF (arg1 .EQ. 0.0) THEN
      result1_d = 0.0_4
    ELSE
      result1_d = arg1_d/(2.0*temp)
    END IF
    result1 = temp
    res_d = -result1_d
    res = 1._sp - result1
  END FUNCTION KGE_D

!  Differentiation of kge in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: res y
!   with respect to varying inputs: y
  SUBROUTINE KGE_B(x, y, y_b, res_b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp), DIMENSION(:) :: y_b
    REAL(sp) :: res
    REAL(sp) :: res_b
    REAL(sp) :: r, a, b
    REAL(sp) :: r_b, a_b, b_b
    INTRINSIC SQRT
    REAL(sp) :: arg1
    REAL(sp) :: arg1_b
    REAL(sp) :: result1
    REAL(sp) :: result1_b
    CALL KGE_COMPONENTS(x, y, r, a, b)
! KGE criterion
    arg1 = (r-1._sp)*(r-1._sp) + (b-1._sp)*(b-1._sp) + (a-1._sp)*(a-&
&     1._sp)
    result1_b = -res_b
    arg1 = (r-1._sp)*(r-1._sp) + (b-1._sp)*(b-1._sp) + (a-1._sp)*(a-&
&     1._sp)
    IF (arg1 .EQ. 0.0) THEN
      arg1_b = 0.0_4
    ELSE
      arg1_b = result1_b/(2.0*SQRT(arg1))
    END IF
    r_b = 2*(r-1._sp)*arg1_b
    b_b = 2*(b-1._sp)*arg1_b
    a_b = 2*(a-1._sp)*arg1_b
    CALL KGE_COMPONENTS_B(x, y, y_b, r, r_b, a, a_b, b, b_b)
  END SUBROUTINE KGE_B

  FUNCTION KGE(x, y) RESULT (RES)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp) :: res
    REAL(sp) :: r, a, b
    INTRINSIC SQRT
    REAL(sp) :: arg1
    REAL(sp) :: result1
    CALL KGE_COMPONENTS(x, y, r, a, b)
! KGE criterion
    arg1 = (r-1._sp)*(r-1._sp) + (b-1._sp)*(b-1._sp) + (a-1._sp)*(a-&
&     1._sp)
    result1 = SQRT(arg1)
    res = 1._sp - result1
  END FUNCTION KGE

!  Differentiation of mae in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: res
!   with respect to varying inputs: y
  FUNCTION MAE_D(x, y, y_d, res) RESULT (RES_D)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp), DIMENSION(:), INTENT(IN) :: y_d
    REAL(sp) :: res
    REAL(sp) :: res_d
    INTEGER :: i, n
    INTRINSIC SIZE
    INTRINSIC ABS
    REAL(sp) :: abs0
    REAL(sp) :: abs0_d
    n = 0
    res = 0._sp
    res_d = 0.0_4
    DO i=1,SIZE(x)
      IF (x(i) .GE. 0._sp) THEN
        n = n + 1
        IF (x(i) - y(i) .GE. 0.) THEN
          abs0_d = -y_d(i)
          abs0 = x(i) - y(i)
        ELSE
          abs0_d = y_d(i)
          abs0 = -(x(i)-y(i))
        END IF
        res_d = res_d + abs0_d
        res = res + abs0
      END IF
    END DO
    res_d = res_d/n
    res = res/n
  END FUNCTION MAE_D

!  Differentiation of mae in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: res y
!   with respect to varying inputs: y
  SUBROUTINE MAE_B(x, y, y_b, res_b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp), DIMENSION(:) :: y_b
    REAL(sp) :: res
    REAL(sp) :: res_b
    INTEGER :: i, n
    INTRINSIC SIZE
    INTRINSIC ABS
    REAL(sp) :: abs0
    REAL(sp) :: abs0_b
    INTEGER :: branch
    INTEGER :: ad_to
    n = 0
    DO i=1,SIZE(x)
      IF (x(i) .LT. 0._sp) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        n = n + 1
        IF (x(i) - y(i) .GE. 0.) THEN
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHCONTROL1B(1)
        END IF
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    CALL PUSHINTEGER4(i - 1)
    res_b = res_b/n
    CALL POPINTEGER4(ad_to)
    DO i=ad_to,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        abs0_b = res_b
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          y_b(i) = y_b(i) - abs0_b
        ELSE
          y_b(i) = y_b(i) + abs0_b
        END IF
      END IF
    END DO
  END SUBROUTINE MAE_B

  FUNCTION MAE(x, y) RESULT (RES)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp) :: res
    INTEGER :: i, n
    INTRINSIC SIZE
    INTRINSIC ABS
    REAL(sp) :: abs0
    n = 0
    res = 0._sp
    DO i=1,SIZE(x)
      IF (x(i) .GE. 0._sp) THEN
        n = n + 1
        IF (x(i) - y(i) .GE. 0.) THEN
          abs0 = x(i) - y(i)
        ELSE
          abs0 = -(x(i)-y(i))
        END IF
        res = res + abs0
      END IF
    END DO
    res = res/n
  END FUNCTION MAE

!  Differentiation of mape in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: res
!   with respect to varying inputs: y
  FUNCTION MAPE_D(x, y, y_d, res) RESULT (RES_D)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp), DIMENSION(:), INTENT(IN) :: y_d
    REAL(sp) :: res
    REAL(sp) :: res_d
    INTEGER :: i, n
    INTRINSIC SIZE
    INTRINSIC ABS
    REAL(sp) :: abs0
    REAL(sp) :: abs0_d
    n = 0
    res = 0._sp
    res_d = 0.0_4
    DO i=1,SIZE(x)
      IF (x(i) .GE. 0._sp) THEN
        n = n + 1
        IF ((x(i)-y(i))/x(i) .GE. 0.) THEN
          abs0_d = -(y_d(i)/x(i))
          abs0 = (x(i)-y(i))/x(i)
        ELSE
          abs0_d = y_d(i)/x(i)
          abs0 = -((x(i)-y(i))/x(i))
        END IF
        res_d = res_d + abs0_d
        res = res + abs0
      END IF
    END DO
    res_d = res_d/n
    res = res/n
  END FUNCTION MAPE_D

!  Differentiation of mape in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: res y
!   with respect to varying inputs: y
  SUBROUTINE MAPE_B(x, y, y_b, res_b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp), DIMENSION(:) :: y_b
    REAL(sp) :: res
    REAL(sp) :: res_b
    INTEGER :: i, n
    INTRINSIC SIZE
    INTRINSIC ABS
    REAL(sp) :: abs0
    REAL(sp) :: abs0_b
    INTEGER :: branch
    INTEGER :: ad_to
    n = 0
    DO i=1,SIZE(x)
      IF (x(i) .LT. 0._sp) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        n = n + 1
        IF ((x(i)-y(i))/x(i) .GE. 0.) THEN
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHCONTROL1B(1)
        END IF
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    CALL PUSHINTEGER4(i - 1)
    res_b = res_b/n
    CALL POPINTEGER4(ad_to)
    DO i=ad_to,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        abs0_b = res_b
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          y_b(i) = y_b(i) - abs0_b/x(i)
        ELSE
          y_b(i) = y_b(i) + abs0_b/x(i)
        END IF
      END IF
    END DO
  END SUBROUTINE MAPE_B

  FUNCTION MAPE(x, y) RESULT (RES)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp) :: res
    INTEGER :: i, n
    INTRINSIC SIZE
    INTRINSIC ABS
    REAL(sp) :: abs0
    n = 0
    res = 0._sp
    DO i=1,SIZE(x)
      IF (x(i) .GE. 0._sp) THEN
        n = n + 1
        IF ((x(i)-y(i))/x(i) .GE. 0.) THEN
          abs0 = (x(i)-y(i))/x(i)
        ELSE
          abs0 = -((x(i)-y(i))/x(i))
        END IF
        res = res + abs0
      END IF
    END DO
    res = res/n
  END FUNCTION MAPE

!  Differentiation of se in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: res
!   with respect to varying inputs: y
  FUNCTION SE_D(x, y, y_d, res) RESULT (RES_D)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp), DIMENSION(:), INTENT(IN) :: y_d
    REAL(sp) :: res
    REAL(sp) :: res_d
    INTEGER :: i
    INTRINSIC SIZE
    res = 0._sp
    res_d = 0.0_4
    DO i=1,SIZE(x)
      IF (x(i) .GE. 0._sp) THEN
        res_d = res_d - 2*(x(i)-y(i))*y_d(i)
        res = res + (x(i)-y(i))*(x(i)-y(i))
      END IF
    END DO
  END FUNCTION SE_D

!  Differentiation of se in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: res y
!   with respect to varying inputs: y
  SUBROUTINE SE_B(x, y, y_b, res_b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp), DIMENSION(:) :: y_b
    REAL(sp) :: res
    REAL(sp) :: res_b
    INTEGER :: i
    INTRINSIC SIZE
    INTEGER :: ad_to
    INTEGER :: branch
    DO i=1,SIZE(x)
      IF (x(i) .LT. 0._sp) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    ad_to = i - 1
    DO i=ad_to,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) y_b(i) = y_b(i) - 2*(x(i)-y(i))*res_b
    END DO
  END SUBROUTINE SE_B

  FUNCTION SE(x, y) RESULT (RES)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp) :: res
    INTEGER :: i
    INTRINSIC SIZE
    res = 0._sp
    DO i=1,SIZE(x)
      IF (x(i) .GE. 0._sp) res = res + (x(i)-y(i))*(x(i)-y(i))
    END DO
  END FUNCTION SE

!  Differentiation of mse in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: res
!   with respect to varying inputs: y
  FUNCTION MSE_D(x, y, y_d, res) RESULT (RES_D)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp), DIMENSION(:), INTENT(IN) :: y_d
    REAL(sp) :: res
    REAL(sp) :: res_d
    INTEGER :: i, n
    INTRINSIC SIZE
    REAL(sp) :: result1
    REAL(sp) :: result1_d
    n = 0
    DO i=1,SIZE(x)
      IF (x(i) .GE. 0._sp) n = n + 1
    END DO
    result1_d = SE_D(x, y, y_d, result1)
    res_d = result1_d/n
    res = result1/n
  END FUNCTION MSE_D

!  Differentiation of mse in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: res y
!   with respect to varying inputs: y
  SUBROUTINE MSE_B(x, y, y_b, res_b0)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp), DIMENSION(:) :: y_b
    REAL(sp) :: res
    REAL(sp) :: res_b0
    INTEGER :: i, n
    INTRINSIC SIZE
    REAL(sp) :: result1
    REAL(sp) :: result1_b
    REAL(sp) :: res0
    REAL(sp) :: res_b
    INTEGER :: ad_to
    INTEGER :: branch
    n = 0
    DO i=1,SIZE(x)
      IF (x(i) .LT. 0._sp) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHCONTROL1B(1)
        n = n + 1
      END IF
    END DO
    CALL PUSHINTEGER4(i - 1)
    res0 = SE(x, y)
    result1_b = res_b0/n
    res_b = result1_b
    CALL SE_B(x, y, y_b, res_b)
    CALL POPINTEGER4(ad_to)
    DO i=ad_to,1,-1
      CALL POPCONTROL1B(branch)
    END DO
  END SUBROUTINE MSE_B

  FUNCTION MSE(x, y) RESULT (RES)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp) :: res
    INTEGER :: i, n
    INTRINSIC SIZE
    REAL(sp) :: result1
    n = 0
    DO i=1,SIZE(x)
      IF (x(i) .GE. 0._sp) n = n + 1
    END DO
    result1 = SE(x, y)
    res = result1/n
  END FUNCTION MSE

!  Differentiation of rmse in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: res
!   with respect to varying inputs: y
  FUNCTION RMSE_D(x, y, y_d, res) RESULT (RES_D)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp), DIMENSION(:), INTENT(IN) :: y_d
    REAL(sp) :: res
    REAL(sp) :: res_d
    INTRINSIC SQRT
    REAL(sp) :: result1
    REAL(sp) :: result1_d
    REAL(sp) :: temp
    result1_d = MSE_D(x, y, y_d, result1)
    temp = SQRT(result1)
    IF (result1 .EQ. 0.0) THEN
      res_d = 0.0_4
    ELSE
      res_d = result1_d/(2.0*temp)
    END IF
    res = temp
  END FUNCTION RMSE_D

!  Differentiation of rmse in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: res y
!   with respect to varying inputs: y
  SUBROUTINE RMSE_B(x, y, y_b, res_b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp), DIMENSION(:) :: y_b
    REAL(sp) :: res
    REAL(sp) :: res_b
    INTRINSIC SQRT
    REAL(sp) :: result1
    REAL(sp) :: result1_b
    result1 = MSE(x, y)
    IF (result1 .EQ. 0.0) THEN
      result1_b = 0.0_4
    ELSE
      result1_b = res_b/(2.0*SQRT(result1))
    END IF
    CALL MSE_B(x, y, y_b, result1_b)
  END SUBROUTINE RMSE_B

  FUNCTION RMSE(x, y) RESULT (RES)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp) :: res
    INTRINSIC SQRT
    REAL(sp) :: result1
    result1 = MSE(x, y)
    res = SQRT(result1)
  END FUNCTION RMSE

!  Differentiation of lgrm in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: res
!   with respect to varying inputs: y
  FUNCTION LGRM_D(x, y, y_d, res) RESULT (RES_D)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp), DIMENSION(:), INTENT(IN) :: y_d
    REAL(sp) :: res
    REAL(sp) :: res_d
    INTEGER :: i
    INTRINSIC SIZE
    INTRINSIC LOG
    REAL(sp) :: arg1
    REAL(sp) :: arg1_d
    REAL(sp) :: arg2
    REAL(sp) :: arg2_d
    REAL(sp) :: temp
    REAL(sp) :: temp0
    res = 0._sp
    res_d = 0.0_4
    DO i=1,SIZE(x)
      IF (.NOT.(x(i) .LE. 0._sp .OR. y(i) .LE. 0._sp)) THEN
        arg1_d = y_d(i)/x(i)
        arg1 = y(i)/x(i)
        arg2_d = y_d(i)/x(i)
        arg2 = y(i)/x(i)
        temp = LOG(arg2)
        temp0 = LOG(arg1)
        res_d = res_d + x(i)*(temp*arg1_d/arg1+temp0*arg2_d/arg2)
        res = res + x(i)*(temp0*temp)
      END IF
    END DO
  END FUNCTION LGRM_D

!  Differentiation of lgrm in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: res y
!   with respect to varying inputs: y
  SUBROUTINE LGRM_B(x, y, y_b, res_b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp), DIMENSION(:) :: y_b
    REAL(sp) :: res
    REAL(sp) :: res_b
    INTEGER :: i
    INTRINSIC SIZE
    INTRINSIC LOG
    REAL(sp) :: arg1
    REAL(sp) :: arg1_b
    REAL(sp) :: arg2
    REAL(sp) :: arg2_b
    INTEGER :: ad_to
    INTEGER :: branch
    DO i=1,SIZE(x)
      IF (x(i) .LE. 0._sp .OR. y(i) .LE. 0._sp) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHREAL4(arg1)
        arg1 = y(i)/x(i)
        CALL PUSHREAL4(arg2)
        arg2 = y(i)/x(i)
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    ad_to = i - 1
    DO i=ad_to,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        arg1_b = LOG(arg2)*x(i)*res_b/arg1
        arg2_b = LOG(arg1)*x(i)*res_b/arg2
        CALL POPREAL4(arg2)
        y_b(i) = y_b(i) + arg2_b/x(i) + arg1_b/x(i)
        CALL POPREAL4(arg1)
      END IF
    END DO
  END SUBROUTINE LGRM_B

  FUNCTION LGRM(x, y) RESULT (RES)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: x, y
    REAL(sp) :: res
    INTEGER :: i
    INTRINSIC SIZE
    INTRINSIC LOG
    REAL(sp) :: arg1
    REAL(sp) :: arg2
    res = 0._sp
    DO i=1,SIZE(x)
      IF (.NOT.(x(i) .LE. 0._sp .OR. y(i) .LE. 0._sp)) THEN
        arg1 = y(i)/x(i)
        arg2 = y(i)/x(i)
        res = res + x(i)*LOG(arg1)*LOG(arg2)
      END IF
    END DO
  END FUNCTION LGRM

END MODULE MWD_METRICS_DIFF

!%      (MD) Module Differentiated.
!%
!%      Interface
!%      ---------
!%
!%      - quantile1d_r
!%          . quantile1d_r_scl
!%          . quantile1d_r_1d
!%
!%      Subroutine
!%      ----------
!%
!%      - heap_sort
!%
!%      Function
!%      --------
!%
!%      - quantile1d_r_scl
!%      - quantile1d_r_1d
MODULE MD_STATS_DIFF
!% only: sp
  USE MD_CONSTANT
  IMPLICIT NONE
  INTERFACE QUANTILE1D_R
      MODULE PROCEDURE QUANTILE1D_R_SCL
      MODULE PROCEDURE QUANTILE1D_R_1D
  END INTERFACE QUANTILE1D_R

  INTERFACE QUANTILE1D_R_D
      MODULE PROCEDURE QUANTILE1D_R_SCL_D
  END INTERFACE

  INTERFACE QUANTILE1D_R_B
      MODULE PROCEDURE QUANTILE1D_R_SCL_B
  END INTERFACE


CONTAINS
!  Differentiation of heap_sort in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: arr
!   with respect to varying inputs: arr
  SUBROUTINE HEAP_SORT_D(n, arr, arr_d)
    IMPLICIT NONE
    INTEGER, INTENT(IN) :: n
    REAL(sp), DIMENSION(n), INTENT(INOUT) :: arr
    REAL(sp), DIMENSION(n), INTENT(INOUT) :: arr_d
    INTEGER :: l, ir, i, j
    REAL(sp) :: arr_l
    REAL(sp) :: arr_l_d
    l = n/2 + 1
    ir = n
 10 IF (l .GT. 1) THEN
      l = l - 1
      arr_l_d = arr_d(l)
      arr_l = arr(l)
    ELSE
      arr_l_d = arr_d(ir)
      arr_l = arr(ir)
      arr_d(ir) = arr_d(1)
      arr(ir) = arr(1)
      ir = ir - 1
      IF (ir .EQ. 1) GOTO 100
    END IF
    i = l
    j = l + l
 20 IF (j .LE. ir) THEN
      IF (j .LT. ir) THEN
        IF (arr(j) .LT. arr(j+1)) j = j + 1
      END IF
      IF (arr_l .LT. arr(j)) THEN
        arr_d(i) = arr_d(j)
        arr(i) = arr(j)
        i = j
        j = j + j
      ELSE
        j = ir + 1
      END IF
      GOTO 20
    END IF
    arr_d(i) = arr_l_d
    arr(i) = arr_l
    GOTO 10
 100 arr_d(1) = arr_l_d
    arr(1) = arr_l
  END SUBROUTINE HEAP_SORT_D

!  Differentiation of heap_sort in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: arr
!   with respect to varying inputs: arr
  SUBROUTINE HEAP_SORT_B(n, arr, arr_b)
    IMPLICIT NONE
    INTEGER, INTENT(IN) :: n
    REAL(sp), DIMENSION(n), INTENT(INOUT) :: arr
    REAL(sp), DIMENSION(n), INTENT(INOUT) :: arr_b
    INTEGER :: l, ir, i, j
    REAL(sp) :: arr_l
    REAL(sp) :: arr_l_b
    REAL(sp) :: tmp
    REAL(sp) :: tmp_b
    REAL(sp) :: tmp0
    REAL(sp) :: tmp_b0
    INTEGER :: branch
    INTEGER :: ad_count
    INTEGER :: i0
    INTEGER :: ad_count0
    INTEGER :: i1
    l = n/2 + 1
    ir = n
    ad_count0 = 1
 10 IF (l .GT. 1) THEN
      CALL PUSHINTEGER4(l)
      l = l - 1
      arr_l = arr(l)
      CALL PUSHCONTROL1B(0)
    ELSE
      arr_l = arr(ir)
      tmp = arr(1)
      arr(ir) = tmp
      CALL PUSHINTEGER4(ir)
      ir = ir - 1
      IF (ir .EQ. 1) THEN
        GOTO 100
      ELSE
        CALL PUSHCONTROL1B(1)
      END IF
    END IF
    CALL PUSHINTEGER4(i)
    i = l
    j = l + l
    ad_count = 1
 20 IF (j .LE. ir) THEN
      IF (j .LT. ir) THEN
        IF (arr(j) .LT. arr(j+1)) THEN
          CALL PUSHCONTROL1B(0)
          j = j + 1
        ELSE
          CALL PUSHCONTROL1B(0)
        END IF
      ELSE
        CALL PUSHCONTROL1B(1)
      END IF
      IF (arr_l .LT. arr(j)) THEN
        tmp0 = arr(j)
        arr(i) = tmp0
        CALL PUSHINTEGER4(i)
        i = j
        CALL PUSHINTEGER4(j)
        j = j + j
        CALL PUSHCONTROL1B(1)
      ELSE
        CALL PUSHCONTROL1B(0)
        j = ir + 1
      END IF
      ad_count = ad_count + 1
      GOTO 20
    END IF
    CALL PUSHINTEGER4(ad_count)
    arr(i) = arr_l
    ad_count0 = ad_count0 + 1
    GOTO 10
 100 CALL PUSHINTEGER4(ad_count0)
    arr_l_b = arr_b(1)
    arr_b(1) = 0.0_4
    CALL POPINTEGER4(ad_count0)
    DO 110 i1=1,ad_count0
      IF (i1 .NE. 1) THEN
        arr_l_b = arr_b(i)
        arr_b(i) = 0.0_4
        CALL POPINTEGER4(ad_count)
        DO i0=1,ad_count
          IF (i0 .NE. 1) THEN
            CALL POPCONTROL1B(branch)
            IF (branch .NE. 0) THEN
              CALL POPINTEGER4(j)
              CALL POPINTEGER4(i)
              tmp_b0 = arr_b(i)
              arr_b(i) = 0.0_4
              arr_b(j) = arr_b(j) + tmp_b0
            END IF
            CALL POPCONTROL1B(branch)
          END IF
        END DO
        CALL POPINTEGER4(i)
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          arr_b(l) = arr_b(l) + arr_l_b
          CALL POPINTEGER4(l)
          GOTO 110
        END IF
      END IF
      CALL POPINTEGER4(ir)
      tmp_b = arr_b(ir)
      arr_b(ir) = 0.0_4
      arr_b(1) = arr_b(1) + tmp_b
      arr_b(ir) = arr_b(ir) + arr_l_b
 110 CONTINUE
  END SUBROUTINE HEAP_SORT_B

  SUBROUTINE HEAP_SORT(n, arr)
    IMPLICIT NONE
    INTEGER, INTENT(IN) :: n
    REAL(sp), DIMENSION(n), INTENT(INOUT) :: arr
    INTEGER :: l, ir, i, j
    REAL(sp) :: arr_l
    l = n/2 + 1
    ir = n
 10 IF (l .GT. 1) THEN
      l = l - 1
      arr_l = arr(l)
    ELSE
      arr_l = arr(ir)
      arr(ir) = arr(1)
      ir = ir - 1
      IF (ir .EQ. 1) THEN
        arr(1) = arr_l
        RETURN
      END IF
    END IF
    i = l
    j = l + l
 20 IF (j .LE. ir) THEN
      IF (j .LT. ir) THEN
        IF (arr(j) .LT. arr(j+1)) j = j + 1
      END IF
      IF (arr_l .LT. arr(j)) THEN
        arr(i) = arr(j)
        i = j
        j = j + j
      ELSE
        j = ir + 1
      END IF
      GOTO 20
    ELSE
      arr(i) = arr_l
      GOTO 10
    END IF
  END SUBROUTINE HEAP_SORT

!  Differentiation of quantile1d_r_scl in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: res
!   with respect to varying inputs: dat
  FUNCTION QUANTILE1D_R_SCL_D(dat, dat_d, p, res) RESULT (RES_D)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: dat
    REAL(sp), DIMENSION(:), INTENT(IN) :: dat_d
    REAL(sp), INTENT(IN) :: p
    REAL(sp) :: res
    REAL(sp) :: res_d
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(dat)) :: sorted_dat
    REAL(sp), DIMENSION(SIZE(dat)) :: sorted_dat_d
    INTEGER :: n
    REAL(sp) :: q1, q2, frac
    REAL(sp) :: q1_d, q2_d
    INTRINSIC INT
    REAL(sp) :: temp
    res_d = dat_d(1)
    res = dat(1)
    n = SIZE(dat)
    IF (n .GT. 1) THEN
      sorted_dat_d = dat_d
      sorted_dat = dat
      CALL HEAP_SORT_D(n, sorted_dat, sorted_dat_d)
      frac = (n-1)*p + 1
      IF (frac .LE. 1) THEN
        res_d = sorted_dat_d(1)
        res = sorted_dat(1)
      ELSE IF (frac .GE. n) THEN
        res_d = sorted_dat_d(n)
        res = sorted_dat(n)
      ELSE
        q1_d = sorted_dat_d(INT(frac))
        q1 = sorted_dat(INT(frac))
        q2_d = sorted_dat_d(INT(frac)+1)
        q2 = sorted_dat(INT(frac)+1)
! linear interpolation
        temp = frac - INT(frac)
        res_d = q1_d + temp*(q2_d-q1_d)
        res = q1 + temp*(q2-q1)
      END IF
    END IF
  END FUNCTION QUANTILE1D_R_SCL_D

!  Differentiation of quantile1d_r_scl in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: res
!   with respect to varying inputs: dat
  SUBROUTINE QUANTILE1D_R_SCL_B(dat, dat_b, p, res_b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: dat
    REAL(sp), DIMENSION(:) :: dat_b
    REAL(sp), INTENT(IN) :: p
    REAL(sp) :: res
    REAL(sp) :: res_b
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(dat)) :: sorted_dat
    REAL(sp), DIMENSION(SIZE(dat)) :: sorted_dat_b
    INTEGER :: n
    REAL(sp) :: q1, q2, frac
    REAL(sp) :: q1_b, q2_b
    INTRINSIC INT
    REAL(sp) :: temp_b
    n = SIZE(dat)
    IF (n .GT. 1) THEN
      sorted_dat = dat
      CALL PUSHREAL4ARRAY(sorted_dat, SIZE(dat))
      CALL HEAP_SORT(n, sorted_dat)
      frac = (n-1)*p + 1
      IF (frac .LE. 1) THEN
        sorted_dat_b = 0.0_4
        sorted_dat_b(1) = sorted_dat_b(1) + res_b
      ELSE IF (frac .GE. n) THEN
        sorted_dat_b = 0.0_4
        sorted_dat_b(n) = sorted_dat_b(n) + res_b
      ELSE
        temp_b = (frac-INT(frac))*res_b
        q1_b = res_b - temp_b
        q2_b = temp_b
        sorted_dat_b = 0.0_4
        sorted_dat_b(INT(frac)+1) = sorted_dat_b(INT(frac)+1) + q2_b
        sorted_dat_b(INT(frac)) = sorted_dat_b(INT(frac)) + q1_b
      END IF
      CALL POPREAL4ARRAY(sorted_dat, SIZE(dat))
      CALL HEAP_SORT_B(n, sorted_dat, sorted_dat_b)
      dat_b = 0.0_4
      dat_b = sorted_dat_b
      res_b = 0.0_4
    ELSE
      dat_b = 0.0_4
    END IF
    dat_b(1) = dat_b(1) + res_b
  END SUBROUTINE QUANTILE1D_R_SCL_B

  FUNCTION QUANTILE1D_R_SCL(dat, p) RESULT (RES)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: dat
    REAL(sp), INTENT(IN) :: p
    REAL(sp) :: res
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(dat)) :: sorted_dat
    INTEGER :: n
    REAL(sp) :: q1, q2, frac
    INTRINSIC INT
    res = dat(1)
    n = SIZE(dat)
    IF (n .GT. 1) THEN
      sorted_dat = dat
      CALL HEAP_SORT(n, sorted_dat)
      frac = (n-1)*p + 1
      IF (frac .LE. 1) THEN
        res = sorted_dat(1)
      ELSE IF (frac .GE. n) THEN
        res = sorted_dat(n)
      ELSE
        q1 = sorted_dat(INT(frac))
        q2 = sorted_dat(INT(frac)+1)
! linear interpolation
        res = q1 + (q2-q1)*(frac-INT(frac))
      END IF
    END IF
  END FUNCTION QUANTILE1D_R_SCL

  FUNCTION QUANTILE1D_R_1D(dat, p) RESULT (RES)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: dat
    REAL(sp), DIMENSION(:), INTENT(IN) :: p
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(p)) :: res
    REAL(sp), DIMENSION(SIZE(dat)) :: sorted_dat
    INTEGER :: n, i
    REAL(sp) :: q1, q2, frac
    INTRINSIC INT
    res = dat(1)
    n = SIZE(dat)
    IF (n .GT. 1) THEN
      sorted_dat = dat
      CALL HEAP_SORT(n, sorted_dat)
      DO i=1,SIZE(p)
        frac = (n-1)*p(i) + 1
        IF (frac .LE. 1) THEN
          res(i) = sorted_dat(1)
        ELSE IF (frac .GE. n) THEN
          res(i) = sorted_dat(n)
        ELSE
          q1 = sorted_dat(INT(frac))
          q2 = sorted_dat(INT(frac)+1)
! linear interpolation
          res(i) = q1 + (q2-q1)*(frac-INT(frac))
        END IF
      END DO
    END IF
  END FUNCTION QUANTILE1D_R_1D

END MODULE MD_STATS_DIFF

!%      (MWD) Module Wrapped and Differentiated.
!%
!%      Subroutine
!%      ----------
!%
!%      - baseflow_separation
!%
!%      Function
!%      --------
!%
!%      - rc
!%      - rchf
!%      - rclf
!%      - rch2r
!%      - cfp
!%      - eff
!%      - ebf
!%      - epf
!%      - elt
MODULE MWD_SIGNATURES_DIFF
!% only: sp
  USE MD_CONSTANT
!% only: quantile1d_r
  USE MD_STATS_DIFF
  IMPLICIT NONE

CONTAINS
!  Differentiation of baseflow_separation in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: bt qft
!   with respect to varying inputs: streamflow
  SUBROUTINE BASEFLOW_SEPARATION_D(streamflow, streamflow_d, bt, bt_d, &
&   qft, qft_d, filter_parameter, passes)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: streamflow
    REAL(sp), DIMENSION(:), INTENT(IN) :: streamflow_d
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(streamflow)), INTENT(INOUT) :: bt, qft
    REAL(sp), DIMENSION(SIZE(streamflow)), INTENT(INOUT) :: bt_d, qft_d
    REAL(sp), INTENT(IN) :: filter_parameter
    INTEGER, INTENT(IN) :: passes
    REAL(sp), DIMENSION(SIZE(streamflow)) :: btp
    REAL(sp), DIMENSION(SIZE(streamflow)) :: btp_d
    INTEGER, DIMENSION(passes+1) :: ends
    INTEGER, DIMENSION(passes) :: addtostart
    INTEGER :: i, j
    LOGICAL :: odd
    INTRINSIC SUM
    REAL(sp) :: result1
    REAL(sp) :: result1_d
    REAL(sp) :: temp
    INTEGER :: temp0
    odd = .true.
! Start and end values for the filter function
    DO j=1,passes
      IF (odd) THEN
        ends(j) = 1
        addtostart(j) = 1
      ELSE
        ends(j) = SIZE(streamflow)
        addtostart(j) = -1
      END IF
      odd = .NOT.odd
    END DO
    ends(passes+1) = ends(passes-1)
    btp_d = streamflow_d
    btp = streamflow
    bt = 0._sp
    qft = 0._sp
! Guess baseflow value in the first time step
    result1 = QUANTILE1D_R(streamflow, 0.25_sp)
    IF (streamflow(1) .LT. result1) THEN
      bt_d = 0.0_4
      bt_d(1) = streamflow_d(1)
      bt(1) = streamflow(1)
      qft_d = 0.0_4
    ELSE
      bt_d = 0.0_4
      temp = 1.5_sp*SIZE(streamflow)
      bt_d(1) = SUM(streamflow_d)/temp
      bt(1) = SUM(streamflow)/temp
      qft_d = 0.0_4
    END IF
! Perform baseflow separation
    DO j=1,passes
      DO i=ends(j)+addtostart(j),ends(j+1),addtostart(j)
        IF (filter_parameter*bt(i-addtostart(j)) + (1._sp-&
&           filter_parameter)/2._sp*(btp(i)+btp(i-addtostart(j))) .GT. &
&           btp(i)) THEN
          bt_d(i) = btp_d(i)
          bt(i) = btp(i)
        ELSE
          bt_d(i) = filter_parameter*bt_d(i-addtostart(j)) + (1._sp-&
&           filter_parameter)*(btp_d(i)+btp_d(i-addtostart(j)))/2._sp
          bt(i) = filter_parameter*bt(i-addtostart(j)) + (1._sp-&
&           filter_parameter)/2._sp*(btp(i)+btp(i-addtostart(j)))
        END IF
        qft_d(i) = streamflow_d(i) - bt_d(i)
        qft(i) = streamflow(i) - bt(i)
      END DO
      IF (j .LT. passes) THEN
        btp_d = bt_d
        btp = bt
        IF (streamflow(ends(j+1)) .LT. SUM(btp)/SIZE(btp)) THEN
          bt_d(ends(j+1)) = streamflow_d(ends(j+1))/1.2_sp
          bt(ends(j+1)) = streamflow(ends(j+1))/1.2_sp
        ELSE
          temp0 = SIZE(btp)
          bt_d(ends(j+1)) = SUM(btp_d)/temp0
          bt(ends(j+1)) = SUM(btp)/temp0
        END IF
      END IF
    END DO
  END SUBROUTINE BASEFLOW_SEPARATION_D

!  Differentiation of baseflow_separation in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: streamflow bt qft
!   with respect to varying inputs: streamflow
  SUBROUTINE BASEFLOW_SEPARATION_B(streamflow, streamflow_b, bt, bt_b, &
&   qft, qft_b, filter_parameter, passes)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: streamflow
    REAL(sp), DIMENSION(:) :: streamflow_b
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(streamflow)), INTENT(INOUT) :: bt, qft
    REAL(sp), DIMENSION(SIZE(streamflow)), INTENT(INOUT) :: bt_b, qft_b
    REAL(sp), INTENT(IN) :: filter_parameter
    INTEGER, INTENT(IN) :: passes
    REAL(sp), DIMENSION(SIZE(streamflow)) :: btp
    REAL(sp), DIMENSION(SIZE(streamflow)) :: btp_b
    INTEGER, DIMENSION(passes+1) :: ends
    INTEGER, DIMENSION(passes) :: addtostart
    INTEGER :: i, j
    LOGICAL :: odd
    INTRINSIC SUM
    REAL(sp) :: result1
    REAL(sp) :: result1_b
    REAL(sp) :: tmp
    REAL(sp) :: tmp_b
    REAL(sp) :: temp_b
    INTEGER :: branch
    INTEGER :: ad_from
    INTEGER :: ad_stride
    INTEGER :: ad_to
    odd = .true.
! Start and end values for the filter function
    DO j=1,passes
      IF (odd) THEN
        ends(j) = 1
        addtostart(j) = 1
      ELSE
        ends(j) = SIZE(streamflow)
        addtostart(j) = -1
      END IF
      odd = .NOT.odd
    END DO
    ends(passes+1) = ends(passes-1)
    btp = streamflow
    bt = 0._sp
! Guess baseflow value in the first time step
    result1 = QUANTILE1D_R(streamflow, 0.25_sp)
    IF (streamflow(1) .LT. result1) THEN
      bt(1) = streamflow(1)
      CALL PUSHCONTROL1B(1)
    ELSE
      bt(1) = SUM(streamflow)/SIZE(streamflow)/1.5_sp
      CALL PUSHCONTROL1B(0)
    END IF
! Perform baseflow separation
    DO j=1,passes
      ad_from = ends(j) + addtostart(j)
      ad_stride = addtostart(j)
      DO i=ad_from,ends(j+1),ad_stride
        IF (filter_parameter*bt(i-addtostart(j)) + (1._sp-&
&           filter_parameter)/2._sp*(btp(i)+btp(i-addtostart(j))) .GT. &
&           btp(i)) THEN
          bt(i) = btp(i)
          CALL PUSHCONTROL1B(0)
        ELSE
          tmp = filter_parameter*bt(i-addtostart(j)) + (1._sp-&
&           filter_parameter)/2._sp*(btp(i)+btp(i-addtostart(j)))
          bt(i) = tmp
          CALL PUSHCONTROL1B(1)
        END IF
      END DO
      CALL PUSHINTEGER4(i - ad_stride)
      CALL PUSHINTEGER4(ad_from)
      CALL PUSHINTEGER4(ad_stride)
      IF (j .LT. passes) THEN
        CALL PUSHREAL4ARRAY(btp, SIZE(streamflow))
        btp = bt
        IF (streamflow(ends(j+1)) .LT. SUM(btp)/SIZE(btp)) THEN
          bt(ends(j+1)) = streamflow(ends(j+1))/1.2_sp
          CALL PUSHCONTROL2B(2)
        ELSE
          bt(ends(j+1)) = SUM(btp)/SIZE(btp)
          CALL PUSHCONTROL2B(1)
        END IF
      ELSE
        CALL PUSHCONTROL2B(0)
      END IF
    END DO
    btp_b = 0.0_4
    DO j=passes,1,-1
      CALL POPCONTROL2B(branch)
      IF (branch .NE. 0) THEN
        IF (branch .EQ. 1) THEN
          btp_b = btp_b + bt_b(ends(j+1))/SIZE(btp)
          bt_b(ends(j+1)) = 0.0_4
        ELSE
          streamflow_b(ends(j+1)) = streamflow_b(ends(j+1)) + bt_b(ends(&
&           j+1))/1.2_sp
          bt_b(ends(j+1)) = 0.0_4
        END IF
        CALL POPREAL4ARRAY(btp, SIZE(streamflow))
        bt_b = bt_b + btp_b
        btp_b = 0.0_4
      END IF
      CALL POPINTEGER4(ad_stride)
      CALL POPINTEGER4(ad_from)
      CALL POPINTEGER4(ad_to)
      DO i=ad_to,ad_from,-ad_stride
        streamflow_b(i) = streamflow_b(i) + qft_b(i)
        bt_b(i) = bt_b(i) - qft_b(i)
        qft_b(i) = 0.0_4
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          btp_b(i) = btp_b(i) + bt_b(i)
          bt_b(i) = 0.0_4
        ELSE
          tmp_b = bt_b(i)
          bt_b(i) = 0.0_4
          bt_b(i-addtostart(j)) = bt_b(i-addtostart(j)) + &
&           filter_parameter*tmp_b
          temp_b = (1._sp-filter_parameter)*tmp_b/2._sp
          btp_b(i) = btp_b(i) + temp_b
          btp_b(i-addtostart(j)) = btp_b(i-addtostart(j)) + temp_b
        END IF
      END DO
    END DO
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      streamflow_b = streamflow_b + bt_b(1)/(SIZE(streamflow)*1.5_sp)
    ELSE
      streamflow_b(1) = streamflow_b(1) + bt_b(1)
    END IF
    streamflow_b = streamflow_b + btp_b
    j = 0
  END SUBROUTINE BASEFLOW_SEPARATION_B

  SUBROUTINE BASEFLOW_SEPARATION(streamflow, bt, qft, filter_parameter, &
&   passes)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: streamflow
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(streamflow)), INTENT(INOUT) :: bt, qft
    REAL(sp), INTENT(IN) :: filter_parameter
    INTEGER, INTENT(IN) :: passes
    REAL(sp), DIMENSION(SIZE(streamflow)) :: btp
    INTEGER, DIMENSION(passes+1) :: ends
    INTEGER, DIMENSION(passes) :: addtostart
    INTEGER :: i, j
    LOGICAL :: odd
    INTRINSIC SUM
    REAL(sp) :: result1
    odd = .true.
! Start and end values for the filter function
    DO j=1,passes
      IF (odd) THEN
        ends(j) = 1
        addtostart(j) = 1
      ELSE
        ends(j) = SIZE(streamflow)
        addtostart(j) = -1
      END IF
      odd = .NOT.odd
    END DO
    ends(passes+1) = ends(passes-1)
    btp = streamflow
    bt = 0._sp
    qft = 0._sp
! Guess baseflow value in the first time step
    result1 = QUANTILE1D_R(streamflow, 0.25_sp)
    IF (streamflow(1) .LT. result1) THEN
      bt(1) = streamflow(1)
    ELSE
      bt(1) = SUM(streamflow)/SIZE(streamflow)/1.5_sp
    END IF
! Perform baseflow separation
    DO j=1,passes
      DO i=ends(j)+addtostart(j),ends(j+1),addtostart(j)
        IF (filter_parameter*bt(i-addtostart(j)) + (1._sp-&
&           filter_parameter)/2._sp*(btp(i)+btp(i-addtostart(j))) .GT. &
&           btp(i)) THEN
          bt(i) = btp(i)
        ELSE
          bt(i) = filter_parameter*bt(i-addtostart(j)) + (1._sp-&
&           filter_parameter)/2._sp*(btp(i)+btp(i-addtostart(j)))
        END IF
        qft(i) = streamflow(i) - bt(i)
      END DO
      IF (j .LT. passes) THEN
        btp = bt
        IF (streamflow(ends(j+1)) .LT. SUM(btp)/SIZE(btp)) THEN
          bt(ends(j+1)) = streamflow(ends(j+1))/1.2_sp
        ELSE
          bt(ends(j+1)) = SUM(btp)/SIZE(btp)
        END IF
      END IF
    END DO
  END SUBROUTINE BASEFLOW_SEPARATION

!  Differentiation of rc in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: res
!   with respect to varying inputs: q
  FUNCTION RC_D(p, q, q_d, res) RESULT (RES_D)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: p, q
    REAL(sp), DIMENSION(:), INTENT(IN) :: q_d
    REAL(sp) :: res
    REAL(sp) :: res_d
    INTEGER :: n, i
    REAL(sp) :: numer, denom
    REAL(sp) :: numer_d
    INTRINSIC SIZE
    n = SIZE(p)
    res = -99._sp
    numer = 0._sp
    denom = 0._sp
    numer_d = 0.0_4
    DO i=1,n
      IF (.NOT.(p(i) .LT. 0._sp .OR. q(i) .LT. 0._sp)) THEN
        numer_d = numer_d + q_d(i)
        numer = numer + q(i)
        denom = denom + p(i)
      END IF
    END DO
    IF (denom .GT. 0._sp) THEN
      res_d = numer_d/denom
      res = numer/denom
    ELSE
      res_d = 0.0_4
    END IF
  END FUNCTION RC_D

!  Differentiation of rc in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: res q
!   with respect to varying inputs: q
  SUBROUTINE RC_B(p, q, q_b, res_b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: p, q
    REAL(sp), DIMENSION(:) :: q_b
    REAL(sp) :: res
    REAL(sp) :: res_b
    INTEGER :: n, i
    REAL(sp) :: numer, denom
    REAL(sp) :: numer_b
    INTRINSIC SIZE
    INTEGER :: branch
    n = SIZE(p)
    denom = 0._sp
    DO i=1,n
      IF (p(i) .LT. 0._sp .OR. q(i) .LT. 0._sp) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        denom = denom + p(i)
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    IF (denom .GT. 0._sp) THEN
      numer_b = res_b/denom
    ELSE
      numer_b = 0.0_4
    END IF
    DO i=n,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) q_b(i) = q_b(i) + numer_b
    END DO
  END SUBROUTINE RC_B

  FUNCTION RC(p, q) RESULT (RES)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: p, q
    REAL(sp) :: res
    INTEGER :: n, i
    REAL(sp) :: numer, denom
    INTRINSIC SIZE
    n = SIZE(p)
    res = -99._sp
    numer = 0._sp
    denom = 0._sp
    DO i=1,n
      IF (.NOT.(p(i) .LT. 0._sp .OR. q(i) .LT. 0._sp)) THEN
        numer = numer + q(i)
        denom = denom + p(i)
      END IF
    END DO
    IF (denom .GT. 0._sp) res = numer/denom
  END FUNCTION RC

!  Differentiation of rchf in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: res
!   with respect to varying inputs: q
  FUNCTION RCHF_D(p, q, q_d, res) RESULT (RES_D)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: p, q
    REAL(sp), DIMENSION(:), INTENT(IN) :: q_d
    REAL(sp) :: res
    REAL(sp) :: res_d
    INTEGER :: n, i, j
    REAL(sp) :: numer, denom
    REAL(sp) :: numer_d
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(p)) :: nonnegative_p, nonnegative_q, bf, qf
    REAL(sp), DIMENSION(SIZE(p)) :: nonnegative_q_d, bf_d, qf_d
    n = SIZE(p)
    res = -99._sp
    nonnegative_p = 0._sp
    nonnegative_q = 0._sp
    j = 0
    nonnegative_q_d = 0.0_4
    DO i=1,n
      IF (.NOT.(p(i) .LT. 0._sp .OR. q(i) .LT. 0._sp)) THEN
        j = j + 1
        nonnegative_p(j) = p(i)
        nonnegative_q_d(j) = q_d(i)
        nonnegative_q(j) = q(i)
      END IF
    END DO
    IF (j .GT. 1) THEN
      CALL BASEFLOW_SEPARATION_D(nonnegative_q(1:j), nonnegative_q_d(1:j&
&                          ), bf(1:j), bf_d(1:j), qf(1:j), qf_d(1:j), &
&                          0.925_sp, 3)
      numer = 0._sp
      denom = 0._sp
      numer_d = 0.0_4
      DO i=1,j
        numer_d = numer_d + qf_d(i)
        numer = numer + qf(i)
        denom = denom + nonnegative_p(i)
      END DO
      IF (denom .GT. 0._sp) THEN
        res_d = numer_d/denom
        res = numer/denom
      ELSE
        res_d = 0.0_4
      END IF
    ELSE
      res_d = 0.0_4
    END IF
  END FUNCTION RCHF_D

!  Differentiation of rchf in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: res q
!   with respect to varying inputs: q
  SUBROUTINE RCHF_B(p, q, q_b, res_b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: p, q
    REAL(sp), DIMENSION(:) :: q_b
    REAL(sp) :: res
    REAL(sp) :: res_b
    INTEGER :: n, i, j
    REAL(sp) :: numer, denom
    REAL(sp) :: numer_b
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(p)) :: nonnegative_p, nonnegative_q, bf, qf
    REAL(sp), DIMENSION(SIZE(p)) :: nonnegative_q_b, bf_b, qf_b
    INTEGER :: branch
    n = SIZE(p)
    nonnegative_p = 0._sp
    nonnegative_q = 0._sp
    j = 0
    DO i=1,n
      IF (p(i) .LT. 0._sp .OR. q(i) .LT. 0._sp) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHINTEGER4(j)
        j = j + 1
        nonnegative_p(j) = p(i)
        nonnegative_q(j) = q(i)
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    IF (j .GT. 1) THEN
      CALL BASEFLOW_SEPARATION(nonnegative_q(1:j), bf(1:j), qf(1:j), &
&                        0.925_sp, 3)
      denom = 0._sp
      DO i=1,j
        denom = denom + nonnegative_p(i)
      END DO
      IF (denom .GT. 0._sp) THEN
        numer_b = res_b/denom
      ELSE
        numer_b = 0.0_4
      END IF
      qf_b = 0.0_4
      DO i=j,1,-1
        qf_b(i) = qf_b(i) + numer_b
      END DO
      nonnegative_q_b = 0.0_4
      bf_b = 0.0_4
      CALL BASEFLOW_SEPARATION_B(nonnegative_q(1:j), nonnegative_q_b(1:j&
&                          ), bf(1:j), bf_b(1:j), qf(1:j), qf_b(1:j), &
&                          0.925_sp, 3)
      bf_b(1:j) = 0.0_4
      qf_b(1:j) = 0.0_4
    ELSE
      nonnegative_q_b = 0.0_4
    END IF
    DO i=n,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        q_b(i) = q_b(i) + nonnegative_q_b(j)
        nonnegative_q_b(j) = 0.0_4
        CALL POPINTEGER4(j)
      END IF
    END DO
  END SUBROUTINE RCHF_B

  FUNCTION RCHF(p, q) RESULT (RES)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: p, q
    REAL(sp) :: res
    INTEGER :: n, i, j
    REAL(sp) :: numer, denom
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(p)) :: nonnegative_p, nonnegative_q, bf, qf
    n = SIZE(p)
    res = -99._sp
    nonnegative_p = 0._sp
    nonnegative_q = 0._sp
    j = 0
    DO i=1,n
      IF (.NOT.(p(i) .LT. 0._sp .OR. q(i) .LT. 0._sp)) THEN
        j = j + 1
        nonnegative_p(j) = p(i)
        nonnegative_q(j) = q(i)
      END IF
    END DO
    IF (j .GT. 1) THEN
      CALL BASEFLOW_SEPARATION(nonnegative_q(1:j), bf(1:j), qf(1:j), &
&                        0.925_sp, 3)
      numer = 0._sp
      denom = 0._sp
      DO i=1,j
        numer = numer + qf(i)
        denom = denom + nonnegative_p(i)
      END DO
      IF (denom .GT. 0._sp) res = numer/denom
    END IF
  END FUNCTION RCHF

!  Differentiation of rclf in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: res
!   with respect to varying inputs: q
  FUNCTION RCLF_D(p, q, q_d, res) RESULT (RES_D)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: p, q
    REAL(sp), DIMENSION(:), INTENT(IN) :: q_d
    REAL(sp) :: res
    REAL(sp) :: res_d
    INTEGER :: n, i, j
    REAL(sp) :: numer, denom
    REAL(sp) :: numer_d
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(p)) :: nonnegative_p, nonnegative_q, bf, qf
    REAL(sp), DIMENSION(SIZE(p)) :: nonnegative_q_d, bf_d, qf_d
    n = SIZE(p)
    res = -99._sp
    nonnegative_p = 0._sp
    nonnegative_q = 0._sp
    j = 0
    nonnegative_q_d = 0.0_4
    DO i=1,n
      IF (.NOT.(p(i) .LT. 0._sp .OR. q(i) .LT. 0._sp)) THEN
        j = j + 1
        nonnegative_p(j) = p(i)
        nonnegative_q_d(j) = q_d(i)
        nonnegative_q(j) = q(i)
      END IF
    END DO
    IF (j .GT. 1) THEN
      CALL BASEFLOW_SEPARATION_D(nonnegative_q(1:j), nonnegative_q_d(1:j&
&                          ), bf(1:j), bf_d(1:j), qf(1:j), qf_d(1:j), &
&                          0.925_sp, 3)
      numer = 0._sp
      denom = 0._sp
      numer_d = 0.0_4
      DO i=1,j
        numer_d = numer_d + bf_d(i)
        numer = numer + bf(i)
        denom = denom + nonnegative_p(i)
      END DO
      IF (denom .GT. 0._sp) THEN
        res_d = numer_d/denom
        res = numer/denom
      ELSE
        res_d = 0.0_4
      END IF
    ELSE
      res_d = 0.0_4
    END IF
  END FUNCTION RCLF_D

!  Differentiation of rclf in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: res q
!   with respect to varying inputs: q
  SUBROUTINE RCLF_B(p, q, q_b, res_b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: p, q
    REAL(sp), DIMENSION(:) :: q_b
    REAL(sp) :: res
    REAL(sp) :: res_b
    INTEGER :: n, i, j
    REAL(sp) :: numer, denom
    REAL(sp) :: numer_b
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(p)) :: nonnegative_p, nonnegative_q, bf, qf
    REAL(sp), DIMENSION(SIZE(p)) :: nonnegative_q_b, bf_b, qf_b
    INTEGER :: branch
    n = SIZE(p)
    nonnegative_p = 0._sp
    nonnegative_q = 0._sp
    j = 0
    DO i=1,n
      IF (p(i) .LT. 0._sp .OR. q(i) .LT. 0._sp) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHINTEGER4(j)
        j = j + 1
        nonnegative_p(j) = p(i)
        nonnegative_q(j) = q(i)
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    IF (j .GT. 1) THEN
      CALL BASEFLOW_SEPARATION(nonnegative_q(1:j), bf(1:j), qf(1:j), &
&                        0.925_sp, 3)
      denom = 0._sp
      DO i=1,j
        denom = denom + nonnegative_p(i)
      END DO
      IF (denom .GT. 0._sp) THEN
        numer_b = res_b/denom
      ELSE
        numer_b = 0.0_4
      END IF
      bf_b = 0.0_4
      DO i=j,1,-1
        bf_b(i) = bf_b(i) + numer_b
      END DO
      nonnegative_q_b = 0.0_4
      qf_b = 0.0_4
      CALL BASEFLOW_SEPARATION_B(nonnegative_q(1:j), nonnegative_q_b(1:j&
&                          ), bf(1:j), bf_b(1:j), qf(1:j), qf_b(1:j), &
&                          0.925_sp, 3)
      bf_b(1:j) = 0.0_4
      qf_b(1:j) = 0.0_4
    ELSE
      nonnegative_q_b = 0.0_4
    END IF
    DO i=n,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        q_b(i) = q_b(i) + nonnegative_q_b(j)
        nonnegative_q_b(j) = 0.0_4
        CALL POPINTEGER4(j)
      END IF
    END DO
  END SUBROUTINE RCLF_B

  FUNCTION RCLF(p, q) RESULT (RES)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: p, q
    REAL(sp) :: res
    INTEGER :: n, i, j
    REAL(sp) :: numer, denom
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(p)) :: nonnegative_p, nonnegative_q, bf, qf
    n = SIZE(p)
    res = -99._sp
    nonnegative_p = 0._sp
    nonnegative_q = 0._sp
    j = 0
    DO i=1,n
      IF (.NOT.(p(i) .LT. 0._sp .OR. q(i) .LT. 0._sp)) THEN
        j = j + 1
        nonnegative_p(j) = p(i)
        nonnegative_q(j) = q(i)
      END IF
    END DO
    IF (j .GT. 1) THEN
      CALL BASEFLOW_SEPARATION(nonnegative_q(1:j), bf(1:j), qf(1:j), &
&                        0.925_sp, 3)
      numer = 0._sp
      denom = 0._sp
      DO i=1,j
        numer = numer + bf(i)
        denom = denom + nonnegative_p(i)
      END DO
      IF (denom .GT. 0._sp) res = numer/denom
    END IF
  END FUNCTION RCLF

!  Differentiation of rch2r in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: res
!   with respect to varying inputs: q
  FUNCTION RCH2R_D(p, q, q_d, res) RESULT (RES_D)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: p, q
    REAL(sp), DIMENSION(:), INTENT(IN) :: q_d
    REAL(sp) :: res
    REAL(sp) :: res_d
    INTEGER :: n, i, j
    REAL(sp) :: numer, denom
    REAL(sp) :: numer_d, denom_d
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(p)) :: nonnegative_p, nonnegative_q, bf, qf
    REAL(sp), DIMENSION(SIZE(p)) :: nonnegative_q_d, bf_d, qf_d
    n = SIZE(p)
    res = -99._sp
    nonnegative_q = 0._sp
    j = 0
    nonnegative_q_d = 0.0_4
    DO i=1,n
      IF (.NOT.(p(i) .LT. 0._sp .OR. q(i) .LT. 0._sp)) THEN
        j = j + 1
        nonnegative_q_d(j) = q_d(i)
        nonnegative_q(j) = q(i)
      END IF
    END DO
    IF (j .GT. 1) THEN
      CALL BASEFLOW_SEPARATION_D(nonnegative_q(1:j), nonnegative_q_d(1:j&
&                          ), bf(1:j), bf_d(1:j), qf(1:j), qf_d(1:j), &
&                          0.925_sp, 3)
      numer = 0._sp
      denom = 0._sp
      denom_d = 0.0_4
      numer_d = 0.0_4
      DO i=1,j
        numer_d = numer_d + qf_d(i)
        numer = numer + qf(i)
        denom_d = denom_d + nonnegative_q_d(i)
        denom = denom + nonnegative_q(i)
      END DO
      IF (denom .GT. 0._sp) THEN
        res_d = (numer_d-numer*denom_d/denom)/denom
        res = numer/denom
      ELSE
        res_d = 0.0_4
      END IF
    ELSE
      res_d = 0.0_4
    END IF
  END FUNCTION RCH2R_D

!  Differentiation of rch2r in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: res q
!   with respect to varying inputs: q
  SUBROUTINE RCH2R_B(p, q, q_b, res_b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: p, q
    REAL(sp), DIMENSION(:) :: q_b
    REAL(sp) :: res
    REAL(sp) :: res_b
    INTEGER :: n, i, j
    REAL(sp) :: numer, denom
    REAL(sp) :: numer_b, denom_b
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(p)) :: nonnegative_p, nonnegative_q, bf, qf
    REAL(sp), DIMENSION(SIZE(p)) :: nonnegative_q_b, bf_b, qf_b
    INTEGER :: branch
    n = SIZE(p)
    nonnegative_q = 0._sp
    j = 0
    DO i=1,n
      IF (p(i) .LT. 0._sp .OR. q(i) .LT. 0._sp) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHINTEGER4(j)
        j = j + 1
        nonnegative_q(j) = q(i)
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    IF (j .GT. 1) THEN
      CALL BASEFLOW_SEPARATION(nonnegative_q(1:j), bf(1:j), qf(1:j), &
&                        0.925_sp, 3)
      numer = 0._sp
      denom = 0._sp
      DO i=1,j
        numer = numer + qf(i)
        denom = denom + nonnegative_q(i)
      END DO
      IF (denom .GT. 0._sp) THEN
        numer_b = res_b/denom
        denom_b = -(numer*res_b/denom**2)
      ELSE
        denom_b = 0.0_4
        numer_b = 0.0_4
      END IF
      qf_b = 0.0_4
      nonnegative_q_b = 0.0_4
      DO i=j,1,-1
        nonnegative_q_b(i) = nonnegative_q_b(i) + denom_b
        qf_b(i) = qf_b(i) + numer_b
      END DO
      bf_b = 0.0_4
      CALL BASEFLOW_SEPARATION_B(nonnegative_q(1:j), nonnegative_q_b(1:j&
&                          ), bf(1:j), bf_b(1:j), qf(1:j), qf_b(1:j), &
&                          0.925_sp, 3)
      bf_b(1:j) = 0.0_4
      qf_b(1:j) = 0.0_4
    ELSE
      nonnegative_q_b = 0.0_4
    END IF
    DO i=n,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        q_b(i) = q_b(i) + nonnegative_q_b(j)
        nonnegative_q_b(j) = 0.0_4
        CALL POPINTEGER4(j)
      END IF
    END DO
  END SUBROUTINE RCH2R_B

  FUNCTION RCH2R(p, q) RESULT (RES)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: p, q
    REAL(sp) :: res
    INTEGER :: n, i, j
    REAL(sp) :: numer, denom
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(p)) :: nonnegative_p, nonnegative_q, bf, qf
    n = SIZE(p)
    res = -99._sp
    nonnegative_p = 0._sp
    nonnegative_q = 0._sp
    j = 0
    DO i=1,n
      IF (.NOT.(p(i) .LT. 0._sp .OR. q(i) .LT. 0._sp)) THEN
        j = j + 1
        nonnegative_p(j) = p(i)
        nonnegative_q(j) = q(i)
      END IF
    END DO
    IF (j .GT. 1) THEN
      CALL BASEFLOW_SEPARATION(nonnegative_q(1:j), bf(1:j), qf(1:j), &
&                        0.925_sp, 3)
      numer = 0._sp
      denom = 0._sp
      DO i=1,j
        numer = numer + qf(i)
        denom = denom + nonnegative_q(i)
      END DO
      IF (denom .GT. 0._sp) res = numer/denom
    END IF
  END FUNCTION RCH2R

!  Differentiation of cfp in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: res
!   with respect to varying inputs: q
  FUNCTION CFP_D(q, q_d, quant, res) RESULT (RES_D)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: q
    REAL(sp), DIMENSION(:), INTENT(IN) :: q_d
    REAL(sp), INTENT(IN) :: quant
    REAL(sp) :: res
    REAL(sp) :: res_d
    INTEGER :: n, i, j
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(q)) :: nonnegative_q
    REAL(sp), DIMENSION(SIZE(q)) :: nonnegative_q_d
    n = SIZE(q)
    res = -99._sp
    j = 0
    nonnegative_q_d = 0.0_4
    DO i=1,n
      IF (q(i) .GE. 0._sp) THEN
        j = j + 1
        nonnegative_q_d(j) = q_d(i)
        nonnegative_q(j) = q(i)
      END IF
    END DO
    IF (j .GT. 1) THEN
      res_d = QUANTILE1D_R_D(nonnegative_q(1:j), nonnegative_q_d(1:j), &
&       quant, res)
    ELSE
      res_d = 0.0_4
    END IF
  END FUNCTION CFP_D

!  Differentiation of cfp in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: res q
!   with respect to varying inputs: q
  SUBROUTINE CFP_B(q, q_b, quant, res_b0)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: q
    REAL(sp), DIMENSION(:) :: q_b
    REAL(sp), INTENT(IN) :: quant
    REAL(sp) :: res
    REAL(sp) :: res_b0
    INTEGER :: n, i, j
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(q)) :: nonnegative_q
    REAL(sp), DIMENSION(SIZE(q)) :: nonnegative_q_b
    REAL(sp) :: res0
    REAL(sp) :: res_b
    INTEGER :: branch
    n = SIZE(q)
    j = 0
    DO i=1,n
      IF (q(i) .LT. 0._sp) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHINTEGER4(j)
        j = j + 1
        nonnegative_q(j) = q(i)
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    IF (j .GT. 1) THEN
      res0 = QUANTILE1D_R(nonnegative_q(1:j), quant)
      nonnegative_q_b = 0.0_4
      res_b = res_b0
      CALL QUANTILE1D_R_B(nonnegative_q(1:j), nonnegative_q_b(1:j), &
&                   quant, res_b)
    ELSE
      nonnegative_q_b = 0.0_4
    END IF
    DO i=n,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        q_b(i) = q_b(i) + nonnegative_q_b(j)
        nonnegative_q_b(j) = 0.0_4
        CALL POPINTEGER4(j)
      END IF
    END DO
  END SUBROUTINE CFP_B

  FUNCTION CFP(q, quant) RESULT (RES)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: q
    REAL(sp), INTENT(IN) :: quant
    REAL(sp) :: res
    INTEGER :: n, i, j
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(q)) :: nonnegative_q
    n = SIZE(q)
    res = -99._sp
    j = 0
    DO i=1,n
      IF (q(i) .GE. 0._sp) THEN
        j = j + 1
        nonnegative_q(j) = q(i)
      END IF
    END DO
    IF (j .GT. 1) res = QUANTILE1D_R(nonnegative_q(1:j), quant)
  END FUNCTION CFP

!  Differentiation of eff in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: res
!   with respect to varying inputs: q
  FUNCTION EFF_D(q, q_d, res) RESULT (RES_D)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: q
    REAL(sp), DIMENSION(:), INTENT(IN) :: q_d
    REAL(sp) :: res
    REAL(sp) :: res_d
    INTEGER :: n, i, j
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(q)) :: nonnegative_q, bf, qf
    REAL(sp), DIMENSION(SIZE(q)) :: nonnegative_q_d, bf_d, qf_d
    INTRINSIC SUM
    n = SIZE(q)
    res = -99._sp
    nonnegative_q = 0._sp
    j = 0
    nonnegative_q_d = 0.0_4
    DO i=1,n
      IF (q(i) .GE. 0._sp) THEN
        j = j + 1
        nonnegative_q_d(j) = q_d(i)
        nonnegative_q(j) = q(i)
      END IF
    END DO
    IF (j .GT. 1) THEN
      CALL BASEFLOW_SEPARATION_D(nonnegative_q(1:j), nonnegative_q_d(1:j&
&                          ), bf(1:j), bf_d(1:j), qf(1:j), qf_d(1:j), &
&                          0.925_sp, 3)
      res_d = SUM(qf_d(1:j))/j
      res = SUM(qf(1:j))/j
    ELSE
      res_d = 0.0_4
    END IF
  END FUNCTION EFF_D

!  Differentiation of eff in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: res q
!   with respect to varying inputs: q
  SUBROUTINE EFF_B(q, q_b, res_b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: q
    REAL(sp), DIMENSION(:) :: q_b
    REAL(sp) :: res
    REAL(sp) :: res_b
    INTEGER :: n, i, j
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(q)) :: nonnegative_q, bf, qf
    REAL(sp), DIMENSION(SIZE(q)) :: nonnegative_q_b, bf_b, qf_b
    INTRINSIC SUM
    INTEGER :: branch
    n = SIZE(q)
    nonnegative_q = 0._sp
    j = 0
    DO i=1,n
      IF (q(i) .LT. 0._sp) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHINTEGER4(j)
        j = j + 1
        nonnegative_q(j) = q(i)
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    IF (j .GT. 1) THEN
      CALL BASEFLOW_SEPARATION(nonnegative_q(1:j), bf(1:j), qf(1:j), &
&                        0.925_sp, 3)
      qf_b = 0.0_4
      qf_b(1:j) = qf_b(1:j) + res_b/j
      nonnegative_q_b = 0.0_4
      bf_b = 0.0_4
      CALL BASEFLOW_SEPARATION_B(nonnegative_q(1:j), nonnegative_q_b(1:j&
&                          ), bf(1:j), bf_b(1:j), qf(1:j), qf_b(1:j), &
&                          0.925_sp, 3)
      bf_b(1:j) = 0.0_4
      qf_b(1:j) = 0.0_4
    ELSE
      nonnegative_q_b = 0.0_4
    END IF
    DO i=n,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        q_b(i) = q_b(i) + nonnegative_q_b(j)
        nonnegative_q_b(j) = 0.0_4
        CALL POPINTEGER4(j)
      END IF
    END DO
  END SUBROUTINE EFF_B

  FUNCTION EFF(q) RESULT (RES)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: q
    REAL(sp) :: res
    INTEGER :: n, i, j
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(q)) :: nonnegative_q, bf, qf
    INTRINSIC SUM
    n = SIZE(q)
    res = -99._sp
    nonnegative_q = 0._sp
    j = 0
    DO i=1,n
      IF (q(i) .GE. 0._sp) THEN
        j = j + 1
        nonnegative_q(j) = q(i)
      END IF
    END DO
    IF (j .GT. 1) THEN
      CALL BASEFLOW_SEPARATION(nonnegative_q(1:j), bf(1:j), qf(1:j), &
&                        0.925_sp, 3)
      res = SUM(qf(1:j))/j
    END IF
  END FUNCTION EFF

!  Differentiation of ebf in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: res
!   with respect to varying inputs: q
  FUNCTION EBF_D(q, q_d, res) RESULT (RES_D)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: q
    REAL(sp), DIMENSION(:), INTENT(IN) :: q_d
    REAL(sp) :: res
    REAL(sp) :: res_d
    INTEGER :: n, i, j
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(q)) :: nonnegative_q, bf, qf
    REAL(sp), DIMENSION(SIZE(q)) :: nonnegative_q_d, bf_d, qf_d
    INTRINSIC SUM
    n = SIZE(q)
    res = -99._sp
    nonnegative_q = 0._sp
    j = 0
    nonnegative_q_d = 0.0_4
    DO i=1,n
      IF (q(i) .GE. 0._sp) THEN
        j = j + 1
        nonnegative_q_d(j) = q_d(i)
        nonnegative_q(j) = q(i)
      END IF
    END DO
    IF (j .GT. 1) THEN
      CALL BASEFLOW_SEPARATION_D(nonnegative_q(1:j), nonnegative_q_d(1:j&
&                          ), bf(1:j), bf_d(1:j), qf(1:j), qf_d(1:j), &
&                          0.925_sp, 3)
      res_d = SUM(bf_d(1:j))/j
      res = SUM(bf(1:j))/j
    ELSE
      res_d = 0.0_4
    END IF
  END FUNCTION EBF_D

!  Differentiation of ebf in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: res q
!   with respect to varying inputs: q
  SUBROUTINE EBF_B(q, q_b, res_b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: q
    REAL(sp), DIMENSION(:) :: q_b
    REAL(sp) :: res
    REAL(sp) :: res_b
    INTEGER :: n, i, j
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(q)) :: nonnegative_q, bf, qf
    REAL(sp), DIMENSION(SIZE(q)) :: nonnegative_q_b, bf_b, qf_b
    INTRINSIC SUM
    INTEGER :: branch
    n = SIZE(q)
    nonnegative_q = 0._sp
    j = 0
    DO i=1,n
      IF (q(i) .LT. 0._sp) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHINTEGER4(j)
        j = j + 1
        nonnegative_q(j) = q(i)
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    IF (j .GT. 1) THEN
      CALL BASEFLOW_SEPARATION(nonnegative_q(1:j), bf(1:j), qf(1:j), &
&                        0.925_sp, 3)
      bf_b = 0.0_4
      bf_b(1:j) = bf_b(1:j) + res_b/j
      nonnegative_q_b = 0.0_4
      qf_b = 0.0_4
      CALL BASEFLOW_SEPARATION_B(nonnegative_q(1:j), nonnegative_q_b(1:j&
&                          ), bf(1:j), bf_b(1:j), qf(1:j), qf_b(1:j), &
&                          0.925_sp, 3)
      bf_b(1:j) = 0.0_4
      qf_b(1:j) = 0.0_4
    ELSE
      nonnegative_q_b = 0.0_4
    END IF
    DO i=n,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        q_b(i) = q_b(i) + nonnegative_q_b(j)
        nonnegative_q_b(j) = 0.0_4
        CALL POPINTEGER4(j)
      END IF
    END DO
  END SUBROUTINE EBF_B

  FUNCTION EBF(q) RESULT (RES)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: q
    REAL(sp) :: res
    INTEGER :: n, i, j
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(q)) :: nonnegative_q, bf, qf
    INTRINSIC SUM
    n = SIZE(q)
    res = -99._sp
    nonnegative_q = 0._sp
    j = 0
    DO i=1,n
      IF (q(i) .GE. 0._sp) THEN
        j = j + 1
        nonnegative_q(j) = q(i)
      END IF
    END DO
    IF (j .GT. 1) THEN
      CALL BASEFLOW_SEPARATION(nonnegative_q(1:j), bf(1:j), qf(1:j), &
&                        0.925_sp, 3)
      res = SUM(bf(1:j))/j
    END IF
  END FUNCTION EBF

!  Differentiation of epf in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: res
!   with respect to varying inputs: q
  FUNCTION EPF_D(q, q_d, res) RESULT (RES_D)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: q
    REAL(sp), DIMENSION(:), INTENT(IN) :: q_d
    REAL(sp) :: res
    REAL(sp) :: res_d
    INTEGER :: n, i
    INTRINSIC SIZE
    n = SIZE(q)
    res = -99._sp
    res_d = 0.0_4
    DO i=1,n
      IF (q(i) .GT. res) THEN
        res_d = q_d(i)
        res = q(i)
      END IF
    END DO
  END FUNCTION EPF_D

!  Differentiation of epf in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: res q
!   with respect to varying inputs: q
  SUBROUTINE EPF_B(q, q_b, res_b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: q
    REAL(sp), DIMENSION(:) :: q_b
    REAL(sp) :: res
    REAL(sp) :: res_b
    INTEGER :: n, i
    INTRINSIC SIZE
    INTEGER :: branch
    n = SIZE(q)
    res = -99._sp
    DO i=1,n
      IF (q(i) .LE. res) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        res = q(i)
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    DO i=n,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        q_b(i) = q_b(i) + res_b
        res_b = 0.0_4
      END IF
    END DO
  END SUBROUTINE EPF_B

  FUNCTION EPF(q) RESULT (RES)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: q
    REAL(sp) :: res
    INTEGER :: n, i
    INTRINSIC SIZE
    n = SIZE(q)
    res = -99._sp
    DO i=1,n
      IF (q(i) .GT. res) res = q(i)
    END DO
  END FUNCTION EPF

  FUNCTION ELT(p, q) RESULT (RES)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:), INTENT(IN) :: p, q
    REAL(sp) :: res
    INTEGER :: n, i, imax_p, imax_q
    REAL(sp) :: max_p, max_q
    INTRINSIC SIZE
    n = SIZE(q)
    res = -99._sp
    max_p = -99._sp
    max_q = -99._sp
    imax_p = 0
    imax_q = 0
    DO i=1,n
      IF (p(i) .GT. max_p) THEN
        max_p = p(i)
        imax_p = i
      END IF
      IF (q(i) .GT. max_q) THEN
        max_q = q(i)
        imax_q = i
      END IF
    END DO
    IF (imax_p .GT. 0 .AND. imax_q .GT. 0) res = imax_q - imax_p
  END FUNCTION ELT

END MODULE MWD_SIGNATURES_DIFF

!%      (MWD) Module Wrapped and Differentiated
!%
!%      Subroutine
!%      ----------
!%
!%      - get_serr_mu
!%      - get_serr_sigma
!%      - get_rr_parameters
!%      - get_rr_states
!%      - get_serr_mu_parameters
!%      - get_serr_sigma_parameters
!%      - set_rr_parameters
!%      - set_rr_states
!%      - set_serr_mu_parameters
!%      - set_serr_sigma_parameters
!%      - sigmoide
!%      - inv_sigmoide
!%      - scaled_sigmoide
!%      - inv_scaled_sigmoid
!%      - sigmoide2d
!%      - scaled_sigmoide2d
!%      - sbs_control_tfm
!%      - sbs_inv_control_tfm
!%      - normalize_control_tfm
!%      - normalize_inv_control_tfm
!%      - control_tfm
!%      - inv_control_tfm
!%      - uniform_rr_parameters_get_control_size
!%      - uniform_rr_initial_states_get_control_size
!%      - distributed_rr_parameters_get_control_size
!%      - distributed_rr_initial_states_get_control_size
!%      - multi_linear_rr_parameters_get_control_size
!%      - multi_linear_rr_initial_states_get_control_size
!%      - multi_power_rr_parameters_get_control_size
!%      - multi_power_rr_initial_states_get_control_size
!%      - serr_mu_parameters_get_control_size
!%      - nn_parameters_get_control_size
!%      - get_control_sizes
!%      - uniform_rr_parameters_fill_control
!%      - uniform_rr_initial_states_fill_control
!%      - distributed_rr_parameters_fill_control
!%      - distributed_rr_initial_states_fill_control
!%      - multi_linear_rr_parameters_fill_control
!%      - multi_linear_rr_initial_states_fill_control
!%      - multi_power_rr_parameters_fill_control
!%      - multi_power_rr_initial_states_fill_control
!%      - serr_mu_parameters_fill_control
!%      - serr_sigma_parameters_fill_control
!%      - nn_parameters_fill_control
!%      - fill_control
!%      - uniform_rr_parameters_fill_parameters
!%      - uniform_rr_initial_states_fill_parameters
!%      - distributed_rr_parameters_fill_parameters
!%      - distributed_rr_initial_states_fill_parameters
!%      - multi_linear_rr_parameters_fill_parameters
!%      - multi_linear_rr_initial_states_fill_parameters
!%      - multi_power_rr_parameters_fill_parameters
!%      - multi_power_rr_initial_states_fill_parameters
!%      - serr_mu_parameters_fill_parameters
!%      - serr_sigma_parameters_fill_parameters
!%      - nn_parameters_fill_parameters
!%      - fill_parameters
MODULE MWD_PARAMETERS_MANIPULATION_DIFF
!% only: MuFunk_vect, SigmaFunk_vect
  USE MWD_BAYESIAN_TOOLS_DIFF
!% only: sp, dp
  USE MD_CONSTANT
!% only: SetupDT
  USE MWD_SETUP
!% only: MeshDT
  USE MWD_MESH
!% only: Input_DataDT
  USE MWD_INPUT_DATA
!% only: ParametersDT
  USE MWD_PARAMETERS_DIFF
!% only: RR_ParametersDT
  USE MWD_RR_PARAMETERS_DIFF
!% only: RR_StatesDT
  USE MWD_RR_STATES_DIFF
!% only: SErr_Mu_ParametersDT
  USE MWD_SERR_MU_PARAMETERS_DIFF
!% only: SErr_Sigma_ParametersDT
  USE MWD_SERR_SIGMA_PARAMETERS_DIFF
!% only: OutputDT
  USE MWD_OUTPUT_DIFF
!% only: OptionsDT
  USE MWD_OPTIONS_DIFF
!% only: ReturnsDT
  USE MWD_RETURNS_DIFF
!% only: ControlDT_initialise, ControlDT_finalise
  USE MWD_CONTROL_DIFF
  IMPLICIT NONE

CONTAINS
  SUBROUTINE GET_RR_PARAMETERS(rr_parameters, key, vle)
    IMPLICIT NONE
! Should be unreachable
    TYPE(RR_PARAMETERSDT), INTENT(IN) :: rr_parameters
    CHARACTER(len=*), INTENT(IN) :: key
    REAL(sp), DIMENSION(:, :), INTENT(INOUT) :: vle
    INTEGER :: i
    INTRINSIC SIZE
    INTRINSIC TRIM
! Linear search on keys
    DO i=1,SIZE(rr_parameters%keys)
      IF (TRIM(rr_parameters%keys(i)) .EQ. key) THEN
        vle = rr_parameters%values(:, :, i)
        RETURN
      END IF
    END DO
  END SUBROUTINE GET_RR_PARAMETERS

  SUBROUTINE GET_RR_STATES(rr_states, key, vle)
    IMPLICIT NONE
! Should be unreachable
    TYPE(RR_STATESDT), INTENT(IN) :: rr_states
    CHARACTER(len=*), INTENT(IN) :: key
    REAL(sp), DIMENSION(:, :), INTENT(INOUT) :: vle
    INTEGER :: i
    INTRINSIC SIZE
    INTRINSIC TRIM
! Linear search on keys
    DO i=1,SIZE(rr_states%keys)
      IF (TRIM(rr_states%keys(i)) .EQ. key) THEN
        vle = rr_states%values(:, :, i)
        RETURN
      END IF
    END DO
  END SUBROUTINE GET_RR_STATES

  SUBROUTINE GET_SERR_MU_PARAMETERS(serr_mu_parameters, key, vle)
    IMPLICIT NONE
! Should be unreachable
    TYPE(SERR_MU_PARAMETERSDT), INTENT(IN) :: serr_mu_parameters
    CHARACTER(len=*), INTENT(IN) :: key
    REAL(sp), DIMENSION(:), INTENT(INOUT) :: vle
    INTEGER :: i
    INTRINSIC SIZE
    INTRINSIC TRIM
! Linear search on keys
    DO i=1,SIZE(serr_mu_parameters%keys)
      IF (TRIM(serr_mu_parameters%keys(i)) .EQ. key) THEN
        vle = serr_mu_parameters%values(:, i)
        RETURN
      END IF
    END DO
  END SUBROUTINE GET_SERR_MU_PARAMETERS

  SUBROUTINE GET_SERR_SIGMA_PARAMETERS(serr_sigma_parameters, key, vle)
    IMPLICIT NONE
! Should be unreachable
    TYPE(SERR_SIGMA_PARAMETERSDT), INTENT(IN) :: serr_sigma_parameters
    CHARACTER(len=*), INTENT(IN) :: key
    REAL(sp), DIMENSION(:), INTENT(INOUT) :: vle
    INTEGER :: i
    INTRINSIC SIZE
    INTRINSIC TRIM
! Linear search on keys
    DO i=1,SIZE(serr_sigma_parameters%keys)
      IF (TRIM(serr_sigma_parameters%keys(i)) .EQ. key) THEN
        vle = serr_sigma_parameters%values(:, i)
        RETURN
      END IF
    END DO
  END SUBROUTINE GET_SERR_SIGMA_PARAMETERS

  SUBROUTINE SET_RR_PARAMETERS(rr_parameters, key, vle)
    IMPLICIT NONE
! Should be unreachable
    TYPE(RR_PARAMETERSDT), INTENT(INOUT) :: rr_parameters
    CHARACTER(len=*), INTENT(IN) :: key
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: vle
    INTEGER :: i
    INTRINSIC SIZE
    INTRINSIC TRIM
! Linear search on keys
    DO i=1,SIZE(rr_parameters%keys)
      IF (TRIM(rr_parameters%keys(i)) .EQ. key) THEN
        rr_parameters%values(:, :, i) = vle
        RETURN
      END IF
    END DO
  END SUBROUTINE SET_RR_PARAMETERS

  SUBROUTINE SET_RR_STATES(rr_states, key, vle)
    IMPLICIT NONE
! Should be unreachable
    TYPE(RR_STATESDT), INTENT(INOUT) :: rr_states
    CHARACTER(len=*), INTENT(IN) :: key
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: vle
    INTEGER :: i
    INTRINSIC SIZE
    INTRINSIC TRIM
! Linear search on keys
    DO i=1,SIZE(rr_states%keys)
      IF (TRIM(rr_states%keys(i)) .EQ. key) THEN
        rr_states%values(:, :, i) = vle
        RETURN
      END IF
    END DO
  END SUBROUTINE SET_RR_STATES

  SUBROUTINE SET_SERR_MU_PARAMETERS(serr_mu_parameters, key, vle)
    IMPLICIT NONE
! Should be unreachable
    TYPE(SERR_MU_PARAMETERSDT), INTENT(INOUT) :: serr_mu_parameters
    CHARACTER(len=*), INTENT(IN) :: key
    REAL(sp), DIMENSION(:), INTENT(IN) :: vle
    INTEGER :: i
    INTRINSIC SIZE
    INTRINSIC TRIM
! Linear search on keys
    DO i=1,SIZE(serr_mu_parameters%keys)
      IF (TRIM(serr_mu_parameters%keys(i)) .EQ. key) THEN
        serr_mu_parameters%values(:, i) = vle
        RETURN
      END IF
    END DO
  END SUBROUTINE SET_SERR_MU_PARAMETERS

  SUBROUTINE SET_SERR_SIGMA_PARAMETERS(serr_sigma_parameters, key, vle)
    IMPLICIT NONE
! Should be unreachable
    TYPE(SERR_SIGMA_PARAMETERSDT), INTENT(INOUT) :: &
&   serr_sigma_parameters
    CHARACTER(len=*), INTENT(IN) :: key
    REAL(sp), DIMENSION(:), INTENT(IN) :: vle
    INTEGER :: i
    INTRINSIC SIZE
    INTRINSIC TRIM
! Linear search on keys
    DO i=1,SIZE(serr_sigma_parameters%keys)
      IF (TRIM(serr_sigma_parameters%keys(i)) .EQ. key) THEN
        serr_sigma_parameters%values(:, i) = vle
        RETURN
      END IF
    END DO
  END SUBROUTINE SET_SERR_SIGMA_PARAMETERS

  SUBROUTINE SIGMOIDE(x, res)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: x
    REAL(sp), INTENT(INOUT) :: res
    INTRINSIC EXP
    res = 1._sp/(1._sp+EXP(-x))
  END SUBROUTINE SIGMOIDE

  SUBROUTINE INV_SIGMOIDE(x, res)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: x
    REAL(sp), INTENT(INOUT) :: res
    INTRINSIC LOG
    res = LOG(x/(1._sp-x))
  END SUBROUTINE INV_SIGMOIDE

  SUBROUTINE SCALED_SIGMOIDE(x, l, u, res)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: x, l, u
    REAL(sp), INTENT(INOUT) :: res
    CALL SIGMOIDE(x, res)
    res = res*(u-l) + l
  END SUBROUTINE SCALED_SIGMOIDE

  SUBROUTINE INV_SCALED_SIGMOID(x, l, u, res)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: x, l, u
    REAL(sp), INTENT(INOUT) :: res
    REAL(sp) :: xw
    REAL(sp), SAVE :: eps=1e-3_sp
    INTRINSIC MAX
    INTRINSIC MIN
    IF (x .LT. l + eps) THEN
      xw = l + eps
    ELSE
      xw = x
    END IF
    IF (x .GT. u - eps) THEN
      xw = u - eps
    ELSE
      xw = x
    END IF
    xw = (xw-l)/(u-l)
    CALL INV_SIGMOIDE(xw, res)
  END SUBROUTINE INV_SCALED_SIGMOID

!  Differentiation of sigmoide2d in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: res
!   with respect to varying inputs: x
  SUBROUTINE SIGMOIDE2D_D(x, x_d, res, res_d)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: x
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: x_d
    REAL(sp), DIMENSION(:, :), INTENT(INOUT) :: res
    REAL(sp), DIMENSION(:, :), INTENT(INOUT) :: res_d
    INTRINSIC EXP
    REAL*4, DIMENSION(SIZE(x, 1), SIZE(x, 2)) :: temp
    temp = 1.0/(EXP(-x)+1._sp)
    res_d = temp*EXP(-x)*x_d/(EXP(-x)+1._sp)
    res = temp
  END SUBROUTINE SIGMOIDE2D_D

!  Differentiation of sigmoide2d in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: res
!   with respect to varying inputs: x
  SUBROUTINE SIGMOIDE2D_B(x, x_b, res, res_b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: x
    REAL(sp), DIMENSION(:, :) :: x_b
    REAL(sp), DIMENSION(:, :), INTENT(INOUT) :: res
    REAL(sp), DIMENSION(:, :), INTENT(INOUT) :: res_b
    INTRINSIC EXP
    REAL(sp), DIMENSION(SIZE(x, 1), SIZE(x, 2)) :: temp
    x_b = 0.0_4
    temp = EXP(-x) + 1._sp
    x_b = EXP(-x)*res_b/temp**2
  END SUBROUTINE SIGMOIDE2D_B

  SUBROUTINE SIGMOIDE2D(x, res)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: x
    REAL(sp), DIMENSION(:, :), INTENT(INOUT) :: res
    INTRINSIC EXP
    res = 1._sp/(1._sp+EXP(-x))
  END SUBROUTINE SIGMOIDE2D

!  Differentiation of scaled_sigmoide2d in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: res
!   with respect to varying inputs: x
  SUBROUTINE SCALED_SIGMOIDE2D_D(x, x_d, l, u, res, res_d)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: x
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: x_d
    REAL(sp), INTENT(IN) :: l, u
    REAL(sp), DIMENSION(:, :), INTENT(INOUT) :: res
    REAL(sp), DIMENSION(:, :), INTENT(INOUT) :: res_d
    CALL SIGMOIDE2D_D(x, x_d, res, res_d)
    res_d = (u-l)*res_d
    res = res*(u-l) + l
  END SUBROUTINE SCALED_SIGMOIDE2D_D

!  Differentiation of scaled_sigmoide2d in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: res
!   with respect to varying inputs: x
  SUBROUTINE SCALED_SIGMOIDE2D_B(x, x_b, l, u, res, res_b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: x
    REAL(sp), DIMENSION(:, :) :: x_b
    REAL(sp), INTENT(IN) :: l, u
    REAL(sp), DIMENSION(:, :), INTENT(INOUT) :: res
    REAL(sp), DIMENSION(:, :), INTENT(INOUT) :: res_b
    CALL PUSHREAL4ARRAY(res, SIZE(res, 1)*SIZE(res, 2))
    CALL SIGMOIDE2D(x, res)
    res_b = (u-l)*res_b
    CALL POPREAL4ARRAY(res, SIZE(res, 1)*SIZE(res, 2))
    CALL SIGMOIDE2D_B(x, x_b, res, res_b)
  END SUBROUTINE SCALED_SIGMOIDE2D_B

  SUBROUTINE SCALED_SIGMOIDE2D(x, l, u, res)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: x
    REAL(sp), INTENT(IN) :: l, u
    REAL(sp), DIMENSION(:, :), INTENT(INOUT) :: res
    CALL SIGMOIDE2D(x, res)
    res = res*(u-l) + l
  END SUBROUTINE SCALED_SIGMOIDE2D

!  Differentiation of sbs_control_tfm in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: *(parameters.control.x)
!   with respect to varying inputs: *(parameters.control.x)
!   Plus diff mem management of: parameters.control.x:in parameters.control.l_raw:in
!                parameters.control.u_raw:in
  SUBROUTINE SBS_CONTROL_TFM_D(parameters, parameters_d)
    IMPLICIT NONE
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_d
    INTEGER :: i
    LOGICAL, DIMENSION(parameters%control%n) :: nbd_mask
    INTRINSIC SUM
    INTRINSIC ASINH
    INTRINSIC LOG
    REAL(sp) :: temp
!% Need lower and upper bound to sbs tfm
    nbd_mask = parameters%control%nbd(:) .EQ. 2
! Only apply sbs transformation on RR parameters and RR initial states
    DO i=1,SUM(parameters%control%nbk(1:2))
      IF (nbd_mask(i)) THEN
        IF (parameters%control%l_raw(i) .LT. 0._sp) THEN
          parameters_d%control%x(i) = parameters_d%control%x(i)/SQRT(1.0&
&           +parameters%control%x(i)**2)
          parameters%control%x(i) = ASINH(parameters%control%x(i))
        ELSE IF (parameters%control%l_raw(i) .GE. 0._sp .AND. parameters&
&           %control%u_raw(i) .LE. 1._sp) THEN
          temp = parameters%control%x(i)/(-parameters%control%x(i)+1._sp&
&           )
          parameters_d%control%x(i) = (temp+1.0)*parameters_d%control%x(&
&           i)/(temp*(1._sp-parameters%control%x(i)))
          parameters%control%x(i) = LOG(temp)
        ELSE
          parameters_d%control%x(i) = parameters_d%control%x(i)/&
&           parameters%control%x(i)
          parameters%control%x(i) = LOG(parameters%control%x(i))
        END IF
      END IF
    END DO
  END SUBROUTINE SBS_CONTROL_TFM_D

!  Differentiation of sbs_control_tfm in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: *(parameters.control.x)
!   with respect to varying inputs: *(parameters.control.x)
!   Plus diff mem management of: parameters.control.x:in parameters.control.l_raw:in
!                parameters.control.u_raw:in
  SUBROUTINE SBS_CONTROL_TFM_B(parameters, parameters_b)
    IMPLICIT NONE
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_b
    INTEGER :: i
    LOGICAL, DIMENSION(parameters%control%n) :: nbd_mask
    INTRINSIC SUM
    INTRINSIC ASINH
    INTRINSIC LOG
    REAL(sp) :: temp
    REAL(sp) :: temp_b
    INTEGER :: ad_to
    INTEGER :: branch
!% Need lower and upper bound to sbs tfm
    nbd_mask = parameters%control%nbd(:) .EQ. 2
! Only apply sbs transformation on RR parameters and RR initial states
    DO i=1,SUM(parameters%control%nbk(1:2))
      IF (.NOT.nbd_mask(i)) THEN
        CALL PUSHCONTROL2B(0)
      ELSE IF (parameters%control%l_raw(i) .LT. 0._sp) THEN
        CALL PUSHREAL4(parameters%control%x(i))
        parameters%control%x(i) = ASINH(parameters%control%x(i))
        CALL PUSHCONTROL2B(3)
      ELSE IF (parameters%control%l_raw(i) .GE. 0._sp .AND. parameters%&
&         control%u_raw(i) .LE. 1._sp) THEN
        CALL PUSHREAL4(parameters%control%x(i))
        parameters%control%x(i) = LOG(parameters%control%x(i)/(1._sp-&
&         parameters%control%x(i)))
        CALL PUSHCONTROL2B(2)
      ELSE
        CALL PUSHREAL4(parameters%control%x(i))
        parameters%control%x(i) = LOG(parameters%control%x(i))
        CALL PUSHCONTROL2B(1)
      END IF
    END DO
    ad_to = i - 1
    DO i=ad_to,1,-1
      CALL POPCONTROL2B(branch)
      IF (branch .LT. 2) THEN
        IF (branch .NE. 0) THEN
          CALL POPREAL4(parameters%control%x(i))
          parameters_b%control%x(i) = parameters_b%control%x(i)/&
&           parameters%control%x(i)
        END IF
      ELSE IF (branch .EQ. 2) THEN
        CALL POPREAL4(parameters%control%x(i))
        temp = parameters%control%x(i)/(-parameters%control%x(i)+1._sp)
        temp_b = parameters_b%control%x(i)/((1._sp-parameters%control%x(&
&         i))*temp)
        parameters_b%control%x(i) = (temp+1.0)*temp_b
      ELSE
        CALL POPREAL4(parameters%control%x(i))
        parameters_b%control%x(i) = parameters_b%control%x(i)/SQRT(1.0+&
&         parameters%control%x(i)**2)
      END IF
    END DO
  END SUBROUTINE SBS_CONTROL_TFM_B

  SUBROUTINE SBS_CONTROL_TFM(parameters)
    IMPLICIT NONE
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    INTEGER :: i
    LOGICAL, DIMENSION(parameters%control%n) :: nbd_mask
    INTRINSIC SUM
    INTRINSIC ASINH
    INTRINSIC LOG
!% Need lower and upper bound to sbs tfm
    nbd_mask = parameters%control%nbd(:) .EQ. 2
! Only apply sbs transformation on RR parameters and RR initial states
    DO i=1,SUM(parameters%control%nbk(1:2))
      IF (nbd_mask(i)) THEN
        IF (parameters%control%l_raw(i) .LT. 0._sp) THEN
          parameters%control%x(i) = ASINH(parameters%control%x(i))
          parameters%control%l(i) = ASINH(parameters%control%l_raw(i))
          parameters%control%u(i) = ASINH(parameters%control%u_raw(i))
        ELSE IF (parameters%control%l_raw(i) .GE. 0._sp .AND. parameters&
&           %control%u_raw(i) .LE. 1._sp) THEN
          parameters%control%x(i) = LOG(parameters%control%x(i)/(1._sp-&
&           parameters%control%x(i)))
          parameters%control%l(i) = LOG(parameters%control%l_raw(i)/(&
&           1._sp-parameters%control%l_raw(i)))
          parameters%control%u(i) = LOG(parameters%control%u_raw(i)/(&
&           1._sp-parameters%control%u_raw(i)))
        ELSE
          parameters%control%x(i) = LOG(parameters%control%x(i))
          parameters%control%l(i) = LOG(parameters%control%l_raw(i))
          parameters%control%u(i) = LOG(parameters%control%u_raw(i))
        END IF
      END IF
    END DO
  END SUBROUTINE SBS_CONTROL_TFM

!  Differentiation of sbs_inv_control_tfm in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: *(parameters.control.x)
!   with respect to varying inputs: *(parameters.control.x)
!   Plus diff mem management of: parameters.control.x:in parameters.control.l_raw:in
!                parameters.control.u_raw:in
  SUBROUTINE SBS_INV_CONTROL_TFM_D(parameters, parameters_d)
    IMPLICIT NONE
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_d
    INTEGER :: i
    LOGICAL, DIMENSION(parameters%control%n) :: nbd_mask
    INTRINSIC SUM
    INTRINSIC SINH
    INTRINSIC EXP
    REAL(sp) :: temp
    REAL(sp) :: temp0
!% Need lower and upper bound to sbs tfm
    nbd_mask = parameters%control%nbd(:) .EQ. 2
! Only apply sbs inv transformation on RR parameters et RR initial states
    DO i=1,SUM(parameters%control%nbk(1:2))
      IF (nbd_mask(i)) THEN
        IF (parameters%control%l_raw(i) .LT. 0._sp) THEN
          parameters_d%control%x(i) = COSH(parameters%control%x(i))*&
&           parameters_d%control%x(i)
          parameters%control%x(i) = SINH(parameters%control%x(i))
        ELSE IF (parameters%control%l_raw(i) .GE. 0._sp .AND. parameters&
&           %control%u_raw(i) .LE. 1._sp) THEN
          temp = EXP(parameters%control%x(i)) + 1._sp
          temp0 = EXP(parameters%control%x(i))/temp
          parameters_d%control%x(i) = (EXP(parameters%control%x(i))-&
&           temp0*EXP(parameters%control%x(i)))*parameters_d%control%x(i&
&           )/temp
          parameters%control%x(i) = temp0
        ELSE
          parameters_d%control%x(i) = EXP(parameters%control%x(i))*&
&           parameters_d%control%x(i)
          parameters%control%x(i) = EXP(parameters%control%x(i))
        END IF
      END IF
    END DO
  END SUBROUTINE SBS_INV_CONTROL_TFM_D

!  Differentiation of sbs_inv_control_tfm in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: *(parameters.control.x)
!   with respect to varying inputs: *(parameters.control.x)
!   Plus diff mem management of: parameters.control.x:in parameters.control.l_raw:in
!                parameters.control.u_raw:in
  SUBROUTINE SBS_INV_CONTROL_TFM_B(parameters, parameters_b)
    IMPLICIT NONE
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_b
    INTEGER :: i
    LOGICAL, DIMENSION(parameters%control%n) :: nbd_mask
    INTRINSIC SUM
    INTRINSIC SINH
    INTRINSIC EXP
    REAL(sp) :: temp
    INTEGER :: ad_to
    INTEGER :: branch
!% Need lower and upper bound to sbs tfm
    nbd_mask = parameters%control%nbd(:) .EQ. 2
! Only apply sbs inv transformation on RR parameters et RR initial states
    DO i=1,SUM(parameters%control%nbk(1:2))
      IF (.NOT.nbd_mask(i)) THEN
        CALL PUSHCONTROL2B(0)
      ELSE IF (parameters%control%l_raw(i) .LT. 0._sp) THEN
        CALL PUSHREAL4(parameters%control%x(i))
        parameters%control%x(i) = SINH(parameters%control%x(i))
        CALL PUSHCONTROL2B(3)
      ELSE IF (parameters%control%l_raw(i) .GE. 0._sp .AND. parameters%&
&         control%u_raw(i) .LE. 1._sp) THEN
        CALL PUSHREAL4(parameters%control%x(i))
        parameters%control%x(i) = EXP(parameters%control%x(i))/(1._sp+&
&         EXP(parameters%control%x(i)))
        CALL PUSHCONTROL2B(2)
      ELSE
        CALL PUSHREAL4(parameters%control%x(i))
        parameters%control%x(i) = EXP(parameters%control%x(i))
        CALL PUSHCONTROL2B(1)
      END IF
    END DO
    CALL PUSHINTEGER4(i - 1)
    CALL POPINTEGER4(ad_to)
    DO i=ad_to,1,-1
      CALL POPCONTROL2B(branch)
      IF (branch .LT. 2) THEN
        IF (branch .NE. 0) THEN
          CALL POPREAL4(parameters%control%x(i))
          parameters_b%control%x(i) = EXP(parameters%control%x(i))*&
&           parameters_b%control%x(i)
        END IF
      ELSE IF (branch .EQ. 2) THEN
        CALL POPREAL4(parameters%control%x(i))
        temp = EXP(parameters%control%x(i)) + 1._sp
        parameters_b%control%x(i) = (EXP(parameters%control%x(i))/temp-&
&         EXP(parameters%control%x(i))**2/temp**2)*parameters_b%control%&
&         x(i)
      ELSE
        CALL POPREAL4(parameters%control%x(i))
        parameters_b%control%x(i) = COSH(parameters%control%x(i))*&
&         parameters_b%control%x(i)
      END IF
    END DO
  END SUBROUTINE SBS_INV_CONTROL_TFM_B

  SUBROUTINE SBS_INV_CONTROL_TFM(parameters)
    IMPLICIT NONE
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    INTEGER :: i
    LOGICAL, DIMENSION(parameters%control%n) :: nbd_mask
    INTRINSIC SUM
    INTRINSIC SINH
    INTRINSIC EXP
!% Need lower and upper bound to sbs tfm
    nbd_mask = parameters%control%nbd(:) .EQ. 2
! Only apply sbs inv transformation on RR parameters et RR initial states
    DO i=1,SUM(parameters%control%nbk(1:2))
      IF (nbd_mask(i)) THEN
        IF (parameters%control%l_raw(i) .LT. 0._sp) THEN
          parameters%control%x(i) = SINH(parameters%control%x(i))
        ELSE IF (parameters%control%l_raw(i) .GE. 0._sp .AND. parameters&
&           %control%u_raw(i) .LE. 1._sp) THEN
          parameters%control%x(i) = EXP(parameters%control%x(i))/(1._sp+&
&           EXP(parameters%control%x(i)))
        ELSE
          parameters%control%x(i) = EXP(parameters%control%x(i))
        END IF
      END IF
    END DO
    parameters%control%l = parameters%control%l_raw
    parameters%control%u = parameters%control%u_raw
  END SUBROUTINE SBS_INV_CONTROL_TFM

!  Differentiation of normalize_control_tfm in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: *(parameters.control.x)
!   with respect to varying inputs: *(parameters.control.x)
!   Plus diff mem management of: parameters.control.x:in
  SUBROUTINE NORMALIZE_CONTROL_TFM_D(parameters, parameters_d)
    IMPLICIT NONE
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_d
    LOGICAL, DIMENSION(parameters%control%n) :: nbd_mask
!% Need lower and upper bound to normalize
    nbd_mask = parameters%control%nbd(:) .EQ. 2
    WHERE (nbd_mask) 
      parameters_d%control%x = parameters_d%control%x/(parameters%&
&       control%u_raw-parameters%control%l_raw)
      parameters%control%x = (parameters%control%x-parameters%control%&
&       l_raw)/(parameters%control%u_raw-parameters%control%l_raw)
    END WHERE
  END SUBROUTINE NORMALIZE_CONTROL_TFM_D

!  Differentiation of normalize_control_tfm in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: *(parameters.control.x)
!   with respect to varying inputs: *(parameters.control.x)
!   Plus diff mem management of: parameters.control.x:in
  SUBROUTINE NORMALIZE_CONTROL_TFM_B(parameters, parameters_b)
    IMPLICIT NONE
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_b
    LOGICAL, DIMENSION(parameters%control%n) :: nbd_mask
!% Need lower and upper bound to normalize
    nbd_mask = parameters%control%nbd(:) .EQ. 2
    WHERE (nbd_mask) parameters_b%control%x = parameters_b%control%x/(&
&       parameters%control%u_raw-parameters%control%l_raw)
  END SUBROUTINE NORMALIZE_CONTROL_TFM_B

  SUBROUTINE NORMALIZE_CONTROL_TFM(parameters)
    IMPLICIT NONE
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    LOGICAL, DIMENSION(parameters%control%n) :: nbd_mask
!% Need lower and upper bound to normalize
    nbd_mask = parameters%control%nbd(:) .EQ. 2
    WHERE (nbd_mask) 
      parameters%control%x = (parameters%control%x-parameters%control%&
&       l_raw)/(parameters%control%u_raw-parameters%control%l_raw)
      parameters%control%l = 0._sp
      parameters%control%u = 1._sp
    END WHERE
  END SUBROUTINE NORMALIZE_CONTROL_TFM

!  Differentiation of normalize_inv_control_tfm in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: *(parameters.control.x)
!   with respect to varying inputs: *(parameters.control.x)
!   Plus diff mem management of: parameters.control.x:in parameters.control.l_raw:in
!                parameters.control.u_raw:in
  SUBROUTINE NORMALIZE_INV_CONTROL_TFM_D(parameters, parameters_d)
    IMPLICIT NONE
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_d
    LOGICAL, DIMENSION(parameters%control%n) :: nbd_mask
!% Need lower and upper bound to denormalize
    nbd_mask = parameters%control%nbd(:) .EQ. 2
    WHERE (nbd_mask) 
      parameters_d%control%x = (parameters%control%u_raw-parameters%&
&       control%l_raw)*parameters_d%control%x
      parameters%control%x = parameters%control%x*(parameters%control%&
&       u_raw-parameters%control%l_raw) + parameters%control%l_raw
    END WHERE
  END SUBROUTINE NORMALIZE_INV_CONTROL_TFM_D

!  Differentiation of normalize_inv_control_tfm in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: *(parameters.control.x)
!   with respect to varying inputs: *(parameters.control.x)
!   Plus diff mem management of: parameters.control.x:in parameters.control.l_raw:in
!                parameters.control.u_raw:in
  SUBROUTINE NORMALIZE_INV_CONTROL_TFM_B(parameters, parameters_b)
    IMPLICIT NONE
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_b
    LOGICAL, DIMENSION(parameters%control%n) :: nbd_mask
!% Need lower and upper bound to denormalize
    nbd_mask = parameters%control%nbd(:) .EQ. 2
    WHERE (nbd_mask) parameters_b%control%x = (parameters%control%u_raw-&
&       parameters%control%l_raw)*parameters_b%control%x
  END SUBROUTINE NORMALIZE_INV_CONTROL_TFM_B

  SUBROUTINE NORMALIZE_INV_CONTROL_TFM(parameters)
    IMPLICIT NONE
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    LOGICAL, DIMENSION(parameters%control%n) :: nbd_mask
!% Need lower and upper bound to denormalize
    nbd_mask = parameters%control%nbd(:) .EQ. 2
    WHERE (nbd_mask) 
      parameters%control%x = parameters%control%x*(parameters%control%&
&       u_raw-parameters%control%l_raw) + parameters%control%l_raw
      parameters%control%l = parameters%control%l_raw
      parameters%control%u = parameters%control%u_raw
    END WHERE
  END SUBROUTINE NORMALIZE_INV_CONTROL_TFM

!  Differentiation of control_tfm in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: *(parameters.control.x)
!   with respect to varying inputs: *(parameters.control.x)
!   Plus diff mem management of: parameters.control.x:in parameters.control.l:in
!                parameters.control.u:in parameters.control.l_raw:in
!                parameters.control.u_raw:in
  SUBROUTINE CONTROL_TFM_D(parameters, parameters_d, options)
    IMPLICIT NONE
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_d
    TYPE(OPTIONSDT), INTENT(IN) :: options
    SELECT CASE  (options%optimize%control_tfm) 
    CASE ('sbs') 
      CALL SBS_CONTROL_TFM_D(parameters, parameters_d)
    CASE ('normalize') 
      CALL NORMALIZE_CONTROL_TFM_D(parameters, parameters_d)
    END SELECT
  END SUBROUTINE CONTROL_TFM_D

!  Differentiation of control_tfm in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: *(parameters.control.x)
!   with respect to varying inputs: *(parameters.control.x)
!   Plus diff mem management of: parameters.control.x:in parameters.control.l:in
!                parameters.control.u:in parameters.control.l_raw:in
!                parameters.control.u_raw:in
  SUBROUTINE CONTROL_TFM_B(parameters, parameters_b, options)
    IMPLICIT NONE
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_b
    TYPE(OPTIONSDT), INTENT(IN) :: options
    SELECT CASE  (options%optimize%control_tfm) 
    CASE ('sbs') 
      CALL PUSHREAL4ARRAY(parameters%control%x, SIZE(parameters%control%&
&                   x, 1))
      CALL SBS_CONTROL_TFM(parameters)
      CALL POPREAL4ARRAY(parameters%control%x, SIZE(parameters%control%x&
&                  , 1))
      CALL SBS_CONTROL_TFM_B(parameters, parameters_b)
    CASE ('normalize') 
      CALL PUSHREAL4ARRAY(parameters%control%x, SIZE(parameters%control%&
&                   x, 1))
      CALL NORMALIZE_CONTROL_TFM(parameters)
      CALL POPREAL4ARRAY(parameters%control%x, SIZE(parameters%control%x&
&                  , 1))
      CALL NORMALIZE_CONTROL_TFM_B(parameters, parameters_b)
    END SELECT
  END SUBROUTINE CONTROL_TFM_B

  SUBROUTINE CONTROL_TFM(parameters, options)
    IMPLICIT NONE
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    SELECT CASE  (options%optimize%control_tfm) 
    CASE ('sbs') 
      CALL SBS_CONTROL_TFM(parameters)
    CASE ('normalize') 
      CALL NORMALIZE_CONTROL_TFM(parameters)
    END SELECT
  END SUBROUTINE CONTROL_TFM

!  Differentiation of inv_control_tfm in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: *(parameters.control.x)
!   with respect to varying inputs: *(parameters.control.x)
!   Plus diff mem management of: parameters.control.x:in parameters.control.l:in
!                parameters.control.u:in parameters.control.l_raw:in
!                parameters.control.u_raw:in
  SUBROUTINE INV_CONTROL_TFM_D(parameters, parameters_d, options)
    IMPLICIT NONE
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_d
    TYPE(OPTIONSDT), INTENT(IN) :: options
    SELECT CASE  (options%optimize%control_tfm) 
    CASE ('sbs') 
      CALL SBS_INV_CONTROL_TFM_D(parameters, parameters_d)
    CASE ('normalize') 
      CALL NORMALIZE_INV_CONTROL_TFM_D(parameters, parameters_d)
    END SELECT
  END SUBROUTINE INV_CONTROL_TFM_D

!  Differentiation of inv_control_tfm in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: *(parameters.control.x)
!   with respect to varying inputs: *(parameters.control.x)
!   Plus diff mem management of: parameters.control.x:in parameters.control.l:in
!                parameters.control.u:in parameters.control.l_raw:in
!                parameters.control.u_raw:in
  SUBROUTINE INV_CONTROL_TFM_B(parameters, parameters_b, options)
    IMPLICIT NONE
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_b
    TYPE(OPTIONSDT), INTENT(IN) :: options
    SELECT CASE  (options%optimize%control_tfm) 
    CASE ('sbs') 
      CALL PUSHREAL4ARRAY(parameters%control%x, SIZE(parameters%control%&
&                   x, 1))
      CALL SBS_INV_CONTROL_TFM(parameters)
      CALL POPREAL4ARRAY(parameters%control%x, SIZE(parameters%control%x&
&                  , 1))
      CALL SBS_INV_CONTROL_TFM_B(parameters, parameters_b)
    CASE ('normalize') 
      CALL NORMALIZE_INV_CONTROL_TFM(parameters)
      CALL NORMALIZE_INV_CONTROL_TFM_B(parameters, parameters_b)
    END SELECT
  END SUBROUTINE INV_CONTROL_TFM_B

  SUBROUTINE INV_CONTROL_TFM(parameters, options)
    IMPLICIT NONE
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    SELECT CASE  (options%optimize%control_tfm) 
    CASE ('sbs') 
      CALL SBS_INV_CONTROL_TFM(parameters)
    CASE ('normalize') 
      CALL NORMALIZE_INV_CONTROL_TFM(parameters)
    END SELECT
  END SUBROUTINE INV_CONTROL_TFM

  SUBROUTINE UNIFORM_RR_PARAMETERS_GET_CONTROL_SIZE(options, n)
    IMPLICIT NONE
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER, INTENT(INOUT) :: n
    INTRINSIC SUM
    n = SUM(options%optimize%rr_parameters)
  END SUBROUTINE UNIFORM_RR_PARAMETERS_GET_CONTROL_SIZE

  SUBROUTINE UNIFORM_RR_INITIAL_STATES_GET_CONTROL_SIZE(options, n)
    IMPLICIT NONE
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER, INTENT(INOUT) :: n
    INTRINSIC SUM
    n = SUM(options%optimize%rr_initial_states)
  END SUBROUTINE UNIFORM_RR_INITIAL_STATES_GET_CONTROL_SIZE

  SUBROUTINE DISTRIBUTED_RR_PARAMETERS_GET_CONTROL_SIZE(mesh, options, n&
& )
    IMPLICIT NONE
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER, INTENT(INOUT) :: n
    INTRINSIC SUM
    n = SUM(options%optimize%rr_parameters)*mesh%nac
  END SUBROUTINE DISTRIBUTED_RR_PARAMETERS_GET_CONTROL_SIZE

  SUBROUTINE DISTRIBUTED_RR_INITIAL_STATES_GET_CONTROL_SIZE(mesh, &
&   options, n)
    IMPLICIT NONE
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER, INTENT(INOUT) :: n
    INTRINSIC SUM
    n = SUM(options%optimize%rr_initial_states)*mesh%nac
  END SUBROUTINE DISTRIBUTED_RR_INITIAL_STATES_GET_CONTROL_SIZE

  SUBROUTINE MULTI_LINEAR_RR_PARAMETERS_GET_CONTROL_SIZE(setup, options&
&   , n)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER, INTENT(INOUT) :: n
    INTEGER :: i
    INTRINSIC SUM
    n = 0
    DO i=1,setup%nrrp
      IF (options%optimize%rr_parameters(i) .NE. 0) n = n + 1 + SUM(&
&         options%optimize%rr_parameters_descriptor(:, i))
    END DO
  END SUBROUTINE MULTI_LINEAR_RR_PARAMETERS_GET_CONTROL_SIZE

  SUBROUTINE MULTI_LINEAR_RR_INITIAL_STATES_GET_CONTROL_SIZE(setup, &
&   options, n)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER, INTENT(INOUT) :: n
    INTEGER :: i
    INTRINSIC SUM
    n = 0
    DO i=1,setup%nrrs
      IF (options%optimize%rr_initial_states(i) .NE. 0) n = n + 1 + SUM(&
&         options%optimize%rr_initial_states_descriptor(:, i))
    END DO
  END SUBROUTINE MULTI_LINEAR_RR_INITIAL_STATES_GET_CONTROL_SIZE

  SUBROUTINE MULTI_POWER_RR_PARAMETERS_GET_CONTROL_SIZE(setup, options, &
&   n)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER, INTENT(INOUT) :: n
    INTEGER :: i
    INTRINSIC SUM
    n = 0
    DO i=1,setup%nrrp
      IF (options%optimize%rr_parameters(i) .NE. 0) n = n + 1 + 2*SUM(&
&         options%optimize%rr_parameters_descriptor(:, i))
    END DO
  END SUBROUTINE MULTI_POWER_RR_PARAMETERS_GET_CONTROL_SIZE

  SUBROUTINE MULTI_POWER_RR_INITIAL_STATES_GET_CONTROL_SIZE(setup, &
&   options, n)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER, INTENT(INOUT) :: n
    INTEGER :: i
    INTRINSIC SUM
    n = 0
    DO i=1,setup%nrrs
      IF (options%optimize%rr_initial_states(i) .NE. 0) n = n + 1 + 2*&
&         SUM(options%optimize%rr_initial_states_descriptor(:, i))
    END DO
  END SUBROUTINE MULTI_POWER_RR_INITIAL_STATES_GET_CONTROL_SIZE

  SUBROUTINE SERR_MU_PARAMETERS_GET_CONTROL_SIZE(options, n)
    IMPLICIT NONE
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER, INTENT(INOUT) :: n
    INTRINSIC SUM
    n = SUM(options%optimize%serr_mu_parameters)*options%cost%nog
  END SUBROUTINE SERR_MU_PARAMETERS_GET_CONTROL_SIZE

  SUBROUTINE SERR_SIGMA_PARAMETERS_GET_CONTROL_SIZE(options, n)
    IMPLICIT NONE
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER, INTENT(INOUT) :: n
    INTRINSIC SUM
    n = SUM(options%optimize%serr_sigma_parameters)*options%cost%nog
  END SUBROUTINE SERR_SIGMA_PARAMETERS_GET_CONTROL_SIZE

  SUBROUTINE NN_PARAMETERS_GET_CONTROL_SIZE(setup, options, n)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER, INTENT(INOUT) :: n
    INTEGER :: i, n_w, n_b
    INTRINSIC SIZE
    n = 0
    DO i=0,SIZE(setup%hidden_neuron)
      n_w = options%optimize%nn_parameters(2*i+1)*setup%neurons(i+2)*&
&       setup%neurons(i+1)
      n_b = options%optimize%nn_parameters(2*i+2)*setup%neurons(i+2)
      n = n + n_w + n_b
    END DO
  END SUBROUTINE NN_PARAMETERS_GET_CONTROL_SIZE

  SUBROUTINE GET_CONTROL_SIZES(setup, mesh, options, nbk)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER, DIMENSION(:), INTENT(OUT) :: nbk
    SELECT CASE  (options%optimize%mapping) 
    CASE ('uniform') 
      CALL UNIFORM_RR_PARAMETERS_GET_CONTROL_SIZE(options, nbk(1))
      CALL UNIFORM_RR_INITIAL_STATES_GET_CONTROL_SIZE(options, nbk(2))
    CASE ('distributed') 
      CALL DISTRIBUTED_RR_PARAMETERS_GET_CONTROL_SIZE(mesh, options, nbk&
&                                               (1))
      CALL DISTRIBUTED_RR_INITIAL_STATES_GET_CONTROL_SIZE(mesh, options&
&                                                   , nbk(2))
    CASE ('multi-linear') 
      CALL MULTI_LINEAR_RR_PARAMETERS_GET_CONTROL_SIZE(setup, options, &
&                                                nbk(1))
      CALL MULTI_LINEAR_RR_INITIAL_STATES_GET_CONTROL_SIZE(setup, &
&                                                    options, nbk(2))
    CASE ('multi-power') 
      CALL MULTI_POWER_RR_PARAMETERS_GET_CONTROL_SIZE(setup, options, &
&                                               nbk(1))
      CALL MULTI_POWER_RR_INITIAL_STATES_GET_CONTROL_SIZE(setup, options&
&                                                   , nbk(2))
    CASE ('ann') 
      nbk(1) = 0
      nbk(2) = 0
    END SELECT
! Directly working with hyper parameters
    CALL SERR_MU_PARAMETERS_GET_CONTROL_SIZE(options, nbk(3))
    CALL SERR_SIGMA_PARAMETERS_GET_CONTROL_SIZE(options, nbk(4))
    CALL NN_PARAMETERS_GET_CONTROL_SIZE(setup, options, nbk(5))
  END SUBROUTINE GET_CONTROL_SIZES

  SUBROUTINE UNIFORM_RR_PARAMETERS_FILL_CONTROL(setup, mesh, parameters&
&   , options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j
    LOGICAL, DIMENSION(mesh%nrow, mesh%ncol) :: ac_mask
    INTRINSIC SUM
    INTRINSIC TRIM
    ac_mask = mesh%active_cell(:, :) .EQ. 1
! RR parameters is first control kind
    j = 0
    DO i=1,setup%nrrp
      IF (options%optimize%rr_parameters(i) .NE. 0) THEN
        j = j + 1
        parameters%control%x(j) = SUM(parameters%rr_parameters%values(:&
&         , :, i), mask=ac_mask)/mesh%nac
        parameters%control%l(j) = options%optimize%l_rr_parameters(i)
        parameters%control%u(j) = options%optimize%u_rr_parameters(i)
        parameters%control%nbd(j) = 2
        parameters%control%name(j) = TRIM(parameters%rr_parameters%keys(&
&         i))//'-0'
      END IF
    END DO
  END SUBROUTINE UNIFORM_RR_PARAMETERS_FILL_CONTROL

  SUBROUTINE UNIFORM_RR_INITIAL_STATES_FILL_CONTROL(setup, mesh, &
&   parameters, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j
    LOGICAL, DIMENSION(mesh%nrow, mesh%ncol) :: ac_mask
    INTRINSIC SUM
    INTRINSIC TRIM
    ac_mask = mesh%active_cell(:, :) .EQ. 1
! RR initial states is second control kind
    j = parameters%control%nbk(1)
    DO i=1,setup%nrrs
      IF (options%optimize%rr_initial_states(i) .NE. 0) THEN
        j = j + 1
        parameters%control%x(j) = SUM(parameters%rr_initial_states%&
&         values(:, :, i), mask=ac_mask)/mesh%nac
        parameters%control%l(j) = options%optimize%l_rr_initial_states(i&
&         )
        parameters%control%u(j) = options%optimize%u_rr_initial_states(i&
&         )
        parameters%control%nbd(j) = 2
        parameters%control%name(j) = TRIM(parameters%rr_initial_states%&
&         keys(i))//'-0'
      END IF
    END DO
  END SUBROUTINE UNIFORM_RR_INITIAL_STATES_FILL_CONTROL

  SUBROUTINE DISTRIBUTED_RR_PARAMETERS_FILL_CONTROL(setup, mesh, &
&   parameters, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    CHARACTER(len=lchar) :: name
    INTEGER :: i, j, row, col
    INTRINSIC TRIM
! RR parameters is first control kind
    j = 0
    DO i=1,setup%nrrp
      IF (options%optimize%rr_parameters(i) .NE. 0) THEN
        DO col=1,mesh%ncol
          DO row=1,mesh%nrow
            IF (mesh%active_cell(row, col) .NE. 0) THEN
              j = j + 1
              parameters%control%x(j) = parameters%rr_parameters%values(&
&               row, col, i)
              parameters%control%l(j) = options%optimize%l_rr_parameters&
&               (i)
              parameters%control%u(j) = options%optimize%u_rr_parameters&
&               (i)
              parameters%control%nbd(j) = 2
              WRITE(name, '(a,a,i0,a,i0)') TRIM(parameters%rr_parameters&
&             %keys(i)), '-', row, '-', col
              parameters%control%name(j) = name
            END IF
          END DO
        END DO
      END IF
    END DO
  END SUBROUTINE DISTRIBUTED_RR_PARAMETERS_FILL_CONTROL

  SUBROUTINE DISTRIBUTED_RR_INITIAL_STATES_FILL_CONTROL(setup, mesh, &
&   parameters, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    CHARACTER(len=lchar) :: name
    INTEGER :: i, j, row, col
    INTRINSIC TRIM
! RR initial states is second control kind
    j = parameters%control%nbk(1)
    DO i=1,setup%nrrs
      IF (options%optimize%rr_initial_states(i) .NE. 0) THEN
        DO col=1,mesh%ncol
          DO row=1,mesh%nrow
            IF (mesh%active_cell(row, col) .NE. 0) THEN
              j = j + 1
              parameters%control%x(j) = parameters%rr_initial_states%&
&               values(row, col, i)
              parameters%control%l(j) = options%optimize%&
&               l_rr_initial_states(i)
              parameters%control%u(j) = options%optimize%&
&               u_rr_initial_states(i)
              parameters%control%nbd(j) = 2
              WRITE(name, '(a,a,i0,a,i0)') TRIM(parameters%&
&             rr_initial_states%keys(i)), '-', row, '-', col
              parameters%control%name(j) = name
            END IF
          END DO
        END DO
      END IF
    END DO
  END SUBROUTINE DISTRIBUTED_RR_INITIAL_STATES_FILL_CONTROL

  SUBROUTINE MULTI_LINEAR_RR_PARAMETERS_FILL_CONTROL(setup, mesh, &
&   parameters, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, k
    REAL(sp) :: y, l, u
    LOGICAL, DIMENSION(mesh%nrow, mesh%ncol) :: ac_mask
    INTRINSIC SUM
    INTRINSIC TRIM
    ac_mask = mesh%active_cell(:, :) .EQ. 1
! RR parameters is first control kind
    j = 0
    DO i=1,setup%nrrp
      IF (options%optimize%rr_parameters(i) .NE. 0) THEN
        j = j + 1
        y = SUM(parameters%rr_parameters%values(:, :, i), mask=ac_mask)/&
&         mesh%nac
        l = options%optimize%l_rr_parameters(i)
        u = options%optimize%u_rr_parameters(i)
        CALL INV_SCALED_SIGMOID(y, l, u, parameters%control%x(j))
        parameters%control%nbd(j) = 0
        parameters%control%name(j) = TRIM(parameters%rr_parameters%keys(&
&         i))//'-0'
        DO k=1,setup%nd
          IF (options%optimize%rr_parameters_descriptor(k, i) .NE. 0) &
&         THEN
            j = j + 1
            parameters%control%x(j) = 0._sp
            parameters%control%nbd(j) = 0
            parameters%control%name(j) = TRIM(parameters%rr_parameters%&
&             keys(i))//'-'//TRIM(setup%descriptor_name(k))//'-a'
          END IF
        END DO
      END IF
    END DO
  END SUBROUTINE MULTI_LINEAR_RR_PARAMETERS_FILL_CONTROL

  SUBROUTINE MULTI_LINEAR_RR_INITIAL_STATES_FILL_CONTROL(setup, mesh, &
&   parameters, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, k
    REAL(sp) :: y, l, u
    LOGICAL, DIMENSION(mesh%nrow, mesh%ncol) :: ac_mask
    INTRINSIC SUM
    INTRINSIC TRIM
    ac_mask = mesh%active_cell(:, :) .EQ. 1
! RR initial states is second control kind
    j = parameters%control%nbk(1)
    DO i=1,setup%nrrs
      IF (options%optimize%rr_initial_states(i) .NE. 0) THEN
        j = j + 1
        y = SUM(parameters%rr_initial_states%values(:, :, i), mask=&
&         ac_mask)/mesh%nac
        l = options%optimize%l_rr_initial_states(i)
        u = options%optimize%u_rr_initial_states(i)
        CALL INV_SCALED_SIGMOID(y, l, u, parameters%control%x(j))
        parameters%control%nbd(j) = 0
        parameters%control%name(j) = TRIM(parameters%rr_initial_states%&
&         keys(i))//'-0'
        DO k=1,setup%nd
          IF (options%optimize%rr_initial_states_descriptor(k, i) .NE. 0&
&         ) THEN
            j = j + 1
            parameters%control%x(j) = 0._sp
            parameters%control%nbd(j) = 0
            parameters%control%name(j) = TRIM(parameters%&
&             rr_initial_states%keys(i))//'-'//TRIM(setup%&
&             descriptor_name(k))//'-a'
          END IF
        END DO
      END IF
    END DO
  END SUBROUTINE MULTI_LINEAR_RR_INITIAL_STATES_FILL_CONTROL

  SUBROUTINE MULTI_POWER_RR_PARAMETERS_FILL_CONTROL(setup, mesh, &
&   parameters, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, k
    REAL(sp) :: y, l, u
    LOGICAL, DIMENSION(mesh%nrow, mesh%ncol) :: ac_mask
    INTRINSIC SUM
    INTRINSIC TRIM
    ac_mask = mesh%active_cell(:, :) .EQ. 1
! RR parameters is first control kind
    j = 0
    DO i=1,setup%nrrp
      IF (options%optimize%rr_parameters(i) .NE. 0) THEN
        j = j + 1
        y = SUM(parameters%rr_parameters%values(:, :, i), mask=ac_mask)/&
&         mesh%nac
        l = options%optimize%l_rr_parameters(i)
        u = options%optimize%u_rr_parameters(i)
        CALL INV_SCALED_SIGMOID(y, l, u, parameters%control%x(j))
        parameters%control%nbd(j) = 0
        parameters%control%name(j) = TRIM(parameters%rr_parameters%keys(&
&         i))//'-0'
        DO k=1,setup%nd
          IF (options%optimize%rr_parameters_descriptor(k, i) .NE. 0) &
&         THEN
            j = j + 2
            parameters%control%x(j-1) = 0._sp
            parameters%control%nbd(j-1) = 0
            parameters%control%name(j-1) = TRIM(parameters%rr_parameters&
&             %keys(i))//'-'//TRIM(setup%descriptor_name(k))//'-a'
            parameters%control%x(j) = 1._sp
            parameters%control%l(j) = 0.5_sp
            parameters%control%u(j) = 2._sp
            parameters%control%nbd(j) = 2
            parameters%control%name(j) = TRIM(parameters%rr_parameters%&
&             keys(i))//'-'//TRIM(setup%descriptor_name(k))//'-b'
          END IF
        END DO
      END IF
    END DO
  END SUBROUTINE MULTI_POWER_RR_PARAMETERS_FILL_CONTROL

  SUBROUTINE MULTI_POWER_RR_INITIAL_STATES_FILL_CONTROL(setup, mesh, &
&   parameters, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, k
    REAL(sp) :: y, l, u
    LOGICAL, DIMENSION(mesh%nrow, mesh%ncol) :: ac_mask
    INTRINSIC SUM
    INTRINSIC TRIM
    ac_mask = mesh%active_cell(:, :) .EQ. 1
! RR initial states is second control kind
    j = parameters%control%nbk(1)
    DO i=1,setup%nrrs
      IF (options%optimize%rr_initial_states(i) .NE. 0) THEN
        j = j + 1
        y = SUM(parameters%rr_initial_states%values(:, :, i), mask=&
&         ac_mask)/mesh%nac
        l = options%optimize%l_rr_initial_states(i)
        u = options%optimize%u_rr_initial_states(i)
        CALL INV_SCALED_SIGMOID(y, l, u, parameters%control%x(j))
        parameters%control%nbd(j) = 0
        parameters%control%name(j) = TRIM(parameters%rr_initial_states%&
&         keys(i))//'-0'
        DO k=1,setup%nd
          IF (options%optimize%rr_initial_states_descriptor(k, i) .NE. 0&
&         ) THEN
            j = j + 2
            parameters%control%x(j-1) = 0._sp
            parameters%control%nbd(j-1) = 0
            parameters%control%name(j-1) = TRIM(parameters%&
&             rr_initial_states%keys(i))//'-'//TRIM(setup%&
&             descriptor_name(k))//'-a'
            parameters%control%x(j) = 1._sp
            parameters%control%l(j) = 0.5_sp
            parameters%control%u(j) = 2._sp
            parameters%control%nbd(j) = 2
            parameters%control%name(j) = TRIM(parameters%&
&             rr_initial_states%keys(i))//'-'//TRIM(setup%&
&             descriptor_name(k))//'-b'
          END IF
        END DO
      END IF
    END DO
  END SUBROUTINE MULTI_POWER_RR_INITIAL_STATES_FILL_CONTROL

  SUBROUTINE SERR_MU_PARAMETERS_FILL_CONTROL(setup, mesh, parameters, &
&   options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, k
    INTRINSIC SUM
    INTRINSIC TRIM
! SErr mu parameters is third control kind
    j = SUM(parameters%control%nbk(1:2))
    DO i=1,setup%nsep_mu
      IF (options%optimize%serr_mu_parameters(i) .NE. 0) THEN
        DO k=1,mesh%ng
          IF (options%cost%gauge(k) .NE. 0) THEN
            j = j + 1
            parameters%control%x(j) = parameters%serr_mu_parameters%&
&             values(k, i)
            parameters%control%l(j) = options%optimize%&
&             l_serr_mu_parameters(i)
            parameters%control%u(j) = options%optimize%&
&             u_serr_mu_parameters(i)
            parameters%control%nbd(j) = 2
            parameters%control%name(j) = TRIM(parameters%&
&             serr_mu_parameters%keys(i))//'-'//TRIM(mesh%code(k))
          END IF
        END DO
      END IF
    END DO
  END SUBROUTINE SERR_MU_PARAMETERS_FILL_CONTROL

  SUBROUTINE SERR_SIGMA_PARAMETERS_FILL_CONTROL(setup, mesh, parameters&
&   , options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, k
    INTRINSIC SUM
    INTRINSIC TRIM
! SErr sigma parameters is fourth control kind
    j = SUM(parameters%control%nbk(1:3))
    DO i=1,setup%nsep_sigma
      IF (options%optimize%serr_sigma_parameters(i) .NE. 0) THEN
        DO k=1,mesh%ng
          IF (options%cost%gauge(k) .NE. 0) THEN
            j = j + 1
            parameters%control%x(j) = parameters%serr_sigma_parameters%&
&             values(k, i)
            parameters%control%l(j) = options%optimize%&
&             l_serr_sigma_parameters(i)
            parameters%control%u(j) = options%optimize%&
&             u_serr_sigma_parameters(i)
            parameters%control%nbd(j) = 2
            parameters%control%name(j) = TRIM(parameters%&
&             serr_sigma_parameters%keys(i))//'-'//TRIM(mesh%code(k))
          END IF
        END DO
      END IF
    END DO
  END SUBROUTINE SERR_SIGMA_PARAMETERS_FILL_CONTROL

  SUBROUTINE NN_PARAMETERS_FILL_CONTROL(setup, options, parameters)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    CHARACTER(len=lchar) :: name
    INTEGER :: j, k, l
    INTRINSIC SUM
! NN parameters is fifth control kind
    j = SUM(parameters%control%nbk(1:4))
    IF (options%optimize%nn_parameters(1) .EQ. 1) THEN
      DO k=1,setup%neurons(1)
        DO l=1,setup%neurons(2)
          j = j + 1
          parameters%control%x(j) = parameters%nn_parameters%weight_1(l&
&           , k)
          parameters%control%nbd(j) = 0
          WRITE(name, '(a,i0,a,i0)') 'weight_1-', l, '-', k
          parameters%control%name(j) = name
        END DO
      END DO
    END IF
    IF (options%optimize%nn_parameters(2) .EQ. 1) THEN
      DO k=1,setup%neurons(2)
        j = j + 1
        parameters%control%x(j) = parameters%nn_parameters%bias_1(k)
        parameters%control%nbd(j) = 0
        WRITE(name, '(a,i0)') 'bias_1-', k
        parameters%control%name(j) = name
      END DO
    END IF
    IF (options%optimize%nn_parameters(3) .EQ. 1) THEN
      DO k=1,setup%neurons(2)
        DO l=1,setup%neurons(3)
          j = j + 1
          parameters%control%x(j) = parameters%nn_parameters%weight_2(l&
&           , k)
          parameters%control%nbd(j) = 0
          WRITE(name, '(a,i0,a,i0)') 'weight_2-', l, '-', k
          parameters%control%name(j) = name
        END DO
      END DO
    END IF
    IF (options%optimize%nn_parameters(4) .EQ. 1) THEN
      DO k=1,setup%neurons(3)
        j = j + 1
        parameters%control%x(j) = parameters%nn_parameters%bias_2(k)
        parameters%control%nbd(j) = 0
        WRITE(name, '(a,i0)') 'bias_2-', k
        parameters%control%name(j) = name
      END DO
    END IF
    IF (options%optimize%nn_parameters(5) .EQ. 1) THEN
      DO k=1,setup%neurons(3)
        DO l=1,setup%neurons(4)
          j = j + 1
          parameters%control%x(j) = parameters%nn_parameters%weight_3(l&
&           , k)
          parameters%control%nbd(j) = 0
          WRITE(name, '(a,i0,a,i0)') 'weight_3-', l, '-', k
          parameters%control%name(j) = name
        END DO
      END DO
    END IF
    IF (options%optimize%nn_parameters(6) .EQ. 1) THEN
      DO k=1,setup%neurons(4)
        j = j + 1
        parameters%control%x(j) = parameters%nn_parameters%bias_3(k)
        parameters%control%nbd(j) = 0
        WRITE(name, '(a,i0)') 'bias_3-', k
        parameters%control%name(j) = name
      END DO
    END IF
  END SUBROUTINE NN_PARAMETERS_FILL_CONTROL

  SUBROUTINE FILL_CONTROL(setup, mesh, input_data, parameters, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    SELECT CASE  (options%optimize%mapping) 
    CASE ('uniform') 
      CALL UNIFORM_RR_PARAMETERS_FILL_CONTROL(setup, mesh, parameters, &
&                                       options)
      CALL UNIFORM_RR_INITIAL_STATES_FILL_CONTROL(setup, mesh, &
&                                           parameters, options)
    CASE ('distributed') 
      CALL DISTRIBUTED_RR_PARAMETERS_FILL_CONTROL(setup, mesh, &
&                                           parameters, options)
      CALL DISTRIBUTED_RR_INITIAL_STATES_FILL_CONTROL(setup, mesh, &
&                                               parameters, options)
    CASE ('multi-linear') 
      CALL MULTI_LINEAR_RR_PARAMETERS_FILL_CONTROL(setup, mesh, &
&                                            parameters, options)
      CALL MULTI_LINEAR_RR_INITIAL_STATES_FILL_CONTROL(setup, mesh, &
&                                                parameters, options)
    CASE ('multi-power') 
      CALL MULTI_POWER_RR_PARAMETERS_FILL_CONTROL(setup, mesh, &
&                                           parameters, options)
      CALL MULTI_POWER_RR_INITIAL_STATES_FILL_CONTROL(setup, mesh, &
&                                               parameters, options)
    END SELECT
! Directly working with hyper parameters
    CALL SERR_MU_PARAMETERS_FILL_CONTROL(setup, mesh, parameters, &
&                                  options)
    CALL SERR_SIGMA_PARAMETERS_FILL_CONTROL(setup, mesh, parameters, &
&                                     options)
    CALL NN_PARAMETERS_FILL_CONTROL(setup, options, parameters)
! Store raw control values
    parameters%control%x_raw = parameters%control%x
    parameters%control%l_raw = parameters%control%l
    parameters%control%u_raw = parameters%control%u
  END SUBROUTINE FILL_CONTROL

!  Differentiation of uniform_rr_parameters_fill_parameters in forward (tangent) mode (with options fixinterface noISIZE context)
!:
!   variations   of useful results: *(parameters.rr_parameters.values)
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_parameters.values)
!   Plus diff mem management of: parameters.control.x:in parameters.rr_parameters.values:in
  SUBROUTINE UNIFORM_RR_PARAMETERS_FILL_PARAMETERS_D(setup, mesh, &
&   parameters, parameters_d, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_d
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j
    LOGICAL, DIMENSION(mesh%nrow, mesh%ncol) :: ac_mask
    ac_mask = mesh%active_cell(:, :) .EQ. 1
! RR parameters is first control kind
    j = 0
    DO i=1,setup%nrrp
      IF (options%optimize%rr_parameters(i) .NE. 0) THEN
        j = j + 1
        WHERE (ac_mask) 
          parameters_d%rr_parameters%values(:, :, i) = parameters_d%&
&           control%x(j)
          parameters%rr_parameters%values(:, :, i) = parameters%control%&
&           x(j)
        END WHERE
      END IF
    END DO
  END SUBROUTINE UNIFORM_RR_PARAMETERS_FILL_PARAMETERS_D

!  Differentiation of uniform_rr_parameters_fill_parameters in reverse (adjoint) mode (with options fixinterface noISIZE context)
!:
!   gradient     of useful results: *(parameters.control.x) *(parameters.rr_parameters.values)
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_parameters.values)
!   Plus diff mem management of: parameters.control.x:in parameters.rr_parameters.values:in
  SUBROUTINE UNIFORM_RR_PARAMETERS_FILL_PARAMETERS_B(setup, mesh, &
&   parameters, parameters_b, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_b
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j
    LOGICAL, DIMENSION(mesh%nrow, mesh%ncol) :: ac_mask
    INTEGER :: branch
    ac_mask = mesh%active_cell(:, :) .EQ. 1
! RR parameters is first control kind
    j = 0
    DO i=1,setup%nrrp
      IF (options%optimize%rr_parameters(i) .EQ. 0) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHINTEGER4(j)
        j = j + 1
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    DO i=setup%nrrp,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        parameters_b%control%x(j) = parameters_b%control%x(j) + SUM(&
&         parameters_b%rr_parameters%values(:, :, i), MASK=ac_mask)
        CALL POPINTEGER4(j)
        WHERE (ac_mask) parameters_b%rr_parameters%values(:, :, i) = &
&           0.0_4
      END IF
    END DO
  END SUBROUTINE UNIFORM_RR_PARAMETERS_FILL_PARAMETERS_B

  SUBROUTINE UNIFORM_RR_PARAMETERS_FILL_PARAMETERS(setup, mesh, &
&   parameters, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j
    LOGICAL, DIMENSION(mesh%nrow, mesh%ncol) :: ac_mask
    ac_mask = mesh%active_cell(:, :) .EQ. 1
! RR parameters is first control kind
    j = 0
    DO i=1,setup%nrrp
      IF (options%optimize%rr_parameters(i) .NE. 0) THEN
        j = j + 1
        WHERE (ac_mask) parameters%rr_parameters%values(:, :, i) = &
&           parameters%control%x(j)
      END IF
    END DO
  END SUBROUTINE UNIFORM_RR_PARAMETERS_FILL_PARAMETERS

!  Differentiation of uniform_rr_initial_states_fill_parameters in forward (tangent) mode (with options fixinterface noISIZE cont
!ext):
!   variations   of useful results: *(parameters.rr_initial_states.values)
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_initial_states.values)
!   Plus diff mem management of: parameters.control.x:in parameters.rr_initial_states.values:in
  SUBROUTINE UNIFORM_RR_INITIAL_STATES_FILL_PARAMETERS_D(setup, mesh, &
&   parameters, parameters_d, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_d
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j
    LOGICAL, DIMENSION(mesh%nrow, mesh%ncol) :: ac_mask
    ac_mask = mesh%active_cell(:, :) .EQ. 1
! RR initial states is second control kind
    j = parameters%control%nbk(1)
    DO i=1,setup%nrrs
      IF (options%optimize%rr_initial_states(i) .NE. 0) THEN
        j = j + 1
        WHERE (ac_mask) 
          parameters_d%rr_initial_states%values(:, :, i) = parameters_d%&
&           control%x(j)
          parameters%rr_initial_states%values(:, :, i) = parameters%&
&           control%x(j)
        END WHERE
      END IF
    END DO
  END SUBROUTINE UNIFORM_RR_INITIAL_STATES_FILL_PARAMETERS_D

!  Differentiation of uniform_rr_initial_states_fill_parameters in reverse (adjoint) mode (with options fixinterface noISIZE cont
!ext):
!   gradient     of useful results: *(parameters.control.x) *(parameters.rr_initial_states.values)
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_initial_states.values)
!   Plus diff mem management of: parameters.control.x:in parameters.rr_initial_states.values:in
  SUBROUTINE UNIFORM_RR_INITIAL_STATES_FILL_PARAMETERS_B(setup, mesh, &
&   parameters, parameters_b, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_b
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j
    LOGICAL, DIMENSION(mesh%nrow, mesh%ncol) :: ac_mask
    INTEGER :: branch
    ac_mask = mesh%active_cell(:, :) .EQ. 1
! RR initial states is second control kind
    j = parameters%control%nbk(1)
    DO i=1,setup%nrrs
      IF (options%optimize%rr_initial_states(i) .EQ. 0) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHINTEGER4(j)
        j = j + 1
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    DO i=setup%nrrs,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        parameters_b%control%x(j) = parameters_b%control%x(j) + SUM(&
&         parameters_b%rr_initial_states%values(:, :, i), MASK=ac_mask)
        CALL POPINTEGER4(j)
        WHERE (ac_mask) parameters_b%rr_initial_states%values(:, :, i)&
&          = 0.0_4
      END IF
    END DO
  END SUBROUTINE UNIFORM_RR_INITIAL_STATES_FILL_PARAMETERS_B

  SUBROUTINE UNIFORM_RR_INITIAL_STATES_FILL_PARAMETERS(setup, mesh, &
&   parameters, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j
    LOGICAL, DIMENSION(mesh%nrow, mesh%ncol) :: ac_mask
    ac_mask = mesh%active_cell(:, :) .EQ. 1
! RR initial states is second control kind
    j = parameters%control%nbk(1)
    DO i=1,setup%nrrs
      IF (options%optimize%rr_initial_states(i) .NE. 0) THEN
        j = j + 1
        WHERE (ac_mask) parameters%rr_initial_states%values(:, :, i) = &
&           parameters%control%x(j)
      END IF
    END DO
  END SUBROUTINE UNIFORM_RR_INITIAL_STATES_FILL_PARAMETERS

!  Differentiation of distributed_rr_parameters_fill_parameters in forward (tangent) mode (with options fixinterface noISIZE cont
!ext):
!   variations   of useful results: *(parameters.rr_parameters.values)
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_parameters.values)
!   Plus diff mem management of: parameters.control.x:in parameters.rr_parameters.values:in
  SUBROUTINE DISTRIBUTED_RR_PARAMETERS_FILL_PARAMETERS_D(setup, mesh, &
&   parameters, parameters_d, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_d
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, row, col
! RR parameters is first control kind
    j = 0
    DO i=1,setup%nrrp
      IF (options%optimize%rr_parameters(i) .NE. 0) THEN
        DO col=1,mesh%ncol
          DO row=1,mesh%nrow
            IF (mesh%active_cell(row, col) .NE. 0) THEN
              j = j + 1
              parameters_d%rr_parameters%values(row, col, i) = &
&               parameters_d%control%x(j)
              parameters%rr_parameters%values(row, col, i) = parameters%&
&               control%x(j)
            END IF
          END DO
        END DO
      END IF
    END DO
  END SUBROUTINE DISTRIBUTED_RR_PARAMETERS_FILL_PARAMETERS_D

!  Differentiation of distributed_rr_parameters_fill_parameters in reverse (adjoint) mode (with options fixinterface noISIZE cont
!ext):
!   gradient     of useful results: *(parameters.control.x) *(parameters.rr_parameters.values)
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_parameters.values)
!   Plus diff mem management of: parameters.control.x:in parameters.rr_parameters.values:in
  SUBROUTINE DISTRIBUTED_RR_PARAMETERS_FILL_PARAMETERS_B(setup, mesh, &
&   parameters, parameters_b, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_b
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, row, col
    INTEGER :: branch
! RR parameters is first control kind
    j = 0
    DO i=1,setup%nrrp
      IF (options%optimize%rr_parameters(i) .EQ. 0) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        DO col=1,mesh%ncol
          DO row=1,mesh%nrow
            IF (mesh%active_cell(row, col) .EQ. 0) THEN
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHINTEGER4(j)
              j = j + 1
              CALL PUSHCONTROL1B(1)
            END IF
          END DO
        END DO
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    DO i=setup%nrrp,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        DO col=mesh%ncol,1,-1
          DO row=mesh%nrow,1,-1
            CALL POPCONTROL1B(branch)
            IF (branch .NE. 0) THEN
              parameters_b%control%x(j) = parameters_b%control%x(j) + &
&               parameters_b%rr_parameters%values(row, col, i)
              parameters_b%rr_parameters%values(row, col, i) = 0.0_4
              CALL POPINTEGER4(j)
            END IF
          END DO
        END DO
      END IF
    END DO
  END SUBROUTINE DISTRIBUTED_RR_PARAMETERS_FILL_PARAMETERS_B

  SUBROUTINE DISTRIBUTED_RR_PARAMETERS_FILL_PARAMETERS(setup, mesh, &
&   parameters, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, row, col
! RR parameters is first control kind
    j = 0
    DO i=1,setup%nrrp
      IF (options%optimize%rr_parameters(i) .NE. 0) THEN
        DO col=1,mesh%ncol
          DO row=1,mesh%nrow
            IF (mesh%active_cell(row, col) .NE. 0) THEN
              j = j + 1
              parameters%rr_parameters%values(row, col, i) = parameters%&
&               control%x(j)
            END IF
          END DO
        END DO
      END IF
    END DO
  END SUBROUTINE DISTRIBUTED_RR_PARAMETERS_FILL_PARAMETERS

!  Differentiation of distributed_rr_initial_states_fill_parameters in forward (tangent) mode (with options fixinterface noISIZE 
!context):
!   variations   of useful results: *(parameters.rr_initial_states.values)
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_initial_states.values)
!   Plus diff mem management of: parameters.control.x:in parameters.rr_initial_states.values:in
  SUBROUTINE DISTRIBUTED_RR_INITIAL_STATES_FILL_PARAMETERS_D(setup, mesh&
&   , parameters, parameters_d, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_d
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, row, col
! RR initial states is second control kind
    j = parameters%control%nbk(1)
    DO i=1,setup%nrrs
      IF (options%optimize%rr_initial_states(i) .NE. 0) THEN
        DO col=1,mesh%ncol
          DO row=1,mesh%nrow
            IF (mesh%active_cell(row, col) .NE. 0) THEN
              j = j + 1
              parameters_d%rr_initial_states%values(row, col, i) = &
&               parameters_d%control%x(j)
              parameters%rr_initial_states%values(row, col, i) = &
&               parameters%control%x(j)
            END IF
          END DO
        END DO
      END IF
    END DO
  END SUBROUTINE DISTRIBUTED_RR_INITIAL_STATES_FILL_PARAMETERS_D

!  Differentiation of distributed_rr_initial_states_fill_parameters in reverse (adjoint) mode (with options fixinterface noISIZE 
!context):
!   gradient     of useful results: *(parameters.control.x) *(parameters.rr_initial_states.values)
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_initial_states.values)
!   Plus diff mem management of: parameters.control.x:in parameters.rr_initial_states.values:in
  SUBROUTINE DISTRIBUTED_RR_INITIAL_STATES_FILL_PARAMETERS_B(setup, mesh&
&   , parameters, parameters_b, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_b
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, row, col
    INTEGER :: branch
! RR initial states is second control kind
    j = parameters%control%nbk(1)
    DO i=1,setup%nrrs
      IF (options%optimize%rr_initial_states(i) .EQ. 0) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        DO col=1,mesh%ncol
          DO row=1,mesh%nrow
            IF (mesh%active_cell(row, col) .EQ. 0) THEN
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHINTEGER4(j)
              j = j + 1
              CALL PUSHCONTROL1B(1)
            END IF
          END DO
        END DO
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    DO i=setup%nrrs,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        DO col=mesh%ncol,1,-1
          DO row=mesh%nrow,1,-1
            CALL POPCONTROL1B(branch)
            IF (branch .NE. 0) THEN
              parameters_b%control%x(j) = parameters_b%control%x(j) + &
&               parameters_b%rr_initial_states%values(row, col, i)
              parameters_b%rr_initial_states%values(row, col, i) = 0.0_4
              CALL POPINTEGER4(j)
            END IF
          END DO
        END DO
      END IF
    END DO
  END SUBROUTINE DISTRIBUTED_RR_INITIAL_STATES_FILL_PARAMETERS_B

  SUBROUTINE DISTRIBUTED_RR_INITIAL_STATES_FILL_PARAMETERS(setup, mesh, &
&   parameters, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, row, col
! RR initial states is second control kind
    j = parameters%control%nbk(1)
    DO i=1,setup%nrrs
      IF (options%optimize%rr_initial_states(i) .NE. 0) THEN
        DO col=1,mesh%ncol
          DO row=1,mesh%nrow
            IF (mesh%active_cell(row, col) .NE. 0) THEN
              j = j + 1
              parameters%rr_initial_states%values(row, col, i) = &
&               parameters%control%x(j)
            END IF
          END DO
        END DO
      END IF
    END DO
  END SUBROUTINE DISTRIBUTED_RR_INITIAL_STATES_FILL_PARAMETERS

!  Differentiation of multi_linear_rr_parameters_fill_parameters in forward (tangent) mode (with options fixinterface noISIZE con
!text):
!   variations   of useful results: *(parameters.rr_parameters.values)
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_parameters.values)
!   Plus diff mem management of: parameters.control.x:in parameters.rr_parameters.values:in
  SUBROUTINE MULTI_LINEAR_RR_PARAMETERS_FILL_PARAMETERS_D(setup, mesh, &
&   input_data, parameters, parameters_d, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_d
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, k
    REAL(sp) :: l, u
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: wa2d, norm_desc
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: wa2d_d
! RR parameters is first control kind
    j = 0
    DO i=1,setup%nrrp
      IF (options%optimize%rr_parameters(i) .NE. 0) THEN
        j = j + 1
        wa2d_d = parameters_d%control%x(j)
        wa2d = parameters%control%x(j)
        DO k=1,setup%nd
          IF (options%optimize%rr_parameters_descriptor(k, i) .NE. 0) &
&         THEN
            j = j + 1
            norm_desc = (input_data%physio_data%descriptor(:, :, k)-&
&             input_data%physio_data%l_descriptor(k))/(input_data%&
&             physio_data%u_descriptor(k)-input_data%physio_data%&
&             l_descriptor(k))
            wa2d_d = wa2d_d + norm_desc*parameters_d%control%x(j)
            wa2d = wa2d + parameters%control%x(j)*norm_desc
          END IF
        END DO
        l = options%optimize%l_rr_parameters(i)
        u = options%optimize%u_rr_parameters(i)
        CALL SCALED_SIGMOIDE2D_D(wa2d, wa2d_d, l, u, parameters%&
&                          rr_parameters%values(:, :, i), parameters_d%&
&                          rr_parameters%values(:, :, i))
      END IF
    END DO
  END SUBROUTINE MULTI_LINEAR_RR_PARAMETERS_FILL_PARAMETERS_D

!  Differentiation of multi_linear_rr_parameters_fill_parameters in reverse (adjoint) mode (with options fixinterface noISIZE con
!text):
!   gradient     of useful results: *(parameters.control.x) *(parameters.rr_parameters.values)
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_parameters.values)
!   Plus diff mem management of: parameters.control.x:in parameters.rr_parameters.values:in
  SUBROUTINE MULTI_LINEAR_RR_PARAMETERS_FILL_PARAMETERS_B(setup, mesh, &
&   input_data, parameters, parameters_b, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_b
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, k
    REAL(sp) :: l, u
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: wa2d, norm_desc
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: wa2d_b
    INTEGER :: branch
! RR parameters is first control kind
    j = 0
    DO i=1,setup%nrrp
      IF (options%optimize%rr_parameters(i) .EQ. 0) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHINTEGER4(j)
        j = j + 1
        CALL PUSHREAL4ARRAY(wa2d, mesh%nrow*mesh%ncol)
        wa2d = parameters%control%x(j)
        DO k=1,setup%nd
          IF (options%optimize%rr_parameters_descriptor(k, i) .EQ. 0) &
&         THEN
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHINTEGER4(j)
            j = j + 1
            norm_desc = (input_data%physio_data%descriptor(:, :, k)-&
&             input_data%physio_data%l_descriptor(k))/(input_data%&
&             physio_data%u_descriptor(k)-input_data%physio_data%&
&             l_descriptor(k))
            wa2d = wa2d + parameters%control%x(j)*norm_desc
            CALL PUSHCONTROL1B(1)
          END IF
        END DO
        l = options%optimize%l_rr_parameters(i)
        u = options%optimize%u_rr_parameters(i)
        CALL PUSHREAL4ARRAY(parameters%rr_parameters%values(:, :, i), &
&                     SIZE(parameters%rr_parameters%values, 1)*SIZE(&
&                     parameters%rr_parameters%values, 2))
        CALL SCALED_SIGMOIDE2D(wa2d, l, u, parameters%rr_parameters%&
&                        values(:, :, i))
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    DO i=setup%nrrp,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        l = options%optimize%l_rr_parameters(i)
        u = options%optimize%u_rr_parameters(i)
        CALL POPREAL4ARRAY(parameters%rr_parameters%values(:, :, i), &
&                    SIZE(parameters%rr_parameters%values, 1)*SIZE(&
&                    parameters%rr_parameters%values, 2))
        CALL SCALED_SIGMOIDE2D_B(wa2d, wa2d_b, l, u, parameters%&
&                          rr_parameters%values(:, :, i), parameters_b%&
&                          rr_parameters%values(:, :, i))
        parameters_b%rr_parameters%values(:, :, i) = 0.0_4
        DO k=setup%nd,1,-1
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) THEN
            norm_desc = (input_data%physio_data%descriptor(:, :, k)-&
&             input_data%physio_data%l_descriptor(k))/(input_data%&
&             physio_data%u_descriptor(k)-input_data%physio_data%&
&             l_descriptor(k))
            parameters_b%control%x(j) = parameters_b%control%x(j) + SUM(&
&             norm_desc*wa2d_b)
            CALL POPINTEGER4(j)
          END IF
        END DO
        CALL POPREAL4ARRAY(wa2d, mesh%nrow*mesh%ncol)
        parameters_b%control%x(j) = parameters_b%control%x(j) + SUM(&
&         wa2d_b)
        CALL POPINTEGER4(j)
      END IF
    END DO
  END SUBROUTINE MULTI_LINEAR_RR_PARAMETERS_FILL_PARAMETERS_B

  SUBROUTINE MULTI_LINEAR_RR_PARAMETERS_FILL_PARAMETERS(setup, mesh, &
&   input_data, parameters, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, k
    REAL(sp) :: l, u
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: wa2d, norm_desc
! RR parameters is first control kind
    j = 0
    DO i=1,setup%nrrp
      IF (options%optimize%rr_parameters(i) .NE. 0) THEN
        j = j + 1
        wa2d = parameters%control%x(j)
        DO k=1,setup%nd
          IF (options%optimize%rr_parameters_descriptor(k, i) .NE. 0) &
&         THEN
            j = j + 1
            norm_desc = (input_data%physio_data%descriptor(:, :, k)-&
&             input_data%physio_data%l_descriptor(k))/(input_data%&
&             physio_data%u_descriptor(k)-input_data%physio_data%&
&             l_descriptor(k))
            wa2d = wa2d + parameters%control%x(j)*norm_desc
          END IF
        END DO
        l = options%optimize%l_rr_parameters(i)
        u = options%optimize%u_rr_parameters(i)
        CALL SCALED_SIGMOIDE2D(wa2d, l, u, parameters%rr_parameters%&
&                        values(:, :, i))
      END IF
    END DO
  END SUBROUTINE MULTI_LINEAR_RR_PARAMETERS_FILL_PARAMETERS

!  Differentiation of multi_linear_rr_initial_states_fill_parameters in forward (tangent) mode (with options fixinterface noISIZE
! context):
!   variations   of useful results: *(parameters.rr_initial_states.values)
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_initial_states.values)
!   Plus diff mem management of: parameters.control.x:in parameters.rr_initial_states.values:in
  SUBROUTINE MULTI_LINEAR_RR_INITIAL_STATES_FILL_PARAMETERS_D(setup, &
&   mesh, input_data, parameters, parameters_d, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_d
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, k
    REAL(sp) :: l, u
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: wa2d, norm_desc
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: wa2d_d
! RR initial states is second control kind
    j = parameters%control%nbk(1)
    DO i=1,setup%nrrs
      IF (options%optimize%rr_initial_states(i) .NE. 0) THEN
        j = j + 1
        wa2d_d = parameters_d%control%x(j)
        wa2d = parameters%control%x(j)
        DO k=1,setup%nd
          IF (options%optimize%rr_initial_states_descriptor(k, i) .NE. 0&
&         ) THEN
            j = j + 1
            norm_desc = (input_data%physio_data%descriptor(:, :, k)-&
&             input_data%physio_data%l_descriptor(k))/(input_data%&
&             physio_data%u_descriptor(k)-input_data%physio_data%&
&             l_descriptor(k))
            wa2d_d = wa2d_d + norm_desc*parameters_d%control%x(j)
            wa2d = wa2d + parameters%control%x(j)*norm_desc
          END IF
        END DO
        l = options%optimize%l_rr_initial_states(i)
        u = options%optimize%u_rr_initial_states(i)
        CALL SCALED_SIGMOIDE2D_D(wa2d, wa2d_d, l, u, parameters%&
&                          rr_initial_states%values(:, :, i), &
&                          parameters_d%rr_initial_states%values(:, :, i&
&                          ))
      END IF
    END DO
  END SUBROUTINE MULTI_LINEAR_RR_INITIAL_STATES_FILL_PARAMETERS_D

!  Differentiation of multi_linear_rr_initial_states_fill_parameters in reverse (adjoint) mode (with options fixinterface noISIZE
! context):
!   gradient     of useful results: *(parameters.control.x) *(parameters.rr_initial_states.values)
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_initial_states.values)
!   Plus diff mem management of: parameters.control.x:in parameters.rr_initial_states.values:in
  SUBROUTINE MULTI_LINEAR_RR_INITIAL_STATES_FILL_PARAMETERS_B(setup, &
&   mesh, input_data, parameters, parameters_b, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_b
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, k
    REAL(sp) :: l, u
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: wa2d, norm_desc
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: wa2d_b
    INTEGER :: branch
! RR initial states is second control kind
    j = parameters%control%nbk(1)
    DO i=1,setup%nrrs
      IF (options%optimize%rr_initial_states(i) .EQ. 0) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHINTEGER4(j)
        j = j + 1
        CALL PUSHREAL4ARRAY(wa2d, mesh%nrow*mesh%ncol)
        wa2d = parameters%control%x(j)
        DO k=1,setup%nd
          IF (options%optimize%rr_initial_states_descriptor(k, i) .EQ. 0&
&         ) THEN
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHINTEGER4(j)
            j = j + 1
            norm_desc = (input_data%physio_data%descriptor(:, :, k)-&
&             input_data%physio_data%l_descriptor(k))/(input_data%&
&             physio_data%u_descriptor(k)-input_data%physio_data%&
&             l_descriptor(k))
            wa2d = wa2d + parameters%control%x(j)*norm_desc
            CALL PUSHCONTROL1B(1)
          END IF
        END DO
        l = options%optimize%l_rr_initial_states(i)
        u = options%optimize%u_rr_initial_states(i)
        CALL PUSHREAL4ARRAY(parameters%rr_initial_states%values(:, :, i)&
&                     , SIZE(parameters%rr_initial_states%values, 1)*&
&                     SIZE(parameters%rr_initial_states%values, 2))
        CALL SCALED_SIGMOIDE2D(wa2d, l, u, parameters%rr_initial_states%&
&                        values(:, :, i))
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    DO i=setup%nrrs,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        l = options%optimize%l_rr_initial_states(i)
        u = options%optimize%u_rr_initial_states(i)
        CALL POPREAL4ARRAY(parameters%rr_initial_states%values(:, :, i)&
&                    , SIZE(parameters%rr_initial_states%values, 1)*SIZE&
&                    (parameters%rr_initial_states%values, 2))
        CALL SCALED_SIGMOIDE2D_B(wa2d, wa2d_b, l, u, parameters%&
&                          rr_initial_states%values(:, :, i), &
&                          parameters_b%rr_initial_states%values(:, :, i&
&                          ))
        parameters_b%rr_initial_states%values(:, :, i) = 0.0_4
        DO k=setup%nd,1,-1
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) THEN
            norm_desc = (input_data%physio_data%descriptor(:, :, k)-&
&             input_data%physio_data%l_descriptor(k))/(input_data%&
&             physio_data%u_descriptor(k)-input_data%physio_data%&
&             l_descriptor(k))
            parameters_b%control%x(j) = parameters_b%control%x(j) + SUM(&
&             norm_desc*wa2d_b)
            CALL POPINTEGER4(j)
          END IF
        END DO
        CALL POPREAL4ARRAY(wa2d, mesh%nrow*mesh%ncol)
        parameters_b%control%x(j) = parameters_b%control%x(j) + SUM(&
&         wa2d_b)
        CALL POPINTEGER4(j)
      END IF
    END DO
  END SUBROUTINE MULTI_LINEAR_RR_INITIAL_STATES_FILL_PARAMETERS_B

  SUBROUTINE MULTI_LINEAR_RR_INITIAL_STATES_FILL_PARAMETERS(setup, mesh&
&   , input_data, parameters, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, k
    REAL(sp) :: l, u
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: wa2d, norm_desc
! RR initial states is second control kind
    j = parameters%control%nbk(1)
    DO i=1,setup%nrrs
      IF (options%optimize%rr_initial_states(i) .NE. 0) THEN
        j = j + 1
        wa2d = parameters%control%x(j)
        DO k=1,setup%nd
          IF (options%optimize%rr_initial_states_descriptor(k, i) .NE. 0&
&         ) THEN
            j = j + 1
            norm_desc = (input_data%physio_data%descriptor(:, :, k)-&
&             input_data%physio_data%l_descriptor(k))/(input_data%&
&             physio_data%u_descriptor(k)-input_data%physio_data%&
&             l_descriptor(k))
            wa2d = wa2d + parameters%control%x(j)*norm_desc
          END IF
        END DO
        l = options%optimize%l_rr_initial_states(i)
        u = options%optimize%u_rr_initial_states(i)
        CALL SCALED_SIGMOIDE2D(wa2d, l, u, parameters%rr_initial_states%&
&                        values(:, :, i))
      END IF
    END DO
  END SUBROUTINE MULTI_LINEAR_RR_INITIAL_STATES_FILL_PARAMETERS

!  Differentiation of multi_power_rr_parameters_fill_parameters in forward (tangent) mode (with options fixinterface noISIZE cont
!ext):
!   variations   of useful results: *(parameters.rr_parameters.values)
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_parameters.values)
!   Plus diff mem management of: parameters.control.x:in parameters.rr_parameters.values:in
  SUBROUTINE MULTI_POWER_RR_PARAMETERS_FILL_PARAMETERS_D(setup, mesh, &
&   input_data, parameters, parameters_d, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_d
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, k
    REAL(sp) :: l, u
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: wa2d, norm_desc
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: wa2d_d, norm_desc_d
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: temp
! RR parameters is first control kind
    j = 0
    DO i=1,setup%nrrp
      IF (options%optimize%rr_parameters(i) .NE. 0) THEN
        j = j + 1
        wa2d_d = parameters_d%control%x(j)
        wa2d = parameters%control%x(j)
        DO k=1,setup%nd
          IF (options%optimize%rr_parameters_descriptor(k, i) .NE. 0) &
&         THEN
            j = j + 2
            norm_desc = (input_data%physio_data%descriptor(:, :, k)-&
&             input_data%physio_data%l_descriptor(k))/(input_data%&
&             physio_data%u_descriptor(k)-input_data%physio_data%&
&             l_descriptor(k))
            temp = norm_desc**parameters%control%x(j)
            WHERE (norm_desc .LE. 0.0) 
              norm_desc_d = 0.0_4
            ELSEWHERE
              norm_desc_d = temp*LOG(norm_desc)*parameters_d%control%x(j&
&               )
            END WHERE
            norm_desc = temp
            wa2d_d = wa2d_d + norm_desc*parameters_d%control%x(j-1) + &
&             parameters%control%x(j-1)*norm_desc_d
            wa2d = wa2d + parameters%control%x(j-1)*norm_desc
          END IF
        END DO
        l = options%optimize%l_rr_parameters(i)
        u = options%optimize%u_rr_parameters(i)
        CALL SCALED_SIGMOIDE2D_D(wa2d, wa2d_d, l, u, parameters%&
&                          rr_parameters%values(:, :, i), parameters_d%&
&                          rr_parameters%values(:, :, i))
      END IF
    END DO
  END SUBROUTINE MULTI_POWER_RR_PARAMETERS_FILL_PARAMETERS_D

!  Differentiation of multi_power_rr_parameters_fill_parameters in reverse (adjoint) mode (with options fixinterface noISIZE cont
!ext):
!   gradient     of useful results: *(parameters.control.x) *(parameters.rr_parameters.values)
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_parameters.values)
!   Plus diff mem management of: parameters.control.x:in parameters.rr_parameters.values:in
  SUBROUTINE MULTI_POWER_RR_PARAMETERS_FILL_PARAMETERS_B(setup, mesh, &
&   input_data, parameters, parameters_b, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_b
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, k
    REAL(sp) :: l, u
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: wa2d, norm_desc
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: wa2d_b, norm_desc_b
    INTEGER :: branch
! RR parameters is first control kind
    j = 0
    DO i=1,setup%nrrp
      IF (options%optimize%rr_parameters(i) .EQ. 0) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHINTEGER4(j)
        j = j + 1
        CALL PUSHREAL4ARRAY(wa2d, mesh%nrow*mesh%ncol)
        wa2d = parameters%control%x(j)
        DO k=1,setup%nd
          IF (options%optimize%rr_parameters_descriptor(k, i) .EQ. 0) &
&         THEN
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHINTEGER4(j)
            j = j + 2
            CALL PUSHREAL4ARRAY(norm_desc, mesh%nrow*mesh%ncol)
            norm_desc = (input_data%physio_data%descriptor(:, :, k)-&
&             input_data%physio_data%l_descriptor(k))/(input_data%&
&             physio_data%u_descriptor(k)-input_data%physio_data%&
&             l_descriptor(k))
            CALL PUSHREAL4ARRAY(norm_desc, mesh%nrow*mesh%ncol)
            norm_desc = norm_desc**parameters%control%x(j)
            wa2d = wa2d + parameters%control%x(j-1)*norm_desc
            CALL PUSHCONTROL1B(1)
          END IF
        END DO
        l = options%optimize%l_rr_parameters(i)
        u = options%optimize%u_rr_parameters(i)
        CALL PUSHREAL4ARRAY(parameters%rr_parameters%values(:, :, i), &
&                     SIZE(parameters%rr_parameters%values, 1)*SIZE(&
&                     parameters%rr_parameters%values, 2))
        CALL SCALED_SIGMOIDE2D(wa2d, l, u, parameters%rr_parameters%&
&                        values(:, :, i))
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    DO i=setup%nrrp,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        l = options%optimize%l_rr_parameters(i)
        u = options%optimize%u_rr_parameters(i)
        CALL POPREAL4ARRAY(parameters%rr_parameters%values(:, :, i), &
&                    SIZE(parameters%rr_parameters%values, 1)*SIZE(&
&                    parameters%rr_parameters%values, 2))
        CALL SCALED_SIGMOIDE2D_B(wa2d, wa2d_b, l, u, parameters%&
&                          rr_parameters%values(:, :, i), parameters_b%&
&                          rr_parameters%values(:, :, i))
        parameters_b%rr_parameters%values(:, :, i) = 0.0_4
        DO k=setup%nd,1,-1
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) THEN
            norm_desc_b = 0.0_4
            parameters_b%control%x(j-1) = parameters_b%control%x(j-1) + &
&             SUM(norm_desc*wa2d_b)
            norm_desc_b = parameters%control%x(j-1)*wa2d_b
            CALL POPREAL4ARRAY(norm_desc, mesh%nrow*mesh%ncol)
            parameters_b%control%x(j) = parameters_b%control%x(j) + SUM(&
&             norm_desc**parameters%control%x(j)*LOG(norm_desc)*&
&             norm_desc_b, MASK=.NOT.norm_desc.LE.0.0)
            CALL POPREAL4ARRAY(norm_desc, mesh%nrow*mesh%ncol)
            CALL POPINTEGER4(j)
          END IF
        END DO
        CALL POPREAL4ARRAY(wa2d, mesh%nrow*mesh%ncol)
        parameters_b%control%x(j) = parameters_b%control%x(j) + SUM(&
&         wa2d_b)
        CALL POPINTEGER4(j)
      END IF
    END DO
  END SUBROUTINE MULTI_POWER_RR_PARAMETERS_FILL_PARAMETERS_B

  SUBROUTINE MULTI_POWER_RR_PARAMETERS_FILL_PARAMETERS(setup, mesh, &
&   input_data, parameters, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, k
    REAL(sp) :: l, u
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: wa2d, norm_desc
! RR parameters is first control kind
    j = 0
    DO i=1,setup%nrrp
      IF (options%optimize%rr_parameters(i) .NE. 0) THEN
        j = j + 1
        wa2d = parameters%control%x(j)
        DO k=1,setup%nd
          IF (options%optimize%rr_parameters_descriptor(k, i) .NE. 0) &
&         THEN
            j = j + 2
            norm_desc = (input_data%physio_data%descriptor(:, :, k)-&
&             input_data%physio_data%l_descriptor(k))/(input_data%&
&             physio_data%u_descriptor(k)-input_data%physio_data%&
&             l_descriptor(k))
            norm_desc = norm_desc**parameters%control%x(j)
            wa2d = wa2d + parameters%control%x(j-1)*norm_desc
          END IF
        END DO
        l = options%optimize%l_rr_parameters(i)
        u = options%optimize%u_rr_parameters(i)
        CALL SCALED_SIGMOIDE2D(wa2d, l, u, parameters%rr_parameters%&
&                        values(:, :, i))
      END IF
    END DO
  END SUBROUTINE MULTI_POWER_RR_PARAMETERS_FILL_PARAMETERS

!  Differentiation of multi_power_rr_initial_states_fill_parameters in forward (tangent) mode (with options fixinterface noISIZE 
!context):
!   variations   of useful results: *(parameters.rr_initial_states.values)
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_initial_states.values)
!   Plus diff mem management of: parameters.control.x:in parameters.rr_initial_states.values:in
  SUBROUTINE MULTI_POWER_RR_INITIAL_STATES_FILL_PARAMETERS_D(setup, mesh&
&   , input_data, parameters, parameters_d, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_d
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, k
    REAL(sp) :: l, u
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: wa2d, norm_desc
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: wa2d_d, norm_desc_d
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: temp
! RR initial states is second control kind
    j = parameters%control%nbk(1)
    DO i=1,setup%nrrs
      IF (options%optimize%rr_initial_states(i) .NE. 0) THEN
        j = j + 1
        wa2d_d = parameters_d%control%x(j)
        wa2d = parameters%control%x(j)
        DO k=1,setup%nd
          IF (options%optimize%rr_initial_states_descriptor(k, i) .NE. 0&
&         ) THEN
            j = j + 2
            norm_desc = (input_data%physio_data%descriptor(:, :, k)-&
&             input_data%physio_data%l_descriptor(k))/(input_data%&
&             physio_data%u_descriptor(k)-input_data%physio_data%&
&             l_descriptor(k))
            temp = norm_desc**parameters%control%x(j)
            WHERE (norm_desc .LE. 0.0) 
              norm_desc_d = 0.0_4
            ELSEWHERE
              norm_desc_d = temp*LOG(norm_desc)*parameters_d%control%x(j&
&               )
            END WHERE
            norm_desc = temp
            wa2d_d = wa2d_d + norm_desc*parameters_d%control%x(j-1) + &
&             parameters%control%x(j-1)*norm_desc_d
            wa2d = wa2d + parameters%control%x(j-1)*norm_desc
          END IF
        END DO
        l = options%optimize%l_rr_parameters(i)
        u = options%optimize%u_rr_parameters(i)
        CALL SCALED_SIGMOIDE2D_D(wa2d, wa2d_d, l, u, parameters%&
&                          rr_initial_states%values(:, :, i), &
&                          parameters_d%rr_initial_states%values(:, :, i&
&                          ))
      END IF
    END DO
  END SUBROUTINE MULTI_POWER_RR_INITIAL_STATES_FILL_PARAMETERS_D

!  Differentiation of multi_power_rr_initial_states_fill_parameters in reverse (adjoint) mode (with options fixinterface noISIZE 
!context):
!   gradient     of useful results: *(parameters.control.x) *(parameters.rr_initial_states.values)
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_initial_states.values)
!   Plus diff mem management of: parameters.control.x:in parameters.rr_initial_states.values:in
  SUBROUTINE MULTI_POWER_RR_INITIAL_STATES_FILL_PARAMETERS_B(setup, mesh&
&   , input_data, parameters, parameters_b, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_b
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, k
    REAL(sp) :: l, u
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: wa2d, norm_desc
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: wa2d_b, norm_desc_b
    INTEGER :: branch
! RR initial states is second control kind
    j = parameters%control%nbk(1)
    DO i=1,setup%nrrs
      IF (options%optimize%rr_initial_states(i) .EQ. 0) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHINTEGER4(j)
        j = j + 1
        CALL PUSHREAL4ARRAY(wa2d, mesh%nrow*mesh%ncol)
        wa2d = parameters%control%x(j)
        DO k=1,setup%nd
          IF (options%optimize%rr_initial_states_descriptor(k, i) .EQ. 0&
&         ) THEN
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHINTEGER4(j)
            j = j + 2
            CALL PUSHREAL4ARRAY(norm_desc, mesh%nrow*mesh%ncol)
            norm_desc = (input_data%physio_data%descriptor(:, :, k)-&
&             input_data%physio_data%l_descriptor(k))/(input_data%&
&             physio_data%u_descriptor(k)-input_data%physio_data%&
&             l_descriptor(k))
            CALL PUSHREAL4ARRAY(norm_desc, mesh%nrow*mesh%ncol)
            norm_desc = norm_desc**parameters%control%x(j)
            wa2d = wa2d + parameters%control%x(j-1)*norm_desc
            CALL PUSHCONTROL1B(1)
          END IF
        END DO
        l = options%optimize%l_rr_parameters(i)
        u = options%optimize%u_rr_parameters(i)
        CALL PUSHREAL4ARRAY(parameters%rr_initial_states%values(:, :, i)&
&                     , SIZE(parameters%rr_initial_states%values, 1)*&
&                     SIZE(parameters%rr_initial_states%values, 2))
        CALL SCALED_SIGMOIDE2D(wa2d, l, u, parameters%rr_initial_states%&
&                        values(:, :, i))
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    DO i=setup%nrrs,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        l = options%optimize%l_rr_parameters(i)
        u = options%optimize%u_rr_parameters(i)
        CALL POPREAL4ARRAY(parameters%rr_initial_states%values(:, :, i)&
&                    , SIZE(parameters%rr_initial_states%values, 1)*SIZE&
&                    (parameters%rr_initial_states%values, 2))
        CALL SCALED_SIGMOIDE2D_B(wa2d, wa2d_b, l, u, parameters%&
&                          rr_initial_states%values(:, :, i), &
&                          parameters_b%rr_initial_states%values(:, :, i&
&                          ))
        parameters_b%rr_initial_states%values(:, :, i) = 0.0_4
        DO k=setup%nd,1,-1
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) THEN
            norm_desc_b = 0.0_4
            parameters_b%control%x(j-1) = parameters_b%control%x(j-1) + &
&             SUM(norm_desc*wa2d_b)
            norm_desc_b = parameters%control%x(j-1)*wa2d_b
            CALL POPREAL4ARRAY(norm_desc, mesh%nrow*mesh%ncol)
            parameters_b%control%x(j) = parameters_b%control%x(j) + SUM(&
&             norm_desc**parameters%control%x(j)*LOG(norm_desc)*&
&             norm_desc_b, MASK=.NOT.norm_desc.LE.0.0)
            CALL POPREAL4ARRAY(norm_desc, mesh%nrow*mesh%ncol)
            CALL POPINTEGER4(j)
          END IF
        END DO
        CALL POPREAL4ARRAY(wa2d, mesh%nrow*mesh%ncol)
        parameters_b%control%x(j) = parameters_b%control%x(j) + SUM(&
&         wa2d_b)
        CALL POPINTEGER4(j)
      END IF
    END DO
  END SUBROUTINE MULTI_POWER_RR_INITIAL_STATES_FILL_PARAMETERS_B

  SUBROUTINE MULTI_POWER_RR_INITIAL_STATES_FILL_PARAMETERS(setup, mesh, &
&   input_data, parameters, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, k
    REAL(sp) :: l, u
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: wa2d, norm_desc
! RR initial states is second control kind
    j = parameters%control%nbk(1)
    DO i=1,setup%nrrs
      IF (options%optimize%rr_initial_states(i) .NE. 0) THEN
        j = j + 1
        wa2d = parameters%control%x(j)
        DO k=1,setup%nd
          IF (options%optimize%rr_initial_states_descriptor(k, i) .NE. 0&
&         ) THEN
            j = j + 2
            norm_desc = (input_data%physio_data%descriptor(:, :, k)-&
&             input_data%physio_data%l_descriptor(k))/(input_data%&
&             physio_data%u_descriptor(k)-input_data%physio_data%&
&             l_descriptor(k))
            norm_desc = norm_desc**parameters%control%x(j)
            wa2d = wa2d + parameters%control%x(j-1)*norm_desc
          END IF
        END DO
        l = options%optimize%l_rr_parameters(i)
        u = options%optimize%u_rr_parameters(i)
        CALL SCALED_SIGMOIDE2D(wa2d, l, u, parameters%rr_initial_states%&
&                        values(:, :, i))
      END IF
    END DO
  END SUBROUTINE MULTI_POWER_RR_INITIAL_STATES_FILL_PARAMETERS

!  Differentiation of serr_mu_parameters_fill_parameters in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: *(parameters.serr_mu_parameters.values)
!   with respect to varying inputs: *(parameters.control.x)
!   Plus diff mem management of: parameters.control.x:in parameters.serr_mu_parameters.values:in
  SUBROUTINE SERR_MU_PARAMETERS_FILL_PARAMETERS_D(setup, mesh, &
&   parameters, parameters_d, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_d
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, k
    INTRINSIC SUM
! SErr mu parameters is third control kind
    j = SUM(parameters%control%nbk(1:2))
    parameters_d%serr_mu_parameters%values = 0.0_4
    DO i=1,setup%nsep_mu
      IF (options%optimize%serr_mu_parameters(i) .NE. 0) THEN
        DO k=1,mesh%ng
          IF (options%cost%gauge(k) .NE. 0) THEN
            j = j + 1
            parameters_d%serr_mu_parameters%values(k, i) = parameters_d%&
&             control%x(j)
            parameters%serr_mu_parameters%values(k, i) = parameters%&
&             control%x(j)
          END IF
        END DO
      END IF
    END DO
  END SUBROUTINE SERR_MU_PARAMETERS_FILL_PARAMETERS_D

!  Differentiation of serr_mu_parameters_fill_parameters in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: *(parameters.control.x) *(parameters.serr_mu_parameters.values)
!   with respect to varying inputs: *(parameters.control.x)
!   Plus diff mem management of: parameters.control.x:in parameters.serr_mu_parameters.values:in
  SUBROUTINE SERR_MU_PARAMETERS_FILL_PARAMETERS_B(setup, mesh, &
&   parameters, parameters_b, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_b
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, k
    INTRINSIC SUM
    INTEGER :: branch
! SErr mu parameters is third control kind
    j = SUM(parameters%control%nbk(1:2))
    DO i=1,setup%nsep_mu
      IF (options%optimize%serr_mu_parameters(i) .EQ. 0) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        DO k=1,mesh%ng
          IF (options%cost%gauge(k) .EQ. 0) THEN
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHINTEGER4(j)
            j = j + 1
            CALL PUSHCONTROL1B(1)
          END IF
        END DO
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    DO i=setup%nsep_mu,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        DO k=mesh%ng,1,-1
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) THEN
            parameters_b%control%x(j) = parameters_b%control%x(j) + &
&             parameters_b%serr_mu_parameters%values(k, i)
            parameters_b%serr_mu_parameters%values(k, i) = 0.0_4
            CALL POPINTEGER4(j)
          END IF
        END DO
      END IF
    END DO
  END SUBROUTINE SERR_MU_PARAMETERS_FILL_PARAMETERS_B

  SUBROUTINE SERR_MU_PARAMETERS_FILL_PARAMETERS(setup, mesh, parameters&
&   , options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, k
    INTRINSIC SUM
! SErr mu parameters is third control kind
    j = SUM(parameters%control%nbk(1:2))
    DO i=1,setup%nsep_mu
      IF (options%optimize%serr_mu_parameters(i) .NE. 0) THEN
        DO k=1,mesh%ng
          IF (options%cost%gauge(k) .NE. 0) THEN
            j = j + 1
            parameters%serr_mu_parameters%values(k, i) = parameters%&
&             control%x(j)
          END IF
        END DO
      END IF
    END DO
  END SUBROUTINE SERR_MU_PARAMETERS_FILL_PARAMETERS

!  Differentiation of serr_sigma_parameters_fill_parameters in forward (tangent) mode (with options fixinterface noISIZE context)
!:
!   variations   of useful results: *(parameters.serr_sigma_parameters.values)
!   with respect to varying inputs: *(parameters.control.x)
!   Plus diff mem management of: parameters.control.x:in parameters.serr_sigma_parameters.values:in
  SUBROUTINE SERR_SIGMA_PARAMETERS_FILL_PARAMETERS_D(setup, mesh, &
&   parameters, parameters_d, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_d
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, k
    INTRINSIC SUM
! SErr mu parameters is fourth control kind
    j = SUM(parameters%control%nbk(1:3))
    parameters_d%serr_sigma_parameters%values = 0.0_4
    DO i=1,setup%nsep_sigma
      IF (options%optimize%serr_sigma_parameters(i) .NE. 0) THEN
        DO k=1,mesh%ng
          IF (options%cost%gauge(k) .NE. 0) THEN
            j = j + 1
            parameters_d%serr_sigma_parameters%values(k, i) = &
&             parameters_d%control%x(j)
            parameters%serr_sigma_parameters%values(k, i) = parameters%&
&             control%x(j)
          END IF
        END DO
      END IF
    END DO
  END SUBROUTINE SERR_SIGMA_PARAMETERS_FILL_PARAMETERS_D

!  Differentiation of serr_sigma_parameters_fill_parameters in reverse (adjoint) mode (with options fixinterface noISIZE context)
!:
!   gradient     of useful results: *(parameters.control.x) *(parameters.serr_sigma_parameters.values)
!   with respect to varying inputs: *(parameters.control.x)
!   Plus diff mem management of: parameters.control.x:in parameters.serr_sigma_parameters.values:in
  SUBROUTINE SERR_SIGMA_PARAMETERS_FILL_PARAMETERS_B(setup, mesh, &
&   parameters, parameters_b, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_b
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, k
    INTRINSIC SUM
    INTEGER :: branch
! SErr mu parameters is fourth control kind
    j = SUM(parameters%control%nbk(1:3))
    DO i=1,setup%nsep_sigma
      IF (options%optimize%serr_sigma_parameters(i) .EQ. 0) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        DO k=1,mesh%ng
          IF (options%cost%gauge(k) .EQ. 0) THEN
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHINTEGER4(j)
            j = j + 1
            CALL PUSHCONTROL1B(1)
          END IF
        END DO
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    DO i=setup%nsep_sigma,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        DO k=mesh%ng,1,-1
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) THEN
            parameters_b%control%x(j) = parameters_b%control%x(j) + &
&             parameters_b%serr_sigma_parameters%values(k, i)
            parameters_b%serr_sigma_parameters%values(k, i) = 0.0_4
            CALL POPINTEGER4(j)
          END IF
        END DO
      END IF
    END DO
  END SUBROUTINE SERR_SIGMA_PARAMETERS_FILL_PARAMETERS_B

  SUBROUTINE SERR_SIGMA_PARAMETERS_FILL_PARAMETERS(setup, mesh, &
&   parameters, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: i, j, k
    INTRINSIC SUM
! SErr mu parameters is fourth control kind
    j = SUM(parameters%control%nbk(1:3))
    DO i=1,setup%nsep_sigma
      IF (options%optimize%serr_sigma_parameters(i) .NE. 0) THEN
        DO k=1,mesh%ng
          IF (options%cost%gauge(k) .NE. 0) THEN
            j = j + 1
            parameters%serr_sigma_parameters%values(k, i) = parameters%&
&             control%x(j)
          END IF
        END DO
      END IF
    END DO
  END SUBROUTINE SERR_SIGMA_PARAMETERS_FILL_PARAMETERS

!  Differentiation of nn_parameters_fill_parameters in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: *(parameters.nn_parameters.weight_1)
!                *(parameters.nn_parameters.bias_1) *(parameters.nn_parameters.weight_2)
!                *(parameters.nn_parameters.bias_2) *(parameters.nn_parameters.weight_3)
!                *(parameters.nn_parameters.bias_3)
!   with respect to varying inputs: *(parameters.control.x)
!   Plus diff mem management of: parameters.control.x:in parameters.nn_parameters.weight_1:in
!                parameters.nn_parameters.bias_1:in parameters.nn_parameters.weight_2:in
!                parameters.nn_parameters.bias_2:in parameters.nn_parameters.weight_3:in
!                parameters.nn_parameters.bias_3:in
  SUBROUTINE NN_PARAMETERS_FILL_PARAMETERS_D(setup, options, parameters&
&   , parameters_d)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_d
    INTEGER :: j, k, l
    INTRINSIC SUM
! NN parameters is fifth control kind
    j = SUM(parameters%control%nbk(1:4))
    IF (options%optimize%nn_parameters(1) .EQ. 1) THEN
      parameters_d%nn_parameters%weight_1 = 0.0_4
      DO k=1,setup%neurons(1)
        DO l=1,setup%neurons(2)
          j = j + 1
          parameters_d%nn_parameters%weight_1(l, k) = parameters_d%&
&           control%x(j)
          parameters%nn_parameters%weight_1(l, k) = parameters%control%x&
&           (j)
        END DO
      END DO
    ELSE
      parameters_d%nn_parameters%weight_1 = 0.0_4
    END IF
    IF (options%optimize%nn_parameters(2) .EQ. 1) THEN
      parameters_d%nn_parameters%bias_1 = 0.0_4
      DO k=1,setup%neurons(2)
        j = j + 1
        parameters_d%nn_parameters%bias_1(k) = parameters_d%control%x(j)
        parameters%nn_parameters%bias_1(k) = parameters%control%x(j)
      END DO
    ELSE
      parameters_d%nn_parameters%bias_1 = 0.0_4
    END IF
    IF (options%optimize%nn_parameters(3) .EQ. 1) THEN
      parameters_d%nn_parameters%weight_2 = 0.0_4
      DO k=1,setup%neurons(2)
        DO l=1,setup%neurons(3)
          j = j + 1
          parameters_d%nn_parameters%weight_2(l, k) = parameters_d%&
&           control%x(j)
          parameters%nn_parameters%weight_2(l, k) = parameters%control%x&
&           (j)
        END DO
      END DO
    ELSE
      parameters_d%nn_parameters%weight_2 = 0.0_4
    END IF
    IF (options%optimize%nn_parameters(4) .EQ. 1) THEN
      parameters_d%nn_parameters%bias_2 = 0.0_4
      DO k=1,setup%neurons(3)
        j = j + 1
        parameters_d%nn_parameters%bias_2(k) = parameters_d%control%x(j)
        parameters%nn_parameters%bias_2(k) = parameters%control%x(j)
      END DO
    ELSE
      parameters_d%nn_parameters%bias_2 = 0.0_4
    END IF
    IF (options%optimize%nn_parameters(5) .EQ. 1) THEN
      parameters_d%nn_parameters%weight_3 = 0.0_4
      DO k=1,setup%neurons(3)
        DO l=1,setup%neurons(4)
          j = j + 1
          parameters_d%nn_parameters%weight_3(l, k) = parameters_d%&
&           control%x(j)
          parameters%nn_parameters%weight_3(l, k) = parameters%control%x&
&           (j)
        END DO
      END DO
    ELSE
      parameters_d%nn_parameters%weight_3 = 0.0_4
    END IF
    IF (options%optimize%nn_parameters(6) .EQ. 1) THEN
      parameters_d%nn_parameters%bias_3 = 0.0_4
      DO k=1,setup%neurons(4)
        j = j + 1
        parameters_d%nn_parameters%bias_3(k) = parameters_d%control%x(j)
        parameters%nn_parameters%bias_3(k) = parameters%control%x(j)
      END DO
    ELSE
      parameters_d%nn_parameters%bias_3 = 0.0_4
    END IF
  END SUBROUTINE NN_PARAMETERS_FILL_PARAMETERS_D

!  Differentiation of nn_parameters_fill_parameters in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: *(parameters.control.x) *(parameters.nn_parameters.weight_1)
!                *(parameters.nn_parameters.bias_1) *(parameters.nn_parameters.weight_2)
!                *(parameters.nn_parameters.bias_2) *(parameters.nn_parameters.weight_3)
!                *(parameters.nn_parameters.bias_3)
!   with respect to varying inputs: *(parameters.control.x)
!   Plus diff mem management of: parameters.control.x:in parameters.nn_parameters.weight_1:in
!                parameters.nn_parameters.bias_1:in parameters.nn_parameters.weight_2:in
!                parameters.nn_parameters.bias_2:in parameters.nn_parameters.weight_3:in
!                parameters.nn_parameters.bias_3:in
  SUBROUTINE NN_PARAMETERS_FILL_PARAMETERS_B(setup, options, parameters&
&   , parameters_b)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_b
    INTEGER :: j, k, l
    INTRINSIC SUM
    INTEGER :: branch
! NN parameters is fifth control kind
    j = SUM(parameters%control%nbk(1:4))
    IF (options%optimize%nn_parameters(1) .EQ. 1) THEN
      DO k=1,setup%neurons(1)
        DO l=1,setup%neurons(2)
          CALL PUSHINTEGER4(j)
          j = j + 1
        END DO
      END DO
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHCONTROL1B(1)
    END IF
    IF (options%optimize%nn_parameters(2) .EQ. 1) THEN
      DO k=1,setup%neurons(2)
        CALL PUSHINTEGER4(j)
        j = j + 1
      END DO
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHCONTROL1B(1)
    END IF
    IF (options%optimize%nn_parameters(3) .EQ. 1) THEN
      DO k=1,setup%neurons(2)
        DO l=1,setup%neurons(3)
          CALL PUSHINTEGER4(j)
          j = j + 1
        END DO
      END DO
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHCONTROL1B(1)
    END IF
    IF (options%optimize%nn_parameters(4) .EQ. 1) THEN
      DO k=1,setup%neurons(3)
        CALL PUSHINTEGER4(j)
        j = j + 1
      END DO
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHCONTROL1B(1)
    END IF
    IF (options%optimize%nn_parameters(5) .EQ. 1) THEN
      DO k=1,setup%neurons(3)
        DO l=1,setup%neurons(4)
          CALL PUSHINTEGER4(j)
          j = j + 1
        END DO
      END DO
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHCONTROL1B(1)
    END IF
    IF (options%optimize%nn_parameters(6) .EQ. 1) THEN
      DO k=1,setup%neurons(4)
        CALL PUSHINTEGER4(j)
        j = j + 1
      END DO
      DO k=setup%neurons(4),1,-1
        parameters_b%control%x(j) = parameters_b%control%x(j) + &
&         parameters_b%nn_parameters%bias_3(k)
        parameters_b%nn_parameters%bias_3(k) = 0.0_4
        CALL POPINTEGER4(j)
      END DO
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      DO k=setup%neurons(3),1,-1
        DO l=setup%neurons(4),1,-1
          parameters_b%control%x(j) = parameters_b%control%x(j) + &
&           parameters_b%nn_parameters%weight_3(l, k)
          parameters_b%nn_parameters%weight_3(l, k) = 0.0_4
          CALL POPINTEGER4(j)
        END DO
      END DO
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      DO k=setup%neurons(3),1,-1
        parameters_b%control%x(j) = parameters_b%control%x(j) + &
&         parameters_b%nn_parameters%bias_2(k)
        parameters_b%nn_parameters%bias_2(k) = 0.0_4
        CALL POPINTEGER4(j)
      END DO
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      DO k=setup%neurons(2),1,-1
        DO l=setup%neurons(3),1,-1
          parameters_b%control%x(j) = parameters_b%control%x(j) + &
&           parameters_b%nn_parameters%weight_2(l, k)
          parameters_b%nn_parameters%weight_2(l, k) = 0.0_4
          CALL POPINTEGER4(j)
        END DO
      END DO
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      DO k=setup%neurons(2),1,-1
        parameters_b%control%x(j) = parameters_b%control%x(j) + &
&         parameters_b%nn_parameters%bias_1(k)
        parameters_b%nn_parameters%bias_1(k) = 0.0_4
        CALL POPINTEGER4(j)
      END DO
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      DO k=setup%neurons(1),1,-1
        DO l=setup%neurons(2),1,-1
          parameters_b%control%x(j) = parameters_b%control%x(j) + &
&           parameters_b%nn_parameters%weight_1(l, k)
          parameters_b%nn_parameters%weight_1(l, k) = 0.0_4
          CALL POPINTEGER4(j)
        END DO
      END DO
    END IF
  END SUBROUTINE NN_PARAMETERS_FILL_PARAMETERS_B

  SUBROUTINE NN_PARAMETERS_FILL_PARAMETERS(setup, options, parameters)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    INTEGER :: j, k, l
    INTRINSIC SUM
! NN parameters is fifth control kind
    j = SUM(parameters%control%nbk(1:4))
    IF (options%optimize%nn_parameters(1) .EQ. 1) THEN
      DO k=1,setup%neurons(1)
        DO l=1,setup%neurons(2)
          j = j + 1
          parameters%nn_parameters%weight_1(l, k) = parameters%control%x&
&           (j)
        END DO
      END DO
    END IF
    IF (options%optimize%nn_parameters(2) .EQ. 1) THEN
      DO k=1,setup%neurons(2)
        j = j + 1
        parameters%nn_parameters%bias_1(k) = parameters%control%x(j)
      END DO
    END IF
    IF (options%optimize%nn_parameters(3) .EQ. 1) THEN
      DO k=1,setup%neurons(2)
        DO l=1,setup%neurons(3)
          j = j + 1
          parameters%nn_parameters%weight_2(l, k) = parameters%control%x&
&           (j)
        END DO
      END DO
    END IF
    IF (options%optimize%nn_parameters(4) .EQ. 1) THEN
      DO k=1,setup%neurons(3)
        j = j + 1
        parameters%nn_parameters%bias_2(k) = parameters%control%x(j)
      END DO
    END IF
    IF (options%optimize%nn_parameters(5) .EQ. 1) THEN
      DO k=1,setup%neurons(3)
        DO l=1,setup%neurons(4)
          j = j + 1
          parameters%nn_parameters%weight_3(l, k) = parameters%control%x&
&           (j)
        END DO
      END DO
    END IF
    IF (options%optimize%nn_parameters(6) .EQ. 1) THEN
      DO k=1,setup%neurons(4)
        j = j + 1
        parameters%nn_parameters%bias_3(k) = parameters%control%x(j)
      END DO
    END IF
  END SUBROUTINE NN_PARAMETERS_FILL_PARAMETERS

!  Differentiation of fill_parameters in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: *(parameters.rr_parameters.values)
!                *(parameters.rr_initial_states.values) *(parameters.serr_mu_parameters.values)
!                *(parameters.serr_sigma_parameters.values) *(parameters.nn_parameters.weight_1)
!                *(parameters.nn_parameters.bias_1) *(parameters.nn_parameters.weight_2)
!                *(parameters.nn_parameters.bias_2) *(parameters.nn_parameters.weight_3)
!                *(parameters.nn_parameters.bias_3)
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_parameters.values)
!                *(parameters.rr_initial_states.values)
!   Plus diff mem management of: parameters.control.x:in parameters.rr_parameters.values:in
!                parameters.rr_initial_states.values:in parameters.serr_mu_parameters.values:in
!                parameters.serr_sigma_parameters.values:in parameters.nn_parameters.weight_1:in
!                parameters.nn_parameters.bias_1:in parameters.nn_parameters.weight_2:in
!                parameters.nn_parameters.bias_2:in parameters.nn_parameters.weight_3:in
!                parameters.nn_parameters.bias_3:in
  SUBROUTINE FILL_PARAMETERS_D(setup, mesh, input_data, parameters, &
&   parameters_d, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_d
    TYPE(OPTIONSDT), INTENT(IN) :: options
    SELECT CASE  (options%optimize%mapping) 
    CASE ('uniform') 
      CALL UNIFORM_RR_PARAMETERS_FILL_PARAMETERS_D(setup, mesh, &
&                                            parameters, parameters_d, &
&                                            options)
      CALL UNIFORM_RR_INITIAL_STATES_FILL_PARAMETERS_D(setup, mesh, &
&                                                parameters, &
&                                                parameters_d, options)
    CASE ('distributed') 
      CALL DISTRIBUTED_RR_PARAMETERS_FILL_PARAMETERS_D(setup, mesh, &
&                                                parameters, &
&                                                parameters_d, options)
      CALL DISTRIBUTED_RR_INITIAL_STATES_FILL_PARAMETERS_D(setup, mesh, &
&                                                    parameters, &
&                                                    parameters_d, &
&                                                    options)
    CASE ('multi-linear') 
      CALL MULTI_LINEAR_RR_PARAMETERS_FILL_PARAMETERS_D(setup, mesh, &
&                                                 input_data, parameters&
&                                                 , parameters_d, &
&                                                 options)
      CALL MULTI_LINEAR_RR_INITIAL_STATES_FILL_PARAMETERS_D(setup, mesh&
&                                                     , input_data, &
&                                                     parameters, &
&                                                     parameters_d, &
&                                                     options)
    CASE ('multi-power') 
      CALL MULTI_POWER_RR_PARAMETERS_FILL_PARAMETERS_D(setup, mesh, &
&                                                input_data, parameters&
&                                                , parameters_d, options&
&                                               )
      CALL MULTI_POWER_RR_INITIAL_STATES_FILL_PARAMETERS_D(setup, mesh, &
&                                                    input_data, &
&                                                    parameters, &
&                                                    parameters_d, &
&                                                    options)
    END SELECT
! Directly working with hyper parameters
    CALL SERR_MU_PARAMETERS_FILL_PARAMETERS_D(setup, mesh, parameters, &
&                                       parameters_d, options)
    CALL SERR_SIGMA_PARAMETERS_FILL_PARAMETERS_D(setup, mesh, parameters&
&                                          , parameters_d, options)
    CALL NN_PARAMETERS_FILL_PARAMETERS_D(setup, options, parameters, &
&                                  parameters_d)
  END SUBROUTINE FILL_PARAMETERS_D

!  Differentiation of fill_parameters in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: *(parameters.control.x) *(parameters.rr_parameters.values)
!                *(parameters.rr_initial_states.values) *(parameters.serr_mu_parameters.values)
!                *(parameters.serr_sigma_parameters.values) *(parameters.nn_parameters.weight_1)
!                *(parameters.nn_parameters.bias_1) *(parameters.nn_parameters.weight_2)
!                *(parameters.nn_parameters.bias_2) *(parameters.nn_parameters.weight_3)
!                *(parameters.nn_parameters.bias_3)
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_parameters.values)
!                *(parameters.rr_initial_states.values)
!   Plus diff mem management of: parameters.control.x:in parameters.rr_parameters.values:in
!                parameters.rr_initial_states.values:in parameters.serr_mu_parameters.values:in
!                parameters.serr_sigma_parameters.values:in parameters.nn_parameters.weight_1:in
!                parameters.nn_parameters.bias_1:in parameters.nn_parameters.weight_2:in
!                parameters.nn_parameters.bias_2:in parameters.nn_parameters.weight_3:in
!                parameters.nn_parameters.bias_3:in
  SUBROUTINE FILL_PARAMETERS_B(setup, mesh, input_data, parameters, &
&   parameters_b, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_b
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTEGER :: branch
    SELECT CASE  (options%optimize%mapping) 
    CASE ('uniform') 
      CALL PUSHREAL4ARRAY(parameters%rr_parameters%values, SIZE(&
&                   parameters%rr_parameters%values, 1)*SIZE(parameters%&
&                   rr_parameters%values, 2)*SIZE(parameters%&
&                   rr_parameters%values, 3))
      CALL UNIFORM_RR_PARAMETERS_FILL_PARAMETERS(setup, mesh, parameters&
&                                          , options)
      CALL PUSHREAL4ARRAY(parameters%rr_initial_states%values, SIZE(&
&                   parameters%rr_initial_states%values, 1)*SIZE(&
&                   parameters%rr_initial_states%values, 2)*SIZE(&
&                   parameters%rr_initial_states%values, 3))
      CALL UNIFORM_RR_INITIAL_STATES_FILL_PARAMETERS(setup, mesh, &
&                                              parameters, options)
      CALL PUSHCONTROL3B(1)
    CASE ('distributed') 
      CALL PUSHREAL4ARRAY(parameters%rr_parameters%values, SIZE(&
&                   parameters%rr_parameters%values, 1)*SIZE(parameters%&
&                   rr_parameters%values, 2)*SIZE(parameters%&
&                   rr_parameters%values, 3))
      CALL DISTRIBUTED_RR_PARAMETERS_FILL_PARAMETERS(setup, mesh, &
&                                              parameters, options)
      CALL PUSHREAL4ARRAY(parameters%rr_initial_states%values, SIZE(&
&                   parameters%rr_initial_states%values, 1)*SIZE(&
&                   parameters%rr_initial_states%values, 2)*SIZE(&
&                   parameters%rr_initial_states%values, 3))
      CALL DISTRIBUTED_RR_INITIAL_STATES_FILL_PARAMETERS(setup, mesh, &
&                                                  parameters, options)
      CALL PUSHCONTROL3B(2)
    CASE ('multi-linear') 
      CALL PUSHREAL4ARRAY(parameters%rr_parameters%values, SIZE(&
&                   parameters%rr_parameters%values, 1)*SIZE(parameters%&
&                   rr_parameters%values, 2)*SIZE(parameters%&
&                   rr_parameters%values, 3))
      CALL MULTI_LINEAR_RR_PARAMETERS_FILL_PARAMETERS(setup, mesh, &
&                                               input_data, parameters, &
&                                               options)
      CALL PUSHREAL4ARRAY(parameters%rr_initial_states%values, SIZE(&
&                   parameters%rr_initial_states%values, 1)*SIZE(&
&                   parameters%rr_initial_states%values, 2)*SIZE(&
&                   parameters%rr_initial_states%values, 3))
      CALL MULTI_LINEAR_RR_INITIAL_STATES_FILL_PARAMETERS(setup, mesh, &
&                                                   input_data, &
&                                                   parameters, options)
      CALL PUSHCONTROL3B(3)
    CASE ('multi-power') 
      CALL PUSHREAL4ARRAY(parameters%rr_parameters%values, SIZE(&
&                   parameters%rr_parameters%values, 1)*SIZE(parameters%&
&                   rr_parameters%values, 2)*SIZE(parameters%&
&                   rr_parameters%values, 3))
      CALL MULTI_POWER_RR_PARAMETERS_FILL_PARAMETERS(setup, mesh, &
&                                              input_data, parameters, &
&                                              options)
      CALL PUSHREAL4ARRAY(parameters%rr_initial_states%values, SIZE(&
&                   parameters%rr_initial_states%values, 1)*SIZE(&
&                   parameters%rr_initial_states%values, 2)*SIZE(&
&                   parameters%rr_initial_states%values, 3))
      CALL MULTI_POWER_RR_INITIAL_STATES_FILL_PARAMETERS(setup, mesh, &
&                                                  input_data, &
&                                                  parameters, options)
      CALL PUSHCONTROL3B(4)
    CASE DEFAULT
      CALL PUSHCONTROL3B(0)
    END SELECT
! Directly working with hyper parameters
    CALL SERR_MU_PARAMETERS_FILL_PARAMETERS(setup, mesh, parameters, &
&                                     options)
    CALL SERR_SIGMA_PARAMETERS_FILL_PARAMETERS(setup, mesh, parameters, &
&                                        options)
    CALL PUSHREAL4ARRAY(parameters%nn_parameters%weight_1, SIZE(&
&                 parameters%nn_parameters%weight_1, 1)*SIZE(parameters%&
&                 nn_parameters%weight_1, 2))
    CALL PUSHREAL4ARRAY(parameters%nn_parameters%bias_1, SIZE(parameters&
&                 %nn_parameters%bias_1, 1))
    CALL PUSHREAL4ARRAY(parameters%nn_parameters%weight_2, SIZE(&
&                 parameters%nn_parameters%weight_2, 1)*SIZE(parameters%&
&                 nn_parameters%weight_2, 2))
    CALL PUSHREAL4ARRAY(parameters%nn_parameters%bias_2, SIZE(parameters&
&                 %nn_parameters%bias_2, 1))
    CALL PUSHREAL4ARRAY(parameters%nn_parameters%weight_3, SIZE(&
&                 parameters%nn_parameters%weight_3, 1)*SIZE(parameters%&
&                 nn_parameters%weight_3, 2))
    CALL PUSHREAL4ARRAY(parameters%nn_parameters%bias_3, SIZE(parameters&
&                 %nn_parameters%bias_3, 1))
    CALL NN_PARAMETERS_FILL_PARAMETERS(setup, options, parameters)
    CALL POPREAL4ARRAY(parameters%nn_parameters%bias_3, SIZE(parameters%&
&                nn_parameters%bias_3, 1))
    CALL POPREAL4ARRAY(parameters%nn_parameters%weight_3, SIZE(&
&                parameters%nn_parameters%weight_3, 1)*SIZE(parameters%&
&                nn_parameters%weight_3, 2))
    CALL POPREAL4ARRAY(parameters%nn_parameters%bias_2, SIZE(parameters%&
&                nn_parameters%bias_2, 1))
    CALL POPREAL4ARRAY(parameters%nn_parameters%weight_2, SIZE(&
&                parameters%nn_parameters%weight_2, 1)*SIZE(parameters%&
&                nn_parameters%weight_2, 2))
    CALL POPREAL4ARRAY(parameters%nn_parameters%bias_1, SIZE(parameters%&
&                nn_parameters%bias_1, 1))
    CALL POPREAL4ARRAY(parameters%nn_parameters%weight_1, SIZE(&
&                parameters%nn_parameters%weight_1, 1)*SIZE(parameters%&
&                nn_parameters%weight_1, 2))
    CALL NN_PARAMETERS_FILL_PARAMETERS_B(setup, options, parameters, &
&                                  parameters_b)
    CALL SERR_SIGMA_PARAMETERS_FILL_PARAMETERS_B(setup, mesh, parameters&
&                                          , parameters_b, options)
    CALL SERR_MU_PARAMETERS_FILL_PARAMETERS_B(setup, mesh, parameters, &
&                                       parameters_b, options)
    CALL POPCONTROL3B(branch)
    IF (branch .LT. 2) THEN
      IF (branch .NE. 0) THEN
        CALL POPREAL4ARRAY(parameters%rr_initial_states%values, SIZE(&
&                    parameters%rr_initial_states%values, 1)*SIZE(&
&                    parameters%rr_initial_states%values, 2)*SIZE(&
&                    parameters%rr_initial_states%values, 3))
        CALL UNIFORM_RR_INITIAL_STATES_FILL_PARAMETERS_B(setup, mesh, &
&                                                  parameters, &
&                                                  parameters_b, options&
&                                                 )
        CALL POPREAL4ARRAY(parameters%rr_parameters%values, SIZE(&
&                    parameters%rr_parameters%values, 1)*SIZE(parameters&
&                    %rr_parameters%values, 2)*SIZE(parameters%&
&                    rr_parameters%values, 3))
        CALL UNIFORM_RR_PARAMETERS_FILL_PARAMETERS_B(setup, mesh, &
&                                              parameters, parameters_b&
&                                              , options)
      END IF
    ELSE IF (branch .EQ. 2) THEN
      CALL POPREAL4ARRAY(parameters%rr_initial_states%values, SIZE(&
&                  parameters%rr_initial_states%values, 1)*SIZE(&
&                  parameters%rr_initial_states%values, 2)*SIZE(&
&                  parameters%rr_initial_states%values, 3))
      CALL DISTRIBUTED_RR_INITIAL_STATES_FILL_PARAMETERS_B(setup, mesh, &
&                                                    parameters, &
&                                                    parameters_b, &
&                                                    options)
      CALL POPREAL4ARRAY(parameters%rr_parameters%values, SIZE(&
&                  parameters%rr_parameters%values, 1)*SIZE(parameters%&
&                  rr_parameters%values, 2)*SIZE(parameters%&
&                  rr_parameters%values, 3))
      CALL DISTRIBUTED_RR_PARAMETERS_FILL_PARAMETERS_B(setup, mesh, &
&                                                parameters, &
&                                                parameters_b, options)
    ELSE IF (branch .EQ. 3) THEN
      CALL POPREAL4ARRAY(parameters%rr_initial_states%values, SIZE(&
&                  parameters%rr_initial_states%values, 1)*SIZE(&
&                  parameters%rr_initial_states%values, 2)*SIZE(&
&                  parameters%rr_initial_states%values, 3))
      CALL MULTI_LINEAR_RR_INITIAL_STATES_FILL_PARAMETERS_B(setup, mesh&
&                                                     , input_data, &
&                                                     parameters, &
&                                                     parameters_b, &
&                                                     options)
      CALL POPREAL4ARRAY(parameters%rr_parameters%values, SIZE(&
&                  parameters%rr_parameters%values, 1)*SIZE(parameters%&
&                  rr_parameters%values, 2)*SIZE(parameters%&
&                  rr_parameters%values, 3))
      CALL MULTI_LINEAR_RR_PARAMETERS_FILL_PARAMETERS_B(setup, mesh, &
&                                                 input_data, parameters&
&                                                 , parameters_b, &
&                                                 options)
    ELSE
      CALL POPREAL4ARRAY(parameters%rr_initial_states%values, SIZE(&
&                  parameters%rr_initial_states%values, 1)*SIZE(&
&                  parameters%rr_initial_states%values, 2)*SIZE(&
&                  parameters%rr_initial_states%values, 3))
      CALL MULTI_POWER_RR_INITIAL_STATES_FILL_PARAMETERS_B(setup, mesh, &
&                                                    input_data, &
&                                                    parameters, &
&                                                    parameters_b, &
&                                                    options)
      CALL POPREAL4ARRAY(parameters%rr_parameters%values, SIZE(&
&                  parameters%rr_parameters%values, 1)*SIZE(parameters%&
&                  rr_parameters%values, 2)*SIZE(parameters%&
&                  rr_parameters%values, 3))
      CALL MULTI_POWER_RR_PARAMETERS_FILL_PARAMETERS_B(setup, mesh, &
&                                                input_data, parameters&
&                                                , parameters_b, options&
&                                               )
    END IF
  END SUBROUTINE FILL_PARAMETERS_B

  SUBROUTINE FILL_PARAMETERS(setup, mesh, input_data, parameters, &
&   options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    SELECT CASE  (options%optimize%mapping) 
    CASE ('uniform') 
      CALL UNIFORM_RR_PARAMETERS_FILL_PARAMETERS(setup, mesh, parameters&
&                                          , options)
      CALL UNIFORM_RR_INITIAL_STATES_FILL_PARAMETERS(setup, mesh, &
&                                              parameters, options)
    CASE ('distributed') 
      CALL DISTRIBUTED_RR_PARAMETERS_FILL_PARAMETERS(setup, mesh, &
&                                              parameters, options)
      CALL DISTRIBUTED_RR_INITIAL_STATES_FILL_PARAMETERS(setup, mesh, &
&                                                  parameters, options)
    CASE ('multi-linear') 
      CALL MULTI_LINEAR_RR_PARAMETERS_FILL_PARAMETERS(setup, mesh, &
&                                               input_data, parameters, &
&                                               options)
      CALL MULTI_LINEAR_RR_INITIAL_STATES_FILL_PARAMETERS(setup, mesh, &
&                                                   input_data, &
&                                                   parameters, options)
    CASE ('multi-power') 
      CALL MULTI_POWER_RR_PARAMETERS_FILL_PARAMETERS(setup, mesh, &
&                                              input_data, parameters, &
&                                              options)
      CALL MULTI_POWER_RR_INITIAL_STATES_FILL_PARAMETERS(setup, mesh, &
&                                                  input_data, &
&                                                  parameters, options)
    END SELECT
! Directly working with hyper parameters
    CALL SERR_MU_PARAMETERS_FILL_PARAMETERS(setup, mesh, parameters, &
&                                     options)
    CALL SERR_SIGMA_PARAMETERS_FILL_PARAMETERS(setup, mesh, parameters, &
&                                        options)
    CALL NN_PARAMETERS_FILL_PARAMETERS(setup, options, parameters)
  END SUBROUTINE FILL_PARAMETERS

  SUBROUTINE PARAMETERS_TO_CONTROL(setup, mesh, input_data, parameters, &
&   options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTRINSIC SIZE
    INTEGER, DIMENSION(SIZE(parameters%control%nbk)) :: nbk
    CALL GET_CONTROL_SIZES(setup, mesh, options, nbk)
    CALL CONTROLDT_INITIALISE(parameters%control, nbk)
    CALL FILL_CONTROL(setup, mesh, input_data, parameters, options)
    CALL CONTROL_TFM(parameters, options)
  END SUBROUTINE PARAMETERS_TO_CONTROL

!  Differentiation of control_to_parameters in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: *(parameters.control.x) *(parameters.rr_parameters.values)
!                *(parameters.rr_initial_states.values) *(parameters.serr_mu_parameters.values)
!                *(parameters.serr_sigma_parameters.values) *(parameters.nn_parameters.weight_1)
!                *(parameters.nn_parameters.bias_1) *(parameters.nn_parameters.weight_2)
!                *(parameters.nn_parameters.bias_2) *(parameters.nn_parameters.weight_3)
!                *(parameters.nn_parameters.bias_3)
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_parameters.values)
!                *(parameters.rr_initial_states.values)
!   Plus diff mem management of: parameters.control.x:in parameters.control.l:in
!                parameters.control.u:in parameters.control.l_raw:in
!                parameters.control.u_raw:in parameters.rr_parameters.values:in
!                parameters.rr_initial_states.values:in parameters.serr_mu_parameters.values:in
!                parameters.serr_sigma_parameters.values:in parameters.nn_parameters.weight_1:in
!                parameters.nn_parameters.bias_1:in parameters.nn_parameters.weight_2:in
!                parameters.nn_parameters.bias_2:in parameters.nn_parameters.weight_3:in
!                parameters.nn_parameters.bias_3:in
  SUBROUTINE CONTROL_TO_PARAMETERS_D(setup, mesh, input_data, parameters&
&   , parameters_d, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_d
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTRINSIC ALLOCATED
    IF (.NOT.ALLOCATED(parameters%control%x)) THEN
      parameters_d%serr_mu_parameters%values = 0.0_4
      parameters_d%serr_sigma_parameters%values = 0.0_4
      parameters_d%nn_parameters%weight_1 = 0.0_4
      parameters_d%nn_parameters%bias_1 = 0.0_4
      parameters_d%nn_parameters%weight_2 = 0.0_4
      parameters_d%nn_parameters%bias_2 = 0.0_4
      parameters_d%nn_parameters%weight_3 = 0.0_4
      parameters_d%nn_parameters%bias_3 = 0.0_4
    ELSE
      CALL INV_CONTROL_TFM_D(parameters, parameters_d, options)
      CALL FILL_PARAMETERS_D(setup, mesh, input_data, parameters, &
&                      parameters_d, options)
    END IF
  END SUBROUTINE CONTROL_TO_PARAMETERS_D

!  Differentiation of control_to_parameters in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: *(parameters.control.x) *(parameters.rr_parameters.values)
!                *(parameters.rr_initial_states.values) *(parameters.serr_mu_parameters.values)
!                *(parameters.serr_sigma_parameters.values) *(parameters.nn_parameters.weight_1)
!                *(parameters.nn_parameters.bias_1) *(parameters.nn_parameters.weight_2)
!                *(parameters.nn_parameters.bias_2) *(parameters.nn_parameters.weight_3)
!                *(parameters.nn_parameters.bias_3)
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_parameters.values)
!                *(parameters.rr_initial_states.values)
!   Plus diff mem management of: parameters.control.x:in parameters.control.l:in
!                parameters.control.u:in parameters.control.l_raw:in
!                parameters.control.u_raw:in parameters.rr_parameters.values:in
!                parameters.rr_initial_states.values:in parameters.serr_mu_parameters.values:in
!                parameters.serr_sigma_parameters.values:in parameters.nn_parameters.weight_1:in
!                parameters.nn_parameters.bias_1:in parameters.nn_parameters.weight_2:in
!                parameters.nn_parameters.bias_2:in parameters.nn_parameters.weight_3:in
!                parameters.nn_parameters.bias_3:in
  SUBROUTINE CONTROL_TO_PARAMETERS_B(setup, mesh, input_data, parameters&
&   , parameters_b, options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_b
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTRINSIC ALLOCATED
    IF (ALLOCATED(parameters%control%x)) THEN
      CALL PUSHREAL4ARRAY(parameters%control%x, SIZE(parameters%control%&
&                   x, 1))
      CALL INV_CONTROL_TFM(parameters, options)
      CALL PUSHREAL4ARRAY(parameters%rr_parameters%values, SIZE(&
&                   parameters%rr_parameters%values, 1)*SIZE(parameters%&
&                   rr_parameters%values, 2)*SIZE(parameters%&
&                   rr_parameters%values, 3))
      CALL PUSHREAL4ARRAY(parameters%rr_initial_states%values, SIZE(&
&                   parameters%rr_initial_states%values, 1)*SIZE(&
&                   parameters%rr_initial_states%values, 2)*SIZE(&
&                   parameters%rr_initial_states%values, 3))
      CALL PUSHREAL4ARRAY(parameters%nn_parameters%weight_1, SIZE(&
&                   parameters%nn_parameters%weight_1, 1)*SIZE(&
&                   parameters%nn_parameters%weight_1, 2))
      CALL PUSHREAL4ARRAY(parameters%nn_parameters%bias_1, SIZE(&
&                   parameters%nn_parameters%bias_1, 1))
      CALL PUSHREAL4ARRAY(parameters%nn_parameters%weight_2, SIZE(&
&                   parameters%nn_parameters%weight_2, 1)*SIZE(&
&                   parameters%nn_parameters%weight_2, 2))
      CALL PUSHREAL4ARRAY(parameters%nn_parameters%bias_2, SIZE(&
&                   parameters%nn_parameters%bias_2, 1))
      CALL PUSHREAL4ARRAY(parameters%nn_parameters%weight_3, SIZE(&
&                   parameters%nn_parameters%weight_3, 1)*SIZE(&
&                   parameters%nn_parameters%weight_3, 2))
      CALL PUSHREAL4ARRAY(parameters%nn_parameters%bias_3, SIZE(&
&                   parameters%nn_parameters%bias_3, 1))
      CALL FILL_PARAMETERS(setup, mesh, input_data, parameters, options)
      CALL POPREAL4ARRAY(parameters%nn_parameters%bias_3, SIZE(&
&                  parameters%nn_parameters%bias_3, 1))
      CALL POPREAL4ARRAY(parameters%nn_parameters%weight_3, SIZE(&
&                  parameters%nn_parameters%weight_3, 1)*SIZE(parameters&
&                  %nn_parameters%weight_3, 2))
      CALL POPREAL4ARRAY(parameters%nn_parameters%bias_2, SIZE(&
&                  parameters%nn_parameters%bias_2, 1))
      CALL POPREAL4ARRAY(parameters%nn_parameters%weight_2, SIZE(&
&                  parameters%nn_parameters%weight_2, 1)*SIZE(parameters&
&                  %nn_parameters%weight_2, 2))
      CALL POPREAL4ARRAY(parameters%nn_parameters%bias_1, SIZE(&
&                  parameters%nn_parameters%bias_1, 1))
      CALL POPREAL4ARRAY(parameters%nn_parameters%weight_1, SIZE(&
&                  parameters%nn_parameters%weight_1, 1)*SIZE(parameters&
&                  %nn_parameters%weight_1, 2))
      CALL POPREAL4ARRAY(parameters%rr_initial_states%values, SIZE(&
&                  parameters%rr_initial_states%values, 1)*SIZE(&
&                  parameters%rr_initial_states%values, 2)*SIZE(&
&                  parameters%rr_initial_states%values, 3))
      CALL POPREAL4ARRAY(parameters%rr_parameters%values, SIZE(&
&                  parameters%rr_parameters%values, 1)*SIZE(parameters%&
&                  rr_parameters%values, 2)*SIZE(parameters%&
&                  rr_parameters%values, 3))
      CALL FILL_PARAMETERS_B(setup, mesh, input_data, parameters, &
&                      parameters_b, options)
      CALL POPREAL4ARRAY(parameters%control%x, SIZE(parameters%control%x&
&                  , 1))
      CALL INV_CONTROL_TFM_B(parameters, parameters_b, options)
    END IF
  END SUBROUTINE CONTROL_TO_PARAMETERS_B

  SUBROUTINE CONTROL_TO_PARAMETERS(setup, mesh, input_data, parameters, &
&   options)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    INTRINSIC ALLOCATED
    IF (.NOT.ALLOCATED(parameters%control%x)) THEN
      RETURN
    ELSE
      CALL INV_CONTROL_TFM(parameters, options)
      CALL FILL_PARAMETERS(setup, mesh, input_data, parameters, options)
    END IF
  END SUBROUTINE CONTROL_TO_PARAMETERS

END MODULE MWD_PARAMETERS_MANIPULATION_DIFF

!%      (MW) Module Differentiated.
!%
!%      Function
!%      ----------
!%
!%      - prior_regularization
!%      - smoothing_regularization_spatial_loop
!%      - smoothing_regularization
MODULE MD_REGULARIZATION_DIFF
!% only: sp
  USE MD_CONSTANT
!% only: SetupDT
  USE MWD_SETUP
!% only: MeshDT
  USE MWD_MESH
!% only: Input_DataDT
  USE MWD_INPUT_DATA
!% only: ParametersDT
  USE MWD_PARAMETERS_DIFF
!% only: OptionsDT
  USE MWD_OPTIONS_DIFF
!% only: control_tfm, control_to_parameters
  USE MWD_PARAMETERS_MANIPULATION_DIFF
  IMPLICIT NONE

CONTAINS
!  Differentiation of prior_regularization in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: res
!   with respect to varying inputs: *(parameters.control.x)
!   Plus diff mem management of: parameters.control.x:in
  FUNCTION PRIOR_REGULARIZATION_D(parameters, parameters_d, res) RESULT &
& (RES_D)
    IMPLICIT NONE
    TYPE(PARAMETERSDT), INTENT(IN) :: parameters
    TYPE(PARAMETERSDT), INTENT(IN) :: parameters_d
    REAL(sp) :: res
    REAL(sp) :: res_d
    REAL(sp), DIMENSION(parameters%control%n) :: dbkg
    REAL(sp), DIMENSION(parameters%control%n) :: dbkg_d
    INTRINSIC SUM
! Tapenade needs to know the size somehow
    dbkg_d = parameters_d%control%x
    dbkg = parameters%control%x - parameters%control%x_raw
    res_d = SUM(2*dbkg*dbkg_d)
    res = SUM(dbkg*dbkg)
  END FUNCTION PRIOR_REGULARIZATION_D

!  Differentiation of prior_regularization in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: res *(parameters.control.x)
!   with respect to varying inputs: *(parameters.control.x)
!   Plus diff mem management of: parameters.control.x:in
  SUBROUTINE PRIOR_REGULARIZATION_B(parameters, parameters_b, res_b)
    IMPLICIT NONE
    TYPE(PARAMETERSDT), INTENT(IN) :: parameters
    TYPE(PARAMETERSDT) :: parameters_b
    REAL(sp) :: res
    REAL(sp) :: res_b
    REAL(sp), DIMENSION(parameters%control%n) :: dbkg
    REAL(sp), DIMENSION(parameters%control%n) :: dbkg_b
    INTRINSIC SUM
! Tapenade needs to know the size somehow
    dbkg = parameters%control%x - parameters%control%x_raw
    dbkg = parameters%control%x - parameters%control%x_raw
    dbkg_b = 0.0_4
    dbkg_b = 2*dbkg*res_b
    parameters_b%control%x = parameters_b%control%x + dbkg_b
  END SUBROUTINE PRIOR_REGULARIZATION_B

  FUNCTION PRIOR_REGULARIZATION(parameters) RESULT (RES)
    IMPLICIT NONE
    TYPE(PARAMETERSDT), INTENT(IN) :: parameters
    REAL(sp) :: res
    REAL(sp), DIMENSION(parameters%control%n) :: dbkg
    INTRINSIC SUM
! Tapenade needs to know the size somehow
    dbkg = parameters%control%x - parameters%control%x_raw
    res = SUM(dbkg*dbkg)
  END FUNCTION PRIOR_REGULARIZATION

!  Differentiation of smoothing_regularization_spatial_loop in forward (tangent) mode (with options fixinterface noISIZE context)
!:
!   variations   of useful results: res
!   with respect to varying inputs: matrix
  FUNCTION SMOOTHING_REGULARIZATION_SPATIAL_LOOP_D(mesh, matrix, &
&   matrix_d, res) RESULT (RES_D)
    IMPLICIT NONE
    TYPE(MESHDT), INTENT(IN) :: mesh
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: matrix
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: matrix_d
    REAL(sp) :: res
    REAL(sp) :: res_d
    INTEGER :: row, col, m1row, p1row, m1col, p1col
    INTRINSIC MAX
    INTRINSIC MIN
    res = 0._sp
    res_d = 0.0_4
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .NE. 0) THEN
          IF (1 .LT. row - 1) THEN
            m1row = row - 1
          ELSE
            m1row = 1
          END IF
          IF (mesh%nrow .GT. row + 1) THEN
            p1row = row + 1
          ELSE
            p1row = mesh%nrow
          END IF
          IF (1 .LT. col - 1) THEN
            m1col = col - 1
          ELSE
            m1col = 1
          END IF
          IF (mesh%ncol .GT. col + 1) THEN
            p1col = col + 1
          ELSE
            p1col = mesh%ncol
          END IF
          IF (mesh%active_cell(m1row, col) .EQ. 0) m1row = row
          IF (mesh%active_cell(p1row, col) .EQ. 0) p1row = row
          IF (mesh%active_cell(row, m1col) .EQ. 0) m1col = col
          IF (mesh%active_cell(row, p1col) .EQ. 0) p1col = col
          res_d = res_d + 2*(matrix(p1row, col)-2._sp*matrix(row, col)+&
&           matrix(m1row, col))*(matrix_d(p1row, col)-2._sp*matrix_d(row&
&           , col)+matrix_d(m1row, col)) + 2*(matrix(row, p1col)-2._sp*&
&           matrix(row, col)+matrix(row, m1col))*(matrix_d(row, p1col)-&
&           2._sp*matrix_d(row, col)+matrix_d(row, m1col))
          res = res + (matrix(p1row, col)-2._sp*matrix(row, col)+matrix(&
&           m1row, col))**2 + (matrix(row, p1col)-2._sp*matrix(row, col)&
&           +matrix(row, m1col))**2
        END IF
      END DO
    END DO
  END FUNCTION SMOOTHING_REGULARIZATION_SPATIAL_LOOP_D

!  Differentiation of smoothing_regularization_spatial_loop in reverse (adjoint) mode (with options fixinterface noISIZE context)
!:
!   gradient     of useful results: res
!   with respect to varying inputs: matrix
  SUBROUTINE SMOOTHING_REGULARIZATION_SPATIAL_LOOP_B(mesh, matrix, &
&   matrix_b, res_b)
    IMPLICIT NONE
    TYPE(MESHDT), INTENT(IN) :: mesh
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: matrix
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: matrix_b
    REAL(sp) :: res
    REAL(sp) :: res_b
    INTEGER :: row, col, m1row, p1row, m1col, p1col
    INTRINSIC MAX
    INTRINSIC MIN
    REAL(sp) :: temp_b
    REAL(sp) :: temp_b0
    INTEGER :: branch
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL1B(0)
        ELSE
          IF (1 .LT. row - 1) THEN
            CALL PUSHINTEGER4(m1row)
            m1row = row - 1
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHINTEGER4(m1row)
            m1row = 1
            CALL PUSHCONTROL1B(1)
          END IF
          IF (mesh%nrow .GT. row + 1) THEN
            CALL PUSHINTEGER4(p1row)
            p1row = row + 1
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHINTEGER4(p1row)
            p1row = mesh%nrow
            CALL PUSHCONTROL1B(1)
          END IF
          IF (1 .LT. col - 1) THEN
            CALL PUSHINTEGER4(m1col)
            m1col = col - 1
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHINTEGER4(m1col)
            m1col = 1
            CALL PUSHCONTROL1B(1)
          END IF
          IF (mesh%ncol .GT. col + 1) THEN
            CALL PUSHINTEGER4(p1col)
            p1col = col + 1
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHINTEGER4(p1col)
            p1col = mesh%ncol
            CALL PUSHCONTROL1B(1)
          END IF
          IF (mesh%active_cell(m1row, col) .EQ. 0) m1row = row
          IF (mesh%active_cell(p1row, col) .EQ. 0) p1row = row
          IF (mesh%active_cell(row, m1col) .EQ. 0) m1col = col
          IF (mesh%active_cell(row, p1col) .EQ. 0) p1col = col
          CALL PUSHCONTROL1B(1)
        END IF
      END DO
    END DO
    matrix_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) THEN
          temp_b = 2*(matrix(p1row, col)-2._sp*matrix(row, col)+matrix(&
&           m1row, col))*res_b
          temp_b0 = 2*(matrix(row, p1col)-2._sp*matrix(row, col)+matrix(&
&           row, m1col))*res_b
          matrix_b(row, p1col) = matrix_b(row, p1col) + temp_b0
          matrix_b(row, col) = matrix_b(row, col) - 2._sp*temp_b0
          matrix_b(row, m1col) = matrix_b(row, m1col) + temp_b0
          matrix_b(p1row, col) = matrix_b(p1row, col) + temp_b
          matrix_b(row, col) = matrix_b(row, col) - 2._sp*temp_b
          matrix_b(m1row, col) = matrix_b(m1row, col) + temp_b
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            CALL POPINTEGER4(p1col)
          ELSE
            CALL POPINTEGER4(p1col)
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            CALL POPINTEGER4(m1col)
          ELSE
            CALL POPINTEGER4(m1col)
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            CALL POPINTEGER4(p1row)
          ELSE
            CALL POPINTEGER4(p1row)
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            CALL POPINTEGER4(m1row)
          ELSE
            CALL POPINTEGER4(m1row)
          END IF
        END IF
      END DO
    END DO
  END SUBROUTINE SMOOTHING_REGULARIZATION_SPATIAL_LOOP_B

  FUNCTION SMOOTHING_REGULARIZATION_SPATIAL_LOOP(mesh, matrix) RESULT (&
& RES)
    IMPLICIT NONE
    TYPE(MESHDT), INTENT(IN) :: mesh
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: matrix
    REAL(sp) :: res
    INTEGER :: row, col, m1row, p1row, m1col, p1col
    INTRINSIC MAX
    INTRINSIC MIN
    res = 0._sp
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .NE. 0) THEN
          IF (1 .LT. row - 1) THEN
            m1row = row - 1
          ELSE
            m1row = 1
          END IF
          IF (mesh%nrow .GT. row + 1) THEN
            p1row = row + 1
          ELSE
            p1row = mesh%nrow
          END IF
          IF (1 .LT. col - 1) THEN
            m1col = col - 1
          ELSE
            m1col = 1
          END IF
          IF (mesh%ncol .GT. col + 1) THEN
            p1col = col + 1
          ELSE
            p1col = mesh%ncol
          END IF
          IF (mesh%active_cell(m1row, col) .EQ. 0) m1row = row
          IF (mesh%active_cell(p1row, col) .EQ. 0) p1row = row
          IF (mesh%active_cell(row, m1col) .EQ. 0) m1col = col
          IF (mesh%active_cell(row, p1col) .EQ. 0) p1col = col
          res = res + (matrix(p1row, col)-2._sp*matrix(row, col)+matrix(&
&           m1row, col))**2 + (matrix(row, p1col)-2._sp*matrix(row, col)&
&           +matrix(row, m1col))**2
        END IF
      END DO
    END DO
  END FUNCTION SMOOTHING_REGULARIZATION_SPATIAL_LOOP

!  Differentiation of smoothing_regularization in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: res *(parameters.control.x)
!                *(parameters.rr_parameters.values) *(parameters.rr_initial_states.values)
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_parameters.values)
!                *(parameters.rr_initial_states.values)
!   Plus diff mem management of: parameters.control.x:in parameters.control.l:in
!                parameters.control.u:in parameters.control.l_raw:in
!                parameters.control.u_raw:in parameters.rr_parameters.values:in
!                parameters.rr_initial_states.values:in parameters.serr_mu_parameters.values:in
!                parameters.serr_sigma_parameters.values:in parameters.nn_parameters.weight_1:in
!                parameters.nn_parameters.bias_1:in parameters.nn_parameters.weight_2:in
!                parameters.nn_parameters.bias_2:in parameters.nn_parameters.weight_3:in
!                parameters.nn_parameters.bias_3:in
  FUNCTION SMOOTHING_REGULARIZATION_D(setup, mesh, input_data, &
&   parameters, parameters_d, options, hard, res) RESULT (RES_D)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(IN) :: parameters
    TYPE(PARAMETERSDT), INTENT(IN) :: parameters_d
    TYPE(OPTIONSDT), INTENT(IN) :: options
    LOGICAL :: hard
    REAL(sp) :: res
    REAL(sp) :: res_d
    INTEGER :: i
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: matrix
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: matrix_d
    TYPE(PARAMETERSDT) :: parameters_bkg
    TYPE(PARAMETERSDT) :: parameters_bkg_d
    REAL(sp) :: result1
    REAL(sp) :: result1_d
    res = 0._sp
! This allows to retrieve a parameters structure with background values
    parameters_bkg_d = parameters_d
    parameters_bkg = parameters
    parameters_bkg_d%control%x = 0.0_4
    parameters_bkg%control%x = parameters%control%x_raw
    CALL CONTROL_TFM_D(parameters_bkg, parameters_bkg_d, options)
    CALL CONTROL_TO_PARAMETERS_D(setup, mesh, input_data, parameters_bkg&
&                          , parameters_bkg_d, options)
    res_d = 0.0_4
! Loop on rr_parameters
    DO i=1,setup%nrrp
      IF (options%optimize%rr_parameters(i) .NE. 0) THEN
        IF (hard) THEN
          matrix_d = parameters_d%rr_parameters%values(:, :, i)
          matrix = parameters%rr_parameters%values(:, :, i)
        ELSE
          matrix_d = parameters_d%rr_parameters%values(:, :, i) - &
&           parameters_bkg_d%rr_parameters%values(:, :, i)
          matrix = parameters%rr_parameters%values(:, :, i) - &
&           parameters_bkg%rr_parameters%values(:, :, i)
        END IF
        result1_d = SMOOTHING_REGULARIZATION_SPATIAL_LOOP_D(mesh, matrix&
&         , matrix_d, result1)
        res_d = res_d + result1_d
        res = res + result1
      END IF
    END DO
! Loop on rr_initial_states
    DO i=1,setup%nrrs
      IF (options%optimize%rr_initial_states(i) .NE. 0) THEN
        IF (hard) THEN
          matrix_d = parameters_d%rr_initial_states%values(:, :, i)
          matrix = parameters%rr_initial_states%values(:, :, i)
        ELSE
          matrix_d = parameters_d%rr_initial_states%values(:, :, i) - &
&           parameters_bkg_d%rr_initial_states%values(:, :, i)
          matrix = parameters%rr_initial_states%values(:, :, i) - &
&           parameters_bkg%rr_initial_states%values(:, :, i)
        END IF
        result1_d = SMOOTHING_REGULARIZATION_SPATIAL_LOOP_D(mesh, matrix&
&         , matrix_d, result1)
        res_d = res_d + result1_d
        res = res + result1
      END IF
    END DO
  END FUNCTION SMOOTHING_REGULARIZATION_D

!  Differentiation of smoothing_regularization in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: res *(parameters.control.x)
!                *(parameters.rr_parameters.values) *(parameters.rr_initial_states.values)
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_parameters.values)
!                *(parameters.rr_initial_states.values)
!   Plus diff mem management of: parameters.control.x:in parameters.control.l:in
!                parameters.control.u:in parameters.control.l_raw:in
!                parameters.control.u_raw:in parameters.rr_parameters.values:in
!                parameters.rr_initial_states.values:in parameters.serr_mu_parameters.values:in
!                parameters.serr_sigma_parameters.values:in parameters.nn_parameters.weight_1:in
!                parameters.nn_parameters.bias_1:in parameters.nn_parameters.weight_2:in
!                parameters.nn_parameters.bias_2:in parameters.nn_parameters.weight_3:in
!                parameters.nn_parameters.bias_3:in
  SUBROUTINE SMOOTHING_REGULARIZATION_B(setup, mesh, input_data, &
&   parameters, parameters_b, options, hard, res_b1)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(IN) :: parameters
    TYPE(PARAMETERSDT) :: parameters_b
    TYPE(OPTIONSDT), INTENT(IN) :: options
    LOGICAL :: hard
    REAL(sp) :: res
    REAL(sp) :: res_b1
    INTEGER :: i
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: matrix
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: matrix_b
    TYPE(PARAMETERSDT) :: parameters_bkg
    TYPE(PARAMETERSDT) :: parameters_bkg_b
    REAL(sp) :: result1
    REAL(sp) :: result1_b
    REAL(sp) :: res0
    REAL(sp) :: res_b
    REAL(sp) :: res1
    REAL(sp) :: res_b0
    INTEGER :: branch
! This allows to retrieve a parameters structure with background values
    parameters_bkg_b = parameters_b
    parameters_bkg = parameters
    CALL PUSHREAL4ARRAY(parameters_bkg%control%x, SIZE(parameters_bkg%&
&                 control%x, 1))
    parameters_bkg%control%x = parameters%control%x_raw
    CALL PUSHREAL4ARRAY(parameters_bkg%control%x, SIZE(parameters_bkg%&
&                 control%x, 1))
    CALL CONTROL_TFM(parameters_bkg, options)
    CALL PUSHREAL4ARRAY(parameters_bkg%control%x, SIZE(parameters_bkg%&
&                 control%x, 1))
    CALL PUSHREAL4ARRAY(parameters_bkg%rr_parameters%values, SIZE(&
&                 parameters_bkg%rr_parameters%values, 1)*SIZE(&
&                 parameters_bkg%rr_parameters%values, 2)*SIZE(&
&                 parameters_bkg%rr_parameters%values, 3))
    CALL PUSHREAL4ARRAY(parameters_bkg%rr_initial_states%values, SIZE(&
&                 parameters_bkg%rr_initial_states%values, 1)*SIZE(&
&                 parameters_bkg%rr_initial_states%values, 2)*SIZE(&
&                 parameters_bkg%rr_initial_states%values, 3))
    CALL PUSHREAL4ARRAY(parameters_bkg%nn_parameters%weight_1, SIZE(&
&                 parameters_bkg%nn_parameters%weight_1, 1)*SIZE(&
&                 parameters_bkg%nn_parameters%weight_1, 2))
    CALL PUSHREAL4ARRAY(parameters_bkg%nn_parameters%bias_1, SIZE(&
&                 parameters_bkg%nn_parameters%bias_1, 1))
    CALL PUSHREAL4ARRAY(parameters_bkg%nn_parameters%weight_2, SIZE(&
&                 parameters_bkg%nn_parameters%weight_2, 1)*SIZE(&
&                 parameters_bkg%nn_parameters%weight_2, 2))
    CALL PUSHREAL4ARRAY(parameters_bkg%nn_parameters%bias_2, SIZE(&
&                 parameters_bkg%nn_parameters%bias_2, 1))
    CALL PUSHREAL4ARRAY(parameters_bkg%nn_parameters%weight_3, SIZE(&
&                 parameters_bkg%nn_parameters%weight_3, 1)*SIZE(&
&                 parameters_bkg%nn_parameters%weight_3, 2))
    CALL PUSHREAL4ARRAY(parameters_bkg%nn_parameters%bias_3, SIZE(&
&                 parameters_bkg%nn_parameters%bias_3, 1))
    CALL CONTROL_TO_PARAMETERS(setup, mesh, input_data, parameters_bkg, &
&                        options)
! Loop on rr_parameters
    DO i=1,setup%nrrp
      IF (options%optimize%rr_parameters(i) .EQ. 0) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        IF (hard) THEN
          CALL PUSHREAL4ARRAY(matrix, mesh%nrow*mesh%ncol)
          matrix = parameters%rr_parameters%values(:, :, i)
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHREAL4ARRAY(matrix, mesh%nrow*mesh%ncol)
          matrix = parameters%rr_parameters%values(:, :, i) - &
&           parameters_bkg%rr_parameters%values(:, :, i)
          CALL PUSHCONTROL1B(1)
        END IF
        res0 = SMOOTHING_REGULARIZATION_SPATIAL_LOOP(mesh, matrix)
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
! Loop on rr_initial_states
    DO i=1,setup%nrrs
      IF (options%optimize%rr_initial_states(i) .EQ. 0) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        IF (hard) THEN
          CALL PUSHREAL4ARRAY(matrix, mesh%nrow*mesh%ncol)
          matrix = parameters%rr_initial_states%values(:, :, i)
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHREAL4ARRAY(matrix, mesh%nrow*mesh%ncol)
          matrix = parameters%rr_initial_states%values(:, :, i) - &
&           parameters_bkg%rr_initial_states%values(:, :, i)
          CALL PUSHCONTROL1B(1)
        END IF
        res1 = SMOOTHING_REGULARIZATION_SPATIAL_LOOP(mesh, matrix)
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
    DO i=setup%nrrs,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        result1_b = res_b1
        matrix_b = 0.0_4
        res_b0 = result1_b
        CALL SMOOTHING_REGULARIZATION_SPATIAL_LOOP_B(mesh, matrix, &
&                                              matrix_b, res_b0)
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          CALL POPREAL4ARRAY(matrix, mesh%nrow*mesh%ncol)
          parameters_b%rr_initial_states%values(:, :, i) = parameters_b%&
&           rr_initial_states%values(:, :, i) + matrix_b
        ELSE
          CALL POPREAL4ARRAY(matrix, mesh%nrow*mesh%ncol)
          parameters_b%rr_initial_states%values(:, :, i) = parameters_b%&
&           rr_initial_states%values(:, :, i) + matrix_b
          parameters_bkg_b%rr_initial_states%values(:, :, i) = &
&           parameters_bkg_b%rr_initial_states%values(:, :, i) - &
&           matrix_b
        END IF
      END IF
    END DO
    DO i=setup%nrrp,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        result1_b = res_b1
        matrix_b = 0.0_4
        res_b = result1_b
        CALL SMOOTHING_REGULARIZATION_SPATIAL_LOOP_B(mesh, matrix, &
&                                              matrix_b, res_b)
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          CALL POPREAL4ARRAY(matrix, mesh%nrow*mesh%ncol)
          parameters_b%rr_parameters%values(:, :, i) = parameters_b%&
&           rr_parameters%values(:, :, i) + matrix_b
        ELSE
          CALL POPREAL4ARRAY(matrix, mesh%nrow*mesh%ncol)
          parameters_b%rr_parameters%values(:, :, i) = parameters_b%&
&           rr_parameters%values(:, :, i) + matrix_b
          parameters_bkg_b%rr_parameters%values(:, :, i) = &
&           parameters_bkg_b%rr_parameters%values(:, :, i) - matrix_b
        END IF
      END IF
    END DO
    CALL POPREAL4ARRAY(parameters_bkg%nn_parameters%bias_3, SIZE(&
&                parameters_bkg%nn_parameters%bias_3, 1))
    CALL POPREAL4ARRAY(parameters_bkg%nn_parameters%weight_3, SIZE(&
&                parameters_bkg%nn_parameters%weight_3, 1)*SIZE(&
&                parameters_bkg%nn_parameters%weight_3, 2))
    CALL POPREAL4ARRAY(parameters_bkg%nn_parameters%bias_2, SIZE(&
&                parameters_bkg%nn_parameters%bias_2, 1))
    CALL POPREAL4ARRAY(parameters_bkg%nn_parameters%weight_2, SIZE(&
&                parameters_bkg%nn_parameters%weight_2, 1)*SIZE(&
&                parameters_bkg%nn_parameters%weight_2, 2))
    CALL POPREAL4ARRAY(parameters_bkg%nn_parameters%bias_1, SIZE(&
&                parameters_bkg%nn_parameters%bias_1, 1))
    CALL POPREAL4ARRAY(parameters_bkg%nn_parameters%weight_1, SIZE(&
&                parameters_bkg%nn_parameters%weight_1, 1)*SIZE(&
&                parameters_bkg%nn_parameters%weight_1, 2))
    CALL POPREAL4ARRAY(parameters_bkg%rr_initial_states%values, SIZE(&
&                parameters_bkg%rr_initial_states%values, 1)*SIZE(&
&                parameters_bkg%rr_initial_states%values, 2)*SIZE(&
&                parameters_bkg%rr_initial_states%values, 3))
    CALL POPREAL4ARRAY(parameters_bkg%rr_parameters%values, SIZE(&
&                parameters_bkg%rr_parameters%values, 1)*SIZE(&
&                parameters_bkg%rr_parameters%values, 2)*SIZE(&
&                parameters_bkg%rr_parameters%values, 3))
    CALL POPREAL4ARRAY(parameters_bkg%control%x, SIZE(parameters_bkg%&
&                control%x, 1))
    parameters_b%serr_mu_parameters%values = 0.0_4
    parameters_b%serr_sigma_parameters%values = 0.0_4
    parameters_b%nn_parameters%weight_1 = 0.0_4
    parameters_b%nn_parameters%bias_1 = 0.0_4
    parameters_b%nn_parameters%weight_2 = 0.0_4
    parameters_b%nn_parameters%bias_2 = 0.0_4
    parameters_b%nn_parameters%weight_3 = 0.0_4
    parameters_b%nn_parameters%bias_3 = 0.0_4
    CALL CONTROL_TO_PARAMETERS_B(setup, mesh, input_data, parameters_bkg&
&                          , parameters_bkg_b, options)
    CALL POPREAL4ARRAY(parameters_bkg%control%x, SIZE(parameters_bkg%&
&                control%x, 1))
    CALL CONTROL_TFM_B(parameters_bkg, parameters_bkg_b, options)
    CALL POPREAL4ARRAY(parameters_bkg%control%x, SIZE(parameters_bkg%&
&                control%x, 1))
    parameters_bkg_b%control%x = 0.0_4
  END SUBROUTINE SMOOTHING_REGULARIZATION_B

  FUNCTION SMOOTHING_REGULARIZATION(setup, mesh, input_data, parameters&
&   , options, hard) RESULT (RES)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(IN) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    LOGICAL :: hard
    REAL(sp) :: res
    INTEGER :: i
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: matrix
    TYPE(PARAMETERSDT) :: parameters_bkg
    REAL(sp) :: result1
    res = 0._sp
! This allows to retrieve a parameters structure with background values
    parameters_bkg = parameters
    parameters_bkg%control%x = parameters%control%x_raw
    parameters_bkg%control%l = parameters%control%l_raw
    parameters_bkg%control%u = parameters%control%u_raw
    CALL CONTROL_TFM(parameters_bkg, options)
    CALL CONTROL_TO_PARAMETERS(setup, mesh, input_data, parameters_bkg, &
&                        options)
! Loop on rr_parameters
    DO i=1,setup%nrrp
      IF (options%optimize%rr_parameters(i) .NE. 0) THEN
        IF (hard) THEN
          matrix = parameters%rr_parameters%values(:, :, i)
        ELSE
          matrix = parameters%rr_parameters%values(:, :, i) - &
&           parameters_bkg%rr_parameters%values(:, :, i)
        END IF
        result1 = SMOOTHING_REGULARIZATION_SPATIAL_LOOP(mesh, matrix)
        res = res + result1
      END IF
    END DO
! Loop on rr_initial_states
    DO i=1,setup%nrrs
      IF (options%optimize%rr_initial_states(i) .NE. 0) THEN
        IF (hard) THEN
          matrix = parameters%rr_initial_states%values(:, :, i)
        ELSE
          matrix = parameters%rr_initial_states%values(:, :, i) - &
&           parameters_bkg%rr_initial_states%values(:, :, i)
        END IF
        result1 = SMOOTHING_REGULARIZATION_SPATIAL_LOOP(mesh, matrix)
        res = res + result1
      END IF
    END DO
  END FUNCTION SMOOTHING_REGULARIZATION

END MODULE MD_REGULARIZATION_DIFF

!%      (MWD) Module Wrapped and Differentiated.
!%
!%      Subroutine
!%      ----------
!%
!%      - discharge_transformation
!%      - bayesian_compute_cost
!%      - classical_compute_jobs
!%      - classical_compute_cost
!%      - compute_cost
!%
!%      Function
!%      --------
!%
!%      - get_range_event
MODULE MWD_COST_DIFF
!% only: compute_logPost, PriorType
  USE MWD_BAYESIAN_TOOLS_DIFF
!% only: sp, dp
  USE MD_CONSTANT
!% only: quantile1d_r
  USE MD_STATS_DIFF
!% only: nse, nnse, kge, mae, mape, mse, rmse, lgrm
  USE MWD_METRICS_DIFF
!% only: rc, rchf, rclf, rch2r, cfp, ebf, elt, eff
  USE MWD_SIGNATURES_DIFF
!% only: prior_regularization, smoothing_regularization
  USE MD_REGULARIZATION_DIFF
!% only: SetupDT
  USE MWD_SETUP
!% only: MeshDT
  USE MWD_MESH
!% only: Input_DataDT
  USE MWD_INPUT_DATA
!% only: ParametersDT
  USE MWD_PARAMETERS_DIFF
!% only: OutputDT
  USE MWD_OUTPUT_DIFF
!% only: OptionsDT
  USE MWD_OPTIONS_DIFF
!% only: ReturnsDT
  USE MWD_RETURNS_DIFF
  IMPLICIT NONE

CONTAINS
  FUNCTION GET_RANGE_EVENT(mask_event, i_event) RESULT (RES)
    IMPLICIT NONE
    INTEGER, DIMENSION(:), INTENT(IN) :: mask_event
    INTEGER, INTENT(IN) :: i_event
    INTEGER, DIMENSION(2) :: res
    INTEGER :: i
    INTRINSIC SIZE
    res = 0
    DO i=1,SIZE(mask_event)
      IF (mask_event(i) .EQ. i_event) THEN
        res(1) = i
        GOTO 100
      END IF
    END DO
 100 DO i=SIZE(mask_event),1,-1
      IF (mask_event(i) .EQ. i_event) THEN
        res(2) = i
        GOTO 110
      END IF
    END DO
 110 CONTINUE
  END FUNCTION GET_RANGE_EVENT

!  Differentiation of discharge_tranformation in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: qs
!   with respect to varying inputs: qs
  SUBROUTINE DISCHARGE_TRANFORMATION_D(tfm, qo, qs, qs_d)
    IMPLICIT NONE
    CHARACTER(len=lchar), INTENT(IN) :: tfm
    REAL(sp), DIMENSION(:), INTENT(INOUT) :: qo, qs
    REAL(sp), DIMENSION(:), INTENT(INOUT) :: qs_d
    REAL(sp) :: mean_qo, e
    INTRINSIC SIZE
    LOGICAL, DIMENSION(SIZE(qo)) :: mask
    INTRINSIC SUM
    INTRINSIC COUNT
    INTRINSIC SQRT
    REAL(sp), DIMENSION(SIZE(qs, 1)) :: temp
    mask = qo .GE. 0._sp
    mean_qo = SUM(qo, mask=mask)/COUNT(mask)
    e = 1e-2_sp*mean_qo
!% Should be reach by "keep" only. Do nothing
    SELECT CASE  (tfm) 
    CASE ('sqrt') 
      WHERE (qo .GE. 0._sp) qo = SQRT(qo + e)
      WHERE (qs .GE. 0._sp) 
        temp = SQRT(e + qs)
        WHERE (e + qs .EQ. 0.0) 
          qs_d = 0.0_4
        ELSEWHERE
          qs_d = qs_d/(2.0*temp)
        END WHERE
        qs = temp
      END WHERE
    CASE ('inv') 
      WHERE (qo .GE. 0._sp) qo = 1._sp/(qo+e)
      WHERE (qs .GE. 0._sp) 
        qs_d = -(qs_d/(e+qs)**2)
        qs = 1._sp/(qs+e)
      END WHERE
    END SELECT
  END SUBROUTINE DISCHARGE_TRANFORMATION_D

!  Differentiation of discharge_tranformation in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: qs
!   with respect to varying inputs: qs
  SUBROUTINE DISCHARGE_TRANFORMATION_B(tfm, qo, qs, qs_b)
    IMPLICIT NONE
    CHARACTER(len=lchar), INTENT(IN) :: tfm
    REAL(sp), DIMENSION(:), INTENT(INOUT) :: qo, qs
    REAL(sp), DIMENSION(:), INTENT(INOUT) :: qs_b
    REAL(sp) :: mean_qo, e
    INTRINSIC SIZE
    LOGICAL, DIMENSION(SIZE(qo)) :: mask
    INTRINSIC SUM
    INTRINSIC COUNT
    INTRINSIC SQRT
    mask = qo .GE. 0._sp
    mean_qo = SUM(qo, mask=mask)/COUNT(mask)
    e = 1e-2_sp*mean_qo
!% Should be reach by "keep" only. Do nothing
    SELECT CASE  (tfm) 
    CASE ('sqrt') 
      WHERE (qs .GE. 0._sp) 
        WHERE (e + qs .EQ. 0.0) 
          qs_b = 0.0_4
        ELSEWHERE
          qs_b = qs_b/(2.0*SQRT(e+qs))
        END WHERE
      END WHERE
    CASE ('inv') 
      WHERE (qs .GE. 0._sp) qs_b = -(qs_b/(e+qs)**2)
    END SELECT
  END SUBROUTINE DISCHARGE_TRANFORMATION_B

  SUBROUTINE DISCHARGE_TRANFORMATION(tfm, qo, qs)
    IMPLICIT NONE
    CHARACTER(len=lchar), INTENT(IN) :: tfm
    REAL(sp), DIMENSION(:), INTENT(INOUT) :: qo, qs
    REAL(sp) :: mean_qo, e
    INTRINSIC SIZE
    LOGICAL, DIMENSION(SIZE(qo)) :: mask
    INTRINSIC SUM
    INTRINSIC COUNT
    INTRINSIC SQRT
    mask = qo .GE. 0._sp
    mean_qo = SUM(qo, mask=mask)/COUNT(mask)
    e = 1e-2_sp*mean_qo
!% Should be reach by "keep" only. Do nothing
    SELECT CASE  (tfm) 
    CASE ('sqrt') 
      WHERE (qo .GE. 0._sp) qo = SQRT(qo + e)
      WHERE (qs .GE. 0._sp) qs = SQRT(qs + e)
    CASE ('inv') 
      WHERE (qo .GE. 0._sp) qo = 1._sp/(qo+e)
      WHERE (qs .GE. 0._sp) qs = 1._sp/(qs+e)
    END SELECT
  END SUBROUTINE DISCHARGE_TRANFORMATION

!  Differentiation of bayesian_compute_cost in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: output.cost
!   with respect to varying inputs: *(parameters.control.x) *(parameters.serr_mu_parameters.values)
!                *(parameters.serr_sigma_parameters.values) *(output.response.q)
!   Plus diff mem management of: parameters.control.x:in parameters.serr_mu_parameters.values:in
!                parameters.serr_sigma_parameters.values:in output.response.q:in
  SUBROUTINE BAYESIAN_COMPUTE_COST_D(setup, mesh, input_data, parameters&
&   , parameters_d, output, output_d, options, returns)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(IN) :: parameters
    TYPE(PARAMETERSDT), INTENT(IN) :: parameters_d
    TYPE(OUTPUTDT), INTENT(INOUT) :: output
    TYPE(OUTPUTDT), INTENT(INOUT) :: output_d
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER :: i, j, n
    REAL(dp) :: log_lkh, log_prior, log_h, log_post
    REAL(dp) :: log_post_d
    LOGICAL :: feas, isnull
    CHARACTER(len=lchar) :: mu_funk, sigma_funk
    REAL(dp), DIMENSION(setup%ntime_step, options%cost%nog) :: obs, uobs&
&   , sim
    REAL(dp), DIMENSION(setup%ntime_step, options%cost%nog) :: sim_d
    INTRINSIC SUM
    REAL(dp), DIMENSION(SUM(parameters%control%nbk(1:2))) :: theta
    REAL(dp), DIMENSION(SUM(parameters%control%nbk(1:2))) :: theta_d
    REAL(dp), DIMENSION(setup%nsep_mu, options%cost%nog) :: mu_gamma
    REAL(dp), DIMENSION(setup%nsep_mu, options%cost%nog) :: mu_gamma_d
    REAL(dp), DIMENSION(setup%nsep_sigma, options%cost%nog) :: &
&   sigma_gamma
    REAL(dp), DIMENSION(setup%nsep_sigma, options%cost%nog) :: &
&   sigma_gamma_d
! Derived Type from md_BayesianTools
    TYPE(PRIORTYPE), DIMENSION(SUM(parameters%control%nbk(1:2))) :: &
&   theta_prior
    TYPE(PRIORTYPE), DIMENSION(0, 0) :: mu_gamma_prior, &
&   sigma_gamma_prior, dummy_prior2d
    INTRINSIC REAL
    INTRINSIC SIZE
    INTEGER :: temp
    j = 0
    sigma_gamma_d = 0.0_8
    mu_gamma_d = 0.0_8
    sim_d = 0.0_8
    DO i=1,mesh%ng
      IF (options%cost%gauge(i) .NE. 0) THEN
        j = j + 1
        obs(:, j) = input_data%response_data%q(i, options%cost%&
&         end_warmup:setup%ntime_step)
        uobs(:, j) = input_data%u_response_data%q_stdev(i, options%cost%&
&         end_warmup:setup%ntime_step)
        sim_d(:, j) = output_d%response%q(i, options%cost%end_warmup:&
&         setup%ntime_step)
        sim(:, j) = output%response%q(i, options%cost%end_warmup:setup%&
&         ntime_step)
        mu_gamma_d(:, j) = parameters_d%serr_mu_parameters%values(i, :)
        mu_gamma(:, j) = parameters%serr_mu_parameters%values(i, :)
        sigma_gamma_d(:, j) = parameters_d%serr_sigma_parameters%values(&
&         i, :)
        sigma_gamma(:, j) = parameters%serr_sigma_parameters%values(i, :&
&         )
      END IF
    END DO
! TODO: For the moment only priors for theta are handled.
! Priors for mu_gamma and sigma_gamma are hard-coded to non-informative dummy_prior2d
    obs = REAL(obs, dp)
    uobs = REAL(uobs, dp)
    sim_d = REAL(sim_d, dp)
    sim = REAL(sim, dp)
    n = SUM(parameters%control%nbk(1:2))
    IF (n .GT. 0) THEN
      theta_d = parameters_d%control%x(1:n)
      theta = parameters%control%x(1:n)
      theta_prior = options%cost%control_prior(1:n)
    ELSE
      theta_d = 0.0_8
    END IF
    mu_funk = setup%serr_mu_mapping
    mu_gamma_d = REAL(mu_gamma_d, dp)
    mu_gamma = REAL(mu_gamma, dp)
    mu_gamma_prior = dummy_prior2d
    sigma_funk = setup%serr_sigma_mapping
    sigma_gamma_d = REAL(sigma_gamma_d, dp)
    sigma_gamma = REAL(sigma_gamma, dp)
    sigma_gamma_prior = dummy_prior2d
    CALL COMPUTE_LOGPOST_D(obs, uobs, sim, sim_d, theta, theta_d, &
&                    theta_prior, mu_funk, mu_gamma, mu_gamma_d, &
&                    mu_gamma_prior, sigma_funk, sigma_gamma, &
&                    sigma_gamma_d, sigma_gamma_prior, log_post, &
&                    log_post_d, log_prior, log_lkh, log_h, feas, isnull&
&                   )
! TODO: Should be count(obs .ge. 0._sp .and. uobs .ge. 0._sp)
    temp = SIZE(obs)
    output_d%cost = -(REAL(log_post_d, sp)/temp)
  END SUBROUTINE BAYESIAN_COMPUTE_COST_D

!  Differentiation of bayesian_compute_cost in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: output.cost
!   with respect to varying inputs: *(parameters.control.x) *(parameters.serr_mu_parameters.values)
!                *(parameters.serr_sigma_parameters.values) *(output.response.q)
!   Plus diff mem management of: parameters.control.x:in parameters.serr_mu_parameters.values:in
!                parameters.serr_sigma_parameters.values:in output.response.q:in
  SUBROUTINE BAYESIAN_COMPUTE_COST_B(setup, mesh, input_data, parameters&
&   , parameters_b, output, output_b, options, returns)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(IN) :: parameters
    TYPE(PARAMETERSDT) :: parameters_b
    TYPE(OUTPUTDT), INTENT(INOUT) :: output
    TYPE(OUTPUTDT), INTENT(INOUT) :: output_b
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER :: i, j, n
    REAL(dp) :: log_lkh, log_prior, log_h, log_post
    REAL(dp) :: log_post_b
    LOGICAL :: feas, isnull
    CHARACTER(len=lchar) :: mu_funk, sigma_funk
    REAL(dp), DIMENSION(setup%ntime_step, options%cost%nog) :: obs, uobs&
&   , sim
    REAL(dp), DIMENSION(setup%ntime_step, options%cost%nog) :: sim_b
    INTRINSIC SUM
    REAL(dp), DIMENSION(SUM(parameters%control%nbk(1:2))) :: theta
    REAL(dp), DIMENSION(SUM(parameters%control%nbk(1:2))) :: theta_b
    REAL(dp), DIMENSION(setup%nsep_mu, options%cost%nog) :: mu_gamma
    REAL(dp), DIMENSION(setup%nsep_mu, options%cost%nog) :: mu_gamma_b
    REAL(dp), DIMENSION(setup%nsep_sigma, options%cost%nog) :: &
&   sigma_gamma
    REAL(dp), DIMENSION(setup%nsep_sigma, options%cost%nog) :: &
&   sigma_gamma_b
! Derived Type from md_BayesianTools
    TYPE(PRIORTYPE), DIMENSION(SUM(parameters%control%nbk(1:2))) :: &
&   theta_prior
    TYPE(PRIORTYPE), DIMENSION(0, 0) :: mu_gamma_prior, &
&   sigma_gamma_prior, dummy_prior2d
    INTRINSIC REAL
    INTRINSIC SIZE
    INTEGER :: branch
    j = 0
    DO i=1,mesh%ng
      IF (options%cost%gauge(i) .EQ. 0) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHINTEGER4(j)
        j = j + 1
        obs(:, j) = input_data%response_data%q(i, options%cost%&
&         end_warmup:setup%ntime_step)
        uobs(:, j) = input_data%u_response_data%q_stdev(i, options%cost%&
&         end_warmup:setup%ntime_step)
        sim(:, j) = output%response%q(i, options%cost%end_warmup:setup%&
&         ntime_step)
        mu_gamma(:, j) = parameters%serr_mu_parameters%values(i, :)
        sigma_gamma(:, j) = parameters%serr_sigma_parameters%values(i, :&
&         )
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
! TODO: For the moment only priors for theta are handled.
! Priors for mu_gamma and sigma_gamma are hard-coded to non-informative dummy_prior2d
    obs = REAL(obs, dp)
    uobs = REAL(uobs, dp)
    sim = REAL(sim, dp)
    n = SUM(parameters%control%nbk(1:2))
    IF (n .GT. 0) THEN
      theta = parameters%control%x(1:n)
      theta_prior = options%cost%control_prior(1:n)
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHCONTROL1B(1)
    END IF
    mu_funk = setup%serr_mu_mapping
    mu_gamma = REAL(mu_gamma, dp)
    mu_gamma_prior = dummy_prior2d
    sigma_funk = setup%serr_sigma_mapping
    sigma_gamma = REAL(sigma_gamma, dp)
    sigma_gamma_prior = dummy_prior2d
    CALL COMPUTE_LOGPOST(obs, uobs, sim, theta, theta_prior, mu_funk, &
&                  mu_gamma, mu_gamma_prior, sigma_funk, sigma_gamma, &
&                  sigma_gamma_prior, log_post, log_prior, log_lkh, &
&                  log_h, feas, isnull)
! TODO: Should be count(obs .ge. 0._sp .and. uobs .ge. 0._sp)
    log_post_b = -(output_b%cost/SIZE(obs))
    mu_funk = setup%serr_mu_mapping
    sigma_funk = setup%serr_sigma_mapping
    CALL COMPUTE_LOGPOST_B(obs, uobs, sim, sim_b, theta, theta_b, &
&                    theta_prior, mu_funk, mu_gamma, mu_gamma_b, &
&                    mu_gamma_prior, sigma_funk, sigma_gamma, &
&                    sigma_gamma_b, sigma_gamma_prior, log_post, &
&                    log_post_b, log_prior, log_lkh, log_h, feas, isnull&
&                   )
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      parameters_b%control%x = 0.0_4
      parameters_b%control%x(1:n) = parameters_b%control%x(1:n) + &
&       theta_b
    ELSE
      parameters_b%control%x = 0.0_4
    END IF
    parameters_b%serr_mu_parameters%values = 0.0_4
    parameters_b%serr_sigma_parameters%values = 0.0_4
    output_b%response%q = 0.0_4
    DO i=mesh%ng,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        parameters_b%serr_sigma_parameters%values(i, :) = parameters_b%&
&         serr_sigma_parameters%values(i, :) + sigma_gamma_b(:, j)
        sigma_gamma_b(:, j) = 0.0_8
        parameters_b%serr_mu_parameters%values(i, :) = parameters_b%&
&         serr_mu_parameters%values(i, :) + mu_gamma_b(:, j)
        mu_gamma_b(:, j) = 0.0_8
        output_b%response%q(i, options%cost%end_warmup:setup%ntime_step)&
&        = output_b%response%q(i, options%cost%end_warmup:setup%&
&         ntime_step) + sim_b(:, j)
        sim_b(:, j) = 0.0_8
        CALL POPINTEGER4(j)
      END IF
    END DO
  END SUBROUTINE BAYESIAN_COMPUTE_COST_B

  SUBROUTINE BAYESIAN_COMPUTE_COST(setup, mesh, input_data, parameters, &
&   output, options, returns)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(IN) :: parameters
    TYPE(OUTPUTDT), INTENT(INOUT) :: output
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER :: i, j, n
    REAL(dp) :: log_lkh, log_prior, log_h, log_post
    LOGICAL :: feas, isnull
    CHARACTER(len=lchar) :: mu_funk, sigma_funk
    REAL(dp), DIMENSION(setup%ntime_step, options%cost%nog) :: obs, uobs&
&   , sim
    INTRINSIC SUM
    REAL(dp), DIMENSION(SUM(parameters%control%nbk(1:2))) :: theta
    REAL(dp), DIMENSION(setup%nsep_mu, options%cost%nog) :: mu_gamma
    REAL(dp), DIMENSION(setup%nsep_sigma, options%cost%nog) :: &
&   sigma_gamma
! Derived Type from md_BayesianTools
    TYPE(PRIORTYPE), DIMENSION(SUM(parameters%control%nbk(1:2))) :: &
&   theta_prior
    TYPE(PRIORTYPE), DIMENSION(0, 0) :: mu_gamma_prior, &
&   sigma_gamma_prior, dummy_prior2d
    INTRINSIC REAL
    INTRINSIC SIZE
    j = 0
    DO i=1,mesh%ng
      IF (options%cost%gauge(i) .NE. 0) THEN
        j = j + 1
        obs(:, j) = input_data%response_data%q(i, options%cost%&
&         end_warmup:setup%ntime_step)
        uobs(:, j) = input_data%u_response_data%q_stdev(i, options%cost%&
&         end_warmup:setup%ntime_step)
        sim(:, j) = output%response%q(i, options%cost%end_warmup:setup%&
&         ntime_step)
        mu_gamma(:, j) = parameters%serr_mu_parameters%values(i, :)
        sigma_gamma(:, j) = parameters%serr_sigma_parameters%values(i, :&
&         )
      END IF
    END DO
! TODO: For the moment only priors for theta are handled.
! Priors for mu_gamma and sigma_gamma are hard-coded to non-informative dummy_prior2d
    obs = REAL(obs, dp)
    uobs = REAL(uobs, dp)
    sim = REAL(sim, dp)
    n = SUM(parameters%control%nbk(1:2))
    IF (n .GT. 0) THEN
      theta = parameters%control%x(1:n)
      theta_prior = options%cost%control_prior(1:n)
    END IF
    mu_funk = setup%serr_mu_mapping
    mu_gamma = REAL(mu_gamma, dp)
    mu_gamma_prior = dummy_prior2d
    sigma_funk = setup%serr_sigma_mapping
    sigma_gamma = REAL(sigma_gamma, dp)
    sigma_gamma_prior = dummy_prior2d
    CALL COMPUTE_LOGPOST(obs, uobs, sim, theta, theta_prior, mu_funk, &
&                  mu_gamma, mu_gamma_prior, sigma_funk, sigma_gamma, &
&                  sigma_gamma_prior, log_post, log_prior, log_lkh, &
&                  log_h, feas, isnull)
! TODO: Should be count(obs .ge. 0._sp .and. uobs .ge. 0._sp)
    output%cost = -(1._sp*REAL(log_post, sp)/SIZE(obs))
  END SUBROUTINE BAYESIAN_COMPUTE_COST

!  Differentiation of classical_compute_jobs in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: jobs
!   with respect to varying inputs: *(output.response.q)
!   Plus diff mem management of: output.response.q:in
  SUBROUTINE CLASSICAL_COMPUTE_JOBS_D(setup, mesh, input_data, output, &
&   output_d, options, jobs, jobs_d)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OUTPUTDT), INTENT(IN) :: output
    TYPE(OUTPUTDT), INTENT(IN) :: output_d
    TYPE(OPTIONSDT), INTENT(IN) :: options
    REAL(sp), INTENT(INOUT) :: jobs
    REAL(sp), INTENT(INOUT) :: jobs_d
    INTEGER :: i, j, k, n_computed_event
    REAL(sp), DIMENSION(setup%ntime_step-options%cost%end_warmup+1) :: &
&   qo, qs, mprcp
    REAL(sp), DIMENSION(setup%ntime_step-options%cost%end_warmup+1) :: &
&   qo_d, qs_d
    INTEGER, DIMENSION(setup%ntime_step-options%cost%end_warmup+1) :: &
&   mask_event
    REAL(sp), DIMENSION(mesh%ng, options%cost%njoc) :: jobs_cmpt_values
    REAL(sp), DIMENSION(mesh%ng, options%cost%njoc) :: &
&   jobs_cmpt_values_d
    INTEGER, DIMENSION(2) :: range_event
    REAL(sp), DIMENSION(mesh%ng) :: jobs_gauge
    REAL(sp), DIMENSION(mesh%ng) :: jobs_gauge_d
    REAL(sp) :: jobs_tmp
    REAL(sp) :: jobs_tmp_d
    INTRINSIC ANY
    INTRINSIC ABS
    REAL(sp) :: abs0
    REAL(sp) :: result1
    REAL(sp) :: result1_d
    REAL(sp) :: temp
    jobs_cmpt_values = 0._sp
    jobs_cmpt_values_d = 0.0_4
    DO i=1,mesh%ng
! Cycle if gauge is equal to 0
      IF (options%cost%gauge(i) .NE. 0) THEN
        qo = input_data%response_data%q(i, options%cost%end_warmup:setup&
&         %ntime_step)
        qs_d = output_d%response%q(i, options%cost%end_warmup:setup%&
&         ntime_step)
        qs = output%response%q(i, options%cost%end_warmup:setup%&
&         ntime_step)
        WHERE (qo .LT. 0._sp) 
          qs_d = 0.0_4
          qs = -99._sp
        END WHERE
! Convert mean_prcp from mm/dt to m3/s
        mprcp = input_data%atmos_data%mean_prcp(i, options%cost%&
&         end_warmup:setup%ntime_step)*mesh%area_dln(i)*1.e-3_sp/setup%&
&         dt
        mask_event = options%cost%mask_event(i, options%cost%end_warmup:&
&         setup%ntime_step)
        DO j=1,options%cost%njoc
          CALL DISCHARGE_TRANFORMATION_D(options%cost%jobs_cmpt_tfm(j), &
&                                  qo, qs, qs_d)
! Should be unreachable.
          SELECT CASE  (options%cost%jobs_cmpt(j)) 
          CASE ('nse') 
! Efficiency Metrics
            result1_d = NSE_D(qo, qs, qs_d, result1)
            jobs_cmpt_values_d(i, j) = -result1_d
            jobs_cmpt_values(i, j) = 1._sp - result1
          CASE ('nnse') 
            result1_d = NNSE_D(qo, qs, qs_d, result1)
            jobs_cmpt_values_d(i, j) = -result1_d
            jobs_cmpt_values(i, j) = 1._sp - result1
          CASE ('kge') 
            result1_d = KGE_D(qo, qs, qs_d, result1)
            jobs_cmpt_values_d(i, j) = -result1_d
            jobs_cmpt_values(i, j) = 1._sp - result1
          CASE ('mae') 
            jobs_cmpt_values_d(i, j) = MAE_D(qo, qs, qs_d, &
&             jobs_cmpt_values(i, j))
          CASE ('mape') 
            jobs_cmpt_values_d(i, j) = MAPE_D(qo, qs, qs_d, &
&             jobs_cmpt_values(i, j))
          CASE ('mse') 
            jobs_cmpt_values_d(i, j) = MSE_D(qo, qs, qs_d, &
&             jobs_cmpt_values(i, j))
          CASE ('rmse') 
            jobs_cmpt_values_d(i, j) = RMSE_D(qo, qs, qs_d, &
&             jobs_cmpt_values(i, j))
          CASE ('lgrm') 
            jobs_cmpt_values_d(i, j) = LGRM_D(qo, qs, qs_d, &
&             jobs_cmpt_values(i, j))
          CASE ('Crc') 
! Continuous Signatures
            jobs_tmp = RC(mprcp, qo)
            IF (jobs_tmp .GT. 0._sp) THEN
              result1_d = RC_D(mprcp, qs, qs_d, result1)
              jobs_cmpt_values_d(i, j) = 2*(result1/jobs_tmp-1._sp)*&
&               result1_d/jobs_tmp
              jobs_cmpt_values(i, j) = (result1/jobs_tmp-1._sp)**2
            END IF
          CASE ('Crchf') 
            jobs_tmp = RCHF(mprcp, qo)
            IF (jobs_tmp .GT. 0._sp) THEN
              result1_d = RCHF_D(mprcp, qs, qs_d, result1)
              jobs_cmpt_values_d(i, j) = 2*(result1/jobs_tmp-1._sp)*&
&               result1_d/jobs_tmp
              jobs_cmpt_values(i, j) = (result1/jobs_tmp-1._sp)**2
            END IF
          CASE ('Crclf') 
            jobs_tmp = RCLF(mprcp, qo)
            IF (jobs_tmp .GT. 0._sp) THEN
              result1_d = RCLF_D(mprcp, qs, qs_d, result1)
              jobs_cmpt_values_d(i, j) = 2*(result1/jobs_tmp-1._sp)*&
&               result1_d/jobs_tmp
              jobs_cmpt_values(i, j) = (result1/jobs_tmp-1._sp)**2
            END IF
          CASE ('Crch2r') 
            jobs_tmp = RCH2R(mprcp, qo)
            IF (jobs_tmp .GT. 0._sp) THEN
              result1_d = RCH2R_D(mprcp, qs, qs_d, result1)
              jobs_cmpt_values_d(i, j) = 2*(result1/jobs_tmp-1._sp)*&
&               result1_d/jobs_tmp
              jobs_cmpt_values(i, j) = (result1/jobs_tmp-1._sp)**2
            END IF
          CASE ('Cfp2') 
            jobs_tmp = CFP(qo, 0.02_sp)
            IF (jobs_tmp .GT. 0._sp) THEN
              result1_d = CFP_D(qs, qs_d, 0.02_sp, result1)
              jobs_cmpt_values_d(i, j) = 2*(result1/jobs_tmp-1._sp)*&
&               result1_d/jobs_tmp
              jobs_cmpt_values(i, j) = (result1/jobs_tmp-1._sp)**2
            END IF
          CASE ('Cfp10') 
            jobs_tmp = CFP(qo, 0.1_sp)
            IF (jobs_tmp .GT. 0._sp) THEN
              result1_d = CFP_D(qs, qs_d, 0.1_sp, result1)
              jobs_cmpt_values_d(i, j) = 2*(result1/jobs_tmp-1._sp)*&
&               result1_d/jobs_tmp
              jobs_cmpt_values(i, j) = (result1/jobs_tmp-1._sp)**2
            END IF
          CASE ('Cfp50') 
            jobs_tmp = CFP(qo, 0.5_sp)
            IF (jobs_tmp .GT. 0._sp) THEN
              result1_d = CFP_D(qs, qs_d, 0.5_sp, result1)
              jobs_cmpt_values_d(i, j) = 2*(result1/jobs_tmp-1._sp)*&
&               result1_d/jobs_tmp
              jobs_cmpt_values(i, j) = (result1/jobs_tmp-1._sp)**2
            END IF
          CASE ('Cfp90') 
            jobs_tmp = CFP(qo, 0.9_sp)
            IF (jobs_tmp .GT. 0._sp) THEN
              result1_d = CFP_D(qs, qs_d, 0.9_sp, result1)
              jobs_cmpt_values_d(i, j) = 2*(result1/jobs_tmp-1._sp)*&
&               result1_d/jobs_tmp
              jobs_cmpt_values(i, j) = (result1/jobs_tmp-1._sp)**2
            END IF
          CASE ('Erc') 
! Event Signatures
            n_computed_event = 0
            DO k=1,options%cost%n_event(i)
              range_event = GET_RANGE_EVENT(mask_event, k)
              IF (range_event(1) .GE. 1) THEN
                jobs_tmp = RC(mprcp(range_event(1):range_event(2)), qo(&
&                 range_event(1):range_event(2)))
                IF (jobs_tmp .GT. 0._sp) THEN
                  result1_d = RC_D(mprcp(range_event(1):range_event(2))&
&                   , qs(range_event(1):range_event(2)), qs_d(&
&                   range_event(1):range_event(2)), result1)
                  jobs_cmpt_values_d(i, j) = jobs_cmpt_values_d(i, j) + &
&                   2*(result1/jobs_tmp-1._sp)*result1_d/jobs_tmp
                  jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j) + (&
&                   result1/jobs_tmp-1._sp)**2
                  n_computed_event = n_computed_event + 1
                END IF
              END IF
            END DO
            jobs_cmpt_values_d(i, j) = jobs_cmpt_values_d(i, j)/&
&             n_computed_event
            jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j)/&
&             n_computed_event
          CASE ('Erchf') 
            n_computed_event = 0
            DO k=1,options%cost%n_event(i)
              range_event = GET_RANGE_EVENT(mask_event, k)
              IF (range_event(1) .GE. 1) THEN
                jobs_tmp = RCHF(mprcp(range_event(1):range_event(2)), qo&
&                 (range_event(1):range_event(2)))
                IF (jobs_tmp .GT. 0._sp) THEN
                  result1_d = RCHF_D(mprcp(range_event(1):range_event(2)&
&                   ), qs(range_event(1):range_event(2)), qs_d(&
&                   range_event(1):range_event(2)), result1)
                  jobs_cmpt_values_d(i, j) = jobs_cmpt_values_d(i, j) + &
&                   2*(result1/jobs_tmp-1._sp)*result1_d/jobs_tmp
                  jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j) + (&
&                   result1/jobs_tmp-1._sp)**2
                  n_computed_event = n_computed_event + 1
                END IF
              END IF
            END DO
            jobs_cmpt_values_d(i, j) = jobs_cmpt_values_d(i, j)/&
&             n_computed_event
            jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j)/&
&             n_computed_event
          CASE ('Erclf') 
            n_computed_event = 0
            DO k=1,options%cost%n_event(i)
              range_event = GET_RANGE_EVENT(mask_event, k)
              IF (range_event(1) .GE. 1) THEN
                jobs_tmp = RCLF(mprcp(range_event(1):range_event(2)), qo&
&                 (range_event(1):range_event(2)))
                IF (jobs_tmp .GT. 0._sp) THEN
                  result1_d = RCLF_D(mprcp(range_event(1):range_event(2)&
&                   ), qs(range_event(1):range_event(2)), qs_d(&
&                   range_event(1):range_event(2)), result1)
                  jobs_cmpt_values_d(i, j) = jobs_cmpt_values_d(i, j) + &
&                   2*(result1/jobs_tmp-1._sp)*result1_d/jobs_tmp
                  jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j) + (&
&                   result1/jobs_tmp-1._sp)**2
                  n_computed_event = n_computed_event + 1
                END IF
              END IF
            END DO
            jobs_cmpt_values_d(i, j) = jobs_cmpt_values_d(i, j)/&
&             n_computed_event
            jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j)/&
&             n_computed_event
          CASE ('Erch2r') 
            n_computed_event = 0
            DO k=1,options%cost%n_event(i)
              range_event = GET_RANGE_EVENT(mask_event, k)
              IF (range_event(1) .GE. 1) THEN
                jobs_tmp = RCH2R(mprcp(range_event(1):range_event(2)), &
&                 qo(range_event(1):range_event(2)))
                IF (jobs_tmp .GT. 0._sp) THEN
                  result1_d = RCH2R_D(mprcp(range_event(1):range_event(2&
&                   )), qs(range_event(1):range_event(2)), qs_d(&
&                   range_event(1):range_event(2)), result1)
                  jobs_cmpt_values_d(i, j) = jobs_cmpt_values_d(i, j) + &
&                   2*(result1/jobs_tmp-1._sp)*result1_d/jobs_tmp
                  jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j) + (&
&                   result1/jobs_tmp-1._sp)**2
                  n_computed_event = n_computed_event + 1
                END IF
              END IF
            END DO
            jobs_cmpt_values_d(i, j) = jobs_cmpt_values_d(i, j)/&
&             n_computed_event
            jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j)/&
&             n_computed_event
          CASE ('Eff') 
            n_computed_event = 0
            DO k=1,options%cost%n_event(i)
              range_event = GET_RANGE_EVENT(mask_event, k)
              IF (range_event(1) .GE. 1) THEN
                jobs_tmp = EFF(qo(range_event(1):range_event(2)))
                IF (jobs_tmp .GT. 0._sp) THEN
                  result1_d = EFF_D(qs(range_event(1):range_event(2)), &
&                   qs_d(range_event(1):range_event(2)), result1)
                  jobs_cmpt_values_d(i, j) = jobs_cmpt_values_d(i, j) + &
&                   2*(result1/jobs_tmp-1._sp)*result1_d/jobs_tmp
                  jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j) + (&
&                   result1/jobs_tmp-1._sp)**2
                  n_computed_event = n_computed_event + 1
                END IF
              END IF
            END DO
            jobs_cmpt_values_d(i, j) = jobs_cmpt_values_d(i, j)/&
&             n_computed_event
            jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j)/&
&             n_computed_event
          CASE ('Ebf') 
            n_computed_event = 0
            DO k=1,options%cost%n_event(i)
              range_event = GET_RANGE_EVENT(mask_event, k)
              IF (range_event(1) .GE. 1) THEN
                jobs_tmp = EBF(qo(range_event(1):range_event(2)))
                IF (jobs_tmp .GT. 0._sp) THEN
                  result1_d = EBF_D(qs(range_event(1):range_event(2)), &
&                   qs_d(range_event(1):range_event(2)), result1)
                  jobs_cmpt_values_d(i, j) = jobs_cmpt_values_d(i, j) + &
&                   2*(result1/jobs_tmp-1._sp)*result1_d/jobs_tmp
                  jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j) + (&
&                   result1/jobs_tmp-1._sp)**2
                  n_computed_event = n_computed_event + 1
                END IF
              END IF
            END DO
            jobs_cmpt_values_d(i, j) = jobs_cmpt_values_d(i, j)/&
&             n_computed_event
            jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j)/&
&             n_computed_event
          CASE ('Elt') 
            n_computed_event = 0
            DO k=1,options%cost%n_event(i)
              range_event = GET_RANGE_EVENT(mask_event, k)
              IF (range_event(1) .GE. 1) THEN
                jobs_tmp = ELT(mprcp(range_event(1):range_event(2)), qo(&
&                 range_event(1):range_event(2)))
                IF (jobs_tmp .GT. 0._sp) THEN
                  result1 = ELT(mprcp(range_event(1):range_event(2)), qs&
&                   (range_event(1):range_event(2)))
                  jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j) + (&
&                   result1/jobs_tmp-1._sp)**2
                  n_computed_event = n_computed_event + 1
                END IF
              END IF
            END DO
            jobs_cmpt_values_d(i, j) = jobs_cmpt_values_d(i, j)/&
&             n_computed_event
            jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j)/&
&             n_computed_event
          CASE ('Epf') 
            n_computed_event = 0
            DO k=1,options%cost%n_event(i)
              range_event = GET_RANGE_EVENT(mask_event, k)
              IF (range_event(1) .GE. 1) THEN
                jobs_tmp = EPF(qo(range_event(1):range_event(2)))
                IF (jobs_tmp .GT. 0._sp) THEN
                  result1_d = EPF_D(qs(range_event(1):range_event(2)), &
&                   qs_d(range_event(1):range_event(2)), result1)
                  jobs_cmpt_values_d(i, j) = jobs_cmpt_values_d(i, j) + &
&                   2*(result1/jobs_tmp-1._sp)*result1_d/jobs_tmp
                  jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j) + (&
&                   result1/jobs_tmp-1._sp)**2
                  n_computed_event = n_computed_event + 1
                END IF
              END IF
            END DO
            jobs_cmpt_values_d(i, j) = jobs_cmpt_values_d(i, j)/&
&             n_computed_event
            jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j)/&
&             n_computed_event
          END SELECT
        END DO
      END IF
    END DO
! TODO TH: handle with alias (median, low/upp quartiles) for jobs_cmpt
    IF (ANY(options%cost%wgauge(:) .LT. 0._sp)) THEN
      jobs_gauge = 0._sp
      k = 0
      jobs_gauge_d = 0.0_4
      DO i=1,mesh%ng
        IF (options%cost%gauge(i) .NE. 0) THEN
          jobs_tmp = 0._sp
          jobs_tmp_d = 0.0_4
          DO j=1,options%cost%njoc
            jobs_tmp_d = jobs_tmp_d + options%cost%wjobs_cmpt(j)*&
&             jobs_cmpt_values_d(i, j)
            jobs_tmp = jobs_tmp + options%cost%wjobs_cmpt(j)*&
&             jobs_cmpt_values(i, j)
          END DO
          k = k + 1
          jobs_gauge_d(k) = jobs_tmp_d
          jobs_gauge(k) = jobs_tmp
        END IF
      END DO
      IF (options%cost%wgauge(1) .GE. 0.) THEN
        abs0 = options%cost%wgauge(1)
      ELSE
        abs0 = -options%cost%wgauge(1)
      END IF
      jobs_d = QUANTILE1D_R_D(jobs_gauge(1:k), jobs_gauge_d(1:k), abs0, &
&       jobs)
    ELSE
      jobs_d = 0.0_4
      DO i=1,mesh%ng
        DO j=1,options%cost%njoc
          temp = options%cost%wgauge(i)*options%cost%wjobs_cmpt(j)
          jobs_d = jobs_d + temp*jobs_cmpt_values_d(i, j)
        END DO
      END DO
    END IF
  END SUBROUTINE CLASSICAL_COMPUTE_JOBS_D

!  Differentiation of classical_compute_jobs in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: jobs
!   with respect to varying inputs: *(output.response.q)
!   Plus diff mem management of: output.response.q:in
  SUBROUTINE CLASSICAL_COMPUTE_JOBS_B(setup, mesh, input_data, output, &
&   output_b, options, jobs, jobs_b)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OUTPUTDT), INTENT(IN) :: output
    TYPE(OUTPUTDT) :: output_b
    TYPE(OPTIONSDT), INTENT(IN) :: options
    REAL(sp), INTENT(INOUT) :: jobs
    REAL(sp), INTENT(INOUT) :: jobs_b
    INTEGER :: i, j, k, n_computed_event
    REAL(sp), DIMENSION(setup%ntime_step-options%cost%end_warmup+1) :: &
&   qo, qs, mprcp
    REAL(sp), DIMENSION(setup%ntime_step-options%cost%end_warmup+1) :: &
&   qo_b, qs_b
    INTEGER, DIMENSION(setup%ntime_step-options%cost%end_warmup+1) :: &
&   mask_event
    REAL(sp), DIMENSION(mesh%ng, options%cost%njoc) :: jobs_cmpt_values
    REAL(sp), DIMENSION(mesh%ng, options%cost%njoc) :: &
&   jobs_cmpt_values_b
    INTEGER, DIMENSION(2) :: range_event
    REAL(sp), DIMENSION(mesh%ng) :: jobs_gauge
    REAL(sp), DIMENSION(mesh%ng) :: jobs_gauge_b
    REAL(sp) :: jobs_tmp
    REAL(sp) :: jobs_tmp_b
    INTRINSIC ANY
    INTRINSIC ABS
    REAL(sp) :: abs0
    REAL(sp) :: result1
    REAL(sp) :: result1_b
    REAL(sp) :: res
    REAL(sp) :: res_b
    INTEGER :: ad_to
    INTEGER :: branch
    INTEGER :: ad_to0
    INTEGER :: ad_to1
    INTEGER :: ad_to2
    INTEGER :: ad_to3
    INTEGER :: ad_to4
    INTEGER :: ad_to5
    INTEGER :: ad_to6
    jobs_cmpt_values = 0._sp
    DO i=1,mesh%ng
! Cycle if gauge is equal to 0
      IF (options%cost%gauge(i) .EQ. 0) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHREAL4ARRAY(qo, setup%ntime_step - options%cost%&
&                     end_warmup + 1)
        qo = input_data%response_data%q(i, options%cost%end_warmup:setup&
&         %ntime_step)
        CALL PUSHREAL4ARRAY(qs, setup%ntime_step - options%cost%&
&                     end_warmup + 1)
        qs = output%response%q(i, options%cost%end_warmup:setup%&
&         ntime_step)
        WHERE (qo .LT. 0._sp) qs = -99._sp
! Convert mean_prcp from mm/dt to m3/s
        CALL PUSHREAL4ARRAY(mprcp, setup%ntime_step - options%cost%&
&                     end_warmup + 1)
        mprcp = input_data%atmos_data%mean_prcp(i, options%cost%&
&         end_warmup:setup%ntime_step)*mesh%area_dln(i)*1.e-3_sp/setup%&
&         dt
        mask_event = options%cost%mask_event(i, options%cost%end_warmup:&
&         setup%ntime_step)
        DO j=1,options%cost%njoc
          CALL PUSHREAL4ARRAY(qs, setup%ntime_step - options%cost%&
&                       end_warmup + 1)
          CALL PUSHREAL4ARRAY(qo, setup%ntime_step - options%cost%&
&                       end_warmup + 1)
          CALL DISCHARGE_TRANFORMATION(options%cost%jobs_cmpt_tfm(j), qo&
&                                , qs)
! Should be unreachable.
          SELECT CASE  (options%cost%jobs_cmpt(j)) 
          CASE ('nse') 
! Efficiency Metrics
            CALL PUSHREAL4(result1)
            result1 = NSE(qo, qs)
            jobs_cmpt_values(i, j) = 1._sp - result1
            CALL PUSHCONTROL6B(32)
          CASE ('nnse') 
            CALL PUSHREAL4(result1)
            result1 = NNSE(qo, qs)
            jobs_cmpt_values(i, j) = 1._sp - result1
            CALL PUSHCONTROL6B(31)
          CASE ('kge') 
            CALL PUSHREAL4(result1)
            result1 = KGE(qo, qs)
            jobs_cmpt_values(i, j) = 1._sp - result1
            CALL PUSHCONTROL6B(30)
          CASE ('mae') 
            jobs_cmpt_values(i, j) = MAE(qo, qs)
            CALL PUSHCONTROL6B(29)
          CASE ('mape') 
            jobs_cmpt_values(i, j) = MAPE(qo, qs)
            CALL PUSHCONTROL6B(28)
          CASE ('mse') 
            jobs_cmpt_values(i, j) = MSE(qo, qs)
            CALL PUSHCONTROL6B(27)
          CASE ('rmse') 
            jobs_cmpt_values(i, j) = RMSE(qo, qs)
            CALL PUSHCONTROL6B(26)
          CASE ('lgrm') 
            jobs_cmpt_values(i, j) = LGRM(qo, qs)
            CALL PUSHCONTROL6B(25)
          CASE ('Crc') 
! Continuous Signatures
            CALL PUSHREAL4(jobs_tmp)
            jobs_tmp = RC(mprcp, qo)
            IF (jobs_tmp .GT. 0._sp) THEN
              CALL PUSHREAL4(result1)
              result1 = RC(mprcp, qs)
              jobs_cmpt_values(i, j) = (result1/jobs_tmp-1._sp)**2
              CALL PUSHCONTROL6B(24)
            ELSE
              CALL PUSHCONTROL6B(23)
            END IF
          CASE ('Crchf') 
            CALL PUSHREAL4(jobs_tmp)
            jobs_tmp = RCHF(mprcp, qo)
            IF (jobs_tmp .GT. 0._sp) THEN
              CALL PUSHREAL4(result1)
              result1 = RCHF(mprcp, qs)
              jobs_cmpt_values(i, j) = (result1/jobs_tmp-1._sp)**2
              CALL PUSHCONTROL6B(22)
            ELSE
              CALL PUSHCONTROL6B(21)
            END IF
          CASE ('Crclf') 
            CALL PUSHREAL4(jobs_tmp)
            jobs_tmp = RCLF(mprcp, qo)
            IF (jobs_tmp .GT. 0._sp) THEN
              CALL PUSHREAL4(result1)
              result1 = RCLF(mprcp, qs)
              jobs_cmpt_values(i, j) = (result1/jobs_tmp-1._sp)**2
              CALL PUSHCONTROL6B(20)
            ELSE
              CALL PUSHCONTROL6B(19)
            END IF
          CASE ('Crch2r') 
            CALL PUSHREAL4(jobs_tmp)
            jobs_tmp = RCH2R(mprcp, qo)
            IF (jobs_tmp .GT. 0._sp) THEN
              CALL PUSHREAL4(result1)
              result1 = RCH2R(mprcp, qs)
              jobs_cmpt_values(i, j) = (result1/jobs_tmp-1._sp)**2
              CALL PUSHCONTROL6B(18)
            ELSE
              CALL PUSHCONTROL6B(17)
            END IF
          CASE ('Cfp2') 
            CALL PUSHREAL4(jobs_tmp)
            jobs_tmp = CFP(qo, 0.02_sp)
            IF (jobs_tmp .GT. 0._sp) THEN
              CALL PUSHREAL4(result1)
              result1 = CFP(qs, 0.02_sp)
              jobs_cmpt_values(i, j) = (result1/jobs_tmp-1._sp)**2
              CALL PUSHCONTROL6B(16)
            ELSE
              CALL PUSHCONTROL6B(15)
            END IF
          CASE ('Cfp10') 
            CALL PUSHREAL4(jobs_tmp)
            jobs_tmp = CFP(qo, 0.1_sp)
            IF (jobs_tmp .GT. 0._sp) THEN
              CALL PUSHREAL4(result1)
              result1 = CFP(qs, 0.1_sp)
              jobs_cmpt_values(i, j) = (result1/jobs_tmp-1._sp)**2
              CALL PUSHCONTROL6B(14)
            ELSE
              CALL PUSHCONTROL6B(13)
            END IF
          CASE ('Cfp50') 
            CALL PUSHREAL4(jobs_tmp)
            jobs_tmp = CFP(qo, 0.5_sp)
            IF (jobs_tmp .GT. 0._sp) THEN
              CALL PUSHREAL4(result1)
              result1 = CFP(qs, 0.5_sp)
              jobs_cmpt_values(i, j) = (result1/jobs_tmp-1._sp)**2
              CALL PUSHCONTROL6B(12)
            ELSE
              CALL PUSHCONTROL6B(11)
            END IF
          CASE ('Cfp90') 
            CALL PUSHREAL4(jobs_tmp)
            jobs_tmp = CFP(qo, 0.9_sp)
            IF (jobs_tmp .GT. 0._sp) THEN
              CALL PUSHREAL4(result1)
              result1 = CFP(qs, 0.9_sp)
              jobs_cmpt_values(i, j) = (result1/jobs_tmp-1._sp)**2
              CALL PUSHCONTROL6B(10)
            ELSE
              CALL PUSHCONTROL6B(9)
            END IF
          CASE ('Erc') 
! Event Signatures
            CALL PUSHINTEGER4(n_computed_event)
            n_computed_event = 0
            DO k=1,options%cost%n_event(i)
              CALL PUSHINTEGER4ARRAY(range_event, 2)
              range_event = GET_RANGE_EVENT(mask_event, k)
              IF (range_event(1) .LT. 1) THEN
                CALL PUSHCONTROL2B(0)
              ELSE
                CALL PUSHREAL4(jobs_tmp)
                jobs_tmp = RC(mprcp(range_event(1):range_event(2)), qo(&
&                 range_event(1):range_event(2)))
                IF (jobs_tmp .GT. 0._sp) THEN
                  CALL PUSHREAL4(result1)
                  result1 = RC(mprcp(range_event(1):range_event(2)), qs(&
&                   range_event(1):range_event(2)))
                  jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j) + (&
&                   result1/jobs_tmp-1._sp)**2
                  n_computed_event = n_computed_event + 1
                  CALL PUSHCONTROL2B(2)
                ELSE
                  CALL PUSHCONTROL2B(1)
                END IF
              END IF
            END DO
            CALL PUSHINTEGER4(k - 1)
            jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j)/&
&             n_computed_event
            CALL PUSHCONTROL6B(8)
          CASE ('Erchf') 
            CALL PUSHINTEGER4(n_computed_event)
            n_computed_event = 0
            DO k=1,options%cost%n_event(i)
              CALL PUSHINTEGER4ARRAY(range_event, 2)
              range_event = GET_RANGE_EVENT(mask_event, k)
              IF (range_event(1) .LT. 1) THEN
                CALL PUSHCONTROL2B(0)
              ELSE
                CALL PUSHREAL4(jobs_tmp)
                jobs_tmp = RCHF(mprcp(range_event(1):range_event(2)), qo&
&                 (range_event(1):range_event(2)))
                IF (jobs_tmp .GT. 0._sp) THEN
                  CALL PUSHREAL4(result1)
                  result1 = RCHF(mprcp(range_event(1):range_event(2)), &
&                   qs(range_event(1):range_event(2)))
                  jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j) + (&
&                   result1/jobs_tmp-1._sp)**2
                  n_computed_event = n_computed_event + 1
                  CALL PUSHCONTROL2B(2)
                ELSE
                  CALL PUSHCONTROL2B(1)
                END IF
              END IF
            END DO
            CALL PUSHINTEGER4(k - 1)
            jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j)/&
&             n_computed_event
            CALL PUSHCONTROL6B(7)
          CASE ('Erclf') 
            CALL PUSHINTEGER4(n_computed_event)
            n_computed_event = 0
            DO k=1,options%cost%n_event(i)
              CALL PUSHINTEGER4ARRAY(range_event, 2)
              range_event = GET_RANGE_EVENT(mask_event, k)
              IF (range_event(1) .LT. 1) THEN
                CALL PUSHCONTROL2B(0)
              ELSE
                CALL PUSHREAL4(jobs_tmp)
                jobs_tmp = RCLF(mprcp(range_event(1):range_event(2)), qo&
&                 (range_event(1):range_event(2)))
                IF (jobs_tmp .GT. 0._sp) THEN
                  CALL PUSHREAL4(result1)
                  result1 = RCLF(mprcp(range_event(1):range_event(2)), &
&                   qs(range_event(1):range_event(2)))
                  jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j) + (&
&                   result1/jobs_tmp-1._sp)**2
                  n_computed_event = n_computed_event + 1
                  CALL PUSHCONTROL2B(2)
                ELSE
                  CALL PUSHCONTROL2B(1)
                END IF
              END IF
            END DO
            CALL PUSHINTEGER4(k - 1)
            jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j)/&
&             n_computed_event
            CALL PUSHCONTROL6B(6)
          CASE ('Erch2r') 
            CALL PUSHINTEGER4(n_computed_event)
            n_computed_event = 0
            DO k=1,options%cost%n_event(i)
              CALL PUSHINTEGER4ARRAY(range_event, 2)
              range_event = GET_RANGE_EVENT(mask_event, k)
              IF (range_event(1) .LT. 1) THEN
                CALL PUSHCONTROL2B(0)
              ELSE
                CALL PUSHREAL4(jobs_tmp)
                jobs_tmp = RCH2R(mprcp(range_event(1):range_event(2)), &
&                 qo(range_event(1):range_event(2)))
                IF (jobs_tmp .GT. 0._sp) THEN
                  CALL PUSHREAL4(result1)
                  result1 = RCH2R(mprcp(range_event(1):range_event(2)), &
&                   qs(range_event(1):range_event(2)))
                  jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j) + (&
&                   result1/jobs_tmp-1._sp)**2
                  n_computed_event = n_computed_event + 1
                  CALL PUSHCONTROL2B(2)
                ELSE
                  CALL PUSHCONTROL2B(1)
                END IF
              END IF
            END DO
            CALL PUSHINTEGER4(k - 1)
            jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j)/&
&             n_computed_event
            CALL PUSHCONTROL6B(5)
          CASE ('Eff') 
            CALL PUSHINTEGER4(n_computed_event)
            n_computed_event = 0
            DO k=1,options%cost%n_event(i)
              CALL PUSHINTEGER4ARRAY(range_event, 2)
              range_event = GET_RANGE_EVENT(mask_event, k)
              IF (range_event(1) .LT. 1) THEN
                CALL PUSHCONTROL2B(0)
              ELSE
                CALL PUSHREAL4(jobs_tmp)
                jobs_tmp = EFF(qo(range_event(1):range_event(2)))
                IF (jobs_tmp .GT. 0._sp) THEN
                  CALL PUSHREAL4(result1)
                  result1 = EFF(qs(range_event(1):range_event(2)))
                  jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j) + (&
&                   result1/jobs_tmp-1._sp)**2
                  n_computed_event = n_computed_event + 1
                  CALL PUSHCONTROL2B(2)
                ELSE
                  CALL PUSHCONTROL2B(1)
                END IF
              END IF
            END DO
            CALL PUSHINTEGER4(k - 1)
            jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j)/&
&             n_computed_event
            CALL PUSHCONTROL6B(4)
          CASE ('Ebf') 
            CALL PUSHINTEGER4(n_computed_event)
            n_computed_event = 0
            DO k=1,options%cost%n_event(i)
              CALL PUSHINTEGER4ARRAY(range_event, 2)
              range_event = GET_RANGE_EVENT(mask_event, k)
              IF (range_event(1) .LT. 1) THEN
                CALL PUSHCONTROL2B(0)
              ELSE
                CALL PUSHREAL4(jobs_tmp)
                jobs_tmp = EBF(qo(range_event(1):range_event(2)))
                IF (jobs_tmp .GT. 0._sp) THEN
                  CALL PUSHREAL4(result1)
                  result1 = EBF(qs(range_event(1):range_event(2)))
                  jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j) + (&
&                   result1/jobs_tmp-1._sp)**2
                  n_computed_event = n_computed_event + 1
                  CALL PUSHCONTROL2B(2)
                ELSE
                  CALL PUSHCONTROL2B(1)
                END IF
              END IF
            END DO
            CALL PUSHINTEGER4(k - 1)
            jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j)/&
&             n_computed_event
            CALL PUSHCONTROL6B(3)
          CASE ('Elt') 
            CALL PUSHINTEGER4(n_computed_event)
            n_computed_event = 0
            DO k=1,options%cost%n_event(i)
              CALL PUSHINTEGER4ARRAY(range_event, 2)
              range_event = GET_RANGE_EVENT(mask_event, k)
              IF (range_event(1) .LT. 1) THEN
                CALL PUSHCONTROL2B(0)
              ELSE
                CALL PUSHREAL4(jobs_tmp)
                jobs_tmp = ELT(mprcp(range_event(1):range_event(2)), qo(&
&                 range_event(1):range_event(2)))
                IF (jobs_tmp .GT. 0._sp) THEN
                  CALL PUSHREAL4(result1)
                  result1 = ELT(mprcp(range_event(1):range_event(2)), qs&
&                   (range_event(1):range_event(2)))
                  jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j) + (&
&                   result1/jobs_tmp-1._sp)**2
                  n_computed_event = n_computed_event + 1
                  CALL PUSHCONTROL2B(2)
                ELSE
                  CALL PUSHCONTROL2B(1)
                END IF
              END IF
            END DO
            CALL PUSHINTEGER4(k - 1)
            jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j)/&
&             n_computed_event
            CALL PUSHCONTROL6B(2)
          CASE ('Epf') 
            CALL PUSHINTEGER4(n_computed_event)
            n_computed_event = 0
            DO k=1,options%cost%n_event(i)
              CALL PUSHINTEGER4ARRAY(range_event, 2)
              range_event = GET_RANGE_EVENT(mask_event, k)
              IF (range_event(1) .LT. 1) THEN
                CALL PUSHCONTROL2B(0)
              ELSE
                CALL PUSHREAL4(jobs_tmp)
                jobs_tmp = EPF(qo(range_event(1):range_event(2)))
                IF (jobs_tmp .GT. 0._sp) THEN
                  CALL PUSHREAL4(result1)
                  result1 = EPF(qs(range_event(1):range_event(2)))
                  jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j) + (&
&                   result1/jobs_tmp-1._sp)**2
                  n_computed_event = n_computed_event + 1
                  CALL PUSHCONTROL2B(2)
                ELSE
                  CALL PUSHCONTROL2B(1)
                END IF
              END IF
            END DO
            CALL PUSHINTEGER4(k - 1)
            jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j)/&
&             n_computed_event
            CALL PUSHCONTROL6B(1)
          CASE DEFAULT
            CALL PUSHCONTROL6B(0)
          END SELECT
        END DO
        CALL PUSHCONTROL1B(1)
      END IF
    END DO
! TODO TH: handle with alias (median, low/upp quartiles) for jobs_cmpt
    IF (ANY(options%cost%wgauge(:) .LT. 0._sp)) THEN
      jobs_gauge = 0._sp
      k = 0
      DO i=1,mesh%ng
        IF (options%cost%gauge(i) .EQ. 0) THEN
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHREAL4(jobs_tmp)
          jobs_tmp = 0._sp
          DO j=1,options%cost%njoc
            jobs_tmp = jobs_tmp + options%cost%wjobs_cmpt(j)*&
&             jobs_cmpt_values(i, j)
          END DO
          CALL PUSHINTEGER4(k)
          k = k + 1
          jobs_gauge(k) = jobs_tmp
          CALL PUSHCONTROL1B(1)
        END IF
      END DO
      IF (options%cost%wgauge(1) .GE. 0.) THEN
        abs0 = options%cost%wgauge(1)
      ELSE
        abs0 = -options%cost%wgauge(1)
      END IF
      res = QUANTILE1D_R(jobs_gauge(1:k), abs0)
      jobs_gauge_b = 0.0_4
      res_b = jobs_b
      CALL QUANTILE1D_R_B(jobs_gauge(1:k), jobs_gauge_b(1:k), abs0, &
&                   res_b)
      jobs_cmpt_values_b = 0.0_4
      DO i=mesh%ng,1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) THEN
          jobs_tmp_b = jobs_gauge_b(k)
          jobs_gauge_b(k) = 0.0_4
          CALL POPINTEGER4(k)
          DO j=options%cost%njoc,1,-1
            jobs_cmpt_values_b(i, j) = jobs_cmpt_values_b(i, j) + &
&             options%cost%wjobs_cmpt(j)*jobs_tmp_b
          END DO
          CALL POPREAL4(jobs_tmp)
        END IF
      END DO
    ELSE
      jobs_cmpt_values_b = 0.0_4
      DO i=mesh%ng,1,-1
        DO j=options%cost%njoc,1,-1
          jobs_cmpt_values_b(i, j) = jobs_cmpt_values_b(i, j) + options%&
&           cost%wgauge(i)*options%cost%wjobs_cmpt(j)*jobs_b
        END DO
      END DO
    END IF
    output_b%response%q = 0.0_4
    DO i=mesh%ng,1,-1
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        qs_b = 0.0_4
        DO j=options%cost%njoc,1,-1
          CALL POPCONTROL6B(branch)
          IF (branch .LT. 16) THEN
            IF (branch .LT. 8) THEN
              IF (branch .LT. 4) THEN
                IF (branch .LT. 2) THEN
                  IF (branch .NE. 0) THEN
                    jobs_cmpt_values_b(i, j) = jobs_cmpt_values_b(i, j)/&
&                     n_computed_event
                    CALL POPINTEGER4(ad_to6)
                    DO k=ad_to6,1,-1
                      CALL POPCONTROL2B(branch)
                      IF (branch .NE. 0) THEN
                        IF (branch .NE. 1) THEN
                          result1_b = 2*(result1/jobs_tmp-1._sp)*&
&                           jobs_cmpt_values_b(i, j)/jobs_tmp
                          CALL POPREAL4(result1)
                          CALL EPF_B(qs(range_event(1):range_event(2)), &
&                              qs_b(range_event(1):range_event(2)), &
&                              result1_b)
                        END IF
                        CALL POPREAL4(jobs_tmp)
                      END IF
                      CALL POPINTEGER4ARRAY(range_event, 2)
                    END DO
                    CALL POPINTEGER4(n_computed_event)
                  END IF
                ELSE IF (branch .EQ. 2) THEN
                  jobs_cmpt_values_b(i, j) = jobs_cmpt_values_b(i, j)/&
&                   n_computed_event
                  CALL POPINTEGER4(ad_to5)
                  DO k=ad_to5,1,-1
                    CALL POPCONTROL2B(branch)
                    IF (branch .NE. 0) THEN
                      IF (branch .NE. 1) CALL POPREAL4(result1)
                      CALL POPREAL4(jobs_tmp)
                    END IF
                    CALL POPINTEGER4ARRAY(range_event, 2)
                  END DO
                  CALL POPINTEGER4(n_computed_event)
                ELSE
                  jobs_cmpt_values_b(i, j) = jobs_cmpt_values_b(i, j)/&
&                   n_computed_event
                  CALL POPINTEGER4(ad_to4)
                  DO k=ad_to4,1,-1
                    CALL POPCONTROL2B(branch)
                    IF (branch .NE. 0) THEN
                      IF (branch .NE. 1) THEN
                        result1_b = 2*(result1/jobs_tmp-1._sp)*&
&                         jobs_cmpt_values_b(i, j)/jobs_tmp
                        CALL POPREAL4(result1)
                        CALL EBF_B(qs(range_event(1):range_event(2)), &
&                            qs_b(range_event(1):range_event(2)), &
&                            result1_b)
                      END IF
                      CALL POPREAL4(jobs_tmp)
                    END IF
                    CALL POPINTEGER4ARRAY(range_event, 2)
                  END DO
                  CALL POPINTEGER4(n_computed_event)
                END IF
              ELSE IF (branch .LT. 6) THEN
                IF (branch .EQ. 4) THEN
                  jobs_cmpt_values_b(i, j) = jobs_cmpt_values_b(i, j)/&
&                   n_computed_event
                  CALL POPINTEGER4(ad_to3)
                  DO k=ad_to3,1,-1
                    CALL POPCONTROL2B(branch)
                    IF (branch .NE. 0) THEN
                      IF (branch .NE. 1) THEN
                        result1_b = 2*(result1/jobs_tmp-1._sp)*&
&                         jobs_cmpt_values_b(i, j)/jobs_tmp
                        CALL POPREAL4(result1)
                        CALL EFF_B(qs(range_event(1):range_event(2)), &
&                            qs_b(range_event(1):range_event(2)), &
&                            result1_b)
                      END IF
                      CALL POPREAL4(jobs_tmp)
                    END IF
                    CALL POPINTEGER4ARRAY(range_event, 2)
                  END DO
                  CALL POPINTEGER4(n_computed_event)
                ELSE
                  jobs_cmpt_values_b(i, j) = jobs_cmpt_values_b(i, j)/&
&                   n_computed_event
                  CALL POPINTEGER4(ad_to2)
                  DO k=ad_to2,1,-1
                    CALL POPCONTROL2B(branch)
                    IF (branch .NE. 0) THEN
                      IF (branch .NE. 1) THEN
                        result1_b = 2*(result1/jobs_tmp-1._sp)*&
&                         jobs_cmpt_values_b(i, j)/jobs_tmp
                        CALL POPREAL4(result1)
                        CALL RCH2R_B(mprcp(range_event(1):range_event(2)&
&                              ), qs(range_event(1):range_event(2)), &
&                              qs_b(range_event(1):range_event(2)), &
&                              result1_b)
                      END IF
                      CALL POPREAL4(jobs_tmp)
                    END IF
                    CALL POPINTEGER4ARRAY(range_event, 2)
                  END DO
                  CALL POPINTEGER4(n_computed_event)
                END IF
              ELSE IF (branch .EQ. 6) THEN
                jobs_cmpt_values_b(i, j) = jobs_cmpt_values_b(i, j)/&
&                 n_computed_event
                CALL POPINTEGER4(ad_to1)
                DO k=ad_to1,1,-1
                  CALL POPCONTROL2B(branch)
                  IF (branch .NE. 0) THEN
                    IF (branch .NE. 1) THEN
                      result1_b = 2*(result1/jobs_tmp-1._sp)*&
&                       jobs_cmpt_values_b(i, j)/jobs_tmp
                      CALL POPREAL4(result1)
                      CALL RCLF_B(mprcp(range_event(1):range_event(2)), &
&                           qs(range_event(1):range_event(2)), qs_b(&
&                           range_event(1):range_event(2)), result1_b)
                    END IF
                    CALL POPREAL4(jobs_tmp)
                  END IF
                  CALL POPINTEGER4ARRAY(range_event, 2)
                END DO
                CALL POPINTEGER4(n_computed_event)
              ELSE
                jobs_cmpt_values_b(i, j) = jobs_cmpt_values_b(i, j)/&
&                 n_computed_event
                CALL POPINTEGER4(ad_to0)
                DO k=ad_to0,1,-1
                  CALL POPCONTROL2B(branch)
                  IF (branch .NE. 0) THEN
                    IF (branch .NE. 1) THEN
                      result1_b = 2*(result1/jobs_tmp-1._sp)*&
&                       jobs_cmpt_values_b(i, j)/jobs_tmp
                      CALL POPREAL4(result1)
                      CALL RCHF_B(mprcp(range_event(1):range_event(2)), &
&                           qs(range_event(1):range_event(2)), qs_b(&
&                           range_event(1):range_event(2)), result1_b)
                    END IF
                    CALL POPREAL4(jobs_tmp)
                  END IF
                  CALL POPINTEGER4ARRAY(range_event, 2)
                END DO
                CALL POPINTEGER4(n_computed_event)
              END IF
            ELSE
              IF (branch .LT. 12) THEN
                IF (branch .LT. 10) THEN
                  IF (branch .EQ. 8) THEN
                    jobs_cmpt_values_b(i, j) = jobs_cmpt_values_b(i, j)/&
&                     n_computed_event
                    CALL POPINTEGER4(ad_to)
                    DO k=ad_to,1,-1
                      CALL POPCONTROL2B(branch)
                      IF (branch .NE. 0) THEN
                        IF (branch .NE. 1) THEN
                          result1_b = 2*(result1/jobs_tmp-1._sp)*&
&                           jobs_cmpt_values_b(i, j)/jobs_tmp
                          CALL POPREAL4(result1)
                          CALL RC_B(mprcp(range_event(1):range_event(2))&
&                             , qs(range_event(1):range_event(2)), qs_b(&
&                             range_event(1):range_event(2)), result1_b)
                        END IF
                        CALL POPREAL4(jobs_tmp)
                      END IF
                      CALL POPINTEGER4ARRAY(range_event, 2)
                    END DO
                    CALL POPINTEGER4(n_computed_event)
                    GOTO 140
                  END IF
                ELSE IF (branch .EQ. 10) THEN
                  result1_b = 2*(result1/jobs_tmp-1._sp)*&
&                   jobs_cmpt_values_b(i, j)/jobs_tmp
                  jobs_cmpt_values_b(i, j) = 0.0_4
                  CALL POPREAL4(result1)
                  CALL CFP_B(qs, qs_b, 0.9_sp, result1_b)
                ELSE
                  GOTO 100
                END IF
                CALL POPREAL4(jobs_tmp)
              ELSE
                IF (branch .LT. 14) THEN
                  IF (branch .EQ. 12) THEN
                    result1_b = 2*(result1/jobs_tmp-1._sp)*&
&                     jobs_cmpt_values_b(i, j)/jobs_tmp
                    jobs_cmpt_values_b(i, j) = 0.0_4
                    CALL POPREAL4(result1)
                    CALL CFP_B(qs, qs_b, 0.5_sp, result1_b)
                    GOTO 100
                  END IF
                ELSE IF (branch .EQ. 14) THEN
                  result1_b = 2*(result1/jobs_tmp-1._sp)*&
&                   jobs_cmpt_values_b(i, j)/jobs_tmp
                  jobs_cmpt_values_b(i, j) = 0.0_4
                  CALL POPREAL4(result1)
                  CALL CFP_B(qs, qs_b, 0.1_sp, result1_b)
                ELSE
                  GOTO 130
                END IF
                CALL POPREAL4(jobs_tmp)
              END IF
              GOTO 140
 100          CALL POPREAL4(jobs_tmp)
            END IF
          ELSE
            IF (branch .LT. 24) THEN
              IF (branch .LT. 20) THEN
                IF (branch .LT. 18) THEN
                  IF (branch .EQ. 16) THEN
                    result1_b = 2*(result1/jobs_tmp-1._sp)*&
&                     jobs_cmpt_values_b(i, j)/jobs_tmp
                    jobs_cmpt_values_b(i, j) = 0.0_4
                    CALL POPREAL4(result1)
                    CALL CFP_B(qs, qs_b, 0.02_sp, result1_b)
                    GOTO 130
                  END IF
                ELSE IF (branch .EQ. 18) THEN
                  result1_b = 2*(result1/jobs_tmp-1._sp)*&
&                   jobs_cmpt_values_b(i, j)/jobs_tmp
                  jobs_cmpt_values_b(i, j) = 0.0_4
                  CALL POPREAL4(result1)
                  CALL RCH2R_B(mprcp, qs, qs_b, result1_b)
                ELSE
                  GOTO 110
                END IF
                CALL POPREAL4(jobs_tmp)
              ELSE
                IF (branch .LT. 22) THEN
                  IF (branch .EQ. 20) THEN
                    result1_b = 2*(result1/jobs_tmp-1._sp)*&
&                     jobs_cmpt_values_b(i, j)/jobs_tmp
                    jobs_cmpt_values_b(i, j) = 0.0_4
                    CALL POPREAL4(result1)
                    CALL RCLF_B(mprcp, qs, qs_b, result1_b)
                    GOTO 110
                  END IF
                ELSE IF (branch .EQ. 22) THEN
                  result1_b = 2*(result1/jobs_tmp-1._sp)*&
&                   jobs_cmpt_values_b(i, j)/jobs_tmp
                  jobs_cmpt_values_b(i, j) = 0.0_4
                  CALL POPREAL4(result1)
                  CALL RCHF_B(mprcp, qs, qs_b, result1_b)
                ELSE
                  GOTO 120
                END IF
                CALL POPREAL4(jobs_tmp)
              END IF
              GOTO 140
 110          CALL POPREAL4(jobs_tmp)
              GOTO 140
            ELSE IF (branch .LT. 28) THEN
              IF (branch .LT. 26) THEN
                IF (branch .EQ. 24) THEN
                  result1_b = 2*(result1/jobs_tmp-1._sp)*&
&                   jobs_cmpt_values_b(i, j)/jobs_tmp
                  jobs_cmpt_values_b(i, j) = 0.0_4
                  CALL POPREAL4(result1)
                  CALL RC_B(mprcp, qs, qs_b, result1_b)
                ELSE
                  CALL LGRM_B(qo, qs, qs_b, jobs_cmpt_values_b(i, j))
                  jobs_cmpt_values_b(i, j) = 0.0_4
                  GOTO 140
                END IF
              ELSE
                IF (branch .EQ. 26) THEN
                  CALL RMSE_B(qo, qs, qs_b, jobs_cmpt_values_b(i, j))
                  jobs_cmpt_values_b(i, j) = 0.0_4
                ELSE
                  CALL MSE_B(qo, qs, qs_b, jobs_cmpt_values_b(i, j))
                  jobs_cmpt_values_b(i, j) = 0.0_4
                END IF
                GOTO 140
              END IF
            ELSE
              IF (branch .LT. 30) THEN
                IF (branch .EQ. 28) THEN
                  CALL MAPE_B(qo, qs, qs_b, jobs_cmpt_values_b(i, j))
                  jobs_cmpt_values_b(i, j) = 0.0_4
                ELSE
                  CALL MAE_B(qo, qs, qs_b, jobs_cmpt_values_b(i, j))
                  jobs_cmpt_values_b(i, j) = 0.0_4
                END IF
              ELSE IF (branch .EQ. 30) THEN
                result1_b = -jobs_cmpt_values_b(i, j)
                jobs_cmpt_values_b(i, j) = 0.0_4
                CALL POPREAL4(result1)
                CALL KGE_B(qo, qs, qs_b, result1_b)
              ELSE IF (branch .EQ. 31) THEN
                result1_b = -jobs_cmpt_values_b(i, j)
                jobs_cmpt_values_b(i, j) = 0.0_4
                CALL POPREAL4(result1)
                CALL NNSE_B(qo, qs, qs_b, result1_b)
              ELSE
                result1_b = -jobs_cmpt_values_b(i, j)
                jobs_cmpt_values_b(i, j) = 0.0_4
                CALL POPREAL4(result1)
                CALL NSE_B(qo, qs, qs_b, result1_b)
              END IF
              GOTO 140
            END IF
 120        CALL POPREAL4(jobs_tmp)
          END IF
          GOTO 140
 130      CALL POPREAL4(jobs_tmp)
 140      CALL POPREAL4ARRAY(qo, setup%ntime_step - options%cost%&
&                      end_warmup + 1)
          CALL POPREAL4ARRAY(qs, setup%ntime_step - options%cost%&
&                      end_warmup + 1)
          CALL DISCHARGE_TRANFORMATION_B(options%cost%jobs_cmpt_tfm(j), &
&                                  qo, qs, qs_b)
        END DO
        WHERE (qo .LT. 0._sp) qs_b = 0.0_4
        CALL POPREAL4ARRAY(mprcp, setup%ntime_step - options%cost%&
&                    end_warmup + 1)
        CALL POPREAL4ARRAY(qs, setup%ntime_step - options%cost%&
&                    end_warmup + 1)
        output_b%response%q(i, options%cost%end_warmup:setup%ntime_step)&
&        = output_b%response%q(i, options%cost%end_warmup:setup%&
&         ntime_step) + qs_b
        CALL POPREAL4ARRAY(qo, setup%ntime_step - options%cost%&
&                    end_warmup + 1)
      END IF
    END DO
  END SUBROUTINE CLASSICAL_COMPUTE_JOBS_B

  SUBROUTINE CLASSICAL_COMPUTE_JOBS(setup, mesh, input_data, output, &
&   options, jobs)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OUTPUTDT), INTENT(IN) :: output
    TYPE(OPTIONSDT), INTENT(IN) :: options
    REAL(sp), INTENT(INOUT) :: jobs
    INTEGER :: i, j, k, n_computed_event
    REAL(sp), DIMENSION(setup%ntime_step-options%cost%end_warmup+1) :: &
&   qo, qs, mprcp
    INTEGER, DIMENSION(setup%ntime_step-options%cost%end_warmup+1) :: &
&   mask_event
    REAL(sp), DIMENSION(mesh%ng, options%cost%njoc) :: jobs_cmpt_values
    INTEGER, DIMENSION(2) :: range_event
    REAL(sp), DIMENSION(mesh%ng) :: jobs_gauge
    REAL(sp) :: jobs_tmp
    INTRINSIC ANY
    INTRINSIC ABS
    REAL(sp) :: abs0
    REAL(sp) :: result1
    jobs_cmpt_values = 0._sp
    DO i=1,mesh%ng
! Cycle if gauge is equal to 0
      IF (options%cost%gauge(i) .NE. 0) THEN
        qo = input_data%response_data%q(i, options%cost%end_warmup:setup&
&         %ntime_step)
        qs = output%response%q(i, options%cost%end_warmup:setup%&
&         ntime_step)
        WHERE (qo .LT. 0._sp) qs = -99._sp
! Convert mean_prcp from mm/dt to m3/s
        mprcp = input_data%atmos_data%mean_prcp(i, options%cost%&
&         end_warmup:setup%ntime_step)*mesh%area_dln(i)*1.e-3_sp/setup%&
&         dt
        mask_event = options%cost%mask_event(i, options%cost%end_warmup:&
&         setup%ntime_step)
        DO j=1,options%cost%njoc
          CALL DISCHARGE_TRANFORMATION(options%cost%jobs_cmpt_tfm(j), qo&
&                                , qs)
! Should be unreachable.
          SELECT CASE  (options%cost%jobs_cmpt(j)) 
          CASE ('nse') 
! Efficiency Metrics
            result1 = NSE(qo, qs)
            jobs_cmpt_values(i, j) = 1._sp - result1
          CASE ('nnse') 
            result1 = NNSE(qo, qs)
            jobs_cmpt_values(i, j) = 1._sp - result1
          CASE ('kge') 
            result1 = KGE(qo, qs)
            jobs_cmpt_values(i, j) = 1._sp - result1
          CASE ('mae') 
            jobs_cmpt_values(i, j) = MAE(qo, qs)
          CASE ('mape') 
            jobs_cmpt_values(i, j) = MAPE(qo, qs)
          CASE ('mse') 
            jobs_cmpt_values(i, j) = MSE(qo, qs)
          CASE ('rmse') 
            jobs_cmpt_values(i, j) = RMSE(qo, qs)
          CASE ('lgrm') 
            jobs_cmpt_values(i, j) = LGRM(qo, qs)
          CASE ('Crc') 
! Continuous Signatures
            jobs_tmp = RC(mprcp, qo)
            IF (jobs_tmp .GT. 0._sp) THEN
              result1 = RC(mprcp, qs)
              jobs_cmpt_values(i, j) = (result1/jobs_tmp-1._sp)**2
            END IF
          CASE ('Crchf') 
            jobs_tmp = RCHF(mprcp, qo)
            IF (jobs_tmp .GT. 0._sp) THEN
              result1 = RCHF(mprcp, qs)
              jobs_cmpt_values(i, j) = (result1/jobs_tmp-1._sp)**2
            END IF
          CASE ('Crclf') 
            jobs_tmp = RCLF(mprcp, qo)
            IF (jobs_tmp .GT. 0._sp) THEN
              result1 = RCLF(mprcp, qs)
              jobs_cmpt_values(i, j) = (result1/jobs_tmp-1._sp)**2
            END IF
          CASE ('Crch2r') 
            jobs_tmp = RCH2R(mprcp, qo)
            IF (jobs_tmp .GT. 0._sp) THEN
              result1 = RCH2R(mprcp, qs)
              jobs_cmpt_values(i, j) = (result1/jobs_tmp-1._sp)**2
            END IF
          CASE ('Cfp2') 
            jobs_tmp = CFP(qo, 0.02_sp)
            IF (jobs_tmp .GT. 0._sp) THEN
              result1 = CFP(qs, 0.02_sp)
              jobs_cmpt_values(i, j) = (result1/jobs_tmp-1._sp)**2
            END IF
          CASE ('Cfp10') 
            jobs_tmp = CFP(qo, 0.1_sp)
            IF (jobs_tmp .GT. 0._sp) THEN
              result1 = CFP(qs, 0.1_sp)
              jobs_cmpt_values(i, j) = (result1/jobs_tmp-1._sp)**2
            END IF
          CASE ('Cfp50') 
            jobs_tmp = CFP(qo, 0.5_sp)
            IF (jobs_tmp .GT. 0._sp) THEN
              result1 = CFP(qs, 0.5_sp)
              jobs_cmpt_values(i, j) = (result1/jobs_tmp-1._sp)**2
            END IF
          CASE ('Cfp90') 
            jobs_tmp = CFP(qo, 0.9_sp)
            IF (jobs_tmp .GT. 0._sp) THEN
              result1 = CFP(qs, 0.9_sp)
              jobs_cmpt_values(i, j) = (result1/jobs_tmp-1._sp)**2
            END IF
          CASE ('Erc') 
! Event Signatures
            n_computed_event = 0
            DO k=1,options%cost%n_event(i)
              range_event = GET_RANGE_EVENT(mask_event, k)
              IF (range_event(1) .GE. 1) THEN
                jobs_tmp = RC(mprcp(range_event(1):range_event(2)), qo(&
&                 range_event(1):range_event(2)))
                IF (jobs_tmp .GT. 0._sp) THEN
                  result1 = RC(mprcp(range_event(1):range_event(2)), qs(&
&                   range_event(1):range_event(2)))
                  jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j) + (&
&                   result1/jobs_tmp-1._sp)**2
                  n_computed_event = n_computed_event + 1
                END IF
              END IF
            END DO
            jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j)/&
&             n_computed_event
          CASE ('Erchf') 
            n_computed_event = 0
            DO k=1,options%cost%n_event(i)
              range_event = GET_RANGE_EVENT(mask_event, k)
              IF (range_event(1) .GE. 1) THEN
                jobs_tmp = RCHF(mprcp(range_event(1):range_event(2)), qo&
&                 (range_event(1):range_event(2)))
                IF (jobs_tmp .GT. 0._sp) THEN
                  result1 = RCHF(mprcp(range_event(1):range_event(2)), &
&                   qs(range_event(1):range_event(2)))
                  jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j) + (&
&                   result1/jobs_tmp-1._sp)**2
                  n_computed_event = n_computed_event + 1
                END IF
              END IF
            END DO
            jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j)/&
&             n_computed_event
          CASE ('Erclf') 
            n_computed_event = 0
            DO k=1,options%cost%n_event(i)
              range_event = GET_RANGE_EVENT(mask_event, k)
              IF (range_event(1) .GE. 1) THEN
                jobs_tmp = RCLF(mprcp(range_event(1):range_event(2)), qo&
&                 (range_event(1):range_event(2)))
                IF (jobs_tmp .GT. 0._sp) THEN
                  result1 = RCLF(mprcp(range_event(1):range_event(2)), &
&                   qs(range_event(1):range_event(2)))
                  jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j) + (&
&                   result1/jobs_tmp-1._sp)**2
                  n_computed_event = n_computed_event + 1
                END IF
              END IF
            END DO
            jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j)/&
&             n_computed_event
          CASE ('Erch2r') 
            n_computed_event = 0
            DO k=1,options%cost%n_event(i)
              range_event = GET_RANGE_EVENT(mask_event, k)
              IF (range_event(1) .GE. 1) THEN
                jobs_tmp = RCH2R(mprcp(range_event(1):range_event(2)), &
&                 qo(range_event(1):range_event(2)))
                IF (jobs_tmp .GT. 0._sp) THEN
                  result1 = RCH2R(mprcp(range_event(1):range_event(2)), &
&                   qs(range_event(1):range_event(2)))
                  jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j) + (&
&                   result1/jobs_tmp-1._sp)**2
                  n_computed_event = n_computed_event + 1
                END IF
              END IF
            END DO
            jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j)/&
&             n_computed_event
          CASE ('Eff') 
            n_computed_event = 0
            DO k=1,options%cost%n_event(i)
              range_event = GET_RANGE_EVENT(mask_event, k)
              IF (range_event(1) .GE. 1) THEN
                jobs_tmp = EFF(qo(range_event(1):range_event(2)))
                IF (jobs_tmp .GT. 0._sp) THEN
                  result1 = EFF(qs(range_event(1):range_event(2)))
                  jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j) + (&
&                   result1/jobs_tmp-1._sp)**2
                  n_computed_event = n_computed_event + 1
                END IF
              END IF
            END DO
            jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j)/&
&             n_computed_event
          CASE ('Ebf') 
            n_computed_event = 0
            DO k=1,options%cost%n_event(i)
              range_event = GET_RANGE_EVENT(mask_event, k)
              IF (range_event(1) .GE. 1) THEN
                jobs_tmp = EBF(qo(range_event(1):range_event(2)))
                IF (jobs_tmp .GT. 0._sp) THEN
                  result1 = EBF(qs(range_event(1):range_event(2)))
                  jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j) + (&
&                   result1/jobs_tmp-1._sp)**2
                  n_computed_event = n_computed_event + 1
                END IF
              END IF
            END DO
            jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j)/&
&             n_computed_event
          CASE ('Elt') 
            n_computed_event = 0
            DO k=1,options%cost%n_event(i)
              range_event = GET_RANGE_EVENT(mask_event, k)
              IF (range_event(1) .GE. 1) THEN
                jobs_tmp = ELT(mprcp(range_event(1):range_event(2)), qo(&
&                 range_event(1):range_event(2)))
                IF (jobs_tmp .GT. 0._sp) THEN
                  result1 = ELT(mprcp(range_event(1):range_event(2)), qs&
&                   (range_event(1):range_event(2)))
                  jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j) + (&
&                   result1/jobs_tmp-1._sp)**2
                  n_computed_event = n_computed_event + 1
                END IF
              END IF
            END DO
            jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j)/&
&             n_computed_event
          CASE ('Epf') 
            n_computed_event = 0
            DO k=1,options%cost%n_event(i)
              range_event = GET_RANGE_EVENT(mask_event, k)
              IF (range_event(1) .GE. 1) THEN
                jobs_tmp = EPF(qo(range_event(1):range_event(2)))
                IF (jobs_tmp .GT. 0._sp) THEN
                  result1 = EPF(qs(range_event(1):range_event(2)))
                  jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j) + (&
&                   result1/jobs_tmp-1._sp)**2
                  n_computed_event = n_computed_event + 1
                END IF
              END IF
            END DO
            jobs_cmpt_values(i, j) = jobs_cmpt_values(i, j)/&
&             n_computed_event
          END SELECT
        END DO
      END IF
    END DO
! TODO TH: handle with alias (median, low/upp quartiles) for jobs_cmpt
    IF (ANY(options%cost%wgauge(:) .LT. 0._sp)) THEN
      jobs_gauge = 0._sp
      k = 0
      DO i=1,mesh%ng
        IF (options%cost%gauge(i) .NE. 0) THEN
          jobs_tmp = 0._sp
          DO j=1,options%cost%njoc
            jobs_tmp = jobs_tmp + options%cost%wjobs_cmpt(j)*&
&             jobs_cmpt_values(i, j)
          END DO
          k = k + 1
          jobs_gauge(k) = jobs_tmp
        END IF
      END DO
      IF (options%cost%wgauge(1) .GE. 0.) THEN
        abs0 = options%cost%wgauge(1)
      ELSE
        abs0 = -options%cost%wgauge(1)
      END IF
      jobs = QUANTILE1D_R(jobs_gauge(1:k), abs0)
    ELSE
      jobs = 0._sp
      DO i=1,mesh%ng
        DO j=1,options%cost%njoc
          jobs = jobs + options%cost%wgauge(i)*options%cost%wjobs_cmpt(j&
&           )*jobs_cmpt_values(i, j)
        END DO
      END DO
    END IF
  END SUBROUTINE CLASSICAL_COMPUTE_JOBS

!  Differentiation of classical_compute_jreg in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: jreg
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_parameters.values)
!                *(parameters.rr_initial_states.values)
!   Plus diff mem management of: parameters.control.x:in parameters.control.l:in
!                parameters.control.u:in parameters.control.l_raw:in
!                parameters.control.u_raw:in parameters.rr_parameters.values:in
!                parameters.rr_initial_states.values:in parameters.serr_mu_parameters.values:in
!                parameters.serr_sigma_parameters.values:in parameters.nn_parameters.weight_1:in
!                parameters.nn_parameters.bias_1:in parameters.nn_parameters.weight_2:in
!                parameters.nn_parameters.bias_2:in parameters.nn_parameters.weight_3:in
!                parameters.nn_parameters.bias_3:in options.cost.wjreg_cmpt:in
  SUBROUTINE CLASSICAL_COMPUTE_JREG_D(setup, mesh, input_data, &
&   parameters, parameters_d, options, options_d, jreg, jreg_d)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(IN) :: parameters
    TYPE(PARAMETERSDT), INTENT(IN) :: parameters_d
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(OPTIONSDT_DIFF), INTENT(IN) :: options_d
    REAL(sp), INTENT(INOUT) :: jreg
    REAL(sp), INTENT(INOUT) :: jreg_d
    INTEGER :: i
    REAL(sp), DIMENSION(options%cost%njrc) :: jreg_cmpt_values
    REAL(sp), DIMENSION(options%cost%njrc) :: jreg_cmpt_values_d
    INTRINSIC ALLOCATED
    INTRINSIC SUM
! Case of forward run
    IF (.NOT.ALLOCATED(parameters%control%x)) THEN
      jreg_d = 0.0_4
    ELSE
      jreg_cmpt_values = 0._sp
      jreg_cmpt_values_d = 0.0_4
      DO i=1,options%cost%njrc
        SELECT CASE  (options%cost%jreg_cmpt(i)) 
        CASE ('prior') 
! Can be applied to any control
          jreg_cmpt_values_d(i) = PRIOR_REGULARIZATION_D(parameters, &
&           parameters_d, jreg_cmpt_values(i))
        CASE ('smoothing') 
! Should be only used with distributed mapping. Applied on rr_parameters and rr_initial_states
          jreg_cmpt_values_d(i) = SMOOTHING_REGULARIZATION_D(setup, mesh&
&           , input_data, parameters, parameters_d, options, .false., &
&           jreg_cmpt_values(i))
        CASE ('hard-smoothing') 
! Should be only used with distributed mapping. Applied on rr_parameters and rr_initial_states
          jreg_cmpt_values_d(i) = SMOOTHING_REGULARIZATION_D(setup, mesh&
&           , input_data, parameters, parameters_d, options, .true., &
&           jreg_cmpt_values(i))
        END SELECT
      END DO
      jreg_d = SUM(options%cost%wjreg_cmpt*jreg_cmpt_values_d)
      jreg = SUM(options%cost%wjreg_cmpt*jreg_cmpt_values)
    END IF
  END SUBROUTINE CLASSICAL_COMPUTE_JREG_D

!  Differentiation of classical_compute_jreg in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: jreg
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_parameters.values)
!                *(parameters.rr_initial_states.values)
!   Plus diff mem management of: parameters.control.x:in parameters.control.l:in
!                parameters.control.u:in parameters.control.l_raw:in
!                parameters.control.u_raw:in parameters.rr_parameters.values:in
!                parameters.rr_initial_states.values:in parameters.serr_mu_parameters.values:in
!                parameters.serr_sigma_parameters.values:in parameters.nn_parameters.weight_1:in
!                parameters.nn_parameters.bias_1:in parameters.nn_parameters.weight_2:in
!                parameters.nn_parameters.bias_2:in parameters.nn_parameters.weight_3:in
!                parameters.nn_parameters.bias_3:in options.cost.wjreg_cmpt:in
  SUBROUTINE CLASSICAL_COMPUTE_JREG_B(setup, mesh, input_data, &
&   parameters, parameters_b, options, options_b, jreg, jreg_b)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(IN) :: parameters
    TYPE(PARAMETERSDT) :: parameters_b
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(OPTIONSDT_DIFF) :: options_b
    REAL(sp), INTENT(INOUT) :: jreg
    REAL(sp), INTENT(INOUT) :: jreg_b
    INTEGER :: i
    REAL(sp), DIMENSION(options%cost%njrc) :: jreg_cmpt_values
    REAL(sp), DIMENSION(options%cost%njrc) :: jreg_cmpt_values_b
    INTRINSIC ALLOCATED
    INTRINSIC SUM
    INTEGER :: branch
! Case of forward run
    IF (.NOT.ALLOCATED(parameters%control%x)) THEN
      parameters_b%control%x = 0.0_4
      parameters_b%rr_parameters%values = 0.0_4
      parameters_b%rr_initial_states%values = 0.0_4
    ELSE
      jreg_cmpt_values = 0._sp
      DO i=1,options%cost%njrc
        SELECT CASE  (options%cost%jreg_cmpt(i)) 
        CASE ('prior') 
! Can be applied to any control
          jreg_cmpt_values(i) = PRIOR_REGULARIZATION(parameters)
          CALL PUSHCONTROL2B(2)
        CASE ('smoothing') 
! Should be only used with distributed mapping. Applied on rr_parameters and rr_initial_states
          CALL PUSHREAL4ARRAY(parameters%control%x, SIZE(parameters%&
&                       control%x, 1))
          CALL PUSHREAL4ARRAY(parameters%rr_parameters%values, SIZE(&
&                       parameters%rr_parameters%values, 1)*SIZE(&
&                       parameters%rr_parameters%values, 2)*SIZE(&
&                       parameters%rr_parameters%values, 3))
          CALL PUSHREAL4ARRAY(parameters%rr_initial_states%values, SIZE(&
&                       parameters%rr_initial_states%values, 1)*SIZE(&
&                       parameters%rr_initial_states%values, 2)*SIZE(&
&                       parameters%rr_initial_states%values, 3))
          CALL PUSHREAL4ARRAY(parameters%nn_parameters%weight_1, SIZE(&
&                       parameters%nn_parameters%weight_1, 1)*SIZE(&
&                       parameters%nn_parameters%weight_1, 2))
          CALL PUSHREAL4ARRAY(parameters%nn_parameters%bias_1, SIZE(&
&                       parameters%nn_parameters%bias_1, 1))
          CALL PUSHREAL4ARRAY(parameters%nn_parameters%weight_2, SIZE(&
&                       parameters%nn_parameters%weight_2, 1)*SIZE(&
&                       parameters%nn_parameters%weight_2, 2))
          CALL PUSHREAL4ARRAY(parameters%nn_parameters%bias_2, SIZE(&
&                       parameters%nn_parameters%bias_2, 1))
          CALL PUSHREAL4ARRAY(parameters%nn_parameters%weight_3, SIZE(&
&                       parameters%nn_parameters%weight_3, 1)*SIZE(&
&                       parameters%nn_parameters%weight_3, 2))
          CALL PUSHREAL4ARRAY(parameters%nn_parameters%bias_3, SIZE(&
&                       parameters%nn_parameters%bias_3, 1))
          jreg_cmpt_values(i) = SMOOTHING_REGULARIZATION(setup, mesh, &
&           input_data, parameters, options, .false.)
          CALL PUSHCONTROL2B(1)
        CASE ('hard-smoothing') 
! Should be only used with distributed mapping. Applied on rr_parameters and rr_initial_states
          CALL PUSHREAL4ARRAY(parameters%control%x, SIZE(parameters%&
&                       control%x, 1))
          CALL PUSHREAL4ARRAY(parameters%rr_parameters%values, SIZE(&
&                       parameters%rr_parameters%values, 1)*SIZE(&
&                       parameters%rr_parameters%values, 2)*SIZE(&
&                       parameters%rr_parameters%values, 3))
          CALL PUSHREAL4ARRAY(parameters%rr_initial_states%values, SIZE(&
&                       parameters%rr_initial_states%values, 1)*SIZE(&
&                       parameters%rr_initial_states%values, 2)*SIZE(&
&                       parameters%rr_initial_states%values, 3))
          CALL PUSHREAL4ARRAY(parameters%nn_parameters%weight_1, SIZE(&
&                       parameters%nn_parameters%weight_1, 1)*SIZE(&
&                       parameters%nn_parameters%weight_1, 2))
          CALL PUSHREAL4ARRAY(parameters%nn_parameters%bias_1, SIZE(&
&                       parameters%nn_parameters%bias_1, 1))
          CALL PUSHREAL4ARRAY(parameters%nn_parameters%weight_2, SIZE(&
&                       parameters%nn_parameters%weight_2, 1)*SIZE(&
&                       parameters%nn_parameters%weight_2, 2))
          CALL PUSHREAL4ARRAY(parameters%nn_parameters%bias_2, SIZE(&
&                       parameters%nn_parameters%bias_2, 1))
          CALL PUSHREAL4ARRAY(parameters%nn_parameters%weight_3, SIZE(&
&                       parameters%nn_parameters%weight_3, 1)*SIZE(&
&                       parameters%nn_parameters%weight_3, 2))
          CALL PUSHREAL4ARRAY(parameters%nn_parameters%bias_3, SIZE(&
&                       parameters%nn_parameters%bias_3, 1))
          jreg_cmpt_values(i) = SMOOTHING_REGULARIZATION(setup, mesh, &
&           input_data, parameters, options, .true.)
          CALL PUSHCONTROL2B(0)
        CASE DEFAULT
          CALL PUSHCONTROL2B(3)
        END SELECT
      END DO
      jreg_cmpt_values_b = 0.0_4
      jreg_cmpt_values_b = options%cost%wjreg_cmpt*jreg_b
      parameters_b%control%x = 0.0_4
      parameters_b%rr_parameters%values = 0.0_4
      parameters_b%rr_initial_states%values = 0.0_4
      DO i=options%cost%njrc,1,-1
        CALL POPCONTROL2B(branch)
        IF (branch .LT. 2) THEN
          IF (branch .EQ. 0) THEN
            CALL POPREAL4ARRAY(parameters%nn_parameters%bias_3, SIZE(&
&                        parameters%nn_parameters%bias_3, 1))
            CALL POPREAL4ARRAY(parameters%nn_parameters%weight_3, SIZE(&
&                        parameters%nn_parameters%weight_3, 1)*SIZE(&
&                        parameters%nn_parameters%weight_3, 2))
            CALL POPREAL4ARRAY(parameters%nn_parameters%bias_2, SIZE(&
&                        parameters%nn_parameters%bias_2, 1))
            CALL POPREAL4ARRAY(parameters%nn_parameters%weight_2, SIZE(&
&                        parameters%nn_parameters%weight_2, 1)*SIZE(&
&                        parameters%nn_parameters%weight_2, 2))
            CALL POPREAL4ARRAY(parameters%nn_parameters%bias_1, SIZE(&
&                        parameters%nn_parameters%bias_1, 1))
            CALL POPREAL4ARRAY(parameters%nn_parameters%weight_1, SIZE(&
&                        parameters%nn_parameters%weight_1, 1)*SIZE(&
&                        parameters%nn_parameters%weight_1, 2))
            CALL POPREAL4ARRAY(parameters%rr_initial_states%values, SIZE&
&                        (parameters%rr_initial_states%values, 1)*SIZE(&
&                        parameters%rr_initial_states%values, 2)*SIZE(&
&                        parameters%rr_initial_states%values, 3))
            CALL POPREAL4ARRAY(parameters%rr_parameters%values, SIZE(&
&                        parameters%rr_parameters%values, 1)*SIZE(&
&                        parameters%rr_parameters%values, 2)*SIZE(&
&                        parameters%rr_parameters%values, 3))
            CALL POPREAL4ARRAY(parameters%control%x, SIZE(parameters%&
&                        control%x, 1))
            CALL SMOOTHING_REGULARIZATION_B(setup, mesh, input_data, &
&                                     parameters, parameters_b, options&
&                                     , .true., jreg_cmpt_values_b(i))
            jreg_cmpt_values_b(i) = 0.0_4
          ELSE
            CALL POPREAL4ARRAY(parameters%nn_parameters%bias_3, SIZE(&
&                        parameters%nn_parameters%bias_3, 1))
            CALL POPREAL4ARRAY(parameters%nn_parameters%weight_3, SIZE(&
&                        parameters%nn_parameters%weight_3, 1)*SIZE(&
&                        parameters%nn_parameters%weight_3, 2))
            CALL POPREAL4ARRAY(parameters%nn_parameters%bias_2, SIZE(&
&                        parameters%nn_parameters%bias_2, 1))
            CALL POPREAL4ARRAY(parameters%nn_parameters%weight_2, SIZE(&
&                        parameters%nn_parameters%weight_2, 1)*SIZE(&
&                        parameters%nn_parameters%weight_2, 2))
            CALL POPREAL4ARRAY(parameters%nn_parameters%bias_1, SIZE(&
&                        parameters%nn_parameters%bias_1, 1))
            CALL POPREAL4ARRAY(parameters%nn_parameters%weight_1, SIZE(&
&                        parameters%nn_parameters%weight_1, 1)*SIZE(&
&                        parameters%nn_parameters%weight_1, 2))
            CALL POPREAL4ARRAY(parameters%rr_initial_states%values, SIZE&
&                        (parameters%rr_initial_states%values, 1)*SIZE(&
&                        parameters%rr_initial_states%values, 2)*SIZE(&
&                        parameters%rr_initial_states%values, 3))
            CALL POPREAL4ARRAY(parameters%rr_parameters%values, SIZE(&
&                        parameters%rr_parameters%values, 1)*SIZE(&
&                        parameters%rr_parameters%values, 2)*SIZE(&
&                        parameters%rr_parameters%values, 3))
            CALL POPREAL4ARRAY(parameters%control%x, SIZE(parameters%&
&                        control%x, 1))
            CALL SMOOTHING_REGULARIZATION_B(setup, mesh, input_data, &
&                                     parameters, parameters_b, options&
&                                     , .false., jreg_cmpt_values_b(i))
            jreg_cmpt_values_b(i) = 0.0_4
          END IF
        ELSE IF (branch .EQ. 2) THEN
          CALL PRIOR_REGULARIZATION_B(parameters, parameters_b, &
&                               jreg_cmpt_values_b(i))
          jreg_cmpt_values_b(i) = 0.0_4
        END IF
      END DO
    END IF
  END SUBROUTINE CLASSICAL_COMPUTE_JREG_B

  SUBROUTINE CLASSICAL_COMPUTE_JREG(setup, mesh, input_data, parameters&
&   , options, jreg)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(IN) :: parameters
    TYPE(OPTIONSDT), INTENT(IN) :: options
    REAL(sp), INTENT(INOUT) :: jreg
    INTEGER :: i
    REAL(sp), DIMENSION(options%cost%njrc) :: jreg_cmpt_values
    INTRINSIC ALLOCATED
    INTRINSIC SUM
! Case of forward run
    IF (.NOT.ALLOCATED(parameters%control%x)) THEN
      RETURN
    ELSE
      jreg_cmpt_values = 0._sp
      DO i=1,options%cost%njrc
        SELECT CASE  (options%cost%jreg_cmpt(i)) 
        CASE ('prior') 
! Can be applied to any control
          jreg_cmpt_values(i) = PRIOR_REGULARIZATION(parameters)
        CASE ('smoothing') 
! Should be only used with distributed mapping. Applied on rr_parameters and rr_initial_states
          jreg_cmpt_values(i) = SMOOTHING_REGULARIZATION(setup, mesh, &
&           input_data, parameters, options, .false.)
        CASE ('hard-smoothing') 
! Should be only used with distributed mapping. Applied on rr_parameters and rr_initial_states
          jreg_cmpt_values(i) = SMOOTHING_REGULARIZATION(setup, mesh, &
&           input_data, parameters, options, .true.)
        END SELECT
      END DO
      jreg = SUM(options%cost%wjreg_cmpt*jreg_cmpt_values)
    END IF
  END SUBROUTINE CLASSICAL_COMPUTE_JREG

!  Differentiation of classical_compute_cost in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: output.cost
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_parameters.values)
!                *(parameters.rr_initial_states.values) *(output.response.q)
!   Plus diff mem management of: parameters.control.x:in parameters.control.l:in
!                parameters.control.u:in parameters.control.l_raw:in
!                parameters.control.u_raw:in parameters.rr_parameters.values:in
!                parameters.rr_initial_states.values:in parameters.serr_mu_parameters.values:in
!                parameters.serr_sigma_parameters.values:in parameters.nn_parameters.weight_1:in
!                parameters.nn_parameters.bias_1:in parameters.nn_parameters.weight_2:in
!                parameters.nn_parameters.bias_2:in parameters.nn_parameters.weight_3:in
!                parameters.nn_parameters.bias_3:in output.response.q:in
!                options.cost.wjreg_cmpt:in
  SUBROUTINE CLASSICAL_COMPUTE_COST_D(setup, mesh, input_data, &
&   parameters, parameters_d, output, output_d, options, options_d, &
&   returns)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(IN) :: parameters
    TYPE(PARAMETERSDT), INTENT(IN) :: parameters_d
    TYPE(OUTPUTDT), INTENT(INOUT) :: output
    TYPE(OUTPUTDT), INTENT(INOUT) :: output_d
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(OPTIONSDT_DIFF), INTENT(IN) :: options_d
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    REAL(sp) :: jobs, jreg
    REAL(sp) :: jobs_d, jreg_d
    CALL CLASSICAL_COMPUTE_JOBS_D(setup, mesh, input_data, output, &
&                           output_d, options, jobs, jobs_d)
    CALL CLASSICAL_COMPUTE_JREG_D(setup, mesh, input_data, parameters, &
&                           parameters_d, options, options_d, jreg, &
&                           jreg_d)
    output_d%cost = jobs_d + options%cost%wjreg*jreg_d
  END SUBROUTINE CLASSICAL_COMPUTE_COST_D

!  Differentiation of classical_compute_cost in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: output.cost
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_parameters.values)
!                *(parameters.rr_initial_states.values) *(output.response.q)
!   Plus diff mem management of: parameters.control.x:in parameters.control.l:in
!                parameters.control.u:in parameters.control.l_raw:in
!                parameters.control.u_raw:in parameters.rr_parameters.values:in
!                parameters.rr_initial_states.values:in parameters.serr_mu_parameters.values:in
!                parameters.serr_sigma_parameters.values:in parameters.nn_parameters.weight_1:in
!                parameters.nn_parameters.bias_1:in parameters.nn_parameters.weight_2:in
!                parameters.nn_parameters.bias_2:in parameters.nn_parameters.weight_3:in
!                parameters.nn_parameters.bias_3:in output.response.q:in
!                options.cost.wjreg_cmpt:in
  SUBROUTINE CLASSICAL_COMPUTE_COST_B(setup, mesh, input_data, &
&   parameters, parameters_b, output, output_b, options, options_b, &
&   returns)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(IN) :: parameters
    TYPE(PARAMETERSDT) :: parameters_b
    TYPE(OUTPUTDT), INTENT(INOUT) :: output
    TYPE(OUTPUTDT), INTENT(INOUT) :: output_b
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(OPTIONSDT_DIFF) :: options_b
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    REAL(sp) :: jobs, jreg
    REAL(sp) :: jobs_b, jreg_b
    CALL CLASSICAL_COMPUTE_JOBS(setup, mesh, input_data, output, options&
&                         , jobs)
    CALL PUSHREAL4ARRAY(parameters%control%x, SIZE(parameters%control%x&
&                 , 1))
    CALL PUSHREAL4ARRAY(parameters%rr_parameters%values, SIZE(parameters&
&                 %rr_parameters%values, 1)*SIZE(parameters%&
&                 rr_parameters%values, 2)*SIZE(parameters%rr_parameters&
&                 %values, 3))
    CALL PUSHREAL4ARRAY(parameters%rr_initial_states%values, SIZE(&
&                 parameters%rr_initial_states%values, 1)*SIZE(&
&                 parameters%rr_initial_states%values, 2)*SIZE(&
&                 parameters%rr_initial_states%values, 3))
    CALL PUSHREAL4ARRAY(parameters%nn_parameters%weight_1, SIZE(&
&                 parameters%nn_parameters%weight_1, 1)*SIZE(parameters%&
&                 nn_parameters%weight_1, 2))
    CALL PUSHREAL4ARRAY(parameters%nn_parameters%bias_1, SIZE(parameters&
&                 %nn_parameters%bias_1, 1))
    CALL PUSHREAL4ARRAY(parameters%nn_parameters%weight_2, SIZE(&
&                 parameters%nn_parameters%weight_2, 1)*SIZE(parameters%&
&                 nn_parameters%weight_2, 2))
    CALL PUSHREAL4ARRAY(parameters%nn_parameters%bias_2, SIZE(parameters&
&                 %nn_parameters%bias_2, 1))
    CALL PUSHREAL4ARRAY(parameters%nn_parameters%weight_3, SIZE(&
&                 parameters%nn_parameters%weight_3, 1)*SIZE(parameters%&
&                 nn_parameters%weight_3, 2))
    CALL PUSHREAL4ARRAY(parameters%nn_parameters%bias_3, SIZE(parameters&
&                 %nn_parameters%bias_3, 1))
    CALL CLASSICAL_COMPUTE_JREG(setup, mesh, input_data, parameters, &
&                         options, jreg)
    jobs_b = output_b%cost
    jreg_b = options%cost%wjreg*output_b%cost
    CALL POPREAL4ARRAY(parameters%nn_parameters%bias_3, SIZE(parameters%&
&                nn_parameters%bias_3, 1))
    CALL POPREAL4ARRAY(parameters%nn_parameters%weight_3, SIZE(&
&                parameters%nn_parameters%weight_3, 1)*SIZE(parameters%&
&                nn_parameters%weight_3, 2))
    CALL POPREAL4ARRAY(parameters%nn_parameters%bias_2, SIZE(parameters%&
&                nn_parameters%bias_2, 1))
    CALL POPREAL4ARRAY(parameters%nn_parameters%weight_2, SIZE(&
&                parameters%nn_parameters%weight_2, 1)*SIZE(parameters%&
&                nn_parameters%weight_2, 2))
    CALL POPREAL4ARRAY(parameters%nn_parameters%bias_1, SIZE(parameters%&
&                nn_parameters%bias_1, 1))
    CALL POPREAL4ARRAY(parameters%nn_parameters%weight_1, SIZE(&
&                parameters%nn_parameters%weight_1, 1)*SIZE(parameters%&
&                nn_parameters%weight_1, 2))
    CALL POPREAL4ARRAY(parameters%rr_initial_states%values, SIZE(&
&                parameters%rr_initial_states%values, 1)*SIZE(parameters&
&                %rr_initial_states%values, 2)*SIZE(parameters%&
&                rr_initial_states%values, 3))
    CALL POPREAL4ARRAY(parameters%rr_parameters%values, SIZE(parameters%&
&                rr_parameters%values, 1)*SIZE(parameters%rr_parameters%&
&                values, 2)*SIZE(parameters%rr_parameters%values, 3))
    CALL POPREAL4ARRAY(parameters%control%x, SIZE(parameters%control%x, &
&                1))
    CALL CLASSICAL_COMPUTE_JREG_B(setup, mesh, input_data, parameters, &
&                           parameters_b, options, options_b, jreg, &
&                           jreg_b)
    CALL CLASSICAL_COMPUTE_JOBS_B(setup, mesh, input_data, output, &
&                           output_b, options, jobs, jobs_b)
  END SUBROUTINE CLASSICAL_COMPUTE_COST_B

  SUBROUTINE CLASSICAL_COMPUTE_COST(setup, mesh, input_data, parameters&
&   , output, options, returns)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(IN) :: parameters
    TYPE(OUTPUTDT), INTENT(INOUT) :: output
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    REAL(sp) :: jobs, jreg
    jobs = 0._sp
    jreg = 0._sp
    CALL CLASSICAL_COMPUTE_JOBS(setup, mesh, input_data, output, options&
&                         , jobs)
    CALL CLASSICAL_COMPUTE_JREG(setup, mesh, input_data, parameters, &
&                         options, jreg)
    output%cost = jobs + options%cost%wjreg*jreg
  END SUBROUTINE CLASSICAL_COMPUTE_COST

!  Differentiation of compute_cost in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: output.cost
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_parameters.values)
!                *(parameters.rr_initial_states.values) *(parameters.serr_mu_parameters.values)
!                *(parameters.serr_sigma_parameters.values) *(output.response.q)
!   Plus diff mem management of: parameters.control.x:in parameters.control.l:in
!                parameters.control.u:in parameters.control.l_raw:in
!                parameters.control.u_raw:in parameters.rr_parameters.values:in
!                parameters.rr_initial_states.values:in parameters.serr_mu_parameters.values:in
!                parameters.serr_sigma_parameters.values:in parameters.nn_parameters.weight_1:in
!                parameters.nn_parameters.bias_1:in parameters.nn_parameters.weight_2:in
!                parameters.nn_parameters.bias_2:in parameters.nn_parameters.weight_3:in
!                parameters.nn_parameters.bias_3:in output.response.q:in
!                options.cost.wjreg_cmpt:in
  SUBROUTINE COMPUTE_COST_D(setup, mesh, input_data, parameters, &
&   parameters_d, output, output_d, options, options_d, returns)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(IN) :: parameters
    TYPE(PARAMETERSDT), INTENT(IN) :: parameters_d
    TYPE(OUTPUTDT), INTENT(INOUT) :: output
    TYPE(OUTPUTDT), INTENT(INOUT) :: output_d
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(OPTIONSDT_DIFF), INTENT(IN) :: options_d
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    IF (options%cost%bayesian) THEN
      CALL BAYESIAN_COMPUTE_COST_D(setup, mesh, input_data, parameters, &
&                            parameters_d, output, output_d, options, &
&                            returns)
    ELSE
      CALL CLASSICAL_COMPUTE_COST_D(setup, mesh, input_data, parameters&
&                             , parameters_d, output, output_d, options&
&                             , options_d, returns)
    END IF
  END SUBROUTINE COMPUTE_COST_D

!  Differentiation of compute_cost in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: output.cost
!   with respect to varying inputs: *(parameters.control.x) *(parameters.rr_parameters.values)
!                *(parameters.rr_initial_states.values) *(parameters.serr_mu_parameters.values)
!                *(parameters.serr_sigma_parameters.values) *(output.response.q)
!   Plus diff mem management of: parameters.control.x:in parameters.control.l:in
!                parameters.control.u:in parameters.control.l_raw:in
!                parameters.control.u_raw:in parameters.rr_parameters.values:in
!                parameters.rr_initial_states.values:in parameters.serr_mu_parameters.values:in
!                parameters.serr_sigma_parameters.values:in parameters.nn_parameters.weight_1:in
!                parameters.nn_parameters.bias_1:in parameters.nn_parameters.weight_2:in
!                parameters.nn_parameters.bias_2:in parameters.nn_parameters.weight_3:in
!                parameters.nn_parameters.bias_3:in output.response.q:in
!                options.cost.wjreg_cmpt:in
  SUBROUTINE COMPUTE_COST_B(setup, mesh, input_data, parameters, &
&   parameters_b, output, output_b, options, options_b, returns)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(IN) :: parameters
    TYPE(PARAMETERSDT) :: parameters_b
    TYPE(OUTPUTDT), INTENT(INOUT) :: output
    TYPE(OUTPUTDT), INTENT(INOUT) :: output_b
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(OPTIONSDT_DIFF) :: options_b
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    IF (options%cost%bayesian) THEN
      CALL BAYESIAN_COMPUTE_COST(setup, mesh, input_data, parameters, &
&                          output, options, returns)
      CALL BAYESIAN_COMPUTE_COST_B(setup, mesh, input_data, parameters, &
&                            parameters_b, output, output_b, options, &
&                            returns)
      parameters_b%rr_parameters%values = 0.0_4
      parameters_b%rr_initial_states%values = 0.0_4
    ELSE
      CALL PUSHREAL4ARRAY(parameters%control%x, SIZE(parameters%control%&
&                   x, 1))
      CALL PUSHREAL4ARRAY(parameters%rr_parameters%values, SIZE(&
&                   parameters%rr_parameters%values, 1)*SIZE(parameters%&
&                   rr_parameters%values, 2)*SIZE(parameters%&
&                   rr_parameters%values, 3))
      CALL PUSHREAL4ARRAY(parameters%rr_initial_states%values, SIZE(&
&                   parameters%rr_initial_states%values, 1)*SIZE(&
&                   parameters%rr_initial_states%values, 2)*SIZE(&
&                   parameters%rr_initial_states%values, 3))
      CALL PUSHREAL4ARRAY(parameters%nn_parameters%weight_1, SIZE(&
&                   parameters%nn_parameters%weight_1, 1)*SIZE(&
&                   parameters%nn_parameters%weight_1, 2))
      CALL PUSHREAL4ARRAY(parameters%nn_parameters%bias_1, SIZE(&
&                   parameters%nn_parameters%bias_1, 1))
      CALL PUSHREAL4ARRAY(parameters%nn_parameters%weight_2, SIZE(&
&                   parameters%nn_parameters%weight_2, 1)*SIZE(&
&                   parameters%nn_parameters%weight_2, 2))
      CALL PUSHREAL4ARRAY(parameters%nn_parameters%bias_2, SIZE(&
&                   parameters%nn_parameters%bias_2, 1))
      CALL PUSHREAL4ARRAY(parameters%nn_parameters%weight_3, SIZE(&
&                   parameters%nn_parameters%weight_3, 1)*SIZE(&
&                   parameters%nn_parameters%weight_3, 2))
      CALL PUSHREAL4ARRAY(parameters%nn_parameters%bias_3, SIZE(&
&                   parameters%nn_parameters%bias_3, 1))
      CALL CLASSICAL_COMPUTE_COST(setup, mesh, input_data, parameters, &
&                           output, options, returns)
      CALL POPREAL4ARRAY(parameters%nn_parameters%bias_3, SIZE(&
&                  parameters%nn_parameters%bias_3, 1))
      CALL POPREAL4ARRAY(parameters%nn_parameters%weight_3, SIZE(&
&                  parameters%nn_parameters%weight_3, 1)*SIZE(parameters&
&                  %nn_parameters%weight_3, 2))
      CALL POPREAL4ARRAY(parameters%nn_parameters%bias_2, SIZE(&
&                  parameters%nn_parameters%bias_2, 1))
      CALL POPREAL4ARRAY(parameters%nn_parameters%weight_2, SIZE(&
&                  parameters%nn_parameters%weight_2, 1)*SIZE(parameters&
&                  %nn_parameters%weight_2, 2))
      CALL POPREAL4ARRAY(parameters%nn_parameters%bias_1, SIZE(&
&                  parameters%nn_parameters%bias_1, 1))
      CALL POPREAL4ARRAY(parameters%nn_parameters%weight_1, SIZE(&
&                  parameters%nn_parameters%weight_1, 1)*SIZE(parameters&
&                  %nn_parameters%weight_1, 2))
      CALL POPREAL4ARRAY(parameters%rr_initial_states%values, SIZE(&
&                  parameters%rr_initial_states%values, 1)*SIZE(&
&                  parameters%rr_initial_states%values, 2)*SIZE(&
&                  parameters%rr_initial_states%values, 3))
      CALL POPREAL4ARRAY(parameters%rr_parameters%values, SIZE(&
&                  parameters%rr_parameters%values, 1)*SIZE(parameters%&
&                  rr_parameters%values, 2)*SIZE(parameters%&
&                  rr_parameters%values, 3))
      CALL POPREAL4ARRAY(parameters%control%x, SIZE(parameters%control%x&
&                  , 1))
      CALL CLASSICAL_COMPUTE_COST_B(setup, mesh, input_data, parameters&
&                             , parameters_b, output, output_b, options&
&                             , options_b, returns)
      parameters_b%serr_mu_parameters%values = 0.0_4
      parameters_b%serr_sigma_parameters%values = 0.0_4
    END IF
  END SUBROUTINE COMPUTE_COST_B

  SUBROUTINE COMPUTE_COST(setup, mesh, input_data, parameters, output, &
&   options, returns)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(IN) :: parameters
    TYPE(OUTPUTDT), INTENT(INOUT) :: output
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    IF (options%cost%bayesian) THEN
      CALL BAYESIAN_COMPUTE_COST(setup, mesh, input_data, parameters, &
&                          output, options, returns)
    ELSE
      CALL CLASSICAL_COMPUTE_COST(setup, mesh, input_data, parameters, &
&                           output, options, returns)
    END IF
  END SUBROUTINE COMPUTE_COST

END MODULE MWD_COST_DIFF

!%      (MWD) Module Wrapped and Differentiated
!%
!%      Subroutine
!%      ----------
!%
!%      - binary_search
!%      - compute_rowcol_to_ind_ac
!%      - matrix_to_ac_vector
!%      - ac_vector_to_matrix
!%      - get_matrix_nnz
!%      - coo_fill_sparse_matrix
!%      - ac_fill_sparse_matrix
!%      - fill_sparse_matrix
!%      - matrix_to_sparse_matrix
!%      - coo_sparse_matrix_to_matrix
!%      - ac_sparse_matrix_to_matrix
!%      - sparse_matrix_to_matrix
!%      - coo_get_sparse_matrix_dat
!%      - ac_get_sparse_matrix_dat
!%      - get_sparse_matrix_dat
MODULE MWD_SPARSE_MATRIX_MANIPULATION_DIFF
  USE MD_CONSTANT, ONLY : sp
  USE MWD_MESH, ONLY : meshdt
  USE MWD_SPARSE_MATRIX, ONLY : sparse_matrixdt, &
& sparse_matrixdt_initialise
  IMPLICIT NONE
  PUBLIC :: compute_rowcol_to_ind_ac, matrix_to_sparse_matrix, &
& sparse_matrix_to_matrix, get_sparse_matrix_dat

CONTAINS
  SUBROUTINE BINARY_SEARCH(n, vector, vle, ind)
    IMPLICIT NONE
    INTEGER, INTENT(IN) :: n
    INTEGER, DIMENSION(n), INTENT(IN) :: vector
    INTEGER, INTENT(IN) :: vle
    INTEGER, INTENT(INOUT) :: ind
    INTEGER :: l, u, m
    ind = -1
    l = 1
    u = n
    DO WHILE (l .LE. u)
      m = (u+l)/2
      IF (vector(m) .LT. vle) THEN
        l = m + 1
      ELSE IF (vector(m) .GT. vle) THEN
        u = m - 1
      ELSE
        ind = m
        GOTO 100
      END IF
    END DO
 100 CONTINUE
  END SUBROUTINE BINARY_SEARCH

  SUBROUTINE COMPUTE_ROWCOL_TO_IND_AC(mesh)
    IMPLICIT NONE
    TYPE(MESHDT), INTENT(INOUT) :: mesh
    INTEGER :: i, row, col
    i = 0
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .NE. 0) THEN
          i = i + 1
          mesh%rowcol_to_ind_ac(row, col) = i
        END IF
      END DO
    END DO
  END SUBROUTINE COMPUTE_ROWCOL_TO_IND_AC

!  Differentiation of matrix_to_ac_vector in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: ac_vector
!   with respect to varying inputs: ac_vector matrix
  SUBROUTINE MATRIX_TO_AC_VECTOR_D(mesh, matrix, matrix_d, ac_vector, &
&   ac_vector_d)
    IMPLICIT NONE
    TYPE(MESHDT), INTENT(IN) :: mesh
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol), INTENT(IN) :: matrix
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol), INTENT(IN) :: matrix_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_vector
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_vector_d
    INTEGER :: row, col, k
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        k = mesh%rowcol_to_ind_ac(row, col)
        IF (k .NE. -99) THEN
          ac_vector_d(k) = matrix_d(row, col)
          ac_vector(k) = matrix(row, col)
        END IF
      END DO
    END DO
  END SUBROUTINE MATRIX_TO_AC_VECTOR_D

!  Differentiation of matrix_to_ac_vector in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: ac_vector matrix
!   with respect to varying inputs: ac_vector matrix
  SUBROUTINE MATRIX_TO_AC_VECTOR_B(mesh, matrix, matrix_b, ac_vector, &
&   ac_vector_b)
    IMPLICIT NONE
    TYPE(MESHDT), INTENT(IN) :: mesh
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol), INTENT(IN) :: matrix
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: matrix_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_vector
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_vector_b
    INTEGER :: row, col, k
    INTEGER :: branch
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        k = mesh%rowcol_to_ind_ac(row, col)
        IF (k .EQ. -99) THEN
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHCONTROL1B(1)
        END IF
      END DO
    END DO
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          matrix_b(row, col) = matrix_b(row, col) + ac_vector_b(k)
          ac_vector_b(k) = 0.0_4
        END IF
      END DO
    END DO
  END SUBROUTINE MATRIX_TO_AC_VECTOR_B

  SUBROUTINE MATRIX_TO_AC_VECTOR(mesh, matrix, ac_vector)
    IMPLICIT NONE
    TYPE(MESHDT), INTENT(IN) :: mesh
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol), INTENT(IN) :: matrix
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_vector
    INTEGER :: row, col, k
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        k = mesh%rowcol_to_ind_ac(row, col)
        IF (k .NE. -99) ac_vector(k) = matrix(row, col)
      END DO
    END DO
  END SUBROUTINE MATRIX_TO_AC_VECTOR

  SUBROUTINE AC_VECTOR_TO_MATRIX(mesh, ac_vector, matrix)
    IMPLICIT NONE
    TYPE(MESHDT), INTENT(IN) :: mesh
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_vector
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol), INTENT(INOUT) :: matrix
    INTEGER :: row, col, k
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        k = mesh%rowcol_to_ind_ac(row, col)
        IF (k .NE. -99) matrix(row, col) = ac_vector(k)
      END DO
    END DO
  END SUBROUTINE AC_VECTOR_TO_MATRIX

  SUBROUTINE GET_MATRIX_NNZ(mesh, matrix, zvalue, nnz)
    IMPLICIT NONE
    TYPE(MESHDT), INTENT(IN) :: mesh
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol), INTENT(IN) :: matrix
    REAL(sp), INTENT(IN) :: zvalue
    INTEGER, INTENT(INOUT) :: nnz
    INTEGER :: row, col
    INTRINSIC ABS
    REAL(sp) :: abs0
    nnz = 0
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (matrix(row, col) - zvalue .GE. 0.) THEN
          abs0 = matrix(row, col) - zvalue
        ELSE
          abs0 = -(matrix(row, col)-zvalue)
        END IF
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. abs0 .LE. 0._sp&
&           )) nnz = nnz + 1
      END DO
    END DO
  END SUBROUTINE GET_MATRIX_NNZ

  SUBROUTINE COO_FILL_SPARSE_MATRIX(mesh, matrix, sparse_matrix)
    IMPLICIT NONE
    TYPE(MESHDT), INTENT(IN) :: mesh
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol), INTENT(IN) :: matrix
    TYPE(SPARSE_MATRIXDT), INTENT(INOUT) :: sparse_matrix
    INTEGER :: row, col, i
    INTRINSIC ABS
    REAL(sp) :: abs0
    i = 0
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (matrix(row, col) - sparse_matrix%zvalue .GE. 0.) THEN
          abs0 = matrix(row, col) - sparse_matrix%zvalue
        ELSE
          abs0 = -(matrix(row, col)-sparse_matrix%zvalue)
        END IF
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. abs0 .LE. 0._sp&
&           )) THEN
          i = i + 1
          sparse_matrix%indices(i) = mesh%rowcol_to_ind_ac(row, col)
          sparse_matrix%values(i) = matrix(row, col)
        END IF
      END DO
    END DO
  END SUBROUTINE COO_FILL_SPARSE_MATRIX

  SUBROUTINE AC_FILL_SPARSE_MATRIX(mesh, matrix, sparse_matrix)
    IMPLICIT NONE
    TYPE(MESHDT), INTENT(IN) :: mesh
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol), INTENT(IN) :: matrix
    TYPE(SPARSE_MATRIXDT), INTENT(INOUT) :: sparse_matrix
    CALL MATRIX_TO_AC_VECTOR(mesh, matrix, sparse_matrix%values)
  END SUBROUTINE AC_FILL_SPARSE_MATRIX

  SUBROUTINE FILL_SPARSE_MATRIX(mesh, matrix, sparse_matrix)
    IMPLICIT NONE
    TYPE(MESHDT), INTENT(IN) :: mesh
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol), INTENT(IN) :: matrix
    TYPE(SPARSE_MATRIXDT), INTENT(INOUT) :: sparse_matrix
    IF (sparse_matrix%coo_fmt) THEN
      CALL COO_FILL_SPARSE_MATRIX(mesh, matrix, sparse_matrix)
    ELSE
      CALL AC_FILL_SPARSE_MATRIX(mesh, matrix, sparse_matrix)
    END IF
  END SUBROUTINE FILL_SPARSE_MATRIX

  SUBROUTINE MATRIX_TO_SPARSE_MATRIX(mesh, matrix, zvalue, sparse_matrix&
& )
    IMPLICIT NONE
    TYPE(MESHDT), INTENT(IN) :: mesh
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol), INTENT(IN) :: matrix
    REAL(sp), INTENT(IN) :: zvalue
    TYPE(SPARSE_MATRIXDT), INTENT(INOUT) :: sparse_matrix
    INTEGER :: nnz, n
    LOGICAL :: coo_fmt
    CALL GET_MATRIX_NNZ(mesh, matrix, zvalue, nnz)
!% Do not need to cast to real
    IF (nnz .LE. mesh%nac/2) THEN
      n = nnz
      coo_fmt = .true.
    ELSE
      n = mesh%nac
      coo_fmt = .false.
    END IF
    CALL SPARSE_MATRIXDT_INITIALISE(sparse_matrix, n, coo_fmt, zvalue)
    CALL FILL_SPARSE_MATRIX(mesh, matrix, sparse_matrix)
  END SUBROUTINE MATRIX_TO_SPARSE_MATRIX

  SUBROUTINE COO_SPARSE_MATRIX_TO_MATRIX(mesh, sparse_matrix, matrix)
    IMPLICIT NONE
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(SPARSE_MATRIXDT), INTENT(IN) :: sparse_matrix
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol), INTENT(INOUT) :: matrix
    INTEGER :: row, col, i, next_ind
    i = 0
    next_ind = 1
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .NE. 0) THEN
          i = i + 1
          IF (i .EQ. sparse_matrix%indices(next_ind)) THEN
            matrix(row, col) = sparse_matrix%values(next_ind)
            next_ind = next_ind + 1
            IF (next_ind .GT. sparse_matrix%n) RETURN
          END IF
        END IF
      END DO
    END DO
  END SUBROUTINE COO_SPARSE_MATRIX_TO_MATRIX

  SUBROUTINE AC_SPARSE_MATRIX_TO_MATRIX(mesh, sparse_matrix, matrix)
    IMPLICIT NONE
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(SPARSE_MATRIXDT), INTENT(IN) :: sparse_matrix
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol), INTENT(INOUT) :: matrix
    CALL AC_VECTOR_TO_MATRIX(mesh, sparse_matrix%values, matrix)
  END SUBROUTINE AC_SPARSE_MATRIX_TO_MATRIX

  SUBROUTINE SPARSE_MATRIX_TO_MATRIX(mesh, sparse_matrix, matrix)
    IMPLICIT NONE
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(SPARSE_MATRIXDT), INTENT(IN) :: sparse_matrix
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol), INTENT(INOUT) :: matrix
    matrix = sparse_matrix%zvalue
    IF (sparse_matrix%n .EQ. 0) THEN
      RETURN
    ELSE IF (sparse_matrix%coo_fmt) THEN
      CALL COO_SPARSE_MATRIX_TO_MATRIX(mesh, sparse_matrix, matrix)
    ELSE
      CALL AC_SPARSE_MATRIX_TO_MATRIX(mesh, sparse_matrix, matrix)
    END IF
  END SUBROUTINE SPARSE_MATRIX_TO_MATRIX

  SUBROUTINE COO_GET_SPARSE_MATRIX_DAT(mesh, row, col, sparse_matrix, &
&   res)
    IMPLICIT NONE
    TYPE(MESHDT), INTENT(IN) :: mesh
    INTEGER, INTENT(IN) :: row, col
    TYPE(SPARSE_MATRIXDT), INTENT(IN) :: sparse_matrix
    REAL(sp), INTENT(INOUT) :: res
    INTEGER :: k, ind
    k = mesh%rowcol_to_ind_ac(row, col)
    CALL BINARY_SEARCH(sparse_matrix%n, sparse_matrix%indices, k, ind)
    IF (ind .NE. -1) res = sparse_matrix%values(ind)
  END SUBROUTINE COO_GET_SPARSE_MATRIX_DAT

  SUBROUTINE AC_GET_SPARSE_MATRIX_DAT(mesh, row, col, sparse_matrix, res&
& )
    IMPLICIT NONE
    TYPE(MESHDT), INTENT(IN) :: mesh
    INTEGER, INTENT(IN) :: row, col
    TYPE(SPARSE_MATRIXDT), INTENT(IN) :: sparse_matrix
    REAL(sp), INTENT(INOUT) :: res
    INTEGER :: k
    k = mesh%rowcol_to_ind_ac(row, col)
    res = sparse_matrix%values(k)
  END SUBROUTINE AC_GET_SPARSE_MATRIX_DAT

  SUBROUTINE GET_SPARSE_MATRIX_DAT(mesh, row, col, sparse_matrix, res)
    IMPLICIT NONE
    TYPE(MESHDT), INTENT(IN) :: mesh
    INTEGER, INTENT(IN) :: row, col
    TYPE(SPARSE_MATRIXDT), INTENT(IN) :: sparse_matrix
    REAL(sp), INTENT(INOUT) :: res
    res = sparse_matrix%zvalue
    IF (sparse_matrix%n .EQ. 0) THEN
      RETURN
    ELSE IF (sparse_matrix%coo_fmt) THEN
      CALL COO_GET_SPARSE_MATRIX_DAT(mesh, row, col, sparse_matrix, res)
    ELSE
      CALL AC_GET_SPARSE_MATRIX_DAT(mesh, row, col, sparse_matrix, res)
    END IF
  END SUBROUTINE GET_SPARSE_MATRIX_DAT

END MODULE MWD_SPARSE_MATRIX_MANIPULATION_DIFF

!%      (MD) Module Differentiated.
!%
!%      Type
!%      ----
!%
!%      - Checkpoint_VariableDT
!%          Checkpoint variables passed to simulation_checkpoint subroutine. It stores variables that must
!%          be checkpointed by the adjoint model (i.e. variables that are push/pop each time step)
!%
!%          ======================== =======================================
!%          `Variables`              Description
!%          ======================== =======================================
!%          ``ac_rr_parameters``     Active cell rainfall-runoff parameters
!%          ``ac_rr_states``         Active cell rainfall-runoff states
!%          ``ac_mlt``               Active cell melt flux (snow module output)
!%          ``ac_qtz``               Active cell elemental discharge with time buffer (hydrological module output)
!%          ``ac_qz``                Active cell surface discharge with time buffer (routing module output)
!%          ======================== =======================================
MODULE MD_CHECKPOINT_VARIABLE_DIFF
!% only: sp
  USE MD_CONSTANT
  IMPLICIT NONE
  TYPE CHECKPOINT_VARIABLEDT
      REAL(sp), DIMENSION(:, :), ALLOCATABLE :: ac_rr_parameters
      REAL(sp), DIMENSION(:, :), ALLOCATABLE :: ac_rr_states
      REAL(sp), DIMENSION(:), ALLOCATABLE :: ac_mlt
      REAL(sp), DIMENSION(:, :), ALLOCATABLE :: ac_qtz, ac_qz
  END TYPE CHECKPOINT_VARIABLEDT
END MODULE MD_CHECKPOINT_VARIABLE_DIFF

!%      (MW) Module Wrapped and Differentiated.
!%
!%      Subroutine
!%      ----------
!%
!%      - get_atmos_data_timestep
!%      - set_atmos_data_timestep
!%      - get_ac_atmos_data_timestep
!%      - set_ac_atmos_data_timestep
MODULE MWD_ATMOS_MANIPULATION_DIFF
!% only: sp
  USE MD_CONSTANT
!% only: SetupDT
  USE MWD_SETUP
!% only: MeshDT
  USE MWD_MESH
!% only: Input_DataDT
  USE MWD_INPUT_DATA
!% only: sparse_matrix_to_matrix, matrix_to_sparse_matrix, &
  USE MWD_SPARSE_MATRIX_MANIPULATION_DIFF
  IMPLICIT NONE

CONTAINS
  SUBROUTINE GET_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&   , key, vle)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    INTEGER, INTENT(IN) :: time_step
    CHARACTER(len=*), INTENT(IN) :: key
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol), INTENT(INOUT) :: vle
    INTRINSIC TRIM
    SELECT CASE  (TRIM(key)) 
    CASE ('prcp') 
      IF (setup%sparse_storage) THEN
        CALL SPARSE_MATRIX_TO_MATRIX(mesh, input_data%atmos_data%&
&                              sparse_prcp(time_step), vle)
      ELSE
        vle = input_data%atmos_data%prcp(:, :, time_step)
      END IF
    CASE ('pet') 
      IF (setup%sparse_storage) THEN
        CALL SPARSE_MATRIX_TO_MATRIX(mesh, input_data%atmos_data%&
&                              sparse_pet(time_step), vle)
      ELSE
        vle = input_data%atmos_data%pet(:, :, time_step)
      END IF
    CASE ('snow') 
!% assert (setup%snow_module_present)
      IF (setup%sparse_storage) THEN
        CALL SPARSE_MATRIX_TO_MATRIX(mesh, input_data%atmos_data%&
&                              sparse_snow(time_step), vle)
      ELSE
        vle = input_data%atmos_data%snow(:, :, time_step)
      END IF
    CASE ('temp') 
!% assert (setup%snow_module_present)
      IF (setup%sparse_storage) THEN
        CALL SPARSE_MATRIX_TO_MATRIX(mesh, input_data%atmos_data%&
&                              sparse_temp(time_step), vle)
      ELSE
        vle = input_data%atmos_data%temp(:, :, time_step)
      END IF
    END SELECT
  END SUBROUTINE GET_ATMOS_DATA_TIME_STEP

  SUBROUTINE SET_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&   , key, vle)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(INOUT) :: input_data
    INTEGER, INTENT(IN) :: time_step
    CHARACTER(len=*), INTENT(IN) :: key
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol), INTENT(IN) :: vle
    INTRINSIC TRIM
    SELECT CASE  (TRIM(key)) 
    CASE ('prcp') 
      IF (setup%sparse_storage) THEN
        CALL MATRIX_TO_SPARSE_MATRIX(mesh, vle, 0._sp, input_data%&
&                              atmos_data%sparse_prcp(time_step))
      ELSE
        input_data%atmos_data%prcp(:, :, time_step) = vle
      END IF
    CASE ('pet') 
      IF (setup%sparse_storage) THEN
        CALL MATRIX_TO_SPARSE_MATRIX(mesh, vle, 0._sp, input_data%&
&                              atmos_data%sparse_pet(time_step))
      ELSE
        input_data%atmos_data%pet(:, :, time_step) = vle
      END IF
    CASE ('snow') 
!% assert (setup%snow_module_present)
      IF (setup%sparse_storage) THEN
        CALL MATRIX_TO_SPARSE_MATRIX(mesh, vle, 0._sp, input_data%&
&                              atmos_data%sparse_snow(time_step))
      ELSE
        input_data%atmos_data%snow(:, :, time_step) = vle
      END IF
    CASE ('temp') 
!% assert (setup%snow_module_present)
      IF (setup%sparse_storage) THEN
        CALL MATRIX_TO_SPARSE_MATRIX(mesh, vle, 0._sp, input_data%&
&                              atmos_data%sparse_temp(time_step))
      ELSE
        input_data%atmos_data%temp(:, :, time_step) = vle
      END IF
    END SELECT
  END SUBROUTINE SET_ATMOS_DATA_TIME_STEP

  SUBROUTINE GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, &
&   time_step, key, ac_vector)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    INTEGER, INTENT(IN) :: time_step
    CHARACTER(len=*), INTENT(IN) :: key
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_vector
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: matrix
    CALL GET_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step, &
&                           key, matrix)
    CALL MATRIX_TO_AC_VECTOR(mesh, matrix, ac_vector)
  END SUBROUTINE GET_AC_ATMOS_DATA_TIME_STEP

  SUBROUTINE SET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, &
&   time_step, key, ac_vector)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(INOUT) :: input_data
    INTEGER, INTENT(IN) :: time_step
    CHARACTER(len=*), INTENT(IN) :: key
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_vector
    REAL(sp), DIMENSION(mesh%nrow, mesh%ncol) :: matrix
    CALL AC_VECTOR_TO_MATRIX(mesh, ac_vector, matrix)
    CALL SET_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step, &
&                           key, matrix)
  END SUBROUTINE SET_AC_ATMOS_DATA_TIME_STEP

END MODULE MWD_ATMOS_MANIPULATION_DIFF

!%      (MD) Module Differentiated.
!%
!%      Subroutine
!%      ----------
!%
!%      - solve_linear_system_2vars
!%      - dot_product_2d_1d
MODULE MD_ALGEBRA_DIFF
!% only : sp
  USE MD_CONSTANT
  IMPLICIT NONE

CONTAINS
!  Differentiation of solve_linear_system_2vars in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: x
!   with respect to varying inputs: x a b
  SUBROUTINE SOLVE_LINEAR_SYSTEM_2VARS_D(a, a_d, x, x_d, b, b_d)
    IMPLICIT NONE
    REAL(sp), DIMENSION(2, 2), INTENT(IN) :: a
    REAL(sp), DIMENSION(2, 2), INTENT(IN) :: a_d
    REAL(sp), DIMENSION(2), INTENT(IN) :: b
    REAL(sp), DIMENSION(2), INTENT(IN) :: b_d
    REAL(sp), DIMENSION(2), INTENT(OUT) :: x
    REAL(sp), DIMENSION(2), INTENT(OUT) :: x_d
    REAL(sp) :: det_a
    REAL(sp) :: det_a_d
    INTRINSIC ABS
    REAL(sp) :: abs0
    REAL(sp) :: temp
    det_a_d = a(2, 2)*a_d(1, 1) + a(1, 1)*a_d(2, 2) - a(2, 1)*a_d(1, 2) &
&     - a(1, 2)*a_d(2, 1)
    det_a = a(1, 1)*a(2, 2) - a(1, 2)*a(2, 1)
    IF (det_a .GE. 0.) THEN
      abs0 = det_a
    ELSE
      abs0 = -det_a
    END IF
    IF (abs0 .GT. 0._sp) THEN
      temp = (b(2)*a(1, 2)-b(1)*a(2, 2))/det_a
      x_d(1) = (a(1, 2)*b_d(2)+b(2)*a_d(1, 2)-a(2, 2)*b_d(1)-b(1)*a_d(2&
&       , 2)-temp*det_a_d)/det_a
      x(1) = temp
      temp = (b(1)*a(2, 1)-b(2)*a(1, 1))/det_a
      x_d(2) = (a(2, 1)*b_d(1)+b(1)*a_d(2, 1)-a(1, 1)*b_d(2)-b(2)*a_d(1&
&       , 1)-temp*det_a_d)/det_a
      x(2) = temp
    ELSE
      x = 0._sp
      x_d = 0.0_4
    END IF
  END SUBROUTINE SOLVE_LINEAR_SYSTEM_2VARS_D

!  Differentiation of solve_linear_system_2vars in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: x a b
!   with respect to varying inputs: x a b
  SUBROUTINE SOLVE_LINEAR_SYSTEM_2VARS_B(a, a_b, x, x_b, b, b_b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(2, 2), INTENT(IN) :: a
    REAL(sp), DIMENSION(2, 2) :: a_b
    REAL(sp), DIMENSION(2), INTENT(IN) :: b
    REAL(sp), DIMENSION(2) :: b_b
    REAL(sp), DIMENSION(2) :: x
    REAL(sp), DIMENSION(2) :: x_b
    REAL(sp) :: det_a
    REAL(sp) :: det_a_b
    INTRINSIC ABS
    REAL(sp) :: abs0
    REAL(sp) :: temp_b
    det_a = a(1, 1)*a(2, 2) - a(1, 2)*a(2, 1)
    IF (det_a .GE. 0.) THEN
      abs0 = det_a
    ELSE
      abs0 = -det_a
    END IF
    IF (abs0 .GT. 0._sp) THEN
      det_a = a(1, 1)*a(2, 2) - a(1, 2)*a(2, 1)
      temp_b = x_b(2)/det_a
      x_b(2) = 0.0_4
      b_b(1) = b_b(1) + a(2, 1)*temp_b
      a_b(2, 1) = a_b(2, 1) + b(1)*temp_b
      b_b(2) = b_b(2) - a(1, 1)*temp_b
      a_b(1, 1) = a_b(1, 1) - b(2)*temp_b
      det_a_b = -((b(1)*a(2, 1)-b(2)*a(1, 1))*temp_b/det_a)
      temp_b = x_b(1)/det_a
      x_b(1) = 0.0_4
      b_b(2) = b_b(2) + a(1, 2)*temp_b
      a_b(1, 2) = a_b(1, 2) + b(2)*temp_b
      b_b(1) = b_b(1) - a(2, 2)*temp_b
      a_b(2, 2) = a_b(2, 2) - b(1)*temp_b
      det_a_b = det_a_b - (b(2)*a(1, 2)-b(1)*a(2, 2))*temp_b/det_a
    ELSE
      x_b = 0.0_4
      det_a_b = 0.0_4
    END IF
    a_b(1, 1) = a_b(1, 1) + a(2, 2)*det_a_b
    a_b(2, 2) = a_b(2, 2) + a(1, 1)*det_a_b
    a_b(1, 2) = a_b(1, 2) - a(2, 1)*det_a_b
    a_b(2, 1) = a_b(2, 1) - a(1, 2)*det_a_b
  END SUBROUTINE SOLVE_LINEAR_SYSTEM_2VARS_B

  SUBROUTINE SOLVE_LINEAR_SYSTEM_2VARS(a, x, b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(2, 2), INTENT(IN) :: a
    REAL(sp), DIMENSION(2), INTENT(IN) :: b
    REAL(sp), DIMENSION(2), INTENT(OUT) :: x
    REAL(sp) :: det_a
    INTRINSIC ABS
    REAL(sp) :: abs0
    det_a = a(1, 1)*a(2, 2) - a(1, 2)*a(2, 1)
    IF (det_a .GE. 0.) THEN
      abs0 = det_a
    ELSE
      abs0 = -det_a
    END IF
    IF (abs0 .GT. 0._sp) THEN
      x(1) = (b(2)*a(1, 2)-b(1)*a(2, 2))/det_a
      x(2) = (b(1)*a(2, 1)-b(2)*a(1, 1))/det_a
    ELSE
      x = 0._sp
    END IF
  END SUBROUTINE SOLVE_LINEAR_SYSTEM_2VARS

!  Differentiation of dot_product_2d_1d in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: b
!   with respect to varying inputs: x a
  SUBROUTINE DOT_PRODUCT_2D_1D_D(a, a_d, x, x_d, b, b_d)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: a
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: a_d
    REAL(sp), DIMENSION(:), INTENT(IN) :: x
    REAL(sp), DIMENSION(:), INTENT(IN) :: x_d
    REAL(sp), DIMENSION(:), INTENT(INOUT) :: b
    REAL(sp), DIMENSION(:), INTENT(INOUT) :: b_d
    INTEGER :: i, j
    INTRINSIC SIZE
    b = 0._sp
    b_d = 0.0_4
    DO j=1,SIZE(a, 2)
      DO i=1,SIZE(a, 1)
        b_d(i) = b_d(i) + x(j)*a_d(i, j) + a(i, j)*x_d(j)
        b(i) = b(i) + a(i, j)*x(j)
      END DO
    END DO
  END SUBROUTINE DOT_PRODUCT_2D_1D_D

!  Differentiation of dot_product_2d_1d in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: a b
!   with respect to varying inputs: x a
  SUBROUTINE DOT_PRODUCT_2D_1D_B(a, a_b, x, x_b, b, b_b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: a
    REAL(sp), DIMENSION(:, :) :: a_b
    REAL(sp), DIMENSION(:), INTENT(IN) :: x
    REAL(sp), DIMENSION(:) :: x_b
    REAL(sp), DIMENSION(:), INTENT(INOUT) :: b
    REAL(sp), DIMENSION(:), INTENT(INOUT) :: b_b
    INTEGER :: i, j
    INTRINSIC SIZE
    INTEGER :: ad_to
    INTEGER :: ad_to0
    DO j=1,SIZE(a, 2)
      DO i=1,SIZE(a, 1)

      END DO
      CALL PUSHINTEGER4(i - 1)
    END DO
    ad_to0 = j - 1
    x_b = 0.0_4
    DO j=ad_to0,1,-1
      CALL POPINTEGER4(ad_to)
      DO i=ad_to,1,-1
        a_b(i, j) = a_b(i, j) + x(j)*b_b(i)
        x_b(j) = x_b(j) + a(i, j)*b_b(i)
      END DO
    END DO
  END SUBROUTINE DOT_PRODUCT_2D_1D_B

  SUBROUTINE DOT_PRODUCT_2D_1D(a, x, b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: a
    REAL(sp), DIMENSION(:), INTENT(IN) :: x
    REAL(sp), DIMENSION(:), INTENT(INOUT) :: b
    INTEGER :: i, j
    INTRINSIC SIZE
    b = 0._sp
    DO j=1,SIZE(a, 2)
      DO i=1,SIZE(a, 1)
        b(i) = b(i) + a(i, j)*x(j)
      END DO
    END DO
  END SUBROUTINE DOT_PRODUCT_2D_1D

END MODULE MD_ALGEBRA_DIFF

!%      (MD) Module Differentiated.
!%
!%      Subroutine
!%      ----------
!%
!%      - forward_mlp
!%      - forward_and_backward_mlp
MODULE MD_NEURAL_NETWORK_DIFF
!% only : sp
  USE MD_CONSTANT
!% only: dot_product_2d_1d
  USE MD_ALGEBRA_DIFF
  IMPLICIT NONE

CONTAINS
!  Differentiation of forward_mlp in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: output_layer
!   with respect to varying inputs: bias_1 bias_2 bias_3 input_layer
!                weight_1 weight_2 weight_3
  SUBROUTINE FORWARD_MLP_D(weight_1, weight_1_d, bias_1, bias_1_d, &
&   weight_2, weight_2_d, bias_2, bias_2_d, weight_3, weight_3_d, bias_3&
&   , bias_3_d, input_layer, input_layer_d, output_layer, output_layer_d&
& )
    IMPLICIT NONE
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: weight_1
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: weight_1_d
    REAL(sp), DIMENSION(:), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(:), INTENT(IN) :: bias_1_d
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: weight_2
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: weight_2_d
    REAL(sp), DIMENSION(:), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(:), INTENT(IN) :: bias_2_d
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: weight_3
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: weight_3_d
    REAL(sp), DIMENSION(:), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(:), INTENT(IN) :: bias_3_d
    REAL(sp), DIMENSION(:), INTENT(IN) :: input_layer
    REAL(sp), DIMENSION(:), INTENT(IN) :: input_layer_d
    REAL(sp), DIMENSION(:), INTENT(OUT) :: output_layer
    REAL(sp), DIMENSION(:), INTENT(OUT) :: output_layer_d
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(bias_1)) :: inter_layer_1
    REAL(sp), DIMENSION(SIZE(bias_1)) :: inter_layer_1_d
    REAL(sp), DIMENSION(SIZE(bias_2)) :: inter_layer_2
    REAL(sp), DIMENSION(SIZE(bias_2)) :: inter_layer_2_d
    INTRINSIC EXP
    INTRINSIC TANH
    REAL(sp), DIMENSION(SIZE(bias_1)) :: temp
    REAL(sp), DIMENSION(SIZE(bias_2)) :: temp0
    CALL DOT_PRODUCT_2D_1D_D(weight_1, weight_1_d, input_layer, &
&                      input_layer_d, inter_layer_1, inter_layer_1_d)
    inter_layer_1_d = inter_layer_1_d + bias_1_d
    inter_layer_1 = inter_layer_1 + bias_1
! SiLU
    temp = EXP(-inter_layer_1) + 1._sp
    inter_layer_1_d = (inter_layer_1*EXP(-inter_layer_1)/temp+1.0)*&
&     inter_layer_1_d/temp
    inter_layer_1 = inter_layer_1/temp
    IF (SIZE(bias_3) .GT. 0) THEN
! Case with 3 layers
      CALL DOT_PRODUCT_2D_1D_D(weight_2, weight_2_d, inter_layer_1, &
&                        inter_layer_1_d, inter_layer_2, inter_layer_2_d&
&                       )
      inter_layer_2_d = inter_layer_2_d + bias_2_d
      inter_layer_2 = inter_layer_2 + bias_2
! SiLU
      temp0 = EXP(-inter_layer_2) + 1._sp
      inter_layer_2_d = (inter_layer_2*EXP(-inter_layer_2)/temp0+1.0)*&
&       inter_layer_2_d/temp0
      inter_layer_2 = inter_layer_2/temp0
      CALL DOT_PRODUCT_2D_1D_D(weight_3, weight_3_d, inter_layer_2, &
&                        inter_layer_2_d, output_layer, output_layer_d)
! TanH
      output_layer_d = (1.0-TANH(output_layer+bias_3)**2)*(&
&       output_layer_d+bias_3_d)
      output_layer = TANH(output_layer + bias_3)
    ELSE
! Case with 2 layers
      CALL DOT_PRODUCT_2D_1D_D(weight_2, weight_2_d, inter_layer_1, &
&                        inter_layer_1_d, output_layer, output_layer_d)
! TanH
      output_layer_d = (1.0-TANH(output_layer+bias_2)**2)*(&
&       output_layer_d+bias_2_d)
      output_layer = TANH(output_layer + bias_2)
    END IF
  END SUBROUTINE FORWARD_MLP_D

!  Differentiation of forward_mlp in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: output_layer bias_1 bias_2
!                bias_3 weight_1 weight_2 weight_3
!   with respect to varying inputs: bias_1 bias_2 bias_3 input_layer
!                weight_1 weight_2 weight_3
  SUBROUTINE FORWARD_MLP_B(weight_1, weight_1_b, bias_1, bias_1_b, &
&   weight_2, weight_2_b, bias_2, bias_2_b, weight_3, weight_3_b, bias_3&
&   , bias_3_b, input_layer, input_layer_b, output_layer, output_layer_b&
& )
    IMPLICIT NONE
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: weight_1
    REAL(sp), DIMENSION(:, :) :: weight_1_b
    REAL(sp), DIMENSION(:), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(:) :: bias_1_b
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: weight_2
    REAL(sp), DIMENSION(:, :) :: weight_2_b
    REAL(sp), DIMENSION(:), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(:) :: bias_2_b
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: weight_3
    REAL(sp), DIMENSION(:, :) :: weight_3_b
    REAL(sp), DIMENSION(:), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(:) :: bias_3_b
    REAL(sp), DIMENSION(:), INTENT(IN) :: input_layer
    REAL(sp), DIMENSION(:) :: input_layer_b
    REAL(sp), DIMENSION(:) :: output_layer
    REAL(sp), DIMENSION(:) :: output_layer_b
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(bias_1)) :: inter_layer_1
    REAL(sp), DIMENSION(SIZE(bias_1)) :: inter_layer_1_b
    REAL(sp), DIMENSION(SIZE(bias_2)) :: inter_layer_2
    REAL(sp), DIMENSION(SIZE(bias_2)) :: inter_layer_2_b
    INTRINSIC EXP
    INTRINSIC TANH
    REAL(sp), DIMENSION(SIZE(bias_1)) :: temp
    REAL(sp), DIMENSION(SIZE(bias_2)) :: temp0
    REAL(sp), DIMENSION(SIZE(bias_3, 1)) :: temp_b
    REAL(sp), DIMENSION(SIZE(bias_2, 1)) :: temp_b0
    CALL DOT_PRODUCT_2D_1D(weight_1, input_layer, inter_layer_1)
    inter_layer_1 = inter_layer_1 + bias_1
! SiLU
    CALL PUSHREAL4ARRAY(inter_layer_1, SIZE(bias_1))
    inter_layer_1 = inter_layer_1*(1._sp/(1._sp+EXP(-inter_layer_1)))
    IF (SIZE(bias_3) .GT. 0) THEN
! Case with 3 layers
      CALL DOT_PRODUCT_2D_1D(weight_2, inter_layer_1, inter_layer_2)
      inter_layer_2 = inter_layer_2 + bias_2
! SiLU
      CALL PUSHREAL4ARRAY(inter_layer_2, SIZE(bias_2))
      inter_layer_2 = inter_layer_2*(1._sp/(1._sp+EXP(-inter_layer_2)))
      CALL DOT_PRODUCT_2D_1D(weight_3, inter_layer_2, output_layer)
! TanH
      temp_b = (1.0-TANH(output_layer+bias_3)**2)*output_layer_b
      output_layer_b = temp_b
      bias_3_b = bias_3_b + temp_b
      CALL DOT_PRODUCT_2D_1D_B(weight_3, weight_3_b, inter_layer_2, &
&                        inter_layer_2_b, output_layer, output_layer_b)
      CALL POPREAL4ARRAY(inter_layer_2, SIZE(bias_2))
      temp0 = EXP(-inter_layer_2) + 1._sp
      inter_layer_2_b = (1.0/temp0+EXP(-inter_layer_2)*inter_layer_2/&
&       temp0**2)*inter_layer_2_b
      bias_2_b = bias_2_b + inter_layer_2_b
      CALL DOT_PRODUCT_2D_1D_B(weight_2, weight_2_b, inter_layer_1, &
&                        inter_layer_1_b, inter_layer_2, inter_layer_2_b&
&                       )
    ELSE
! Case with 2 layers
      CALL DOT_PRODUCT_2D_1D(weight_2, inter_layer_1, output_layer)
! TanH
      temp_b0 = (1.0-TANH(output_layer+bias_2)**2)*output_layer_b
      output_layer_b = temp_b0
      bias_2_b = bias_2_b + temp_b0
      CALL DOT_PRODUCT_2D_1D_B(weight_2, weight_2_b, inter_layer_1, &
&                        inter_layer_1_b, output_layer, output_layer_b)
    END IF
    CALL POPREAL4ARRAY(inter_layer_1, SIZE(bias_1))
    temp = EXP(-inter_layer_1) + 1._sp
    inter_layer_1_b = (1.0/temp+EXP(-inter_layer_1)*inter_layer_1/temp**&
&     2)*inter_layer_1_b
    bias_1_b = bias_1_b + inter_layer_1_b
    CALL DOT_PRODUCT_2D_1D_B(weight_1, weight_1_b, input_layer, &
&                      input_layer_b, inter_layer_1, inter_layer_1_b)
  END SUBROUTINE FORWARD_MLP_B

  SUBROUTINE FORWARD_MLP(weight_1, bias_1, weight_2, bias_2, weight_3, &
&   bias_3, input_layer, output_layer)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: weight_1
    REAL(sp), DIMENSION(:), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: weight_2
    REAL(sp), DIMENSION(:), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: weight_3
    REAL(sp), DIMENSION(:), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(:), INTENT(IN) :: input_layer
    REAL(sp), DIMENSION(:), INTENT(OUT) :: output_layer
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(bias_1)) :: inter_layer_1
    REAL(sp), DIMENSION(SIZE(bias_2)) :: inter_layer_2
    INTRINSIC EXP
    INTRINSIC TANH
    CALL DOT_PRODUCT_2D_1D(weight_1, input_layer, inter_layer_1)
    inter_layer_1 = inter_layer_1 + bias_1
! SiLU
    inter_layer_1 = inter_layer_1*(1._sp/(1._sp+EXP(-inter_layer_1)))
    IF (SIZE(bias_3) .GT. 0) THEN
! Case with 3 layers
      CALL DOT_PRODUCT_2D_1D(weight_2, inter_layer_1, inter_layer_2)
      inter_layer_2 = inter_layer_2 + bias_2
! SiLU
      inter_layer_2 = inter_layer_2*(1._sp/(1._sp+EXP(-inter_layer_2)))
      CALL DOT_PRODUCT_2D_1D(weight_3, inter_layer_2, output_layer)
! TanH
      output_layer = TANH(output_layer + bias_3)
    ELSE
! Case with 2 layers
      CALL DOT_PRODUCT_2D_1D(weight_2, inter_layer_1, output_layer)
! TanH
      output_layer = TANH(output_layer + bias_2)
    END IF
  END SUBROUTINE FORWARD_MLP

!  Differentiation of forward_and_backward_mlp in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: output_jacobian_1 output_jacobian_2
!                output_layer
!   with respect to varying inputs: bias_1 bias_2 bias_3 input_layer
!                weight_1 weight_2 weight_3
  SUBROUTINE FORWARD_AND_BACKWARD_MLP_D(weight_1, weight_1_d, bias_1, &
&   bias_1_d, weight_2, weight_2_d, bias_2, bias_2_d, weight_3, &
&   weight_3_d, bias_3, bias_3_d, input_layer, input_layer_d, &
&   output_layer, output_layer_d, output_jacobian_1, output_jacobian_1_d&
&   , output_jacobian_2, output_jacobian_2_d)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: weight_1
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: weight_1_d
    REAL(sp), DIMENSION(:), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(:), INTENT(IN) :: bias_1_d
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: weight_2
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: weight_2_d
    REAL(sp), DIMENSION(:), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(:), INTENT(IN) :: bias_2_d
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: weight_3
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: weight_3_d
    REAL(sp), DIMENSION(:), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(:), INTENT(IN) :: bias_3_d
    REAL(sp), DIMENSION(:), INTENT(IN) :: input_layer
    REAL(sp), DIMENSION(:), INTENT(IN) :: input_layer_d
    REAL(sp), DIMENSION(:), INTENT(OUT) :: output_layer
    REAL(sp), DIMENSION(:), INTENT(OUT) :: output_layer_d
    REAL(sp), DIMENSION(:), INTENT(OUT) :: output_jacobian_1
    REAL(sp), DIMENSION(:), INTENT(OUT) :: output_jacobian_1_d
    REAL(sp), DIMENSION(:), INTENT(OUT) :: output_jacobian_2
    REAL(sp), DIMENSION(:), INTENT(OUT) :: output_jacobian_2_d
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(bias_1)) :: inter_layer_1, inter_layer_1_tf&
&   , inter_layer_1_grad, layer_1_grad
    REAL(sp), DIMENSION(SIZE(bias_1)) :: inter_layer_1_d, &
&   inter_layer_1_tf_d, inter_layer_1_grad_d, layer_1_grad_d
    REAL(sp), DIMENSION(SIZE(bias_2)) :: inter_layer_2, inter_layer_2_tf&
&   , inter_layer_2_grad, layer_2_grad
    REAL(sp), DIMENSION(SIZE(bias_2)) :: inter_layer_2_d, &
&   inter_layer_2_tf_d, inter_layer_2_grad_d, layer_2_grad_d
    INTEGER :: i, j, k
    INTRINSIC EXP
    INTRINSIC TANH
    REAL(sp), DIMENSION(size(bias_1)) :: temp
    REAL(sp), DIMENSION(size(bias_2)) :: temp0
    output_jacobian_1 = 0._sp
    output_jacobian_2 = 0._sp
    CALL DOT_PRODUCT_2D_1D_D(weight_1, weight_1_d, input_layer, &
&                      input_layer_d, inter_layer_1, inter_layer_1_d)
    inter_layer_1_d = inter_layer_1_d + bias_1_d
    inter_layer_1 = inter_layer_1 + bias_1
! SiLU
    temp = EXP(-inter_layer_1) + 1._sp
    inter_layer_1_tf_d = (inter_layer_1*EXP(-inter_layer_1)/temp+1.0)*&
&     inter_layer_1_d/temp
    inter_layer_1_tf = inter_layer_1/temp
! Derivative of SiLU
    temp = EXP(-inter_layer_1) + 1._sp
    inter_layer_1_grad_d = inter_layer_1_tf_d + ((1._sp-inter_layer_1_tf&
&     )*EXP(-inter_layer_1)*inter_layer_1_d/temp-inter_layer_1_tf_d)/&
&     temp
    inter_layer_1_grad = inter_layer_1_tf + (1._sp-inter_layer_1_tf)/&
&     temp
    IF (SIZE(bias_3) .GT. 0) THEN
! Case with 3 layers
      CALL DOT_PRODUCT_2D_1D_D(weight_2, weight_2_d, inter_layer_1_tf, &
&                        inter_layer_1_tf_d, inter_layer_2, &
&                        inter_layer_2_d)
      inter_layer_2_d = inter_layer_2_d + bias_2_d
      inter_layer_2 = inter_layer_2 + bias_2
! SiLU
      temp0 = EXP(-inter_layer_2) + 1._sp
      inter_layer_2_tf_d = (inter_layer_2*EXP(-inter_layer_2)/temp0+1.0)&
&       *inter_layer_2_d/temp0
      inter_layer_2_tf = inter_layer_2/temp0
! Derivative of SiLU
      temp0 = EXP(-inter_layer_2) + 1._sp
      inter_layer_2_grad_d = inter_layer_2_tf_d + ((1._sp-&
&       inter_layer_2_tf)*EXP(-inter_layer_2)*inter_layer_2_d/temp0-&
&       inter_layer_2_tf_d)/temp0
      inter_layer_2_grad = inter_layer_2_tf + (1._sp-inter_layer_2_tf)/&
&       temp0
      CALL DOT_PRODUCT_2D_1D_D(weight_3, weight_3_d, inter_layer_2_tf, &
&                        inter_layer_2_tf_d, output_layer, &
&                        output_layer_d)
! TanH
      output_layer_d = (1.0-TANH(output_layer+bias_3)**2)*(&
&       output_layer_d+bias_3_d)
      output_layer = TANH(output_layer + bias_3)
      output_jacobian_1_d = 0.0_4
      output_jacobian_2_d = 0.0_4
      layer_2_grad_d = 0.0_4
! Compute Jacobian matrix of output wrt input MLP
      DO i=1,SIZE(output_layer)
        DO j=1,SIZE(inter_layer_2)
! Derivative of TanH
          layer_2_grad_d(j) = (1._sp-output_layer(i)**2)*weight_3_d(i, j&
&           ) - weight_3(i, j)*2*output_layer(i)*output_layer_d(i)
          layer_2_grad(j) = (1._sp-output_layer(i)**2)*weight_3(i, j)
          layer_2_grad_d(j) = inter_layer_2_grad(j)*layer_2_grad_d(j) + &
&           layer_2_grad(j)*inter_layer_2_grad_d(j)
          layer_2_grad(j) = layer_2_grad(j)*inter_layer_2_grad(j)
        END DO
! Gradient of second layer wrt first layer
        layer_1_grad = 0._sp
        layer_1_grad_d = 0.0_4
        DO j=1,SIZE(inter_layer_1)
          DO k=1,SIZE(inter_layer_2)
            layer_1_grad_d(j) = layer_1_grad_d(j) + weight_2(k, j)*&
&             layer_2_grad_d(k) + layer_2_grad(k)*weight_2_d(k, j)
            layer_1_grad(j) = layer_1_grad(j) + layer_2_grad(k)*weight_2&
&             (k, j)
          END DO
          layer_1_grad_d(j) = inter_layer_1_grad(j)*layer_1_grad_d(j) + &
&           layer_1_grad(j)*inter_layer_1_grad_d(j)
          layer_1_grad(j) = layer_1_grad(j)*inter_layer_1_grad(j)
        END DO
! Gradient of first layer wrt input layer
        DO k=1,SIZE(inter_layer_1)
          output_jacobian_1_d(i) = output_jacobian_1_d(i) + weight_1(k, &
&           1)*layer_1_grad_d(k) + layer_1_grad(k)*weight_1_d(k, 1)
          output_jacobian_1(i) = output_jacobian_1(i) + layer_1_grad(k)*&
&           weight_1(k, 1)
          output_jacobian_2_d(i) = output_jacobian_2_d(i) + weight_1(k, &
&           2)*layer_1_grad_d(k) + layer_1_grad(k)*weight_1_d(k, 2)
          output_jacobian_2(i) = output_jacobian_2(i) + layer_1_grad(k)*&
&           weight_1(k, 2)
        END DO
      END DO
    ELSE
! Case with 2 layers
      CALL DOT_PRODUCT_2D_1D_D(weight_2, weight_2_d, inter_layer_1_tf, &
&                        inter_layer_1_tf_d, output_layer, &
&                        output_layer_d)
      output_layer_d = (1.0-TANH(output_layer+bias_2)**2)*(&
&       output_layer_d+bias_2_d)
      output_layer = TANH(output_layer + bias_2)
      output_jacobian_1_d = 0.0_4
      output_jacobian_2_d = 0.0_4
      layer_1_grad_d = 0.0_4
! Compute Jacobian matrix of output wrt input MLP
      DO i=1,SIZE(output_layer)
        DO j=1,SIZE(inter_layer_1)
! Derivative of TanH
          layer_1_grad_d(j) = (1._sp-output_layer(i)**2)*weight_2_d(i, j&
&           ) - weight_2(i, j)*2*output_layer(i)*output_layer_d(i)
          layer_1_grad(j) = (1._sp-output_layer(i)**2)*weight_2(i, j)
          layer_1_grad_d(j) = inter_layer_1_grad(j)*layer_1_grad_d(j) + &
&           layer_1_grad(j)*inter_layer_1_grad_d(j)
          layer_1_grad(j) = layer_1_grad(j)*inter_layer_1_grad(j)
        END DO
! Gradient of first layer wrt input layer
        DO k=1,SIZE(inter_layer_1)
          output_jacobian_1_d(i) = output_jacobian_1_d(i) + weight_1(k, &
&           1)*layer_1_grad_d(k) + layer_1_grad(k)*weight_1_d(k, 1)
          output_jacobian_1(i) = output_jacobian_1(i) + layer_1_grad(k)*&
&           weight_1(k, 1)
          output_jacobian_2_d(i) = output_jacobian_2_d(i) + weight_1(k, &
&           2)*layer_1_grad_d(k) + layer_1_grad(k)*weight_1_d(k, 2)
          output_jacobian_2(i) = output_jacobian_2(i) + layer_1_grad(k)*&
&           weight_1(k, 2)
        END DO
      END DO
    END IF
  END SUBROUTINE FORWARD_AND_BACKWARD_MLP_D

!  Differentiation of forward_and_backward_mlp in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: output_jacobian_1 output_jacobian_2
!                output_layer bias_1 bias_2 bias_3 weight_1 weight_2
!                weight_3
!   with respect to varying inputs: bias_1 bias_2 bias_3 input_layer
!                weight_1 weight_2 weight_3
  SUBROUTINE FORWARD_AND_BACKWARD_MLP_B(weight_1, weight_1_b, bias_1, &
&   bias_1_b, weight_2, weight_2_b, bias_2, bias_2_b, weight_3, &
&   weight_3_b, bias_3, bias_3_b, input_layer, input_layer_b, &
&   output_layer, output_layer_b, output_jacobian_1, output_jacobian_1_b&
&   , output_jacobian_2, output_jacobian_2_b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: weight_1
    REAL(sp), DIMENSION(:, :) :: weight_1_b
    REAL(sp), DIMENSION(:), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(:) :: bias_1_b
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: weight_2
    REAL(sp), DIMENSION(:, :) :: weight_2_b
    REAL(sp), DIMENSION(:), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(:) :: bias_2_b
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: weight_3
    REAL(sp), DIMENSION(:, :) :: weight_3_b
    REAL(sp), DIMENSION(:), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(:) :: bias_3_b
    REAL(sp), DIMENSION(:), INTENT(IN) :: input_layer
    REAL(sp), DIMENSION(:) :: input_layer_b
    REAL(sp), DIMENSION(:) :: output_layer
    REAL(sp), DIMENSION(:) :: output_layer_b
    REAL(sp), DIMENSION(:) :: output_jacobian_1
    REAL(sp), DIMENSION(:) :: output_jacobian_1_b
    REAL(sp), DIMENSION(:) :: output_jacobian_2
    REAL(sp), DIMENSION(:) :: output_jacobian_2_b
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(bias_1)) :: inter_layer_1, inter_layer_1_tf&
&   , inter_layer_1_grad, layer_1_grad
    REAL(sp), DIMENSION(SIZE(bias_1)) :: inter_layer_1_b, &
&   inter_layer_1_tf_b, inter_layer_1_grad_b, layer_1_grad_b
    REAL(sp), DIMENSION(SIZE(bias_2)) :: inter_layer_2, inter_layer_2_tf&
&   , inter_layer_2_grad, layer_2_grad
    REAL(sp), DIMENSION(SIZE(bias_2)) :: inter_layer_2_b, &
&   inter_layer_2_tf_b, inter_layer_2_grad_b, layer_2_grad_b
    INTEGER :: i, j, k
    INTRINSIC EXP
    INTRINSIC TANH
    REAL(sp), DIMENSION(size(bias_1)) :: temp
    REAL(sp), DIMENSION(size(bias_2)) :: temp0
    REAL(sp), DIMENSION(SIZE(bias_3, 1)) :: temp_b
    REAL(sp), DIMENSION(SIZE(bias_2, 1)) :: temp_b0
    INTEGER :: ad_to
    INTEGER :: ad_to0
    INTEGER :: ad_to1
    INTEGER :: ad_to2
    INTEGER :: ad_to3
    INTEGER :: ad_to4
    INTEGER :: ad_to5
    INTEGER :: ad_to6
    CALL DOT_PRODUCT_2D_1D(weight_1, input_layer, inter_layer_1)
    inter_layer_1 = inter_layer_1 + bias_1
! SiLU
    inter_layer_1_tf = inter_layer_1*(1._sp/(1._sp+EXP(-inter_layer_1)))
! Derivative of SiLU
    inter_layer_1_grad = inter_layer_1_tf + (1._sp-inter_layer_1_tf)/(&
&     1._sp+EXP(-inter_layer_1))
    IF (SIZE(bias_3) .GT. 0) THEN
! Case with 3 layers
      CALL DOT_PRODUCT_2D_1D(weight_2, inter_layer_1_tf, inter_layer_2)
      inter_layer_2 = inter_layer_2 + bias_2
! SiLU
      inter_layer_2_tf = inter_layer_2*(1._sp/(1._sp+EXP(-inter_layer_2)&
&       ))
! Derivative of SiLU
      inter_layer_2_grad = inter_layer_2_tf + (1._sp-inter_layer_2_tf)/(&
&       1._sp+EXP(-inter_layer_2))
      CALL DOT_PRODUCT_2D_1D(weight_3, inter_layer_2_tf, output_layer)
! TanH
      CALL PUSHREAL4ARRAY(output_layer, SIZE(output_layer, 1))
      output_layer = TANH(output_layer + bias_3)
! Compute Jacobian matrix of output wrt input MLP
      DO i=1,SIZE(output_layer)
        DO j=1,SIZE(inter_layer_2)
! Derivative of TanH
          CALL PUSHREAL4(layer_2_grad(j))
          layer_2_grad(j) = (1._sp-output_layer(i)**2)*weight_3(i, j)
          CALL PUSHREAL4(layer_2_grad(j))
          layer_2_grad(j) = layer_2_grad(j)*inter_layer_2_grad(j)
        END DO
        CALL PUSHINTEGER4(j - 1)
! Gradient of second layer wrt first layer
        CALL PUSHREAL4ARRAY(layer_1_grad, SIZE(bias_1))
        layer_1_grad = 0._sp
        DO j=1,SIZE(inter_layer_1)
          DO k=1,SIZE(inter_layer_2)
            layer_1_grad(j) = layer_1_grad(j) + layer_2_grad(k)*weight_2&
&             (k, j)
          END DO
          CALL PUSHINTEGER4(k - 1)
          CALL PUSHREAL4(layer_1_grad(j))
          layer_1_grad(j) = layer_1_grad(j)*inter_layer_1_grad(j)
        END DO
        CALL PUSHINTEGER4(j - 1)
! Gradient of first layer wrt input layer
        DO k=1,SIZE(inter_layer_1)

        END DO
        CALL PUSHINTEGER4(k - 1)
      END DO
      ad_to3 = i - 1
      inter_layer_1_grad_b = 0.0_4
      layer_2_grad_b = 0.0_4
      inter_layer_2_grad_b = 0.0_4
      DO i=ad_to3,1,-1
        layer_1_grad_b = 0.0_4
        CALL POPINTEGER4(ad_to2)
        DO k=ad_to2,1,-1
          layer_1_grad_b(k) = layer_1_grad_b(k) + weight_1(k, 2)*&
&           output_jacobian_2_b(i) + weight_1(k, 1)*output_jacobian_1_b(&
&           i)
          weight_1_b(k, 2) = weight_1_b(k, 2) + layer_1_grad(k)*&
&           output_jacobian_2_b(i)
          weight_1_b(k, 1) = weight_1_b(k, 1) + layer_1_grad(k)*&
&           output_jacobian_1_b(i)
        END DO
        CALL POPINTEGER4(ad_to1)
        DO j=ad_to1,1,-1
          CALL POPREAL4(layer_1_grad(j))
          inter_layer_1_grad_b(j) = inter_layer_1_grad_b(j) + &
&           layer_1_grad(j)*layer_1_grad_b(j)
          layer_1_grad_b(j) = inter_layer_1_grad(j)*layer_1_grad_b(j)
          CALL POPINTEGER4(ad_to0)
          DO k=ad_to0,1,-1
            layer_2_grad_b(k) = layer_2_grad_b(k) + weight_2(k, j)*&
&             layer_1_grad_b(j)
            weight_2_b(k, j) = weight_2_b(k, j) + layer_2_grad(k)*&
&             layer_1_grad_b(j)
          END DO
        END DO
        CALL POPREAL4ARRAY(layer_1_grad, SIZE(bias_1))
        CALL POPINTEGER4(ad_to)
        DO j=ad_to,1,-1
          CALL POPREAL4(layer_2_grad(j))
          inter_layer_2_grad_b(j) = inter_layer_2_grad_b(j) + &
&           layer_2_grad(j)*layer_2_grad_b(j)
          layer_2_grad_b(j) = inter_layer_2_grad(j)*layer_2_grad_b(j)
          CALL POPREAL4(layer_2_grad(j))
          output_layer_b(i) = output_layer_b(i) - 2*output_layer(i)*&
&           weight_3(i, j)*layer_2_grad_b(j)
          weight_3_b(i, j) = weight_3_b(i, j) + (1._sp-output_layer(i)**&
&           2)*layer_2_grad_b(j)
          layer_2_grad_b(j) = 0.0_4
        END DO
      END DO
      CALL POPREAL4ARRAY(output_layer, SIZE(output_layer, 1))
      temp_b = (1.0-TANH(output_layer+bias_3)**2)*output_layer_b
      output_layer_b = temp_b
      bias_3_b = bias_3_b + temp_b
      CALL DOT_PRODUCT_2D_1D_B(weight_3, weight_3_b, inter_layer_2_tf, &
&                        inter_layer_2_tf_b, output_layer, &
&                        output_layer_b)
      inter_layer_2_b = 0.0_4
      temp0 = EXP(-inter_layer_2) + 1._sp
      inter_layer_2_tf_b = inter_layer_2_tf_b + (1.0-1.0/temp0)*&
&       inter_layer_2_grad_b
      inter_layer_2_b = EXP(-inter_layer_2)*(1._sp-inter_layer_2_tf)*&
&       inter_layer_2_grad_b/temp0**2
      temp0 = EXP(-inter_layer_2) + 1._sp
      inter_layer_2_b = inter_layer_2_b + (1.0/temp0+EXP(-inter_layer_2)&
&       *inter_layer_2/temp0**2)*inter_layer_2_tf_b
      bias_2_b = bias_2_b + inter_layer_2_b
      CALL DOT_PRODUCT_2D_1D_B(weight_2, weight_2_b, inter_layer_1_tf, &
&                        inter_layer_1_tf_b, inter_layer_2, &
&                        inter_layer_2_b)
    ELSE
! Case with 2 layers
      CALL DOT_PRODUCT_2D_1D(weight_2, inter_layer_1_tf, output_layer)
      CALL PUSHREAL4ARRAY(output_layer, SIZE(output_layer, 1))
      output_layer = TANH(output_layer + bias_2)
! Compute Jacobian matrix of output wrt input MLP
      DO i=1,SIZE(output_layer)
        DO j=1,SIZE(inter_layer_1)
! Derivative of TanH
          CALL PUSHREAL4(layer_1_grad(j))
          layer_1_grad(j) = (1._sp-output_layer(i)**2)*weight_2(i, j)
          CALL PUSHREAL4(layer_1_grad(j))
          layer_1_grad(j) = layer_1_grad(j)*inter_layer_1_grad(j)
        END DO
        CALL PUSHINTEGER4(j - 1)
! Gradient of first layer wrt input layer
        DO k=1,SIZE(inter_layer_1)

        END DO
        CALL PUSHINTEGER4(k - 1)
      END DO
      ad_to6 = i - 1
      inter_layer_1_grad_b = 0.0_4
      layer_1_grad_b = 0.0_4
      DO i=ad_to6,1,-1
        CALL POPINTEGER4(ad_to5)
        DO k=ad_to5,1,-1
          layer_1_grad_b(k) = layer_1_grad_b(k) + weight_1(k, 2)*&
&           output_jacobian_2_b(i) + weight_1(k, 1)*output_jacobian_1_b(&
&           i)
          weight_1_b(k, 2) = weight_1_b(k, 2) + layer_1_grad(k)*&
&           output_jacobian_2_b(i)
          weight_1_b(k, 1) = weight_1_b(k, 1) + layer_1_grad(k)*&
&           output_jacobian_1_b(i)
        END DO
        CALL POPINTEGER4(ad_to4)
        DO j=ad_to4,1,-1
          CALL POPREAL4(layer_1_grad(j))
          inter_layer_1_grad_b(j) = inter_layer_1_grad_b(j) + &
&           layer_1_grad(j)*layer_1_grad_b(j)
          layer_1_grad_b(j) = inter_layer_1_grad(j)*layer_1_grad_b(j)
          CALL POPREAL4(layer_1_grad(j))
          output_layer_b(i) = output_layer_b(i) - 2*output_layer(i)*&
&           weight_2(i, j)*layer_1_grad_b(j)
          weight_2_b(i, j) = weight_2_b(i, j) + (1._sp-output_layer(i)**&
&           2)*layer_1_grad_b(j)
          layer_1_grad_b(j) = 0.0_4
        END DO
      END DO
      CALL POPREAL4ARRAY(output_layer, SIZE(output_layer, 1))
      temp_b0 = (1.0-TANH(output_layer+bias_2)**2)*output_layer_b
      output_layer_b = temp_b0
      bias_2_b = bias_2_b + temp_b0
      CALL DOT_PRODUCT_2D_1D_B(weight_2, weight_2_b, inter_layer_1_tf, &
&                        inter_layer_1_tf_b, output_layer, &
&                        output_layer_b)
    END IF
    inter_layer_1_b = 0.0_4
    temp = EXP(-inter_layer_1) + 1._sp
    inter_layer_1_tf_b = inter_layer_1_tf_b + (1.0-1.0/temp)*&
&     inter_layer_1_grad_b
    inter_layer_1_b = EXP(-inter_layer_1)*(1._sp-inter_layer_1_tf)*&
&     inter_layer_1_grad_b/temp**2
    temp = EXP(-inter_layer_1) + 1._sp
    inter_layer_1_b = inter_layer_1_b + (1.0/temp+EXP(-inter_layer_1)*&
&     inter_layer_1/temp**2)*inter_layer_1_tf_b
    bias_1_b = bias_1_b + inter_layer_1_b
    CALL DOT_PRODUCT_2D_1D_B(weight_1, weight_1_b, input_layer, &
&                      input_layer_b, inter_layer_1, inter_layer_1_b)
  END SUBROUTINE FORWARD_AND_BACKWARD_MLP_B

  SUBROUTINE FORWARD_AND_BACKWARD_MLP(weight_1, bias_1, weight_2, bias_2&
&   , weight_3, bias_3, input_layer, output_layer, output_jacobian_1, &
&   output_jacobian_2)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: weight_1
    REAL(sp), DIMENSION(:), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: weight_2
    REAL(sp), DIMENSION(:), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(:, :), INTENT(IN) :: weight_3
    REAL(sp), DIMENSION(:), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(:), INTENT(IN) :: input_layer
    REAL(sp), DIMENSION(:), INTENT(OUT) :: output_layer
    REAL(sp), DIMENSION(:), INTENT(OUT) :: output_jacobian_1
    REAL(sp), DIMENSION(:), INTENT(OUT) :: output_jacobian_2
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(bias_1)) :: inter_layer_1, inter_layer_1_tf&
&   , inter_layer_1_grad, layer_1_grad
    REAL(sp), DIMENSION(SIZE(bias_2)) :: inter_layer_2, inter_layer_2_tf&
&   , inter_layer_2_grad, layer_2_grad
    INTEGER :: i, j, k
    INTRINSIC EXP
    INTRINSIC TANH
    output_jacobian_1 = 0._sp
    output_jacobian_2 = 0._sp
    CALL DOT_PRODUCT_2D_1D(weight_1, input_layer, inter_layer_1)
    inter_layer_1 = inter_layer_1 + bias_1
! SiLU
    inter_layer_1_tf = inter_layer_1*(1._sp/(1._sp+EXP(-inter_layer_1)))
! Derivative of SiLU
    inter_layer_1_grad = inter_layer_1_tf + (1._sp-inter_layer_1_tf)/(&
&     1._sp+EXP(-inter_layer_1))
    IF (SIZE(bias_3) .GT. 0) THEN
! Case with 3 layers
      CALL DOT_PRODUCT_2D_1D(weight_2, inter_layer_1_tf, inter_layer_2)
      inter_layer_2 = inter_layer_2 + bias_2
! SiLU
      inter_layer_2_tf = inter_layer_2*(1._sp/(1._sp+EXP(-inter_layer_2)&
&       ))
! Derivative of SiLU
      inter_layer_2_grad = inter_layer_2_tf + (1._sp-inter_layer_2_tf)/(&
&       1._sp+EXP(-inter_layer_2))
      CALL DOT_PRODUCT_2D_1D(weight_3, inter_layer_2_tf, output_layer)
! TanH
      output_layer = TANH(output_layer + bias_3)
! Compute Jacobian matrix of output wrt input MLP
      DO i=1,SIZE(output_layer)
        DO j=1,SIZE(inter_layer_2)
! Derivative of TanH
          layer_2_grad(j) = (1._sp-output_layer(i)**2)*weight_3(i, j)
          layer_2_grad(j) = layer_2_grad(j)*inter_layer_2_grad(j)
        END DO
! Gradient of second layer wrt first layer
        layer_1_grad = 0._sp
        DO j=1,SIZE(inter_layer_1)
          DO k=1,SIZE(inter_layer_2)
            layer_1_grad(j) = layer_1_grad(j) + layer_2_grad(k)*weight_2&
&             (k, j)
          END DO
          layer_1_grad(j) = layer_1_grad(j)*inter_layer_1_grad(j)
        END DO
! Gradient of first layer wrt input layer
        DO k=1,SIZE(inter_layer_1)
          output_jacobian_1(i) = output_jacobian_1(i) + layer_1_grad(k)*&
&           weight_1(k, 1)
          output_jacobian_2(i) = output_jacobian_2(i) + layer_1_grad(k)*&
&           weight_1(k, 2)
        END DO
      END DO
    ELSE
! Case with 2 layers
      CALL DOT_PRODUCT_2D_1D(weight_2, inter_layer_1_tf, output_layer)
      output_layer = TANH(output_layer + bias_2)
! Compute Jacobian matrix of output wrt input MLP
      DO i=1,SIZE(output_layer)
        DO j=1,SIZE(inter_layer_1)
! Derivative of TanH
          layer_1_grad(j) = (1._sp-output_layer(i)**2)*weight_2(i, j)
          layer_1_grad(j) = layer_1_grad(j)*inter_layer_1_grad(j)
        END DO
! Gradient of first layer wrt input layer
        DO k=1,SIZE(inter_layer_1)
          output_jacobian_1(i) = output_jacobian_1(i) + layer_1_grad(k)*&
&           weight_1(k, 1)
          output_jacobian_2(i) = output_jacobian_2(i) + layer_1_grad(k)*&
&           weight_1(k, 2)
        END DO
      END DO
    END IF
  END SUBROUTINE FORWARD_AND_BACKWARD_MLP

END MODULE MD_NEURAL_NETWORK_DIFF

!%      (MD) Module Differentiated.
!%
!%      Subroutine
!%      ----------
!%
!%      - gr_interception
!%      - gr_production
!%      - gr_exchange
!%      - gr_threshold_exchange
!%      - gr_transfer
!%      - gr_production_transfer_ode
!%      - gr_production_transfer_ode_mlp
!%      - gr4_time_step
!%      - gr4_mlp_time_step
!%      - gr4_ri_time_step
!%      - gr4_ode_time_step
!%      - gr4_ode_mlp_time_step
!%      - gr5_time_step
!%      - gr5_mlp_time_step
!%      - gr5_ri_time_step
!%      - gr6_time_step
!%      - gr6_mlp_time_step
!%      - grc_time_step
!%      - grc_mlp_time_step
!%      - grd_time_step
!%      - grd_mlp_time_step
!%      - loieau_time_step
!%      - loieau_mlp_time_step
MODULE MD_GR_OPERATOR_DIFF
!% only : sp
  USE MD_CONSTANT
!% only: SetupDT
  USE MWD_SETUP
!% only: MeshDT
  USE MWD_MESH
!% only: Input_DataDT
  USE MWD_INPUT_DATA
!% only: OptionsDT
  USE MWD_OPTIONS_DIFF
!% only: ReturnsDT
  USE MWD_RETURNS_DIFF
!% get_ac_atmos_data_time_step
  USE MWD_ATMOS_MANIPULATION_DIFF
!% only: solve_linear_system_2vars
  USE MD_ALGEBRA_DIFF
!% only: forward_mlp, forward_and_backward_mlp
  USE MD_NEURAL_NETWORK_DIFF
  IMPLICIT NONE

CONTAINS
!  Differentiation of gr_interception in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: hi en pn
!   with respect to varying inputs: prcp hi ci
  SUBROUTINE GR_INTERCEPTION_D(prcp, prcp_d, pet, ci, ci_d, hi, hi_d, pn&
&   , pn_d, en, en_d)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: prcp, pet, ci
    REAL(sp), INTENT(IN) :: prcp_d, ci_d
    REAL(sp), INTENT(INOUT) :: hi
    REAL(sp), INTENT(INOUT) :: hi_d
    REAL(sp), INTENT(OUT) :: pn, en
    REAL(sp), INTENT(OUT) :: pn_d, en_d
    REAL(sp) :: ei
    REAL(sp) :: ei_d
    INTRINSIC MIN
    INTRINSIC MAX
    REAL(sp) :: temp
    IF (pet .GT. prcp + hi*ci) THEN
      ei_d = prcp_d + ci*hi_d + hi*ci_d
      ei = prcp + hi*ci
    ELSE
      ei = pet
      ei_d = 0.0_4
    END IF
    IF (0._sp .LT. prcp - ci*(1._sp-hi) - ei) THEN
      pn_d = prcp_d - (1._sp-hi)*ci_d + ci*hi_d - ei_d
      pn = prcp - ci*(1._sp-hi) - ei
    ELSE
      pn = 0._sp
      pn_d = 0.0_4
    END IF
    en_d = -ei_d
    en = pet - ei
    temp = (prcp-ei-pn)/ci
    hi_d = hi_d + (prcp_d-ei_d-pn_d-temp*ci_d)/ci
    hi = hi + temp
  END SUBROUTINE GR_INTERCEPTION_D

!  Differentiation of gr_interception in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: prcp hi en ci pn
!   with respect to varying inputs: prcp hi ci
  SUBROUTINE GR_INTERCEPTION_B(prcp, prcp_b, pet, ci, ci_b, hi, hi_b, pn&
&   , pn_b, en, en_b)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: prcp, pet, ci
    REAL(sp) :: prcp_b, ci_b
    REAL(sp), INTENT(INOUT) :: hi
    REAL(sp), INTENT(INOUT) :: hi_b
    REAL(sp) :: pn, en
    REAL(sp) :: pn_b, en_b
    REAL(sp) :: ei
    REAL(sp) :: ei_b
    INTRINSIC MIN
    INTRINSIC MAX
    REAL(sp) :: temp_b
    INTEGER :: branch
    IF (pet .GT. prcp + hi*ci) THEN
      ei = prcp + hi*ci
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHCONTROL1B(1)
      ei = pet
    END IF
    IF (0._sp .LT. prcp - ci*(1._sp-hi) - ei) THEN
      CALL PUSHREAL4(pn)
      pn = prcp - ci*(1._sp-hi) - ei
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHREAL4(pn)
      pn = 0._sp
      CALL PUSHCONTROL1B(1)
    END IF
    temp_b = hi_b/ci
    prcp_b = prcp_b + temp_b
    ei_b = -temp_b - en_b
    pn_b = pn_b - temp_b
    ci_b = ci_b - (prcp-ei-pn)*temp_b/ci
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      CALL POPREAL4(pn)
      prcp_b = prcp_b + pn_b
      ci_b = ci_b - (1._sp-hi)*pn_b
      hi_b = hi_b + ci*pn_b
      ei_b = ei_b - pn_b
    ELSE
      CALL POPREAL4(pn)
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      prcp_b = prcp_b + ei_b
      hi_b = hi_b + ci*ei_b
      ci_b = ci_b + hi*ei_b
    END IF
  END SUBROUTINE GR_INTERCEPTION_B

  SUBROUTINE GR_INTERCEPTION(prcp, pet, ci, hi, pn, en)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: prcp, pet, ci
    REAL(sp), INTENT(INOUT) :: hi
    REAL(sp), INTENT(OUT) :: pn, en
    REAL(sp) :: ei
    INTRINSIC MIN
    INTRINSIC MAX
    IF (pet .GT. prcp + hi*ci) THEN
      ei = prcp + hi*ci
    ELSE
      ei = pet
    END IF
    IF (0._sp .LT. prcp - ci*(1._sp-hi) - ei) THEN
      pn = prcp - ci*(1._sp-hi) - ei
    ELSE
      pn = 0._sp
    END IF
    en = pet - ei
    hi = hi + (prcp-ei-pn)/ci
  END SUBROUTINE GR_INTERCEPTION

!  Differentiation of gr_production in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: hp pn perc pr
!   with respect to varying inputs: fq_ps hp en fq_es cp pn
  SUBROUTINE GR_PRODUCTION_D(fq_ps, fq_ps_d, fq_es, fq_es_d, pn, pn_d, &
&   en, en_d, imperviousness, cp, cp_d, beta, hp, hp_d, pr, pr_d, perc, &
&   perc_d, ps, es)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: fq_ps, fq_es, en, imperviousness, cp, beta
    REAL(sp), INTENT(IN) :: fq_ps_d, fq_es_d, en_d, cp_d
    REAL(sp), INTENT(INOUT) :: pn, hp
    REAL(sp), INTENT(INOUT) :: pn_d, hp_d
    REAL(sp), INTENT(OUT) :: pr, perc, ps, es
    REAL(sp), INTENT(OUT) :: pr_d, perc_d
    REAL(sp) :: inv_cp, hp_imd
    REAL(sp) :: inv_cp_d, hp_imd_d
    INTRINSIC TANH
    INTRINSIC MIN
    REAL(sp) :: pwx1
    REAL(sp) :: pwx1_d
    REAL(sp) :: pwr1
    REAL(sp) :: pwr1_d
    REAL(sp) :: temp
    REAL(sp) :: temp0
    REAL(sp) :: temp1
    REAL(sp) :: temp2
    REAL(sp) :: ps_d
    REAL(sp) :: es_d
    inv_cp_d = -(cp_d/cp**2)
    inv_cp = 1._sp/cp
    pr = 0._sp
! impervious area percentage at cell scale applied to neutralized rainfall - no infiltration for imperviousness*pn
    pn_d = (1._sp-imperviousness)*pn_d
    pn = (1._sp-imperviousness)*pn
    temp = TANH(pn*inv_cp)
    temp0 = TANH(pn*inv_cp)
    temp1 = cp*(-(hp*hp)+1._sp)
    temp2 = temp1*temp0/(hp*temp+1._sp)
    ps_d = (temp0*((1._sp-hp**2)*cp_d-cp*2*hp*hp_d)+temp1*(1.0-TANH(pn*&
&     inv_cp)**2)*(inv_cp*pn_d+pn*inv_cp_d)-temp2*(temp*hp_d+hp*(1.0-&
&     TANH(pn*inv_cp)**2)*(inv_cp*pn_d+pn*inv_cp_d)))/(hp*temp+1._sp)
    ps = temp2
    IF (pn .GT. (1._sp+fq_ps)*ps) THEN
      ps_d = ps*fq_ps_d + (fq_ps+1._sp)*ps_d
      ps = (1._sp+fq_ps)*ps
    ELSE
      ps_d = pn_d
      ps = pn
    END IF
    temp2 = TANH(en*inv_cp)
    temp1 = TANH(en*inv_cp)
    temp0 = hp*cp*(-hp+2._sp)
    temp = temp0*temp1/((-hp+1._sp)*temp2+1._sp)
    es_d = (temp1*((2._sp-hp)*(cp*hp_d+hp*cp_d)-hp*cp*hp_d)+temp0*(1.0-&
&     TANH(en*inv_cp)**2)*(inv_cp*en_d+en*inv_cp_d)-temp*((1._sp-hp)*(&
&     1.0-TANH(en*inv_cp)**2)*(inv_cp*en_d+en*inv_cp_d)-temp2*hp_d))/((&
&     1._sp-hp)*temp2+1._sp)
    es = temp
    IF (en .GT. (1._sp+fq_es)*es) THEN
      es_d = es*fq_es_d + (fq_es+1._sp)*es_d
      es = (1._sp+fq_es)*es
    ELSE
      es_d = en_d
      es = en
    END IF
! no evaporation over impervious part of a cell
    es_d = (1._sp-imperviousness)*es_d
    es = (1._sp-imperviousness)*es
    hp_imd_d = hp_d + inv_cp*(ps_d-es_d) + (ps-es)*inv_cp_d
    hp_imd = hp + (ps-es)*inv_cp
    IF (pn .GT. 0) THEN
      pr_d = pn_d - ps_d
      pr = pn - ps
    ELSE
      pr_d = 0.0_4
    END IF
    pwx1_d = 4*hp_imd**3*hp_imd_d/beta**4
    pwx1 = 1._sp + (hp_imd/beta)**4
    pwr1_d = -(0.25_sp*pwx1**(-1.25)*pwx1_d)
    pwr1 = pwx1**(-0.25_sp)
    perc_d = (1._sp-pwr1)*(cp*hp_imd_d+hp_imd*cp_d) - hp_imd*cp*pwr1_d
    perc = hp_imd*cp*(1._sp-pwr1)
    hp_d = hp_imd_d - inv_cp*perc_d - perc*inv_cp_d
    hp = hp_imd - perc*inv_cp
  END SUBROUTINE GR_PRODUCTION_D

!  Differentiation of gr_production in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: fq_ps hp en fq_es cp pn perc
!                pr
!   with respect to varying inputs: fq_ps hp en fq_es cp pn
  SUBROUTINE GR_PRODUCTION_B(fq_ps, fq_ps_b, fq_es, fq_es_b, pn, pn_b, &
&   en, en_b, imperviousness, cp, cp_b, beta, hp, hp_b, pr, pr_b, perc, &
&   perc_b, ps, es)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: fq_ps, fq_es, en, imperviousness, cp, beta
    REAL(sp) :: fq_ps_b, fq_es_b, en_b, cp_b
    REAL(sp), INTENT(INOUT) :: pn, hp
    REAL(sp), INTENT(INOUT) :: pn_b, hp_b
    REAL(sp) :: pr, perc, ps, es
    REAL(sp) :: pr_b, perc_b
    REAL(sp) :: inv_cp, hp_imd
    REAL(sp) :: inv_cp_b, hp_imd_b
    INTRINSIC TANH
    INTRINSIC MIN
    REAL(sp) :: pwx1
    REAL(sp) :: pwx1_b
    REAL(sp) :: pwr1
    REAL(sp) :: pwr1_b
    REAL(sp) :: temp
    REAL(sp) :: temp0
    REAL(sp) :: temp_b
    REAL(sp) :: temp1
    REAL(sp) :: temp2
    REAL(sp) :: temp3
    REAL(sp) :: temp_b0
    REAL(sp) :: temp_b1
    REAL(sp) :: temp4
    REAL(sp) :: temp_b2
    REAL(sp) :: temp_b3
    REAL(sp) :: temp_b4
    REAL(sp) :: temp_b5
    INTEGER :: branch
    REAL(sp) :: ps_b
    REAL(sp) :: es_b
    inv_cp = 1._sp/cp
! impervious area percentage at cell scale applied to neutralized rainfall - no infiltration for imperviousness*pn
    pn = (1._sp-imperviousness)*pn
    ps = cp*(1._sp-hp*hp)*TANH(pn*inv_cp)/(1._sp+hp*TANH(pn*inv_cp))
    IF (pn .GT. (1._sp+fq_ps)*ps) THEN
      CALL PUSHREAL4(ps)
      ps = (1._sp+fq_ps)*ps
      CALL PUSHCONTROL1B(0)
    ELSE
      ps = pn
      CALL PUSHCONTROL1B(1)
    END IF
    es = hp*cp*(2._sp-hp)*TANH(en*inv_cp)/(1._sp+(1._sp-hp)*TANH(en*&
&     inv_cp))
    IF (en .GT. (1._sp+fq_es)*es) THEN
      CALL PUSHREAL4(es)
      es = (1._sp+fq_es)*es
      CALL PUSHCONTROL1B(0)
    ELSE
      es = en
      CALL PUSHCONTROL1B(1)
    END IF
! no evaporation over impervious part of a cell
    es = (1._sp-imperviousness)*es
    hp_imd = hp + (ps-es)*inv_cp
    IF (pn .GT. 0) THEN
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHCONTROL1B(1)
    END IF
    pwx1 = 1._sp + (hp_imd/beta)**4
    pwr1 = pwx1**(-0.25_sp)
    CALL PUSHREAL4(perc)
    perc = hp_imd*cp*(1._sp-pwr1)
    pwx1 = 1._sp + (hp_imd/beta)**4
    pwr1 = pwx1**(-0.25_sp)
    inv_cp = 1._sp/cp
    perc_b = perc_b - inv_cp*hp_b
    inv_cp_b = -(perc*hp_b)
    CALL POPREAL4(perc)
    cp_b = cp_b + hp_imd*(1._sp-pwr1)*perc_b
    pwr1_b = -(hp_imd*cp*perc_b)
    pwx1_b = -(0.25_sp*pwx1**(-1.25)*pwr1_b)
    hp_imd_b = hp_b + cp*(1._sp-pwr1)*perc_b + 4*hp_imd**3*pwx1_b/beta**&
&     4
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      pn_b = pn_b + pr_b
      ps_b = -pr_b
    ELSE
      ps_b = 0.0_4
    END IF
    hp_b = hp_imd_b
    ps_b = ps_b + inv_cp*hp_imd_b
    es_b = -(inv_cp*hp_imd_b)
    inv_cp_b = inv_cp_b + (ps-es)*hp_imd_b
    es_b = (1._sp-imperviousness)*es_b
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      CALL POPREAL4(es)
      fq_es_b = fq_es_b + es*es_b
      es_b = (fq_es+1._sp)*es_b
    ELSE
      en_b = en_b + es_b
      es_b = 0.0_4
    END IF
    temp4 = TANH(en*inv_cp)
    temp3 = (-hp+1._sp)*temp4 + 1._sp
    temp1 = TANH(en*inv_cp)
    temp0 = hp*cp*(-hp+2._sp)
    temp_b3 = es_b/temp3
    temp_b = (2._sp-hp)*temp1*temp_b3
    temp_b4 = (1.0-TANH(en*inv_cp)**2)*temp0*temp_b3
    temp_b0 = -(temp0*temp1*temp_b3/temp3)
    hp_b = hp_b + cp*temp_b - hp*cp*temp1*temp_b3 - temp4*temp_b0
    temp_b5 = (1.0-TANH(en*inv_cp)**2)*(1._sp-hp)*temp_b0
    en_b = en_b + inv_cp*temp_b5 + inv_cp*temp_b4
    inv_cp_b = inv_cp_b + en*temp_b5 + en*temp_b4
    cp_b = cp_b + hp*temp_b
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      CALL POPREAL4(ps)
      fq_ps_b = fq_ps_b + ps*ps_b
      ps_b = (fq_ps+1._sp)*ps_b
    ELSE
      pn_b = pn_b + ps_b
      ps_b = 0.0_4
    END IF
    temp = TANH(pn*inv_cp)
    temp0 = hp*temp + 1._sp
    temp1 = TANH(pn*inv_cp)
    temp2 = cp*(-(hp*hp)+1._sp)
    temp_b = ps_b/temp0
    temp_b0 = (1.0-TANH(pn*inv_cp)**2)*temp2*temp_b
    temp_b1 = -(temp2*temp1*temp_b/temp0)
    hp_b = hp_b + temp*temp_b1 - 2*hp*cp*temp1*temp_b
    temp_b2 = (1.0-TANH(pn*inv_cp)**2)*hp*temp_b1
    pn_b = pn_b + inv_cp*temp_b2 + inv_cp*temp_b0
    inv_cp_b = inv_cp_b + pn*temp_b2 + pn*temp_b0
    cp_b = cp_b + (1._sp-hp**2)*temp1*temp_b - inv_cp_b/cp**2
    pn_b = (1._sp-imperviousness)*pn_b
  END SUBROUTINE GR_PRODUCTION_B

  SUBROUTINE GR_PRODUCTION(fq_ps, fq_es, pn, en, imperviousness, cp, &
&   beta, hp, pr, perc, ps, es)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: fq_ps, fq_es, en, imperviousness, cp, beta
    REAL(sp), INTENT(INOUT) :: pn, hp
    REAL(sp), INTENT(OUT) :: pr, perc, ps, es
    REAL(sp) :: inv_cp, hp_imd
    INTRINSIC TANH
    INTRINSIC MIN
    REAL(sp) :: pwx1
    REAL(sp) :: pwr1
    inv_cp = 1._sp/cp
    pr = 0._sp
! impervious area percentage at cell scale applied to neutralized rainfall - no infiltration for imperviousness*pn
    pn = (1._sp-imperviousness)*pn
    ps = cp*(1._sp-hp*hp)*TANH(pn*inv_cp)/(1._sp+hp*TANH(pn*inv_cp))
    IF (pn .GT. (1._sp+fq_ps)*ps) THEN
      ps = (1._sp+fq_ps)*ps
    ELSE
      ps = pn
    END IF
    es = hp*cp*(2._sp-hp)*TANH(en*inv_cp)/(1._sp+(1._sp-hp)*TANH(en*&
&     inv_cp))
    IF (en .GT. (1._sp+fq_es)*es) THEN
      es = (1._sp+fq_es)*es
    ELSE
      es = en
    END IF
! no evaporation over impervious part of a cell
    es = (1._sp-imperviousness)*es
    hp_imd = hp + (ps-es)*inv_cp
    IF (pn .GT. 0) pr = pn - ps
    pwx1 = 1._sp + (hp_imd/beta)**4
    pwr1 = pwx1**(-0.25_sp)
    perc = hp_imd*cp*(1._sp-pwr1)
    hp = hp_imd - perc*inv_cp
  END SUBROUTINE GR_PRODUCTION

!  Differentiation of gr_ri_production in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: hp pn perc pr
!   with respect to varying inputs: alpha1 hp en cp pn
  SUBROUTINE GR_RI_PRODUCTION_D(pn, pn_d, en, en_d, imperviousness, cp, &
&   cp_d, beta, alpha1, alpha1_d, hp, hp_d, pr, pr_d, perc, perc_d, ps, &
&   es, dt)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: en, imperviousness, cp, beta, alpha1
    REAL(sp), INTENT(IN) :: en_d, cp_d, alpha1_d
    REAL(sp), INTENT(IN) :: dt
    REAL(sp), INTENT(INOUT) :: pn, hp
    REAL(sp), INTENT(INOUT) :: pn_d, hp_d
    REAL(sp), INTENT(OUT) :: pr, perc, ps, es
    REAL(sp), INTENT(OUT) :: pr_d, perc_d
    REAL(sp) :: inv_cp, hp_imd
    REAL(sp) :: inv_cp_d, hp_imd_d
    REAL(sp) :: lambda, gam, inv_lambda
    REAL(sp) :: lambda_d, gam_d, inv_lambda_d
    INTRINSIC EXP
    INTRINSIC SQRT
    INTRINSIC TANH
    REAL(sp) :: arg1
    REAL(sp) :: arg1_d
    REAL(sp) :: arg2
    REAL(sp) :: arg2_d
    REAL(sp) :: pwx1
    REAL(sp) :: pwx1_d
    REAL(sp) :: pwr1
    REAL(sp) :: pwr1_d
    REAL(sp) :: temp
    REAL(sp) :: temp0
    REAL(sp) :: temp1
    REAL(sp) :: temp2
    REAL(sp) :: temp3
    REAL(sp) :: temp4
    REAL(sp) :: ps_d
    REAL(sp) :: es_d
    inv_cp_d = -(cp_d/cp**2)
    inv_cp = 1._sp/cp
    pr = 0._sp
    gam_d = EXP(-(pn*alpha1))*(alpha1*pn_d+pn*alpha1_d)
    gam = 1._sp - EXP(-(pn*alpha1))
    temp = SQRT(-gam + 1._sp)
    IF (1._sp - gam .EQ. 0.0) THEN
      lambda_d = 0.0_4
    ELSE
      lambda_d = -(gam_d/(2.0*temp))
    END IF
    lambda = temp
    inv_lambda_d = -(lambda_d/lambda**2)
    inv_lambda = 1._sp/lambda
! impervious area percentage at cell scale applied to neutralized rainfall - no infiltration for imperviousness*pn
    pn_d = (1._sp-imperviousness)*pn_d
    pn = (1._sp-imperviousness)*pn
    arg1_d = inv_cp*(pn*lambda_d+lambda*pn_d) + lambda*pn*inv_cp_d
    arg1 = lambda*pn*inv_cp
    arg2_d = inv_cp*(pn*lambda_d+lambda*pn_d) + lambda*pn*inv_cp_d
    arg2 = lambda*pn*inv_cp
    temp = TANH(arg2)
    temp0 = lambda*hp*temp + 1._sp
    temp1 = -(lambda*hp*(lambda*hp)) + 1._sp
    temp2 = cp*inv_lambda*temp1
    temp3 = TANH(arg1)
    temp4 = temp3*temp2/temp0
    ps_d = (temp2*(1.0-TANH(arg1)**2)*arg1_d+temp3*(temp1*(inv_lambda*&
&     cp_d+cp*inv_lambda_d)-cp*inv_lambda*2*lambda*hp*(hp*lambda_d+&
&     lambda*hp_d))-temp4*(temp*(hp*lambda_d+lambda*hp_d)+lambda*hp*(1.0&
&     -TANH(arg2)**2)*arg2_d))/temp0 - dt*gam_d
    ps = temp4 - dt*gam
    temp4 = TANH(en*inv_cp)
    temp3 = TANH(en*inv_cp)
    temp2 = hp*cp*(-hp+2._sp)
    temp1 = temp2*temp3/((-hp+1._sp)*temp4+1._sp)
    es_d = (temp3*((2._sp-hp)*(cp*hp_d+hp*cp_d)-hp*cp*hp_d)+temp2*(1.0-&
&     TANH(en*inv_cp)**2)*(inv_cp*en_d+en*inv_cp_d)-temp1*((1._sp-hp)*(&
&     1.0-TANH(en*inv_cp)**2)*(inv_cp*en_d+en*inv_cp_d)-temp4*hp_d))/((&
&     1._sp-hp)*temp4+1._sp)
    es = temp1
! no evaporation over impervious part of a cell
    es_d = (1._sp-imperviousness)*es_d
    es = (1._sp-imperviousness)*es
    hp_imd_d = hp_d + inv_cp*(ps_d-es_d) + (ps-es)*inv_cp_d
    hp_imd = hp + (ps-es)*inv_cp
    IF (pn .GT. 0) THEN
      pr_d = pn_d - cp*(hp_imd_d-hp_d) - (hp_imd-hp)*cp_d
      pr = pn - (hp_imd-hp)*cp
    ELSE
      pr_d = 0.0_4
    END IF
    pwx1_d = 4*hp_imd**3*hp_imd_d/beta**4
    pwx1 = 1._sp + (hp_imd/beta)**4
    pwr1_d = -(0.25_sp*pwx1**(-1.25)*pwx1_d)
    pwr1 = pwx1**(-0.25_sp)
    perc_d = (1._sp-pwr1)*(cp*hp_imd_d+hp_imd*cp_d) - hp_imd*cp*pwr1_d
    perc = hp_imd*cp*(1._sp-pwr1)
    hp_d = hp_imd_d - inv_cp*perc_d - perc*inv_cp_d
    hp = hp_imd - perc*inv_cp
  END SUBROUTINE GR_RI_PRODUCTION_D

!  Differentiation of gr_ri_production in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: alpha1 hp cp pn perc pr
!   with respect to varying inputs: alpha1 hp en cp pn
  SUBROUTINE GR_RI_PRODUCTION_B(pn, pn_b, en, en_b, imperviousness, cp, &
&   cp_b, beta, alpha1, alpha1_b, hp, hp_b, pr, pr_b, perc, perc_b, ps, &
&   es, dt)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: en, imperviousness, cp, beta, alpha1
    REAL(sp) :: en_b, cp_b, alpha1_b
    REAL(sp), INTENT(IN) :: dt
    REAL(sp), INTENT(INOUT) :: pn, hp
    REAL(sp), INTENT(INOUT) :: pn_b, hp_b
    REAL(sp) :: pr, perc, ps, es
    REAL(sp) :: pr_b, perc_b
    REAL(sp) :: inv_cp, hp_imd
    REAL(sp) :: inv_cp_b, hp_imd_b
    REAL(sp) :: lambda, gam, inv_lambda
    REAL(sp) :: lambda_b, gam_b, inv_lambda_b
    INTRINSIC EXP
    INTRINSIC SQRT
    INTRINSIC TANH
    REAL(sp) :: arg1
    REAL(sp) :: arg1_b
    REAL(sp) :: arg2
    REAL(sp) :: arg2_b
    REAL(sp) :: pwx1
    REAL(sp) :: pwx1_b
    REAL(sp) :: pwr1
    REAL(sp) :: pwr1_b
    REAL(sp) :: temp
    REAL(sp) :: temp_b
    REAL(sp) :: temp0
    REAL(sp) :: temp_b0
    REAL(sp) :: temp1
    REAL(sp) :: temp2
    REAL(sp) :: temp3
    REAL(sp) :: temp_b1
    REAL(sp) :: temp4
    REAL(sp) :: temp_b2
    REAL(sp) :: temp_b3
    REAL(sp) :: temp_b4
    REAL(sp) :: temp_b5
    INTEGER :: branch
    REAL(sp) :: ps_b
    REAL(sp) :: es_b
    inv_cp = 1._sp/cp
    gam = 1._sp - EXP(-(pn*alpha1))
    lambda = SQRT(1._sp - gam)
    inv_lambda = 1._sp/lambda
! impervious area percentage at cell scale applied to neutralized rainfall - no infiltration for imperviousness*pn
    CALL PUSHREAL4(pn)
    pn = (1._sp-imperviousness)*pn
    arg1 = lambda*pn*inv_cp
    arg2 = lambda*pn*inv_cp
    ps = cp*inv_lambda*TANH(arg1)*(1._sp-(lambda*hp)**2)/(1._sp+lambda*&
&     hp*TANH(arg2)) - gam*dt
    es = hp*cp*(2._sp-hp)*TANH(en*inv_cp)/(1._sp+(1._sp-hp)*TANH(en*&
&     inv_cp))
! no evaporation over impervious part of a cell
    es = (1._sp-imperviousness)*es
    hp_imd = hp + (ps-es)*inv_cp
    IF (pn .GT. 0) THEN
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHCONTROL1B(1)
    END IF
    pwx1 = 1._sp + (hp_imd/beta)**4
    pwr1 = pwx1**(-0.25_sp)
    CALL PUSHREAL4(perc)
    perc = hp_imd*cp*(1._sp-pwr1)
    pwx1 = 1._sp + (hp_imd/beta)**4
    pwr1 = pwx1**(-0.25_sp)
    inv_cp = 1._sp/cp
    perc_b = perc_b - inv_cp*hp_b
    inv_cp_b = -(perc*hp_b)
    CALL POPREAL4(perc)
    cp_b = cp_b + hp_imd*(1._sp-pwr1)*perc_b
    pwr1_b = -(hp_imd*cp*perc_b)
    pwx1_b = -(0.25_sp*pwx1**(-1.25)*pwr1_b)
    hp_imd_b = hp_b + cp*(1._sp-pwr1)*perc_b + 4*hp_imd**3*pwx1_b/beta**&
&     4
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      pn_b = pn_b + pr_b
      hp_imd_b = hp_imd_b - cp*pr_b
      hp_b = cp*pr_b
      cp_b = cp_b - (hp_imd-hp)*pr_b
    ELSE
      hp_b = 0.0_4
    END IF
    es_b = -(inv_cp*hp_imd_b)
    es_b = (1._sp-imperviousness)*es_b
    temp4 = TANH(en*inv_cp)
    temp3 = (-hp+1._sp)*temp4 + 1._sp
    temp1 = TANH(en*inv_cp)
    temp0 = hp*cp*(-hp+2._sp)
    temp_b1 = es_b/temp3
    temp_b0 = (2._sp-hp)*temp1*temp_b1
    temp_b4 = -(temp0*temp1*temp_b1/temp3)
    hp_b = hp_b + hp_imd_b + cp*temp_b0 - hp*cp*temp1*temp_b1 - temp4*&
&     temp_b4
    ps_b = inv_cp*hp_imd_b
    temp_b = (1.0-TANH(en*inv_cp)**2)*temp0*temp_b1
    temp_b5 = (1.0-TANH(en*inv_cp)**2)*(1._sp-hp)*temp_b4
    en_b = inv_cp*temp_b5 + inv_cp*temp_b
    cp_b = cp_b + hp*temp_b0
    arg1 = lambda*pn*inv_cp
    arg2 = lambda*pn*inv_cp
    inv_lambda = 1._sp/lambda
    temp = TANH(arg2)
    temp0 = lambda*hp*temp + 1._sp
    temp1 = -(lambda*hp*(lambda*hp)) + 1._sp
    temp2 = cp*inv_lambda*temp1
    temp3 = TANH(arg1)
    temp_b0 = ps_b/temp0
    arg1_b = (1.0-TANH(arg1)**2)*temp2*temp_b0
    temp_b1 = temp3*temp_b0
    temp_b3 = -(temp3*temp2*temp_b0/temp0)
    arg2_b = (1.0-TANH(arg2)**2)*lambda*hp*temp_b3
    inv_cp_b = inv_cp_b + (ps-es)*hp_imd_b + en*temp_b5 + en*temp_b + &
&     lambda*pn*arg2_b + lambda*pn*arg1_b
    cp_b = cp_b + inv_lambda*temp1*temp_b1 - inv_cp_b/cp**2
    inv_lambda_b = cp*temp1*temp_b1
    temp_b2 = -(2*lambda*hp*cp*inv_lambda*temp_b1)
    lambda_b = hp*temp*temp_b3 + hp*temp_b2 + pn*inv_cp*arg2_b + pn*&
&     inv_cp*arg1_b - inv_lambda_b/lambda**2
    IF (1._sp - gam .EQ. 0.0) THEN
      gam_b = -(dt*ps_b)
    ELSE
      gam_b = -(dt*ps_b) - lambda_b/(2.0*SQRT(1._sp-gam))
    END IF
    hp_b = hp_b + lambda*temp*temp_b3 + lambda*temp_b2
    pn_b = pn_b + lambda*inv_cp*arg2_b + lambda*inv_cp*arg1_b
    CALL POPREAL4(pn)
    temp_b = -(EXP(-(pn*alpha1))*gam_b)
    pn_b = (1._sp-imperviousness)*pn_b - alpha1*temp_b
    alpha1_b = alpha1_b - pn*temp_b
  END SUBROUTINE GR_RI_PRODUCTION_B

  SUBROUTINE GR_RI_PRODUCTION(pn, en, imperviousness, cp, beta, alpha1, &
&   hp, pr, perc, ps, es, dt)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: en, imperviousness, cp, beta, alpha1
    REAL(sp), INTENT(IN) :: dt
    REAL(sp), INTENT(INOUT) :: pn, hp
    REAL(sp), INTENT(OUT) :: pr, perc, ps, es
    REAL(sp) :: inv_cp, hp_imd
    REAL(sp) :: lambda, gam, inv_lambda
    INTRINSIC EXP
    INTRINSIC SQRT
    INTRINSIC TANH
    REAL(sp) :: arg1
    REAL(sp) :: arg2
    REAL(sp) :: pwx1
    REAL(sp) :: pwr1
    inv_cp = 1._sp/cp
    pr = 0._sp
    gam = 1._sp - EXP(-(pn*alpha1))
    lambda = SQRT(1._sp - gam)
    inv_lambda = 1._sp/lambda
! impervious area percentage at cell scale applied to neutralized rainfall - no infiltration for imperviousness*pn
    pn = (1._sp-imperviousness)*pn
    arg1 = lambda*pn*inv_cp
    arg2 = lambda*pn*inv_cp
    ps = cp*inv_lambda*TANH(arg1)*(1._sp-(lambda*hp)**2)/(1._sp+lambda*&
&     hp*TANH(arg2)) - gam*dt
    es = hp*cp*(2._sp-hp)*TANH(en*inv_cp)/(1._sp+(1._sp-hp)*TANH(en*&
&     inv_cp))
! no evaporation over impervious part of a cell
    es = (1._sp-imperviousness)*es
    hp_imd = hp + (ps-es)*inv_cp
    IF (pn .GT. 0) pr = pn - (hp_imd-hp)*cp
    pwx1 = 1._sp + (hp_imd/beta)**4
    pwr1 = pwx1**(-0.25_sp)
    perc = hp_imd*cp*(1._sp-pwr1)
    hp = hp_imd - perc*inv_cp
  END SUBROUTINE GR_RI_PRODUCTION

!  Differentiation of gr_exchange in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: l
!   with respect to varying inputs: kexc fq_l ht
  SUBROUTINE GR_EXCHANGE_D(fq_l, fq_l_d, kexc, kexc_d, ht, ht_d, l, l_d)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: fq_l, kexc
    REAL(sp), INTENT(IN) :: fq_l_d, kexc_d
    REAL(sp), INTENT(INOUT) :: ht
    REAL(sp), INTENT(INOUT) :: ht_d
    REAL(sp), INTENT(OUT) :: l
    REAL(sp), INTENT(OUT) :: l_d
    REAL(sp) :: temp
! Range of correction coef: (0, 2)
    temp = ht**3.5_sp
    l_d = temp*(kexc*fq_l_d+(fq_l+1._sp)*kexc_d) + (fq_l+1._sp)*kexc*&
&     3.5_sp*ht**2.5*ht_d
    l = (fq_l+1._sp)*kexc*temp
  END SUBROUTINE GR_EXCHANGE_D

!  Differentiation of gr_exchange in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: l kexc fq_l ht
!   with respect to varying inputs: kexc fq_l ht
  SUBROUTINE GR_EXCHANGE_B(fq_l, fq_l_b, kexc, kexc_b, ht, ht_b, l, l_b)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: fq_l, kexc
    REAL(sp) :: fq_l_b, kexc_b
    REAL(sp), INTENT(INOUT) :: ht
    REAL(sp), INTENT(INOUT) :: ht_b
    REAL(sp) :: l
    REAL(sp) :: l_b
! Range of correction coef: (0, 2)
    REAL(sp) :: temp_b
    temp_b = ht**3.5_sp*l_b
    ht_b = ht_b + 3.5_sp*ht**2.5*(fq_l+1._sp)*kexc*l_b
    fq_l_b = fq_l_b + kexc*temp_b
    kexc_b = kexc_b + (fq_l+1._sp)*temp_b
  END SUBROUTINE GR_EXCHANGE_B

  SUBROUTINE GR_EXCHANGE(fq_l, kexc, ht, l)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: fq_l, kexc
    REAL(sp), INTENT(INOUT) :: ht
    REAL(sp), INTENT(OUT) :: l
! Range of correction coef: (0, 2)
    l = (1._sp+fq_l)*kexc*ht**3.5_sp
  END SUBROUTINE GR_EXCHANGE

!  Differentiation of gr_threshold_exchange in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: l
!   with respect to varying inputs: aexc kexc fq_l ht
  SUBROUTINE GR_THRESHOLD_EXCHANGE_D(fq_l, fq_l_d, kexc, kexc_d, aexc, &
&   aexc_d, ht, ht_d, l, l_d)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: fq_l, kexc, aexc
    REAL(sp), INTENT(IN) :: fq_l_d, kexc_d, aexc_d
    REAL(sp), INTENT(INOUT) :: ht
    REAL(sp), INTENT(INOUT) :: ht_d
    REAL(sp), INTENT(OUT) :: l
    REAL(sp), INTENT(OUT) :: l_d
! Range of correction coef: (0, 2)
    l_d = (ht-aexc)*(kexc*fq_l_d+(fq_l+1._sp)*kexc_d) + (fq_l+1._sp)*&
&     kexc*(ht_d-aexc_d)
    l = (1._sp+fq_l)*kexc*(ht-aexc)
  END SUBROUTINE GR_THRESHOLD_EXCHANGE_D

!  Differentiation of gr_threshold_exchange in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: aexc l kexc fq_l ht
!   with respect to varying inputs: aexc kexc fq_l ht
  SUBROUTINE GR_THRESHOLD_EXCHANGE_B(fq_l, fq_l_b, kexc, kexc_b, aexc, &
&   aexc_b, ht, ht_b, l, l_b)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: fq_l, kexc, aexc
    REAL(sp) :: fq_l_b, kexc_b, aexc_b
    REAL(sp), INTENT(INOUT) :: ht
    REAL(sp), INTENT(INOUT) :: ht_b
    REAL(sp) :: l
    REAL(sp) :: l_b
! Range of correction coef: (0, 2)
    REAL(sp) :: temp_b
    fq_l_b = fq_l_b + kexc*(ht-aexc)*l_b
    kexc_b = kexc_b + (fq_l+1._sp)*(ht-aexc)*l_b
    temp_b = (fq_l+1._sp)*kexc*l_b
    ht_b = ht_b + temp_b
    aexc_b = aexc_b - temp_b
  END SUBROUTINE GR_THRESHOLD_EXCHANGE_B

  SUBROUTINE GR_THRESHOLD_EXCHANGE(fq_l, kexc, aexc, ht, l)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: fq_l, kexc, aexc
    REAL(sp), INTENT(INOUT) :: ht
    REAL(sp), INTENT(OUT) :: l
! Range of correction coef: (0, 2)
    l = (1._sp+fq_l)*kexc*(ht-aexc)
  END SUBROUTINE GR_THRESHOLD_EXCHANGE

!  Differentiation of gr_transfer in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: q ht
!   with respect to varying inputs: ht ct pr
  SUBROUTINE GR_TRANSFER_D(n, prcp, pr, pr_d, ct, ct_d, ht, ht_d, q, q_d&
& )
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: n, prcp, pr, ct
    REAL(sp), INTENT(IN) :: pr_d, ct_d
    REAL(sp), INTENT(INOUT) :: ht
    REAL(sp), INTENT(INOUT) :: ht_d
    REAL(sp), INTENT(OUT) :: q
    REAL(sp), INTENT(OUT) :: q_d
    REAL(sp) :: pr_imd, ht_imd, nm1, d1pnm1
    REAL(sp) :: pr_imd_d, ht_imd_d
    INTRINSIC MAX
    REAL(sp) :: pwx1
    REAL(sp) :: pwx1_d
    REAL(sp) :: pwy1
    REAL(sp) :: pwr1
    REAL(sp) :: pwr1_d
    REAL(sp) :: pwy2
    REAL(sp) :: pwr2
    REAL(sp) :: pwr2_d
    REAL(sp) :: pwx3
    REAL(sp) :: pwx3_d
    REAL(sp) :: pwy3
    REAL(sp) :: pwr3
    REAL(sp) :: pwr3_d
    nm1 = n - 1._sp
    d1pnm1 = 1._sp/nm1
    IF (prcp .LT. 0._sp) THEN
      pwx1_d = ct*ht_d + ht*ct_d
      pwx1 = ht*ct
      pwy1 = -nm1
      IF (pwx1 .LE. 0.0 .AND. (pwy1 .EQ. 0.0 .OR. pwy1 .NE. INT(pwy1))) &
&     THEN
        pwr1_d = 0.0_4
      ELSE
        pwr1_d = pwy1*pwx1**(pwy1-1)*pwx1_d
      END IF
      pwr1 = pwx1**pwy1
      pwy2 = -nm1
      IF (ct .LE. 0.0 .AND. (pwy2 .EQ. 0.0 .OR. pwy2 .NE. INT(pwy2))) &
&     THEN
        pwr2_d = 0.0_4
      ELSE
        pwr2_d = pwy2*ct**(pwy2-1)*ct_d
      END IF
      pwr2 = ct**pwy2
      pwx3_d = pwr1_d - pwr2_d
      pwx3 = pwr1 - pwr2
      pwy3 = -d1pnm1
      IF (pwx3 .LE. 0.0 .AND. (pwy3 .EQ. 0.0 .OR. pwy3 .NE. INT(pwy3))) &
&     THEN
        pwr3_d = 0.0_4
      ELSE
        pwr3_d = pwy3*pwx3**(pwy3-1)*pwx3_d
      END IF
      pwr3 = pwx3**pwy3
      pr_imd_d = pwr3_d - ct*ht_d - ht*ct_d
      pr_imd = pwr3 - ht*ct
    ELSE
      pr_imd_d = pr_d
      pr_imd = pr
    END IF
    IF (1.e-6_sp .LT. ht + pr_imd/ct) THEN
      ht_imd_d = ht_d + (pr_imd_d-pr_imd*ct_d/ct)/ct
      ht_imd = ht + pr_imd/ct
    ELSE
      ht_imd = 1.e-6_sp
      ht_imd_d = 0.0_4
    END IF
    pwx1_d = ct*ht_imd_d + ht_imd*ct_d
    pwx1 = ht_imd*ct
    pwy1 = -nm1
    IF (pwx1 .LE. 0.0 .AND. (pwy1 .EQ. 0.0 .OR. pwy1 .NE. INT(pwy1))) &
&   THEN
      pwr1_d = 0.0_4
    ELSE
      pwr1_d = pwy1*pwx1**(pwy1-1)*pwx1_d
    END IF
    pwr1 = pwx1**pwy1
    pwy2 = -nm1
    IF (ct .LE. 0.0 .AND. (pwy2 .EQ. 0.0 .OR. pwy2 .NE. INT(pwy2))) THEN
      pwr2_d = 0.0_4
    ELSE
      pwr2_d = pwy2*ct**(pwy2-1)*ct_d
    END IF
    pwr2 = ct**pwy2
    pwx3_d = pwr1_d + pwr2_d
    pwx3 = pwr1 + pwr2
    pwy3 = -d1pnm1
    IF (pwx3 .LE. 0.0 .AND. (pwy3 .EQ. 0.0 .OR. pwy3 .NE. INT(pwy3))) &
&   THEN
      pwr3_d = 0.0_4
    ELSE
      pwr3_d = pwy3*pwx3**(pwy3-1)*pwx3_d
    END IF
    pwr3 = pwx3**pwy3
    ht_d = (pwr3_d-pwr3*ct_d/ct)/ct
    ht = pwr3/ct
    q_d = ct*(ht_imd_d-ht_d) + (ht_imd-ht)*ct_d
    q = (ht_imd-ht)*ct
  END SUBROUTINE GR_TRANSFER_D

!  Differentiation of gr_transfer in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: q ht ct
!   with respect to varying inputs: ht ct pr
  SUBROUTINE GR_TRANSFER_B(n, prcp, pr, pr_b, ct, ct_b, ht, ht_b, q, q_b&
& )
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: n, prcp, pr, ct
    REAL(sp) :: pr_b, ct_b
    REAL(sp), INTENT(INOUT) :: ht
    REAL(sp), INTENT(INOUT) :: ht_b
    REAL(sp) :: q
    REAL(sp) :: q_b
    REAL(sp) :: pr_imd, ht_imd, nm1, d1pnm1
    REAL(sp) :: pr_imd_b, ht_imd_b
    INTRINSIC MAX
    REAL(sp) :: pwx1
    REAL(sp) :: pwx1_b
    REAL(sp) :: pwy1
    REAL(sp) :: pwr1
    REAL(sp) :: pwr1_b
    REAL(sp) :: pwy2
    REAL(sp) :: pwr2
    REAL(sp) :: pwr2_b
    REAL(sp) :: pwx3
    REAL(sp) :: pwx3_b
    REAL(sp) :: pwy3
    REAL(sp) :: pwr3
    REAL(sp) :: pwr3_b
    INTEGER :: branch
    nm1 = n - 1._sp
    d1pnm1 = 1._sp/nm1
    IF (prcp .LT. 0._sp) THEN
      pwx1 = ht*ct
      pwy1 = -nm1
      pwr1 = pwx1**pwy1
      pwy2 = -nm1
      pwr2 = ct**pwy2
      pwx3 = pwr1 - pwr2
      pwy3 = -d1pnm1
      pwr3 = pwx3**pwy3
      pr_imd = pwr3 - ht*ct
      CALL PUSHCONTROL1B(1)
    ELSE
      pr_imd = pr
      CALL PUSHCONTROL1B(0)
    END IF
    IF (1.e-6_sp .LT. ht + pr_imd/ct) THEN
      ht_imd = ht + pr_imd/ct
      CALL PUSHCONTROL1B(0)
    ELSE
      ht_imd = 1.e-6_sp
      CALL PUSHCONTROL1B(1)
    END IF
    CALL PUSHREAL4(pwx1)
    pwx1 = ht_imd*ct
    CALL PUSHREAL4(pwy1)
    pwy1 = -nm1
    pwr1 = pwx1**pwy1
    CALL PUSHREAL4(pwy2)
    pwy2 = -nm1
    pwr2 = ct**pwy2
    CALL PUSHREAL4(pwx3)
    pwx3 = pwr1 + pwr2
    CALL PUSHREAL4(pwy3)
    pwy3 = -d1pnm1
    pwr3 = pwx3**pwy3
    CALL PUSHREAL4(ht)
    ht = pwr3/ct
    pwx1 = ht_imd*ct
    nm1 = n - 1._sp
    pwy1 = -nm1
    pwy2 = -nm1
    d1pnm1 = 1._sp/nm1
    pwy3 = -d1pnm1
    ht_b = ht_b - ct*q_b
    pwr3_b = ht_b/ct
    IF (pwx3 .LE. 0.0 .AND. (pwy3 .EQ. 0.0 .OR. pwy3 .NE. INT(pwy3))) &
&   THEN
      pwx3_b = 0.0_4
    ELSE
      pwx3_b = pwy3*pwx3**(pwy3-1)*pwr3_b
    END IF
    pwr1_b = pwx3_b
    pwr2_b = pwx3_b
    IF (pwx1 .LE. 0.0 .AND. (pwy1 .EQ. 0.0 .OR. pwy1 .NE. INT(pwy1))) &
&   THEN
      pwx1_b = 0.0_4
    ELSE
      pwx1_b = pwy1*pwx1**(pwy1-1)*pwr1_b
    END IF
    ht_imd_b = ct*q_b + ct*pwx1_b
    IF (ct .LE. 0.0 .AND. (pwy2 .EQ. 0.0 .OR. pwy2 .NE. INT(pwy2))) THEN
      ct_b = ct_b + (ht_imd-ht)*q_b + ht_imd*pwx1_b - pwr3*ht_b/ct**2
    ELSE
      ct_b = ct_b + (ht_imd-ht)*q_b + pwy2*ct**(pwy2-1)*pwr2_b - pwr3*&
&       ht_b/ct**2 + ht_imd*pwx1_b
    END IF
    CALL POPREAL4(ht)
    CALL POPREAL4(pwy3)
    CALL POPREAL4(pwx3)
    CALL POPREAL4(pwy2)
    CALL POPREAL4(pwy1)
    CALL POPREAL4(pwx1)
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      ht_b = ht_imd_b
      pr_imd_b = ht_imd_b/ct
      ct_b = ct_b - pr_imd*ht_imd_b/ct**2
    ELSE
      ht_b = 0.0_4
      pr_imd_b = 0.0_4
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      pr_b = pr_imd_b
    ELSE
      pwr3_b = pr_imd_b
      IF (pwx3 .LE. 0.0 .AND. (pwy3 .EQ. 0.0 .OR. pwy3 .NE. INT(pwy3))) &
&     THEN
        pwx3_b = 0.0_4
      ELSE
        pwx3_b = pwy3*pwx3**(pwy3-1)*pwr3_b
      END IF
      pwr1_b = pwx3_b
      pwr2_b = -pwx3_b
      IF (pwx1 .LE. 0.0 .AND. (pwy1 .EQ. 0.0 .OR. pwy1 .NE. INT(pwy1))) &
&     THEN
        pwx1_b = 0.0_4
      ELSE
        pwx1_b = pwy1*pwx1**(pwy1-1)*pwr1_b
      END IF
      ht_b = ht_b + ct*pwx1_b - ct*pr_imd_b
      IF (ct .LE. 0.0 .AND. (pwy2 .EQ. 0.0 .OR. pwy2 .NE. INT(pwy2))) &
&     THEN
        ct_b = ct_b + ht*pwx1_b - ht*pr_imd_b
      ELSE
        ct_b = ct_b + pwy2*ct**(pwy2-1)*pwr2_b - ht*pr_imd_b + ht*pwx1_b
      END IF
      pr_b = 0.0_4
    END IF
  END SUBROUTINE GR_TRANSFER_B

  SUBROUTINE GR_TRANSFER(n, prcp, pr, ct, ht, q)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: n, prcp, pr, ct
    REAL(sp), INTENT(INOUT) :: ht
    REAL(sp), INTENT(OUT) :: q
    REAL(sp) :: pr_imd, ht_imd, nm1, d1pnm1
    INTRINSIC MAX
    REAL(sp) :: pwx1
    REAL(sp) :: pwy1
    REAL(sp) :: pwr1
    REAL(sp) :: pwy2
    REAL(sp) :: pwr2
    REAL(sp) :: pwx3
    REAL(sp) :: pwy3
    REAL(sp) :: pwr3
    nm1 = n - 1._sp
    d1pnm1 = 1._sp/nm1
    IF (prcp .LT. 0._sp) THEN
      pwx1 = ht*ct
      pwy1 = -nm1
      pwr1 = pwx1**pwy1
      pwy2 = -nm1
      pwr2 = ct**pwy2
      pwx3 = pwr1 - pwr2
      pwy3 = -d1pnm1
      pwr3 = pwx3**pwy3
      pr_imd = pwr3 - ht*ct
    ELSE
      pr_imd = pr
    END IF
    IF (1.e-6_sp .LT. ht + pr_imd/ct) THEN
      ht_imd = ht + pr_imd/ct
    ELSE
      ht_imd = 1.e-6_sp
    END IF
    pwx1 = ht_imd*ct
    pwy1 = -nm1
    pwr1 = pwx1**pwy1
    pwy2 = -nm1
    pwr2 = ct**pwy2
    pwx3 = pwr1 + pwr2
    pwy3 = -d1pnm1
    pwr3 = pwx3**pwy3
    ht = pwr3/ct
    q = (ht_imd-ht)*ct
  END SUBROUTINE GR_TRANSFER

!  Differentiation of gr_exponential_transfer in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: qe he
!   with respect to varying inputs: he be pre
  SUBROUTINE GR_EXPONENTIAL_TRANSFER_D(pre, pre_d, be, be_d, he, he_d, &
&   qe, qe_d)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: pre, be
    REAL(sp), INTENT(IN) :: pre_d, be_d
    REAL(sp), INTENT(INOUT) :: he
    REAL(sp), INTENT(INOUT) :: he_d
    REAL(sp), INTENT(OUT) :: qe
    REAL(sp), INTENT(OUT) :: qe_d
    REAL(sp) :: he_star, ar
    REAL(sp) :: he_star_d, ar_d
    INTRINSIC EXP
    INTRINSIC LOG
    REAL(sp) :: arg1
    REAL(sp) :: arg1_d
    REAL(sp) :: temp
    he_star_d = he_d + pre_d
    he_star = he + pre
    ar_d = (he_star_d-he_star*be_d/be)/be
    ar = he_star/be
    IF (ar .LT. -7._sp) THEN
      temp = EXP(ar)
      qe_d = temp*be_d + be*EXP(ar)*ar_d
      qe = be*temp
    ELSE IF (ar .GT. 7._sp) THEN
      temp = EXP(ar)
      qe_d = he_star_d + (be_d-be*EXP(ar)*ar_d/temp)/temp
      qe = he_star + be/temp
    ELSE
      arg1_d = EXP(ar)*ar_d
      arg1 = EXP(ar) + 1._sp
      temp = LOG(arg1)
      qe_d = temp*be_d + be*arg1_d/arg1
      qe = be*temp
    END IF
    he_d = he_star_d - qe_d
    he = he_star - qe
  END SUBROUTINE GR_EXPONENTIAL_TRANSFER_D

!  Differentiation of gr_exponential_transfer in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: qe he be
!   with respect to varying inputs: he be pre
  SUBROUTINE GR_EXPONENTIAL_TRANSFER_B(pre, pre_b, be, be_b, he, he_b, &
&   qe, qe_b)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: pre, be
    REAL(sp) :: pre_b, be_b
    REAL(sp), INTENT(INOUT) :: he
    REAL(sp), INTENT(INOUT) :: he_b
    REAL(sp) :: qe
    REAL(sp) :: qe_b
    REAL(sp) :: he_star, ar
    REAL(sp) :: he_star_b, ar_b
    INTRINSIC EXP
    INTRINSIC LOG
    REAL(sp) :: arg1
    REAL(sp) :: arg1_b
    REAL(sp) :: temp
    INTEGER :: branch
    he_star = he + pre
    ar = he_star/be
    IF (ar .LT. -7._sp) THEN
      CALL PUSHCONTROL2B(0)
    ELSE IF (ar .GT. 7._sp) THEN
      CALL PUSHCONTROL2B(1)
    ELSE
      arg1 = EXP(ar) + 1._sp
      CALL PUSHCONTROL2B(2)
    END IF
    he_star_b = he_b
    qe_b = qe_b - he_b
    CALL POPCONTROL2B(branch)
    IF (branch .EQ. 0) THEN
      ar = he_star/be
      be_b = be_b + EXP(ar)*qe_b
      ar_b = EXP(ar)*be*qe_b
    ELSE IF (branch .EQ. 1) THEN
      ar = he_star/be
      temp = EXP(ar)
      he_star_b = he_star_b + qe_b
      be_b = be_b + qe_b/temp
      ar_b = -(EXP(ar)*be*qe_b/temp**2)
    ELSE
      be_b = be_b + LOG(arg1)*qe_b
      arg1_b = be*qe_b/arg1
      ar = he_star/be
      ar_b = EXP(ar)*arg1_b
    END IF
    he_star_b = he_star_b + ar_b/be
    be_b = be_b - he_star*ar_b/be**2
    he_b = he_star_b
    pre_b = he_star_b
  END SUBROUTINE GR_EXPONENTIAL_TRANSFER_B

  SUBROUTINE GR_EXPONENTIAL_TRANSFER(pre, be, he, qe)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: pre, be
    REAL(sp), INTENT(INOUT) :: he
    REAL(sp), INTENT(OUT) :: qe
    REAL(sp) :: he_star, ar
    INTRINSIC EXP
    INTRINSIC LOG
    REAL(sp) :: arg1
    he_star = he + pre
    ar = he_star/be
    IF (ar .LT. -7._sp) THEN
      qe = be*EXP(ar)
    ELSE IF (ar .GT. 7._sp) THEN
      qe = he_star + be/EXP(ar)
    ELSE
      arg1 = EXP(ar) + 1._sp
      qe = be*LOG(arg1)
    END IF
    he = he_star - qe
  END SUBROUTINE GR_EXPONENTIAL_TRANSFER

!  Differentiation of gr_production_transfer_ode in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: q hp ht pn
!   with respect to varying inputs: kexc hp ht en cp pn ct
  SUBROUTINE GR_PRODUCTION_TRANSFER_ODE_D(pn, pn_d, en, en_d, &
&   imperviousness, cp, cp_d, ct, ct_d, kexc, kexc_d, hp, hp_d, ht, ht_d&
&   , q, q_d, l)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: en, imperviousness, cp, ct, kexc
    REAL(sp), INTENT(IN) :: en_d, cp_d, ct_d, kexc_d
    REAL(sp), INTENT(INOUT) :: pn, hp, ht, q
    REAL(sp), INTENT(INOUT) :: pn_d, hp_d, ht_d, q_d
    REAL(sp), INTENT(OUT) :: l
    REAL(sp) :: l_d
    REAL(sp), DIMENSION(2, 2) :: jacob
    REAL(sp), DIMENSION(2, 2) :: jacob_d
    REAL(sp), DIMENSION(2) :: dh, delta_h
    REAL(sp), DIMENSION(2) :: dh_d, delta_h_d
    REAL(sp) :: inv_cp, inv_ct, hp0, ht0, dt, fhp, fht
    REAL(sp) :: inv_cp_d, inv_ct_d, hp0_d, ht0_d, fhp_d, fht_d
    LOGICAL :: converged
    INTEGER :: j
    INTEGER, SAVE :: maxiter=10
    INTRINSIC SQRT
    REAL(sp) :: arg1
    REAL(sp) :: result1
    REAL(sp) :: temp
    REAL(sp) :: temp0
    REAL(sp) :: temp1
    inv_cp_d = -(cp_d/cp**2)
    inv_cp = 1._sp/cp
    inv_ct_d = -(ct_d/ct**2)
    inv_ct = 1._sp/ct
! impervious area percentage at cell scale applied to neutralized rainfall - no infiltration for imperviousness*pn
    pn_d = (1._sp-imperviousness)*pn_d
    pn = (1._sp-imperviousness)*pn
    dt = 1._sp
    hp0_d = hp_d
    hp0 = hp
    ht0_d = ht_d
    ht0 = ht
    converged = .false.
    j = 0
    dh_d = 0.0_4
    delta_h_d = 0.0_4
    jacob_d = 0.0_4
    DO WHILE (.NOT.converged .AND. j .LT. maxiter)
      temp = (-(hp*hp)+1._sp)*pn - (-hp+2._sp)*hp*en
      fhp_d = inv_cp*((1._sp-hp**2)*pn_d-(pn*2*hp-hp*en)*hp_d-(2._sp-hp)&
&       *(en*hp_d+hp*en_d)) + temp*inv_cp_d
      fhp = temp*inv_cp
      dh_d(1) = hp_d - hp0_d - dt*fhp_d
      dh(1) = hp - hp0 - dt*fhp
      temp = ht**5
      temp0 = ht**3.5_sp
      temp1 = 0.9_sp*pn*(hp*hp) - 0.25_sp*ct*temp + kexc*temp0
      fht_d = inv_ct*(0.9_sp*(hp**2*pn_d+pn*2*hp*hp_d)-0.25_sp*(temp*&
&       ct_d+ct*5*ht**4*ht_d)+temp0*kexc_d+kexc*3.5_sp*ht**2.5*ht_d) + &
&       temp1*inv_ct_d
      fht = temp1*inv_ct
      dh_d(2) = ht_d - ht0_d - dt*fht_d
      dh(2) = ht - ht0 - dt*fht
! 1 - dt*nabla_hp(fhp)
      temp1 = hp*(pn-en) + en
      jacob_d(1, 1) = dt*2._sp*(inv_cp*((pn-en)*hp_d+hp*(pn_d-en_d)+en_d&
&       )+temp1*inv_cp_d)
      jacob(1, 1) = dt*2._sp*(temp1*inv_cp) + 1._sp
! -dt*nabla_ht(fhp)
      jacob_d(1, 2) = 0.0_4
      jacob(1, 2) = 0._sp
! -dt*nabla_hp(fht)
      jacob_d(2, 1) = -(dt*1.8_sp*(inv_ct*(hp*pn_d+pn*hp_d)+pn*hp*&
&       inv_ct_d))
      jacob(2, 1) = -(dt*1.8_sp*pn*hp*inv_ct)
! 1 - dt*nabla_ht(fht)
      temp1 = ht**2.5_sp
      temp0 = ht**4
      temp = 3.5_sp*kexc*temp1 - 1.25_sp*ct*temp0
      jacob_d(2, 2) = -(dt*(inv_ct*(3.5_sp*(temp1*kexc_d+kexc*2.5_sp*ht&
&       **1.5*ht_d)-1.25_sp*(temp0*ct_d+ct*4*ht**3*ht_d))+temp*inv_ct_d)&
&       )
      jacob(2, 2) = 1._sp - dt*(temp*inv_ct)
      CALL SOLVE_LINEAR_SYSTEM_2VARS_D(jacob, jacob_d, delta_h, &
&                                delta_h_d, dh, dh_d)
      hp_d = hp_d + delta_h_d(1)
      hp = hp + delta_h(1)
      IF (hp .LE. 0._sp) THEN
        hp = 1.e-6_sp
        hp_d = 0.0_4
      END IF
      IF (hp .GE. 1._sp) THEN
        hp = 1._sp - 1.e-6_sp
        hp_d = 0.0_4
      END IF
      ht_d = ht_d + delta_h_d(2)
      ht = ht + delta_h(2)
      IF (ht .LE. 0._sp) THEN
        ht = 1.e-6_sp
        ht_d = 0.0_4
      END IF
      IF (ht .GE. 1._sp) THEN
        ht = 1._sp - 1.e-6_sp
        ht_d = 0.0_4
      END IF
      arg1 = (delta_h(1)/hp)**2 + (delta_h(2)/ht)**2
      result1 = SQRT(arg1)
      converged = result1 .LT. 1.e-6_sp
      j = j + 1
    END DO
    temp1 = ht**3.5_sp
    l_d = temp1*kexc_d + kexc*3.5_sp*ht**2.5*ht_d
    l = kexc*temp1
    temp1 = ht**5
    q_d = 0.25_sp*(temp1*ct_d+ct*5*ht**4*ht_d) + 0.1_sp*(hp**2*pn_d+pn*2&
&     *hp*hp_d) + l_d
    q = 0.25_sp*(ct*temp1) + 0.1_sp*(pn*(hp*hp)) + l
  END SUBROUTINE GR_PRODUCTION_TRANSFER_ODE_D

!  Differentiation of gr_production_transfer_ode in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: q kexc hp ht en cp pn ct
!   with respect to varying inputs: kexc hp ht en cp pn ct
  SUBROUTINE GR_PRODUCTION_TRANSFER_ODE_B(pn, pn_b, en, en_b, &
&   imperviousness, cp, cp_b, ct, ct_b, kexc, kexc_b, hp, hp_b, ht, ht_b&
&   , q, q_b, l)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: en, imperviousness, cp, ct, kexc
    REAL(sp) :: en_b, cp_b, ct_b, kexc_b
    REAL(sp), INTENT(INOUT) :: pn, hp, ht, q
    REAL(sp), INTENT(INOUT) :: pn_b, hp_b, ht_b, q_b
    REAL(sp) :: l
    REAL(sp), DIMENSION(2, 2) :: jacob
    REAL(sp), DIMENSION(2, 2) :: jacob_b
    REAL(sp), DIMENSION(2) :: dh, delta_h
    REAL(sp), DIMENSION(2) :: dh_b, delta_h_b
    REAL(sp) :: inv_cp, inv_ct, hp0, ht0, dt, fhp, fht
    REAL(sp) :: inv_cp_b, inv_ct_b, hp0_b, ht0_b, fhp_b, fht_b
    LOGICAL :: converged
    INTEGER :: j
    INTEGER, SAVE :: maxiter=10
    INTRINSIC SQRT
    REAL(sp) :: arg1
    REAL(sp) :: result1
    REAL(sp) :: temp
    REAL(sp) :: temp_b
    REAL(sp) :: temp0
    REAL(sp) :: temp1
    REAL(sp) :: temp_b0
    REAL(sp) :: temp_b1
    INTEGER :: branch
    INTEGER :: ad_count
    INTEGER :: i
    REAL(sp) :: l_b
    inv_cp = 1._sp/cp
    inv_ct = 1._sp/ct
! impervious area percentage at cell scale applied to neutralized rainfall - no infiltration for imperviousness*pn
    pn = (1._sp-imperviousness)*pn
    dt = 1._sp
    hp0 = hp
    ht0 = ht
    converged = .false.
    j = 0
    ad_count = 0
    DO WHILE (.NOT.converged .AND. j .LT. maxiter)
      fhp = ((1._sp-hp**2)*pn-hp*(2._sp-hp)*en)*inv_cp
      CALL PUSHREAL4(dh(1))
      dh(1) = hp - hp0 - dt*fhp
      fht = (0.9_sp*pn*hp**2-0.25_sp*ct*ht**5+kexc*ht**3.5_sp)*inv_ct
      CALL PUSHREAL4(dh(2))
      dh(2) = ht - ht0 - dt*fht
! 1 - dt*nabla_hp(fhp)
      CALL PUSHREAL4(jacob(1, 1))
      jacob(1, 1) = 1._sp + dt*2._sp*(hp*(pn-en)+en)*inv_cp
! -dt*nabla_ht(fhp)
      CALL PUSHREAL4(jacob(1, 2))
      jacob(1, 2) = 0._sp
! -dt*nabla_hp(fht)
      CALL PUSHREAL4(jacob(2, 1))
      jacob(2, 1) = -(dt*1.8_sp*pn*hp*inv_ct)
! 1 - dt*nabla_ht(fht)
      CALL PUSHREAL4(jacob(2, 2))
      jacob(2, 2) = 1._sp - dt*(3.5_sp*kexc*ht**2.5_sp-1.25_sp*ct*ht**4)&
&       *inv_ct
      CALL SOLVE_LINEAR_SYSTEM_2VARS(jacob, delta_h, dh)
      CALL PUSHREAL4(hp)
      hp = hp + delta_h(1)
      IF (hp .LE. 0._sp) THEN
        hp = 1.e-6_sp
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHCONTROL1B(1)
      END IF
      IF (hp .GE. 1._sp) THEN
        hp = 1._sp - 1.e-6_sp
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHCONTROL1B(1)
      END IF
      CALL PUSHREAL4(ht)
      ht = ht + delta_h(2)
      IF (ht .LE. 0._sp) THEN
        ht = 1.e-6_sp
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHCONTROL1B(1)
      END IF
      IF (ht .GE. 1._sp) THEN
        ht = 1._sp - 1.e-6_sp
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHCONTROL1B(1)
      END IF
      arg1 = (delta_h(1)/hp)**2 + (delta_h(2)/ht)**2
      result1 = SQRT(arg1)
      converged = result1 .LT. 1.e-6_sp
      j = j + 1
      ad_count = ad_count + 1
    END DO
    CALL PUSHINTEGER4(ad_count)
    l_b = q_b
    ct_b = ct_b + ht**5*0.25_sp*q_b
    ht_b = ht_b + 5*ht**4*ct*0.25_sp*q_b + 3.5_sp*ht**2.5*kexc*l_b
    pn_b = pn_b + hp**2*0.1_sp*q_b
    hp_b = hp_b + 2*hp*pn*0.1_sp*q_b
    kexc_b = kexc_b + ht**3.5_sp*l_b
    dt = 1._sp
    inv_cp = 1._sp/cp
    inv_ct = 1._sp/ct
    dh_b = 0.0_4
    delta_h_b = 0.0_4
    jacob_b = 0.0_4
    hp0_b = 0.0_4
    inv_cp_b = 0.0_4
    inv_ct_b = 0.0_4
    ht0_b = 0.0_4
    CALL POPINTEGER4(ad_count)
    DO i=1,ad_count
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) ht_b = 0.0_4
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) ht_b = 0.0_4
      CALL POPREAL4(ht)
      delta_h_b(2) = delta_h_b(2) + ht_b
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) hp_b = 0.0_4
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) hp_b = 0.0_4
      CALL POPREAL4(hp)
      delta_h_b(1) = delta_h_b(1) + hp_b
      CALL SOLVE_LINEAR_SYSTEM_2VARS_B(jacob, jacob_b, delta_h, &
&                                delta_h_b, dh, dh_b)
      CALL POPREAL4(jacob(2, 2))
      temp0 = ht**2.5_sp
      temp = ht**4
      temp_b0 = -(inv_ct*dt*jacob_b(2, 2))
      inv_ct_b = inv_ct_b - (3.5_sp*(kexc*temp0)-1.25_sp*(ct*temp))*dt*&
&       jacob_b(2, 2)
      jacob_b(2, 2) = 0.0_4
      CALL POPREAL4(jacob(2, 1))
      CALL POPREAL4(jacob(1, 2))
      jacob_b(1, 2) = 0.0_4
      CALL POPREAL4(jacob(1, 1))
      CALL POPREAL4(dh(2))
      ht0_b = ht0_b - dh_b(2)
      fht_b = -(dt*dh_b(2))
      temp1 = ht**3.5_sp
      temp_b = inv_ct*fht_b
      kexc_b = kexc_b + temp0*3.5_sp*temp_b0 + temp1*temp_b
      ht_b = ht_b + (2.5_sp*ht**1.5*kexc*3.5_sp-4*ht**3*ct*1.25_sp)*&
&       temp_b0 + dh_b(2) + (3.5_sp*ht**2.5*kexc-5*ht**4*ct*0.25_sp)*&
&       temp_b
      dh_b(2) = 0.0_4
      temp0 = ht**5
      ct_b = ct_b - temp*1.25_sp*temp_b0 - temp0*0.25_sp*temp_b
      temp_b0 = -(dt*1.8_sp*jacob_b(2, 1))
      jacob_b(2, 1) = 0.0_4
      pn_b = pn_b + hp*inv_ct*temp_b0
      hp_b = hp_b + pn*inv_ct*temp_b0
      inv_ct_b = inv_ct_b + pn*hp*temp_b0 + (0.9_sp*(pn*hp**2)-0.25_sp*(&
&       ct*temp0)+kexc*temp1)*fht_b
      temp_b0 = dt*2._sp*jacob_b(1, 1)
      jacob_b(1, 1) = 0.0_4
      temp_b1 = inv_cp*temp_b0
      hp_b = hp_b + (pn-en)*temp_b1 + 2*hp*pn*0.9_sp*temp_b
      pn_b = pn_b + hp*temp_b1 + hp**2*0.9_sp*temp_b
      CALL POPREAL4(dh(1))
      hp0_b = hp0_b - dh_b(1)
      fhp_b = -(dt*dh_b(1))
      inv_cp_b = inv_cp_b + (hp*(pn-en)+en)*temp_b0 + ((1._sp-hp**2)*pn-&
&       (2._sp-hp)*(hp*en))*fhp_b
      temp_b = inv_cp*fhp_b
      en_b = en_b + (1.0-hp)*temp_b1 - hp*(2._sp-hp)*temp_b
      hp_b = hp_b + dh_b(1) + (hp*en-en*(2._sp-hp)-2*hp*pn)*temp_b
      dh_b(1) = 0.0_4
      pn_b = pn_b + (1._sp-hp**2)*temp_b
    END DO
    ht_b = ht_b + ht0_b
    hp_b = hp_b + hp0_b
    pn_b = (1._sp-imperviousness)*pn_b
    ct_b = ct_b - inv_ct_b/ct**2
    cp_b = cp_b - inv_cp_b/cp**2
  END SUBROUTINE GR_PRODUCTION_TRANSFER_ODE_B

  SUBROUTINE GR_PRODUCTION_TRANSFER_ODE(pn, en, imperviousness, cp, ct, &
&   kexc, hp, ht, q, l)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: en, imperviousness, cp, ct, kexc
    REAL(sp), INTENT(INOUT) :: pn, hp, ht, q
    REAL(sp), INTENT(OUT) :: l
    REAL(sp), DIMENSION(2, 2) :: jacob
    REAL(sp), DIMENSION(2) :: dh, delta_h
    REAL(sp) :: inv_cp, inv_ct, hp0, ht0, dt, fhp, fht
    LOGICAL :: converged
    INTEGER :: j
    INTEGER, SAVE :: maxiter=10
    INTRINSIC SQRT
    REAL(sp) :: arg1
    REAL(sp) :: result1
    inv_cp = 1._sp/cp
    inv_ct = 1._sp/ct
! impervious area percentage at cell scale applied to neutralized rainfall - no infiltration for imperviousness*pn
    pn = (1._sp-imperviousness)*pn
    dt = 1._sp
    hp0 = hp
    ht0 = ht
    converged = .false.
    j = 0
    DO WHILE (.NOT.converged .AND. j .LT. maxiter)
      fhp = ((1._sp-hp**2)*pn-hp*(2._sp-hp)*en)*inv_cp
      dh(1) = hp - hp0 - dt*fhp
      fht = (0.9_sp*pn*hp**2-0.25_sp*ct*ht**5+kexc*ht**3.5_sp)*inv_ct
      dh(2) = ht - ht0 - dt*fht
! 1 - dt*nabla_hp(fhp)
      jacob(1, 1) = 1._sp + dt*2._sp*(hp*(pn-en)+en)*inv_cp
! -dt*nabla_ht(fhp)
      jacob(1, 2) = 0._sp
! -dt*nabla_hp(fht)
      jacob(2, 1) = -(dt*1.8_sp*pn*hp*inv_ct)
! 1 - dt*nabla_ht(fht)
      jacob(2, 2) = 1._sp - dt*(3.5_sp*kexc*ht**2.5_sp-1.25_sp*ct*ht**4)&
&       *inv_ct
      CALL SOLVE_LINEAR_SYSTEM_2VARS(jacob, delta_h, dh)
      hp = hp + delta_h(1)
      IF (hp .LE. 0._sp) hp = 1.e-6_sp
      IF (hp .GE. 1._sp) hp = 1._sp - 1.e-6_sp
      ht = ht + delta_h(2)
      IF (ht .LE. 0._sp) ht = 1.e-6_sp
      IF (ht .GE. 1._sp) ht = 1._sp - 1.e-6_sp
      arg1 = (delta_h(1)/hp)**2 + (delta_h(2)/ht)**2
      result1 = SQRT(arg1)
      converged = result1 .LT. 1.e-6_sp
      j = j + 1
    END DO
    l = kexc*ht**3.5_sp
    q = 0.25_sp*ct*ht**5 + 0.1_sp*pn*hp**2 + l
  END SUBROUTINE GR_PRODUCTION_TRANSFER_ODE

!  Differentiation of gr_production_transfer_ode_mlp in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: q hp ht pn
!   with respect to varying inputs: kexc hp ht en jacobian_nn_1
!                jacobian_nn_2 fq cp pn ct
  SUBROUTINE GR_PRODUCTION_TRANSFER_ODE_MLP_D(fq, fq_d, jacobian_nn_1, &
&   jacobian_nn_1_d, jacobian_nn_2, jacobian_nn_2_d, pn, pn_d, en, en_d&
&   , imperviousness, cp, cp_d, ct, ct_d, kexc, kexc_d, hp, hp_d, ht, &
&   ht_d, q, q_d, l)
    IMPLICIT NONE
! fixed NN output size
    REAL(sp), DIMENSION(4), INTENT(IN) :: fq
    REAL(sp), DIMENSION(4), INTENT(IN) :: fq_d
    INTRINSIC SIZE
! grad wrt hp
    REAL(sp), DIMENSION(SIZE(fq)), INTENT(IN) :: jacobian_nn_1
    REAL(sp), DIMENSION(SIZE(fq)), INTENT(IN) :: jacobian_nn_1_d
! grad wrt ht
    REAL(sp), DIMENSION(SIZE(fq)), INTENT(IN) :: jacobian_nn_2
    REAL(sp), DIMENSION(SIZE(fq)), INTENT(IN) :: jacobian_nn_2_d
    REAL(sp), INTENT(IN) :: en, imperviousness, cp, ct, kexc
    REAL(sp), INTENT(IN) :: en_d, cp_d, ct_d, kexc_d
    REAL(sp), INTENT(INOUT) :: pn, hp, ht, q
    REAL(sp), INTENT(INOUT) :: pn_d, hp_d, ht_d, q_d
    REAL(sp), INTENT(OUT) :: l
    REAL(sp) :: l_d
    REAL(sp), DIMENSION(2, 2) :: jacob
    REAL(sp), DIMENSION(2, 2) :: jacob_d
    REAL(sp), DIMENSION(2) :: dh, delta_h
    REAL(sp), DIMENSION(2) :: dh_d, delta_h_d
    REAL(sp) :: inv_cp, inv_ct, hp0, ht0, dt, fhp, fht
    REAL(sp) :: inv_cp_d, inv_ct_d, hp0_d, ht0_d, fhp_d, fht_d
    LOGICAL :: converged
    INTEGER :: j
    INTEGER, SAVE :: maxiter=10
    INTRINSIC SQRT
    REAL(sp) :: arg1
    REAL(sp) :: result1
    REAL(sp) :: temp
    REAL(sp) :: temp0
    REAL(sp) :: temp1
    REAL(sp) :: temp2
    REAL*4 :: temp3
    REAL*4 :: temp4
    inv_cp_d = -(cp_d/cp**2)
    inv_cp = 1._sp/cp
    inv_ct_d = -(ct_d/ct**2)
    inv_ct = 1._sp/ct
! impervious area percentage at cell scale applied to neutralized rainfall - no infiltration for imperviousness*pn
    pn_d = (1._sp-imperviousness)*pn_d
    pn = (1._sp-imperviousness)*pn
    dt = 1._sp
    hp0_d = hp_d
    hp0 = hp
    ht0_d = ht_d
    ht0 = ht
    converged = .false.
    j = 0
    dh_d = 0.0_4
    delta_h_d = 0.0_4
    jacob_d = 0.0_4
    DO WHILE (.NOT.converged .AND. j .LT. maxiter)
! Range of correction for the two terms: (0, 2)
      temp = (-hp+2._sp)*(fq(2)+1._sp)
      temp0 = (-(hp*hp)+1._sp)*pn*(fq(1)+1._sp) - hp*en*temp
      fhp_d = inv_cp*((1._sp-hp**2)*((fq(1)+1._sp)*pn_d+pn*fq_d(1))-pn*(&
&       fq(1)+1._sp)*2*hp*hp_d-temp*(en*hp_d+hp*en_d)-hp*en*((2._sp-hp)*&
&       fq_d(2)-(fq(2)+1._sp)*hp_d)) + temp0*inv_cp_d
      fhp = temp0*inv_cp
      dh_d(1) = hp_d - hp0_d - dt*fhp_d
      dh(1) = hp - hp0 - dt*fhp
! Range of correction for the three terms: (0, 2)
      temp0 = ht**5
      temp = ht**3.5_sp
      temp1 = 0.9_sp*(fq(1)+1._sp)*pn*(hp*hp) - 0.25_sp*(fq(4)+1._sp)*ct&
&       *temp0 + temp*kexc*(fq(3)+1._sp)
      fht_d = inv_ct*(0.9_sp*(hp**2*(pn*fq_d(1)+(fq(1)+1._sp)*pn_d)+(fq(&
&       1)+1._sp)*pn*2*hp*hp_d)-0.25_sp*(temp0*(ct*fq_d(4)+(fq(4)+1._sp)&
&       *ct_d)+(fq(4)+1._sp)*ct*5*ht**4*ht_d)+kexc*(fq(3)+1._sp)*3.5_sp*&
&       ht**2.5*ht_d+temp*((fq(3)+1._sp)*kexc_d+kexc*fq_d(3))) + temp1*&
&       inv_ct_d
      fht = temp1*inv_ct
      dh_d(2) = ht_d - ht0_d - dt*fht_d
      dh(2) = ht - ht0 - dt*fht
! 1 - dt*nabla_hp(fhp)
      temp1 = jacobian_nn_1(1)*(-(hp*hp)+1) - 2._sp*hp*(fq(1)+1._sp)
      temp0 = jacobian_nn_1(2)*hp*(-hp+2._sp) + 2._sp*(-hp+1._sp)*(fq(2)&
&       +1._sp)
      temp = pn*temp1 - en*temp0
      jacob_d(1, 1) = -(dt*(inv_cp*(temp1*pn_d+pn*((1-hp**2)*&
&       jacobian_nn_1_d(1)-jacobian_nn_1(1)*2*hp*hp_d-2._sp*((fq(1)+&
&       1._sp)*hp_d+hp*fq_d(1)))-temp0*en_d-en*((2._sp-hp)*(hp*&
&       jacobian_nn_1_d(2)+jacobian_nn_1(2)*hp_d)-jacobian_nn_1(2)*hp*&
&       hp_d+2._sp*((1._sp-hp)*fq_d(2)-(fq(2)+1._sp)*hp_d)))+temp*&
&       inv_cp_d))
      jacob(1, 1) = 1._sp - dt*(temp*inv_cp)
! -dt*nabla_ht(fhp)
      temp1 = pn*jacobian_nn_2(1)*(-(hp*hp)+1) - en*hp*jacobian_nn_2(2)*&
&       (-hp+2._sp)
      jacob_d(1, 2) = -(dt*(inv_cp*((1-hp**2)*(jacobian_nn_2(1)*pn_d+pn*&
&       jacobian_nn_2_d(1))-pn*jacobian_nn_2(1)*2*hp*hp_d-jacobian_nn_2(&
&       2)*(2._sp-hp)*(hp*en_d+en*hp_d)-en*hp*((2._sp-hp)*&
&       jacobian_nn_2_d(2)-jacobian_nn_2(2)*hp_d))+temp1*inv_cp_d))
      jacob(1, 2) = -(dt*(temp1*inv_cp))
! -dt*nabla_hp(fht)
      temp1 = 2._sp*(fq(1)+1._sp) + jacobian_nn_1(1)*hp
      temp0 = ht**5
      temp = ht**3.5_sp
      temp2 = 0.9_sp*pn*hp*temp1 - 0.25_sp*jacobian_nn_1(4)*ct*temp0 + &
&       jacobian_nn_1(3)*kexc*temp
      jacob_d(2, 1) = -(dt*(inv_ct*(0.9_sp*(temp1*(hp*pn_d+pn*hp_d)+pn*&
&       hp*(2._sp*fq_d(1)+hp*jacobian_nn_1_d(1)+jacobian_nn_1(1)*hp_d))-&
&       0.25_sp*(temp0*(ct*jacobian_nn_1_d(4)+jacobian_nn_1(4)*ct_d)+&
&       jacobian_nn_1(4)*ct*5*ht**4*ht_d)+temp*(kexc*jacobian_nn_1_d(3)+&
&       jacobian_nn_1(3)*kexc_d)+jacobian_nn_1(3)*kexc*3.5_sp*ht**2.5*&
&       ht_d)+temp2*inv_ct_d))
      jacob(2, 1) = -(dt*(temp2*inv_ct))
! 1 - dt*nabla_ht(fht)
      temp3 = ht**2.5
      temp2 = 3.5_sp*(fq(3)+1._sp) + jacobian_nn_2(3)*ht
      temp1 = ht**4
      temp0 = 1.25_sp*(fq(4)+1._sp) + 0.25_sp*jacobian_nn_2(4)*ht
      temp4 = temp2*kexc*temp3 + 0.9_sp*jacobian_nn_2(1)*pn*(hp*hp) - &
&       temp0*ct*temp1
      jacob_d(2, 2) = -(dt*(inv_ct*(temp3*(kexc*(3.5_sp*fq_d(3)+ht*&
&       jacobian_nn_2_d(3)+jacobian_nn_2(3)*ht_d)+temp2*kexc_d)+temp2*&
&       kexc*2.5*ht**1.5*ht_d+0.9_sp*(hp**2*(pn*jacobian_nn_2_d(1)+&
&       jacobian_nn_2(1)*pn_d)+jacobian_nn_2(1)*pn*2*hp*hp_d)-ct*temp1*(&
&       1.25_sp*fq_d(4)+0.25_sp*(ht*jacobian_nn_2_d(4)+jacobian_nn_2(4)*&
&       ht_d))-temp0*(temp1*ct_d+ct*4*ht**3*ht_d))+temp4*inv_ct_d))
      jacob(2, 2) = 1._sp - dt*(temp4*inv_ct)
      CALL SOLVE_LINEAR_SYSTEM_2VARS_D(jacob, jacob_d, delta_h, &
&                                delta_h_d, dh, dh_d)
      hp_d = hp_d + delta_h_d(1)
      hp = hp + delta_h(1)
      IF (hp .LE. 0._sp) THEN
        hp = 1.e-6_sp
        hp_d = 0.0_4
      END IF
      IF (hp .GE. 1._sp) THEN
        hp = 1._sp - 1.e-6_sp
        hp_d = 0.0_4
      END IF
      ht_d = ht_d + delta_h_d(2)
      ht = ht + delta_h(2)
      IF (ht .LE. 0._sp) THEN
        ht = 1.e-6_sp
        ht_d = 0.0_4
      END IF
      IF (ht .GE. 1._sp) THEN
        ht = 1._sp - 1.e-6_sp
        ht_d = 0.0_4
      END IF
      arg1 = (delta_h(1)/hp)**2 + (delta_h(2)/ht)**2
      result1 = SQRT(arg1)
      converged = result1 .LT. 1.e-6_sp
      j = j + 1
    END DO
! Range of correction kexc: (0, 2)
    temp2 = ht**3.5_sp
    l_d = temp2*(kexc*fq_d(3)+(fq(3)+1._sp)*kexc_d) + (fq(3)+1._sp)*kexc&
&     *3.5_sp*ht**2.5*ht_d
    l = (fq(3)+1._sp)*kexc*temp2
! Range of correction ct: (0, 2)
! Range of correction pn: (0, 2)
    temp2 = ht**5
    q_d = 0.25_sp*(temp2*(ct*fq_d(4)+(fq(4)+1._sp)*ct_d)+(fq(4)+1._sp)*&
&     ct*5*ht**4*ht_d) + 0.1_sp*(hp**2*(pn*fq_d(1)+(fq(1)+1._sp)*pn_d)+(&
&     fq(1)+1._sp)*pn*2*hp*hp_d) + l_d
    q = 0.25_sp*((fq(4)+1._sp)*ct*temp2) + 0.1_sp*((fq(1)+1._sp)*pn*(hp*&
&     hp)) + l
  END SUBROUTINE GR_PRODUCTION_TRANSFER_ODE_MLP_D

!  Differentiation of gr_production_transfer_ode_mlp in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: q kexc hp ht en jacobian_nn_1
!                jacobian_nn_2 fq cp pn ct
!   with respect to varying inputs: kexc hp ht en jacobian_nn_1
!                jacobian_nn_2 fq cp pn ct
  SUBROUTINE GR_PRODUCTION_TRANSFER_ODE_MLP_B(fq, fq_b, jacobian_nn_1, &
&   jacobian_nn_1_b, jacobian_nn_2, jacobian_nn_2_b, pn, pn_b, en, en_b&
&   , imperviousness, cp, cp_b, ct, ct_b, kexc, kexc_b, hp, hp_b, ht, &
&   ht_b, q, q_b, l)
    IMPLICIT NONE
! fixed NN output size
    REAL(sp), DIMENSION(4), INTENT(IN) :: fq
    REAL(sp), DIMENSION(4) :: fq_b
    INTRINSIC SIZE
! grad wrt hp
    REAL(sp), DIMENSION(SIZE(fq)), INTENT(IN) :: jacobian_nn_1
    REAL(sp), DIMENSION(SIZE(fq)) :: jacobian_nn_1_b
! grad wrt ht
    REAL(sp), DIMENSION(SIZE(fq)), INTENT(IN) :: jacobian_nn_2
    REAL(sp), DIMENSION(SIZE(fq)) :: jacobian_nn_2_b
    REAL(sp), INTENT(IN) :: en, imperviousness, cp, ct, kexc
    REAL(sp) :: en_b, cp_b, ct_b, kexc_b
    REAL(sp), INTENT(INOUT) :: pn, hp, ht, q
    REAL(sp), INTENT(INOUT) :: pn_b, hp_b, ht_b, q_b
    REAL(sp) :: l
    REAL(sp), DIMENSION(2, 2) :: jacob
    REAL(sp), DIMENSION(2, 2) :: jacob_b
    REAL(sp), DIMENSION(2) :: dh, delta_h
    REAL(sp), DIMENSION(2) :: dh_b, delta_h_b
    REAL(sp) :: inv_cp, inv_ct, hp0, ht0, dt, fhp, fht
    REAL(sp) :: inv_cp_b, inv_ct_b, hp0_b, ht0_b, fhp_b, fht_b
    LOGICAL :: converged
    INTEGER :: j
    INTEGER, SAVE :: maxiter=10
    INTRINSIC SQRT
    REAL(sp) :: arg1
    REAL(sp) :: result1
    REAL(sp) :: temp
    REAL(sp) :: temp_b
    REAL(sp) :: temp0
    REAL(sp) :: temp_b0
    REAL(sp) :: temp1
    REAL(sp) :: temp_b1
    REAL(sp) :: temp2
    REAL(sp) :: temp_b2
    REAL(sp) :: temp3
    REAL(sp) :: temp_b3
    REAL(sp) :: temp4
    REAL*4 :: temp_b4
    REAL*4 :: temp5
    REAL(sp) :: temp_b5
    INTEGER :: branch
    INTEGER :: ad_count
    INTEGER :: i
    REAL(sp) :: l_b
    inv_cp = 1._sp/cp
    inv_ct = 1._sp/ct
! impervious area percentage at cell scale applied to neutralized rainfall - no infiltration for imperviousness*pn
    pn = (1._sp-imperviousness)*pn
    dt = 1._sp
    hp0 = hp
    ht0 = ht
    converged = .false.
    j = 0
    ad_count = 0
    DO WHILE (.NOT.converged .AND. j .LT. maxiter)
! Range of correction for the two terms: (0, 2)
      fhp = ((1._sp-hp**2)*pn*(1._sp+fq(1))-hp*(2._sp-hp)*en*(1._sp+fq(2&
&       )))*inv_cp
      CALL PUSHREAL4(dh(1))
      dh(1) = hp - hp0 - dt*fhp
! Range of correction for the three terms: (0, 2)
      fht = (0.9_sp*(1._sp+fq(1))*pn*hp**2-0.25_sp*(1._sp+fq(4))*ct*ht**&
&       5+kexc*ht**3.5_sp*(1._sp+fq(3)))*inv_ct
      CALL PUSHREAL4(dh(2))
      dh(2) = ht - ht0 - dt*fht
! 1 - dt*nabla_hp(fhp)
      CALL PUSHREAL4(jacob(1, 1))
      jacob(1, 1) = 1._sp - dt*(pn*(jacobian_nn_1(1)*(1-hp**2)-2._sp*hp*&
&       (1._sp+fq(1)))-en*(jacobian_nn_1(2)*hp*(2._sp-hp)+2._sp*(1._sp-&
&       hp)*(1._sp+fq(2))))*inv_cp
! -dt*nabla_ht(fhp)
      CALL PUSHREAL4(jacob(1, 2))
      jacob(1, 2) = -(dt*(pn*jacobian_nn_2(1)*(1-hp**2)-en*jacobian_nn_2&
&       (2)*hp*(2._sp-hp))*inv_cp)
! -dt*nabla_hp(fht)
      CALL PUSHREAL4(jacob(2, 1))
      jacob(2, 1) = -(dt*(0.9_sp*pn*hp*(2._sp*(1._sp+fq(1))+&
&       jacobian_nn_1(1)*hp)-0.25_sp*jacobian_nn_1(4)*ct*ht**5+&
&       jacobian_nn_1(3)*kexc*ht**3.5_sp)*inv_ct)
! 1 - dt*nabla_ht(fht)
      CALL PUSHREAL4(jacob(2, 2))
      jacob(2, 2) = 1._sp - dt*((3.5_sp*(1._sp+fq(3))+jacobian_nn_2(3)*&
&       ht)*kexc*ht**2.5+0.9_sp*jacobian_nn_2(1)*pn*hp**2-(1.25_sp*(&
&       1._sp+fq(4))+0.25_sp*jacobian_nn_2(4)*ht)*ct*ht**4)*inv_ct
      CALL SOLVE_LINEAR_SYSTEM_2VARS(jacob, delta_h, dh)
      CALL PUSHREAL4(hp)
      hp = hp + delta_h(1)
      IF (hp .LE. 0._sp) THEN
        hp = 1.e-6_sp
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHCONTROL1B(1)
      END IF
      IF (hp .GE. 1._sp) THEN
        hp = 1._sp - 1.e-6_sp
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHCONTROL1B(1)
      END IF
      CALL PUSHREAL4(ht)
      ht = ht + delta_h(2)
      IF (ht .LE. 0._sp) THEN
        ht = 1.e-6_sp
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHCONTROL1B(1)
      END IF
      IF (ht .GE. 1._sp) THEN
        ht = 1._sp - 1.e-6_sp
        CALL PUSHCONTROL1B(0)
      ELSE
        CALL PUSHCONTROL1B(1)
      END IF
      arg1 = (delta_h(1)/hp)**2 + (delta_h(2)/ht)**2
      result1 = SQRT(arg1)
      converged = result1 .LT. 1.e-6_sp
      j = j + 1
      ad_count = ad_count + 1
    END DO
    CALL PUSHINTEGER4(ad_count)
    l_b = q_b
    temp_b5 = ht**5*0.25_sp*q_b
    ht_b = ht_b + 5*ht**4*(fq(4)+1._sp)*ct*0.25_sp*q_b + 3.5_sp*ht**2.5*&
&     (fq(3)+1._sp)*kexc*l_b
    temp_b3 = hp**2*0.1_sp*q_b
    hp_b = hp_b + 2*hp*(fq(1)+1._sp)*pn*0.1_sp*q_b
    fq_b(1) = fq_b(1) + pn*temp_b3
    pn_b = pn_b + (fq(1)+1._sp)*temp_b3
    fq_b(4) = fq_b(4) + ct*temp_b5
    ct_b = ct_b + (fq(4)+1._sp)*temp_b5
    temp_b5 = ht**3.5_sp*l_b
    fq_b(3) = fq_b(3) + kexc*temp_b5
    kexc_b = kexc_b + (fq(3)+1._sp)*temp_b5
    dt = 1._sp
    inv_cp = 1._sp/cp
    inv_ct = 1._sp/ct
    dh_b = 0.0_4
    delta_h_b = 0.0_4
    jacob_b = 0.0_4
    hp0_b = 0.0_4
    inv_cp_b = 0.0_4
    inv_ct_b = 0.0_4
    ht0_b = 0.0_4
    CALL POPINTEGER4(ad_count)
    DO i=1,ad_count
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) ht_b = 0.0_4
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) ht_b = 0.0_4
      CALL POPREAL4(ht)
      delta_h_b(2) = delta_h_b(2) + ht_b
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) hp_b = 0.0_4
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) hp_b = 0.0_4
      temp3 = ht**3.5_sp
      temp = ht**5
      CALL POPREAL4(hp)
      delta_h_b(1) = delta_h_b(1) + hp_b
      CALL SOLVE_LINEAR_SYSTEM_2VARS_B(jacob, jacob_b, delta_h, &
&                                delta_h_b, dh, dh_b)
      CALL POPREAL4(jacob(2, 2))
      temp5 = ht**2.5
      temp4 = 3.5_sp*(fq(3)+1._sp) + jacobian_nn_2(3)*ht
      temp2 = ht**4
      temp1 = ct*temp2
      temp0 = 1.25_sp*(fq(4)+1._sp) + 0.25_sp*jacobian_nn_2(4)*ht
      temp_b4 = -(inv_ct*dt*jacob_b(2, 2))
      inv_ct_b = inv_ct_b - (temp4*kexc*temp5+0.9_sp*(jacobian_nn_2(1)*&
&       pn*hp**2)-temp0*temp1)*dt*jacob_b(2, 2)
      jacob_b(2, 2) = 0.0_4
      temp_b5 = kexc*temp5*temp_b4
      kexc_b = kexc_b + temp4*temp5*temp_b4
      temp_b3 = hp**2*0.9_sp*temp_b4
      temp_b0 = -(temp1*temp_b4)
      ct_b = ct_b - temp2*temp0*temp_b4
      fq_b(4) = fq_b(4) + 1.25_sp*temp_b0
      jacobian_nn_2_b(4) = jacobian_nn_2_b(4) + ht*0.25_sp*temp_b0
      jacobian_nn_2_b(1) = jacobian_nn_2_b(1) + pn*temp_b3
      pn_b = pn_b + jacobian_nn_2(1)*temp_b3
      jacobian_nn_2_b(3) = jacobian_nn_2_b(3) + ht*temp_b5
      CALL POPREAL4(jacob(2, 1))
      temp2 = 2._sp*(fq(1)+1._sp) + jacobian_nn_1(1)*hp
      temp_b3 = -(inv_ct*dt*jacob_b(2, 1))
      ht_b = ht_b + (2.5*ht**1.5*temp4*kexc-4*ht**3*ct*temp0)*temp_b4 + &
&       jacobian_nn_2(4)*0.25_sp*temp_b0 + jacobian_nn_2(3)*temp_b5 + (&
&       3.5_sp*ht**2.5*jacobian_nn_1(3)*kexc-5*ht**4*jacobian_nn_1(4)*ct&
&       *0.25_sp)*temp_b3
      temp0 = ht**5
      temp4 = ht**3.5_sp
      temp_b1 = temp2*0.9_sp*temp_b3
      temp_b2 = pn*hp*0.9_sp*temp_b3
      hp_b = hp_b + 2*hp*jacobian_nn_2(1)*pn*0.9_sp*temp_b4 + &
&       jacobian_nn_1(1)*temp_b2 + pn*temp_b1
      temp_b = -(temp0*0.25_sp*temp_b3)
      jacobian_nn_1_b(3) = jacobian_nn_1_b(3) + kexc*temp4*temp_b3
      kexc_b = kexc_b + jacobian_nn_1(3)*temp4*temp_b3
      jacobian_nn_1_b(4) = jacobian_nn_1_b(4) + ct*temp_b
      fq_b(1) = fq_b(1) + 2._sp*temp_b2
      jacobian_nn_1_b(1) = jacobian_nn_1_b(1) + hp*temp_b2
      CALL POPREAL4(jacob(1, 2))
      temp1 = jacobian_nn_2(2)*(-hp+2._sp)
      temp_b3 = -(inv_cp*dt*jacob_b(1, 2))
      en_b = en_b - hp*temp1*temp_b3
      CALL POPREAL4(jacob(1, 1))
      CALL POPREAL4(dh(2))
      ht0_b = ht0_b - dh_b(2)
      fht_b = -(dt*dh_b(2))
      inv_ct_b = inv_ct_b + (0.9_sp*((fq(1)+1._sp)*pn*hp**2)-0.25_sp*((&
&       fq(4)+1._sp)*ct*temp)+temp3*(kexc*(fq(3)+1._sp)))*fht_b - (&
&       0.9_sp*(pn*hp*temp2)-0.25_sp*(jacobian_nn_1(4)*ct*temp0)+&
&       jacobian_nn_1(3)*kexc*temp4)*dt*jacob_b(2, 1)
      jacob_b(2, 1) = 0.0_4
      temp2 = -(hp*hp) + 1
      pn_b = pn_b + hp*temp_b1 + jacobian_nn_2(1)*temp2*temp_b3
      inv_cp_b = inv_cp_b - (pn*jacobian_nn_2(1)*temp2-en*hp*temp1)*dt*&
&       jacob_b(1, 2)
      jacob_b(1, 2) = 0.0_4
      jacobian_nn_2_b(1) = jacobian_nn_2_b(1) + pn*temp2*temp_b3
      temp_b1 = -(en*hp*temp_b3)
      hp_b = hp_b - (2*hp*pn*jacobian_nn_2(1)+en*temp1)*temp_b3 - &
&       jacobian_nn_2(2)*temp_b1
      jacobian_nn_2_b(2) = jacobian_nn_2_b(2) + (2._sp-hp)*temp_b1
      temp2 = jacobian_nn_1(1)*(-(hp*hp)+1) - 2._sp*hp*(fq(1)+1._sp)
      temp1 = jacobian_nn_1(2)*hp*(-hp+2._sp) + 2._sp*(-hp+1._sp)*(fq(2)&
&       +1._sp)
      temp_b3 = -(inv_cp*dt*jacob_b(1, 1))
      inv_cp_b = inv_cp_b - (pn*temp2-en*temp1)*dt*jacob_b(1, 1)
      jacob_b(1, 1) = 0.0_4
      temp_b2 = pn*temp_b3
      en_b = en_b - temp1*temp_b3
      temp_b1 = -(en*temp_b3)
      jacobian_nn_1_b(2) = jacobian_nn_1_b(2) + hp*(2._sp-hp)*temp_b1
      hp_b = hp_b + (jacobian_nn_1(2)*(2._sp-hp)-jacobian_nn_1(2)*hp-(fq&
&       (2)+1._sp)*2._sp)*temp_b1
      fq_b(2) = fq_b(2) + (1._sp-hp)*2._sp*temp_b1
      jacobian_nn_1_b(1) = jacobian_nn_1_b(1) + (1-hp**2)*temp_b2
      temp_b1 = inv_ct*fht_b
      fq_b(3) = fq_b(3) + 3.5_sp*temp_b5 + kexc*temp3*temp_b1
      hp_b = hp_b + 2*hp*(fq(1)+1._sp)*pn*0.9_sp*temp_b1 - (2*hp*&
&       jacobian_nn_1(1)+(fq(1)+1._sp)*2._sp)*temp_b2
      ht_b = ht_b + dh_b(2) + (3.5_sp*ht**2.5*kexc*(fq(3)+1._sp)-5*ht**4&
&       *(fq(4)+1._sp)*ct*0.25_sp)*temp_b1
      dh_b(2) = 0.0_4
      temp_b0 = hp**2*0.9_sp*temp_b1
      pn_b = pn_b + temp2*temp_b3 + (fq(1)+1._sp)*temp_b0
      fq_b(1) = fq_b(1) + pn*temp_b0 - hp*2._sp*temp_b2
      temp_b2 = -(temp*0.25_sp*temp_b1)
      ct_b = ct_b + jacobian_nn_1(4)*temp_b + (fq(4)+1._sp)*temp_b2
      kexc_b = kexc_b + (fq(3)+1._sp)*temp3*temp_b1
      fq_b(4) = fq_b(4) + ct*temp_b2
      CALL POPREAL4(dh(1))
      hp0_b = hp0_b - dh_b(1)
      fhp_b = -(dt*dh_b(1))
      temp1 = (-hp+2._sp)*(fq(2)+1._sp)
      temp_b = inv_cp*fhp_b
      inv_cp_b = inv_cp_b + ((1._sp-hp**2)*(pn*(fq(1)+1._sp))-hp*en*&
&       temp1)*fhp_b
      temp_b0 = (1._sp-hp**2)*temp_b
      en_b = en_b - hp*temp1*temp_b
      temp_b1 = -(hp*en*temp_b)
      hp_b = hp_b + dh_b(1) - (2*hp*pn*(fq(1)+1._sp)+en*temp1)*temp_b - &
&       (fq(2)+1._sp)*temp_b1
      dh_b(1) = 0.0_4
      fq_b(2) = fq_b(2) + (2._sp-hp)*temp_b1
      pn_b = pn_b + (fq(1)+1._sp)*temp_b0
      fq_b(1) = fq_b(1) + pn*temp_b0
    END DO
    ht_b = ht_b + ht0_b
    hp_b = hp_b + hp0_b
    pn_b = (1._sp-imperviousness)*pn_b
    ct_b = ct_b - inv_ct_b/ct**2
    cp_b = cp_b - inv_cp_b/cp**2
  END SUBROUTINE GR_PRODUCTION_TRANSFER_ODE_MLP_B

  SUBROUTINE GR_PRODUCTION_TRANSFER_ODE_MLP(fq, jacobian_nn_1, &
&   jacobian_nn_2, pn, en, imperviousness, cp, ct, kexc, hp, ht, q, l)
    IMPLICIT NONE
! fixed NN output size
    REAL(sp), DIMENSION(4), INTENT(IN) :: fq
    INTRINSIC SIZE
! grad wrt hp
    REAL(sp), DIMENSION(SIZE(fq)), INTENT(IN) :: jacobian_nn_1
! grad wrt ht
    REAL(sp), DIMENSION(SIZE(fq)), INTENT(IN) :: jacobian_nn_2
    REAL(sp), INTENT(IN) :: en, imperviousness, cp, ct, kexc
    REAL(sp), INTENT(INOUT) :: pn, hp, ht, q
    REAL(sp), INTENT(OUT) :: l
    REAL(sp), DIMENSION(2, 2) :: jacob
    REAL(sp), DIMENSION(2) :: dh, delta_h
    REAL(sp) :: inv_cp, inv_ct, hp0, ht0, dt, fhp, fht
    LOGICAL :: converged
    INTEGER :: j
    INTEGER, SAVE :: maxiter=10
    INTRINSIC SQRT
    REAL(sp) :: arg1
    REAL(sp) :: result1
    inv_cp = 1._sp/cp
    inv_ct = 1._sp/ct
! impervious area percentage at cell scale applied to neutralized rainfall - no infiltration for imperviousness*pn
    pn = (1._sp-imperviousness)*pn
    dt = 1._sp
    hp0 = hp
    ht0 = ht
    converged = .false.
    j = 0
    DO WHILE (.NOT.converged .AND. j .LT. maxiter)
! Range of correction for the two terms: (0, 2)
      fhp = ((1._sp-hp**2)*pn*(1._sp+fq(1))-hp*(2._sp-hp)*en*(1._sp+fq(2&
&       )))*inv_cp
      dh(1) = hp - hp0 - dt*fhp
! Range of correction for the three terms: (0, 2)
      fht = (0.9_sp*(1._sp+fq(1))*pn*hp**2-0.25_sp*(1._sp+fq(4))*ct*ht**&
&       5+kexc*ht**3.5_sp*(1._sp+fq(3)))*inv_ct
      dh(2) = ht - ht0 - dt*fht
! 1 - dt*nabla_hp(fhp)
      jacob(1, 1) = 1._sp - dt*(pn*(jacobian_nn_1(1)*(1-hp**2)-2._sp*hp*&
&       (1._sp+fq(1)))-en*(jacobian_nn_1(2)*hp*(2._sp-hp)+2._sp*(1._sp-&
&       hp)*(1._sp+fq(2))))*inv_cp
! -dt*nabla_ht(fhp)
      jacob(1, 2) = -(dt*(pn*jacobian_nn_2(1)*(1-hp**2)-en*jacobian_nn_2&
&       (2)*hp*(2._sp-hp))*inv_cp)
! -dt*nabla_hp(fht)
      jacob(2, 1) = -(dt*(0.9_sp*pn*hp*(2._sp*(1._sp+fq(1))+&
&       jacobian_nn_1(1)*hp)-0.25_sp*jacobian_nn_1(4)*ct*ht**5+&
&       jacobian_nn_1(3)*kexc*ht**3.5_sp)*inv_ct)
! 1 - dt*nabla_ht(fht)
      jacob(2, 2) = 1._sp - dt*((3.5_sp*(1._sp+fq(3))+jacobian_nn_2(3)*&
&       ht)*kexc*ht**2.5+0.9_sp*jacobian_nn_2(1)*pn*hp**2-(1.25_sp*(&
&       1._sp+fq(4))+0.25_sp*jacobian_nn_2(4)*ht)*ct*ht**4)*inv_ct
      CALL SOLVE_LINEAR_SYSTEM_2VARS(jacob, delta_h, dh)
      hp = hp + delta_h(1)
      IF (hp .LE. 0._sp) hp = 1.e-6_sp
      IF (hp .GE. 1._sp) hp = 1._sp - 1.e-6_sp
      ht = ht + delta_h(2)
      IF (ht .LE. 0._sp) ht = 1.e-6_sp
      IF (ht .GE. 1._sp) ht = 1._sp - 1.e-6_sp
      arg1 = (delta_h(1)/hp)**2 + (delta_h(2)/ht)**2
      result1 = SQRT(arg1)
      converged = result1 .LT. 1.e-6_sp
      j = j + 1
    END DO
! Range of correction kexc: (0, 2)
    l = (1._sp+fq(3))*kexc*ht**3.5_sp
! Range of correction ct: (0, 2)
! Range of correction pn: (0, 2)
    q = 0.25_sp*(1._sp+fq(4))*ct*ht**5 + 0.1_sp*(1._sp+fq(1))*pn*hp**2 +&
&     l
  END SUBROUTINE GR_PRODUCTION_TRANSFER_ODE_MLP

!  Differentiation of gr4_time_step in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: ac_qt ac_hi ac_hp ac_ht
!   with respect to varying inputs: ac_kexc ac_ci ac_cp ac_ct ac_qt
!                ac_hi ac_hp ac_ht ac_mlt
  SUBROUTINE GR4_TIME_STEP_D(setup, mesh, input_data, options, returns, &
&   time_step, ac_mlt, ac_mlt_d, ac_ci, ac_ci_d, ac_cp, ac_cp_d, ac_ct, &
&   ac_ct_d, ac_kexc, ac_kexc_d, ac_hi, ac_hi_d, ac_hp, ac_hp_d, ac_ht, &
&   ac_ht_d, ac_qt, ac_qt_d)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_kexc
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci_d, ac_cp_d, &
&   ac_ct_d, ac_kexc_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi_d, ac_hp_d, &
&   ac_ht_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_d
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_d
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, pn, en, imperviousness, pr, perc, ps, es, l, prr, &
&   prd, qr, qd
    REAL(sp) :: pn_d, en_d, pr_d, perc_d, l_d, prr_d, prd_d, qr_d, qd_d
    INTRINSIC MAX
    REAL(sp) :: temp
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp_d = ac_mlt_d
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_INTERCEPTION_D(ac_prcp(k), ac_prcp_d(k), ac_pet(k), &
&                            ac_ci(k), ac_ci_d(k), ac_hi(k), ac_hi_d(k)&
&                            , pn, pn_d, en, en_d)
            CALL GR_PRODUCTION_D(0._sp, 0.0_4, 0._sp, 0.0_4, pn, pn_d, &
&                          en, en_d, imperviousness, ac_cp(k), ac_cp_d(k&
&                          ), beta, ac_hp(k), ac_hp_d(k), pr, pr_d, perc&
&                          , perc_d, ps, es)
            CALL GR_EXCHANGE_D(0._sp, 0.0_4, ac_kexc(k), ac_kexc_d(k), &
&                        ac_ht(k), ac_ht_d(k), l, l_d)
          ELSE
            pr = 0._sp
            perc = 0._sp
            l = 0._sp
            l_d = 0.0_4
            perc_d = 0.0_4
            pr_d = 0.0_4
          END IF
          prr_d = 0.9_sp*(pr_d+perc_d) + l_d
          prr = 0.9_sp*(pr+perc) + l
          prd_d = 0.1_sp*(pr_d+perc_d)
          prd = 0.1_sp*(pr+perc)
          CALL GR_TRANSFER_D(5._sp, ac_prcp(k), prr, prr_d, ac_ct(k), &
&                      ac_ct_d(k), ac_ht(k), ac_ht_d(k), qr, qr_d)
          IF (0._sp .LT. prd + l) THEN
            qd_d = prd_d + l_d
            qd = prd + l
          ELSE
            qd = 0._sp
            qd_d = 0.0_4
          END IF
          ac_qt_d(k) = qr_d + qd_d
          ac_qt(k) = qr + qd
! Transform from mm/dt to m3/s
          temp = 1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col)
          ac_qt_d(k) = temp*ac_qt_d(k)/setup%dt
          ac_qt(k) = temp*(ac_qt(k)/setup%dt)
        END IF
      END DO
    END DO
  END SUBROUTINE GR4_TIME_STEP_D

!  Differentiation of gr4_time_step in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: ac_kexc ac_ci ac_cp ac_ct ac_qt
!                ac_hi ac_hp ac_ht ac_mlt
!   with respect to varying inputs: ac_kexc ac_ci ac_cp ac_ct ac_qt
!                ac_hi ac_hp ac_ht ac_mlt
  SUBROUTINE GR4_TIME_STEP_B(setup, mesh, input_data, options, returns, &
&   time_step, ac_mlt, ac_mlt_b, ac_ci, ac_ci_b, ac_cp, ac_cp_b, ac_ct, &
&   ac_ct_b, ac_kexc, ac_kexc_b, ac_hi, ac_hi_b, ac_hp, ac_hp_b, ac_ht, &
&   ac_ht_b, ac_qt, ac_qt_b)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac) :: ac_mlt_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_kexc
    REAL(sp), DIMENSION(mesh%nac) :: ac_ci_b, ac_cp_b, ac_ct_b, &
&   ac_kexc_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi_b, ac_hp_b, &
&   ac_ht_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_b
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_b
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, pn, en, imperviousness, pr, perc, ps, es, l, prr, &
&   prd, qr, qd
    REAL(sp) :: pn_b, en_b, pr_b, perc_b, l_b, prr_b, prd_b, qr_b, qd_b
    INTRINSIC MAX
    REAL(sp) :: dummydiff_b
    REAL(sp) :: dummydiff_b0
    REAL(sp) :: dummydiff_b1
    INTEGER :: branch
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL1B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4(en)
            CALL PUSHREAL4(ac_hi(k))
            CALL GR_INTERCEPTION(ac_prcp(k), ac_pet(k), ac_ci(k), ac_hi(&
&                          k), pn, en)
            CALL PUSHREAL4(ac_hp(k))
            CALL PUSHREAL4(pn)
            CALL GR_PRODUCTION(0._sp, 0._sp, pn, en, imperviousness, &
&                        ac_cp(k), beta, ac_hp(k), pr, perc, ps, es)
            CALL GR_EXCHANGE(0._sp, ac_kexc(k), ac_ht(k), l)
            CALL PUSHCONTROL1B(1)
          ELSE
            CALL PUSHCONTROL1B(0)
            pr = 0._sp
            perc = 0._sp
            l = 0._sp
          END IF
          CALL PUSHREAL4(prr)
          prr = 0.9_sp*(pr+perc) + l
          prd = 0.1_sp*(pr+perc)
          CALL PUSHREAL4(ac_ht(k))
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prr, ac_ct(k), ac_ht(k), &
&                    qr)
          IF (0._sp .LT. prd + l) THEN
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHCONTROL1B(1)
          END IF
          CALL PUSHCONTROL1B(1)
        END IF
      END DO
    END DO
    ac_prcp_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          ac_qt_b(k) = mesh%dx(row, col)*1e-3_sp*mesh%dy(row, col)*&
&           ac_qt_b(k)/setup%dt
          qr_b = ac_qt_b(k)
          qd_b = ac_qt_b(k)
          ac_qt_b(k) = 0.0_4
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            prd_b = qd_b
            l_b = qd_b
          ELSE
            l_b = 0.0_4
            prd_b = 0.0_4
          END IF
          CALL POPREAL4(ac_ht(k))
          CALL GR_TRANSFER_B(5._sp, ac_prcp(k), prr, prr_b, ac_ct(k), &
&                      ac_ct_b(k), ac_ht(k), ac_ht_b(k), qr, qr_b)
          pr_b = 0.1_sp*prd_b + 0.9_sp*prr_b
          perc_b = 0.1_sp*prd_b + 0.9_sp*prr_b
          CALL POPREAL4(prr)
          l_b = l_b + prr_b
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) THEN
            CALL GR_EXCHANGE_B(0._sp, dummydiff_b1, ac_kexc(k), &
&                        ac_kexc_b(k), ac_ht(k), ac_ht_b(k), l, l_b)
            imperviousness = input_data%physio_data%imperviousness(row, &
&             col)
            CALL POPREAL4(pn)
            CALL POPREAL4(ac_hp(k))
            pn_b = 0.0_4
            en_b = 0.0_4
            CALL GR_PRODUCTION_B(0._sp, dummydiff_b, 0._sp, dummydiff_b0&
&                          , pn, pn_b, en, en_b, imperviousness, ac_cp(k&
&                          ), ac_cp_b(k), beta, ac_hp(k), ac_hp_b(k), pr&
&                          , pr_b, perc, perc_b, ps, es)
            CALL POPREAL4(ac_hi(k))
            CALL POPREAL4(en)
            CALL GR_INTERCEPTION_B(ac_prcp(k), ac_prcp_b(k), ac_pet(k), &
&                            ac_ci(k), ac_ci_b(k), ac_hi(k), ac_hi_b(k)&
&                            , pn, pn_b, en, en_b)
          END IF
        END IF
      END DO
    END DO
    ac_mlt_b = ac_mlt_b + ac_prcp_b
  END SUBROUTINE GR4_TIME_STEP_B

  SUBROUTINE GR4_TIME_STEP(setup, mesh, input_data, options, returns, &
&   time_step, ac_mlt, ac_ci, ac_cp, ac_ct, ac_kexc, ac_hi, ac_hp, ac_ht&
&   , ac_qt)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_kexc
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, pn, en, imperviousness, pr, perc, ps, es, l, prr, &
&   prd, qr, qd
    INTRINSIC MAX
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_INTERCEPTION(ac_prcp(k), ac_pet(k), ac_ci(k), ac_hi(&
&                          k), pn, en)
            CALL GR_PRODUCTION(0._sp, 0._sp, pn, en, imperviousness, &
&                        ac_cp(k), beta, ac_hp(k), pr, perc, ps, es)
            CALL GR_EXCHANGE(0._sp, ac_kexc(k), ac_ht(k), l)
          ELSE
            pr = 0._sp
            perc = 0._sp
            l = 0._sp
          END IF
          prr = 0.9_sp*(pr+perc) + l
          prd = 0.1_sp*(pr+perc)
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prr, ac_ct(k), ac_ht(k), &
&                    qr)
          IF (0._sp .LT. prd + l) THEN
            qd = prd + l
          ELSE
            qd = 0._sp
          END IF
          ac_qt(k) = qr + qd
! Transform from mm/dt to m3/s
          ac_qt(k) = ac_qt(k)*1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col&
&           )/setup%dt
        END IF
      END DO
    END DO
  END SUBROUTINE GR4_TIME_STEP

!  Differentiation of gr4_mlp_time_step in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: ac_qt ac_hi ac_hp ac_ht
!   with respect to varying inputs: ac_kexc ac_ci ac_cp ac_ct bias_1
!                bias_2 bias_3 ac_qt ac_hi ac_hp weight_1 weight_2
!                weight_3 ac_ht ac_mlt
  SUBROUTINE GR4_MLP_TIME_STEP_D(setup, mesh, input_data, options, &
&   returns, time_step, weight_1, weight_1_d, bias_1, bias_1_d, weight_2&
&   , weight_2_d, bias_2, bias_2_d, weight_3, weight_3_d, bias_3, &
&   bias_3_d, ac_mlt, ac_mlt_d, ac_ci, ac_ci_d, ac_cp, ac_cp_d, ac_ct, &
&   ac_ct_d, ac_kexc, ac_kexc_d, ac_hi, ac_hi_d, ac_hp, ac_hp_d, ac_ht, &
&   ac_ht_d, ac_qt, ac_qt_d)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1_d
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1_d
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2_d
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2_d
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3_d
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_kexc
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci_d, ac_cp_d, &
&   ac_ct_d, ac_kexc_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi_d, ac_hp_d, &
&   ac_ht_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_d
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer_d
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer_d
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet, pn, en
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_d, pn_d, en_d
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, imperviousness, pr, perc, ps, es, l, prr, prd, qr&
&   , qd
    REAL(sp) :: pr_d, perc_d, l_d, prr_d, prd_d, qr_d, qd_d
    INTRINSIC MAX
    REAL(sp) :: temp
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp_d = ac_mlt_d
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
    en_d = 0.0_4
    pn_d = 0.0_4
! Interception with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_INTERCEPTION_D(ac_prcp(k), ac_prcp_d(k), ac_pet(k), &
&                            ac_ci(k), ac_ci_d(k), ac_hi(k), ac_hi_d(k)&
&                            , pn(k), pn_d(k), en(k), en_d(k))
          ELSE
            pn_d(k) = 0.0_4
            pn(k) = 0._sp
            en_d(k) = 0.0_4
            en(k) = 0._sp
          END IF
        END IF
      END DO
    END DO
    output_layer_d = 0.0_4
! Forward MLP without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            input_layer_d(:) = (/ac_hp_d(k), ac_ht_d(k), pn_d(k), en_d(k&
&             )/)
            input_layer(:) = (/ac_hp(k), ac_ht(k), pn(k), en(k)/)
            CALL FORWARD_MLP_D(weight_1, weight_1_d, bias_1, bias_1_d, &
&                        weight_2, weight_2_d, bias_2, bias_2_d, &
&                        weight_3, weight_3_d, bias_3, bias_3_d, &
&                        input_layer, input_layer_d, output_layer(:, k)&
&                        , output_layer_d(:, k))
          ELSE
            output_layer_d(:, k) = 0.0_4
            output_layer(:, k) = 0._sp
          END IF
        END IF
      END DO
    END DO
! Production and transfer with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_PRODUCTION_D(output_layer(1, k), output_layer_d(1, k&
&                          ), output_layer(2, k), output_layer_d(2, k), &
&                          pn(k), pn_d(k), en(k), en_d(k), &
&                          imperviousness, ac_cp(k), ac_cp_d(k), beta, &
&                          ac_hp(k), ac_hp_d(k), pr, pr_d, perc, perc_d&
&                          , ps, es)
            CALL GR_EXCHANGE_D(output_layer(4, k), output_layer_d(4, k)&
&                        , ac_kexc(k), ac_kexc_d(k), ac_ht(k), ac_ht_d(k&
&                        ), l, l_d)
          ELSE
            pr = 0._sp
            perc = 0._sp
            l = 0._sp
            l_d = 0.0_4
            perc_d = 0.0_4
            pr_d = 0.0_4
          END IF
! Range of correction c0.9: (1, 0)
          temp = -(output_layer(3, k)*output_layer(3, k)) + 1._sp
          prr_d = 0.9_sp*(temp*(pr_d+perc_d)-(pr+perc)*2*output_layer(3&
&           , k)*output_layer_d(3, k)) + l_d
          prr = 0.9_sp*(temp*(pr+perc)) + l
! Range of correction c0.1: (1, 10)
          temp = 0.9_sp*(output_layer(3, k)*output_layer(3, k)) + 0.1_sp
          prd_d = (pr+perc)*0.9_sp*2*output_layer(3, k)*output_layer_d(3&
&           , k) + temp*(pr_d+perc_d)
          prd = temp*(pr+perc)
          CALL GR_TRANSFER_D(5._sp, ac_prcp(k), prr, prr_d, ac_ct(k), &
&                      ac_ct_d(k), ac_ht(k), ac_ht_d(k), qr, qr_d)
          IF (0._sp .LT. prd + l) THEN
            qd_d = prd_d + l_d
            qd = prd + l
          ELSE
            qd = 0._sp
            qd_d = 0.0_4
          END IF
          ac_qt_d(k) = qr_d + qd_d
          ac_qt(k) = qr + qd
! Transform from mm/dt to m3/s
          temp = 1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col)
          ac_qt_d(k) = temp*ac_qt_d(k)/setup%dt
          ac_qt(k) = temp*(ac_qt(k)/setup%dt)
        END IF
      END DO
    END DO
  END SUBROUTINE GR4_MLP_TIME_STEP_D

!  Differentiation of gr4_mlp_time_step in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: ac_kexc ac_ci ac_cp ac_ct bias_1
!                bias_2 bias_3 ac_qt ac_hi ac_hp weight_1 weight_2
!                weight_3 ac_ht ac_mlt
!   with respect to varying inputs: ac_kexc ac_ci ac_cp ac_ct bias_1
!                bias_2 bias_3 ac_qt ac_hi ac_hp weight_1 weight_2
!                weight_3 ac_ht ac_mlt
  SUBROUTINE GR4_MLP_TIME_STEP_B(setup, mesh, input_data, options, &
&   returns, time_step, weight_1, weight_1_b, bias_1, bias_1_b, weight_2&
&   , weight_2_b, bias_2, bias_2_b, weight_3, weight_3_b, bias_3, &
&   bias_3_b, ac_mlt, ac_mlt_b, ac_ci, ac_ci_b, ac_cp, ac_cp_b, ac_ct, &
&   ac_ct_b, ac_kexc, ac_kexc_b, ac_hi, ac_hi_b, ac_hp, ac_hp_b, ac_ht, &
&   ac_ht_b, ac_qt, ac_qt_b)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)) :: &
&   weight_1_b
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(setup%neurons(2)) :: bias_1_b
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)) :: &
&   weight_2_b
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(setup%neurons(3)) :: bias_2_b
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)) :: &
&   weight_3_b
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(setup%neurons(4)) :: bias_3_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac) :: ac_mlt_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_kexc
    REAL(sp), DIMENSION(mesh%nac) :: ac_ci_b, ac_cp_b, ac_ct_b, &
&   ac_kexc_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi_b, ac_hp_b, &
&   ac_ht_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_b
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer_b
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer_b
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet, pn, en
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_b, pn_b, en_b
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, imperviousness, pr, perc, ps, es, l, prr, prd, qr&
&   , qd
    REAL(sp) :: pr_b, perc_b, l_b, prr_b, prd_b, qr_b, qd_b
    INTRINSIC MAX
    REAL(sp) :: temp_b
    INTEGER :: branch
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
! Interception with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL2B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4(ac_hi(k))
            CALL GR_INTERCEPTION(ac_prcp(k), ac_pet(k), ac_ci(k), ac_hi(&
&                          k), pn(k), en(k))
            CALL PUSHCONTROL2B(2)
          ELSE
            pn(k) = 0._sp
            en(k) = 0._sp
            CALL PUSHCONTROL2B(1)
          END IF
        END IF
      END DO
    END DO
! Forward MLP without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL2B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4ARRAY(input_layer, setup%neurons(1))
            input_layer(:) = (/ac_hp(k), ac_ht(k), pn(k), en(k)/)
            CALL FORWARD_MLP(weight_1, bias_1, weight_2, bias_2, &
&                      weight_3, bias_3, input_layer, output_layer(:, k)&
&                     )
            CALL PUSHCONTROL2B(2)
          ELSE
            output_layer(:, k) = 0._sp
            CALL PUSHCONTROL2B(1)
          END IF
        END IF
      END DO
    END DO
! Production and transfer with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHINTEGER4(k)
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4(perc)
            CALL PUSHREAL4(pr)
            CALL PUSHREAL4(ac_hp(k))
            CALL PUSHREAL4(pn(k))
            CALL GR_PRODUCTION(output_layer(1, k), output_layer(2, k), &
&                        pn(k), en(k), imperviousness, ac_cp(k), beta, &
&                        ac_hp(k), pr, perc, ps, es)
            CALL GR_EXCHANGE(output_layer(4, k), ac_kexc(k), ac_ht(k), l&
&                     )
            CALL PUSHCONTROL1B(1)
          ELSE
            CALL PUSHREAL4(pr)
            pr = 0._sp
            CALL PUSHREAL4(perc)
            perc = 0._sp
            l = 0._sp
            CALL PUSHCONTROL1B(0)
          END IF
! Range of correction c0.9: (1, 0)
          CALL PUSHREAL4(prr)
          prr = 0.9_sp*(1._sp-output_layer(3, k)**2)*(pr+perc) + l
! Range of correction c0.1: (1, 10)
          prd = (0.1_sp+0.9_sp*output_layer(3, k)**2)*(pr+perc)
          CALL PUSHREAL4(ac_ht(k))
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prr, ac_ct(k), ac_ht(k), &
&                    qr)
          IF (0._sp .LT. prd + l) THEN
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHCONTROL1B(1)
          END IF
          CALL PUSHCONTROL1B(1)
        END IF
      END DO
    END DO
    output_layer_b = 0.0_4
    en_b = 0.0_4
    pn_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) THEN
          ac_qt_b(k) = mesh%dx(row, col)*1e-3_sp*mesh%dy(row, col)*&
&           ac_qt_b(k)/setup%dt
          qr_b = ac_qt_b(k)
          qd_b = ac_qt_b(k)
          ac_qt_b(k) = 0.0_4
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            prd_b = qd_b
            l_b = qd_b
          ELSE
            l_b = 0.0_4
            prd_b = 0.0_4
          END IF
          CALL POPREAL4(ac_ht(k))
          CALL GR_TRANSFER_B(5._sp, ac_prcp(k), prr, prr_b, ac_ct(k), &
&                      ac_ct_b(k), ac_ht(k), ac_ht_b(k), qr, qr_b)
          output_layer_b(3, k) = output_layer_b(3, k) + 2*output_layer(3&
&           , k)*0.9_sp*(pr+perc)*prd_b - 2*output_layer(3, k)*(pr+perc)&
&           *0.9_sp*prr_b
          temp_b = (0.9_sp*output_layer(3, k)**2+0.1_sp)*prd_b
          pr_b = temp_b
          perc_b = temp_b
          CALL POPREAL4(prr)
          temp_b = (1._sp-output_layer(3, k)**2)*0.9_sp*prr_b
          l_b = l_b + prr_b
          pr_b = pr_b + temp_b
          perc_b = perc_b + temp_b
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            CALL POPREAL4(perc)
            CALL POPREAL4(pr)
          ELSE
            CALL GR_EXCHANGE_B(output_layer(4, k), output_layer_b(4, k)&
&                        , ac_kexc(k), ac_kexc_b(k), ac_ht(k), ac_ht_b(k&
&                        ), l, l_b)
            imperviousness = input_data%physio_data%imperviousness(row, &
&             col)
            CALL POPREAL4(pn(k))
            CALL POPREAL4(ac_hp(k))
            CALL POPREAL4(pr)
            CALL POPREAL4(perc)
            CALL GR_PRODUCTION_B(output_layer(1, k), output_layer_b(1, k&
&                          ), output_layer(2, k), output_layer_b(2, k), &
&                          pn(k), pn_b(k), en(k), en_b(k), &
&                          imperviousness, ac_cp(k), ac_cp_b(k), beta, &
&                          ac_hp(k), ac_hp_b(k), pr, pr_b, perc, perc_b&
&                          , ps, es)
          END IF
          CALL POPINTEGER4(k)
        END IF
      END DO
    END DO
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL2B(branch)
        IF (branch .NE. 0) THEN
          IF (branch .EQ. 1) THEN
            k = mesh%rowcol_to_ind_ac(row, col)
            output_layer_b(:, k) = 0.0_4
          ELSE
            k = mesh%rowcol_to_ind_ac(row, col)
            CALL FORWARD_MLP_B(weight_1, weight_1_b, bias_1, bias_1_b, &
&                        weight_2, weight_2_b, bias_2, bias_2_b, &
&                        weight_3, weight_3_b, bias_3, bias_3_b, &
&                        input_layer, input_layer_b, output_layer(:, k)&
&                        , output_layer_b(:, k))
            output_layer_b(:, k) = 0.0_4
            CALL POPREAL4ARRAY(input_layer, setup%neurons(1))
            ac_hp_b(k) = ac_hp_b(k) + input_layer_b(1)
            ac_ht_b(k) = ac_ht_b(k) + input_layer_b(2)
            pn_b(k) = pn_b(k) + input_layer_b(3)
            en_b(k) = en_b(k) + input_layer_b(4)
          END IF
        END IF
      END DO
    END DO
    ac_prcp_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL2B(branch)
        IF (branch .NE. 0) THEN
          IF (branch .EQ. 1) THEN
            k = mesh%rowcol_to_ind_ac(row, col)
            en_b(k) = 0.0_4
            pn_b(k) = 0.0_4
          ELSE
            k = mesh%rowcol_to_ind_ac(row, col)
            CALL POPREAL4(ac_hi(k))
            CALL GR_INTERCEPTION_B(ac_prcp(k), ac_prcp_b(k), ac_pet(k), &
&                            ac_ci(k), ac_ci_b(k), ac_hi(k), ac_hi_b(k)&
&                            , pn(k), pn_b(k), en(k), en_b(k))
            pn_b(k) = 0.0_4
            en_b(k) = 0.0_4
          END IF
        END IF
      END DO
    END DO
    ac_mlt_b = ac_mlt_b + ac_prcp_b
  END SUBROUTINE GR4_MLP_TIME_STEP_B

  SUBROUTINE GR4_MLP_TIME_STEP(setup, mesh, input_data, options, returns&
&   , time_step, weight_1, bias_1, weight_2, bias_2, weight_3, bias_3, &
&   ac_mlt, ac_ci, ac_cp, ac_ct, ac_kexc, ac_hi, ac_hp, ac_ht, ac_qt)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_kexc
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet, pn, en
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, imperviousness, pr, perc, ps, es, l, prr, prd, qr&
&   , qd
    INTRINSIC MAX
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
! Interception with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_INTERCEPTION(ac_prcp(k), ac_pet(k), ac_ci(k), ac_hi(&
&                          k), pn(k), en(k))
          ELSE
            pn(k) = 0._sp
            en(k) = 0._sp
          END IF
        END IF
      END DO
    END DO
! Forward MLP without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            input_layer(:) = (/ac_hp(k), ac_ht(k), pn(k), en(k)/)
            CALL FORWARD_MLP(weight_1, bias_1, weight_2, bias_2, &
&                      weight_3, bias_3, input_layer, output_layer(:, k)&
&                     )
          ELSE
            output_layer(:, k) = 0._sp
          END IF
        END IF
      END DO
    END DO
! Production and transfer with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_PRODUCTION(output_layer(1, k), output_layer(2, k), &
&                        pn(k), en(k), imperviousness, ac_cp(k), beta, &
&                        ac_hp(k), pr, perc, ps, es)
            CALL GR_EXCHANGE(output_layer(4, k), ac_kexc(k), ac_ht(k), l&
&                     )
          ELSE
            pr = 0._sp
            perc = 0._sp
            l = 0._sp
          END IF
! Range of correction c0.9: (1, 0)
          prr = 0.9_sp*(1._sp-output_layer(3, k)**2)*(pr+perc) + l
! Range of correction c0.1: (1, 10)
          prd = (0.1_sp+0.9_sp*output_layer(3, k)**2)*(pr+perc)
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prr, ac_ct(k), ac_ht(k), &
&                    qr)
          IF (0._sp .LT. prd + l) THEN
            qd = prd + l
          ELSE
            qd = 0._sp
          END IF
          ac_qt(k) = qr + qd
! Transform from mm/dt to m3/s
          ac_qt(k) = ac_qt(k)*1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col&
&           )/setup%dt
        END IF
      END DO
    END DO
  END SUBROUTINE GR4_MLP_TIME_STEP

!  Differentiation of gr4_ri_time_step in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: ac_qt ac_hi ac_hp ac_ht
!   with respect to varying inputs: ac_kexc ac_ci ac_cp ac_ct ac_alpha1
!                ac_alpha2 ac_qt ac_hi ac_hp ac_ht ac_mlt
  SUBROUTINE GR4_RI_TIME_STEP_D(setup, mesh, input_data, options, &
&   returns, time_step, ac_mlt, ac_mlt_d, ac_ci, ac_ci_d, ac_cp, ac_cp_d&
&   , ac_ct, ac_ct_d, ac_alpha1, ac_alpha1_d, ac_alpha2, ac_alpha2_d, &
&   ac_kexc, ac_kexc_d, ac_hi, ac_hi_d, ac_hp, ac_hp_d, ac_ht, ac_ht_d, &
&   ac_qt, ac_qt_d)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_kexc
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci_d, ac_cp_d, &
&   ac_ct_d, ac_kexc_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_alpha1, ac_alpha2
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_alpha1_d, &
&   ac_alpha2_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi_d, ac_hp_d, &
&   ac_ht_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_d
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_d
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, pn, en, imperviousness, pr, perc, ps, es, l, prr, &
&   prd, qr, qd, split
    REAL(sp) :: pn_d, en_d, pr_d, perc_d, l_d, prr_d, prd_d, qr_d, qd_d&
&   , split_d
    INTRINSIC TANH
    INTRINSIC MAX
    REAL(sp) :: temp
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp_d = ac_mlt_d
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
    pn_d = 0.0_4
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_INTERCEPTION_D(ac_prcp(k), ac_prcp_d(k), ac_pet(k), &
&                            ac_ci(k), ac_ci_d(k), ac_hi(k), ac_hi_d(k)&
&                            , pn, pn_d, en, en_d)
            CALL GR_RI_PRODUCTION_D(pn, pn_d, en, en_d, imperviousness, &
&                             ac_cp(k), ac_cp_d(k), beta, ac_alpha1(k), &
&                             ac_alpha1_d(k), ac_hp(k), ac_hp_d(k), pr, &
&                             pr_d, perc, perc_d, ps, es, setup%dt)
            CALL GR_EXCHANGE_D(0._sp, 0.0_4, ac_kexc(k), ac_kexc_d(k), &
&                        ac_ht(k), ac_ht_d(k), l, l_d)
          ELSE
            pr = 0._sp
            perc = 0._sp
            l = 0._sp
            l_d = 0.0_4
            perc_d = 0.0_4
            pr_d = 0.0_4
          END IF
          split_d = 0.9_sp*2*TANH(ac_alpha2(k)*pn)*(1.0-TANH(ac_alpha2(k&
&           )*pn)**2)*(pn*ac_alpha2_d(k)+ac_alpha2(k)*pn_d)
          split = 0.9_sp*TANH(ac_alpha2(k)*pn)**2 + 0.1_sp
          prr_d = (1._sp-split)*(pr_d+perc_d) - (pr+perc)*split_d + l_d
          prr = (1._sp-split)*(pr+perc) + l
          prd_d = (pr+perc)*split_d + split*(pr_d+perc_d)
          prd = split*(pr+perc)
          CALL GR_TRANSFER_D(5._sp, ac_prcp(k), prr, prr_d, ac_ct(k), &
&                      ac_ct_d(k), ac_ht(k), ac_ht_d(k), qr, qr_d)
          IF (0._sp .LT. prd + l) THEN
            qd_d = prd_d + l_d
            qd = prd + l
          ELSE
            qd = 0._sp
            qd_d = 0.0_4
          END IF
          ac_qt_d(k) = qr_d + qd_d
          ac_qt(k) = qr + qd
! Transform from mm/dt to m3/s
          temp = 1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col)
          ac_qt_d(k) = temp*ac_qt_d(k)/setup%dt
          ac_qt(k) = temp*(ac_qt(k)/setup%dt)
        END IF
      END DO
    END DO
  END SUBROUTINE GR4_RI_TIME_STEP_D

!  Differentiation of gr4_ri_time_step in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: ac_kexc ac_ci ac_cp ac_ct ac_alpha1
!                ac_alpha2 ac_qt ac_hi ac_hp ac_ht ac_mlt
!   with respect to varying inputs: ac_kexc ac_ci ac_cp ac_ct ac_alpha1
!                ac_alpha2 ac_qt ac_hi ac_hp ac_ht ac_mlt
  SUBROUTINE GR4_RI_TIME_STEP_B(setup, mesh, input_data, options, &
&   returns, time_step, ac_mlt, ac_mlt_b, ac_ci, ac_ci_b, ac_cp, ac_cp_b&
&   , ac_ct, ac_ct_b, ac_alpha1, ac_alpha1_b, ac_alpha2, ac_alpha2_b, &
&   ac_kexc, ac_kexc_b, ac_hi, ac_hi_b, ac_hp, ac_hp_b, ac_ht, ac_ht_b, &
&   ac_qt, ac_qt_b)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac) :: ac_mlt_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_kexc
    REAL(sp), DIMENSION(mesh%nac) :: ac_ci_b, ac_cp_b, ac_ct_b, &
&   ac_kexc_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_alpha1, ac_alpha2
    REAL(sp), DIMENSION(mesh%nac) :: ac_alpha1_b, ac_alpha2_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi_b, ac_hp_b, &
&   ac_ht_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_b
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_b
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, pn, en, imperviousness, pr, perc, ps, es, l, prr, &
&   prd, qr, qd, split
    REAL(sp) :: pn_b, en_b, pr_b, perc_b, l_b, prr_b, prd_b, qr_b, qd_b&
&   , split_b
    INTRINSIC TANH
    INTRINSIC MAX
    REAL(sp) :: dummydiff_b
    REAL(sp) :: temp_b
    INTEGER :: branch
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL1B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4(en)
            CALL PUSHREAL4(pn)
            CALL PUSHREAL4(ac_hi(k))
            CALL GR_INTERCEPTION(ac_prcp(k), ac_pet(k), ac_ci(k), ac_hi(&
&                          k), pn, en)
            CALL PUSHREAL4(perc)
            CALL PUSHREAL4(pr)
            CALL PUSHREAL4(ac_hp(k))
            CALL PUSHREAL4(pn)
            CALL GR_RI_PRODUCTION(pn, en, imperviousness, ac_cp(k), beta&
&                           , ac_alpha1(k), ac_hp(k), pr, perc, ps, es, &
&                           setup%dt)
            CALL GR_EXCHANGE(0._sp, ac_kexc(k), ac_ht(k), l)
            CALL PUSHCONTROL1B(1)
          ELSE
            CALL PUSHREAL4(pr)
            pr = 0._sp
            CALL PUSHREAL4(perc)
            perc = 0._sp
            l = 0._sp
            CALL PUSHCONTROL1B(0)
          END IF
          CALL PUSHREAL4(split)
          split = 0.9_sp*TANH(ac_alpha2(k)*pn)**2 + 0.1_sp
          CALL PUSHREAL4(prr)
          prr = (1._sp-split)*(pr+perc) + l
          prd = split*(pr+perc)
          CALL PUSHREAL4(ac_ht(k))
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prr, ac_ct(k), ac_ht(k), &
&                    qr)
          IF (0._sp .LT. prd + l) THEN
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHCONTROL1B(1)
          END IF
          CALL PUSHCONTROL1B(1)
        END IF
      END DO
    END DO
    ac_prcp_b = 0.0_4
    pn_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          ac_qt_b(k) = mesh%dx(row, col)*1e-3_sp*mesh%dy(row, col)*&
&           ac_qt_b(k)/setup%dt
          qr_b = ac_qt_b(k)
          qd_b = ac_qt_b(k)
          ac_qt_b(k) = 0.0_4
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            prd_b = qd_b
            l_b = qd_b
          ELSE
            l_b = 0.0_4
            prd_b = 0.0_4
          END IF
          CALL POPREAL4(ac_ht(k))
          CALL GR_TRANSFER_B(5._sp, ac_prcp(k), prr, prr_b, ac_ct(k), &
&                      ac_ct_b(k), ac_ht(k), ac_ht_b(k), qr, qr_b)
          split_b = (pr+perc)*prd_b - (pr+perc)*prr_b
          pr_b = split*prd_b + (1._sp-split)*prr_b
          perc_b = split*prd_b + (1._sp-split)*prr_b
          CALL POPREAL4(prr)
          l_b = l_b + prr_b
          CALL POPREAL4(split)
          temp_b = (1.0-TANH(ac_alpha2(k)*pn)**2)*2*TANH(ac_alpha2(k)*pn&
&           )*0.9_sp*split_b
          ac_alpha2_b(k) = ac_alpha2_b(k) + pn*temp_b
          pn_b = pn_b + ac_alpha2(k)*temp_b
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            CALL POPREAL4(perc)
            CALL POPREAL4(pr)
          ELSE
            CALL GR_EXCHANGE_B(0._sp, dummydiff_b, ac_kexc(k), ac_kexc_b&
&                        (k), ac_ht(k), ac_ht_b(k), l, l_b)
            imperviousness = input_data%physio_data%imperviousness(row, &
&             col)
            CALL POPREAL4(pn)
            CALL POPREAL4(ac_hp(k))
            CALL POPREAL4(pr)
            CALL POPREAL4(perc)
            CALL GR_RI_PRODUCTION_B(pn, pn_b, en, en_b, imperviousness, &
&                             ac_cp(k), ac_cp_b(k), beta, ac_alpha1(k), &
&                             ac_alpha1_b(k), ac_hp(k), ac_hp_b(k), pr, &
&                             pr_b, perc, perc_b, ps, es, setup%dt)
            CALL POPREAL4(ac_hi(k))
            CALL POPREAL4(pn)
            CALL POPREAL4(en)
            CALL GR_INTERCEPTION_B(ac_prcp(k), ac_prcp_b(k), ac_pet(k), &
&                            ac_ci(k), ac_ci_b(k), ac_hi(k), ac_hi_b(k)&
&                            , pn, pn_b, en, en_b)
            pn_b = 0.0_4
          END IF
        END IF
      END DO
    END DO
    ac_mlt_b = ac_mlt_b + ac_prcp_b
  END SUBROUTINE GR4_RI_TIME_STEP_B

  SUBROUTINE GR4_RI_TIME_STEP(setup, mesh, input_data, options, returns&
&   , time_step, ac_mlt, ac_ci, ac_cp, ac_ct, ac_alpha1, ac_alpha2, &
&   ac_kexc, ac_hi, ac_hp, ac_ht, ac_qt)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_kexc
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_alpha1, ac_alpha2
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, pn, en, imperviousness, pr, perc, ps, es, l, prr, &
&   prd, qr, qd, split
    INTRINSIC TANH
    INTRINSIC MAX
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_INTERCEPTION(ac_prcp(k), ac_pet(k), ac_ci(k), ac_hi(&
&                          k), pn, en)
            CALL GR_RI_PRODUCTION(pn, en, imperviousness, ac_cp(k), beta&
&                           , ac_alpha1(k), ac_hp(k), pr, perc, ps, es, &
&                           setup%dt)
            CALL GR_EXCHANGE(0._sp, ac_kexc(k), ac_ht(k), l)
          ELSE
            pr = 0._sp
            perc = 0._sp
            l = 0._sp
          END IF
          split = 0.9_sp*TANH(ac_alpha2(k)*pn)**2 + 0.1_sp
          prr = (1._sp-split)*(pr+perc) + l
          prd = split*(pr+perc)
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prr, ac_ct(k), ac_ht(k), &
&                    qr)
          IF (0._sp .LT. prd + l) THEN
            qd = prd + l
          ELSE
            qd = 0._sp
          END IF
          ac_qt(k) = qr + qd
! Transform from mm/dt to m3/s
          ac_qt(k) = ac_qt(k)*1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col&
&           )/setup%dt
        END IF
      END DO
    END DO
  END SUBROUTINE GR4_RI_TIME_STEP

!  Differentiation of gr4_ode_time_step in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: ac_qt ac_hi ac_hp ac_ht
!   with respect to varying inputs: ac_kexc ac_ci ac_cp ac_ct ac_qt
!                ac_hi ac_hp ac_ht ac_mlt
  SUBROUTINE GR4_ODE_TIME_STEP_D(setup, mesh, input_data, options, &
&   returns, time_step, ac_mlt, ac_mlt_d, ac_ci, ac_ci_d, ac_cp, ac_cp_d&
&   , ac_ct, ac_ct_d, ac_kexc, ac_kexc_d, ac_hi, ac_hi_d, ac_hp, ac_hp_d&
&   , ac_ht, ac_ht_d, ac_qt, ac_qt_d)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_kexc
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci_d, ac_cp_d, &
&   ac_ct_d, ac_kexc_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi_d, ac_hp_d, &
&   ac_ht_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_d
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet, pn, en
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_d, pn_d, en_d
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: imperviousness, l
    REAL(sp) :: temp
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp_d = ac_mlt_d
    ac_prcp = ac_prcp + ac_mlt
    en_d = 0.0_4
    pn_d = 0.0_4
! Interception with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_INTERCEPTION_D(ac_prcp(k), ac_prcp_d(k), ac_pet(k), &
&                            ac_ci(k), ac_ci_d(k), ac_hi(k), ac_hi_d(k)&
&                            , pn(k), pn_d(k), en(k), en_d(k))
          ELSE
            pn_d(k) = 0.0_4
            pn(k) = 0._sp
            en_d(k) = 0.0_4
            en(k) = 0._sp
          END IF
        END IF
      END DO
    END DO
! Production and transfer without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          CALL GR_PRODUCTION_TRANSFER_ODE_D(pn(k), pn_d(k), en(k), en_d(&
&                                     k), imperviousness, ac_cp(k), &
&                                     ac_cp_d(k), ac_ct(k), ac_ct_d(k), &
&                                     ac_kexc(k), ac_kexc_d(k), ac_hp(k)&
&                                     , ac_hp_d(k), ac_ht(k), ac_ht_d(k)&
&                                     , ac_qt(k), ac_qt_d(k), l)
! Transform from mm/dt to m3/s
          temp = 1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col)
          ac_qt_d(k) = temp*ac_qt_d(k)/setup%dt
          ac_qt(k) = temp*(ac_qt(k)/setup%dt)
        END IF
      END DO
    END DO
  END SUBROUTINE GR4_ODE_TIME_STEP_D

!  Differentiation of gr4_ode_time_step in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: ac_kexc ac_ci ac_cp ac_ct ac_qt
!                ac_hi ac_hp ac_ht ac_mlt
!   with respect to varying inputs: ac_kexc ac_ci ac_cp ac_ct ac_qt
!                ac_hi ac_hp ac_ht ac_mlt
  SUBROUTINE GR4_ODE_TIME_STEP_B(setup, mesh, input_data, options, &
&   returns, time_step, ac_mlt, ac_mlt_b, ac_ci, ac_ci_b, ac_cp, ac_cp_b&
&   , ac_ct, ac_ct_b, ac_kexc, ac_kexc_b, ac_hi, ac_hi_b, ac_hp, ac_hp_b&
&   , ac_ht, ac_ht_b, ac_qt, ac_qt_b)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac) :: ac_mlt_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_kexc
    REAL(sp), DIMENSION(mesh%nac) :: ac_ci_b, ac_cp_b, ac_ct_b, &
&   ac_kexc_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi_b, ac_hp_b, &
&   ac_ht_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_b
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet, pn, en
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_b, pn_b, en_b
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: imperviousness, l
    INTEGER :: branch
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Interception with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL2B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4(ac_hi(k))
            CALL GR_INTERCEPTION(ac_prcp(k), ac_pet(k), ac_ci(k), ac_hi(&
&                          k), pn(k), en(k))
            CALL PUSHCONTROL2B(2)
          ELSE
            pn(k) = 0._sp
            en(k) = 0._sp
            CALL PUSHCONTROL2B(1)
          END IF
        END IF
      END DO
    END DO
! Production and transfer without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL1B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          CALL PUSHREAL4(ac_qt(k))
          CALL PUSHREAL4(ac_ht(k))
          CALL PUSHREAL4(ac_hp(k))
          CALL PUSHREAL4(pn(k))
          CALL GR_PRODUCTION_TRANSFER_ODE(pn(k), en(k), imperviousness, &
&                                   ac_cp(k), ac_ct(k), ac_kexc(k), &
&                                   ac_hp(k), ac_ht(k), ac_qt(k), l)
! Transform from mm/dt to m3/s
          CALL PUSHCONTROL1B(1)
        END IF
      END DO
    END DO
    en_b = 0.0_4
    pn_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          ac_qt_b(k) = mesh%dx(row, col)*1e-3_sp*mesh%dy(row, col)*&
&           ac_qt_b(k)/setup%dt
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          CALL POPREAL4(pn(k))
          CALL POPREAL4(ac_hp(k))
          CALL POPREAL4(ac_ht(k))
          CALL POPREAL4(ac_qt(k))
          CALL GR_PRODUCTION_TRANSFER_ODE_B(pn(k), pn_b(k), en(k), en_b(&
&                                     k), imperviousness, ac_cp(k), &
&                                     ac_cp_b(k), ac_ct(k), ac_ct_b(k), &
&                                     ac_kexc(k), ac_kexc_b(k), ac_hp(k)&
&                                     , ac_hp_b(k), ac_ht(k), ac_ht_b(k)&
&                                     , ac_qt(k), ac_qt_b(k), l)
          ac_qt_b(k) = 0.0_4
        END IF
      END DO
    END DO
    ac_prcp_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL2B(branch)
        IF (branch .NE. 0) THEN
          IF (branch .EQ. 1) THEN
            k = mesh%rowcol_to_ind_ac(row, col)
            en_b(k) = 0.0_4
            pn_b(k) = 0.0_4
          ELSE
            k = mesh%rowcol_to_ind_ac(row, col)
            CALL POPREAL4(ac_hi(k))
            CALL GR_INTERCEPTION_B(ac_prcp(k), ac_prcp_b(k), ac_pet(k), &
&                            ac_ci(k), ac_ci_b(k), ac_hi(k), ac_hi_b(k)&
&                            , pn(k), pn_b(k), en(k), en_b(k))
            pn_b(k) = 0.0_4
            en_b(k) = 0.0_4
          END IF
        END IF
      END DO
    END DO
    ac_mlt_b = ac_mlt_b + ac_prcp_b
  END SUBROUTINE GR4_ODE_TIME_STEP_B

  SUBROUTINE GR4_ODE_TIME_STEP(setup, mesh, input_data, options, returns&
&   , time_step, ac_mlt, ac_ci, ac_cp, ac_ct, ac_kexc, ac_hi, ac_hp, &
&   ac_ht, ac_qt)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_kexc
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet, pn, en
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: imperviousness, l
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Interception with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_INTERCEPTION(ac_prcp(k), ac_pet(k), ac_ci(k), ac_hi(&
&                          k), pn(k), en(k))
          ELSE
            pn(k) = 0._sp
            en(k) = 0._sp
          END IF
        END IF
      END DO
    END DO
! Production and transfer without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          CALL GR_PRODUCTION_TRANSFER_ODE(pn(k), en(k), imperviousness, &
&                                   ac_cp(k), ac_ct(k), ac_kexc(k), &
&                                   ac_hp(k), ac_ht(k), ac_qt(k), l)
! Transform from mm/dt to m3/s
          ac_qt(k) = ac_qt(k)*1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col&
&           )/setup%dt
        END IF
      END DO
    END DO
  END SUBROUTINE GR4_ODE_TIME_STEP

!  Differentiation of gr4_ode_mlp_time_step in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: ac_qt ac_hi ac_hp ac_ht
!   with respect to varying inputs: ac_kexc ac_ci ac_cp ac_ct bias_1
!                bias_2 bias_3 ac_qt ac_hi ac_hp weight_1 weight_2
!                weight_3 ac_ht ac_mlt
  SUBROUTINE GR4_ODE_MLP_TIME_STEP_D(setup, mesh, input_data, options, &
&   returns, time_step, weight_1, weight_1_d, bias_1, bias_1_d, weight_2&
&   , weight_2_d, bias_2, bias_2_d, weight_3, weight_3_d, bias_3, &
&   bias_3_d, ac_mlt, ac_mlt_d, ac_ci, ac_ci_d, ac_cp, ac_cp_d, ac_ct, &
&   ac_ct_d, ac_kexc, ac_kexc_d, ac_hi, ac_hi_d, ac_hp, ac_hp_d, ac_ht, &
&   ac_ht_d, ac_qt, ac_qt_d)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1_d
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1_d
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2_d
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2_d
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3_d
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_kexc
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci_d, ac_cp_d, &
&   ac_ct_d, ac_kexc_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi_d, ac_hp_d, &
&   ac_ht_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_d
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer_d
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer_d
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_jacobian_1
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_jacobian_1_d
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_jacobian_2
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_jacobian_2_d
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet, pn, en
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_d, pn_d, en_d
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: imperviousness, l
    REAL(sp) :: temp
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp_d = ac_mlt_d
    ac_prcp = ac_prcp + ac_mlt
    en_d = 0.0_4
    pn_d = 0.0_4
! Interception with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_INTERCEPTION_D(ac_prcp(k), ac_prcp_d(k), ac_pet(k), &
&                            ac_ci(k), ac_ci_d(k), ac_hi(k), ac_hi_d(k)&
&                            , pn(k), pn_d(k), en(k), en_d(k))
          ELSE
            pn_d(k) = 0.0_4
            pn(k) = 0._sp
            en_d(k) = 0.0_4
            en(k) = 0._sp
          END IF
        END IF
      END DO
    END DO
    output_jacobian_1_d = 0.0_4
    output_jacobian_2_d = 0.0_4
    output_layer_d = 0.0_4
! Forward MLP without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            input_layer_d(:) = (/ac_hp_d(k), ac_ht_d(k), pn_d(k), en_d(k&
&             )/)
            input_layer(:) = (/ac_hp(k), ac_ht(k), pn(k), en(k)/)
            CALL FORWARD_AND_BACKWARD_MLP_D(weight_1, weight_1_d, bias_1&
&                                     , bias_1_d, weight_2, weight_2_d, &
&                                     bias_2, bias_2_d, weight_3, &
&                                     weight_3_d, bias_3, bias_3_d, &
&                                     input_layer, input_layer_d, &
&                                     output_layer(:, k), output_layer_d&
&                                     (:, k), output_jacobian_1(:, k), &
&                                     output_jacobian_1_d(:, k), &
&                                     output_jacobian_2(:, k), &
&                                     output_jacobian_2_d(:, k))
          ELSE
            output_layer_d(:, k) = 0.0_4
            output_layer(:, k) = 0._sp
            output_jacobian_1_d(:, k) = 0.0_4
            output_jacobian_1(:, k) = 0._sp
            output_jacobian_2_d(:, k) = 0.0_4
            output_jacobian_2(:, k) = 0._sp
          END IF
        END IF
      END DO
    END DO
! Production and transfer without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          CALL GR_PRODUCTION_TRANSFER_ODE_MLP_D(output_layer(:, k), &
&                                         output_layer_d(:, k), &
&                                         output_jacobian_1(:, k), &
&                                         output_jacobian_1_d(:, k), &
&                                         output_jacobian_2(:, k), &
&                                         output_jacobian_2_d(:, k), pn(&
&                                         k), pn_d(k), en(k), en_d(k), &
&                                         imperviousness, ac_cp(k), &
&                                         ac_cp_d(k), ac_ct(k), ac_ct_d(&
&                                         k), ac_kexc(k), ac_kexc_d(k), &
&                                         ac_hp(k), ac_hp_d(k), ac_ht(k)&
&                                         , ac_ht_d(k), ac_qt(k), &
&                                         ac_qt_d(k), l)
! Transform from mm/dt to m3/s
          temp = 1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col)
          ac_qt_d(k) = temp*ac_qt_d(k)/setup%dt
          ac_qt(k) = temp*(ac_qt(k)/setup%dt)
        END IF
      END DO
    END DO
  END SUBROUTINE GR4_ODE_MLP_TIME_STEP_D

!  Differentiation of gr4_ode_mlp_time_step in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: ac_kexc ac_ci ac_cp ac_ct bias_1
!                bias_2 bias_3 ac_qt ac_hi ac_hp weight_1 weight_2
!                weight_3 ac_ht ac_mlt
!   with respect to varying inputs: ac_kexc ac_ci ac_cp ac_ct bias_1
!                bias_2 bias_3 ac_qt ac_hi ac_hp weight_1 weight_2
!                weight_3 ac_ht ac_mlt
  SUBROUTINE GR4_ODE_MLP_TIME_STEP_B(setup, mesh, input_data, options, &
&   returns, time_step, weight_1, weight_1_b, bias_1, bias_1_b, weight_2&
&   , weight_2_b, bias_2, bias_2_b, weight_3, weight_3_b, bias_3, &
&   bias_3_b, ac_mlt, ac_mlt_b, ac_ci, ac_ci_b, ac_cp, ac_cp_b, ac_ct, &
&   ac_ct_b, ac_kexc, ac_kexc_b, ac_hi, ac_hi_b, ac_hp, ac_hp_b, ac_ht, &
&   ac_ht_b, ac_qt, ac_qt_b)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)) :: &
&   weight_1_b
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(setup%neurons(2)) :: bias_1_b
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)) :: &
&   weight_2_b
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(setup%neurons(3)) :: bias_2_b
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)) :: &
&   weight_3_b
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(setup%neurons(4)) :: bias_3_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac) :: ac_mlt_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_kexc
    REAL(sp), DIMENSION(mesh%nac) :: ac_ci_b, ac_cp_b, ac_ct_b, &
&   ac_kexc_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi_b, ac_hp_b, &
&   ac_ht_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_b
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer_b
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer_b
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_jacobian_1
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_jacobian_1_b
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_jacobian_2
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_jacobian_2_b
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet, pn, en
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_b, pn_b, en_b
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: imperviousness, l
    INTEGER :: branch
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Interception with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL2B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4(ac_hi(k))
            CALL GR_INTERCEPTION(ac_prcp(k), ac_pet(k), ac_ci(k), ac_hi(&
&                          k), pn(k), en(k))
            CALL PUSHCONTROL2B(2)
          ELSE
            pn(k) = 0._sp
            en(k) = 0._sp
            CALL PUSHCONTROL2B(1)
          END IF
        END IF
      END DO
    END DO
! Forward MLP without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL2B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4ARRAY(input_layer, setup%neurons(1))
            input_layer(:) = (/ac_hp(k), ac_ht(k), pn(k), en(k)/)
            CALL FORWARD_AND_BACKWARD_MLP(weight_1, bias_1, weight_2, &
&                                   bias_2, weight_3, bias_3, &
&                                   input_layer, output_layer(:, k), &
&                                   output_jacobian_1(:, k), &
&                                   output_jacobian_2(:, k))
            CALL PUSHCONTROL2B(2)
          ELSE
            output_layer(:, k) = 0._sp
            output_jacobian_1(:, k) = 0._sp
            output_jacobian_2(:, k) = 0._sp
            CALL PUSHCONTROL2B(1)
          END IF
        END IF
      END DO
    END DO
! Production and transfer without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL1B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          CALL PUSHREAL4(ac_qt(k))
          CALL PUSHREAL4(ac_ht(k))
          CALL PUSHREAL4(ac_hp(k))
          CALL PUSHREAL4(pn(k))
          CALL GR_PRODUCTION_TRANSFER_ODE_MLP(output_layer(:, k), &
&                                       output_jacobian_1(:, k), &
&                                       output_jacobian_2(:, k), pn(k), &
&                                       en(k), imperviousness, ac_cp(k)&
&                                       , ac_ct(k), ac_kexc(k), ac_hp(k)&
&                                       , ac_ht(k), ac_qt(k), l)
! Transform from mm/dt to m3/s
          CALL PUSHCONTROL1B(1)
        END IF
      END DO
    END DO
    output_jacobian_1_b = 0.0_4
    output_jacobian_2_b = 0.0_4
    output_layer_b = 0.0_4
    en_b = 0.0_4
    pn_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          ac_qt_b(k) = mesh%dx(row, col)*1e-3_sp*mesh%dy(row, col)*&
&           ac_qt_b(k)/setup%dt
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          CALL POPREAL4(pn(k))
          CALL POPREAL4(ac_hp(k))
          CALL POPREAL4(ac_ht(k))
          CALL POPREAL4(ac_qt(k))
          CALL GR_PRODUCTION_TRANSFER_ODE_MLP_B(output_layer(:, k), &
&                                         output_layer_b(:, k), &
&                                         output_jacobian_1(:, k), &
&                                         output_jacobian_1_b(:, k), &
&                                         output_jacobian_2(:, k), &
&                                         output_jacobian_2_b(:, k), pn(&
&                                         k), pn_b(k), en(k), en_b(k), &
&                                         imperviousness, ac_cp(k), &
&                                         ac_cp_b(k), ac_ct(k), ac_ct_b(&
&                                         k), ac_kexc(k), ac_kexc_b(k), &
&                                         ac_hp(k), ac_hp_b(k), ac_ht(k)&
&                                         , ac_ht_b(k), ac_qt(k), &
&                                         ac_qt_b(k), l)
          ac_qt_b(k) = 0.0_4
        END IF
      END DO
    END DO
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL2B(branch)
        IF (branch .NE. 0) THEN
          IF (branch .EQ. 1) THEN
            k = mesh%rowcol_to_ind_ac(row, col)
            output_jacobian_2_b(:, k) = 0.0_4
            output_jacobian_1_b(:, k) = 0.0_4
            output_layer_b(:, k) = 0.0_4
          ELSE
            k = mesh%rowcol_to_ind_ac(row, col)
            CALL FORWARD_AND_BACKWARD_MLP_B(weight_1, weight_1_b, bias_1&
&                                     , bias_1_b, weight_2, weight_2_b, &
&                                     bias_2, bias_2_b, weight_3, &
&                                     weight_3_b, bias_3, bias_3_b, &
&                                     input_layer, input_layer_b, &
&                                     output_layer(:, k), output_layer_b&
&                                     (:, k), output_jacobian_1(:, k), &
&                                     output_jacobian_1_b(:, k), &
&                                     output_jacobian_2(:, k), &
&                                     output_jacobian_2_b(:, k))
            output_layer_b(:, k) = 0.0_4
            output_jacobian_1_b(:, k) = 0.0_4
            output_jacobian_2_b(:, k) = 0.0_4
            CALL POPREAL4ARRAY(input_layer, setup%neurons(1))
            ac_hp_b(k) = ac_hp_b(k) + input_layer_b(1)
            ac_ht_b(k) = ac_ht_b(k) + input_layer_b(2)
            pn_b(k) = pn_b(k) + input_layer_b(3)
            en_b(k) = en_b(k) + input_layer_b(4)
          END IF
        END IF
      END DO
    END DO
    ac_prcp_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL2B(branch)
        IF (branch .NE. 0) THEN
          IF (branch .EQ. 1) THEN
            k = mesh%rowcol_to_ind_ac(row, col)
            en_b(k) = 0.0_4
            pn_b(k) = 0.0_4
          ELSE
            k = mesh%rowcol_to_ind_ac(row, col)
            CALL POPREAL4(ac_hi(k))
            CALL GR_INTERCEPTION_B(ac_prcp(k), ac_prcp_b(k), ac_pet(k), &
&                            ac_ci(k), ac_ci_b(k), ac_hi(k), ac_hi_b(k)&
&                            , pn(k), pn_b(k), en(k), en_b(k))
            pn_b(k) = 0.0_4
            en_b(k) = 0.0_4
          END IF
        END IF
      END DO
    END DO
    ac_mlt_b = ac_mlt_b + ac_prcp_b
  END SUBROUTINE GR4_ODE_MLP_TIME_STEP_B

  SUBROUTINE GR4_ODE_MLP_TIME_STEP(setup, mesh, input_data, options, &
&   returns, time_step, weight_1, bias_1, weight_2, bias_2, weight_3, &
&   bias_3, ac_mlt, ac_ci, ac_cp, ac_ct, ac_kexc, ac_hi, ac_hp, ac_ht, &
&   ac_qt)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_kexc
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_jacobian_1
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_jacobian_2
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet, pn, en
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: imperviousness, l
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Interception with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_INTERCEPTION(ac_prcp(k), ac_pet(k), ac_ci(k), ac_hi(&
&                          k), pn(k), en(k))
          ELSE
            pn(k) = 0._sp
            en(k) = 0._sp
          END IF
        END IF
      END DO
    END DO
! Forward MLP without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            input_layer(:) = (/ac_hp(k), ac_ht(k), pn(k), en(k)/)
            CALL FORWARD_AND_BACKWARD_MLP(weight_1, bias_1, weight_2, &
&                                   bias_2, weight_3, bias_3, &
&                                   input_layer, output_layer(:, k), &
&                                   output_jacobian_1(:, k), &
&                                   output_jacobian_2(:, k))
          ELSE
            output_layer(:, k) = 0._sp
            output_jacobian_1(:, k) = 0._sp
            output_jacobian_2(:, k) = 0._sp
          END IF
        END IF
      END DO
    END DO
! Production and transfer without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          CALL GR_PRODUCTION_TRANSFER_ODE_MLP(output_layer(:, k), &
&                                       output_jacobian_1(:, k), &
&                                       output_jacobian_2(:, k), pn(k), &
&                                       en(k), imperviousness, ac_cp(k)&
&                                       , ac_ct(k), ac_kexc(k), ac_hp(k)&
&                                       , ac_ht(k), ac_qt(k), l)
! Transform from mm/dt to m3/s
          ac_qt(k) = ac_qt(k)*1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col&
&           )/setup%dt
        END IF
      END DO
    END DO
  END SUBROUTINE GR4_ODE_MLP_TIME_STEP

!  Differentiation of gr5_time_step in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: ac_qt ac_hi ac_hp ac_ht
!   with respect to varying inputs: ac_kexc ac_ci ac_cp ac_ct ac_qt
!                ac_hi ac_hp ac_ht ac_mlt ac_aexc
  SUBROUTINE GR5_TIME_STEP_D(setup, mesh, input_data, options, returns, &
&   time_step, ac_mlt, ac_mlt_d, ac_ci, ac_ci_d, ac_cp, ac_cp_d, ac_ct, &
&   ac_ct_d, ac_kexc, ac_kexc_d, ac_aexc, ac_aexc_d, ac_hi, ac_hi_d, &
&   ac_hp, ac_hp_d, ac_ht, ac_ht_d, ac_qt, ac_qt_d)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_kexc, ac_aexc
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci_d, ac_cp_d, &
&   ac_ct_d, ac_kexc_d, ac_aexc_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi_d, ac_hp_d, &
&   ac_ht_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_d
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_d
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, pn, en, imperviousness, pr, perc, ps, es, l, prr, &
&   prd, qr, qd
    REAL(sp) :: pn_d, en_d, pr_d, perc_d, l_d, prr_d, prd_d, qr_d, qd_d
    INTRINSIC MAX
    REAL(sp) :: temp
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp_d = ac_mlt_d
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_INTERCEPTION_D(ac_prcp(k), ac_prcp_d(k), ac_pet(k), &
&                            ac_ci(k), ac_ci_d(k), ac_hi(k), ac_hi_d(k)&
&                            , pn, pn_d, en, en_d)
            CALL GR_PRODUCTION_D(0._sp, 0.0_4, 0._sp, 0.0_4, pn, pn_d, &
&                          en, en_d, imperviousness, ac_cp(k), ac_cp_d(k&
&                          ), beta, ac_hp(k), ac_hp_d(k), pr, pr_d, perc&
&                          , perc_d, ps, es)
            CALL GR_THRESHOLD_EXCHANGE_D(0._sp, 0.0_4, ac_kexc(k), &
&                                  ac_kexc_d(k), ac_aexc(k), ac_aexc_d(k&
&                                  ), ac_ht(k), ac_ht_d(k), l, l_d)
          ELSE
            pr = 0._sp
            perc = 0._sp
            l = 0._sp
            l_d = 0.0_4
            perc_d = 0.0_4
            pr_d = 0.0_4
          END IF
          prr_d = 0.9_sp*(pr_d+perc_d) + l_d
          prr = 0.9_sp*(pr+perc) + l
          prd_d = 0.1_sp*(pr_d+perc_d)
          prd = 0.1_sp*(pr+perc)
          CALL GR_TRANSFER_D(5._sp, ac_prcp(k), prr, prr_d, ac_ct(k), &
&                      ac_ct_d(k), ac_ht(k), ac_ht_d(k), qr, qr_d)
          IF (0._sp .LT. prd + l) THEN
            qd_d = prd_d + l_d
            qd = prd + l
          ELSE
            qd = 0._sp
            qd_d = 0.0_4
          END IF
          ac_qt_d(k) = qr_d + qd_d
          ac_qt(k) = qr + qd
! Transform from mm/dt to m3/s
          temp = 1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col)
          ac_qt_d(k) = temp*ac_qt_d(k)/setup%dt
          ac_qt(k) = temp*(ac_qt(k)/setup%dt)
        END IF
      END DO
    END DO
  END SUBROUTINE GR5_TIME_STEP_D

!  Differentiation of gr5_time_step in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: ac_kexc ac_ci ac_cp ac_ct ac_qt
!                ac_hi ac_hp ac_ht ac_mlt ac_aexc
!   with respect to varying inputs: ac_kexc ac_ci ac_cp ac_ct ac_qt
!                ac_hi ac_hp ac_ht ac_mlt ac_aexc
  SUBROUTINE GR5_TIME_STEP_B(setup, mesh, input_data, options, returns, &
&   time_step, ac_mlt, ac_mlt_b, ac_ci, ac_ci_b, ac_cp, ac_cp_b, ac_ct, &
&   ac_ct_b, ac_kexc, ac_kexc_b, ac_aexc, ac_aexc_b, ac_hi, ac_hi_b, &
&   ac_hp, ac_hp_b, ac_ht, ac_ht_b, ac_qt, ac_qt_b)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac) :: ac_mlt_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_kexc, ac_aexc
    REAL(sp), DIMENSION(mesh%nac) :: ac_ci_b, ac_cp_b, ac_ct_b, &
&   ac_kexc_b, ac_aexc_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi_b, ac_hp_b, &
&   ac_ht_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_b
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_b
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, pn, en, imperviousness, pr, perc, ps, es, l, prr, &
&   prd, qr, qd
    REAL(sp) :: pn_b, en_b, pr_b, perc_b, l_b, prr_b, prd_b, qr_b, qd_b
    INTRINSIC MAX
    REAL(sp) :: dummydiff_b
    REAL(sp) :: dummydiff_b0
    REAL(sp) :: dummydiff_b1
    INTEGER :: branch
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL1B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4(en)
            CALL PUSHREAL4(ac_hi(k))
            CALL GR_INTERCEPTION(ac_prcp(k), ac_pet(k), ac_ci(k), ac_hi(&
&                          k), pn, en)
            CALL PUSHREAL4(ac_hp(k))
            CALL PUSHREAL4(pn)
            CALL GR_PRODUCTION(0._sp, 0._sp, pn, en, imperviousness, &
&                        ac_cp(k), beta, ac_hp(k), pr, perc, ps, es)
            CALL GR_THRESHOLD_EXCHANGE(0._sp, ac_kexc(k), ac_aexc(k), &
&                                ac_ht(k), l)
            CALL PUSHCONTROL1B(1)
          ELSE
            CALL PUSHCONTROL1B(0)
            pr = 0._sp
            perc = 0._sp
            l = 0._sp
          END IF
          CALL PUSHREAL4(prr)
          prr = 0.9_sp*(pr+perc) + l
          prd = 0.1_sp*(pr+perc)
          CALL PUSHREAL4(ac_ht(k))
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prr, ac_ct(k), ac_ht(k), &
&                    qr)
          IF (0._sp .LT. prd + l) THEN
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHCONTROL1B(1)
          END IF
          CALL PUSHCONTROL1B(1)
        END IF
      END DO
    END DO
    ac_prcp_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          ac_qt_b(k) = mesh%dx(row, col)*1e-3_sp*mesh%dy(row, col)*&
&           ac_qt_b(k)/setup%dt
          qr_b = ac_qt_b(k)
          qd_b = ac_qt_b(k)
          ac_qt_b(k) = 0.0_4
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            prd_b = qd_b
            l_b = qd_b
          ELSE
            l_b = 0.0_4
            prd_b = 0.0_4
          END IF
          CALL POPREAL4(ac_ht(k))
          CALL GR_TRANSFER_B(5._sp, ac_prcp(k), prr, prr_b, ac_ct(k), &
&                      ac_ct_b(k), ac_ht(k), ac_ht_b(k), qr, qr_b)
          pr_b = 0.1_sp*prd_b + 0.9_sp*prr_b
          perc_b = 0.1_sp*prd_b + 0.9_sp*prr_b
          CALL POPREAL4(prr)
          l_b = l_b + prr_b
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) THEN
            CALL GR_THRESHOLD_EXCHANGE_B(0._sp, dummydiff_b1, ac_kexc(k)&
&                                  , ac_kexc_b(k), ac_aexc(k), ac_aexc_b&
&                                  (k), ac_ht(k), ac_ht_b(k), l, l_b)
            imperviousness = input_data%physio_data%imperviousness(row, &
&             col)
            CALL POPREAL4(pn)
            CALL POPREAL4(ac_hp(k))
            pn_b = 0.0_4
            en_b = 0.0_4
            CALL GR_PRODUCTION_B(0._sp, dummydiff_b, 0._sp, dummydiff_b0&
&                          , pn, pn_b, en, en_b, imperviousness, ac_cp(k&
&                          ), ac_cp_b(k), beta, ac_hp(k), ac_hp_b(k), pr&
&                          , pr_b, perc, perc_b, ps, es)
            CALL POPREAL4(ac_hi(k))
            CALL POPREAL4(en)
            CALL GR_INTERCEPTION_B(ac_prcp(k), ac_prcp_b(k), ac_pet(k), &
&                            ac_ci(k), ac_ci_b(k), ac_hi(k), ac_hi_b(k)&
&                            , pn, pn_b, en, en_b)
          END IF
        END IF
      END DO
    END DO
    ac_mlt_b = ac_mlt_b + ac_prcp_b
  END SUBROUTINE GR5_TIME_STEP_B

  SUBROUTINE GR5_TIME_STEP(setup, mesh, input_data, options, returns, &
&   time_step, ac_mlt, ac_ci, ac_cp, ac_ct, ac_kexc, ac_aexc, ac_hi, &
&   ac_hp, ac_ht, ac_qt)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_kexc, ac_aexc
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, pn, en, imperviousness, pr, perc, ps, es, l, prr, &
&   prd, qr, qd
    INTRINSIC MAX
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_INTERCEPTION(ac_prcp(k), ac_pet(k), ac_ci(k), ac_hi(&
&                          k), pn, en)
            CALL GR_PRODUCTION(0._sp, 0._sp, pn, en, imperviousness, &
&                        ac_cp(k), beta, ac_hp(k), pr, perc, ps, es)
            CALL GR_THRESHOLD_EXCHANGE(0._sp, ac_kexc(k), ac_aexc(k), &
&                                ac_ht(k), l)
          ELSE
            pr = 0._sp
            perc = 0._sp
            l = 0._sp
          END IF
          prr = 0.9_sp*(pr+perc) + l
          prd = 0.1_sp*(pr+perc)
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prr, ac_ct(k), ac_ht(k), &
&                    qr)
          IF (0._sp .LT. prd + l) THEN
            qd = prd + l
          ELSE
            qd = 0._sp
          END IF
          ac_qt(k) = qr + qd
! Transform from mm/dt to m3/s
          ac_qt(k) = ac_qt(k)*1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col&
&           )/setup%dt
        END IF
      END DO
    END DO
  END SUBROUTINE GR5_TIME_STEP

!  Differentiation of gr5_mlp_time_step in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: ac_qt ac_hi ac_hp ac_ht
!   with respect to varying inputs: ac_kexc ac_ci ac_cp ac_ct bias_1
!                bias_2 bias_3 ac_qt ac_hi ac_hp weight_1 weight_2
!                weight_3 ac_ht ac_mlt ac_aexc
  SUBROUTINE GR5_MLP_TIME_STEP_D(setup, mesh, input_data, options, &
&   returns, time_step, weight_1, weight_1_d, bias_1, bias_1_d, weight_2&
&   , weight_2_d, bias_2, bias_2_d, weight_3, weight_3_d, bias_3, &
&   bias_3_d, ac_mlt, ac_mlt_d, ac_ci, ac_ci_d, ac_cp, ac_cp_d, ac_ct, &
&   ac_ct_d, ac_kexc, ac_kexc_d, ac_aexc, ac_aexc_d, ac_hi, ac_hi_d, &
&   ac_hp, ac_hp_d, ac_ht, ac_ht_d, ac_qt, ac_qt_d)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1_d
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1_d
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2_d
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2_d
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3_d
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_kexc, ac_aexc
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci_d, ac_cp_d, &
&   ac_ct_d, ac_kexc_d, ac_aexc_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi_d, ac_hp_d, &
&   ac_ht_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_d
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer_d
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer_d
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet, pn, en
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_d, pn_d, en_d
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, imperviousness, pr, perc, ps, es, l, prr, prd, qr&
&   , qd
    REAL(sp) :: pr_d, perc_d, l_d, prr_d, prd_d, qr_d, qd_d
    INTRINSIC MAX
    REAL(sp) :: temp
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp_d = ac_mlt_d
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
    en_d = 0.0_4
    pn_d = 0.0_4
! Interception with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_INTERCEPTION_D(ac_prcp(k), ac_prcp_d(k), ac_pet(k), &
&                            ac_ci(k), ac_ci_d(k), ac_hi(k), ac_hi_d(k)&
&                            , pn(k), pn_d(k), en(k), en_d(k))
          ELSE
            pn_d(k) = 0.0_4
            pn(k) = 0._sp
            en_d(k) = 0.0_4
            en(k) = 0._sp
          END IF
        END IF
      END DO
    END DO
    output_layer_d = 0.0_4
! Forward MLP without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            input_layer_d(:) = (/ac_hp_d(k), ac_ht_d(k), pn_d(k), en_d(k&
&             )/)
            input_layer(:) = (/ac_hp(k), ac_ht(k), pn(k), en(k)/)
            CALL FORWARD_MLP_D(weight_1, weight_1_d, bias_1, bias_1_d, &
&                        weight_2, weight_2_d, bias_2, bias_2_d, &
&                        weight_3, weight_3_d, bias_3, bias_3_d, &
&                        input_layer, input_layer_d, output_layer(:, k)&
&                        , output_layer_d(:, k))
          ELSE
            output_layer_d(:, k) = 0.0_4
            output_layer(:, k) = 0._sp
          END IF
        END IF
      END DO
    END DO
! Production and transfer with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_PRODUCTION_D(output_layer(1, k), output_layer_d(1, k&
&                          ), output_layer(2, k), output_layer_d(2, k), &
&                          pn(k), pn_d(k), en(k), en_d(k), &
&                          imperviousness, ac_cp(k), ac_cp_d(k), beta, &
&                          ac_hp(k), ac_hp_d(k), pr, pr_d, perc, perc_d&
&                          , ps, es)
            CALL GR_THRESHOLD_EXCHANGE_D(output_layer(4, k), &
&                                  output_layer_d(4, k), ac_kexc(k), &
&                                  ac_kexc_d(k), ac_aexc(k), ac_aexc_d(k&
&                                  ), ac_ht(k), ac_ht_d(k), l, l_d)
          ELSE
            pr = 0._sp
            perc = 0._sp
            l = 0._sp
            l_d = 0.0_4
            perc_d = 0.0_4
            pr_d = 0.0_4
          END IF
! Range of correction c0.9: (1, 0)
          temp = -(output_layer(3, k)*output_layer(3, k)) + 1._sp
          prr_d = 0.9_sp*(temp*(pr_d+perc_d)-(pr+perc)*2*output_layer(3&
&           , k)*output_layer_d(3, k)) + l_d
          prr = 0.9_sp*(temp*(pr+perc)) + l
! Range of correction c0.1: (1, 10)
          temp = 0.9_sp*(output_layer(3, k)*output_layer(3, k)) + 0.1_sp
          prd_d = (pr+perc)*0.9_sp*2*output_layer(3, k)*output_layer_d(3&
&           , k) + temp*(pr_d+perc_d)
          prd = temp*(pr+perc)
          CALL GR_TRANSFER_D(5._sp, ac_prcp(k), prr, prr_d, ac_ct(k), &
&                      ac_ct_d(k), ac_ht(k), ac_ht_d(k), qr, qr_d)
          IF (0._sp .LT. prd + l) THEN
            qd_d = prd_d + l_d
            qd = prd + l
          ELSE
            qd = 0._sp
            qd_d = 0.0_4
          END IF
          ac_qt_d(k) = qr_d + qd_d
          ac_qt(k) = qr + qd
! Transform from mm/dt to m3/s
          temp = 1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col)
          ac_qt_d(k) = temp*ac_qt_d(k)/setup%dt
          ac_qt(k) = temp*(ac_qt(k)/setup%dt)
        END IF
      END DO
    END DO
  END SUBROUTINE GR5_MLP_TIME_STEP_D

!  Differentiation of gr5_mlp_time_step in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: ac_kexc ac_ci ac_cp ac_ct bias_1
!                bias_2 bias_3 ac_qt ac_hi ac_hp weight_1 weight_2
!                weight_3 ac_ht ac_mlt ac_aexc
!   with respect to varying inputs: ac_kexc ac_ci ac_cp ac_ct bias_1
!                bias_2 bias_3 ac_qt ac_hi ac_hp weight_1 weight_2
!                weight_3 ac_ht ac_mlt ac_aexc
  SUBROUTINE GR5_MLP_TIME_STEP_B(setup, mesh, input_data, options, &
&   returns, time_step, weight_1, weight_1_b, bias_1, bias_1_b, weight_2&
&   , weight_2_b, bias_2, bias_2_b, weight_3, weight_3_b, bias_3, &
&   bias_3_b, ac_mlt, ac_mlt_b, ac_ci, ac_ci_b, ac_cp, ac_cp_b, ac_ct, &
&   ac_ct_b, ac_kexc, ac_kexc_b, ac_aexc, ac_aexc_b, ac_hi, ac_hi_b, &
&   ac_hp, ac_hp_b, ac_ht, ac_ht_b, ac_qt, ac_qt_b)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)) :: &
&   weight_1_b
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(setup%neurons(2)) :: bias_1_b
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)) :: &
&   weight_2_b
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(setup%neurons(3)) :: bias_2_b
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)) :: &
&   weight_3_b
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(setup%neurons(4)) :: bias_3_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac) :: ac_mlt_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_kexc, ac_aexc
    REAL(sp), DIMENSION(mesh%nac) :: ac_ci_b, ac_cp_b, ac_ct_b, &
&   ac_kexc_b, ac_aexc_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi_b, ac_hp_b, &
&   ac_ht_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_b
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer_b
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer_b
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet, pn, en
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_b, pn_b, en_b
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, imperviousness, pr, perc, ps, es, l, prr, prd, qr&
&   , qd
    REAL(sp) :: pr_b, perc_b, l_b, prr_b, prd_b, qr_b, qd_b
    INTRINSIC MAX
    REAL(sp) :: temp_b
    INTEGER :: branch
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
! Interception with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL2B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4(ac_hi(k))
            CALL GR_INTERCEPTION(ac_prcp(k), ac_pet(k), ac_ci(k), ac_hi(&
&                          k), pn(k), en(k))
            CALL PUSHCONTROL2B(2)
          ELSE
            pn(k) = 0._sp
            en(k) = 0._sp
            CALL PUSHCONTROL2B(1)
          END IF
        END IF
      END DO
    END DO
! Forward MLP without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL2B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4ARRAY(input_layer, setup%neurons(1))
            input_layer(:) = (/ac_hp(k), ac_ht(k), pn(k), en(k)/)
            CALL FORWARD_MLP(weight_1, bias_1, weight_2, bias_2, &
&                      weight_3, bias_3, input_layer, output_layer(:, k)&
&                     )
            CALL PUSHCONTROL2B(2)
          ELSE
            output_layer(:, k) = 0._sp
            CALL PUSHCONTROL2B(1)
          END IF
        END IF
      END DO
    END DO
! Production and transfer with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHINTEGER4(k)
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4(perc)
            CALL PUSHREAL4(pr)
            CALL PUSHREAL4(ac_hp(k))
            CALL PUSHREAL4(pn(k))
            CALL GR_PRODUCTION(output_layer(1, k), output_layer(2, k), &
&                        pn(k), en(k), imperviousness, ac_cp(k), beta, &
&                        ac_hp(k), pr, perc, ps, es)
            CALL GR_THRESHOLD_EXCHANGE(output_layer(4, k), ac_kexc(k), &
&                                ac_aexc(k), ac_ht(k), l)
            CALL PUSHCONTROL1B(1)
          ELSE
            CALL PUSHREAL4(pr)
            pr = 0._sp
            CALL PUSHREAL4(perc)
            perc = 0._sp
            l = 0._sp
            CALL PUSHCONTROL1B(0)
          END IF
! Range of correction c0.9: (1, 0)
          CALL PUSHREAL4(prr)
          prr = 0.9_sp*(1._sp-output_layer(3, k)**2)*(pr+perc) + l
! Range of correction c0.1: (1, 10)
          prd = (0.1_sp+0.9_sp*output_layer(3, k)**2)*(pr+perc)
          CALL PUSHREAL4(ac_ht(k))
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prr, ac_ct(k), ac_ht(k), &
&                    qr)
          IF (0._sp .LT. prd + l) THEN
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHCONTROL1B(1)
          END IF
          CALL PUSHCONTROL1B(1)
        END IF
      END DO
    END DO
    output_layer_b = 0.0_4
    en_b = 0.0_4
    pn_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) THEN
          ac_qt_b(k) = mesh%dx(row, col)*1e-3_sp*mesh%dy(row, col)*&
&           ac_qt_b(k)/setup%dt
          qr_b = ac_qt_b(k)
          qd_b = ac_qt_b(k)
          ac_qt_b(k) = 0.0_4
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            prd_b = qd_b
            l_b = qd_b
          ELSE
            l_b = 0.0_4
            prd_b = 0.0_4
          END IF
          CALL POPREAL4(ac_ht(k))
          CALL GR_TRANSFER_B(5._sp, ac_prcp(k), prr, prr_b, ac_ct(k), &
&                      ac_ct_b(k), ac_ht(k), ac_ht_b(k), qr, qr_b)
          output_layer_b(3, k) = output_layer_b(3, k) + 2*output_layer(3&
&           , k)*0.9_sp*(pr+perc)*prd_b - 2*output_layer(3, k)*(pr+perc)&
&           *0.9_sp*prr_b
          temp_b = (0.9_sp*output_layer(3, k)**2+0.1_sp)*prd_b
          pr_b = temp_b
          perc_b = temp_b
          CALL POPREAL4(prr)
          temp_b = (1._sp-output_layer(3, k)**2)*0.9_sp*prr_b
          l_b = l_b + prr_b
          pr_b = pr_b + temp_b
          perc_b = perc_b + temp_b
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            CALL POPREAL4(perc)
            CALL POPREAL4(pr)
          ELSE
            CALL GR_THRESHOLD_EXCHANGE_B(output_layer(4, k), &
&                                  output_layer_b(4, k), ac_kexc(k), &
&                                  ac_kexc_b(k), ac_aexc(k), ac_aexc_b(k&
&                                  ), ac_ht(k), ac_ht_b(k), l, l_b)
            imperviousness = input_data%physio_data%imperviousness(row, &
&             col)
            CALL POPREAL4(pn(k))
            CALL POPREAL4(ac_hp(k))
            CALL POPREAL4(pr)
            CALL POPREAL4(perc)
            CALL GR_PRODUCTION_B(output_layer(1, k), output_layer_b(1, k&
&                          ), output_layer(2, k), output_layer_b(2, k), &
&                          pn(k), pn_b(k), en(k), en_b(k), &
&                          imperviousness, ac_cp(k), ac_cp_b(k), beta, &
&                          ac_hp(k), ac_hp_b(k), pr, pr_b, perc, perc_b&
&                          , ps, es)
          END IF
          CALL POPINTEGER4(k)
        END IF
      END DO
    END DO
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL2B(branch)
        IF (branch .NE. 0) THEN
          IF (branch .EQ. 1) THEN
            k = mesh%rowcol_to_ind_ac(row, col)
            output_layer_b(:, k) = 0.0_4
          ELSE
            k = mesh%rowcol_to_ind_ac(row, col)
            CALL FORWARD_MLP_B(weight_1, weight_1_b, bias_1, bias_1_b, &
&                        weight_2, weight_2_b, bias_2, bias_2_b, &
&                        weight_3, weight_3_b, bias_3, bias_3_b, &
&                        input_layer, input_layer_b, output_layer(:, k)&
&                        , output_layer_b(:, k))
            output_layer_b(:, k) = 0.0_4
            CALL POPREAL4ARRAY(input_layer, setup%neurons(1))
            ac_hp_b(k) = ac_hp_b(k) + input_layer_b(1)
            ac_ht_b(k) = ac_ht_b(k) + input_layer_b(2)
            pn_b(k) = pn_b(k) + input_layer_b(3)
            en_b(k) = en_b(k) + input_layer_b(4)
          END IF
        END IF
      END DO
    END DO
    ac_prcp_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL2B(branch)
        IF (branch .NE. 0) THEN
          IF (branch .EQ. 1) THEN
            k = mesh%rowcol_to_ind_ac(row, col)
            en_b(k) = 0.0_4
            pn_b(k) = 0.0_4
          ELSE
            k = mesh%rowcol_to_ind_ac(row, col)
            CALL POPREAL4(ac_hi(k))
            CALL GR_INTERCEPTION_B(ac_prcp(k), ac_prcp_b(k), ac_pet(k), &
&                            ac_ci(k), ac_ci_b(k), ac_hi(k), ac_hi_b(k)&
&                            , pn(k), pn_b(k), en(k), en_b(k))
            pn_b(k) = 0.0_4
            en_b(k) = 0.0_4
          END IF
        END IF
      END DO
    END DO
    ac_mlt_b = ac_mlt_b + ac_prcp_b
  END SUBROUTINE GR5_MLP_TIME_STEP_B

  SUBROUTINE GR5_MLP_TIME_STEP(setup, mesh, input_data, options, returns&
&   , time_step, weight_1, bias_1, weight_2, bias_2, weight_3, bias_3, &
&   ac_mlt, ac_ci, ac_cp, ac_ct, ac_kexc, ac_aexc, ac_hi, ac_hp, ac_ht, &
&   ac_qt)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_kexc, ac_aexc
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet, pn, en
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, imperviousness, pr, perc, ps, es, l, prr, prd, qr&
&   , qd
    INTRINSIC MAX
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
! Interception with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_INTERCEPTION(ac_prcp(k), ac_pet(k), ac_ci(k), ac_hi(&
&                          k), pn(k), en(k))
          ELSE
            pn(k) = 0._sp
            en(k) = 0._sp
          END IF
        END IF
      END DO
    END DO
! Forward MLP without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            input_layer(:) = (/ac_hp(k), ac_ht(k), pn(k), en(k)/)
            CALL FORWARD_MLP(weight_1, bias_1, weight_2, bias_2, &
&                      weight_3, bias_3, input_layer, output_layer(:, k)&
&                     )
          ELSE
            output_layer(:, k) = 0._sp
          END IF
        END IF
      END DO
    END DO
! Production and transfer with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_PRODUCTION(output_layer(1, k), output_layer(2, k), &
&                        pn(k), en(k), imperviousness, ac_cp(k), beta, &
&                        ac_hp(k), pr, perc, ps, es)
            CALL GR_THRESHOLD_EXCHANGE(output_layer(4, k), ac_kexc(k), &
&                                ac_aexc(k), ac_ht(k), l)
          ELSE
            pr = 0._sp
            perc = 0._sp
            l = 0._sp
          END IF
! Range of correction c0.9: (1, 0)
          prr = 0.9_sp*(1._sp-output_layer(3, k)**2)*(pr+perc) + l
! Range of correction c0.1: (1, 10)
          prd = (0.1_sp+0.9_sp*output_layer(3, k)**2)*(pr+perc)
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prr, ac_ct(k), ac_ht(k), &
&                    qr)
          IF (0._sp .LT. prd + l) THEN
            qd = prd + l
          ELSE
            qd = 0._sp
          END IF
          ac_qt(k) = qr + qd
! Transform from mm/dt to m3/s
          ac_qt(k) = ac_qt(k)*1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col&
&           )/setup%dt
        END IF
      END DO
    END DO
  END SUBROUTINE GR5_MLP_TIME_STEP

!  Differentiation of gr5_ri_time_step in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: ac_qt ac_hi ac_hp ac_ht
!   with respect to varying inputs: ac_kexc ac_ci ac_cp ac_ct ac_alpha1
!                ac_alpha2 ac_qt ac_hi ac_hp ac_ht ac_mlt ac_aexc
  SUBROUTINE GR5_RI_TIME_STEP_D(setup, mesh, input_data, options, &
&   returns, time_step, ac_mlt, ac_mlt_d, ac_ci, ac_ci_d, ac_cp, ac_cp_d&
&   , ac_ct, ac_ct_d, ac_alpha1, ac_alpha1_d, ac_alpha2, ac_alpha2_d, &
&   ac_kexc, ac_kexc_d, ac_aexc, ac_aexc_d, ac_hi, ac_hi_d, ac_hp, &
&   ac_hp_d, ac_ht, ac_ht_d, ac_qt, ac_qt_d)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_kexc, ac_aexc
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci_d, ac_cp_d, &
&   ac_ct_d, ac_kexc_d, ac_aexc_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_alpha1, ac_alpha2
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_alpha1_d, &
&   ac_alpha2_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi_d, ac_hp_d, &
&   ac_ht_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_d
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_d
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, pn, en, imperviousness, pr, perc, ps, es, l, prr, &
&   prd, qr, qd, split
    REAL(sp) :: pn_d, en_d, pr_d, perc_d, l_d, prr_d, prd_d, qr_d, qd_d&
&   , split_d
    INTRINSIC TANH
    INTRINSIC MAX
    REAL(sp) :: temp
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp_d = ac_mlt_d
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
    pn_d = 0.0_4
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_INTERCEPTION_D(ac_prcp(k), ac_prcp_d(k), ac_pet(k), &
&                            ac_ci(k), ac_ci_d(k), ac_hi(k), ac_hi_d(k)&
&                            , pn, pn_d, en, en_d)
            CALL GR_RI_PRODUCTION_D(pn, pn_d, en, en_d, imperviousness, &
&                             ac_cp(k), ac_cp_d(k), beta, ac_alpha1(k), &
&                             ac_alpha1_d(k), ac_hp(k), ac_hp_d(k), pr, &
&                             pr_d, perc, perc_d, ps, es, setup%dt)
            CALL GR_THRESHOLD_EXCHANGE_D(0._sp, 0.0_4, ac_kexc(k), &
&                                  ac_kexc_d(k), ac_aexc(k), ac_aexc_d(k&
&                                  ), ac_ht(k), ac_ht_d(k), l, l_d)
          ELSE
            pr = 0._sp
            perc = 0._sp
            l = 0._sp
            l_d = 0.0_4
            perc_d = 0.0_4
            pr_d = 0.0_4
          END IF
          split_d = 0.9_sp*2*TANH(ac_alpha2(k)*pn)*(1.0-TANH(ac_alpha2(k&
&           )*pn)**2)*(pn*ac_alpha2_d(k)+ac_alpha2(k)*pn_d)
          split = 0.9_sp*TANH(ac_alpha2(k)*pn)**2 + 0.1_sp
          prr_d = (1._sp-split)*(pr_d+perc_d) - (pr+perc)*split_d + l_d
          prr = (1._sp-split)*(pr+perc) + l
          prd_d = (pr+perc)*split_d + split*(pr_d+perc_d)
          prd = split*(pr+perc)
          CALL GR_TRANSFER_D(5._sp, ac_prcp(k), prr, prr_d, ac_ct(k), &
&                      ac_ct_d(k), ac_ht(k), ac_ht_d(k), qr, qr_d)
          IF (0._sp .LT. prd + l) THEN
            qd_d = prd_d + l_d
            qd = prd + l
          ELSE
            qd = 0._sp
            qd_d = 0.0_4
          END IF
          ac_qt_d(k) = qr_d + qd_d
          ac_qt(k) = qr + qd
! Transform from mm/dt to m3/s
          temp = 1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col)
          ac_qt_d(k) = temp*ac_qt_d(k)/setup%dt
          ac_qt(k) = temp*(ac_qt(k)/setup%dt)
        END IF
      END DO
    END DO
  END SUBROUTINE GR5_RI_TIME_STEP_D

!  Differentiation of gr5_ri_time_step in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: ac_kexc ac_ci ac_cp ac_ct ac_alpha1
!                ac_alpha2 ac_qt ac_hi ac_hp ac_ht ac_mlt ac_aexc
!   with respect to varying inputs: ac_kexc ac_ci ac_cp ac_ct ac_alpha1
!                ac_alpha2 ac_qt ac_hi ac_hp ac_ht ac_mlt ac_aexc
  SUBROUTINE GR5_RI_TIME_STEP_B(setup, mesh, input_data, options, &
&   returns, time_step, ac_mlt, ac_mlt_b, ac_ci, ac_ci_b, ac_cp, ac_cp_b&
&   , ac_ct, ac_ct_b, ac_alpha1, ac_alpha1_b, ac_alpha2, ac_alpha2_b, &
&   ac_kexc, ac_kexc_b, ac_aexc, ac_aexc_b, ac_hi, ac_hi_b, ac_hp, &
&   ac_hp_b, ac_ht, ac_ht_b, ac_qt, ac_qt_b)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac) :: ac_mlt_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_kexc, ac_aexc
    REAL(sp), DIMENSION(mesh%nac) :: ac_ci_b, ac_cp_b, ac_ct_b, &
&   ac_kexc_b, ac_aexc_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_alpha1, ac_alpha2
    REAL(sp), DIMENSION(mesh%nac) :: ac_alpha1_b, ac_alpha2_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi_b, ac_hp_b, &
&   ac_ht_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_b
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_b
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, pn, en, imperviousness, pr, perc, ps, es, l, prr, &
&   prd, qr, qd, split
    REAL(sp) :: pn_b, en_b, pr_b, perc_b, l_b, prr_b, prd_b, qr_b, qd_b&
&   , split_b
    INTRINSIC TANH
    INTRINSIC MAX
    REAL(sp) :: dummydiff_b
    REAL(sp) :: temp_b
    INTEGER :: branch
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL1B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4(en)
            CALL PUSHREAL4(pn)
            CALL PUSHREAL4(ac_hi(k))
            CALL GR_INTERCEPTION(ac_prcp(k), ac_pet(k), ac_ci(k), ac_hi(&
&                          k), pn, en)
            CALL PUSHREAL4(perc)
            CALL PUSHREAL4(pr)
            CALL PUSHREAL4(ac_hp(k))
            CALL PUSHREAL4(pn)
            CALL GR_RI_PRODUCTION(pn, en, imperviousness, ac_cp(k), beta&
&                           , ac_alpha1(k), ac_hp(k), pr, perc, ps, es, &
&                           setup%dt)
            CALL GR_THRESHOLD_EXCHANGE(0._sp, ac_kexc(k), ac_aexc(k), &
&                                ac_ht(k), l)
            CALL PUSHCONTROL1B(1)
          ELSE
            CALL PUSHREAL4(pr)
            pr = 0._sp
            CALL PUSHREAL4(perc)
            perc = 0._sp
            l = 0._sp
            CALL PUSHCONTROL1B(0)
          END IF
          CALL PUSHREAL4(split)
          split = 0.9_sp*TANH(ac_alpha2(k)*pn)**2 + 0.1_sp
          CALL PUSHREAL4(prr)
          prr = (1._sp-split)*(pr+perc) + l
          prd = split*(pr+perc)
          CALL PUSHREAL4(ac_ht(k))
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prr, ac_ct(k), ac_ht(k), &
&                    qr)
          IF (0._sp .LT. prd + l) THEN
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHCONTROL1B(1)
          END IF
          CALL PUSHCONTROL1B(1)
        END IF
      END DO
    END DO
    ac_prcp_b = 0.0_4
    pn_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          ac_qt_b(k) = mesh%dx(row, col)*1e-3_sp*mesh%dy(row, col)*&
&           ac_qt_b(k)/setup%dt
          qr_b = ac_qt_b(k)
          qd_b = ac_qt_b(k)
          ac_qt_b(k) = 0.0_4
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            prd_b = qd_b
            l_b = qd_b
          ELSE
            l_b = 0.0_4
            prd_b = 0.0_4
          END IF
          CALL POPREAL4(ac_ht(k))
          CALL GR_TRANSFER_B(5._sp, ac_prcp(k), prr, prr_b, ac_ct(k), &
&                      ac_ct_b(k), ac_ht(k), ac_ht_b(k), qr, qr_b)
          split_b = (pr+perc)*prd_b - (pr+perc)*prr_b
          pr_b = split*prd_b + (1._sp-split)*prr_b
          perc_b = split*prd_b + (1._sp-split)*prr_b
          CALL POPREAL4(prr)
          l_b = l_b + prr_b
          CALL POPREAL4(split)
          temp_b = (1.0-TANH(ac_alpha2(k)*pn)**2)*2*TANH(ac_alpha2(k)*pn&
&           )*0.9_sp*split_b
          ac_alpha2_b(k) = ac_alpha2_b(k) + pn*temp_b
          pn_b = pn_b + ac_alpha2(k)*temp_b
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            CALL POPREAL4(perc)
            CALL POPREAL4(pr)
          ELSE
            CALL GR_THRESHOLD_EXCHANGE_B(0._sp, dummydiff_b, ac_kexc(k)&
&                                  , ac_kexc_b(k), ac_aexc(k), ac_aexc_b&
&                                  (k), ac_ht(k), ac_ht_b(k), l, l_b)
            imperviousness = input_data%physio_data%imperviousness(row, &
&             col)
            CALL POPREAL4(pn)
            CALL POPREAL4(ac_hp(k))
            CALL POPREAL4(pr)
            CALL POPREAL4(perc)
            CALL GR_RI_PRODUCTION_B(pn, pn_b, en, en_b, imperviousness, &
&                             ac_cp(k), ac_cp_b(k), beta, ac_alpha1(k), &
&                             ac_alpha1_b(k), ac_hp(k), ac_hp_b(k), pr, &
&                             pr_b, perc, perc_b, ps, es, setup%dt)
            CALL POPREAL4(ac_hi(k))
            CALL POPREAL4(pn)
            CALL POPREAL4(en)
            CALL GR_INTERCEPTION_B(ac_prcp(k), ac_prcp_b(k), ac_pet(k), &
&                            ac_ci(k), ac_ci_b(k), ac_hi(k), ac_hi_b(k)&
&                            , pn, pn_b, en, en_b)
            pn_b = 0.0_4
          END IF
        END IF
      END DO
    END DO
    ac_mlt_b = ac_mlt_b + ac_prcp_b
  END SUBROUTINE GR5_RI_TIME_STEP_B

  SUBROUTINE GR5_RI_TIME_STEP(setup, mesh, input_data, options, returns&
&   , time_step, ac_mlt, ac_ci, ac_cp, ac_ct, ac_alpha1, ac_alpha2, &
&   ac_kexc, ac_aexc, ac_hi, ac_hp, ac_ht, ac_qt)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_kexc, ac_aexc
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_alpha1, ac_alpha2
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, pn, en, imperviousness, pr, perc, ps, es, l, prr, &
&   prd, qr, qd, split
    INTRINSIC TANH
    INTRINSIC MAX
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_INTERCEPTION(ac_prcp(k), ac_pet(k), ac_ci(k), ac_hi(&
&                          k), pn, en)
            CALL GR_RI_PRODUCTION(pn, en, imperviousness, ac_cp(k), beta&
&                           , ac_alpha1(k), ac_hp(k), pr, perc, ps, es, &
&                           setup%dt)
            CALL GR_THRESHOLD_EXCHANGE(0._sp, ac_kexc(k), ac_aexc(k), &
&                                ac_ht(k), l)
          ELSE
            pr = 0._sp
            perc = 0._sp
            l = 0._sp
          END IF
          split = 0.9_sp*TANH(ac_alpha2(k)*pn)**2 + 0.1_sp
          prr = (1._sp-split)*(pr+perc) + l
          prd = split*(pr+perc)
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prr, ac_ct(k), ac_ht(k), &
&                    qr)
          IF (0._sp .LT. prd + l) THEN
            qd = prd + l
          ELSE
            qd = 0._sp
          END IF
          ac_qt(k) = qr + qd
! Transform from mm/dt to m3/s
          ac_qt(k) = ac_qt(k)*1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col&
&           )/setup%dt
        END IF
      END DO
    END DO
  END SUBROUTINE GR5_RI_TIME_STEP

!  Differentiation of gr6_time_step in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: ac_qt ac_he ac_hi ac_hp ac_ht
!   with respect to varying inputs: ac_kexc ac_ci ac_cp ac_ct ac_qt
!                ac_he ac_hi ac_hp ac_be ac_ht ac_mlt ac_aexc
  SUBROUTINE GR6_TIME_STEP_D(setup, mesh, input_data, options, returns, &
&   time_step, ac_mlt, ac_mlt_d, ac_ci, ac_ci_d, ac_cp, ac_cp_d, ac_ct, &
&   ac_ct_d, ac_be, ac_be_d, ac_kexc, ac_kexc_d, ac_aexc, ac_aexc_d, &
&   ac_hi, ac_hi_d, ac_hp, ac_hp_d, ac_ht, ac_ht_d, ac_he, ac_he_d, &
&   ac_qt, ac_qt_d)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_be, ac_kexc, ac_aexc
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci_d, ac_cp_d, &
&   ac_ct_d, ac_be_d, ac_kexc_d, ac_aexc_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht&
&   , ac_he
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi_d, ac_hp_d, &
&   ac_ht_d, ac_he_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_d
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_d
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, pn, en, imperviousness, pr, perc, ps, es, l, prr, &
&   pre, prd, qr, qd, qe
    REAL(sp) :: pn_d, en_d, pr_d, perc_d, l_d, prr_d, pre_d, prd_d, qr_d&
&   , qd_d, qe_d
    INTRINSIC MAX
    REAL(sp) :: temp
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp_d = ac_mlt_d
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_INTERCEPTION_D(ac_prcp(k), ac_prcp_d(k), ac_pet(k), &
&                            ac_ci(k), ac_ci_d(k), ac_hi(k), ac_hi_d(k)&
&                            , pn, pn_d, en, en_d)
            CALL GR_PRODUCTION_D(0._sp, 0.0_4, 0._sp, 0.0_4, pn, pn_d, &
&                          en, en_d, imperviousness, ac_cp(k), ac_cp_d(k&
&                          ), beta, ac_hp(k), ac_hp_d(k), pr, pr_d, perc&
&                          , perc_d, ps, es)
            CALL GR_THRESHOLD_EXCHANGE_D(0._sp, 0.0_4, ac_kexc(k), &
&                                  ac_kexc_d(k), ac_aexc(k), ac_aexc_d(k&
&                                  ), ac_ht(k), ac_ht_d(k), l, l_d)
          ELSE
            pr = 0._sp
            perc = 0._sp
            l = 0._sp
            l_d = 0.0_4
            perc_d = 0.0_4
            pr_d = 0.0_4
          END IF
          prr_d = 0.9_sp*0.6_sp*(pr_d+perc_d) + l_d
          prr = 0.6_sp*0.9_sp*(pr+perc) + l
          pre_d = 0.9_sp*0.4_sp*(pr_d+perc_d) + l_d
          pre = 0.4_sp*0.9_sp*(pr+perc) + l
          prd_d = 0.1_sp*(pr_d+perc_d)
          prd = 0.1_sp*(pr+perc)
          CALL GR_TRANSFER_D(5._sp, ac_prcp(k), prr, prr_d, ac_ct(k), &
&                      ac_ct_d(k), ac_ht(k), ac_ht_d(k), qr, qr_d)
          CALL GR_EXPONENTIAL_TRANSFER_D(pre, pre_d, ac_be(k), ac_be_d(k&
&                                  ), ac_he(k), ac_he_d(k), qe, qe_d)
          IF (0._sp .LT. prd + l) THEN
            qd_d = prd_d + l_d
            qd = prd + l
          ELSE
            qd = 0._sp
            qd_d = 0.0_4
          END IF
          ac_qt_d(k) = qr_d + qd_d + qe_d
          ac_qt(k) = qr + qd + qe
! Transform from mm/dt to m3/s
          temp = 1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col)
          ac_qt_d(k) = temp*ac_qt_d(k)/setup%dt
          ac_qt(k) = temp*(ac_qt(k)/setup%dt)
        END IF
      END DO
    END DO
  END SUBROUTINE GR6_TIME_STEP_D

!  Differentiation of gr6_time_step in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: ac_kexc ac_ci ac_cp ac_ct ac_qt
!                ac_he ac_hi ac_hp ac_be ac_ht ac_mlt ac_aexc
!   with respect to varying inputs: ac_kexc ac_ci ac_cp ac_ct ac_qt
!                ac_he ac_hi ac_hp ac_be ac_ht ac_mlt ac_aexc
  SUBROUTINE GR6_TIME_STEP_B(setup, mesh, input_data, options, returns, &
&   time_step, ac_mlt, ac_mlt_b, ac_ci, ac_ci_b, ac_cp, ac_cp_b, ac_ct, &
&   ac_ct_b, ac_be, ac_be_b, ac_kexc, ac_kexc_b, ac_aexc, ac_aexc_b, &
&   ac_hi, ac_hi_b, ac_hp, ac_hp_b, ac_ht, ac_ht_b, ac_he, ac_he_b, &
&   ac_qt, ac_qt_b)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac) :: ac_mlt_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_be, ac_kexc, ac_aexc
    REAL(sp), DIMENSION(mesh%nac) :: ac_ci_b, ac_cp_b, ac_ct_b, ac_be_b&
&   , ac_kexc_b, ac_aexc_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht&
&   , ac_he
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi_b, ac_hp_b, &
&   ac_ht_b, ac_he_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_b
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_b
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, pn, en, imperviousness, pr, perc, ps, es, l, prr, &
&   pre, prd, qr, qd, qe
    REAL(sp) :: pn_b, en_b, pr_b, perc_b, l_b, prr_b, pre_b, prd_b, qr_b&
&   , qd_b, qe_b
    INTRINSIC MAX
    REAL(sp) :: dummydiff_b
    REAL(sp) :: dummydiff_b0
    REAL(sp) :: dummydiff_b1
    REAL(sp) :: temp_b
    INTEGER :: branch
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL1B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4(en)
            CALL PUSHREAL4(ac_hi(k))
            CALL GR_INTERCEPTION(ac_prcp(k), ac_pet(k), ac_ci(k), ac_hi(&
&                          k), pn, en)
            CALL PUSHREAL4(ac_hp(k))
            CALL PUSHREAL4(pn)
            CALL GR_PRODUCTION(0._sp, 0._sp, pn, en, imperviousness, &
&                        ac_cp(k), beta, ac_hp(k), pr, perc, ps, es)
            CALL GR_THRESHOLD_EXCHANGE(0._sp, ac_kexc(k), ac_aexc(k), &
&                                ac_ht(k), l)
            CALL PUSHCONTROL1B(1)
          ELSE
            CALL PUSHCONTROL1B(0)
            pr = 0._sp
            perc = 0._sp
            l = 0._sp
          END IF
          CALL PUSHREAL4(prr)
          prr = 0.6_sp*0.9_sp*(pr+perc) + l
          CALL PUSHREAL4(pre)
          pre = 0.4_sp*0.9_sp*(pr+perc) + l
          prd = 0.1_sp*(pr+perc)
          CALL PUSHREAL4(ac_ht(k))
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prr, ac_ct(k), ac_ht(k), &
&                    qr)
          CALL PUSHREAL4(ac_he(k))
          CALL GR_EXPONENTIAL_TRANSFER(pre, ac_be(k), ac_he(k), qe)
          IF (0._sp .LT. prd + l) THEN
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHCONTROL1B(1)
          END IF
          CALL PUSHCONTROL1B(1)
        END IF
      END DO
    END DO
    ac_prcp_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          ac_qt_b(k) = mesh%dx(row, col)*1e-3_sp*mesh%dy(row, col)*&
&           ac_qt_b(k)/setup%dt
          qr_b = ac_qt_b(k)
          qd_b = ac_qt_b(k)
          qe_b = ac_qt_b(k)
          ac_qt_b(k) = 0.0_4
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            prd_b = qd_b
            l_b = qd_b
          ELSE
            l_b = 0.0_4
            prd_b = 0.0_4
          END IF
          CALL POPREAL4(ac_he(k))
          CALL GR_EXPONENTIAL_TRANSFER_B(pre, pre_b, ac_be(k), ac_be_b(k&
&                                  ), ac_he(k), ac_he_b(k), qe, qe_b)
          CALL POPREAL4(ac_ht(k))
          CALL GR_TRANSFER_B(5._sp, ac_prcp(k), prr, prr_b, ac_ct(k), &
&                      ac_ct_b(k), ac_ht(k), ac_ht_b(k), qr, qr_b)
          CALL POPREAL4(pre)
          temp_b = 0.9_sp*0.4_sp*pre_b
          pr_b = 0.1_sp*prd_b + temp_b
          perc_b = 0.1_sp*prd_b + temp_b
          l_b = l_b + pre_b + prr_b
          CALL POPREAL4(prr)
          temp_b = 0.9_sp*0.6_sp*prr_b
          pr_b = pr_b + temp_b
          perc_b = perc_b + temp_b
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) THEN
            CALL GR_THRESHOLD_EXCHANGE_B(0._sp, dummydiff_b1, ac_kexc(k)&
&                                  , ac_kexc_b(k), ac_aexc(k), ac_aexc_b&
&                                  (k), ac_ht(k), ac_ht_b(k), l, l_b)
            imperviousness = input_data%physio_data%imperviousness(row, &
&             col)
            CALL POPREAL4(pn)
            CALL POPREAL4(ac_hp(k))
            pn_b = 0.0_4
            en_b = 0.0_4
            CALL GR_PRODUCTION_B(0._sp, dummydiff_b, 0._sp, dummydiff_b0&
&                          , pn, pn_b, en, en_b, imperviousness, ac_cp(k&
&                          ), ac_cp_b(k), beta, ac_hp(k), ac_hp_b(k), pr&
&                          , pr_b, perc, perc_b, ps, es)
            CALL POPREAL4(ac_hi(k))
            CALL POPREAL4(en)
            CALL GR_INTERCEPTION_B(ac_prcp(k), ac_prcp_b(k), ac_pet(k), &
&                            ac_ci(k), ac_ci_b(k), ac_hi(k), ac_hi_b(k)&
&                            , pn, pn_b, en, en_b)
          END IF
        END IF
      END DO
    END DO
    ac_mlt_b = ac_mlt_b + ac_prcp_b
  END SUBROUTINE GR6_TIME_STEP_B

  SUBROUTINE GR6_TIME_STEP(setup, mesh, input_data, options, returns, &
&   time_step, ac_mlt, ac_ci, ac_cp, ac_ct, ac_be, ac_kexc, ac_aexc, &
&   ac_hi, ac_hp, ac_ht, ac_he, ac_qt)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_be, ac_kexc, ac_aexc
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht&
&   , ac_he
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, pn, en, imperviousness, pr, perc, ps, es, l, prr, &
&   pre, prd, qr, qd, qe
    INTRINSIC MAX
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_INTERCEPTION(ac_prcp(k), ac_pet(k), ac_ci(k), ac_hi(&
&                          k), pn, en)
            CALL GR_PRODUCTION(0._sp, 0._sp, pn, en, imperviousness, &
&                        ac_cp(k), beta, ac_hp(k), pr, perc, ps, es)
            CALL GR_THRESHOLD_EXCHANGE(0._sp, ac_kexc(k), ac_aexc(k), &
&                                ac_ht(k), l)
          ELSE
            pr = 0._sp
            perc = 0._sp
            l = 0._sp
          END IF
          prr = 0.6_sp*0.9_sp*(pr+perc) + l
          pre = 0.4_sp*0.9_sp*(pr+perc) + l
          prd = 0.1_sp*(pr+perc)
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prr, ac_ct(k), ac_ht(k), &
&                    qr)
          CALL GR_EXPONENTIAL_TRANSFER(pre, ac_be(k), ac_he(k), qe)
          IF (0._sp .LT. prd + l) THEN
            qd = prd + l
          ELSE
            qd = 0._sp
          END IF
          ac_qt(k) = qr + qd + qe
! Transform from mm/dt to m3/s
          ac_qt(k) = ac_qt(k)*1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col&
&           )/setup%dt
        END IF
      END DO
    END DO
  END SUBROUTINE GR6_TIME_STEP

!  Differentiation of gr6_mlp_time_step in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: ac_qt ac_he ac_hi ac_hp ac_ht
!   with respect to varying inputs: ac_kexc ac_ci ac_cp ac_ct bias_1
!                bias_2 bias_3 ac_qt ac_he ac_hi ac_hp weight_1
!                weight_2 ac_be weight_3 ac_ht ac_mlt ac_aexc
  SUBROUTINE GR6_MLP_TIME_STEP_D(setup, mesh, input_data, options, &
&   returns, time_step, weight_1, weight_1_d, bias_1, bias_1_d, weight_2&
&   , weight_2_d, bias_2, bias_2_d, weight_3, weight_3_d, bias_3, &
&   bias_3_d, ac_mlt, ac_mlt_d, ac_ci, ac_ci_d, ac_cp, ac_cp_d, ac_ct, &
&   ac_ct_d, ac_be, ac_be_d, ac_kexc, ac_kexc_d, ac_aexc, ac_aexc_d, &
&   ac_hi, ac_hi_d, ac_hp, ac_hp_d, ac_ht, ac_ht_d, ac_he, ac_he_d, &
&   ac_qt, ac_qt_d)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1_d
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1_d
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2_d
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2_d
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3_d
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_be, ac_kexc, ac_aexc
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci_d, ac_cp_d, &
&   ac_ct_d, ac_be_d, ac_kexc_d, ac_aexc_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht&
&   , ac_he
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi_d, ac_hp_d, &
&   ac_ht_d, ac_he_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_d
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer_d
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer_d
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet, pn, en
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_d, pn_d, en_d
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, imperviousness, pr, perc, ps, es, l, prr, pre, prd&
&   , qr, qd, qe
    REAL(sp) :: pr_d, perc_d, l_d, prr_d, pre_d, prd_d, qr_d, qd_d, qe_d
    INTRINSIC MAX
    REAL(sp) :: temp
    REAL(sp) :: temp0
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp_d = ac_mlt_d
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
    en_d = 0.0_4
    pn_d = 0.0_4
! Interception with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_INTERCEPTION_D(ac_prcp(k), ac_prcp_d(k), ac_pet(k), &
&                            ac_ci(k), ac_ci_d(k), ac_hi(k), ac_hi_d(k)&
&                            , pn(k), pn_d(k), en(k), en_d(k))
          ELSE
            pn_d(k) = 0.0_4
            pn(k) = 0._sp
            en_d(k) = 0.0_4
            en(k) = 0._sp
          END IF
        END IF
      END DO
    END DO
    output_layer_d = 0.0_4
! Forward MLP without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            input_layer_d(:) = (/ac_hp_d(k), ac_ht_d(k), ac_he_d(k), &
&             pn_d(k), en_d(k)/)
            input_layer(:) = (/ac_hp(k), ac_ht(k), ac_he(k), pn(k), en(k&
&             )/)
            CALL FORWARD_MLP_D(weight_1, weight_1_d, bias_1, bias_1_d, &
&                        weight_2, weight_2_d, bias_2, bias_2_d, &
&                        weight_3, weight_3_d, bias_3, bias_3_d, &
&                        input_layer, input_layer_d, output_layer(:, k)&
&                        , output_layer_d(:, k))
          ELSE
            output_layer_d(:, k) = 0.0_4
            output_layer(:, k) = 0._sp
          END IF
        END IF
      END DO
    END DO
! Production and transfer with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_PRODUCTION_D(output_layer(1, k), output_layer_d(1, k&
&                          ), output_layer(2, k), output_layer_d(2, k), &
&                          pn(k), pn_d(k), en(k), en_d(k), &
&                          imperviousness, ac_cp(k), ac_cp_d(k), beta, &
&                          ac_hp(k), ac_hp_d(k), pr, pr_d, perc, perc_d&
&                          , ps, es)
            CALL GR_THRESHOLD_EXCHANGE_D(output_layer(5, k), &
&                                  output_layer_d(5, k), ac_kexc(k), &
&                                  ac_kexc_d(k), ac_aexc(k), ac_aexc_d(k&
&                                  ), ac_ht(k), ac_ht_d(k), l, l_d)
          ELSE
            pr = 0._sp
            perc = 0._sp
            l = 0._sp
            l_d = 0.0_4
            perc_d = 0.0_4
            pr_d = 0.0_4
          END IF
! Range of correction c0.6: (5/3, 1/3)
! Range of correction c0.9: (1, 0)
          temp = -(output_layer(3, k)*output_layer(3, k)) + 1._sp
          temp0 = -(0.4_sp*output_layer(4, k)) + 0.6_sp
          prr_d = 0.9_sp*(temp*(temp0*(pr_d+perc_d)-(pr+perc)*0.4_sp*&
&           output_layer_d(4, k))-temp0*(pr+perc)*2*output_layer(3, k)*&
&           output_layer_d(3, k)) + l_d
          prr = 0.9_sp*(temp0*(pr+perc)*temp) + l
! Range of correction c0.4: (0, 2)
! Range of correction c0.9: (1, 0)
          temp0 = -(output_layer(3, k)*output_layer(3, k)) + 1._sp
          temp = (output_layer(4, k)+1._sp)*(pr+perc)
          pre_d = 0.9_sp*0.4_sp*(temp0*((pr+perc)*output_layer_d(4, k)+(&
&           output_layer(4, k)+1._sp)*(pr_d+perc_d))-temp*2*output_layer&
&           (3, k)*output_layer_d(3, k)) + l_d
          pre = 0.9_sp*0.4_sp*(temp*temp0) + l
! Range of correction c0.1: (0, 10)
          temp0 = 0.9_sp*(output_layer(3, k)*output_layer(3, k)) + &
&           0.1_sp
          prd_d = (pr+perc)*0.9_sp*2*output_layer(3, k)*output_layer_d(3&
&           , k) + temp0*(pr_d+perc_d)
          prd = temp0*(pr+perc)
          CALL GR_TRANSFER_D(5._sp, ac_prcp(k), prr, prr_d, ac_ct(k), &
&                      ac_ct_d(k), ac_ht(k), ac_ht_d(k), qr, qr_d)
          CALL GR_EXPONENTIAL_TRANSFER_D(pre, pre_d, ac_be(k), ac_be_d(k&
&                                  ), ac_he(k), ac_he_d(k), qe, qe_d)
          IF (0._sp .LT. prd + l) THEN
            qd_d = prd_d + l_d
            qd = prd + l
          ELSE
            qd = 0._sp
            qd_d = 0.0_4
          END IF
          ac_qt_d(k) = qr_d + qd_d + qe_d
          ac_qt(k) = qr + qd + qe
! Transform from mm/dt to m3/s
          temp0 = 1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col)
          ac_qt_d(k) = temp0*ac_qt_d(k)/setup%dt
          ac_qt(k) = temp0*(ac_qt(k)/setup%dt)
        END IF
      END DO
    END DO
  END SUBROUTINE GR6_MLP_TIME_STEP_D

!  Differentiation of gr6_mlp_time_step in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: ac_kexc ac_ci ac_cp ac_ct bias_1
!                bias_2 bias_3 ac_qt ac_he ac_hi ac_hp weight_1
!                weight_2 ac_be weight_3 ac_ht ac_mlt ac_aexc
!   with respect to varying inputs: ac_kexc ac_ci ac_cp ac_ct bias_1
!                bias_2 bias_3 ac_qt ac_he ac_hi ac_hp weight_1
!                weight_2 ac_be weight_3 ac_ht ac_mlt ac_aexc
  SUBROUTINE GR6_MLP_TIME_STEP_B(setup, mesh, input_data, options, &
&   returns, time_step, weight_1, weight_1_b, bias_1, bias_1_b, weight_2&
&   , weight_2_b, bias_2, bias_2_b, weight_3, weight_3_b, bias_3, &
&   bias_3_b, ac_mlt, ac_mlt_b, ac_ci, ac_ci_b, ac_cp, ac_cp_b, ac_ct, &
&   ac_ct_b, ac_be, ac_be_b, ac_kexc, ac_kexc_b, ac_aexc, ac_aexc_b, &
&   ac_hi, ac_hi_b, ac_hp, ac_hp_b, ac_ht, ac_ht_b, ac_he, ac_he_b, &
&   ac_qt, ac_qt_b)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)) :: &
&   weight_1_b
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(setup%neurons(2)) :: bias_1_b
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)) :: &
&   weight_2_b
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(setup%neurons(3)) :: bias_2_b
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)) :: &
&   weight_3_b
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(setup%neurons(4)) :: bias_3_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac) :: ac_mlt_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_be, ac_kexc, ac_aexc
    REAL(sp), DIMENSION(mesh%nac) :: ac_ci_b, ac_cp_b, ac_ct_b, ac_be_b&
&   , ac_kexc_b, ac_aexc_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht&
&   , ac_he
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi_b, ac_hp_b, &
&   ac_ht_b, ac_he_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_b
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer_b
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer_b
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet, pn, en
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_b, pn_b, en_b
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, imperviousness, pr, perc, ps, es, l, prr, pre, prd&
&   , qr, qd, qe
    REAL(sp) :: pr_b, perc_b, l_b, prr_b, pre_b, prd_b, qr_b, qd_b, qe_b
    INTRINSIC MAX
    REAL(sp) :: temp_b
    REAL(sp) :: temp
    REAL(sp) :: temp_b0
    REAL(sp) :: temp_b1
    INTEGER :: branch
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
! Interception with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL2B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4(ac_hi(k))
            CALL GR_INTERCEPTION(ac_prcp(k), ac_pet(k), ac_ci(k), ac_hi(&
&                          k), pn(k), en(k))
            CALL PUSHCONTROL2B(2)
          ELSE
            pn(k) = 0._sp
            en(k) = 0._sp
            CALL PUSHCONTROL2B(1)
          END IF
        END IF
      END DO
    END DO
! Forward MLP without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL2B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4ARRAY(input_layer, setup%neurons(1))
            input_layer(:) = (/ac_hp(k), ac_ht(k), ac_he(k), pn(k), en(k&
&             )/)
            CALL FORWARD_MLP(weight_1, bias_1, weight_2, bias_2, &
&                      weight_3, bias_3, input_layer, output_layer(:, k)&
&                     )
            CALL PUSHCONTROL2B(2)
          ELSE
            output_layer(:, k) = 0._sp
            CALL PUSHCONTROL2B(1)
          END IF
        END IF
      END DO
    END DO
! Production and transfer with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHINTEGER4(k)
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4(perc)
            CALL PUSHREAL4(pr)
            CALL PUSHREAL4(ac_hp(k))
            CALL PUSHREAL4(pn(k))
            CALL GR_PRODUCTION(output_layer(1, k), output_layer(2, k), &
&                        pn(k), en(k), imperviousness, ac_cp(k), beta, &
&                        ac_hp(k), pr, perc, ps, es)
            CALL GR_THRESHOLD_EXCHANGE(output_layer(5, k), ac_kexc(k), &
&                                ac_aexc(k), ac_ht(k), l)
            CALL PUSHCONTROL1B(1)
          ELSE
            CALL PUSHREAL4(pr)
            pr = 0._sp
            CALL PUSHREAL4(perc)
            perc = 0._sp
            l = 0._sp
            CALL PUSHCONTROL1B(0)
          END IF
! Range of correction c0.6: (5/3, 1/3)
! Range of correction c0.9: (1, 0)
          CALL PUSHREAL4(prr)
          prr = (0.6_sp-0.4_sp*output_layer(4, k))*(0.9_sp*(1._sp-&
&           output_layer(3, k)**2))*(pr+perc) + l
! Range of correction c0.4: (0, 2)
! Range of correction c0.9: (1, 0)
          CALL PUSHREAL4(pre)
          pre = 0.4_sp*(1._sp+output_layer(4, k))*(0.9_sp*(1._sp-&
&           output_layer(3, k)**2))*(pr+perc) + l
! Range of correction c0.1: (0, 10)
          prd = (0.1_sp+0.9_sp*output_layer(3, k)**2)*(pr+perc)
          CALL PUSHREAL4(ac_ht(k))
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prr, ac_ct(k), ac_ht(k), &
&                    qr)
          CALL PUSHREAL4(ac_he(k))
          CALL GR_EXPONENTIAL_TRANSFER(pre, ac_be(k), ac_he(k), qe)
          IF (0._sp .LT. prd + l) THEN
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHCONTROL1B(1)
          END IF
          CALL PUSHCONTROL1B(1)
        END IF
      END DO
    END DO
    output_layer_b = 0.0_4
    en_b = 0.0_4
    pn_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) THEN
          ac_qt_b(k) = mesh%dx(row, col)*1e-3_sp*mesh%dy(row, col)*&
&           ac_qt_b(k)/setup%dt
          qr_b = ac_qt_b(k)
          qd_b = ac_qt_b(k)
          qe_b = ac_qt_b(k)
          ac_qt_b(k) = 0.0_4
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            prd_b = qd_b
            l_b = qd_b
          ELSE
            l_b = 0.0_4
            prd_b = 0.0_4
          END IF
          temp = -(0.4_sp*output_layer(4, k)) + 0.6_sp
          CALL POPREAL4(ac_he(k))
          CALL GR_EXPONENTIAL_TRANSFER_B(pre, pre_b, ac_be(k), ac_be_b(k&
&                                  ), ac_he(k), ac_he_b(k), qe, qe_b)
          CALL POPREAL4(ac_ht(k))
          CALL GR_TRANSFER_B(5._sp, ac_prcp(k), prr, prr_b, ac_ct(k), &
&                      ac_ct_b(k), ac_ht(k), ac_ht_b(k), qr, qr_b)
          temp_b1 = (0.9_sp*output_layer(3, k)**2+0.1_sp)*prd_b
          pr_b = temp_b1
          perc_b = temp_b1
          CALL POPREAL4(pre)
          temp_b0 = 0.9_sp*0.4_sp*pre_b
          output_layer_b(3, k) = output_layer_b(3, k) + 2*output_layer(3&
&           , k)*0.9_sp*(pr+perc)*prd_b - 2*output_layer(3, k)*(&
&           output_layer(4, k)+1._sp)*(pr+perc)*temp_b0 - 2*output_layer&
&           (3, k)*temp*(pr+perc)*0.9_sp*prr_b
          l_b = l_b + pre_b + prr_b
          temp_b = (1._sp-output_layer(3, k)**2)*temp_b0
          output_layer_b(4, k) = output_layer_b(4, k) + (pr+perc)*temp_b
          temp_b1 = (output_layer(4, k)+1._sp)*temp_b
          CALL POPREAL4(prr)
          temp_b = (1._sp-output_layer(3, k)**2)*0.9_sp*prr_b
          pr_b = pr_b + temp_b1 + temp*temp_b
          perc_b = perc_b + temp_b1 + temp*temp_b
          output_layer_b(4, k) = output_layer_b(4, k) - 0.4_sp*(pr+perc)&
&           *temp_b
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            CALL POPREAL4(perc)
            CALL POPREAL4(pr)
          ELSE
            CALL GR_THRESHOLD_EXCHANGE_B(output_layer(5, k), &
&                                  output_layer_b(5, k), ac_kexc(k), &
&                                  ac_kexc_b(k), ac_aexc(k), ac_aexc_b(k&
&                                  ), ac_ht(k), ac_ht_b(k), l, l_b)
            imperviousness = input_data%physio_data%imperviousness(row, &
&             col)
            CALL POPREAL4(pn(k))
            CALL POPREAL4(ac_hp(k))
            CALL POPREAL4(pr)
            CALL POPREAL4(perc)
            CALL GR_PRODUCTION_B(output_layer(1, k), output_layer_b(1, k&
&                          ), output_layer(2, k), output_layer_b(2, k), &
&                          pn(k), pn_b(k), en(k), en_b(k), &
&                          imperviousness, ac_cp(k), ac_cp_b(k), beta, &
&                          ac_hp(k), ac_hp_b(k), pr, pr_b, perc, perc_b&
&                          , ps, es)
          END IF
          CALL POPINTEGER4(k)
        END IF
      END DO
    END DO
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL2B(branch)
        IF (branch .NE. 0) THEN
          IF (branch .EQ. 1) THEN
            k = mesh%rowcol_to_ind_ac(row, col)
            output_layer_b(:, k) = 0.0_4
          ELSE
            k = mesh%rowcol_to_ind_ac(row, col)
            CALL FORWARD_MLP_B(weight_1, weight_1_b, bias_1, bias_1_b, &
&                        weight_2, weight_2_b, bias_2, bias_2_b, &
&                        weight_3, weight_3_b, bias_3, bias_3_b, &
&                        input_layer, input_layer_b, output_layer(:, k)&
&                        , output_layer_b(:, k))
            output_layer_b(:, k) = 0.0_4
            CALL POPREAL4ARRAY(input_layer, setup%neurons(1))
            ac_hp_b(k) = ac_hp_b(k) + input_layer_b(1)
            ac_ht_b(k) = ac_ht_b(k) + input_layer_b(2)
            ac_he_b(k) = ac_he_b(k) + input_layer_b(3)
            pn_b(k) = pn_b(k) + input_layer_b(4)
            en_b(k) = en_b(k) + input_layer_b(5)
          END IF
        END IF
      END DO
    END DO
    ac_prcp_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL2B(branch)
        IF (branch .NE. 0) THEN
          IF (branch .EQ. 1) THEN
            k = mesh%rowcol_to_ind_ac(row, col)
            en_b(k) = 0.0_4
            pn_b(k) = 0.0_4
          ELSE
            k = mesh%rowcol_to_ind_ac(row, col)
            CALL POPREAL4(ac_hi(k))
            CALL GR_INTERCEPTION_B(ac_prcp(k), ac_prcp_b(k), ac_pet(k), &
&                            ac_ci(k), ac_ci_b(k), ac_hi(k), ac_hi_b(k)&
&                            , pn(k), pn_b(k), en(k), en_b(k))
            pn_b(k) = 0.0_4
            en_b(k) = 0.0_4
          END IF
        END IF
      END DO
    END DO
    ac_mlt_b = ac_mlt_b + ac_prcp_b
  END SUBROUTINE GR6_MLP_TIME_STEP_B

  SUBROUTINE GR6_MLP_TIME_STEP(setup, mesh, input_data, options, returns&
&   , time_step, weight_1, bias_1, weight_2, bias_2, weight_3, bias_3, &
&   ac_mlt, ac_ci, ac_cp, ac_ct, ac_be, ac_kexc, ac_aexc, ac_hi, ac_hp, &
&   ac_ht, ac_he, ac_qt)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_be, ac_kexc, ac_aexc
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht&
&   , ac_he
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet, pn, en
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, imperviousness, pr, perc, ps, es, l, prr, pre, prd&
&   , qr, qd, qe
    INTRINSIC MAX
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
! Interception with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_INTERCEPTION(ac_prcp(k), ac_pet(k), ac_ci(k), ac_hi(&
&                          k), pn(k), en(k))
          ELSE
            pn(k) = 0._sp
            en(k) = 0._sp
          END IF
        END IF
      END DO
    END DO
! Forward MLP without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            input_layer(:) = (/ac_hp(k), ac_ht(k), ac_he(k), pn(k), en(k&
&             )/)
            CALL FORWARD_MLP(weight_1, bias_1, weight_2, bias_2, &
&                      weight_3, bias_3, input_layer, output_layer(:, k)&
&                     )
          ELSE
            output_layer(:, k) = 0._sp
          END IF
        END IF
      END DO
    END DO
! Production and transfer with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_PRODUCTION(output_layer(1, k), output_layer(2, k), &
&                        pn(k), en(k), imperviousness, ac_cp(k), beta, &
&                        ac_hp(k), pr, perc, ps, es)
            CALL GR_THRESHOLD_EXCHANGE(output_layer(5, k), ac_kexc(k), &
&                                ac_aexc(k), ac_ht(k), l)
          ELSE
            pr = 0._sp
            perc = 0._sp
            l = 0._sp
          END IF
! Range of correction c0.6: (5/3, 1/3)
! Range of correction c0.9: (1, 0)
          prr = (0.6_sp-0.4_sp*output_layer(4, k))*(0.9_sp*(1._sp-&
&           output_layer(3, k)**2))*(pr+perc) + l
! Range of correction c0.4: (0, 2)
! Range of correction c0.9: (1, 0)
          pre = 0.4_sp*(1._sp+output_layer(4, k))*(0.9_sp*(1._sp-&
&           output_layer(3, k)**2))*(pr+perc) + l
! Range of correction c0.1: (0, 10)
          prd = (0.1_sp+0.9_sp*output_layer(3, k)**2)*(pr+perc)
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prr, ac_ct(k), ac_ht(k), &
&                    qr)
          CALL GR_EXPONENTIAL_TRANSFER(pre, ac_be(k), ac_he(k), qe)
          IF (0._sp .LT. prd + l) THEN
            qd = prd + l
          ELSE
            qd = 0._sp
          END IF
          ac_qt(k) = qr + qd + qe
! Transform from mm/dt to m3/s
          ac_qt(k) = ac_qt(k)*1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col&
&           )/setup%dt
        END IF
      END DO
    END DO
  END SUBROUTINE GR6_MLP_TIME_STEP

!  Differentiation of grc_time_step in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: ac_qt ac_hi ac_hl ac_hp ac_ht
!   with respect to varying inputs: ac_kexc ac_ci ac_cl ac_cp ac_ct
!                ac_qt ac_hi ac_hl ac_hp ac_ht ac_mlt
  SUBROUTINE GRC_TIME_STEP_D(setup, mesh, input_data, options, returns, &
&   time_step, ac_mlt, ac_mlt_d, ac_ci, ac_ci_d, ac_cp, ac_cp_d, ac_ct, &
&   ac_ct_d, ac_cl, ac_cl_d, ac_kexc, ac_kexc_d, ac_hi, ac_hi_d, ac_hp, &
&   ac_hp_d, ac_ht, ac_ht_d, ac_hl, ac_hl_d, ac_qt, ac_qt_d)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_cl, ac_kexc
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci_d, ac_cp_d, &
&   ac_ct_d, ac_cl_d, ac_kexc_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht&
&   , ac_hl
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi_d, ac_hp_d, &
&   ac_ht_d, ac_hl_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_d
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_d
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: pn, en, imperviousness, pr, perc, ps, es, l, prr, prl, &
&   prd, qr, ql, qd
    REAL(sp) :: pn_d, en_d, pr_d, perc_d, l_d, prr_d, prl_d, prd_d, qr_d&
&   , ql_d, qd_d
    INTRINSIC MAX
    REAL(sp) :: temp
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp_d = ac_mlt_d
    ac_prcp = ac_prcp + ac_mlt
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_INTERCEPTION_D(ac_prcp(k), ac_prcp_d(k), ac_pet(k), &
&                            ac_ci(k), ac_ci_d(k), ac_hi(k), ac_hi_d(k)&
&                            , pn, pn_d, en, en_d)
            CALL GR_PRODUCTION_D(0._sp, 0.0_4, 0._sp, 0.0_4, pn, pn_d, &
&                          en, en_d, imperviousness, ac_cp(k), ac_cp_d(k&
&                          ), 1000._sp, ac_hp(k), ac_hp_d(k), pr, pr_d, &
&                          perc, perc_d, ps, es)
            CALL GR_EXCHANGE_D(0._sp, 0.0_4, ac_kexc(k), ac_kexc_d(k), &
&                        ac_ht(k), ac_ht_d(k), l, l_d)
          ELSE
            pr = 0._sp
            perc = 0._sp
            l = 0._sp
            l_d = 0.0_4
            perc_d = 0.0_4
            pr_d = 0.0_4
          END IF
          prr_d = 0.9_sp*0.6_sp*(pr_d+perc_d) + l_d
          prr = 0.6_sp*0.9_sp*(pr+perc) + l
          prl_d = 0.9_sp*0.4_sp*(pr_d+perc_d)
          prl = 0.4_sp*0.9_sp*(pr+perc)
          prd_d = 0.1_sp*(pr_d+perc_d)
          prd = 0.1_sp*(pr+perc)
          CALL GR_TRANSFER_D(5._sp, ac_prcp(k), prr, prr_d, ac_ct(k), &
&                      ac_ct_d(k), ac_ht(k), ac_ht_d(k), qr, qr_d)
          CALL GR_TRANSFER_D(5._sp, ac_prcp(k), prl, prl_d, ac_cl(k), &
&                      ac_cl_d(k), ac_hl(k), ac_hl_d(k), ql, ql_d)
          IF (0._sp .LT. prd + l) THEN
            qd_d = prd_d + l_d
            qd = prd + l
          ELSE
            qd = 0._sp
            qd_d = 0.0_4
          END IF
          ac_qt_d(k) = qr_d + ql_d + qd_d
          ac_qt(k) = qr + ql + qd
! Transform from mm/dt to m3/s
          temp = 1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col)
          ac_qt_d(k) = temp*ac_qt_d(k)/setup%dt
          ac_qt(k) = temp*(ac_qt(k)/setup%dt)
        END IF
      END DO
    END DO
  END SUBROUTINE GRC_TIME_STEP_D

!  Differentiation of grc_time_step in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: ac_kexc ac_ci ac_cl ac_cp ac_ct
!                ac_qt ac_hi ac_hl ac_hp ac_ht ac_mlt
!   with respect to varying inputs: ac_kexc ac_ci ac_cl ac_cp ac_ct
!                ac_qt ac_hi ac_hl ac_hp ac_ht ac_mlt
  SUBROUTINE GRC_TIME_STEP_B(setup, mesh, input_data, options, returns, &
&   time_step, ac_mlt, ac_mlt_b, ac_ci, ac_ci_b, ac_cp, ac_cp_b, ac_ct, &
&   ac_ct_b, ac_cl, ac_cl_b, ac_kexc, ac_kexc_b, ac_hi, ac_hi_b, ac_hp, &
&   ac_hp_b, ac_ht, ac_ht_b, ac_hl, ac_hl_b, ac_qt, ac_qt_b)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac) :: ac_mlt_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_cl, ac_kexc
    REAL(sp), DIMENSION(mesh%nac) :: ac_ci_b, ac_cp_b, ac_ct_b, ac_cl_b&
&   , ac_kexc_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht&
&   , ac_hl
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi_b, ac_hp_b, &
&   ac_ht_b, ac_hl_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_b
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_b
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: pn, en, imperviousness, pr, perc, ps, es, l, prr, prl, &
&   prd, qr, ql, qd
    REAL(sp) :: pn_b, en_b, pr_b, perc_b, l_b, prr_b, prl_b, prd_b, qr_b&
&   , ql_b, qd_b
    INTRINSIC MAX
    REAL(sp) :: dummydiff_b
    REAL(sp) :: dummydiff_b0
    REAL(sp) :: dummydiff_b1
    REAL(sp) :: temp_b
    INTEGER :: branch
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL1B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4(en)
            CALL PUSHREAL4(ac_hi(k))
            CALL GR_INTERCEPTION(ac_prcp(k), ac_pet(k), ac_ci(k), ac_hi(&
&                          k), pn, en)
            CALL PUSHREAL4(ac_hp(k))
            CALL PUSHREAL4(pn)
            CALL GR_PRODUCTION(0._sp, 0._sp, pn, en, imperviousness, &
&                        ac_cp(k), 1000._sp, ac_hp(k), pr, perc, ps, es)
            CALL GR_EXCHANGE(0._sp, ac_kexc(k), ac_ht(k), l)
            CALL PUSHCONTROL1B(1)
          ELSE
            CALL PUSHCONTROL1B(0)
            pr = 0._sp
            perc = 0._sp
            l = 0._sp
          END IF
          CALL PUSHREAL4(prr)
          prr = 0.6_sp*0.9_sp*(pr+perc) + l
          CALL PUSHREAL4(prl)
          prl = 0.4_sp*0.9_sp*(pr+perc)
          prd = 0.1_sp*(pr+perc)
          CALL PUSHREAL4(ac_ht(k))
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prr, ac_ct(k), ac_ht(k), &
&                    qr)
          CALL PUSHREAL4(ac_hl(k))
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prl, ac_cl(k), ac_hl(k), &
&                    ql)
          IF (0._sp .LT. prd + l) THEN
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHCONTROL1B(1)
          END IF
          CALL PUSHCONTROL1B(1)
        END IF
      END DO
    END DO
    ac_prcp_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          ac_qt_b(k) = mesh%dx(row, col)*1e-3_sp*mesh%dy(row, col)*&
&           ac_qt_b(k)/setup%dt
          qr_b = ac_qt_b(k)
          ql_b = ac_qt_b(k)
          qd_b = ac_qt_b(k)
          ac_qt_b(k) = 0.0_4
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            prd_b = qd_b
            l_b = qd_b
          ELSE
            l_b = 0.0_4
            prd_b = 0.0_4
          END IF
          CALL POPREAL4(ac_hl(k))
          CALL GR_TRANSFER_B(5._sp, ac_prcp(k), prl, prl_b, ac_cl(k), &
&                      ac_cl_b(k), ac_hl(k), ac_hl_b(k), ql, ql_b)
          CALL POPREAL4(ac_ht(k))
          CALL GR_TRANSFER_B(5._sp, ac_prcp(k), prr, prr_b, ac_ct(k), &
&                      ac_ct_b(k), ac_ht(k), ac_ht_b(k), qr, qr_b)
          CALL POPREAL4(prl)
          temp_b = 0.9_sp*0.4_sp*prl_b
          pr_b = 0.1_sp*prd_b + temp_b
          perc_b = 0.1_sp*prd_b + temp_b
          CALL POPREAL4(prr)
          temp_b = 0.9_sp*0.6_sp*prr_b
          l_b = l_b + prr_b
          pr_b = pr_b + temp_b
          perc_b = perc_b + temp_b
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) THEN
            CALL GR_EXCHANGE_B(0._sp, dummydiff_b1, ac_kexc(k), &
&                        ac_kexc_b(k), ac_ht(k), ac_ht_b(k), l, l_b)
            imperviousness = input_data%physio_data%imperviousness(row, &
&             col)
            CALL POPREAL4(pn)
            CALL POPREAL4(ac_hp(k))
            pn_b = 0.0_4
            en_b = 0.0_4
            CALL GR_PRODUCTION_B(0._sp, dummydiff_b, 0._sp, dummydiff_b0&
&                          , pn, pn_b, en, en_b, imperviousness, ac_cp(k&
&                          ), ac_cp_b(k), 1000._sp, ac_hp(k), ac_hp_b(k)&
&                          , pr, pr_b, perc, perc_b, ps, es)
            CALL POPREAL4(ac_hi(k))
            CALL POPREAL4(en)
            CALL GR_INTERCEPTION_B(ac_prcp(k), ac_prcp_b(k), ac_pet(k), &
&                            ac_ci(k), ac_ci_b(k), ac_hi(k), ac_hi_b(k)&
&                            , pn, pn_b, en, en_b)
          END IF
        END IF
      END DO
    END DO
    ac_mlt_b = ac_mlt_b + ac_prcp_b
  END SUBROUTINE GRC_TIME_STEP_B

  SUBROUTINE GRC_TIME_STEP(setup, mesh, input_data, options, returns, &
&   time_step, ac_mlt, ac_ci, ac_cp, ac_ct, ac_cl, ac_kexc, ac_hi, ac_hp&
&   , ac_ht, ac_hl, ac_qt)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_cl, ac_kexc
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht&
&   , ac_hl
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: pn, en, imperviousness, pr, perc, ps, es, l, prr, prl, &
&   prd, qr, ql, qd
    INTRINSIC MAX
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_INTERCEPTION(ac_prcp(k), ac_pet(k), ac_ci(k), ac_hi(&
&                          k), pn, en)
            CALL GR_PRODUCTION(0._sp, 0._sp, pn, en, imperviousness, &
&                        ac_cp(k), 1000._sp, ac_hp(k), pr, perc, ps, es)
            CALL GR_EXCHANGE(0._sp, ac_kexc(k), ac_ht(k), l)
          ELSE
            pr = 0._sp
            perc = 0._sp
            l = 0._sp
          END IF
          prr = 0.6_sp*0.9_sp*(pr+perc) + l
          prl = 0.4_sp*0.9_sp*(pr+perc)
          prd = 0.1_sp*(pr+perc)
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prr, ac_ct(k), ac_ht(k), &
&                    qr)
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prl, ac_cl(k), ac_hl(k), &
&                    ql)
          IF (0._sp .LT. prd + l) THEN
            qd = prd + l
          ELSE
            qd = 0._sp
          END IF
          ac_qt(k) = qr + ql + qd
! Transform from mm/dt to m3/s
          ac_qt(k) = ac_qt(k)*1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col&
&           )/setup%dt
        END IF
      END DO
    END DO
  END SUBROUTINE GRC_TIME_STEP

!  Differentiation of grc_mlp_time_step in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: ac_qt ac_hi ac_hl ac_hp ac_ht
!   with respect to varying inputs: ac_kexc ac_ci ac_cl ac_cp ac_ct
!                bias_1 bias_2 bias_3 ac_qt ac_hi ac_hl ac_hp weight_1
!                weight_2 weight_3 ac_ht ac_mlt
  SUBROUTINE GRC_MLP_TIME_STEP_D(setup, mesh, input_data, options, &
&   returns, time_step, weight_1, weight_1_d, bias_1, bias_1_d, weight_2&
&   , weight_2_d, bias_2, bias_2_d, weight_3, weight_3_d, bias_3, &
&   bias_3_d, ac_mlt, ac_mlt_d, ac_ci, ac_ci_d, ac_cp, ac_cp_d, ac_ct, &
&   ac_ct_d, ac_cl, ac_cl_d, ac_kexc, ac_kexc_d, ac_hi, ac_hi_d, ac_hp, &
&   ac_hp_d, ac_ht, ac_ht_d, ac_hl, ac_hl_d, ac_qt, ac_qt_d)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1_d
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1_d
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2_d
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2_d
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3_d
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_cl, ac_kexc
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci_d, ac_cp_d, &
&   ac_ct_d, ac_cl_d, ac_kexc_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht&
&   , ac_hl
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi_d, ac_hp_d, &
&   ac_ht_d, ac_hl_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_d
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer_d
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer_d
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet, pn, en
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_d, pn_d, en_d
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: imperviousness, pr, perc, ps, es, l, prr, prl, prd, qr, &
&   ql, qd
    REAL(sp) :: pr_d, perc_d, l_d, prr_d, prl_d, prd_d, qr_d, ql_d, qd_d
    INTRINSIC MAX
    REAL(sp) :: temp
    REAL(sp) :: temp0
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp_d = ac_mlt_d
    ac_prcp = ac_prcp + ac_mlt
    en_d = 0.0_4
    pn_d = 0.0_4
! Interception with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_INTERCEPTION_D(ac_prcp(k), ac_prcp_d(k), ac_pet(k), &
&                            ac_ci(k), ac_ci_d(k), ac_hi(k), ac_hi_d(k)&
&                            , pn(k), pn_d(k), en(k), en_d(k))
          ELSE
            pn_d(k) = 0.0_4
            pn(k) = 0._sp
            en_d(k) = 0.0_4
            en(k) = 0._sp
          END IF
        END IF
      END DO
    END DO
    output_layer_d = 0.0_4
! Forward MLP without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            input_layer_d(:) = (/ac_hp_d(k), ac_ht_d(k), ac_hl_d(k), &
&             pn_d(k), en_d(k)/)
            input_layer(:) = (/ac_hp(k), ac_ht(k), ac_hl(k), pn(k), en(k&
&             )/)
            CALL FORWARD_MLP_D(weight_1, weight_1_d, bias_1, bias_1_d, &
&                        weight_2, weight_2_d, bias_2, bias_2_d, &
&                        weight_3, weight_3_d, bias_3, bias_3_d, &
&                        input_layer, input_layer_d, output_layer(:, k)&
&                        , output_layer_d(:, k))
          ELSE
            output_layer_d(:, k) = 0.0_4
            output_layer(:, k) = 0._sp
          END IF
        END IF
      END DO
    END DO
! Production and transfer with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_PRODUCTION_D(output_layer(1, k), output_layer_d(1, k&
&                          ), output_layer(2, k), output_layer_d(2, k), &
&                          pn(k), pn_d(k), en(k), en_d(k), &
&                          imperviousness, ac_cp(k), ac_cp_d(k), &
&                          1000._sp, ac_hp(k), ac_hp_d(k), pr, pr_d, &
&                          perc, perc_d, ps, es)
            CALL GR_EXCHANGE_D(output_layer(5, k), output_layer_d(5, k)&
&                        , ac_kexc(k), ac_kexc_d(k), ac_ht(k), ac_ht_d(k&
&                        ), l, l_d)
          ELSE
            pr = 0._sp
            perc = 0._sp
            l = 0._sp
            l_d = 0.0_4
            perc_d = 0.0_4
            pr_d = 0.0_4
          END IF
! Range of correction c0.6: (5/3, 1/3)
! Range of correction c0.9: (1, 0)
          temp = -(output_layer(3, k)*output_layer(3, k)) + 1._sp
          temp0 = -(0.4_sp*output_layer(4, k)) + 0.6_sp
          prr_d = 0.9_sp*(temp*(temp0*(pr_d+perc_d)-(pr+perc)*0.4_sp*&
&           output_layer_d(4, k))-temp0*(pr+perc)*2*output_layer(3, k)*&
&           output_layer_d(3, k)) + l_d
          prr = 0.9_sp*(temp0*(pr+perc)*temp) + l
! Range of correction c0.4: (0, 2)
! Range of correction c0.9: (1, 0)
          temp0 = -(output_layer(3, k)*output_layer(3, k)) + 1._sp
          temp = (output_layer(4, k)+1._sp)*(pr+perc)
          prl_d = 0.9_sp*0.4_sp*(temp0*((pr+perc)*output_layer_d(4, k)+(&
&           output_layer(4, k)+1._sp)*(pr_d+perc_d))-temp*2*output_layer&
&           (3, k)*output_layer_d(3, k))
          prl = 0.9_sp*0.4_sp*(temp*temp0)
! Range of correction c0.1: (0, 10)
          temp0 = 0.9_sp*(output_layer(3, k)*output_layer(3, k)) + &
&           0.1_sp
          prd_d = (pr+perc)*0.9_sp*2*output_layer(3, k)*output_layer_d(3&
&           , k) + temp0*(pr_d+perc_d)
          prd = temp0*(pr+perc)
          CALL GR_TRANSFER_D(5._sp, ac_prcp(k), prr, prr_d, ac_ct(k), &
&                      ac_ct_d(k), ac_ht(k), ac_ht_d(k), qr, qr_d)
          CALL GR_TRANSFER_D(5._sp, ac_prcp(k), prl, prl_d, ac_cl(k), &
&                      ac_cl_d(k), ac_hl(k), ac_hl_d(k), ql, ql_d)
          IF (0._sp .LT. prd + l) THEN
            qd_d = prd_d + l_d
            qd = prd + l
          ELSE
            qd = 0._sp
            qd_d = 0.0_4
          END IF
          ac_qt_d(k) = qr_d + ql_d + qd_d
          ac_qt(k) = qr + ql + qd
! Transform from mm/dt to m3/s
          temp0 = 1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col)
          ac_qt_d(k) = temp0*ac_qt_d(k)/setup%dt
          ac_qt(k) = temp0*(ac_qt(k)/setup%dt)
        END IF
      END DO
    END DO
  END SUBROUTINE GRC_MLP_TIME_STEP_D

!  Differentiation of grc_mlp_time_step in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: ac_kexc ac_ci ac_cl ac_cp ac_ct
!                bias_1 bias_2 bias_3 ac_qt ac_hi ac_hl ac_hp weight_1
!                weight_2 weight_3 ac_ht ac_mlt
!   with respect to varying inputs: ac_kexc ac_ci ac_cl ac_cp ac_ct
!                bias_1 bias_2 bias_3 ac_qt ac_hi ac_hl ac_hp weight_1
!                weight_2 weight_3 ac_ht ac_mlt
  SUBROUTINE GRC_MLP_TIME_STEP_B(setup, mesh, input_data, options, &
&   returns, time_step, weight_1, weight_1_b, bias_1, bias_1_b, weight_2&
&   , weight_2_b, bias_2, bias_2_b, weight_3, weight_3_b, bias_3, &
&   bias_3_b, ac_mlt, ac_mlt_b, ac_ci, ac_ci_b, ac_cp, ac_cp_b, ac_ct, &
&   ac_ct_b, ac_cl, ac_cl_b, ac_kexc, ac_kexc_b, ac_hi, ac_hi_b, ac_hp, &
&   ac_hp_b, ac_ht, ac_ht_b, ac_hl, ac_hl_b, ac_qt, ac_qt_b)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)) :: &
&   weight_1_b
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(setup%neurons(2)) :: bias_1_b
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)) :: &
&   weight_2_b
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(setup%neurons(3)) :: bias_2_b
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)) :: &
&   weight_3_b
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(setup%neurons(4)) :: bias_3_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac) :: ac_mlt_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_cl, ac_kexc
    REAL(sp), DIMENSION(mesh%nac) :: ac_ci_b, ac_cp_b, ac_ct_b, ac_cl_b&
&   , ac_kexc_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht&
&   , ac_hl
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi_b, ac_hp_b, &
&   ac_ht_b, ac_hl_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_b
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer_b
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer_b
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet, pn, en
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_b, pn_b, en_b
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: imperviousness, pr, perc, ps, es, l, prr, prl, prd, qr, &
&   ql, qd
    REAL(sp) :: pr_b, perc_b, l_b, prr_b, prl_b, prd_b, qr_b, ql_b, qd_b
    INTRINSIC MAX
    REAL(sp) :: temp_b
    REAL(sp) :: temp
    REAL(sp) :: temp_b0
    REAL(sp) :: temp_b1
    INTEGER :: branch
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Interception with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL2B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4(ac_hi(k))
            CALL GR_INTERCEPTION(ac_prcp(k), ac_pet(k), ac_ci(k), ac_hi(&
&                          k), pn(k), en(k))
            CALL PUSHCONTROL2B(2)
          ELSE
            pn(k) = 0._sp
            en(k) = 0._sp
            CALL PUSHCONTROL2B(1)
          END IF
        END IF
      END DO
    END DO
! Forward MLP without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL2B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4ARRAY(input_layer, setup%neurons(1))
            input_layer(:) = (/ac_hp(k), ac_ht(k), ac_hl(k), pn(k), en(k&
&             )/)
            CALL FORWARD_MLP(weight_1, bias_1, weight_2, bias_2, &
&                      weight_3, bias_3, input_layer, output_layer(:, k)&
&                     )
            CALL PUSHCONTROL2B(2)
          ELSE
            output_layer(:, k) = 0._sp
            CALL PUSHCONTROL2B(1)
          END IF
        END IF
      END DO
    END DO
! Production and transfer with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHINTEGER4(k)
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4(perc)
            CALL PUSHREAL4(pr)
            CALL PUSHREAL4(ac_hp(k))
            CALL PUSHREAL4(pn(k))
            CALL GR_PRODUCTION(output_layer(1, k), output_layer(2, k), &
&                        pn(k), en(k), imperviousness, ac_cp(k), &
&                        1000._sp, ac_hp(k), pr, perc, ps, es)
            CALL GR_EXCHANGE(output_layer(5, k), ac_kexc(k), ac_ht(k), l&
&                     )
            CALL PUSHCONTROL1B(1)
          ELSE
            CALL PUSHREAL4(pr)
            pr = 0._sp
            CALL PUSHREAL4(perc)
            perc = 0._sp
            l = 0._sp
            CALL PUSHCONTROL1B(0)
          END IF
! Range of correction c0.6: (5/3, 1/3)
! Range of correction c0.9: (1, 0)
          CALL PUSHREAL4(prr)
          prr = (0.6_sp-0.4_sp*output_layer(4, k))*(0.9_sp*(1._sp-&
&           output_layer(3, k)**2))*(pr+perc) + l
! Range of correction c0.4: (0, 2)
! Range of correction c0.9: (1, 0)
          prl = 0.4_sp*(1._sp+output_layer(4, k))*(0.9_sp*(1._sp-&
&           output_layer(3, k)**2))*(pr+perc)
! Range of correction c0.1: (0, 10)
          prd = (0.1_sp+0.9_sp*output_layer(3, k)**2)*(pr+perc)
          CALL PUSHREAL4(ac_ht(k))
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prr, ac_ct(k), ac_ht(k), &
&                    qr)
          CALL PUSHREAL4(ac_hl(k))
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prl, ac_cl(k), ac_hl(k), &
&                    ql)
          IF (0._sp .LT. prd + l) THEN
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHCONTROL1B(1)
          END IF
          CALL PUSHCONTROL1B(1)
        END IF
      END DO
    END DO
    output_layer_b = 0.0_4
    en_b = 0.0_4
    pn_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) THEN
          ac_qt_b(k) = mesh%dx(row, col)*1e-3_sp*mesh%dy(row, col)*&
&           ac_qt_b(k)/setup%dt
          qr_b = ac_qt_b(k)
          ql_b = ac_qt_b(k)
          qd_b = ac_qt_b(k)
          ac_qt_b(k) = 0.0_4
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            prd_b = qd_b
            l_b = qd_b
          ELSE
            l_b = 0.0_4
            prd_b = 0.0_4
          END IF
          temp = -(0.4_sp*output_layer(4, k)) + 0.6_sp
          prl = 0.4_sp*(1._sp+output_layer(4, k))*(0.9_sp*(1._sp-&
&           output_layer(3, k)**2))*(pr+perc)
          CALL POPREAL4(ac_hl(k))
          CALL GR_TRANSFER_B(5._sp, ac_prcp(k), prl, prl_b, ac_cl(k), &
&                      ac_cl_b(k), ac_hl(k), ac_hl_b(k), ql, ql_b)
          CALL POPREAL4(ac_ht(k))
          CALL GR_TRANSFER_B(5._sp, ac_prcp(k), prr, prr_b, ac_ct(k), &
&                      ac_ct_b(k), ac_ht(k), ac_ht_b(k), qr, qr_b)
          temp_b1 = (0.9_sp*output_layer(3, k)**2+0.1_sp)*prd_b
          pr_b = temp_b1
          perc_b = temp_b1
          temp_b0 = 0.9_sp*0.4_sp*prl_b
          output_layer_b(3, k) = output_layer_b(3, k) + 2*output_layer(3&
&           , k)*0.9_sp*(pr+perc)*prd_b - 2*output_layer(3, k)*(&
&           output_layer(4, k)+1._sp)*(pr+perc)*temp_b0 - 2*output_layer&
&           (3, k)*temp*(pr+perc)*0.9_sp*prr_b
          temp_b = (1._sp-output_layer(3, k)**2)*temp_b0
          output_layer_b(4, k) = output_layer_b(4, k) + (pr+perc)*temp_b
          temp_b1 = (output_layer(4, k)+1._sp)*temp_b
          CALL POPREAL4(prr)
          temp_b = (1._sp-output_layer(3, k)**2)*0.9_sp*prr_b
          pr_b = pr_b + temp_b1 + temp*temp_b
          perc_b = perc_b + temp_b1 + temp*temp_b
          l_b = l_b + prr_b
          output_layer_b(4, k) = output_layer_b(4, k) - 0.4_sp*(pr+perc)&
&           *temp_b
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            CALL POPREAL4(perc)
            CALL POPREAL4(pr)
          ELSE
            CALL GR_EXCHANGE_B(output_layer(5, k), output_layer_b(5, k)&
&                        , ac_kexc(k), ac_kexc_b(k), ac_ht(k), ac_ht_b(k&
&                        ), l, l_b)
            imperviousness = input_data%physio_data%imperviousness(row, &
&             col)
            CALL POPREAL4(pn(k))
            CALL POPREAL4(ac_hp(k))
            CALL POPREAL4(pr)
            CALL POPREAL4(perc)
            CALL GR_PRODUCTION_B(output_layer(1, k), output_layer_b(1, k&
&                          ), output_layer(2, k), output_layer_b(2, k), &
&                          pn(k), pn_b(k), en(k), en_b(k), &
&                          imperviousness, ac_cp(k), ac_cp_b(k), &
&                          1000._sp, ac_hp(k), ac_hp_b(k), pr, pr_b, &
&                          perc, perc_b, ps, es)
          END IF
          CALL POPINTEGER4(k)
        END IF
      END DO
    END DO
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL2B(branch)
        IF (branch .NE. 0) THEN
          IF (branch .EQ. 1) THEN
            k = mesh%rowcol_to_ind_ac(row, col)
            output_layer_b(:, k) = 0.0_4
          ELSE
            k = mesh%rowcol_to_ind_ac(row, col)
            CALL FORWARD_MLP_B(weight_1, weight_1_b, bias_1, bias_1_b, &
&                        weight_2, weight_2_b, bias_2, bias_2_b, &
&                        weight_3, weight_3_b, bias_3, bias_3_b, &
&                        input_layer, input_layer_b, output_layer(:, k)&
&                        , output_layer_b(:, k))
            output_layer_b(:, k) = 0.0_4
            CALL POPREAL4ARRAY(input_layer, setup%neurons(1))
            ac_hp_b(k) = ac_hp_b(k) + input_layer_b(1)
            ac_ht_b(k) = ac_ht_b(k) + input_layer_b(2)
            ac_hl_b(k) = ac_hl_b(k) + input_layer_b(3)
            pn_b(k) = pn_b(k) + input_layer_b(4)
            en_b(k) = en_b(k) + input_layer_b(5)
          END IF
        END IF
      END DO
    END DO
    ac_prcp_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL2B(branch)
        IF (branch .NE. 0) THEN
          IF (branch .EQ. 1) THEN
            k = mesh%rowcol_to_ind_ac(row, col)
            en_b(k) = 0.0_4
            pn_b(k) = 0.0_4
          ELSE
            k = mesh%rowcol_to_ind_ac(row, col)
            CALL POPREAL4(ac_hi(k))
            CALL GR_INTERCEPTION_B(ac_prcp(k), ac_prcp_b(k), ac_pet(k), &
&                            ac_ci(k), ac_ci_b(k), ac_hi(k), ac_hi_b(k)&
&                            , pn(k), pn_b(k), en(k), en_b(k))
            pn_b(k) = 0.0_4
            en_b(k) = 0.0_4
          END IF
        END IF
      END DO
    END DO
    ac_mlt_b = ac_mlt_b + ac_prcp_b
  END SUBROUTINE GRC_MLP_TIME_STEP_B

  SUBROUTINE GRC_MLP_TIME_STEP(setup, mesh, input_data, options, returns&
&   , time_step, weight_1, bias_1, weight_2, bias_2, weight_3, bias_3, &
&   ac_mlt, ac_ci, ac_cp, ac_ct, ac_cl, ac_kexc, ac_hi, ac_hp, ac_ht, &
&   ac_hl, ac_qt)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ci, ac_cp, ac_ct, &
&   ac_cl, ac_kexc
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hi, ac_hp, ac_ht&
&   , ac_hl
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet, pn, en
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: imperviousness, pr, perc, ps, es, l, prr, prl, prd, qr, &
&   ql, qd
    INTRINSIC MAX
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Interception with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_INTERCEPTION(ac_prcp(k), ac_pet(k), ac_ci(k), ac_hi(&
&                          k), pn(k), en(k))
          ELSE
            pn(k) = 0._sp
            en(k) = 0._sp
          END IF
        END IF
      END DO
    END DO
! Forward MLP without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            input_layer(:) = (/ac_hp(k), ac_ht(k), ac_hl(k), pn(k), en(k&
&             )/)
            CALL FORWARD_MLP(weight_1, bias_1, weight_2, bias_2, &
&                      weight_3, bias_3, input_layer, output_layer(:, k)&
&                     )
          ELSE
            output_layer(:, k) = 0._sp
          END IF
        END IF
      END DO
    END DO
! Production and transfer with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_PRODUCTION(output_layer(1, k), output_layer(2, k), &
&                        pn(k), en(k), imperviousness, ac_cp(k), &
&                        1000._sp, ac_hp(k), pr, perc, ps, es)
            CALL GR_EXCHANGE(output_layer(5, k), ac_kexc(k), ac_ht(k), l&
&                     )
          ELSE
            pr = 0._sp
            perc = 0._sp
            l = 0._sp
          END IF
! Range of correction c0.6: (5/3, 1/3)
! Range of correction c0.9: (1, 0)
          prr = (0.6_sp-0.4_sp*output_layer(4, k))*(0.9_sp*(1._sp-&
&           output_layer(3, k)**2))*(pr+perc) + l
! Range of correction c0.4: (0, 2)
! Range of correction c0.9: (1, 0)
          prl = 0.4_sp*(1._sp+output_layer(4, k))*(0.9_sp*(1._sp-&
&           output_layer(3, k)**2))*(pr+perc)
! Range of correction c0.1: (0, 10)
          prd = (0.1_sp+0.9_sp*output_layer(3, k)**2)*(pr+perc)
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prr, ac_ct(k), ac_ht(k), &
&                    qr)
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prl, ac_cl(k), ac_hl(k), &
&                    ql)
          IF (0._sp .LT. prd + l) THEN
            qd = prd + l
          ELSE
            qd = 0._sp
          END IF
          ac_qt(k) = qr + ql + qd
! Transform from mm/dt to m3/s
          ac_qt(k) = ac_qt(k)*1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col&
&           )/setup%dt
        END IF
      END DO
    END DO
  END SUBROUTINE GRC_MLP_TIME_STEP

!  Differentiation of grd_time_step in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: ac_qt ac_hp ac_ht
!   with respect to varying inputs: ac_cp ac_ct ac_qt ac_hp ac_ht
!                ac_mlt
  SUBROUTINE GRD_TIME_STEP_D(setup, mesh, input_data, options, returns, &
&   time_step, ac_mlt, ac_mlt_d, ac_cp, ac_cp_d, ac_ct, ac_ct_d, ac_hp, &
&   ac_hp_d, ac_ht, ac_ht_d, ac_qt, ac_qt_d)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_cp, ac_ct
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_cp_d, ac_ct_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hp_d, ac_ht_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_d
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_d
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: ei, pn, en, imperviousness, pr, perc, ps, es, prr, qr
    REAL(sp) :: ei_d, pn_d, en_d, pr_d, perc_d, prr_d, qr_d
    INTRINSIC MIN
    INTRINSIC MAX
    REAL(sp) :: temp
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp_d = ac_mlt_d
    ac_prcp = ac_prcp + ac_mlt
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            IF (ac_pet(k) .GT. ac_prcp(k)) THEN
              ei_d = ac_prcp_d(k)
              ei = ac_prcp(k)
            ELSE
              ei = ac_pet(k)
              ei_d = 0.0_4
            END IF
            IF (0._sp .LT. ac_prcp(k) - ei) THEN
              pn_d = ac_prcp_d(k) - ei_d
              pn = ac_prcp(k) - ei
            ELSE
              pn = 0._sp
              pn_d = 0.0_4
            END IF
            en_d = -ei_d
            en = ac_pet(k) - ei
            CALL GR_PRODUCTION_D(0._sp, 0.0_4, 0._sp, 0.0_4, pn, pn_d, &
&                          en, en_d, imperviousness, ac_cp(k), ac_cp_d(k&
&                          ), 1000._sp, ac_hp(k), ac_hp_d(k), pr, pr_d, &
&                          perc, perc_d, ps, es)
          ELSE
            pr = 0._sp
            perc = 0._sp
            perc_d = 0.0_4
            pr_d = 0.0_4
          END IF
          prr_d = pr_d + perc_d
          prr = pr + perc
          CALL GR_TRANSFER_D(5._sp, ac_prcp(k), prr, prr_d, ac_ct(k), &
&                      ac_ct_d(k), ac_ht(k), ac_ht_d(k), qr, qr_d)
          ac_qt_d(k) = qr_d
          ac_qt(k) = qr
! Transform from mm/dt to m3/s
          temp = 1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col)
          ac_qt_d(k) = temp*ac_qt_d(k)/setup%dt
          ac_qt(k) = temp*(ac_qt(k)/setup%dt)
        END IF
      END DO
    END DO
  END SUBROUTINE GRD_TIME_STEP_D

!  Differentiation of grd_time_step in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: ac_cp ac_ct ac_qt ac_hp ac_ht
!                ac_mlt
!   with respect to varying inputs: ac_cp ac_ct ac_qt ac_hp ac_ht
!                ac_mlt
  SUBROUTINE GRD_TIME_STEP_B(setup, mesh, input_data, options, returns, &
&   time_step, ac_mlt, ac_mlt_b, ac_cp, ac_cp_b, ac_ct, ac_ct_b, ac_hp, &
&   ac_hp_b, ac_ht, ac_ht_b, ac_qt, ac_qt_b)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac) :: ac_mlt_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_cp, ac_ct
    REAL(sp), DIMENSION(mesh%nac) :: ac_cp_b, ac_ct_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hp_b, ac_ht_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_b
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_b
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: ei, pn, en, imperviousness, pr, perc, ps, es, prr, qr
    REAL(sp) :: ei_b, pn_b, en_b, pr_b, perc_b, prr_b, qr_b
    INTRINSIC MIN
    INTRINSIC MAX
    REAL(sp) :: dummydiff_b
    REAL(sp) :: dummydiff_b0
    INTEGER :: branch
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL1B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            IF (ac_pet(k) .GT. ac_prcp(k)) THEN
              ei = ac_prcp(k)
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
              ei = ac_pet(k)
            END IF
            IF (0._sp .LT. ac_prcp(k) - ei) THEN
              pn = ac_prcp(k) - ei
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
              pn = 0._sp
            END IF
            CALL PUSHREAL4(en)
            en = ac_pet(k) - ei
            CALL PUSHREAL4(ac_hp(k))
            CALL PUSHREAL4(pn)
            CALL GR_PRODUCTION(0._sp, 0._sp, pn, en, imperviousness, &
&                        ac_cp(k), 1000._sp, ac_hp(k), pr, perc, ps, es)
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHCONTROL1B(1)
            pr = 0._sp
            perc = 0._sp
          END IF
          CALL PUSHREAL4(prr)
          prr = pr + perc
          CALL PUSHREAL4(ac_ht(k))
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prr, ac_ct(k), ac_ht(k), &
&                    qr)
! Transform from mm/dt to m3/s
          CALL PUSHCONTROL1B(1)
        END IF
      END DO
    END DO
    ac_prcp_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          ac_qt_b(k) = mesh%dx(row, col)*1e-3_sp*mesh%dy(row, col)*&
&           ac_qt_b(k)/setup%dt
          qr_b = ac_qt_b(k)
          ac_qt_b(k) = 0.0_4
          CALL POPREAL4(ac_ht(k))
          CALL GR_TRANSFER_B(5._sp, ac_prcp(k), prr, prr_b, ac_ct(k), &
&                      ac_ct_b(k), ac_ht(k), ac_ht_b(k), qr, qr_b)
          CALL POPREAL4(prr)
          pr_b = prr_b
          perc_b = prr_b
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            imperviousness = input_data%physio_data%imperviousness(row, &
&             col)
            CALL POPREAL4(pn)
            CALL POPREAL4(ac_hp(k))
            pn_b = 0.0_4
            en_b = 0.0_4
            CALL GR_PRODUCTION_B(0._sp, dummydiff_b, 0._sp, dummydiff_b0&
&                          , pn, pn_b, en, en_b, imperviousness, ac_cp(k&
&                          ), ac_cp_b(k), 1000._sp, ac_hp(k), ac_hp_b(k)&
&                          , pr, pr_b, perc, perc_b, ps, es)
            CALL POPREAL4(en)
            ei_b = -en_b
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              ac_prcp_b(k) = ac_prcp_b(k) + pn_b
              ei_b = ei_b - pn_b
            END IF
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) ac_prcp_b(k) = ac_prcp_b(k) + ei_b
          END IF
        END IF
      END DO
    END DO
    ac_mlt_b = ac_mlt_b + ac_prcp_b
  END SUBROUTINE GRD_TIME_STEP_B

  SUBROUTINE GRD_TIME_STEP(setup, mesh, input_data, options, returns, &
&   time_step, ac_mlt, ac_cp, ac_ct, ac_hp, ac_ht, ac_qt)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_cp, ac_ct
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: ei, pn, en, imperviousness, pr, perc, ps, es, prr, qr
    INTRINSIC MIN
    INTRINSIC MAX
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            IF (ac_pet(k) .GT. ac_prcp(k)) THEN
              ei = ac_prcp(k)
            ELSE
              ei = ac_pet(k)
            END IF
            IF (0._sp .LT. ac_prcp(k) - ei) THEN
              pn = ac_prcp(k) - ei
            ELSE
              pn = 0._sp
            END IF
            en = ac_pet(k) - ei
            CALL GR_PRODUCTION(0._sp, 0._sp, pn, en, imperviousness, &
&                        ac_cp(k), 1000._sp, ac_hp(k), pr, perc, ps, es)
          ELSE
            pr = 0._sp
            perc = 0._sp
          END IF
          prr = pr + perc
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prr, ac_ct(k), ac_ht(k), &
&                    qr)
          ac_qt(k) = qr
! Transform from mm/dt to m3/s
          ac_qt(k) = ac_qt(k)*1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col&
&           )/setup%dt
        END IF
      END DO
    END DO
  END SUBROUTINE GRD_TIME_STEP

!  Differentiation of grd_mlp_time_step in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: ac_qt ac_hp ac_ht
!   with respect to varying inputs: ac_cp ac_ct bias_1 bias_2 bias_3
!                ac_qt ac_hp weight_1 weight_2 weight_3 ac_ht ac_mlt
  SUBROUTINE GRD_MLP_TIME_STEP_D(setup, mesh, input_data, options, &
&   returns, time_step, weight_1, weight_1_d, bias_1, bias_1_d, weight_2&
&   , weight_2_d, bias_2, bias_2_d, weight_3, weight_3_d, bias_3, &
&   bias_3_d, ac_mlt, ac_mlt_d, ac_cp, ac_cp_d, ac_ct, ac_ct_d, ac_hp, &
&   ac_hp_d, ac_ht, ac_ht_d, ac_qt, ac_qt_d)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1_d
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1_d
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2_d
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2_d
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3_d
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_cp, ac_ct
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_cp_d, ac_ct_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hp_d, ac_ht_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_d
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer_d
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer_d
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet, ei, pn, en
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_d, ei_d, pn_d, en_d
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: imperviousness, pr, perc, ps, es, prr, qr
    REAL(sp) :: pr_d, perc_d, prr_d, qr_d
    INTRINSIC MIN
    INTRINSIC MAX
    REAL(sp) :: temp
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp_d = ac_mlt_d
    ac_prcp = ac_prcp + ac_mlt
    ei_d = 0.0_4
    en_d = 0.0_4
    pn_d = 0.0_4
! Interception with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            IF (ac_pet(k) .GT. ac_prcp(k)) THEN
              ei_d(k) = ac_prcp_d(k)
              ei(k) = ac_prcp(k)
            ELSE
              ei_d(k) = 0.0_4
              ei(k) = ac_pet(k)
            END IF
            IF (0._sp .LT. ac_prcp(k) - ei(k)) THEN
              pn_d(k) = ac_prcp_d(k) - ei_d(k)
              pn(k) = ac_prcp(k) - ei(k)
            ELSE
              pn_d(k) = 0.0_4
              pn(k) = 0._sp
            END IF
            en_d(k) = -ei_d(k)
            en(k) = ac_pet(k) - ei(k)
          ELSE
            ei_d(k) = 0.0_4
            ei(k) = 0._sp
            pn_d(k) = 0.0_4
            pn(k) = 0._sp
            en_d(k) = 0.0_4
            en(k) = 0._sp
          END IF
        END IF
      END DO
    END DO
    output_layer_d = 0.0_4
! Forward MLP without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            input_layer_d(:) = (/ac_hp_d(k), ac_ht_d(k), pn_d(k), en_d(k&
&             )/)
            input_layer(:) = (/ac_hp(k), ac_ht(k), pn(k), en(k)/)
            CALL FORWARD_MLP_D(weight_1, weight_1_d, bias_1, bias_1_d, &
&                        weight_2, weight_2_d, bias_2, bias_2_d, &
&                        weight_3, weight_3_d, bias_3, bias_3_d, &
&                        input_layer, input_layer_d, output_layer(:, k)&
&                        , output_layer_d(:, k))
          ELSE
            output_layer_d(:, k) = 0.0_4
            output_layer(:, k) = 0._sp
          END IF
        END IF
      END DO
    END DO
! Production and transfer with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_PRODUCTION_D(output_layer(1, k), output_layer_d(1, k&
&                          ), output_layer(2, k), output_layer_d(2, k), &
&                          pn(k), pn_d(k), en(k), en_d(k), &
&                          imperviousness, ac_cp(k), ac_cp_d(k), &
&                          1000._sp, ac_hp(k), ac_hp_d(k), pr, pr_d, &
&                          perc, perc_d, ps, es)
          ELSE
            pr = 0._sp
            perc = 0._sp
            perc_d = 0.0_4
            pr_d = 0.0_4
          END IF
          prr_d = pr_d + perc_d
          prr = pr + perc
          CALL GR_TRANSFER_D(5._sp, ac_prcp(k), prr, prr_d, ac_ct(k), &
&                      ac_ct_d(k), ac_ht(k), ac_ht_d(k), qr, qr_d)
          ac_qt_d(k) = qr_d
          ac_qt(k) = qr
! Transform from mm/dt to m3/s
          temp = 1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col)
          ac_qt_d(k) = temp*ac_qt_d(k)/setup%dt
          ac_qt(k) = temp*(ac_qt(k)/setup%dt)
        END IF
      END DO
    END DO
  END SUBROUTINE GRD_MLP_TIME_STEP_D

!  Differentiation of grd_mlp_time_step in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: ac_cp ac_ct bias_1 bias_2 bias_3
!                ac_qt ac_hp weight_1 weight_2 weight_3 ac_ht ac_mlt
!   with respect to varying inputs: ac_cp ac_ct bias_1 bias_2 bias_3
!                ac_qt ac_hp weight_1 weight_2 weight_3 ac_ht ac_mlt
  SUBROUTINE GRD_MLP_TIME_STEP_B(setup, mesh, input_data, options, &
&   returns, time_step, weight_1, weight_1_b, bias_1, bias_1_b, weight_2&
&   , weight_2_b, bias_2, bias_2_b, weight_3, weight_3_b, bias_3, &
&   bias_3_b, ac_mlt, ac_mlt_b, ac_cp, ac_cp_b, ac_ct, ac_ct_b, ac_hp, &
&   ac_hp_b, ac_ht, ac_ht_b, ac_qt, ac_qt_b)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)) :: &
&   weight_1_b
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(setup%neurons(2)) :: bias_1_b
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)) :: &
&   weight_2_b
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(setup%neurons(3)) :: bias_2_b
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)) :: &
&   weight_3_b
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(setup%neurons(4)) :: bias_3_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac) :: ac_mlt_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_cp, ac_ct
    REAL(sp), DIMENSION(mesh%nac) :: ac_cp_b, ac_ct_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hp_b, ac_ht_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_b
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer_b
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer_b
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet, ei, pn, en
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_b, ei_b, pn_b, en_b
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: imperviousness, pr, perc, ps, es, prr, qr
    REAL(sp) :: pr_b, perc_b, prr_b, qr_b
    INTRINSIC MIN
    INTRINSIC MAX
    INTEGER :: branch
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Interception with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL2B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            IF (ac_pet(k) .GT. ac_prcp(k)) THEN
              ei(k) = ac_prcp(k)
              CALL PUSHCONTROL1B(0)
            ELSE
              ei(k) = ac_pet(k)
              CALL PUSHCONTROL1B(1)
            END IF
            IF (0._sp .LT. ac_prcp(k) - ei(k)) THEN
              pn(k) = ac_prcp(k) - ei(k)
              CALL PUSHCONTROL1B(0)
            ELSE
              pn(k) = 0._sp
              CALL PUSHCONTROL1B(1)
            END IF
            en(k) = ac_pet(k) - ei(k)
            CALL PUSHCONTROL2B(2)
          ELSE
            ei(k) = 0._sp
            pn(k) = 0._sp
            en(k) = 0._sp
            CALL PUSHCONTROL2B(1)
          END IF
        END IF
      END DO
    END DO
! Forward MLP without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL2B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4ARRAY(input_layer, setup%neurons(1))
            input_layer(:) = (/ac_hp(k), ac_ht(k), pn(k), en(k)/)
            CALL FORWARD_MLP(weight_1, bias_1, weight_2, bias_2, &
&                      weight_3, bias_3, input_layer, output_layer(:, k)&
&                     )
            CALL PUSHCONTROL2B(2)
          ELSE
            output_layer(:, k) = 0._sp
            CALL PUSHCONTROL2B(1)
          END IF
        END IF
      END DO
    END DO
! Production and transfer with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL1B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4(ac_hp(k))
            CALL PUSHREAL4(pn(k))
            CALL GR_PRODUCTION(output_layer(1, k), output_layer(2, k), &
&                        pn(k), en(k), imperviousness, ac_cp(k), &
&                        1000._sp, ac_hp(k), pr, perc, ps, es)
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHCONTROL1B(1)
            pr = 0._sp
            perc = 0._sp
          END IF
          CALL PUSHREAL4(prr)
          prr = pr + perc
          CALL PUSHREAL4(ac_ht(k))
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prr, ac_ct(k), ac_ht(k), &
&                    qr)
! Transform from mm/dt to m3/s
          CALL PUSHCONTROL1B(1)
        END IF
      END DO
    END DO
    output_layer_b = 0.0_4
    en_b = 0.0_4
    pn_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          ac_qt_b(k) = mesh%dx(row, col)*1e-3_sp*mesh%dy(row, col)*&
&           ac_qt_b(k)/setup%dt
          qr_b = ac_qt_b(k)
          ac_qt_b(k) = 0.0_4
          CALL POPREAL4(ac_ht(k))
          CALL GR_TRANSFER_B(5._sp, ac_prcp(k), prr, prr_b, ac_ct(k), &
&                      ac_ct_b(k), ac_ht(k), ac_ht_b(k), qr, qr_b)
          CALL POPREAL4(prr)
          pr_b = prr_b
          perc_b = prr_b
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            imperviousness = input_data%physio_data%imperviousness(row, &
&             col)
            CALL POPREAL4(pn(k))
            CALL POPREAL4(ac_hp(k))
            CALL GR_PRODUCTION_B(output_layer(1, k), output_layer_b(1, k&
&                          ), output_layer(2, k), output_layer_b(2, k), &
&                          pn(k), pn_b(k), en(k), en_b(k), &
&                          imperviousness, ac_cp(k), ac_cp_b(k), &
&                          1000._sp, ac_hp(k), ac_hp_b(k), pr, pr_b, &
&                          perc, perc_b, ps, es)
          END IF
        END IF
      END DO
    END DO
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL2B(branch)
        IF (branch .NE. 0) THEN
          IF (branch .EQ. 1) THEN
            k = mesh%rowcol_to_ind_ac(row, col)
            output_layer_b(:, k) = 0.0_4
          ELSE
            k = mesh%rowcol_to_ind_ac(row, col)
            CALL FORWARD_MLP_B(weight_1, weight_1_b, bias_1, bias_1_b, &
&                        weight_2, weight_2_b, bias_2, bias_2_b, &
&                        weight_3, weight_3_b, bias_3, bias_3_b, &
&                        input_layer, input_layer_b, output_layer(:, k)&
&                        , output_layer_b(:, k))
            output_layer_b(:, k) = 0.0_4
            CALL POPREAL4ARRAY(input_layer, setup%neurons(1))
            ac_hp_b(k) = ac_hp_b(k) + input_layer_b(1)
            ac_ht_b(k) = ac_ht_b(k) + input_layer_b(2)
            pn_b(k) = pn_b(k) + input_layer_b(3)
            en_b(k) = en_b(k) + input_layer_b(4)
          END IF
        END IF
      END DO
    END DO
    ac_prcp_b = 0.0_4
    ei_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL2B(branch)
        IF (branch .NE. 0) THEN
          IF (branch .EQ. 1) THEN
            k = mesh%rowcol_to_ind_ac(row, col)
            en_b(k) = 0.0_4
            pn_b(k) = 0.0_4
            ei_b(k) = 0.0_4
          ELSE
            k = mesh%rowcol_to_ind_ac(row, col)
            ei_b(k) = ei_b(k) - en_b(k)
            en_b(k) = 0.0_4
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              ac_prcp_b(k) = ac_prcp_b(k) + pn_b(k)
              ei_b(k) = ei_b(k) - pn_b(k)
              pn_b(k) = 0.0_4
            ELSE
              pn_b(k) = 0.0_4
            END IF
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              ac_prcp_b(k) = ac_prcp_b(k) + ei_b(k)
              ei_b(k) = 0.0_4
            ELSE
              ei_b(k) = 0.0_4
            END IF
          END IF
        END IF
      END DO
    END DO
    ac_mlt_b = ac_mlt_b + ac_prcp_b
  END SUBROUTINE GRD_MLP_TIME_STEP_B

  SUBROUTINE GRD_MLP_TIME_STEP(setup, mesh, input_data, options, returns&
&   , time_step, weight_1, bias_1, weight_2, bias_2, weight_3, bias_3, &
&   ac_mlt, ac_cp, ac_ct, ac_hp, ac_ht, ac_qt)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_cp, ac_ct
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hp, ac_ht
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet, ei, pn, en
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: imperviousness, pr, perc, ps, es, prr, qr
    INTRINSIC MIN
    INTRINSIC MAX
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Interception with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            IF (ac_pet(k) .GT. ac_prcp(k)) THEN
              ei(k) = ac_prcp(k)
            ELSE
              ei(k) = ac_pet(k)
            END IF
            IF (0._sp .LT. ac_prcp(k) - ei(k)) THEN
              pn(k) = ac_prcp(k) - ei(k)
            ELSE
              pn(k) = 0._sp
            END IF
            en(k) = ac_pet(k) - ei(k)
          ELSE
            ei(k) = 0._sp
            pn(k) = 0._sp
            en(k) = 0._sp
          END IF
        END IF
      END DO
    END DO
! Forward MLP without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            input_layer(:) = (/ac_hp(k), ac_ht(k), pn(k), en(k)/)
            CALL FORWARD_MLP(weight_1, bias_1, weight_2, bias_2, &
&                      weight_3, bias_3, input_layer, output_layer(:, k)&
&                     )
          ELSE
            output_layer(:, k) = 0._sp
          END IF
        END IF
      END DO
    END DO
! Production and transfer with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_PRODUCTION(output_layer(1, k), output_layer(2, k), &
&                        pn(k), en(k), imperviousness, ac_cp(k), &
&                        1000._sp, ac_hp(k), pr, perc, ps, es)
          ELSE
            pr = 0._sp
            perc = 0._sp
          END IF
          prr = pr + perc
          CALL GR_TRANSFER(5._sp, ac_prcp(k), prr, ac_ct(k), ac_ht(k), &
&                    qr)
          ac_qt(k) = qr
! Transform from mm/dt to m3/s
          ac_qt(k) = ac_qt(k)*1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col&
&           )/setup%dt
        END IF
      END DO
    END DO
  END SUBROUTINE GRD_MLP_TIME_STEP

!  Differentiation of loieau_time_step in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: ac_qt ac_ha ac_hc
!   with respect to varying inputs: ac_ca ac_cc ac_kb ac_qt ac_ha
!                ac_hc ac_mlt
  SUBROUTINE LOIEAU_TIME_STEP_D(setup, mesh, input_data, options, &
&   returns, time_step, ac_mlt, ac_mlt_d, ac_ca, ac_ca_d, ac_cc, ac_cc_d&
&   , ac_kb, ac_kb_d, ac_ha, ac_ha_d, ac_hc, ac_hc_d, ac_qt, ac_qt_d)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ca, ac_cc, ac_kb
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ca_d, ac_cc_d, &
&   ac_kb_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_ha, ac_hc
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_ha_d, ac_hc_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_d
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_d
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, ei, pn, en, imperviousness, pr, perc, ps, es, prr&
&   , prd, qr, qd
    REAL(sp) :: ei_d, pn_d, en_d, pr_d, perc_d, prr_d, prd_d, qr_d, qd_d
    INTRINSIC MIN
    INTRINSIC MAX
    REAL(sp) :: temp
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp_d = ac_mlt_d
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            IF (ac_pet(k) .GT. ac_prcp(k)) THEN
              ei_d = ac_prcp_d(k)
              ei = ac_prcp(k)
            ELSE
              ei = ac_pet(k)
              ei_d = 0.0_4
            END IF
            IF (0._sp .LT. ac_prcp(k) - ei) THEN
              pn_d = ac_prcp_d(k) - ei_d
              pn = ac_prcp(k) - ei
            ELSE
              pn = 0._sp
              pn_d = 0.0_4
            END IF
            en_d = -ei_d
            en = ac_pet(k) - ei
            CALL GR_PRODUCTION_D(0._sp, 0.0_4, 0._sp, 0.0_4, pn, pn_d, &
&                          en, en_d, imperviousness, ac_ca(k), ac_ca_d(k&
&                          ), beta, ac_ha(k), ac_ha_d(k), pr, pr_d, perc&
&                          , perc_d, ps, es)
          ELSE
            pr = 0._sp
            perc = 0._sp
            perc_d = 0.0_4
            pr_d = 0.0_4
          END IF
          prr_d = 0.9_sp*(pr_d+perc_d)
          prr = 0.9_sp*(pr+perc)
          prd_d = 0.1_sp*(pr_d+perc_d)
          prd = 0.1_sp*(pr+perc)
          CALL GR_TRANSFER_D(4._sp, ac_prcp(k), prr, prr_d, ac_cc(k), &
&                      ac_cc_d(k), ac_hc(k), ac_hc_d(k), qr, qr_d)
          IF (0._sp .LT. prd) THEN
            qd_d = prd_d
            qd = prd
          ELSE
            qd = 0._sp
            qd_d = 0.0_4
          END IF
          ac_qt_d(k) = (qr+qd)*ac_kb_d(k) + ac_kb(k)*(qr_d+qd_d)
          ac_qt(k) = ac_kb(k)*(qr+qd)
! Transform from mm/dt to m3/s
          temp = 1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col)
          ac_qt_d(k) = temp*ac_qt_d(k)/setup%dt
          ac_qt(k) = temp*(ac_qt(k)/setup%dt)
        END IF
      END DO
    END DO
  END SUBROUTINE LOIEAU_TIME_STEP_D

!  Differentiation of loieau_time_step in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: ac_ca ac_cc ac_kb ac_qt ac_ha
!                ac_hc ac_mlt
!   with respect to varying inputs: ac_ca ac_cc ac_kb ac_qt ac_ha
!                ac_hc ac_mlt
  SUBROUTINE LOIEAU_TIME_STEP_B(setup, mesh, input_data, options, &
&   returns, time_step, ac_mlt, ac_mlt_b, ac_ca, ac_ca_b, ac_cc, ac_cc_b&
&   , ac_kb, ac_kb_b, ac_ha, ac_ha_b, ac_hc, ac_hc_b, ac_qt, ac_qt_b)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac) :: ac_mlt_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ca, ac_cc, ac_kb
    REAL(sp), DIMENSION(mesh%nac) :: ac_ca_b, ac_cc_b, ac_kb_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_ha, ac_hc
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_ha_b, ac_hc_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_b
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_b
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, ei, pn, en, imperviousness, pr, perc, ps, es, prr&
&   , prd, qr, qd
    REAL(sp) :: ei_b, pn_b, en_b, pr_b, perc_b, prr_b, prd_b, qr_b, qd_b
    INTRINSIC MIN
    INTRINSIC MAX
    REAL(sp) :: dummydiff_b
    REAL(sp) :: dummydiff_b0
    INTEGER :: branch
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL1B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            IF (ac_pet(k) .GT. ac_prcp(k)) THEN
              ei = ac_prcp(k)
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
              ei = ac_pet(k)
            END IF
            IF (0._sp .LT. ac_prcp(k) - ei) THEN
              pn = ac_prcp(k) - ei
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
              pn = 0._sp
            END IF
            CALL PUSHREAL4(en)
            en = ac_pet(k) - ei
            CALL PUSHREAL4(ac_ha(k))
            CALL PUSHREAL4(pn)
            CALL GR_PRODUCTION(0._sp, 0._sp, pn, en, imperviousness, &
&                        ac_ca(k), beta, ac_ha(k), pr, perc, ps, es)
            CALL PUSHCONTROL1B(1)
          ELSE
            CALL PUSHCONTROL1B(0)
            pr = 0._sp
            perc = 0._sp
          END IF
          CALL PUSHREAL4(prr)
          prr = 0.9_sp*(pr+perc)
          prd = 0.1_sp*(pr+perc)
          CALL PUSHREAL4(qr)
          CALL PUSHREAL4(ac_hc(k))
          CALL GR_TRANSFER(4._sp, ac_prcp(k), prr, ac_cc(k), ac_hc(k), &
&                    qr)
          IF (0._sp .LT. prd) THEN
            CALL PUSHREAL4(qd)
            qd = prd
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHREAL4(qd)
            qd = 0._sp
            CALL PUSHCONTROL1B(1)
          END IF
          CALL PUSHCONTROL1B(1)
        END IF
      END DO
    END DO
    ac_prcp_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          ac_qt_b(k) = mesh%dx(row, col)*1e-3_sp*mesh%dy(row, col)*&
&           ac_qt_b(k)/setup%dt
          ac_kb_b(k) = ac_kb_b(k) + (qr+qd)*ac_qt_b(k)
          qr_b = ac_kb(k)*ac_qt_b(k)
          qd_b = ac_kb(k)*ac_qt_b(k)
          ac_qt_b(k) = 0.0_4
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            CALL POPREAL4(qd)
            prd_b = qd_b
          ELSE
            CALL POPREAL4(qd)
            prd_b = 0.0_4
          END IF
          CALL POPREAL4(ac_hc(k))
          CALL POPREAL4(qr)
          CALL GR_TRANSFER_B(4._sp, ac_prcp(k), prr, prr_b, ac_cc(k), &
&                      ac_cc_b(k), ac_hc(k), ac_hc_b(k), qr, qr_b)
          pr_b = 0.1_sp*prd_b + 0.9_sp*prr_b
          perc_b = 0.1_sp*prd_b + 0.9_sp*prr_b
          CALL POPREAL4(prr)
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) THEN
            imperviousness = input_data%physio_data%imperviousness(row, &
&             col)
            CALL POPREAL4(pn)
            CALL POPREAL4(ac_ha(k))
            pn_b = 0.0_4
            en_b = 0.0_4
            CALL GR_PRODUCTION_B(0._sp, dummydiff_b, 0._sp, dummydiff_b0&
&                          , pn, pn_b, en, en_b, imperviousness, ac_ca(k&
&                          ), ac_ca_b(k), beta, ac_ha(k), ac_ha_b(k), pr&
&                          , pr_b, perc, perc_b, ps, es)
            CALL POPREAL4(en)
            ei_b = -en_b
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              ac_prcp_b(k) = ac_prcp_b(k) + pn_b
              ei_b = ei_b - pn_b
            END IF
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) ac_prcp_b(k) = ac_prcp_b(k) + ei_b
          END IF
        END IF
      END DO
    END DO
    ac_mlt_b = ac_mlt_b + ac_prcp_b
  END SUBROUTINE LOIEAU_TIME_STEP_B

  SUBROUTINE LOIEAU_TIME_STEP(setup, mesh, input_data, options, returns&
&   , time_step, ac_mlt, ac_ca, ac_cc, ac_kb, ac_ha, ac_hc, ac_qt)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ca, ac_cc, ac_kb
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_ha, ac_hc
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, ei, pn, en, imperviousness, pr, perc, ps, es, prr&
&   , prd, qr, qd
    INTRINSIC MIN
    INTRINSIC MAX
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            IF (ac_pet(k) .GT. ac_prcp(k)) THEN
              ei = ac_prcp(k)
            ELSE
              ei = ac_pet(k)
            END IF
            IF (0._sp .LT. ac_prcp(k) - ei) THEN
              pn = ac_prcp(k) - ei
            ELSE
              pn = 0._sp
            END IF
            en = ac_pet(k) - ei
            CALL GR_PRODUCTION(0._sp, 0._sp, pn, en, imperviousness, &
&                        ac_ca(k), beta, ac_ha(k), pr, perc, ps, es)
          ELSE
            pr = 0._sp
            perc = 0._sp
          END IF
          prr = 0.9_sp*(pr+perc)
          prd = 0.1_sp*(pr+perc)
          CALL GR_TRANSFER(4._sp, ac_prcp(k), prr, ac_cc(k), ac_hc(k), &
&                    qr)
          IF (0._sp .LT. prd) THEN
            qd = prd
          ELSE
            qd = 0._sp
          END IF
          ac_qt(k) = ac_kb(k)*(qr+qd)
! Transform from mm/dt to m3/s
          ac_qt(k) = ac_qt(k)*1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col&
&           )/setup%dt
        END IF
      END DO
    END DO
  END SUBROUTINE LOIEAU_TIME_STEP

!  Differentiation of loieau_mlp_time_step in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: ac_qt ac_ha ac_hc
!   with respect to varying inputs: ac_ca ac_cc bias_1 bias_2 bias_3
!                ac_kb ac_qt ac_ha ac_hc weight_1 weight_2 weight_3
!                ac_mlt
  SUBROUTINE LOIEAU_MLP_TIME_STEP_D(setup, mesh, input_data, options, &
&   returns, time_step, weight_1, weight_1_d, bias_1, bias_1_d, weight_2&
&   , weight_2_d, bias_2, bias_2_d, weight_3, weight_3_d, bias_3, &
&   bias_3_d, ac_mlt, ac_mlt_d, ac_ca, ac_ca_d, ac_cc, ac_cc_d, ac_kb, &
&   ac_kb_d, ac_ha, ac_ha_d, ac_hc, ac_hc_d, ac_qt, ac_qt_d)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1_d
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1_d
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2_d
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2_d
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3_d
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ca, ac_cc, ac_kb
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ca_d, ac_cc_d, &
&   ac_kb_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_ha, ac_hc
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_ha_d, ac_hc_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_d
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer_d
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer_d
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet, ei, pn, en
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_d, ei_d, pn_d, en_d
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, imperviousness, pr, perc, ps, es, prr, prd, qr, qd
    REAL(sp) :: pr_d, perc_d, prr_d, prd_d, qr_d, qd_d
    INTRINSIC MIN
    INTRINSIC MAX
    REAL(sp) :: temp
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp_d = ac_mlt_d
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
    ei_d = 0.0_4
    en_d = 0.0_4
    pn_d = 0.0_4
! Interception with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            IF (ac_pet(k) .GT. ac_prcp(k)) THEN
              ei_d(k) = ac_prcp_d(k)
              ei(k) = ac_prcp(k)
            ELSE
              ei_d(k) = 0.0_4
              ei(k) = ac_pet(k)
            END IF
            IF (0._sp .LT. ac_prcp(k) - ei(k)) THEN
              pn_d(k) = ac_prcp_d(k) - ei_d(k)
              pn(k) = ac_prcp(k) - ei(k)
            ELSE
              pn_d(k) = 0.0_4
              pn(k) = 0._sp
            END IF
            en_d(k) = -ei_d(k)
            en(k) = ac_pet(k) - ei(k)
          ELSE
            ei_d(k) = 0.0_4
            ei(k) = 0._sp
            pn_d(k) = 0.0_4
            pn(k) = 0._sp
            en_d(k) = 0.0_4
            en(k) = 0._sp
          END IF
        END IF
      END DO
    END DO
    output_layer_d = 0.0_4
! Forward MLP without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            input_layer_d(:) = (/ac_ha_d(k), ac_hc_d(k), pn_d(k), en_d(k&
&             )/)
            input_layer(:) = (/ac_ha(k), ac_hc(k), pn(k), en(k)/)
            CALL FORWARD_MLP_D(weight_1, weight_1_d, bias_1, bias_1_d, &
&                        weight_2, weight_2_d, bias_2, bias_2_d, &
&                        weight_3, weight_3_d, bias_3, bias_3_d, &
&                        input_layer, input_layer_d, output_layer(:, k)&
&                        , output_layer_d(:, k))
          ELSE
            output_layer_d(:, k) = 0.0_4
            output_layer(:, k) = 0._sp
          END IF
        END IF
      END DO
    END DO
! Production and transfer with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_PRODUCTION_D(output_layer(1, k), output_layer_d(1, k&
&                          ), output_layer(2, k), output_layer_d(2, k), &
&                          pn(k), pn_d(k), en(k), en_d(k), &
&                          imperviousness, ac_ca(k), ac_ca_d(k), beta, &
&                          ac_ha(k), ac_ha_d(k), pr, pr_d, perc, perc_d&
&                          , ps, es)
          ELSE
            pr = 0._sp
            perc = 0._sp
            perc_d = 0.0_4
            pr_d = 0.0_4
          END IF
! Range of correction c0.9: (1, 0)
          temp = -(output_layer(3, k)*output_layer(3, k)) + 1._sp
          prr_d = 0.9_sp*(temp*(pr_d+perc_d)-(pr+perc)*2*output_layer(3&
&           , k)*output_layer_d(3, k))
          prr = 0.9_sp*(temp*(pr+perc))
! Range of correction c0.1: (0, 10)
          temp = 0.9_sp*(output_layer(3, k)*output_layer(3, k)) + 0.1_sp
          prd_d = (pr+perc)*0.9_sp*2*output_layer(3, k)*output_layer_d(3&
&           , k) + temp*(pr_d+perc_d)
          prd = temp*(pr+perc)
          CALL GR_TRANSFER_D(4._sp, ac_prcp(k), prr, prr_d, ac_cc(k), &
&                      ac_cc_d(k), ac_hc(k), ac_hc_d(k), qr, qr_d)
          IF (0._sp .LT. prd) THEN
            qd_d = prd_d
            qd = prd
          ELSE
            qd = 0._sp
            qd_d = 0.0_4
          END IF
          ac_qt_d(k) = (qr+qd)*ac_kb_d(k) + ac_kb(k)*(qr_d+qd_d)
          ac_qt(k) = ac_kb(k)*(qr+qd)
! Transform from mm/dt to m3/s
          temp = 1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col)
          ac_qt_d(k) = temp*ac_qt_d(k)/setup%dt
          ac_qt(k) = temp*(ac_qt(k)/setup%dt)
        END IF
      END DO
    END DO
  END SUBROUTINE LOIEAU_MLP_TIME_STEP_D

!  Differentiation of loieau_mlp_time_step in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: ac_ca ac_cc bias_1 bias_2 bias_3
!                ac_kb ac_qt ac_ha ac_hc weight_1 weight_2 weight_3
!                ac_mlt
!   with respect to varying inputs: ac_ca ac_cc bias_1 bias_2 bias_3
!                ac_kb ac_qt ac_ha ac_hc weight_1 weight_2 weight_3
!                ac_mlt
  SUBROUTINE LOIEAU_MLP_TIME_STEP_B(setup, mesh, input_data, options, &
&   returns, time_step, weight_1, weight_1_b, bias_1, bias_1_b, weight_2&
&   , weight_2_b, bias_2, bias_2_b, weight_3, weight_3_b, bias_3, &
&   bias_3_b, ac_mlt, ac_mlt_b, ac_ca, ac_ca_b, ac_cc, ac_cc_b, ac_kb, &
&   ac_kb_b, ac_ha, ac_ha_b, ac_hc, ac_hc_b, ac_qt, ac_qt_b)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)) :: &
&   weight_1_b
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(setup%neurons(2)) :: bias_1_b
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)) :: &
&   weight_2_b
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(setup%neurons(3)) :: bias_2_b
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)) :: &
&   weight_3_b
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(setup%neurons(4)) :: bias_3_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac) :: ac_mlt_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ca, ac_cc, ac_kb
    REAL(sp), DIMENSION(mesh%nac) :: ac_ca_b, ac_cc_b, ac_kb_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_ha, ac_hc
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_ha_b, ac_hc_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_b
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer_b
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer_b
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet, ei, pn, en
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_b, ei_b, pn_b, en_b
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, imperviousness, pr, perc, ps, es, prr, prd, qr, qd
    REAL(sp) :: pr_b, perc_b, prr_b, prd_b, qr_b, qd_b
    INTRINSIC MIN
    INTRINSIC MAX
    REAL(sp) :: temp_b
    INTEGER :: branch
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
! Interception with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL2B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            IF (ac_pet(k) .GT. ac_prcp(k)) THEN
              ei(k) = ac_prcp(k)
              CALL PUSHCONTROL1B(0)
            ELSE
              ei(k) = ac_pet(k)
              CALL PUSHCONTROL1B(1)
            END IF
            IF (0._sp .LT. ac_prcp(k) - ei(k)) THEN
              pn(k) = ac_prcp(k) - ei(k)
              CALL PUSHCONTROL1B(0)
            ELSE
              pn(k) = 0._sp
              CALL PUSHCONTROL1B(1)
            END IF
            en(k) = ac_pet(k) - ei(k)
            CALL PUSHCONTROL2B(2)
          ELSE
            ei(k) = 0._sp
            pn(k) = 0._sp
            en(k) = 0._sp
            CALL PUSHCONTROL2B(1)
          END IF
        END IF
      END DO
    END DO
! Forward MLP without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL2B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4ARRAY(input_layer, setup%neurons(1))
            input_layer(:) = (/ac_ha(k), ac_hc(k), pn(k), en(k)/)
            CALL FORWARD_MLP(weight_1, bias_1, weight_2, bias_2, &
&                      weight_3, bias_3, input_layer, output_layer(:, k)&
&                     )
            CALL PUSHCONTROL2B(2)
          ELSE
            output_layer(:, k) = 0._sp
            CALL PUSHCONTROL2B(1)
          END IF
        END IF
      END DO
    END DO
! Production and transfer with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHINTEGER4(k)
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL PUSHREAL4(perc)
            CALL PUSHREAL4(pr)
            CALL PUSHREAL4(ac_ha(k))
            CALL PUSHREAL4(pn(k))
            CALL GR_PRODUCTION(output_layer(1, k), output_layer(2, k), &
&                        pn(k), en(k), imperviousness, ac_ca(k), beta, &
&                        ac_ha(k), pr, perc, ps, es)
            CALL PUSHCONTROL1B(1)
          ELSE
            CALL PUSHREAL4(pr)
            pr = 0._sp
            CALL PUSHREAL4(perc)
            perc = 0._sp
            CALL PUSHCONTROL1B(0)
          END IF
! Range of correction c0.9: (1, 0)
          prr = 0.9_sp*(1._sp-output_layer(3, k)**2)*(pr+perc)
! Range of correction c0.1: (0, 10)
          prd = (0.1_sp+0.9_sp*output_layer(3, k)**2)*(pr+perc)
          CALL PUSHREAL4(qr)
          CALL PUSHREAL4(ac_hc(k))
          CALL GR_TRANSFER(4._sp, ac_prcp(k), prr, ac_cc(k), ac_hc(k), &
&                    qr)
          IF (0._sp .LT. prd) THEN
            CALL PUSHREAL4(qd)
            qd = prd
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHREAL4(qd)
            qd = 0._sp
            CALL PUSHCONTROL1B(1)
          END IF
          CALL PUSHCONTROL1B(1)
        END IF
      END DO
    END DO
    output_layer_b = 0.0_4
    en_b = 0.0_4
    pn_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) THEN
          ac_qt_b(k) = mesh%dx(row, col)*1e-3_sp*mesh%dy(row, col)*&
&           ac_qt_b(k)/setup%dt
          ac_kb_b(k) = ac_kb_b(k) + (qr+qd)*ac_qt_b(k)
          qr_b = ac_kb(k)*ac_qt_b(k)
          qd_b = ac_kb(k)*ac_qt_b(k)
          ac_qt_b(k) = 0.0_4
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            CALL POPREAL4(qd)
            prd_b = qd_b
          ELSE
            CALL POPREAL4(qd)
            prd_b = 0.0_4
          END IF
          prr = 0.9_sp*(1._sp-output_layer(3, k)**2)*(pr+perc)
          CALL POPREAL4(ac_hc(k))
          CALL POPREAL4(qr)
          CALL GR_TRANSFER_B(4._sp, ac_prcp(k), prr, prr_b, ac_cc(k), &
&                      ac_cc_b(k), ac_hc(k), ac_hc_b(k), qr, qr_b)
          output_layer_b(3, k) = output_layer_b(3, k) + 2*output_layer(3&
&           , k)*0.9_sp*(pr+perc)*prd_b - 2*output_layer(3, k)*(pr+perc)&
&           *0.9_sp*prr_b
          temp_b = (0.9_sp*output_layer(3, k)**2+0.1_sp)*prd_b
          pr_b = temp_b
          perc_b = temp_b
          temp_b = (1._sp-output_layer(3, k)**2)*0.9_sp*prr_b
          pr_b = pr_b + temp_b
          perc_b = perc_b + temp_b
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            CALL POPREAL4(perc)
            CALL POPREAL4(pr)
          ELSE
            imperviousness = input_data%physio_data%imperviousness(row, &
&             col)
            CALL POPREAL4(pn(k))
            CALL POPREAL4(ac_ha(k))
            CALL POPREAL4(pr)
            CALL POPREAL4(perc)
            CALL GR_PRODUCTION_B(output_layer(1, k), output_layer_b(1, k&
&                          ), output_layer(2, k), output_layer_b(2, k), &
&                          pn(k), pn_b(k), en(k), en_b(k), &
&                          imperviousness, ac_ca(k), ac_ca_b(k), beta, &
&                          ac_ha(k), ac_ha_b(k), pr, pr_b, perc, perc_b&
&                          , ps, es)
          END IF
          CALL POPINTEGER4(k)
        END IF
      END DO
    END DO
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL2B(branch)
        IF (branch .NE. 0) THEN
          IF (branch .EQ. 1) THEN
            k = mesh%rowcol_to_ind_ac(row, col)
            output_layer_b(:, k) = 0.0_4
          ELSE
            k = mesh%rowcol_to_ind_ac(row, col)
            CALL FORWARD_MLP_B(weight_1, weight_1_b, bias_1, bias_1_b, &
&                        weight_2, weight_2_b, bias_2, bias_2_b, &
&                        weight_3, weight_3_b, bias_3, bias_3_b, &
&                        input_layer, input_layer_b, output_layer(:, k)&
&                        , output_layer_b(:, k))
            output_layer_b(:, k) = 0.0_4
            CALL POPREAL4ARRAY(input_layer, setup%neurons(1))
            ac_ha_b(k) = ac_ha_b(k) + input_layer_b(1)
            ac_hc_b(k) = ac_hc_b(k) + input_layer_b(2)
            pn_b(k) = pn_b(k) + input_layer_b(3)
            en_b(k) = en_b(k) + input_layer_b(4)
          END IF
        END IF
      END DO
    END DO
    ac_prcp_b = 0.0_4
    ei_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL2B(branch)
        IF (branch .NE. 0) THEN
          IF (branch .EQ. 1) THEN
            k = mesh%rowcol_to_ind_ac(row, col)
            en_b(k) = 0.0_4
            pn_b(k) = 0.0_4
            ei_b(k) = 0.0_4
          ELSE
            k = mesh%rowcol_to_ind_ac(row, col)
            ei_b(k) = ei_b(k) - en_b(k)
            en_b(k) = 0.0_4
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              ac_prcp_b(k) = ac_prcp_b(k) + pn_b(k)
              ei_b(k) = ei_b(k) - pn_b(k)
              pn_b(k) = 0.0_4
            ELSE
              pn_b(k) = 0.0_4
            END IF
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              ac_prcp_b(k) = ac_prcp_b(k) + ei_b(k)
              ei_b(k) = 0.0_4
            ELSE
              ei_b(k) = 0.0_4
            END IF
          END IF
        END IF
      END DO
    END DO
    ac_mlt_b = ac_mlt_b + ac_prcp_b
  END SUBROUTINE LOIEAU_MLP_TIME_STEP_B

  SUBROUTINE LOIEAU_MLP_TIME_STEP(setup, mesh, input_data, options, &
&   returns, time_step, weight_1, bias_1, weight_2, bias_2, weight_3, &
&   bias_3, ac_mlt, ac_ca, ac_cc, ac_kb, ac_ha, ac_hc, ac_qt)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(setup%neurons(2), setup%neurons(1)), INTENT(IN) &
&   :: weight_1
    REAL(sp), DIMENSION(setup%neurons(2)), INTENT(IN) :: bias_1
    REAL(sp), DIMENSION(setup%neurons(3), setup%neurons(2)), INTENT(IN) &
&   :: weight_2
    REAL(sp), DIMENSION(setup%neurons(3)), INTENT(IN) :: bias_2
    REAL(sp), DIMENSION(setup%neurons(4), setup%neurons(3)), INTENT(IN) &
&   :: weight_3
    REAL(sp), DIMENSION(setup%neurons(4)), INTENT(IN) :: bias_3
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_ca, ac_cc, ac_kb
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_ha, ac_hc
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(setup%neurons(1)) :: input_layer
    REAL(sp), DIMENSION(setup%neurons(setup%n_layers+1), mesh%nac) :: &
&   output_layer
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet, ei, pn, en
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: beta, imperviousness, pr, perc, ps, es, prr, prd, qr, qd
    INTRINSIC MIN
    INTRINSIC MAX
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
! Beta percolation parameter is time step dependent
    beta = 9._sp/4._sp*(86400._sp/setup%dt)**0.25_sp
! Interception with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            IF (ac_pet(k) .GT. ac_prcp(k)) THEN
              ei(k) = ac_prcp(k)
            ELSE
              ei(k) = ac_pet(k)
            END IF
            IF (0._sp .LT. ac_prcp(k) - ei(k)) THEN
              pn(k) = ac_prcp(k) - ei(k)
            ELSE
              pn(k) = 0._sp
            END IF
            en(k) = ac_pet(k) - ei(k)
          ELSE
            ei(k) = 0._sp
            pn(k) = 0._sp
            en(k) = 0._sp
          END IF
        END IF
      END DO
    END DO
! Forward MLP without OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            input_layer(:) = (/ac_ha(k), ac_hc(k), pn(k), en(k)/)
            CALL FORWARD_MLP(weight_1, bias_1, weight_2, bias_2, &
&                      weight_3, bias_3, input_layer, output_layer(:, k)&
&                     )
          ELSE
            output_layer(:, k) = 0._sp
          END IF
        END IF
      END DO
    END DO
! Production and transfer with OPENMP
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          imperviousness = input_data%physio_data%imperviousness(row, &
&           col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
            CALL GR_PRODUCTION(output_layer(1, k), output_layer(2, k), &
&                        pn(k), en(k), imperviousness, ac_ca(k), beta, &
&                        ac_ha(k), pr, perc, ps, es)
          ELSE
            pr = 0._sp
            perc = 0._sp
          END IF
! Range of correction c0.9: (1, 0)
          prr = 0.9_sp*(1._sp-output_layer(3, k)**2)*(pr+perc)
! Range of correction c0.1: (0, 10)
          prd = (0.1_sp+0.9_sp*output_layer(3, k)**2)*(pr+perc)
          CALL GR_TRANSFER(4._sp, ac_prcp(k), prr, ac_cc(k), ac_hc(k), &
&                    qr)
          IF (0._sp .LT. prd) THEN
            qd = prd
          ELSE
            qd = 0._sp
          END IF
          ac_qt(k) = ac_kb(k)*(qr+qd)
! Transform from mm/dt to m3/s
          ac_qt(k) = ac_qt(k)*1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col&
&           )/setup%dt
        END IF
      END DO
    END DO
  END SUBROUTINE LOIEAU_MLP_TIME_STEP

END MODULE MD_GR_OPERATOR_DIFF

!%      (MD) Module Differentiated.
!%
!%      Subroutine
!%      ----------
!%
!%      - upstream_discharge
!%      - linear_routing
!%      - kinematic_wave1d
!%      - lag0_time_step
!%      - lr_time_step
!%      - kw_time_step
MODULE MD_ROUTING_OPERATOR_DIFF
!% only : sp
  USE MD_CONSTANT
!% only: SetupDT
  USE MWD_SETUP
!% only: MeshDT
  USE MWD_MESH
!% only: OptionsDT
  USE MWD_OPTIONS_DIFF
!% only: ReturnsDT
  USE MWD_RETURNS_DIFF
  IMPLICIT NONE

CONTAINS
!  Differentiation of upstream_discharge in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: qup
!   with respect to varying inputs: ac_q
  SUBROUTINE UPSTREAM_DISCHARGE_D(mesh, row, col, ac_q, ac_q_d, qup, &
&   qup_d)
    IMPLICIT NONE
    TYPE(MESHDT), INTENT(IN) :: mesh
    INTEGER, INTENT(IN) :: row, col
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_q
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_q_d
    REAL(sp), INTENT(OUT) :: qup
    REAL(sp), INTENT(OUT) :: qup_d
    INTEGER :: i, row_imd, col_imd, k
    INTEGER, DIMENSION(8), SAVE :: drow=(/1, 1, 0, -1, -1, -1, 0, 1/)
    INTEGER, DIMENSION(8), SAVE :: dcol=(/0, -1, -1, -1, 0, 1, 1, 1/)
    qup = 0._sp
    qup_d = 0.0_4
    DO i=1,8
      row_imd = row + drow(i)
      col_imd = col + dcol(i)
      IF (.NOT.(((row_imd .LT. 1 .OR. row_imd .GT. mesh%nrow) .OR. &
&         col_imd .LT. 1) .OR. col_imd .GT. mesh%ncol)) THEN
        k = mesh%rowcol_to_ind_ac(row_imd, col_imd)
        IF (mesh%flwdir(row_imd, col_imd) .EQ. i) THEN
          qup_d = qup_d + ac_q_d(k)
          qup = qup + ac_q(k)
        END IF
      END IF
    END DO
  END SUBROUTINE UPSTREAM_DISCHARGE_D

!  Differentiation of upstream_discharge in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: ac_q qup
!   with respect to varying inputs: ac_q
  SUBROUTINE UPSTREAM_DISCHARGE_B(mesh, row, col, ac_q, ac_q_b, qup, &
&   qup_b)
    IMPLICIT NONE
    TYPE(MESHDT), INTENT(IN) :: mesh
    INTEGER, INTENT(IN) :: row, col
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_q
    REAL(sp), DIMENSION(mesh%nac) :: ac_q_b
    REAL(sp) :: qup
    REAL(sp) :: qup_b
    INTEGER :: i, row_imd, col_imd, k
    INTEGER, DIMENSION(8), SAVE :: drow=(/1, 1, 0, -1, -1, -1, 0, 1/)
    INTEGER, DIMENSION(8), SAVE :: dcol=(/0, -1, -1, -1, 0, 1, 1, 1/)
    INTEGER :: branch
    DO i=1,8
      row_imd = row + drow(i)
      col_imd = col + dcol(i)
      IF (((row_imd .LT. 1 .OR. row_imd .GT. mesh%nrow) .OR. col_imd &
&         .LT. 1) .OR. col_imd .GT. mesh%ncol) THEN
        CALL PUSHCONTROL2B(0)
      ELSE
        CALL PUSHINTEGER4(k)
        k = mesh%rowcol_to_ind_ac(row_imd, col_imd)
        IF (mesh%flwdir(row_imd, col_imd) .EQ. i) THEN
          CALL PUSHCONTROL2B(2)
        ELSE
          CALL PUSHCONTROL2B(1)
        END IF
      END IF
    END DO
    DO i=8,1,-1
      CALL POPCONTROL2B(branch)
      IF (branch .NE. 0) THEN
        IF (branch .NE. 1) ac_q_b(k) = ac_q_b(k) + qup_b
        CALL POPINTEGER4(k)
      END IF
    END DO
  END SUBROUTINE UPSTREAM_DISCHARGE_B

  SUBROUTINE UPSTREAM_DISCHARGE(mesh, row, col, ac_q, qup)
    IMPLICIT NONE
    TYPE(MESHDT), INTENT(IN) :: mesh
    INTEGER, INTENT(IN) :: row, col
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_q
    REAL(sp), INTENT(OUT) :: qup
    INTEGER :: i, row_imd, col_imd, k
    INTEGER, DIMENSION(8), SAVE :: drow=(/1, 1, 0, -1, -1, -1, 0, 1/)
    INTEGER, DIMENSION(8), SAVE :: dcol=(/0, -1, -1, -1, 0, 1, 1, 1/)
    qup = 0._sp
    DO i=1,8
      row_imd = row + drow(i)
      col_imd = col + dcol(i)
      IF (.NOT.(((row_imd .LT. 1 .OR. row_imd .GT. mesh%nrow) .OR. &
&         col_imd .LT. 1) .OR. col_imd .GT. mesh%ncol)) THEN
        k = mesh%rowcol_to_ind_ac(row_imd, col_imd)
        IF (mesh%flwdir(row_imd, col_imd) .EQ. i) qup = qup + ac_q(k)
      END IF
    END DO
  END SUBROUTINE UPSTREAM_DISCHARGE

!  Differentiation of linear_routing in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: hlr q
!   with respect to varying inputs: hlr q qup llr
  SUBROUTINE LINEAR_ROUTING_D(dx, dy, dt, flwacc, llr, llr_d, hlr, hlr_d&
&   , qup, qup_d, q, q_d)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: dx, dy, dt, flwacc
    REAL(sp), INTENT(IN) :: llr
    REAL(sp), INTENT(IN) :: llr_d
    REAL(sp), INTENT(INOUT) :: hlr, qup, q
    REAL(sp), INTENT(INOUT) :: hlr_d, qup_d, q_d
    REAL(sp) :: hlr_imd
    REAL(sp) :: hlr_imd_d
    INTRINSIC EXP
    REAL(sp) :: arg1
    REAL(sp) :: arg1_d
    REAL(sp) :: temp
    temp = 1e-3_sp*(flwacc-dx*dy)
    qup_d = dt*qup_d/temp
    qup = dt*(qup/temp)
    hlr_imd_d = hlr_d + qup_d
    hlr_imd = hlr + qup
    temp = dt/(60._sp*llr)
    arg1_d = temp*llr_d/llr
    arg1 = -temp
    temp = EXP(arg1)
    hlr_d = temp*hlr_imd_d + hlr_imd*EXP(arg1)*arg1_d
    hlr = hlr_imd*temp
    temp = 1e-3_sp*(flwacc-dx*dy)
    q_d = q_d + temp*(hlr_imd_d-hlr_d)/dt
    q = q + temp*((hlr_imd-hlr)/dt)
  END SUBROUTINE LINEAR_ROUTING_D

!  Differentiation of linear_routing in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: hlr q llr
!   with respect to varying inputs: hlr q qup llr
  SUBROUTINE LINEAR_ROUTING_B(dx, dy, dt, flwacc, llr, llr_b, hlr, hlr_b&
&   , qup, qup_b, q, q_b)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: dx, dy, dt, flwacc
    REAL(sp), INTENT(IN) :: llr
    REAL(sp) :: llr_b
    REAL(sp), INTENT(INOUT) :: hlr, qup, q
    REAL(sp), INTENT(INOUT) :: hlr_b, qup_b, q_b
    REAL(sp) :: hlr_imd
    REAL(sp) :: hlr_imd_b
    INTRINSIC EXP
    REAL(sp) :: arg1
    REAL(sp) :: arg1_b
    REAL(sp) :: temp_b
    qup = qup*dt/(1e-3_sp*(flwacc-dx*dy))
    hlr_imd = hlr + qup
    arg1 = -(dt/(llr*60._sp))
    arg1 = -(dt/(llr*60._sp))
    temp_b = (flwacc-dx*dy)*1e-3_sp*q_b/dt
    hlr_b = hlr_b - temp_b
    hlr_imd_b = temp_b + EXP(arg1)*hlr_b
    arg1_b = EXP(arg1)*hlr_imd*hlr_b
    llr_b = llr_b + dt*arg1_b/(llr**2*60._sp)
    hlr_b = hlr_imd_b
    qup_b = hlr_imd_b
    qup_b = dt*qup_b/(1e-3_sp*(flwacc-dx*dy))
  END SUBROUTINE LINEAR_ROUTING_B

  SUBROUTINE LINEAR_ROUTING(dx, dy, dt, flwacc, llr, hlr, qup, q)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: dx, dy, dt, flwacc
    REAL(sp), INTENT(IN) :: llr
    REAL(sp), INTENT(INOUT) :: hlr, qup, q
    REAL(sp) :: hlr_imd
    INTRINSIC EXP
    REAL(sp) :: arg1
    qup = qup*dt/(1e-3_sp*(flwacc-dx*dy))
    hlr_imd = hlr + qup
    arg1 = -(dt/(llr*60._sp))
    hlr = hlr_imd*EXP(arg1)
    q = q + (hlr_imd-hlr)*1e-3_sp*(flwacc-dx*dy)/dt
  END SUBROUTINE LINEAR_ROUTING

!  Differentiation of kinematic_wave1d in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: qij
!   with respect to varying inputs: qim1j bkw qijm1 qlij akw qlijm1
  SUBROUTINE KINEMATIC_WAVE1D_D(dx, dy, dt, akw, akw_d, bkw, bkw_d, &
&   qlijm1, qlijm1_d, qlij, qlij_d, qim1j, qim1j_d, qijm1, qijm1_d, qij&
&   , qij_d)
    IMPLICIT NONE
!% Non-Linear solution solved with Newton-Raphson
!% Commented while testing Linearized solution
!~         rhs = n1 + akw*wqijm1**bkw + n3
!~         iter = 0
!~         maxiter = 2
!~         rsd = 1._sp
!~         do while (abs(rsd) > 1e-6 .and. iter < maxiter)
!~             rsd = dtddx*qij + akw*qij**bkw - rhs
!~             rsd_d = dtddx + akw*bkw*qij**(bkw - 1._sp)
!~             qij = qij - rsd/rsd_d
!~             qij = max(qij, 0._sp)
!~             iter = iter + 1
!~         end do
    REAL(sp), INTENT(IN) :: dx, dy, dt
    REAL(sp), INTENT(IN) :: akw, bkw
    REAL(sp), INTENT(IN) :: akw_d, bkw_d
    REAL(sp), INTENT(IN) :: qlijm1, qlij, qim1j, qijm1
    REAL(sp), INTENT(IN) :: qlijm1_d, qlij_d, qim1j_d, qijm1_d
    REAL(sp), INTENT(INOUT) :: qij
    REAL(sp), INTENT(INOUT) :: qij_d
    REAL(sp) :: wqlijm1, wqlij, wqim1j, wqijm1
    REAL(sp) :: wqlijm1_d, wqlij_d, wqim1j_d, wqijm1_d
    REAL(sp) :: dtddx, n1, n2, n3, d1, d2, rhs, rsd, rsd_d
    REAL(sp) :: n1_d, n2_d, n3_d, d2_d
    INTEGER :: iter, maxiter
    INTRINSIC MAX
    REAL(sp) :: pwx1
    REAL(sp) :: pwx1_d
    REAL(sp) :: pwy1
    REAL(sp) :: pwy1_d
    REAL(sp) :: pwr1
    REAL(sp) :: pwr1_d
    REAL(sp) :: temp
    IF (1e-6_sp .LT. qlijm1) THEN
      wqlijm1_d = qlijm1_d
      wqlijm1 = qlijm1
    ELSE
      wqlijm1 = 1e-6_sp
      wqlijm1_d = 0.0_4
    END IF
    IF (1e-6_sp .LT. qlij) THEN
      wqlij_d = qlij_d
      wqlij = qlij
    ELSE
      wqlij = 1e-6_sp
      wqlij_d = 0.0_4
    END IF
    IF (1e-6_sp .LT. qim1j) THEN
      wqim1j_d = qim1j_d
      wqim1j = qim1j
    ELSE
      wqim1j = 1e-6_sp
      wqim1j_d = 0.0_4
    END IF
    IF (1e-6_sp .LT. qijm1) THEN
      wqijm1_d = qijm1_d
      wqijm1 = qijm1
    ELSE
      wqijm1 = 1e-6_sp
      wqijm1_d = 0.0_4
    END IF
    dtddx = dt/dx
    d1 = dtddx
    pwx1_d = (wqijm1_d+wqim1j_d)/2._sp
    pwx1 = (wqijm1+wqim1j)/2._sp
    pwy1_d = bkw_d
    pwy1 = bkw - 1._sp
    temp = pwx1**pwy1
    IF (pwx1 .LE. 0.0 .AND. (pwy1 .EQ. 0.0 .OR. pwy1 .NE. INT(pwy1))) &
&   THEN
      pwr1_d = 0.0_4
    ELSE IF (pwx1 .LE. 0.0) THEN
      pwr1_d = pwy1*pwx1**(pwy1-1)*pwx1_d
    ELSE
      pwr1_d = pwy1*pwx1**(pwy1-1)*pwx1_d + temp*LOG(pwx1)*pwy1_d
    END IF
    pwr1 = temp
    d2_d = pwr1*(bkw*akw_d+akw*bkw_d) + akw*bkw*pwr1_d
    d2 = akw*bkw*pwr1
    n1_d = dtddx*wqim1j_d
    n1 = dtddx*wqim1j
    n2_d = d2*wqijm1_d + wqijm1*d2_d
    n2 = wqijm1*d2
    n3_d = dtddx*(wqlijm1_d+wqlij_d)/2._sp
    n3 = dtddx*(wqlijm1+wqlij)/2._sp
!% Linearized solution
    temp = (n1+n2+n3)/(d1+d2)
    qij_d = (n1_d+n2_d+n3_d-temp*d2_d)/(d1+d2)
    qij = temp
  END SUBROUTINE KINEMATIC_WAVE1D_D

!  Differentiation of kinematic_wave1d in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: bkw akw qij
!   with respect to varying inputs: qim1j bkw qijm1 qlij akw qlijm1
  SUBROUTINE KINEMATIC_WAVE1D_B(dx, dy, dt, akw, akw_b, bkw, bkw_b, &
&   qlijm1, qlijm1_b, qlij, qlij_b, qim1j, qim1j_b, qijm1, qijm1_b, qij&
&   , qij_b)
    IMPLICIT NONE
!% Non-Linear solution solved with Newton-Raphson
!% Commented while testing Linearized solution
!~         rhs = n1 + akw*wqijm1**bkw + n3
!~         iter = 0
!~         maxiter = 2
!~         rsd = 1._sp
!~         do while (abs(rsd) > 1e-6 .and. iter < maxiter)
!~             rsd = dtddx*qij + akw*qij**bkw - rhs
!~             rsd_d = dtddx + akw*bkw*qij**(bkw - 1._sp)
!~             qij = qij - rsd/rsd_d
!~             qij = max(qij, 0._sp)
!~             iter = iter + 1
!~         end do
    REAL(sp), INTENT(IN) :: dx, dy, dt
    REAL(sp), INTENT(IN) :: akw, bkw
    REAL(sp) :: akw_b, bkw_b
    REAL(sp), INTENT(IN) :: qlijm1, qlij, qim1j, qijm1
    REAL(sp) :: qlijm1_b, qlij_b, qim1j_b, qijm1_b
    REAL(sp), INTENT(INOUT) :: qij
    REAL(sp), INTENT(INOUT) :: qij_b
    REAL(sp) :: wqlijm1, wqlij, wqim1j, wqijm1
    REAL(sp) :: wqlijm1_b, wqlij_b, wqim1j_b, wqijm1_b
    REAL(sp) :: dtddx, n1, n2, n3, d1, d2, rhs, rsd, rsd_d
    REAL(sp) :: n1_b, n2_b, n3_b, d2_b
    INTEGER :: iter, maxiter
    INTRINSIC MAX
    REAL(sp) :: pwx1
    REAL(sp) :: pwx1_b
    REAL(sp) :: pwy1
    REAL(sp) :: pwy1_b
    REAL(sp) :: pwr1
    REAL(sp) :: pwr1_b
    REAL(sp) :: temp_b
    INTEGER :: branch
    IF (1e-6_sp .LT. qlijm1) THEN
      wqlijm1 = qlijm1
      CALL PUSHCONTROL1B(0)
    ELSE
      wqlijm1 = 1e-6_sp
      CALL PUSHCONTROL1B(1)
    END IF
    IF (1e-6_sp .LT. qlij) THEN
      wqlij = qlij
      CALL PUSHCONTROL1B(0)
    ELSE
      wqlij = 1e-6_sp
      CALL PUSHCONTROL1B(1)
    END IF
    IF (1e-6_sp .LT. qim1j) THEN
      wqim1j = qim1j
      CALL PUSHCONTROL1B(0)
    ELSE
      wqim1j = 1e-6_sp
      CALL PUSHCONTROL1B(1)
    END IF
    IF (1e-6_sp .LT. qijm1) THEN
      wqijm1 = qijm1
      CALL PUSHCONTROL1B(0)
    ELSE
      wqijm1 = 1e-6_sp
      CALL PUSHCONTROL1B(1)
    END IF
    dtddx = dt/dx
    d1 = dtddx
    pwx1 = (wqijm1+wqim1j)/2._sp
    pwy1 = bkw - 1._sp
    pwr1 = pwx1**pwy1
    d2 = akw*bkw*pwr1
    n1 = dtddx*wqim1j
    n2 = wqijm1*d2
    n3 = dtddx*(wqlijm1+wqlij)/2._sp
!% Linearized solution
    d2 = akw*bkw*pwr1
    pwy1 = bkw - 1._sp
    n2 = wqijm1*d2
    dtddx = dt/dx
    temp_b = qij_b/(d1+d2)
    n1_b = temp_b
    n2_b = temp_b
    n3_b = temp_b
    d2_b = wqijm1*n2_b - (n1+n2+n3)*temp_b/(d1+d2)
    temp_b = dtddx*n3_b/2._sp
    wqlijm1_b = temp_b
    wqlij_b = temp_b
    akw_b = akw_b + bkw*pwr1*d2_b
    pwr1_b = akw*bkw*d2_b
    IF (pwx1 .LE. 0.0 .AND. (pwy1 .EQ. 0.0 .OR. pwy1 .NE. INT(pwy1))) &
&   THEN
      pwx1_b = 0.0_4
    ELSE
      pwx1_b = pwy1*pwx1**(pwy1-1)*pwr1_b
    END IF
    wqijm1_b = d2*n2_b + pwx1_b/2._sp
    wqim1j_b = dtddx*n1_b + pwx1_b/2._sp
    IF (pwx1 .LE. 0.0) THEN
      pwy1_b = 0.0_4
    ELSE
      pwy1_b = pwx1**pwy1*LOG(pwx1)*pwr1_b
    END IF
    bkw_b = bkw_b + akw*pwr1*d2_b + pwy1_b
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      qijm1_b = wqijm1_b
    ELSE
      qijm1_b = 0.0_4
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      qim1j_b = wqim1j_b
    ELSE
      qim1j_b = 0.0_4
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      qlij_b = wqlij_b
    ELSE
      qlij_b = 0.0_4
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      qlijm1_b = wqlijm1_b
    ELSE
      qlijm1_b = 0.0_4
    END IF
  END SUBROUTINE KINEMATIC_WAVE1D_B

  SUBROUTINE KINEMATIC_WAVE1D(dx, dy, dt, akw, bkw, qlijm1, qlij, qim1j&
&   , qijm1, qij)
    IMPLICIT NONE
!% Non-Linear solution solved with Newton-Raphson
!% Commented while testing Linearized solution
!~         rhs = n1 + akw*wqijm1**bkw + n3
!~         iter = 0
!~         maxiter = 2
!~         rsd = 1._sp
!~         do while (abs(rsd) > 1e-6 .and. iter < maxiter)
!~             rsd = dtddx*qij + akw*qij**bkw - rhs
!~             rsd_d = dtddx + akw*bkw*qij**(bkw - 1._sp)
!~             qij = qij - rsd/rsd_d
!~             qij = max(qij, 0._sp)
!~             iter = iter + 1
!~         end do
    REAL(sp), INTENT(IN) :: dx, dy, dt
    REAL(sp), INTENT(IN) :: akw, bkw
    REAL(sp), INTENT(IN) :: qlijm1, qlij, qim1j, qijm1
    REAL(sp), INTENT(INOUT) :: qij
    REAL(sp) :: wqlijm1, wqlij, wqim1j, wqijm1
    REAL(sp) :: dtddx, n1, n2, n3, d1, d2, rhs, rsd, rsd_d
    INTEGER :: iter, maxiter
    INTRINSIC MAX
    REAL(sp) :: pwx1
    REAL(sp) :: pwy1
    REAL(sp) :: pwr1
    IF (1e-6_sp .LT. qlijm1) THEN
      wqlijm1 = qlijm1
    ELSE
      wqlijm1 = 1e-6_sp
    END IF
    IF (1e-6_sp .LT. qlij) THEN
      wqlij = qlij
    ELSE
      wqlij = 1e-6_sp
    END IF
    IF (1e-6_sp .LT. qim1j) THEN
      wqim1j = qim1j
    ELSE
      wqim1j = 1e-6_sp
    END IF
    IF (1e-6_sp .LT. qijm1) THEN
      wqijm1 = qijm1
    ELSE
      wqijm1 = 1e-6_sp
    END IF
    dtddx = dt/dx
    d1 = dtddx
    pwx1 = (wqijm1+wqim1j)/2._sp
    pwy1 = bkw - 1._sp
    pwr1 = pwx1**pwy1
    d2 = akw*bkw*pwr1
    n1 = dtddx*wqim1j
    n2 = wqijm1*d2
    n3 = dtddx*(wqlijm1+wqlij)/2._sp
!% Linearized solution
    qij = (n1+n2+n3)/(d1+d2)
  END SUBROUTINE KINEMATIC_WAVE1D

!  Differentiation of lag0_time_step in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: ac_qz
!   with respect to varying inputs: ac_qz ac_qtz
  SUBROUTINE LAG0_TIME_STEP_D(setup, mesh, options, returns, time_step, &
&   ac_qtz, ac_qtz_d, ac_qz, ac_qz_d)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(IN) :: ac_qtz
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(IN) :: ac_qtz_d
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(INOUT) :: ac_qz
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(INOUT) :: ac_qz_d
    INTEGER :: i, j, row, col, k, time_step_returns
    REAL(sp) :: qup
    REAL(sp) :: qup_d
    ac_qz_d(:, setup%nqz) = ac_qtz_d(:, setup%nqz)
    ac_qz(:, setup%nqz) = ac_qtz(:, setup%nqz)
! Skip the first partition because boundary cells are not routed
    DO i=2,mesh%npar
! Tapenade does not accept 'IF' condition within OMP directive. Therefore, the routing loop
! is duplicated ... Maybe there is another way to do it.
      IF (mesh%ncpar(i) .GE. options%comm%ncpu) THEN
        DO j=1,mesh%ncpar(i)
          row = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 1)
          col = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 2)
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&             local_active_cell(row, col) .EQ. 0)) THEN
            CALL UPSTREAM_DISCHARGE_D(mesh, row, col, ac_qz(:, setup%nqz&
&                               ), ac_qz_d(:, setup%nqz), qup, qup_d)
            ac_qz_d(k, setup%nqz) = ac_qz_d(k, setup%nqz) + qup_d
            ac_qz(k, setup%nqz) = ac_qz(k, setup%nqz) + qup
          END IF
        END DO
      ELSE
        DO j=1,mesh%ncpar(i)
          row = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 1)
          col = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 2)
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&             local_active_cell(row, col) .EQ. 0)) THEN
            CALL UPSTREAM_DISCHARGE_D(mesh, row, col, ac_qz(:, setup%nqz&
&                               ), ac_qz_d(:, setup%nqz), qup, qup_d)
            ac_qz_d(k, setup%nqz) = ac_qz_d(k, setup%nqz) + qup_d
            ac_qz(k, setup%nqz) = ac_qz(k, setup%nqz) + qup
          END IF
        END DO
      END IF
    END DO
  END SUBROUTINE LAG0_TIME_STEP_D

!  Differentiation of lag0_time_step in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: ac_qz ac_qtz
!   with respect to varying inputs: ac_qz ac_qtz
  SUBROUTINE LAG0_TIME_STEP_B(setup, mesh, options, returns, time_step, &
&   ac_qtz, ac_qtz_b, ac_qz, ac_qz_b)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(IN) :: ac_qtz
    REAL(sp), DIMENSION(mesh%nac, setup%nqz) :: ac_qtz_b
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(INOUT) :: ac_qz
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(INOUT) :: ac_qz_b
    INTEGER :: i, j, row, col, k, time_step_returns
    REAL(sp) :: qup
    REAL(sp) :: qup_b
    INTEGER :: ad_to
    INTEGER :: branch
    INTEGER :: ad_to0
    ac_qz(:, setup%nqz) = ac_qtz(:, setup%nqz)
! Skip the first partition because boundary cells are not routed
    DO i=2,mesh%npar
! Tapenade does not accept 'IF' condition within OMP directive. Therefore, the routing loop
! is duplicated ... Maybe there is another way to do it.
      IF (mesh%ncpar(i) .GE. options%comm%ncpu) THEN
        DO j=1,mesh%ncpar(i)
          row = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 1)
          col = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 2)
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&             local_active_cell(row, col) .EQ. 0) THEN
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL UPSTREAM_DISCHARGE(mesh, row, col, ac_qz(:, setup%nqz)&
&                             , qup)
            ac_qz(k, setup%nqz) = ac_qz(k, setup%nqz) + qup
            CALL PUSHCONTROL1B(1)
          END IF
        END DO
        CALL PUSHINTEGER4(j - 1)
        CALL PUSHCONTROL1B(1)
      ELSE
        DO j=1,mesh%ncpar(i)
          row = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 1)
          col = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 2)
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&             local_active_cell(row, col) .EQ. 0) THEN
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL UPSTREAM_DISCHARGE(mesh, row, col, ac_qz(:, setup%nqz)&
&                             , qup)
            ac_qz(k, setup%nqz) = ac_qz(k, setup%nqz) + qup
            CALL PUSHCONTROL1B(1)
          END IF
        END DO
        CALL PUSHINTEGER4(j - 1)
        CALL PUSHCONTROL1B(0)
      END IF
    END DO
    DO i=mesh%npar,2,-1
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) THEN
        CALL POPINTEGER4(ad_to0)
        DO j=ad_to0,1,-1
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) THEN
            row = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 1)
            col = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 2)
            k = mesh%rowcol_to_ind_ac(row, col)
            qup_b = ac_qz_b(k, setup%nqz)
            CALL UPSTREAM_DISCHARGE_B(mesh, row, col, ac_qz(:, setup%nqz&
&                               ), ac_qz_b(:, setup%nqz), qup, qup_b)
          END IF
        END DO
      ELSE
        CALL POPINTEGER4(ad_to)
        DO j=ad_to,1,-1
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) THEN
            row = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 1)
            col = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 2)
            k = mesh%rowcol_to_ind_ac(row, col)
            qup_b = ac_qz_b(k, setup%nqz)
            CALL UPSTREAM_DISCHARGE_B(mesh, row, col, ac_qz(:, setup%nqz&
&                               ), ac_qz_b(:, setup%nqz), qup, qup_b)
          END IF
        END DO
      END IF
    END DO
    ac_qtz_b(:, setup%nqz) = ac_qtz_b(:, setup%nqz) + ac_qz_b(:, setup%&
&     nqz)
    ac_qz_b(:, setup%nqz) = 0.0_4
  END SUBROUTINE LAG0_TIME_STEP_B

  SUBROUTINE LAG0_TIME_STEP(setup, mesh, options, returns, time_step, &
&   ac_qtz, ac_qz)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(IN) :: ac_qtz
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(INOUT) :: ac_qz
    INTEGER :: i, j, row, col, k, time_step_returns
    REAL(sp) :: qup
    ac_qz(:, setup%nqz) = ac_qtz(:, setup%nqz)
! Skip the first partition because boundary cells are not routed
    DO i=2,mesh%npar
! Tapenade does not accept 'IF' condition within OMP directive. Therefore, the routing loop
! is duplicated ... Maybe there is another way to do it.
      IF (mesh%ncpar(i) .GE. options%comm%ncpu) THEN
        DO j=1,mesh%ncpar(i)
          row = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 1)
          col = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 2)
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&             local_active_cell(row, col) .EQ. 0)) THEN
            CALL UPSTREAM_DISCHARGE(mesh, row, col, ac_qz(:, setup%nqz)&
&                             , qup)
            ac_qz(k, setup%nqz) = ac_qz(k, setup%nqz) + qup
          END IF
        END DO
      ELSE
        DO j=1,mesh%ncpar(i)
          row = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 1)
          col = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 2)
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&             local_active_cell(row, col) .EQ. 0)) THEN
            CALL UPSTREAM_DISCHARGE(mesh, row, col, ac_qz(:, setup%nqz)&
&                             , qup)
            ac_qz(k, setup%nqz) = ac_qz(k, setup%nqz) + qup
          END IF
        END DO
      END IF
    END DO
  END SUBROUTINE LAG0_TIME_STEP

!  Differentiation of lr_time_step in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: ac_qz ac_hlr
!   with respect to varying inputs: ac_llr ac_qz ac_hlr ac_qtz
  SUBROUTINE LR_TIME_STEP_D(setup, mesh, options, returns, time_step, &
&   ac_qtz, ac_qtz_d, ac_llr, ac_llr_d, ac_hlr, ac_hlr_d, ac_qz, ac_qz_d&
& )
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(IN) :: ac_qtz
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(IN) :: ac_qtz_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_llr
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_llr_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hlr
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hlr_d
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(INOUT) :: ac_qz
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(INOUT) :: ac_qz_d
    INTEGER :: i, j, row, col, k, time_step_returns
    REAL(sp) :: qup
    REAL(sp) :: qup_d
    ac_qz_d(:, setup%nqz) = ac_qtz_d(:, setup%nqz)
    ac_qz(:, setup%nqz) = ac_qtz(:, setup%nqz)
! Skip the first partition because boundary cells are not routed
    DO i=2,mesh%npar
! Tapenade does not accept 'IF' condition within OMP directive. Therefore, the routing loop
! is duplicated ... Maybe there is another way to do it.
      IF (mesh%ncpar(i) .GE. options%comm%ncpu) THEN
        DO j=1,mesh%ncpar(i)
          row = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 1)
          col = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 2)
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&             local_active_cell(row, col) .EQ. 0)) THEN
            CALL UPSTREAM_DISCHARGE_D(mesh, row, col, ac_qz(:, setup%nqz&
&                               ), ac_qz_d(:, setup%nqz), qup, qup_d)
            CALL LINEAR_ROUTING_D(mesh%dx(row, col), mesh%dy(row, col), &
&                           setup%dt, mesh%flwacc(row, col), ac_llr(k), &
&                           ac_llr_d(k), ac_hlr(k), ac_hlr_d(k), qup, &
&                           qup_d, ac_qz(k, setup%nqz), ac_qz_d(k, setup&
&                           %nqz))
          END IF
        END DO
      ELSE
        DO j=1,mesh%ncpar(i)
          row = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 1)
          col = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 2)
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&             local_active_cell(row, col) .EQ. 0)) THEN
            CALL UPSTREAM_DISCHARGE_D(mesh, row, col, ac_qz(:, setup%nqz&
&                               ), ac_qz_d(:, setup%nqz), qup, qup_d)
            CALL LINEAR_ROUTING_D(mesh%dx(row, col), mesh%dy(row, col), &
&                           setup%dt, mesh%flwacc(row, col), ac_llr(k), &
&                           ac_llr_d(k), ac_hlr(k), ac_hlr_d(k), qup, &
&                           qup_d, ac_qz(k, setup%nqz), ac_qz_d(k, setup&
&                           %nqz))
          END IF
        END DO
      END IF
    END DO
  END SUBROUTINE LR_TIME_STEP_D

!  Differentiation of lr_time_step in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: ac_llr ac_qz ac_hlr ac_qtz
!   with respect to varying inputs: ac_llr ac_qz ac_hlr ac_qtz
  SUBROUTINE LR_TIME_STEP_B(setup, mesh, options, returns, time_step, &
&   ac_qtz, ac_qtz_b, ac_llr, ac_llr_b, ac_hlr, ac_hlr_b, ac_qz, ac_qz_b&
& )
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(IN) :: ac_qtz
    REAL(sp), DIMENSION(mesh%nac, setup%nqz) :: ac_qtz_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_llr
    REAL(sp), DIMENSION(mesh%nac) :: ac_llr_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hlr
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hlr_b
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(INOUT) :: ac_qz
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(INOUT) :: ac_qz_b
    INTEGER :: i, j, row, col, k, time_step_returns
    REAL(sp) :: qup
    REAL(sp) :: qup_b
    INTEGER :: ad_to
    INTEGER :: branch
    INTEGER :: ad_to0
    ac_qz(:, setup%nqz) = ac_qtz(:, setup%nqz)
! Skip the first partition because boundary cells are not routed
    DO i=2,mesh%npar
! Tapenade does not accept 'IF' condition within OMP directive. Therefore, the routing loop
! is duplicated ... Maybe there is another way to do it.
      IF (mesh%ncpar(i) .GE. options%comm%ncpu) THEN
        DO j=1,mesh%ncpar(i)
          row = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 1)
          col = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 2)
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&             local_active_cell(row, col) .EQ. 0) THEN
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL UPSTREAM_DISCHARGE(mesh, row, col, ac_qz(:, setup%nqz)&
&                             , qup)
            CALL PUSHREAL4(qup)
            CALL PUSHREAL4(ac_hlr(k))
            CALL LINEAR_ROUTING(mesh%dx(row, col), mesh%dy(row, col), &
&                         setup%dt, mesh%flwacc(row, col), ac_llr(k), &
&                         ac_hlr(k), qup, ac_qz(k, setup%nqz))
            CALL PUSHCONTROL1B(1)
          END IF
        END DO
        CALL PUSHINTEGER4(j - 1)
        CALL PUSHCONTROL1B(1)
      ELSE
        DO j=1,mesh%ncpar(i)
          row = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 1)
          col = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 2)
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&             local_active_cell(row, col) .EQ. 0) THEN
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL UPSTREAM_DISCHARGE(mesh, row, col, ac_qz(:, setup%nqz)&
&                             , qup)
            CALL PUSHREAL4(qup)
            CALL PUSHREAL4(ac_hlr(k))
            CALL LINEAR_ROUTING(mesh%dx(row, col), mesh%dy(row, col), &
&                         setup%dt, mesh%flwacc(row, col), ac_llr(k), &
&                         ac_hlr(k), qup, ac_qz(k, setup%nqz))
            CALL PUSHCONTROL1B(1)
          END IF
        END DO
        CALL PUSHINTEGER4(j - 1)
        CALL PUSHCONTROL1B(0)
      END IF
    END DO
    DO i=mesh%npar,2,-1
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) THEN
        CALL POPINTEGER4(ad_to0)
        DO j=ad_to0,1,-1
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) THEN
            row = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 1)
            col = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 2)
            k = mesh%rowcol_to_ind_ac(row, col)
            CALL POPREAL4(ac_hlr(k))
            CALL POPREAL4(qup)
            CALL LINEAR_ROUTING_B(mesh%dx(row, col), mesh%dy(row, col), &
&                           setup%dt, mesh%flwacc(row, col), ac_llr(k), &
&                           ac_llr_b(k), ac_hlr(k), ac_hlr_b(k), qup, &
&                           qup_b, ac_qz(k, setup%nqz), ac_qz_b(k, setup&
&                           %nqz))
            CALL UPSTREAM_DISCHARGE_B(mesh, row, col, ac_qz(:, setup%nqz&
&                               ), ac_qz_b(:, setup%nqz), qup, qup_b)
          END IF
        END DO
      ELSE
        CALL POPINTEGER4(ad_to)
        DO j=ad_to,1,-1
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) THEN
            row = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 1)
            col = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 2)
            k = mesh%rowcol_to_ind_ac(row, col)
            CALL POPREAL4(ac_hlr(k))
            CALL POPREAL4(qup)
            CALL LINEAR_ROUTING_B(mesh%dx(row, col), mesh%dy(row, col), &
&                           setup%dt, mesh%flwacc(row, col), ac_llr(k), &
&                           ac_llr_b(k), ac_hlr(k), ac_hlr_b(k), qup, &
&                           qup_b, ac_qz(k, setup%nqz), ac_qz_b(k, setup&
&                           %nqz))
            CALL UPSTREAM_DISCHARGE_B(mesh, row, col, ac_qz(:, setup%nqz&
&                               ), ac_qz_b(:, setup%nqz), qup, qup_b)
          END IF
        END DO
      END IF
    END DO
    ac_qtz_b(:, setup%nqz) = ac_qtz_b(:, setup%nqz) + ac_qz_b(:, setup%&
&     nqz)
    ac_qz_b(:, setup%nqz) = 0.0_4
  END SUBROUTINE LR_TIME_STEP_B

  SUBROUTINE LR_TIME_STEP(setup, mesh, options, returns, time_step, &
&   ac_qtz, ac_llr, ac_hlr, ac_qz)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(IN) :: ac_qtz
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_llr
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hlr
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(INOUT) :: ac_qz
    INTEGER :: i, j, row, col, k, time_step_returns
    REAL(sp) :: qup
    ac_qz(:, setup%nqz) = ac_qtz(:, setup%nqz)
! Skip the first partition because boundary cells are not routed
    DO i=2,mesh%npar
! Tapenade does not accept 'IF' condition within OMP directive. Therefore, the routing loop
! is duplicated ... Maybe there is another way to do it.
      IF (mesh%ncpar(i) .GE. options%comm%ncpu) THEN
        DO j=1,mesh%ncpar(i)
          row = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 1)
          col = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 2)
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&             local_active_cell(row, col) .EQ. 0)) THEN
            CALL UPSTREAM_DISCHARGE(mesh, row, col, ac_qz(:, setup%nqz)&
&                             , qup)
            CALL LINEAR_ROUTING(mesh%dx(row, col), mesh%dy(row, col), &
&                         setup%dt, mesh%flwacc(row, col), ac_llr(k), &
&                         ac_hlr(k), qup, ac_qz(k, setup%nqz))
          END IF
        END DO
      ELSE
        DO j=1,mesh%ncpar(i)
          row = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 1)
          col = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 2)
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&             local_active_cell(row, col) .EQ. 0)) THEN
            CALL UPSTREAM_DISCHARGE(mesh, row, col, ac_qz(:, setup%nqz)&
&                             , qup)
            CALL LINEAR_ROUTING(mesh%dx(row, col), mesh%dy(row, col), &
&                         setup%dt, mesh%flwacc(row, col), ac_llr(k), &
&                         ac_hlr(k), qup, ac_qz(k, setup%nqz))
          END IF
        END DO
      END IF
    END DO
  END SUBROUTINE LR_TIME_STEP

!  Differentiation of kw_time_step in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: ac_qz
!   with respect to varying inputs: ac_akw ac_qz ac_qtz ac_bkw
  SUBROUTINE KW_TIME_STEP_D(setup, mesh, options, returns, t, ac_qtz, &
&   ac_qtz_d, ac_akw, ac_akw_d, ac_bkw, ac_bkw_d, ac_qz, ac_qz_d)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: t
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(IN) :: ac_qtz
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(IN) :: ac_qtz_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_akw, ac_bkw
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_akw_d, ac_bkw_d
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(INOUT) :: ac_qz
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(INOUT) :: ac_qz_d
    INTEGER :: i, j, row, col, k, t_returns
    REAL(sp) :: qlijm1, qlij, qim1j, qijm1
    REAL(sp) :: qlijm1_d, qlij_d, qim1j_d, qijm1_d
    ac_qz_d(:, setup%nqz) = ac_qtz_d(:, setup%nqz)
    ac_qz(:, setup%nqz) = ac_qtz(:, setup%nqz)
! Skip the first partition because boundary cells are not routed
    DO i=2,mesh%npar
! Tapenade does not accept 'IF' condition within OMP directive. Therefore, the routing loop
! is duplicated ... Maybe there is another way to do it.
      IF (mesh%ncpar(i) .GE. options%comm%ncpu) THEN
        DO j=1,mesh%ncpar(i)
          row = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 1)
          col = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 2)
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&             local_active_cell(row, col) .EQ. 0)) THEN
            qlijm1_d = ac_qtz_d(k, setup%nqz-1)
            qlijm1 = ac_qtz(k, setup%nqz-1)
            qlij_d = ac_qtz_d(k, setup%nqz)
            qlij = ac_qtz(k, setup%nqz)
            qijm1_d = ac_qz_d(k, setup%nqz-1)
            qijm1 = ac_qz(k, setup%nqz-1)
            CALL UPSTREAM_DISCHARGE_D(mesh, row, col, ac_qz(:, setup%nqz&
&                               ), ac_qz_d(:, setup%nqz), qim1j, qim1j_d&
&                              )
            CALL KINEMATIC_WAVE1D_D(mesh%dx(row, col), mesh%dy(row, col)&
&                             , setup%dt, ac_akw(k), ac_akw_d(k), ac_bkw&
&                             (k), ac_bkw_d(k), qlijm1, qlijm1_d, qlij, &
&                             qlij_d, qim1j, qim1j_d, qijm1, qijm1_d, &
&                             ac_qz(k, setup%nqz), ac_qz_d(k, setup%nqz)&
&                            )
          END IF
        END DO
      ELSE
        DO j=1,mesh%ncpar(i)
          row = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 1)
          col = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 2)
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&             local_active_cell(row, col) .EQ. 0)) THEN
            qlijm1_d = ac_qtz_d(k, setup%nqz-1)
            qlijm1 = ac_qtz(k, setup%nqz-1)
            qlij_d = ac_qtz_d(k, setup%nqz)
            qlij = ac_qtz(k, setup%nqz)
            qijm1_d = ac_qz_d(k, setup%nqz-1)
            qijm1 = ac_qz(k, setup%nqz-1)
            CALL UPSTREAM_DISCHARGE_D(mesh, row, col, ac_qz(:, setup%nqz&
&                               ), ac_qz_d(:, setup%nqz), qim1j, qim1j_d&
&                              )
            CALL KINEMATIC_WAVE1D_D(mesh%dx(row, col), mesh%dy(row, col)&
&                             , setup%dt, ac_akw(k), ac_akw_d(k), ac_bkw&
&                             (k), ac_bkw_d(k), qlijm1, qlijm1_d, qlij, &
&                             qlij_d, qim1j, qim1j_d, qijm1, qijm1_d, &
&                             ac_qz(k, setup%nqz), ac_qz_d(k, setup%nqz)&
&                            )
          END IF
        END DO
      END IF
    END DO
  END SUBROUTINE KW_TIME_STEP_D

!  Differentiation of kw_time_step in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: ac_akw ac_qz ac_qtz ac_bkw
!   with respect to varying inputs: ac_akw ac_qz ac_qtz ac_bkw
  SUBROUTINE KW_TIME_STEP_B(setup, mesh, options, returns, t, ac_qtz, &
&   ac_qtz_b, ac_akw, ac_akw_b, ac_bkw, ac_bkw_b, ac_qz, ac_qz_b)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: t
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(IN) :: ac_qtz
    REAL(sp), DIMENSION(mesh%nac, setup%nqz) :: ac_qtz_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_akw, ac_bkw
    REAL(sp), DIMENSION(mesh%nac) :: ac_akw_b, ac_bkw_b
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(INOUT) :: ac_qz
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(INOUT) :: ac_qz_b
    INTEGER :: i, j, row, col, k, t_returns
    REAL(sp) :: qlijm1, qlij, qim1j, qijm1
    REAL(sp) :: qlijm1_b, qlij_b, qim1j_b, qijm1_b
    INTEGER :: ad_to
    INTEGER :: branch
    INTEGER :: ad_to0
    ac_qz(:, setup%nqz) = ac_qtz(:, setup%nqz)
! Skip the first partition because boundary cells are not routed
    DO i=2,mesh%npar
! Tapenade does not accept 'IF' condition within OMP directive. Therefore, the routing loop
! is duplicated ... Maybe there is another way to do it.
      IF (mesh%ncpar(i) .GE. options%comm%ncpu) THEN
        DO j=1,mesh%ncpar(i)
          row = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 1)
          col = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 2)
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&             local_active_cell(row, col) .EQ. 0) THEN
            CALL PUSHCONTROL1B(0)
          ELSE
            qlijm1 = ac_qtz(k, setup%nqz-1)
            qlij = ac_qtz(k, setup%nqz)
            CALL PUSHREAL4(qijm1)
            qijm1 = ac_qz(k, setup%nqz-1)
            CALL PUSHREAL4(qim1j)
            CALL UPSTREAM_DISCHARGE(mesh, row, col, ac_qz(:, setup%nqz)&
&                             , qim1j)
            CALL KINEMATIC_WAVE1D(mesh%dx(row, col), mesh%dy(row, col), &
&                           setup%dt, ac_akw(k), ac_bkw(k), qlijm1, qlij&
&                           , qim1j, qijm1, ac_qz(k, setup%nqz))
            CALL PUSHCONTROL1B(1)
          END IF
        END DO
        CALL PUSHINTEGER4(j - 1)
        CALL PUSHCONTROL1B(1)
      ELSE
        DO j=1,mesh%ncpar(i)
          row = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 1)
          col = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 2)
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&             local_active_cell(row, col) .EQ. 0) THEN
            CALL PUSHCONTROL1B(0)
          ELSE
            qlijm1 = ac_qtz(k, setup%nqz-1)
            qlij = ac_qtz(k, setup%nqz)
            CALL PUSHREAL4(qijm1)
            qijm1 = ac_qz(k, setup%nqz-1)
            CALL PUSHREAL4(qim1j)
            CALL UPSTREAM_DISCHARGE(mesh, row, col, ac_qz(:, setup%nqz)&
&                             , qim1j)
            CALL KINEMATIC_WAVE1D(mesh%dx(row, col), mesh%dy(row, col), &
&                           setup%dt, ac_akw(k), ac_bkw(k), qlijm1, qlij&
&                           , qim1j, qijm1, ac_qz(k, setup%nqz))
            CALL PUSHCONTROL1B(1)
          END IF
        END DO
        CALL PUSHINTEGER4(j - 1)
        CALL PUSHCONTROL1B(0)
      END IF
    END DO
    DO i=mesh%npar,2,-1
      CALL POPCONTROL1B(branch)
      IF (branch .EQ. 0) THEN
        CALL POPINTEGER4(ad_to0)
        DO j=ad_to0,1,-1
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) THEN
            row = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 1)
            col = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 2)
            k = mesh%rowcol_to_ind_ac(row, col)
            qlij = ac_qtz(k, setup%nqz)
            qlijm1 = ac_qtz(k, setup%nqz-1)
            CALL KINEMATIC_WAVE1D_B(mesh%dx(row, col), mesh%dy(row, col)&
&                             , setup%dt, ac_akw(k), ac_akw_b(k), ac_bkw&
&                             (k), ac_bkw_b(k), qlijm1, qlijm1_b, qlij, &
&                             qlij_b, qim1j, qim1j_b, qijm1, qijm1_b, &
&                             ac_qz(k, setup%nqz), ac_qz_b(k, setup%nqz)&
&                            )
            ac_qz_b(k, setup%nqz) = 0.0_4
            CALL POPREAL4(qim1j)
            CALL UPSTREAM_DISCHARGE_B(mesh, row, col, ac_qz(:, setup%nqz&
&                               ), ac_qz_b(:, setup%nqz), qim1j, qim1j_b&
&                              )
            CALL POPREAL4(qijm1)
            ac_qz_b(k, setup%nqz-1) = ac_qz_b(k, setup%nqz-1) + qijm1_b
            ac_qtz_b(k, setup%nqz) = ac_qtz_b(k, setup%nqz) + qlij_b
            ac_qtz_b(k, setup%nqz-1) = ac_qtz_b(k, setup%nqz-1) + &
&             qlijm1_b
          END IF
        END DO
      ELSE
        CALL POPINTEGER4(ad_to)
        DO j=ad_to,1,-1
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) THEN
            row = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 1)
            col = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 2)
            k = mesh%rowcol_to_ind_ac(row, col)
            qlij = ac_qtz(k, setup%nqz)
            qlijm1 = ac_qtz(k, setup%nqz-1)
            CALL KINEMATIC_WAVE1D_B(mesh%dx(row, col), mesh%dy(row, col)&
&                             , setup%dt, ac_akw(k), ac_akw_b(k), ac_bkw&
&                             (k), ac_bkw_b(k), qlijm1, qlijm1_b, qlij, &
&                             qlij_b, qim1j, qim1j_b, qijm1, qijm1_b, &
&                             ac_qz(k, setup%nqz), ac_qz_b(k, setup%nqz)&
&                            )
            ac_qz_b(k, setup%nqz) = 0.0_4
            CALL POPREAL4(qim1j)
            CALL UPSTREAM_DISCHARGE_B(mesh, row, col, ac_qz(:, setup%nqz&
&                               ), ac_qz_b(:, setup%nqz), qim1j, qim1j_b&
&                              )
            CALL POPREAL4(qijm1)
            ac_qz_b(k, setup%nqz-1) = ac_qz_b(k, setup%nqz-1) + qijm1_b
            ac_qtz_b(k, setup%nqz) = ac_qtz_b(k, setup%nqz) + qlij_b
            ac_qtz_b(k, setup%nqz-1) = ac_qtz_b(k, setup%nqz-1) + &
&             qlijm1_b
          END IF
        END DO
      END IF
    END DO
    ac_qtz_b(:, setup%nqz) = ac_qtz_b(:, setup%nqz) + ac_qz_b(:, setup%&
&     nqz)
    ac_qz_b(:, setup%nqz) = 0.0_4
  END SUBROUTINE KW_TIME_STEP_B

  SUBROUTINE KW_TIME_STEP(setup, mesh, options, returns, t, ac_qtz, &
&   ac_akw, ac_bkw, ac_qz)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: t
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(IN) :: ac_qtz
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_akw, ac_bkw
    REAL(sp), DIMENSION(mesh%nac, setup%nqz), INTENT(INOUT) :: ac_qz
    INTEGER :: i, j, row, col, k, t_returns
    REAL(sp) :: qlijm1, qlij, qim1j, qijm1
    ac_qz(:, setup%nqz) = ac_qtz(:, setup%nqz)
! Skip the first partition because boundary cells are not routed
    DO i=2,mesh%npar
! Tapenade does not accept 'IF' condition within OMP directive. Therefore, the routing loop
! is duplicated ... Maybe there is another way to do it.
      IF (mesh%ncpar(i) .GE. options%comm%ncpu) THEN
        DO j=1,mesh%ncpar(i)
          row = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 1)
          col = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 2)
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&             local_active_cell(row, col) .EQ. 0)) THEN
            qlijm1 = ac_qtz(k, setup%nqz-1)
            qlij = ac_qtz(k, setup%nqz)
            qijm1 = ac_qz(k, setup%nqz-1)
            CALL UPSTREAM_DISCHARGE(mesh, row, col, ac_qz(:, setup%nqz)&
&                             , qim1j)
            CALL KINEMATIC_WAVE1D(mesh%dx(row, col), mesh%dy(row, col), &
&                           setup%dt, ac_akw(k), ac_bkw(k), qlijm1, qlij&
&                           , qim1j, qijm1, ac_qz(k, setup%nqz))
          END IF
        END DO
      ELSE
        DO j=1,mesh%ncpar(i)
          row = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 1)
          col = mesh%cpar_to_rowcol(mesh%cscpar(i)+j, 2)
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&             local_active_cell(row, col) .EQ. 0)) THEN
            qlijm1 = ac_qtz(k, setup%nqz-1)
            qlij = ac_qtz(k, setup%nqz)
            qijm1 = ac_qz(k, setup%nqz-1)
            CALL UPSTREAM_DISCHARGE(mesh, row, col, ac_qz(:, setup%nqz)&
&                             , qim1j)
            CALL KINEMATIC_WAVE1D(mesh%dx(row, col), mesh%dy(row, col), &
&                           setup%dt, ac_akw(k), ac_bkw(k), qlijm1, qlij&
&                           , qim1j, qijm1, ac_qz(k, setup%nqz))
          END IF
        END DO
      END IF
    END DO
  END SUBROUTINE KW_TIME_STEP

END MODULE MD_ROUTING_OPERATOR_DIFF

!%      (MD) Module Differentiated.
!%
!%      Subroutine
!%      ----------
!%
!%      - simple_snow
!%      - ssn_time_step
MODULE MD_SNOW_OPERATOR_DIFF
!% only: sp
  USE MD_CONSTANT
!% only: SetupDT
  USE MWD_SETUP
!% only: MeshDT
  USE MWD_MESH
!% only: Input_DataDT
  USE MWD_INPUT_DATA
!% only: OptionsDT
  USE MWD_OPTIONS_DIFF
!% only: ReturnsDT
  USE MWD_RETURNS_DIFF
!% get_ac_atmos_data_time_step
  USE MWD_ATMOS_MANIPULATION_DIFF
  IMPLICIT NONE

CONTAINS
!  Differentiation of simple_snow in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: mlt hs
!   with respect to varying inputs: hs kmlt
  SUBROUTINE SIMPLE_SNOW_D(snow, temp, kmlt, kmlt_d, hs, hs_d, mlt, &
&   mlt_d)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: snow, temp, kmlt
    REAL(sp), INTENT(IN) :: kmlt_d
    REAL(sp), INTENT(INOUT) :: hs
    REAL(sp), INTENT(INOUT) :: hs_d
    REAL(sp), INTENT(OUT) :: mlt
    REAL(sp), INTENT(OUT) :: mlt_d
    INTRINSIC MAX
    INTRINSIC MIN
    hs = hs + snow
    IF (0._sp .LT. kmlt*temp) THEN
      mlt_d = temp*kmlt_d
      mlt = kmlt*temp
    ELSE
      mlt = 0._sp
      mlt_d = 0.0_4
    END IF
    IF (mlt .GT. hs) THEN
      mlt_d = hs_d
      mlt = hs
    ELSE
      mlt = mlt
    END IF
    hs_d = hs_d - mlt_d
    hs = hs - mlt
  END SUBROUTINE SIMPLE_SNOW_D

!  Differentiation of simple_snow in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: mlt hs kmlt
!   with respect to varying inputs: hs kmlt
  SUBROUTINE SIMPLE_SNOW_B(snow, temp, kmlt, kmlt_b, hs, hs_b, mlt, &
&   mlt_b)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: snow, temp, kmlt
    REAL(sp) :: kmlt_b
    REAL(sp), INTENT(INOUT) :: hs
    REAL(sp), INTENT(INOUT) :: hs_b
    REAL(sp) :: mlt
    REAL(sp) :: mlt_b
    INTRINSIC MAX
    INTRINSIC MIN
    INTEGER :: branch
    hs = hs + snow
    IF (0._sp .LT. kmlt*temp) THEN
      CALL PUSHREAL4(mlt)
      mlt = kmlt*temp
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHREAL4(mlt)
      mlt = 0._sp
      CALL PUSHCONTROL1B(1)
    END IF
    IF (mlt .GT. hs) THEN
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHCONTROL1B(1)
    END IF
    mlt_b = mlt_b - hs_b
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      hs_b = hs_b + mlt_b
      mlt_b = 0.0_4
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      CALL POPREAL4(mlt)
      kmlt_b = kmlt_b + temp*mlt_b
    ELSE
      CALL POPREAL4(mlt)
    END IF
  END SUBROUTINE SIMPLE_SNOW_B

  SUBROUTINE SIMPLE_SNOW(snow, temp, kmlt, hs, mlt)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: snow, temp, kmlt
    REAL(sp), INTENT(INOUT) :: hs
    REAL(sp), INTENT(OUT) :: mlt
    INTRINSIC MAX
    INTRINSIC MIN
    hs = hs + snow
    IF (0._sp .LT. kmlt*temp) THEN
      mlt = kmlt*temp
    ELSE
      mlt = 0._sp
    END IF
    IF (mlt .GT. hs) THEN
      mlt = hs
    ELSE
      mlt = mlt
    END IF
    hs = hs - mlt
  END SUBROUTINE SIMPLE_SNOW

!  Differentiation of ssn_time_step in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: ac_hs ac_mlt
!   with respect to varying inputs: ac_kmlt ac_hs ac_mlt
  SUBROUTINE SSN_TIME_STEP_D(setup, mesh, input_data, options, returns, &
&   time_step, ac_kmlt, ac_kmlt_d, ac_hs, ac_hs_d, ac_mlt, ac_mlt_d)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_kmlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_kmlt_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hs
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hs_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_mlt_d
    INTEGER :: row, col, k, time_step_returns
    REAL(sp), DIMENSION(mesh%nac) :: ac_snow, ac_temp
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'snow', ac_snow)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'temp', ac_temp)
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_snow(k) .GE. 0._sp .AND. ac_temp(k) .GT. -99._sp) THEN
            CALL SIMPLE_SNOW_D(ac_snow(k), ac_temp(k), ac_kmlt(k), &
&                        ac_kmlt_d(k), ac_hs(k), ac_hs_d(k), ac_mlt(k), &
&                        ac_mlt_d(k))
          ELSE
            ac_mlt_d(k) = 0.0_4
            ac_mlt(k) = 0._sp
          END IF
        END IF
      END DO
    END DO
  END SUBROUTINE SSN_TIME_STEP_D

!  Differentiation of ssn_time_step in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: ac_kmlt ac_hs ac_mlt
!   with respect to varying inputs: ac_kmlt ac_hs ac_mlt
  SUBROUTINE SSN_TIME_STEP_B(setup, mesh, input_data, options, returns, &
&   time_step, ac_kmlt, ac_kmlt_b, ac_hs, ac_hs_b, ac_mlt, ac_mlt_b)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_kmlt
    REAL(sp), DIMENSION(mesh%nac) :: ac_kmlt_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hs
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hs_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_mlt_b
    INTEGER :: row, col, k, time_step_returns
    REAL(sp), DIMENSION(mesh%nac) :: ac_snow, ac_temp
    INTEGER :: branch
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'snow', ac_snow)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'temp', ac_temp)
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL2B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_snow(k) .GE. 0._sp .AND. ac_temp(k) .GT. -99._sp) THEN
            CALL PUSHREAL4(ac_mlt(k))
            CALL PUSHREAL4(ac_hs(k))
            CALL SIMPLE_SNOW(ac_snow(k), ac_temp(k), ac_kmlt(k), ac_hs(k&
&                      ), ac_mlt(k))
            CALL PUSHCONTROL2B(2)
          ELSE
            CALL PUSHCONTROL2B(1)
          END IF
        END IF
      END DO
    END DO
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL2B(branch)
        IF (branch .NE. 0) THEN
          IF (branch .EQ. 1) THEN
            k = mesh%rowcol_to_ind_ac(row, col)
            ac_mlt_b(k) = 0.0_4
          ELSE
            k = mesh%rowcol_to_ind_ac(row, col)
            CALL POPREAL4(ac_hs(k))
            CALL POPREAL4(ac_mlt(k))
            CALL SIMPLE_SNOW_B(ac_snow(k), ac_temp(k), ac_kmlt(k), &
&                        ac_kmlt_b(k), ac_hs(k), ac_hs_b(k), ac_mlt(k), &
&                        ac_mlt_b(k))
            ac_mlt_b(k) = 0.0_4
          END IF
        END IF
      END DO
    END DO
  END SUBROUTINE SSN_TIME_STEP_B

  SUBROUTINE SSN_TIME_STEP(setup, mesh, input_data, options, returns, &
&   time_step, ac_kmlt, ac_hs, ac_mlt)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_kmlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hs
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_mlt
    INTEGER :: row, col, k, time_step_returns
    REAL(sp), DIMENSION(mesh%nac) :: ac_snow, ac_temp
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'snow', ac_snow)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'temp', ac_temp)
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_snow(k) .GE. 0._sp .AND. ac_temp(k) .GT. -99._sp) THEN
            CALL SIMPLE_SNOW(ac_snow(k), ac_temp(k), ac_kmlt(k), ac_hs(k&
&                      ), ac_mlt(k))
          ELSE
            ac_mlt(k) = 0._sp
          END IF
        END IF
      END DO
    END DO
  END SUBROUTINE SSN_TIME_STEP

END MODULE MD_SNOW_OPERATOR_DIFF

MODULE MD_VIC3L_OPERATOR_DIFF
!% only: sp
  USE MD_CONSTANT
!% only: SetupDT
  USE MWD_SETUP
!% only: MeshDT
  USE MWD_MESH
!% only: Input_DataDT
  USE MWD_INPUT_DATA
!% only: OptionsDT
  USE MWD_OPTIONS_DIFF
!% only: ReturnDT
  USE MWD_RETURNS_DIFF
!% get_ac_atmos_data_time_step
  USE MWD_ATMOS_MANIPULATION_DIFF
  IMPLICIT NONE

CONTAINS
!  Differentiation of vic3l_canopy_interception in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: hcl en pn
!   with respect to varying inputs: hcl prcp
  SUBROUTINE VIC3L_CANOPY_INTERCEPTION_D(prcp, prcp_d, pet, ccl, hcl, &
&   hcl_d, pn, pn_d, en, en_d)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: prcp, pet, ccl
    REAL(sp), INTENT(IN) :: prcp_d
    REAL(sp), INTENT(INOUT) :: hcl
    REAL(sp), INTENT(INOUT) :: hcl_d
    REAL(sp), INTENT(OUT) :: pn, en
    REAL(sp), INTENT(OUT) :: pn_d, en_d
    REAL(sp) :: ec
    REAL(sp) :: ec_d
    INTRINSIC MIN
    INTRINSIC MAX
    REAL(sp) :: pwr1
    REAL(sp) :: pwr1_d
    pwr1 = hcl**(2._sp/3._sp)
    IF (pet*pwr1 .GT. prcp + hcl*ccl) THEN
      ec_d = prcp_d + ccl*hcl_d
      ec = prcp + hcl*ccl
    ELSE
      IF (hcl .LE. 0.0 .AND. (2._sp/3._sp .EQ. 0.0 .OR. 2._sp/3._sp .NE.&
&         INT(2._sp/3._sp))) THEN
        pwr1_d = 0.0_4
      ELSE
        pwr1_d = 2._sp*hcl**(2._sp/3._sp-1)*hcl_d/3._sp
      END IF
      pwr1 = hcl**(2._sp/3._sp)
      ec_d = pet*pwr1_d
      ec = pet*pwr1
    END IF
    IF (0._sp .LT. prcp - ccl*(1._sp-hcl) - ec) THEN
      pn_d = prcp_d + ccl*hcl_d - ec_d
      pn = prcp - ccl*(1._sp-hcl) - ec
    ELSE
      pn = 0._sp
      pn_d = 0.0_4
    END IF
    en_d = -ec_d
    en = pet - ec
    hcl_d = hcl_d + (prcp_d-ec_d-pn_d)/ccl
    hcl = hcl + (prcp-ec-pn)/ccl
    IF (0.999999_sp .GT. hcl) THEN
      hcl = hcl
    ELSE
      hcl = 0.999999_sp
      hcl_d = 0.0_4
    END IF
    IF (1e-6_sp .LT. hcl) THEN
      hcl = hcl
    ELSE
      hcl = 1e-6_sp
      hcl_d = 0.0_4
    END IF
  END SUBROUTINE VIC3L_CANOPY_INTERCEPTION_D

!  Differentiation of vic3l_canopy_interception in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: hcl prcp en pn
!   with respect to varying inputs: hcl prcp
  SUBROUTINE VIC3L_CANOPY_INTERCEPTION_B(prcp, prcp_b, pet, ccl, hcl, &
&   hcl_b, pn, pn_b, en, en_b)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: prcp, pet, ccl
    REAL(sp) :: prcp_b
    REAL(sp), INTENT(INOUT) :: hcl
    REAL(sp), INTENT(INOUT) :: hcl_b
    REAL(sp) :: pn, en
    REAL(sp) :: pn_b, en_b
    REAL(sp) :: ec
    REAL(sp) :: ec_b
    INTRINSIC MIN
    INTRINSIC MAX
    REAL(sp) :: pwr1
    REAL(sp) :: pwr1_b
    REAL(sp) :: temp_b
    INTEGER :: branch
    pwr1 = hcl**(2._sp/3._sp)
    IF (pet*pwr1 .GT. prcp + hcl*ccl) THEN
      ec = prcp + hcl*ccl
      CALL PUSHCONTROL1B(0)
    ELSE
      pwr1 = hcl**(2._sp/3._sp)
      ec = pet*pwr1
      CALL PUSHCONTROL1B(1)
    END IF
    IF (0._sp .LT. prcp - ccl*(1._sp-hcl) - ec) THEN
      CALL PUSHREAL4(pn)
      pn = prcp - ccl*(1._sp-hcl) - ec
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHREAL4(pn)
      pn = 0._sp
      CALL PUSHCONTROL1B(1)
    END IF
    CALL PUSHREAL4(hcl)
    hcl = hcl + (prcp-ec-pn)/ccl
    IF (0.999999_sp .GT. hcl) THEN
      CALL PUSHCONTROL1B(0)
      hcl = hcl
    ELSE
      hcl = 0.999999_sp
      CALL PUSHCONTROL1B(1)
    END IF
    IF (1e-6_sp .GE. hcl) hcl_b = 0.0_4
    CALL POPCONTROL1B(branch)
    IF (branch .NE. 0) hcl_b = 0.0_4
    CALL POPREAL4(hcl)
    temp_b = hcl_b/ccl
    prcp_b = prcp_b + temp_b
    ec_b = -temp_b - en_b
    pn_b = pn_b - temp_b
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      CALL POPREAL4(pn)
      prcp_b = prcp_b + pn_b
      hcl_b = hcl_b + ccl*pn_b
      ec_b = ec_b - pn_b
    ELSE
      CALL POPREAL4(pn)
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      prcp_b = prcp_b + ec_b
      hcl_b = hcl_b + ccl*ec_b
    ELSE
      pwr1_b = pet*ec_b
      IF (.NOT.(hcl .LE. 0.0 .AND. (2._sp/3._sp .EQ. 0.0 .OR. 2._sp/&
&         3._sp .NE. INT(2._sp/3._sp)))) hcl_b = hcl_b + 2._sp*hcl**(&
&         2._sp/3._sp-1)*pwr1_b/3._sp
    END IF
  END SUBROUTINE VIC3L_CANOPY_INTERCEPTION_B

  SUBROUTINE VIC3L_CANOPY_INTERCEPTION(prcp, pet, ccl, hcl, pn, en)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: prcp, pet, ccl
    REAL(sp), INTENT(INOUT) :: hcl
    REAL(sp), INTENT(OUT) :: pn, en
    REAL(sp) :: ec
    INTRINSIC MIN
    INTRINSIC MAX
    REAL(sp) :: pwr1
    pwr1 = hcl**(2._sp/3._sp)
    IF (pet*pwr1 .GT. prcp + hcl*ccl) THEN
      ec = prcp + hcl*ccl
    ELSE
      pwr1 = hcl**(2._sp/3._sp)
      ec = pet*pwr1
    END IF
    IF (0._sp .LT. prcp - ccl*(1._sp-hcl) - ec) THEN
      pn = prcp - ccl*(1._sp-hcl) - ec
    ELSE
      pn = 0._sp
    END IF
    en = pet - ec
    hcl = hcl + (prcp-ec-pn)/ccl
    IF (0.999999_sp .GT. hcl) THEN
      hcl = hcl
    ELSE
      hcl = 0.999999_sp
    END IF
    IF (1e-6_sp .LT. hcl) THEN
      hcl = hcl
    ELSE
      hcl = 1e-6_sp
    END IF
  END SUBROUTINE VIC3L_CANOPY_INTERCEPTION

!  Differentiation of vic3l_upper_soil_layer_evaporation in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: husl
!   with respect to varying inputs: cusl en husl b
! https://github.com/UW-Hydro/VIC/blob/master/vic/vic_run/src/arno_evap.c
  SUBROUTINE VIC3L_UPPER_SOIL_LAYER_EVAPORATION_D(en, en_d, b, b_d, cusl&
&   , cusl_d, husl, husl_d)
    IMPLICIT NONE
    INTEGER, PARAMETER :: npe=5
    REAL(sp), INTENT(IN) :: en, b, cusl
    REAL(sp), INTENT(IN) :: en_d, b_d, cusl_d
    REAL(sp), INTENT(INOUT) :: husl
    REAL(sp), INTENT(INOUT) :: husl_d
    INTEGER :: i
    REAL(sp) :: iflm, ifl0, ratio, as, pe_value, beta, es
    REAL(sp) :: iflm_d, ifl0_d, ratio_d, as_d, pe_value_d, beta_d, es_d
    INTRINSIC MIN
    REAL(sp) :: pwx1
    REAL(sp) :: pwx1_d
    REAL(sp) :: pwy1
    REAL(sp) :: pwy1_d
    REAL(sp) :: pwr1
    REAL(sp) :: pwr1_d
    REAL(sp) :: temp
    iflm_d = cusl*b_d + (b+1._sp)*cusl_d
    iflm = (1._sp+b)*cusl
    pwx1_d = -husl_d
    pwx1 = 1._sp - husl
    pwy1_d = -(b_d/(b+1._sp)**2)
    pwy1 = 1._sp/(1._sp+b)
    temp = pwx1**pwy1
    IF (pwx1 .LE. 0.0 .AND. (pwy1 .EQ. 0.0 .OR. pwy1 .NE. INT(pwy1))) &
&   THEN
      pwr1_d = 0.0_4
    ELSE IF (pwx1 .LE. 0.0) THEN
      pwr1_d = pwy1*pwx1**(pwy1-1)*pwx1_d
    ELSE
      pwr1_d = pwy1*pwx1**(pwy1-1)*pwx1_d + temp*LOG(pwx1)*pwy1_d
    END IF
    pwr1 = temp
    ifl0_d = (1._sp-pwr1)*iflm_d - iflm*pwr1_d
    ifl0 = iflm*(1._sp-pwr1)
    IF (ifl0 .GE. iflm) THEN
      es_d = en_d
      es = en
    ELSE
      ratio_d = -((ifl0_d-ifl0*iflm_d/iflm)/iflm)
      ratio = 1._sp - ifl0/iflm
      temp = ratio**b
      IF (ratio .LE. 0.0 .AND. (b .EQ. 0.0 .OR. b .NE. INT(b))) THEN
        pwr1_d = 0.0_4
      ELSE IF (ratio .LE. 0.0) THEN
        pwr1_d = b*ratio**(b-1)*ratio_d
      ELSE
        pwr1_d = b*ratio**(b-1)*ratio_d + temp*LOG(ratio)*b_d
      END IF
      pwr1 = temp
      as_d = -pwr1_d
      as = 1._sp - pwr1
      pe_value = 1._sp
      pe_value_d = 0.0_4
      DO i=1,npe
        IF (ratio .LE. 0.0 .AND. (i .EQ. 0.0 .OR. i .NE. INT(i))) THEN
          pwr1_d = 0.0_4
        ELSE
          pwr1_d = i*ratio**(i-1)*ratio_d
        END IF
        pwr1 = ratio**i
        temp = b*pwr1/(i+b)
        pe_value_d = pe_value_d + ((pwr1-temp)*b_d+b*pwr1_d)/(i+b)
        pe_value = pe_value + temp
      END DO
      beta_d = as_d + (1._sp-ratio)*((1._sp-as)*pe_value_d-pe_value*as_d&
&       ) - (1._sp-as)*pe_value*ratio_d
      beta = as + (1._sp-as)*(1._sp-ratio)*pe_value
      es_d = beta*en_d + en*beta_d
      es = en*beta
    END IF
    IF (es .GT. husl*cusl) THEN
      es_d = cusl*husl_d + husl*cusl_d
      es = husl*cusl
    ELSE
      es = es
    END IF
    husl_d = husl_d - (es_d-es*cusl_d/cusl)/cusl
    husl = husl - es/cusl
  END SUBROUTINE VIC3L_UPPER_SOIL_LAYER_EVAPORATION_D

!  Differentiation of vic3l_upper_soil_layer_evaporation in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: cusl husl b
!   with respect to varying inputs: cusl en husl b
! https://github.com/UW-Hydro/VIC/blob/master/vic/vic_run/src/arno_evap.c
  SUBROUTINE VIC3L_UPPER_SOIL_LAYER_EVAPORATION_B(en, en_b, b, b_b, cusl&
&   , cusl_b, husl, husl_b)
    IMPLICIT NONE
    INTEGER, PARAMETER :: npe=5
    REAL(sp), INTENT(IN) :: en, b, cusl
    REAL(sp) :: en_b, b_b, cusl_b
    REAL(sp), INTENT(INOUT) :: husl
    REAL(sp), INTENT(INOUT) :: husl_b
    INTEGER :: i
    REAL(sp) :: iflm, ifl0, ratio, as, pe_value, beta, es
    REAL(sp) :: iflm_b, ifl0_b, ratio_b, as_b, pe_value_b, beta_b, es_b
    INTRINSIC MIN
    REAL(sp) :: pwx1
    REAL(sp) :: pwx1_b
    REAL(sp) :: pwy1
    REAL(sp) :: pwy1_b
    REAL(sp) :: pwr1
    REAL(sp) :: pwr1_b
    REAL(sp) :: temp_b
    INTEGER :: branch
    iflm = (1._sp+b)*cusl
    pwx1 = 1._sp - husl
    pwy1 = 1._sp/(1._sp+b)
    pwr1 = pwx1**pwy1
    ifl0 = iflm*(1._sp-pwr1)
    IF (ifl0 .GE. iflm) THEN
      es = en
      CALL PUSHCONTROL1B(1)
    ELSE
      ratio = 1._sp - ifl0/iflm
      pwr1 = ratio**b
      as = 1._sp - pwr1
      pe_value = 1._sp
      DO i=1,npe
        pwr1 = ratio**i
        pe_value = pe_value + b*pwr1/(b+i)
      END DO
      beta = as + (1._sp-as)*(1._sp-ratio)*pe_value
      es = en*beta
      CALL PUSHCONTROL1B(0)
    END IF
    IF (es .GT. husl*cusl) THEN
      es = husl*cusl
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHCONTROL1B(1)
      es = es
    END IF
    es_b = -(husl_b/cusl)
    cusl_b = cusl_b + es*husl_b/cusl**2
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      husl_b = husl_b + cusl*es_b
      cusl_b = cusl_b + husl*es_b
      es_b = 0.0_4
    END IF
    iflm = (1._sp+b)*cusl
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      en_b = beta*es_b
      beta_b = en*es_b
      as_b = (1.0-pe_value*(1._sp-ratio))*beta_b
      pe_value_b = (1._sp-as)*(1._sp-ratio)*beta_b
      ratio_b = -((1._sp-as)*pe_value*beta_b)
      DO i=npe,1,-1
        pwr1 = ratio**i
        temp_b = pe_value_b/(i+b)
        b_b = b_b + (pwr1-b*pwr1/(i+b))*temp_b
        pwr1_b = b*temp_b
        IF (.NOT.(ratio .LE. 0.0 .AND. (i .EQ. 0.0 .OR. i .NE. INT(i)))&
&       ) ratio_b = ratio_b + i*ratio**(i-1)*pwr1_b
      END DO
      pwr1_b = -as_b
      IF (.NOT.(ratio .LE. 0.0 .AND. (b .EQ. 0.0 .OR. b .NE. INT(b)))) &
&       ratio_b = ratio_b + b*ratio**(b-1)*pwr1_b
      IF (.NOT.ratio .LE. 0.0) b_b = b_b + ratio**b*LOG(ratio)*pwr1_b
      pwy1 = 1._sp/(1._sp+b)
      pwr1 = pwx1**pwy1
      ifl0_b = -(ratio_b/iflm)
      iflm_b = ifl0*ratio_b/iflm**2
    ELSE
      en_b = es_b
      iflm_b = 0.0_4
      ifl0_b = 0.0_4
    END IF
    iflm_b = iflm_b + (1._sp-pwr1)*ifl0_b
    pwr1_b = -(iflm*ifl0_b)
    IF (pwx1 .LE. 0.0 .AND. (pwy1 .EQ. 0.0 .OR. pwy1 .NE. INT(pwy1))) &
&   THEN
      pwx1_b = 0.0_4
    ELSE
      pwx1_b = pwy1*pwx1**(pwy1-1)*pwr1_b
    END IF
    IF (pwx1 .LE. 0.0) THEN
      pwy1_b = 0.0_4
    ELSE
      pwy1_b = pwx1**pwy1*LOG(pwx1)*pwr1_b
    END IF
    b_b = b_b + cusl*iflm_b - pwy1_b/(b+1._sp)**2
    husl_b = husl_b - pwx1_b
    cusl_b = cusl_b + (b+1._sp)*iflm_b
  END SUBROUTINE VIC3L_UPPER_SOIL_LAYER_EVAPORATION_B

! https://github.com/UW-Hydro/VIC/blob/master/vic/vic_run/src/arno_evap.c
  SUBROUTINE VIC3L_UPPER_SOIL_LAYER_EVAPORATION(en, b, cusl, husl)
    IMPLICIT NONE
    INTEGER, PARAMETER :: npe=5
    REAL(sp), INTENT(IN) :: en, b, cusl
    REAL(sp), INTENT(INOUT) :: husl
    INTEGER :: i
    REAL(sp) :: iflm, ifl0, ratio, as, pe_value, beta, es
    INTRINSIC MIN
    REAL(sp) :: pwx1
    REAL(sp) :: pwy1
    REAL(sp) :: pwr1
    iflm = (1._sp+b)*cusl
    pwx1 = 1._sp - husl
    pwy1 = 1._sp/(1._sp+b)
    pwr1 = pwx1**pwy1
    ifl0 = iflm*(1._sp-pwr1)
    IF (ifl0 .GE. iflm) THEN
      es = en
    ELSE
      ratio = 1._sp - ifl0/iflm
      pwr1 = ratio**b
      as = 1._sp - pwr1
      pe_value = 1._sp
      DO i=1,npe
        pwr1 = ratio**i
        pe_value = pe_value + b*pwr1/(b+i)
      END DO
      beta = as + (1._sp-as)*(1._sp-ratio)*pe_value
      es = en*beta
    END IF
    IF (es .GT. husl*cusl) THEN
      es = husl*cusl
    ELSE
      es = es
    END IF
    husl = husl - es/cusl
  END SUBROUTINE VIC3L_UPPER_SOIL_LAYER_EVAPORATION

!  Differentiation of vic3l_infiltration in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: qr husl hmsl
!   with respect to varying inputs: cusl cmsl husl pn hmsl b
  SUBROUTINE VIC3L_INFILTRATION_D(pn, pn_d, b, b_d, cusl, cusl_d, cmsl, &
&   cmsl_d, husl, husl_d, hmsl, hmsl_d, qr, qr_d)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: pn, b, cusl, cmsl
    REAL(sp), INTENT(IN) :: pn_d, b_d, cusl_d, cmsl_d
    REAL(sp), INTENT(INOUT) :: husl, hmsl
    REAL(sp), INTENT(INOUT) :: husl_d, hmsl_d
    REAL(sp), INTENT(OUT) :: qr
    REAL(sp), INTENT(OUT) :: qr_d
    REAL(sp) :: cumsl, wumsl, humsl, iflm, ifl0, ifl, ifl_usl, ifl_msl
    REAL(sp) :: cumsl_d, wumsl_d, humsl_d, iflm_d, ifl0_d, ifl_d, &
&   ifl_usl_d, ifl_msl_d
    INTRINSIC MIN
    INTRINSIC MAX
    REAL(sp) :: pwx1
    REAL(sp) :: pwx1_d
    REAL(sp) :: pwy1
    REAL(sp) :: pwy1_d
    REAL(sp) :: pwr1
    REAL(sp) :: pwr1_d
    REAL(sp) :: temp
    cumsl_d = cusl_d + cmsl_d
    cumsl = cusl + cmsl
    wumsl_d = cusl*husl_d + husl*cusl_d + cmsl*hmsl_d + hmsl*cmsl_d
    wumsl = husl*cusl + hmsl*cmsl
    humsl_d = (wumsl_d-wumsl*cumsl_d/cumsl)/cumsl
    humsl = wumsl/cumsl
    iflm_d = cumsl*b_d + (b+1._sp)*cumsl_d
    iflm = (1._sp+b)*cumsl
    pwx1_d = -humsl_d
    pwx1 = 1._sp - humsl
    pwy1_d = -(b_d/(b+1._sp)**2)
    pwy1 = 1._sp/(1._sp+b)
    temp = pwx1**pwy1
    IF (pwx1 .LE. 0.0 .AND. (pwy1 .EQ. 0.0 .OR. pwy1 .NE. INT(pwy1))) &
&   THEN
      pwr1_d = 0.0_4
    ELSE IF (pwx1 .LE. 0.0) THEN
      pwr1_d = pwy1*pwx1**(pwy1-1)*pwx1_d
    ELSE
      pwr1_d = pwy1*pwx1**(pwy1-1)*pwx1_d + temp*LOG(pwx1)*pwy1_d
    END IF
    pwr1 = temp
    ifl0_d = (1._sp-pwr1)*iflm_d - iflm*pwr1_d
    ifl0 = iflm*(1._sp-pwr1)
    IF (ifl0 + pn .GT. iflm) THEN
      ifl_d = cumsl_d - wumsl_d
      ifl = cumsl - wumsl
    ELSE
      temp = (ifl0+pn)/iflm
      pwx1_d = -((ifl0_d+pn_d-temp*iflm_d)/iflm)
      pwx1 = 1._sp - temp
      pwy1_d = b_d
      pwy1 = b + 1._sp
      temp = pwx1**pwy1
      IF (pwx1 .LE. 0.0 .AND. (pwy1 .EQ. 0.0 .OR. pwy1 .NE. INT(pwy1))) &
&     THEN
        pwr1_d = 0.0_4
      ELSE IF (pwx1 .LE. 0.0) THEN
        pwr1_d = pwy1*pwx1**(pwy1-1)*pwx1_d
      ELSE
        pwr1_d = pwy1*pwx1**(pwy1-1)*pwx1_d + temp*LOG(pwx1)*pwy1_d
      END IF
      pwr1 = temp
      ifl_d = (1.0-pwr1)*cumsl_d - wumsl_d - cumsl*pwr1_d
      ifl = cumsl - wumsl - cumsl*pwr1
    END IF
    IF (pn .GT. ifl) THEN
      ifl = ifl
    ELSE
      ifl_d = pn_d
      ifl = pn
    END IF
    IF ((1._sp-husl)*cusl .GT. ifl) THEN
      ifl_usl_d = ifl_d
      ifl_usl = ifl
    ELSE
      ifl_usl_d = (1._sp-husl)*cusl_d - cusl*husl_d
      ifl_usl = (1._sp-husl)*cusl
    END IF
    IF ((1._sp-hmsl)*cmsl .GT. ifl - ifl_usl) THEN
      ifl_msl_d = ifl_d - ifl_usl_d
      ifl_msl = ifl - ifl_usl
    ELSE
      ifl_msl_d = (1._sp-hmsl)*cmsl_d - cmsl*hmsl_d
      ifl_msl = (1._sp-hmsl)*cmsl
    END IF
    husl_d = husl_d + (ifl_usl_d-ifl_usl*cusl_d/cusl)/cusl
    husl = husl + ifl_usl/cusl
    hmsl_d = hmsl_d + (ifl_msl_d-ifl_msl*cmsl_d/cmsl)/cmsl
    hmsl = hmsl + ifl_msl/cmsl
    IF (0.999999_sp .GT. husl) THEN
      husl = husl
    ELSE
      husl = 0.999999_sp
      husl_d = 0.0_4
    END IF
    IF (1e-6_sp .LT. husl) THEN
      husl = husl
    ELSE
      husl = 1e-6_sp
      husl_d = 0.0_4
    END IF
    IF (0.999999_sp .GT. hmsl) THEN
      hmsl = hmsl
    ELSE
      hmsl = 0.999999_sp
      hmsl_d = 0.0_4
    END IF
    IF (1e-6_sp .LT. hmsl) THEN
      hmsl = hmsl
    ELSE
      hmsl = 1e-6_sp
      hmsl_d = 0.0_4
    END IF
    qr_d = pn_d - ifl_usl_d - ifl_msl_d
    qr = pn - (ifl_usl+ifl_msl)
  END SUBROUTINE VIC3L_INFILTRATION_D

!  Differentiation of vic3l_infiltration in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: qr cusl cmsl husl hmsl b
!   with respect to varying inputs: cusl cmsl husl pn hmsl b
  SUBROUTINE VIC3L_INFILTRATION_B(pn, pn_b, b, b_b, cusl, cusl_b, cmsl, &
&   cmsl_b, husl, husl_b, hmsl, hmsl_b, qr, qr_b)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: pn, b, cusl, cmsl
    REAL(sp) :: pn_b, b_b, cusl_b, cmsl_b
    REAL(sp), INTENT(INOUT) :: husl, hmsl
    REAL(sp), INTENT(INOUT) :: husl_b, hmsl_b
    REAL(sp) :: qr
    REAL(sp) :: qr_b
    REAL(sp) :: cumsl, wumsl, humsl, iflm, ifl0, ifl, ifl_usl, ifl_msl
    REAL(sp) :: cumsl_b, wumsl_b, humsl_b, iflm_b, ifl0_b, ifl_b, &
&   ifl_usl_b, ifl_msl_b
    INTRINSIC MIN
    INTRINSIC MAX
    REAL(sp) :: pwx1
    REAL(sp) :: pwx1_b
    REAL(sp) :: pwy1
    REAL(sp) :: pwy1_b
    REAL(sp) :: pwr1
    REAL(sp) :: pwr1_b
    REAL(sp) :: temp_b
    INTEGER :: branch
    cumsl = cusl + cmsl
    wumsl = husl*cusl + hmsl*cmsl
    humsl = wumsl/cumsl
    iflm = (1._sp+b)*cumsl
    pwx1 = 1._sp - humsl
    pwy1 = 1._sp/(1._sp+b)
    pwr1 = pwx1**pwy1
    ifl0 = iflm*(1._sp-pwr1)
    IF (ifl0 + pn .GT. iflm) THEN
      ifl = cumsl - wumsl
      CALL PUSHCONTROL1B(1)
    ELSE
      pwx1 = 1._sp - (ifl0+pn)/iflm
      pwy1 = b + 1._sp
      CALL PUSHREAL4(pwr1)
      pwr1 = pwx1**pwy1
      ifl = cumsl - wumsl - cumsl*pwr1
      CALL PUSHCONTROL1B(0)
    END IF
    IF (pn .GT. ifl) THEN
      CALL PUSHCONTROL1B(0)
      ifl = ifl
    ELSE
      ifl = pn
      CALL PUSHCONTROL1B(1)
    END IF
    IF ((1._sp-husl)*cusl .GT. ifl) THEN
      ifl_usl = ifl
      CALL PUSHCONTROL1B(0)
    ELSE
      ifl_usl = (1._sp-husl)*cusl
      CALL PUSHCONTROL1B(1)
    END IF
    IF ((1._sp-hmsl)*cmsl .GT. ifl - ifl_usl) THEN
      ifl_msl = ifl - ifl_usl
      CALL PUSHCONTROL1B(0)
    ELSE
      ifl_msl = (1._sp-hmsl)*cmsl
      CALL PUSHCONTROL1B(1)
    END IF
    CALL PUSHREAL4(husl)
    husl = husl + ifl_usl/cusl
    CALL PUSHREAL4(hmsl)
    hmsl = hmsl + ifl_msl/cmsl
    IF (0.999999_sp .GT. husl) THEN
      CALL PUSHCONTROL1B(0)
      husl = husl
    ELSE
      husl = 0.999999_sp
      CALL PUSHCONTROL1B(1)
    END IF
    IF (1e-6_sp .LT. husl) THEN
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHCONTROL1B(1)
    END IF
    IF (0.999999_sp .GT. hmsl) THEN
      CALL PUSHCONTROL1B(0)
      hmsl = hmsl
    ELSE
      hmsl = 0.999999_sp
      CALL PUSHCONTROL1B(1)
    END IF
    IF (1e-6_sp .LT. hmsl) THEN
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHCONTROL1B(1)
    END IF
    pn_b = qr_b
    ifl_usl_b = -qr_b
    ifl_msl_b = -qr_b
    CALL POPCONTROL1B(branch)
    IF (branch .NE. 0) hmsl_b = 0.0_4
    CALL POPCONTROL1B(branch)
    IF (branch .NE. 0) hmsl_b = 0.0_4
    CALL POPCONTROL1B(branch)
    IF (branch .NE. 0) husl_b = 0.0_4
    CALL POPCONTROL1B(branch)
    IF (branch .NE. 0) husl_b = 0.0_4
    CALL POPREAL4(hmsl)
    ifl_msl_b = ifl_msl_b + hmsl_b/cmsl
    cmsl_b = cmsl_b - ifl_msl*hmsl_b/cmsl**2
    CALL POPREAL4(husl)
    ifl_usl_b = ifl_usl_b + husl_b/cusl
    cusl_b = cusl_b - ifl_usl*husl_b/cusl**2
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      ifl_b = ifl_msl_b
      ifl_usl_b = ifl_usl_b - ifl_msl_b
    ELSE
      hmsl_b = hmsl_b - cmsl*ifl_msl_b
      cmsl_b = cmsl_b + (1._sp-hmsl)*ifl_msl_b
      ifl_b = 0.0_4
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      ifl_b = ifl_b + ifl_usl_b
    ELSE
      husl_b = husl_b - cusl*ifl_usl_b
      cusl_b = cusl_b + (1._sp-husl)*ifl_usl_b
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .NE. 0) THEN
      pn_b = pn_b + ifl_b
      ifl_b = 0.0_4
    END IF
    cumsl = cusl + cmsl
    iflm = (1._sp+b)*cumsl
    wumsl = husl*cusl + hmsl*cmsl
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      cumsl_b = (1.0-pwr1)*ifl_b
      wumsl_b = -ifl_b
      pwr1_b = -(cumsl*ifl_b)
      CALL POPREAL4(pwr1)
      IF (pwx1 .LE. 0.0 .AND. (pwy1 .EQ. 0.0 .OR. pwy1 .NE. INT(pwy1))) &
&     THEN
        pwx1_b = 0.0_4
      ELSE
        pwx1_b = pwy1*pwx1**(pwy1-1)*pwr1_b
      END IF
      IF (pwx1 .LE. 0.0) THEN
        pwy1_b = 0.0_4
      ELSE
        pwy1_b = pwx1**pwy1*LOG(pwx1)*pwr1_b
      END IF
      b_b = b_b + pwy1_b
      temp_b = -(pwx1_b/iflm)
      ifl0_b = temp_b
      pn_b = pn_b + temp_b
      iflm_b = -((ifl0+pn)*temp_b/iflm)
      pwy1 = 1._sp/(1._sp+b)
      humsl = wumsl/cumsl
      pwx1 = 1._sp - humsl
    ELSE
      cumsl_b = ifl_b
      wumsl_b = -ifl_b
      iflm_b = 0.0_4
      ifl0_b = 0.0_4
    END IF
    iflm_b = iflm_b + (1._sp-pwr1)*ifl0_b
    pwr1_b = -(iflm*ifl0_b)
    IF (pwx1 .LE. 0.0 .AND. (pwy1 .EQ. 0.0 .OR. pwy1 .NE. INT(pwy1))) &
&   THEN
      pwx1_b = 0.0_4
    ELSE
      pwx1_b = pwy1*pwx1**(pwy1-1)*pwr1_b
    END IF
    IF (pwx1 .LE. 0.0) THEN
      pwy1_b = 0.0_4
    ELSE
      pwy1_b = pwx1**pwy1*LOG(pwx1)*pwr1_b
    END IF
    b_b = b_b + cumsl*iflm_b - pwy1_b/(b+1._sp)**2
    humsl_b = -pwx1_b
    cumsl_b = cumsl_b + (b+1._sp)*iflm_b - wumsl*humsl_b/cumsl**2
    wumsl_b = wumsl_b + humsl_b/cumsl
    husl_b = husl_b + cusl*wumsl_b
    cusl_b = cusl_b + husl*wumsl_b + cumsl_b
    hmsl_b = hmsl_b + cmsl*wumsl_b
    cmsl_b = cmsl_b + hmsl*wumsl_b + cumsl_b
  END SUBROUTINE VIC3L_INFILTRATION_B

  SUBROUTINE VIC3L_INFILTRATION(pn, b, cusl, cmsl, husl, hmsl, qr)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: pn, b, cusl, cmsl
    REAL(sp), INTENT(INOUT) :: husl, hmsl
    REAL(sp), INTENT(OUT) :: qr
    REAL(sp) :: cumsl, wumsl, humsl, iflm, ifl0, ifl, ifl_usl, ifl_msl
    INTRINSIC MIN
    INTRINSIC MAX
    REAL(sp) :: pwx1
    REAL(sp) :: pwy1
    REAL(sp) :: pwr1
    cumsl = cusl + cmsl
    wumsl = husl*cusl + hmsl*cmsl
    humsl = wumsl/cumsl
    iflm = (1._sp+b)*cumsl
    pwx1 = 1._sp - humsl
    pwy1 = 1._sp/(1._sp+b)
    pwr1 = pwx1**pwy1
    ifl0 = iflm*(1._sp-pwr1)
    IF (ifl0 + pn .GT. iflm) THEN
      ifl = cumsl - wumsl
    ELSE
      pwx1 = 1._sp - (ifl0+pn)/iflm
      pwy1 = b + 1._sp
      pwr1 = pwx1**pwy1
      ifl = cumsl - wumsl - cumsl*pwr1
    END IF
    IF (pn .GT. ifl) THEN
      ifl = ifl
    ELSE
      ifl = pn
    END IF
    IF ((1._sp-husl)*cusl .GT. ifl) THEN
      ifl_usl = ifl
    ELSE
      ifl_usl = (1._sp-husl)*cusl
    END IF
    IF ((1._sp-hmsl)*cmsl .GT. ifl - ifl_usl) THEN
      ifl_msl = ifl - ifl_usl
    ELSE
      ifl_msl = (1._sp-hmsl)*cmsl
    END IF
    husl = husl + ifl_usl/cusl
    hmsl = hmsl + ifl_msl/cmsl
    IF (0.999999_sp .GT. husl) THEN
      husl = husl
    ELSE
      husl = 0.999999_sp
    END IF
    IF (1e-6_sp .LT. husl) THEN
      husl = husl
    ELSE
      husl = 1e-6_sp
    END IF
    IF (0.999999_sp .GT. hmsl) THEN
      hmsl = hmsl
    ELSE
      hmsl = 0.999999_sp
    END IF
    IF (1e-6_sp .LT. hmsl) THEN
      hmsl = hmsl
    ELSE
      hmsl = 1e-6_sp
    END IF
    qr = pn - (ifl_usl+ifl_msl)
  END SUBROUTINE VIC3L_INFILTRATION

!  Differentiation of vic3l_drainage_2l in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: hl hu
!   with respect to varying inputs: hl ks hu pbc cl cu
  SUBROUTINE VIC3L_DRAINAGE_2L_D(cu, cu_d, cl, cl_d, ks, ks_d, pbc, &
&   pbc_d, hu, hu_d, hl, hl_d)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: cu, cl, ks, pbc
    REAL(sp), INTENT(IN) :: cu_d, cl_d, ks_d, pbc_d
    REAL(sp), INTENT(INOUT) :: hu, hl
    REAL(sp), INTENT(INOUT) :: hu_d, hl_d
    REAL(sp) :: hpbc, d, wu, wl
    REAL(sp) :: hpbc_d, d_d, wu_d, wl_d
    INTRINSIC MAX
    INTRINSIC MIN
    REAL(sp) :: pwr1
    REAL(sp) :: temp
    REAL(sp) :: y1_d
    REAL(sp) :: y1
    pwr1 = hu**pbc
    IF (1e-6_sp .LT. pwr1) THEN
      temp = hu**pbc
      IF (hu .LE. 0.0 .AND. (pbc .EQ. 0.0 .OR. pbc .NE. INT(pbc))) THEN
        hpbc_d = 0.0_4
      ELSE IF (hu .LE. 0.0) THEN
        hpbc_d = pbc*hu**(pbc-1)*hu_d
      ELSE
        hpbc_d = pbc*hu**(pbc-1)*hu_d + temp*LOG(hu)*pbc_d
      END IF
      hpbc = temp
    ELSE
      hpbc = 1e-6_sp
      hpbc_d = 0.0_4
    END IF
    d_d = hpbc*ks_d + ks*hpbc_d
    d = ks*hpbc
    wu_d = cu*hu_d + hu*cu_d
    wu = hu*cu
    wl_d = cl*hl_d + hl*cl_d
    wl = hl*cl
    IF (wu .GT. cl - wl) THEN
      y1_d = cl_d - wl_d
      y1 = cl - wl
    ELSE
      y1_d = wu_d
      y1 = wu
    END IF
    IF (d .GT. y1) THEN
      d_d = y1_d
      d = y1
    ELSE
      d = d
    END IF
    hu_d = hu_d - (d_d-d*cu_d/cu)/cu
    hu = hu - d/cu
    hl_d = hl_d + (d_d-d*cl_d/cl)/cl
    hl = hl + d/cl
  END SUBROUTINE VIC3L_DRAINAGE_2L_D

!  Differentiation of vic3l_drainage_2l in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: hl ks hu pbc cl cu
!   with respect to varying inputs: hl ks hu pbc cl cu
  SUBROUTINE VIC3L_DRAINAGE_2L_B(cu, cu_b, cl, cl_b, ks, ks_b, pbc, &
&   pbc_b, hu, hu_b, hl, hl_b)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: cu, cl, ks, pbc
    REAL(sp) :: cu_b, cl_b, ks_b, pbc_b
    REAL(sp), INTENT(INOUT) :: hu, hl
    REAL(sp), INTENT(INOUT) :: hu_b, hl_b
    REAL(sp) :: hpbc, d, wu, wl
    REAL(sp) :: hpbc_b, d_b, wu_b, wl_b
    INTRINSIC MAX
    INTRINSIC MIN
    REAL(sp) :: pwr1
    REAL(sp) :: y1_b
    INTEGER :: branch
    REAL(sp) :: y1
    pwr1 = hu**pbc
    IF (1e-6_sp .LT. pwr1) THEN
      hpbc = hu**pbc
      CALL PUSHCONTROL1B(0)
    ELSE
      CALL PUSHCONTROL1B(1)
      hpbc = 1e-6_sp
    END IF
    d = ks*hpbc
    wu = hu*cu
    wl = hl*cl
    IF (wu .GT. cl - wl) THEN
      y1 = cl - wl
      CALL PUSHCONTROL1B(0)
    ELSE
      y1 = wu
      CALL PUSHCONTROL1B(1)
    END IF
    IF (d .GT. y1) THEN
      d = y1
      CALL PUSHCONTROL1B(0)
    ELSE
      d = d
      CALL PUSHCONTROL1B(1)
    END IF
    d_b = hl_b/cl - hu_b/cu
    cl_b = cl_b - d*hl_b/cl**2
    cu_b = cu_b + d*hu_b/cu**2
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      y1_b = d_b
      d_b = 0.0_4
    ELSE
      y1_b = 0.0_4
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      cl_b = cl_b + y1_b
      wl_b = -y1_b
      wu_b = 0.0_4
    ELSE
      wu_b = y1_b
      wl_b = 0.0_4
    END IF
    hl_b = hl_b + cl*wl_b
    cl_b = cl_b + hl*wl_b
    hu_b = hu_b + cu*wu_b
    cu_b = cu_b + hu*wu_b
    ks_b = ks_b + hpbc*d_b
    hpbc_b = ks*d_b
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      IF (.NOT.(hu .LE. 0.0 .AND. (pbc .EQ. 0.0 .OR. pbc .NE. INT(pbc)))&
&     ) hu_b = hu_b + pbc*hu**(pbc-1)*hpbc_b
      IF (.NOT.hu .LE. 0.0) pbc_b = pbc_b + hu**pbc*LOG(hu)*hpbc_b
    END IF
  END SUBROUTINE VIC3L_DRAINAGE_2L_B

  SUBROUTINE VIC3L_DRAINAGE_2L(cu, cl, ks, pbc, hu, hl)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: cu, cl, ks, pbc
    REAL(sp), INTENT(INOUT) :: hu, hl
    REAL(sp) :: hpbc, d, wu, wl
    INTRINSIC MAX
    INTRINSIC MIN
    REAL(sp) :: pwr1
    REAL(sp) :: y1
    pwr1 = hu**pbc
    IF (1e-6_sp .LT. pwr1) THEN
      hpbc = hu**pbc
    ELSE
      hpbc = 1e-6_sp
    END IF
    d = ks*hpbc
    wu = hu*cu
    wl = hl*cl
    IF (wu .GT. cl - wl) THEN
      y1 = cl - wl
    ELSE
      y1 = wu
    END IF
    IF (d .GT. y1) THEN
      d = y1
    ELSE
      d = d
    END IF
    hu = hu - d/cu
    hl = hl + d/cl
  END SUBROUTINE VIC3L_DRAINAGE_2L

!  Differentiation of vic3l_drainage in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: hbsl husl hmsl
!   with respect to varying inputs: hbsl cusl cmsl ks cbsl pbc
!                husl hmsl
  SUBROUTINE VIC3L_DRAINAGE_D(cusl, cusl_d, cmsl, cmsl_d, cbsl, cbsl_d, &
&   ks, ks_d, pbc, pbc_d, husl, husl_d, hmsl, hmsl_d, hbsl, hbsl_d)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: cusl, cmsl, cbsl, ks, pbc
    REAL(sp), INTENT(IN) :: cusl_d, cmsl_d, cbsl_d, ks_d, pbc_d
    REAL(sp), INTENT(INOUT) :: husl, hmsl, hbsl
    REAL(sp), INTENT(INOUT) :: husl_d, hmsl_d, hbsl_d
    CALL VIC3L_DRAINAGE_2L_D(cusl, cusl_d, cmsl, cmsl_d, ks, ks_d, pbc, &
&                      pbc_d, husl, husl_d, hmsl, hmsl_d)
    CALL VIC3L_DRAINAGE_2L_D(cmsl, cmsl_d, cbsl, cbsl_d, ks, ks_d, pbc, &
&                      pbc_d, hmsl, hmsl_d, hbsl, hbsl_d)
  END SUBROUTINE VIC3L_DRAINAGE_D

!  Differentiation of vic3l_drainage in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: hbsl cusl cmsl ks cbsl pbc
!                husl hmsl
!   with respect to varying inputs: hbsl cusl cmsl ks cbsl pbc
!                husl hmsl
  SUBROUTINE VIC3L_DRAINAGE_B(cusl, cusl_b, cmsl, cmsl_b, cbsl, cbsl_b, &
&   ks, ks_b, pbc, pbc_b, husl, husl_b, hmsl, hmsl_b, hbsl, hbsl_b)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: cusl, cmsl, cbsl, ks, pbc
    REAL(sp) :: cusl_b, cmsl_b, cbsl_b, ks_b, pbc_b
    REAL(sp), INTENT(INOUT) :: husl, hmsl, hbsl
    REAL(sp), INTENT(INOUT) :: husl_b, hmsl_b, hbsl_b
    CALL PUSHREAL4(hmsl)
    CALL PUSHREAL4(husl)
    CALL VIC3L_DRAINAGE_2L(cusl, cmsl, ks, pbc, husl, hmsl)
    CALL PUSHREAL4(hbsl)
    CALL PUSHREAL4(hmsl)
    CALL VIC3L_DRAINAGE_2L(cmsl, cbsl, ks, pbc, hmsl, hbsl)
    CALL POPREAL4(hmsl)
    CALL POPREAL4(hbsl)
    CALL VIC3L_DRAINAGE_2L_B(cmsl, cmsl_b, cbsl, cbsl_b, ks, ks_b, pbc, &
&                      pbc_b, hmsl, hmsl_b, hbsl, hbsl_b)
    CALL POPREAL4(husl)
    CALL POPREAL4(hmsl)
    CALL VIC3L_DRAINAGE_2L_B(cusl, cusl_b, cmsl, cmsl_b, ks, ks_b, pbc, &
&                      pbc_b, husl, husl_b, hmsl, hmsl_b)
  END SUBROUTINE VIC3L_DRAINAGE_B

  SUBROUTINE VIC3L_DRAINAGE(cusl, cmsl, cbsl, ks, pbc, husl, hmsl, hbsl)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: cusl, cmsl, cbsl, ks, pbc
    REAL(sp), INTENT(INOUT) :: husl, hmsl, hbsl
    CALL VIC3L_DRAINAGE_2L(cusl, cmsl, ks, pbc, husl, hmsl)
    CALL VIC3L_DRAINAGE_2L(cmsl, cbsl, ks, pbc, hmsl, hbsl)
  END SUBROUTINE VIC3L_DRAINAGE

!  Differentiation of vic3l_baseflow in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: qb hbsl
!   with respect to varying inputs: ws hbsl ds cbsl dsm
  SUBROUTINE VIC3L_BASEFLOW_D(cbsl, cbsl_d, ds, ds_d, dsm, dsm_d, ws, &
&   ws_d, hbsl, hbsl_d, qb, qb_d)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: cbsl, ds, dsm, ws
    REAL(sp), INTENT(IN) :: cbsl_d, ds_d, dsm_d, ws_d
    REAL(sp), INTENT(INOUT) :: hbsl
    REAL(sp), INTENT(INOUT) :: hbsl_d
    REAL(sp), INTENT(OUT) :: qb
    REAL(sp), INTENT(OUT) :: qb_d
    INTRINSIC MIN
    REAL(sp) :: temp
    REAL(sp) :: temp0
    REAL(sp) :: temp1
    REAL(sp) :: temp2
    IF (hbsl .GT. ws) THEN
      temp = hbsl/ws
      temp0 = (hbsl-ws)/(-ws+1._sp)
      temp1 = temp0**2._sp
      temp2 = ds/ws
      qb_d = temp*(ds*dsm_d+dsm*ds_d) + dsm*ds*(hbsl_d-temp*ws_d)/ws + &
&       temp1*((1._sp-temp2)*dsm_d-dsm*(ds_d-temp2*ws_d)/ws) + dsm*(&
&       1._sp-temp2)*2._sp*temp0*(hbsl_d-(1.0-temp0)*ws_d)/(1._sp-ws)
      qb = dsm*ds*temp + dsm*(1._sp-temp2)*temp1
    ELSE
      temp2 = hbsl/ws
      qb_d = temp2*(ds*dsm_d+dsm*ds_d) + dsm*ds*(hbsl_d-temp2*ws_d)/ws
      qb = dsm*ds*temp2
    END IF
    IF (hbsl*cbsl .GT. qb) THEN
      qb = qb
    ELSE
      qb_d = cbsl*hbsl_d + hbsl*cbsl_d
      qb = hbsl*cbsl
    END IF
    hbsl_d = hbsl_d - (qb_d-qb*cbsl_d/cbsl)/cbsl
    hbsl = hbsl - qb/cbsl
  END SUBROUTINE VIC3L_BASEFLOW_D

!  Differentiation of vic3l_baseflow in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: qb ws hbsl ds cbsl dsm
!   with respect to varying inputs: ws hbsl ds cbsl dsm
  SUBROUTINE VIC3L_BASEFLOW_B(cbsl, cbsl_b, ds, ds_b, dsm, dsm_b, ws, &
&   ws_b, hbsl, hbsl_b, qb, qb_b)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: cbsl, ds, dsm, ws
    REAL(sp) :: cbsl_b, ds_b, dsm_b, ws_b
    REAL(sp), INTENT(INOUT) :: hbsl
    REAL(sp), INTENT(INOUT) :: hbsl_b
    REAL(sp) :: qb
    REAL(sp) :: qb_b
    INTRINSIC MIN
    REAL(sp) :: temp
    REAL(sp) :: temp_b
    REAL(sp) :: temp0
    REAL(sp) :: temp_b0
    REAL(sp) :: temp1
    REAL(sp) :: temp_b1
    REAL(sp) :: temp_b2
    INTEGER :: branch
    IF (hbsl .GT. ws) THEN
      qb = dsm*ds/ws*hbsl + dsm*(1._sp-ds/ws)*((hbsl-ws)/(1._sp-ws))**&
&       2._sp
      CALL PUSHCONTROL1B(1)
    ELSE
      qb = dsm*ds/ws*hbsl
      CALL PUSHCONTROL1B(0)
    END IF
    IF (hbsl*cbsl .GT. qb) THEN
      CALL PUSHCONTROL1B(0)
      qb = qb
    ELSE
      qb = hbsl*cbsl
      CALL PUSHCONTROL1B(1)
    END IF
    qb_b = qb_b - hbsl_b/cbsl
    cbsl_b = cbsl_b + qb*hbsl_b/cbsl**2
    CALL POPCONTROL1B(branch)
    IF (branch .NE. 0) THEN
      hbsl_b = hbsl_b + cbsl*qb_b
      cbsl_b = cbsl_b + hbsl*qb_b
      qb_b = 0.0_4
    END IF
    CALL POPCONTROL1B(branch)
    IF (branch .EQ. 0) THEN
      temp1 = hbsl/ws
      dsm_b = dsm_b + ds*temp1*qb_b
      ds_b = ds_b + dsm*temp1*qb_b
      temp_b1 = dsm*ds*qb_b/ws
      hbsl_b = hbsl_b + temp_b1
      ws_b = ws_b - temp1*temp_b1
    ELSE
      temp = hbsl/ws
      temp0 = (hbsl-ws)/(-ws+1._sp)
      temp1 = ds/ws
      temp_b = dsm*ds*qb_b/ws
      temp_b0 = temp0**2._sp*qb_b
      dsm_b = dsm_b + ds*temp*qb_b + (1._sp-temp1)*temp_b0
      temp_b2 = 2._sp*temp0*dsm*(1._sp-temp1)*qb_b/(1._sp-ws)
      hbsl_b = hbsl_b + temp_b2 + temp_b
      temp_b1 = -(dsm*temp_b0/ws)
      ds_b = ds_b + dsm*temp*qb_b + temp_b1
      ws_b = ws_b + (temp0-1.0)*temp_b2 - temp1*temp_b1 - temp*temp_b
    END IF
  END SUBROUTINE VIC3L_BASEFLOW_B

  SUBROUTINE VIC3L_BASEFLOW(cbsl, ds, dsm, ws, hbsl, qb)
    IMPLICIT NONE
    REAL(sp), INTENT(IN) :: cbsl, ds, dsm, ws
    REAL(sp), INTENT(INOUT) :: hbsl
    REAL(sp), INTENT(OUT) :: qb
    INTRINSIC MIN
    IF (hbsl .GT. ws) THEN
      qb = dsm*ds/ws*hbsl + dsm*(1._sp-ds/ws)*((hbsl-ws)/(1._sp-ws))**&
&       2._sp
    ELSE
      qb = dsm*ds/ws*hbsl
    END IF
    IF (hbsl*cbsl .GT. qb) THEN
      qb = qb
    ELSE
      qb = hbsl*cbsl
    END IF
    hbsl = hbsl - qb/cbsl
  END SUBROUTINE VIC3L_BASEFLOW

!  Differentiation of vic3l_time_step in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: ac_hbsl ac_husl ac_qt ac_hmsl
!                ac_hcl
!   with respect to varying inputs: ac_hbsl ac_cusl ac_b ac_cmsl
!                ac_pbc ac_ws ac_cbsl ac_dsm ac_ds ac_husl ac_qt
!                ac_hmsl ac_ks ac_mlt ac_hcl
  SUBROUTINE VIC3L_TIME_STEP_D(setup, mesh, input_data, options, returns&
&   , time_step, ac_mlt, ac_mlt_d, ac_b, ac_b_d, ac_cusl, ac_cusl_d, &
&   ac_cmsl, ac_cmsl_d, ac_cbsl, ac_cbsl_d, ac_ks, ac_ks_d, ac_pbc, &
&   ac_pbc_d, ac_dsm, ac_dsm_d, ac_ds, ac_ds_d, ac_ws, ac_ws_d, ac_hcl, &
&   ac_hcl_d, ac_husl, ac_husl_d, ac_hmsl, ac_hmsl_d, ac_hbsl, ac_hbsl_d&
&   , ac_qt, ac_qt_d)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_b, ac_cusl, ac_cmsl&
&   , ac_cbsl, ac_ks, ac_pbc, ac_ds, ac_dsm, ac_ws
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_b_d, ac_cusl_d, &
&   ac_cmsl_d, ac_cbsl_d, ac_ks_d, ac_pbc_d, ac_ds_d, ac_dsm_d, ac_ws_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hcl, ac_husl, &
&   ac_hmsl, ac_hbsl
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hcl_d, ac_husl_d&
&   , ac_hmsl_d, ac_hbsl_d
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_d
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_d
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: pn, en, qr, qb
    REAL(sp) :: pn_d, en_d, qr_d, qb_d
    REAL(sp) :: temp
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp_d = ac_mlt_d
    ac_prcp = ac_prcp + ac_mlt
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
! Canopy maximum capacity is (0.2 * LAI). Here we fix maximum capacity to 1 mm
            CALL VIC3L_CANOPY_INTERCEPTION_D(ac_prcp(k), ac_prcp_d(k), &
&                                      ac_pet(k), 1._sp, ac_hcl(k), &
&                                      ac_hcl_d(k), pn, pn_d, en, en_d)
            CALL VIC3L_UPPER_SOIL_LAYER_EVAPORATION_D(en, en_d, ac_b(k)&
&                                               , ac_b_d(k), ac_cusl(k)&
&                                               , ac_cusl_d(k), ac_husl(&
&                                               k), ac_husl_d(k))
            CALL VIC3L_INFILTRATION_D(pn, pn_d, ac_b(k), ac_b_d(k), &
&                               ac_cusl(k), ac_cusl_d(k), ac_cmsl(k), &
&                               ac_cmsl_d(k), ac_husl(k), ac_husl_d(k), &
&                               ac_hmsl(k), ac_hmsl_d(k), qr, qr_d)
            CALL VIC3L_DRAINAGE_D(ac_cusl(k), ac_cusl_d(k), ac_cmsl(k), &
&                           ac_cmsl_d(k), ac_cbsl(k), ac_cbsl_d(k), &
&                           ac_ks(k), ac_ks_d(k), ac_pbc(k), ac_pbc_d(k)&
&                           , ac_husl(k), ac_husl_d(k), ac_hmsl(k), &
&                           ac_hmsl_d(k), ac_hbsl(k), ac_hbsl_d(k))
          ELSE
            qr = 0._sp
            qr_d = 0.0_4
          END IF
          CALL VIC3L_BASEFLOW_D(ac_cbsl(k), ac_cbsl_d(k), ac_ds(k), &
&                         ac_ds_d(k), ac_dsm(k), ac_dsm_d(k), ac_ws(k), &
&                         ac_ws_d(k), ac_hbsl(k), ac_hbsl_d(k), qb, qb_d&
&                        )
          ac_qt_d(k) = qr_d + qb_d
          ac_qt(k) = qr + qb
! Transform from mm/dt to m3/s
          temp = 1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col)
          ac_qt_d(k) = temp*ac_qt_d(k)/setup%dt
          ac_qt(k) = temp*(ac_qt(k)/setup%dt)
        END IF
      END DO
    END DO
  END SUBROUTINE VIC3L_TIME_STEP_D

!  Differentiation of vic3l_time_step in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: ac_hbsl ac_cusl ac_b ac_cmsl
!                ac_pbc ac_ws ac_cbsl ac_dsm ac_ds ac_husl ac_qt
!                ac_hmsl ac_ks ac_mlt ac_hcl
!   with respect to varying inputs: ac_hbsl ac_cusl ac_b ac_cmsl
!                ac_pbc ac_ws ac_cbsl ac_dsm ac_ds ac_husl ac_qt
!                ac_hmsl ac_ks ac_mlt ac_hcl
  SUBROUTINE VIC3L_TIME_STEP_B(setup, mesh, input_data, options, returns&
&   , time_step, ac_mlt, ac_mlt_b, ac_b, ac_b_b, ac_cusl, ac_cusl_b, &
&   ac_cmsl, ac_cmsl_b, ac_cbsl, ac_cbsl_b, ac_ks, ac_ks_b, ac_pbc, &
&   ac_pbc_b, ac_dsm, ac_dsm_b, ac_ds, ac_ds_b, ac_ws, ac_ws_b, ac_hcl, &
&   ac_hcl_b, ac_husl, ac_husl_b, ac_hmsl, ac_hmsl_b, ac_hbsl, ac_hbsl_b&
&   , ac_qt, ac_qt_b)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac) :: ac_mlt_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_b, ac_cusl, ac_cmsl&
&   , ac_cbsl, ac_ks, ac_pbc, ac_ds, ac_dsm, ac_ws
    REAL(sp), DIMENSION(mesh%nac) :: ac_b_b, ac_cusl_b, ac_cmsl_b, &
&   ac_cbsl_b, ac_ks_b, ac_pbc_b, ac_ds_b, ac_dsm_b, ac_ws_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hcl, ac_husl, &
&   ac_hmsl, ac_hbsl
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hcl_b, ac_husl_b&
&   , ac_hmsl_b, ac_hbsl_b
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt_b
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp_b
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: pn, en, qr, qb
    REAL(sp) :: pn_b, en_b, qr_b, qb_b
    INTEGER :: branch
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0) THEN
          CALL PUSHCONTROL1B(0)
        ELSE
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
! Canopy maximum capacity is (0.2 * LAI). Here we fix maximum capacity to 1 mm
            CALL PUSHREAL4(en)
            CALL PUSHREAL4(pn)
            CALL PUSHREAL4(ac_hcl(k))
            CALL VIC3L_CANOPY_INTERCEPTION(ac_prcp(k), ac_pet(k), 1._sp&
&                                    , ac_hcl(k), pn, en)
            CALL PUSHREAL4(ac_husl(k))
            CALL VIC3L_UPPER_SOIL_LAYER_EVAPORATION(en, ac_b(k), ac_cusl&
&                                             (k), ac_husl(k))
            CALL PUSHREAL4(ac_hmsl(k))
            CALL PUSHREAL4(ac_husl(k))
            CALL VIC3L_INFILTRATION(pn, ac_b(k), ac_cusl(k), ac_cmsl(k)&
&                             , ac_husl(k), ac_hmsl(k), qr)
            CALL PUSHREAL4(ac_hbsl(k))
            CALL PUSHREAL4(ac_hmsl(k))
            CALL PUSHREAL4(ac_husl(k))
            CALL VIC3L_DRAINAGE(ac_cusl(k), ac_cmsl(k), ac_cbsl(k), &
&                         ac_ks(k), ac_pbc(k), ac_husl(k), ac_hmsl(k), &
&                         ac_hbsl(k))
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHCONTROL1B(1)
          END IF
          CALL PUSHREAL4(ac_hbsl(k))
          CALL VIC3L_BASEFLOW(ac_cbsl(k), ac_ds(k), ac_dsm(k), ac_ws(k)&
&                       , ac_hbsl(k), qb)
! Transform from mm/dt to m3/s
          CALL PUSHCONTROL1B(1)
        END IF
      END DO
    END DO
    ac_prcp_b = 0.0_4
    DO col=mesh%ncol,1,-1
      DO row=mesh%nrow,1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          ac_qt_b(k) = mesh%dx(row, col)*1e-3_sp*mesh%dy(row, col)*&
&           ac_qt_b(k)/setup%dt
          qr_b = ac_qt_b(k)
          qb_b = ac_qt_b(k)
          ac_qt_b(k) = 0.0_4
          CALL POPREAL4(ac_hbsl(k))
          CALL VIC3L_BASEFLOW_B(ac_cbsl(k), ac_cbsl_b(k), ac_ds(k), &
&                         ac_ds_b(k), ac_dsm(k), ac_dsm_b(k), ac_ws(k), &
&                         ac_ws_b(k), ac_hbsl(k), ac_hbsl_b(k), qb, qb_b&
&                        )
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            CALL POPREAL4(ac_husl(k))
            CALL POPREAL4(ac_hmsl(k))
            CALL POPREAL4(ac_hbsl(k))
            CALL VIC3L_DRAINAGE_B(ac_cusl(k), ac_cusl_b(k), ac_cmsl(k), &
&                           ac_cmsl_b(k), ac_cbsl(k), ac_cbsl_b(k), &
&                           ac_ks(k), ac_ks_b(k), ac_pbc(k), ac_pbc_b(k)&
&                           , ac_husl(k), ac_husl_b(k), ac_hmsl(k), &
&                           ac_hmsl_b(k), ac_hbsl(k), ac_hbsl_b(k))
            CALL POPREAL4(ac_husl(k))
            CALL POPREAL4(ac_hmsl(k))
            CALL VIC3L_INFILTRATION_B(pn, pn_b, ac_b(k), ac_b_b(k), &
&                               ac_cusl(k), ac_cusl_b(k), ac_cmsl(k), &
&                               ac_cmsl_b(k), ac_husl(k), ac_husl_b(k), &
&                               ac_hmsl(k), ac_hmsl_b(k), qr, qr_b)
            CALL POPREAL4(ac_husl(k))
            CALL VIC3L_UPPER_SOIL_LAYER_EVAPORATION_B(en, en_b, ac_b(k)&
&                                               , ac_b_b(k), ac_cusl(k)&
&                                               , ac_cusl_b(k), ac_husl(&
&                                               k), ac_husl_b(k))
            CALL POPREAL4(ac_hcl(k))
            CALL POPREAL4(pn)
            CALL POPREAL4(en)
            CALL VIC3L_CANOPY_INTERCEPTION_B(ac_prcp(k), ac_prcp_b(k), &
&                                      ac_pet(k), 1._sp, ac_hcl(k), &
&                                      ac_hcl_b(k), pn, pn_b, en, en_b)
          END IF
        END IF
      END DO
    END DO
    ac_mlt_b = ac_mlt_b + ac_prcp_b
  END SUBROUTINE VIC3L_TIME_STEP_B

  SUBROUTINE VIC3L_TIME_STEP(setup, mesh, input_data, options, returns, &
&   time_step, ac_mlt, ac_b, ac_cusl, ac_cmsl, ac_cbsl, ac_ks, ac_pbc, &
&   ac_dsm, ac_ds, ac_ws, ac_hcl, ac_husl, ac_hmsl, ac_hbsl, ac_qt)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    INTEGER, INTENT(IN) :: time_step
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_mlt
    REAL(sp), DIMENSION(mesh%nac), INTENT(IN) :: ac_b, ac_cusl, ac_cmsl&
&   , ac_cbsl, ac_ks, ac_pbc, ac_ds, ac_dsm, ac_ws
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_hcl, ac_husl, &
&   ac_hmsl, ac_hbsl
    REAL(sp), DIMENSION(mesh%nac), INTENT(INOUT) :: ac_qt
    REAL(sp), DIMENSION(mesh%nac) :: ac_prcp, ac_pet
    INTEGER :: row, col, k, time_step_returns
    REAL(sp) :: pn, en, qr, qb
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'prcp', ac_prcp)
    CALL GET_AC_ATMOS_DATA_TIME_STEP(setup, mesh, input_data, time_step&
&                              , 'pet', ac_pet)
    ac_prcp = ac_prcp + ac_mlt
    DO col=1,mesh%ncol
      DO row=1,mesh%nrow
        IF (.NOT.(mesh%active_cell(row, col) .EQ. 0 .OR. mesh%&
&           local_active_cell(row, col) .EQ. 0)) THEN
          k = mesh%rowcol_to_ind_ac(row, col)
          IF (ac_prcp(k) .GE. 0._sp .AND. ac_pet(k) .GE. 0._sp) THEN
! Canopy maximum capacity is (0.2 * LAI). Here we fix maximum capacity to 1 mm
            CALL VIC3L_CANOPY_INTERCEPTION(ac_prcp(k), ac_pet(k), 1._sp&
&                                    , ac_hcl(k), pn, en)
            CALL VIC3L_UPPER_SOIL_LAYER_EVAPORATION(en, ac_b(k), ac_cusl&
&                                             (k), ac_husl(k))
            CALL VIC3L_INFILTRATION(pn, ac_b(k), ac_cusl(k), ac_cmsl(k)&
&                             , ac_husl(k), ac_hmsl(k), qr)
            CALL VIC3L_DRAINAGE(ac_cusl(k), ac_cmsl(k), ac_cbsl(k), &
&                         ac_ks(k), ac_pbc(k), ac_husl(k), ac_hmsl(k), &
&                         ac_hbsl(k))
          ELSE
            qr = 0._sp
          END IF
          CALL VIC3L_BASEFLOW(ac_cbsl(k), ac_ds(k), ac_dsm(k), ac_ws(k)&
&                       , ac_hbsl(k), qb)
          ac_qt(k) = qr + qb
! Transform from mm/dt to m3/s
          ac_qt(k) = ac_qt(k)*1e-3_sp*mesh%dx(row, col)*mesh%dy(row, col&
&           )/setup%dt
        END IF
      END DO
    END DO
  END SUBROUTINE VIC3L_TIME_STEP

END MODULE MD_VIC3L_OPERATOR_DIFF

!%      (MD) Module Differentiated.
!%
!%      Subroutine
!%      ----------
!%
!%      - roll_discharge
!%      - store_time_step
!%      - simulation_checkpoint
!%      - simulation
MODULE MD_SIMULATION_DIFF
!% only: sp
  USE MD_CONSTANT
!% only: SetupDT
  USE MWD_SETUP
!% only: MeshDT
  USE MWD_MESH
!% only: Input_DataDT
  USE MWD_INPUT_DATA
!% only: ParametersDT
  USE MWD_PARAMETERS_DIFF
!% only: RR_StatesDT
  USE MWD_RR_STATES_DIFF
!% only: OutputDT
  USE MWD_OUTPUT_DIFF
!% only: OptionsDT
  USE MWD_OPTIONS_DIFF
!% only: ReturnsDT
  USE MWD_RETURNS_DIFF
!% only: Checkpoint_VariableDT
  USE MD_CHECKPOINT_VARIABLE_DIFF
!% only: ssn_time_step
  USE MD_SNOW_OPERATOR_DIFF
!% only: gr4_time_step, gr4_mlp_time_step, gr4_ri_time_step, gr4_ode_time_step, &
  USE MD_GR_OPERATOR_DIFF
!% & gr4_ode_mlp_time_step, gr5_time_step, gr5_mlp_time_step, gr5_ri_time_step, gr6_time_step, &
!% & gr6_mlp_time_step, grc_time_step, grc_mlp_time_step, grd_time_step, grd_mlp_time_step,
!% & loieau_time_step, loieau_mlp_time_step
!% only: vic3l_time_step
  USE MD_VIC3L_OPERATOR_DIFF
!% only: lag0_time_step, lr_time_step, kw_time_step
  USE MD_ROUTING_OPERATOR_DIFF
!% only: matrix_to_ac_vector, &
  USE MWD_SPARSE_MATRIX_MANIPULATION_DIFF
  IMPLICIT NONE

CONTAINS
!  Differentiation of roll_discharge in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: ac_qz
!   with respect to varying inputs: ac_qz
  SUBROUTINE ROLL_DISCHARGE_D(ac_qz, ac_qz_d)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:, :), INTENT(INOUT) :: ac_qz
    REAL(sp), DIMENSION(:, :), INTENT(INOUT) :: ac_qz_d
    INTEGER :: i, nqz
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(ac_qz, 1)) :: tmp
    REAL(sp), DIMENSION(SIZE(ac_qz, 1)) :: tmp_d
    nqz = SIZE(ac_qz, 2)
    DO i=nqz,2,-1
      tmp_d = ac_qz_d(:, nqz)
      tmp = ac_qz(:, nqz)
      ac_qz_d(:, nqz) = ac_qz_d(:, i-1)
      ac_qz(:, nqz) = ac_qz(:, i-1)
      ac_qz_d(:, i-1) = tmp_d
      ac_qz(:, i-1) = tmp
    END DO
  END SUBROUTINE ROLL_DISCHARGE_D

!  Differentiation of roll_discharge in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: ac_qz
!   with respect to varying inputs: ac_qz
  SUBROUTINE ROLL_DISCHARGE_B(ac_qz, ac_qz_b)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:, :), INTENT(INOUT) :: ac_qz
    REAL(sp), DIMENSION(:, :), INTENT(INOUT) :: ac_qz_b
    INTEGER :: i, nqz
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(ac_qz, 1)) :: tmp
    REAL(sp), DIMENSION(SIZE(ac_qz, 1)) :: tmp_b
    REAL(sp), DIMENSION(SIZE(ac_qz, 1)) :: tmp0
    REAL(sp), DIMENSION(SIZE(ac_qz, 1)) :: tmp_b0
    nqz = SIZE(ac_qz, 2)
    DO i=2,nqz,1
      tmp_b = 0.0_4
      tmp_b = ac_qz_b(:, i-1)
      ac_qz_b(:, i-1) = 0.0_4
      tmp_b0(:) = ac_qz_b(:, nqz)
      ac_qz_b(:, nqz) = 0.0_4
      ac_qz_b(:, i-1) = ac_qz_b(:, i-1) + tmp_b0
      ac_qz_b(:, nqz) = ac_qz_b(:, nqz) + tmp_b
    END DO
  END SUBROUTINE ROLL_DISCHARGE_B

  SUBROUTINE ROLL_DISCHARGE(ac_qz)
    IMPLICIT NONE
    REAL(sp), DIMENSION(:, :), INTENT(INOUT) :: ac_qz
    INTEGER :: i, nqz
    INTRINSIC SIZE
    REAL(sp), DIMENSION(SIZE(ac_qz, 1)) :: tmp
    nqz = SIZE(ac_qz, 2)
    DO i=nqz,2,-1
      tmp = ac_qz(:, nqz)
      ac_qz(:, nqz) = ac_qz(:, i-1)
      ac_qz(:, i-1) = tmp
    END DO
  END SUBROUTINE ROLL_DISCHARGE

!  Differentiation of store_time_step in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: *(output.response.q)
!   with respect to varying inputs: *(checkpoint_variable.ac_qz)
!                *(output.response.q)
!   Plus diff mem management of: checkpoint_variable.ac_qz:in output.response.q:in
  SUBROUTINE STORE_TIME_STEP_D(setup, mesh, output, output_d, returns, &
&   checkpoint_variable, checkpoint_variable_d, time_step)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(OUTPUTDT), INTENT(INOUT) :: output
    TYPE(OUTPUTDT), INTENT(INOUT) :: output_d
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    TYPE(CHECKPOINT_VARIABLEDT), INTENT(IN) :: checkpoint_variable
    TYPE(CHECKPOINT_VARIABLEDT), INTENT(IN) :: checkpoint_variable_d
    INTEGER, INTENT(IN) :: time_step
    INTEGER :: i, k, time_step_returns
    DO i=1,mesh%ng
      k = mesh%rowcol_to_ind_ac(mesh%gauge_pos(i, 1), mesh%gauge_pos(i, &
&       2))
      output_d%response%q(i, time_step) = checkpoint_variable_d%ac_qz(k&
&       , setup%nqz)
      output%response%q(i, time_step) = checkpoint_variable%ac_qz(k, &
&       setup%nqz)
    END DO
  END SUBROUTINE STORE_TIME_STEP_D

!  Differentiation of store_time_step in reverse (adjoint) mode (with options fixinterface noISIZE context):
!   gradient     of useful results: *(checkpoint_variable.ac_qz)
!                *(output.response.q)
!   with respect to varying inputs: *(checkpoint_variable.ac_qz)
!                *(output.response.q)
!   Plus diff mem management of: checkpoint_variable.ac_qz:in output.response.q:in
  SUBROUTINE STORE_TIME_STEP_B(setup, mesh, output, output_b, returns, &
&   checkpoint_variable, checkpoint_variable_b, time_step)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(OUTPUTDT), INTENT(INOUT) :: output
    TYPE(OUTPUTDT), INTENT(INOUT) :: output_b
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    TYPE(CHECKPOINT_VARIABLEDT), INTENT(IN) :: checkpoint_variable
    TYPE(CHECKPOINT_VARIABLEDT) :: checkpoint_variable_b
    INTEGER, INTENT(IN) :: time_step
    INTEGER :: i, k, time_step_returns
    DO i=1,mesh%ng
      k = mesh%rowcol_to_ind_ac(mesh%gauge_pos(i, 1), mesh%gauge_pos(i, &
&       2))
    END DO
    DO i=mesh%ng,1,-1
      k = mesh%rowcol_to_ind_ac(mesh%gauge_pos(i, 1), mesh%gauge_pos(i, &
&       2))
      checkpoint_variable_b%ac_qz(k, setup%nqz) = checkpoint_variable_b%&
&       ac_qz(k, setup%nqz) + output_b%response%q(i, time_step)
      output_b%response%q(i, time_step) = 0.0_4
    END DO
  END SUBROUTINE STORE_TIME_STEP_B

  SUBROUTINE STORE_TIME_STEP(setup, mesh, output, returns, &
&   checkpoint_variable, time_step)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(OUTPUTDT), INTENT(INOUT) :: output
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    TYPE(CHECKPOINT_VARIABLEDT), INTENT(IN) :: checkpoint_variable
    INTEGER, INTENT(IN) :: time_step
    INTEGER :: i, k, time_step_returns
    DO i=1,mesh%ng
      k = mesh%rowcol_to_ind_ac(mesh%gauge_pos(i, 1), mesh%gauge_pos(i, &
&       2))
      output%response%q(i, time_step) = checkpoint_variable%ac_qz(k, &
&       setup%nqz)
    END DO
  END SUBROUTINE STORE_TIME_STEP

!  Differentiation of simulation_checkpoint in forward (tangent) mode (with options fixinterface noISIZE context):
!   variations   of useful results: *(checkpoint_variable.ac_rr_states)
!                *(checkpoint_variable.ac_mlt) *(checkpoint_variable.ac_qtz)
!                *(checkpoint_variable.ac_qz) *(output.response.q)
!   with respect to varying inputs: *(parameters.nn_parameters.weight_1)
!                *(parameters.nn_parameters.bias_1) *(parameters.nn_parameters.weight_2)
!                *(parameters.nn_parameters.bias_2) *(parameters.nn_parameters.weight_3)
!                *(parameters.nn_parameters.bias_3) *(checkpoint_variable.ac_rr_parameters)
!                *(checkpoint_variable.ac_rr_states) *(checkpoint_variable.ac_mlt)
!                *(checkpoint_variable.ac_qtz) *(checkpoint_variable.ac_qz)
!                *(output.response.q)
!   Plus diff mem management of: parameters.nn_parameters.weight_1:in
!                parameters.nn_parameters.bias_1:in parameters.nn_parameters.weight_2:in
!                parameters.nn_parameters.bias_2:in parameters.nn_parameters.weight_3:in
!                parameters.nn_parameters.bias_3:in checkpoint_variable.ac_rr_parameters:in
!                checkpoint_variable.ac_rr_states:in checkpoint_variable.ac_mlt:in
!                checkpoint_variable.ac_qtz:in checkpoint_variable.ac_qz:in
!                output.response.q:in
  SUBROUTINE SIMULATION_CHECKPOINT_D(setup, mesh, input_data, parameters&
&   , parameters_d, output, output_d, options, returns, &
&   checkpoint_variable, checkpoint_variable_d, start_time_step, &
&   end_time_step)
    IMPLICIT NONE
    TYPE(SETUPDT), INTENT(IN) :: setup
    TYPE(MESHDT), INTENT(IN) :: mesh
    TYPE(INPUT_DATADT), INTENT(IN) :: input_data
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters
    TYPE(PARAMETERSDT), INTENT(INOUT) :: parameters_d
    TYPE(OUTPUTDT), INTENT(INOUT) :: output
    TYPE(OUTPUTDT), INTENT(INOUT) :: output_d
    TYPE(OPTIONSDT), INTENT(IN) :: options
    TYPE(RETURNSDT), INTENT(INOUT) :: returns
    TYPE(CHECKPOINT_VARIABLEDT), INTENT(INOUT) :: checkpoint_variable
    TYPE(CHECKPOINT_VARIABLEDT), INTENT(INOUT) :: checkpoint_variable_d
    INTEGER, INTENT(IN) :: start_time_step, end_time_step
    INTEGER :: t, rr_parameters_inc, rr_states_inc
! % Might add any number if needed
    REAL(sp), DIMENSION(mesh%nac) :: h1, h2, h3, h4
    REAL(sp), DIMENSION(mesh%nac) :: h1_d, h2_d, h3_d, h4_d
    DO t=start_time_step,end_time_step
      rr_parameters_inc = 0
      rr_states_inc = 0
! % Roll discharge buffer. Depending on the routing module, it is sometimes necessary to store
! % more than one discharge time step. Instead of storing all the time steps, we allocate an array
! % whose depth is equal to the depth of the time dependency, and then at each time step, we
! % overwrite the oldest time step by rolling the array.
      CALL ROLL_DISCHARGE_D(checkpoint_variable%ac_qtz, &
&                     checkpoint_variable_d%ac_qtz)
      CALL ROLL_DISCHARGE_D(checkpoint_variable%ac_qz, &
&                     checkpoint_variable_d%ac_qz)
! Snow module
      SELECT CASE  (setup%snow_module) 
      CASE ('zero') 

      CASE ('ssn') 
! 'zero' module
! Nothing to do
! 'ssn' module
! % To avoid potential aliasing tapenade warning (DF02)
! % hs
        h1_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+1)
        h1 = checkpoint_variable%ac_rr_states(:, rr_states_inc+1)
! % kmlt
! % hs
        CALL SSN_TIME_STEP_D(setup, mesh, input_data, options, returns, &
&                      t, checkpoint_variable%ac_rr_parameters(:, &
&                      rr_parameters_inc+1), checkpoint_variable_d%&
&                      ac_rr_parameters(:, rr_parameters_inc+1), h1, &
&                      h1_d, checkpoint_variable%ac_mlt, &
&                      checkpoint_variable_d%ac_mlt)
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+1) = h1_d
        checkpoint_variable%ac_rr_states(:, rr_states_inc+1) = h1
        rr_parameters_inc = rr_parameters_inc + 1
        rr_states_inc = rr_states_inc + 1
      END SELECT
! Hydrological module
      SELECT CASE  (setup%hydrological_module) 
      CASE ('gr4') 
! 'gr4' module
! % To avoid potential aliasing tapenade warning (DF02)
! % hi
        h1_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+1)
        h1 = checkpoint_variable%ac_rr_states(:, rr_states_inc+1)
! % hp
        h2_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+2)
        h2 = checkpoint_variable%ac_rr_states(:, rr_states_inc+2)
! % ht
        h3_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+3)
        h3 = checkpoint_variable%ac_rr_states(:, rr_states_inc+3)
! % ci
! % cp
! % ct
! % kexc
! % hi
! % hp
! % ht
        CALL GR4_TIME_STEP_D(setup, mesh, input_data, options, returns, &
&                      t, checkpoint_variable%ac_mlt, &
&                      checkpoint_variable_d%ac_mlt, checkpoint_variable&
&                      %ac_rr_parameters(:, rr_parameters_inc+1), &
&                      checkpoint_variable_d%ac_rr_parameters(:, &
&                      rr_parameters_inc+1), checkpoint_variable%&
&                      ac_rr_parameters(:, rr_parameters_inc+2), &
&                      checkpoint_variable_d%ac_rr_parameters(:, &
&                      rr_parameters_inc+2), checkpoint_variable%&
&                      ac_rr_parameters(:, rr_parameters_inc+3), &
&                      checkpoint_variable_d%ac_rr_parameters(:, &
&                      rr_parameters_inc+3), checkpoint_variable%&
&                      ac_rr_parameters(:, rr_parameters_inc+4), &
&                      checkpoint_variable_d%ac_rr_parameters(:, &
&                      rr_parameters_inc+4), h1, h1_d, h2, h2_d, h3, &
&                      h3_d, checkpoint_variable%ac_qtz(:, setup%nqz), &
&                      checkpoint_variable_d%ac_qtz(:, setup%nqz))
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+1) = h1_d
        checkpoint_variable%ac_rr_states(:, rr_states_inc+1) = h1
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+2) = h2_d
        checkpoint_variable%ac_rr_states(:, rr_states_inc+2) = h2
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+3) = h3_d
        checkpoint_variable%ac_rr_states(:, rr_states_inc+3) = h3
        rr_parameters_inc = rr_parameters_inc + 4
        rr_states_inc = rr_states_inc + 3
      CASE ('gr4_mlp') 
! 'gr4_mlp' module
! % To avoid potential aliasing tapenade warning (DF02)
! % hi
        h1_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+1)
        h1 = checkpoint_variable%ac_rr_states(:, rr_states_inc+1)
! % hp
        h2_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+2)
        h2 = checkpoint_variable%ac_rr_states(:, rr_states_inc+2)
! % ht
        h3_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+3)
        h3 = checkpoint_variable%ac_rr_states(:, rr_states_inc+3)
! % ci
! % cp
! % ct
! % kexc
! % hi
! % hp
! % ht
        CALL GR4_MLP_TIME_STEP_D(setup, mesh, input_data, options, &
&                          returns, t, parameters%nn_parameters%weight_1&
&                          , parameters_d%nn_parameters%weight_1, &
&                          parameters%nn_parameters%bias_1, parameters_d&
&                          %nn_parameters%bias_1, parameters%&
&                          nn_parameters%weight_2, parameters_d%&
&                          nn_parameters%weight_2, parameters%&
&                          nn_parameters%bias_2, parameters_d%&
&                          nn_parameters%bias_2, parameters%&
&                          nn_parameters%weight_3, parameters_d%&
&                          nn_parameters%weight_3, parameters%&
&                          nn_parameters%bias_3, parameters_d%&
&                          nn_parameters%bias_3, checkpoint_variable%&
&                          ac_mlt, checkpoint_variable_d%ac_mlt, &
&                          checkpoint_variable%ac_rr_parameters(:, &
&                          rr_parameters_inc+1), checkpoint_variable_d%&
&                          ac_rr_parameters(:, rr_parameters_inc+1), &
&                          checkpoint_variable%ac_rr_parameters(:, &
&                          rr_parameters_inc+2), checkpoint_variable_d%&
&                          ac_rr_parameters(:, rr_parameters_inc+2), &
&                          checkpoint_variable%ac_rr_parameters(:, &
&                          rr_parameters_inc+3), checkpoint_variable_d%&
&                          ac_rr_parameters(:, rr_parameters_inc+3), &
&                          checkpoint_variable%ac_rr_parameters(:, &
&                          rr_parameters_inc+4), checkpoint_variable_d%&
&                          ac_rr_parameters(:, rr_parameters_inc+4), h1&
&                          , h1_d, h2, h2_d, h3, h3_d, &
&                          checkpoint_variable%ac_qtz(:, setup%nqz), &
&                          checkpoint_variable_d%ac_qtz(:, setup%nqz))
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+1) = h1_d
        checkpoint_variable%ac_rr_states(:, rr_states_inc+1) = h1
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+2) = h2_d
        checkpoint_variable%ac_rr_states(:, rr_states_inc+2) = h2
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+3) = h3_d
        checkpoint_variable%ac_rr_states(:, rr_states_inc+3) = h3
        rr_parameters_inc = rr_parameters_inc + 4
        rr_states_inc = rr_states_inc + 3
      CASE ('gr4_ri') 
! 'gr4_ri' module
! % To avoid potential aliasing tapenade warning (DF02)
! % hi
        h1_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+1)
        h1 = checkpoint_variable%ac_rr_states(:, rr_states_inc+1)
! % hp
        h2_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+2)
        h2 = checkpoint_variable%ac_rr_states(:, rr_states_inc+2)
! % ht
        h3_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+3)
        h3 = checkpoint_variable%ac_rr_states(:, rr_states_inc+3)
! % ci
! % cp
! % ct
! % alpha1
! % alpha2
! % kexc
! % hi
! % hp
! % ht
        CALL GR4_RI_TIME_STEP_D(setup, mesh, input_data, options, &
&                         returns, t, checkpoint_variable%ac_mlt, &
&                         checkpoint_variable_d%ac_mlt, &
&                         checkpoint_variable%ac_rr_parameters(:, &
&                         rr_parameters_inc+1), checkpoint_variable_d%&
&                         ac_rr_parameters(:, rr_parameters_inc+1), &
&                         checkpoint_variable%ac_rr_parameters(:, &
&                         rr_parameters_inc+2), checkpoint_variable_d%&
&                         ac_rr_parameters(:, rr_parameters_inc+2), &
&                         checkpoint_variable%ac_rr_parameters(:, &
&                         rr_parameters_inc+3), checkpoint_variable_d%&
&                         ac_rr_parameters(:, rr_parameters_inc+3), &
&                         checkpoint_variable%ac_rr_parameters(:, &
&                         rr_parameters_inc+4), checkpoint_variable_d%&
&                         ac_rr_parameters(:, rr_parameters_inc+4), &
&                         checkpoint_variable%ac_rr_parameters(:, &
&                         rr_parameters_inc+5), checkpoint_variable_d%&
&                         ac_rr_parameters(:, rr_parameters_inc+5), &
&                         checkpoint_variable%ac_rr_parameters(:, &
&                         rr_parameters_inc+6), checkpoint_variable_d%&
&                         ac_rr_parameters(:, rr_parameters_inc+6), h1, &
&                         h1_d, h2, h2_d, h3, h3_d, checkpoint_variable%&
&                         ac_qtz(:, setup%nqz), checkpoint_variable_d%&
&                         ac_qtz(:, setup%nqz))
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+1) = h1_d
        checkpoint_variable%ac_rr_states(:, rr_states_inc+1) = h1
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+2) = h2_d
        checkpoint_variable%ac_rr_states(:, rr_states_inc+2) = h2
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+3) = h3_d
        checkpoint_variable%ac_rr_states(:, rr_states_inc+3) = h3
        rr_parameters_inc = rr_parameters_inc + 6
        rr_states_inc = rr_states_inc + 3
      CASE ('gr4_ode') 
! 'gr4_ode' module
! % To avoid potential aliasing tapenade warning (DF02)
! % hi
        h1_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+1)
        h1 = checkpoint_variable%ac_rr_states(:, rr_states_inc+1)
! % hp
        h2_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+2)
        h2 = checkpoint_variable%ac_rr_states(:, rr_states_inc+2)
! % ht
        h3_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+3)
        h3 = checkpoint_variable%ac_rr_states(:, rr_states_inc+3)
! % ci
! % cp
! % ct
! % kexc
! % hi
! % hp
! % ht
        CALL GR4_ODE_TIME_STEP_D(setup, mesh, input_data, options, &
&                          returns, t, checkpoint_variable%ac_mlt, &
&                          checkpoint_variable_d%ac_mlt, &
&                          checkpoint_variable%ac_rr_parameters(:, &
&                          rr_parameters_inc+1), checkpoint_variable_d%&
&                          ac_rr_parameters(:, rr_parameters_inc+1), &
&                          checkpoint_variable%ac_rr_parameters(:, &
&                          rr_parameters_inc+2), checkpoint_variable_d%&
&                          ac_rr_parameters(:, rr_parameters_inc+2), &
&                          checkpoint_variable%ac_rr_parameters(:, &
&                          rr_parameters_inc+3), checkpoint_variable_d%&
&                          ac_rr_parameters(:, rr_parameters_inc+3), &
&                          checkpoint_variable%ac_rr_parameters(:, &
&                          rr_parameters_inc+4), checkpoint_variable_d%&
&                          ac_rr_parameters(:, rr_parameters_inc+4), h1&
&                          , h1_d, h2, h2_d, h3, h3_d, &
&                          checkpoint_variable%ac_qtz(:, setup%nqz), &
&                          checkpoint_variable_d%ac_qtz(:, setup%nqz))
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+1) = h1_d
        checkpoint_variable%ac_rr_states(:, rr_states_inc+1) = h1
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+2) = h2_d
        checkpoint_variable%ac_rr_states(:, rr_states_inc+2) = h2
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+3) = h3_d
        checkpoint_variable%ac_rr_states(:, rr_states_inc+3) = h3
        rr_parameters_inc = rr_parameters_inc + 4
        rr_states_inc = rr_states_inc + 3
      CASE ('gr4_ode_mlp') 
! 'gr4_ode_mlp' module
! % To avoid potential aliasing tapenade warning (DF02)
! % hi
        h1_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+1)
        h1 = checkpoint_variable%ac_rr_states(:, rr_states_inc+1)
! % hp
        h2_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+2)
        h2 = checkpoint_variable%ac_rr_states(:, rr_states_inc+2)
! % ht
        h3_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+3)
        h3 = checkpoint_variable%ac_rr_states(:, rr_states_inc+3)
! % ci
! % cp
! % ct
! % kexc
! % hi
! % hp
! % ht
        CALL GR4_ODE_MLP_TIME_STEP_D(setup, mesh, input_data, options, &
&                              returns, t, parameters%nn_parameters%&
&                              weight_1, parameters_d%nn_parameters%&
&                              weight_1, parameters%nn_parameters%bias_1&
&                              , parameters_d%nn_parameters%bias_1, &
&                              parameters%nn_parameters%weight_2, &
&                              parameters_d%nn_parameters%weight_2, &
&                              parameters%nn_parameters%bias_2, &
&                              parameters_d%nn_parameters%bias_2, &
&                              parameters%nn_parameters%weight_3, &
&                              parameters_d%nn_parameters%weight_3, &
&                              parameters%nn_parameters%bias_3, &
&                              parameters_d%nn_parameters%bias_3, &
&                              checkpoint_variable%ac_mlt, &
&                              checkpoint_variable_d%ac_mlt, &
&                              checkpoint_variable%ac_rr_parameters(:, &
&                              rr_parameters_inc+1), &
&                              checkpoint_variable_d%ac_rr_parameters(:&
&                              , rr_parameters_inc+1), &
&                              checkpoint_variable%ac_rr_parameters(:, &
&                              rr_parameters_inc+2), &
&                              checkpoint_variable_d%ac_rr_parameters(:&
&                              , rr_parameters_inc+2), &
&                              checkpoint_variable%ac_rr_parameters(:, &
&                              rr_parameters_inc+3), &
&                              checkpoint_variable_d%ac_rr_parameters(:&
&                              , rr_parameters_inc+3), &
&                              checkpoint_variable%ac_rr_parameters(:, &
&                              rr_parameters_inc+4), &
&                              checkpoint_variable_d%ac_rr_parameters(:&
&                              , rr_parameters_inc+4), h1, h1_d, h2, &
&                              h2_d, h3, h3_d, checkpoint_variable%&
&                              ac_qtz(:, setup%nqz), &
&                              checkpoint_variable_d%ac_qtz(:, setup%nqz&
&                              ))
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+1) = h1_d
        checkpoint_variable%ac_rr_states(:, rr_states_inc+1) = h1
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+2) = h2_d
        checkpoint_variable%ac_rr_states(:, rr_states_inc+2) = h2
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+3) = h3_d
        checkpoint_variable%ac_rr_states(:, rr_states_inc+3) = h3
        rr_parameters_inc = rr_parameters_inc + 4
        rr_states_inc = rr_states_inc + 3
      CASE ('gr5') 
! 'gr5' module
! % To avoid potential aliasing tapenade warning (DF02)
! % hi
        h1_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+1)
        h1 = checkpoint_variable%ac_rr_states(:, rr_states_inc+1)
! % hp
        h2_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+2)
        h2 = checkpoint_variable%ac_rr_states(:, rr_states_inc+2)
! % ht
        h3_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+3)
        h3 = checkpoint_variable%ac_rr_states(:, rr_states_inc+3)
! % ci
! % cp
! % ct
! % kexc
! % aexc
! % hi
! % hp
! % ht
        CALL GR5_TIME_STEP_D(setup, mesh, input_data, options, returns, &
&                      t, checkpoint_variable%ac_mlt, &
&                      checkpoint_variable_d%ac_mlt, checkpoint_variable&
&                      %ac_rr_parameters(:, rr_parameters_inc+1), &
&                      checkpoint_variable_d%ac_rr_parameters(:, &
&                      rr_parameters_inc+1), checkpoint_variable%&
&                      ac_rr_parameters(:, rr_parameters_inc+2), &
&                      checkpoint_variable_d%ac_rr_parameters(:, &
&                      rr_parameters_inc+2), checkpoint_variable%&
&                      ac_rr_parameters(:, rr_parameters_inc+3), &
&                      checkpoint_variable_d%ac_rr_parameters(:, &
&                      rr_parameters_inc+3), checkpoint_variable%&
&                      ac_rr_parameters(:, rr_parameters_inc+4), &
&                      checkpoint_variable_d%ac_rr_parameters(:, &
&                      rr_parameters_inc+4), checkpoint_variable%&
&                      ac_rr_parameters(:, rr_parameters_inc+5), &
&                      checkpoint_variable_d%ac_rr_parameters(:, &
&                      rr_parameters_inc+5), h1, h1_d, h2, h2_d, h3, &
&                      h3_d, checkpoint_variable%ac_qtz(:, setup%nqz), &
&                      checkpoint_variable_d%ac_qtz(:, setup%nqz))
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+1) = h1_d
        checkpoint_variable%ac_rr_states(:, rr_states_inc+1) = h1
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+2) = h2_d
        checkpoint_variable%ac_rr_states(:, rr_states_inc+2) = h2
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+3) = h3_d
        checkpoint_variable%ac_rr_states(:, rr_states_inc+3) = h3
        rr_parameters_inc = rr_parameters_inc + 5
        rr_states_inc = rr_states_inc + 3
      CASE ('gr5_mlp') 
! 'gr5_mlp' module
! % To avoid potential aliasing tapenade warning (DF02)
! % hi
        h1_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+1)
        h1 = checkpoint_variable%ac_rr_states(:, rr_states_inc+1)
! % hp
        h2_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+2)
        h2 = checkpoint_variable%ac_rr_states(:, rr_states_inc+2)
! % ht
        h3_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+3)
        h3 = checkpoint_variable%ac_rr_states(:, rr_states_inc+3)
! % ci
! % cp
! % ct
! % kexc
! % aexc
! % hi
! % hp
! % ht
        CALL GR5_MLP_TIME_STEP_D(setup, mesh, input_data, options, &
&                          returns, t, parameters%nn_parameters%weight_1&
&                          , parameters_d%nn_parameters%weight_1, &
&                          parameters%nn_parameters%bias_1, parameters_d&
&                          %nn_parameters%bias_1, parameters%&
&                          nn_parameters%weight_2, parameters_d%&
&                          nn_parameters%weight_2, parameters%&
&                          nn_parameters%bias_2, parameters_d%&
&                          nn_parameters%bias_2, parameters%&
&                          nn_parameters%weight_3, parameters_d%&
&                          nn_parameters%weight_3, parameters%&
&                          nn_parameters%bias_3, parameters_d%&
&                          nn_parameters%bias_3, checkpoint_variable%&
&                          ac_mlt, checkpoint_variable_d%ac_mlt, &
&                          checkpoint_variable%ac_rr_parameters(:, &
&                          rr_parameters_inc+1), checkpoint_variable_d%&
&                          ac_rr_parameters(:, rr_parameters_inc+1), &
&                          checkpoint_variable%ac_rr_parameters(:, &
&                          rr_parameters_inc+2), checkpoint_variable_d%&
&                          ac_rr_parameters(:, rr_parameters_inc+2), &
&                          checkpoint_variable%ac_rr_parameters(:, &
&                          rr_parameters_inc+3), checkpoint_variable_d%&
&                          ac_rr_parameters(:, rr_parameters_inc+3), &
&                          checkpoint_variable%ac_rr_parameters(:, &
&                          rr_parameters_inc+4), checkpoint_variable_d%&
&                          ac_rr_parameters(:, rr_parameters_inc+4), &
&                          checkpoint_variable%ac_rr_parameters(:, &
&                          rr_parameters_inc+5), checkpoint_variable_d%&
&                          ac_rr_parameters(:, rr_parameters_inc+5), h1&
&                          , h1_d, h2, h2_d, h3, h3_d, &
&                          checkpoint_variable%ac_qtz(:, setup%nqz), &
&                          checkpoint_variable_d%ac_qtz(:, setup%nqz))
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+1) = h1_d
        checkpoint_variable%ac_rr_states(:, rr_states_inc+1) = h1
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+2) = h2_d
        checkpoint_variable%ac_rr_states(:, rr_states_inc+2) = h2
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+3) = h3_d
        checkpoint_variable%ac_rr_states(:, rr_states_inc+3) = h3
        rr_parameters_inc = rr_parameters_inc + 5
        rr_states_inc = rr_states_inc + 3
      CASE ('gr5_ri') 
! 'gr5_ri' module
! % To avoid potential aliasing tapenade warning (DF02)
! % hi
        h1_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+1)
        h1 = checkpoint_variable%ac_rr_states(:, rr_states_inc+1)
! % hp
        h2_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+2)
        h2 = checkpoint_variable%ac_rr_states(:, rr_states_inc+2)
! % ht
        h3_d = checkpoint_variable_d%ac_rr_states(:, rr_states_inc+3)
        h3 = checkpoint_variable%ac_rr_states(:, rr_states_inc+3)
! % ci
! % cp
! % ct
! % alpha1
! % alpha2
! % kexc
! % aexc
! % hi
! % hp
! % ht
        CALL GR5_RI_TIME_STEP_D(setup, mesh, input_data, options, &
&                         returns, t, checkpoint_variable%ac_mlt, &
&                         checkpoint_variable_d%ac_mlt, &
&                         checkpoint_variable%ac_rr_parameters(:, &
&                         rr_parameters_inc+1), checkpoint_variable_d%&
&                         ac_rr_parameters(:, rr_parameters_inc+1), &
&                         checkpoint_variable%ac_rr_parameters(:, &
&                         rr_parameters_inc+2), checkpoint_variable_d%&
&                         ac_rr_parameters(:, rr_parameters_inc+2), &
&                         checkpoint_variable%ac_rr_parameters(:, &
&                         rr_parameters_inc+3), checkpoint_variable_d%&
&                         ac_rr_parameters(:, rr_parameters_inc+3), &
&                         checkpoint_variable%ac_rr_parameters(:, &
&                         rr_parameters_inc+4), checkpoint_variable_d%&
&                         ac_rr_parameters(:, rr_parameters_inc+4), &
&                         checkpoint_variable%ac_rr_parameters(:, &
&                         rr_parameters_inc+5), checkpoint_variable_d%&
&                         ac_rr_parameters(:, rr_parameters_inc+5), &
&                         checkpoint_variable%ac_rr_parameters(:, &
&                         rr_parameters_inc+6), checkpoint_variable_d%&
&                         ac_rr_parameters(:, rr_parameters_inc+6), &
&                         checkpoint_variable%ac_rr_parameters(:, &
&                         rr_parameters_inc+7), checkpoint_variable_d%&
&                         ac_rr_parameters(:, rr_parameters_inc+7), h1, &
&                         h1_d, h2, h2_d, h3, h3_d, checkpoint_variable%&
&                         ac_qtz(:, setup%nqz), checkpoint_variable_d%&
&                         ac_qtz(:, setup%nqz))
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+1) = h1_d
        checkpoint_variable%ac_rr_states(:, rr_states_inc+1) = h1
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+2) = h2_d
        checkpoint_variable%ac_rr_states(:, rr_states_inc+2) = h2
        checkpoint_variable_d%ac_rr_states(:, rr_states_inc+3)