# mypy_boto3

Mypy-friendly type annotations for `boto3 1.10.39`.
More information can be found [here](https://github.com/vemel/mypy_boto3).

- [mypy_boto3](#mypyboto3)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
    - [Code auto-complete](#code-auto-complete)
  - [How it works](#how-it-works)
  - [Submodules](#submodules)

## How to use

This package by itself is not very useful, it just gives you access to all
underlying `boto3` services type annotations.

It is the biggest package, so if you want to save 4 MB of space, install
service packages directly, e.g. `pip install mypy-boto3-s3 mypy-boto3-ec2`

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for services that you use to get type checking working.

```bash
# You can find a full list of modules below
python -m pip install boto3-stubs[s3,ec2]
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking.

```python
import boto3

from mypy_boto3 import s3
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_s3 as s3

# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("s3")
client: s3.EC2Client = boto3.client("s3")

# Oh, it must be `Bucket`... Thanks, mypy!
client.create_bucket(bucket="bucket")
```

### Code auto-complete

Not a single Python IDE supports `Literal` type overloads yet (but in `VSCode` support is just around the corner).
Meanwhile, to have a nice auto-complete you can explicitly set types to help your IDE to get methods, arguments etc.

```python
import boto3_name

from mypy_boto3 import ec2

# this is the only place where you have to set types explicitly
client: ec2.EC2Client = boto3.client("ec2")
resource: ec2.EC2ServiceResource = boto3.resource("ec2")

# now you have auto-complete for methods, arguments and even return types
```

### Build services index

This packages provides a CLI to build services index for `boto3-stubs`.

```bash
# Use this command when you add or remove service packages
python -m mypy_boto3
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- Latest version of `boto3` is used.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from latest documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Code is processed by [black](https://github.com/psf/black) for readability.

## Submodules

- `essential` - Type annotations for `cloudformation`, `dynamodb`, `ec2`, `lambda`, `rds`, `s3` and `sqs` services.
- `accessanalyzer` - Type annotations for `accessanalyzer` service.
- `acm` - Type annotations for `acm` service.
- `acm-pca` - Type annotations for `acm-pca` service.
- `alexaforbusiness` - Type annotations for `alexaforbusiness` service.
- `amplify` - Type annotations for `amplify` service.
- `apigateway` - Type annotations for `apigateway` service.
- `apigatewaymanagementapi` - Type annotations for `apigatewaymanagementapi` service.
- `apigatewayv2` - Type annotations for `apigatewayv2` service.
- `appconfig` - Type annotations for `appconfig` service.
- `application-autoscaling` - Type annotations for `application-autoscaling` service.
- `application-insights` - Type annotations for `application-insights` service.
- `appmesh` - Type annotations for `appmesh` service.
- `appstream` - Type annotations for `appstream` service.
- `appsync` - Type annotations for `appsync` service.
- `athena` - Type annotations for `athena` service.
- `autoscaling` - Type annotations for `autoscaling` service.
- `autoscaling-plans` - Type annotations for `autoscaling-plans` service.
- `backup` - Type annotations for `backup` service.
- `batch` - Type annotations for `batch` service.
- `budgets` - Type annotations for `budgets` service.
- `ce` - Type annotations for `ce` service.
- `chime` - Type annotations for `chime` service.
- `cloud9` - Type annotations for `cloud9` service.
- `clouddirectory` - Type annotations for `clouddirectory` service.
- `cloudformation` - Type annotations for `cloudformation` service.
- `cloudfront` - Type annotations for `cloudfront` service.
- `cloudhsm` - Type annotations for `cloudhsm` service.
- `cloudhsmv2` - Type annotations for `cloudhsmv2` service.
- `cloudsearch` - Type annotations for `cloudsearch` service.
- `cloudsearchdomain` - Type annotations for `cloudsearchdomain` service.
- `cloudtrail` - Type annotations for `cloudtrail` service.
- `cloudwatch` - Type annotations for `cloudwatch` service.
- `codebuild` - Type annotations for `codebuild` service.
- `codecommit` - Type annotations for `codecommit` service.
- `codedeploy` - Type annotations for `codedeploy` service.
- `codeguru-reviewer` - Type annotations for `codeguru-reviewer` service.
- `codeguruprofiler` - Type annotations for `codeguruprofiler` service.
- `codepipeline` - Type annotations for `codepipeline` service.
- `codestar` - Type annotations for `codestar` service.
- `codestar-notifications` - Type annotations for `codestar-notifications` service.
- `cognito-identity` - Type annotations for `cognito-identity` service.
- `cognito-idp` - Type annotations for `cognito-idp` service.
- `cognito-sync` - Type annotations for `cognito-sync` service.
- `comprehend` - Type annotations for `comprehend` service.
- `comprehendmedical` - Type annotations for `comprehendmedical` service.
- `compute-optimizer` - Type annotations for `compute-optimizer` service.
- `config` - Type annotations for `config` service.
- `connect` - Type annotations for `connect` service.
- `connectparticipant` - Type annotations for `connectparticipant` service.
- `cur` - Type annotations for `cur` service.
- `dataexchange` - Type annotations for `dataexchange` service.
- `datapipeline` - Type annotations for `datapipeline` service.
- `datasync` - Type annotations for `datasync` service.
- `dax` - Type annotations for `dax` service.
- `devicefarm` - Type annotations for `devicefarm` service.
- `directconnect` - Type annotations for `directconnect` service.
- `discovery` - Type annotations for `discovery` service.
- `dlm` - Type annotations for `dlm` service.
- `dms` - Type annotations for `dms` service.
- `docdb` - Type annotations for `docdb` service.
- `ds` - Type annotations for `ds` service.
- `dynamodb` - Type annotations for `dynamodb` service.
- `dynamodbstreams` - Type annotations for `dynamodbstreams` service.
- `ebs` - Type annotations for `ebs` service.
- `ec2` - Type annotations for `ec2` service.
- `ec2-instance-connect` - Type annotations for `ec2-instance-connect` service.
- `ecr` - Type annotations for `ecr` service.
- `ecs` - Type annotations for `ecs` service.
- `efs` - Type annotations for `efs` service.
- `eks` - Type annotations for `eks` service.
- `elastic-inference` - Type annotations for `elastic-inference` service.
- `elasticache` - Type annotations for `elasticache` service.
- `elasticbeanstalk` - Type annotations for `elasticbeanstalk` service.
- `elastictranscoder` - Type annotations for `elastictranscoder` service.
- `elb` - Type annotations for `elb` service.
- `elbv2` - Type annotations for `elbv2` service.
- `emr` - Type annotations for `emr` service.
- `es` - Type annotations for `es` service.
- `events` - Type annotations for `events` service.
- `firehose` - Type annotations for `firehose` service.
- `fms` - Type annotations for `fms` service.
- `forecast` - Type annotations for `forecast` service.
- `forecastquery` - Type annotations for `forecastquery` service.
- `frauddetector` - Type annotations for `frauddetector` service.
- `fsx` - Type annotations for `fsx` service.
- `gamelift` - Type annotations for `gamelift` service.
- `glacier` - Type annotations for `glacier` service.
- `globalaccelerator` - Type annotations for `globalaccelerator` service.
- `glue` - Type annotations for `glue` service.
- `greengrass` - Type annotations for `greengrass` service.
- `groundstation` - Type annotations for `groundstation` service.
- `guardduty` - Type annotations for `guardduty` service.
- `health` - Type annotations for `health` service.
- `iam` - Type annotations for `iam` service.
- `imagebuilder` - Type annotations for `imagebuilder` service.
- `importexport` - Type annotations for `importexport` service.
- `inspector` - Type annotations for `inspector` service.
- `iot` - Type annotations for `iot` service.
- `iot-data` - Type annotations for `iot-data` service.
- `iot-jobs-data` - Type annotations for `iot-jobs-data` service.
- `iot1click-devices` - Type annotations for `iot1click-devices` service.
- `iot1click-projects` - Type annotations for `iot1click-projects` service.
- `iotanalytics` - Type annotations for `iotanalytics` service.
- `iotevents` - Type annotations for `iotevents` service.
- `iotevents-data` - Type annotations for `iotevents-data` service.
- `iotsecuretunneling` - Type annotations for `iotsecuretunneling` service.
- `iotthingsgraph` - Type annotations for `iotthingsgraph` service.
- `kafka` - Type annotations for `kafka` service.
- `kendra` - Type annotations for `kendra` service.
- `kinesis` - Type annotations for `kinesis` service.
- `kinesis-video-archived-media` - Type annotations for `kinesis-video-archived-media` service.
- `kinesis-video-media` - Type annotations for `kinesis-video-media` service.
- `kinesis-video-signaling` - Type annotations for `kinesis-video-signaling` service.
- `kinesisanalytics` - Type annotations for `kinesisanalytics` service.
- `kinesisanalyticsv2` - Type annotations for `kinesisanalyticsv2` service.
- `kinesisvideo` - Type annotations for `kinesisvideo` service.
- `kms` - Type annotations for `kms` service.
- `lakeformation` - Type annotations for `lakeformation` service.
- `lambda` - Type annotations for `lambda` service.
- `lex-models` - Type annotations for `lex-models` service.
- `lex-runtime` - Type annotations for `lex-runtime` service.
- `license-manager` - Type annotations for `license-manager` service.
- `lightsail` - Type annotations for `lightsail` service.
- `logs` - Type annotations for `logs` service.
- `machinelearning` - Type annotations for `machinelearning` service.
- `macie` - Type annotations for `macie` service.
- `managedblockchain` - Type annotations for `managedblockchain` service.
- `marketplace-catalog` - Type annotations for `marketplace-catalog` service.
- `marketplace-entitlement` - Type annotations for `marketplace-entitlement` service.
- `marketplacecommerceanalytics` - Type annotations for `marketplacecommerceanalytics` service.
- `mediaconnect` - Type annotations for `mediaconnect` service.
- `mediaconvert` - Type annotations for `mediaconvert` service.
- `medialive` - Type annotations for `medialive` service.
- `mediapackage` - Type annotations for `mediapackage` service.
- `mediapackage-vod` - Type annotations for `mediapackage-vod` service.
- `mediastore` - Type annotations for `mediastore` service.
- `mediastore-data` - Type annotations for `mediastore-data` service.
- `mediatailor` - Type annotations for `mediatailor` service.
- `meteringmarketplace` - Type annotations for `meteringmarketplace` service.
- `mgh` - Type annotations for `mgh` service.
- `migrationhub-config` - Type annotations for `migrationhub-config` service.
- `mobile` - Type annotations for `mobile` service.
- `mq` - Type annotations for `mq` service.
- `mturk` - Type annotations for `mturk` service.
- `neptune` - Type annotations for `neptune` service.
- `networkmanager` - Type annotations for `networkmanager` service.
- `opsworks` - Type annotations for `opsworks` service.
- `opsworkscm` - Type annotations for `opsworkscm` service.
- `organizations` - Type annotations for `organizations` service.
- `outposts` - Type annotations for `outposts` service.
- `personalize` - Type annotations for `personalize` service.
- `personalize-events` - Type annotations for `personalize-events` service.
- `personalize-runtime` - Type annotations for `personalize-runtime` service.
- `pi` - Type annotations for `pi` service.
- `pinpoint` - Type annotations for `pinpoint` service.
- `pinpoint-email` - Type annotations for `pinpoint-email` service.
- `pinpoint-sms-voice` - Type annotations for `pinpoint-sms-voice` service.
- `polly` - Type annotations for `polly` service.
- `pricing` - Type annotations for `pricing` service.
- `qldb` - Type annotations for `qldb` service.
- `qldb-session` - Type annotations for `qldb-session` service.
- `quicksight` - Type annotations for `quicksight` service.
- `ram` - Type annotations for `ram` service.
- `rds` - Type annotations for `rds` service.
- `rds-data` - Type annotations for `rds-data` service.
- `redshift` - Type annotations for `redshift` service.
- `rekognition` - Type annotations for `rekognition` service.
- `resource-groups` - Type annotations for `resource-groups` service.
- `resourcegroupstaggingapi` - Type annotations for `resourcegroupstaggingapi` service.
- `robomaker` - Type annotations for `robomaker` service.
- `route53` - Type annotations for `route53` service.
- `route53domains` - Type annotations for `route53domains` service.
- `route53resolver` - Type annotations for `route53resolver` service.
- `s3` - Type annotations for `s3` service.
- `s3control` - Type annotations for `s3control` service.
- `sagemaker` - Type annotations for `sagemaker` service.
- `sagemaker-a2i-runtime` - Type annotations for `sagemaker-a2i-runtime` service.
- `sagemaker-runtime` - Type annotations for `sagemaker-runtime` service.
- `savingsplans` - Type annotations for `savingsplans` service.
- `schemas` - Type annotations for `schemas` service.
- `sdb` - Type annotations for `sdb` service.
- `secretsmanager` - Type annotations for `secretsmanager` service.
- `securityhub` - Type annotations for `securityhub` service.
- `serverlessrepo` - Type annotations for `serverlessrepo` service.
- `service-quotas` - Type annotations for `service-quotas` service.
- `servicecatalog` - Type annotations for `servicecatalog` service.
- `servicediscovery` - Type annotations for `servicediscovery` service.
- `ses` - Type annotations for `ses` service.
- `sesv2` - Type annotations for `sesv2` service.
- `shield` - Type annotations for `shield` service.
- `signer` - Type annotations for `signer` service.
- `sms` - Type annotations for `sms` service.
- `sms-voice` - Type annotations for `sms-voice` service.
- `snowball` - Type annotations for `snowball` service.
- `sns` - Type annotations for `sns` service.
- `sqs` - Type annotations for `sqs` service.
- `ssm` - Type annotations for `ssm` service.
- `sso` - Type annotations for `sso` service.
- `sso-oidc` - Type annotations for `sso-oidc` service.
- `stepfunctions` - Type annotations for `stepfunctions` service.
- `storagegateway` - Type annotations for `storagegateway` service.
- `sts` - Type annotations for `sts` service.
- `support` - Type annotations for `support` service.
- `swf` - Type annotations for `swf` service.
- `textract` - Type annotations for `textract` service.
- `transcribe` - Type annotations for `transcribe` service.
- `transfer` - Type annotations for `transfer` service.
- `translate` - Type annotations for `translate` service.
- `waf` - Type annotations for `waf` service.
- `waf-regional` - Type annotations for `waf-regional` service.
- `wafv2` - Type annotations for `wafv2` service.
- `workdocs` - Type annotations for `workdocs` service.
- `worklink` - Type annotations for `worklink` service.
- `workmail` - Type annotations for `workmail` service.
- `workmailmessageflow` - Type annotations for `workmailmessageflow` service.
- `workspaces` - Type annotations for `workspaces` service.
- `xray` - Type annotations for `xray` service.
