import importlib.util
from typing import List, Dict, Any

SUBMODULES: List[Dict[str, Any]] = [
    dict(
        module_name="mypy_boto3_accessanalyzer",
        import_name="accessanalyzer",
        boto3_name="accessanalyzer",
        class_name="AccessAnalyzer",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_acm",
        import_name="acm",
        boto3_name="acm",
        class_name="ACM",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_acm_pca",
        import_name="acm_pca",
        boto3_name="acm-pca",
        class_name="ACMPCA",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_alexaforbusiness",
        import_name="alexaforbusiness",
        boto3_name="alexaforbusiness",
        class_name="AlexaForBusiness",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_amplify",
        import_name="amplify",
        boto3_name="amplify",
        class_name="Amplify",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_apigateway",
        import_name="apigateway",
        boto3_name="apigateway",
        class_name="APIGateway",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_apigatewaymanagementapi",
        import_name="apigatewaymanagementapi",
        boto3_name="apigatewaymanagementapi",
        class_name="ApiGatewayManagementApi",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_apigatewayv2",
        import_name="apigatewayv2",
        boto3_name="apigatewayv2",
        class_name="ApiGatewayV2",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_appconfig",
        import_name="appconfig",
        boto3_name="appconfig",
        class_name="AppConfig",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_application_autoscaling",
        import_name="application_autoscaling",
        boto3_name="application-autoscaling",
        class_name="ApplicationAutoScaling",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_application_insights",
        import_name="application_insights",
        boto3_name="application-insights",
        class_name="ApplicationInsights",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_appmesh",
        import_name="appmesh",
        boto3_name="appmesh",
        class_name="AppMesh",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_appstream",
        import_name="appstream",
        boto3_name="appstream",
        class_name="AppStream",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_appsync",
        import_name="appsync",
        boto3_name="appsync",
        class_name="AppSync",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_athena",
        import_name="athena",
        boto3_name="athena",
        class_name="Athena",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_autoscaling",
        import_name="autoscaling",
        boto3_name="autoscaling",
        class_name="AutoScaling",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_autoscaling_plans",
        import_name="autoscaling_plans",
        boto3_name="autoscaling-plans",
        class_name="AutoScalingPlans",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_backup",
        import_name="backup",
        boto3_name="backup",
        class_name="Backup",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_batch",
        import_name="batch",
        boto3_name="batch",
        class_name="Batch",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_budgets",
        import_name="budgets",
        boto3_name="budgets",
        class_name="Budgets",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_ce",
        import_name="ce",
        boto3_name="ce",
        class_name="CostExplorer",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_chime",
        import_name="chime",
        boto3_name="chime",
        class_name="Chime",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_cloud9",
        import_name="cloud9",
        boto3_name="cloud9",
        class_name="Cloud9",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_clouddirectory",
        import_name="clouddirectory",
        boto3_name="clouddirectory",
        class_name="CloudDirectory",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_cloudformation",
        import_name="cloudformation",
        boto3_name="cloudformation",
        class_name="CloudFormation",
        has_resource=True,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_cloudfront",
        import_name="cloudfront",
        boto3_name="cloudfront",
        class_name="CloudFront",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_cloudhsm",
        import_name="cloudhsm",
        boto3_name="cloudhsm",
        class_name="CloudHSM",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_cloudhsmv2",
        import_name="cloudhsmv2",
        boto3_name="cloudhsmv2",
        class_name="CloudHSMV2",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_cloudsearch",
        import_name="cloudsearch",
        boto3_name="cloudsearch",
        class_name="CloudSearch",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_cloudsearchdomain",
        import_name="cloudsearchdomain",
        boto3_name="cloudsearchdomain",
        class_name="CloudSearchDomain",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_cloudtrail",
        import_name="cloudtrail",
        boto3_name="cloudtrail",
        class_name="CloudTrail",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_cloudwatch",
        import_name="cloudwatch",
        boto3_name="cloudwatch",
        class_name="CloudWatch",
        has_resource=True,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_codebuild",
        import_name="codebuild",
        boto3_name="codebuild",
        class_name="CodeBuild",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_codecommit",
        import_name="codecommit",
        boto3_name="codecommit",
        class_name="CodeCommit",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_codedeploy",
        import_name="codedeploy",
        boto3_name="codedeploy",
        class_name="CodeDeploy",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_codeguru_reviewer",
        import_name="codeguru_reviewer",
        boto3_name="codeguru-reviewer",
        class_name="CodeGuruReviewer",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_codeguruprofiler",
        import_name="codeguruprofiler",
        boto3_name="codeguruprofiler",
        class_name="CodeGuruProfiler",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_codepipeline",
        import_name="codepipeline",
        boto3_name="codepipeline",
        class_name="CodePipeline",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_codestar",
        import_name="codestar",
        boto3_name="codestar",
        class_name="CodeStar",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_codestar_notifications",
        import_name="codestar_notifications",
        boto3_name="codestar-notifications",
        class_name="CodeStarNotifications",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_cognito_identity",
        import_name="cognito_identity",
        boto3_name="cognito-identity",
        class_name="CognitoIdentity",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_cognito_idp",
        import_name="cognito_idp",
        boto3_name="cognito-idp",
        class_name="CognitoIdentityProvider",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_cognito_sync",
        import_name="cognito_sync",
        boto3_name="cognito-sync",
        class_name="CognitoSync",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_comprehend",
        import_name="comprehend",
        boto3_name="comprehend",
        class_name="Comprehend",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_comprehendmedical",
        import_name="comprehendmedical",
        boto3_name="comprehendmedical",
        class_name="ComprehendMedical",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_compute_optimizer",
        import_name="compute_optimizer",
        boto3_name="compute-optimizer",
        class_name="ComputeOptimizer",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_config",
        import_name="config",
        boto3_name="config",
        class_name="ConfigService",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_connect",
        import_name="connect",
        boto3_name="connect",
        class_name="Connect",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_connectparticipant",
        import_name="connectparticipant",
        boto3_name="connectparticipant",
        class_name="ConnectParticipant",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_cur",
        import_name="cur",
        boto3_name="cur",
        class_name="CostandUsageReportService",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_dataexchange",
        import_name="dataexchange",
        boto3_name="dataexchange",
        class_name="DataExchange",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_datapipeline",
        import_name="datapipeline",
        boto3_name="datapipeline",
        class_name="DataPipeline",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_datasync",
        import_name="datasync",
        boto3_name="datasync",
        class_name="DataSync",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_dax",
        import_name="dax",
        boto3_name="dax",
        class_name="DAX",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_devicefarm",
        import_name="devicefarm",
        boto3_name="devicefarm",
        class_name="DeviceFarm",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_directconnect",
        import_name="directconnect",
        boto3_name="directconnect",
        class_name="DirectConnect",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_discovery",
        import_name="discovery",
        boto3_name="discovery",
        class_name="ApplicationDiscoveryService",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_dlm",
        import_name="dlm",
        boto3_name="dlm",
        class_name="DLM",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_dms",
        import_name="dms",
        boto3_name="dms",
        class_name="DatabaseMigrationService",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_docdb",
        import_name="docdb",
        boto3_name="docdb",
        class_name="DocDB",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_ds",
        import_name="ds",
        boto3_name="ds",
        class_name="DirectoryService",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_dynamodb",
        import_name="dynamodb",
        boto3_name="dynamodb",
        class_name="DynamoDB",
        has_resource=True,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_dynamodbstreams",
        import_name="dynamodbstreams",
        boto3_name="dynamodbstreams",
        class_name="DynamoDBStreams",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_ebs",
        import_name="ebs",
        boto3_name="ebs",
        class_name="EBS",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_ec2",
        import_name="ec2",
        boto3_name="ec2",
        class_name="EC2",
        has_resource=True,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_ec2_instance_connect",
        import_name="ec2_instance_connect",
        boto3_name="ec2-instance-connect",
        class_name="EC2InstanceConnect",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_ecr",
        import_name="ecr",
        boto3_name="ecr",
        class_name="ECR",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_ecs",
        import_name="ecs",
        boto3_name="ecs",
        class_name="ECS",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_efs",
        import_name="efs",
        boto3_name="efs",
        class_name="EFS",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_eks",
        import_name="eks",
        boto3_name="eks",
        class_name="EKS",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_elastic_inference",
        import_name="elastic_inference",
        boto3_name="elastic-inference",
        class_name="ElasticInference",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_elasticache",
        import_name="elasticache",
        boto3_name="elasticache",
        class_name="ElastiCache",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_elasticbeanstalk",
        import_name="elasticbeanstalk",
        boto3_name="elasticbeanstalk",
        class_name="ElasticBeanstalk",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_elastictranscoder",
        import_name="elastictranscoder",
        boto3_name="elastictranscoder",
        class_name="ElasticTranscoder",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_elb",
        import_name="elb",
        boto3_name="elb",
        class_name="ElasticLoadBalancing",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_elbv2",
        import_name="elbv2",
        boto3_name="elbv2",
        class_name="ElasticLoadBalancingv2",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_emr",
        import_name="emr",
        boto3_name="emr",
        class_name="EMR",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_es",
        import_name="es",
        boto3_name="es",
        class_name="ElasticsearchService",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_events",
        import_name="events",
        boto3_name="events",
        class_name="EventBridge",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_firehose",
        import_name="firehose",
        boto3_name="firehose",
        class_name="Firehose",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_fms",
        import_name="fms",
        boto3_name="fms",
        class_name="FMS",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_forecast",
        import_name="forecast",
        boto3_name="forecast",
        class_name="ForecastService",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_forecastquery",
        import_name="forecastquery",
        boto3_name="forecastquery",
        class_name="ForecastQueryService",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_frauddetector",
        import_name="frauddetector",
        boto3_name="frauddetector",
        class_name="FraudDetector",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_fsx",
        import_name="fsx",
        boto3_name="fsx",
        class_name="FSx",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_gamelift",
        import_name="gamelift",
        boto3_name="gamelift",
        class_name="GameLift",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_glacier",
        import_name="glacier",
        boto3_name="glacier",
        class_name="Glacier",
        has_resource=True,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_globalaccelerator",
        import_name="globalaccelerator",
        boto3_name="globalaccelerator",
        class_name="GlobalAccelerator",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_glue",
        import_name="glue",
        boto3_name="glue",
        class_name="Glue",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_greengrass",
        import_name="greengrass",
        boto3_name="greengrass",
        class_name="Greengrass",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_groundstation",
        import_name="groundstation",
        boto3_name="groundstation",
        class_name="GroundStation",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_guardduty",
        import_name="guardduty",
        boto3_name="guardduty",
        class_name="GuardDuty",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_health",
        import_name="health",
        boto3_name="health",
        class_name="Health",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_iam",
        import_name="iam",
        boto3_name="iam",
        class_name="IAM",
        has_resource=True,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_imagebuilder",
        import_name="imagebuilder",
        boto3_name="imagebuilder",
        class_name="Imagebuilder",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_importexport",
        import_name="importexport",
        boto3_name="importexport",
        class_name="ImportExport",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_inspector",
        import_name="inspector",
        boto3_name="inspector",
        class_name="Inspector",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_iot",
        import_name="iot",
        boto3_name="iot",
        class_name="IoT",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_iot_data",
        import_name="iot_data",
        boto3_name="iot-data",
        class_name="IoTDataPlane",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_iot_jobs_data",
        import_name="iot_jobs_data",
        boto3_name="iot-jobs-data",
        class_name="IoTJobsDataPlane",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_iot1click_devices",
        import_name="iot1click_devices",
        boto3_name="iot1click-devices",
        class_name="IoT1ClickDevicesService",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_iot1click_projects",
        import_name="iot1click_projects",
        boto3_name="iot1click-projects",
        class_name="IoT1ClickProjects",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_iotanalytics",
        import_name="iotanalytics",
        boto3_name="iotanalytics",
        class_name="IoTAnalytics",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_iotevents",
        import_name="iotevents",
        boto3_name="iotevents",
        class_name="IoTEvents",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_iotevents_data",
        import_name="iotevents_data",
        boto3_name="iotevents-data",
        class_name="IoTEventsData",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_iotsecuretunneling",
        import_name="iotsecuretunneling",
        boto3_name="iotsecuretunneling",
        class_name="IoTSecureTunneling",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_iotthingsgraph",
        import_name="iotthingsgraph",
        boto3_name="iotthingsgraph",
        class_name="IoTThingsGraph",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_kafka",
        import_name="kafka",
        boto3_name="kafka",
        class_name="Kafka",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_kendra",
        import_name="kendra",
        boto3_name="kendra",
        class_name="Kendra",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_kinesis",
        import_name="kinesis",
        boto3_name="kinesis",
        class_name="Kinesis",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_kinesis_video_archived_media",
        import_name="kinesis_video_archived_media",
        boto3_name="kinesis-video-archived-media",
        class_name="KinesisVideoArchivedMedia",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_kinesis_video_media",
        import_name="kinesis_video_media",
        boto3_name="kinesis-video-media",
        class_name="KinesisVideoMedia",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_kinesis_video_signaling",
        import_name="kinesis_video_signaling",
        boto3_name="kinesis-video-signaling",
        class_name="KinesisVideoSignalingChannels",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_kinesisanalytics",
        import_name="kinesisanalytics",
        boto3_name="kinesisanalytics",
        class_name="KinesisAnalytics",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_kinesisanalyticsv2",
        import_name="kinesisanalyticsv2",
        boto3_name="kinesisanalyticsv2",
        class_name="KinesisAnalyticsV2",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_kinesisvideo",
        import_name="kinesisvideo",
        boto3_name="kinesisvideo",
        class_name="KinesisVideo",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_kms",
        import_name="kms",
        boto3_name="kms",
        class_name="KMS",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_lakeformation",
        import_name="lakeformation",
        boto3_name="lakeformation",
        class_name="LakeFormation",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_lambda",
        import_name="lambda_",
        boto3_name="lambda",
        class_name="Lambda",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_lex_models",
        import_name="lex_models",
        boto3_name="lex-models",
        class_name="LexModelBuildingService",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_lex_runtime",
        import_name="lex_runtime",
        boto3_name="lex-runtime",
        class_name="LexRuntimeService",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_license_manager",
        import_name="license_manager",
        boto3_name="license-manager",
        class_name="LicenseManager",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_lightsail",
        import_name="lightsail",
        boto3_name="lightsail",
        class_name="Lightsail",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_logs",
        import_name="logs",
        boto3_name="logs",
        class_name="CloudWatchLogs",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_machinelearning",
        import_name="machinelearning",
        boto3_name="machinelearning",
        class_name="MachineLearning",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_macie",
        import_name="macie",
        boto3_name="macie",
        class_name="Macie",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_managedblockchain",
        import_name="managedblockchain",
        boto3_name="managedblockchain",
        class_name="ManagedBlockchain",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_marketplace_catalog",
        import_name="marketplace_catalog",
        boto3_name="marketplace-catalog",
        class_name="MarketplaceCatalog",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_marketplace_entitlement",
        import_name="marketplace_entitlement",
        boto3_name="marketplace-entitlement",
        class_name="MarketplaceEntitlementService",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_marketplacecommerceanalytics",
        import_name="marketplacecommerceanalytics",
        boto3_name="marketplacecommerceanalytics",
        class_name="MarketplaceCommerceAnalytics",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_mediaconnect",
        import_name="mediaconnect",
        boto3_name="mediaconnect",
        class_name="MediaConnect",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_mediaconvert",
        import_name="mediaconvert",
        boto3_name="mediaconvert",
        class_name="MediaConvert",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_medialive",
        import_name="medialive",
        boto3_name="medialive",
        class_name="MediaLive",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_mediapackage",
        import_name="mediapackage",
        boto3_name="mediapackage",
        class_name="MediaPackage",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_mediapackage_vod",
        import_name="mediapackage_vod",
        boto3_name="mediapackage-vod",
        class_name="MediaPackageVod",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_mediastore",
        import_name="mediastore",
        boto3_name="mediastore",
        class_name="MediaStore",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_mediastore_data",
        import_name="mediastore_data",
        boto3_name="mediastore-data",
        class_name="MediaStoreData",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_mediatailor",
        import_name="mediatailor",
        boto3_name="mediatailor",
        class_name="MediaTailor",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_meteringmarketplace",
        import_name="meteringmarketplace",
        boto3_name="meteringmarketplace",
        class_name="MarketplaceMetering",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_mgh",
        import_name="mgh",
        boto3_name="mgh",
        class_name="MigrationHub",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_migrationhub_config",
        import_name="migrationhub_config",
        boto3_name="migrationhub-config",
        class_name="MigrationHubConfig",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_mobile",
        import_name="mobile",
        boto3_name="mobile",
        class_name="Mobile",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_mq",
        import_name="mq",
        boto3_name="mq",
        class_name="MQ",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_mturk",
        import_name="mturk",
        boto3_name="mturk",
        class_name="MTurk",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_neptune",
        import_name="neptune",
        boto3_name="neptune",
        class_name="Neptune",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_networkmanager",
        import_name="networkmanager",
        boto3_name="networkmanager",
        class_name="NetworkManager",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_opsworks",
        import_name="opsworks",
        boto3_name="opsworks",
        class_name="OpsWorks",
        has_resource=True,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_opsworkscm",
        import_name="opsworkscm",
        boto3_name="opsworkscm",
        class_name="OpsWorksCM",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_organizations",
        import_name="organizations",
        boto3_name="organizations",
        class_name="Organizations",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_outposts",
        import_name="outposts",
        boto3_name="outposts",
        class_name="Outposts",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_personalize",
        import_name="personalize",
        boto3_name="personalize",
        class_name="Personalize",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_personalize_events",
        import_name="personalize_events",
        boto3_name="personalize-events",
        class_name="PersonalizeEvents",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_personalize_runtime",
        import_name="personalize_runtime",
        boto3_name="personalize-runtime",
        class_name="PersonalizeRuntime",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_pi",
        import_name="pi",
        boto3_name="pi",
        class_name="PI",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_pinpoint",
        import_name="pinpoint",
        boto3_name="pinpoint",
        class_name="Pinpoint",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_pinpoint_email",
        import_name="pinpoint_email",
        boto3_name="pinpoint-email",
        class_name="PinpointEmail",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_pinpoint_sms_voice",
        import_name="pinpoint_sms_voice",
        boto3_name="pinpoint-sms-voice",
        class_name="PinpointSMSVoice",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_polly",
        import_name="polly",
        boto3_name="polly",
        class_name="Polly",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_pricing",
        import_name="pricing",
        boto3_name="pricing",
        class_name="Pricing",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_qldb",
        import_name="qldb",
        boto3_name="qldb",
        class_name="QLDB",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_qldb_session",
        import_name="qldb_session",
        boto3_name="qldb-session",
        class_name="QLDBSession",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_quicksight",
        import_name="quicksight",
        boto3_name="quicksight",
        class_name="QuickSight",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_ram",
        import_name="ram",
        boto3_name="ram",
        class_name="RAM",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_rds",
        import_name="rds",
        boto3_name="rds",
        class_name="RDS",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_rds_data",
        import_name="rds_data",
        boto3_name="rds-data",
        class_name="RDSDataService",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_redshift",
        import_name="redshift",
        boto3_name="redshift",
        class_name="Redshift",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_rekognition",
        import_name="rekognition",
        boto3_name="rekognition",
        class_name="Rekognition",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_resource_groups",
        import_name="resource_groups",
        boto3_name="resource-groups",
        class_name="ResourceGroups",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_resourcegroupstaggingapi",
        import_name="resourcegroupstaggingapi",
        boto3_name="resourcegroupstaggingapi",
        class_name="ResourceGroupsTaggingAPI",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_robomaker",
        import_name="robomaker",
        boto3_name="robomaker",
        class_name="RoboMaker",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_route53",
        import_name="route53",
        boto3_name="route53",
        class_name="Route53",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_route53domains",
        import_name="route53domains",
        boto3_name="route53domains",
        class_name="Route53Domains",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_route53resolver",
        import_name="route53resolver",
        boto3_name="route53resolver",
        class_name="Route53Resolver",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_s3",
        import_name="s3",
        boto3_name="s3",
        class_name="S3",
        has_resource=True,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_s3control",
        import_name="s3control",
        boto3_name="s3control",
        class_name="S3Control",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_sagemaker",
        import_name="sagemaker",
        boto3_name="sagemaker",
        class_name="SageMaker",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_sagemaker_a2i_runtime",
        import_name="sagemaker_a2i_runtime",
        boto3_name="sagemaker-a2i-runtime",
        class_name="AugmentedAIRuntime",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_sagemaker_runtime",
        import_name="sagemaker_runtime",
        boto3_name="sagemaker-runtime",
        class_name="SageMakerRuntime",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_savingsplans",
        import_name="savingsplans",
        boto3_name="savingsplans",
        class_name="SavingsPlans",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_schemas",
        import_name="schemas",
        boto3_name="schemas",
        class_name="Schemas",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_sdb",
        import_name="sdb",
        boto3_name="sdb",
        class_name="SimpleDB",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_secretsmanager",
        import_name="secretsmanager",
        boto3_name="secretsmanager",
        class_name="SecretsManager",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_securityhub",
        import_name="securityhub",
        boto3_name="securityhub",
        class_name="SecurityHub",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_serverlessrepo",
        import_name="serverlessrepo",
        boto3_name="serverlessrepo",
        class_name="ServerlessApplicationRepository",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_service_quotas",
        import_name="service_quotas",
        boto3_name="service-quotas",
        class_name="ServiceQuotas",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_servicecatalog",
        import_name="servicecatalog",
        boto3_name="servicecatalog",
        class_name="ServiceCatalog",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_servicediscovery",
        import_name="servicediscovery",
        boto3_name="servicediscovery",
        class_name="ServiceDiscovery",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_ses",
        import_name="ses",
        boto3_name="ses",
        class_name="SES",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_sesv2",
        import_name="sesv2",
        boto3_name="sesv2",
        class_name="SESV2",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_shield",
        import_name="shield",
        boto3_name="shield",
        class_name="Shield",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_signer",
        import_name="signer",
        boto3_name="signer",
        class_name="Signer",
        has_resource=False,
        has_waiter=True,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_sms",
        import_name="sms",
        boto3_name="sms",
        class_name="SMS",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_sms_voice",
        import_name="sms_voice",
        boto3_name="sms-voice",
        class_name="SMSVoice",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_snowball",
        import_name="snowball",
        boto3_name="snowball",
        class_name="Snowball",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_sns",
        import_name="sns",
        boto3_name="sns",
        class_name="SNS",
        has_resource=True,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_sqs",
        import_name="sqs",
        boto3_name="sqs",
        class_name="SQS",
        has_resource=True,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_ssm",
        import_name="ssm",
        boto3_name="ssm",
        class_name="SSM",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_sso",
        import_name="sso",
        boto3_name="sso",
        class_name="SSO",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_sso_oidc",
        import_name="sso_oidc",
        boto3_name="sso-oidc",
        class_name="SSOOIDC",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_stepfunctions",
        import_name="stepfunctions",
        boto3_name="stepfunctions",
        class_name="SFN",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_storagegateway",
        import_name="storagegateway",
        boto3_name="storagegateway",
        class_name="StorageGateway",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_sts",
        import_name="sts",
        boto3_name="sts",
        class_name="STS",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_support",
        import_name="support",
        boto3_name="support",
        class_name="Support",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_swf",
        import_name="swf",
        boto3_name="swf",
        class_name="SWF",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_textract",
        import_name="textract",
        boto3_name="textract",
        class_name="Textract",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_transcribe",
        import_name="transcribe",
        boto3_name="transcribe",
        class_name="TranscribeService",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_transfer",
        import_name="transfer",
        boto3_name="transfer",
        class_name="Transfer",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_translate",
        import_name="translate",
        boto3_name="translate",
        class_name="Translate",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_waf",
        import_name="waf",
        boto3_name="waf",
        class_name="WAF",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_waf_regional",
        import_name="waf_regional",
        boto3_name="waf-regional",
        class_name="WAFRegional",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_wafv2",
        import_name="wafv2",
        boto3_name="wafv2",
        class_name="WAFV2",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_workdocs",
        import_name="workdocs",
        boto3_name="workdocs",
        class_name="WorkDocs",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_worklink",
        import_name="worklink",
        boto3_name="worklink",
        class_name="WorkLink",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_workmail",
        import_name="workmail",
        boto3_name="workmail",
        class_name="WorkMail",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_workmailmessageflow",
        import_name="workmailmessageflow",
        boto3_name="workmailmessageflow",
        class_name="WorkMailMessageFlow",
        has_resource=False,
        has_waiter=False,
        has_paginator=False,
    ),
    dict(
        module_name="mypy_boto3_workspaces",
        import_name="workspaces",
        boto3_name="workspaces",
        class_name="WorkSpaces",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
    dict(
        module_name="mypy_boto3_xray",
        import_name="xray",
        boto3_name="xray",
        class_name="XRay",
        has_resource=False,
        has_waiter=False,
        has_paginator=True,
    ),
]

INSTALLED_SUBMODULES: List[Dict[str, Any]] = []
installed_submodule_names: List[str] = []
for submodule in SUBMODULES:
    if importlib.util.find_spec(submodule["module_name"]) is not None:
        INSTALLED_SUBMODULES.append(submodule)
        installed_submodule_names.append(submodule["boto3_name"])

CACHE_KEY = ",".join(installed_submodule_names)
