import os
from os.path import abspath, dirname

from setuptools import setup
from setuptools.command.install import install


LONG_DESCRIPTION = open(dirname(abspath(__file__)) + "/README.md", "r").read()


class PostInstallCommand(install):
    def run(self):
        install.run(self)
        cwd = os.getcwd()
        os.chdir(dirname(cwd))
        try:
            from mypy_boto3.main import maybe_build_index

            maybe_build_index()
            print("mypy_boto3: Package index updated")
        except:
            pass
        os.chdir(cwd)


setup(
    name="mypy-boto3",
    version="1.10.39.1",
    packages=["mypy_boto3",],
    url="https://github.com/vemel/mypy_boto3",
    license="MIT License",
    author="Vlad Emelianov",
    author_email="vlad.emelianov.nz@gmail.com",
    description="Mypy-friendly boto3 1.10.39 type annotations master module.",
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "Environment :: Console",
        "License :: OSI Approved :: MIT License",
        "Natural Language :: English",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: Implementation :: CPython",
        "Typing :: Typed",
    ],
    long_description=LONG_DESCRIPTION,
    long_description_content_type="text/markdown",
    install_requires=["boto3", "typing_extensions; python_version < '3.8'",],
    extras_require={
        "essential": [
            "mypy-boto3-cloudformation==1.10.39.1",
            "mypy-boto3-dynamodb==1.10.39.1",
            "mypy-boto3-ec2==1.10.39.1",
            "mypy-boto3-lambda==1.10.39.1",
            "mypy-boto3-rds==1.10.39.1",
            "mypy-boto3-s3==1.10.39.1",
            "mypy-boto3-sqs==1.10.39.1",
        ],
        "accessanalyzer": ["mypy-boto3-accessanalyzer==1.10.39.1"],
        "acm": ["mypy-boto3-acm==1.10.39.1"],
        "acm-pca": ["mypy-boto3-acm-pca==1.10.39.1"],
        "alexaforbusiness": ["mypy-boto3-alexaforbusiness==1.10.39.1"],
        "amplify": ["mypy-boto3-amplify==1.10.39.1"],
        "apigateway": ["mypy-boto3-apigateway==1.10.39.1"],
        "apigatewaymanagementapi": ["mypy-boto3-apigatewaymanagementapi==1.10.39.1"],
        "apigatewayv2": ["mypy-boto3-apigatewayv2==1.10.39.1"],
        "appconfig": ["mypy-boto3-appconfig==1.10.39.1"],
        "application-autoscaling": ["mypy-boto3-application-autoscaling==1.10.39.1"],
        "application-insights": ["mypy-boto3-application-insights==1.10.39.1"],
        "appmesh": ["mypy-boto3-appmesh==1.10.39.1"],
        "appstream": ["mypy-boto3-appstream==1.10.39.1"],
        "appsync": ["mypy-boto3-appsync==1.10.39.1"],
        "athena": ["mypy-boto3-athena==1.10.39.1"],
        "autoscaling": ["mypy-boto3-autoscaling==1.10.39.1"],
        "autoscaling-plans": ["mypy-boto3-autoscaling-plans==1.10.39.1"],
        "backup": ["mypy-boto3-backup==1.10.39.1"],
        "batch": ["mypy-boto3-batch==1.10.39.1"],
        "budgets": ["mypy-boto3-budgets==1.10.39.1"],
        "ce": ["mypy-boto3-ce==1.10.39.1"],
        "chime": ["mypy-boto3-chime==1.10.39.1"],
        "cloud9": ["mypy-boto3-cloud9==1.10.39.1"],
        "clouddirectory": ["mypy-boto3-clouddirectory==1.10.39.1"],
        "cloudformation": ["mypy-boto3-cloudformation==1.10.39.1"],
        "cloudfront": ["mypy-boto3-cloudfront==1.10.39.1"],
        "cloudhsm": ["mypy-boto3-cloudhsm==1.10.39.1"],
        "cloudhsmv2": ["mypy-boto3-cloudhsmv2==1.10.39.1"],
        "cloudsearch": ["mypy-boto3-cloudsearch==1.10.39.1"],
        "cloudsearchdomain": ["mypy-boto3-cloudsearchdomain==1.10.39.1"],
        "cloudtrail": ["mypy-boto3-cloudtrail==1.10.39.1"],
        "cloudwatch": ["mypy-boto3-cloudwatch==1.10.39.1"],
        "codebuild": ["mypy-boto3-codebuild==1.10.39.1"],
        "codecommit": ["mypy-boto3-codecommit==1.10.39.1"],
        "codedeploy": ["mypy-boto3-codedeploy==1.10.39.1"],
        "codeguru-reviewer": ["mypy-boto3-codeguru-reviewer==1.10.39.1"],
        "codeguruprofiler": ["mypy-boto3-codeguruprofiler==1.10.39.1"],
        "codepipeline": ["mypy-boto3-codepipeline==1.10.39.1"],
        "codestar": ["mypy-boto3-codestar==1.10.39.1"],
        "codestar-notifications": ["mypy-boto3-codestar-notifications==1.10.39.1"],
        "cognito-identity": ["mypy-boto3-cognito-identity==1.10.39.1"],
        "cognito-idp": ["mypy-boto3-cognito-idp==1.10.39.1"],
        "cognito-sync": ["mypy-boto3-cognito-sync==1.10.39.1"],
        "comprehend": ["mypy-boto3-comprehend==1.10.39.1"],
        "comprehendmedical": ["mypy-boto3-comprehendmedical==1.10.39.1"],
        "compute-optimizer": ["mypy-boto3-compute-optimizer==1.10.39.1"],
        "config": ["mypy-boto3-config==1.10.39.1"],
        "connect": ["mypy-boto3-connect==1.10.39.1"],
        "connectparticipant": ["mypy-boto3-connectparticipant==1.10.39.1"],
        "cur": ["mypy-boto3-cur==1.10.39.1"],
        "dataexchange": ["mypy-boto3-dataexchange==1.10.39.1"],
        "datapipeline": ["mypy-boto3-datapipeline==1.10.39.1"],
        "datasync": ["mypy-boto3-datasync==1.10.39.1"],
        "dax": ["mypy-boto3-dax==1.10.39.1"],
        "devicefarm": ["mypy-boto3-devicefarm==1.10.39.1"],
        "directconnect": ["mypy-boto3-directconnect==1.10.39.1"],
        "discovery": ["mypy-boto3-discovery==1.10.39.1"],
        "dlm": ["mypy-boto3-dlm==1.10.39.1"],
        "dms": ["mypy-boto3-dms==1.10.39.1"],
        "docdb": ["mypy-boto3-docdb==1.10.39.1"],
        "ds": ["mypy-boto3-ds==1.10.39.1"],
        "dynamodb": ["mypy-boto3-dynamodb==1.10.39.1"],
        "dynamodbstreams": ["mypy-boto3-dynamodbstreams==1.10.39.1"],
        "ebs": ["mypy-boto3-ebs==1.10.39.1"],
        "ec2": ["mypy-boto3-ec2==1.10.39.1"],
        "ec2-instance-connect": ["mypy-boto3-ec2-instance-connect==1.10.39.1"],
        "ecr": ["mypy-boto3-ecr==1.10.39.1"],
        "ecs": ["mypy-boto3-ecs==1.10.39.1"],
        "efs": ["mypy-boto3-efs==1.10.39.1"],
        "eks": ["mypy-boto3-eks==1.10.39.1"],
        "elastic-inference": ["mypy-boto3-elastic-inference==1.10.39.1"],
        "elasticache": ["mypy-boto3-elasticache==1.10.39.1"],
        "elasticbeanstalk": ["mypy-boto3-elasticbeanstalk==1.10.39.1"],
        "elastictranscoder": ["mypy-boto3-elastictranscoder==1.10.39.1"],
        "elb": ["mypy-boto3-elb==1.10.39.1"],
        "elbv2": ["mypy-boto3-elbv2==1.10.39.1"],
        "emr": ["mypy-boto3-emr==1.10.39.1"],
        "es": ["mypy-boto3-es==1.10.39.1"],
        "events": ["mypy-boto3-events==1.10.39.1"],
        "firehose": ["mypy-boto3-firehose==1.10.39.1"],
        "fms": ["mypy-boto3-fms==1.10.39.1"],
        "forecast": ["mypy-boto3-forecast==1.10.39.1"],
        "forecastquery": ["mypy-boto3-forecastquery==1.10.39.1"],
        "frauddetector": ["mypy-boto3-frauddetector==1.10.39.1"],
        "fsx": ["mypy-boto3-fsx==1.10.39.1"],
        "gamelift": ["mypy-boto3-gamelift==1.10.39.1"],
        "glacier": ["mypy-boto3-glacier==1.10.39.1"],
        "globalaccelerator": ["mypy-boto3-globalaccelerator==1.10.39.1"],
        "glue": ["mypy-boto3-glue==1.10.39.1"],
        "greengrass": ["mypy-boto3-greengrass==1.10.39.1"],
        "groundstation": ["mypy-boto3-groundstation==1.10.39.1"],
        "guardduty": ["mypy-boto3-guardduty==1.10.39.1"],
        "health": ["mypy-boto3-health==1.10.39.1"],
        "iam": ["mypy-boto3-iam==1.10.39.1"],
        "imagebuilder": ["mypy-boto3-imagebuilder==1.10.39.1"],
        "importexport": ["mypy-boto3-importexport==1.10.39.1"],
        "inspector": ["mypy-boto3-inspector==1.10.39.1"],
        "iot": ["mypy-boto3-iot==1.10.39.1"],
        "iot-data": ["mypy-boto3-iot-data==1.10.39.1"],
        "iot-jobs-data": ["mypy-boto3-iot-jobs-data==1.10.39.1"],
        "iot1click-devices": ["mypy-boto3-iot1click-devices==1.10.39.1"],
        "iot1click-projects": ["mypy-boto3-iot1click-projects==1.10.39.1"],
        "iotanalytics": ["mypy-boto3-iotanalytics==1.10.39.1"],
        "iotevents": ["mypy-boto3-iotevents==1.10.39.1"],
        "iotevents-data": ["mypy-boto3-iotevents-data==1.10.39.1"],
        "iotsecuretunneling": ["mypy-boto3-iotsecuretunneling==1.10.39.1"],
        "iotthingsgraph": ["mypy-boto3-iotthingsgraph==1.10.39.1"],
        "kafka": ["mypy-boto3-kafka==1.10.39.1"],
        "kendra": ["mypy-boto3-kendra==1.10.39.1"],
        "kinesis": ["mypy-boto3-kinesis==1.10.39.1"],
        "kinesis-video-archived-media": ["mypy-boto3-kinesis-video-archived-media==1.10.39.1"],
        "kinesis-video-media": ["mypy-boto3-kinesis-video-media==1.10.39.1"],
        "kinesis-video-signaling": ["mypy-boto3-kinesis-video-signaling==1.10.39.1"],
        "kinesisanalytics": ["mypy-boto3-kinesisanalytics==1.10.39.1"],
        "kinesisanalyticsv2": ["mypy-boto3-kinesisanalyticsv2==1.10.39.1"],
        "kinesisvideo": ["mypy-boto3-kinesisvideo==1.10.39.1"],
        "kms": ["mypy-boto3-kms==1.10.39.1"],
        "lakeformation": ["mypy-boto3-lakeformation==1.10.39.1"],
        "lambda": ["mypy-boto3-lambda==1.10.39.1"],
        "lex-models": ["mypy-boto3-lex-models==1.10.39.1"],
        "lex-runtime": ["mypy-boto3-lex-runtime==1.10.39.1"],
        "license-manager": ["mypy-boto3-license-manager==1.10.39.1"],
        "lightsail": ["mypy-boto3-lightsail==1.10.39.1"],
        "logs": ["mypy-boto3-logs==1.10.39.1"],
        "machinelearning": ["mypy-boto3-machinelearning==1.10.39.1"],
        "macie": ["mypy-boto3-macie==1.10.39.1"],
        "managedblockchain": ["mypy-boto3-managedblockchain==1.10.39.1"],
        "marketplace-catalog": ["mypy-boto3-marketplace-catalog==1.10.39.1"],
        "marketplace-entitlement": ["mypy-boto3-marketplace-entitlement==1.10.39.1"],
        "marketplacecommerceanalytics": ["mypy-boto3-marketplacecommerceanalytics==1.10.39.1"],
        "mediaconnect": ["mypy-boto3-mediaconnect==1.10.39.1"],
        "mediaconvert": ["mypy-boto3-mediaconvert==1.10.39.1"],
        "medialive": ["mypy-boto3-medialive==1.10.39.1"],
        "mediapackage": ["mypy-boto3-mediapackage==1.10.39.1"],
        "mediapackage-vod": ["mypy-boto3-mediapackage-vod==1.10.39.1"],
        "mediastore": ["mypy-boto3-mediastore==1.10.39.1"],
        "mediastore-data": ["mypy-boto3-mediastore-data==1.10.39.1"],
        "mediatailor": ["mypy-boto3-mediatailor==1.10.39.1"],
        "meteringmarketplace": ["mypy-boto3-meteringmarketplace==1.10.39.1"],
        "mgh": ["mypy-boto3-mgh==1.10.39.1"],
        "migrationhub-config": ["mypy-boto3-migrationhub-config==1.10.39.1"],
        "mobile": ["mypy-boto3-mobile==1.10.39.1"],
        "mq": ["mypy-boto3-mq==1.10.39.1"],
        "mturk": ["mypy-boto3-mturk==1.10.39.1"],
        "neptune": ["mypy-boto3-neptune==1.10.39.1"],
        "networkmanager": ["mypy-boto3-networkmanager==1.10.39.1"],
        "opsworks": ["mypy-boto3-opsworks==1.10.39.1"],
        "opsworkscm": ["mypy-boto3-opsworkscm==1.10.39.1"],
        "organizations": ["mypy-boto3-organizations==1.10.39.1"],
        "outposts": ["mypy-boto3-outposts==1.10.39.1"],
        "personalize": ["mypy-boto3-personalize==1.10.39.1"],
        "personalize-events": ["mypy-boto3-personalize-events==1.10.39.1"],
        "personalize-runtime": ["mypy-boto3-personalize-runtime==1.10.39.1"],
        "pi": ["mypy-boto3-pi==1.10.39.1"],
        "pinpoint": ["mypy-boto3-pinpoint==1.10.39.1"],
        "pinpoint-email": ["mypy-boto3-pinpoint-email==1.10.39.1"],
        "pinpoint-sms-voice": ["mypy-boto3-pinpoint-sms-voice==1.10.39.1"],
        "polly": ["mypy-boto3-polly==1.10.39.1"],
        "pricing": ["mypy-boto3-pricing==1.10.39.1"],
        "qldb": ["mypy-boto3-qldb==1.10.39.1"],
        "qldb-session": ["mypy-boto3-qldb-session==1.10.39.1"],
        "quicksight": ["mypy-boto3-quicksight==1.10.39.1"],
        "ram": ["mypy-boto3-ram==1.10.39.1"],
        "rds": ["mypy-boto3-rds==1.10.39.1"],
        "rds-data": ["mypy-boto3-rds-data==1.10.39.1"],
        "redshift": ["mypy-boto3-redshift==1.10.39.1"],
        "rekognition": ["mypy-boto3-rekognition==1.10.39.1"],
        "resource-groups": ["mypy-boto3-resource-groups==1.10.39.1"],
        "resourcegroupstaggingapi": ["mypy-boto3-resourcegroupstaggingapi==1.10.39.1"],
        "robomaker": ["mypy-boto3-robomaker==1.10.39.1"],
        "route53": ["mypy-boto3-route53==1.10.39.1"],
        "route53domains": ["mypy-boto3-route53domains==1.10.39.1"],
        "route53resolver": ["mypy-boto3-route53resolver==1.10.39.1"],
        "s3": ["mypy-boto3-s3==1.10.39.1"],
        "s3control": ["mypy-boto3-s3control==1.10.39.1"],
        "sagemaker": ["mypy-boto3-sagemaker==1.10.39.1"],
        "sagemaker-a2i-runtime": ["mypy-boto3-sagemaker-a2i-runtime==1.10.39.1"],
        "sagemaker-runtime": ["mypy-boto3-sagemaker-runtime==1.10.39.1"],
        "savingsplans": ["mypy-boto3-savingsplans==1.10.39.1"],
        "schemas": ["mypy-boto3-schemas==1.10.39.1"],
        "sdb": ["mypy-boto3-sdb==1.10.39.1"],
        "secretsmanager": ["mypy-boto3-secretsmanager==1.10.39.1"],
        "securityhub": ["mypy-boto3-securityhub==1.10.39.1"],
        "serverlessrepo": ["mypy-boto3-serverlessrepo==1.10.39.1"],
        "service-quotas": ["mypy-boto3-service-quotas==1.10.39.1"],
        "servicecatalog": ["mypy-boto3-servicecatalog==1.10.39.1"],
        "servicediscovery": ["mypy-boto3-servicediscovery==1.10.39.1"],
        "ses": ["mypy-boto3-ses==1.10.39.1"],
        "sesv2": ["mypy-boto3-sesv2==1.10.39.1"],
        "shield": ["mypy-boto3-shield==1.10.39.1"],
        "signer": ["mypy-boto3-signer==1.10.39.1"],
        "sms": ["mypy-boto3-sms==1.10.39.1"],
        "sms-voice": ["mypy-boto3-sms-voice==1.10.39.1"],
        "snowball": ["mypy-boto3-snowball==1.10.39.1"],
        "sns": ["mypy-boto3-sns==1.10.39.1"],
        "sqs": ["mypy-boto3-sqs==1.10.39.1"],
        "ssm": ["mypy-boto3-ssm==1.10.39.1"],
        "sso": ["mypy-boto3-sso==1.10.39.1"],
        "sso-oidc": ["mypy-boto3-sso-oidc==1.10.39.1"],
        "stepfunctions": ["mypy-boto3-stepfunctions==1.10.39.1"],
        "storagegateway": ["mypy-boto3-storagegateway==1.10.39.1"],
        "sts": ["mypy-boto3-sts==1.10.39.1"],
        "support": ["mypy-boto3-support==1.10.39.1"],
        "swf": ["mypy-boto3-swf==1.10.39.1"],
        "textract": ["mypy-boto3-textract==1.10.39.1"],
        "transcribe": ["mypy-boto3-transcribe==1.10.39.1"],
        "transfer": ["mypy-boto3-transfer==1.10.39.1"],
        "translate": ["mypy-boto3-translate==1.10.39.1"],
        "waf": ["mypy-boto3-waf==1.10.39.1"],
        "waf-regional": ["mypy-boto3-waf-regional==1.10.39.1"],
        "wafv2": ["mypy-boto3-wafv2==1.10.39.1"],
        "workdocs": ["mypy-boto3-workdocs==1.10.39.1"],
        "worklink": ["mypy-boto3-worklink==1.10.39.1"],
        "workmail": ["mypy-boto3-workmail==1.10.39.1"],
        "workmailmessageflow": ["mypy-boto3-workmailmessageflow==1.10.39.1"],
        "workspaces": ["mypy-boto3-workspaces==1.10.39.1"],
        "xray": ["mypy-boto3-xray==1.10.39.1"],
    },
    package_data={"mypy_boto3": ["py.typed"]},
    zip_safe=False,
    entry_points={"console_scripts": ["mypy_boto3 = mypy_boto3.main:main"]},
    cmdclass={"install": PostInstallCommand,},
)
