# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.account import Account
from .raw_client import AsyncRawAccountsClient, RawAccountsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AccountsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAccountsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAccountsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAccountsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        app_id: typing.Optional[str] = None,
        external_user_id: typing.Optional[str] = None,
        oauth_app_id: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        before: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        include_credentials: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Account]:
        """
        Parameters
        ----------
        app_id : typing.Optional[str]
            The app slug or ID to filter accounts by.

        external_user_id : typing.Optional[str]

        oauth_app_id : typing.Optional[str]
            The OAuth app ID to filter by, if applicable

        after : typing.Optional[str]
            The cursor to start from for pagination

        before : typing.Optional[str]
            The cursor to end before for pagination

        limit : typing.Optional[int]
            The maximum number of results to return

        include_credentials : typing.Optional[bool]
            Whether to retrieve the account's credentials or not

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Account]
            accounts listed

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        response = client.accounts.list()
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            app_id=app_id,
            external_user_id=external_user_id,
            oauth_app_id=oauth_app_id,
            after=after,
            before=before,
            limit=limit,
            include_credentials=include_credentials,
            request_options=request_options,
        )

    def create(
        self,
        *,
        app_slug: str,
        cfmap_json: str,
        connect_token: str,
        app_id: typing.Optional[str] = None,
        external_user_id: typing.Optional[str] = None,
        oauth_app_id: typing.Optional[str] = None,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Account:
        """
        Parameters
        ----------
        app_slug : str
            The app slug for the account

        cfmap_json : str
            JSON string containing the custom fields mapping

        connect_token : str
            The connect token for authentication

        app_id : typing.Optional[str]
            The app slug or ID to filter accounts by.

        external_user_id : typing.Optional[str]

        oauth_app_id : typing.Optional[str]
            The OAuth app ID to filter by, if applicable

        name : typing.Optional[str]
            Optional name for the account

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Account
            account created

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.accounts.create(
            app_slug="app_slug",
            cfmap_json="cfmap_json",
            connect_token="connect_token",
        )
        """
        _response = self._raw_client.create(
            app_slug=app_slug,
            cfmap_json=cfmap_json,
            connect_token=connect_token,
            app_id=app_id,
            external_user_id=external_user_id,
            oauth_app_id=oauth_app_id,
            name=name,
            request_options=request_options,
        )
        return _response.data

    def retrieve(
        self,
        account_id: str,
        *,
        include_credentials: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Account:
        """
        Parameters
        ----------
        account_id : str

        include_credentials : typing.Optional[bool]
            Whether to retrieve the account's credentials or not

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Account
            account retrieved

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.accounts.retrieve(
            account_id="account_id",
        )
        """
        _response = self._raw_client.retrieve(
            account_id, include_credentials=include_credentials, request_options=request_options
        )
        return _response.data

    def delete(self, account_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        account_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.accounts.delete(
            account_id="account_id",
        )
        """
        _response = self._raw_client.delete(account_id, request_options=request_options)
        return _response.data

    def delete_by_app(self, app_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        app_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.accounts.delete_by_app(
            app_id="app_id",
        )
        """
        _response = self._raw_client.delete_by_app(app_id, request_options=request_options)
        return _response.data


class AsyncAccountsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAccountsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAccountsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAccountsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        app_id: typing.Optional[str] = None,
        external_user_id: typing.Optional[str] = None,
        oauth_app_id: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        before: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        include_credentials: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Account]:
        """
        Parameters
        ----------
        app_id : typing.Optional[str]
            The app slug or ID to filter accounts by.

        external_user_id : typing.Optional[str]

        oauth_app_id : typing.Optional[str]
            The OAuth app ID to filter by, if applicable

        after : typing.Optional[str]
            The cursor to start from for pagination

        before : typing.Optional[str]
            The cursor to end before for pagination

        limit : typing.Optional[int]
            The maximum number of results to return

        include_credentials : typing.Optional[bool]
            Whether to retrieve the account's credentials or not

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Account]
            accounts listed

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            response = await client.accounts.list()
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            app_id=app_id,
            external_user_id=external_user_id,
            oauth_app_id=oauth_app_id,
            after=after,
            before=before,
            limit=limit,
            include_credentials=include_credentials,
            request_options=request_options,
        )

    async def create(
        self,
        *,
        app_slug: str,
        cfmap_json: str,
        connect_token: str,
        app_id: typing.Optional[str] = None,
        external_user_id: typing.Optional[str] = None,
        oauth_app_id: typing.Optional[str] = None,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Account:
        """
        Parameters
        ----------
        app_slug : str
            The app slug for the account

        cfmap_json : str
            JSON string containing the custom fields mapping

        connect_token : str
            The connect token for authentication

        app_id : typing.Optional[str]
            The app slug or ID to filter accounts by.

        external_user_id : typing.Optional[str]

        oauth_app_id : typing.Optional[str]
            The OAuth app ID to filter by, if applicable

        name : typing.Optional[str]
            Optional name for the account

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Account
            account created

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.accounts.create(
                app_slug="app_slug",
                cfmap_json="cfmap_json",
                connect_token="connect_token",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            app_slug=app_slug,
            cfmap_json=cfmap_json,
            connect_token=connect_token,
            app_id=app_id,
            external_user_id=external_user_id,
            oauth_app_id=oauth_app_id,
            name=name,
            request_options=request_options,
        )
        return _response.data

    async def retrieve(
        self,
        account_id: str,
        *,
        include_credentials: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Account:
        """
        Parameters
        ----------
        account_id : str

        include_credentials : typing.Optional[bool]
            Whether to retrieve the account's credentials or not

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Account
            account retrieved

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.accounts.retrieve(
                account_id="account_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(
            account_id, include_credentials=include_credentials, request_options=request_options
        )
        return _response.data

    async def delete(self, account_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        account_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.accounts.delete(
                account_id="account_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(account_id, request_options=request_options)
        return _response.data

    async def delete_by_app(self, app_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        app_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.accounts.delete_by_app(
                app_id="app_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_app(app_id, request_options=request_options)
        return _response.data
