# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pagination import AsyncPager, BaseHttpResponse, SyncPager
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..types.account import Account
from ..types.list_accounts_response import ListAccountsResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawAccountsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        app_id: typing.Optional[str] = None,
        external_user_id: typing.Optional[str] = None,
        oauth_app_id: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        before: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        include_credentials: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Account]:
        """
        Parameters
        ----------
        app_id : typing.Optional[str]
            The app slug or ID to filter accounts by.

        external_user_id : typing.Optional[str]

        oauth_app_id : typing.Optional[str]
            The OAuth app ID to filter by, if applicable

        after : typing.Optional[str]
            The cursor to start from for pagination

        before : typing.Optional[str]
            The cursor to end before for pagination

        limit : typing.Optional[int]
            The maximum number of results to return

        include_credentials : typing.Optional[bool]
            Whether to retrieve the account's credentials or not

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Account]
            accounts listed
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/accounts",
            method="GET",
            params={
                "app_id": app_id,
                "external_user_id": external_user_id,
                "oauth_app_id": oauth_app_id,
                "after": after,
                "before": before,
                "limit": limit,
                "include_credentials": include_credentials,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ListAccountsResponse,
                    parse_obj_as(
                        type_=ListAccountsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.data
                _has_next = False
                _get_next = None
                if _parsed_response.page_info is not None:
                    _parsed_next = _parsed_response.page_info.end_cursor
                    _has_next = _parsed_next is not None and _parsed_next != ""
                    _get_next = lambda: self.list(
                        app_id=app_id,
                        external_user_id=external_user_id,
                        oauth_app_id=oauth_app_id,
                        after=_parsed_next,
                        before=before,
                        limit=limit,
                        include_credentials=include_credentials,
                        request_options=request_options,
                    )
                return SyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        app_slug: str,
        cfmap_json: str,
        connect_token: str,
        app_id: typing.Optional[str] = None,
        external_user_id: typing.Optional[str] = None,
        oauth_app_id: typing.Optional[str] = None,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Account]:
        """
        Parameters
        ----------
        app_slug : str
            The app slug for the account

        cfmap_json : str
            JSON string containing the custom fields mapping

        connect_token : str
            The connect token for authentication

        app_id : typing.Optional[str]
            The app slug or ID to filter accounts by.

        external_user_id : typing.Optional[str]

        oauth_app_id : typing.Optional[str]
            The OAuth app ID to filter by, if applicable

        name : typing.Optional[str]
            Optional name for the account

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Account]
            account created
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/accounts",
            method="POST",
            params={
                "app_id": app_id,
                "external_user_id": external_user_id,
                "oauth_app_id": oauth_app_id,
            },
            json={
                "app_slug": app_slug,
                "cfmap_json": cfmap_json,
                "connect_token": connect_token,
                "name": name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Account,
                    parse_obj_as(
                        type_=Account,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def retrieve(
        self,
        account_id: str,
        *,
        include_credentials: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Account]:
        """
        Parameters
        ----------
        account_id : str

        include_credentials : typing.Optional[bool]
            Whether to retrieve the account's credentials or not

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Account]
            account retrieved
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/accounts/{jsonable_encoder(account_id)}",
            method="GET",
            params={
                "include_credentials": include_credentials,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Account,
                    parse_obj_as(
                        type_=Account,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(self, account_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[None]:
        """
        Parameters
        ----------
        account_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/accounts/{jsonable_encoder(account_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_by_app(
        self, app_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Parameters
        ----------
        app_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/apps/{jsonable_encoder(app_id)}/accounts",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawAccountsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        app_id: typing.Optional[str] = None,
        external_user_id: typing.Optional[str] = None,
        oauth_app_id: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        before: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        include_credentials: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Account]:
        """
        Parameters
        ----------
        app_id : typing.Optional[str]
            The app slug or ID to filter accounts by.

        external_user_id : typing.Optional[str]

        oauth_app_id : typing.Optional[str]
            The OAuth app ID to filter by, if applicable

        after : typing.Optional[str]
            The cursor to start from for pagination

        before : typing.Optional[str]
            The cursor to end before for pagination

        limit : typing.Optional[int]
            The maximum number of results to return

        include_credentials : typing.Optional[bool]
            Whether to retrieve the account's credentials or not

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Account]
            accounts listed
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/accounts",
            method="GET",
            params={
                "app_id": app_id,
                "external_user_id": external_user_id,
                "oauth_app_id": oauth_app_id,
                "after": after,
                "before": before,
                "limit": limit,
                "include_credentials": include_credentials,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ListAccountsResponse,
                    parse_obj_as(
                        type_=ListAccountsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.data
                _has_next = False
                _get_next = None
                if _parsed_response.page_info is not None:
                    _parsed_next = _parsed_response.page_info.end_cursor
                    _has_next = _parsed_next is not None and _parsed_next != ""

                    async def _get_next():
                        return await self.list(
                            app_id=app_id,
                            external_user_id=external_user_id,
                            oauth_app_id=oauth_app_id,
                            after=_parsed_next,
                            before=before,
                            limit=limit,
                            include_credentials=include_credentials,
                            request_options=request_options,
                        )

                return AsyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        app_slug: str,
        cfmap_json: str,
        connect_token: str,
        app_id: typing.Optional[str] = None,
        external_user_id: typing.Optional[str] = None,
        oauth_app_id: typing.Optional[str] = None,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Account]:
        """
        Parameters
        ----------
        app_slug : str
            The app slug for the account

        cfmap_json : str
            JSON string containing the custom fields mapping

        connect_token : str
            The connect token for authentication

        app_id : typing.Optional[str]
            The app slug or ID to filter accounts by.

        external_user_id : typing.Optional[str]

        oauth_app_id : typing.Optional[str]
            The OAuth app ID to filter by, if applicable

        name : typing.Optional[str]
            Optional name for the account

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Account]
            account created
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/accounts",
            method="POST",
            params={
                "app_id": app_id,
                "external_user_id": external_user_id,
                "oauth_app_id": oauth_app_id,
            },
            json={
                "app_slug": app_slug,
                "cfmap_json": cfmap_json,
                "connect_token": connect_token,
                "name": name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Account,
                    parse_obj_as(
                        type_=Account,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def retrieve(
        self,
        account_id: str,
        *,
        include_credentials: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Account]:
        """
        Parameters
        ----------
        account_id : str

        include_credentials : typing.Optional[bool]
            Whether to retrieve the account's credentials or not

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Account]
            account retrieved
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/accounts/{jsonable_encoder(account_id)}",
            method="GET",
            params={
                "include_credentials": include_credentials,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Account,
                    parse_obj_as(
                        type_=Account,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self, account_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        account_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/accounts/{jsonable_encoder(account_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_by_app(
        self, app_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        app_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/apps/{jsonable_encoder(app_id)}/accounts",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
