# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.get_app_category_response import GetAppCategoryResponse
from ..types.list_app_categories_response import ListAppCategoriesResponse
from .raw_client import AsyncRawAppCategoriesClient, RawAppCategoriesClient


class AppCategoriesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAppCategoriesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAppCategoriesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAppCategoriesClient
        """
        return self._raw_client

    def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> ListAppCategoriesResponse:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListAppCategoriesResponse
            apps listed

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.app_categories.list()
        """
        _response = self._raw_client.list(request_options=request_options)
        return _response.data

    def retrieve(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetAppCategoryResponse:
        """
        Parameters
        ----------
        id : str
            The ID of the app category to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetAppCategoryResponse
            app retrieved

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.app_categories.retrieve(
            id="id",
        )
        """
        _response = self._raw_client.retrieve(id, request_options=request_options)
        return _response.data


class AsyncAppCategoriesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAppCategoriesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAppCategoriesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAppCategoriesClient
        """
        return self._raw_client

    async def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> ListAppCategoriesResponse:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListAppCategoriesResponse
            apps listed

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.app_categories.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(request_options=request_options)
        return _response.data

    async def retrieve(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetAppCategoryResponse:
        """
        Parameters
        ----------
        id : str
            The ID of the app category to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetAppCategoryResponse
            app retrieved

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.app_categories.retrieve(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(id, request_options=request_options)
        return _response.data
